SUMMARY = "Cross locale generation tool for glibc"
HOMEPAGE = "http://www.gnu.org/software/libc/libc.html"
SECTION = "libs"
LICENSE = "LGPL-2.1"

LIC_FILES_CHKSUM = "file://LICENSES;md5=e9a558e243b36d3209f380deb394b213 \
      file://COPYING;md5=b234ee4d69f5fce4486a80fdaf4a4263 \
      file://posix/rxspencer/COPYRIGHT;md5=dc5485bb394a13b2332ec1c785f5d83a \
      file://COPYING.LIB;md5=4fbd65380cdd255951079008b364516c"


inherit native
inherit autotools

FILESEXTRAPATHS =. "${FILE_DIRNAME}/${PN}:${FILE_DIRNAME}/glibc:"

SRCBRANCH ?= "release/${PV}/master"
GLIBC_GIT_URI ?= "git://sourceware.org/git/glibc.git"

SRC_URI = "${GLIBC_GIT_URI};branch=${SRCBRANCH};name=glibc \
           git://github.com/kraj/localedef;branch=master;name=localedef;destsuffix=git/localedef \
           file://fix_for_centos_5.8.patch \
	   file://strcoll-Remove-incorrect-STRDIFF-based-optimization-.patch \
           ${EGLIBCPATCHES} \
"
EGLIBCPATCHES = "\
           file://0017-timezone-re-written-tzselect-as-posix-sh.patch \
           file://0018-eglibc-Cross-building-and-testing-instructions.patch \
           file://0019-eglibc-Bring-Eglibc-option-group-infrastructure-to-g.patch \
           file://0020-eglibc-Help-bootstrap-cross-toolchain.patch \
           file://0021-eglibc-cherry-picked-from-http-www.eglibc.org-archiv.patch \
           file://0022-eglibc-Clear-cache-lines-on-ppc8xx.patch \
           file://0023-eglibc-Resolve-__fpscr_values-on-SH4.patch \
           file://0024-eglibc-Forward-port-eglibc-options-groups-support.patch \
           file://0025-eglibc-Install-PIC-archives.patch \
           file://0026-eglibc-dl_debug_mask-is-controlled-by-__OPTION_EGLIB.patch \
           file://0027-eglibc-use-option-groups-Conditionally-exclude-c-tes.patch \
"

SRCREV_glibc ?= "a34d1c6afc86521d6ad17662a3b5362d8481514c"
SRCREV_localedef ?= "c833367348d39dad7ba018990bfdaffaec8e9ed3"

# Makes for a rather long rev (22 characters), but...
#
SRCREV_FORMAT = "glibc_localedef"

S = "${WORKDIR}/git"

EXTRA_OECONF = "--with-glibc=${S}"
CFLAGS += "-fgnu89-inline -std=gnu99 -DIS_IN\(x\)='0'"

do_configure () {
	${S}/localedef/configure ${EXTRA_OECONF}
}


do_install() {
	install -d ${D}${bindir}
	install -m 0755 ${B}/localedef ${D}${bindir}/cross-localedef
}
