/*====*====*====*====*====*====*====*====*====*====*====*====*====*====*====*
                              <resetlog.h>
DESCRIPTION

EXTERNALIZED FUNCTIONS

This software is contributed or developed by KYOCERA Corporation.
(C) 2015 KYOCERA Corporation
(C) 2016 KYOCERA Corporation
(C) 2018 KYOCERA Corporation

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License version 2 and
only version 2 as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301, USA.

*====*====*====*====*====*====*====*====*====*====*====*====*====*====*====*/
#ifndef _RESET_LOG_H
#define _RESET_LOG_H

#define HEADER_VERION           "v1.1.2"
#define HEADER_VERION_SIZE      (8)

#ifdef  __KERNEL__      /* linux kernel */
#include <linux/kc_phymap.h>
#define MSM_KCJLOG_BASE         (MSM_UNINIT_RAM_BASE)

#else /*__KERNEL__*/    /* boot system */
#include <stdint.h>
#ifdef  SCL_UNINIT_RAM_BASE
#define MSM_KCJLOG_BASE         (SCL_UNINIT_RAM_BASE)
#endif/*UNINIT_RAM_BASE*/
#endif/*__KERNEL__*/

#define MSM_KCJLOG_SIZE         (0x003F0000)

#ifdef  MSM_KCJLOG_BASE
#define SIZE_SMEM_ALLOC         (512)
#define SIZE_CONTROL_INFO       (512)
#define SIZE_KERNEL_LOG         (1 * 1024 * 1024)
#define SIZE_LOGCAT_MAIN        (1 * 1024 * 1024)
#define SIZE_LOGCAT_SYSTEM      (1 * 1024 * 1024)
#define SIZE_LOGCAT_EVENTS      (128 * 1024)
#define SIZE_LOGCAT_RADIO       (128 * 1024)
#define SIZE_USERLAND_LOG       (64)
#define SIZE_SMEM_EVENT_LOG     ( 50 * 1024)
#define SIZE_MODEM_F3_LOG       (512 * 1024)
#define SIZE_MODEM_ERR_DATA_LOG ( 16 * 1024)

#define ADDR_CONTROL_INFO       (MSM_KCJLOG_BASE)
#define ADDR_KERNEL_LOG         (ADDR_CONTROL_INFO       + SIZE_CONTROL_INFO      )
#define ADDR_LOGCAT_MAIN        (ADDR_KERNEL_LOG         + SIZE_KERNEL_LOG        )
#define ADDR_LOGCAT_SYSTEM      (ADDR_LOGCAT_MAIN        + SIZE_LOGCAT_MAIN       )
#define ADDR_LOGCAT_EVENTS      (ADDR_LOGCAT_SYSTEM      + SIZE_LOGCAT_SYSTEM     )
#define ADDR_LOGCAT_RADIO       (ADDR_LOGCAT_EVENTS      + SIZE_LOGCAT_EVENTS     )
#define ADDR_USERLAND_LOG       (ADDR_LOGCAT_RADIO       + SIZE_LOGCAT_RADIO      )
#define ADDR_SMEM_EVENT_LOG     (ADDR_USERLAND_LOG       + SIZE_USERLAND_LOG      )
#define ADDR_MODEM_F3_LOG       (ADDR_SMEM_EVENT_LOG     + SIZE_SMEM_EVENT_LOG    )
#define ADDR_MODEM_ERR_DATA_LOG (ADDR_MODEM_F3_LOG       + SIZE_MODEM_F3_LOG      )

#endif/*MSM_KCJLOG_BASE*/

enum {
    LOGGER_INFO_MAIN,
    LOGGER_INFO_SYSTEM,
    LOGGER_INFO_EVENTS,
    LOGGER_INFO_RADIO,
    LOGGER_INFO_MAX
};

#define CRASH_MAGIC_CODE         "KC ERROR"

#define CRASH_SYSTEM_UNKNOWN     "UNKNOWN"
#define CRASH_SYSTEM_KERNEL      "KERNEL"
#define CRASH_SYSTEM_MODEM       "MODEM"
#define CRASH_SYSTEM_ADSP        "ADSP"
#define CRASH_SYSTEM_USERLAND    "USERLAND"
#define CRASH_SYSTEM_BOOT        "BOOT"

#define CRASH_KIND_UNKNOWN       "UNKNOWN"
#define CRASH_KIND_PANIC         "KERNEL PANIC"
#define CRASH_KIND_FATAL         "ERR FATAL"
#define CRASH_KIND_EXCEPTION     "EXCEPTION"
#define CRASH_KIND_WDOG_HW       "HW WATCH DOG"
#define CRASH_KIND_WDOG_SW       "SW WATCH DOG"

/* RAM_CONSOLE Contol */
typedef struct {
    uint32_t                    sig;
    uint32_t                    start;
    uint32_t                    size;
} ram_console_header_type;

typedef struct {
    ram_console_header_type     header;
    unsigned char               msg[1];
} ram_console_type;

/* Log Control */
typedef struct {
    uint32_t                    w_off;
    uint32_t                    head;
} logger_log_info;

#define MAGIC_CODE_SIZE         (16)
#define CRASH_SYSTEM_SIZE       (16)
#define CRASH_KIND_SIZE         (32)
#define CRASH_TIME_SIZE         (48)

#define VERSION_SIZE            (64)
#define MODEL_SIZE              (32)
#define PET_TIME_SIZE           (36)

#define MINFO_SIZE              (13)

typedef struct {
    unsigned char   magic_code[MAGIC_CODE_SIZE];
    unsigned char   crash_system[CRASH_SYSTEM_SIZE];
    unsigned char   crash_kind[CRASH_KIND_SIZE];
    unsigned char   crash_time[CRASH_TIME_SIZE];
    unsigned char   linux_ver[VERSION_SIZE];
    unsigned char   modem_ver[VERSION_SIZE];
    unsigned char   model[MODEL_SIZE];
    logger_log_info info[LOGGER_INFO_MAX];
    uint32_t        regsave_addr;
    uint32_t        regsave_addr_check;
    uint32_t        m_info[MINFO_SIZE];
} ram_log_info_type;

#ifdef  __KERNEL__      /* linux kernel */
typedef struct {
    void __iomem    *addr_control_info;
    void __iomem    *addr_kcj_ram_console;
    void __iomem    *addr_kernel_log;
    void __iomem    *addr_logcat_main;
    void __iomem    *addr_logcat_system;
    void __iomem    *addr_logcat_events;
    void __iomem    *addr_logcat_radio;
    void __iomem    *addr_userland_log;
    void __iomem    *addr_modem_f3_log;
    void __iomem    *addr_modem_err_data_log;
    void __iomem    *addr_smem_event_log;
} addr_offset_type;
#endif/*__KERNEL__*/

#endif /* _RESET_LOG_H */

