ifndef QCONFIG
QCONFIG=qconfig.mk
endif
include $(QCONFIG)

DRIVER_NAME = intel-drm
NAME = drm-intel-gp12
DESC=Direct Rendering Manager (DRM) server
define PINFO
PINFO DESCRIPTION = "$(DESC)"
endef

CCFLAGS += -fno-strict-aliasing -Wc,-std=gnu99 -Wc,-march=nehalem -Wc,-msse4.1
CCFLAGS += -Wc,-Wno-unused-variable -Wc,-Wno-return-type -Wc,-Wno-pointer-sign -Wc,-Wno-unused-function
CCFLAGS += -Wc,-Wno-unused-but-set-variable -Wc,-fbuiltin
CCFLAGS += -DTHREAD_STACK_SIZE=524288 -DTHREAD_STACK_GUARD_SIZE=131072
CCFLAGS += -D__KERNEL__ -D__KERNEL411__ -DMODULE=1 -DKBUILD_MODNAME=\"i915\" -DCONFIG_PRINTK=1 -DCONFIG_BUG=1
CCFLAGS += -DCONFIG_X86=1 -DCONFIG_FLATMEM=1 -DCONFIG_GPIOLIB=1 -DCONFIG_ARCH_HAS_CACHE_LINE_SIZE=1
CCFLAGS += -DCONFIG_X86_INTERNODE_CACHE_SHIFT=6 -DCONFIG_X86_L1_CACHE_SHIFT=5 -DCONFIG_SMP=1
CCFLAGS += -DCONFIG_BASE_SMALL=0 -DCONFIG_TREE_RCU=1 -DHAVE_ARCH_STRUCT_FLOCK=1 -DHAVE_ARCH_STRUCT_FLOCK64=1
CCFLAGS += -DCONFIG_ARCH_ENABLE_SPLIT_PMD_PTLOCK=0 -DCONFIG_HAS_DMA=1 -DWANT_PAGE_VIRTUAL=1 -DCONFIG_MMU=1
CCFLAGS += -DCONFIG_PCI=1 -DCONFIG_PCI_MSI=1 -DHAVE_ARCH_DMA_SUPPORTED=1 -DCONFIG_X86_PAE=1
CCFLAGS += -DCONFIG_ARCH_DMA_ADDR_T_64BIT=1 -DCONFIG_PHYS_ADDR_T_64BIT=1 -DCONFIG_PCI_BUS_ADDR_T_64BIT=1
CCFLAGS += -DCONFIG_DRM_LOAD_EDID_FIRMWARE=1 -DCONFIG_BACKLIGHT_CLASS_DEVICE=1 -DCONFIG_DRM_DP_AUX_CHARDEV=1
CCFLAGS += -DCONFIG_DRM_VM=1 -DCONFIG_DRM_I915_CAPTURE_ERROR=1 -DCONFIG_CRC32_BIT=1 -DCONFIG_HZ=1000
CCFLAGS += -DCONFIG_SYSFS=1 -DCONFIG_PM=1 -DCONFIG_DEBUG_FS=1 -DHAVE_ARCH_DMA_SUPPORTED=1
CCFLAGS += -DCONFIG_GENERIC_IOMAP=1 -DCONFIG_NEED_SG_DMA_LENGTH=1 -DCONFIG_X86_PPRO_FENCE=1
CCFLAGS += -DCONFIG_SYSCTL=1 -DCONFIG_FASTBOOT_FW_LOAD=1

CCFLAGS_x86 += -DBITS_PER_LONG=32 -DBITS_PER_LONG_LONG=64 -DBYTES_PER_WORD=4 -DCONFIG_X86_32=1 -DCONFIG_X86_32_SMP=1
CCFLAGS_x86 += -DCONFIG_X86_CMPXCHG64=1 -DACPI_MACHINE_WIDTH=32
CCFLAGS_x86_64 += -DBITS_PER_LONG=64 -DBITS_PER_LONG_LONG=64 -DBYTES_PER_WORD=8 -DCONFIG_X86_64=1 -DCONFIG_64BIT=1
CCFLAGS_x86_64 += -DCONFIG_X86_64_SMP=1 -DACPI_MACHINE_WIDTH=64
CCFLAGS+= $(CCFLAGS_$(CPU))

CCFLAGS += -DCONFIG_INTEL_IOMMU=1

EXTRA_INCVPATH += $(PROJECT_ROOT)/elf
EXTRA_INCVPATH += $(PROJECT_ROOT)/include
EXTRA_INCVPATH += $(PROJECT_ROOT)/include/uapi
EXTRA_INCVPATH += $(PROJECT_ROOT)/include/x86
EXTRA_INCVPATH += $(PROJECT_ROOT)/include/x86/uapi
EXTRA_INCVPATH += $(PROJECT_ROOT)/include/drm
EXTRA_INCVPATH += $(PROJECT_ROOT)/i915
EXTRA_INCVPATH += $(PROJECT_ROOT)/qnx
EXTRA_INCVPATH += $(PROJECT_ROOT)/i915/gvt
EXTRA_INCVPATH += $(EXTRA_INCVPATH_$(CPU))

EXTRA_SRCVPATH += $(PROJECT_ROOT)/elf
EXTRA_SRCVPATH += $(PROJECT_ROOT)/qnx
EXTRA_SRCVPATH += $(PROJECT_ROOT)/i915
EXTRA_SRCVPATH += $(PROJECT_ROOT)/bridge
EXTRA_SRCVPATH += $(EXTRA_SRCVPATH_$(CPU))

## Framebuffer device
EXCLUDE_OBJS += drm_fb_helper.o drm_fb_cma_helper.o
## 32-bit compatibility ioctls
EXCLUDE_OBJS += drm_ioc32.o i915_ioc32.o
## CONFIG_OF
EXCLUDE_OBJS += drm_of.o
## CONFIG_MMU_NOTIFIER=1
EXCLUDE_OBJS += i915_gem_userptr.o
## CONFIG_DRM_FBDEV_EMULATION
EXCLUDE_OBJS += intel_fbdev.o
## CONFIG_ACPI
EXCLUDE_OBJS += intel_acpi.o intel_opregion.o
## CONFIG_AGP - Linux skips compilation of this file if CONFIG_AGP is not set.
EXCLUDE_OBJS += drm_agpsupport.o
## Do we need KVM support? It seems no.
EXCLUDE_OBJS += kvmgt.o
## Do we need XENGT support? It seems no.
EXCLUDE_OBJS += xengt.o

EXCLUDE_OBJS += $(EXCLUDE_OBJS_$(CPU))

include $(MKFILES_ROOT)/qmacros.mk

IS_DEBUG_BUILD:=$(filter g, $(VARIANT_LIST))
CCFLAGS += $(if $(IS_DEBUG_BUILD), -DCONFIG_DEBUG_SG=1)
CCFLAGS += $(if $(IS_DEBUG_BUILD), -DCONFIG_KALLSYMS=1)
CCFLAGS += $(if $(IS_DEBUG_BUILD), -DCONFIG_DRM_DEBUG_MM=1)
CCFLAGS += $(if $(IS_DEBUG_BUILD), -DCONFIG_REFCOUNT_FULL=1)

# Uncomment definition below to trace mutex and spinlocks creations
# CCFLAGS += $(if $(IS_DEBUG_BUILD), -DCONFIG_TRACE_QNX_MUTEX=1)
# Uncomment definition below to trace kmalloc memory allocations
# CCFLAGS += $(if $(IS_DEBUG_BUILD), -DCONFIG_TRACE_QNX_KMALLOC=1)

# It seems that these flags were untested by Intel, they raise a lot of errors just because
# some functionality has not been implemented yet
# CCFLAGS += $(if $(IS_DEBUG_BUILD), -DCONFIG_DRM_I915_DEBUG=1)
# CCFLAGS += $(if $(IS_DEBUG_BUILD), -DCONFIG_DRM_I915_DEBUG_GEM=1)

# Internal profiling library
# CCFLAGS += -g -Wc,-finstrument-functions
# LDFLAGS += -g -lcall-stats-complex

IS_GVT_BUILD := $(filter gvtg, $(VARIANT_LIST))
CCFLAGS += $(if $(IS_GVT_BUILD), -DCONFIG_DRM_I915_GVT=1)
LATE_SRCVPATH += $(if $(IS_GVT_BUILD), $(PROJECT_ROOT)/i915/gvt)
EXCLUDE_OBJS +=  $(if $(IS_GVT_BUILD), , intel_gvt.o)

LIBS += pci

DBG_LIBSUFFIX := $(if $(IS_DEBUG_BUILD),_g)
DBG_DIRSUFFIX := $(if $(IS_DEBUG_BUILD),-debug)

INSTALLDIR=sbin

EXTRA_CLEAN+=*.d
EXTRA_CLEAN+=*.i

USEFILE=drm.use
EXTRA_CLEAN += $(USEFILE)

include $(MKFILES_ROOT)/qtargets.mk
$(USEFILE): $(PROJECT_ROOT)/usemsg.sh
	DESC="$(DESC)" \
	DRIVER_NAME="$(DRIVER_NAME)" \
	$(SHELL) "$<" > "$@"

include $(MKFILES_ROOT)/qdepfile.mk  # defines "make depends"

-include $(PROJECT_ROOT)/local.mk  # optional (for debugging)
