function(FindMediaSDK)
  if(DEFINED ENV{MFX_HOME})
    message(STATUS "MediaSDK distribution found in $ENV{MFX_HOME}")
    set(MFX_HOME $ENV{MFX_HOME})
  elseif (EXISTS "${CMAKE_SYSROOT}/opt/intel/mediasdk")
    message(STATUS "MediaSDK distribution found in /opt/intel/mediasdk")
    set(MFX_HOME "${CMAKE_SYSROOT}/opt/intel/mediasdk")
  else()
    message(FATAL_ERROR "No MediaSDK distribution is found.")
  endif()
  set(MFX_INCLUDES "${MFX_HOME}/include")
  set(MFX_LIBRARY  "${MFX_HOME}/lib/lin_x64/libmfx.a")
  message(STATUS "MediaSDK include directory: ${MFX_INCLUDES}")
  message( STATUS "MediaSDK library directory: ${MFX_LIBRARY}")
  add_library(libmfx STATIC IMPORTED)
  set_property(TARGET libmfx PROPERTY IMPORTED_LOCATION ${MFX_LIBRARY})
  include_directories(${MFX_INCLUDES})
endfunction(FindMediaSDK)
