set(BASE_LIBRARIES "")
set(SINK_BACKEND "")
set(PARSER "")

if(UNIX)
  include(FindPkgConfig)
endif()

include(${CMAKE_SOURCE_DIR}/cmake/FindMediaSDK.cmake)
include(${CMAKE_SOURCE_DIR}/cmake/FindBaseDependencies.cmake)
include(${CMAKE_SOURCE_DIR}/cmake/FindSinkDependencies.cmake)
include(${CMAKE_SOURCE_DIR}/cmake/FindVC1ParserDependencies.cmake)

FindMediaSDK()
FindBaseLibs(BASE_LIBRARIES)

if(WITH_MSS_2016)
  add_definitions(-DWITH_MSS_2016)
endif()

if(MFX_DECODER)
  add_definitions(-DMFX_DECODER)
  if(USE_HEVC_DECODER)
    add_definitions(-DUSE_HEVC_DECODER)
  endif()
  if(USE_VP8_DECODER)
    add_definitions(-DUSE_VP8_DECODER)
  endif()
  if(USE_VP9_DECODER)
    add_definitions(-DUSE_VP9_DECODER)
  endif()
endif()

if(MFX_VPP)
  add_definitions(-DMFX_VPP)
endif()

if(MFX_SINK)
  add_definitions(-DMFX_SINK)
  if(WITH_WAYLAND)
    FindWayland(SINK_BACKEND)
    add_definitions(-DWITH_WAYLAND)
    if(USE_WAYLAND_RENDERER)
      add_definitions(-DUSE_WAYLAND)
    endif()
    if(USE_EGL_RENDERER)
      FindEGL(SINK_BACKEND)
      FindEGLWayland(SINK_BACKEND)
      add_definitions(-DUSE_EGL)
    endif()
  endif()
  
  if(WITH_X11)
    FindX11(SINK_BACKEND)
    add_definitions(-DWITH_X11)
    if(USE_DRI3_RENDERER)
      add_definitions(-DUSE_DRI3)
    endif()
    if(USE_EGL_RENDERER)
      FindEGL(SINK_BACKEND)
      add_definitions(-DUSE_EGL)
    endif()
  endif()
endif()

if(MFX_SINK_BIN)
  add_definitions(-DMFX_SINK_BIN)
endif()

if(MFX_H264_ENCODER)
  add_definitions(-DMFX_H264_ENCODER)
endif()

if(MFX_H265_ENCODER)
  add_definitions(-DMFX_H265_ENCODER)
endif()

if(MFX_MPEG2_ENCODER)
  add_definitions(-DMFX_MPEG2_ENCODER)
endif()

if(MFX_JPEG_ENCODER)
  add_definitions(-DMFX_JPEG_ENCODER)
endif()

if(MFX_JPEG_ENCODER)
  add_definitions(-DMFX_JPEG_ENCODER)
endif()

if(MFX_VC1_PARSER)
  FindVC1(PARSER)
  add_definitions(-DMFX_VC1_PARSER)
endif()
