/*
 * Copyright (c) 2017, DENSO Corporation
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 */
#include <linux/init.h>
#include <linux/module.h>
#include <linux/device.h>
#include <linux/kernel.h>
#include <linux/i2c.h>

static const struct i2c_board_info	dummy_devices[] = {
};

static const struct i2c_board_info sc16is752_devices[] = {
        {
                I2C_BOARD_INFO("sc16is752", 0x90 >> 1),
                //.platform_data = &sc16_data, /*Need to add specific data if required.*/
                .irq = 83
        }
};

static const struct i2c_buses {
	int			busnum;
	const struct i2c_board_info	*info;
	int			len;
}	i2c_devices[] = {
	{
		.busnum = 0,
		.info = sc16is752_devices,
		.len = ARRAY_SIZE(sc16is752_devices),
	},
	{
		.busnum = 1,
		.info = dummy_devices,
		.len = ARRAY_SIZE(dummy_devices),
	},
	{
		.busnum = 2,
		.info = dummy_devices,
		.len = ARRAY_SIZE(dummy_devices),
	},
	{
		.busnum = 3,
		.info = dummy_devices,
		.len = ARRAY_SIZE(dummy_devices),
	},
	{},
};

static int __init subaru_board_init(void)
{
	int	ret;
	const struct i2c_buses	*bus;

	for (bus = i2c_devices; bus->info; bus++) {
		int	i;
		ret = i2c_register_board_info(
				bus->busnum,
				bus->info,
				bus->len);
		printk(KERN_INFO "%s bus%d (", __func__, bus->busnum);
		for (i = 0; i < bus->len; i++) {
			printk(KERN_CONT "%s(0x%02x) ",
					bus->info->type,
					bus->info->addr << 1);
		}
		printk(KERN_CONT ") ret=%d\n", ret);
		if (ret) return ret;
	}
	return 0;
}

arch_initcall(subaru_board_init);
MODULE_LICENSE("GPL v2");
