/*
 * i915_preinit.c
 *
 * Copyright 2017 DENSO Corporation.
 * All Right Reserved.
 *
 * initialize before smp activation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL TUNGSTEN GRAPHICS AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#include <linux/device.h>
#include <drm/i915_drm.h>
#include <linux/module.h>

static DECLARE_BITMAP(cpu_notdrm_bits, CONFIG_NR_CPUS) __read_mostly;
static DECLARE_BITMAP(cpu_drm_bits, CONFIG_NR_CPUS) __read_mostly;

const struct cpumask *const cpu_notdrm_mask = to_cpumask(cpu_notdrm_bits);
const struct cpumask *const cpu_drm_mask = to_cpumask(cpu_drm_bits);
unsigned int	i915_drm_cpu = INT_MAX;

EXPORT_SYMBOL(cpu_notdrm_mask);
EXPORT_SYMBOL(cpu_drm_mask);
EXPORT_SYMBOL(i915_drm_cpu);

static void __init i915_cpumask_init(unsigned int drmcpu)
{
	struct cpumask	*notdrm_mask = to_cpumask(cpu_notdrm_bits);
	struct cpumask	*drm_mask = to_cpumask(cpu_drm_bits);

	if (i915_drm_cpu < CONFIG_NR_CPUS) {
		return;	/* already set drmcpu */
	}

	cpumask_setall(notdrm_mask);
	cpumask_clear(drm_mask);
	if (drmcpu) {
		cpumask_clear_cpu(drmcpu, notdrm_mask);
		cpumask_set_cpu(drmcpu, drm_mask);
	}
	if (cpumask_empty(drm_mask)) {
		cpumask_setall(drm_mask);
		if (drmcpu) {
			printk(KERN_ERR "%s invalid drm_cpu=%d\n",
					__func__, drmcpu);
		}
		i915_drm_cpu = 0;
	} else {
		printk(KERN_INFO "%s drm_cpu=%d\n",
				__func__, drmcpu);
		i915_drm_cpu = drmcpu;
	}
}

static int __init drm_cpu(char *str)
{
	int	drmcpu;

	if (get_option(&str, &drmcpu)) {
		i915_cpumask_init(drmcpu);
		return 0;
	}
	return -EINVAL;
}
early_param("drm_cpu", drm_cpu);

static int __init i915_preinit(void)
{
	i915_cpumask_init(CONFIG_I915_DRM_CPU);
	return 0;
}
module_init(i915_preinit);


MODULE_AUTHOR("DENSO Corporation");

MODULE_DESCRIPTION(DRIVER_DESC);
MODULE_LICENSE("GPL and additional rights");
