/*
 * Copyright (c) 2014--2016 Intel Corporation.
 *
 * Author: Vinod Govindapillai <vinod.govindapillai@intel.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef __CRLMODULE_imx214_CONFIGURATION_H_
#define __CRLMODULE_imx214_CONFIGURATION_H_

#include "crlmodule-sensor-ds.h"

static struct crl_register_write_rep imx214_pll_1080mbps[] = {
	{ 0x0301, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x0303, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x0305, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x0306, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0307, CRL_REG_LEN_08BIT, 0x87 },
	{ 0x0309, CRL_REG_LEN_08BIT, 0x0a },
	{ 0x030B, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0310, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0820, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0821, CRL_REG_LEN_08BIT, 0xe0 },
	{ 0x0822, CRL_REG_LEN_08BIT, 0x66 },
	{ 0x0823, CRL_REG_LEN_08BIT, 0x66 },
	{ 0x3A03, CRL_REG_LEN_08BIT, 0x09 },
	{ 0x3A04, CRL_REG_LEN_08BIT, 0x40 },
	{ 0x3A05, CRL_REG_LEN_08BIT, 0x01 },
};

static struct crl_register_write_rep imx214_pll_8_1080mbps[] = {
	{ 0x0301, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x0303, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x0305, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x0306, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0307, CRL_REG_LEN_08BIT, 0x87 },
	{ 0x030B, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0309, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x0310, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0820, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0821, CRL_REG_LEN_08BIT, 0xe0 },
	{ 0x0822, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0823, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A03, CRL_REG_LEN_08BIT, 0x09 },
	{ 0x3A04, CRL_REG_LEN_08BIT, 0x40 },
	{ 0x3A05, CRL_REG_LEN_08BIT, 0x01 },
};

static struct crl_register_write_rep imx214_pll_1200mbps[] = {
	{ 0x0301, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x0303, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x0305, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x0306, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0307, CRL_REG_LEN_08BIT, 0x96 },
	{ 0x0309, CRL_REG_LEN_08BIT, 0x0a },
	{ 0x030B, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0310, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0820, CRL_REG_LEN_08BIT, 0x12},
	{ 0x0821, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0x0822, CRL_REG_LEN_08BIT, 0x66 },
	{ 0x0823, CRL_REG_LEN_08BIT, 0x66 },
	{ 0x3A03, CRL_REG_LEN_08BIT, 0x09 },
	{ 0x3A04, CRL_REG_LEN_08BIT, 0x40 },
	{ 0x3A05, CRL_REG_LEN_08BIT, 0x01 },
};

static struct crl_register_write_rep imx214_pll_8_1200mbps[] = {
	{ 0x0301, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x0303, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x0305, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x0306, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0307, CRL_REG_LEN_08BIT, 0x96 },
	{ 0x030B, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0309, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x0310, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0820, CRL_REG_LEN_08BIT, 0x12},
	{ 0x0821, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0x0822, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0823, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A03, CRL_REG_LEN_08BIT, 0x09 },
	{ 0x3A04, CRL_REG_LEN_08BIT, 0x40 },
	{ 0x3A05, CRL_REG_LEN_08BIT, 0x01 },
};

static struct crl_register_write_rep imx214_powerup_regset[] = {
	{ 0x0103, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0100, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0136, CRL_REG_LEN_08BIT, 0x18 }, /*24Mhz*/
	{ 0x0137, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0350, CRL_REG_LEN_08BIT, 0x00 }, /* Enable/disable Long exposure*/
	{ 0x0101, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0105, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0138, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0106, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x4550, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x4601, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4642, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x6227, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x6276, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x900E, CRL_REG_LEN_08BIT, 0x06 },
	{ 0xA802, CRL_REG_LEN_08BIT, 0x90 },
	{ 0xA803, CRL_REG_LEN_08BIT, 0x11 },
	{ 0xA804, CRL_REG_LEN_08BIT, 0x62 },
	{ 0xA805, CRL_REG_LEN_08BIT, 0x77 },
	{ 0xA806, CRL_REG_LEN_08BIT, 0xAE },
	{ 0xA807, CRL_REG_LEN_08BIT, 0x34 },
	{ 0xA808, CRL_REG_LEN_08BIT, 0xAE },
	{ 0xA809, CRL_REG_LEN_08BIT, 0x35 },
	{ 0xA80A, CRL_REG_LEN_08BIT, 0x62 },
	{ 0xA80B, CRL_REG_LEN_08BIT, 0x83 },
	{ 0xAE33, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4174, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4175, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x4612, CRL_REG_LEN_08BIT, 0x29 },
	{ 0x461B, CRL_REG_LEN_08BIT, 0x12 },
	{ 0x461F, CRL_REG_LEN_08BIT, 0x06 },
	{ 0x4635, CRL_REG_LEN_08BIT, 0x07 },
	{ 0x4637, CRL_REG_LEN_08BIT, 0x30 },
	{ 0x463F, CRL_REG_LEN_08BIT, 0x18 },
	{ 0x4641, CRL_REG_LEN_08BIT, 0x0D },
	{ 0x465B, CRL_REG_LEN_08BIT, 0x12 },
	{ 0x465F, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x4663, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x4667, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x466F, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x470E, CRL_REG_LEN_08BIT, 0x09 },
	{ 0x4909, CRL_REG_LEN_08BIT, 0xAB },
	{ 0x490B, CRL_REG_LEN_08BIT, 0x95 },
	{ 0x4915, CRL_REG_LEN_08BIT, 0x5D },
	{ 0x4A5F, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x4A61, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x4A73, CRL_REG_LEN_08BIT, 0x62 },
	{ 0x4A85, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4A87, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x583C, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x620E, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x6EB2, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x6EB3, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x9300, CRL_REG_LEN_08BIT, 0x02 },
};

/*
 * 0, 4207, 0, 3119
 * 4208, 3120
 * 4208x3120
 */
static struct crl_register_write_rep imx214_mode_13m[] = {
	{ 0x0114, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x0220, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0221, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0222, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0x6F },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0C },
	{ 0x034B, CRL_REG_LEN_08BIT, 0x2F },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3000, CRL_REG_LEN_08BIT, 0x35 },
	{ 0x3054, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x034D, CRL_REG_LEN_08BIT, 0x70 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x0C },
	{ 0x034F, CRL_REG_LEN_08BIT, 0x30 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x040D, CRL_REG_LEN_08BIT, 0x70 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x0C },
	{ 0x040F, CRL_REG_LEN_08BIT, 0x30 },
	{ 0x3A03, CRL_REG_LEN_08BIT, 0x09 },
	{ 0x3A04, CRL_REG_LEN_08BIT, 0x40 },
	{ 0x3A05, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0B06, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x30A2, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x30B4, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A02, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x3011, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3013, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0202, CRL_REG_LEN_08BIT, 0x0D },
	{ 0x0203, CRL_REG_LEN_08BIT, 0xDE },
	{ 0x0224, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0225, CRL_REG_LEN_08BIT, 0xF4 },
	{ 0x020E, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x020F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0210, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0211, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0212, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0213, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0214, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0215, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0216, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0217, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4170, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4171, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x4176, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4177, CRL_REG_LEN_08BIT, 0x3C },
	{ 0xAE20, CRL_REG_LEN_08BIT, 0x04 },
	{ 0xAE21, CRL_REG_LEN_08BIT, 0x5C },
	{ 0x0138, CRL_REG_LEN_08BIT, 0x01 },
};

static struct crl_register_write_rep imx214_mode_2k[] = {
	{ 0x0114, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x0220, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0221, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0222, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0x6F },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0C },
	{ 0x034B, CRL_REG_LEN_08BIT, 0x2F },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x22 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x3000, CRL_REG_LEN_08BIT, 0x35 },
	{ 0x3054, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x034D, CRL_REG_LEN_08BIT, 0x38 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x06 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0x18 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x040D, CRL_REG_LEN_08BIT, 0x38 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x06 },
	{ 0x040F, CRL_REG_LEN_08BIT, 0x18 },
	{ 0x0B06, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x30A2, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x30B4, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A02, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x3011, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3013, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0202, CRL_REG_LEN_08BIT, 0x06 },
	{ 0x0203, CRL_REG_LEN_08BIT, 0xAE },
	{ 0x0224, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0225, CRL_REG_LEN_08BIT, 0xF4 },
	{ 0x020E, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x020F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0210, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0211, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0212, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0213, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0214, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0215, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0216, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0217, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4170, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4171, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x4176, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4177, CRL_REG_LEN_08BIT, 0x3C },
	{ 0xAE20, CRL_REG_LEN_08BIT, 0x04 },
	{ 0xAE21, CRL_REG_LEN_08BIT, 0x5C },
	{ 0x0138, CRL_REG_LEN_08BIT, 0x01 },
};

static struct crl_register_write_rep imx214_mode_4k2k[] = {
	{ 0x0114, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x0220, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0221, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0222, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0x78 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0x6F },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0A },
	{ 0x034B, CRL_REG_LEN_08BIT, 0xB8 },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3000, CRL_REG_LEN_08BIT, 0x35 },
	{ 0x3054, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x034D, CRL_REG_LEN_08BIT, 0x70 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x09 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0x40 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x040D, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x040F, CRL_REG_LEN_08BIT, 0x70 },
	{ 0x3A03, CRL_REG_LEN_08BIT, 0x09 },
	{ 0x3A04, CRL_REG_LEN_08BIT, 0x40 },
	{ 0x3A05, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0B06, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x30A2, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x30B4, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A02, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x3011, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3013, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0202, CRL_REG_LEN_08BIT, 0x0D },
	{ 0x0203, CRL_REG_LEN_08BIT, 0xE8 },
	{ 0x0224, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0225, CRL_REG_LEN_08BIT, 0xF4 },
	{ 0x020E, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x020F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0210, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0211, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0212, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0213, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0214, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0215, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0216, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0217, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4170, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4171, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x4176, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4177, CRL_REG_LEN_08BIT, 0x3C },
	{ 0xAE20, CRL_REG_LEN_08BIT, 0x04 },
	{ 0xAE21, CRL_REG_LEN_08BIT, 0x5C },
	{ 0x0138, CRL_REG_LEN_08BIT, 0x01 },
};

static struct crl_register_write_rep imx214_mode_1120[] = {
	{ 0x0114, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x0220, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0221, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0222, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x38 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0xB8 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0x6F },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0A },
	{ 0x034B, CRL_REG_LEN_08BIT, 0xB8 },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x22 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x3000, CRL_REG_LEN_08BIT, 0x35 },
	{ 0x3054, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x034D, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0x60 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x040D, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x040F, CRL_REG_LEN_08BIT, 0x60 },
	{ 0x3A03, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x3A04, CRL_REG_LEN_08BIT, 0x68 },
	{ 0x3A05, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0B06, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x30A2, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x30B4, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A02, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x3011, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3013, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0224, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0225, CRL_REG_LEN_08BIT, 0xF4 },
	{ 0x020E, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x020F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0210, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0211, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0212, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0213, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0214, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0215, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0216, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0217, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4170, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4171, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x4176, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4177, CRL_REG_LEN_08BIT, 0x3C },
	{ 0xAE20, CRL_REG_LEN_08BIT, 0x04 },
	{ 0xAE21, CRL_REG_LEN_08BIT, 0x5C },
	{ 0x0138, CRL_REG_LEN_08BIT, 0x01 },
};

static struct crl_register_write_rep imx214_mode_1080[] = {
	{ 0x0114, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x0220, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0221, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0222, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0x78 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0x6F },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0A },
	{ 0x034B, CRL_REG_LEN_08BIT, 0xB8 },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x22 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x3000, CRL_REG_LEN_08BIT, 0x35 },
	{ 0x3054, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x07 },
	{ 0x034D, CRL_REG_LEN_08BIT, 0x80 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0x38 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x07 },
	{ 0x040D, CRL_REG_LEN_08BIT, 0x80 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x040F, CRL_REG_LEN_08BIT, 0x38 },
	{ 0x3A03, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x3A04, CRL_REG_LEN_08BIT, 0x68 },
	{ 0x3A05, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0B06, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x30A2, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x30B4, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A02, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x3011, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3013, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0224, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0225, CRL_REG_LEN_08BIT, 0xF4 },
	{ 0x020E, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x020F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0210, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0211, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0212, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0213, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0214, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0215, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0216, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0217, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4170, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4171, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x4176, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4177, CRL_REG_LEN_08BIT, 0x3C },
	{ 0xAE20, CRL_REG_LEN_08BIT, 0x04 },
	{ 0xAE21, CRL_REG_LEN_08BIT, 0x5C },
	{ 0x0138, CRL_REG_LEN_08BIT, 0x01 },
};

static struct crl_register_write_rep imx214_mode_720[] = {
	{ 0x0114, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x0220, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0221, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0222, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0344, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x78 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0x8E },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x0A },
	{ 0x0349, CRL_REG_LEN_08BIT, 0xF7 },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x07 },
	{ 0x034B, CRL_REG_LEN_08BIT, 0xA1 },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3000, CRL_REG_LEN_08BIT, 0x35 },
	{ 0x3054, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x034D, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0xD0 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x040D, CRL_REG_LEN_08BIT, 0x80 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x040F, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A03, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x3A04, CRL_REG_LEN_08BIT, 0xF8 },
	{ 0x3A05, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0B06, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x30A2, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x30B4, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A02, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x3011, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3013, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0224, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0225, CRL_REG_LEN_08BIT, 0xF4 },
	{ 0x020E, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x020F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0210, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0211, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0212, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0213, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0214, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0215, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0216, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0217, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4170, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4171, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x4176, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4177, CRL_REG_LEN_08BIT, 0x3C },
	{ 0xAE20, CRL_REG_LEN_08BIT, 0x04 },
	{ 0xAE21, CRL_REG_LEN_08BIT, 0x5C },
	{ 0x0138, CRL_REG_LEN_08BIT, 0x01 },
};

static struct crl_register_write_rep imx214_streamon_regs[] = {
	{ 0x0100, CRL_REG_LEN_08BIT, 0x01 }
};

static struct crl_register_write_rep imx214_streamoff_regs[] = {
	{ 0x0100, CRL_REG_LEN_08BIT, 0x00 }
};

static struct crl_register_write_rep imx214_data_fmt_width10[] = {
	{ 0x0112, CRL_REG_LEN_16BIT, 0x0a0a }
};

static struct crl_register_write_rep imx214_data_fmt_width8[] = {
	{ 0x0112, CRL_REG_LEN_16BIT, 0x0808 }
};

static struct crl_arithmetic_ops imx214_vflip_ops[] = {
	{
		.op = CRL_BITWISE_LSHIFT,
		.operand.entity_val = 1,
	},
};

static struct crl_dynamic_register_access imx214_h_flip_regs[] = {
	{
		.address = 0x0101,
		.len = CRL_REG_LEN_08BIT | CRL_REG_READ_AND_UPDATE,
		.ops_items = 0,
		.ops = 0,
		.mask = 0x1,
	},
};

static struct crl_dynamic_register_access imx214_v_flip_regs[] = {
	{
		.address = 0x0101,
		.len = CRL_REG_LEN_08BIT | CRL_REG_READ_AND_UPDATE,
		.ops_items = ARRAY_SIZE(imx214_vflip_ops),
		.ops = imx214_vflip_ops,
		.mask = 0x2,
	},
};

struct crl_register_write_rep imx214_poweroff_regset[] = {
	{ 0x0103, CRL_REG_LEN_08BIT, 0x01 },
};


static struct crl_dynamic_register_access imx214_ana_gain_global_regs[] = {
	{
		.address = 0x0204,
		.len = CRL_REG_LEN_16BIT,
		.ops_items = 0,
		.ops = 0,
		.mask = 0xffff,
	},
};

static struct crl_dynamic_register_access imx214_exposure_regs[] = {
	{
		.address = 0x0202,
		.len = CRL_REG_LEN_16BIT,
		.ops_items = 0,
		.ops = 0,
		.mask = 0xffff,
	}
};

static struct crl_dynamic_register_access imx214_vblank_regs[] = {
	{
		.address = 0x0340,
		.len = CRL_REG_LEN_16BIT,
		.ops_items = 0,
		.ops = 0,
		.mask = 0xffff,
	},
};

static struct crl_dynamic_register_access imx214_hblank_regs[] = {
	{
		.address = 0x0342,
		.len = CRL_REG_LEN_16BIT,
		.ops_items = 0,
		.ops = 0,
		.mask = 0xffff,
	},
};

static struct crl_dynamic_register_access imx214_test_pattern_regs[] = {
	{
		.address = 0x0600,
		.len = CRL_REG_LEN_16BIT,
		.ops_items = 0,
		.ops = 0,
		.mask = 0xffff
	},
};

static struct crl_sensor_detect_config imx214_sensor_detect_regset[] = {
	{
		.reg = { 0x0019, CRL_REG_LEN_08BIT, 0x000000ff },
		.width = 5,
	},
	{
		.reg = { 0x0016, CRL_REG_LEN_16BIT, 0x0000ffff },
		.width = 7,
	},
};

const s64 imx214_op_sys_clock[] =  { 504000000, 504000000, 600000000,
					600000000};

static struct crl_pll_configuration imx214_pll_configurations[] = {
	{
		.input_clk = 24000000,
		.op_sys_clk = 504000000,
		.bitsperpixel = 8,
		.pixel_rate_csi = 432000000,
		.pixel_rate_pa = 432000000,
		.comp_items = 0,
		.ctrl_data = 0,
		.csi_lanes = 4,
		.pll_regs_items = ARRAY_SIZE(imx214_pll_8_1080mbps),
		.pll_regs = imx214_pll_8_1080mbps,
	},
	{
		.input_clk = 24000000,
		.op_sys_clk = 504000000,
		.bitsperpixel = 10,
		.pixel_rate_csi = 432000000,
		.pixel_rate_pa = 432000000,
		.csi_lanes = 4,
		.comp_items = 0,
		.ctrl_data = 0,
		.pll_regs_items = ARRAY_SIZE(imx214_pll_1080mbps),
		.pll_regs = imx214_pll_1080mbps,
	},
	{
		.input_clk = 24000000,
		.op_sys_clk = 600000000,
		.bitsperpixel = 8,
		.pixel_rate_csi = 480000000,
		.pixel_rate_pa = 480000000,
		.csi_lanes = 4,
		.comp_items = 0,
		.ctrl_data = 0,
		.pll_regs_items = ARRAY_SIZE(imx214_pll_8_1200mbps),
		.pll_regs = imx214_pll_8_1200mbps,
	},
	{
		.input_clk = 24000000,
		.op_sys_clk = 600000000,
		.bitsperpixel = 10,
		.pixel_rate_csi = 480000000,
		.pixel_rate_pa = 480000000,
		.csi_lanes = 4,
		.comp_items = 0,
		.ctrl_data = 0,
		.pll_regs_items = ARRAY_SIZE(imx214_pll_1200mbps),
		.pll_regs = imx214_pll_1200mbps,
	},

};

/*
 * 0,5343,448,3567
 * 5344, 3120
 * Dig Crop: (568,0)->4208x3120
 * Scale_m 16
 * 4208x3120
 */

static struct crl_subdev_rect_rep imx214_13m_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 4208,
		.in_rect.height = 3120,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 4208,
		.out_rect.height = 3120,
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 4208,
		.in_rect.height = 3120,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 4208,
		.out_rect.height = 3120,
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 4208,
		.in_rect.height = 3120,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 4208,
		.out_rect.height = 3120,
	},
};

static struct crl_subdev_rect_rep imx214_4k2k_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 4208,
		.in_rect.height = 3120,
		.out_rect.left = 0,
		.out_rect.top = 376,
		.out_rect.width = 4208,
		.out_rect.height = 2368,
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 4208,
		.in_rect.height = 2368,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 4208,
		.out_rect.height = 2368,
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 4208,
		.in_rect.height = 2368,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 4208,
		.out_rect.height = 2368,
	},
};

static struct crl_subdev_rect_rep imx214_2k_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 4208,
		.in_rect.height = 3120,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 4208,
		.out_rect.height = 3120,
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 4208,
		.in_rect.height = 3120,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 2104,
		.out_rect.height = 1560,
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 2104,
		.in_rect.height = 1560,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 2104,
		.out_rect.height = 1560,
	},
};

static struct crl_subdev_rect_rep imx214_1120_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 4208,
		.in_rect.height = 3120,
		.out_rect.left = 56,
		.out_rect.top = 440,
		.out_rect.width = 4096,
		.out_rect.height = 2240,
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 4096,
		.in_rect.height = 2240,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 2048,
		.out_rect.height = 1120,
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 2048,
		.in_rect.height = 1120,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 2048,
		.out_rect.height = 1120,
	},
};

static struct crl_subdev_rect_rep imx214_1080_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 4208,
		.in_rect.height = 3120,
		.out_rect.left = 0,
		.out_rect.top = 376,
		.out_rect.width = 4208,
		.out_rect.height = 2368,
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 4208,
		.in_rect.height = 2368,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 2104,
		.out_rect.height = 1184,
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 2104,
		.in_rect.height = 1184,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 1920,
		.out_rect.height = 1080,
	},
};

static struct crl_subdev_rect_rep imx214_720_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 4208,
		.in_rect.height = 3120,
		.out_rect.left = 1400,
		.out_rect.top = 1166,
		.out_rect.width = 1408,
		.out_rect.height = 788,
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 1408,
		.in_rect.height = 788,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 1408,
		.out_rect.height = 788,
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 1408,
		.in_rect.height = 788,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 1280,
		.out_rect.height = 720,
	},
};

static struct crl_mode_rep imx214_modes[] = {
	{
		.sd_rects_items = ARRAY_SIZE(imx214_13m_rects),
		.sd_rects = imx214_13m_rects,
		.binn_hor = 1,
		.binn_vert = 1,
		.scale_m = 1,
		.width = 4208,
		.height = 3120,
		.min_llp = 5008,
		.min_fll = 3180,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx214_mode_13m),
		.mode_regs = imx214_mode_13m,
	},
		{
		.sd_rects_items = ARRAY_SIZE(imx214_4k2k_rects),
		.sd_rects = imx214_4k2k_rects,
		.binn_hor = 1,
		.binn_vert = 1,
		.scale_m = 1,
		.width = 4208,
		.height = 2368,
		.min_llp = 5008,
		.min_fll = 2408,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx214_mode_4k2k),
		.mode_regs = imx214_mode_4k2k,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx214_2k_rects),
		.sd_rects = imx214_2k_rects,
		.binn_hor = 2,
		.binn_vert = 2,
		.scale_m = 1,
		.width = 2104,
		.height = 1560,
		.min_llp = 5008,
		.min_fll = 1700,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx214_mode_2k),
		.mode_regs = imx214_mode_2k,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx214_1120_rects),
		.sd_rects = imx214_1120_rects,
		.binn_hor = 2,
		.binn_vert = 2,
		.scale_m = 1,
		.width = 2048,
		.height = 1120,
		.min_llp = 5008,
		.min_fll = 1600,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx214_mode_1120),
		.mode_regs = imx214_mode_1120,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx214_1080_rects),
		.sd_rects = imx214_1080_rects,
		.binn_hor = 2,
		.binn_vert = 2,
		.scale_m = 1,
		.width = 1920,
		.height = 1080,
		.min_llp = 5008,
		.min_fll = 1200,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx214_mode_1080),
		.mode_regs = imx214_mode_1080,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx214_720_rects),
		.sd_rects = imx214_720_rects,
		.binn_hor = 1,
		.binn_vert = 1,
		.scale_m = 1,
		.width = 1280,
		.height = 720,
		.min_llp = 5008,
		.min_fll = 828,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx214_mode_720),
		.mode_regs = imx214_mode_720,
	},
};

static struct crl_sensor_subdev_config imx214_sensor_subdevs[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.name = "imx214 scaler",
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.name = "imx214 binner",
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.name = "imx214 pixel array",
	},
};

static struct crl_sensor_limits imx214_sensor_limits = {
	.x_addr_min = 0,
	.y_addr_min = 0,
	.x_addr_max = 4208,
	.y_addr_max = 3120,
	.min_frame_length_lines = 184,
	.max_frame_length_lines = 65535,
	.min_line_length_pixels = 5008,
	.max_line_length_pixels = 32752,
	.scaler_m_min = 16,
	.scaler_m_max = 255,
	.scaler_n_min = 16,
	.scaler_n_max = 16,
	.min_even_inc = 1,
	.max_even_inc = 1,
	.min_odd_inc = 1,
	.max_odd_inc = 3,
};

static struct crl_flip_data imx214_flip_configurations[] = {
	{
		.flip = CRL_FLIP_DEFAULT_NONE,
		.pixel_order = CRL_PIXEL_ORDER_RGGB,
	},
	{
		.flip = CRL_FLIP_HFLIP,
		.pixel_order = CRL_PIXEL_ORDER_GRBG,
	},
	{
		.flip = CRL_FLIP_VFLIP,
		.pixel_order = CRL_PIXEL_ORDER_GBRG,
	},
	{
		.flip = CRL_FLIP_HFLIP_VFLIP,
		.pixel_order = CRL_PIXEL_ORDER_BGGR,
	},
};

static struct crl_csi_data_fmt imx214_crl_csi_data_fmt[] = {
	{
		.code = MEDIA_BUS_FMT_SGRBG10_1X10,
		.pixel_order = CRL_PIXEL_ORDER_GRBG,
		.bits_per_pixel = 10,
		.regs_items = ARRAY_SIZE(imx214_data_fmt_width10),
		.regs = imx214_data_fmt_width10,
	},
	{
		.code = MEDIA_BUS_FMT_SRGGB10_1X10,
		.pixel_order = CRL_PIXEL_ORDER_RGGB,
		.regs_items = ARRAY_SIZE(imx214_data_fmt_width10),
		.bits_per_pixel = 10,
		.regs = imx214_data_fmt_width10,
	},
	{
		.code = MEDIA_BUS_FMT_SBGGR10_1X10,
		.pixel_order = CRL_PIXEL_ORDER_BGGR,
		.regs_items = ARRAY_SIZE(imx214_data_fmt_width10),
		.bits_per_pixel = 10,
		.regs = imx214_data_fmt_width10,
	},
	{
		.code = MEDIA_BUS_FMT_SGBRG10_1X10,
		.pixel_order = CRL_PIXEL_ORDER_GBRG,
		.regs_items = ARRAY_SIZE(imx214_data_fmt_width10),
		.bits_per_pixel = 10,
		.regs = imx214_data_fmt_width10,
	},
	{
		.code = MEDIA_BUS_FMT_SGRBG8_1X8,
		.pixel_order = CRL_PIXEL_ORDER_GRBG,
		.regs_items = ARRAY_SIZE(imx214_data_fmt_width8),
		.bits_per_pixel = 8,
		.regs = imx214_data_fmt_width8,
	},
	{
		.code = MEDIA_BUS_FMT_SRGGB8_1X8,
		.pixel_order = CRL_PIXEL_ORDER_RGGB,
		.regs_items = ARRAY_SIZE(imx214_data_fmt_width8),
		.bits_per_pixel = 8,
		.regs = imx214_data_fmt_width8,
	},
	{
		.code = MEDIA_BUS_FMT_SBGGR8_1X8,
		.pixel_order = CRL_PIXEL_ORDER_BGGR,
		.regs_items = ARRAY_SIZE(imx214_data_fmt_width8),
		.bits_per_pixel = 8,
		.regs = imx214_data_fmt_width8,
	},
	{
		.code = MEDIA_BUS_FMT_SGBRG8_1X8,
		.pixel_order = CRL_PIXEL_ORDER_GBRG,
		.regs_items = ARRAY_SIZE(imx214_data_fmt_width8),
		.bits_per_pixel = 8,
		.regs = imx214_data_fmt_width8,
	},
};


static const char * const imx214_test_patterns[] = {
	"Disabled",
	"Solid Colour",
	"Eight Vertical Colour Bars",
};


static struct crl_v4l2_ctrl imx214_v4l2_ctrls[] = {
	{
		.sd_type = CRL_SUBDEV_TYPE_SCALER,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_IDLE,
		.ctrl_id = V4L2_CID_LINK_FREQ,
		.name = "V4L2_CID_LINK_FREQ",
		.type = CRL_V4L2_CTRL_TYPE_MENU_INT,
		.data.v4l2_int_menu.def = 0,
		.data.v4l2_int_menu.max =
			ARRAY_SIZE(imx214_pll_configurations) - 1,
		.data.v4l2_int_menu.menu = imx214_op_sys_clock,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.regs_items = 0,
		.regs = 0,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_GET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_PIXEL_RATE,
		.name = "V4L2_CID_PIXEL_RATE_PA",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = INT_MAX,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.regs_items = 0,
		.regs = 0,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_SCALER,
		.op_type = CRL_V4L2_CTRL_GET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_PIXEL_RATE,
		.name = "V4L2_CID_PIXEL_RATE_CSI",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = INT_MAX,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.regs_items = 0,
		.regs = 0,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_ANALOGUE_GAIN,
		.name = "V4L2_CID_ANALOGUE_GAIN",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = 480,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx214_ana_gain_global_regs),
		.regs = imx214_ana_gain_global_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_EXPOSURE,
		.name = "V4L2_CID_EXPOSURE",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = 65500,
		.data.std_data.step = 1,
		.data.std_data.def = 1700,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx214_exposure_regs),
		.regs = imx214_exposure_regs,
		.dep_items = 0, /* FLL is changes automatically */
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_HFLIP,
		.name = "V4L2_CID_HFLIP",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = 1,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx214_h_flip_regs),
		.regs = imx214_h_flip_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_VFLIP,
		.name = "V4L2_CID_VFLIP",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = 1,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx214_v_flip_regs),
		.regs = imx214_v_flip_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_FRAME_LENGTH_LINES,
		.name = "Frame length lines",
		.type = CRL_V4L2_CTRL_TYPE_CUSTOM,
		.data.std_data.min = 160,
		.data.std_data.max = 65535,
		.data.std_data.step = 1,
		.data.std_data.def = 4130,
		.flags = V4L2_CTRL_FLAG_UPDATE,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx214_vblank_regs),
		.regs = imx214_vblank_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
		.v4l2_type = V4L2_CTRL_TYPE_INTEGER,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_LINE_LENGTH_PIXELS,
		.name = "Line Length Pixels",
		.type = CRL_V4L2_CTRL_TYPE_CUSTOM,
		.data.std_data.min = 5008,
		.data.std_data.max = 65520,
		.data.std_data.step = 1,
		.data.std_data.def = 5008,
		.flags = V4L2_CTRL_FLAG_UPDATE,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx214_hblank_regs),
		.regs = imx214_hblank_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
		.v4l2_type = V4L2_CTRL_TYPE_INTEGER,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_TEST_PATTERN,
		.name = "V4L2_CID_TEST_PATTERN",
		.type = CRL_V4L2_CTRL_TYPE_MENU_ITEMS,
		.data.v4l2_menu_items.menu = imx214_test_patterns,
		.data.v4l2_menu_items.size = ARRAY_SIZE(imx214_test_patterns),
		.flags = V4L2_CTRL_FLAG_UPDATE,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx214_test_pattern_regs),
		.regs = imx214_test_pattern_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
};

/* Power items, they are enabled in the order they are listed here */
static struct crl_power_seq_entity imx214_power_items[] = {
	{
		.type = CRL_POWER_ETY_REGULATOR_FRAMEWORK,
		.ent_name = "VANA",
		.val = 2700000,
		.delay = 30000,
	},
	{
		.type = CRL_POWER_ETY_REGULATOR_FRAMEWORK,
		.ent_name = "VDIG",
		.val = 1100000,
		.delay = 0,
	},
	{
		.type = CRL_POWER_ETY_CLK_FRAMEWORK,
		.val = 24000000,
	},
	{
		.type = CRL_POWER_ETY_GPIO_FROM_PDATA,
		.val = 1,
		.undo_val = 0,
	},
};

struct crl_sensor_configuration imx214_crl_configuration = {

	.power_items = ARRAY_SIZE(imx214_power_items),
	.power_entities = imx214_power_items,

	.powerup_regs_items = ARRAY_SIZE(imx214_powerup_regset),
	.powerup_regs = imx214_powerup_regset,

	.poweroff_regs_items = 0,
	.poweroff_regs = 0,


	.id_reg_items = ARRAY_SIZE(imx214_sensor_detect_regset),
	.id_regs = imx214_sensor_detect_regset,

	.subdev_items = ARRAY_SIZE(imx214_sensor_subdevs),
	.subdevs = imx214_sensor_subdevs,

	.sensor_limits = &imx214_sensor_limits,

	.pll_config_items = ARRAY_SIZE(imx214_pll_configurations),
	.pll_configs = imx214_pll_configurations,

	.modes_items = ARRAY_SIZE(imx214_modes),
	.modes = imx214_modes,
	.fail_safe_mode_index = 3,

	.streamon_regs_items = ARRAY_SIZE(imx214_streamon_regs),
	.streamon_regs = imx214_streamon_regs,

	.streamoff_regs_items = ARRAY_SIZE(imx214_streamoff_regs),
	.streamoff_regs = imx214_streamoff_regs,

	.v4l2_ctrls_items = ARRAY_SIZE(imx214_v4l2_ctrls),
	.v4l2_ctrl_bank = imx214_v4l2_ctrls,

	.csi_fmts_items = ARRAY_SIZE(imx214_crl_csi_data_fmt),
	.csi_fmts = imx214_crl_csi_data_fmt,

	.flip_items = ARRAY_SIZE(imx214_flip_configurations),
	.flip_data = imx214_flip_configurations,
};






#endif  /* __CRLMODULE_DUMMY_imx230_CONFIGURATION_H_ */


