/*
 * Copyright (c) 2014--2016 Intel Corporation.
 *
 * Author: Vinod Govindapillai <vinod.govindapillai@intel.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef __CRLMODULE_imx230_CONFIGURATION_H_
#define __CRLMODULE_imx230_CONFIGURATION_H_

#include "crlmodule-nvm.h"
#include "crlmodule-sensor-ds.h"


static struct crl_register_write_rep imx230_pll_1500mbps[] = {
	{ 0x0301, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x0303, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x0305, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x0306, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0307, CRL_REG_LEN_08BIT, 0xc8 },
	{ 0x0309, CRL_REG_LEN_08BIT, 0x0A },
	{ 0x030B, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x030D, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x030E, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x030F, CRL_REG_LEN_08BIT, 0xa9 },
	{ 0x0310, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0114, CRL_REG_LEN_08BIT, 0x03 }, /* Mipi settings, 4 lane */
	{ 0x0820, CRL_REG_LEN_08BIT, 0x17 }, /*Data rate setting*/
	{ 0x0821, CRL_REG_LEN_08BIT, 0x6c },
	{ 0x0822, CRL_REG_LEN_08BIT, 0xcc },
	{ 0x0823, CRL_REG_LEN_08BIT, 0xcc },
	{ 0x0808, CRL_REG_LEN_08BIT, 0x01 },
};

static struct crl_register_write_rep imx230_pll_2_10_1500mbps[] = {
	{ 0x0301, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x0303, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x0305, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x0306, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0307, CRL_REG_LEN_08BIT, 0xc8 },
	{ 0x0309, CRL_REG_LEN_08BIT, 0x0A },
	{ 0x030B, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x030D, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x030E, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x030F, CRL_REG_LEN_08BIT, 0xa9 },
	{ 0x0310, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0114, CRL_REG_LEN_08BIT, 0x01 }, /* Mipi settings, 2 lane */
	{ 0x0820, CRL_REG_LEN_08BIT, 0x09 }, /*Data rate setting*/
	{ 0x0821, CRL_REG_LEN_08BIT, 0x60 },
	{ 0x0822, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0823, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0808, CRL_REG_LEN_08BIT, 0x01 },
};

static struct crl_register_write_rep imx230_pll_2_8_1500mbps[] = {
	{ 0x0301, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x0303, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x0305, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x0306, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0307, CRL_REG_LEN_08BIT, 0xc8 },
	{ 0x0309, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x030B, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x030D, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x030E, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x030F, CRL_REG_LEN_08BIT, 0xa9 },
	{ 0x0310, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0114, CRL_REG_LEN_08BIT, 0x01 }, /* Mipi settings, 2 lane */
	{ 0x0820, CRL_REG_LEN_08BIT, 0x09 }, /*Data rate setting*/
	{ 0x0821, CRL_REG_LEN_08BIT, 0x60 },
	{ 0x0822, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0823, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0808, CRL_REG_LEN_08BIT, 0x01 },
};

static struct crl_register_write_rep imx230_powerup_regset[] = {
	{ 0x4800, CRL_REG_LEN_08BIT, 0x0E },
	{ 0x4890, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x4D1E, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x4D1F, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x4FA0, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4FA1, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4FA2, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x4FA3, CRL_REG_LEN_08BIT, 0x83 },
	{ 0x6153, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x6156, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x69BB, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x69BC, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x69BD, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x69C1, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x69C4, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x69C6, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x7300, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x9009, CRL_REG_LEN_08BIT, 0x1A },
	{ 0xB040, CRL_REG_LEN_08BIT, 0x90 },
	{ 0xB041, CRL_REG_LEN_08BIT, 0x14 },
	{ 0xB042, CRL_REG_LEN_08BIT, 0x6B },
	{ 0xB043, CRL_REG_LEN_08BIT, 0x43 },
	{ 0xB044, CRL_REG_LEN_08BIT, 0x63 },
	{ 0xB045, CRL_REG_LEN_08BIT, 0x2A },
	{ 0xB046, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB047, CRL_REG_LEN_08BIT, 0x06 },
	{ 0xB048, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB049, CRL_REG_LEN_08BIT, 0x07 },
	{ 0xB04A, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB04B, CRL_REG_LEN_08BIT, 0x04 },
	{ 0xB04C, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB04D, CRL_REG_LEN_08BIT, 0x05 },
	{ 0xB04E, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB04F, CRL_REG_LEN_08BIT, 0x16 },
	{ 0xB050, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB051, CRL_REG_LEN_08BIT, 0x17 },
	{ 0xB052, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB053, CRL_REG_LEN_08BIT, 0x74 },
	{ 0xB054, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB055, CRL_REG_LEN_08BIT, 0x75 },
	{ 0xB056, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB057, CRL_REG_LEN_08BIT, 0x76 },
	{ 0xB058, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB059, CRL_REG_LEN_08BIT, 0x77 },
	{ 0xB05A, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB05B, CRL_REG_LEN_08BIT, 0x7A },
	{ 0xB05C, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB05D, CRL_REG_LEN_08BIT, 0x7B },
	{ 0xB05E, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB05F, CRL_REG_LEN_08BIT, 0x0A },
	{ 0xB060, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB061, CRL_REG_LEN_08BIT, 0x0B },
	{ 0xB062, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB063, CRL_REG_LEN_08BIT, 0x08 },
	{ 0xB064, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB065, CRL_REG_LEN_08BIT, 0x09 },
	{ 0xB066, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB067, CRL_REG_LEN_08BIT, 0x0E },
	{ 0xB068, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB069, CRL_REG_LEN_08BIT, 0x0F },
	{ 0xB06A, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB06B, CRL_REG_LEN_08BIT, 0x0C },
	{ 0xB06C, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB06D, CRL_REG_LEN_08BIT, 0x0D },
	{ 0xB06E, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB06F, CRL_REG_LEN_08BIT, 0x13 },
	{ 0xB070, CRL_REG_LEN_08BIT, 0x68 },
	{ 0xB071, CRL_REG_LEN_08BIT, 0x12 },
	{ 0xB072, CRL_REG_LEN_08BIT, 0x90 },
	{ 0xB073, CRL_REG_LEN_08BIT, 0x0E },
	{ 0xD000, CRL_REG_LEN_08BIT, 0xDA },
	{ 0xD001, CRL_REG_LEN_08BIT, 0xDA },
	{ 0xD002, CRL_REG_LEN_08BIT, 0xAF },
	{ 0xD003, CRL_REG_LEN_08BIT, 0xE1 },
	{ 0xD004, CRL_REG_LEN_08BIT, 0x55 },
	{ 0xD005, CRL_REG_LEN_08BIT, 0x34 },
	{ 0xD006, CRL_REG_LEN_08BIT, 0x21 },
	{ 0xD007, CRL_REG_LEN_08BIT, 0x00 },
	{ 0xD008, CRL_REG_LEN_08BIT, 0x1C },
	{ 0xD009, CRL_REG_LEN_08BIT, 0x80 },
	{ 0xD00A, CRL_REG_LEN_08BIT, 0xFE },
	{ 0xD00B, CRL_REG_LEN_08BIT, 0xC5 },
	{ 0xD00C, CRL_REG_LEN_08BIT, 0x55 },
	{ 0xD00D, CRL_REG_LEN_08BIT, 0xDC },
	{ 0xD00E, CRL_REG_LEN_08BIT, 0xB6 },
	{ 0xD00F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0xD010, CRL_REG_LEN_08BIT, 0x31 },
	{ 0xD011, CRL_REG_LEN_08BIT, 0x02 },
	{ 0xD012, CRL_REG_LEN_08BIT, 0x4A },
	{ 0xD013, CRL_REG_LEN_08BIT, 0x0E },
	{ 0xD014, CRL_REG_LEN_08BIT, 0x55 },
	{ 0xD015, CRL_REG_LEN_08BIT, 0xF0 },
	{ 0xD016, CRL_REG_LEN_08BIT, 0x1B },
	{ 0xD017, CRL_REG_LEN_08BIT, 0x00 },
	{ 0xD018, CRL_REG_LEN_08BIT, 0xFA },
	{ 0xD019, CRL_REG_LEN_08BIT, 0x2C },
	{ 0xD01A, CRL_REG_LEN_08BIT, 0xF1 },
	{ 0xD01B, CRL_REG_LEN_08BIT, 0x7E },
	{ 0xD01C, CRL_REG_LEN_08BIT, 0x55 },
	{ 0xD01D, CRL_REG_LEN_08BIT, 0x1C },
	{ 0xD01E, CRL_REG_LEN_08BIT, 0xD8 },
	{ 0xD01F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0xD020, CRL_REG_LEN_08BIT, 0x76 },
	{ 0xD021, CRL_REG_LEN_08BIT, 0xC1 },
	{ 0xD022, CRL_REG_LEN_08BIT, 0xBF },
	{ 0xD044, CRL_REG_LEN_08BIT, 0x40 },
	{ 0xD045, CRL_REG_LEN_08BIT, 0xBA },
	{ 0xD046, CRL_REG_LEN_08BIT, 0x70 },
	{ 0xD047, CRL_REG_LEN_08BIT, 0x47 },
	{ 0xD048, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0xD049, CRL_REG_LEN_08BIT, 0xBA },
	{ 0xD04A, CRL_REG_LEN_08BIT, 0x70 },
	{ 0xD04B, CRL_REG_LEN_08BIT, 0x47 },
	{ 0xD04C, CRL_REG_LEN_08BIT, 0x82 },
	{ 0xD04D, CRL_REG_LEN_08BIT, 0xF6 },
	{ 0xD04E, CRL_REG_LEN_08BIT, 0xDA },
	{ 0xD04F, CRL_REG_LEN_08BIT, 0xFA },
	{ 0xD050, CRL_REG_LEN_08BIT, 0x00 },
	{ 0xD051, CRL_REG_LEN_08BIT, 0xF0 },
	{ 0xD052, CRL_REG_LEN_08BIT, 0x02 },
	{ 0xD053, CRL_REG_LEN_08BIT, 0xF8 },
	{ 0xD054, CRL_REG_LEN_08BIT, 0x81 },
	{ 0xD055, CRL_REG_LEN_08BIT, 0xF6 },
	{ 0xD056, CRL_REG_LEN_08BIT, 0xCE },
	{ 0xD057, CRL_REG_LEN_08BIT, 0xFD },
	{ 0xD058, CRL_REG_LEN_08BIT, 0x10 },
	{ 0xD059, CRL_REG_LEN_08BIT, 0xB5 },
	{ 0xD05A, CRL_REG_LEN_08BIT, 0x0D },
	{ 0xD05B, CRL_REG_LEN_08BIT, 0x48 },
	{ 0xD05C, CRL_REG_LEN_08BIT, 0x40 },
	{ 0xD05D, CRL_REG_LEN_08BIT, 0x7A },
	{ 0xD05E, CRL_REG_LEN_08BIT, 0x01 },
	{ 0xD05F, CRL_REG_LEN_08BIT, 0x28 },
	{ 0xD060, CRL_REG_LEN_08BIT, 0x15 },
	{ 0xD061, CRL_REG_LEN_08BIT, 0xD1 },
	{ 0xD062, CRL_REG_LEN_08BIT, 0x0C },
	{ 0xD063, CRL_REG_LEN_08BIT, 0x49 },
	{ 0xD064, CRL_REG_LEN_08BIT, 0x0C },
	{ 0xD065, CRL_REG_LEN_08BIT, 0x46 },
	{ 0xD066, CRL_REG_LEN_08BIT, 0x40 },
	{ 0xD067, CRL_REG_LEN_08BIT, 0x3C },
	{ 0xD068, CRL_REG_LEN_08BIT, 0x48 },
	{ 0xD069, CRL_REG_LEN_08BIT, 0x8A },
	{ 0xD06A, CRL_REG_LEN_08BIT, 0x62 },
	{ 0xD06B, CRL_REG_LEN_08BIT, 0x8A },
	{ 0xD06C, CRL_REG_LEN_08BIT, 0x80 },
	{ 0xD06D, CRL_REG_LEN_08BIT, 0x1A },
	{ 0xD06E, CRL_REG_LEN_08BIT, 0x8A },
	{ 0xD06F, CRL_REG_LEN_08BIT, 0x89 },
	{ 0xD070, CRL_REG_LEN_08BIT, 0x00 },
	{ 0xD071, CRL_REG_LEN_08BIT, 0xB2 },
	{ 0xD072, CRL_REG_LEN_08BIT, 0x10 },
	{ 0xD073, CRL_REG_LEN_08BIT, 0x18 },
	{ 0xD074, CRL_REG_LEN_08BIT, 0x0A },
	{ 0xD075, CRL_REG_LEN_08BIT, 0x46 },
	{ 0xD076, CRL_REG_LEN_08BIT, 0x20 },
	{ 0xD077, CRL_REG_LEN_08BIT, 0x32 },
	{ 0xD078, CRL_REG_LEN_08BIT, 0x12 },
	{ 0xD079, CRL_REG_LEN_08BIT, 0x88 },
	{ 0xD07A, CRL_REG_LEN_08BIT, 0x90 },
	{ 0xD07B, CRL_REG_LEN_08BIT, 0x42 },
	{ 0xD07C, CRL_REG_LEN_08BIT, 0x00 },
	{ 0xD07D, CRL_REG_LEN_08BIT, 0xDA },
	{ 0xD07E, CRL_REG_LEN_08BIT, 0x10 },
	{ 0xD07F, CRL_REG_LEN_08BIT, 0x46 },
	{ 0xD080, CRL_REG_LEN_08BIT, 0x80 },
	{ 0xD081, CRL_REG_LEN_08BIT, 0xB2 },
	{ 0xD082, CRL_REG_LEN_08BIT, 0x88 },
	{ 0xD083, CRL_REG_LEN_08BIT, 0x81 },
	{ 0xD084, CRL_REG_LEN_08BIT, 0x84 },
	{ 0xD085, CRL_REG_LEN_08BIT, 0xF6 },
	{ 0xD086, CRL_REG_LEN_08BIT, 0x06 },
	{ 0xD087, CRL_REG_LEN_08BIT, 0xF8 },
	{ 0xD088, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0xD089, CRL_REG_LEN_08BIT, 0x67 },
	{ 0xD08A, CRL_REG_LEN_08BIT, 0x85 },
	{ 0xD08B, CRL_REG_LEN_08BIT, 0xF6 },
	{ 0xD08C, CRL_REG_LEN_08BIT, 0x4B },
	{ 0xD08D, CRL_REG_LEN_08BIT, 0xFC },
	{ 0xD08E, CRL_REG_LEN_08BIT, 0x10 },
	{ 0xD08F, CRL_REG_LEN_08BIT, 0xBD },
	{ 0xD090, CRL_REG_LEN_08BIT, 0x00 },
	{ 0xD091, CRL_REG_LEN_08BIT, 0x18 },
	{ 0xD092, CRL_REG_LEN_08BIT, 0x1E },
	{ 0xD093, CRL_REG_LEN_08BIT, 0x78 },
	{ 0xD094, CRL_REG_LEN_08BIT, 0x00 },
	{ 0xD095, CRL_REG_LEN_08BIT, 0x18 },
	{ 0xD096, CRL_REG_LEN_08BIT, 0x17 },
	{ 0xD097, CRL_REG_LEN_08BIT, 0x98 },
	{ 0x5869, CRL_REG_LEN_08BIT, 0x01 }, /*Global settings done*/
	{ 0x0216, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0217, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x020E, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x020F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0210, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0211, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0212, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0213, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0214, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0215, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0220, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0221, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0222, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0224, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0225, CRL_REG_LEN_08BIT, 0xF4 },
	{ 0x3000, CRL_REG_LEN_08BIT, 0x74 }, /* HDR output control */
	{ 0x30b1, CRL_REG_LEN_08BIT, 0x00 }, /* GlobalShadingComp - HDRZZ */
	{ 0x30c6, CRL_REG_LEN_08BIT, 0x00 }, /* ShieldPixelCorr HDRZZ */
	{ 0x30b2, CRL_REG_LEN_08BIT, 0x00 }, /* DefectCorr1D HDRZZ */
	{ 0x30b3, CRL_REG_LEN_08BIT, 0x00 }, /* DefectCorr2D HDRZZ */
	{ 0x30c7, CRL_REG_LEN_08BIT, 0x00 }, /* NoiseReduction HDRZZ */
	{ 0x3A21, CRL_REG_LEN_08BIT, 0x00 }, /* LSC setting */
	{ 0x3011, CRL_REG_LEN_08BIT, 0x00 }, /* STATS Calc enable/disable */
	{ 0x3013, CRL_REG_LEN_08BIT, 0x00 }, /*stats output enable/disable */
	{ 0x5041, CRL_REG_LEN_08BIT, 0x04 }, /*embedded data on/off, 4 lines */
	{ 0x3121, CRL_REG_LEN_08BIT, 0x00 }, /*PDAF calc enable/disable */
	{ 0x3001, CRL_REG_LEN_08BIT, 0x00 }, /*PDAF fir HDR enable/disable */
	{ 0x3123, CRL_REG_LEN_08BIT, 0x00 }, /*PDAF output enable/disable **/
	{ 0x0138, CRL_REG_LEN_08BIT, 0x01 }, /* Temperature control enable */
};

static struct crl_register_write_rep imx230_mode_2k2k[] = {
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x034B, CRL_REG_LEN_08BIT, 0xAF },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x22 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3001, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x0A }, /*Output*/
	{ 0x034D, CRL_REG_LEN_08BIT, 0x70 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x07 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0xD7 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x0A },
	{ 0x040D, CRL_REG_LEN_08BIT, 0x70 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x07 },
	{ 0x040F, CRL_REG_LEN_08BIT, 0xD7 },
	{ 0x3006, CRL_REG_LEN_08BIT, 0x01 }, /* HDR settings */
	{ 0x3007, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x31E0, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x31E1, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x31E4, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x697D, CRL_REG_LEN_08BIT, 0x02 }, /* PAF settings */
	{ 0x6985, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x698D, CRL_REG_LEN_08BIT, 0x0B },
	{ 0x6995, CRL_REG_LEN_08BIT, 0x0B },
	{ 0x699D, CRL_REG_LEN_08BIT, 0x16 },
	{ 0x69A5, CRL_REG_LEN_08BIT, 0x16 },
	{ 0x69AD, CRL_REG_LEN_08BIT, 0x1F },
	{ 0x69B5, CRL_REG_LEN_08BIT, 0x1F },
	{ 0x3A22, CRL_REG_LEN_08BIT, 0x20 }, /* DPC2D settings */
	{ 0x3A23, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A24, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A25, CRL_REG_LEN_08BIT, 0x07 },
	{ 0x3A26, CRL_REG_LEN_08BIT, 0xD8 },
	{ 0x3A2F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A30, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A31, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A32, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A33, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A34, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x3A35, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x3A36, CRL_REG_LEN_08BIT, 0xAF },
	{ 0x3A37, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A38, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x3A39, CRL_REG_LEN_08BIT, 0x00 },
};

/* UHD Scale */
static struct crl_register_write_rep imx230_mode_4k2k[] = {
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0xF8 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0D },
	{ 0x034B, CRL_REG_LEN_08BIT, 0xB7 },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3001, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x034D, CRL_REG_LEN_08BIT, 0x2E },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0x88 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x16 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x040D, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x0B },
	{ 0x040F, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0x3A22, CRL_REG_LEN_08BIT, 0x20 }, /* DPC2D settings */
	{ 0x3A23, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A24, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A25, CRL_REG_LEN_08BIT, 0x0B },
	{ 0x3A26, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0x3A2F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A30, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A31, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x3A32, CRL_REG_LEN_08BIT, 0xF8 },
	{ 0x3A33, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A34, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x3A35, CRL_REG_LEN_08BIT, 0x0D },
	{ 0x3A36, CRL_REG_LEN_08BIT, 0xB7 },
	{ 0x3A37, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A38, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A39, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3006, CRL_REG_LEN_08BIT, 0x01 }, /* HDR settings */
	{ 0x3007, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x31E0, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x31E1, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x31E4, CRL_REG_LEN_08BIT, 0x02 },
};


/* UHD crop*/
static struct crl_register_write_rep imx230_mode_uhd_crop[] = {
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0xA0 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0C },
	{ 0x034B, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3001, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x034D, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0x70 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x040D, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x040F, CRL_REG_LEN_08BIT, 0x70 },
	{ 0x3A22, CRL_REG_LEN_08BIT, 0x20 }, /* DPC2D settings */
	{ 0x3A23, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A24, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A25, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x3A26, CRL_REG_LEN_08BIT, 0x70 },
	{ 0x3A2F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A30, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A31, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x3A32, CRL_REG_LEN_08BIT, 0xA0 },
	{ 0x3A33, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A34, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x3A35, CRL_REG_LEN_08BIT, 0x0C },
	{ 0x3A36, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x3A37, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A38, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A39, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3006, CRL_REG_LEN_08BIT, 0x01 }, /* HDR settings */
	{ 0x3007, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x31E0, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x31E1, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x31E4, CRL_REG_LEN_08BIT, 0x02 },
};


/*5344 x 40160*/
static struct crl_register_write_rep imx230_mode_full_4_3[] = {
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x034B, CRL_REG_LEN_08BIT, 0xAF },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3001, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x034D, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x034F, CRL_REG_LEN_08BIT, 0xB0 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x040D, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x040F, CRL_REG_LEN_08BIT, 0xB0 },
	{ 0x3A22, CRL_REG_LEN_08BIT, 0x20 }, /* DPC2D settings */
	{ 0x3A23, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A24, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A25, CRL_REG_LEN_08BIT, 0x0f },
	{ 0x3A26, CRL_REG_LEN_08BIT, 0xB0 },
	{ 0x3A2F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A30, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A31, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x3A32, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0x3A33, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A34, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x3A35, CRL_REG_LEN_08BIT, 0x0f },
	{ 0x3A36, CRL_REG_LEN_08BIT, 0xAF },
	{ 0x3A37, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A38, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A39, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3006, CRL_REG_LEN_08BIT, 0x01 }, /* HDR settings */
	{ 0x3007, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x31E0, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x31E1, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x31E4, CRL_REG_LEN_08BIT, 0x02 },
};

/*5344 x 4016*/
static struct crl_register_write_rep imx230_mode_full_16_9[] = {
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0xF8 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0D },
	{ 0x034B, CRL_REG_LEN_08BIT, 0xB7 },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3001, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x034D, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x0B },
	{ 0x034F, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x040D, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x0B },
	{ 0x040F, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0x3A22, CRL_REG_LEN_08BIT, 0x20 }, /* DPC2D settings */
	{ 0x3A23, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A24, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A25, CRL_REG_LEN_08BIT, 0x0B },
	{ 0x3A26, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0x3A2F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A30, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A31, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x3A32, CRL_REG_LEN_08BIT, 0xF8 },
	{ 0x3A33, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A34, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x3A35, CRL_REG_LEN_08BIT, 0x0D },
	{ 0x3A36, CRL_REG_LEN_08BIT, 0xB7 },
	{ 0x3A37, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A38, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A39, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3006, CRL_REG_LEN_08BIT, 0x01 }, /* HDR settings */
	{ 0x3007, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x31E0, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x31E1, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x31E4, CRL_REG_LEN_08BIT, 0x02 },
};

static struct crl_register_write_rep imx230_mode_3264x2448_crop[] = {
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0C },
	{ 0x034B, CRL_REG_LEN_08BIT, 0x9F },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3001, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x0C },
	{ 0x034D, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x09 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0x90 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x0C },
	{ 0x040D, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x09 },
	{ 0x040F, CRL_REG_LEN_08BIT, 0x90 },
	{ 0x3A22, CRL_REG_LEN_08BIT, 0x20 }, /* DPC2D settings */
	{ 0x3A23, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A24, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A25, CRL_REG_LEN_08BIT, 0x09 },
	{ 0x3A26, CRL_REG_LEN_08BIT, 0x90 },
	{ 0x3A2F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A30, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A31, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x3A32, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x3A33, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A34, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x3A35, CRL_REG_LEN_08BIT, 0x0C },
	{ 0x3A36, CRL_REG_LEN_08BIT, 0x9F },
	{ 0x3A37, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A38, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A39, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3006, CRL_REG_LEN_08BIT, 0x01 }, /* HDR settings */
	{ 0x3007, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x31E0, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x31E1, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x31E4, CRL_REG_LEN_08BIT, 0x02 },
};

static struct crl_register_write_rep imx230_mode_3264x2448_scale[] = {
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x034B, CRL_REG_LEN_08BIT, 0xAF },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3001, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x0C },
	{ 0x034D, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x09 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0x90 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x1A },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x040D, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x0F }, /*dig crop y*/
	{ 0x040F, CRL_REG_LEN_08BIT, 0xB0 },
	{ 0x3A22, CRL_REG_LEN_08BIT, 0x20 }, /* DPC2D settings */
	{ 0x3A23, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A24, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A25, CRL_REG_LEN_08BIT, 0x0f },
	{ 0x3A26, CRL_REG_LEN_08BIT, 0xB0 },
	{ 0x3A2F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A30, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A31, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x3A32, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0x3A33, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A34, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x3A35, CRL_REG_LEN_08BIT, 0x0f },
	{ 0x3A36, CRL_REG_LEN_08BIT, 0xAF },
	{ 0x3A37, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A38, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A39, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3006, CRL_REG_LEN_08BIT, 0x01 }, /* HDR settings */
	{ 0x3007, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x31E0, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x31E1, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x31E4, CRL_REG_LEN_08BIT, 0x02 },
};

static struct crl_register_write_rep imx230_mode_3280x2460_scale[] = {
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x034B, CRL_REG_LEN_08BIT, 0xAF },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3001, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x0C },
	{ 0x034D, CRL_REG_LEN_08BIT, 0xD0 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x09 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0x9C },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x1A },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x040D, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x040F, CRL_REG_LEN_08BIT, 0xB0 },
	{ 0x3A22, CRL_REG_LEN_08BIT, 0x20 }, /* DPC2D settings */
	{ 0x3A23, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A24, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A25, CRL_REG_LEN_08BIT, 0x0f },
	{ 0x3A26, CRL_REG_LEN_08BIT, 0xB0 },
	{ 0x3A2F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A30, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A31, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x3A32, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0x3A33, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A34, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x3A35, CRL_REG_LEN_08BIT, 0x0f },
	{ 0x3A36, CRL_REG_LEN_08BIT, 0xAF },
	{ 0x3A37, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A38, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A39, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3006, CRL_REG_LEN_08BIT, 0x01 }, /* HDR settings */
	{ 0x3007, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x31E0, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x31E1, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x31E4, CRL_REG_LEN_08BIT, 0x02 },
};

static struct crl_register_write_rep imx230_mode_3336x2502_scale[] = {
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x034B, CRL_REG_LEN_08BIT, 0xAF },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3001, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x0D },
	{ 0x034D, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x09 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0xC6 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x19 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x040D, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x0F },
	{ 0x040F, CRL_REG_LEN_08BIT, 0xB0 },
	{ 0x3A22, CRL_REG_LEN_08BIT, 0x20 }, /* DPC2D settings */
	{ 0x3A23, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A24, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A25, CRL_REG_LEN_08BIT, 0x0f },
	{ 0x3A26, CRL_REG_LEN_08BIT, 0xB0 },
	{ 0x3A2F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A30, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A31, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x3A32, CRL_REG_LEN_08BIT, 0xC0 },
	{ 0x3A33, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A34, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x3A35, CRL_REG_LEN_08BIT, 0x0f },
	{ 0x3A36, CRL_REG_LEN_08BIT, 0xAF },
	{ 0x3A37, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A38, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A39, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3006, CRL_REG_LEN_08BIT, 0x01 }, /* HDR settings */
	{ 0x3007, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x31E0, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x31E1, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x31E4, CRL_REG_LEN_08BIT, 0x02 },
};

static struct crl_register_write_rep imx230_mode_2672x1504[] = {
	{ 0x0220, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0221, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x0222, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0224, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0225, CRL_REG_LEN_08BIT, 0xF4 },
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0xF8 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0D },
	{ 0x034B, CRL_REG_LEN_08BIT, 0xB7 },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x22 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3000, CRL_REG_LEN_08BIT, 0x74 },
	{ 0x3001, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x0A },
	{ 0x034D, CRL_REG_LEN_08BIT, 0x70 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x0A },
	{ 0x040D, CRL_REG_LEN_08BIT, 0x70 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x040F, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A22, CRL_REG_LEN_08BIT, 0x20 }, /* DPC2D settings */
	{ 0x3A23, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A24, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A25, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x3A26, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A2F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A30, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A31, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x3A32, CRL_REG_LEN_08BIT, 0xF8 },
	{ 0x3A33, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A34, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x3A35, CRL_REG_LEN_08BIT, 0x0D },
	{ 0x3A36, CRL_REG_LEN_08BIT, 0xB7 },
	{ 0x3A37, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A38, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x3A39, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3006, CRL_REG_LEN_08BIT, 0x01 }, /* HDR settings */
	{ 0x3007, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x31E0, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x31E1, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x31E4, CRL_REG_LEN_08BIT, 0x02 },
};

static struct crl_register_write_rep imx230_mode_1940x1092[] = {
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0xF8 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0D },
	{ 0x034B, CRL_REG_LEN_08BIT, 0xB7 },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x22 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3001, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x07 } /*1920 x 1080*/,
	{ 0x034D, CRL_REG_LEN_08BIT, 0x94 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x04 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0x44 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x16 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x0A },
	{ 0x040D, CRL_REG_LEN_08BIT, 0x70 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x040F, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A22, CRL_REG_LEN_08BIT, 0x20 }, /* DPC2D settings */
	{ 0x3A23, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A24, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A25, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x3A26, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A2F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A30, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A31, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x3A32, CRL_REG_LEN_08BIT, 0xF8 },
	{ 0x3A33, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A34, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x3A35, CRL_REG_LEN_08BIT, 0x0D },
	{ 0x3A36, CRL_REG_LEN_08BIT, 0xB7 },
	{ 0x3A37, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A38, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x3A39, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3006, CRL_REG_LEN_08BIT, 0x01 }, /* HDR settings */
	{ 0x3007, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x31E0, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x31E1, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x31E4, CRL_REG_LEN_08BIT, 0x02 },

};

static struct crl_register_write_rep imx230_mode_1440[] = {
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0A },
	{ 0x034B, CRL_REG_LEN_08BIT, 0xA7 },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x22 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3001, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x0A },  /* 2560 x 1440 */
	{ 0x034D, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0xA0 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x70 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x0A },
	{ 0x040D, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x040F, CRL_REG_LEN_08BIT, 0xA0 },
	{ 0x3A22, CRL_REG_LEN_08BIT, 0x20 }, /* DPC2D settings */
	{ 0x3A23, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A24, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A25, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x3A26, CRL_REG_LEN_08BIT, 0xA0 },
	{ 0x3A2F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A30, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A31, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x3A32, CRL_REG_LEN_08BIT, 0x08 },
	{ 0x3A33, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A34, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x3A35, CRL_REG_LEN_08BIT, 0x0A },
	{ 0x3A36, CRL_REG_LEN_08BIT, 0xA7 },
	{ 0x3A37, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A38, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A39, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3006, CRL_REG_LEN_08BIT, 0x01 }, /* HDR settings */
	{ 0x3007, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x31E0, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x31E1, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x31E4, CRL_REG_LEN_08BIT, 0x02 },
};


static struct crl_register_write_rep imx230_mode_720[] = {
	{ 0x0344, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0345, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0346, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x0347, CRL_REG_LEN_08BIT, 0x18 },
	{ 0x0348, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x0349, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x034A, CRL_REG_LEN_08BIT, 0x0D },
	{ 0x034B, CRL_REG_LEN_08BIT, 0x97 },
	{ 0x0381, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0383, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0385, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0387, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0900, CRL_REG_LEN_08BIT, 0x01 },
	{ 0x0901, CRL_REG_LEN_08BIT, 0x44 },
	{ 0x0902, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3001, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x305C, CRL_REG_LEN_08BIT, 0x11 },
	{ 0x034C, CRL_REG_LEN_08BIT, 0x05 } /* 1296 x 736 */,
	{ 0x034D, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x034E, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x034F, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x0401, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0404, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0405, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x0408, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x0409, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x040A, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040B, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x040C, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x040D, CRL_REG_LEN_08BIT, 0x10 },
	{ 0x040E, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x040F, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A22, CRL_REG_LEN_08BIT, 0x20 }, /* DPC2D settings */
	{ 0x3A23, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A24, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A25, CRL_REG_LEN_08BIT, 0x05 },
	{ 0x3A26, CRL_REG_LEN_08BIT, 0xE0 },
	{ 0x3A2F, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A30, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A31, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x3A32, CRL_REG_LEN_08BIT, 0x18 },
	{ 0x3A33, CRL_REG_LEN_08BIT, 0x14 },
	{ 0x3A34, CRL_REG_LEN_08BIT, 0xDF },
	{ 0x3A35, CRL_REG_LEN_08BIT, 0x0D },
	{ 0x3A36, CRL_REG_LEN_08BIT, 0x97 },
	{ 0x3A37, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3A38, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x3A39, CRL_REG_LEN_08BIT, 0x00 },
	{ 0x3006, CRL_REG_LEN_08BIT, 0x01 }, /* HDR settings */
	{ 0x3007, CRL_REG_LEN_08BIT, 0x02 },
	{ 0x31E0, CRL_REG_LEN_08BIT, 0x03 },
	{ 0x31E1, CRL_REG_LEN_08BIT, 0xFF },
	{ 0x31E4, CRL_REG_LEN_08BIT, 0x02 },
};


static struct crl_register_write_rep imx230_streamon_regs[] = {
	{ 0x0100, CRL_REG_LEN_08BIT, 0x01 }
};

static struct crl_register_write_rep imx230_streamoff_regs[] = {
	{ 0x0100, CRL_REG_LEN_08BIT, 0x00 }
};

static struct crl_register_write_rep imx230_data_fmt_width10[] = {
	{ 0x0112, CRL_REG_LEN_16BIT, 0x0a0a }
};

static struct crl_register_write_rep imx230_data_fmt_width8[] = {
	{ 0x0112, CRL_REG_LEN_16BIT, 0x0808 }
};

static struct crl_arithmetic_ops imx230_vflip_ops[] = {
	{
		.op = CRL_BITWISE_LSHIFT,
		.operand.entity_val = 1,
	},
};

static struct crl_dynamic_register_access imx230_h_flip_regs[] = {
	{
		.address = 0x0101,
		.len = CRL_REG_LEN_08BIT | CRL_REG_READ_AND_UPDATE,
		.ops_items = 0,
		.ops = 0,
		.mask = 0x1,
	},
};

static struct crl_dynamic_register_access imx230_v_flip_regs[] = {
	{
		.address = 0x0101,
		.len = CRL_REG_LEN_08BIT | CRL_REG_READ_AND_UPDATE,
		.ops_items = ARRAY_SIZE(imx230_vflip_ops),
		.ops = imx230_vflip_ops,
		.mask = 0x2,
	},
};


static struct crl_dynamic_register_access imx230_ana_gain_global_regs[] = {
	{
		.address = 0x0204,
		.len = CRL_REG_LEN_16BIT,
		.ops_items = 0,
		.ops = 0,
		.mask = 0xffff,
	},
};

static struct crl_dynamic_register_access imx230_dig_gain_regs[] = {
	{
		.address = 0x020e,
		.len = CRL_REG_LEN_16BIT,
		.ops_items = 0,
		.ops = 0,
		.mask = 0xfff,
	},
	{
		.address = 0x0210,
		.len = CRL_REG_LEN_16BIT,
		.ops_items = 0,
		.ops = 0,
		.mask = 0xfff,
	},
	{
		.address = 0x0212,
		.len = CRL_REG_LEN_16BIT,
		.ops_items = 0,
		.ops = 0,
		.mask = 0xfff,
	},
	{
		.address = 0x0214,
		.len = CRL_REG_LEN_16BIT,
		.ops_items = 0,
		.ops = 0,
		.mask = 0xfff,
	},
};



static struct crl_dynamic_register_access imx230_exposure_regs[] = {
	{
		.address = 0x0202,
		.len = CRL_REG_LEN_16BIT,
		.ops_items = 0,
		.ops = 0,
		.mask = 0xffff,
	}
};

static struct crl_dynamic_register_access imx230_fll_regs[] = {
	{
		.address = 0x0340,
		.len = CRL_REG_LEN_16BIT,
		.ops_items = 0,
		.ops = 0,
		.mask = 0xffff,
	},
};

static struct crl_dynamic_register_access imx230_llp_regs[] = {
	{
		.address = 0x0342,
		.len = CRL_REG_LEN_16BIT,
		.ops_items = 0,
		.ops = 0,
		.mask = 0xffff,
	},
};

/*
 * HDR mode on -> ctrl value 1.
 * 0x0220 to 0x01 and 0x3000 to 0x00
 * HDR mode off -> ctrl value 0
 * 0x0220 to 0x00 and 0x3000 to 0x74
 *
 * NOTE! 0x3000 to 0x74 is based on the existing mode details. If any mode need
 * any another value than 0x74, then a separate control would be needed.
 *
 * TODO! Replace this when the dpendency register block is enabled
 */
static struct crl_arithmetic_ops imx230_hdr_mode_ops[] = {
	{ CRL_BITWISE_COMPLEMENT, { 0, 0 } },
	{ CRL_BITWISE_AND, { 0, 1 } },
	{ CRL_MULTIPLY, { 0, 0x74 } },
};

static struct crl_dynamic_register_access imx230_hdr_mode_regs[] = {
	{ 0x0220, CRL_REG_LEN_08BIT, 0xff, 0, NULL, 0 },
	{ 0x3000, CRL_REG_LEN_08BIT, 0xff, ARRAY_SIZE(imx230_hdr_mode_ops),
					   imx230_hdr_mode_ops, 0 },
};

static struct crl_dynamic_register_access imx230_hdr_et_ratio_regs[] = {
	{ 0x0222, CRL_REG_LEN_08BIT, 0xff, 0, NULL, 0 },
};

static struct crl_dynamic_register_access imx230_hdr_zigzag_regs[] = {
	{ 0x30b4, CRL_REG_LEN_08BIT, 0xff, 0, NULL, 0 },
	{ 0x30b5, CRL_REG_LEN_08BIT, 0xff, 0, NULL, 0 },
	{ 0x30b6, CRL_REG_LEN_08BIT, 0xff, 0, NULL, 0 },
	{ 0x30b7, CRL_REG_LEN_08BIT, 0xff, 0, NULL, 0 },
	{ 0x30b8, CRL_REG_LEN_08BIT, 0xff, 0, NULL, 0 },
	{ 0x30b9, CRL_REG_LEN_08BIT, 0xff, 0, NULL, 0 },
	{ 0x30ba, CRL_REG_LEN_08BIT, 0xff, 0, NULL, 0 },
	{ 0x30bb, CRL_REG_LEN_08BIT, 0xff, 0, NULL, 0 },
	{ 0x30bc, CRL_REG_LEN_08BIT, 0xff, 0, NULL, 0 },
};

static struct crl_sensor_detect_config imx230_sensor_detect_regset[] = {
	{
		.reg = { 0x0019, CRL_REG_LEN_08BIT, 0x000000ff },
		.width = 5,
	},
		{
		.reg = { 0x0018, CRL_REG_LEN_08BIT, 0x000000ff },
		.width = 5,
	},
	{
		.reg = { 0x0016, CRL_REG_LEN_16BIT, 0x0000ffff },
		.width = 7,
	},
};

static struct crl_arithmetic_ops imx230_thermal_ops[] = {
	{
		.op = CRL_ASSIGNMENT,
		.operand.entity_type = CRL_DYNAMIC_VAL_OPERAND_TYPE_REG_VAL,
		.operand.entity_val = 0x013a,
	},
};

static struct crl_dynamic_register_access imx230_thermal_regs[] = {
	{
		.address = 0x013a,
		.len = CRL_REG_LEN_08BIT,
		.ops_items = ARRAY_SIZE(imx230_thermal_ops),
		.ops = imx230_thermal_ops,
		.mask = 0xff,
	},
};

static struct crl_pll_configuration imx230_pll_configurations[] = {
	{
		.input_clk = 24000000,
		.op_sys_clk = 749600000,
		.bitsperpixel = 10,
		.pixel_rate_csi = 599680000,
		.pixel_rate_pa = 600000000,
		.csi_lanes = 4,
		.comp_items = 0,
		.ctrl_data = 0,
		.pll_regs_items = ARRAY_SIZE(imx230_pll_1500mbps),
		.pll_regs = imx230_pll_1500mbps,
	},
	{
		.input_clk = 24000000,
		.op_sys_clk = 749600000,
		.bitsperpixel = 8,
		.pixel_rate_csi = 374800000,
		.pixel_rate_pa = 600000000,
		.csi_lanes = 2,
		.comp_items = 0,
		.ctrl_data = 0,
		.pll_regs_items = ARRAY_SIZE(imx230_pll_2_8_1500mbps),
		.pll_regs = imx230_pll_2_8_1500mbps,
	},
	{
		.input_clk = 24000000,
		.op_sys_clk = 749600000,
		.bitsperpixel = 10,
		.pixel_rate_csi = 299840000,
		.pixel_rate_pa = 600000000,
		.csi_lanes = 2,
		.comp_items = 0,
		.ctrl_data = 0,
		.pll_regs_items = ARRAY_SIZE(imx230_pll_2_10_1500mbps),
		.pll_regs = imx230_pll_2_10_1500mbps,
	},
};

static struct crl_subdev_rect_rep imx230_full_4_3_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 5344, 4016 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 5344, 4016 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 5344, 4016 },
	},
};

static struct crl_subdev_rect_rep imx230_3280x2460_s_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 5344, 4016 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 5344, 4016 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 3280, 2460 },
	},
};

static struct crl_subdev_rect_rep imx230_3264x2448_s_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 5344, 4016 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 5344, 4016 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 3264, 2448 },
	},
};

static struct crl_subdev_rect_rep imx230_3336x2502_s_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 5344, 4016 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 5344, 4016 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 3336, 2502 },
	},
};

static struct crl_subdev_rect_rep imx230_3264x2448_c_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 504, 5344, 3008 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect = { 0, 0, 5344, 3008 },
		.out_rect = { 0, 0, 5344, 3008 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect = { 0, 0, 5344, 3008 },
		.out_rect = { 0, 0, 3264, 2448 },
	},
};

static struct crl_subdev_rect_rep imx230_full_16_9_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 504, 5344, 3008 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect = { 0, 0, 5344, 3008 },
		.out_rect = { 0, 0, 5344, 3008 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect = { 0, 0, 5344, 3008 },
		.out_rect = { 0, 0, 5344, 3008 },
	},
};

static struct crl_subdev_rect_rep imx230_4k2k_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 504, 5344, 3008 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect = { 0, 0, 5344, 3008 },
		.out_rect = { 0, 0, 5344, 3008 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect = { 0, 0, 5344, 3008 },
		.out_rect = { 0, 0, 3886, 2184 },
	},
};

static struct crl_subdev_rect_rep imx230_uhd_crop_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 928, 5344, 2160 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect = { 0, 0, 5344, 2160 },
		.out_rect = { 0, 0, 5344, 2160 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect = { 0, 0, 5344, 2160 },
		.out_rect = { 0, 0, 3840, 2160 },
	},
};

static struct crl_subdev_rect_rep imx230_2k2k_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 5344, 4016 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 2672, 2008 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect = { 0, 0, 2672, 2008 },
		.out_rect = { 0, 0, 2672, 2008 },
	},
};


static struct crl_subdev_rect_rep imx230_1940x1092_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 504, 5344, 3008 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect = { 0, 0, 5344, 3008 },
		.out_rect = { 0, 0, 2672, 1504 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect = { 0, 0, 2672, 1504 },
		.out_rect = { 0, 0, 1940, 1092 },
	},
};

static struct crl_subdev_rect_rep imx230_2672x1504_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 504, 5344, 3008 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect = { 0, 0, 5344, 3008 },
		.out_rect = { 0, 0, 2672, 1504 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect = { 0, 0, 2672, 1504 },
		.out_rect = { 0, 0, 2672, 1504 },
	},
};

static struct crl_subdev_rect_rep imx230_1440_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 1288, 5344, 1440 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect = { 0, 0, 5344, 1440 },
		.out_rect = { 0, 0, 5344, 1440 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect = { 0, 0, 5344, 1440 },
		.out_rect = { 0, 0, 2560, 1440 },
	},
};

static struct crl_subdev_rect_rep imx230_720_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect = { 0, 0, 5344, 4016 },
		.out_rect = { 0, 0, 5344, 3008 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect = { 0, 0, 5344, 3008 },
		.out_rect = { 0, 0, 1336, 752 },
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.in_rect = { 0, 0, 1336, 752 },
		.out_rect = { 0, 0, 1296, 736 },
	},
};

static struct crl_mode_rep imx230_modes[] = {
	{
		.sd_rects_items = ARRAY_SIZE(imx230_full_4_3_rects),
		.sd_rects = imx230_full_4_3_rects,
		.binn_hor = 1,
		.binn_vert = 1,
		.scale_m = 1,
		.width = 5344,
		.height = 4016,
		.min_llp = 6024,
		.min_fll = 4106,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx230_mode_full_4_3),
		.mode_regs = imx230_mode_full_4_3,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx230_3280x2460_s_rects),
		.sd_rects = imx230_3280x2460_s_rects,
		.binn_hor = 1,
		.binn_vert = 1,
		.scale_m = 26,
		.width = 3280,
		.height = 2460,
		.min_llp = 6024,
		.min_fll = 4106,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx230_mode_3280x2460_scale),
		.mode_regs = imx230_mode_3280x2460_scale,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx230_3264x2448_s_rects),
		.sd_rects = imx230_3264x2448_s_rects,
		.binn_hor = 1,
		.binn_vert = 1,
		.scale_m = 26,
		.width = 3264,
		.height = 2448,
		.min_llp = 6024,
		.min_fll = 4106,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx230_mode_3264x2448_scale),
		.mode_regs = imx230_mode_3264x2448_scale,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx230_3336x2502_s_rects),
		.sd_rects = imx230_3336x2502_s_rects,
		.binn_hor = 1,
		.binn_vert = 1,
		.scale_m = 25,
		.width = 3336,
		.height = 2502,
		.min_llp = 6024,
		.min_fll = 4106,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx230_mode_3336x2502_scale),
		.mode_regs = imx230_mode_3336x2502_scale,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx230_3264x2448_c_rects),
		.sd_rects = imx230_3264x2448_c_rects,
		.binn_hor = 1,
		.binn_vert = 1,
		.scale_m = 1,
		.width = 3264,
		.height = 2448,
		.min_llp = 6024,
		.min_fll = 2538,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx230_mode_3264x2448_crop),
		.mode_regs = imx230_mode_3264x2448_crop,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx230_full_16_9_rects),
		.sd_rects = imx230_full_16_9_rects,
		.binn_hor = 1,
		.binn_vert = 1,
		.scale_m = 1,
		.width = 5344,
		.height = 3008,
		.min_llp = 6024,
		.min_fll = 3098,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx230_mode_full_16_9),
		.mode_regs = imx230_mode_full_16_9,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx230_4k2k_rects),
		.sd_rects = imx230_4k2k_rects,
		.binn_hor = 1,
		.binn_vert = 1,
		.scale_m = 22,
		.width = 3886,
		.height = 2184,
		.min_llp = 6024,
		.min_fll = 3300,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx230_mode_4k2k),
		.mode_regs = imx230_mode_4k2k,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx230_uhd_crop_rects),
		.sd_rects = imx230_uhd_crop_rects,
		.binn_hor = 1,
		.binn_vert = 1,
		.scale_m = 1,
		.width = 3840,
		.height = 2160,
		.min_llp = 6024,
		.min_fll = 2250,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx230_mode_uhd_crop),
		.mode_regs = imx230_mode_uhd_crop,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx230_2k2k_rects),
		.sd_rects = imx230_2k2k_rects,
		.binn_hor = 2,
		.binn_vert = 2,
		.scale_m = 1,
		.width = 2672,
		.height = 2008,
		.min_llp = 6024,
		.min_fll = 2108,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx230_mode_2k2k),
		.mode_regs = imx230_mode_2k2k,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx230_2672x1504_rects),
		.sd_rects = imx230_2672x1504_rects,
		.binn_hor = 2,
		.binn_vert = 2,
		.scale_m = 1,
		.width = 2672,
		.height = 1504,
		.min_llp = 6024,
		.min_fll = 1660,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx230_mode_2672x1504),
		.mode_regs = imx230_mode_2672x1504,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx230_1940x1092_rects),
		.sd_rects = imx230_1940x1092_rects,
		.binn_hor = 2,
		.binn_vert = 2,
		.scale_m = 22,
		.width = 1940,
		.height = 1092,
		.min_llp = 6024,
		.min_fll = 1660,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx230_mode_1940x1092),
		.mode_regs = imx230_mode_1940x1092,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx230_1440_rects),
		.sd_rects = imx230_1440_rects,
		.binn_hor = 1,
		.binn_vert = 1,
		.scale_m = 1,
		.width = 2560,
		.height = 1440,
		.min_llp = 6024,
		.min_fll = 1530,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx230_mode_1440),
		.mode_regs = imx230_mode_1440,
	},
	{
		.sd_rects_items = ARRAY_SIZE(imx230_720_rects),
		.sd_rects = imx230_720_rects,
		.binn_hor = 4,
		.binn_vert = 4,
		.scale_m = 1,
		.width = 1296,
		.height = 736,
		.min_llp = 6024,
		.min_fll = 826,
		.comp_items = 0,
		.ctrl_data = 0,
		.mode_regs_items = ARRAY_SIZE(imx230_mode_720),
		.mode_regs = imx230_mode_720,
	},
};

static struct crl_sensor_subdev_config imx230_sensor_subdevs[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_SCALER,
		.name = "imx230 scaler",
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.name = "imx230 binner",
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.name = "imx230 pixel array",
	},
};

static struct crl_sensor_limits imx230_sensor_limits = {
	.x_addr_min = 0,
	.y_addr_min = 0,
	.x_addr_max = 5344,
	.y_addr_max = 4016,
	.min_frame_length_lines = 160,
	.max_frame_length_lines = 65535,
	.min_line_length_pixels = 6024,
	.max_line_length_pixels = 32752,
	.scaler_m_min = 16,
	.scaler_m_max = 255,
	.scaler_n_min = 16,
	.scaler_n_max = 16,
	.min_even_inc = 1,
	.max_even_inc = 1,
	.min_odd_inc = 1,
	.max_odd_inc = 3,
};

static struct crl_flip_data imx230_flip_configurations[] = {
	{
		.flip = CRL_FLIP_DEFAULT_NONE,
		.pixel_order = CRL_PIXEL_ORDER_RGGB,
	},
	{
		.flip = CRL_FLIP_HFLIP,
		.pixel_order = CRL_PIXEL_ORDER_GRBG,
	},
	{
		.flip = CRL_FLIP_VFLIP,
		.pixel_order = CRL_PIXEL_ORDER_GBRG,
	},
	{
		.flip = CRL_FLIP_HFLIP_VFLIP,
		.pixel_order = CRL_PIXEL_ORDER_BGGR,
	},
};

static struct crl_csi_data_fmt imx230_crl_csi_data_fmt[] = {
	{
		.code = MEDIA_BUS_FMT_SGRBG10_1X10,
		.pixel_order = CRL_PIXEL_ORDER_GRBG,
		.bits_per_pixel = 10,
		.regs_items = 1,
		.regs = imx230_data_fmt_width10,
	},
	{
		.code = MEDIA_BUS_FMT_SRGGB10_1X10,
		.pixel_order = CRL_PIXEL_ORDER_RGGB,
		.regs_items = 1,
		.bits_per_pixel = 10,
		.regs = imx230_data_fmt_width10,
	},
	{
		.code = MEDIA_BUS_FMT_SBGGR10_1X10,
		.pixel_order = CRL_PIXEL_ORDER_BGGR,
		.regs_items = 1,
		.bits_per_pixel = 10,
		.regs = imx230_data_fmt_width10,
	},
	{
		.code = MEDIA_BUS_FMT_SGBRG10_1X10,
		.pixel_order = CRL_PIXEL_ORDER_GBRG,
		.regs_items = 1,
		.bits_per_pixel = 10,
		.regs = imx230_data_fmt_width10,
	},
	{
		.code = MEDIA_BUS_FMT_SGRBG8_1X8,
		.pixel_order = CRL_PIXEL_ORDER_GRBG,
		.regs_items = 1,
		.bits_per_pixel = 8,
		.regs = imx230_data_fmt_width8,
	},
	{
		.code = MEDIA_BUS_FMT_SRGGB8_1X8,
		.pixel_order = CRL_PIXEL_ORDER_RGGB,
		.regs_items = 1,
		.bits_per_pixel = 8,
		.regs = imx230_data_fmt_width8,
	},
	{
		.code = MEDIA_BUS_FMT_SBGGR8_1X8,
		.pixel_order = CRL_PIXEL_ORDER_BGGR,
		.regs_items = 1,
		.bits_per_pixel = 8,
		.regs = imx230_data_fmt_width8,
	},
	{
		.code = MEDIA_BUS_FMT_SGBRG8_1X8,
		.pixel_order = CRL_PIXEL_ORDER_GBRG,
		.regs_items = 1,
		.bits_per_pixel = 8,
		.regs = imx230_data_fmt_width8,
	},
};

static struct crl_v4l2_ctrl imx230_vl42_ctrls[] = {
	{
		.sd_type = CRL_SUBDEV_TYPE_SCALER,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_IDLE,
		.ctrl_id = V4L2_CID_LINK_FREQ,
		.name = "V4L2_CID_LINK_FREQ",
		.type = CRL_V4L2_CTRL_TYPE_MENU_INT,
		.data.v4l2_int_menu.def = 0,
		.data.v4l2_int_menu.max = 0,
		.data.v4l2_int_menu.menu = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.regs_items = 0,
		.regs = 0,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_GET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_PIXEL_RATE,
		.name = "V4L2_CID_PIXEL_RATE_PA",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = INT_MAX,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.regs_items = 0,
		.regs = 0,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_SCALER,
		.op_type = CRL_V4L2_CTRL_GET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_PIXEL_RATE,
		.name = "V4L2_CID_PIXEL_RATE_CSI",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = INT_MAX,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.regs_items = 0,
		.regs = 0,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_ANALOGUE_GAIN,
		.name = "V4L2_CID_ANALOGUE_GAIN",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = 448,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx230_ana_gain_global_regs),
		.regs = imx230_ana_gain_global_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_EXPOSURE,
		.name = "V4L2_CID_EXPOSURE",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = 65500,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx230_exposure_regs),
		.regs = imx230_exposure_regs,
		.dep_items = 0, /* FLL is changes automatically */
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_HFLIP,
		.name = "V4L2_CID_HFLIP",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = 1,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx230_h_flip_regs),
		.regs = imx230_h_flip_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_VFLIP,
		.name = "V4L2_CID_VFLIP",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = 1,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx230_v_flip_regs),
		.regs = imx230_v_flip_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_FRAME_LENGTH_LINES,
		.name = "Frame length lines",
		.type = CRL_V4L2_CTRL_TYPE_CUSTOM,
		.data.std_data.min = 160,
		.data.std_data.max = 65535,
		.data.std_data.step = 1,
		.data.std_data.def = 4130,
		.flags = V4L2_CTRL_FLAG_UPDATE,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx230_fll_regs),
		.regs = imx230_fll_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
		.v4l2_type = V4L2_CTRL_TYPE_INTEGER,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_LINE_LENGTH_PIXELS,
		.name = "Line Length Pixels",
		.type = CRL_V4L2_CTRL_TYPE_CUSTOM,
		.data.std_data.min = 6024,
		.data.std_data.max = 65520,
		.data.std_data.step = 1,
		.data.std_data.def = 6024,
		.flags = V4L2_CTRL_FLAG_UPDATE,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx230_llp_regs),
		.regs = imx230_llp_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
		.v4l2_type = V4L2_CTRL_TYPE_INTEGER,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_GAIN,
		.name = "Digital Gain",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = 4095,
		.data.std_data.step = 1,
		.data.std_data.def = 256,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx230_dig_gain_regs),
		.regs = imx230_dig_gain_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_GET_OP,
		.context = SENSOR_STREAMING,
		.ctrl_id = CRL_CID_SENSOR_THERMAL_DATA,
		.name = "Sensor Thermal Data",
		.type = CRL_V4L2_CTRL_TYPE_CUSTOM,
		.data.std_data.min = 0,
		.data.std_data.max = INT_MAX,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = V4L2_CTRL_FLAG_VOLATILE | V4L2_CTRL_FLAG_READ_ONLY,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx230_thermal_regs),
		.regs = imx230_thermal_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
		.v4l2_type = V4L2_CTRL_TYPE_INTEGER,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_IDLE, /* Cannot be set when streaming? */
		.ctrl_id = CRL_CID_IMX230_HDR_MODE,
		.name = "imx230 HDR mode",
		.type = CRL_V4L2_CTRL_TYPE_CUSTOM,
		.data.std_data.min = 0,
		.data.std_data.max = 1,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = V4L2_CTRL_FLAG_UPDATE,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx230_hdr_mode_regs),
		.regs = imx230_hdr_mode_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
		.v4l2_type = V4L2_CTRL_TYPE_INTEGER,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_IDLE, /* Cannot be set when streaming? */
		.ctrl_id = CRL_CID_IMX230_HDR_ET_RATIO,
		.name = "imx230 HDR ET Ratio",
		.type = CRL_V4L2_CTRL_TYPE_CUSTOM,
		.data.std_data.min = 1,
		.data.std_data.max = 16,
		.data.std_data.step = 1,
		.data.std_data.def = 1,
		.flags = V4L2_CTRL_FLAG_UPDATE,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx230_hdr_et_ratio_regs),
		.regs = imx230_hdr_et_ratio_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
		.v4l2_type = V4L2_CTRL_TYPE_INTEGER,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_IDLE, /* Cannot be set when streaming? */
		.ctrl_id = CRL_CID_IMX230_HDR_ZIGZAG,
		.name = "imx230 HDR zigzag",
		.type = CRL_V4L2_CTRL_TYPE_CUSTOM,
		.data.std_data.min = 0,
		.data.std_data.max = 1,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = V4L2_CTRL_FLAG_UPDATE,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(imx230_hdr_zigzag_regs),
		.regs = imx230_hdr_zigzag_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
		.v4l2_type = V4L2_CTRL_TYPE_INTEGER,
	},
};

/* Power items, they are enabled in the order they are listed here */
static struct crl_power_seq_entity imx230_power_items[] = {
	{
		.type = CRL_POWER_ETY_REGULATOR_FRAMEWORK,
		.ent_name = "VANA",
		.val = 2500000,
		.delay = 0,
	},
	{
		.type = CRL_POWER_ETY_REGULATOR_FRAMEWORK,
		.ent_name = "VDIG",
		.val = 1100000,
		.delay = 0,
	},
	{
		.type = CRL_POWER_ETY_REGULATOR_FRAMEWORK,
		.ent_name = "VIO",
		.val = 1800000,
		.delay = 0,
	},
	{
		.type = CRL_POWER_ETY_REGULATOR_FRAMEWORK,
		.ent_name = "VAF",
		.val = 3000000,
		.delay = 2000,
	},
	{
		.type = CRL_POWER_ETY_CLK_FRAMEWORK,
		.val = 24000000,
	},
	{
		.type = CRL_POWER_ETY_GPIO_FROM_PDATA,
		.val = 1,
		.delay = 10700,
	},
};

static struct crl_nvm_blob imx230_nvm_blobs[] = {
	{ 0x54, 0x00, 0x100 },
	{ 0x55, 0x00, 0x100 },
	{ 0x56, 0x00, 0x021 },
};

static struct crl_arithmetic_ops imx230_frame_desc_width_ops[] = {
	{
	 .op = CRL_ASSIGNMENT,
	 .operand.entity_type = CRL_DYNAMIC_VAL_OPERAND_TYPE_VAR_REF,
	 .operand.entity_val = CRL_VAR_REF_OUTPUT_WIDTH,
	},
};

static struct crl_arithmetic_ops imx230_frame_desc_height_ops[] = {
	{
	 .op = CRL_ASSIGNMENT,
	 .operand.entity_type = CRL_DYNAMIC_VAL_OPERAND_TYPE_CONST,
	 .operand.entity_val = 4,
	},
};

static struct crl_frame_desc imx230_frame_desc[] = {
	{
		.flags.entity_val = 0,
		.bpp.entity_type = CRL_DYNAMIC_VAL_OPERAND_TYPE_VAR_REF,
		.bpp.entity_val = CRL_VAR_REF_BITSPERPIXEL,
		.pixelcode.entity_val = MEDIA_BUS_FMT_FIXED,
		.length.entity_val = 0,
		.start_line.entity_val = 0,
		.start_pixel.entity_val = 0,
		.width = {
			 .ops_items = ARRAY_SIZE(imx230_frame_desc_width_ops),
			 .ops = imx230_frame_desc_width_ops,
			 },
		.height = {
			  .ops_items = ARRAY_SIZE(imx230_frame_desc_height_ops),
			  .ops = imx230_frame_desc_height_ops,
			  },
		.csi2_channel.entity_val = 0,
		.csi2_data_type.entity_val = 0x12,
	},
};

struct crl_sensor_configuration imx230_crl_configuration = {


	.power_items = ARRAY_SIZE(imx230_power_items),
	.power_entities = imx230_power_items,

	.powerup_regs_items = ARRAY_SIZE(imx230_powerup_regset),
	.powerup_regs = imx230_powerup_regset,

	.poweroff_regs_items = 0,
	.poweroff_regs = 0,

	.id_reg_items = ARRAY_SIZE(imx230_sensor_detect_regset),
	.id_regs = imx230_sensor_detect_regset,

	.subdev_items = ARRAY_SIZE(imx230_sensor_subdevs),
	.subdevs = imx230_sensor_subdevs,

	.sensor_limits = &imx230_sensor_limits,

	.pll_config_items = ARRAY_SIZE(imx230_pll_configurations),
	.pll_configs = imx230_pll_configurations,

	.modes_items = ARRAY_SIZE(imx230_modes),
	.modes = imx230_modes,
	.fail_safe_mode_index = 3,

	.streamon_regs_items = ARRAY_SIZE(imx230_streamon_regs),
	.streamon_regs = imx230_streamon_regs,

	.streamoff_regs_items = ARRAY_SIZE(imx230_streamoff_regs),
	.streamoff_regs = imx230_streamoff_regs,

	.v4l2_ctrls_items = ARRAY_SIZE(imx230_vl42_ctrls),
	.v4l2_ctrl_bank = imx230_vl42_ctrls,

	.csi_fmts_items = ARRAY_SIZE(imx230_crl_csi_data_fmt),
	.csi_fmts = imx230_crl_csi_data_fmt,

	.flip_items = ARRAY_SIZE(imx230_flip_configurations),
	.flip_data = imx230_flip_configurations,

	.crl_nvm_info.nvm_flags = CRL_NVM_ADDR_MODE_8BIT,
	.crl_nvm_info.nvm_preop_regs_items = 0,
	.crl_nvm_info.nvm_postop_regs_items = 0,
	.crl_nvm_info.nvm_blobs_items = ARRAY_SIZE(imx230_nvm_blobs),
	.crl_nvm_info.nvm_config = imx230_nvm_blobs,

	.frame_desc_entries = ARRAY_SIZE(imx230_frame_desc),
	.frame_desc_type = CRL_V4L2_MBUS_FRAME_DESC_TYPE_CSI2,
	.frame_desc = imx230_frame_desc,

	.msr_file_name = "00imx230.bxt_rvp.drvb",
};

#endif  /* __CRLMODULE_imx230_CONFIGURATION_H_ */
