/*
 * Copyright (c) 2016 Intel Corporation.
 *
 * Author: Yunliang Ding <yunliang.ding@intel.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef __CRLMODULE_OV10635_CONFIGURATION_H_
#define __CRLMODULE_OV10635_CONFIGURATION_H_

#include "crlmodule-sensor-ds.h"

#define OV10635_REG_RESET		0x0103

static struct crl_register_write_rep ov10635_1280_800_YUV_HDR[] = {
	{0x301b, CRL_REG_LEN_08BIT, 0xff},
	{0x301c, CRL_REG_LEN_08BIT, 0xff},
	{0x301a, CRL_REG_LEN_08BIT, 0xff},
	{0x3011, CRL_REG_LEN_08BIT, 0x42},
	{0x6900, CRL_REG_LEN_08BIT, 0x0c},
	{0x6901, CRL_REG_LEN_08BIT, 0x11},
	{0x3503, CRL_REG_LEN_08BIT, 0x10},
	{0x3025, CRL_REG_LEN_08BIT, 0x03},
	{0x3003, CRL_REG_LEN_08BIT, 0x20},
	{0x3004, CRL_REG_LEN_08BIT, 0x21},
	{0x3005, CRL_REG_LEN_08BIT, 0x20},
	{0x3006, CRL_REG_LEN_08BIT, 0x91},
	{0x3600, CRL_REG_LEN_08BIT, 0x74},
	{0x3601, CRL_REG_LEN_08BIT, 0x2b},
	{0x3612, CRL_REG_LEN_08BIT, 0x00},
	{0x3611, CRL_REG_LEN_08BIT, 0x67},
	{0x3633, CRL_REG_LEN_08BIT, 0xca},
	{0x3602, CRL_REG_LEN_08BIT, 0x2f},
	{0x3603, CRL_REG_LEN_08BIT, 0x00},
	{0x3630, CRL_REG_LEN_08BIT, 0x28},
	{0x3631, CRL_REG_LEN_08BIT, 0x16},
	{0x3714, CRL_REG_LEN_08BIT, 0x10},
	{0x371d, CRL_REG_LEN_08BIT, 0x01},
	{0x3007, CRL_REG_LEN_08BIT, 0x01},
	{0x3024, CRL_REG_LEN_08BIT, 0x01},
	{0x3020, CRL_REG_LEN_08BIT, 0x0b},
	{0x3702, CRL_REG_LEN_08BIT, 0x20},
	{0x3703, CRL_REG_LEN_08BIT, 0x48},
	{0x3704, CRL_REG_LEN_08BIT, 0x32},
	{0x3709, CRL_REG_LEN_08BIT, 0xa8},
	{0x3709, CRL_REG_LEN_08BIT, 0xa8},
	{0x370c, CRL_REG_LEN_08BIT, 0xc7},
	{0x370d, CRL_REG_LEN_08BIT, 0x80},
	{0x3712, CRL_REG_LEN_08BIT, 0x00},
	{0x3713, CRL_REG_LEN_08BIT, 0x20},
	{0x3715, CRL_REG_LEN_08BIT, 0x04},
	{0x381d, CRL_REG_LEN_08BIT, 0x40},
	{0x381c, CRL_REG_LEN_08BIT, 0x00},
	{0x3822, CRL_REG_LEN_08BIT, 0x50},
	{0x3824, CRL_REG_LEN_08BIT, 0x50},
	{0x3815, CRL_REG_LEN_08BIT, 0x8c},
	{0x3804, CRL_REG_LEN_08BIT, 0x05},
	{0x3805, CRL_REG_LEN_08BIT, 0x1f},
	{0x3800, CRL_REG_LEN_08BIT, 0x00},
	{0x3801, CRL_REG_LEN_08BIT, 0x00},
	{0x3806, CRL_REG_LEN_08BIT, 0x03},
	{0x3807, CRL_REG_LEN_08BIT, 0x29},
	{0x3802, CRL_REG_LEN_08BIT, 0x00},
	{0x3803, CRL_REG_LEN_08BIT, 0x04},
	{0x3808, CRL_REG_LEN_08BIT, 0x05},
	{0x3809, CRL_REG_LEN_08BIT, 0x00},
	{0x380a, CRL_REG_LEN_08BIT, 0x03},
	{0x380b, CRL_REG_LEN_08BIT, 0x20},
	{0x380c, CRL_REG_LEN_08BIT, 0x07},
	{0x380d, CRL_REG_LEN_08BIT, 0x71},
	{0x6e42, CRL_REG_LEN_08BIT, 0x03},
	{0x6e43, CRL_REG_LEN_08BIT, 0x48},
	{0x380e, CRL_REG_LEN_08BIT, 0x03},
	{0x380f, CRL_REG_LEN_08BIT, 0x48},
	{0x3813, CRL_REG_LEN_08BIT, 0x02},
	{0x3811, CRL_REG_LEN_08BIT, 0x10},
	{0x381f, CRL_REG_LEN_08BIT, 0x0c},
	{0x3828, CRL_REG_LEN_08BIT, 0x03},
	{0x3829, CRL_REG_LEN_08BIT, 0x10},
	{0x382a, CRL_REG_LEN_08BIT, 0x10},
	{0x382b, CRL_REG_LEN_08BIT, 0x10},
	{0x3621, CRL_REG_LEN_08BIT, 0x64},
	{0x5005, CRL_REG_LEN_08BIT, 0x08},
	{0x56d5, CRL_REG_LEN_08BIT, 0x00},
	{0x56d6, CRL_REG_LEN_08BIT, 0x80},
	{0x56d7, CRL_REG_LEN_08BIT, 0x00},
	{0x56d8, CRL_REG_LEN_08BIT, 0x00},
	{0x56d9, CRL_REG_LEN_08BIT, 0x00},
	{0x56da, CRL_REG_LEN_08BIT, 0x80},
	{0x56db, CRL_REG_LEN_08BIT, 0x00},
	{0x56dc, CRL_REG_LEN_08BIT, 0x00},
	{0x56e8, CRL_REG_LEN_08BIT, 0x00},
	{0x56e9, CRL_REG_LEN_08BIT, 0x7f},
	{0x56ea, CRL_REG_LEN_08BIT, 0x00},
	{0x56eb, CRL_REG_LEN_08BIT, 0x7f},
	{0x5100, CRL_REG_LEN_08BIT, 0x00},
	{0x5101, CRL_REG_LEN_08BIT, 0x80},
	{0x5102, CRL_REG_LEN_08BIT, 0x00},
	{0x5103, CRL_REG_LEN_08BIT, 0x80},
	{0x5104, CRL_REG_LEN_08BIT, 0x00},
	{0x5105, CRL_REG_LEN_08BIT, 0x80},
	{0x5106, CRL_REG_LEN_08BIT, 0x00},
	{0x5107, CRL_REG_LEN_08BIT, 0x80},
	{0x5108, CRL_REG_LEN_08BIT, 0x00},
	{0x5109, CRL_REG_LEN_08BIT, 0x00},
	{0x510a, CRL_REG_LEN_08BIT, 0x00},
	{0x510b, CRL_REG_LEN_08BIT, 0x00},
	{0x510c, CRL_REG_LEN_08BIT, 0x00},
	{0x510d, CRL_REG_LEN_08BIT, 0x00},
	{0x510e, CRL_REG_LEN_08BIT, 0x00},
	{0x510f, CRL_REG_LEN_08BIT, 0x00},
	{0x5110, CRL_REG_LEN_08BIT, 0x00},
	{0x5111, CRL_REG_LEN_08BIT, 0x80},
	{0x5112, CRL_REG_LEN_08BIT, 0x00},
	{0x5113, CRL_REG_LEN_08BIT, 0x80},
	{0x5114, CRL_REG_LEN_08BIT, 0x00},
	{0x5115, CRL_REG_LEN_08BIT, 0x80},
	{0x5116, CRL_REG_LEN_08BIT, 0x00},
	{0x5117, CRL_REG_LEN_08BIT, 0x80},
	{0x5118, CRL_REG_LEN_08BIT, 0x00},
	{0x5119, CRL_REG_LEN_08BIT, 0x00},
	{0x511a, CRL_REG_LEN_08BIT, 0x00},
	{0x511b, CRL_REG_LEN_08BIT, 0x00},
	{0x511c, CRL_REG_LEN_08BIT, 0x00},
	{0x511d, CRL_REG_LEN_08BIT, 0x00},
	{0x511e, CRL_REG_LEN_08BIT, 0x00},
	{0x511f, CRL_REG_LEN_08BIT, 0x00},
	{0x56d0, CRL_REG_LEN_08BIT, 0x00},
	{0x5006, CRL_REG_LEN_08BIT, 0x24},
	{0x5608, CRL_REG_LEN_08BIT, 0x0d},
	{0x52d7, CRL_REG_LEN_08BIT, 0x06},
	{0x528d, CRL_REG_LEN_08BIT, 0x08},
	{0x5293, CRL_REG_LEN_08BIT, 0x12},
	{0x52d3, CRL_REG_LEN_08BIT, 0x12},
	{0x5288, CRL_REG_LEN_08BIT, 0x06},
	{0x5289, CRL_REG_LEN_08BIT, 0x20},
	{0x52c8, CRL_REG_LEN_08BIT, 0x06},
	{0x52c9, CRL_REG_LEN_08BIT, 0x20},
	{0x52cd, CRL_REG_LEN_08BIT, 0x04},
	{0x5381, CRL_REG_LEN_08BIT, 0x00},
	{0x5382, CRL_REG_LEN_08BIT, 0xff},
	{0x5589, CRL_REG_LEN_08BIT, 0x76},
	{0x558a, CRL_REG_LEN_08BIT, 0x47},
	{0x558b, CRL_REG_LEN_08BIT, 0xef},
	{0x558c, CRL_REG_LEN_08BIT, 0xc9},
	{0x558d, CRL_REG_LEN_08BIT, 0x49},
	{0x558e, CRL_REG_LEN_08BIT, 0x30},
	{0x558f, CRL_REG_LEN_08BIT, 0x67},
	{0x5590, CRL_REG_LEN_08BIT, 0x3f},
	{0x5591, CRL_REG_LEN_08BIT, 0xf0},
	{0x5592, CRL_REG_LEN_08BIT, 0x10},
	{0x55a2, CRL_REG_LEN_08BIT, 0x6d},
	{0x55a3, CRL_REG_LEN_08BIT, 0x55},
	{0x55a4, CRL_REG_LEN_08BIT, 0xc3},
	{0x55a5, CRL_REG_LEN_08BIT, 0xb5},
	{0x55a6, CRL_REG_LEN_08BIT, 0x43},
	{0x55a7, CRL_REG_LEN_08BIT, 0x38},
	{0x55a8, CRL_REG_LEN_08BIT, 0x5f},
	{0x55a9, CRL_REG_LEN_08BIT, 0x4b},
	{0x55aa, CRL_REG_LEN_08BIT, 0xf0},
	{0x55ab, CRL_REG_LEN_08BIT, 0x10},
	{0x5581, CRL_REG_LEN_08BIT, 0x52},
	{0x5300, CRL_REG_LEN_08BIT, 0x01},
	{0x5301, CRL_REG_LEN_08BIT, 0x00},
	{0x5302, CRL_REG_LEN_08BIT, 0x00},
	{0x5303, CRL_REG_LEN_08BIT, 0x0e},
	{0x5304, CRL_REG_LEN_08BIT, 0x00},
	{0x5305, CRL_REG_LEN_08BIT, 0x0e},
	{0x5306, CRL_REG_LEN_08BIT, 0x00},
	{0x5307, CRL_REG_LEN_08BIT, 0x36},
	{0x5308, CRL_REG_LEN_08BIT, 0x00},
	{0x5309, CRL_REG_LEN_08BIT, 0xd9},
	{0x530a, CRL_REG_LEN_08BIT, 0x00},
	{0x530b, CRL_REG_LEN_08BIT, 0x0f},
	{0x530c, CRL_REG_LEN_08BIT, 0x00},
	{0x530d, CRL_REG_LEN_08BIT, 0x2c},
	{0x530e, CRL_REG_LEN_08BIT, 0x00},
	{0x530f, CRL_REG_LEN_08BIT, 0x59},
	{0x5310, CRL_REG_LEN_08BIT, 0x00},
	{0x5311, CRL_REG_LEN_08BIT, 0x7b},
	{0x5312, CRL_REG_LEN_08BIT, 0x00},
	{0x5313, CRL_REG_LEN_08BIT, 0x22},
	{0x5314, CRL_REG_LEN_08BIT, 0x00},
	{0x5315, CRL_REG_LEN_08BIT, 0xd5},
	{0x5316, CRL_REG_LEN_08BIT, 0x00},
	{0x5317, CRL_REG_LEN_08BIT, 0x13},
	{0x5318, CRL_REG_LEN_08BIT, 0x00},
	{0x5319, CRL_REG_LEN_08BIT, 0x18},
	{0x531a, CRL_REG_LEN_08BIT, 0x00},
	{0x531b, CRL_REG_LEN_08BIT, 0x26},
	{0x531c, CRL_REG_LEN_08BIT, 0x00},
	{0x531d, CRL_REG_LEN_08BIT, 0xdc},
	{0x531e, CRL_REG_LEN_08BIT, 0x00},
	{0x531f, CRL_REG_LEN_08BIT, 0x02},
	{0x5320, CRL_REG_LEN_08BIT, 0x00},
	{0x5321, CRL_REG_LEN_08BIT, 0x24},
	{0x5322, CRL_REG_LEN_08BIT, 0x00},
	{0x5323, CRL_REG_LEN_08BIT, 0x56},
	{0x5324, CRL_REG_LEN_08BIT, 0x00},
	{0x5325, CRL_REG_LEN_08BIT, 0x85},
	{0x5326, CRL_REG_LEN_08BIT, 0x00},
	{0x5327, CRL_REG_LEN_08BIT, 0x20},
	{0x5609, CRL_REG_LEN_08BIT, 0x01},
	{0x560a, CRL_REG_LEN_08BIT, 0x40},
	{0x560b, CRL_REG_LEN_08BIT, 0x01},
	{0x560c, CRL_REG_LEN_08BIT, 0x40},
	{0x560d, CRL_REG_LEN_08BIT, 0x00},
	{0x560e, CRL_REG_LEN_08BIT, 0xfa},
	{0x560f, CRL_REG_LEN_08BIT, 0x00},
	{0x5610, CRL_REG_LEN_08BIT, 0xfa},
	{0x5611, CRL_REG_LEN_08BIT, 0x02},
	{0x5612, CRL_REG_LEN_08BIT, 0x80},
	{0x5613, CRL_REG_LEN_08BIT, 0x02},
	{0x5614, CRL_REG_LEN_08BIT, 0x80},
	{0x5615, CRL_REG_LEN_08BIT, 0x01},
	{0x5616, CRL_REG_LEN_08BIT, 0x2c},
	{0x5617, CRL_REG_LEN_08BIT, 0x01},
	{0x5618, CRL_REG_LEN_08BIT, 0x2c},
	{0x563b, CRL_REG_LEN_08BIT, 0x01},
	{0x563c, CRL_REG_LEN_08BIT, 0x01},
	{0x563d, CRL_REG_LEN_08BIT, 0x01},
	{0x563e, CRL_REG_LEN_08BIT, 0x01},
	{0x563f, CRL_REG_LEN_08BIT, 0x03},
	{0x5640, CRL_REG_LEN_08BIT, 0x03},
	{0x5641, CRL_REG_LEN_08BIT, 0x03},
	{0x5642, CRL_REG_LEN_08BIT, 0x05},
	{0x5643, CRL_REG_LEN_08BIT, 0x09},
	{0x5644, CRL_REG_LEN_08BIT, 0x05},
	{0x5645, CRL_REG_LEN_08BIT, 0x05},
	{0x5646, CRL_REG_LEN_08BIT, 0x05},
	{0x5647, CRL_REG_LEN_08BIT, 0x05},
	{0x5651, CRL_REG_LEN_08BIT, 0x00},
	{0x5652, CRL_REG_LEN_08BIT, 0x80},
	{0x521a, CRL_REG_LEN_08BIT, 0x01},
	{0x521b, CRL_REG_LEN_08BIT, 0x03},
	{0x521c, CRL_REG_LEN_08BIT, 0x06},
	{0x521d, CRL_REG_LEN_08BIT, 0x0a},
	{0x521e, CRL_REG_LEN_08BIT, 0x0e},
	{0x521f, CRL_REG_LEN_08BIT, 0x12},
	{0x5220, CRL_REG_LEN_08BIT, 0x16},
	{0x5223, CRL_REG_LEN_08BIT, 0x02},
	{0x5225, CRL_REG_LEN_08BIT, 0x04},
	{0x5227, CRL_REG_LEN_08BIT, 0x08},
	{0x5229, CRL_REG_LEN_08BIT, 0x0c},
	{0x522b, CRL_REG_LEN_08BIT, 0x12},
	{0x522d, CRL_REG_LEN_08BIT, 0x18},
	{0x522f, CRL_REG_LEN_08BIT, 0x1e},
	{0x5241, CRL_REG_LEN_08BIT, 0x04},
	{0x5242, CRL_REG_LEN_08BIT, 0x01},
	{0x5243, CRL_REG_LEN_08BIT, 0x03},
	{0x5244, CRL_REG_LEN_08BIT, 0x06},
	{0x5245, CRL_REG_LEN_08BIT, 0x0a},
	{0x5246, CRL_REG_LEN_08BIT, 0x0e},
	{0x5247, CRL_REG_LEN_08BIT, 0x12},
	{0x5248, CRL_REG_LEN_08BIT, 0x16},
	{0x524a, CRL_REG_LEN_08BIT, 0x03},
	{0x524c, CRL_REG_LEN_08BIT, 0x04},
	{0x524e, CRL_REG_LEN_08BIT, 0x08},
	{0x5250, CRL_REG_LEN_08BIT, 0x0c},
	{0x5252, CRL_REG_LEN_08BIT, 0x12},
	{0x5254, CRL_REG_LEN_08BIT, 0x18},
	{0x5256, CRL_REG_LEN_08BIT, 0x1e},
	{0x4606, CRL_REG_LEN_08BIT, 0x07},
	{0x4607, CRL_REG_LEN_08BIT, 0x71},
	{0x460a, CRL_REG_LEN_08BIT, 0x02},
	{0x460b, CRL_REG_LEN_08BIT, 0x70},
	{0x460c, CRL_REG_LEN_08BIT, 0x00},
	{0x4620, CRL_REG_LEN_08BIT, 0x0e},
	{0x4700, CRL_REG_LEN_08BIT, 0x04},
	{0x4701, CRL_REG_LEN_08BIT, 0x00},
	{0x4702, CRL_REG_LEN_08BIT, 0x01},
	{0x4004, CRL_REG_LEN_08BIT, 0x04},
	{0x4005, CRL_REG_LEN_08BIT, 0x18},
	{0x4001, CRL_REG_LEN_08BIT, 0x06},
	{0x4050, CRL_REG_LEN_08BIT, 0x22},
	{0x4051, CRL_REG_LEN_08BIT, 0x24},
	{0x4052, CRL_REG_LEN_08BIT, 0x02},
	{0x4057, CRL_REG_LEN_08BIT, 0x9c},
	{0x405a, CRL_REG_LEN_08BIT, 0x00},
	{0x3832, CRL_REG_LEN_08BIT, 0x00},
	{0x3833, CRL_REG_LEN_08BIT, 0x02},
	{0x3834, CRL_REG_LEN_08BIT, 0x03},
	{0x3835, CRL_REG_LEN_08BIT, 0x48},
	{0x302e, CRL_REG_LEN_08BIT, 0x00},
	{0x4202, CRL_REG_LEN_08BIT, 0x02},
	{0x3023, CRL_REG_LEN_08BIT, 0x10},
	{0x0100, CRL_REG_LEN_08BIT, 0x01},
	{0x0100, CRL_REG_LEN_08BIT, 0x01},
	{0x6f10, CRL_REG_LEN_08BIT, 0x07},
	{0x6f11, CRL_REG_LEN_08BIT, 0x82},
	{0x6f12, CRL_REG_LEN_08BIT, 0x04},
	{0x6f13, CRL_REG_LEN_08BIT, 0x00},
	{0x6f14, CRL_REG_LEN_08BIT, 0x1f},
	{0x6f15, CRL_REG_LEN_08BIT, 0xdd},
	{0x6f16, CRL_REG_LEN_08BIT, 0x04},
	{0x6f17, CRL_REG_LEN_08BIT, 0x04},
	{0x6f18, CRL_REG_LEN_08BIT, 0x36},
	{0x6f19, CRL_REG_LEN_08BIT, 0x66},
	{0x6f1a, CRL_REG_LEN_08BIT, 0x04},
	{0x6f1b, CRL_REG_LEN_08BIT, 0x08},
	{0x6f1c, CRL_REG_LEN_08BIT, 0x0c},
	{0x6f1d, CRL_REG_LEN_08BIT, 0xe7},
	{0x6f1e, CRL_REG_LEN_08BIT, 0x04},
	{0x6f1f, CRL_REG_LEN_08BIT, 0x0c},
	{0xd000, CRL_REG_LEN_08BIT, 0x19},
	{0xd001, CRL_REG_LEN_08BIT, 0xa0},
	{0xd002, CRL_REG_LEN_08BIT, 0x00},
	{0xd003, CRL_REG_LEN_08BIT, 0x01},
	{0xd004, CRL_REG_LEN_08BIT, 0xa9},
	{0xd005, CRL_REG_LEN_08BIT, 0xad},
	{0xd006, CRL_REG_LEN_08BIT, 0x10},
	{0xd007, CRL_REG_LEN_08BIT, 0x40},
	{0xd008, CRL_REG_LEN_08BIT, 0x44},
	{0xd009, CRL_REG_LEN_08BIT, 0x00},
	{0xd00a, CRL_REG_LEN_08BIT, 0x68},
	{0xd00b, CRL_REG_LEN_08BIT, 0x00},
	{0xd00c, CRL_REG_LEN_08BIT, 0x15},
	{0xd00d, CRL_REG_LEN_08BIT, 0x00},
	{0xd00e, CRL_REG_LEN_08BIT, 0x00},
	{0xd00f, CRL_REG_LEN_08BIT, 0x00},
	{0xd010, CRL_REG_LEN_08BIT, 0x19},
	{0xd011, CRL_REG_LEN_08BIT, 0xa0},
	{0xd012, CRL_REG_LEN_08BIT, 0x00},
	{0xd013, CRL_REG_LEN_08BIT, 0x01},
	{0xd014, CRL_REG_LEN_08BIT, 0xa9},
	{0xd015, CRL_REG_LEN_08BIT, 0xad},
	{0xd016, CRL_REG_LEN_08BIT, 0x13},
	{0xd017, CRL_REG_LEN_08BIT, 0xd0},
	{0xd018, CRL_REG_LEN_08BIT, 0x44},
	{0xd019, CRL_REG_LEN_08BIT, 0x00},
	{0xd01a, CRL_REG_LEN_08BIT, 0x68},
	{0xd01b, CRL_REG_LEN_08BIT, 0x00},
	{0xd01c, CRL_REG_LEN_08BIT, 0x15},
	{0xd01d, CRL_REG_LEN_08BIT, 0x00},
	{0xd01e, CRL_REG_LEN_08BIT, 0x00},
	{0xd01f, CRL_REG_LEN_08BIT, 0x00},
	{0xd020, CRL_REG_LEN_08BIT, 0x19},
	{0xd021, CRL_REG_LEN_08BIT, 0xa0},
	{0xd022, CRL_REG_LEN_08BIT, 0x00},
	{0xd023, CRL_REG_LEN_08BIT, 0x01},
	{0xd024, CRL_REG_LEN_08BIT, 0xa9},
	{0xd025, CRL_REG_LEN_08BIT, 0xad},
	{0xd026, CRL_REG_LEN_08BIT, 0x14},
	{0xd027, CRL_REG_LEN_08BIT, 0xb8},
	{0xd028, CRL_REG_LEN_08BIT, 0x44},
	{0xd029, CRL_REG_LEN_08BIT, 0x00},
	{0xd02a, CRL_REG_LEN_08BIT, 0x68},
	{0xd02b, CRL_REG_LEN_08BIT, 0x00},
	{0xd02c, CRL_REG_LEN_08BIT, 0x15},
	{0xd02d, CRL_REG_LEN_08BIT, 0x00},
	{0xd02e, CRL_REG_LEN_08BIT, 0x00},
	{0xd02f, CRL_REG_LEN_08BIT, 0x00},
	{0xd030, CRL_REG_LEN_08BIT, 0x19},
	{0xd031, CRL_REG_LEN_08BIT, 0xa0},
	{0xd032, CRL_REG_LEN_08BIT, 0x00},
	{0xd033, CRL_REG_LEN_08BIT, 0x01},
	{0xd034, CRL_REG_LEN_08BIT, 0xa9},
	{0xd035, CRL_REG_LEN_08BIT, 0xad},
	{0xd036, CRL_REG_LEN_08BIT, 0x14},
	{0xd037, CRL_REG_LEN_08BIT, 0xdc},
	{0xd038, CRL_REG_LEN_08BIT, 0x44},
	{0xd039, CRL_REG_LEN_08BIT, 0x00},
	{0xd03a, CRL_REG_LEN_08BIT, 0x68},
	{0xd03b, CRL_REG_LEN_08BIT, 0x00},
	{0xd03c, CRL_REG_LEN_08BIT, 0x15},
	{0xd03d, CRL_REG_LEN_08BIT, 0x00},
	{0xd03e, CRL_REG_LEN_08BIT, 0x00},
	{0xd03f, CRL_REG_LEN_08BIT, 0x00},
	{0xd040, CRL_REG_LEN_08BIT, 0x9c},
	{0xd041, CRL_REG_LEN_08BIT, 0x21},
	{0xd042, CRL_REG_LEN_08BIT, 0xff},
	{0xd043, CRL_REG_LEN_08BIT, 0xe4},
	{0xd044, CRL_REG_LEN_08BIT, 0xd4},
	{0xd045, CRL_REG_LEN_08BIT, 0x01},
	{0xd046, CRL_REG_LEN_08BIT, 0x48},
	{0xd047, CRL_REG_LEN_08BIT, 0x00},
	{0xd048, CRL_REG_LEN_08BIT, 0xd4},
	{0xd049, CRL_REG_LEN_08BIT, 0x01},
	{0xd04a, CRL_REG_LEN_08BIT, 0x50},
	{0xd04b, CRL_REG_LEN_08BIT, 0x04},
	{0xd04c, CRL_REG_LEN_08BIT, 0xd4},
	{0xd04d, CRL_REG_LEN_08BIT, 0x01},
	{0xd04e, CRL_REG_LEN_08BIT, 0x60},
	{0xd04f, CRL_REG_LEN_08BIT, 0x08},
	{0xd050, CRL_REG_LEN_08BIT, 0xd4},
	{0xd051, CRL_REG_LEN_08BIT, 0x01},
	{0xd052, CRL_REG_LEN_08BIT, 0x70},
	{0xd053, CRL_REG_LEN_08BIT, 0x0c},
	{0xd054, CRL_REG_LEN_08BIT, 0xd4},
	{0xd055, CRL_REG_LEN_08BIT, 0x01},
	{0xd056, CRL_REG_LEN_08BIT, 0x80},
	{0xd057, CRL_REG_LEN_08BIT, 0x10},
	{0xd058, CRL_REG_LEN_08BIT, 0x19},
	{0xd059, CRL_REG_LEN_08BIT, 0xc0},
	{0xd05a, CRL_REG_LEN_08BIT, 0x00},
	{0xd05b, CRL_REG_LEN_08BIT, 0x01},
	{0xd05c, CRL_REG_LEN_08BIT, 0xa9},
	{0xd05d, CRL_REG_LEN_08BIT, 0xce},
	{0xd05e, CRL_REG_LEN_08BIT, 0x02},
	{0xd05f, CRL_REG_LEN_08BIT, 0xa4},
	{0xd060, CRL_REG_LEN_08BIT, 0x9c},
	{0xd061, CRL_REG_LEN_08BIT, 0xa0},
	{0xd062, CRL_REG_LEN_08BIT, 0x00},
	{0xd063, CRL_REG_LEN_08BIT, 0x00},
	{0xd064, CRL_REG_LEN_08BIT, 0x84},
	{0xd065, CRL_REG_LEN_08BIT, 0x6e},
	{0xd066, CRL_REG_LEN_08BIT, 0x00},
	{0xd067, CRL_REG_LEN_08BIT, 0x00},
	{0xd068, CRL_REG_LEN_08BIT, 0xd8},
	{0xd069, CRL_REG_LEN_08BIT, 0x03},
	{0xd06a, CRL_REG_LEN_08BIT, 0x28},
	{0xd06b, CRL_REG_LEN_08BIT, 0x76},
	{0xd06c, CRL_REG_LEN_08BIT, 0x1a},
	{0xd06d, CRL_REG_LEN_08BIT, 0x00},
	{0xd06e, CRL_REG_LEN_08BIT, 0x00},
	{0xd06f, CRL_REG_LEN_08BIT, 0x01},
	{0xd070, CRL_REG_LEN_08BIT, 0xaa},
	{0xd071, CRL_REG_LEN_08BIT, 0x10},
	{0xd072, CRL_REG_LEN_08BIT, 0x03},
	{0xd073, CRL_REG_LEN_08BIT, 0xf0},
	{0xd074, CRL_REG_LEN_08BIT, 0x18},
	{0xd075, CRL_REG_LEN_08BIT, 0x60},
	{0xd076, CRL_REG_LEN_08BIT, 0x00},
	{0xd077, CRL_REG_LEN_08BIT, 0x01},
	{0xd078, CRL_REG_LEN_08BIT, 0xa8},
	{0xd079, CRL_REG_LEN_08BIT, 0x63},
	{0xd07a, CRL_REG_LEN_08BIT, 0x07},
	{0xd07b, CRL_REG_LEN_08BIT, 0x80},
	{0xd07c, CRL_REG_LEN_08BIT, 0xe0},
	{0xd07d, CRL_REG_LEN_08BIT, 0xa0},
	{0xd07e, CRL_REG_LEN_08BIT, 0x00},
	{0xd07f, CRL_REG_LEN_08BIT, 0x04},
	{0xd080, CRL_REG_LEN_08BIT, 0x18},
	{0xd081, CRL_REG_LEN_08BIT, 0xc0},
	{0xd082, CRL_REG_LEN_08BIT, 0x00},
	{0xd083, CRL_REG_LEN_08BIT, 0x00},
	{0xd084, CRL_REG_LEN_08BIT, 0xa8},
	{0xd085, CRL_REG_LEN_08BIT, 0xc6},
	{0xd086, CRL_REG_LEN_08BIT, 0x00},
	{0xd087, CRL_REG_LEN_08BIT, 0x00},
	{0xd088, CRL_REG_LEN_08BIT, 0x8c},
	{0xd089, CRL_REG_LEN_08BIT, 0x63},
	{0xd08a, CRL_REG_LEN_08BIT, 0x00},
	{0xd08b, CRL_REG_LEN_08BIT, 0x00},
	{0xd08c, CRL_REG_LEN_08BIT, 0xd4},
	{0xd08d, CRL_REG_LEN_08BIT, 0x01},
	{0xd08e, CRL_REG_LEN_08BIT, 0x28},
	{0xd08f, CRL_REG_LEN_08BIT, 0x14},
	{0xd090, CRL_REG_LEN_08BIT, 0xd4},
	{0xd091, CRL_REG_LEN_08BIT, 0x01},
	{0xd092, CRL_REG_LEN_08BIT, 0x30},
	{0xd093, CRL_REG_LEN_08BIT, 0x18},
	{0xd094, CRL_REG_LEN_08BIT, 0x07},
	{0xd095, CRL_REG_LEN_08BIT, 0xff},
	{0xd096, CRL_REG_LEN_08BIT, 0xf8},
	{0xd097, CRL_REG_LEN_08BIT, 0xfd},
	{0xd098, CRL_REG_LEN_08BIT, 0x9c},
	{0xd099, CRL_REG_LEN_08BIT, 0x80},
	{0xd09a, CRL_REG_LEN_08BIT, 0x00},
	{0xd09b, CRL_REG_LEN_08BIT, 0x03},
	{0xd09c, CRL_REG_LEN_08BIT, 0xa5},
	{0xd09d, CRL_REG_LEN_08BIT, 0x6b},
	{0xd09e, CRL_REG_LEN_08BIT, 0x00},
	{0xd09f, CRL_REG_LEN_08BIT, 0xff},
	{0xd0a0, CRL_REG_LEN_08BIT, 0x18},
	{0xd0a1, CRL_REG_LEN_08BIT, 0xc0},
	{0xd0a2, CRL_REG_LEN_08BIT, 0x00},
	{0xd0a3, CRL_REG_LEN_08BIT, 0x01},
	{0xd0a4, CRL_REG_LEN_08BIT, 0xa8},
	{0xd0a5, CRL_REG_LEN_08BIT, 0xc6},
	{0xd0a6, CRL_REG_LEN_08BIT, 0x01},
	{0xd0a7, CRL_REG_LEN_08BIT, 0x02},
	{0xd0a8, CRL_REG_LEN_08BIT, 0xe1},
	{0xd0a9, CRL_REG_LEN_08BIT, 0x6b},
	{0xd0aa, CRL_REG_LEN_08BIT, 0x58},
	{0xd0ab, CRL_REG_LEN_08BIT, 0x00},
	{0xd0ac, CRL_REG_LEN_08BIT, 0x84},
	{0xd0ad, CRL_REG_LEN_08BIT, 0x8e},
	{0xd0ae, CRL_REG_LEN_08BIT, 0x00},
	{0xd0af, CRL_REG_LEN_08BIT, 0x00},
	{0xd0b0, CRL_REG_LEN_08BIT, 0xe1},
	{0xd0b1, CRL_REG_LEN_08BIT, 0x6b},
	{0xd0b2, CRL_REG_LEN_08BIT, 0x30},
	{0xd0b3, CRL_REG_LEN_08BIT, 0x00},
	{0xd0b4, CRL_REG_LEN_08BIT, 0x98},
	{0xd0b5, CRL_REG_LEN_08BIT, 0xb0},
	{0xd0b6, CRL_REG_LEN_08BIT, 0x00},
	{0xd0b7, CRL_REG_LEN_08BIT, 0x00},
	{0xd0b8, CRL_REG_LEN_08BIT, 0x8c},
	{0xd0b9, CRL_REG_LEN_08BIT, 0x64},
	{0xd0ba, CRL_REG_LEN_08BIT, 0x00},
	{0xd0bb, CRL_REG_LEN_08BIT, 0x6e},
	{0xd0bc, CRL_REG_LEN_08BIT, 0xe5},
	{0xd0bd, CRL_REG_LEN_08BIT, 0xa5},
	{0xd0be, CRL_REG_LEN_08BIT, 0x18},
	{0xd0bf, CRL_REG_LEN_08BIT, 0x00},
	{0xd0c0, CRL_REG_LEN_08BIT, 0x10},
	{0xd0c1, CRL_REG_LEN_08BIT, 0x00},
	{0xd0c2, CRL_REG_LEN_08BIT, 0x00},
	{0xd0c3, CRL_REG_LEN_08BIT, 0x06},
	{0xd0c4, CRL_REG_LEN_08BIT, 0x95},
	{0xd0c5, CRL_REG_LEN_08BIT, 0x8b},
	{0xd0c6, CRL_REG_LEN_08BIT, 0x00},
	{0xd0c7, CRL_REG_LEN_08BIT, 0x00},
	{0xd0c8, CRL_REG_LEN_08BIT, 0x94},
	{0xd0c9, CRL_REG_LEN_08BIT, 0xa4},
	{0xd0ca, CRL_REG_LEN_08BIT, 0x00},
	{0xd0cb, CRL_REG_LEN_08BIT, 0x70},
	{0xd0cc, CRL_REG_LEN_08BIT, 0xe5},
	{0xd0cd, CRL_REG_LEN_08BIT, 0x65},
	{0xd0ce, CRL_REG_LEN_08BIT, 0x60},
	{0xd0cf, CRL_REG_LEN_08BIT, 0x00},
	{0xd0d0, CRL_REG_LEN_08BIT, 0x0c},
	{0xd0d1, CRL_REG_LEN_08BIT, 0x00},
	{0xd0d2, CRL_REG_LEN_08BIT, 0x00},
	{0xd0d3, CRL_REG_LEN_08BIT, 0x62},
	{0xd0d4, CRL_REG_LEN_08BIT, 0x15},
	{0xd0d5, CRL_REG_LEN_08BIT, 0x00},
	{0xd0d6, CRL_REG_LEN_08BIT, 0x00},
	{0xd0d7, CRL_REG_LEN_08BIT, 0x00},
	{0xd0d8, CRL_REG_LEN_08BIT, 0x18},
	{0xd0d9, CRL_REG_LEN_08BIT, 0x60},
	{0xd0da, CRL_REG_LEN_08BIT, 0x80},
	{0xd0db, CRL_REG_LEN_08BIT, 0x06},
	{0xd0dc, CRL_REG_LEN_08BIT, 0xa8},
	{0xd0dd, CRL_REG_LEN_08BIT, 0x83},
	{0xd0de, CRL_REG_LEN_08BIT, 0x38},
	{0xd0df, CRL_REG_LEN_08BIT, 0x29},
	{0xd0e0, CRL_REG_LEN_08BIT, 0xa8},
	{0xd0e1, CRL_REG_LEN_08BIT, 0xe3},
	{0xd0e2, CRL_REG_LEN_08BIT, 0x40},
	{0xd0e3, CRL_REG_LEN_08BIT, 0x08},
	{0xd0e4, CRL_REG_LEN_08BIT, 0x8c},
	{0xd0e5, CRL_REG_LEN_08BIT, 0x84},
	{0xd0e6, CRL_REG_LEN_08BIT, 0x00},
	{0xd0e7, CRL_REG_LEN_08BIT, 0x00},
	{0xd0e8, CRL_REG_LEN_08BIT, 0xa8},
	{0xd0e9, CRL_REG_LEN_08BIT, 0xa3},
	{0xd0ea, CRL_REG_LEN_08BIT, 0x40},
	{0xd0eb, CRL_REG_LEN_08BIT, 0x09},
	{0xd0ec, CRL_REG_LEN_08BIT, 0xa8},
	{0xd0ed, CRL_REG_LEN_08BIT, 0xc3},
	{0xd0ee, CRL_REG_LEN_08BIT, 0x38},
	{0xd0ef, CRL_REG_LEN_08BIT, 0x2a},
	{0xd0f0, CRL_REG_LEN_08BIT, 0xd8},
	{0xd0f1, CRL_REG_LEN_08BIT, 0x07},
	{0xd0f2, CRL_REG_LEN_08BIT, 0x20},
	{0xd0f3, CRL_REG_LEN_08BIT, 0x00},
	{0xd0f4, CRL_REG_LEN_08BIT, 0x8c},
	{0xd0f5, CRL_REG_LEN_08BIT, 0x66},
	{0xd0f6, CRL_REG_LEN_08BIT, 0x00},
	{0xd0f7, CRL_REG_LEN_08BIT, 0x00},
	{0xd0f8, CRL_REG_LEN_08BIT, 0xd8},
	{0xd0f9, CRL_REG_LEN_08BIT, 0x05},
	{0xd0fa, CRL_REG_LEN_08BIT, 0x18},
	{0xd0fb, CRL_REG_LEN_08BIT, 0x00},
	{0xd0fc, CRL_REG_LEN_08BIT, 0x18},
	{0xd0fd, CRL_REG_LEN_08BIT, 0x60},
	{0xd0fe, CRL_REG_LEN_08BIT, 0x00},
	{0xd0ff, CRL_REG_LEN_08BIT, 0x01},
	{0xd100, CRL_REG_LEN_08BIT, 0x98},
	{0xd101, CRL_REG_LEN_08BIT, 0x90},
	{0xd102, CRL_REG_LEN_08BIT, 0x00},
	{0xd103, CRL_REG_LEN_08BIT, 0x00},
	{0xd104, CRL_REG_LEN_08BIT, 0x84},
	{0xd105, CRL_REG_LEN_08BIT, 0xae},
	{0xd106, CRL_REG_LEN_08BIT, 0x00},
	{0xd107, CRL_REG_LEN_08BIT, 0x00},
	{0xd108, CRL_REG_LEN_08BIT, 0xa8},
	{0xd109, CRL_REG_LEN_08BIT, 0x63},
	{0xd10a, CRL_REG_LEN_08BIT, 0x06},
	{0xd10b, CRL_REG_LEN_08BIT, 0x4c},
	{0xd10c, CRL_REG_LEN_08BIT, 0x9c},
	{0xd10d, CRL_REG_LEN_08BIT, 0xc0},
	{0xd10e, CRL_REG_LEN_08BIT, 0x00},
	{0xd10f, CRL_REG_LEN_08BIT, 0x00},
	{0xd110, CRL_REG_LEN_08BIT, 0xd8},
	{0xd111, CRL_REG_LEN_08BIT, 0x03},
	{0xd112, CRL_REG_LEN_08BIT, 0x30},
	{0xd113, CRL_REG_LEN_08BIT, 0x00},
	{0xd114, CRL_REG_LEN_08BIT, 0x8c},
	{0xd115, CRL_REG_LEN_08BIT, 0x65},
	{0xd116, CRL_REG_LEN_08BIT, 0x00},
	{0xd117, CRL_REG_LEN_08BIT, 0x6e},
	{0xd118, CRL_REG_LEN_08BIT, 0xe5},
	{0xd119, CRL_REG_LEN_08BIT, 0x84},
	{0xd11a, CRL_REG_LEN_08BIT, 0x18},
	{0xd11b, CRL_REG_LEN_08BIT, 0x00},
	{0xd11c, CRL_REG_LEN_08BIT, 0x10},
	{0xd11d, CRL_REG_LEN_08BIT, 0x00},
	{0xd11e, CRL_REG_LEN_08BIT, 0x00},
	{0xd11f, CRL_REG_LEN_08BIT, 0x07},
	{0xd120, CRL_REG_LEN_08BIT, 0x18},
	{0xd121, CRL_REG_LEN_08BIT, 0x80},
	{0xd122, CRL_REG_LEN_08BIT, 0x80},
	{0xd123, CRL_REG_LEN_08BIT, 0x06},
	{0xd124, CRL_REG_LEN_08BIT, 0x94},
	{0xd125, CRL_REG_LEN_08BIT, 0x65},
	{0xd126, CRL_REG_LEN_08BIT, 0x00},
	{0xd127, CRL_REG_LEN_08BIT, 0x70},
	{0xd128, CRL_REG_LEN_08BIT, 0xe5},
	{0xd129, CRL_REG_LEN_08BIT, 0x43},
	{0xd12a, CRL_REG_LEN_08BIT, 0x60},
	{0xd12b, CRL_REG_LEN_08BIT, 0x00},
	{0xd12c, CRL_REG_LEN_08BIT, 0x0c},
	{0xd12d, CRL_REG_LEN_08BIT, 0x00},
	{0xd12e, CRL_REG_LEN_08BIT, 0x00},
	{0xd12f, CRL_REG_LEN_08BIT, 0x3e},
	{0xd130, CRL_REG_LEN_08BIT, 0xa8},
	{0xd131, CRL_REG_LEN_08BIT, 0x64},
	{0xd132, CRL_REG_LEN_08BIT, 0x38},
	{0xd133, CRL_REG_LEN_08BIT, 0x24},
	{0xd134, CRL_REG_LEN_08BIT, 0x18},
	{0xd135, CRL_REG_LEN_08BIT, 0x80},
	{0xd136, CRL_REG_LEN_08BIT, 0x80},
	{0xd137, CRL_REG_LEN_08BIT, 0x06},
	{0xd138, CRL_REG_LEN_08BIT, 0xa8},
	{0xd139, CRL_REG_LEN_08BIT, 0x64},
	{0xd13a, CRL_REG_LEN_08BIT, 0x38},
	{0xd13b, CRL_REG_LEN_08BIT, 0x24},
	{0xd13c, CRL_REG_LEN_08BIT, 0x8c},
	{0xd13d, CRL_REG_LEN_08BIT, 0x63},
	{0xd13e, CRL_REG_LEN_08BIT, 0x00},
	{0xd13f, CRL_REG_LEN_08BIT, 0x00},
	{0xd140, CRL_REG_LEN_08BIT, 0xa4},
	{0xd141, CRL_REG_LEN_08BIT, 0x63},
	{0xd142, CRL_REG_LEN_08BIT, 0x00},
	{0xd143, CRL_REG_LEN_08BIT, 0x40},
	{0xd144, CRL_REG_LEN_08BIT, 0xbc},
	{0xd145, CRL_REG_LEN_08BIT, 0x23},
	{0xd146, CRL_REG_LEN_08BIT, 0x00},
	{0xd147, CRL_REG_LEN_08BIT, 0x00},
	{0xd148, CRL_REG_LEN_08BIT, 0x0c},
	{0xd149, CRL_REG_LEN_08BIT, 0x00},
	{0xd14a, CRL_REG_LEN_08BIT, 0x00},
	{0xd14b, CRL_REG_LEN_08BIT, 0x2a},
	{0xd14c, CRL_REG_LEN_08BIT, 0xa8},
	{0xd14d, CRL_REG_LEN_08BIT, 0x64},
	{0xd14e, CRL_REG_LEN_08BIT, 0x6e},
	{0xd14f, CRL_REG_LEN_08BIT, 0x44},
	{0xd150, CRL_REG_LEN_08BIT, 0x19},
	{0xd151, CRL_REG_LEN_08BIT, 0x00},
	{0xd152, CRL_REG_LEN_08BIT, 0x80},
	{0xd153, CRL_REG_LEN_08BIT, 0x06},
	{0xd154, CRL_REG_LEN_08BIT, 0xa8},
	{0xd155, CRL_REG_LEN_08BIT, 0xe8},
	{0xd156, CRL_REG_LEN_08BIT, 0x3d},
	{0xd157, CRL_REG_LEN_08BIT, 0x05},
	{0xd158, CRL_REG_LEN_08BIT, 0x8c},
	{0xd159, CRL_REG_LEN_08BIT, 0x67},
	{0xd15a, CRL_REG_LEN_08BIT, 0x00},
	{0xd15b, CRL_REG_LEN_08BIT, 0x00},
	{0xd15c, CRL_REG_LEN_08BIT, 0xb8},
	{0xd15d, CRL_REG_LEN_08BIT, 0x63},
	{0xd15e, CRL_REG_LEN_08BIT, 0x00},
	{0xd15f, CRL_REG_LEN_08BIT, 0x18},
	{0xd160, CRL_REG_LEN_08BIT, 0xb8},
	{0xd161, CRL_REG_LEN_08BIT, 0x63},
	{0xd162, CRL_REG_LEN_08BIT, 0x00},
	{0xd163, CRL_REG_LEN_08BIT, 0x98},
	{0xd164, CRL_REG_LEN_08BIT, 0xbc},
	{0xd165, CRL_REG_LEN_08BIT, 0x03},
	{0xd166, CRL_REG_LEN_08BIT, 0x00},
	{0xd167, CRL_REG_LEN_08BIT, 0x00},
	{0xd168, CRL_REG_LEN_08BIT, 0x10},
	{0xd169, CRL_REG_LEN_08BIT, 0x00},
	{0xd16a, CRL_REG_LEN_08BIT, 0x00},
	{0xd16b, CRL_REG_LEN_08BIT, 0x10},
	{0xd16c, CRL_REG_LEN_08BIT, 0xa9},
	{0xd16d, CRL_REG_LEN_08BIT, 0x48},
	{0xd16e, CRL_REG_LEN_08BIT, 0x67},
	{0xd16f, CRL_REG_LEN_08BIT, 0x02},
	{0xd170, CRL_REG_LEN_08BIT, 0xb8},
	{0xd171, CRL_REG_LEN_08BIT, 0xa3},
	{0xd172, CRL_REG_LEN_08BIT, 0x00},
	{0xd173, CRL_REG_LEN_08BIT, 0x19},
	{0xd174, CRL_REG_LEN_08BIT, 0x8c},
	{0xd175, CRL_REG_LEN_08BIT, 0x8a},
	{0xd176, CRL_REG_LEN_08BIT, 0x00},
	{0xd177, CRL_REG_LEN_08BIT, 0x00},
	{0xd178, CRL_REG_LEN_08BIT, 0xa9},
	{0xd179, CRL_REG_LEN_08BIT, 0x68},
	{0xd17a, CRL_REG_LEN_08BIT, 0x67},
	{0xd17b, CRL_REG_LEN_08BIT, 0x03},
	{0xd17c, CRL_REG_LEN_08BIT, 0xb8},
	{0xd17d, CRL_REG_LEN_08BIT, 0xc4},
	{0xd17e, CRL_REG_LEN_08BIT, 0x00},
	{0xd17f, CRL_REG_LEN_08BIT, 0x08},
	{0xd180, CRL_REG_LEN_08BIT, 0x8c},
	{0xd181, CRL_REG_LEN_08BIT, 0x6b},
	{0xd182, CRL_REG_LEN_08BIT, 0x00},
	{0xd183, CRL_REG_LEN_08BIT, 0x00},
	{0xd184, CRL_REG_LEN_08BIT, 0xb8},
	{0xd185, CRL_REG_LEN_08BIT, 0x85},
	{0xd186, CRL_REG_LEN_08BIT, 0x00},
	{0xd187, CRL_REG_LEN_08BIT, 0x98},
	{0xd188, CRL_REG_LEN_08BIT, 0xe0},
	{0xd189, CRL_REG_LEN_08BIT, 0x63},
	{0xd18a, CRL_REG_LEN_08BIT, 0x30},
	{0xd18b, CRL_REG_LEN_08BIT, 0x04},
	{0xd18c, CRL_REG_LEN_08BIT, 0xe0},
	{0xd18d, CRL_REG_LEN_08BIT, 0x64},
	{0xd18e, CRL_REG_LEN_08BIT, 0x18},
	{0xd18f, CRL_REG_LEN_08BIT, 0x00},
	{0xd190, CRL_REG_LEN_08BIT, 0xa4},
	{0xd191, CRL_REG_LEN_08BIT, 0x83},
	{0xd192, CRL_REG_LEN_08BIT, 0xff},
	{0xd193, CRL_REG_LEN_08BIT, 0xff},
	{0xd194, CRL_REG_LEN_08BIT, 0xb8},
	{0xd195, CRL_REG_LEN_08BIT, 0x64},
	{0xd196, CRL_REG_LEN_08BIT, 0x00},
	{0xd197, CRL_REG_LEN_08BIT, 0x48},
	{0xd198, CRL_REG_LEN_08BIT, 0xd8},
	{0xd199, CRL_REG_LEN_08BIT, 0x0a},
	{0xd19a, CRL_REG_LEN_08BIT, 0x18},
	{0xd19b, CRL_REG_LEN_08BIT, 0x00},
	{0xd19c, CRL_REG_LEN_08BIT, 0xd8},
	{0xd19d, CRL_REG_LEN_08BIT, 0x0b},
	{0xd19e, CRL_REG_LEN_08BIT, 0x20},
	{0xd19f, CRL_REG_LEN_08BIT, 0x00},
	{0xd1a0, CRL_REG_LEN_08BIT, 0x9c},
	{0xd1a1, CRL_REG_LEN_08BIT, 0x60},
	{0xd1a2, CRL_REG_LEN_08BIT, 0x00},
	{0xd1a3, CRL_REG_LEN_08BIT, 0x00},
	{0xd1a4, CRL_REG_LEN_08BIT, 0xd8},
	{0xd1a5, CRL_REG_LEN_08BIT, 0x07},
	{0xd1a6, CRL_REG_LEN_08BIT, 0x18},
	{0xd1a7, CRL_REG_LEN_08BIT, 0x00},
	{0xd1a8, CRL_REG_LEN_08BIT, 0xa8},
	{0xd1a9, CRL_REG_LEN_08BIT, 0x68},
	{0xd1aa, CRL_REG_LEN_08BIT, 0x38},
	{0xd1ab, CRL_REG_LEN_08BIT, 0x22},
	{0xd1ac, CRL_REG_LEN_08BIT, 0x9c},
	{0xd1ad, CRL_REG_LEN_08BIT, 0x80},
	{0xd1ae, CRL_REG_LEN_08BIT, 0x00},
	{0xd1af, CRL_REG_LEN_08BIT, 0x70},
	{0xd1b0, CRL_REG_LEN_08BIT, 0xa8},
	{0xd1b1, CRL_REG_LEN_08BIT, 0xe8},
	{0xd1b2, CRL_REG_LEN_08BIT, 0x38},
	{0xd1b3, CRL_REG_LEN_08BIT, 0x43},
	{0xd1b4, CRL_REG_LEN_08BIT, 0xd8},
	{0xd1b5, CRL_REG_LEN_08BIT, 0x03},
	{0xd1b6, CRL_REG_LEN_08BIT, 0x20},
	{0xd1b7, CRL_REG_LEN_08BIT, 0x00},
	{0xd1b8, CRL_REG_LEN_08BIT, 0x9c},
	{0xd1b9, CRL_REG_LEN_08BIT, 0xa0},
	{0xd1ba, CRL_REG_LEN_08BIT, 0x00},
	{0xd1bb, CRL_REG_LEN_08BIT, 0x00},
	{0xd1bc, CRL_REG_LEN_08BIT, 0xa8},
	{0xd1bd, CRL_REG_LEN_08BIT, 0xc8},
	{0xd1be, CRL_REG_LEN_08BIT, 0x38},
	{0xd1bf, CRL_REG_LEN_08BIT, 0x42},
	{0xd1c0, CRL_REG_LEN_08BIT, 0x8c},
	{0xd1c1, CRL_REG_LEN_08BIT, 0x66},
	{0xd1c2, CRL_REG_LEN_08BIT, 0x00},
	{0xd1c3, CRL_REG_LEN_08BIT, 0x00},
	{0xd1c4, CRL_REG_LEN_08BIT, 0x9c},
	{0xd1c5, CRL_REG_LEN_08BIT, 0xa5},
	{0xd1c6, CRL_REG_LEN_08BIT, 0x00},
	{0xd1c7, CRL_REG_LEN_08BIT, 0x01},
	{0xd1c8, CRL_REG_LEN_08BIT, 0xb8},
	{0xd1c9, CRL_REG_LEN_08BIT, 0x83},
	{0xd1ca, CRL_REG_LEN_08BIT, 0x00},
	{0xd1cb, CRL_REG_LEN_08BIT, 0x08},
	{0xd1cc, CRL_REG_LEN_08BIT, 0xa4},
	{0xd1cd, CRL_REG_LEN_08BIT, 0xa5},
	{0xd1ce, CRL_REG_LEN_08BIT, 0x00},
	{0xd1cf, CRL_REG_LEN_08BIT, 0xff},
	{0xd1d0, CRL_REG_LEN_08BIT, 0x8c},
	{0xd1d1, CRL_REG_LEN_08BIT, 0x67},
	{0xd1d2, CRL_REG_LEN_08BIT, 0x00},
	{0xd1d3, CRL_REG_LEN_08BIT, 0x00},
	{0xd1d4, CRL_REG_LEN_08BIT, 0xe0},
	{0xd1d5, CRL_REG_LEN_08BIT, 0x63},
	{0xd1d6, CRL_REG_LEN_08BIT, 0x20},
	{0xd1d7, CRL_REG_LEN_08BIT, 0x00},
	{0xd1d8, CRL_REG_LEN_08BIT, 0xa4},
	{0xd1d9, CRL_REG_LEN_08BIT, 0x63},
	{0xd1da, CRL_REG_LEN_08BIT, 0xff},
	{0xd1db, CRL_REG_LEN_08BIT, 0xff},
	{0xd1dc, CRL_REG_LEN_08BIT, 0xbc},
	{0xd1dd, CRL_REG_LEN_08BIT, 0x43},
	{0xd1de, CRL_REG_LEN_08BIT, 0x00},
	{0xd1df, CRL_REG_LEN_08BIT, 0x07},
	{0xd1e0, CRL_REG_LEN_08BIT, 0x0c},
	{0xd1e1, CRL_REG_LEN_08BIT, 0x00},
	{0xd1e2, CRL_REG_LEN_08BIT, 0x00},
	{0xd1e3, CRL_REG_LEN_08BIT, 0x5b},
	{0xd1e4, CRL_REG_LEN_08BIT, 0xbc},
	{0xd1e5, CRL_REG_LEN_08BIT, 0x05},
	{0xd1e6, CRL_REG_LEN_08BIT, 0x00},
	{0xd1e7, CRL_REG_LEN_08BIT, 0x02},
	{0xd1e8, CRL_REG_LEN_08BIT, 0x03},
	{0xd1e9, CRL_REG_LEN_08BIT, 0xff},
	{0xd1ea, CRL_REG_LEN_08BIT, 0xff},
	{0xd1eb, CRL_REG_LEN_08BIT, 0xf6},
	{0xd1ec, CRL_REG_LEN_08BIT, 0x9c},
	{0xd1ed, CRL_REG_LEN_08BIT, 0xa0},
	{0xd1ee, CRL_REG_LEN_08BIT, 0x00},
	{0xd1ef, CRL_REG_LEN_08BIT, 0x00},
	{0xd1f0, CRL_REG_LEN_08BIT, 0xa8},
	{0xd1f1, CRL_REG_LEN_08BIT, 0xa4},
	{0xd1f2, CRL_REG_LEN_08BIT, 0x55},
	{0xd1f3, CRL_REG_LEN_08BIT, 0x86},
	{0xd1f4, CRL_REG_LEN_08BIT, 0x8c},
	{0xd1f5, CRL_REG_LEN_08BIT, 0x63},
	{0xd1f6, CRL_REG_LEN_08BIT, 0x00},
	{0xd1f7, CRL_REG_LEN_08BIT, 0x00},
	{0xd1f8, CRL_REG_LEN_08BIT, 0xa8},
	{0xd1f9, CRL_REG_LEN_08BIT, 0xc4},
	{0xd1fa, CRL_REG_LEN_08BIT, 0x6e},
	{0xd1fb, CRL_REG_LEN_08BIT, 0x45},
	{0xd1fc, CRL_REG_LEN_08BIT, 0xa8},
	{0xd1fd, CRL_REG_LEN_08BIT, 0xe4},
	{0xd1fe, CRL_REG_LEN_08BIT, 0x55},
	{0xd1ff, CRL_REG_LEN_08BIT, 0x87},
	{0xd200, CRL_REG_LEN_08BIT, 0xd8},
	{0xd201, CRL_REG_LEN_08BIT, 0x05},
	{0xd202, CRL_REG_LEN_08BIT, 0x18},
	{0xd203, CRL_REG_LEN_08BIT, 0x00},
	{0xd204, CRL_REG_LEN_08BIT, 0x8c},
	{0xd205, CRL_REG_LEN_08BIT, 0x66},
	{0xd206, CRL_REG_LEN_08BIT, 0x00},
	{0xd207, CRL_REG_LEN_08BIT, 0x00},
	{0xd208, CRL_REG_LEN_08BIT, 0xa8},
	{0xd209, CRL_REG_LEN_08BIT, 0xa4},
	{0xd20a, CRL_REG_LEN_08BIT, 0x6e},
	{0xd20b, CRL_REG_LEN_08BIT, 0x46},
	{0xd20c, CRL_REG_LEN_08BIT, 0xd8},
	{0xd20d, CRL_REG_LEN_08BIT, 0x07},
	{0xd20e, CRL_REG_LEN_08BIT, 0x18},
	{0xd20f, CRL_REG_LEN_08BIT, 0x00},
	{0xd210, CRL_REG_LEN_08BIT, 0xa8},
	{0xd211, CRL_REG_LEN_08BIT, 0x84},
	{0xd212, CRL_REG_LEN_08BIT, 0x55},
	{0xd213, CRL_REG_LEN_08BIT, 0x88},
	{0xd214, CRL_REG_LEN_08BIT, 0x8c},
	{0xd215, CRL_REG_LEN_08BIT, 0x65},
	{0xd216, CRL_REG_LEN_08BIT, 0x00},
	{0xd217, CRL_REG_LEN_08BIT, 0x00},
	{0xd218, CRL_REG_LEN_08BIT, 0xd8},
	{0xd219, CRL_REG_LEN_08BIT, 0x04},
	{0xd21a, CRL_REG_LEN_08BIT, 0x18},
	{0xd21b, CRL_REG_LEN_08BIT, 0x00},
	{0xd21c, CRL_REG_LEN_08BIT, 0x03},
	{0xd21d, CRL_REG_LEN_08BIT, 0xff},
	{0xd21e, CRL_REG_LEN_08BIT, 0xff},
	{0xd21f, CRL_REG_LEN_08BIT, 0xce},
	{0xd220, CRL_REG_LEN_08BIT, 0x19},
	{0xd221, CRL_REG_LEN_08BIT, 0x00},
	{0xd222, CRL_REG_LEN_08BIT, 0x80},
	{0xd223, CRL_REG_LEN_08BIT, 0x06},
	{0xd224, CRL_REG_LEN_08BIT, 0x8c},
	{0xd225, CRL_REG_LEN_08BIT, 0x63},
	{0xd226, CRL_REG_LEN_08BIT, 0x00},
	{0xd227, CRL_REG_LEN_08BIT, 0x00},
	{0xd228, CRL_REG_LEN_08BIT, 0xa4},
	{0xd229, CRL_REG_LEN_08BIT, 0x63},
	{0xd22a, CRL_REG_LEN_08BIT, 0x00},
	{0xd22b, CRL_REG_LEN_08BIT, 0x40},
	{0xd22c, CRL_REG_LEN_08BIT, 0xbc},
	{0xd22d, CRL_REG_LEN_08BIT, 0x23},
	{0xd22e, CRL_REG_LEN_08BIT, 0x00},
	{0xd22f, CRL_REG_LEN_08BIT, 0x00},
	{0xd230, CRL_REG_LEN_08BIT, 0x13},
	{0xd231, CRL_REG_LEN_08BIT, 0xff},
	{0xd232, CRL_REG_LEN_08BIT, 0xff},
	{0xd233, CRL_REG_LEN_08BIT, 0xc8},
	{0xd234, CRL_REG_LEN_08BIT, 0x9d},
	{0xd235, CRL_REG_LEN_08BIT, 0x00},
	{0xd236, CRL_REG_LEN_08BIT, 0x00},
	{0xd237, CRL_REG_LEN_08BIT, 0x40},
	{0xd238, CRL_REG_LEN_08BIT, 0xa8},
	{0xd239, CRL_REG_LEN_08BIT, 0x64},
	{0xd23a, CRL_REG_LEN_08BIT, 0x55},
	{0xd23b, CRL_REG_LEN_08BIT, 0x86},
	{0xd23c, CRL_REG_LEN_08BIT, 0xa8},
	{0xd23d, CRL_REG_LEN_08BIT, 0xa4},
	{0xd23e, CRL_REG_LEN_08BIT, 0x55},
	{0xd23f, CRL_REG_LEN_08BIT, 0x87},
	{0xd240, CRL_REG_LEN_08BIT, 0xd8},
	{0xd241, CRL_REG_LEN_08BIT, 0x03},
	{0xd242, CRL_REG_LEN_08BIT, 0x40},
	{0xd243, CRL_REG_LEN_08BIT, 0x00},
	{0xd244, CRL_REG_LEN_08BIT, 0xa8},
	{0xd245, CRL_REG_LEN_08BIT, 0x64},
	{0xd246, CRL_REG_LEN_08BIT, 0x55},
	{0xd247, CRL_REG_LEN_08BIT, 0x88},
	{0xd248, CRL_REG_LEN_08BIT, 0xd8},
	{0xd249, CRL_REG_LEN_08BIT, 0x05},
	{0xd24a, CRL_REG_LEN_08BIT, 0x40},
	{0xd24b, CRL_REG_LEN_08BIT, 0x00},
	{0xd24c, CRL_REG_LEN_08BIT, 0xd8},
	{0xd24d, CRL_REG_LEN_08BIT, 0x03},
	{0xd24e, CRL_REG_LEN_08BIT, 0x40},
	{0xd24f, CRL_REG_LEN_08BIT, 0x00},
	{0xd250, CRL_REG_LEN_08BIT, 0x03},
	{0xd251, CRL_REG_LEN_08BIT, 0xff},
	{0xd252, CRL_REG_LEN_08BIT, 0xff},
	{0xd253, CRL_REG_LEN_08BIT, 0xc1},
	{0xd254, CRL_REG_LEN_08BIT, 0x19},
	{0xd255, CRL_REG_LEN_08BIT, 0x00},
	{0xd256, CRL_REG_LEN_08BIT, 0x80},
	{0xd257, CRL_REG_LEN_08BIT, 0x06},
	{0xd258, CRL_REG_LEN_08BIT, 0x94},
	{0xd259, CRL_REG_LEN_08BIT, 0x84},
	{0xd25a, CRL_REG_LEN_08BIT, 0x00},
	{0xd25b, CRL_REG_LEN_08BIT, 0x72},
	{0xd25c, CRL_REG_LEN_08BIT, 0xe5},
	{0xd25d, CRL_REG_LEN_08BIT, 0xa4},
	{0xd25e, CRL_REG_LEN_08BIT, 0x60},
	{0xd25f, CRL_REG_LEN_08BIT, 0x00},
	{0xd260, CRL_REG_LEN_08BIT, 0x0c},
	{0xd261, CRL_REG_LEN_08BIT, 0x00},
	{0xd262, CRL_REG_LEN_08BIT, 0x00},
	{0xd263, CRL_REG_LEN_08BIT, 0x3f},
	{0xd264, CRL_REG_LEN_08BIT, 0x9d},
	{0xd265, CRL_REG_LEN_08BIT, 0x60},
	{0xd266, CRL_REG_LEN_08BIT, 0x01},
	{0xd267, CRL_REG_LEN_08BIT, 0x00},
	{0xd268, CRL_REG_LEN_08BIT, 0x85},
	{0xd269, CRL_REG_LEN_08BIT, 0x4e},
	{0xd26a, CRL_REG_LEN_08BIT, 0x00},
	{0xd26b, CRL_REG_LEN_08BIT, 0x00},
	{0xd26c, CRL_REG_LEN_08BIT, 0x98},
	{0xd26d, CRL_REG_LEN_08BIT, 0x70},
	{0xd26e, CRL_REG_LEN_08BIT, 0x00},
	{0xd26f, CRL_REG_LEN_08BIT, 0x00},
	{0xd270, CRL_REG_LEN_08BIT, 0x8c},
	{0xd271, CRL_REG_LEN_08BIT, 0x8a},
	{0xd272, CRL_REG_LEN_08BIT, 0x00},
	{0xd273, CRL_REG_LEN_08BIT, 0x6f},
	{0xd274, CRL_REG_LEN_08BIT, 0xe5},
	{0xd275, CRL_REG_LEN_08BIT, 0x63},
	{0xd276, CRL_REG_LEN_08BIT, 0x20},
	{0xd277, CRL_REG_LEN_08BIT, 0x00},
	{0xd278, CRL_REG_LEN_08BIT, 0x10},
	{0xd279, CRL_REG_LEN_08BIT, 0x00},
	{0xd27a, CRL_REG_LEN_08BIT, 0x00},
	{0xd27b, CRL_REG_LEN_08BIT, 0x07},
	{0xd27c, CRL_REG_LEN_08BIT, 0x15},
	{0xd27d, CRL_REG_LEN_08BIT, 0x00},
	{0xd27e, CRL_REG_LEN_08BIT, 0x00},
	{0xd27f, CRL_REG_LEN_08BIT, 0x00},
	{0xd280, CRL_REG_LEN_08BIT, 0x8c},
	{0xd281, CRL_REG_LEN_08BIT, 0xaa},
	{0xd282, CRL_REG_LEN_08BIT, 0x00},
	{0xd283, CRL_REG_LEN_08BIT, 0x6e},
	{0xd284, CRL_REG_LEN_08BIT, 0xe0},
	{0xd285, CRL_REG_LEN_08BIT, 0x63},
	{0xd286, CRL_REG_LEN_08BIT, 0x28},
	{0xd287, CRL_REG_LEN_08BIT, 0x02},
	{0xd288, CRL_REG_LEN_08BIT, 0xe0},
	{0xd289, CRL_REG_LEN_08BIT, 0x84},
	{0xd28a, CRL_REG_LEN_08BIT, 0x28},
	{0xd28b, CRL_REG_LEN_08BIT, 0x02},
	{0xd28c, CRL_REG_LEN_08BIT, 0x07},
	{0xd28d, CRL_REG_LEN_08BIT, 0xff},
	{0xd28e, CRL_REG_LEN_08BIT, 0xf8},
	{0xd28f, CRL_REG_LEN_08BIT, 0x66},
	{0xd290, CRL_REG_LEN_08BIT, 0xe0},
	{0xd291, CRL_REG_LEN_08BIT, 0x63},
	{0xd292, CRL_REG_LEN_08BIT, 0x5b},
	{0xd293, CRL_REG_LEN_08BIT, 0x06},
	{0xd294, CRL_REG_LEN_08BIT, 0x8c},
	{0xd295, CRL_REG_LEN_08BIT, 0x6a},
	{0xd296, CRL_REG_LEN_08BIT, 0x00},
	{0xd297, CRL_REG_LEN_08BIT, 0x77},
	{0xd298, CRL_REG_LEN_08BIT, 0xe0},
	{0xd299, CRL_REG_LEN_08BIT, 0x63},
	{0xd29a, CRL_REG_LEN_08BIT, 0x5b},
	{0xd29b, CRL_REG_LEN_08BIT, 0x06},
	{0xd29c, CRL_REG_LEN_08BIT, 0xbd},
	{0xd29d, CRL_REG_LEN_08BIT, 0x63},
	{0xd29e, CRL_REG_LEN_08BIT, 0x00},
	{0xd29f, CRL_REG_LEN_08BIT, 0x00},
	{0xd2a0, CRL_REG_LEN_08BIT, 0x0c},
	{0xd2a1, CRL_REG_LEN_08BIT, 0x00},
	{0xd2a2, CRL_REG_LEN_08BIT, 0x00},
	{0xd2a3, CRL_REG_LEN_08BIT, 0x3c},
	{0xd2a4, CRL_REG_LEN_08BIT, 0x15},
	{0xd2a5, CRL_REG_LEN_08BIT, 0x00},
	{0xd2a6, CRL_REG_LEN_08BIT, 0x00},
	{0xd2a7, CRL_REG_LEN_08BIT, 0x00},
	{0xd2a8, CRL_REG_LEN_08BIT, 0x8c},
	{0xd2a9, CRL_REG_LEN_08BIT, 0x8a},
	{0xd2aa, CRL_REG_LEN_08BIT, 0x00},
	{0xd2ab, CRL_REG_LEN_08BIT, 0x78},
	{0xd2ac, CRL_REG_LEN_08BIT, 0xb8},
	{0xd2ad, CRL_REG_LEN_08BIT, 0x63},
	{0xd2ae, CRL_REG_LEN_08BIT, 0x00},
	{0xd2af, CRL_REG_LEN_08BIT, 0x88},
	{0xd2b0, CRL_REG_LEN_08BIT, 0xe1},
	{0xd2b1, CRL_REG_LEN_08BIT, 0x64},
	{0xd2b2, CRL_REG_LEN_08BIT, 0x5b},
	{0xd2b3, CRL_REG_LEN_08BIT, 0x06},
	{0xd2b4, CRL_REG_LEN_08BIT, 0xbd},
	{0xd2b5, CRL_REG_LEN_08BIT, 0x6b},
	{0xd2b6, CRL_REG_LEN_08BIT, 0x00},
	{0xd2b7, CRL_REG_LEN_08BIT, 0x00},
	{0xd2b8, CRL_REG_LEN_08BIT, 0x0c},
	{0xd2b9, CRL_REG_LEN_08BIT, 0x00},
	{0xd2ba, CRL_REG_LEN_08BIT, 0x00},
	{0xd2bb, CRL_REG_LEN_08BIT, 0x34},
	{0xd2bc, CRL_REG_LEN_08BIT, 0xd4},
	{0xd2bd, CRL_REG_LEN_08BIT, 0x01},
	{0xd2be, CRL_REG_LEN_08BIT, 0x18},
	{0xd2bf, CRL_REG_LEN_08BIT, 0x14},
	{0xd2c0, CRL_REG_LEN_08BIT, 0xb9},
	{0xd2c1, CRL_REG_LEN_08BIT, 0x6b},
	{0xd2c2, CRL_REG_LEN_08BIT, 0x00},
	{0xd2c3, CRL_REG_LEN_08BIT, 0x88},
	{0xd2c4, CRL_REG_LEN_08BIT, 0x85},
	{0xd2c5, CRL_REG_LEN_08BIT, 0x01},
	{0xd2c6, CRL_REG_LEN_08BIT, 0x00},
	{0xd2c7, CRL_REG_LEN_08BIT, 0x14},
	{0xd2c8, CRL_REG_LEN_08BIT, 0xbd},
	{0xd2c9, CRL_REG_LEN_08BIT, 0x68},
	{0xd2ca, CRL_REG_LEN_08BIT, 0x00},
	{0xd2cb, CRL_REG_LEN_08BIT, 0x00},
	{0xd2cc, CRL_REG_LEN_08BIT, 0x0c},
	{0xd2cd, CRL_REG_LEN_08BIT, 0x00},
	{0xd2ce, CRL_REG_LEN_08BIT, 0x00},
	{0xd2cf, CRL_REG_LEN_08BIT, 0x2c},
	{0xd2d0, CRL_REG_LEN_08BIT, 0xd4},
	{0xd2d1, CRL_REG_LEN_08BIT, 0x01},
	{0xd2d2, CRL_REG_LEN_08BIT, 0x58},
	{0xd2d3, CRL_REG_LEN_08BIT, 0x18},
	{0xd2d4, CRL_REG_LEN_08BIT, 0x84},
	{0xd2d5, CRL_REG_LEN_08BIT, 0x81},
	{0xd2d6, CRL_REG_LEN_08BIT, 0x00},
	{0xd2d7, CRL_REG_LEN_08BIT, 0x14},
	{0xd2d8, CRL_REG_LEN_08BIT, 0xbd},
	{0xd2d9, CRL_REG_LEN_08BIT, 0xa4},
	{0xd2da, CRL_REG_LEN_08BIT, 0x01},
	{0xd2db, CRL_REG_LEN_08BIT, 0x00},
	{0xd2dc, CRL_REG_LEN_08BIT, 0x10},
	{0xd2dd, CRL_REG_LEN_08BIT, 0x00},
	{0xd2de, CRL_REG_LEN_08BIT, 0x00},
	{0xd2df, CRL_REG_LEN_08BIT, 0x05},
	{0xd2e0, CRL_REG_LEN_08BIT, 0x84},
	{0xd2e1, CRL_REG_LEN_08BIT, 0xc1},
	{0xd2e2, CRL_REG_LEN_08BIT, 0x00},
	{0xd2e3, CRL_REG_LEN_08BIT, 0x18},
	{0xd2e4, CRL_REG_LEN_08BIT, 0x9c},
	{0xd2e5, CRL_REG_LEN_08BIT, 0xa0},
	{0xd2e6, CRL_REG_LEN_08BIT, 0x01},
	{0xd2e7, CRL_REG_LEN_08BIT, 0x00},
	{0xd2e8, CRL_REG_LEN_08BIT, 0xd4},
	{0xd2e9, CRL_REG_LEN_08BIT, 0x01},
	{0xd2ea, CRL_REG_LEN_08BIT, 0x28},
	{0xd2eb, CRL_REG_LEN_08BIT, 0x14},
	{0xd2ec, CRL_REG_LEN_08BIT, 0x84},
	{0xd2ed, CRL_REG_LEN_08BIT, 0xc1},
	{0xd2ee, CRL_REG_LEN_08BIT, 0x00},
	{0xd2ef, CRL_REG_LEN_08BIT, 0x18},
	{0xd2f0, CRL_REG_LEN_08BIT, 0xbd},
	{0xd2f1, CRL_REG_LEN_08BIT, 0x66},
	{0xd2f2, CRL_REG_LEN_08BIT, 0x00},
	{0xd2f3, CRL_REG_LEN_08BIT, 0x00},
	{0xd2f4, CRL_REG_LEN_08BIT, 0x0c},
	{0xd2f5, CRL_REG_LEN_08BIT, 0x00},
	{0xd2f6, CRL_REG_LEN_08BIT, 0x00},
	{0xd2f7, CRL_REG_LEN_08BIT, 0x20},
	{0xd2f8, CRL_REG_LEN_08BIT, 0x9d},
	{0xd2f9, CRL_REG_LEN_08BIT, 0x00},
	{0xd2fa, CRL_REG_LEN_08BIT, 0x00},
	{0xd2fb, CRL_REG_LEN_08BIT, 0x00},
	{0xd2fc, CRL_REG_LEN_08BIT, 0x84},
	{0xd2fd, CRL_REG_LEN_08BIT, 0x61},
	{0xd2fe, CRL_REG_LEN_08BIT, 0x00},
	{0xd2ff, CRL_REG_LEN_08BIT, 0x18},
	{0xd300, CRL_REG_LEN_08BIT, 0xbd},
	{0xd301, CRL_REG_LEN_08BIT, 0xa3},
	{0xd302, CRL_REG_LEN_08BIT, 0x01},
	{0xd303, CRL_REG_LEN_08BIT, 0x00},
	{0xd304, CRL_REG_LEN_08BIT, 0x10},
	{0xd305, CRL_REG_LEN_08BIT, 0x00},
	{0xd306, CRL_REG_LEN_08BIT, 0x00},
	{0xd307, CRL_REG_LEN_08BIT, 0x03},
	{0xd308, CRL_REG_LEN_08BIT, 0x9c},
	{0xd309, CRL_REG_LEN_08BIT, 0x80},
	{0xd30a, CRL_REG_LEN_08BIT, 0x01},
	{0xd30b, CRL_REG_LEN_08BIT, 0x00},
	{0xd30c, CRL_REG_LEN_08BIT, 0xd4},
	{0xd30d, CRL_REG_LEN_08BIT, 0x01},
	{0xd30e, CRL_REG_LEN_08BIT, 0x20},
	{0xd30f, CRL_REG_LEN_08BIT, 0x18},
	{0xd310, CRL_REG_LEN_08BIT, 0x18},
	{0xd311, CRL_REG_LEN_08BIT, 0x60},
	{0xd312, CRL_REG_LEN_08BIT, 0x80},
	{0xd313, CRL_REG_LEN_08BIT, 0x06},
	{0xd314, CRL_REG_LEN_08BIT, 0x85},
	{0xd315, CRL_REG_LEN_08BIT, 0x01},
	{0xd316, CRL_REG_LEN_08BIT, 0x00},
	{0xd317, CRL_REG_LEN_08BIT, 0x14},
	{0xd318, CRL_REG_LEN_08BIT, 0xa8},
	{0xd319, CRL_REG_LEN_08BIT, 0x83},
	{0xd31a, CRL_REG_LEN_08BIT, 0x38},
	{0xd31b, CRL_REG_LEN_08BIT, 0x29},
	{0xd31c, CRL_REG_LEN_08BIT, 0xa8},
	{0xd31d, CRL_REG_LEN_08BIT, 0xc3},
	{0xd31e, CRL_REG_LEN_08BIT, 0x40},
	{0xd31f, CRL_REG_LEN_08BIT, 0x08},
	{0xd320, CRL_REG_LEN_08BIT, 0x8c},
	{0xd321, CRL_REG_LEN_08BIT, 0x84},
	{0xd322, CRL_REG_LEN_08BIT, 0x00},
	{0xd323, CRL_REG_LEN_08BIT, 0x00},
	{0xd324, CRL_REG_LEN_08BIT, 0xa8},
	{0xd325, CRL_REG_LEN_08BIT, 0xa3},
	{0xd326, CRL_REG_LEN_08BIT, 0x38},
	{0xd327, CRL_REG_LEN_08BIT, 0x2a},
	{0xd328, CRL_REG_LEN_08BIT, 0xa8},
	{0xd329, CRL_REG_LEN_08BIT, 0xe3},
	{0xd32a, CRL_REG_LEN_08BIT, 0x40},
	{0xd32b, CRL_REG_LEN_08BIT, 0x09},
	{0xd32c, CRL_REG_LEN_08BIT, 0xe0},
	{0xd32d, CRL_REG_LEN_08BIT, 0x64},
	{0xd32e, CRL_REG_LEN_08BIT, 0x40},
	{0xd32f, CRL_REG_LEN_08BIT, 0x00},
	{0xd330, CRL_REG_LEN_08BIT, 0xd8},
	{0xd331, CRL_REG_LEN_08BIT, 0x06},
	{0xd332, CRL_REG_LEN_08BIT, 0x18},
	{0xd333, CRL_REG_LEN_08BIT, 0x00},
	{0xd334, CRL_REG_LEN_08BIT, 0x8c},
	{0xd335, CRL_REG_LEN_08BIT, 0x65},
	{0xd336, CRL_REG_LEN_08BIT, 0x00},
	{0xd337, CRL_REG_LEN_08BIT, 0x00},
	{0xd338, CRL_REG_LEN_08BIT, 0x84},
	{0xd339, CRL_REG_LEN_08BIT, 0x81},
	{0xd33a, CRL_REG_LEN_08BIT, 0x00},
	{0xd33b, CRL_REG_LEN_08BIT, 0x18},
	{0xd33c, CRL_REG_LEN_08BIT, 0xe3},
	{0xd33d, CRL_REG_LEN_08BIT, 0xe3},
	{0xd33e, CRL_REG_LEN_08BIT, 0x20},
	{0xd33f, CRL_REG_LEN_08BIT, 0x00},
	{0xd340, CRL_REG_LEN_08BIT, 0xd8},
	{0xd341, CRL_REG_LEN_08BIT, 0x07},
	{0xd342, CRL_REG_LEN_08BIT, 0xf8},
	{0xd343, CRL_REG_LEN_08BIT, 0x00},
	{0xd344, CRL_REG_LEN_08BIT, 0x03},
	{0xd345, CRL_REG_LEN_08BIT, 0xff},
	{0xd346, CRL_REG_LEN_08BIT, 0xff},
	{0xd347, CRL_REG_LEN_08BIT, 0x6f},
	{0xd348, CRL_REG_LEN_08BIT, 0x18},
	{0xd349, CRL_REG_LEN_08BIT, 0x60},
	{0xd34a, CRL_REG_LEN_08BIT, 0x00},
	{0xd34b, CRL_REG_LEN_08BIT, 0x01},
	{0xd34c, CRL_REG_LEN_08BIT, 0x0f},
	{0xd34d, CRL_REG_LEN_08BIT, 0xff},
	{0xd34e, CRL_REG_LEN_08BIT, 0xff},
	{0xd34f, CRL_REG_LEN_08BIT, 0x9d},
	{0xd350, CRL_REG_LEN_08BIT, 0x18},
	{0xd351, CRL_REG_LEN_08BIT, 0x60},
	{0xd352, CRL_REG_LEN_08BIT, 0x80},
	{0xd353, CRL_REG_LEN_08BIT, 0x06},
	{0xd354, CRL_REG_LEN_08BIT, 0x00},
	{0xd355, CRL_REG_LEN_08BIT, 0x00},
	{0xd356, CRL_REG_LEN_08BIT, 0x00},
	{0xd357, CRL_REG_LEN_08BIT, 0x11},
	{0xd358, CRL_REG_LEN_08BIT, 0xa8},
	{0xd359, CRL_REG_LEN_08BIT, 0x83},
	{0xd35a, CRL_REG_LEN_08BIT, 0x6e},
	{0xd35b, CRL_REG_LEN_08BIT, 0x43},
	{0xd35c, CRL_REG_LEN_08BIT, 0xe0},
	{0xd35d, CRL_REG_LEN_08BIT, 0x6c},
	{0xd35e, CRL_REG_LEN_08BIT, 0x28},
	{0xd35f, CRL_REG_LEN_08BIT, 0x02},
	{0xd360, CRL_REG_LEN_08BIT, 0xe0},
	{0xd361, CRL_REG_LEN_08BIT, 0x84},
	{0xd362, CRL_REG_LEN_08BIT, 0x28},
	{0xd363, CRL_REG_LEN_08BIT, 0x02},
	{0xd364, CRL_REG_LEN_08BIT, 0x07},
	{0xd365, CRL_REG_LEN_08BIT, 0xff},
	{0xd366, CRL_REG_LEN_08BIT, 0xf8},
	{0xd367, CRL_REG_LEN_08BIT, 0x30},
	{0xd368, CRL_REG_LEN_08BIT, 0xb8},
	{0xd369, CRL_REG_LEN_08BIT, 0x63},
	{0xd36a, CRL_REG_LEN_08BIT, 0x00},
	{0xd36b, CRL_REG_LEN_08BIT, 0x08},
	{0xd36c, CRL_REG_LEN_08BIT, 0x03},
	{0xd36d, CRL_REG_LEN_08BIT, 0xff},
	{0xd36e, CRL_REG_LEN_08BIT, 0xff},
	{0xd36f, CRL_REG_LEN_08BIT, 0xc0},
	{0xd370, CRL_REG_LEN_08BIT, 0x85},
	{0xd371, CRL_REG_LEN_08BIT, 0x4e},
	{0xd372, CRL_REG_LEN_08BIT, 0x00},
	{0xd373, CRL_REG_LEN_08BIT, 0x00},
	{0xd374, CRL_REG_LEN_08BIT, 0x03},
	{0xd375, CRL_REG_LEN_08BIT, 0xff},
	{0xd376, CRL_REG_LEN_08BIT, 0xff},
	{0xd377, CRL_REG_LEN_08BIT, 0xe7},
	{0xd378, CRL_REG_LEN_08BIT, 0xd4},
	{0xd379, CRL_REG_LEN_08BIT, 0x01},
	{0xd37a, CRL_REG_LEN_08BIT, 0x40},
	{0xd37b, CRL_REG_LEN_08BIT, 0x18},
	{0xd37c, CRL_REG_LEN_08BIT, 0x9c},
	{0xd37d, CRL_REG_LEN_08BIT, 0x60},
	{0xd37e, CRL_REG_LEN_08BIT, 0x00},
	{0xd37f, CRL_REG_LEN_08BIT, 0x00},
	{0xd380, CRL_REG_LEN_08BIT, 0x03},
	{0xd381, CRL_REG_LEN_08BIT, 0xff},
	{0xd382, CRL_REG_LEN_08BIT, 0xff},
	{0xd383, CRL_REG_LEN_08BIT, 0xdb},
	{0xd384, CRL_REG_LEN_08BIT, 0xd4},
	{0xd385, CRL_REG_LEN_08BIT, 0x01},
	{0xd386, CRL_REG_LEN_08BIT, 0x18},
	{0xd387, CRL_REG_LEN_08BIT, 0x14},
	{0xd388, CRL_REG_LEN_08BIT, 0x03},
	{0xd389, CRL_REG_LEN_08BIT, 0xff},
	{0xd38a, CRL_REG_LEN_08BIT, 0xff},
	{0xd38b, CRL_REG_LEN_08BIT, 0xce},
	{0xd38c, CRL_REG_LEN_08BIT, 0x9d},
	{0xd38d, CRL_REG_LEN_08BIT, 0x6b},
	{0xd38e, CRL_REG_LEN_08BIT, 0x00},
	{0xd38f, CRL_REG_LEN_08BIT, 0xff},
	{0xd390, CRL_REG_LEN_08BIT, 0x03},
	{0xd391, CRL_REG_LEN_08BIT, 0xff},
	{0xd392, CRL_REG_LEN_08BIT, 0xff},
	{0xd393, CRL_REG_LEN_08BIT, 0xc6},
	{0xd394, CRL_REG_LEN_08BIT, 0x9c},
	{0xd395, CRL_REG_LEN_08BIT, 0x63},
	{0xd396, CRL_REG_LEN_08BIT, 0x00},
	{0xd397, CRL_REG_LEN_08BIT, 0xff},
	{0xd398, CRL_REG_LEN_08BIT, 0xa8},
	{0xd399, CRL_REG_LEN_08BIT, 0xe3},
	{0xd39a, CRL_REG_LEN_08BIT, 0x38},
	{0xd39b, CRL_REG_LEN_08BIT, 0x0f},
	{0xd39c, CRL_REG_LEN_08BIT, 0x8c},
	{0xd39d, CRL_REG_LEN_08BIT, 0x84},
	{0xd39e, CRL_REG_LEN_08BIT, 0x00},
	{0xd39f, CRL_REG_LEN_08BIT, 0x00},
	{0xd3a0, CRL_REG_LEN_08BIT, 0xa8},
	{0xd3a1, CRL_REG_LEN_08BIT, 0xa3},
	{0xd3a2, CRL_REG_LEN_08BIT, 0x38},
	{0xd3a3, CRL_REG_LEN_08BIT, 0x0e},
	{0xd3a4, CRL_REG_LEN_08BIT, 0xa8},
	{0xd3a5, CRL_REG_LEN_08BIT, 0xc3},
	{0xd3a6, CRL_REG_LEN_08BIT, 0x6e},
	{0xd3a7, CRL_REG_LEN_08BIT, 0x42},
	{0xd3a8, CRL_REG_LEN_08BIT, 0xd8},
	{0xd3a9, CRL_REG_LEN_08BIT, 0x07},
	{0xd3aa, CRL_REG_LEN_08BIT, 0x20},
	{0xd3ab, CRL_REG_LEN_08BIT, 0x00},
	{0xd3ac, CRL_REG_LEN_08BIT, 0x8c},
	{0xd3ad, CRL_REG_LEN_08BIT, 0x66},
	{0xd3ae, CRL_REG_LEN_08BIT, 0x00},
	{0xd3af, CRL_REG_LEN_08BIT, 0x00},
	{0xd3b0, CRL_REG_LEN_08BIT, 0xd8},
	{0xd3b1, CRL_REG_LEN_08BIT, 0x05},
	{0xd3b2, CRL_REG_LEN_08BIT, 0x18},
	{0xd3b3, CRL_REG_LEN_08BIT, 0x00},
	{0xd3b4, CRL_REG_LEN_08BIT, 0x85},
	{0xd3b5, CRL_REG_LEN_08BIT, 0x21},
	{0xd3b6, CRL_REG_LEN_08BIT, 0x00},
	{0xd3b7, CRL_REG_LEN_08BIT, 0x00},
	{0xd3b8, CRL_REG_LEN_08BIT, 0x85},
	{0xd3b9, CRL_REG_LEN_08BIT, 0x41},
	{0xd3ba, CRL_REG_LEN_08BIT, 0x00},
	{0xd3bb, CRL_REG_LEN_08BIT, 0x04},
	{0xd3bc, CRL_REG_LEN_08BIT, 0x85},
	{0xd3bd, CRL_REG_LEN_08BIT, 0x81},
	{0xd3be, CRL_REG_LEN_08BIT, 0x00},
	{0xd3bf, CRL_REG_LEN_08BIT, 0x08},
	{0xd3c0, CRL_REG_LEN_08BIT, 0x85},
	{0xd3c1, CRL_REG_LEN_08BIT, 0xc1},
	{0xd3c2, CRL_REG_LEN_08BIT, 0x00},
	{0xd3c3, CRL_REG_LEN_08BIT, 0x0c},
	{0xd3c4, CRL_REG_LEN_08BIT, 0x86},
	{0xd3c5, CRL_REG_LEN_08BIT, 0x01},
	{0xd3c6, CRL_REG_LEN_08BIT, 0x00},
	{0xd3c7, CRL_REG_LEN_08BIT, 0x10},
	{0xd3c8, CRL_REG_LEN_08BIT, 0x44},
	{0xd3c9, CRL_REG_LEN_08BIT, 0x00},
	{0xd3ca, CRL_REG_LEN_08BIT, 0x48},
	{0xd3cb, CRL_REG_LEN_08BIT, 0x00},
	{0xd3cc, CRL_REG_LEN_08BIT, 0x9c},
	{0xd3cd, CRL_REG_LEN_08BIT, 0x21},
	{0xd3ce, CRL_REG_LEN_08BIT, 0x00},
	{0xd3cf, CRL_REG_LEN_08BIT, 0x1c},
	{0xd3d0, CRL_REG_LEN_08BIT, 0x9c},
	{0xd3d1, CRL_REG_LEN_08BIT, 0x21},
	{0xd3d2, CRL_REG_LEN_08BIT, 0xff},
	{0xd3d3, CRL_REG_LEN_08BIT, 0xfc},
	{0xd3d4, CRL_REG_LEN_08BIT, 0xd4},
	{0xd3d5, CRL_REG_LEN_08BIT, 0x01},
	{0xd3d6, CRL_REG_LEN_08BIT, 0x48},
	{0xd3d7, CRL_REG_LEN_08BIT, 0x00},
	{0xd3d8, CRL_REG_LEN_08BIT, 0x18},
	{0xd3d9, CRL_REG_LEN_08BIT, 0x60},
	{0xd3da, CRL_REG_LEN_08BIT, 0x00},
	{0xd3db, CRL_REG_LEN_08BIT, 0x01},
	{0xd3dc, CRL_REG_LEN_08BIT, 0xa8},
	{0xd3dd, CRL_REG_LEN_08BIT, 0x63},
	{0xd3de, CRL_REG_LEN_08BIT, 0x07},
	{0xd3df, CRL_REG_LEN_08BIT, 0x80},
	{0xd3e0, CRL_REG_LEN_08BIT, 0x8c},
	{0xd3e1, CRL_REG_LEN_08BIT, 0x63},
	{0xd3e2, CRL_REG_LEN_08BIT, 0x00},
	{0xd3e3, CRL_REG_LEN_08BIT, 0x68},
	{0xd3e4, CRL_REG_LEN_08BIT, 0xbc},
	{0xd3e5, CRL_REG_LEN_08BIT, 0x03},
	{0xd3e6, CRL_REG_LEN_08BIT, 0x00},
	{0xd3e7, CRL_REG_LEN_08BIT, 0x00},
	{0xd3e8, CRL_REG_LEN_08BIT, 0x10},
	{0xd3e9, CRL_REG_LEN_08BIT, 0x00},
	{0xd3ea, CRL_REG_LEN_08BIT, 0x00},
	{0xd3eb, CRL_REG_LEN_08BIT, 0x0c},
	{0xd3ec, CRL_REG_LEN_08BIT, 0x15},
	{0xd3ed, CRL_REG_LEN_08BIT, 0x00},
	{0xd3ee, CRL_REG_LEN_08BIT, 0x00},
	{0xd3ef, CRL_REG_LEN_08BIT, 0x00},
	{0xd3f0, CRL_REG_LEN_08BIT, 0x07},
	{0xd3f1, CRL_REG_LEN_08BIT, 0xff},
	{0xd3f2, CRL_REG_LEN_08BIT, 0xd9},
	{0xd3f3, CRL_REG_LEN_08BIT, 0x98},
	{0xd3f4, CRL_REG_LEN_08BIT, 0x15},
	{0xd3f5, CRL_REG_LEN_08BIT, 0x00},
	{0xd3f6, CRL_REG_LEN_08BIT, 0x00},
	{0xd3f7, CRL_REG_LEN_08BIT, 0x00},
	{0xd3f8, CRL_REG_LEN_08BIT, 0x18},
	{0xd3f9, CRL_REG_LEN_08BIT, 0x60},
	{0xd3fa, CRL_REG_LEN_08BIT, 0x80},
	{0xd3fb, CRL_REG_LEN_08BIT, 0x06},
	{0xd3fc, CRL_REG_LEN_08BIT, 0xa8},
	{0xd3fd, CRL_REG_LEN_08BIT, 0x63},
	{0xd3fe, CRL_REG_LEN_08BIT, 0xc4},
	{0xd3ff, CRL_REG_LEN_08BIT, 0xb8},
	{0xd400, CRL_REG_LEN_08BIT, 0x8c},
	{0xd401, CRL_REG_LEN_08BIT, 0x63},
	{0xd402, CRL_REG_LEN_08BIT, 0x00},
	{0xd403, CRL_REG_LEN_08BIT, 0x00},
	{0xd404, CRL_REG_LEN_08BIT, 0xbc},
	{0xd405, CRL_REG_LEN_08BIT, 0x23},
	{0xd406, CRL_REG_LEN_08BIT, 0x00},
	{0xd407, CRL_REG_LEN_08BIT, 0x01},
	{0xd408, CRL_REG_LEN_08BIT, 0x10},
	{0xd409, CRL_REG_LEN_08BIT, 0x00},
	{0xd40a, CRL_REG_LEN_08BIT, 0x00},
	{0xd40b, CRL_REG_LEN_08BIT, 0x25},
	{0xd40c, CRL_REG_LEN_08BIT, 0x9d},
	{0xd40d, CRL_REG_LEN_08BIT, 0x00},
	{0xd40e, CRL_REG_LEN_08BIT, 0x00},
	{0xd40f, CRL_REG_LEN_08BIT, 0x00},
	{0xd410, CRL_REG_LEN_08BIT, 0x00},
	{0xd411, CRL_REG_LEN_08BIT, 0x00},
	{0xd412, CRL_REG_LEN_08BIT, 0x00},
	{0xd413, CRL_REG_LEN_08BIT, 0x0b},
	{0xd414, CRL_REG_LEN_08BIT, 0xb8},
	{0xd415, CRL_REG_LEN_08BIT, 0xe8},
	{0xd416, CRL_REG_LEN_08BIT, 0x00},
	{0xd417, CRL_REG_LEN_08BIT, 0x02},
	{0xd418, CRL_REG_LEN_08BIT, 0x07},
	{0xd419, CRL_REG_LEN_08BIT, 0xff},
	{0xd41a, CRL_REG_LEN_08BIT, 0xd6},
	{0xd41b, CRL_REG_LEN_08BIT, 0x24},
	{0xd41c, CRL_REG_LEN_08BIT, 0x15},
	{0xd41d, CRL_REG_LEN_08BIT, 0x00},
	{0xd41e, CRL_REG_LEN_08BIT, 0x00},
	{0xd41f, CRL_REG_LEN_08BIT, 0x00},
	{0xd420, CRL_REG_LEN_08BIT, 0x18},
	{0xd421, CRL_REG_LEN_08BIT, 0x60},
	{0xd422, CRL_REG_LEN_08BIT, 0x80},
	{0xd423, CRL_REG_LEN_08BIT, 0x06},
	{0xd424, CRL_REG_LEN_08BIT, 0xa8},
	{0xd425, CRL_REG_LEN_08BIT, 0x63},
	{0xd426, CRL_REG_LEN_08BIT, 0xc4},
	{0xd427, CRL_REG_LEN_08BIT, 0xb8},
	{0xd428, CRL_REG_LEN_08BIT, 0x8c},
	{0xd429, CRL_REG_LEN_08BIT, 0x63},
	{0xd42a, CRL_REG_LEN_08BIT, 0x00},
	{0xd42b, CRL_REG_LEN_08BIT, 0x00},
	{0xd42c, CRL_REG_LEN_08BIT, 0xbc},
	{0xd42d, CRL_REG_LEN_08BIT, 0x23},
	{0xd42e, CRL_REG_LEN_08BIT, 0x00},
	{0xd42f, CRL_REG_LEN_08BIT, 0x01},
	{0xd430, CRL_REG_LEN_08BIT, 0x10},
	{0xd431, CRL_REG_LEN_08BIT, 0x00},
	{0xd432, CRL_REG_LEN_08BIT, 0x00},
	{0xd433, CRL_REG_LEN_08BIT, 0x1b},
	{0xd434, CRL_REG_LEN_08BIT, 0x9d},
	{0xd435, CRL_REG_LEN_08BIT, 0x00},
	{0xd436, CRL_REG_LEN_08BIT, 0x00},
	{0xd437, CRL_REG_LEN_08BIT, 0x00},
	{0xd438, CRL_REG_LEN_08BIT, 0xb8},
	{0xd439, CRL_REG_LEN_08BIT, 0xe8},
	{0xd43a, CRL_REG_LEN_08BIT, 0x00},
	{0xd43b, CRL_REG_LEN_08BIT, 0x02},
	{0xd43c, CRL_REG_LEN_08BIT, 0x9c},
	{0xd43d, CRL_REG_LEN_08BIT, 0xc0},
	{0xd43e, CRL_REG_LEN_08BIT, 0x00},
	{0xd43f, CRL_REG_LEN_08BIT, 0x00},
	{0xd440, CRL_REG_LEN_08BIT, 0x18},
	{0xd441, CRL_REG_LEN_08BIT, 0xa0},
	{0xd442, CRL_REG_LEN_08BIT, 0x80},
	{0xd443, CRL_REG_LEN_08BIT, 0x06},
	{0xd444, CRL_REG_LEN_08BIT, 0xe0},
	{0xd445, CRL_REG_LEN_08BIT, 0x67},
	{0xd446, CRL_REG_LEN_08BIT, 0x30},
	{0xd447, CRL_REG_LEN_08BIT, 0x00},
	{0xd448, CRL_REG_LEN_08BIT, 0xa8},
	{0xd449, CRL_REG_LEN_08BIT, 0xa5},
	{0xd44a, CRL_REG_LEN_08BIT, 0xce},
	{0xd44b, CRL_REG_LEN_08BIT, 0xb0},
	{0xd44c, CRL_REG_LEN_08BIT, 0x19},
	{0xd44d, CRL_REG_LEN_08BIT, 0x60},
	{0xd44e, CRL_REG_LEN_08BIT, 0x00},
	{0xd44f, CRL_REG_LEN_08BIT, 0x01},
	{0xd450, CRL_REG_LEN_08BIT, 0xa9},
	{0xd451, CRL_REG_LEN_08BIT, 0x6b},
	{0xd452, CRL_REG_LEN_08BIT, 0x06},
	{0xd453, CRL_REG_LEN_08BIT, 0x14},
	{0xd454, CRL_REG_LEN_08BIT, 0xe0},
	{0xd455, CRL_REG_LEN_08BIT, 0x83},
	{0xd456, CRL_REG_LEN_08BIT, 0x28},
	{0xd457, CRL_REG_LEN_08BIT, 0x00},
	{0xd458, CRL_REG_LEN_08BIT, 0x9c},
	{0xd459, CRL_REG_LEN_08BIT, 0xc6},
	{0xd45a, CRL_REG_LEN_08BIT, 0x00},
	{0xd45b, CRL_REG_LEN_08BIT, 0x01},
	{0xd45c, CRL_REG_LEN_08BIT, 0xe0},
	{0xd45d, CRL_REG_LEN_08BIT, 0x63},
	{0xd45e, CRL_REG_LEN_08BIT, 0x18},
	{0xd45f, CRL_REG_LEN_08BIT, 0x00},
	{0xd460, CRL_REG_LEN_08BIT, 0x8c},
	{0xd461, CRL_REG_LEN_08BIT, 0x84},
	{0xd462, CRL_REG_LEN_08BIT, 0x00},
	{0xd463, CRL_REG_LEN_08BIT, 0x00},
	{0xd464, CRL_REG_LEN_08BIT, 0xe0},
	{0xd465, CRL_REG_LEN_08BIT, 0xa3},
	{0xd466, CRL_REG_LEN_08BIT, 0x58},
	{0xd467, CRL_REG_LEN_08BIT, 0x00},
	{0xd468, CRL_REG_LEN_08BIT, 0xa4},
	{0xd469, CRL_REG_LEN_08BIT, 0xc6},
	{0xd46a, CRL_REG_LEN_08BIT, 0x00},
	{0xd46b, CRL_REG_LEN_08BIT, 0xff},
	{0xd46c, CRL_REG_LEN_08BIT, 0xb8},
	{0xd46d, CRL_REG_LEN_08BIT, 0x64},
	{0xd46e, CRL_REG_LEN_08BIT, 0x00},
	{0xd46f, CRL_REG_LEN_08BIT, 0x18},
	{0xd470, CRL_REG_LEN_08BIT, 0xbc},
	{0xd471, CRL_REG_LEN_08BIT, 0x46},
	{0xd472, CRL_REG_LEN_08BIT, 0x00},
	{0xd473, CRL_REG_LEN_08BIT, 0x03},
	{0xd474, CRL_REG_LEN_08BIT, 0x94},
	{0xd475, CRL_REG_LEN_08BIT, 0x85},
	{0xd476, CRL_REG_LEN_08BIT, 0x00},
	{0xd477, CRL_REG_LEN_08BIT, 0x00},
	{0xd478, CRL_REG_LEN_08BIT, 0xb8},
	{0xd479, CRL_REG_LEN_08BIT, 0x63},
	{0xd47a, CRL_REG_LEN_08BIT, 0x00},
	{0xd47b, CRL_REG_LEN_08BIT, 0x98},
	{0xd47c, CRL_REG_LEN_08BIT, 0xe0},
	{0xd47d, CRL_REG_LEN_08BIT, 0x64},
	{0xd47e, CRL_REG_LEN_08BIT, 0x18},
	{0xd47f, CRL_REG_LEN_08BIT, 0x00},
	{0xd480, CRL_REG_LEN_08BIT, 0x0f},
	{0xd481, CRL_REG_LEN_08BIT, 0xff},
	{0xd482, CRL_REG_LEN_08BIT, 0xff},
	{0xd483, CRL_REG_LEN_08BIT, 0xf0},
	{0xd484, CRL_REG_LEN_08BIT, 0xdc},
	{0xd485, CRL_REG_LEN_08BIT, 0x05},
	{0xd486, CRL_REG_LEN_08BIT, 0x18},
	{0xd487, CRL_REG_LEN_08BIT, 0x00},
	{0xd488, CRL_REG_LEN_08BIT, 0x9c},
	{0xd489, CRL_REG_LEN_08BIT, 0x68},
	{0xd48a, CRL_REG_LEN_08BIT, 0x00},
	{0xd48b, CRL_REG_LEN_08BIT, 0x01},
	{0xd48c, CRL_REG_LEN_08BIT, 0xa5},
	{0xd48d, CRL_REG_LEN_08BIT, 0x03},
	{0xd48e, CRL_REG_LEN_08BIT, 0x00},
	{0xd48f, CRL_REG_LEN_08BIT, 0xff},
	{0xd490, CRL_REG_LEN_08BIT, 0xbc},
	{0xd491, CRL_REG_LEN_08BIT, 0x48},
	{0xd492, CRL_REG_LEN_08BIT, 0x00},
	{0xd493, CRL_REG_LEN_08BIT, 0x01},
	{0xd494, CRL_REG_LEN_08BIT, 0x0f},
	{0xd495, CRL_REG_LEN_08BIT, 0xff},
	{0xd496, CRL_REG_LEN_08BIT, 0xff},
	{0xd497, CRL_REG_LEN_08BIT, 0xea},
	{0xd498, CRL_REG_LEN_08BIT, 0xb8},
	{0xd499, CRL_REG_LEN_08BIT, 0xe8},
	{0xd49a, CRL_REG_LEN_08BIT, 0x00},
	{0xd49b, CRL_REG_LEN_08BIT, 0x02},
	{0xd49c, CRL_REG_LEN_08BIT, 0x18},
	{0xd49d, CRL_REG_LEN_08BIT, 0x60},
	{0xd49e, CRL_REG_LEN_08BIT, 0x00},
	{0xd49f, CRL_REG_LEN_08BIT, 0x01},
	{0xd4a0, CRL_REG_LEN_08BIT, 0xa8},
	{0xd4a1, CRL_REG_LEN_08BIT, 0x63},
	{0xd4a2, CRL_REG_LEN_08BIT, 0x06},
	{0xd4a3, CRL_REG_LEN_08BIT, 0x14},
	{0xd4a4, CRL_REG_LEN_08BIT, 0x07},
	{0xd4a5, CRL_REG_LEN_08BIT, 0xff},
	{0xd4a6, CRL_REG_LEN_08BIT, 0xe4},
	{0xd4a7, CRL_REG_LEN_08BIT, 0x05},
	{0xd4a8, CRL_REG_LEN_08BIT, 0x9c},
	{0xd4a9, CRL_REG_LEN_08BIT, 0x83},
	{0xd4aa, CRL_REG_LEN_08BIT, 0x00},
	{0xd4ab, CRL_REG_LEN_08BIT, 0x10},
	{0xd4ac, CRL_REG_LEN_08BIT, 0x85},
	{0xd4ad, CRL_REG_LEN_08BIT, 0x21},
	{0xd4ae, CRL_REG_LEN_08BIT, 0x00},
	{0xd4af, CRL_REG_LEN_08BIT, 0x00},
	{0xd4b0, CRL_REG_LEN_08BIT, 0x44},
	{0xd4b1, CRL_REG_LEN_08BIT, 0x00},
	{0xd4b2, CRL_REG_LEN_08BIT, 0x48},
	{0xd4b3, CRL_REG_LEN_08BIT, 0x00},
	{0xd4b4, CRL_REG_LEN_08BIT, 0x9c},
	{0xd4b5, CRL_REG_LEN_08BIT, 0x21},
	{0xd4b6, CRL_REG_LEN_08BIT, 0x00},
	{0xd4b7, CRL_REG_LEN_08BIT, 0x04},
	{0xd4b8, CRL_REG_LEN_08BIT, 0x18},
	{0xd4b9, CRL_REG_LEN_08BIT, 0x60},
	{0xd4ba, CRL_REG_LEN_08BIT, 0x00},
	{0xd4bb, CRL_REG_LEN_08BIT, 0x01},
	{0xd4bc, CRL_REG_LEN_08BIT, 0x9c},
	{0xd4bd, CRL_REG_LEN_08BIT, 0x80},
	{0xd4be, CRL_REG_LEN_08BIT, 0xff},
	{0xd4bf, CRL_REG_LEN_08BIT, 0xff},
	{0xd4c0, CRL_REG_LEN_08BIT, 0xa8},
	{0xd4c1, CRL_REG_LEN_08BIT, 0x63},
	{0xd4c2, CRL_REG_LEN_08BIT, 0x09},
	{0xd4c3, CRL_REG_LEN_08BIT, 0xef},
	{0xd4c4, CRL_REG_LEN_08BIT, 0xd8},
	{0xd4c5, CRL_REG_LEN_08BIT, 0x03},
	{0xd4c6, CRL_REG_LEN_08BIT, 0x20},
	{0xd4c7, CRL_REG_LEN_08BIT, 0x00},
	{0xd4c8, CRL_REG_LEN_08BIT, 0x18},
	{0xd4c9, CRL_REG_LEN_08BIT, 0x60},
	{0xd4ca, CRL_REG_LEN_08BIT, 0x80},
	{0xd4cb, CRL_REG_LEN_08BIT, 0x06},
	{0xd4cc, CRL_REG_LEN_08BIT, 0xa8},
	{0xd4cd, CRL_REG_LEN_08BIT, 0x63},
	{0xd4ce, CRL_REG_LEN_08BIT, 0xc9},
	{0xd4cf, CRL_REG_LEN_08BIT, 0xef},
	{0xd4d0, CRL_REG_LEN_08BIT, 0xd8},
	{0xd4d1, CRL_REG_LEN_08BIT, 0x03},
	{0xd4d2, CRL_REG_LEN_08BIT, 0x20},
	{0xd4d3, CRL_REG_LEN_08BIT, 0x00},
	{0xd4d4, CRL_REG_LEN_08BIT, 0x44},
	{0xd4d5, CRL_REG_LEN_08BIT, 0x00},
	{0xd4d6, CRL_REG_LEN_08BIT, 0x48},
	{0xd4d7, CRL_REG_LEN_08BIT, 0x00},
	{0xd4d8, CRL_REG_LEN_08BIT, 0x15},
	{0xd4d9, CRL_REG_LEN_08BIT, 0x00},
	{0xd4da, CRL_REG_LEN_08BIT, 0x00},
	{0xd4db, CRL_REG_LEN_08BIT, 0x00},
	{0xd4dc, CRL_REG_LEN_08BIT, 0x18},
	{0xd4dd, CRL_REG_LEN_08BIT, 0x80},
	{0xd4de, CRL_REG_LEN_08BIT, 0x00},
	{0xd4df, CRL_REG_LEN_08BIT, 0x01},
	{0xd4e0, CRL_REG_LEN_08BIT, 0xa8},
	{0xd4e1, CRL_REG_LEN_08BIT, 0x84},
	{0xd4e2, CRL_REG_LEN_08BIT, 0x0a},
	{0xd4e3, CRL_REG_LEN_08BIT, 0x12},
	{0xd4e4, CRL_REG_LEN_08BIT, 0x8c},
	{0xd4e5, CRL_REG_LEN_08BIT, 0x64},
	{0xd4e6, CRL_REG_LEN_08BIT, 0x00},
	{0xd4e7, CRL_REG_LEN_08BIT, 0x00},
	{0xd4e8, CRL_REG_LEN_08BIT, 0xbc},
	{0xd4e9, CRL_REG_LEN_08BIT, 0x03},
	{0xd4ea, CRL_REG_LEN_08BIT, 0x00},
	{0xd4eb, CRL_REG_LEN_08BIT, 0x00},
	{0xd4ec, CRL_REG_LEN_08BIT, 0x13},
	{0xd4ed, CRL_REG_LEN_08BIT, 0xff},
	{0xd4ee, CRL_REG_LEN_08BIT, 0xff},
	{0xd4ef, CRL_REG_LEN_08BIT, 0xfe},
	{0xd4f0, CRL_REG_LEN_08BIT, 0x15},
	{0xd4f1, CRL_REG_LEN_08BIT, 0x00},
	{0xd4f2, CRL_REG_LEN_08BIT, 0x00},
	{0xd4f3, CRL_REG_LEN_08BIT, 0x00},
	{0xd4f4, CRL_REG_LEN_08BIT, 0x44},
	{0xd4f5, CRL_REG_LEN_08BIT, 0x00},
	{0xd4f6, CRL_REG_LEN_08BIT, 0x48},
	{0xd4f7, CRL_REG_LEN_08BIT, 0x00},
	{0xd4f8, CRL_REG_LEN_08BIT, 0x15},
	{0xd4f9, CRL_REG_LEN_08BIT, 0x00},
	{0xd4fa, CRL_REG_LEN_08BIT, 0x00},
	{0xd4fb, CRL_REG_LEN_08BIT, 0x00},
	{0xd4fc, CRL_REG_LEN_08BIT, 0x00},
	{0xd4fd, CRL_REG_LEN_08BIT, 0x00},
	{0xd4fe, CRL_REG_LEN_08BIT, 0x00},
	{0xd4ff, CRL_REG_LEN_08BIT, 0x00},
	{0xd500, CRL_REG_LEN_08BIT, 0x00},
	{0xd501, CRL_REG_LEN_08BIT, 0x00},
	{0xd502, CRL_REG_LEN_08BIT, 0x00},
	{0xd503, CRL_REG_LEN_08BIT, 0x00},
	{0x6f0e, CRL_REG_LEN_08BIT, 0x33},
	{0x6f0f, CRL_REG_LEN_08BIT, 0x33},
	{0x460e, CRL_REG_LEN_08BIT, 0x08},
	{0x460f, CRL_REG_LEN_08BIT, 0x01},
	{0x4610, CRL_REG_LEN_08BIT, 0x00},
	{0x4611, CRL_REG_LEN_08BIT, 0x01},
	{0x4612, CRL_REG_LEN_08BIT, 0x00},
	{0x4613, CRL_REG_LEN_08BIT, 0x01},
	{0x4605, CRL_REG_LEN_08BIT, 0x08},
	{0x4608, CRL_REG_LEN_08BIT, 0x00},
	{0x4609, CRL_REG_LEN_08BIT, 0x08},
	{0x6804, CRL_REG_LEN_08BIT, 0x00},
	{0x6805, CRL_REG_LEN_08BIT, 0x06},
	{0x6806, CRL_REG_LEN_08BIT, 0x00},
	{0x5120, CRL_REG_LEN_08BIT, 0x00},
	{0x3510, CRL_REG_LEN_08BIT, 0x00},
	{0x3504, CRL_REG_LEN_08BIT, 0x00},
	{0x6800, CRL_REG_LEN_08BIT, 0x00},
	{0x6f0d, CRL_REG_LEN_08BIT, 0x0f},
	{0x5000, CRL_REG_LEN_08BIT, 0xff},
	{0x5001, CRL_REG_LEN_08BIT, 0xbf},
	{0x5002, CRL_REG_LEN_08BIT, 0x7e},
	{0x5003, CRL_REG_LEN_08BIT, 0x0c},
	{0x503d, CRL_REG_LEN_08BIT, 0x00},
	{0xc450, CRL_REG_LEN_08BIT, 0x01},
	{0xc452, CRL_REG_LEN_08BIT, 0x04},
	{0xc453, CRL_REG_LEN_08BIT, 0x00},
	{0xc454, CRL_REG_LEN_08BIT, 0x01},
	{0xc455, CRL_REG_LEN_08BIT, 0x00},
	{0xc456, CRL_REG_LEN_08BIT, 0x00},
	{0xc457, CRL_REG_LEN_08BIT, 0x00},
	{0xc458, CRL_REG_LEN_08BIT, 0x00},
	{0xc459, CRL_REG_LEN_08BIT, 0x00},
	{0xc45b, CRL_REG_LEN_08BIT, 0x00},
	{0xc45c, CRL_REG_LEN_08BIT, 0x00},
	{0xc45d, CRL_REG_LEN_08BIT, 0x00},
	{0xc45e, CRL_REG_LEN_08BIT, 0x00},
	{0xc45f, CRL_REG_LEN_08BIT, 0x00},
	{0xc460, CRL_REG_LEN_08BIT, 0x00},
	{0xc461, CRL_REG_LEN_08BIT, 0x01},
	{0xc462, CRL_REG_LEN_08BIT, 0x01},
	{0xc464, CRL_REG_LEN_08BIT, 0x88},
	{0xc465, CRL_REG_LEN_08BIT, 0x00},
	{0xc466, CRL_REG_LEN_08BIT, 0x8a},
	{0xc467, CRL_REG_LEN_08BIT, 0x00},
	{0xc468, CRL_REG_LEN_08BIT, 0x86},
	{0xc469, CRL_REG_LEN_08BIT, 0x00},
	{0xc46a, CRL_REG_LEN_08BIT, 0x40},
	{0xc46b, CRL_REG_LEN_08BIT, 0x50},
	{0xc46c, CRL_REG_LEN_08BIT, 0x30},
	{0xc46d, CRL_REG_LEN_08BIT, 0x28},
	{0xc46e, CRL_REG_LEN_08BIT, 0x60},
	{0xc46f, CRL_REG_LEN_08BIT, 0x40},
	{0xc47c, CRL_REG_LEN_08BIT, 0x01},
	{0xc47d, CRL_REG_LEN_08BIT, 0x38},
	{0xc47e, CRL_REG_LEN_08BIT, 0x00},
	{0xc47f, CRL_REG_LEN_08BIT, 0x00},
	{0xc480, CRL_REG_LEN_08BIT, 0x00},
	{0xc481, CRL_REG_LEN_08BIT, 0xff},
	{0xc482, CRL_REG_LEN_08BIT, 0x00},
	{0xc483, CRL_REG_LEN_08BIT, 0x40},
	{0xc484, CRL_REG_LEN_08BIT, 0x00},
	{0xc485, CRL_REG_LEN_08BIT, 0x18},
	{0xc486, CRL_REG_LEN_08BIT, 0x00},
	{0xc487, CRL_REG_LEN_08BIT, 0x18},
	{0xc488, CRL_REG_LEN_08BIT, 0x34},
	{0xc489, CRL_REG_LEN_08BIT, 0x00},
	{0xc48a, CRL_REG_LEN_08BIT, 0x34},
	{0xc48b, CRL_REG_LEN_08BIT, 0x00},
	{0xc48c, CRL_REG_LEN_08BIT, 0x00},
	{0xc48d, CRL_REG_LEN_08BIT, 0x04},
	{0xc48e, CRL_REG_LEN_08BIT, 0x00},
	{0xc48f, CRL_REG_LEN_08BIT, 0x04},
	{0xc490, CRL_REG_LEN_08BIT, 0x07},
	{0xc492, CRL_REG_LEN_08BIT, 0x20},
	{0xc493, CRL_REG_LEN_08BIT, 0x08},
	{0xc498, CRL_REG_LEN_08BIT, 0x02},
	{0xc499, CRL_REG_LEN_08BIT, 0x00},
	{0xc49a, CRL_REG_LEN_08BIT, 0x02},
	{0xc49b, CRL_REG_LEN_08BIT, 0x00},
	{0xc49c, CRL_REG_LEN_08BIT, 0x02},
	{0xc49d, CRL_REG_LEN_08BIT, 0x00},
	{0xc49e, CRL_REG_LEN_08BIT, 0x02},
	{0xc49f, CRL_REG_LEN_08BIT, 0x60},
	{0xc4a0, CRL_REG_LEN_08BIT, 0x03},
	{0xc4a1, CRL_REG_LEN_08BIT, 0x00},
	{0xc4a2, CRL_REG_LEN_08BIT, 0x04},
	{0xc4a3, CRL_REG_LEN_08BIT, 0x00},
	{0xc4a4, CRL_REG_LEN_08BIT, 0x00},
	{0xc4a5, CRL_REG_LEN_08BIT, 0x10},
	{0xc4a6, CRL_REG_LEN_08BIT, 0x00},
	{0xc4a7, CRL_REG_LEN_08BIT, 0x40},
	{0xc4a8, CRL_REG_LEN_08BIT, 0x00},
	{0xc4a9, CRL_REG_LEN_08BIT, 0x80},
	{0xc4aa, CRL_REG_LEN_08BIT, 0x0d},
	{0xc4ab, CRL_REG_LEN_08BIT, 0x00},
	{0xc4ac, CRL_REG_LEN_08BIT, 0x0f},
	{0xc4ad, CRL_REG_LEN_08BIT, 0xc0},
	{0xc4b4, CRL_REG_LEN_08BIT, 0x01},
	{0xc4b5, CRL_REG_LEN_08BIT, 0x01},
	{0xc4b6, CRL_REG_LEN_08BIT, 0x00},
	{0xc4b7, CRL_REG_LEN_08BIT, 0x01},
	{0xc4b8, CRL_REG_LEN_08BIT, 0x00},
	{0xc4b9, CRL_REG_LEN_08BIT, 0x01},
	{0xc4ba, CRL_REG_LEN_08BIT, 0x01},
	{0xc4bb, CRL_REG_LEN_08BIT, 0x00},
	{0xc4bc, CRL_REG_LEN_08BIT, 0x01},
	{0xc4bd, CRL_REG_LEN_08BIT, 0x60},
	{0xc4be, CRL_REG_LEN_08BIT, 0x02},
	{0xc4bf, CRL_REG_LEN_08BIT, 0x33},
	{0xc4c8, CRL_REG_LEN_08BIT, 0x03},
	{0xc4c9, CRL_REG_LEN_08BIT, 0xd0},
	{0xc4ca, CRL_REG_LEN_08BIT, 0x0e},
	{0xc4cb, CRL_REG_LEN_08BIT, 0x00},
	{0xc4cc, CRL_REG_LEN_08BIT, 0x10},
	{0xc4cd, CRL_REG_LEN_08BIT, 0x18},
	{0xc4ce, CRL_REG_LEN_08BIT, 0x10},
	{0xc4cf, CRL_REG_LEN_08BIT, 0x18},
	{0xc4d0, CRL_REG_LEN_08BIT, 0x04},
	{0xc4d1, CRL_REG_LEN_08BIT, 0x80},
	{0xc4e0, CRL_REG_LEN_08BIT, 0x04},
	{0xc4e1, CRL_REG_LEN_08BIT, 0x02},
	{0xc4e2, CRL_REG_LEN_08BIT, 0x01},
	{0xc4e4, CRL_REG_LEN_08BIT, 0x10},
	{0xc4e5, CRL_REG_LEN_08BIT, 0x20},
	{0xc4e6, CRL_REG_LEN_08BIT, 0x30},
	{0xc4e7, CRL_REG_LEN_08BIT, 0x40},
	{0xc4e8, CRL_REG_LEN_08BIT, 0x50},
	{0xc4e9, CRL_REG_LEN_08BIT, 0x60},
	{0xc4ea, CRL_REG_LEN_08BIT, 0x70},
	{0xc4eb, CRL_REG_LEN_08BIT, 0x80},
	{0xc4ec, CRL_REG_LEN_08BIT, 0x90},
	{0xc4ed, CRL_REG_LEN_08BIT, 0xa0},
	{0xc4ee, CRL_REG_LEN_08BIT, 0xb0},
	{0xc4ef, CRL_REG_LEN_08BIT, 0xc0},
	{0xc4f0, CRL_REG_LEN_08BIT, 0xd0},
	{0xc4f1, CRL_REG_LEN_08BIT, 0xe0},
	{0xc4f2, CRL_REG_LEN_08BIT, 0xf0},
	{0xc4f3, CRL_REG_LEN_08BIT, 0x80},
	{0xc4f4, CRL_REG_LEN_08BIT, 0x00},
	{0xc4f5, CRL_REG_LEN_08BIT, 0x20},
	{0xc4f6, CRL_REG_LEN_08BIT, 0x02},
	{0xc4f7, CRL_REG_LEN_08BIT, 0x00},
	{0xc4f8, CRL_REG_LEN_08BIT, 0x04},
	{0xc4f9, CRL_REG_LEN_08BIT, 0x0b},
	{0xc4fa, CRL_REG_LEN_08BIT, 0x00},
	{0xc4fb, CRL_REG_LEN_08BIT, 0x00},
	{0xc4fc, CRL_REG_LEN_08BIT, 0x01},
	{0xc4fd, CRL_REG_LEN_08BIT, 0x00},
	{0xc4fe, CRL_REG_LEN_08BIT, 0x04},
	{0xc4ff, CRL_REG_LEN_08BIT, 0x02},
	{0xc500, CRL_REG_LEN_08BIT, 0x48},
	{0xc501, CRL_REG_LEN_08BIT, 0x74},
	{0xc502, CRL_REG_LEN_08BIT, 0x58},
	{0xc503, CRL_REG_LEN_08BIT, 0x80},
	{0xc504, CRL_REG_LEN_08BIT, 0x05},
	{0xc505, CRL_REG_LEN_08BIT, 0x80},
	{0xc506, CRL_REG_LEN_08BIT, 0x03},
	{0xc507, CRL_REG_LEN_08BIT, 0x80},
	{0xc508, CRL_REG_LEN_08BIT, 0x01},
	{0xc509, CRL_REG_LEN_08BIT, 0xc0},
	{0xc50a, CRL_REG_LEN_08BIT, 0x01},
	{0xc50b, CRL_REG_LEN_08BIT, 0xa0},
	{0xc50c, CRL_REG_LEN_08BIT, 0x01},
	{0xc50d, CRL_REG_LEN_08BIT, 0x2c},
	{0xc50e, CRL_REG_LEN_08BIT, 0x01},
	{0xc50f, CRL_REG_LEN_08BIT, 0x0a},
	{0xc510, CRL_REG_LEN_08BIT, 0x00},
	{0xc511, CRL_REG_LEN_08BIT, 0x01},
	{0xc512, CRL_REG_LEN_08BIT, 0x01},
	{0xc513, CRL_REG_LEN_08BIT, 0x80},
	{0xc514, CRL_REG_LEN_08BIT, 0x04},
	{0xc515, CRL_REG_LEN_08BIT, 0x00},
	{0xc518, CRL_REG_LEN_08BIT, 0x03},
	{0xc519, CRL_REG_LEN_08BIT, 0x48},
	{0xc51a, CRL_REG_LEN_08BIT, 0x07},
	{0xc51b, CRL_REG_LEN_08BIT, 0x70},
	{0xc2e0, CRL_REG_LEN_08BIT, 0x00},
	{0xc2e1, CRL_REG_LEN_08BIT, 0x51},
	{0xc2e2, CRL_REG_LEN_08BIT, 0x00},
	{0xc2e3, CRL_REG_LEN_08BIT, 0xd6},
	{0xc2e4, CRL_REG_LEN_08BIT, 0x01},
	{0xc2e5, CRL_REG_LEN_08BIT, 0x5e},
	{0xc2e9, CRL_REG_LEN_08BIT, 0x01},
	{0xc2ea, CRL_REG_LEN_08BIT, 0x7a},
	{0xc2eb, CRL_REG_LEN_08BIT, 0x90},
	{0xc2ed, CRL_REG_LEN_08BIT, 0x00},
	{0xc2ee, CRL_REG_LEN_08BIT, 0x7a},
	{0xc2ef, CRL_REG_LEN_08BIT, 0x64},
	{0xc308, CRL_REG_LEN_08BIT, 0x00},
	{0xc309, CRL_REG_LEN_08BIT, 0x00},
	{0xc30a, CRL_REG_LEN_08BIT, 0x00},
	{0xc30c, CRL_REG_LEN_08BIT, 0x00},
	{0xc30d, CRL_REG_LEN_08BIT, 0x01},
	{0xc30e, CRL_REG_LEN_08BIT, 0x00},
	{0xc30f, CRL_REG_LEN_08BIT, 0x00},
	{0xc310, CRL_REG_LEN_08BIT, 0x01},
	{0xc311, CRL_REG_LEN_08BIT, 0x60},
	{0xc312, CRL_REG_LEN_08BIT, 0xff},
	{0xc313, CRL_REG_LEN_08BIT, 0x08},
	{0xc314, CRL_REG_LEN_08BIT, 0x01},
	{0xc315, CRL_REG_LEN_08BIT, 0x7f},
	{0xc316, CRL_REG_LEN_08BIT, 0xff},
	{0xc317, CRL_REG_LEN_08BIT, 0x0b},
	{0xc318, CRL_REG_LEN_08BIT, 0x00},
	{0xc319, CRL_REG_LEN_08BIT, 0x0c},
	{0xc31a, CRL_REG_LEN_08BIT, 0x00},
	{0xc31b, CRL_REG_LEN_08BIT, 0xe0},
	{0xc31c, CRL_REG_LEN_08BIT, 0x00},
	{0xc31d, CRL_REG_LEN_08BIT, 0x14},
	{0xc31e, CRL_REG_LEN_08BIT, 0x00},
	{0xc31f, CRL_REG_LEN_08BIT, 0xc5},
	{0xc320, CRL_REG_LEN_08BIT, 0xff},
	{0xc321, CRL_REG_LEN_08BIT, 0x4b},
	{0xc322, CRL_REG_LEN_08BIT, 0xff},
	{0xc323, CRL_REG_LEN_08BIT, 0xf0},
	{0xc324, CRL_REG_LEN_08BIT, 0xff},
	{0xc325, CRL_REG_LEN_08BIT, 0xe8},
	{0xc326, CRL_REG_LEN_08BIT, 0x00},
	{0xc327, CRL_REG_LEN_08BIT, 0x46},
	{0xc328, CRL_REG_LEN_08BIT, 0xff},
	{0xc329, CRL_REG_LEN_08BIT, 0xd2},
	{0xc32a, CRL_REG_LEN_08BIT, 0xff},
	{0xc32b, CRL_REG_LEN_08BIT, 0xe4},
	{0xc32c, CRL_REG_LEN_08BIT, 0xff},
	{0xc32d, CRL_REG_LEN_08BIT, 0xbb},
	{0xc32e, CRL_REG_LEN_08BIT, 0x00},
	{0xc32f, CRL_REG_LEN_08BIT, 0x61},
	{0xc330, CRL_REG_LEN_08BIT, 0xff},
	{0xc331, CRL_REG_LEN_08BIT, 0xf9},
	{0xc332, CRL_REG_LEN_08BIT, 0x00},
	{0xc333, CRL_REG_LEN_08BIT, 0xd9},
	{0xc334, CRL_REG_LEN_08BIT, 0x00},
	{0xc335, CRL_REG_LEN_08BIT, 0x2e},
	{0xc336, CRL_REG_LEN_08BIT, 0x00},
	{0xc337, CRL_REG_LEN_08BIT, 0xb1},
	{0xc338, CRL_REG_LEN_08BIT, 0xff},
	{0xc339, CRL_REG_LEN_08BIT, 0x64},
	{0xc33a, CRL_REG_LEN_08BIT, 0xff},
	{0xc33b, CRL_REG_LEN_08BIT, 0xeb},
	{0xc33c, CRL_REG_LEN_08BIT, 0xff},
	{0xc33d, CRL_REG_LEN_08BIT, 0xe8},
	{0xc33e, CRL_REG_LEN_08BIT, 0x00},
	{0xc33f, CRL_REG_LEN_08BIT, 0x48},
	{0xc340, CRL_REG_LEN_08BIT, 0xff},
	{0xc341, CRL_REG_LEN_08BIT, 0xd0},
	{0xc342, CRL_REG_LEN_08BIT, 0xff},
	{0xc343, CRL_REG_LEN_08BIT, 0xed},
	{0xc344, CRL_REG_LEN_08BIT, 0xff},
	{0xc345, CRL_REG_LEN_08BIT, 0xad},
	{0xc346, CRL_REG_LEN_08BIT, 0x00},
	{0xc347, CRL_REG_LEN_08BIT, 0x66},
	{0xc348, CRL_REG_LEN_08BIT, 0x01},
	{0xc349, CRL_REG_LEN_08BIT, 0x00},
	{0x6700, CRL_REG_LEN_08BIT, 0x04},
	{0x6701, CRL_REG_LEN_08BIT, 0x7b},
	{0x6702, CRL_REG_LEN_08BIT, 0xfd},
	{0x6703, CRL_REG_LEN_08BIT, 0xf9},
	{0x6704, CRL_REG_LEN_08BIT, 0x3d},
	{0x6705, CRL_REG_LEN_08BIT, 0x71},
	{0x6706, CRL_REG_LEN_08BIT, 0x78},
	{0x6708, CRL_REG_LEN_08BIT, 0x05},
	{0x6f06, CRL_REG_LEN_08BIT, 0x6f},
	{0x6f07, CRL_REG_LEN_08BIT, 0x00},
	{0x6f0a, CRL_REG_LEN_08BIT, 0x6f},
	{0x6f0b, CRL_REG_LEN_08BIT, 0x00},
	{0x6f00, CRL_REG_LEN_08BIT, 0x03},
	{0xc34c, CRL_REG_LEN_08BIT, 0x01},
	{0xc34d, CRL_REG_LEN_08BIT, 0x00},
	{0xc34e, CRL_REG_LEN_08BIT, 0x46},
	{0xc34f, CRL_REG_LEN_08BIT, 0x55},
	{0xc350, CRL_REG_LEN_08BIT, 0x00},
	{0xc351, CRL_REG_LEN_08BIT, 0x40},
	{0xc352, CRL_REG_LEN_08BIT, 0x00},
	{0xc353, CRL_REG_LEN_08BIT, 0xff},
	{0xc354, CRL_REG_LEN_08BIT, 0x04},
	{0xc355, CRL_REG_LEN_08BIT, 0x08},
	{0xc356, CRL_REG_LEN_08BIT, 0x01},
	{0xc357, CRL_REG_LEN_08BIT, 0xef},
	{0xc358, CRL_REG_LEN_08BIT, 0x30},
	{0xc359, CRL_REG_LEN_08BIT, 0x01},
	{0xc35a, CRL_REG_LEN_08BIT, 0x64},
	{0xc35b, CRL_REG_LEN_08BIT, 0x46},
	{0xc35c, CRL_REG_LEN_08BIT, 0x00},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x302e, CRL_REG_LEN_08BIT, 0x00},
	{0x301b, CRL_REG_LEN_08BIT, 0xf0},
	{0x301c, CRL_REG_LEN_08BIT, 0xf0},
	{0x301a, CRL_REG_LEN_08BIT, 0xf0},
	{0xceb0, CRL_REG_LEN_08BIT, 0x00},
	{0xceb1, CRL_REG_LEN_08BIT, 0x00},
	{0xceb2, CRL_REG_LEN_08BIT, 0x00},
	{0xceb3, CRL_REG_LEN_08BIT, 0x00},
	{0xceb4, CRL_REG_LEN_08BIT, 0x00},
	{0xceb5, CRL_REG_LEN_08BIT, 0x00},
	{0xceb6, CRL_REG_LEN_08BIT, 0x00},
	{0xceb7, CRL_REG_LEN_08BIT, 0x00},
	{0xc4bc, CRL_REG_LEN_08BIT, 0x01},
	{0xc4bd, CRL_REG_LEN_08BIT, 0x60},
};

static struct crl_register_write_rep ov10635_640_480_YUV_HDR[] = {
	{0x301b, CRL_REG_LEN_08BIT, 0xff},
	{0x301c, CRL_REG_LEN_08BIT, 0xff},
	{0x301a, CRL_REG_LEN_08BIT, 0xff},
	{0x3011, CRL_REG_LEN_08BIT, 0x42},
	{0x6900, CRL_REG_LEN_08BIT, 0x0c},
	{0x6901, CRL_REG_LEN_08BIT, 0x11},
	{0x3503, CRL_REG_LEN_08BIT, 0x10},
	{0x3025, CRL_REG_LEN_08BIT, 0x03},
	{0x3003, CRL_REG_LEN_08BIT, 0x14},
	{0x3004, CRL_REG_LEN_08BIT, 0x23},
	{0x3005, CRL_REG_LEN_08BIT, 0x20},
	{0x3006, CRL_REG_LEN_08BIT, 0x91},
	{0x3600, CRL_REG_LEN_08BIT, 0x74},
	{0x3601, CRL_REG_LEN_08BIT, 0x2b},
	{0x3612, CRL_REG_LEN_08BIT, 0x00},
	{0x3611, CRL_REG_LEN_08BIT, 0x67},
	{0x3633, CRL_REG_LEN_08BIT, 0xca},
	{0x3602, CRL_REG_LEN_08BIT, 0x2f},
	{0x3603, CRL_REG_LEN_08BIT, 0x00},
	{0x3630, CRL_REG_LEN_08BIT, 0x28},
	{0x3631, CRL_REG_LEN_08BIT, 0x16},
	{0x3714, CRL_REG_LEN_08BIT, 0x10},
	{0x371d, CRL_REG_LEN_08BIT, 0x01},
	{0x3007, CRL_REG_LEN_08BIT, 0x01},
	{0x3024, CRL_REG_LEN_08BIT, 0x01},
	{0x3020, CRL_REG_LEN_08BIT, 0x0b},
	{0x3702, CRL_REG_LEN_08BIT, 0x0a},
	{0x3703, CRL_REG_LEN_08BIT, 0x17},
	{0x3704, CRL_REG_LEN_08BIT, 0x0f},
	{0x3709, CRL_REG_LEN_08BIT, 0xa8},
	{0x3709, CRL_REG_LEN_08BIT, 0xa8},
	{0x370c, CRL_REG_LEN_08BIT, 0xc7},
	{0x370d, CRL_REG_LEN_08BIT, 0x80},
	{0x3712, CRL_REG_LEN_08BIT, 0x00},
	{0x3713, CRL_REG_LEN_08BIT, 0x20},
	{0x3715, CRL_REG_LEN_08BIT, 0x04},
	{0x381d, CRL_REG_LEN_08BIT, 0x40},
	{0x381c, CRL_REG_LEN_08BIT, 0x00},
	{0x3822, CRL_REG_LEN_08BIT, 0x50},
	{0x3824, CRL_REG_LEN_08BIT, 0x50},
	{0x3815, CRL_REG_LEN_08BIT, 0x8c},
	{0x3804, CRL_REG_LEN_08BIT, 0x05},
	{0x3805, CRL_REG_LEN_08BIT, 0x1f},
	{0x3800, CRL_REG_LEN_08BIT, 0x00},
	{0x3801, CRL_REG_LEN_08BIT, 0x00},
	{0x3806, CRL_REG_LEN_08BIT, 0x02},
	{0x3807, CRL_REG_LEN_08BIT, 0x89},
	{0x3802, CRL_REG_LEN_08BIT, 0x00},
	{0x3803, CRL_REG_LEN_08BIT, 0xa4},
	{0x3808, CRL_REG_LEN_08BIT, 0x02},
	{0x3809, CRL_REG_LEN_08BIT, 0x80},
	{0x380a, CRL_REG_LEN_08BIT, 0x01},
	{0x380b, CRL_REG_LEN_08BIT, 0xe0},
	{0x380c, CRL_REG_LEN_08BIT, 0x03},
	{0x380d, CRL_REG_LEN_08BIT, 0xc0},
	{0x6e42, CRL_REG_LEN_08BIT, 0x02},
	{0x6e43, CRL_REG_LEN_08BIT, 0x08},
	{0x380e, CRL_REG_LEN_08BIT, 0x02},
	{0x380f, CRL_REG_LEN_08BIT, 0x08},
	{0x3813, CRL_REG_LEN_08BIT, 0x02},
	{0x3811, CRL_REG_LEN_08BIT, 0x08},
	{0x381f, CRL_REG_LEN_08BIT, 0x0c},
	{0x3828, CRL_REG_LEN_08BIT, 0x03},
	{0x3829, CRL_REG_LEN_08BIT, 0x10},
	{0x382a, CRL_REG_LEN_08BIT, 0x10},
	{0x382b, CRL_REG_LEN_08BIT, 0x10},
	{0x3621, CRL_REG_LEN_08BIT, 0x74},
	{0x5005, CRL_REG_LEN_08BIT, 0x08},
	{0x56d5, CRL_REG_LEN_08BIT, 0x00},
	{0x56d6, CRL_REG_LEN_08BIT, 0x80},
	{0x56d7, CRL_REG_LEN_08BIT, 0x00},
	{0x56d8, CRL_REG_LEN_08BIT, 0x00},
	{0x56d9, CRL_REG_LEN_08BIT, 0x00},
	{0x56da, CRL_REG_LEN_08BIT, 0x80},
	{0x56db, CRL_REG_LEN_08BIT, 0x00},
	{0x56dc, CRL_REG_LEN_08BIT, 0x00},
	{0x56e8, CRL_REG_LEN_08BIT, 0x00},
	{0x56e9, CRL_REG_LEN_08BIT, 0x7f},
	{0x56ea, CRL_REG_LEN_08BIT, 0x00},
	{0x56eb, CRL_REG_LEN_08BIT, 0x7f},
	{0x5100, CRL_REG_LEN_08BIT, 0x00},
	{0x5101, CRL_REG_LEN_08BIT, 0x80},
	{0x5102, CRL_REG_LEN_08BIT, 0x00},
	{0x5103, CRL_REG_LEN_08BIT, 0x80},
	{0x5104, CRL_REG_LEN_08BIT, 0x00},
	{0x5105, CRL_REG_LEN_08BIT, 0x80},
	{0x5106, CRL_REG_LEN_08BIT, 0x00},
	{0x5107, CRL_REG_LEN_08BIT, 0x80},
	{0x5108, CRL_REG_LEN_08BIT, 0x00},
	{0x5109, CRL_REG_LEN_08BIT, 0x00},
	{0x510a, CRL_REG_LEN_08BIT, 0x00},
	{0x510b, CRL_REG_LEN_08BIT, 0x00},
	{0x510c, CRL_REG_LEN_08BIT, 0x00},
	{0x510d, CRL_REG_LEN_08BIT, 0x00},
	{0x510e, CRL_REG_LEN_08BIT, 0x00},
	{0x510f, CRL_REG_LEN_08BIT, 0x00},
	{0x5110, CRL_REG_LEN_08BIT, 0x00},
	{0x5111, CRL_REG_LEN_08BIT, 0x80},
	{0x5112, CRL_REG_LEN_08BIT, 0x00},
	{0x5113, CRL_REG_LEN_08BIT, 0x80},
	{0x5114, CRL_REG_LEN_08BIT, 0x00},
	{0x5115, CRL_REG_LEN_08BIT, 0x80},
	{0x5116, CRL_REG_LEN_08BIT, 0x00},
	{0x5117, CRL_REG_LEN_08BIT, 0x80},
	{0x5118, CRL_REG_LEN_08BIT, 0x00},
	{0x5119, CRL_REG_LEN_08BIT, 0x00},
	{0x511a, CRL_REG_LEN_08BIT, 0x00},
	{0x511b, CRL_REG_LEN_08BIT, 0x00},
	{0x511c, CRL_REG_LEN_08BIT, 0x00},
	{0x511d, CRL_REG_LEN_08BIT, 0x00},
	{0x511e, CRL_REG_LEN_08BIT, 0x00},
	{0x511f, CRL_REG_LEN_08BIT, 0x00},
	{0x56d0, CRL_REG_LEN_08BIT, 0x00},
	{0x5006, CRL_REG_LEN_08BIT, 0x24},
	{0x5608, CRL_REG_LEN_08BIT, 0x19},
	{0x52d7, CRL_REG_LEN_08BIT, 0x06},
	{0x528d, CRL_REG_LEN_08BIT, 0x08},
	{0x5293, CRL_REG_LEN_08BIT, 0x12},
	{0x52d3, CRL_REG_LEN_08BIT, 0x12},
	{0x5288, CRL_REG_LEN_08BIT, 0x06},
	{0x5289, CRL_REG_LEN_08BIT, 0x20},
	{0x52c8, CRL_REG_LEN_08BIT, 0x06},
	{0x52c9, CRL_REG_LEN_08BIT, 0x20},
	{0x52cd, CRL_REG_LEN_08BIT, 0x04},
	{0x5381, CRL_REG_LEN_08BIT, 0x00},
	{0x5382, CRL_REG_LEN_08BIT, 0xff},
	{0x5589, CRL_REG_LEN_08BIT, 0x76},
	{0x558a, CRL_REG_LEN_08BIT, 0x47},
	{0x558b, CRL_REG_LEN_08BIT, 0xef},
	{0x558c, CRL_REG_LEN_08BIT, 0xc9},
	{0x558d, CRL_REG_LEN_08BIT, 0x49},
	{0x558e, CRL_REG_LEN_08BIT, 0x30},
	{0x558f, CRL_REG_LEN_08BIT, 0x67},
	{0x5590, CRL_REG_LEN_08BIT, 0x3f},
	{0x5591, CRL_REG_LEN_08BIT, 0xf0},
	{0x5592, CRL_REG_LEN_08BIT, 0x10},
	{0x55a2, CRL_REG_LEN_08BIT, 0x6d},
	{0x55a3, CRL_REG_LEN_08BIT, 0x55},
	{0x55a4, CRL_REG_LEN_08BIT, 0xc3},
	{0x55a5, CRL_REG_LEN_08BIT, 0xb5},
	{0x55a6, CRL_REG_LEN_08BIT, 0x43},
	{0x55a7, CRL_REG_LEN_08BIT, 0x38},
	{0x55a8, CRL_REG_LEN_08BIT, 0x5f},
	{0x55a9, CRL_REG_LEN_08BIT, 0x4b},
	{0x55aa, CRL_REG_LEN_08BIT, 0xf0},
	{0x55ab, CRL_REG_LEN_08BIT, 0x10},
	{0x5581, CRL_REG_LEN_08BIT, 0x52},
	{0x5300, CRL_REG_LEN_08BIT, 0x01},
	{0x5301, CRL_REG_LEN_08BIT, 0x00},
	{0x5302, CRL_REG_LEN_08BIT, 0x00},
	{0x5303, CRL_REG_LEN_08BIT, 0x0e},
	{0x5304, CRL_REG_LEN_08BIT, 0x00},
	{0x5305, CRL_REG_LEN_08BIT, 0x0e},
	{0x5306, CRL_REG_LEN_08BIT, 0x00},
	{0x5307, CRL_REG_LEN_08BIT, 0x36},
	{0x5308, CRL_REG_LEN_08BIT, 0x00},
	{0x5309, CRL_REG_LEN_08BIT, 0xd9},
	{0x530a, CRL_REG_LEN_08BIT, 0x00},
	{0x530b, CRL_REG_LEN_08BIT, 0x0f},
	{0x530c, CRL_REG_LEN_08BIT, 0x00},
	{0x530d, CRL_REG_LEN_08BIT, 0x2c},
	{0x530e, CRL_REG_LEN_08BIT, 0x00},
	{0x530f, CRL_REG_LEN_08BIT, 0x59},
	{0x5310, CRL_REG_LEN_08BIT, 0x00},
	{0x5311, CRL_REG_LEN_08BIT, 0x7b},
	{0x5312, CRL_REG_LEN_08BIT, 0x00},
	{0x5313, CRL_REG_LEN_08BIT, 0x22},
	{0x5314, CRL_REG_LEN_08BIT, 0x00},
	{0x5315, CRL_REG_LEN_08BIT, 0xd5},
	{0x5316, CRL_REG_LEN_08BIT, 0x00},
	{0x5317, CRL_REG_LEN_08BIT, 0x13},
	{0x5318, CRL_REG_LEN_08BIT, 0x00},
	{0x5319, CRL_REG_LEN_08BIT, 0x18},
	{0x531a, CRL_REG_LEN_08BIT, 0x00},
	{0x531b, CRL_REG_LEN_08BIT, 0x26},
	{0x531c, CRL_REG_LEN_08BIT, 0x00},
	{0x531d, CRL_REG_LEN_08BIT, 0xdc},
	{0x531e, CRL_REG_LEN_08BIT, 0x00},
	{0x531f, CRL_REG_LEN_08BIT, 0x02},
	{0x5320, CRL_REG_LEN_08BIT, 0x00},
	{0x5321, CRL_REG_LEN_08BIT, 0x24},
	{0x5322, CRL_REG_LEN_08BIT, 0x00},
	{0x5323, CRL_REG_LEN_08BIT, 0x56},
	{0x5324, CRL_REG_LEN_08BIT, 0x00},
	{0x5325, CRL_REG_LEN_08BIT, 0x85},
	{0x5326, CRL_REG_LEN_08BIT, 0x00},
	{0x5327, CRL_REG_LEN_08BIT, 0x20},
	{0x5609, CRL_REG_LEN_08BIT, 0x01},
	{0x560a, CRL_REG_LEN_08BIT, 0x40},
	{0x560b, CRL_REG_LEN_08BIT, 0x01},
	{0x560c, CRL_REG_LEN_08BIT, 0x40},
	{0x560d, CRL_REG_LEN_08BIT, 0x00},
	{0x560e, CRL_REG_LEN_08BIT, 0xfa},
	{0x560f, CRL_REG_LEN_08BIT, 0x00},
	{0x5610, CRL_REG_LEN_08BIT, 0xfa},
	{0x5611, CRL_REG_LEN_08BIT, 0x02},
	{0x5612, CRL_REG_LEN_08BIT, 0x80},
	{0x5613, CRL_REG_LEN_08BIT, 0x02},
	{0x5614, CRL_REG_LEN_08BIT, 0x80},
	{0x5615, CRL_REG_LEN_08BIT, 0x01},
	{0x5616, CRL_REG_LEN_08BIT, 0x2c},
	{0x5617, CRL_REG_LEN_08BIT, 0x01},
	{0x5618, CRL_REG_LEN_08BIT, 0x2c},
	{0x563b, CRL_REG_LEN_08BIT, 0x01},
	{0x563c, CRL_REG_LEN_08BIT, 0x01},
	{0x563d, CRL_REG_LEN_08BIT, 0x01},
	{0x563e, CRL_REG_LEN_08BIT, 0x01},
	{0x563f, CRL_REG_LEN_08BIT, 0x03},
	{0x5640, CRL_REG_LEN_08BIT, 0x03},
	{0x5641, CRL_REG_LEN_08BIT, 0x03},
	{0x5642, CRL_REG_LEN_08BIT, 0x05},
	{0x5643, CRL_REG_LEN_08BIT, 0x09},
	{0x5644, CRL_REG_LEN_08BIT, 0x05},
	{0x5645, CRL_REG_LEN_08BIT, 0x05},
	{0x5646, CRL_REG_LEN_08BIT, 0x05},
	{0x5647, CRL_REG_LEN_08BIT, 0x05},
	{0x5651, CRL_REG_LEN_08BIT, 0x00},
	{0x5652, CRL_REG_LEN_08BIT, 0x80},
	{0x521a, CRL_REG_LEN_08BIT, 0x01},
	{0x521b, CRL_REG_LEN_08BIT, 0x03},
	{0x521c, CRL_REG_LEN_08BIT, 0x06},
	{0x521d, CRL_REG_LEN_08BIT, 0x0a},
	{0x521e, CRL_REG_LEN_08BIT, 0x0e},
	{0x521f, CRL_REG_LEN_08BIT, 0x12},
	{0x5220, CRL_REG_LEN_08BIT, 0x16},
	{0x5223, CRL_REG_LEN_08BIT, 0x02},
	{0x5225, CRL_REG_LEN_08BIT, 0x04},
	{0x5227, CRL_REG_LEN_08BIT, 0x08},
	{0x5229, CRL_REG_LEN_08BIT, 0x0c},
	{0x522b, CRL_REG_LEN_08BIT, 0x12},
	{0x522d, CRL_REG_LEN_08BIT, 0x18},
	{0x522f, CRL_REG_LEN_08BIT, 0x1e},
	{0x5241, CRL_REG_LEN_08BIT, 0x04},
	{0x5242, CRL_REG_LEN_08BIT, 0x01},
	{0x5243, CRL_REG_LEN_08BIT, 0x03},
	{0x5244, CRL_REG_LEN_08BIT, 0x06},
	{0x5245, CRL_REG_LEN_08BIT, 0x0a},
	{0x5246, CRL_REG_LEN_08BIT, 0x0e},
	{0x5247, CRL_REG_LEN_08BIT, 0x12},
	{0x5248, CRL_REG_LEN_08BIT, 0x16},
	{0x524a, CRL_REG_LEN_08BIT, 0x03},
	{0x524c, CRL_REG_LEN_08BIT, 0x04},
	{0x524e, CRL_REG_LEN_08BIT, 0x08},
	{0x5250, CRL_REG_LEN_08BIT, 0x0c},
	{0x5252, CRL_REG_LEN_08BIT, 0x12},
	{0x5254, CRL_REG_LEN_08BIT, 0x18},
	{0x5256, CRL_REG_LEN_08BIT, 0x1e},
	{0x4606, CRL_REG_LEN_08BIT, 0x07},
	{0x4607, CRL_REG_LEN_08BIT, 0x71},
	{0x460a, CRL_REG_LEN_08BIT, 0x02},
	{0x460b, CRL_REG_LEN_08BIT, 0x70},
	{0x460c, CRL_REG_LEN_08BIT, 0x00},
	{0x4620, CRL_REG_LEN_08BIT, 0x0e},
	{0x4700, CRL_REG_LEN_08BIT, 0x04},
	{0x4701, CRL_REG_LEN_08BIT, 0x00},
	{0x4702, CRL_REG_LEN_08BIT, 0x01},
	{0x4004, CRL_REG_LEN_08BIT, 0x04},
	{0x4005, CRL_REG_LEN_08BIT, 0x18},
	{0x4001, CRL_REG_LEN_08BIT, 0x06},
	{0x4050, CRL_REG_LEN_08BIT, 0x22},
	{0x4051, CRL_REG_LEN_08BIT, 0x24},
	{0x4052, CRL_REG_LEN_08BIT, 0x02},
	{0x4057, CRL_REG_LEN_08BIT, 0x9c},
	{0x405a, CRL_REG_LEN_08BIT, 0x00},
	/*FSIN enable*/
	{0x3832, CRL_REG_LEN_08BIT, 0x00},
	{0x3833, CRL_REG_LEN_08BIT, 0x02},
	{0x3834, CRL_REG_LEN_08BIT, 0x02},
	{0x3835, CRL_REG_LEN_08BIT, 0x08},
	{0x302e, CRL_REG_LEN_08BIT, 0x00},
	/*FSIN end*/
	{0x4202, CRL_REG_LEN_08BIT, 0x02},
	{0x3023, CRL_REG_LEN_08BIT, 0x10},
	{0x3003, CRL_REG_LEN_08BIT, 0x20},
	{0x3004, CRL_REG_LEN_08BIT, 0x21},
	{0x3005, CRL_REG_LEN_08BIT, 0x14},
	{0x3006, CRL_REG_LEN_08BIT, 0x11},
	{0x3024, CRL_REG_LEN_08BIT, 0x01},
	{0x0100, CRL_REG_LEN_08BIT, 0x01},
	{0x0100, CRL_REG_LEN_08BIT, 0x01},
	{0x6f10, CRL_REG_LEN_08BIT, 0x07},
	{0x6f11, CRL_REG_LEN_08BIT, 0x82},
	{0x6f12, CRL_REG_LEN_08BIT, 0x04},
	{0x6f13, CRL_REG_LEN_08BIT, 0x00},
	{0x6f14, CRL_REG_LEN_08BIT, 0x1f},
	{0x6f15, CRL_REG_LEN_08BIT, 0xdd},
	{0x6f16, CRL_REG_LEN_08BIT, 0x04},
	{0x6f17, CRL_REG_LEN_08BIT, 0x04},
	{0x6f18, CRL_REG_LEN_08BIT, 0x36},
	{0x6f19, CRL_REG_LEN_08BIT, 0x66},
	{0x6f1a, CRL_REG_LEN_08BIT, 0x04},
	{0x6f1b, CRL_REG_LEN_08BIT, 0x08},
	{0x6f1c, CRL_REG_LEN_08BIT, 0x0c},
	{0x6f1d, CRL_REG_LEN_08BIT, 0xe7},
	{0x6f1e, CRL_REG_LEN_08BIT, 0x04},
	{0x6f1f, CRL_REG_LEN_08BIT, 0x0c},
	{0xd000, CRL_REG_LEN_08BIT, 0x19},
	{0xd001, CRL_REG_LEN_08BIT, 0xa0},
	{0xd002, CRL_REG_LEN_08BIT, 0x00},
	{0xd003, CRL_REG_LEN_08BIT, 0x01},
	{0xd004, CRL_REG_LEN_08BIT, 0xa9},
	{0xd005, CRL_REG_LEN_08BIT, 0xad},
	{0xd006, CRL_REG_LEN_08BIT, 0x10},
	{0xd007, CRL_REG_LEN_08BIT, 0x40},
	{0xd008, CRL_REG_LEN_08BIT, 0x44},
	{0xd009, CRL_REG_LEN_08BIT, 0x00},
	{0xd00a, CRL_REG_LEN_08BIT, 0x68},
	{0xd00b, CRL_REG_LEN_08BIT, 0x00},
	{0xd00c, CRL_REG_LEN_08BIT, 0x15},
	{0xd00d, CRL_REG_LEN_08BIT, 0x00},
	{0xd00e, CRL_REG_LEN_08BIT, 0x00},
	{0xd00f, CRL_REG_LEN_08BIT, 0x00},
	{0xd010, CRL_REG_LEN_08BIT, 0x19},
	{0xd011, CRL_REG_LEN_08BIT, 0xa0},
	{0xd012, CRL_REG_LEN_08BIT, 0x00},
	{0xd013, CRL_REG_LEN_08BIT, 0x01},
	{0xd014, CRL_REG_LEN_08BIT, 0xa9},
	{0xd015, CRL_REG_LEN_08BIT, 0xad},
	{0xd016, CRL_REG_LEN_08BIT, 0x13},
	{0xd017, CRL_REG_LEN_08BIT, 0xd0},
	{0xd018, CRL_REG_LEN_08BIT, 0x44},
	{0xd019, CRL_REG_LEN_08BIT, 0x00},
	{0xd01a, CRL_REG_LEN_08BIT, 0x68},
	{0xd01b, CRL_REG_LEN_08BIT, 0x00},
	{0xd01c, CRL_REG_LEN_08BIT, 0x15},
	{0xd01d, CRL_REG_LEN_08BIT, 0x00},
	{0xd01e, CRL_REG_LEN_08BIT, 0x00},
	{0xd01f, CRL_REG_LEN_08BIT, 0x00},
	{0xd020, CRL_REG_LEN_08BIT, 0x19},
	{0xd021, CRL_REG_LEN_08BIT, 0xa0},
	{0xd022, CRL_REG_LEN_08BIT, 0x00},
	{0xd023, CRL_REG_LEN_08BIT, 0x01},
	{0xd024, CRL_REG_LEN_08BIT, 0xa9},
	{0xd025, CRL_REG_LEN_08BIT, 0xad},
	{0xd026, CRL_REG_LEN_08BIT, 0x14},
	{0xd027, CRL_REG_LEN_08BIT, 0xb8},
	{0xd028, CRL_REG_LEN_08BIT, 0x44},
	{0xd029, CRL_REG_LEN_08BIT, 0x00},
	{0xd02a, CRL_REG_LEN_08BIT, 0x68},
	{0xd02b, CRL_REG_LEN_08BIT, 0x00},
	{0xd02c, CRL_REG_LEN_08BIT, 0x15},
	{0xd02d, CRL_REG_LEN_08BIT, 0x00},
	{0xd02e, CRL_REG_LEN_08BIT, 0x00},
	{0xd02f, CRL_REG_LEN_08BIT, 0x00},
	{0xd030, CRL_REG_LEN_08BIT, 0x19},
	{0xd031, CRL_REG_LEN_08BIT, 0xa0},
	{0xd032, CRL_REG_LEN_08BIT, 0x00},
	{0xd033, CRL_REG_LEN_08BIT, 0x01},
	{0xd034, CRL_REG_LEN_08BIT, 0xa9},
	{0xd035, CRL_REG_LEN_08BIT, 0xad},
	{0xd036, CRL_REG_LEN_08BIT, 0x14},
	{0xd037, CRL_REG_LEN_08BIT, 0xdc},
	{0xd038, CRL_REG_LEN_08BIT, 0x44},
	{0xd039, CRL_REG_LEN_08BIT, 0x00},
	{0xd03a, CRL_REG_LEN_08BIT, 0x68},
	{0xd03b, CRL_REG_LEN_08BIT, 0x00},
	{0xd03c, CRL_REG_LEN_08BIT, 0x15},
	{0xd03d, CRL_REG_LEN_08BIT, 0x00},
	{0xd03e, CRL_REG_LEN_08BIT, 0x00},
	{0xd03f, CRL_REG_LEN_08BIT, 0x00},
	{0xd040, CRL_REG_LEN_08BIT, 0x9c},
	{0xd041, CRL_REG_LEN_08BIT, 0x21},
	{0xd042, CRL_REG_LEN_08BIT, 0xff},
	{0xd043, CRL_REG_LEN_08BIT, 0xe4},
	{0xd044, CRL_REG_LEN_08BIT, 0xd4},
	{0xd045, CRL_REG_LEN_08BIT, 0x01},
	{0xd046, CRL_REG_LEN_08BIT, 0x48},
	{0xd047, CRL_REG_LEN_08BIT, 0x00},
	{0xd048, CRL_REG_LEN_08BIT, 0xd4},
	{0xd049, CRL_REG_LEN_08BIT, 0x01},
	{0xd04a, CRL_REG_LEN_08BIT, 0x50},
	{0xd04b, CRL_REG_LEN_08BIT, 0x04},
	{0xd04c, CRL_REG_LEN_08BIT, 0xd4},
	{0xd04d, CRL_REG_LEN_08BIT, 0x01},
	{0xd04e, CRL_REG_LEN_08BIT, 0x60},
	{0xd04f, CRL_REG_LEN_08BIT, 0x08},
	{0xd050, CRL_REG_LEN_08BIT, 0xd4},
	{0xd051, CRL_REG_LEN_08BIT, 0x01},
	{0xd052, CRL_REG_LEN_08BIT, 0x70},
	{0xd053, CRL_REG_LEN_08BIT, 0x0c},
	{0xd054, CRL_REG_LEN_08BIT, 0xd4},
	{0xd055, CRL_REG_LEN_08BIT, 0x01},
	{0xd056, CRL_REG_LEN_08BIT, 0x80},
	{0xd057, CRL_REG_LEN_08BIT, 0x10},
	{0xd058, CRL_REG_LEN_08BIT, 0x19},
	{0xd059, CRL_REG_LEN_08BIT, 0xc0},
	{0xd05a, CRL_REG_LEN_08BIT, 0x00},
	{0xd05b, CRL_REG_LEN_08BIT, 0x01},
	{0xd05c, CRL_REG_LEN_08BIT, 0xa9},
	{0xd05d, CRL_REG_LEN_08BIT, 0xce},
	{0xd05e, CRL_REG_LEN_08BIT, 0x02},
	{0xd05f, CRL_REG_LEN_08BIT, 0xa4},
	{0xd060, CRL_REG_LEN_08BIT, 0x9c},
	{0xd061, CRL_REG_LEN_08BIT, 0xa0},
	{0xd062, CRL_REG_LEN_08BIT, 0x00},
	{0xd063, CRL_REG_LEN_08BIT, 0x00},
	{0xd064, CRL_REG_LEN_08BIT, 0x84},
	{0xd065, CRL_REG_LEN_08BIT, 0x6e},
	{0xd066, CRL_REG_LEN_08BIT, 0x00},
	{0xd067, CRL_REG_LEN_08BIT, 0x00},
	{0xd068, CRL_REG_LEN_08BIT, 0xd8},
	{0xd069, CRL_REG_LEN_08BIT, 0x03},
	{0xd06a, CRL_REG_LEN_08BIT, 0x28},
	{0xd06b, CRL_REG_LEN_08BIT, 0x76},
	{0xd06c, CRL_REG_LEN_08BIT, 0x1a},
	{0xd06d, CRL_REG_LEN_08BIT, 0x00},
	{0xd06e, CRL_REG_LEN_08BIT, 0x00},
	{0xd06f, CRL_REG_LEN_08BIT, 0x01},
	{0xd070, CRL_REG_LEN_08BIT, 0xaa},
	{0xd071, CRL_REG_LEN_08BIT, 0x10},
	{0xd072, CRL_REG_LEN_08BIT, 0x03},
	{0xd073, CRL_REG_LEN_08BIT, 0xf0},
	{0xd074, CRL_REG_LEN_08BIT, 0x18},
	{0xd075, CRL_REG_LEN_08BIT, 0x60},
	{0xd076, CRL_REG_LEN_08BIT, 0x00},
	{0xd077, CRL_REG_LEN_08BIT, 0x01},
	{0xd078, CRL_REG_LEN_08BIT, 0xa8},
	{0xd079, CRL_REG_LEN_08BIT, 0x63},
	{0xd07a, CRL_REG_LEN_08BIT, 0x07},
	{0xd07b, CRL_REG_LEN_08BIT, 0x80},
	{0xd07c, CRL_REG_LEN_08BIT, 0xe0},
	{0xd07d, CRL_REG_LEN_08BIT, 0xa0},
	{0xd07e, CRL_REG_LEN_08BIT, 0x00},
	{0xd07f, CRL_REG_LEN_08BIT, 0x04},
	{0xd080, CRL_REG_LEN_08BIT, 0x18},
	{0xd081, CRL_REG_LEN_08BIT, 0xc0},
	{0xd082, CRL_REG_LEN_08BIT, 0x00},
	{0xd083, CRL_REG_LEN_08BIT, 0x00},
	{0xd084, CRL_REG_LEN_08BIT, 0xa8},
	{0xd085, CRL_REG_LEN_08BIT, 0xc6},
	{0xd086, CRL_REG_LEN_08BIT, 0x00},
	{0xd087, CRL_REG_LEN_08BIT, 0x00},
	{0xd088, CRL_REG_LEN_08BIT, 0x8c},
	{0xd089, CRL_REG_LEN_08BIT, 0x63},
	{0xd08a, CRL_REG_LEN_08BIT, 0x00},
	{0xd08b, CRL_REG_LEN_08BIT, 0x00},
	{0xd08c, CRL_REG_LEN_08BIT, 0xd4},
	{0xd08d, CRL_REG_LEN_08BIT, 0x01},
	{0xd08e, CRL_REG_LEN_08BIT, 0x28},
	{0xd08f, CRL_REG_LEN_08BIT, 0x14},
	{0xd090, CRL_REG_LEN_08BIT, 0xd4},
	{0xd091, CRL_REG_LEN_08BIT, 0x01},
	{0xd092, CRL_REG_LEN_08BIT, 0x30},
	{0xd093, CRL_REG_LEN_08BIT, 0x18},
	{0xd094, CRL_REG_LEN_08BIT, 0x07},
	{0xd095, CRL_REG_LEN_08BIT, 0xff},
	{0xd096, CRL_REG_LEN_08BIT, 0xf8},
	{0xd097, CRL_REG_LEN_08BIT, 0xfd},
	{0xd098, CRL_REG_LEN_08BIT, 0x9c},
	{0xd099, CRL_REG_LEN_08BIT, 0x80},
	{0xd09a, CRL_REG_LEN_08BIT, 0x00},
	{0xd09b, CRL_REG_LEN_08BIT, 0x03},
	{0xd09c, CRL_REG_LEN_08BIT, 0xa5},
	{0xd09d, CRL_REG_LEN_08BIT, 0x6b},
	{0xd09e, CRL_REG_LEN_08BIT, 0x00},
	{0xd09f, CRL_REG_LEN_08BIT, 0xff},
	{0xd0a0, CRL_REG_LEN_08BIT, 0x18},
	{0xd0a1, CRL_REG_LEN_08BIT, 0xc0},
	{0xd0a2, CRL_REG_LEN_08BIT, 0x00},
	{0xd0a3, CRL_REG_LEN_08BIT, 0x01},
	{0xd0a4, CRL_REG_LEN_08BIT, 0xa8},
	{0xd0a5, CRL_REG_LEN_08BIT, 0xc6},
	{0xd0a6, CRL_REG_LEN_08BIT, 0x01},
	{0xd0a7, CRL_REG_LEN_08BIT, 0x02},
	{0xd0a8, CRL_REG_LEN_08BIT, 0xe1},
	{0xd0a9, CRL_REG_LEN_08BIT, 0x6b},
	{0xd0aa, CRL_REG_LEN_08BIT, 0x58},
	{0xd0ab, CRL_REG_LEN_08BIT, 0x00},
	{0xd0ac, CRL_REG_LEN_08BIT, 0x84},
	{0xd0ad, CRL_REG_LEN_08BIT, 0x8e},
	{0xd0ae, CRL_REG_LEN_08BIT, 0x00},
	{0xd0af, CRL_REG_LEN_08BIT, 0x00},
	{0xd0b0, CRL_REG_LEN_08BIT, 0xe1},
	{0xd0b1, CRL_REG_LEN_08BIT, 0x6b},
	{0xd0b2, CRL_REG_LEN_08BIT, 0x30},
	{0xd0b3, CRL_REG_LEN_08BIT, 0x00},
	{0xd0b4, CRL_REG_LEN_08BIT, 0x98},
	{0xd0b5, CRL_REG_LEN_08BIT, 0xb0},
	{0xd0b6, CRL_REG_LEN_08BIT, 0x00},
	{0xd0b7, CRL_REG_LEN_08BIT, 0x00},
	{0xd0b8, CRL_REG_LEN_08BIT, 0x8c},
	{0xd0b9, CRL_REG_LEN_08BIT, 0x64},
	{0xd0ba, CRL_REG_LEN_08BIT, 0x00},
	{0xd0bb, CRL_REG_LEN_08BIT, 0x6e},
	{0xd0bc, CRL_REG_LEN_08BIT, 0xe5},
	{0xd0bd, CRL_REG_LEN_08BIT, 0xa5},
	{0xd0be, CRL_REG_LEN_08BIT, 0x18},
	{0xd0bf, CRL_REG_LEN_08BIT, 0x00},
	{0xd0c0, CRL_REG_LEN_08BIT, 0x10},
	{0xd0c1, CRL_REG_LEN_08BIT, 0x00},
	{0xd0c2, CRL_REG_LEN_08BIT, 0x00},
	{0xd0c3, CRL_REG_LEN_08BIT, 0x06},
	{0xd0c4, CRL_REG_LEN_08BIT, 0x95},
	{0xd0c5, CRL_REG_LEN_08BIT, 0x8b},
	{0xd0c6, CRL_REG_LEN_08BIT, 0x00},
	{0xd0c7, CRL_REG_LEN_08BIT, 0x00},
	{0xd0c8, CRL_REG_LEN_08BIT, 0x94},
	{0xd0c9, CRL_REG_LEN_08BIT, 0xa4},
	{0xd0ca, CRL_REG_LEN_08BIT, 0x00},
	{0xd0cb, CRL_REG_LEN_08BIT, 0x70},
	{0xd0cc, CRL_REG_LEN_08BIT, 0xe5},
	{0xd0cd, CRL_REG_LEN_08BIT, 0x65},
	{0xd0ce, CRL_REG_LEN_08BIT, 0x60},
	{0xd0cf, CRL_REG_LEN_08BIT, 0x00},
	{0xd0d0, CRL_REG_LEN_08BIT, 0x0c},
	{0xd0d1, CRL_REG_LEN_08BIT, 0x00},
	{0xd0d2, CRL_REG_LEN_08BIT, 0x00},
	{0xd0d3, CRL_REG_LEN_08BIT, 0x62},
	{0xd0d4, CRL_REG_LEN_08BIT, 0x15},
	{0xd0d5, CRL_REG_LEN_08BIT, 0x00},
	{0xd0d6, CRL_REG_LEN_08BIT, 0x00},
	{0xd0d7, CRL_REG_LEN_08BIT, 0x00},
	{0xd0d8, CRL_REG_LEN_08BIT, 0x18},
	{0xd0d9, CRL_REG_LEN_08BIT, 0x60},
	{0xd0da, CRL_REG_LEN_08BIT, 0x80},
	{0xd0db, CRL_REG_LEN_08BIT, 0x06},
	{0xd0dc, CRL_REG_LEN_08BIT, 0xa8},
	{0xd0dd, CRL_REG_LEN_08BIT, 0x83},
	{0xd0de, CRL_REG_LEN_08BIT, 0x38},
	{0xd0df, CRL_REG_LEN_08BIT, 0x29},
	{0xd0e0, CRL_REG_LEN_08BIT, 0xa8},
	{0xd0e1, CRL_REG_LEN_08BIT, 0xe3},
	{0xd0e2, CRL_REG_LEN_08BIT, 0x40},
	{0xd0e3, CRL_REG_LEN_08BIT, 0x08},
	{0xd0e4, CRL_REG_LEN_08BIT, 0x8c},
	{0xd0e5, CRL_REG_LEN_08BIT, 0x84},
	{0xd0e6, CRL_REG_LEN_08BIT, 0x00},
	{0xd0e7, CRL_REG_LEN_08BIT, 0x00},
	{0xd0e8, CRL_REG_LEN_08BIT, 0xa8},
	{0xd0e9, CRL_REG_LEN_08BIT, 0xa3},
	{0xd0ea, CRL_REG_LEN_08BIT, 0x40},
	{0xd0eb, CRL_REG_LEN_08BIT, 0x09},
	{0xd0ec, CRL_REG_LEN_08BIT, 0xa8},
	{0xd0ed, CRL_REG_LEN_08BIT, 0xc3},
	{0xd0ee, CRL_REG_LEN_08BIT, 0x38},
	{0xd0ef, CRL_REG_LEN_08BIT, 0x2a},
	{0xd0f0, CRL_REG_LEN_08BIT, 0xd8},
	{0xd0f1, CRL_REG_LEN_08BIT, 0x07},
	{0xd0f2, CRL_REG_LEN_08BIT, 0x20},
	{0xd0f3, CRL_REG_LEN_08BIT, 0x00},
	{0xd0f4, CRL_REG_LEN_08BIT, 0x8c},
	{0xd0f5, CRL_REG_LEN_08BIT, 0x66},
	{0xd0f6, CRL_REG_LEN_08BIT, 0x00},
	{0xd0f7, CRL_REG_LEN_08BIT, 0x00},
	{0xd0f8, CRL_REG_LEN_08BIT, 0xd8},
	{0xd0f9, CRL_REG_LEN_08BIT, 0x05},
	{0xd0fa, CRL_REG_LEN_08BIT, 0x18},
	{0xd0fb, CRL_REG_LEN_08BIT, 0x00},
	{0xd0fc, CRL_REG_LEN_08BIT, 0x18},
	{0xd0fd, CRL_REG_LEN_08BIT, 0x60},
	{0xd0fe, CRL_REG_LEN_08BIT, 0x00},
	{0xd0ff, CRL_REG_LEN_08BIT, 0x01},
	{0xd100, CRL_REG_LEN_08BIT, 0x98},
	{0xd101, CRL_REG_LEN_08BIT, 0x90},
	{0xd102, CRL_REG_LEN_08BIT, 0x00},
	{0xd103, CRL_REG_LEN_08BIT, 0x00},
	{0xd104, CRL_REG_LEN_08BIT, 0x84},
	{0xd105, CRL_REG_LEN_08BIT, 0xae},
	{0xd106, CRL_REG_LEN_08BIT, 0x00},
	{0xd107, CRL_REG_LEN_08BIT, 0x00},
	{0xd108, CRL_REG_LEN_08BIT, 0xa8},
	{0xd109, CRL_REG_LEN_08BIT, 0x63},
	{0xd10a, CRL_REG_LEN_08BIT, 0x06},
	{0xd10b, CRL_REG_LEN_08BIT, 0x4c},
	{0xd10c, CRL_REG_LEN_08BIT, 0x9c},
	{0xd10d, CRL_REG_LEN_08BIT, 0xc0},
	{0xd10e, CRL_REG_LEN_08BIT, 0x00},
	{0xd10f, CRL_REG_LEN_08BIT, 0x00},
	{0xd110, CRL_REG_LEN_08BIT, 0xd8},
	{0xd111, CRL_REG_LEN_08BIT, 0x03},
	{0xd112, CRL_REG_LEN_08BIT, 0x30},
	{0xd113, CRL_REG_LEN_08BIT, 0x00},
	{0xd114, CRL_REG_LEN_08BIT, 0x8c},
	{0xd115, CRL_REG_LEN_08BIT, 0x65},
	{0xd116, CRL_REG_LEN_08BIT, 0x00},
	{0xd117, CRL_REG_LEN_08BIT, 0x6e},
	{0xd118, CRL_REG_LEN_08BIT, 0xe5},
	{0xd119, CRL_REG_LEN_08BIT, 0x84},
	{0xd11a, CRL_REG_LEN_08BIT, 0x18},
	{0xd11b, CRL_REG_LEN_08BIT, 0x00},
	{0xd11c, CRL_REG_LEN_08BIT, 0x10},
	{0xd11d, CRL_REG_LEN_08BIT, 0x00},
	{0xd11e, CRL_REG_LEN_08BIT, 0x00},
	{0xd11f, CRL_REG_LEN_08BIT, 0x07},
	{0xd120, CRL_REG_LEN_08BIT, 0x18},
	{0xd121, CRL_REG_LEN_08BIT, 0x80},
	{0xd122, CRL_REG_LEN_08BIT, 0x80},
	{0xd123, CRL_REG_LEN_08BIT, 0x06},
	{0xd124, CRL_REG_LEN_08BIT, 0x94},
	{0xd125, CRL_REG_LEN_08BIT, 0x65},
	{0xd126, CRL_REG_LEN_08BIT, 0x00},
	{0xd127, CRL_REG_LEN_08BIT, 0x70},
	{0xd128, CRL_REG_LEN_08BIT, 0xe5},
	{0xd129, CRL_REG_LEN_08BIT, 0x43},
	{0xd12a, CRL_REG_LEN_08BIT, 0x60},
	{0xd12b, CRL_REG_LEN_08BIT, 0x00},
	{0xd12c, CRL_REG_LEN_08BIT, 0x0c},
	{0xd12d, CRL_REG_LEN_08BIT, 0x00},
	{0xd12e, CRL_REG_LEN_08BIT, 0x00},
	{0xd12f, CRL_REG_LEN_08BIT, 0x3e},
	{0xd130, CRL_REG_LEN_08BIT, 0xa8},
	{0xd131, CRL_REG_LEN_08BIT, 0x64},
	{0xd132, CRL_REG_LEN_08BIT, 0x38},
	{0xd133, CRL_REG_LEN_08BIT, 0x24},
	{0xd134, CRL_REG_LEN_08BIT, 0x18},
	{0xd135, CRL_REG_LEN_08BIT, 0x80},
	{0xd136, CRL_REG_LEN_08BIT, 0x80},
	{0xd137, CRL_REG_LEN_08BIT, 0x06},
	{0xd138, CRL_REG_LEN_08BIT, 0xa8},
	{0xd139, CRL_REG_LEN_08BIT, 0x64},
	{0xd13a, CRL_REG_LEN_08BIT, 0x38},
	{0xd13b, CRL_REG_LEN_08BIT, 0x24},
	{0xd13c, CRL_REG_LEN_08BIT, 0x8c},
	{0xd13d, CRL_REG_LEN_08BIT, 0x63},
	{0xd13e, CRL_REG_LEN_08BIT, 0x00},
	{0xd13f, CRL_REG_LEN_08BIT, 0x00},
	{0xd140, CRL_REG_LEN_08BIT, 0xa4},
	{0xd141, CRL_REG_LEN_08BIT, 0x63},
	{0xd142, CRL_REG_LEN_08BIT, 0x00},
	{0xd143, CRL_REG_LEN_08BIT, 0x40},
	{0xd144, CRL_REG_LEN_08BIT, 0xbc},
	{0xd145, CRL_REG_LEN_08BIT, 0x23},
	{0xd146, CRL_REG_LEN_08BIT, 0x00},
	{0xd147, CRL_REG_LEN_08BIT, 0x00},
	{0xd148, CRL_REG_LEN_08BIT, 0x0c},
	{0xd149, CRL_REG_LEN_08BIT, 0x00},
	{0xd14a, CRL_REG_LEN_08BIT, 0x00},
	{0xd14b, CRL_REG_LEN_08BIT, 0x2a},
	{0xd14c, CRL_REG_LEN_08BIT, 0xa8},
	{0xd14d, CRL_REG_LEN_08BIT, 0x64},
	{0xd14e, CRL_REG_LEN_08BIT, 0x6e},
	{0xd14f, CRL_REG_LEN_08BIT, 0x44},
	{0xd150, CRL_REG_LEN_08BIT, 0x19},
	{0xd151, CRL_REG_LEN_08BIT, 0x00},
	{0xd152, CRL_REG_LEN_08BIT, 0x80},
	{0xd153, CRL_REG_LEN_08BIT, 0x06},
	{0xd154, CRL_REG_LEN_08BIT, 0xa8},
	{0xd155, CRL_REG_LEN_08BIT, 0xe8},
	{0xd156, CRL_REG_LEN_08BIT, 0x3d},
	{0xd157, CRL_REG_LEN_08BIT, 0x05},
	{0xd158, CRL_REG_LEN_08BIT, 0x8c},
	{0xd159, CRL_REG_LEN_08BIT, 0x67},
	{0xd15a, CRL_REG_LEN_08BIT, 0x00},
	{0xd15b, CRL_REG_LEN_08BIT, 0x00},
	{0xd15c, CRL_REG_LEN_08BIT, 0xb8},
	{0xd15d, CRL_REG_LEN_08BIT, 0x63},
	{0xd15e, CRL_REG_LEN_08BIT, 0x00},
	{0xd15f, CRL_REG_LEN_08BIT, 0x18},
	{0xd160, CRL_REG_LEN_08BIT, 0xb8},
	{0xd161, CRL_REG_LEN_08BIT, 0x63},
	{0xd162, CRL_REG_LEN_08BIT, 0x00},
	{0xd163, CRL_REG_LEN_08BIT, 0x98},
	{0xd164, CRL_REG_LEN_08BIT, 0xbc},
	{0xd165, CRL_REG_LEN_08BIT, 0x03},
	{0xd166, CRL_REG_LEN_08BIT, 0x00},
	{0xd167, CRL_REG_LEN_08BIT, 0x00},
	{0xd168, CRL_REG_LEN_08BIT, 0x10},
	{0xd169, CRL_REG_LEN_08BIT, 0x00},
	{0xd16a, CRL_REG_LEN_08BIT, 0x00},
	{0xd16b, CRL_REG_LEN_08BIT, 0x10},
	{0xd16c, CRL_REG_LEN_08BIT, 0xa9},
	{0xd16d, CRL_REG_LEN_08BIT, 0x48},
	{0xd16e, CRL_REG_LEN_08BIT, 0x67},
	{0xd16f, CRL_REG_LEN_08BIT, 0x02},
	{0xd170, CRL_REG_LEN_08BIT, 0xb8},
	{0xd171, CRL_REG_LEN_08BIT, 0xa3},
	{0xd172, CRL_REG_LEN_08BIT, 0x00},
	{0xd173, CRL_REG_LEN_08BIT, 0x19},
	{0xd174, CRL_REG_LEN_08BIT, 0x8c},
	{0xd175, CRL_REG_LEN_08BIT, 0x8a},
	{0xd176, CRL_REG_LEN_08BIT, 0x00},
	{0xd177, CRL_REG_LEN_08BIT, 0x00},
	{0xd178, CRL_REG_LEN_08BIT, 0xa9},
	{0xd179, CRL_REG_LEN_08BIT, 0x68},
	{0xd17a, CRL_REG_LEN_08BIT, 0x67},
	{0xd17b, CRL_REG_LEN_08BIT, 0x03},
	{0xd17c, CRL_REG_LEN_08BIT, 0xb8},
	{0xd17d, CRL_REG_LEN_08BIT, 0xc4},
	{0xd17e, CRL_REG_LEN_08BIT, 0x00},
	{0xd17f, CRL_REG_LEN_08BIT, 0x08},
	{0xd180, CRL_REG_LEN_08BIT, 0x8c},
	{0xd181, CRL_REG_LEN_08BIT, 0x6b},
	{0xd182, CRL_REG_LEN_08BIT, 0x00},
	{0xd183, CRL_REG_LEN_08BIT, 0x00},
	{0xd184, CRL_REG_LEN_08BIT, 0xb8},
	{0xd185, CRL_REG_LEN_08BIT, 0x85},
	{0xd186, CRL_REG_LEN_08BIT, 0x00},
	{0xd187, CRL_REG_LEN_08BIT, 0x98},
	{0xd188, CRL_REG_LEN_08BIT, 0xe0},
	{0xd189, CRL_REG_LEN_08BIT, 0x63},
	{0xd18a, CRL_REG_LEN_08BIT, 0x30},
	{0xd18b, CRL_REG_LEN_08BIT, 0x04},
	{0xd18c, CRL_REG_LEN_08BIT, 0xe0},
	{0xd18d, CRL_REG_LEN_08BIT, 0x64},
	{0xd18e, CRL_REG_LEN_08BIT, 0x18},
	{0xd18f, CRL_REG_LEN_08BIT, 0x00},
	{0xd190, CRL_REG_LEN_08BIT, 0xa4},
	{0xd191, CRL_REG_LEN_08BIT, 0x83},
	{0xd192, CRL_REG_LEN_08BIT, 0xff},
	{0xd193, CRL_REG_LEN_08BIT, 0xff},
	{0xd194, CRL_REG_LEN_08BIT, 0xb8},
	{0xd195, CRL_REG_LEN_08BIT, 0x64},
	{0xd196, CRL_REG_LEN_08BIT, 0x00},
	{0xd197, CRL_REG_LEN_08BIT, 0x48},
	{0xd198, CRL_REG_LEN_08BIT, 0xd8},
	{0xd199, CRL_REG_LEN_08BIT, 0x0a},
	{0xd19a, CRL_REG_LEN_08BIT, 0x18},
	{0xd19b, CRL_REG_LEN_08BIT, 0x00},
	{0xd19c, CRL_REG_LEN_08BIT, 0xd8},
	{0xd19d, CRL_REG_LEN_08BIT, 0x0b},
	{0xd19e, CRL_REG_LEN_08BIT, 0x20},
	{0xd19f, CRL_REG_LEN_08BIT, 0x00},
	{0xd1a0, CRL_REG_LEN_08BIT, 0x9c},
	{0xd1a1, CRL_REG_LEN_08BIT, 0x60},
	{0xd1a2, CRL_REG_LEN_08BIT, 0x00},
	{0xd1a3, CRL_REG_LEN_08BIT, 0x00},
	{0xd1a4, CRL_REG_LEN_08BIT, 0xd8},
	{0xd1a5, CRL_REG_LEN_08BIT, 0x07},
	{0xd1a6, CRL_REG_LEN_08BIT, 0x18},
	{0xd1a7, CRL_REG_LEN_08BIT, 0x00},
	{0xd1a8, CRL_REG_LEN_08BIT, 0xa8},
	{0xd1a9, CRL_REG_LEN_08BIT, 0x68},
	{0xd1aa, CRL_REG_LEN_08BIT, 0x38},
	{0xd1ab, CRL_REG_LEN_08BIT, 0x22},
	{0xd1ac, CRL_REG_LEN_08BIT, 0x9c},
	{0xd1ad, CRL_REG_LEN_08BIT, 0x80},
	{0xd1ae, CRL_REG_LEN_08BIT, 0x00},
	{0xd1af, CRL_REG_LEN_08BIT, 0x70},
	{0xd1b0, CRL_REG_LEN_08BIT, 0xa8},
	{0xd1b1, CRL_REG_LEN_08BIT, 0xe8},
	{0xd1b2, CRL_REG_LEN_08BIT, 0x38},
	{0xd1b3, CRL_REG_LEN_08BIT, 0x43},
	{0xd1b4, CRL_REG_LEN_08BIT, 0xd8},
	{0xd1b5, CRL_REG_LEN_08BIT, 0x03},
	{0xd1b6, CRL_REG_LEN_08BIT, 0x20},
	{0xd1b7, CRL_REG_LEN_08BIT, 0x00},
	{0xd1b8, CRL_REG_LEN_08BIT, 0x9c},
	{0xd1b9, CRL_REG_LEN_08BIT, 0xa0},
	{0xd1ba, CRL_REG_LEN_08BIT, 0x00},
	{0xd1bb, CRL_REG_LEN_08BIT, 0x00},
	{0xd1bc, CRL_REG_LEN_08BIT, 0xa8},
	{0xd1bd, CRL_REG_LEN_08BIT, 0xc8},
	{0xd1be, CRL_REG_LEN_08BIT, 0x38},
	{0xd1bf, CRL_REG_LEN_08BIT, 0x42},
	{0xd1c0, CRL_REG_LEN_08BIT, 0x8c},
	{0xd1c1, CRL_REG_LEN_08BIT, 0x66},
	{0xd1c2, CRL_REG_LEN_08BIT, 0x00},
	{0xd1c3, CRL_REG_LEN_08BIT, 0x00},
	{0xd1c4, CRL_REG_LEN_08BIT, 0x9c},
	{0xd1c5, CRL_REG_LEN_08BIT, 0xa5},
	{0xd1c6, CRL_REG_LEN_08BIT, 0x00},
	{0xd1c7, CRL_REG_LEN_08BIT, 0x01},
	{0xd1c8, CRL_REG_LEN_08BIT, 0xb8},
	{0xd1c9, CRL_REG_LEN_08BIT, 0x83},
	{0xd1ca, CRL_REG_LEN_08BIT, 0x00},
	{0xd1cb, CRL_REG_LEN_08BIT, 0x08},
	{0xd1cc, CRL_REG_LEN_08BIT, 0xa4},
	{0xd1cd, CRL_REG_LEN_08BIT, 0xa5},
	{0xd1ce, CRL_REG_LEN_08BIT, 0x00},
	{0xd1cf, CRL_REG_LEN_08BIT, 0xff},
	{0xd1d0, CRL_REG_LEN_08BIT, 0x8c},
	{0xd1d1, CRL_REG_LEN_08BIT, 0x67},
	{0xd1d2, CRL_REG_LEN_08BIT, 0x00},
	{0xd1d3, CRL_REG_LEN_08BIT, 0x00},
	{0xd1d4, CRL_REG_LEN_08BIT, 0xe0},
	{0xd1d5, CRL_REG_LEN_08BIT, 0x63},
	{0xd1d6, CRL_REG_LEN_08BIT, 0x20},
	{0xd1d7, CRL_REG_LEN_08BIT, 0x00},
	{0xd1d8, CRL_REG_LEN_08BIT, 0xa4},
	{0xd1d9, CRL_REG_LEN_08BIT, 0x63},
	{0xd1da, CRL_REG_LEN_08BIT, 0xff},
	{0xd1db, CRL_REG_LEN_08BIT, 0xff},
	{0xd1dc, CRL_REG_LEN_08BIT, 0xbc},
	{0xd1dd, CRL_REG_LEN_08BIT, 0x43},
	{0xd1de, CRL_REG_LEN_08BIT, 0x00},
	{0xd1df, CRL_REG_LEN_08BIT, 0x07},
	{0xd1e0, CRL_REG_LEN_08BIT, 0x0c},
	{0xd1e1, CRL_REG_LEN_08BIT, 0x00},
	{0xd1e2, CRL_REG_LEN_08BIT, 0x00},
	{0xd1e3, CRL_REG_LEN_08BIT, 0x5b},
	{0xd1e4, CRL_REG_LEN_08BIT, 0xbc},
	{0xd1e5, CRL_REG_LEN_08BIT, 0x05},
	{0xd1e6, CRL_REG_LEN_08BIT, 0x00},
	{0xd1e7, CRL_REG_LEN_08BIT, 0x02},
	{0xd1e8, CRL_REG_LEN_08BIT, 0x03},
	{0xd1e9, CRL_REG_LEN_08BIT, 0xff},
	{0xd1ea, CRL_REG_LEN_08BIT, 0xff},
	{0xd1eb, CRL_REG_LEN_08BIT, 0xf6},
	{0xd1ec, CRL_REG_LEN_08BIT, 0x9c},
	{0xd1ed, CRL_REG_LEN_08BIT, 0xa0},
	{0xd1ee, CRL_REG_LEN_08BIT, 0x00},
	{0xd1ef, CRL_REG_LEN_08BIT, 0x00},
	{0xd1f0, CRL_REG_LEN_08BIT, 0xa8},
	{0xd1f1, CRL_REG_LEN_08BIT, 0xa4},
	{0xd1f2, CRL_REG_LEN_08BIT, 0x55},
	{0xd1f3, CRL_REG_LEN_08BIT, 0x86},
	{0xd1f4, CRL_REG_LEN_08BIT, 0x8c},
	{0xd1f5, CRL_REG_LEN_08BIT, 0x63},
	{0xd1f6, CRL_REG_LEN_08BIT, 0x00},
	{0xd1f7, CRL_REG_LEN_08BIT, 0x00},
	{0xd1f8, CRL_REG_LEN_08BIT, 0xa8},
	{0xd1f9, CRL_REG_LEN_08BIT, 0xc4},
	{0xd1fa, CRL_REG_LEN_08BIT, 0x6e},
	{0xd1fb, CRL_REG_LEN_08BIT, 0x45},
	{0xd1fc, CRL_REG_LEN_08BIT, 0xa8},
	{0xd1fd, CRL_REG_LEN_08BIT, 0xe4},
	{0xd1fe, CRL_REG_LEN_08BIT, 0x55},
	{0xd1ff, CRL_REG_LEN_08BIT, 0x87},
	{0xd200, CRL_REG_LEN_08BIT, 0xd8},
	{0xd201, CRL_REG_LEN_08BIT, 0x05},
	{0xd202, CRL_REG_LEN_08BIT, 0x18},
	{0xd203, CRL_REG_LEN_08BIT, 0x00},
	{0xd204, CRL_REG_LEN_08BIT, 0x8c},
	{0xd205, CRL_REG_LEN_08BIT, 0x66},
	{0xd206, CRL_REG_LEN_08BIT, 0x00},
	{0xd207, CRL_REG_LEN_08BIT, 0x00},
	{0xd208, CRL_REG_LEN_08BIT, 0xa8},
	{0xd209, CRL_REG_LEN_08BIT, 0xa4},
	{0xd20a, CRL_REG_LEN_08BIT, 0x6e},
	{0xd20b, CRL_REG_LEN_08BIT, 0x46},
	{0xd20c, CRL_REG_LEN_08BIT, 0xd8},
	{0xd20d, CRL_REG_LEN_08BIT, 0x07},
	{0xd20e, CRL_REG_LEN_08BIT, 0x18},
	{0xd20f, CRL_REG_LEN_08BIT, 0x00},
	{0xd210, CRL_REG_LEN_08BIT, 0xa8},
	{0xd211, CRL_REG_LEN_08BIT, 0x84},
	{0xd212, CRL_REG_LEN_08BIT, 0x55},
	{0xd213, CRL_REG_LEN_08BIT, 0x88},
	{0xd214, CRL_REG_LEN_08BIT, 0x8c},
	{0xd215, CRL_REG_LEN_08BIT, 0x65},
	{0xd216, CRL_REG_LEN_08BIT, 0x00},
	{0xd217, CRL_REG_LEN_08BIT, 0x00},
	{0xd218, CRL_REG_LEN_08BIT, 0xd8},
	{0xd219, CRL_REG_LEN_08BIT, 0x04},
	{0xd21a, CRL_REG_LEN_08BIT, 0x18},
	{0xd21b, CRL_REG_LEN_08BIT, 0x00},
	{0xd21c, CRL_REG_LEN_08BIT, 0x03},
	{0xd21d, CRL_REG_LEN_08BIT, 0xff},
	{0xd21e, CRL_REG_LEN_08BIT, 0xff},
	{0xd21f, CRL_REG_LEN_08BIT, 0xce},
	{0xd220, CRL_REG_LEN_08BIT, 0x19},
	{0xd221, CRL_REG_LEN_08BIT, 0x00},
	{0xd222, CRL_REG_LEN_08BIT, 0x80},
	{0xd223, CRL_REG_LEN_08BIT, 0x06},
	{0xd224, CRL_REG_LEN_08BIT, 0x8c},
	{0xd225, CRL_REG_LEN_08BIT, 0x63},
	{0xd226, CRL_REG_LEN_08BIT, 0x00},
	{0xd227, CRL_REG_LEN_08BIT, 0x00},
	{0xd228, CRL_REG_LEN_08BIT, 0xa4},
	{0xd229, CRL_REG_LEN_08BIT, 0x63},
	{0xd22a, CRL_REG_LEN_08BIT, 0x00},
	{0xd22b, CRL_REG_LEN_08BIT, 0x40},
	{0xd22c, CRL_REG_LEN_08BIT, 0xbc},
	{0xd22d, CRL_REG_LEN_08BIT, 0x23},
	{0xd22e, CRL_REG_LEN_08BIT, 0x00},
	{0xd22f, CRL_REG_LEN_08BIT, 0x00},
	{0xd230, CRL_REG_LEN_08BIT, 0x13},
	{0xd231, CRL_REG_LEN_08BIT, 0xff},
	{0xd232, CRL_REG_LEN_08BIT, 0xff},
	{0xd233, CRL_REG_LEN_08BIT, 0xc8},
	{0xd234, CRL_REG_LEN_08BIT, 0x9d},
	{0xd235, CRL_REG_LEN_08BIT, 0x00},
	{0xd236, CRL_REG_LEN_08BIT, 0x00},
	{0xd237, CRL_REG_LEN_08BIT, 0x40},
	{0xd238, CRL_REG_LEN_08BIT, 0xa8},
	{0xd239, CRL_REG_LEN_08BIT, 0x64},
	{0xd23a, CRL_REG_LEN_08BIT, 0x55},
	{0xd23b, CRL_REG_LEN_08BIT, 0x86},
	{0xd23c, CRL_REG_LEN_08BIT, 0xa8},
	{0xd23d, CRL_REG_LEN_08BIT, 0xa4},
	{0xd23e, CRL_REG_LEN_08BIT, 0x55},
	{0xd23f, CRL_REG_LEN_08BIT, 0x87},
	{0xd240, CRL_REG_LEN_08BIT, 0xd8},
	{0xd241, CRL_REG_LEN_08BIT, 0x03},
	{0xd242, CRL_REG_LEN_08BIT, 0x40},
	{0xd243, CRL_REG_LEN_08BIT, 0x00},
	{0xd244, CRL_REG_LEN_08BIT, 0xa8},
	{0xd245, CRL_REG_LEN_08BIT, 0x64},
	{0xd246, CRL_REG_LEN_08BIT, 0x55},
	{0xd247, CRL_REG_LEN_08BIT, 0x88},
	{0xd248, CRL_REG_LEN_08BIT, 0xd8},
	{0xd249, CRL_REG_LEN_08BIT, 0x05},
	{0xd24a, CRL_REG_LEN_08BIT, 0x40},
	{0xd24b, CRL_REG_LEN_08BIT, 0x00},
	{0xd24c, CRL_REG_LEN_08BIT, 0xd8},
	{0xd24d, CRL_REG_LEN_08BIT, 0x03},
	{0xd24e, CRL_REG_LEN_08BIT, 0x40},
	{0xd24f, CRL_REG_LEN_08BIT, 0x00},
	{0xd250, CRL_REG_LEN_08BIT, 0x03},
	{0xd251, CRL_REG_LEN_08BIT, 0xff},
	{0xd252, CRL_REG_LEN_08BIT, 0xff},
	{0xd253, CRL_REG_LEN_08BIT, 0xc1},
	{0xd254, CRL_REG_LEN_08BIT, 0x19},
	{0xd255, CRL_REG_LEN_08BIT, 0x00},
	{0xd256, CRL_REG_LEN_08BIT, 0x80},
	{0xd257, CRL_REG_LEN_08BIT, 0x06},
	{0xd258, CRL_REG_LEN_08BIT, 0x94},
	{0xd259, CRL_REG_LEN_08BIT, 0x84},
	{0xd25a, CRL_REG_LEN_08BIT, 0x00},
	{0xd25b, CRL_REG_LEN_08BIT, 0x72},
	{0xd25c, CRL_REG_LEN_08BIT, 0xe5},
	{0xd25d, CRL_REG_LEN_08BIT, 0xa4},
	{0xd25e, CRL_REG_LEN_08BIT, 0x60},
	{0xd25f, CRL_REG_LEN_08BIT, 0x00},
	{0xd260, CRL_REG_LEN_08BIT, 0x0c},
	{0xd261, CRL_REG_LEN_08BIT, 0x00},
	{0xd262, CRL_REG_LEN_08BIT, 0x00},
	{0xd263, CRL_REG_LEN_08BIT, 0x3f},
	{0xd264, CRL_REG_LEN_08BIT, 0x9d},
	{0xd265, CRL_REG_LEN_08BIT, 0x60},
	{0xd266, CRL_REG_LEN_08BIT, 0x01},
	{0xd267, CRL_REG_LEN_08BIT, 0x00},
	{0xd268, CRL_REG_LEN_08BIT, 0x85},
	{0xd269, CRL_REG_LEN_08BIT, 0x4e},
	{0xd26a, CRL_REG_LEN_08BIT, 0x00},
	{0xd26b, CRL_REG_LEN_08BIT, 0x00},
	{0xd26c, CRL_REG_LEN_08BIT, 0x98},
	{0xd26d, CRL_REG_LEN_08BIT, 0x70},
	{0xd26e, CRL_REG_LEN_08BIT, 0x00},
	{0xd26f, CRL_REG_LEN_08BIT, 0x00},
	{0xd270, CRL_REG_LEN_08BIT, 0x8c},
	{0xd271, CRL_REG_LEN_08BIT, 0x8a},
	{0xd272, CRL_REG_LEN_08BIT, 0x00},
	{0xd273, CRL_REG_LEN_08BIT, 0x6f},
	{0xd274, CRL_REG_LEN_08BIT, 0xe5},
	{0xd275, CRL_REG_LEN_08BIT, 0x63},
	{0xd276, CRL_REG_LEN_08BIT, 0x20},
	{0xd277, CRL_REG_LEN_08BIT, 0x00},
	{0xd278, CRL_REG_LEN_08BIT, 0x10},
	{0xd279, CRL_REG_LEN_08BIT, 0x00},
	{0xd27a, CRL_REG_LEN_08BIT, 0x00},
	{0xd27b, CRL_REG_LEN_08BIT, 0x07},
	{0xd27c, CRL_REG_LEN_08BIT, 0x15},
	{0xd27d, CRL_REG_LEN_08BIT, 0x00},
	{0xd27e, CRL_REG_LEN_08BIT, 0x00},
	{0xd27f, CRL_REG_LEN_08BIT, 0x00},
	{0xd280, CRL_REG_LEN_08BIT, 0x8c},
	{0xd281, CRL_REG_LEN_08BIT, 0xaa},
	{0xd282, CRL_REG_LEN_08BIT, 0x00},
	{0xd283, CRL_REG_LEN_08BIT, 0x6e},
	{0xd284, CRL_REG_LEN_08BIT, 0xe0},
	{0xd285, CRL_REG_LEN_08BIT, 0x63},
	{0xd286, CRL_REG_LEN_08BIT, 0x28},
	{0xd287, CRL_REG_LEN_08BIT, 0x02},
	{0xd288, CRL_REG_LEN_08BIT, 0xe0},
	{0xd289, CRL_REG_LEN_08BIT, 0x84},
	{0xd28a, CRL_REG_LEN_08BIT, 0x28},
	{0xd28b, CRL_REG_LEN_08BIT, 0x02},
	{0xd28c, CRL_REG_LEN_08BIT, 0x07},
	{0xd28d, CRL_REG_LEN_08BIT, 0xff},
	{0xd28e, CRL_REG_LEN_08BIT, 0xf8},
	{0xd28f, CRL_REG_LEN_08BIT, 0x66},
	{0xd290, CRL_REG_LEN_08BIT, 0xe0},
	{0xd291, CRL_REG_LEN_08BIT, 0x63},
	{0xd292, CRL_REG_LEN_08BIT, 0x5b},
	{0xd293, CRL_REG_LEN_08BIT, 0x06},
	{0xd294, CRL_REG_LEN_08BIT, 0x8c},
	{0xd295, CRL_REG_LEN_08BIT, 0x6a},
	{0xd296, CRL_REG_LEN_08BIT, 0x00},
	{0xd297, CRL_REG_LEN_08BIT, 0x77},
	{0xd298, CRL_REG_LEN_08BIT, 0xe0},
	{0xd299, CRL_REG_LEN_08BIT, 0x63},
	{0xd29a, CRL_REG_LEN_08BIT, 0x5b},
	{0xd29b, CRL_REG_LEN_08BIT, 0x06},
	{0xd29c, CRL_REG_LEN_08BIT, 0xbd},
	{0xd29d, CRL_REG_LEN_08BIT, 0x63},
	{0xd29e, CRL_REG_LEN_08BIT, 0x00},
	{0xd29f, CRL_REG_LEN_08BIT, 0x00},
	{0xd2a0, CRL_REG_LEN_08BIT, 0x0c},
	{0xd2a1, CRL_REG_LEN_08BIT, 0x00},
	{0xd2a2, CRL_REG_LEN_08BIT, 0x00},
	{0xd2a3, CRL_REG_LEN_08BIT, 0x3c},
	{0xd2a4, CRL_REG_LEN_08BIT, 0x15},
	{0xd2a5, CRL_REG_LEN_08BIT, 0x00},
	{0xd2a6, CRL_REG_LEN_08BIT, 0x00},
	{0xd2a7, CRL_REG_LEN_08BIT, 0x00},
	{0xd2a8, CRL_REG_LEN_08BIT, 0x8c},
	{0xd2a9, CRL_REG_LEN_08BIT, 0x8a},
	{0xd2aa, CRL_REG_LEN_08BIT, 0x00},
	{0xd2ab, CRL_REG_LEN_08BIT, 0x78},
	{0xd2ac, CRL_REG_LEN_08BIT, 0xb8},
	{0xd2ad, CRL_REG_LEN_08BIT, 0x63},
	{0xd2ae, CRL_REG_LEN_08BIT, 0x00},
	{0xd2af, CRL_REG_LEN_08BIT, 0x88},
	{0xd2b0, CRL_REG_LEN_08BIT, 0xe1},
	{0xd2b1, CRL_REG_LEN_08BIT, 0x64},
	{0xd2b2, CRL_REG_LEN_08BIT, 0x5b},
	{0xd2b3, CRL_REG_LEN_08BIT, 0x06},
	{0xd2b4, CRL_REG_LEN_08BIT, 0xbd},
	{0xd2b5, CRL_REG_LEN_08BIT, 0x6b},
	{0xd2b6, CRL_REG_LEN_08BIT, 0x00},
	{0xd2b7, CRL_REG_LEN_08BIT, 0x00},
	{0xd2b8, CRL_REG_LEN_08BIT, 0x0c},
	{0xd2b9, CRL_REG_LEN_08BIT, 0x00},
	{0xd2ba, CRL_REG_LEN_08BIT, 0x00},
	{0xd2bb, CRL_REG_LEN_08BIT, 0x34},
	{0xd2bc, CRL_REG_LEN_08BIT, 0xd4},
	{0xd2bd, CRL_REG_LEN_08BIT, 0x01},
	{0xd2be, CRL_REG_LEN_08BIT, 0x18},
	{0xd2bf, CRL_REG_LEN_08BIT, 0x14},
	{0xd2c0, CRL_REG_LEN_08BIT, 0xb9},
	{0xd2c1, CRL_REG_LEN_08BIT, 0x6b},
	{0xd2c2, CRL_REG_LEN_08BIT, 0x00},
	{0xd2c3, CRL_REG_LEN_08BIT, 0x88},
	{0xd2c4, CRL_REG_LEN_08BIT, 0x85},
	{0xd2c5, CRL_REG_LEN_08BIT, 0x01},
	{0xd2c6, CRL_REG_LEN_08BIT, 0x00},
	{0xd2c7, CRL_REG_LEN_08BIT, 0x14},
	{0xd2c8, CRL_REG_LEN_08BIT, 0xbd},
	{0xd2c9, CRL_REG_LEN_08BIT, 0x68},
	{0xd2ca, CRL_REG_LEN_08BIT, 0x00},
	{0xd2cb, CRL_REG_LEN_08BIT, 0x00},
	{0xd2cc, CRL_REG_LEN_08BIT, 0x0c},
	{0xd2cd, CRL_REG_LEN_08BIT, 0x00},
	{0xd2ce, CRL_REG_LEN_08BIT, 0x00},
	{0xd2cf, CRL_REG_LEN_08BIT, 0x2c},
	{0xd2d0, CRL_REG_LEN_08BIT, 0xd4},
	{0xd2d1, CRL_REG_LEN_08BIT, 0x01},
	{0xd2d2, CRL_REG_LEN_08BIT, 0x58},
	{0xd2d3, CRL_REG_LEN_08BIT, 0x18},
	{0xd2d4, CRL_REG_LEN_08BIT, 0x84},
	{0xd2d5, CRL_REG_LEN_08BIT, 0x81},
	{0xd2d6, CRL_REG_LEN_08BIT, 0x00},
	{0xd2d7, CRL_REG_LEN_08BIT, 0x14},
	{0xd2d8, CRL_REG_LEN_08BIT, 0xbd},
	{0xd2d9, CRL_REG_LEN_08BIT, 0xa4},
	{0xd2da, CRL_REG_LEN_08BIT, 0x01},
	{0xd2db, CRL_REG_LEN_08BIT, 0x00},
	{0xd2dc, CRL_REG_LEN_08BIT, 0x10},
	{0xd2dd, CRL_REG_LEN_08BIT, 0x00},
	{0xd2de, CRL_REG_LEN_08BIT, 0x00},
	{0xd2df, CRL_REG_LEN_08BIT, 0x05},
	{0xd2e0, CRL_REG_LEN_08BIT, 0x84},
	{0xd2e1, CRL_REG_LEN_08BIT, 0xc1},
	{0xd2e2, CRL_REG_LEN_08BIT, 0x00},
	{0xd2e3, CRL_REG_LEN_08BIT, 0x18},
	{0xd2e4, CRL_REG_LEN_08BIT, 0x9c},
	{0xd2e5, CRL_REG_LEN_08BIT, 0xa0},
	{0xd2e6, CRL_REG_LEN_08BIT, 0x01},
	{0xd2e7, CRL_REG_LEN_08BIT, 0x00},
	{0xd2e8, CRL_REG_LEN_08BIT, 0xd4},
	{0xd2e9, CRL_REG_LEN_08BIT, 0x01},
	{0xd2ea, CRL_REG_LEN_08BIT, 0x28},
	{0xd2eb, CRL_REG_LEN_08BIT, 0x14},
	{0xd2ec, CRL_REG_LEN_08BIT, 0x84},
	{0xd2ed, CRL_REG_LEN_08BIT, 0xc1},
	{0xd2ee, CRL_REG_LEN_08BIT, 0x00},
	{0xd2ef, CRL_REG_LEN_08BIT, 0x18},
	{0xd2f0, CRL_REG_LEN_08BIT, 0xbd},
	{0xd2f1, CRL_REG_LEN_08BIT, 0x66},
	{0xd2f2, CRL_REG_LEN_08BIT, 0x00},
	{0xd2f3, CRL_REG_LEN_08BIT, 0x00},
	{0xd2f4, CRL_REG_LEN_08BIT, 0x0c},
	{0xd2f5, CRL_REG_LEN_08BIT, 0x00},
	{0xd2f6, CRL_REG_LEN_08BIT, 0x00},
	{0xd2f7, CRL_REG_LEN_08BIT, 0x20},
	{0xd2f8, CRL_REG_LEN_08BIT, 0x9d},
	{0xd2f9, CRL_REG_LEN_08BIT, 0x00},
	{0xd2fa, CRL_REG_LEN_08BIT, 0x00},
	{0xd2fb, CRL_REG_LEN_08BIT, 0x00},
	{0xd2fc, CRL_REG_LEN_08BIT, 0x84},
	{0xd2fd, CRL_REG_LEN_08BIT, 0x61},
	{0xd2fe, CRL_REG_LEN_08BIT, 0x00},
	{0xd2ff, CRL_REG_LEN_08BIT, 0x18},
	{0xd300, CRL_REG_LEN_08BIT, 0xbd},
	{0xd301, CRL_REG_LEN_08BIT, 0xa3},
	{0xd302, CRL_REG_LEN_08BIT, 0x01},
	{0xd303, CRL_REG_LEN_08BIT, 0x00},
	{0xd304, CRL_REG_LEN_08BIT, 0x10},
	{0xd305, CRL_REG_LEN_08BIT, 0x00},
	{0xd306, CRL_REG_LEN_08BIT, 0x00},
	{0xd307, CRL_REG_LEN_08BIT, 0x03},
	{0xd308, CRL_REG_LEN_08BIT, 0x9c},
	{0xd309, CRL_REG_LEN_08BIT, 0x80},
	{0xd30a, CRL_REG_LEN_08BIT, 0x01},
	{0xd30b, CRL_REG_LEN_08BIT, 0x00},
	{0xd30c, CRL_REG_LEN_08BIT, 0xd4},
	{0xd30d, CRL_REG_LEN_08BIT, 0x01},
	{0xd30e, CRL_REG_LEN_08BIT, 0x20},
	{0xd30f, CRL_REG_LEN_08BIT, 0x18},
	{0xd310, CRL_REG_LEN_08BIT, 0x18},
	{0xd311, CRL_REG_LEN_08BIT, 0x60},
	{0xd312, CRL_REG_LEN_08BIT, 0x80},
	{0xd313, CRL_REG_LEN_08BIT, 0x06},
	{0xd314, CRL_REG_LEN_08BIT, 0x85},
	{0xd315, CRL_REG_LEN_08BIT, 0x01},
	{0xd316, CRL_REG_LEN_08BIT, 0x00},
	{0xd317, CRL_REG_LEN_08BIT, 0x14},
	{0xd318, CRL_REG_LEN_08BIT, 0xa8},
	{0xd319, CRL_REG_LEN_08BIT, 0x83},
	{0xd31a, CRL_REG_LEN_08BIT, 0x38},
	{0xd31b, CRL_REG_LEN_08BIT, 0x29},
	{0xd31c, CRL_REG_LEN_08BIT, 0xa8},
	{0xd31d, CRL_REG_LEN_08BIT, 0xc3},
	{0xd31e, CRL_REG_LEN_08BIT, 0x40},
	{0xd31f, CRL_REG_LEN_08BIT, 0x08},
	{0xd320, CRL_REG_LEN_08BIT, 0x8c},
	{0xd321, CRL_REG_LEN_08BIT, 0x84},
	{0xd322, CRL_REG_LEN_08BIT, 0x00},
	{0xd323, CRL_REG_LEN_08BIT, 0x00},
	{0xd324, CRL_REG_LEN_08BIT, 0xa8},
	{0xd325, CRL_REG_LEN_08BIT, 0xa3},
	{0xd326, CRL_REG_LEN_08BIT, 0x38},
	{0xd327, CRL_REG_LEN_08BIT, 0x2a},
	{0xd328, CRL_REG_LEN_08BIT, 0xa8},
	{0xd329, CRL_REG_LEN_08BIT, 0xe3},
	{0xd32a, CRL_REG_LEN_08BIT, 0x40},
	{0xd32b, CRL_REG_LEN_08BIT, 0x09},
	{0xd32c, CRL_REG_LEN_08BIT, 0xe0},
	{0xd32d, CRL_REG_LEN_08BIT, 0x64},
	{0xd32e, CRL_REG_LEN_08BIT, 0x40},
	{0xd32f, CRL_REG_LEN_08BIT, 0x00},
	{0xd330, CRL_REG_LEN_08BIT, 0xd8},
	{0xd331, CRL_REG_LEN_08BIT, 0x06},
	{0xd332, CRL_REG_LEN_08BIT, 0x18},
	{0xd333, CRL_REG_LEN_08BIT, 0x00},
	{0xd334, CRL_REG_LEN_08BIT, 0x8c},
	{0xd335, CRL_REG_LEN_08BIT, 0x65},
	{0xd336, CRL_REG_LEN_08BIT, 0x00},
	{0xd337, CRL_REG_LEN_08BIT, 0x00},
	{0xd338, CRL_REG_LEN_08BIT, 0x84},
	{0xd339, CRL_REG_LEN_08BIT, 0x81},
	{0xd33a, CRL_REG_LEN_08BIT, 0x00},
	{0xd33b, CRL_REG_LEN_08BIT, 0x18},
	{0xd33c, CRL_REG_LEN_08BIT, 0xe3},
	{0xd33d, CRL_REG_LEN_08BIT, 0xe3},
	{0xd33e, CRL_REG_LEN_08BIT, 0x20},
	{0xd33f, CRL_REG_LEN_08BIT, 0x00},
	{0xd340, CRL_REG_LEN_08BIT, 0xd8},
	{0xd341, CRL_REG_LEN_08BIT, 0x07},
	{0xd342, CRL_REG_LEN_08BIT, 0xf8},
	{0xd343, CRL_REG_LEN_08BIT, 0x00},
	{0xd344, CRL_REG_LEN_08BIT, 0x03},
	{0xd345, CRL_REG_LEN_08BIT, 0xff},
	{0xd346, CRL_REG_LEN_08BIT, 0xff},
	{0xd347, CRL_REG_LEN_08BIT, 0x6f},
	{0xd348, CRL_REG_LEN_08BIT, 0x18},
	{0xd349, CRL_REG_LEN_08BIT, 0x60},
	{0xd34a, CRL_REG_LEN_08BIT, 0x00},
	{0xd34b, CRL_REG_LEN_08BIT, 0x01},
	{0xd34c, CRL_REG_LEN_08BIT, 0x0f},
	{0xd34d, CRL_REG_LEN_08BIT, 0xff},
	{0xd34e, CRL_REG_LEN_08BIT, 0xff},
	{0xd34f, CRL_REG_LEN_08BIT, 0x9d},
	{0xd350, CRL_REG_LEN_08BIT, 0x18},
	{0xd351, CRL_REG_LEN_08BIT, 0x60},
	{0xd352, CRL_REG_LEN_08BIT, 0x80},
	{0xd353, CRL_REG_LEN_08BIT, 0x06},
	{0xd354, CRL_REG_LEN_08BIT, 0x00},
	{0xd355, CRL_REG_LEN_08BIT, 0x00},
	{0xd356, CRL_REG_LEN_08BIT, 0x00},
	{0xd357, CRL_REG_LEN_08BIT, 0x11},
	{0xd358, CRL_REG_LEN_08BIT, 0xa8},
	{0xd359, CRL_REG_LEN_08BIT, 0x83},
	{0xd35a, CRL_REG_LEN_08BIT, 0x6e},
	{0xd35b, CRL_REG_LEN_08BIT, 0x43},
	{0xd35c, CRL_REG_LEN_08BIT, 0xe0},
	{0xd35d, CRL_REG_LEN_08BIT, 0x6c},
	{0xd35e, CRL_REG_LEN_08BIT, 0x28},
	{0xd35f, CRL_REG_LEN_08BIT, 0x02},
	{0xd360, CRL_REG_LEN_08BIT, 0xe0},
	{0xd361, CRL_REG_LEN_08BIT, 0x84},
	{0xd362, CRL_REG_LEN_08BIT, 0x28},
	{0xd363, CRL_REG_LEN_08BIT, 0x02},
	{0xd364, CRL_REG_LEN_08BIT, 0x07},
	{0xd365, CRL_REG_LEN_08BIT, 0xff},
	{0xd366, CRL_REG_LEN_08BIT, 0xf8},
	{0xd367, CRL_REG_LEN_08BIT, 0x30},
	{0xd368, CRL_REG_LEN_08BIT, 0xb8},
	{0xd369, CRL_REG_LEN_08BIT, 0x63},
	{0xd36a, CRL_REG_LEN_08BIT, 0x00},
	{0xd36b, CRL_REG_LEN_08BIT, 0x08},
	{0xd36c, CRL_REG_LEN_08BIT, 0x03},
	{0xd36d, CRL_REG_LEN_08BIT, 0xff},
	{0xd36e, CRL_REG_LEN_08BIT, 0xff},
	{0xd36f, CRL_REG_LEN_08BIT, 0xc0},
	{0xd370, CRL_REG_LEN_08BIT, 0x85},
	{0xd371, CRL_REG_LEN_08BIT, 0x4e},
	{0xd372, CRL_REG_LEN_08BIT, 0x00},
	{0xd373, CRL_REG_LEN_08BIT, 0x00},
	{0xd374, CRL_REG_LEN_08BIT, 0x03},
	{0xd375, CRL_REG_LEN_08BIT, 0xff},
	{0xd376, CRL_REG_LEN_08BIT, 0xff},
	{0xd377, CRL_REG_LEN_08BIT, 0xe7},
	{0xd378, CRL_REG_LEN_08BIT, 0xd4},
	{0xd379, CRL_REG_LEN_08BIT, 0x01},
	{0xd37a, CRL_REG_LEN_08BIT, 0x40},
	{0xd37b, CRL_REG_LEN_08BIT, 0x18},
	{0xd37c, CRL_REG_LEN_08BIT, 0x9c},
	{0xd37d, CRL_REG_LEN_08BIT, 0x60},
	{0xd37e, CRL_REG_LEN_08BIT, 0x00},
	{0xd37f, CRL_REG_LEN_08BIT, 0x00},
	{0xd380, CRL_REG_LEN_08BIT, 0x03},
	{0xd381, CRL_REG_LEN_08BIT, 0xff},
	{0xd382, CRL_REG_LEN_08BIT, 0xff},
	{0xd383, CRL_REG_LEN_08BIT, 0xdb},
	{0xd384, CRL_REG_LEN_08BIT, 0xd4},
	{0xd385, CRL_REG_LEN_08BIT, 0x01},
	{0xd386, CRL_REG_LEN_08BIT, 0x18},
	{0xd387, CRL_REG_LEN_08BIT, 0x14},
	{0xd388, CRL_REG_LEN_08BIT, 0x03},
	{0xd389, CRL_REG_LEN_08BIT, 0xff},
	{0xd38a, CRL_REG_LEN_08BIT, 0xff},
	{0xd38b, CRL_REG_LEN_08BIT, 0xce},
	{0xd38c, CRL_REG_LEN_08BIT, 0x9d},
	{0xd38d, CRL_REG_LEN_08BIT, 0x6b},
	{0xd38e, CRL_REG_LEN_08BIT, 0x00},
	{0xd38f, CRL_REG_LEN_08BIT, 0xff},
	{0xd390, CRL_REG_LEN_08BIT, 0x03},
	{0xd391, CRL_REG_LEN_08BIT, 0xff},
	{0xd392, CRL_REG_LEN_08BIT, 0xff},
	{0xd393, CRL_REG_LEN_08BIT, 0xc6},
	{0xd394, CRL_REG_LEN_08BIT, 0x9c},
	{0xd395, CRL_REG_LEN_08BIT, 0x63},
	{0xd396, CRL_REG_LEN_08BIT, 0x00},
	{0xd397, CRL_REG_LEN_08BIT, 0xff},
	{0xd398, CRL_REG_LEN_08BIT, 0xa8},
	{0xd399, CRL_REG_LEN_08BIT, 0xe3},
	{0xd39a, CRL_REG_LEN_08BIT, 0x38},
	{0xd39b, CRL_REG_LEN_08BIT, 0x0f},
	{0xd39c, CRL_REG_LEN_08BIT, 0x8c},
	{0xd39d, CRL_REG_LEN_08BIT, 0x84},
	{0xd39e, CRL_REG_LEN_08BIT, 0x00},
	{0xd39f, CRL_REG_LEN_08BIT, 0x00},
	{0xd3a0, CRL_REG_LEN_08BIT, 0xa8},
	{0xd3a1, CRL_REG_LEN_08BIT, 0xa3},
	{0xd3a2, CRL_REG_LEN_08BIT, 0x38},
	{0xd3a3, CRL_REG_LEN_08BIT, 0x0e},
	{0xd3a4, CRL_REG_LEN_08BIT, 0xa8},
	{0xd3a5, CRL_REG_LEN_08BIT, 0xc3},
	{0xd3a6, CRL_REG_LEN_08BIT, 0x6e},
	{0xd3a7, CRL_REG_LEN_08BIT, 0x42},
	{0xd3a8, CRL_REG_LEN_08BIT, 0xd8},
	{0xd3a9, CRL_REG_LEN_08BIT, 0x07},
	{0xd3aa, CRL_REG_LEN_08BIT, 0x20},
	{0xd3ab, CRL_REG_LEN_08BIT, 0x00},
	{0xd3ac, CRL_REG_LEN_08BIT, 0x8c},
	{0xd3ad, CRL_REG_LEN_08BIT, 0x66},
	{0xd3ae, CRL_REG_LEN_08BIT, 0x00},
	{0xd3af, CRL_REG_LEN_08BIT, 0x00},
	{0xd3b0, CRL_REG_LEN_08BIT, 0xd8},
	{0xd3b1, CRL_REG_LEN_08BIT, 0x05},
	{0xd3b2, CRL_REG_LEN_08BIT, 0x18},
	{0xd3b3, CRL_REG_LEN_08BIT, 0x00},
	{0xd3b4, CRL_REG_LEN_08BIT, 0x85},
	{0xd3b5, CRL_REG_LEN_08BIT, 0x21},
	{0xd3b6, CRL_REG_LEN_08BIT, 0x00},
	{0xd3b7, CRL_REG_LEN_08BIT, 0x00},
	{0xd3b8, CRL_REG_LEN_08BIT, 0x85},
	{0xd3b9, CRL_REG_LEN_08BIT, 0x41},
	{0xd3ba, CRL_REG_LEN_08BIT, 0x00},
	{0xd3bb, CRL_REG_LEN_08BIT, 0x04},
	{0xd3bc, CRL_REG_LEN_08BIT, 0x85},
	{0xd3bd, CRL_REG_LEN_08BIT, 0x81},
	{0xd3be, CRL_REG_LEN_08BIT, 0x00},
	{0xd3bf, CRL_REG_LEN_08BIT, 0x08},
	{0xd3c0, CRL_REG_LEN_08BIT, 0x85},
	{0xd3c1, CRL_REG_LEN_08BIT, 0xc1},
	{0xd3c2, CRL_REG_LEN_08BIT, 0x00},
	{0xd3c3, CRL_REG_LEN_08BIT, 0x0c},
	{0xd3c4, CRL_REG_LEN_08BIT, 0x86},
	{0xd3c5, CRL_REG_LEN_08BIT, 0x01},
	{0xd3c6, CRL_REG_LEN_08BIT, 0x00},
	{0xd3c7, CRL_REG_LEN_08BIT, 0x10},
	{0xd3c8, CRL_REG_LEN_08BIT, 0x44},
	{0xd3c9, CRL_REG_LEN_08BIT, 0x00},
	{0xd3ca, CRL_REG_LEN_08BIT, 0x48},
	{0xd3cb, CRL_REG_LEN_08BIT, 0x00},
	{0xd3cc, CRL_REG_LEN_08BIT, 0x9c},
	{0xd3cd, CRL_REG_LEN_08BIT, 0x21},
	{0xd3ce, CRL_REG_LEN_08BIT, 0x00},
	{0xd3cf, CRL_REG_LEN_08BIT, 0x1c},
	{0xd3d0, CRL_REG_LEN_08BIT, 0x9c},
	{0xd3d1, CRL_REG_LEN_08BIT, 0x21},
	{0xd3d2, CRL_REG_LEN_08BIT, 0xff},
	{0xd3d3, CRL_REG_LEN_08BIT, 0xfc},
	{0xd3d4, CRL_REG_LEN_08BIT, 0xd4},
	{0xd3d5, CRL_REG_LEN_08BIT, 0x01},
	{0xd3d6, CRL_REG_LEN_08BIT, 0x48},
	{0xd3d7, CRL_REG_LEN_08BIT, 0x00},
	{0xd3d8, CRL_REG_LEN_08BIT, 0x18},
	{0xd3d9, CRL_REG_LEN_08BIT, 0x60},
	{0xd3da, CRL_REG_LEN_08BIT, 0x00},
	{0xd3db, CRL_REG_LEN_08BIT, 0x01},
	{0xd3dc, CRL_REG_LEN_08BIT, 0xa8},
	{0xd3dd, CRL_REG_LEN_08BIT, 0x63},
	{0xd3de, CRL_REG_LEN_08BIT, 0x07},
	{0xd3df, CRL_REG_LEN_08BIT, 0x80},
	{0xd3e0, CRL_REG_LEN_08BIT, 0x8c},
	{0xd3e1, CRL_REG_LEN_08BIT, 0x63},
	{0xd3e2, CRL_REG_LEN_08BIT, 0x00},
	{0xd3e3, CRL_REG_LEN_08BIT, 0x68},
	{0xd3e4, CRL_REG_LEN_08BIT, 0xbc},
	{0xd3e5, CRL_REG_LEN_08BIT, 0x03},
	{0xd3e6, CRL_REG_LEN_08BIT, 0x00},
	{0xd3e7, CRL_REG_LEN_08BIT, 0x00},
	{0xd3e8, CRL_REG_LEN_08BIT, 0x10},
	{0xd3e9, CRL_REG_LEN_08BIT, 0x00},
	{0xd3ea, CRL_REG_LEN_08BIT, 0x00},
	{0xd3eb, CRL_REG_LEN_08BIT, 0x0c},
	{0xd3ec, CRL_REG_LEN_08BIT, 0x15},
	{0xd3ed, CRL_REG_LEN_08BIT, 0x00},
	{0xd3ee, CRL_REG_LEN_08BIT, 0x00},
	{0xd3ef, CRL_REG_LEN_08BIT, 0x00},
	{0xd3f0, CRL_REG_LEN_08BIT, 0x07},
	{0xd3f1, CRL_REG_LEN_08BIT, 0xff},
	{0xd3f2, CRL_REG_LEN_08BIT, 0xd9},
	{0xd3f3, CRL_REG_LEN_08BIT, 0x98},
	{0xd3f4, CRL_REG_LEN_08BIT, 0x15},
	{0xd3f5, CRL_REG_LEN_08BIT, 0x00},
	{0xd3f6, CRL_REG_LEN_08BIT, 0x00},
	{0xd3f7, CRL_REG_LEN_08BIT, 0x00},
	{0xd3f8, CRL_REG_LEN_08BIT, 0x18},
	{0xd3f9, CRL_REG_LEN_08BIT, 0x60},
	{0xd3fa, CRL_REG_LEN_08BIT, 0x80},
	{0xd3fb, CRL_REG_LEN_08BIT, 0x06},
	{0xd3fc, CRL_REG_LEN_08BIT, 0xa8},
	{0xd3fd, CRL_REG_LEN_08BIT, 0x63},
	{0xd3fe, CRL_REG_LEN_08BIT, 0xc4},
	{0xd3ff, CRL_REG_LEN_08BIT, 0xb8},
	{0xd400, CRL_REG_LEN_08BIT, 0x8c},
	{0xd401, CRL_REG_LEN_08BIT, 0x63},
	{0xd402, CRL_REG_LEN_08BIT, 0x00},
	{0xd403, CRL_REG_LEN_08BIT, 0x00},
	{0xd404, CRL_REG_LEN_08BIT, 0xbc},
	{0xd405, CRL_REG_LEN_08BIT, 0x23},
	{0xd406, CRL_REG_LEN_08BIT, 0x00},
	{0xd407, CRL_REG_LEN_08BIT, 0x01},
	{0xd408, CRL_REG_LEN_08BIT, 0x10},
	{0xd409, CRL_REG_LEN_08BIT, 0x00},
	{0xd40a, CRL_REG_LEN_08BIT, 0x00},
	{0xd40b, CRL_REG_LEN_08BIT, 0x25},
	{0xd40c, CRL_REG_LEN_08BIT, 0x9d},
	{0xd40d, CRL_REG_LEN_08BIT, 0x00},
	{0xd40e, CRL_REG_LEN_08BIT, 0x00},
	{0xd40f, CRL_REG_LEN_08BIT, 0x00},
	{0xd410, CRL_REG_LEN_08BIT, 0x00},
	{0xd411, CRL_REG_LEN_08BIT, 0x00},
	{0xd412, CRL_REG_LEN_08BIT, 0x00},
	{0xd413, CRL_REG_LEN_08BIT, 0x0b},
	{0xd414, CRL_REG_LEN_08BIT, 0xb8},
	{0xd415, CRL_REG_LEN_08BIT, 0xe8},
	{0xd416, CRL_REG_LEN_08BIT, 0x00},
	{0xd417, CRL_REG_LEN_08BIT, 0x02},
	{0xd418, CRL_REG_LEN_08BIT, 0x07},
	{0xd419, CRL_REG_LEN_08BIT, 0xff},
	{0xd41a, CRL_REG_LEN_08BIT, 0xd6},
	{0xd41b, CRL_REG_LEN_08BIT, 0x24},
	{0xd41c, CRL_REG_LEN_08BIT, 0x15},
	{0xd41d, CRL_REG_LEN_08BIT, 0x00},
	{0xd41e, CRL_REG_LEN_08BIT, 0x00},
	{0xd41f, CRL_REG_LEN_08BIT, 0x00},
	{0xd420, CRL_REG_LEN_08BIT, 0x18},
	{0xd421, CRL_REG_LEN_08BIT, 0x60},
	{0xd422, CRL_REG_LEN_08BIT, 0x80},
	{0xd423, CRL_REG_LEN_08BIT, 0x06},
	{0xd424, CRL_REG_LEN_08BIT, 0xa8},
	{0xd425, CRL_REG_LEN_08BIT, 0x63},
	{0xd426, CRL_REG_LEN_08BIT, 0xc4},
	{0xd427, CRL_REG_LEN_08BIT, 0xb8},
	{0xd428, CRL_REG_LEN_08BIT, 0x8c},
	{0xd429, CRL_REG_LEN_08BIT, 0x63},
	{0xd42a, CRL_REG_LEN_08BIT, 0x00},
	{0xd42b, CRL_REG_LEN_08BIT, 0x00},
	{0xd42c, CRL_REG_LEN_08BIT, 0xbc},
	{0xd42d, CRL_REG_LEN_08BIT, 0x23},
	{0xd42e, CRL_REG_LEN_08BIT, 0x00},
	{0xd42f, CRL_REG_LEN_08BIT, 0x01},
	{0xd430, CRL_REG_LEN_08BIT, 0x10},
	{0xd431, CRL_REG_LEN_08BIT, 0x00},
	{0xd432, CRL_REG_LEN_08BIT, 0x00},
	{0xd433, CRL_REG_LEN_08BIT, 0x1b},
	{0xd434, CRL_REG_LEN_08BIT, 0x9d},
	{0xd435, CRL_REG_LEN_08BIT, 0x00},
	{0xd436, CRL_REG_LEN_08BIT, 0x00},
	{0xd437, CRL_REG_LEN_08BIT, 0x00},
	{0xd438, CRL_REG_LEN_08BIT, 0xb8},
	{0xd439, CRL_REG_LEN_08BIT, 0xe8},
	{0xd43a, CRL_REG_LEN_08BIT, 0x00},
	{0xd43b, CRL_REG_LEN_08BIT, 0x02},
	{0xd43c, CRL_REG_LEN_08BIT, 0x9c},
	{0xd43d, CRL_REG_LEN_08BIT, 0xc0},
	{0xd43e, CRL_REG_LEN_08BIT, 0x00},
	{0xd43f, CRL_REG_LEN_08BIT, 0x00},
	{0xd440, CRL_REG_LEN_08BIT, 0x18},
	{0xd441, CRL_REG_LEN_08BIT, 0xa0},
	{0xd442, CRL_REG_LEN_08BIT, 0x80},
	{0xd443, CRL_REG_LEN_08BIT, 0x06},
	{0xd444, CRL_REG_LEN_08BIT, 0xe0},
	{0xd445, CRL_REG_LEN_08BIT, 0x67},
	{0xd446, CRL_REG_LEN_08BIT, 0x30},
	{0xd447, CRL_REG_LEN_08BIT, 0x00},
	{0xd448, CRL_REG_LEN_08BIT, 0xa8},
	{0xd449, CRL_REG_LEN_08BIT, 0xa5},
	{0xd44a, CRL_REG_LEN_08BIT, 0xce},
	{0xd44b, CRL_REG_LEN_08BIT, 0xb0},
	{0xd44c, CRL_REG_LEN_08BIT, 0x19},
	{0xd44d, CRL_REG_LEN_08BIT, 0x60},
	{0xd44e, CRL_REG_LEN_08BIT, 0x00},
	{0xd44f, CRL_REG_LEN_08BIT, 0x01},
	{0xd450, CRL_REG_LEN_08BIT, 0xa9},
	{0xd451, CRL_REG_LEN_08BIT, 0x6b},
	{0xd452, CRL_REG_LEN_08BIT, 0x06},
	{0xd453, CRL_REG_LEN_08BIT, 0x14},
	{0xd454, CRL_REG_LEN_08BIT, 0xe0},
	{0xd455, CRL_REG_LEN_08BIT, 0x83},
	{0xd456, CRL_REG_LEN_08BIT, 0x28},
	{0xd457, CRL_REG_LEN_08BIT, 0x00},
	{0xd458, CRL_REG_LEN_08BIT, 0x9c},
	{0xd459, CRL_REG_LEN_08BIT, 0xc6},
	{0xd45a, CRL_REG_LEN_08BIT, 0x00},
	{0xd45b, CRL_REG_LEN_08BIT, 0x01},
	{0xd45c, CRL_REG_LEN_08BIT, 0xe0},
	{0xd45d, CRL_REG_LEN_08BIT, 0x63},
	{0xd45e, CRL_REG_LEN_08BIT, 0x18},
	{0xd45f, CRL_REG_LEN_08BIT, 0x00},
	{0xd460, CRL_REG_LEN_08BIT, 0x8c},
	{0xd461, CRL_REG_LEN_08BIT, 0x84},
	{0xd462, CRL_REG_LEN_08BIT, 0x00},
	{0xd463, CRL_REG_LEN_08BIT, 0x00},
	{0xd464, CRL_REG_LEN_08BIT, 0xe0},
	{0xd465, CRL_REG_LEN_08BIT, 0xa3},
	{0xd466, CRL_REG_LEN_08BIT, 0x58},
	{0xd467, CRL_REG_LEN_08BIT, 0x00},
	{0xd468, CRL_REG_LEN_08BIT, 0xa4},
	{0xd469, CRL_REG_LEN_08BIT, 0xc6},
	{0xd46a, CRL_REG_LEN_08BIT, 0x00},
	{0xd46b, CRL_REG_LEN_08BIT, 0xff},
	{0xd46c, CRL_REG_LEN_08BIT, 0xb8},
	{0xd46d, CRL_REG_LEN_08BIT, 0x64},
	{0xd46e, CRL_REG_LEN_08BIT, 0x00},
	{0xd46f, CRL_REG_LEN_08BIT, 0x18},
	{0xd470, CRL_REG_LEN_08BIT, 0xbc},
	{0xd471, CRL_REG_LEN_08BIT, 0x46},
	{0xd472, CRL_REG_LEN_08BIT, 0x00},
	{0xd473, CRL_REG_LEN_08BIT, 0x03},
	{0xd474, CRL_REG_LEN_08BIT, 0x94},
	{0xd475, CRL_REG_LEN_08BIT, 0x85},
	{0xd476, CRL_REG_LEN_08BIT, 0x00},
	{0xd477, CRL_REG_LEN_08BIT, 0x00},
	{0xd478, CRL_REG_LEN_08BIT, 0xb8},
	{0xd479, CRL_REG_LEN_08BIT, 0x63},
	{0xd47a, CRL_REG_LEN_08BIT, 0x00},
	{0xd47b, CRL_REG_LEN_08BIT, 0x98},
	{0xd47c, CRL_REG_LEN_08BIT, 0xe0},
	{0xd47d, CRL_REG_LEN_08BIT, 0x64},
	{0xd47e, CRL_REG_LEN_08BIT, 0x18},
	{0xd47f, CRL_REG_LEN_08BIT, 0x00},
	{0xd480, CRL_REG_LEN_08BIT, 0x0f},
	{0xd481, CRL_REG_LEN_08BIT, 0xff},
	{0xd482, CRL_REG_LEN_08BIT, 0xff},
	{0xd483, CRL_REG_LEN_08BIT, 0xf0},
	{0xd484, CRL_REG_LEN_08BIT, 0xdc},
	{0xd485, CRL_REG_LEN_08BIT, 0x05},
	{0xd486, CRL_REG_LEN_08BIT, 0x18},
	{0xd487, CRL_REG_LEN_08BIT, 0x00},
	{0xd488, CRL_REG_LEN_08BIT, 0x9c},
	{0xd489, CRL_REG_LEN_08BIT, 0x68},
	{0xd48a, CRL_REG_LEN_08BIT, 0x00},
	{0xd48b, CRL_REG_LEN_08BIT, 0x01},
	{0xd48c, CRL_REG_LEN_08BIT, 0xa5},
	{0xd48d, CRL_REG_LEN_08BIT, 0x03},
	{0xd48e, CRL_REG_LEN_08BIT, 0x00},
	{0xd48f, CRL_REG_LEN_08BIT, 0xff},
	{0xd490, CRL_REG_LEN_08BIT, 0xbc},
	{0xd491, CRL_REG_LEN_08BIT, 0x48},
	{0xd492, CRL_REG_LEN_08BIT, 0x00},
	{0xd493, CRL_REG_LEN_08BIT, 0x01},
	{0xd494, CRL_REG_LEN_08BIT, 0x0f},
	{0xd495, CRL_REG_LEN_08BIT, 0xff},
	{0xd496, CRL_REG_LEN_08BIT, 0xff},
	{0xd497, CRL_REG_LEN_08BIT, 0xea},
	{0xd498, CRL_REG_LEN_08BIT, 0xb8},
	{0xd499, CRL_REG_LEN_08BIT, 0xe8},
	{0xd49a, CRL_REG_LEN_08BIT, 0x00},
	{0xd49b, CRL_REG_LEN_08BIT, 0x02},
	{0xd49c, CRL_REG_LEN_08BIT, 0x18},
	{0xd49d, CRL_REG_LEN_08BIT, 0x60},
	{0xd49e, CRL_REG_LEN_08BIT, 0x00},
	{0xd49f, CRL_REG_LEN_08BIT, 0x01},
	{0xd4a0, CRL_REG_LEN_08BIT, 0xa8},
	{0xd4a1, CRL_REG_LEN_08BIT, 0x63},
	{0xd4a2, CRL_REG_LEN_08BIT, 0x06},
	{0xd4a3, CRL_REG_LEN_08BIT, 0x14},
	{0xd4a4, CRL_REG_LEN_08BIT, 0x07},
	{0xd4a5, CRL_REG_LEN_08BIT, 0xff},
	{0xd4a6, CRL_REG_LEN_08BIT, 0xe4},
	{0xd4a7, CRL_REG_LEN_08BIT, 0x05},
	{0xd4a8, CRL_REG_LEN_08BIT, 0x9c},
	{0xd4a9, CRL_REG_LEN_08BIT, 0x83},
	{0xd4aa, CRL_REG_LEN_08BIT, 0x00},
	{0xd4ab, CRL_REG_LEN_08BIT, 0x10},
	{0xd4ac, CRL_REG_LEN_08BIT, 0x85},
	{0xd4ad, CRL_REG_LEN_08BIT, 0x21},
	{0xd4ae, CRL_REG_LEN_08BIT, 0x00},
	{0xd4af, CRL_REG_LEN_08BIT, 0x00},
	{0xd4b0, CRL_REG_LEN_08BIT, 0x44},
	{0xd4b1, CRL_REG_LEN_08BIT, 0x00},
	{0xd4b2, CRL_REG_LEN_08BIT, 0x48},
	{0xd4b3, CRL_REG_LEN_08BIT, 0x00},
	{0xd4b4, CRL_REG_LEN_08BIT, 0x9c},
	{0xd4b5, CRL_REG_LEN_08BIT, 0x21},
	{0xd4b6, CRL_REG_LEN_08BIT, 0x00},
	{0xd4b7, CRL_REG_LEN_08BIT, 0x04},
	{0xd4b8, CRL_REG_LEN_08BIT, 0x18},
	{0xd4b9, CRL_REG_LEN_08BIT, 0x60},
	{0xd4ba, CRL_REG_LEN_08BIT, 0x00},
	{0xd4bb, CRL_REG_LEN_08BIT, 0x01},
	{0xd4bc, CRL_REG_LEN_08BIT, 0x9c},
	{0xd4bd, CRL_REG_LEN_08BIT, 0x80},
	{0xd4be, CRL_REG_LEN_08BIT, 0xff},
	{0xd4bf, CRL_REG_LEN_08BIT, 0xff},
	{0xd4c0, CRL_REG_LEN_08BIT, 0xa8},
	{0xd4c1, CRL_REG_LEN_08BIT, 0x63},
	{0xd4c2, CRL_REG_LEN_08BIT, 0x09},
	{0xd4c3, CRL_REG_LEN_08BIT, 0xef},
	{0xd4c4, CRL_REG_LEN_08BIT, 0xd8},
	{0xd4c5, CRL_REG_LEN_08BIT, 0x03},
	{0xd4c6, CRL_REG_LEN_08BIT, 0x20},
	{0xd4c7, CRL_REG_LEN_08BIT, 0x00},
	{0xd4c8, CRL_REG_LEN_08BIT, 0x18},
	{0xd4c9, CRL_REG_LEN_08BIT, 0x60},
	{0xd4ca, CRL_REG_LEN_08BIT, 0x80},
	{0xd4cb, CRL_REG_LEN_08BIT, 0x06},
	{0xd4cc, CRL_REG_LEN_08BIT, 0xa8},
	{0xd4cd, CRL_REG_LEN_08BIT, 0x63},
	{0xd4ce, CRL_REG_LEN_08BIT, 0xc9},
	{0xd4cf, CRL_REG_LEN_08BIT, 0xef},
	{0xd4d0, CRL_REG_LEN_08BIT, 0xd8},
	{0xd4d1, CRL_REG_LEN_08BIT, 0x03},
	{0xd4d2, CRL_REG_LEN_08BIT, 0x20},
	{0xd4d3, CRL_REG_LEN_08BIT, 0x00},
	{0xd4d4, CRL_REG_LEN_08BIT, 0x44},
	{0xd4d5, CRL_REG_LEN_08BIT, 0x00},
	{0xd4d6, CRL_REG_LEN_08BIT, 0x48},
	{0xd4d7, CRL_REG_LEN_08BIT, 0x00},
	{0xd4d8, CRL_REG_LEN_08BIT, 0x15},
	{0xd4d9, CRL_REG_LEN_08BIT, 0x00},
	{0xd4da, CRL_REG_LEN_08BIT, 0x00},
	{0xd4db, CRL_REG_LEN_08BIT, 0x00},
	{0xd4dc, CRL_REG_LEN_08BIT, 0x18},
	{0xd4dd, CRL_REG_LEN_08BIT, 0x80},
	{0xd4de, CRL_REG_LEN_08BIT, 0x00},
	{0xd4df, CRL_REG_LEN_08BIT, 0x01},
	{0xd4e0, CRL_REG_LEN_08BIT, 0xa8},
	{0xd4e1, CRL_REG_LEN_08BIT, 0x84},
	{0xd4e2, CRL_REG_LEN_08BIT, 0x0a},
	{0xd4e3, CRL_REG_LEN_08BIT, 0x12},
	{0xd4e4, CRL_REG_LEN_08BIT, 0x8c},
	{0xd4e5, CRL_REG_LEN_08BIT, 0x64},
	{0xd4e6, CRL_REG_LEN_08BIT, 0x00},
	{0xd4e7, CRL_REG_LEN_08BIT, 0x00},
	{0xd4e8, CRL_REG_LEN_08BIT, 0xbc},
	{0xd4e9, CRL_REG_LEN_08BIT, 0x03},
	{0xd4ea, CRL_REG_LEN_08BIT, 0x00},
	{0xd4eb, CRL_REG_LEN_08BIT, 0x00},
	{0xd4ec, CRL_REG_LEN_08BIT, 0x13},
	{0xd4ed, CRL_REG_LEN_08BIT, 0xff},
	{0xd4ee, CRL_REG_LEN_08BIT, 0xff},
	{0xd4ef, CRL_REG_LEN_08BIT, 0xfe},
	{0xd4f0, CRL_REG_LEN_08BIT, 0x15},
	{0xd4f1, CRL_REG_LEN_08BIT, 0x00},
	{0xd4f2, CRL_REG_LEN_08BIT, 0x00},
	{0xd4f3, CRL_REG_LEN_08BIT, 0x00},
	{0xd4f4, CRL_REG_LEN_08BIT, 0x44},
	{0xd4f5, CRL_REG_LEN_08BIT, 0x00},
	{0xd4f6, CRL_REG_LEN_08BIT, 0x48},
	{0xd4f7, CRL_REG_LEN_08BIT, 0x00},
	{0xd4f8, CRL_REG_LEN_08BIT, 0x15},
	{0xd4f9, CRL_REG_LEN_08BIT, 0x00},
	{0xd4fa, CRL_REG_LEN_08BIT, 0x00},
	{0xd4fb, CRL_REG_LEN_08BIT, 0x00},
	{0xd4fc, CRL_REG_LEN_08BIT, 0x00},
	{0xd4fd, CRL_REG_LEN_08BIT, 0x00},
	{0xd4fe, CRL_REG_LEN_08BIT, 0x00},
	{0xd4ff, CRL_REG_LEN_08BIT, 0x00},
	{0xd500, CRL_REG_LEN_08BIT, 0x00},
	{0xd501, CRL_REG_LEN_08BIT, 0x00},
	{0xd502, CRL_REG_LEN_08BIT, 0x00},
	{0xd503, CRL_REG_LEN_08BIT, 0x00},
	{0x6f0e, CRL_REG_LEN_08BIT, 0x33},
	{0x6f0f, CRL_REG_LEN_08BIT, 0x33},
	{0x460e, CRL_REG_LEN_08BIT, 0x08},
	{0x460f, CRL_REG_LEN_08BIT, 0x01},
	{0x4610, CRL_REG_LEN_08BIT, 0x00},
	{0x4611, CRL_REG_LEN_08BIT, 0x01},
	{0x4612, CRL_REG_LEN_08BIT, 0x00},
	{0x4613, CRL_REG_LEN_08BIT, 0x01},
	{0x4605, CRL_REG_LEN_08BIT, 0x08},/*YUV 8bit*/
	{0x4608, CRL_REG_LEN_08BIT, 0x00},
	{0x4609, CRL_REG_LEN_08BIT, 0x08},
	{0x6804, CRL_REG_LEN_08BIT, 0x00},
	{0x6805, CRL_REG_LEN_08BIT, 0x06},
	{0x6806, CRL_REG_LEN_08BIT, 0x00},
	{0x5120, CRL_REG_LEN_08BIT, 0x00},
	{0x3510, CRL_REG_LEN_08BIT, 0x00},
	{0x3504, CRL_REG_LEN_08BIT, 0x00},
	{0x6800, CRL_REG_LEN_08BIT, 0x00},
	{0x6f0d, CRL_REG_LEN_08BIT, 0x0f},
	{0x5000, CRL_REG_LEN_08BIT, 0xff},
	{0x5001, CRL_REG_LEN_08BIT, 0xbf},
	{0x5002, CRL_REG_LEN_08BIT, 0x7e},
	{0x5003, CRL_REG_LEN_08BIT, 0x0c},
	{0x503d, CRL_REG_LEN_08BIT, 0x00},
	{0xc450, CRL_REG_LEN_08BIT, 0x01},
	{0xc452, CRL_REG_LEN_08BIT, 0x04},
	{0xc453, CRL_REG_LEN_08BIT, 0x00},
	{0xc454, CRL_REG_LEN_08BIT, 0x01},
	{0xc455, CRL_REG_LEN_08BIT, 0x00},
	{0xc456, CRL_REG_LEN_08BIT, 0x00},
	{0xc457, CRL_REG_LEN_08BIT, 0x00},
	{0xc458, CRL_REG_LEN_08BIT, 0x00},
	{0xc459, CRL_REG_LEN_08BIT, 0x00},
	{0xc45b, CRL_REG_LEN_08BIT, 0x00},
	{0xc45c, CRL_REG_LEN_08BIT, 0x00},
	{0xc45d, CRL_REG_LEN_08BIT, 0x00},
	{0xc45e, CRL_REG_LEN_08BIT, 0x00},
	{0xc45f, CRL_REG_LEN_08BIT, 0x00},
	{0xc460, CRL_REG_LEN_08BIT, 0x00},
	{0xc461, CRL_REG_LEN_08BIT, 0x01},
	{0xc462, CRL_REG_LEN_08BIT, 0x01},
	{0xc464, CRL_REG_LEN_08BIT, 0x88},
	{0xc465, CRL_REG_LEN_08BIT, 0x00},
	{0xc466, CRL_REG_LEN_08BIT, 0x8a},
	{0xc467, CRL_REG_LEN_08BIT, 0x00},
	{0xc468, CRL_REG_LEN_08BIT, 0x86},
	{0xc469, CRL_REG_LEN_08BIT, 0x00},
	{0xc46a, CRL_REG_LEN_08BIT, 0x40},
	{0xc46b, CRL_REG_LEN_08BIT, 0x50},
	{0xc46c, CRL_REG_LEN_08BIT, 0x30},
	{0xc46d, CRL_REG_LEN_08BIT, 0x28},
	{0xc46e, CRL_REG_LEN_08BIT, 0x60},
	{0xc46f, CRL_REG_LEN_08BIT, 0x40},
	{0xc47c, CRL_REG_LEN_08BIT, 0x01},
	{0xc47d, CRL_REG_LEN_08BIT, 0x38},
	{0xc47e, CRL_REG_LEN_08BIT, 0x00},
	{0xc47f, CRL_REG_LEN_08BIT, 0x00},
	{0xc480, CRL_REG_LEN_08BIT, 0x00},
	{0xc481, CRL_REG_LEN_08BIT, 0xff},
	{0xc482, CRL_REG_LEN_08BIT, 0x00},
	{0xc483, CRL_REG_LEN_08BIT, 0x40},
	{0xc484, CRL_REG_LEN_08BIT, 0x00},
	{0xc485, CRL_REG_LEN_08BIT, 0x18},
	{0xc486, CRL_REG_LEN_08BIT, 0x00},
	{0xc487, CRL_REG_LEN_08BIT, 0x18},
	{0xc488, CRL_REG_LEN_08BIT, 0x20},
	{0xc489, CRL_REG_LEN_08BIT, 0x00},
	{0xc48a, CRL_REG_LEN_08BIT, 0x20},
	{0xc48b, CRL_REG_LEN_08BIT, 0x00},
	{0xc48c, CRL_REG_LEN_08BIT, 0x00},
	{0xc48d, CRL_REG_LEN_08BIT, 0x04},
	{0xc48e, CRL_REG_LEN_08BIT, 0x00},
	{0xc48f, CRL_REG_LEN_08BIT, 0x04},
	{0xc490, CRL_REG_LEN_08BIT, 0x07},
	{0xc492, CRL_REG_LEN_08BIT, 0x20},
	{0xc493, CRL_REG_LEN_08BIT, 0x08},
	{0xc498, CRL_REG_LEN_08BIT, 0x02},
	{0xc499, CRL_REG_LEN_08BIT, 0x00},
	{0xc49a, CRL_REG_LEN_08BIT, 0x02},
	{0xc49b, CRL_REG_LEN_08BIT, 0x00},
	{0xc49c, CRL_REG_LEN_08BIT, 0x02},
	{0xc49d, CRL_REG_LEN_08BIT, 0x00},
	{0xc49e, CRL_REG_LEN_08BIT, 0x02},
	{0xc49f, CRL_REG_LEN_08BIT, 0x60},
	{0xc4a0, CRL_REG_LEN_08BIT, 0x03},
	{0xc4a1, CRL_REG_LEN_08BIT, 0x00},
	{0xc4a2, CRL_REG_LEN_08BIT, 0x04},
	{0xc4a3, CRL_REG_LEN_08BIT, 0x00},
	{0xc4a4, CRL_REG_LEN_08BIT, 0x00},
	{0xc4a5, CRL_REG_LEN_08BIT, 0x10},
	{0xc4a6, CRL_REG_LEN_08BIT, 0x00},
	{0xc4a7, CRL_REG_LEN_08BIT, 0x40},
	{0xc4a8, CRL_REG_LEN_08BIT, 0x00},
	{0xc4a9, CRL_REG_LEN_08BIT, 0x80},
	{0xc4aa, CRL_REG_LEN_08BIT, 0x0d},
	{0xc4ab, CRL_REG_LEN_08BIT, 0x00},
	{0xc4ac, CRL_REG_LEN_08BIT, 0x0f},
	{0xc4ad, CRL_REG_LEN_08BIT, 0xc0},
	{0xc4b4, CRL_REG_LEN_08BIT, 0x01},
	{0xc4b5, CRL_REG_LEN_08BIT, 0x01},
	{0xc4b6, CRL_REG_LEN_08BIT, 0x00},
	{0xc4b7, CRL_REG_LEN_08BIT, 0x01},
	{0xc4b8, CRL_REG_LEN_08BIT, 0x00},
	{0xc4b9, CRL_REG_LEN_08BIT, 0x01},
	{0xc4ba, CRL_REG_LEN_08BIT, 0x01},
	{0xc4bb, CRL_REG_LEN_08BIT, 0x00},
	{0xc4bc, CRL_REG_LEN_08BIT, 0x01},
	{0xc4bd, CRL_REG_LEN_08BIT, 0x60},
	{0xc4be, CRL_REG_LEN_08BIT, 0x02},
	{0xc4bf, CRL_REG_LEN_08BIT, 0x33},
	{0xc4c8, CRL_REG_LEN_08BIT, 0x03},
	{0xc4c9, CRL_REG_LEN_08BIT, 0xd0},
	{0xc4ca, CRL_REG_LEN_08BIT, 0x0e},
	{0xc4cb, CRL_REG_LEN_08BIT, 0x00},
	{0xc4cc, CRL_REG_LEN_08BIT, 0x04},
	{0xc4cd, CRL_REG_LEN_08BIT, 0xd8},
	{0xc4ce, CRL_REG_LEN_08BIT, 0x04},
	{0xc4cf, CRL_REG_LEN_08BIT, 0xd8},
	{0xc4d0, CRL_REG_LEN_08BIT, 0x04},
	{0xc4d1, CRL_REG_LEN_08BIT, 0x80},
	{0xc4e0, CRL_REG_LEN_08BIT, 0x04},
	{0xc4e1, CRL_REG_LEN_08BIT, 0x02},
	{0xc4e2, CRL_REG_LEN_08BIT, 0x01},
	{0xc4e4, CRL_REG_LEN_08BIT, 0x10},
	{0xc4e5, CRL_REG_LEN_08BIT, 0x20},
	{0xc4e6, CRL_REG_LEN_08BIT, 0x30},
	{0xc4e7, CRL_REG_LEN_08BIT, 0x40},
	{0xc4e8, CRL_REG_LEN_08BIT, 0x50},
	{0xc4e9, CRL_REG_LEN_08BIT, 0x60},
	{0xc4ea, CRL_REG_LEN_08BIT, 0x70},
	{0xc4eb, CRL_REG_LEN_08BIT, 0x80},
	{0xc4ec, CRL_REG_LEN_08BIT, 0x90},
	{0xc4ed, CRL_REG_LEN_08BIT, 0xa0},
	{0xc4ee, CRL_REG_LEN_08BIT, 0xb0},
	{0xc4ef, CRL_REG_LEN_08BIT, 0xc0},
	{0xc4f0, CRL_REG_LEN_08BIT, 0xd0},
	{0xc4f1, CRL_REG_LEN_08BIT, 0xe0},
	{0xc4f2, CRL_REG_LEN_08BIT, 0xf0},
	{0xc4f3, CRL_REG_LEN_08BIT, 0x80},
	{0xc4f4, CRL_REG_LEN_08BIT, 0x00},
	{0xc4f5, CRL_REG_LEN_08BIT, 0x20},
	{0xc4f6, CRL_REG_LEN_08BIT, 0x02},
	{0xc4f7, CRL_REG_LEN_08BIT, 0x00},
	{0xc4f8, CRL_REG_LEN_08BIT, 0x04},
	{0xc4f9, CRL_REG_LEN_08BIT, 0x0b},
	{0xc4fa, CRL_REG_LEN_08BIT, 0x00},
	{0xc4fb, CRL_REG_LEN_08BIT, 0x00},
	{0xc4fc, CRL_REG_LEN_08BIT, 0x01},
	{0xc4fd, CRL_REG_LEN_08BIT, 0x00},
	{0xc4fe, CRL_REG_LEN_08BIT, 0x04},
	{0xc4ff, CRL_REG_LEN_08BIT, 0x02},
	{0xc500, CRL_REG_LEN_08BIT, 0x48},
	{0xc501, CRL_REG_LEN_08BIT, 0x74},
	{0xc502, CRL_REG_LEN_08BIT, 0x58},
	{0xc503, CRL_REG_LEN_08BIT, 0x80},
	{0xc504, CRL_REG_LEN_08BIT, 0x05},
	{0xc505, CRL_REG_LEN_08BIT, 0x80},
	{0xc506, CRL_REG_LEN_08BIT, 0x03},
	{0xc507, CRL_REG_LEN_08BIT, 0x80},
	{0xc508, CRL_REG_LEN_08BIT, 0x01},
	{0xc509, CRL_REG_LEN_08BIT, 0xc0},
	{0xc50a, CRL_REG_LEN_08BIT, 0x01},
	{0xc50b, CRL_REG_LEN_08BIT, 0xa0},
	{0xc50c, CRL_REG_LEN_08BIT, 0x01},
	{0xc50d, CRL_REG_LEN_08BIT, 0x2c},
	{0xc50e, CRL_REG_LEN_08BIT, 0x01},
	{0xc50f, CRL_REG_LEN_08BIT, 0x0a},
	{0xc510, CRL_REG_LEN_08BIT, 0x00},
	{0xc511, CRL_REG_LEN_08BIT, 0x00},
	{0xc512, CRL_REG_LEN_08BIT, 0x4d},
	{0xc513, CRL_REG_LEN_08BIT, 0x84},
	{0xc514, CRL_REG_LEN_08BIT, 0x04},
	{0xc515, CRL_REG_LEN_08BIT, 0x00},
	{0xc518, CRL_REG_LEN_08BIT, 0x03},
	{0xc519, CRL_REG_LEN_08BIT, 0x48},
	{0xc51a, CRL_REG_LEN_08BIT, 0x07},
	{0xc51b, CRL_REG_LEN_08BIT, 0x70},
	{0xc2e0, CRL_REG_LEN_08BIT, 0x00},
	{0xc2e1, CRL_REG_LEN_08BIT, 0x51},
	{0xc2e2, CRL_REG_LEN_08BIT, 0x00},
	{0xc2e3, CRL_REG_LEN_08BIT, 0xd6},
	{0xc2e4, CRL_REG_LEN_08BIT, 0x01},
	{0xc2e5, CRL_REG_LEN_08BIT, 0x5e},
	{0xc2e9, CRL_REG_LEN_08BIT, 0x01},
	{0xc2ea, CRL_REG_LEN_08BIT, 0x7a},
	{0xc2eb, CRL_REG_LEN_08BIT, 0x90},
	{0xc2ed, CRL_REG_LEN_08BIT, 0x00},
	{0xc2ee, CRL_REG_LEN_08BIT, 0x7a},
	{0xc2ef, CRL_REG_LEN_08BIT, 0x64},
	{0xc308, CRL_REG_LEN_08BIT, 0x00},
	{0xc309, CRL_REG_LEN_08BIT, 0x00},
	{0xc30a, CRL_REG_LEN_08BIT, 0x00},
	{0xc30c, CRL_REG_LEN_08BIT, 0x00},
	{0xc30d, CRL_REG_LEN_08BIT, 0x01},
	{0xc30e, CRL_REG_LEN_08BIT, 0x00},
	{0xc30f, CRL_REG_LEN_08BIT, 0x00},
	{0xc310, CRL_REG_LEN_08BIT, 0x01},
	{0xc311, CRL_REG_LEN_08BIT, 0x60},
	{0xc312, CRL_REG_LEN_08BIT, 0xff},
	{0xc313, CRL_REG_LEN_08BIT, 0x08},
	{0xc314, CRL_REG_LEN_08BIT, 0x01},
	{0xc315, CRL_REG_LEN_08BIT, 0x7f},
	{0xc316, CRL_REG_LEN_08BIT, 0xff},
	{0xc317, CRL_REG_LEN_08BIT, 0x0b},
	{0xc318, CRL_REG_LEN_08BIT, 0x00},
	{0xc319, CRL_REG_LEN_08BIT, 0x0c},
	{0xc31a, CRL_REG_LEN_08BIT, 0x00},
	{0xc31b, CRL_REG_LEN_08BIT, 0xe0},
	{0xc31c, CRL_REG_LEN_08BIT, 0x00},
	{0xc31d, CRL_REG_LEN_08BIT, 0x14},
	{0xc31e, CRL_REG_LEN_08BIT, 0x00},
	{0xc31f, CRL_REG_LEN_08BIT, 0xc5},
	{0xc320, CRL_REG_LEN_08BIT, 0xff},
	{0xc321, CRL_REG_LEN_08BIT, 0x4b},
	{0xc322, CRL_REG_LEN_08BIT, 0xff},
	{0xc323, CRL_REG_LEN_08BIT, 0xf0},
	{0xc324, CRL_REG_LEN_08BIT, 0xff},
	{0xc325, CRL_REG_LEN_08BIT, 0xe8},
	{0xc326, CRL_REG_LEN_08BIT, 0x00},
	{0xc327, CRL_REG_LEN_08BIT, 0x46},
	{0xc328, CRL_REG_LEN_08BIT, 0xff},
	{0xc329, CRL_REG_LEN_08BIT, 0xd2},
	{0xc32a, CRL_REG_LEN_08BIT, 0xff},
	{0xc32b, CRL_REG_LEN_08BIT, 0xe4},
	{0xc32c, CRL_REG_LEN_08BIT, 0xff},
	{0xc32d, CRL_REG_LEN_08BIT, 0xbb},
	{0xc32e, CRL_REG_LEN_08BIT, 0x00},
	{0xc32f, CRL_REG_LEN_08BIT, 0x61},
	{0xc330, CRL_REG_LEN_08BIT, 0xff},
	{0xc331, CRL_REG_LEN_08BIT, 0xf9},
	{0xc332, CRL_REG_LEN_08BIT, 0x00},
	{0xc333, CRL_REG_LEN_08BIT, 0xd9},
	{0xc334, CRL_REG_LEN_08BIT, 0x00},
	{0xc335, CRL_REG_LEN_08BIT, 0x2e},
	{0xc336, CRL_REG_LEN_08BIT, 0x00},
	{0xc337, CRL_REG_LEN_08BIT, 0xb1},
	{0xc338, CRL_REG_LEN_08BIT, 0xff},
	{0xc339, CRL_REG_LEN_08BIT, 0x64},
	{0xc33a, CRL_REG_LEN_08BIT, 0xff},
	{0xc33b, CRL_REG_LEN_08BIT, 0xeb},
	{0xc33c, CRL_REG_LEN_08BIT, 0xff},
	{0xc33d, CRL_REG_LEN_08BIT, 0xe8},
	{0xc33e, CRL_REG_LEN_08BIT, 0x00},
	{0xc33f, CRL_REG_LEN_08BIT, 0x48},
	{0xc340, CRL_REG_LEN_08BIT, 0xff},
	{0xc341, CRL_REG_LEN_08BIT, 0xd0},
	{0xc342, CRL_REG_LEN_08BIT, 0xff},
	{0xc343, CRL_REG_LEN_08BIT, 0xed},
	{0xc344, CRL_REG_LEN_08BIT, 0xff},
	{0xc345, CRL_REG_LEN_08BIT, 0xad},
	{0xc346, CRL_REG_LEN_08BIT, 0x00},
	{0xc347, CRL_REG_LEN_08BIT, 0x66},
	{0xc348, CRL_REG_LEN_08BIT, 0x01},
	{0xc349, CRL_REG_LEN_08BIT, 0x00},
	{0x6700, CRL_REG_LEN_08BIT, 0x04},
	{0x6701, CRL_REG_LEN_08BIT, 0x7b},
	{0x6702, CRL_REG_LEN_08BIT, 0xfd},
	{0x6703, CRL_REG_LEN_08BIT, 0xf9},
	{0x6704, CRL_REG_LEN_08BIT, 0x3d},
	{0x6705, CRL_REG_LEN_08BIT, 0x71},
	{0x6706, CRL_REG_LEN_08BIT, 0x78},
	{0x6708, CRL_REG_LEN_08BIT, 0x05},
	{0x6f06, CRL_REG_LEN_08BIT, 0x6f},
	{0x6f07, CRL_REG_LEN_08BIT, 0x00},
	{0x6f0a, CRL_REG_LEN_08BIT, 0x6f},
	{0x6f0b, CRL_REG_LEN_08BIT, 0x00},
	{0x6f00, CRL_REG_LEN_08BIT, 0x03},
	{0xc34c, CRL_REG_LEN_08BIT, 0x01},
	{0xc34d, CRL_REG_LEN_08BIT, 0x00},
	{0xc34e, CRL_REG_LEN_08BIT, 0x46},
	{0xc34f, CRL_REG_LEN_08BIT, 0x55},
	{0xc350, CRL_REG_LEN_08BIT, 0x00},
	{0xc351, CRL_REG_LEN_08BIT, 0x40},
	{0xc352, CRL_REG_LEN_08BIT, 0x00},
	{0xc353, CRL_REG_LEN_08BIT, 0xff},
	{0xc354, CRL_REG_LEN_08BIT, 0x04},
	{0xc355, CRL_REG_LEN_08BIT, 0x08},
	{0xc356, CRL_REG_LEN_08BIT, 0x01},
	{0xc357, CRL_REG_LEN_08BIT, 0xef},
	{0xc358, CRL_REG_LEN_08BIT, 0x30},
	{0xc359, CRL_REG_LEN_08BIT, 0x01},
	{0xc35a, CRL_REG_LEN_08BIT, 0x64},
	{0xc35b, CRL_REG_LEN_08BIT, 0x46},
	{0xc35c, CRL_REG_LEN_08BIT, 0x00},
	{0x3621, CRL_REG_LEN_08BIT, 0x73},
	{0x3702, CRL_REG_LEN_08BIT, 0x20},
	{0x3703, CRL_REG_LEN_08BIT, 0x48},
	{0x3704, CRL_REG_LEN_08BIT, 0x32},
	{0x3800, CRL_REG_LEN_08BIT, 0x00},
	{0x3801, CRL_REG_LEN_08BIT, 0x00},
	{0x3802, CRL_REG_LEN_08BIT, 0x00},
	{0x3803, CRL_REG_LEN_08BIT, 0xA4},
	{0x3804, CRL_REG_LEN_08BIT, 0x00},
	{0x3805, CRL_REG_LEN_08BIT, 0xFF},
	{0x3806, CRL_REG_LEN_08BIT, 0x02},
	{0x3807, CRL_REG_LEN_08BIT, 0x89},
	{0x3808, CRL_REG_LEN_08BIT, 0x02},
	{0x3809, CRL_REG_LEN_08BIT, 0x80},
	{0x380a, CRL_REG_LEN_08BIT, 0x01},
	{0x380b, CRL_REG_LEN_08BIT, 0xE0},
	{0x380c, CRL_REG_LEN_08BIT, 0x04},
	{0x380d, CRL_REG_LEN_08BIT, 0xAC},
	{0x6e42, CRL_REG_LEN_08BIT, 0x05},
	{0x6e43, CRL_REG_LEN_08BIT, 0x3A},
	{0x3810, CRL_REG_LEN_08BIT, 0x00},
	{0x3811, CRL_REG_LEN_08BIT, 0x08},
	{0x3812, CRL_REG_LEN_08BIT, 0x00},
	{0x3813, CRL_REG_LEN_08BIT, 0x02},
	{0x381c, CRL_REG_LEN_08BIT, 0x00},
	{0x381e, CRL_REG_LEN_08BIT, 0x00},
	{0x381f, CRL_REG_LEN_08BIT, 0x0C},
	{0x4001, CRL_REG_LEN_08BIT, 0x06},
	{0x4004, CRL_REG_LEN_08BIT, 0x04},
	{0x4050, CRL_REG_LEN_08BIT, 0x22},
	{0x4051, CRL_REG_LEN_08BIT, 0x24},
	{0x4605, CRL_REG_LEN_08BIT, 0x08},
	{0x4606, CRL_REG_LEN_08BIT, 0x09},
	{0x4607, CRL_REG_LEN_08BIT, 0x58},
	{0xc488, CRL_REG_LEN_08BIT, 0x53},
	{0xc489, CRL_REG_LEN_08BIT, 0x20},
	{0xc48a, CRL_REG_LEN_08BIT, 0x53},
	{0xc48b, CRL_REG_LEN_08BIT, 0x20},
	{0xc4cc, CRL_REG_LEN_08BIT, 0x04},
	{0xc4cd, CRL_REG_LEN_08BIT, 0xD8},
	{0xc4ce, CRL_REG_LEN_08BIT, 0x04},
	{0xc4cf, CRL_REG_LEN_08BIT, 0xD8},
	{0xc510, CRL_REG_LEN_08BIT, 0x00},
	{0xc511, CRL_REG_LEN_08BIT, 0x00},
	{0xc512, CRL_REG_LEN_08BIT, 0x4D},
	{0xc513, CRL_REG_LEN_08BIT, 0x84},
	{0x5005, CRL_REG_LEN_08BIT, 0x08},
	{0x3007, CRL_REG_LEN_08BIT, 0x01},
	{0xc518, CRL_REG_LEN_08BIT, 0x05},
	{0xc519, CRL_REG_LEN_08BIT, 0x3A},
	{0xc51a, CRL_REG_LEN_08BIT, 0x04},
	{0xc51b, CRL_REG_LEN_08BIT, 0xAC},
	{0x5608, CRL_REG_LEN_08BIT, 0x15},
	{0x3815, CRL_REG_LEN_08BIT, 0x8C},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x3042, CRL_REG_LEN_08BIT, 0xf0},
	{0x302e, CRL_REG_LEN_08BIT, 0x00},
	{0x301b, CRL_REG_LEN_08BIT, 0xf0},
	{0x301c, CRL_REG_LEN_08BIT, 0xf0},
	{0x301a, CRL_REG_LEN_08BIT, 0xf0},
	{0xceb0, CRL_REG_LEN_08BIT, 0x00},
	{0xceb1, CRL_REG_LEN_08BIT, 0x00},
	{0xceb2, CRL_REG_LEN_08BIT, 0x00},
	{0xceb3, CRL_REG_LEN_08BIT, 0x00},
	{0xceb4, CRL_REG_LEN_08BIT, 0x00},
	{0xceb5, CRL_REG_LEN_08BIT, 0x00},
	{0xceb6, CRL_REG_LEN_08BIT, 0x00},
	{0xceb7, CRL_REG_LEN_08BIT, 0x00},
	{0xc4bc, CRL_REG_LEN_08BIT, 0x01},
	{0xc4bd, CRL_REG_LEN_08BIT, 0x60},
};

static struct crl_dynamic_register_access ov10635_h_flip_regs[] = {
	{
		.address = 0x300c,
		.len = CRL_REG_LEN_08BIT | CRL_REG_READ_AND_UPDATE,
		.ops_items = 0,
		.ops = 0,
		.mask = 0x3,
	}
};

static struct crl_dynamic_register_access ov10635_v_flip_regs[] = {
	{
		.address = 0x300c,
		.len = CRL_REG_LEN_08BIT | CRL_REG_READ_AND_UPDATE,
		.ops_items = 0,
		.ops = 0,
		.mask = 0xc,
	}
};

/* Needed for acpi support for runtime detection */
static struct crl_sensor_detect_config ov10635_sensor_detect_regset[] = {
	{
		.reg = { 0x300A, CRL_REG_LEN_08BIT, 0x000000ff },
		.width = 8,
	},
	{
		.reg = { 0x300B, CRL_REG_LEN_08BIT, 0x000000ff },
		.width = 8,
	}
};

static struct crl_pll_configuration ov10635_pll_configurations[] = {
	{
		.input_clk = 12000000,
		.op_sys_clk = 392000000,
		.bitsperpixel = 16,
		.pixel_rate_csi = 529000000,
		.pixel_rate_pa = 529000000, /* pixel_rate = MIPICLK*2 *4/12 */
		.csi_lanes = 4,
		.comp_items = 0,
		.ctrl_data = 0,
		.pll_regs_items = 0,
		.pll_regs = NULL,
	},
	{
		.input_clk = 12000000,
		.op_sys_clk = 392000000,
		.bitsperpixel = 10,
		.pixel_rate_csi = 529000000,
		.pixel_rate_pa = 529000000, /* pixel_rate = MIPICLK*2 *4/12 */
		.csi_lanes = 4,
		.comp_items = 0,
		.ctrl_data = 0,
		.pll_regs_items = 0,
		.pll_regs = NULL,
	},
	{
		.input_clk = 12000000,
		.op_sys_clk = 392000000,
		.bitsperpixel = 20,
		.pixel_rate_csi = 529000000,
		.pixel_rate_pa = 529000000, /* pixel_rate = MIPICLK*2 *4/12 */
		.csi_lanes = 4,
		.comp_items = 0,
		.ctrl_data = 0,
		.pll_regs_items = 0,
		.pll_regs = NULL,
	}
};

static struct crl_subdev_rect_rep ov10635_1280_800_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 1280,
		.in_rect.height = 800,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 1280,
		.out_rect.height = 800,
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 1280,
		.in_rect.height = 800,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 1280,
		.out_rect.height = 800,
	},
};

static struct crl_subdev_rect_rep ov10635_640_480_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 1280,
		.in_rect.height = 800,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 1280,
		.out_rect.height = 800,
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect.left = 0,
		.in_rect.top = 0,
		.in_rect.width = 1280,
		.in_rect.height = 800,
		.out_rect.left = 0,
		.out_rect.top = 0,
		.out_rect.width = 640,
		.out_rect.height = 480,
	},
};

static struct crl_register_write_rep ov10635_powerup_regs[] = {
	{OV10635_REG_RESET, CRL_REG_LEN_08BIT, 0x01},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
	{0x300c, CRL_REG_LEN_08BIT, 0x61},
};

static struct crl_register_write_rep ov10635_poweroff_regs[] = {
	{OV10635_REG_RESET, CRL_REG_LEN_08BIT, 0x01},
};

static struct crl_mode_rep ov10635_modes[] = {
	{
		.sd_rects_items = ARRAY_SIZE(ov10635_1280_800_rects),
		.sd_rects = ov10635_1280_800_rects,
		.binn_hor = 1,
		.binn_vert = 1,
		.scale_m = 1,
		.width = 1280,
		.height = 800,
		.min_llp = 2250,
		.min_fll = 1320,
		.mode_regs_items = ARRAY_SIZE(ov10635_1280_800_YUV_HDR),
		.mode_regs = ov10635_1280_800_YUV_HDR,
	},
	{
		.sd_rects_items = ARRAY_SIZE(ov10635_640_480_rects),
		.sd_rects = ov10635_640_480_rects,
		.binn_hor = 2,
		.binn_vert = 1,
		.scale_m = 1,
		.width = 640,
		.height = 480,
		.min_llp = 2250,
		.min_fll = 1320,
		.mode_regs_items = ARRAY_SIZE(ov10635_640_480_YUV_HDR),
		.mode_regs = ov10635_640_480_YUV_HDR,
	},
};

static struct crl_sensor_subdev_config ov10635_sensor_subdevs[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.name = "ov10635 binner",
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.name = "ov10635 pixel array",
	}
};

static struct crl_sensor_limits ov10635_sensor_limits = {
	.x_addr_min = 0,
	.y_addr_min = 0,
	.x_addr_max = 1280,
	.y_addr_max = 800,
	.min_frame_length_lines = 240,
	.max_frame_length_lines = 65535,
	.min_line_length_pixels = 320,
	.max_line_length_pixels = 32752,
};

static struct crl_flip_data ov10635_flip_configurations[] = {
	{
		.flip = CRL_FLIP_DEFAULT_NONE,
		.pixel_order = CRL_PIXEL_ORDER_IGNORE,
	},
	{
		.flip = CRL_FLIP_HFLIP,
		.pixel_order = CRL_PIXEL_ORDER_IGNORE,
	},
	{
		.flip = CRL_FLIP_VFLIP,
		.pixel_order = CRL_PIXEL_ORDER_IGNORE,
	},
	{
		.flip = CRL_FLIP_HFLIP_VFLIP,
		.pixel_order = CRL_PIXEL_ORDER_IGNORE,
	}
};

static struct crl_register_write_rep ov10635_yuyv_regs[] = {
	{0x4300, CRL_REG_LEN_08BIT, 0x38},
};

static struct crl_register_write_rep ov10635_uyvy_regs[] = {
	{0x4300, CRL_REG_LEN_08BIT, 0x3a},
};

static struct crl_csi_data_fmt ov10635_crl_csi_data_fmt[] = {
	{
		.code = MEDIA_BUS_FMT_YUYV8_1X16,
		.pixel_order = CRL_PIXEL_ORDER_IGNORE,
		.bits_per_pixel = 16,
		.regs_items = ARRAY_SIZE(ov10635_yuyv_regs),
		.regs = ov10635_yuyv_regs,
	},
	{
		.code = MEDIA_BUS_FMT_UYVY8_1X16,
		.pixel_order = CRL_PIXEL_ORDER_IGNORE,
		.bits_per_pixel = 16,
		.regs_items = ARRAY_SIZE(ov10635_uyvy_regs),
		.regs = ov10635_uyvy_regs,
	},
};

static struct crl_v4l2_ctrl ov10635_v4l2_ctrls[] = {
	{
		.sd_type = CRL_SUBDEV_TYPE_BINNER,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_IDLE,
		.ctrl_id = V4L2_CID_LINK_FREQ,
		.name = "V4L2_CID_LINK_FREQ",
		.type = CRL_V4L2_CTRL_TYPE_MENU_INT,
		.data.v4l2_int_menu.def = 0,
		.data.v4l2_int_menu.max = 0,
		.data.v4l2_int_menu.menu = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.regs_items = 0,
		.regs = 0,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_GET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_PIXEL_RATE,
		.name = "V4L2_CID_PIXEL_RATE_PA",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = INT_MAX,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.regs_items = 0,
		.regs = 0,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_BINNER,
		.op_type = CRL_V4L2_CTRL_GET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_PIXEL_RATE,
		.name = "V4L2_CID_PIXEL_RATE_CSI",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = INT_MAX,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.regs_items = 0,
		.regs = 0,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_HFLIP,
		.name = "V4L2_CID_HFLIP",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = 1,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(ov10635_h_flip_regs),
		.regs = ov10635_h_flip_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
	 },
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_VFLIP,
		.name = "V4L2_CID_VFLIP",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = 1,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(ov10635_v_flip_regs),
		.regs = ov10635_v_flip_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
	 },
};

struct crl_sensor_configuration ov10635_crl_configuration = {

	.powerup_regs_items = ARRAY_SIZE(ov10635_powerup_regs),
	.powerup_regs = ov10635_powerup_regs,

	.poweroff_regs_items = ARRAY_SIZE(ov10635_poweroff_regs),
	.poweroff_regs = ov10635_poweroff_regs,

	.id_reg_items = ARRAY_SIZE(ov10635_sensor_detect_regset),
	.id_regs = ov10635_sensor_detect_regset,

	.subdev_items = ARRAY_SIZE(ov10635_sensor_subdevs),
	.subdevs = ov10635_sensor_subdevs,

	.pll_config_items = ARRAY_SIZE(ov10635_pll_configurations),
	.pll_configs = ov10635_pll_configurations,

	.sensor_limits = &ov10635_sensor_limits,

	.modes_items = ARRAY_SIZE(ov10635_modes),
	.modes = ov10635_modes,

	.streamon_regs_items = 0,
	.streamon_regs = 0,

	.streamoff_regs_items = 0,
	.streamoff_regs = 0,

	.v4l2_ctrls_items = ARRAY_SIZE(ov10635_v4l2_ctrls),
	.v4l2_ctrl_bank = ov10635_v4l2_ctrls,

	.csi_fmts_items = ARRAY_SIZE(ov10635_crl_csi_data_fmt),
	.csi_fmts = ov10635_crl_csi_data_fmt,

	.flip_items = ARRAY_SIZE(ov10635_flip_configurations),
	.flip_data = ov10635_flip_configurations,
};

#endif  /* __CRLMODULE_OV10635_CONFIGURATION_H_ */
