/*
 * Copyright (c) 2016 Intel Corporation.
 *
 * Author: Shuguang Gong <shuguang.gong@intel.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef __CRLMODULE_OV10640_CONFIGURATION_H_
#define __CRLMODULE_OV10640_CONFIGURATION_H_

#include "crlmodule-sensor-ds.h"

#define OV10640_REG_STREAM		0x3012
#define OV10640_REG_RESET		0x3013

#define OV10640_HMAX			65535
#define OV10640_VMAX			131071
#define OV10640_MAX_SHS1		(OV10640_VMAX - 2)

/* 111Mbps for ov10640 720p 30fps */
static struct crl_register_write_rep ov10640_pll_794mbps[] = {
	{0x3000, CRL_REG_LEN_08BIT, 0x03},
	{0x3001, CRL_REG_LEN_08BIT, 0x48},
	{0x3002, CRL_REG_LEN_08BIT, 0x07},
	{0x3004, CRL_REG_LEN_08BIT, 0x03},
	{0x3005, CRL_REG_LEN_08BIT, 0x48},
	{0x3006, CRL_REG_LEN_08BIT, 0x07},
	{0x3007, CRL_REG_LEN_08BIT, 0x01},
};

static struct crl_register_write_rep ov10640_powerup_standby[] = {
	{OV10640_REG_RESET, CRL_REG_LEN_08BIT, 0x01},
};

static struct crl_register_write_rep ov10640_1280_1080_LONG_RAW[] = {
	{0x328a, CRL_REG_LEN_08BIT, 0x11},
	{0x313f, CRL_REG_LEN_08BIT, 0x80},
	{0x3132, CRL_REG_LEN_08BIT, 0x24},
	{0x3014, CRL_REG_LEN_08BIT, 0x03},
	{0x3023, CRL_REG_LEN_08BIT, 0x05},
	{0x3032, CRL_REG_LEN_08BIT, 0x35},
	{0x3033, CRL_REG_LEN_08BIT, 0x04},
	{0x3054, CRL_REG_LEN_08BIT, 0x00},
	{0x3055, CRL_REG_LEN_08BIT, 0x08},
	{0x3056, CRL_REG_LEN_08BIT, 0x01},
	{0x3057, CRL_REG_LEN_08BIT, 0xff},
	{0x3058, CRL_REG_LEN_08BIT, 0xaf},
	{0x3059, CRL_REG_LEN_08BIT, 0x44},
	{0x305a, CRL_REG_LEN_08BIT, 0x02},
	{0x305b, CRL_REG_LEN_08BIT, 0x00},
	{0x305c, CRL_REG_LEN_08BIT, 0x30},
	{0x305d, CRL_REG_LEN_08BIT, 0x9e},
	{0x305e, CRL_REG_LEN_08BIT, 0x19},
	{0x305f, CRL_REG_LEN_08BIT, 0x18},
	{0x3060, CRL_REG_LEN_08BIT, 0xf9},
	{0x3061, CRL_REG_LEN_08BIT, 0xf0},
	{0x308c, CRL_REG_LEN_08BIT, 0x03},
	{0x308f, CRL_REG_LEN_08BIT, 0x10},
	{0x3090, CRL_REG_LEN_08BIT, 0x00},
	{0x3091, CRL_REG_LEN_08BIT, 0x00},
	{0x30eb, CRL_REG_LEN_08BIT, 0x00},
	{0x30a3, CRL_REG_LEN_08BIT, 0x08},
	{0x30ad, CRL_REG_LEN_08BIT, 0x03},
	{0x30ae, CRL_REG_LEN_08BIT, 0x80},
	{0x30af, CRL_REG_LEN_08BIT, 0x80},
	{0x30b0, CRL_REG_LEN_08BIT, 0xff},
	{0x30b1, CRL_REG_LEN_08BIT, 0x3f},
	{0x30b2, CRL_REG_LEN_08BIT, 0x22},
	{0x30b9, CRL_REG_LEN_08BIT, 0x22},
	{0x30bb, CRL_REG_LEN_08BIT, 0x00},
	{0x30bc, CRL_REG_LEN_08BIT, 0x00},
	{0x30bd, CRL_REG_LEN_08BIT, 0x00},
	{0x30be, CRL_REG_LEN_08BIT, 0x00},
	{0x30bf, CRL_REG_LEN_08BIT, 0x00},
	{0x30c0, CRL_REG_LEN_08BIT, 0x00},
	{0x30c1, CRL_REG_LEN_08BIT, 0x00},
	{0x30c2, CRL_REG_LEN_08BIT, 0x00},
	{0x30c3, CRL_REG_LEN_08BIT, 0x00},
	{0x30c4, CRL_REG_LEN_08BIT, 0x80},
	{0x30c5, CRL_REG_LEN_08BIT, 0x00},
	{0x30c6, CRL_REG_LEN_08BIT, 0x80},
	{0x30c7, CRL_REG_LEN_08BIT, 0x00},
	{0x30c8, CRL_REG_LEN_08BIT, 0x80},
	{0x3119, CRL_REG_LEN_08BIT, 0x45},
	{0x311a, CRL_REG_LEN_08BIT, 0x01},
	{0x311b, CRL_REG_LEN_08BIT, 0x4a},
	{0x3074, CRL_REG_LEN_08BIT, 0x00},
	{0x3075, CRL_REG_LEN_08BIT, 0x00},
	{0x3076, CRL_REG_LEN_08BIT, 0x00},
	{0x3077, CRL_REG_LEN_08BIT, 0x02},
	{0x3078, CRL_REG_LEN_08BIT, 0x05},
	{0x3079, CRL_REG_LEN_08BIT, 0x07},
	{0x307a, CRL_REG_LEN_08BIT, 0x04},
	{0x307b, CRL_REG_LEN_08BIT, 0x41},
	{0x307c, CRL_REG_LEN_08BIT, 0x05},
	{0x307d, CRL_REG_LEN_08BIT, 0x00},
	{0x307e, CRL_REG_LEN_08BIT, 0x04},
	{0x307f, CRL_REG_LEN_08BIT, 0x38},
	{0x3080, CRL_REG_LEN_08BIT, 0x05},
	{0x3081, CRL_REG_LEN_08BIT, 0xb2},
	{0x3082, CRL_REG_LEN_08BIT, 0x06},
	{0x3083, CRL_REG_LEN_08BIT, 0x6e},
	{0x3084, CRL_REG_LEN_08BIT, 0x00},
	{0x3085, CRL_REG_LEN_08BIT, 0x04},
	{0x3086, CRL_REG_LEN_08BIT, 0x00},
	{0x3087, CRL_REG_LEN_08BIT, 0x04},
	{0x3088, CRL_REG_LEN_08BIT, 0x00},
	{0x3089, CRL_REG_LEN_08BIT, 0x40},
	{0x308d, CRL_REG_LEN_08BIT, 0x92},
	{0x3094, CRL_REG_LEN_08BIT, 0xa5},
	{0x30e6, CRL_REG_LEN_08BIT, 0x04},
	{0x30e7, CRL_REG_LEN_08BIT, 0x48},
	{0x30e8, CRL_REG_LEN_08BIT, 0x04},
	{0x30e9, CRL_REG_LEN_08BIT, 0x48},
	{0x30e9, CRL_REG_LEN_08BIT, 0x05},
	{0x30ec, CRL_REG_LEN_08BIT, 0x01},
	{0x30fa, CRL_REG_LEN_08BIT, 0x06},
	{0x3120, CRL_REG_LEN_08BIT, 0x00},
	{0x3121, CRL_REG_LEN_08BIT, 0x01},
	{0x3122, CRL_REG_LEN_08BIT, 0x00},
	{0x3127, CRL_REG_LEN_08BIT, 0x63},
	{0x3128, CRL_REG_LEN_08BIT, 0xc0},
	{0x3129, CRL_REG_LEN_08BIT, 0x00},
	{0x31be, CRL_REG_LEN_08BIT, 0x00},
	{0x30a5, CRL_REG_LEN_08BIT, 0x78},
	{0x30a6, CRL_REG_LEN_08BIT, 0x40},
	{0x30a7, CRL_REG_LEN_08BIT, 0x78},
	{0x30a8, CRL_REG_LEN_08BIT, 0x80},
	{0x30a9, CRL_REG_LEN_08BIT, 0x78},
	{0x30aa, CRL_REG_LEN_08BIT, 0xe0},
	{0x30ab, CRL_REG_LEN_08BIT, 0xf9},
	{0x30ac, CRL_REG_LEN_08BIT, 0xc0},
	{0x3440, CRL_REG_LEN_08BIT, 0x04},
	{0x3444, CRL_REG_LEN_08BIT, 0x28},
	{0x344e, CRL_REG_LEN_08BIT, 0x2c},
	{0x3457, CRL_REG_LEN_08BIT, 0x33},
	{0x345e, CRL_REG_LEN_08BIT, 0x38},
	{0x3461, CRL_REG_LEN_08BIT, 0xa8},
	{0x7002, CRL_REG_LEN_08BIT, 0xaa},
	{0x7001, CRL_REG_LEN_08BIT, 0xdf},
	{0x7048, CRL_REG_LEN_08BIT, 0x00},
	{0x7049, CRL_REG_LEN_08BIT, 0x02},
	{0x704a, CRL_REG_LEN_08BIT, 0x02},
	{0x704b, CRL_REG_LEN_08BIT, 0x00},
	{0x704c, CRL_REG_LEN_08BIT, 0x01},
	{0x704d, CRL_REG_LEN_08BIT, 0x00},
	{0x7043, CRL_REG_LEN_08BIT, 0x04},
	{0x7040, CRL_REG_LEN_08BIT, 0x3c},
	{0x7047, CRL_REG_LEN_08BIT, 0x00},
	{0x7044, CRL_REG_LEN_08BIT, 0x01},
	{0x7000, CRL_REG_LEN_08BIT, 0x1f},
	{0x7084, CRL_REG_LEN_08BIT, 0x01},
	{0x7085, CRL_REG_LEN_08BIT, 0x03},
	{0x7086, CRL_REG_LEN_08BIT, 0x02},
	{0x7087, CRL_REG_LEN_08BIT, 0x40},
	{0x7088, CRL_REG_LEN_08BIT, 0x01},
	{0x7089, CRL_REG_LEN_08BIT, 0x20},
	{0x707f, CRL_REG_LEN_08BIT, 0x04},
	{0x707c, CRL_REG_LEN_08BIT, 0x3c},
	{0x7083, CRL_REG_LEN_08BIT, 0x00},
	{0x7080, CRL_REG_LEN_08BIT, 0x01},
	{0x7003, CRL_REG_LEN_08BIT, 0xdf},
	{0x70c0, CRL_REG_LEN_08BIT, 0x00},
	{0x70c1, CRL_REG_LEN_08BIT, 0x02},
	{0x70c2, CRL_REG_LEN_08BIT, 0x02},
	{0x70c3, CRL_REG_LEN_08BIT, 0x00},
	{0x70c4, CRL_REG_LEN_08BIT, 0x01},
	{0x70c5, CRL_REG_LEN_08BIT, 0x00},
	{0x70b8, CRL_REG_LEN_08BIT, 0x03},
	{0x70b9, CRL_REG_LEN_08BIT, 0x98},
	{0x70bc, CRL_REG_LEN_08BIT, 0x00},
	{0x70bd, CRL_REG_LEN_08BIT, 0x80},
	{0x7004, CRL_REG_LEN_08BIT, 0x02},
	{0x7005, CRL_REG_LEN_08BIT, 0x00},
	{0x7006, CRL_REG_LEN_08BIT, 0x01},
	{0x7007, CRL_REG_LEN_08BIT, 0x80},
	{0x7008, CRL_REG_LEN_08BIT, 0x02},
	{0x7009, CRL_REG_LEN_08BIT, 0x00},
	{0x700a, CRL_REG_LEN_08BIT, 0x04},
	{0x700b, CRL_REG_LEN_08BIT, 0x00},
	{0x700e, CRL_REG_LEN_08BIT, 0x00},
	{0x700f, CRL_REG_LEN_08BIT, 0x60},
	{0x701a, CRL_REG_LEN_08BIT, 0x02},
	{0x701b, CRL_REG_LEN_08BIT, 0x00},
	{0x701c, CRL_REG_LEN_08BIT, 0x01},
	{0x701d, CRL_REG_LEN_08BIT, 0x80},
	{0x701e, CRL_REG_LEN_08BIT, 0x02},
	{0x701f, CRL_REG_LEN_08BIT, 0x00},
	{0x7020, CRL_REG_LEN_08BIT, 0x04},
	{0x7021, CRL_REG_LEN_08BIT, 0x00},
	{0x7024, CRL_REG_LEN_08BIT, 0x00},
	{0x7025, CRL_REG_LEN_08BIT, 0x60},
	{0x70e7, CRL_REG_LEN_08BIT, 0x00},
	{0x70e4, CRL_REG_LEN_08BIT, 0x10},
	{0x70e5, CRL_REG_LEN_08BIT, 0x00},
	{0x70e6, CRL_REG_LEN_08BIT, 0x00},
	{0x70eb, CRL_REG_LEN_08BIT, 0x00},
	{0x70e8, CRL_REG_LEN_08BIT, 0x10},
	{0x70e9, CRL_REG_LEN_08BIT, 0x00},
	{0x70ea, CRL_REG_LEN_08BIT, 0x00},
	{0x70ef, CRL_REG_LEN_08BIT, 0x00},
	{0x70ec, CRL_REG_LEN_08BIT, 0xfd},
	{0x70ed, CRL_REG_LEN_08BIT, 0x00},
	{0x70ee, CRL_REG_LEN_08BIT, 0x00},
	{0x70eb, CRL_REG_LEN_08BIT, 0x00},
	{0x70f0, CRL_REG_LEN_08BIT, 0xfd},
	{0x70f1, CRL_REG_LEN_08BIT, 0x00},
	{0x70f2, CRL_REG_LEN_08BIT, 0x00},
	{0x30fb, CRL_REG_LEN_08BIT, 0x06},
	{0x30fc, CRL_REG_LEN_08BIT, 0x80},
	{0x30fd, CRL_REG_LEN_08BIT, 0x02},
	{0x30fe, CRL_REG_LEN_08BIT, 0x93},
	{0x6000, CRL_REG_LEN_08BIT, 0xc1},
	{0x6001, CRL_REG_LEN_08BIT, 0xb9},
	{0x6002, CRL_REG_LEN_08BIT, 0xba},
	{0x6003, CRL_REG_LEN_08BIT, 0xa4},
	{0x6004, CRL_REG_LEN_08BIT, 0xb5},
	{0x6005, CRL_REG_LEN_08BIT, 0xa0},
	{0x6006, CRL_REG_LEN_08BIT, 0x82},
	{0x6007, CRL_REG_LEN_08BIT, 0xa7},
	{0x6008, CRL_REG_LEN_08BIT, 0xb7},
	{0x6009, CRL_REG_LEN_08BIT, 0x5c},
	{0x600a, CRL_REG_LEN_08BIT, 0x9e},
	{0x600b, CRL_REG_LEN_08BIT, 0xc0},
	{0x600c, CRL_REG_LEN_08BIT, 0xd2},
	{0x600d, CRL_REG_LEN_08BIT, 0x33},
	{0x600e, CRL_REG_LEN_08BIT, 0xcc},
	{0x600f, CRL_REG_LEN_08BIT, 0xe2},
	{0x6010, CRL_REG_LEN_08BIT, 0xc1},
	{0x6011, CRL_REG_LEN_08BIT, 0xab},
	{0x6012, CRL_REG_LEN_08BIT, 0xb7},
	{0x6013, CRL_REG_LEN_08BIT, 0x00},
	{0x6014, CRL_REG_LEN_08BIT, 0x00},
	{0x6015, CRL_REG_LEN_08BIT, 0x00},
	{0x6016, CRL_REG_LEN_08BIT, 0x00},
	{0x6017, CRL_REG_LEN_08BIT, 0x00},
	{0x6018, CRL_REG_LEN_08BIT, 0x00},
	{0x6019, CRL_REG_LEN_08BIT, 0x00},
	{0x601a, CRL_REG_LEN_08BIT, 0x00},
	{0x601b, CRL_REG_LEN_08BIT, 0x00},
	{0x601c, CRL_REG_LEN_08BIT, 0x00},
	{0x601d, CRL_REG_LEN_08BIT, 0x00},
	{0x601e, CRL_REG_LEN_08BIT, 0x9c},
	{0x601f, CRL_REG_LEN_08BIT, 0x94},
	{0x6020, CRL_REG_LEN_08BIT, 0x90},
	{0x6021, CRL_REG_LEN_08BIT, 0xc5},
	{0x6022, CRL_REG_LEN_08BIT, 0x01},
	{0x6023, CRL_REG_LEN_08BIT, 0x54},
	{0x6024, CRL_REG_LEN_08BIT, 0x2a},
	{0x6025, CRL_REG_LEN_08BIT, 0x61},
	{0x6026, CRL_REG_LEN_08BIT, 0xd2},
	{0x6027, CRL_REG_LEN_08BIT, 0xcc},
	{0x6028, CRL_REG_LEN_08BIT, 0x04},
	{0x6029, CRL_REG_LEN_08BIT, 0x35},
	{0x602a, CRL_REG_LEN_08BIT, 0xb1},
	{0x602b, CRL_REG_LEN_08BIT, 0xb2},
	{0x602c, CRL_REG_LEN_08BIT, 0xb3},
	{0x602d, CRL_REG_LEN_08BIT, 0xd2},
	{0x602e, CRL_REG_LEN_08BIT, 0xd3},
	{0x602f, CRL_REG_LEN_08BIT, 0x12},
	{0x6030, CRL_REG_LEN_08BIT, 0x31},
	{0x6031, CRL_REG_LEN_08BIT, 0xcc},
	{0x6032, CRL_REG_LEN_08BIT, 0x06},
	{0x6033, CRL_REG_LEN_08BIT, 0xd2},
	{0x6034, CRL_REG_LEN_08BIT, 0xc4},
	{0x6035, CRL_REG_LEN_08BIT, 0xce},
	{0x6036, CRL_REG_LEN_08BIT, 0x18},
	{0x6037, CRL_REG_LEN_08BIT, 0xcf},
	{0x6038, CRL_REG_LEN_08BIT, 0x1e},
	{0x6039, CRL_REG_LEN_08BIT, 0xd0},
	{0x603a, CRL_REG_LEN_08BIT, 0x24},
	{0x603b, CRL_REG_LEN_08BIT, 0xc5},
	{0x603c, CRL_REG_LEN_08BIT, 0xd2},
	{0x603d, CRL_REG_LEN_08BIT, 0xbc},
	{0x603e, CRL_REG_LEN_08BIT, 0xcc},
	{0x603f, CRL_REG_LEN_08BIT, 0x52},
	{0x6040, CRL_REG_LEN_08BIT, 0x2b},
	{0x6041, CRL_REG_LEN_08BIT, 0xd2},
	{0x6042, CRL_REG_LEN_08BIT, 0xd3},
	{0x6043, CRL_REG_LEN_08BIT, 0x02},
	{0x6044, CRL_REG_LEN_08BIT, 0xcc},
	{0x6045, CRL_REG_LEN_08BIT, 0x0a},
	{0x6046, CRL_REG_LEN_08BIT, 0xd2},
	{0x6047, CRL_REG_LEN_08BIT, 0xd3},
	{0x6048, CRL_REG_LEN_08BIT, 0x0f},
	{0x6049, CRL_REG_LEN_08BIT, 0x1a},
	{0x604a, CRL_REG_LEN_08BIT, 0x2a},
	{0x604b, CRL_REG_LEN_08BIT, 0xd4},
	{0x604c, CRL_REG_LEN_08BIT, 0xf6},
	{0x604d, CRL_REG_LEN_08BIT, 0xba},
	{0x604e, CRL_REG_LEN_08BIT, 0x56},
	{0x604f, CRL_REG_LEN_08BIT, 0xd3},
	{0x6050, CRL_REG_LEN_08BIT, 0x2e},
	{0x6051, CRL_REG_LEN_08BIT, 0x54},
	{0x6052, CRL_REG_LEN_08BIT, 0x26},
	{0x6053, CRL_REG_LEN_08BIT, 0xd2},
	{0x6054, CRL_REG_LEN_08BIT, 0xcc},
	{0x6055, CRL_REG_LEN_08BIT, 0x60},
	{0x6056, CRL_REG_LEN_08BIT, 0xd2},
	{0x6057, CRL_REG_LEN_08BIT, 0xd3},
	{0x6058, CRL_REG_LEN_08BIT, 0x27},
	{0x6059, CRL_REG_LEN_08BIT, 0x27},
	{0x605a, CRL_REG_LEN_08BIT, 0x08},
	{0x605b, CRL_REG_LEN_08BIT, 0x1a},
	{0x605c, CRL_REG_LEN_08BIT, 0xcc},
	{0x605d, CRL_REG_LEN_08BIT, 0x88},
	{0x605e, CRL_REG_LEN_08BIT, 0x00},
	{0x605f, CRL_REG_LEN_08BIT, 0x12},
	{0x6060, CRL_REG_LEN_08BIT, 0x2c},
	{0x6061, CRL_REG_LEN_08BIT, 0x60},
	{0x6062, CRL_REG_LEN_08BIT, 0xc2},
	{0x6063, CRL_REG_LEN_08BIT, 0xb9},
	{0x6064, CRL_REG_LEN_08BIT, 0xa5},
	{0x6065, CRL_REG_LEN_08BIT, 0xb5},
	{0x6066, CRL_REG_LEN_08BIT, 0xa0},
	{0x6067, CRL_REG_LEN_08BIT, 0x82},
	{0x6068, CRL_REG_LEN_08BIT, 0x5c},
	{0x6069, CRL_REG_LEN_08BIT, 0xd4},
	{0x606a, CRL_REG_LEN_08BIT, 0xbe},
	{0x606b, CRL_REG_LEN_08BIT, 0xd4},
	{0x606c, CRL_REG_LEN_08BIT, 0xbe},
	{0x606d, CRL_REG_LEN_08BIT, 0xd3},
	{0x606e, CRL_REG_LEN_08BIT, 0x01},
	{0x606f, CRL_REG_LEN_08BIT, 0x7c},
	{0x6070, CRL_REG_LEN_08BIT, 0x74},
	{0x6071, CRL_REG_LEN_08BIT, 0x00},
	{0x6072, CRL_REG_LEN_08BIT, 0x61},
	{0x6073, CRL_REG_LEN_08BIT, 0x2a},
	{0x6074, CRL_REG_LEN_08BIT, 0xd2},
	{0x6075, CRL_REG_LEN_08BIT, 0xcc},
	{0x6076, CRL_REG_LEN_08BIT, 0xdf},
	{0x6077, CRL_REG_LEN_08BIT, 0xc6},
	{0x6078, CRL_REG_LEN_08BIT, 0x35},
	{0x6079, CRL_REG_LEN_08BIT, 0xd2},
	{0x607a, CRL_REG_LEN_08BIT, 0xcc},
	{0x607b, CRL_REG_LEN_08BIT, 0x06},
	{0x607c, CRL_REG_LEN_08BIT, 0x31},
	{0x607d, CRL_REG_LEN_08BIT, 0xd2},
	{0x607e, CRL_REG_LEN_08BIT, 0xc5},
	{0x607f, CRL_REG_LEN_08BIT, 0xbb},
	{0x6080, CRL_REG_LEN_08BIT, 0xcc},
	{0x6081, CRL_REG_LEN_08BIT, 0x18},
	{0x6082, CRL_REG_LEN_08BIT, 0xc6},
	{0x6083, CRL_REG_LEN_08BIT, 0xd2},
	{0x6084, CRL_REG_LEN_08BIT, 0xbd},
	{0x6085, CRL_REG_LEN_08BIT, 0xcc},
	{0x6086, CRL_REG_LEN_08BIT, 0x52},
	{0x6087, CRL_REG_LEN_08BIT, 0x2b},
	{0x6088, CRL_REG_LEN_08BIT, 0xd2},
	{0x6089, CRL_REG_LEN_08BIT, 0xd3},
	{0x608a, CRL_REG_LEN_08BIT, 0x01},
	{0x608b, CRL_REG_LEN_08BIT, 0xcc},
	{0x608c, CRL_REG_LEN_08BIT, 0x0a},
	{0x608d, CRL_REG_LEN_08BIT, 0xd2},
	{0x608e, CRL_REG_LEN_08BIT, 0xd3},
	{0x608f, CRL_REG_LEN_08BIT, 0x0f},
	{0x6090, CRL_REG_LEN_08BIT, 0x1a},
	{0x6091, CRL_REG_LEN_08BIT, 0x71},
	{0x6092, CRL_REG_LEN_08BIT, 0x2a},
	{0x6093, CRL_REG_LEN_08BIT, 0xd4},
	{0x6094, CRL_REG_LEN_08BIT, 0xf6},
	{0x6095, CRL_REG_LEN_08BIT, 0xd3},
	{0x6096, CRL_REG_LEN_08BIT, 0x22},
	{0x6097, CRL_REG_LEN_08BIT, 0x70},
	{0x6098, CRL_REG_LEN_08BIT, 0xca},
	{0x6099, CRL_REG_LEN_08BIT, 0x26},
	{0x609a, CRL_REG_LEN_08BIT, 0xd2},
	{0x609b, CRL_REG_LEN_08BIT, 0xcc},
	{0x609c, CRL_REG_LEN_08BIT, 0x60},
	{0x609d, CRL_REG_LEN_08BIT, 0xd2},
	{0x609e, CRL_REG_LEN_08BIT, 0xd3},
	{0x609f, CRL_REG_LEN_08BIT, 0x27},
	{0x60a0, CRL_REG_LEN_08BIT, 0x27},
	{0x60a1, CRL_REG_LEN_08BIT, 0x08},
	{0x60a2, CRL_REG_LEN_08BIT, 0x1a},
	{0x60a3, CRL_REG_LEN_08BIT, 0xcc},
	{0x60a4, CRL_REG_LEN_08BIT, 0x88},
	{0x60a5, CRL_REG_LEN_08BIT, 0x12},
	{0x60a6, CRL_REG_LEN_08BIT, 0x2c},
	{0x60a7, CRL_REG_LEN_08BIT, 0x60},
	{0x60a8, CRL_REG_LEN_08BIT, 0x00},
	{0x60a9, CRL_REG_LEN_08BIT, 0x00},
	{0x60aa, CRL_REG_LEN_08BIT, 0xc0},
	{0x60ab, CRL_REG_LEN_08BIT, 0xb9},
	{0x60ac, CRL_REG_LEN_08BIT, 0xa3},
	{0x60ad, CRL_REG_LEN_08BIT, 0xb5},
	{0x60ae, CRL_REG_LEN_08BIT, 0x00},
	{0x60af, CRL_REG_LEN_08BIT, 0xa0},
	{0x60b0, CRL_REG_LEN_08BIT, 0x82},
	{0x60b1, CRL_REG_LEN_08BIT, 0x5c},
	{0x60b2, CRL_REG_LEN_08BIT, 0xd4},
	{0x60b3, CRL_REG_LEN_08BIT, 0xa0},
	{0x60b4, CRL_REG_LEN_08BIT, 0x9d},
	{0x60b5, CRL_REG_LEN_08BIT, 0xd3},
	{0x60b6, CRL_REG_LEN_08BIT, 0x26},
	{0x60b7, CRL_REG_LEN_08BIT, 0xb0},
	{0x60b8, CRL_REG_LEN_08BIT, 0xb7},
	{0x60b9, CRL_REG_LEN_08BIT, 0x00},
	{0x60ba, CRL_REG_LEN_08BIT, 0xd3},
	{0x60bb, CRL_REG_LEN_08BIT, 0x0a},
	{0x60bc, CRL_REG_LEN_08BIT, 0xd3},
	{0x60bd, CRL_REG_LEN_08BIT, 0x10},
	{0x60be, CRL_REG_LEN_08BIT, 0x9c},
	{0x60bf, CRL_REG_LEN_08BIT, 0x94},
	{0x60c0, CRL_REG_LEN_08BIT, 0x90},
	{0x60c1, CRL_REG_LEN_08BIT, 0xc8},
	{0x60c2, CRL_REG_LEN_08BIT, 0xba},
	{0x60c3, CRL_REG_LEN_08BIT, 0x7c},
	{0x60c4, CRL_REG_LEN_08BIT, 0x74},
	{0x60c5, CRL_REG_LEN_08BIT, 0x00},
	{0x60c6, CRL_REG_LEN_08BIT, 0x61},
	{0x60c7, CRL_REG_LEN_08BIT, 0x2a},
	{0x60c8, CRL_REG_LEN_08BIT, 0x00},
	{0x60c9, CRL_REG_LEN_08BIT, 0xd2},
	{0x60ca, CRL_REG_LEN_08BIT, 0xcc},
	{0x60cb, CRL_REG_LEN_08BIT, 0xdf},
	{0x60cc, CRL_REG_LEN_08BIT, 0xc4},
	{0x60cd, CRL_REG_LEN_08BIT, 0x35},
	{0x60ce, CRL_REG_LEN_08BIT, 0xd2},
	{0x60cf, CRL_REG_LEN_08BIT, 0xcc},
	{0x60d0, CRL_REG_LEN_08BIT, 0x06},
	{0x60d1, CRL_REG_LEN_08BIT, 0x31},
	{0x60d2, CRL_REG_LEN_08BIT, 0xd2},
	{0x60d3, CRL_REG_LEN_08BIT, 0xcc},
	{0x60d4, CRL_REG_LEN_08BIT, 0x15},
	{0x60d5, CRL_REG_LEN_08BIT, 0xd2},
	{0x60d6, CRL_REG_LEN_08BIT, 0xbb},
	{0x60d7, CRL_REG_LEN_08BIT, 0xcc},
	{0x60d8, CRL_REG_LEN_08BIT, 0x1a},
	{0x60d9, CRL_REG_LEN_08BIT, 0xd2},
	{0x60da, CRL_REG_LEN_08BIT, 0xbe},
	{0x60db, CRL_REG_LEN_08BIT, 0xce},
	{0x60dc, CRL_REG_LEN_08BIT, 0x52},
	{0x60dd, CRL_REG_LEN_08BIT, 0xcf},
	{0x60de, CRL_REG_LEN_08BIT, 0x56},
	{0x60df, CRL_REG_LEN_08BIT, 0xd0},
	{0x60e0, CRL_REG_LEN_08BIT, 0x5b},
	{0x60e1, CRL_REG_LEN_08BIT, 0x2b},
	{0x60e2, CRL_REG_LEN_08BIT, 0xd2},
	{0x60e3, CRL_REG_LEN_08BIT, 0xd3},
	{0x60e4, CRL_REG_LEN_08BIT, 0x01},
	{0x60e5, CRL_REG_LEN_08BIT, 0xcc},
	{0x60e6, CRL_REG_LEN_08BIT, 0x0a},
	{0x60e7, CRL_REG_LEN_08BIT, 0xd2},
	{0x60e8, CRL_REG_LEN_08BIT, 0xd3},
	{0x60e9, CRL_REG_LEN_08BIT, 0x0f},
	{0x60ea, CRL_REG_LEN_08BIT, 0xd9},
	{0x60eb, CRL_REG_LEN_08BIT, 0xc7},
	{0x60ec, CRL_REG_LEN_08BIT, 0xda},
	{0x60ed, CRL_REG_LEN_08BIT, 0xce},
	{0x60ee, CRL_REG_LEN_08BIT, 0x1a},
	{0x60ef, CRL_REG_LEN_08BIT, 0xd4},
	{0x60f0, CRL_REG_LEN_08BIT, 0xf6},
	{0x60f1, CRL_REG_LEN_08BIT, 0xd4},
	{0x60f2, CRL_REG_LEN_08BIT, 0xa9},
	{0x60f3, CRL_REG_LEN_08BIT, 0x27},
	{0x60f4, CRL_REG_LEN_08BIT, 0x00},
	{0x60f5, CRL_REG_LEN_08BIT, 0xd2},
	{0x60f6, CRL_REG_LEN_08BIT, 0xcc},
	{0x60f7, CRL_REG_LEN_08BIT, 0x60},
	{0x60f8, CRL_REG_LEN_08BIT, 0xd2},
	{0x60f9, CRL_REG_LEN_08BIT, 0xd3},
	{0x60fa, CRL_REG_LEN_08BIT, 0x2d},
	{0x60fb, CRL_REG_LEN_08BIT, 0xd9},
	{0x60fc, CRL_REG_LEN_08BIT, 0xdf},
	{0x60fd, CRL_REG_LEN_08BIT, 0xda},
	{0x60fe, CRL_REG_LEN_08BIT, 0xe5},
	{0x60ff, CRL_REG_LEN_08BIT, 0x1a},
	{0x6100, CRL_REG_LEN_08BIT, 0x12},
	{0x6101, CRL_REG_LEN_08BIT, 0xcc},
	{0x6102, CRL_REG_LEN_08BIT, 0x88},
	{0x6103, CRL_REG_LEN_08BIT, 0xd6},
	{0x6104, CRL_REG_LEN_08BIT, 0xb1},
	{0x6105, CRL_REG_LEN_08BIT, 0xb9},
	{0x6106, CRL_REG_LEN_08BIT, 0xba},
	{0x6107, CRL_REG_LEN_08BIT, 0xaf},
	{0x6108, CRL_REG_LEN_08BIT, 0xdc},
	{0x6109, CRL_REG_LEN_08BIT, 0x00},
	{0x610a, CRL_REG_LEN_08BIT, 0xcb},
	{0x610b, CRL_REG_LEN_08BIT, 0xc3},
	{0x610c, CRL_REG_LEN_08BIT, 0xb9},
	{0x610d, CRL_REG_LEN_08BIT, 0xa4},
	{0x610e, CRL_REG_LEN_08BIT, 0xb5},
	{0x610f, CRL_REG_LEN_08BIT, 0x5c},
	{0x6110, CRL_REG_LEN_08BIT, 0x12},
	{0x6111, CRL_REG_LEN_08BIT, 0x2a},
	{0x6112, CRL_REG_LEN_08BIT, 0x61},
	{0x6113, CRL_REG_LEN_08BIT, 0xd2},
	{0x6114, CRL_REG_LEN_08BIT, 0xcc},
	{0x6115, CRL_REG_LEN_08BIT, 0xdf},
	{0x6116, CRL_REG_LEN_08BIT, 0xc7},
	{0x6117, CRL_REG_LEN_08BIT, 0x35},
	{0x6118, CRL_REG_LEN_08BIT, 0xd2},
	{0x6119, CRL_REG_LEN_08BIT, 0xcc},
	{0x611a, CRL_REG_LEN_08BIT, 0x06},
	{0x611b, CRL_REG_LEN_08BIT, 0x31},
	{0x611c, CRL_REG_LEN_08BIT, 0xc6},
	{0x611d, CRL_REG_LEN_08BIT, 0xbb},
	{0x611e, CRL_REG_LEN_08BIT, 0xd2},
	{0x611f, CRL_REG_LEN_08BIT, 0xcc},
	{0x6120, CRL_REG_LEN_08BIT, 0x18},
	{0x6121, CRL_REG_LEN_08BIT, 0xd2},
	{0x6122, CRL_REG_LEN_08BIT, 0xbe},
	{0x6123, CRL_REG_LEN_08BIT, 0xcc},
	{0x6124, CRL_REG_LEN_08BIT, 0x52},
	{0x6125, CRL_REG_LEN_08BIT, 0xc7},
	{0x6126, CRL_REG_LEN_08BIT, 0xd2},
	{0x6127, CRL_REG_LEN_08BIT, 0xcc},
	{0x6128, CRL_REG_LEN_08BIT, 0x0a},
	{0x6129, CRL_REG_LEN_08BIT, 0xb4},
	{0x612a, CRL_REG_LEN_08BIT, 0xb7},
	{0x612b, CRL_REG_LEN_08BIT, 0x94},
	{0x612c, CRL_REG_LEN_08BIT, 0xd2},
	{0x612d, CRL_REG_LEN_08BIT, 0x12},
	{0x612e, CRL_REG_LEN_08BIT, 0x26},
	{0x612f, CRL_REG_LEN_08BIT, 0x42},
	{0x6130, CRL_REG_LEN_08BIT, 0x46},
	{0x6131, CRL_REG_LEN_08BIT, 0x42},
	{0x6132, CRL_REG_LEN_08BIT, 0xd3},
	{0x6133, CRL_REG_LEN_08BIT, 0x20},
	{0x6134, CRL_REG_LEN_08BIT, 0x27},
	{0x6135, CRL_REG_LEN_08BIT, 0x00},
	{0x6136, CRL_REG_LEN_08BIT, 0x1a},
	{0x6137, CRL_REG_LEN_08BIT, 0xcc},
	{0x6138, CRL_REG_LEN_08BIT, 0x88},
	{0x6139, CRL_REG_LEN_08BIT, 0x60},
	{0x613a, CRL_REG_LEN_08BIT, 0x2c},
	{0x613b, CRL_REG_LEN_08BIT, 0x12},
	{0x613c, CRL_REG_LEN_08BIT, 0x40},
	{0x613d, CRL_REG_LEN_08BIT, 0xb8},
	{0x613e, CRL_REG_LEN_08BIT, 0x90},
	{0x613f, CRL_REG_LEN_08BIT, 0xd5},
	{0x6140, CRL_REG_LEN_08BIT, 0xba},
	{0x6141, CRL_REG_LEN_08BIT, 0x00},
	{0x6142, CRL_REG_LEN_08BIT, 0x00},
	{0x6143, CRL_REG_LEN_08BIT, 0x00},
	{0x6144, CRL_REG_LEN_08BIT, 0x00},
	{0x6145, CRL_REG_LEN_08BIT, 0x00},
	{0x6146, CRL_REG_LEN_08BIT, 0x00},
	{0x6147, CRL_REG_LEN_08BIT, 0xaa},
	{0x6148, CRL_REG_LEN_08BIT, 0xb7},
	{0x6149, CRL_REG_LEN_08BIT, 0x00},
	{0x614a, CRL_REG_LEN_08BIT, 0x00},
	{0x614b, CRL_REG_LEN_08BIT, 0x00},
	{0x614c, CRL_REG_LEN_08BIT, 0x00},
	{0x614d, CRL_REG_LEN_08BIT, 0xa6},
	{0x614e, CRL_REG_LEN_08BIT, 0xb7},
	{0x614f, CRL_REG_LEN_08BIT, 0x00},
	{0x6150, CRL_REG_LEN_08BIT, 0xd5},
	{0x6151, CRL_REG_LEN_08BIT, 0x00},
	{0x6152, CRL_REG_LEN_08BIT, 0x71},
	{0x6153, CRL_REG_LEN_08BIT, 0xd3},
	{0x6154, CRL_REG_LEN_08BIT, 0x30},
	{0x6155, CRL_REG_LEN_08BIT, 0xba},
	{0x6156, CRL_REG_LEN_08BIT, 0x00},
	{0x6157, CRL_REG_LEN_08BIT, 0x00},
	{0x6158, CRL_REG_LEN_08BIT, 0x00},
	{0x6159, CRL_REG_LEN_08BIT, 0x00},
	{0x615a, CRL_REG_LEN_08BIT, 0xd3},
	{0x615b, CRL_REG_LEN_08BIT, 0x10},
	{0x615c, CRL_REG_LEN_08BIT, 0x70},
	{0x615d, CRL_REG_LEN_08BIT, 0x00},
	{0x615e, CRL_REG_LEN_08BIT, 0x00},
	{0x615f, CRL_REG_LEN_08BIT, 0x00},
	{0x6160, CRL_REG_LEN_08BIT, 0x00},
	{0x6161, CRL_REG_LEN_08BIT, 0xd5},
	{0x6162, CRL_REG_LEN_08BIT, 0xba},
	{0x6163, CRL_REG_LEN_08BIT, 0xb0},
	{0x6164, CRL_REG_LEN_08BIT, 0xb7},
	{0x6165, CRL_REG_LEN_08BIT, 0x00},
	{0x6166, CRL_REG_LEN_08BIT, 0x9d},
	{0x6167, CRL_REG_LEN_08BIT, 0xd3},
	{0x6168, CRL_REG_LEN_08BIT, 0x0a},
	{0x6169, CRL_REG_LEN_08BIT, 0x9d},
	{0x616a, CRL_REG_LEN_08BIT, 0x9d},
	{0x616b, CRL_REG_LEN_08BIT, 0xd3},
	{0x616c, CRL_REG_LEN_08BIT, 0x10},
	{0x616d, CRL_REG_LEN_08BIT, 0x9c},
	{0x616e, CRL_REG_LEN_08BIT, 0x94},
	{0x616f, CRL_REG_LEN_08BIT, 0x90},
	{0x6170, CRL_REG_LEN_08BIT, 0xc8},
	{0x6171, CRL_REG_LEN_08BIT, 0xba},
	{0x6172, CRL_REG_LEN_08BIT, 0xd2},
	{0x6173, CRL_REG_LEN_08BIT, 0x60},
	{0x6174, CRL_REG_LEN_08BIT, 0x2c},
	{0x6175, CRL_REG_LEN_08BIT, 0x50},
	{0x6176, CRL_REG_LEN_08BIT, 0x11},
	{0x6177, CRL_REG_LEN_08BIT, 0xcc},
	{0x6178, CRL_REG_LEN_08BIT, 0x00},
	{0x6179, CRL_REG_LEN_08BIT, 0x30},
	{0x617a, CRL_REG_LEN_08BIT, 0xd5},
	{0x617b, CRL_REG_LEN_08BIT, 0x00},
	{0x617c, CRL_REG_LEN_08BIT, 0xba},
	{0x617d, CRL_REG_LEN_08BIT, 0xb0},
	{0x617e, CRL_REG_LEN_08BIT, 0xb7},
	{0x617f, CRL_REG_LEN_08BIT, 0x00},
	{0x6180, CRL_REG_LEN_08BIT, 0x9d},
	{0x6181, CRL_REG_LEN_08BIT, 0xd3},
	{0x6182, CRL_REG_LEN_08BIT, 0x0a},
	{0x6183, CRL_REG_LEN_08BIT, 0x9d},
	{0x6184, CRL_REG_LEN_08BIT, 0x9d},
	{0x6185, CRL_REG_LEN_08BIT, 0xd3},
	{0x6186, CRL_REG_LEN_08BIT, 0x10},
	{0x6187, CRL_REG_LEN_08BIT, 0x9c},
	{0x6188, CRL_REG_LEN_08BIT, 0x94},
	{0x6189, CRL_REG_LEN_08BIT, 0x90},
	{0x618a, CRL_REG_LEN_08BIT, 0xc8},
	{0x618b, CRL_REG_LEN_08BIT, 0xba},
	{0x618c, CRL_REG_LEN_08BIT, 0xd5},
	{0x618d, CRL_REG_LEN_08BIT, 0x00},
	{0x618e, CRL_REG_LEN_08BIT, 0x01},
	{0x618f, CRL_REG_LEN_08BIT, 0x1a},
	{0x6190, CRL_REG_LEN_08BIT, 0xcc},
	{0x6191, CRL_REG_LEN_08BIT, 0x12},
	{0x6192, CRL_REG_LEN_08BIT, 0x12},
	{0x6193, CRL_REG_LEN_08BIT, 0x00},
	{0x6194, CRL_REG_LEN_08BIT, 0xcc},
	{0x6195, CRL_REG_LEN_08BIT, 0x9c},
	{0x6196, CRL_REG_LEN_08BIT, 0xd2},
	{0x6197, CRL_REG_LEN_08BIT, 0xcc},
	{0x6198, CRL_REG_LEN_08BIT, 0x60},
	{0x6199, CRL_REG_LEN_08BIT, 0xd2},
	{0x619a, CRL_REG_LEN_08BIT, 0x04},
	{0x619b, CRL_REG_LEN_08BIT, 0xd5},
	{0x619c, CRL_REG_LEN_08BIT, 0x1a},
	{0x619d, CRL_REG_LEN_08BIT, 0xcc},
	{0x619e, CRL_REG_LEN_08BIT, 0x12},
	{0x619f, CRL_REG_LEN_08BIT, 0x00},
	{0x61a0, CRL_REG_LEN_08BIT, 0x12},
	{0x61a1, CRL_REG_LEN_08BIT, 0xcc},
	{0x61a2, CRL_REG_LEN_08BIT, 0x9c},
	{0x61a3, CRL_REG_LEN_08BIT, 0xd2},
	{0x61a4, CRL_REG_LEN_08BIT, 0xcc},
	{0x61a5, CRL_REG_LEN_08BIT, 0x60},
	{0x61a6, CRL_REG_LEN_08BIT, 0xd2},
	{0x61a7, CRL_REG_LEN_08BIT, 0x1a},
	{0x61a8, CRL_REG_LEN_08BIT, 0xcc},
	{0x61a9, CRL_REG_LEN_08BIT, 0x12},
	{0x61aa, CRL_REG_LEN_08BIT, 0x00},
	{0x61ab, CRL_REG_LEN_08BIT, 0x12},
	{0x61ac, CRL_REG_LEN_08BIT, 0xcc},
	{0x61ad, CRL_REG_LEN_08BIT, 0x9c},
	{0x61ae, CRL_REG_LEN_08BIT, 0xd2},
	{0x61af, CRL_REG_LEN_08BIT, 0xcc},
	{0x61b0, CRL_REG_LEN_08BIT, 0x60},
	{0x61b1, CRL_REG_LEN_08BIT, 0xd2},
	{0x61b2, CRL_REG_LEN_08BIT, 0x1a},
	{0x61b3, CRL_REG_LEN_08BIT, 0xcc},
	{0x61b4, CRL_REG_LEN_08BIT, 0x12},
	{0x61b5, CRL_REG_LEN_08BIT, 0x00},
	{0x61b6, CRL_REG_LEN_08BIT, 0x12},
	{0x61b7, CRL_REG_LEN_08BIT, 0xcc},
	{0x61b8, CRL_REG_LEN_08BIT, 0x9c},
	{0x61b9, CRL_REG_LEN_08BIT, 0xd2},
	{0x61ba, CRL_REG_LEN_08BIT, 0xcc},
	{0x61bb, CRL_REG_LEN_08BIT, 0x60},
	{0x61bc, CRL_REG_LEN_08BIT, 0xd2},
	{0x61bd, CRL_REG_LEN_08BIT, 0xd5},
	{0x61be, CRL_REG_LEN_08BIT, 0x1a},
	{0x61bf, CRL_REG_LEN_08BIT, 0xcc},
	{0x61c0, CRL_REG_LEN_08BIT, 0x12},
	{0x61c1, CRL_REG_LEN_08BIT, 0x12},
	{0x61c2, CRL_REG_LEN_08BIT, 0x00},
	{0x61c3, CRL_REG_LEN_08BIT, 0xcc},
	{0x61c4, CRL_REG_LEN_08BIT, 0x8a},
	{0x61c5, CRL_REG_LEN_08BIT, 0xd2},
	{0x61c6, CRL_REG_LEN_08BIT, 0xcc},
	{0x61c7, CRL_REG_LEN_08BIT, 0x74},
	{0x61c8, CRL_REG_LEN_08BIT, 0xd2},
	{0x61c9, CRL_REG_LEN_08BIT, 0xd5},
	{0x61ca, CRL_REG_LEN_08BIT, 0x1a},
	{0x61cb, CRL_REG_LEN_08BIT, 0xcc},
	{0x61cc, CRL_REG_LEN_08BIT, 0x12},
	{0x61cd, CRL_REG_LEN_08BIT, 0x00},
	{0x61ce, CRL_REG_LEN_08BIT, 0x12},
	{0x61cf, CRL_REG_LEN_08BIT, 0xcc},
	{0x61d0, CRL_REG_LEN_08BIT, 0x8a},
	{0x61d1, CRL_REG_LEN_08BIT, 0xd2},
	{0x61d2, CRL_REG_LEN_08BIT, 0xcc},
	{0x61d3, CRL_REG_LEN_08BIT, 0x74},
	{0x61d4, CRL_REG_LEN_08BIT, 0xd2},
	{0x61d5, CRL_REG_LEN_08BIT, 0x1a},
	{0x61d6, CRL_REG_LEN_08BIT, 0xcc},
	{0x61d7, CRL_REG_LEN_08BIT, 0x12},
	{0x61d8, CRL_REG_LEN_08BIT, 0x00},
	{0x61d9, CRL_REG_LEN_08BIT, 0x12},
	{0x61da, CRL_REG_LEN_08BIT, 0xcc},
	{0x61db, CRL_REG_LEN_08BIT, 0x8a},
	{0x61dc, CRL_REG_LEN_08BIT, 0xd2},
	{0x61dd, CRL_REG_LEN_08BIT, 0xcc},
	{0x61de, CRL_REG_LEN_08BIT, 0x74},
	{0x61df, CRL_REG_LEN_08BIT, 0xd2},
	{0x61e0, CRL_REG_LEN_08BIT, 0x1a},
	{0x61e1, CRL_REG_LEN_08BIT, 0xcc},
	{0x61e2, CRL_REG_LEN_08BIT, 0x12},
	{0x61e3, CRL_REG_LEN_08BIT, 0x00},
	{0x61e4, CRL_REG_LEN_08BIT, 0x12},
	{0x61e5, CRL_REG_LEN_08BIT, 0xcc},
	{0x61e6, CRL_REG_LEN_08BIT, 0x8a},
	{0x61e7, CRL_REG_LEN_08BIT, 0xd2},
	{0x61e8, CRL_REG_LEN_08BIT, 0xcc},
	{0x61e9, CRL_REG_LEN_08BIT, 0x74},
	{0x61ea, CRL_REG_LEN_08BIT, 0xd2},
	{0x61eb, CRL_REG_LEN_08BIT, 0xd5},
	{0x61ec, CRL_REG_LEN_08BIT, 0xcc},
	{0x61ed, CRL_REG_LEN_08BIT, 0x12},
	{0x61ee, CRL_REG_LEN_08BIT, 0x00},
	{0x61ef, CRL_REG_LEN_08BIT, 0x12},
	{0x61f0, CRL_REG_LEN_08BIT, 0xcc},
	{0x61f1, CRL_REG_LEN_08BIT, 0x9c},
	{0x61f2, CRL_REG_LEN_08BIT, 0xd5},
	{0x6400, CRL_REG_LEN_08BIT, 0x04},
	{0x6401, CRL_REG_LEN_08BIT, 0x04},
	{0x6402, CRL_REG_LEN_08BIT, 0x00},
	{0x6403, CRL_REG_LEN_08BIT, 0xff},
	{0x6404, CRL_REG_LEN_08BIT, 0x00},
	{0x6405, CRL_REG_LEN_08BIT, 0x08},
	{0x6406, CRL_REG_LEN_08BIT, 0x00},
	{0x6407, CRL_REG_LEN_08BIT, 0xff},
	{0x6408, CRL_REG_LEN_08BIT, 0x04},
	{0x6409, CRL_REG_LEN_08BIT, 0x70},
	{0x640a, CRL_REG_LEN_08BIT, 0x00},
	{0x640b, CRL_REG_LEN_08BIT, 0xff},
	{0x640c, CRL_REG_LEN_08BIT, 0x05},
	{0x640d, CRL_REG_LEN_08BIT, 0x14},
	{0x640e, CRL_REG_LEN_08BIT, 0x04},
	{0x640f, CRL_REG_LEN_08BIT, 0x71},
	{0x6410, CRL_REG_LEN_08BIT, 0x05},
	{0x6411, CRL_REG_LEN_08BIT, 0x74},
	{0x6412, CRL_REG_LEN_08BIT, 0x00},
	{0x6413, CRL_REG_LEN_08BIT, 0xff},
	{0x6414, CRL_REG_LEN_08BIT, 0x05},
	{0x6415, CRL_REG_LEN_08BIT, 0x54},
	{0x6416, CRL_REG_LEN_08BIT, 0x05},
	{0x6417, CRL_REG_LEN_08BIT, 0x44},
	{0x6418, CRL_REG_LEN_08BIT, 0x04},
	{0x6419, CRL_REG_LEN_08BIT, 0x30},
	{0x641a, CRL_REG_LEN_08BIT, 0x05},
	{0x641b, CRL_REG_LEN_08BIT, 0x46},
	{0x641c, CRL_REG_LEN_08BIT, 0x00},
	{0x641d, CRL_REG_LEN_08BIT, 0xff},
	{0x641e, CRL_REG_LEN_08BIT, 0x04},
	{0x641f, CRL_REG_LEN_08BIT, 0x31},
	{0x6420, CRL_REG_LEN_08BIT, 0x04},
	{0x6421, CRL_REG_LEN_08BIT, 0x30},
	{0x6422, CRL_REG_LEN_08BIT, 0x00},
	{0x6423, CRL_REG_LEN_08BIT, 0xff},
	{0x6424, CRL_REG_LEN_08BIT, 0x04},
	{0x6425, CRL_REG_LEN_08BIT, 0x20},
	{0x6426, CRL_REG_LEN_08BIT, 0x05},
	{0x6427, CRL_REG_LEN_08BIT, 0x06},
	{0x6428, CRL_REG_LEN_08BIT, 0x00},
	{0x6429, CRL_REG_LEN_08BIT, 0xff},
	{0x642a, CRL_REG_LEN_08BIT, 0x08},
	{0x642b, CRL_REG_LEN_08BIT, 0x2a},
	{0x642c, CRL_REG_LEN_08BIT, 0x08},
	{0x642d, CRL_REG_LEN_08BIT, 0x31},
	{0x642e, CRL_REG_LEN_08BIT, 0x00},
	{0x642f, CRL_REG_LEN_08BIT, 0xff},
	{0x6430, CRL_REG_LEN_08BIT, 0x08},
	{0x6431, CRL_REG_LEN_08BIT, 0x2a},
	{0x6432, CRL_REG_LEN_08BIT, 0x08},
	{0x6433, CRL_REG_LEN_08BIT, 0x31},
	{0x6434, CRL_REG_LEN_08BIT, 0x06},
	{0x6435, CRL_REG_LEN_08BIT, 0x20},
	{0x6436, CRL_REG_LEN_08BIT, 0x07},
	{0x6437, CRL_REG_LEN_08BIT, 0x00},
	{0x6438, CRL_REG_LEN_08BIT, 0x08},
	{0x6439, CRL_REG_LEN_08BIT, 0x40},
	{0x643a, CRL_REG_LEN_08BIT, 0x00},
	{0x643b, CRL_REG_LEN_08BIT, 0xff},
	{0x643c, CRL_REG_LEN_08BIT, 0x08},
	{0x643d, CRL_REG_LEN_08BIT, 0x2a},
	{0x643e, CRL_REG_LEN_08BIT, 0x08},
	{0x643f, CRL_REG_LEN_08BIT, 0x36},
	{0x6440, CRL_REG_LEN_08BIT, 0x06},
	{0x6441, CRL_REG_LEN_08BIT, 0x10},
	{0x6442, CRL_REG_LEN_08BIT, 0x07},
	{0x6443, CRL_REG_LEN_08BIT, 0x00},
	{0x6444, CRL_REG_LEN_08BIT, 0x08},
	{0x6445, CRL_REG_LEN_08BIT, 0x40},
	{0x6446, CRL_REG_LEN_08BIT, 0x00},
	{0x6447, CRL_REG_LEN_08BIT, 0xff},
	{0x6448, CRL_REG_LEN_08BIT, 0x08},
	{0x6449, CRL_REG_LEN_08BIT, 0x2a},
	{0x644a, CRL_REG_LEN_08BIT, 0x08},
	{0x644b, CRL_REG_LEN_08BIT, 0x3b},
	{0x644c, CRL_REG_LEN_08BIT, 0x06},
	{0x644d, CRL_REG_LEN_08BIT, 0x00},
	{0x644e, CRL_REG_LEN_08BIT, 0x07},
	{0x644f, CRL_REG_LEN_08BIT, 0x00},
	{0x6450, CRL_REG_LEN_08BIT, 0x08},
	{0x6451, CRL_REG_LEN_08BIT, 0x40},
	{0x6452, CRL_REG_LEN_08BIT, 0x00},
	{0x6453, CRL_REG_LEN_08BIT, 0xff},
	{0x6454, CRL_REG_LEN_08BIT, 0x06},
	{0x6455, CRL_REG_LEN_08BIT, 0x00},
	{0x6456, CRL_REG_LEN_08BIT, 0x07},
	{0x6457, CRL_REG_LEN_08BIT, 0x05},
	{0x6458, CRL_REG_LEN_08BIT, 0x01},
	{0x6459, CRL_REG_LEN_08BIT, 0xaf},
	{0x645a, CRL_REG_LEN_08BIT, 0x01},
	{0x645b, CRL_REG_LEN_08BIT, 0x0f},
	{0x645c, CRL_REG_LEN_08BIT, 0x01},
	{0x645d, CRL_REG_LEN_08BIT, 0x90},
	{0x645e, CRL_REG_LEN_08BIT, 0x01},
	{0x645f, CRL_REG_LEN_08BIT, 0xc8},
	{0x6460, CRL_REG_LEN_08BIT, 0x00},
	{0x6461, CRL_REG_LEN_08BIT, 0xff},
	{0x6462, CRL_REG_LEN_08BIT, 0x01},
	{0x6463, CRL_REG_LEN_08BIT, 0xac},
	{0x6464, CRL_REG_LEN_08BIT, 0x01},
	{0x6465, CRL_REG_LEN_08BIT, 0x0c},
	{0x6466, CRL_REG_LEN_08BIT, 0x01},
	{0x6467, CRL_REG_LEN_08BIT, 0x90},
	{0x6468, CRL_REG_LEN_08BIT, 0x01},
	{0x6469, CRL_REG_LEN_08BIT, 0xe8},
	{0x646a, CRL_REG_LEN_08BIT, 0x00},
	{0x646b, CRL_REG_LEN_08BIT, 0xff},
	{0x646c, CRL_REG_LEN_08BIT, 0x01},
	{0x646d, CRL_REG_LEN_08BIT, 0xad},
	{0x646e, CRL_REG_LEN_08BIT, 0x01},
	{0x646f, CRL_REG_LEN_08BIT, 0x0d},
	{0x6470, CRL_REG_LEN_08BIT, 0x01},
	{0x6471, CRL_REG_LEN_08BIT, 0x90},
	{0x6472, CRL_REG_LEN_08BIT, 0x01},
	{0x6473, CRL_REG_LEN_08BIT, 0xe8},
	{0x6474, CRL_REG_LEN_08BIT, 0x00},
	{0x6475, CRL_REG_LEN_08BIT, 0xff},
	{0x6476, CRL_REG_LEN_08BIT, 0x01},
	{0x6477, CRL_REG_LEN_08BIT, 0xae},
	{0x6478, CRL_REG_LEN_08BIT, 0x01},
	{0x6479, CRL_REG_LEN_08BIT, 0x0e},
	{0x647a, CRL_REG_LEN_08BIT, 0x01},
	{0x647b, CRL_REG_LEN_08BIT, 0x90},
	{0x647c, CRL_REG_LEN_08BIT, 0x01},
	{0x647d, CRL_REG_LEN_08BIT, 0xe8},
	{0x647e, CRL_REG_LEN_08BIT, 0x00},
	{0x647f, CRL_REG_LEN_08BIT, 0xff},
	{0x6480, CRL_REG_LEN_08BIT, 0x01},
	{0x6481, CRL_REG_LEN_08BIT, 0xb0},
	{0x6482, CRL_REG_LEN_08BIT, 0x01},
	{0x6483, CRL_REG_LEN_08BIT, 0xb1},
	{0x6484, CRL_REG_LEN_08BIT, 0x01},
	{0x6485, CRL_REG_LEN_08BIT, 0xb2},
	{0x6486, CRL_REG_LEN_08BIT, 0x01},
	{0x6487, CRL_REG_LEN_08BIT, 0xb3},
	{0x6488, CRL_REG_LEN_08BIT, 0x01},
	{0x6489, CRL_REG_LEN_08BIT, 0xb4},
	{0x648a, CRL_REG_LEN_08BIT, 0x01},
	{0x648b, CRL_REG_LEN_08BIT, 0xb5},
	{0x648c, CRL_REG_LEN_08BIT, 0x01},
	{0x648d, CRL_REG_LEN_08BIT, 0xb6},
	{0x648e, CRL_REG_LEN_08BIT, 0x01},
	{0x648f, CRL_REG_LEN_08BIT, 0xb7},
	{0x6490, CRL_REG_LEN_08BIT, 0x01},
	{0x6491, CRL_REG_LEN_08BIT, 0xb8},
	{0x6492, CRL_REG_LEN_08BIT, 0x01},
	{0x6493, CRL_REG_LEN_08BIT, 0xb9},
	{0x6494, CRL_REG_LEN_08BIT, 0x01},
	{0x6495, CRL_REG_LEN_08BIT, 0xba},
	{0x6496, CRL_REG_LEN_08BIT, 0x01},
	{0x6497, CRL_REG_LEN_08BIT, 0xbb},
	{0x6498, CRL_REG_LEN_08BIT, 0x01},
	{0x6499, CRL_REG_LEN_08BIT, 0xbc},
	{0x649a, CRL_REG_LEN_08BIT, 0x01},
	{0x649b, CRL_REG_LEN_08BIT, 0xbd},
	{0x649c, CRL_REG_LEN_08BIT, 0x01},
	{0x649d, CRL_REG_LEN_08BIT, 0xbe},
	{0x649e, CRL_REG_LEN_08BIT, 0x01},
	{0x649f, CRL_REG_LEN_08BIT, 0xbf},
	{0x64a0, CRL_REG_LEN_08BIT, 0x01},
	{0x64a1, CRL_REG_LEN_08BIT, 0xc0},
	{0x64a2, CRL_REG_LEN_08BIT, 0x00},
	{0x64a3, CRL_REG_LEN_08BIT, 0xff},
	{0x64a4, CRL_REG_LEN_08BIT, 0x06},
	{0x64a5, CRL_REG_LEN_08BIT, 0x00},
	{0x64a6, CRL_REG_LEN_08BIT, 0x01},
	{0x64a7, CRL_REG_LEN_08BIT, 0xf6},
	{0x64a8, CRL_REG_LEN_08BIT, 0x04},
	{0x64a9, CRL_REG_LEN_08BIT, 0x30},
	{0x64aa, CRL_REG_LEN_08BIT, 0x00},
	{0x64ab, CRL_REG_LEN_08BIT, 0xff},
	{0x64ac, CRL_REG_LEN_08BIT, 0x06},
	{0x64ad, CRL_REG_LEN_08BIT, 0x10},
	{0x64ae, CRL_REG_LEN_08BIT, 0x01},
	{0x64af, CRL_REG_LEN_08BIT, 0xf6},
	{0x64b0, CRL_REG_LEN_08BIT, 0x04},
	{0x64b1, CRL_REG_LEN_08BIT, 0x30},
	{0x64b2, CRL_REG_LEN_08BIT, 0x06},
	{0x64b3, CRL_REG_LEN_08BIT, 0x00},
	{0x64b4, CRL_REG_LEN_08BIT, 0x00},
	{0x64b5, CRL_REG_LEN_08BIT, 0xff},
	{0x64b6, CRL_REG_LEN_08BIT, 0x06},
	{0x64b7, CRL_REG_LEN_08BIT, 0x20},
	{0x64b8, CRL_REG_LEN_08BIT, 0x01},
	{0x64b9, CRL_REG_LEN_08BIT, 0xf6},
	{0x64ba, CRL_REG_LEN_08BIT, 0x04},
	{0x64bb, CRL_REG_LEN_08BIT, 0x30},
	{0x64bc, CRL_REG_LEN_08BIT, 0x06},
	{0x64bd, CRL_REG_LEN_08BIT, 0x00},
	{0x64be, CRL_REG_LEN_08BIT, 0x00},
	{0x64bf, CRL_REG_LEN_08BIT, 0xff},
	{0x64c0, CRL_REG_LEN_08BIT, 0x04},
	{0x64c1, CRL_REG_LEN_08BIT, 0x31},
	{0x64c2, CRL_REG_LEN_08BIT, 0x04},
	{0x64c3, CRL_REG_LEN_08BIT, 0x30},
	{0x64c4, CRL_REG_LEN_08BIT, 0x01},
	{0x64c5, CRL_REG_LEN_08BIT, 0x20},
	{0x64c6, CRL_REG_LEN_08BIT, 0x01},
	{0x64c7, CRL_REG_LEN_08BIT, 0x31},
	{0x64c8, CRL_REG_LEN_08BIT, 0x01},
	{0x64c9, CRL_REG_LEN_08BIT, 0x32},
	{0x64ca, CRL_REG_LEN_08BIT, 0x01},
	{0x64cb, CRL_REG_LEN_08BIT, 0x33},
	{0x64cc, CRL_REG_LEN_08BIT, 0x01},
	{0x64cd, CRL_REG_LEN_08BIT, 0x34},
	{0x64ce, CRL_REG_LEN_08BIT, 0x01},
	{0x64cf, CRL_REG_LEN_08BIT, 0x35},
	{0x64d0, CRL_REG_LEN_08BIT, 0x01},
	{0x64d1, CRL_REG_LEN_08BIT, 0x36},
	{0x64d2, CRL_REG_LEN_08BIT, 0x01},
	{0x64d3, CRL_REG_LEN_08BIT, 0x37},
	{0x64d4, CRL_REG_LEN_08BIT, 0x01},
	{0x64d5, CRL_REG_LEN_08BIT, 0x38},
	{0x64d6, CRL_REG_LEN_08BIT, 0x01},
	{0x64d7, CRL_REG_LEN_08BIT, 0x39},
	{0x64d8, CRL_REG_LEN_08BIT, 0x01},
	{0x64d9, CRL_REG_LEN_08BIT, 0x3a},
	{0x64da, CRL_REG_LEN_08BIT, 0x01},
	{0x64db, CRL_REG_LEN_08BIT, 0x3b},
	{0x64dc, CRL_REG_LEN_08BIT, 0x01},
	{0x64dd, CRL_REG_LEN_08BIT, 0x3c},
	{0x64de, CRL_REG_LEN_08BIT, 0x01},
	{0x64df, CRL_REG_LEN_08BIT, 0x3d},
	{0x64e0, CRL_REG_LEN_08BIT, 0x01},
	{0x64e1, CRL_REG_LEN_08BIT, 0x3e},
	{0x64e2, CRL_REG_LEN_08BIT, 0x01},
	{0x64e3, CRL_REG_LEN_08BIT, 0x3f},
	{0x64e4, CRL_REG_LEN_08BIT, 0x02},
	{0x64e5, CRL_REG_LEN_08BIT, 0xa0},
	{0x64e6, CRL_REG_LEN_08BIT, 0x00},
	{0x64e7, CRL_REG_LEN_08BIT, 0xff},
	{0x64e8, CRL_REG_LEN_08BIT, 0x04},
	{0x64e9, CRL_REG_LEN_08BIT, 0x31},
	{0x64ea, CRL_REG_LEN_08BIT, 0x04},
	{0x64eb, CRL_REG_LEN_08BIT, 0x30},
	{0x64ec, CRL_REG_LEN_08BIT, 0x01},
	{0x64ed, CRL_REG_LEN_08BIT, 0x00},
	{0x64ee, CRL_REG_LEN_08BIT, 0x01},
	{0x64ef, CRL_REG_LEN_08BIT, 0x11},
	{0x64f0, CRL_REG_LEN_08BIT, 0x01},
	{0x64f1, CRL_REG_LEN_08BIT, 0x12},
	{0x64f2, CRL_REG_LEN_08BIT, 0x01},
	{0x64f3, CRL_REG_LEN_08BIT, 0x13},
	{0x64f4, CRL_REG_LEN_08BIT, 0x01},
	{0x64f5, CRL_REG_LEN_08BIT, 0x14},
	{0x64f6, CRL_REG_LEN_08BIT, 0x01},
	{0x64f7, CRL_REG_LEN_08BIT, 0x15},
	{0x64f8, CRL_REG_LEN_08BIT, 0x01},
	{0x64f9, CRL_REG_LEN_08BIT, 0x16},
	{0x64fa, CRL_REG_LEN_08BIT, 0x01},
	{0x64fb, CRL_REG_LEN_08BIT, 0x17},
	{0x64fc, CRL_REG_LEN_08BIT, 0x01},
	{0x64fd, CRL_REG_LEN_08BIT, 0x18},
	{0x64fe, CRL_REG_LEN_08BIT, 0x01},
	{0x64ff, CRL_REG_LEN_08BIT, 0x19},
	{0x6500, CRL_REG_LEN_08BIT, 0x01},
	{0x6501, CRL_REG_LEN_08BIT, 0x1a},
	{0x6502, CRL_REG_LEN_08BIT, 0x01},
	{0x6503, CRL_REG_LEN_08BIT, 0x1b},
	{0x6504, CRL_REG_LEN_08BIT, 0x01},
	{0x6505, CRL_REG_LEN_08BIT, 0x1c},
	{0x6506, CRL_REG_LEN_08BIT, 0x01},
	{0x6507, CRL_REG_LEN_08BIT, 0x1d},
	{0x6508, CRL_REG_LEN_08BIT, 0x01},
	{0x6509, CRL_REG_LEN_08BIT, 0x1e},
	{0x650a, CRL_REG_LEN_08BIT, 0x01},
	{0x650b, CRL_REG_LEN_08BIT, 0x1f},
	{0x650c, CRL_REG_LEN_08BIT, 0x02},
	{0x650d, CRL_REG_LEN_08BIT, 0xa0},
	{0x650e, CRL_REG_LEN_08BIT, 0x00},
	{0x650f, CRL_REG_LEN_08BIT, 0xff},
	{0x6510, CRL_REG_LEN_08BIT, 0x04},
	{0x6511, CRL_REG_LEN_08BIT, 0x20},
	{0x6512, CRL_REG_LEN_08BIT, 0x05},
	{0x6513, CRL_REG_LEN_08BIT, 0x86},
	{0x6514, CRL_REG_LEN_08BIT, 0x03},
	{0x6515, CRL_REG_LEN_08BIT, 0x0b},
	{0x6516, CRL_REG_LEN_08BIT, 0x05},
	{0x6517, CRL_REG_LEN_08BIT, 0x86},
	{0x6518, CRL_REG_LEN_08BIT, 0x00},
	{0x6519, CRL_REG_LEN_08BIT, 0x00},
	{0x651a, CRL_REG_LEN_08BIT, 0x05},
	{0x651b, CRL_REG_LEN_08BIT, 0x06},
	{0x651c, CRL_REG_LEN_08BIT, 0x00},
	{0x651d, CRL_REG_LEN_08BIT, 0x04},
	{0x651e, CRL_REG_LEN_08BIT, 0x05},
	{0x651f, CRL_REG_LEN_08BIT, 0x04},
	{0x6520, CRL_REG_LEN_08BIT, 0x00},
	{0x6521, CRL_REG_LEN_08BIT, 0x04},
	{0x6522, CRL_REG_LEN_08BIT, 0x05},
	{0x6523, CRL_REG_LEN_08BIT, 0x00},
	{0x6524, CRL_REG_LEN_08BIT, 0x05},
	{0x6525, CRL_REG_LEN_08BIT, 0x0a},
	{0x6526, CRL_REG_LEN_08BIT, 0x03},
	{0x6527, CRL_REG_LEN_08BIT, 0x9a},
	{0x6528, CRL_REG_LEN_08BIT, 0x05},
	{0x6529, CRL_REG_LEN_08BIT, 0x86},
	{0x652a, CRL_REG_LEN_08BIT, 0x00},
	{0x652b, CRL_REG_LEN_08BIT, 0x00},
	{0x652c, CRL_REG_LEN_08BIT, 0x05},
	{0x652d, CRL_REG_LEN_08BIT, 0x06},
	{0x652e, CRL_REG_LEN_08BIT, 0x00},
	{0x652f, CRL_REG_LEN_08BIT, 0x01},
	{0x6530, CRL_REG_LEN_08BIT, 0x05},
	{0x6531, CRL_REG_LEN_08BIT, 0x04},
	{0x6532, CRL_REG_LEN_08BIT, 0x00},
	{0x6533, CRL_REG_LEN_08BIT, 0x04},
	{0x6534, CRL_REG_LEN_08BIT, 0x05},
	{0x6535, CRL_REG_LEN_08BIT, 0x00},
	{0x6536, CRL_REG_LEN_08BIT, 0x05},
	{0x6537, CRL_REG_LEN_08BIT, 0x0a},
	{0x6538, CRL_REG_LEN_08BIT, 0x03},
	{0x6539, CRL_REG_LEN_08BIT, 0x99},
	{0x653a, CRL_REG_LEN_08BIT, 0x05},
	{0x653b, CRL_REG_LEN_08BIT, 0x06},
	{0x653c, CRL_REG_LEN_08BIT, 0x00},
	{0x653d, CRL_REG_LEN_08BIT, 0x00},
	{0x653e, CRL_REG_LEN_08BIT, 0x05},
	{0x653f, CRL_REG_LEN_08BIT, 0x04},
	{0x6540, CRL_REG_LEN_08BIT, 0x00},
	{0x6541, CRL_REG_LEN_08BIT, 0x04},
	{0x6542, CRL_REG_LEN_08BIT, 0x05},
	{0x6543, CRL_REG_LEN_08BIT, 0x00},
	{0x6544, CRL_REG_LEN_08BIT, 0x05},
	{0x6545, CRL_REG_LEN_08BIT, 0x0a},
	{0x6546, CRL_REG_LEN_08BIT, 0x03},
	{0x6547, CRL_REG_LEN_08BIT, 0x98},
	{0x6548, CRL_REG_LEN_08BIT, 0x05},
	{0x6549, CRL_REG_LEN_08BIT, 0x06},
	{0x654a, CRL_REG_LEN_08BIT, 0x00},
	{0x654b, CRL_REG_LEN_08BIT, 0x00},
	{0x654c, CRL_REG_LEN_08BIT, 0x05},
	{0x654d, CRL_REG_LEN_08BIT, 0x04},
	{0x654e, CRL_REG_LEN_08BIT, 0x00},
	{0x654f, CRL_REG_LEN_08BIT, 0x04},
	{0x6550, CRL_REG_LEN_08BIT, 0x05},
	{0x6551, CRL_REG_LEN_08BIT, 0x00},
	{0x6552, CRL_REG_LEN_08BIT, 0x05},
	{0x6553, CRL_REG_LEN_08BIT, 0x0a},
	{0x6554, CRL_REG_LEN_08BIT, 0x03},
	{0x6555, CRL_REG_LEN_08BIT, 0x97},
	{0x6556, CRL_REG_LEN_08BIT, 0x05},
	{0x6557, CRL_REG_LEN_08BIT, 0x06},
	{0x6558, CRL_REG_LEN_08BIT, 0x05},
	{0x6559, CRL_REG_LEN_08BIT, 0x04},
	{0x655a, CRL_REG_LEN_08BIT, 0x00},
	{0x655b, CRL_REG_LEN_08BIT, 0x04},
	{0x655c, CRL_REG_LEN_08BIT, 0x05},
	{0x655d, CRL_REG_LEN_08BIT, 0x00},
	{0x655e, CRL_REG_LEN_08BIT, 0x05},
	{0x655f, CRL_REG_LEN_08BIT, 0x0a},
	{0x6560, CRL_REG_LEN_08BIT, 0x03},
	{0x6561, CRL_REG_LEN_08BIT, 0x96},
	{0x6562, CRL_REG_LEN_08BIT, 0x05},
	{0x6563, CRL_REG_LEN_08BIT, 0x06},
	{0x6564, CRL_REG_LEN_08BIT, 0x05},
	{0x6565, CRL_REG_LEN_08BIT, 0x04},
	{0x6566, CRL_REG_LEN_08BIT, 0x00},
	{0x6567, CRL_REG_LEN_08BIT, 0x04},
	{0x6568, CRL_REG_LEN_08BIT, 0x05},
	{0x6569, CRL_REG_LEN_08BIT, 0x00},
	{0x656a, CRL_REG_LEN_08BIT, 0x05},
	{0x656b, CRL_REG_LEN_08BIT, 0x0a},
	{0x656c, CRL_REG_LEN_08BIT, 0x03},
	{0x656d, CRL_REG_LEN_08BIT, 0x95},
	{0x656e, CRL_REG_LEN_08BIT, 0x05},
	{0x656f, CRL_REG_LEN_08BIT, 0x06},
	{0x6570, CRL_REG_LEN_08BIT, 0x05},
	{0x6571, CRL_REG_LEN_08BIT, 0x04},
	{0x6572, CRL_REG_LEN_08BIT, 0x00},
	{0x6573, CRL_REG_LEN_08BIT, 0x04},
	{0x6574, CRL_REG_LEN_08BIT, 0x05},
	{0x6575, CRL_REG_LEN_08BIT, 0x00},
	{0x6576, CRL_REG_LEN_08BIT, 0x05},
	{0x6577, CRL_REG_LEN_08BIT, 0x0a},
	{0x6578, CRL_REG_LEN_08BIT, 0x03},
	{0x6579, CRL_REG_LEN_08BIT, 0x94},
	{0x657a, CRL_REG_LEN_08BIT, 0x05},
	{0x657b, CRL_REG_LEN_08BIT, 0x06},
	{0x657c, CRL_REG_LEN_08BIT, 0x00},
	{0x657d, CRL_REG_LEN_08BIT, 0x00},
	{0x657e, CRL_REG_LEN_08BIT, 0x05},
	{0x657f, CRL_REG_LEN_08BIT, 0x04},
	{0x6580, CRL_REG_LEN_08BIT, 0x00},
	{0x6581, CRL_REG_LEN_08BIT, 0x04},
	{0x6582, CRL_REG_LEN_08BIT, 0x05},
	{0x6583, CRL_REG_LEN_08BIT, 0x00},
	{0x6584, CRL_REG_LEN_08BIT, 0x05},
	{0x6585, CRL_REG_LEN_08BIT, 0x0a},
	{0x6586, CRL_REG_LEN_08BIT, 0x03},
	{0x6587, CRL_REG_LEN_08BIT, 0x93},
	{0x6588, CRL_REG_LEN_08BIT, 0x05},
	{0x6589, CRL_REG_LEN_08BIT, 0x06},
	{0x658a, CRL_REG_LEN_08BIT, 0x00},
	{0x658b, CRL_REG_LEN_08BIT, 0x00},
	{0x658c, CRL_REG_LEN_08BIT, 0x05},
	{0x658d, CRL_REG_LEN_08BIT, 0x04},
	{0x658e, CRL_REG_LEN_08BIT, 0x00},
	{0x658f, CRL_REG_LEN_08BIT, 0x04},
	{0x6590, CRL_REG_LEN_08BIT, 0x05},
	{0x6591, CRL_REG_LEN_08BIT, 0x00},
	{0x6592, CRL_REG_LEN_08BIT, 0x05},
	{0x6593, CRL_REG_LEN_08BIT, 0x0a},
	{0x6594, CRL_REG_LEN_08BIT, 0x03},
	{0x6595, CRL_REG_LEN_08BIT, 0x92},
	{0x6596, CRL_REG_LEN_08BIT, 0x05},
	{0x6597, CRL_REG_LEN_08BIT, 0x06},
	{0x6598, CRL_REG_LEN_08BIT, 0x05},
	{0x6599, CRL_REG_LEN_08BIT, 0x04},
	{0x659a, CRL_REG_LEN_08BIT, 0x00},
	{0x659b, CRL_REG_LEN_08BIT, 0x04},
	{0x659c, CRL_REG_LEN_08BIT, 0x05},
	{0x659d, CRL_REG_LEN_08BIT, 0x00},
	{0x659e, CRL_REG_LEN_08BIT, 0x05},
	{0x659f, CRL_REG_LEN_08BIT, 0x0a},
	{0x65a0, CRL_REG_LEN_08BIT, 0x03},
	{0x65a1, CRL_REG_LEN_08BIT, 0x91},
	{0x65a2, CRL_REG_LEN_08BIT, 0x05},
	{0x65a3, CRL_REG_LEN_08BIT, 0x06},
	{0x65a4, CRL_REG_LEN_08BIT, 0x05},
	{0x65a5, CRL_REG_LEN_08BIT, 0x04},
	{0x65a6, CRL_REG_LEN_08BIT, 0x00},
	{0x65a7, CRL_REG_LEN_08BIT, 0x04},
	{0x65a8, CRL_REG_LEN_08BIT, 0x05},
	{0x65a9, CRL_REG_LEN_08BIT, 0x00},
	{0x65aa, CRL_REG_LEN_08BIT, 0x05},
	{0x65ab, CRL_REG_LEN_08BIT, 0x0a},
	{0x65ac, CRL_REG_LEN_08BIT, 0x03},
	{0x65ad, CRL_REG_LEN_08BIT, 0x90},
	{0x65ae, CRL_REG_LEN_08BIT, 0x05},
	{0x65af, CRL_REG_LEN_08BIT, 0x06},
	{0x65b0, CRL_REG_LEN_08BIT, 0x05},
	{0x65b1, CRL_REG_LEN_08BIT, 0x04},
	{0x65b2, CRL_REG_LEN_08BIT, 0x00},
	{0x65b3, CRL_REG_LEN_08BIT, 0x04},
	{0x65b4, CRL_REG_LEN_08BIT, 0x05},
	{0x65b5, CRL_REG_LEN_08BIT, 0x00},
	{0x65b6, CRL_REG_LEN_08BIT, 0x05},
	{0x65b7, CRL_REG_LEN_08BIT, 0x0a},
	{0x65b8, CRL_REG_LEN_08BIT, 0x02},
	{0x65b9, CRL_REG_LEN_08BIT, 0x90},
	{0x65ba, CRL_REG_LEN_08BIT, 0x05},
	{0x65bb, CRL_REG_LEN_08BIT, 0x06},
	{0x65bc, CRL_REG_LEN_08BIT, 0x00},
	{0x65bd, CRL_REG_LEN_08BIT, 0xff},
	{0x65be, CRL_REG_LEN_08BIT, 0x04},
	{0x65bf, CRL_REG_LEN_08BIT, 0x70},
	{0x65c0, CRL_REG_LEN_08BIT, 0x08},
	{0x65c1, CRL_REG_LEN_08BIT, 0x76},
	{0x65c2, CRL_REG_LEN_08BIT, 0x00},
	{0x65c3, CRL_REG_LEN_08BIT, 0xff},
	{0x65c4, CRL_REG_LEN_08BIT, 0x08},
	{0x65c5, CRL_REG_LEN_08BIT, 0x76},
	{0x65c6, CRL_REG_LEN_08BIT, 0x04},
	{0x65c7, CRL_REG_LEN_08BIT, 0x0c},
	{0x65c8, CRL_REG_LEN_08BIT, 0x05},
	{0x65c9, CRL_REG_LEN_08BIT, 0x07},
	{0x65ca, CRL_REG_LEN_08BIT, 0x04},
	{0x65cb, CRL_REG_LEN_08BIT, 0x04},
	{0x65cc, CRL_REG_LEN_08BIT, 0x00},
	{0x65cd, CRL_REG_LEN_08BIT, 0xff},
	{0x65ce, CRL_REG_LEN_08BIT, 0x00},
	{0x65cf, CRL_REG_LEN_08BIT, 0xff},
	{0x65d0, CRL_REG_LEN_08BIT, 0x00},
	{0x65d1, CRL_REG_LEN_08BIT, 0xff},
	{0x30eb, CRL_REG_LEN_08BIT, 0x04},
	{0x30ed, CRL_REG_LEN_08BIT, 0x5a},
	{0x30ee, CRL_REG_LEN_08BIT, 0x01},
	{0x30ef, CRL_REG_LEN_08BIT, 0x80},
	{0x30f1, CRL_REG_LEN_08BIT, 0x5a},
	{0x303a, CRL_REG_LEN_08BIT, 0x04},
	{0x303b, CRL_REG_LEN_08BIT, 0x7f},
	{0x303c, CRL_REG_LEN_08BIT, 0xfe},
	{0x303d, CRL_REG_LEN_08BIT, 0x19},
	{0x303e, CRL_REG_LEN_08BIT, 0xd7},
	{0x303f, CRL_REG_LEN_08BIT, 0x09},
	{0x3040, CRL_REG_LEN_08BIT, 0x78},
	{0x3042, CRL_REG_LEN_08BIT, 0x05},
	{0x328a, CRL_REG_LEN_08BIT, 0x10},
};

static struct crl_register_write_rep ov10640_streamon_regs[] = {
	{OV10640_REG_STREAM, CRL_REG_LEN_08BIT, 0x01},
};

static struct crl_register_write_rep ov10640_streamoff_regs[] = {
	{OV10640_REG_STREAM, CRL_REG_LEN_08BIT, 0x00},
};

static struct crl_dynamic_register_access ov10640_h_flip_regs[] = {
	{
		.address = 0x3128,
		.len = CRL_REG_LEN_08BIT | CRL_REG_READ_AND_UPDATE,
		.ops_items = 0,
		.ops = 0,
		.mask = 0x1,
	}
};

static struct crl_dynamic_register_access ov10640_v_flip_regs[] = {
	{
		.address = 0x3128,
		.len = CRL_REG_LEN_08BIT | CRL_REG_READ_AND_UPDATE,
		.ops_items = 0,
		.ops = 0,
		.mask = 0x2,
	}
};

/* Needed for acpi support for runtime detection */
static struct crl_sensor_detect_config ov10640_sensor_detect_regset[] = {
	{
		.reg = { 0x300A, CRL_REG_LEN_08BIT, 0x000000ff },
		.width = 8,
	},
	{
		.reg = { 0x300B, CRL_REG_LEN_08BIT, 0x000000ff },
		.width = 8,
	},
};

static struct crl_pll_configuration ov10640_pll_configurations[] = {
	{
		.input_clk = 12000000,
		.op_sys_clk = 392000000,
		.bitsperpixel = 12,
		.pixel_rate_csi = 529000000,
		.pixel_rate_pa = 529000000, /* pixel_rate = MIPICLK*2 *4/12 */
		.csi_lanes = 4,
		.comp_items = 0,
		.ctrl_data = 0,
		.pll_regs_items = ARRAY_SIZE(ov10640_pll_794mbps),
		.pll_regs = ov10640_pll_794mbps,
	}
};

static struct crl_subdev_rect_rep ov10640_1280_1080_rects[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.in_rect = {0, 0, 1280, 1080},
		.out_rect = {0, 0, 1280, 1080},
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.in_rect = {0, 0, 1280, 1080},
		.out_rect = {0, 0, 1280, 1080},
	}
};

static struct crl_mode_rep ov10640_modes[] = {
	{
		.sd_rects_items = ARRAY_SIZE(ov10640_1280_1080_rects),
		.sd_rects = ov10640_1280_1080_rects,
		.binn_hor = 1,
		.binn_vert = 1,
		.scale_m = 1,
		.width = 1280,
		.height = 1080,
		.min_llp = 2250,
		.min_fll = 1320,
		.mode_regs_items = ARRAY_SIZE(ov10640_1280_1080_LONG_RAW),
		.mode_regs = ov10640_1280_1080_LONG_RAW,
	},
};

static struct crl_sensor_subdev_config ov10640_sensor_subdevs[] = {
	{
		.subdev_type = CRL_SUBDEV_TYPE_BINNER,
		.name = "ov10640 binner",
	},
	{
		.subdev_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.name = "ov10640 pixel array",
	}
};

static struct crl_sensor_limits ov10640_sensor_limits = {
	.x_addr_min = 0,
	.y_addr_min = 0,
	.x_addr_max = 1280,
	.y_addr_max = 1080,
	.min_frame_length_lines = 320,
	.max_frame_length_lines = 65535,
	.min_line_length_pixels = 380,
	.max_line_length_pixels = 32752,
};

static struct crl_flip_data ov10640_flip_configurations[] = {
	{
		.flip = CRL_FLIP_DEFAULT_NONE,
		.pixel_order = CRL_PIXEL_ORDER_BGGR,
	},
	{
		.flip = CRL_FLIP_HFLIP,
		.pixel_order = CRL_PIXEL_ORDER_GBRG,
	},
	{
		.flip = CRL_FLIP_VFLIP,
		.pixel_order = CRL_PIXEL_ORDER_GRBG,
	},
	{
		.flip = CRL_FLIP_HFLIP_VFLIP,
		.pixel_order = CRL_PIXEL_ORDER_RGGB,
	}
};

static struct crl_csi_data_fmt ov10640_crl_csi_data_fmt[] = {
	{
		.code = MEDIA_BUS_FMT_SGRBG12_1X12,
		.pixel_order = CRL_PIXEL_ORDER_GRBG,
		.bits_per_pixel = 12,
		.regs_items = 0,
		.regs = 0,
	},
	{
		.code = MEDIA_BUS_FMT_SRGGB12_1X12,
		.pixel_order = CRL_PIXEL_ORDER_RGGB,
		.bits_per_pixel = 12,
		.regs_items = 0,
		.regs = 0,
	},
	{
		.code = MEDIA_BUS_FMT_SBGGR12_1X12,
		.pixel_order = CRL_PIXEL_ORDER_BGGR,
		.bits_per_pixel = 12,
		.regs_items = 0,
		.regs = 0,
	},
	{
		.code = MEDIA_BUS_FMT_SGBRG12_1X12,
		.pixel_order = CRL_PIXEL_ORDER_GBRG,
		.bits_per_pixel = 12,
		.regs_items = 0,
		.regs = 0,
	}
};

static struct crl_v4l2_ctrl ov10640_v4l2_ctrls[] = {
	{
		.sd_type = CRL_SUBDEV_TYPE_BINNER,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_IDLE,
		.ctrl_id = V4L2_CID_LINK_FREQ,
		.name = "V4L2_CID_LINK_FREQ",
		.type = CRL_V4L2_CTRL_TYPE_MENU_INT,
		.data.v4l2_int_menu.def = 0,
		.data.v4l2_int_menu.max = 0,
		.data.v4l2_int_menu.menu = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.regs_items = 0,
		.regs = 0,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_GET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_PIXEL_RATE,
		.name = "V4L2_CID_PIXEL_RATE_PA",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = INT_MAX,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.regs_items = 0,
		.regs = 0,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_BINNER,
		.op_type = CRL_V4L2_CTRL_GET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_PIXEL_RATE,
		.name = "V4L2_CID_PIXEL_RATE_CSI",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = INT_MAX,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.regs_items = 0,
		.regs = 0,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_HFLIP,
		.name = "V4L2_CID_HFLIP",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = 1,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(ov10640_h_flip_regs),
		.regs = ov10640_h_flip_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
	{
		.sd_type = CRL_SUBDEV_TYPE_PIXEL_ARRAY,
		.op_type = CRL_V4L2_CTRL_SET_OP,
		.context = SENSOR_POWERED_ON,
		.ctrl_id = V4L2_CID_VFLIP,
		.name = "V4L2_CID_VFLIP",
		.type = CRL_V4L2_CTRL_TYPE_INTEGER,
		.data.std_data.min = 0,
		.data.std_data.max = 1,
		.data.std_data.step = 1,
		.data.std_data.def = 0,
		.flags = 0,
		.impact = CRL_IMPACTS_NO_IMPACT,
		.ctrl = 0,
		.regs_items = ARRAY_SIZE(ov10640_v_flip_regs),
		.regs = ov10640_v_flip_regs,
		.dep_items = 0,
		.dep_ctrls = 0,
	},
};

struct crl_sensor_configuration ov10640_crl_configuration = {
	.powerup_regs_items = ARRAY_SIZE(ov10640_powerup_standby),
	.powerup_regs = ov10640_powerup_standby,

	.poweroff_regs_items = 0,
	.poweroff_regs = 0,

	.id_reg_items = ARRAY_SIZE(ov10640_sensor_detect_regset),
	.id_regs = ov10640_sensor_detect_regset,

	.subdev_items = ARRAY_SIZE(ov10640_sensor_subdevs),
	.subdevs = ov10640_sensor_subdevs,

	.sensor_limits = &ov10640_sensor_limits,

	.pll_config_items = ARRAY_SIZE(ov10640_pll_configurations),
	.pll_configs = ov10640_pll_configurations,

	.modes_items = ARRAY_SIZE(ov10640_modes),
	.modes = ov10640_modes,

	.streamon_regs_items = ARRAY_SIZE(ov10640_streamon_regs),
	.streamon_regs = ov10640_streamon_regs,

	.streamoff_regs_items = ARRAY_SIZE(ov10640_streamoff_regs),
	.streamoff_regs = ov10640_streamoff_regs,

	.v4l2_ctrls_items = ARRAY_SIZE(ov10640_v4l2_ctrls),
	.v4l2_ctrl_bank = ov10640_v4l2_ctrls,

	.csi_fmts_items = ARRAY_SIZE(ov10640_crl_csi_data_fmt),
	.csi_fmts = ov10640_crl_csi_data_fmt,

	.flip_items = ARRAY_SIZE(ov10640_flip_configurations),
	.flip_data = ov10640_flip_configurations,
};

#endif  /* __CRLMODULE_OV10640_CONFIGURATION_H_ */
