/*
 * Copyright (c) 2016 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef INTEL_IPU5_ISYS_CSI2_REG_H
#define INTEL_IPU5_ISYS_CSI2_REG_H

#define INTEL_IPU5_CSI_REG_TOP0_RX_A_ADDR_OFFSET		0x68000
#define INTEL_IPU5_CSI_REG_TOP0_RX_B_ADDR_OFFSET		0x68100
#define INTEL_IPU5_CSI_REG_TOP0_CPHY_RX_0_ADDR_OFFSET		0x68200
#define INTEL_IPU5_CSI_REG_TOP0_CPHY_RX_1_ADDR_OFFSET		0x68300

#define INTEL_IPU5_CSI_REG_TOP1_RX_A_ADDR_OFFSET		0x6a000
#define INTEL_IPU5_CSI_REG_TOP1_RX_B_ADDR_OFFSET		0x6a100
#define INTEL_IPU5_CSI_REG_TOP1_CPHY_RX_0_ADDR_OFFSET		0x6a200
#define INTEL_IPU5_CSI_REG_TOP1_CPHY_RX_1_ADDR_OFFSET		0x6a300

#define INTEL_IPU5_CSI_REG_TOP2_RX_A_ADDR_OFFSET		0x6c000
#define INTEL_IPU5_CSI_REG_TOP2_RX_B_ADDR_OFFSET		0x6c100
#define INTEL_IPU5_CSI_REG_TOP2_CPHY_RX_0_ADDR_OFFSET		0x6c200
#define INTEL_IPU5_CSI_REG_TOP2_CPHY_RX_1_ADDR_OFFSET		0x6c300

#define INTEL_IPU5_CSI_REG_RX_ENABLE				0x00
#define INTEL_IPU5_CSI_REG_RX_ENABLE_ENABLE			0x01
#define INTEL_IPU5_CSI_REG_RX_NOF_ENABLED_LANES			0x04
#define INTEL_IPU5_CSI_REG_RX_CTL				0x08
#define INTEL_IPU5_CSI_REG_RX_CONFIG_RELEASE_LP11		0x1
#define INTEL_IPU5_CSI_REG_RX_CONFIG_DISABLE_BYTE_CLK_GATING	0x2
#define INTEL_IPU5_CSI_REG_RX_HBP_TESTMODE_ENABLE		0x0c

#define INTEL_IPU5_CSI_REG_RX_ERROR_HANDLING			0x10
#define INTEL_IPU5_CSI_REG_RX_SYNC_CNTR_SEL			0x14
#define INTEL_IPU5_CSI_REG_RX_SP_IF_CONFIG			0x18
#define INTEL_IPU5_CSI_REG_RX_LP_IF_CONFIG			0x1C

#define INTEL_IPU5_CSI_REG_RX_DLY_CNT_TERMEN_CLANE		0x30
#define INTEL_IPU5_CSI_REG_RX_DLY_CNT_SETTLE_CLANE		0x34
/* 0..3 */
#define INTEL_IPU5_CSI_REG_RX_DLY_CNT_TERMEN_DLANE(n)		(0x38 + (n) * 8)
#define INTEL_IPU5_CSI_REG_RX_DLY_CNT_SETTLE_DLANE(n)		(0x3C + (n) * 8)

/*
* IPU5 related IRQ registers
* irq_ctrlx_a based from rx_a
* irq_ctrlx_b based from rx_b
*/
#define INTEL_IPU5_CSI_REG_IRQ_CTRL0_A_EDGE			0xb00
#define INTEL_IPU5_CSI_REG_IRQ_CTRL1_A_EDGE			0xa00
#define INTEL_IPU5_CSI_REG_IRQ_CTRL2_A_EDGE			0xd00
#define INTEL_IPU5_CSI_REG_IRQ_CTRL0_B_EDGE			0x1200
#define INTEL_IPU5_CSI_REG_IRQ_CTRL1_B_EDGE			0x1100
#define INTEL_IPU5_CSI_REG_IRQ_CTRL2_B_EDGE			0x1400

#define INTEL_IPU5_CSI_REG_IRQ_MASK_OFFSET			0x4
#define INTEL_IPU5_CSI_REG_IRQ_STATUS_OFFSET			0x8
#define INTEL_IPU5_CSI_REG_IRQ_CLEAR_OFFSET			0xc
#define INTEL_IPU5_CSI_REG_IRQ_ENABLE_OFFSET			0x10
#define INTEL_IPU5_CSI_REG_IRQ_PULSE_OFFSET			0x14

#define CSI_RX_HEADER_SINGLE_ERROR_CORRECTED			BIT(0)
#define CSI_RX_HEADER_MULTIPLE_ERRORS_CORRECTED			BIT(1)
#define CSI_RX_PAYLOAD_CRC_ERROR				BIT(2)
#define CSI_RX_FIFO_OVERFLOW					BIT(3)
#define CSI_RX_RESERVED_SHORT_PACKET_DATA_TYPE			BIT(4)
#define CSI_RX_RESERVED_LONG_PACKET_DATA_TYPE			BIT(5)
#define CSI_RX_INCOMPLETE_LONG_PACKET				BIT(6)
#define CSI_RX_FRAME_SYNC_ERROR					BIT(7)
#define CSI_RX_LINE_SYNC_ERROR					BIT(8)
#define CSI_RX_DATA_RECOVERABLE_SYNC_ERROR			BIT(9)
#define CSI_RX_DATA_NONRECOVERABLE_SYNC_ERROR			BIT(10)
#define CSI_RX_DATA_ESCAPE_MODE_ERROR				BIT(11)
#define CSI_RX_DATA_ESCAPE_MODE_TRIGGER_EVENT			BIT(12)
#define CSI_RX_DATA_ESCAPE_MODE_ULTRALOW_POWER			BIT(13)
#define CSI_RX_CLK_ESCAPE_MODE_ULTRALOW_POWER			BIT(14)
#define CSI_RX_INTER_FRAME_SHORT_PACKET_DISCARDED		BIT(15)
/* this bit is in ctrl2 */
#define CSI_RX_INTER_FRAME_LONG_PACKET_DISCARDED		BIT(1)
#define CSI_RX_ERROR_IRQ_MASK					0xffff
#define CSI_RX_NUM_ERRORS_IN_CTRL0				16
#define CSI_RX_NUM_IRQ						32

#define CSI_CPHY_RX_HEADER_ERROR				BIT(0)
#define CSI_CPHY_RX_PAYLOAD_CRC_ERROR				BIT(1)
#define CSI_CPHY_RX_FIFO_OVERFLOW				BIT(2)
#define CSI_CPHY_RX_RESERVED_SHORT_PACKET_DATA_TYPE		BIT(3)
#define CSI_CPHY_RX_RESERVED_LONG_PACKET_DATA_TYPE		BIT(4)
#define CSI_CPHY_RX_INCOMPLETE_PACKET				BIT(5)
#define CSI_CPHY_RX_FRAME_SYNC_ERROR				BIT(6)
#define CSI_CPHY_RX_LINE_SYNC_ERROR				BIT(7)
#define CSI_CPHY_RX_SOT_MISSING_SYNC0				BIT(8)
#define CSI_CPHY_RX_SOT_MISSING_SYNC1				BIT(9)
#define CSI_CPHY_RX_INTER_FRAME_SHORT_PACKET_DISCARDED		BIT(26)
#define CSI_CPHY_RX_INTER_FRAME_LONG_PACKET_DISCARDED		BIT(27)
#define CSI_CPHY_RX_ERROR_IRQ_MASK				0xc0003ff
#define CSI_CPHY_RX_NUM_ERRORS_IN_CTRL1				10
#define CSI_CPHY_RX_NUM_IRQ					29

#define INTEL_IPU5_CSI_RX_IRQ_FS_VC(chn)	\
	(1 << ((chn) * 4 + CSI_RX_NUM_ERRORS_IN_CTRL0))
#define INTEL_IPU5_CSI_RX_IRQ_FE_VC(chn)	\
	(2 << ((chn) * 4 + CSI_RX_NUM_ERRORS_IN_CTRL0))
#define INTEL_IPU5_CSI_RX_IRQ_LS_VC(chn)	\
	(4 << ((chn) * 4 + CSI_RX_NUM_ERRORS_IN_CTRL0))
#define INTEL_IPU5_CSI_RX_IRQ_LN_VC(chn)	\
	(8 << ((chn) * 4 + CSI_RX_NUM_ERRORS_IN_CTRL0))

#define INTEL_IPU5_CSI_CPHY_RX_IRQ_FS_VC(chn)	\
	(1 << ((chn) * 4 + CSI_CPHY_RX_NUM_ERRORS_IN_CTRL1))
#define INTEL_IPU5_CSI_CPHY_RX_IRQ_FE_VC(chn)	\
	(2 << ((chn) * 4 + CSI_CPHY_RX_NUM_ERRORS_IN_CTRL1))
#define INTEL_IPU5_CSI_CPHY_RX_IRQ_LS_VC(chn)	\
	(4 << ((chn) * 4 + CSI_CPHY_RX_NUM_ERRORS_IN_CTRL1))
#define INTEL_IPU5_CSI_CPHY_RX_IRQ_LN_VC(chn)	\
	(8 << ((chn) * 4 + CSI_CPHY_RX_NUM_ERRORS_IN_CTRL1))

#endif /* INTEL_IPU5_ISYS_CSI2_REG_H */
