/*
 * (c) 2016 Advanced Driver Information Technology GmbH
 *          Frederic Berat (fberat@de.adit-jv.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 */

#ifndef __HYPERVISOR_LOGS_H__
#define __HYPERVISOR_LOGS_H__

#include "llrb.h"

#ifdef CONFIG_ERRMEM_HANDLE_HYPERVISOR_LOGS

int errmem_init_hyp_logs(struct llrb *llrb, struct device *dev);
void errmem_deinit_hyp_logs(void);
int errmem_read_hyp_logs(struct llrb *llrb);

#else /* CONFIG_ERRMEM_HANDLE_HYPERVISOR_LOGS */

static inline int errmem_init_hyp_logs(__maybe_unused struct llrb *in,
				       __maybe_unused struct device *dev)
{
	return -ENODEV;
};

static inline void errmem_deinit_hyp_logs(void) { return; };

static inline int errmem_read_hyp_logs(__maybe_unused struct llrb *in)
{
	return -ENODEV;
};

#endif /* !CONFIG_ERRMEM_HANDLE_HYPERVISOR_LOGS */

#endif /* __HYPERVISOR_LOGS_H__ */
