/*
 * (c) 2016 Advanced Driver Information Technology GmbH
 *          Frederic Berat (fberat@de.adit-jv.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 */

#ifndef __ERRMEM_INTERNAL_H__
#define __ERRMEM_INTERNAL_H__

#include <linux/errmem.h>
#include <linux/fs.h>

#include "llrb.h"

/* maximum console message level */
#define CONSOLEMAXLEVEL            8

struct errmem_private_data {
	unsigned int rd;	/* next message to read */
	unsigned int wr;	/* message to write (append) */
	unsigned int read_size;	/* buffer size for IOCTL_ERRMEM_READ */
};

int errmem_get_console_wr(void);
int errmem_get_console_lvl(void);
void errmem_set_console_lvl(int lvl);

ssize_t errmem_read(struct file *filp, struct errmem_message *msg);
ssize_t errmem_write(struct file *filp, char *data, unsigned int length);

int errmem_ioctl(struct llrb *llrb, struct file *filp, unsigned int cmd,
		 unsigned long arg);

#endif /* __ERRMEM_INTERNAL_H__ */
