/*
 * linux/drivers/misc/exchnd/arch/triggers/arm64.c
 *
 * aarch64 do_exit handling when KERNEL_PROFILING option is disabled.
 *
 * Copyright (C) 2016 Advanced Driver Information Technology GmbH
 * Written by Frederic Berat (fberat@de.adit-jv.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 */

/*
 * exception trigger PROCESS_EXIT
 *
 * The exception hooks on a probe on do_exit to trigger when a process ends.
 * Aim is to temporarily modify the call stack, adding a function that will
 * stop the task we want to watch.
 */

#include <linux/ptrace.h>
#include <linux/exchnd.h>

#include "../../internal.h"

/* Currently not supported. */
#error "Process exit trigger without profiling is not yet supported"

void exchnd_restore_registers(struct pt_regs *regs)
{
	pr_error("Not supported on arm64");
}

void exchnd_arch_do_exit(struct pt_regs *regs)
{
	pr_error("Not supported on arm64");
}
