/*************************************************************************/ /*
 BUSMONI

 Copyright (c) 2016 Renesas Electronics Corporation. All rights reserved.

 License        Dual MIT/GPLv2

 The contents of this file are subject to the MIT license as set out below.

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 Alternatively, the contents of this file may be used under the terms of
 the GNU General Public License Version 2 ("GPL") in which case the provisions
 of GPL are applicable instead of those above.

 If you wish to allow use of your version of this file only under the terms of
 GPL, and not to allow others to use your version of this file under the terms
 of the MIT license, indicate your decision by deleting the provisions above
 and replace them with the notice and other provisions required by GPL as set
 out in the file called "GPL-COPYING" included in this distribution. If you do
 not delete the provisions above, a recipient may use your version of this file
 under the terms of either the MIT license or GPL.

 This License is also included in this distribution in the file called
 "MIT-COPYING".

 EXCEPT AS OTHERWISE STATED IN A NEGOTIATED AGREEMENT: (A) THE SOFTWARE IS
 PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 PURPOSE AND NONINFRINGEMENT; AND (B) IN NO EVENT SHALL THE AUTHORS OR
 COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


 GPLv2:
 If you wish to use this file under the terms of GPL, following terms are
 effective.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2 of the License.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/ /*************************************************************************/
#include "busmon.h"
#include "r8a7795.h"
#include <linux/ioport.h>
#include <linux/io.h>

BUSMONREG   BUSMON;
DBMONREG    DBMON;
PERFMONREG	PERFMON[MAX_PARA_LAT_MON];
static char pmon_name[16][20];

int busmon_init(uint32_t device, uint32_t device_version)
{
    uint32_t pa_traffic_fix;
    uint32_t pa_traffic_be;
    uint32_t pa_monitortime_a;
    uint32_t pa_performance_monitor;
    uint32_t pa_monitortime;
    uint32_t pa_monitor_changetime;
    uint32_t pa_monitor_interrupt;
    uint32_t pa_distribution_threshold;
    
    int ret = 0;
    
    pa_traffic_fix = BUSMON_BASE + TRAFFICMONITOR_FIX_OFFSET;
    if (!request_mem_region(pa_traffic_fix, 0x1000, BUSMON_REG_NAME)) {
        pr_err("busmon_init: request_mem_region[TRAFFICMONITOR_FIX] error");
        ret = -ENOMEM;
        goto err_i1;
    }
    BUSMON.TRAFFICMONITOR_FIX = (uint64_t)ioremap_nocache(pa_traffic_fix, 0x1000);
    
    pa_traffic_be = BUSMON_BASE + TRAFFICMONITOR_BE_OFFSET;
    if (!request_mem_region(pa_traffic_be, 0x1000, BUSMON_REG_NAME)) {
        pr_err("busmon_init: request_mem_region[TRAFFICMONITOR_BE] error");
        ret = -ENOMEM;
        goto err_i2;
    }
    BUSMON.TRAFFICMONITOR_BE = (uint64_t)ioremap_nocache(pa_traffic_be, 0x1000);
    
    pa_monitortime_a = BUSMON_BASE + MonitorTimeA_OFFSET;
    if (!request_mem_region(pa_monitortime_a, sizeof(uint32_t), BUSMON_REG_NAME)) {
        pr_err("busmon_init: request_mem_region[MonitorTimeA] error");
        ret = -ENOMEM;
        goto err_i3;
    }
    BUSMON.MonitorTimeA = (uint64_t)ioremap_nocache(pa_monitortime_a, sizeof(uint32_t));
    
    pa_performance_monitor = BUSMON_BASE + PerformanceMonitor_OFFSET;
    if (!request_mem_region(pa_performance_monitor, sizeof(uint32_t), BUSMON_REG_NAME)) {
        pr_err("busmon_init: request_mem_region[PerformanceMonitor] error");
        ret = -ENOMEM;
        goto err_i4;
    }
    BUSMON.PerformanceMonitor = (uint64_t)ioremap_nocache(pa_performance_monitor, sizeof(uint32_t));
    
    if (device == R_CAR_M3W) {
        pa_monitor_changetime = BUSMON_BASE + MonitorChangeTime_OFFSET;
        if (!request_mem_region(pa_monitor_changetime, sizeof(uint32_t), BUSMON_REG_NAME)) {
            pr_err("busmon_init: request_mem_region[MonitorChangeTime] error");
            ret = -ENOMEM;
            goto err_i5;
        }
        BUSMON.MonitorChangeTime = (uint64_t)ioremap_nocache(pa_monitor_changetime, sizeof(uint32_t));
        
        pa_monitor_interrupt = BUSMON_BASE + MonitorInterrupt_OFFSET;
        if (!request_mem_region(pa_monitor_interrupt, sizeof(uint32_t), BUSMON_REG_NAME)) {
            pr_err("busmon_init: request_mem_region[MonitorInterrupt] error");
            ret = -ENOMEM;
            goto err_i6;
        }
        BUSMON.MonitorInterrupt = (uint64_t)ioremap_nocache(pa_monitor_interrupt, sizeof(uint32_t));
    }
    
    pa_monitortime = BUSMON_BASE + MonitorTime_OFFSET;
    if (!request_mem_region(pa_monitortime, sizeof(uint32_t), BUSMON_REG_NAME)) {
        pr_err("busmon_init: request_mem_region[MonitorTime] error");
        ret = -ENOMEM;
        goto err_i7;
    }
    BUSMON.MonitorTime = (uint64_t)ioremap_nocache(pa_monitortime, sizeof(uint32_t));
    
    pa_distribution_threshold = BUSMON_BASE + DistributionThreshold_OFFSET;
    if (!request_mem_region(pa_distribution_threshold, sizeof(uint64_t), BUSMON_REG_NAME)) {
        pr_err("busmon_init: request_mem_region[DistributionThreshold] error");
        ret = -ENOMEM;
        goto err_i8;
    }
    BUSMON.DistributionThreshold = (uint64_t)ioremap_nocache(pa_distribution_threshold, sizeof(uint64_t));
    
    return ret;

err_i8:
    iounmap((void *)BUSMON.MonitorTime);
    release_mem_region(pa_monitortime, sizeof(uint32_t));       
err_i7:
    if (device == R_CAR_M3W) {
        iounmap((void *)BUSMON.MonitorInterrupt);
        release_mem_region(pa_monitor_interrupt, sizeof(uint32_t)); 
    }
err_i6:
    if (device == R_CAR_M3W) {
        iounmap((void *)BUSMON.MonitorChangeTime);
        release_mem_region(pa_monitor_changetime, sizeof(uint32_t));
    }
err_i5:
    iounmap((void *)BUSMON.PerformanceMonitor);
    release_mem_region(pa_performance_monitor, sizeof(uint32_t));
    
err_i4:
    iounmap((void *)BUSMON.MonitorTimeA);
    release_mem_region(pa_monitortime_a, sizeof(uint32_t));
err_i3:
    iounmap((void *)BUSMON.TRAFFICMONITOR_BE);
    release_mem_region(pa_traffic_be, 0x1000);
err_i2:
    iounmap((void *)BUSMON.TRAFFICMONITOR_FIX);
    release_mem_region(pa_traffic_fix, 0x1000);
err_i1:
    return ret;
}

int dbmon_init(uint32_t device, uint32_t device_version)
{
    /* register mapping */
    uint32_t pa_dbmonconf0; 
    uint32_t pa_dbmonrdl;

    int ret = 0;
    
    pa_dbmonconf0 = DBMON_BASE;
    if (!request_mem_region(pa_dbmonconf0, 0x1C, DBMON_REG_NAME)) {
        pr_err("dbmon_init: request_mem_region[DBMONCONF0] error");
        ret = -ENOMEM;
        goto err_i1;
    }
    DBMON.DBMONCONF0 = (uint64_t)ioremap_nocache(pa_dbmonconf0, 0x1C);
    DBMON.DBMONCONF1 = DBMON.DBMONCONF0 + 0x04;
    DBMON.DBMONCONF2 = DBMON.DBMONCONF0 + 0x08;
    DBMON.DBMONCONF3 = DBMON.DBMONCONF0 + 0x0C;
    DBMON.DBMONCONF4 = DBMON.DBMONCONF0 + 0x10;
    DBMON.DBMONCONF5 = DBMON.DBMONCONF0 + 0x14;
    DBMON.DBMONCONF6 = DBMON.DBMONCONF0 + 0x18;
    
    pa_dbmonrdl = DBMON_BASE + DBMONRDL_OFFSET;
    if (!request_mem_region(pa_dbmonrdl, 0x20, DBMON_REG_NAME)) {
        pr_err("dbmon_init: request_mem_region[DBMONRDL] error");
        ret = -ENOMEM;
        goto err_i2;
    }
    DBMON.DBMONRDL   = (uint64_t)ioremap_nocache(pa_dbmonrdl, 0x20);
    DBMON.DBMONRDH   = DBMON.DBMONRDL + 0x04;
    DBMON.DBMONWRL   = DBMON.DBMONRDL + 0x08;
    DBMON.DBMONWRH   = DBMON.DBMONRDL + 0x0C;
    DBMON.DBMONACTL  = DBMON.DBMONRDL + 0x10;
    DBMON.DBMONACTH  = DBMON.DBMONRDL + 0x14;
    DBMON.DBMONREFL  = DBMON.DBMONRDL + 0x18;
    DBMON.DBMONREFH  = DBMON.DBMONRDL + 0x1C;
    return ret;
    
err_i2:
    iounmap((void *)DBMON.DBMONCONF0);
    release_mem_region(pa_dbmonconf0, 0x1C);    
err_i1:
    return ret;     
}


int perfmon_init(uint32_t device, uint32_t device_version, BUSMONI_WORK_BUF * pwork_buf)
{
	int i;
	int ret = 0;
	PVOID pPerfmonRegBase[MAX_PARA_LAT_MON];

	/* Init PerfMON registers */
	for (i = 0; i < pwork_buf->work_paras.PMON_paraNum; i++) {
		strcpy(pmon_name[i], "");
		sprintf(pmon_name[i], "PERFMON REGISTER %d", i);
		if ( !request_mem_region(pwork_buf->work_paras.PMON_baseAdd[i], PERFMON_REG_SIZE, pmon_name[i])) {
			pr_err("perfmon_init_n: request_mem_region error");
			for (i=i-1; i >= 0; i--){
				release_mem_region(pwork_buf->work_paras.PMON_baseAdd[i], PERFMON_REG_SIZE);
			}
			ret = -ENOMEM;
			return ret;
		}
		pPerfmonRegBase[i] = ioremap_nocache(pwork_buf->work_paras.PMON_baseAdd[i], PERFMON_REG_SIZE);
		PERFMON[i].CCLEAR          = (uint64_t)pPerfmonRegBase[i] + CCLEAR_OFFSET;
		PERFMON[i].CENABLE         = (uint64_t)pPerfmonRegBase[i] + CENABLE_OFFSET;
		PERFMON[i].PRESCALE        = (uint64_t)pPerfmonRegBase[i] + PRESCALE_OFFSET;
		PERFMON[i].IDMSKR0         = (uint64_t)pPerfmonRegBase[i] + IDMSKR0_OFFSET;
		PERFMON[i].IDMSKR1         = (uint64_t)pPerfmonRegBase[i] + IDMSKR1_OFFSET;
		PERFMON[i].IDMSKW0         = (uint64_t)pPerfmonRegBase[i] + IDMSKW0_OFFSET;
		PERFMON[i].IDMSKW1         = (uint64_t)pPerfmonRegBase[i] + IDMSKW1_OFFSET;
		PERFMON[i].SELR            = (uint64_t)pPerfmonRegBase[i] + SELR_OFFSET;
		PERFMON[i].SELW            = (uint64_t)pPerfmonRegBase[i] + SELW_OFFSET;
		PERFMON[i].ACCUMULATOR_R   = (uint64_t)pPerfmonRegBase[i] + ACCUMULATOR_R_OFFSET;
		PERFMON[i].ACCUMULATOR_W   = (uint64_t)pPerfmonRegBase[i] + ACCUMULATOR_W_OFFSET;
		PERFMON[i].TX_COUNTER_R    = (uint64_t)pPerfmonRegBase[i] + TX_COUNTER_R_OFFSET;
		PERFMON[i].TX_COUNTER_W    = (uint64_t)pPerfmonRegBase[i] + TX_COUNTER_W_OFFSET;
		PERFMON[i].MAX_COUNTER_R   = (uint64_t)pPerfmonRegBase[i] + MAX_COUNTER_R_OFFSET;
		PERFMON[i].MAX_COUNTER_W   = (uint64_t)pPerfmonRegBase[i] + MAX_COUNTER_W_OFFSET;
		PERFMON[i].OUTSTANDINGOVER = (uint64_t)pPerfmonRegBase[i] + OUTSTANDINGOVER_OFFSET;
	}
	
	return ret;
}