/*************************************************************************/ /*
 BUSMONI

 Copyright (c) 2016 Renesas Electronics Corporation. All rights reserved.
 License        Dual MIT/GPLv2

 The contents of this file are subject to the MIT license as set out below.

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 Alternatively, the contents of this file may be used under the terms of
 the GNU General Public License Version 2 ("GPL") in which case the provisions
 of GPL are applicable instead of those above.

 If you wish to allow use of your version of this file only under the terms of
 GPL, and not to allow others to use your version of this file under the terms
 of the MIT license, indicate your decision by deleting the provisions above
 and replace them with the notice and other provisions required by GPL as set
 out in the file called "GPL-COPYING" included in this distribution. If you do
 not delete the provisions above, a recipient may use your version of this file
 under the terms of either the MIT license or GPL.

 This License is also included in this distribution in the file called
 "MIT-COPYING".

 EXCEPT AS OTHERWISE STATED IN A NEGOTIATED AGREEMENT: (A) THE SOFTWARE IS
 PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 PURPOSE AND NONINFRINGEMENT; AND (B) IN NO EVENT SHALL THE AUTHORS OR
 COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


 GPLv2:
 If you wish to use this file under the terms of GPL, following terms are
 effective.

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2 of the License.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/ /*************************************************************************/

 
#include <linux/kernel.h>


#define PM_PRESET       (0x00010000)
#define PM_PMEN         (0x00000001)
#define SSLOTCLOCK_MSK      (0x000001FF)

#define W 0
#define R 1

#define R_CAR_H3            (0x00004F00)
#define R_CAR_M3W           (0x00005200)

#define WS1_0               (0x00000000)
#define WS1_1               (0x00000001)
#define WS2_0               (0x00000010)
#define WS3_0               (0x00000020)

#define ALREADY 1
#define NOTYET 0

#define USED 1
#define FREE 0

#define RUNNING   1
#define COMPLETED 0

#define YES 1
#define NO  0

#define ON 1
#define OFF 0

#define MNDEV_MSK       (0x00007000)
#define MNDEV_SHIFT     (12)
#define MNSCHE_MSK      (0x00000300)
#define MNSCHE_SHIFT        (8)
#define MNBCAM_MSK      (0x00000010)
#define MNBCAM_SHIFT        (4)
#define MNAXIP_MSK      (0x00000003)
#define MNAXIP_SHIFT        (0)
#define DBMON_L08_MSK       (0x000000FF)

#define MASTER_ID_NUM_MAX       (104)
#define DDR_CH_NUM_MAX          (4)
#define MASTER_ID_NUM_H3        (MASTER_ID_NUM_MAX)
#define DDR_CH_NUM_H3           (DDR_CH_NUM_MAX)
#define MASTER_ID_NUM_M3W       (MASTER_ID_NUM_MAX)
#define DDR_CH_NUM_M3W          (DDR_CH_NUM_MAX)

#define MAX_PARA_LAT_MON  (16) /* Support 16 PerfMon run in parallel */

#define READARRAY64(reg, pos)       (*(volatile uint64_t * const)((reg) + (sizeof(uint64_t)*(pos))))
#define WRITEARRAY64(reg, pos, val) (*(volatile uint64_t * const)((reg) + (sizeof(uint64_t)*(pos)))) = (uint64_t)(val)
#define READARRAY32(reg, pos)       (*(volatile uint32_t * const)((reg) + (sizeof(uint32_t)*(pos))))
#define WRITEARRAY32(reg, pos, val) (*(volatile uint32_t * const)((reg) + (sizeof(uint32_t)*(pos)))) = (uint32_t)(val)
#define READARRAY16(reg, pos)       (*(volatile unsigned short * const)((reg) + (sizeof(unsigned short)*(pos))))
#define WRITEARRAY16(reg, pos, val) (*(volatile unsigned short * const)((reg) + (sizeof(unsigned short)*(pos)))) = (unsigned short)(val)
#define READARRAY8(reg, pos)        (*(volatile unsigned char * const)((reg) + (sizeof(unsigned char)*(pos))))
#define WRITEARRAY8(reg, pos, val)  (*(volatile unsigned char * const)((reg) + (sizeof(unsigned char)*(pos)))) = (unsigned char)(val)

#define READREG64(reg)          (*(volatile uint64_t * const)(reg))
#define WRITEREG64(reg, val)        (*(volatile uint64_t * const)(reg)) = (uint64_t)(val)
#define READREG32(reg)          (*(volatile uint32_t * const)(reg))
#define WRITEREG32(reg, val)        (*(volatile uint32_t * const)(reg)) = (uint32_t)(val)
#define READREG16(reg)          (*(volatile unsigned short * const)(reg))
#define WRITEREG16(reg, val)        (*(volatile unsigned short * const)(reg)) = (unsigned short)(val)
#define READREG8(reg)           (*(volatile unsigned char * const)(reg))
#define WRITEREG8(reg, val)     (*(volatile unsigned char * const)(reg)) = (unsigned char)(val)


typedef void * PVOID;

typedef struct _DEV_INFO {
    uint32_t device; /* The product code of the running SoC */
    uint32_t device_version; /* The version code of the running SoC*/
} DEV_INFO;

/* BUSMONI operation parameter struct */
typedef struct _BUSMONI_PARA {
        /* The interval between each measurement. Range: 100 ms ->10000 ms 
         * Default value = 1000 --> 1000ms 
         */
        uint32_t interval;
        
        /* The number of the measurements that want to run 
         * Default value = 1 --> measures 1 time
         */
        uint32_t count;
        /* AXI BUS CLOCK
         * Default value = 400Mhz 
         * H3 WS1.0 - 200MHz
         * H3 WS1.1 - 400MHz
         * M3W WS1.0 - 400MHz
         */
        uint32_t axi_bus_clk;
        
        /* Some parameters of DBMON
         * Default: 
         uint64_t   param_DistributionThreshold = 0x0000003000200010;
         uint32_t   param_DBMONCONF1 = 0;
         uint32_t   param_DBMONCONF2 = 0;
         uint32_t   param_DBMONCONF3 = 0;
         uint32_t   param_DBMONCONF4 = 0;
         uint32_t   param_DBMONCONF5 = 0;
         uint32_t   param_DBMONCONF6 = 0;
         */
        uint64_t    param_DistributionThreshold;
        uint32_t    param_DBMONCONF1;
        uint32_t    param_DBMONCONF2;
        uint32_t    param_DBMONCONF3;
        uint32_t    param_DBMONCONF4;
        uint32_t    param_DBMONCONF5;
        uint32_t    param_DBMONCONF6;
		
		/* It contains the base address of the node that want to monitor latency. 
		 */
		uint32_t PMON_baseAdd[MAX_PARA_LAT_MON];
		
		/* It specifies the number of latency monitor can be measured simultaneously 
		 * Range: 0:MAX_PARA_LAT_MON
		*/
		int32_t PMON_paraNum;
		
		/* It specifies the setting for IDMSKR*, IDMSKW* registers.
		 * Only works with UC34
		 */
		uint32_t PMON_idmskr0[MAX_PARA_LAT_MON];
		uint32_t PMON_idmskr1[MAX_PARA_LAT_MON]; 
		uint32_t PMON_idmskw0[MAX_PARA_LAT_MON]; 
		uint32_t PMON_idmskw1[MAX_PARA_LAT_MON]; 		
		
		/* It specifies the setting for selr and selw registers
		 * Only works with UC34
		 */
		uint32_t PMON_selr[MAX_PARA_LAT_MON];
		uint32_t PMON_selw[MAX_PARA_LAT_MON];
		 
		/* It specifies the setting for PRESCALE register. 
		 * Regulates number of cycle for each count 
		 * Only works with UC34
		 * 000: counts each cycle
		 * 001: counts each 2 cycle
		 * 010: counts each 4 cycle
		 * 011: counts each 8 cycle
		 * 100: counts each 16 cycle
		 */
		uint32_t PMON_prescale[MAX_PARA_LAT_MON];		
        
} BUSMONI_PARA;



typedef struct _BUSMONI_TRAFFIC_MID
{
    char name[20];
    int rw;                /* 0:Write 1:Read */
    uint64_t total_forw;   /* Total bus load of a master_id = fix + be */
} BUSMONI_TRAFFIC_MID ;

typedef struct _BUSMONI_DBMON_CMD
{
    char name[20];
    uint64_t rcmd;
    uint64_t wcmd;
    uint64_t actcmd;
    uint64_t refcmd;
} BUSMONI_DBMON_CMD;

typedef struct _BUSMONI_PERFMON
{
	uint64_t accum_r;
	uint64_t accum_w;
	uint32_t cnt_r;
	uint32_t cnt_w;
	uint32_t max_cycle_r;
	uint32_t max_cycle_w;
	uint32_t out_std_over;
} BUSMONI_PERFMON;

typedef struct _BUSMONI_INFO
{
    int master_id_num;
    int ddr_ch_num;
    
    uint32_t slot_per_ms; /* Number of slots in 1 ms*/
    uint32_t monitor_time; /* Real measurement period */
    uint32_t cycl_per_slot; /* Number of AXI BUS clock cycles in 1 slot */
    uint32_t device; /* The product code of the running SoC*/
    uint32_t device_version; /* The version code of the running SoC*/
} BUSMONI_INFO;

typedef struct _BUSMONI_UC11_RSLT
{
    uint64_t ddr_r;
    uint64_t ddr_w;
} BUSMONI_UC11_RSLT;

typedef struct _BUSMONI_UC12_RSLT
{
    uint64_t dbsc0_r;
    uint64_t dbsc0_w;
    uint64_t dbsc1_r;
    uint64_t dbsc1_w;
} BUSMONI_UC12_RSLT;

typedef struct _BUSMONI_UC13_RSLT
{
    struct ddr_ch {
        uint64_t read;
        uint64_t write;
    } ddr_ch[DDR_CH_NUM_MAX];
} BUSMONI_UC13_RSLT;

typedef struct _BUSMONI_UC14_RSLT
{
    struct dbmon_cmd_ch {
        uint64_t rcmd;
        uint64_t wcmd;
        uint64_t actcmd;
        uint64_t refcmd;
    } dbmon_cmd_ch[DDR_CH_NUM_MAX];
} BUSMONI_UC14_RSLT;

typedef struct _BUSMONI_UC22_RSLT
{
    struct traffic_mon_rslt_uc22 {
        char name[20];
        int rw;                /* 0:Write 1:Read */
        uint64_t total_forw;   /* Total bus load of this master_id (in MB/s) */
    } traffic_mon_rslt[MASTER_ID_NUM_MAX];
} BUSMONI_UC22_RSLT;

typedef struct _BUSMONI_UC34_RSLT
{
	struct lat_mon_rslt_uc34 {
		uint64_t accum_r;
		uint32_t cnt_r;
		uint64_t ave_r;	
		uint64_t accum_w;
		uint32_t cnt_w;
		uint64_t ave_w;	
		uint32_t max_cycle_r;
		uint32_t max_cycle_w;	
		uint32_t out_std_over;
	} lat_mon_rslt[MAX_PARA_LAT_MON];
} BUSMONI_UC34_RSLT;

typedef struct _BUSMONI_RESULT_BUF 
{
    BUSMONI_UC11_RSLT uc11_rslt;
    BUSMONI_UC12_RSLT uc12_rslt;
    BUSMONI_UC13_RSLT uc13_rslt;
    BUSMONI_UC14_RSLT uc14_rslt;
    
    BUSMONI_UC22_RSLT uc22_rslt;
	
	BUSMONI_UC34_RSLT uc34_rslt;
    
    uint32_t done_meas_cnt; /* done measurement counter */
    BUSMONI_PARA work_paras;
} BUSMONI_RESULT_BUF;

typedef struct _BUSMONI_WORK_BUF {
    BUSMONI_PARA work_paras;
    BUSMONI_TRAFFIC_MID  * work_traff_mid;
    BUSMONI_DBMON_CMD    * work_dbmon_cmd;
	BUSMONI_PERFMON      * work_perfmon;
    BUSMONI_INFO bus_info;
    
    int (*cb_user)(BUSMONI_RESULT_BUF, uint64_t);
    uint64_t args;
} BUSMONI_WORK_BUF, *PBUSMONI_WORK_BUF;



enum {
    reserved1,
    reserved2,
    reserved3,
    IOCTL_BUSMONI_SETUP,
    IOCTL_BUSMONI_GET_DEVICE_INFO,
    IOCTL_BUSMONI_CANCEL,
    IOCTL_BUSMONI_RELEASE_MEM,
    IOCTL_BUSMONI_START,
    IOCTL_BUSMONI_STOP,
};



int busmon_init(uint32_t device, uint32_t device_version);
int dbmon_init(uint32_t device, uint32_t device_version);
int perfmon_init(uint32_t device, uint32_t device_version, BUSMONI_WORK_BUF * pwork_buf);


typedef struct _BUSMONREG
{
    uint64_t TRAFFICMONITOR_FIX;
    uint64_t TRAFFICMONITOR_BE;
    uint64_t MonitorTimeA;
    uint64_t PerformanceMonitor;
    uint64_t MonitorChangeTime;
    uint64_t MonitorInterrupt;
    uint64_t MonitorTime;
    
    uint64_t DistributionThreshold;
} BUSMONREG;

typedef struct _DBMONREG
{
    uint64_t DBMONCONF0;
    uint64_t DBMONCONF1;
    uint64_t DBMONCONF2;
    uint64_t DBMONCONF3;
    uint64_t DBMONCONF4;
    uint64_t DBMONCONF5;
    uint64_t DBMONCONF6;
    uint64_t DBMONRDL;
    uint64_t DBMONRDH;
    uint64_t DBMONWRL;
    uint64_t DBMONWRH;
    uint64_t DBMONACTL;
    uint64_t DBMONACTH;
    uint64_t DBMONREFL;
    uint64_t DBMONREFH;
} DBMONREG;

typedef struct _PERFMONREG
{
	uint64_t CCLEAR;
	uint64_t CENABLE;
	uint64_t PRESCALE;
	uint64_t IDMSKR0;
	uint64_t IDMSKR1;
	uint64_t IDMSKW0;
	uint64_t IDMSKW1;
	uint64_t SELR; //newCCLEAR  (M3W - fcpvd,vin only)
	uint64_t SELW;
	uint64_t ACCUMULATOR_R; //ACCUMULATOR_LSB (M3W - fcpvd,vin only)
	uint64_t ACCUMULATOR_W; //ACCUMULATOR_MSB (M3W - fcpvd,vin only)
	uint64_t TX_COUNTER_R; //TX_COUNTER_LSB (M3W - fcpvd,vin only)
	uint64_t TX_COUNTER_W; //TX_COUNTER_MSB (M3W - fcpvd,vin only)
	uint64_t MAX_COUNTER_R;
	uint64_t MAX_COUNTER_W;
	uint64_t OUTSTANDINGOVER;
} PERFMONREG;