/**************************************************************
* Copyright 2014 (c) Discretix Technologies Ltd.              *
* This software is protected by copyright, international      *
* treaties and various patents. Any copy or reproduction of   *
* the software as permitted below, must include this          *
* Copyright Notice as well as any other notices provided      *
* under the relevant license.                                 *
*                                                             *
* This software shall be governed by, and may be used and     *
* redistributed under the terms and conditions of the GNU     *
* General Public License version 2, as published by the       *
* Free Software Foundation.                                   *
* This software is distributed in the hope that it will be    *
* useful, but WITHOUT ANY liability and WARRANTY; without     *
* even the implied warranty of MERCHANTABILITY or FITNESS     *
* FOR A PARTICULAR PURPOSE. See the GNU General Public        *
* License for more details.                                   *
* You should have received a copy of the GNU General          *
* Public License along with this software; if not, please     *
* write to the Free Software Foundation, Inc.,                *
* 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.   *
**************************************************************/

#ifndef __CC_LL_TEST_H__
#define __CC_LL_TEST_H__

#include "dx_reg_common.h"

/* Uncomment the following line when running Linux as secure OS (i.e., ARM::SCR.NS == 0) */
/* This option enables a few test steps which cannot be executed in insecure world */
//#define SECURE_LINUX

/* Supported CryptoCell products signature values */
/* Used to detect product ID at compile time */
#define DX_CC63P_SIG    0xDCC63000

/* CC device resources (which are missing from dx_reg_*.h files */
#if (DX_DEV_SIGNATURE == DX_CC63P_SIG)
#define DX_HW_VERSION  0xAF400001U
#define DX_ROM_VERSION 0x03000009U
#else
#error Unsupported DX_DEV_SIGNATURE value
#endif

#define DX_CC_SRAM_SIZE 4096

/* Default test parameters */
#define DX_CACHE_PARAMS_DEFAULT 0x000 /* Alternative: 0x333 for ACE coherency */
#define DMA_COHERENT_OPS_DEFAULT 0 /* Alternative: 1 to use arm_coherent_dma_ops */
#define RESULTS_VERIF_MSLEEP 10 /* [msec] delay before re-verifying results */

#endif /*__CC_LL_TEST_H__*/
