/*
 * include/linux/arch_topology.h - arch specific cpu topology information
 */
#ifndef _LINUX_ARCH_TOPOLOGY_H_
#define _LINUX_ARCH_TOPOLOGY_H_

#include <linux/percpu.h>

void topology_normalize_cpu_scale(void);

struct device_node;
int topology_parse_cpu_capacity(struct device_node *cpu_node, int cpu);

DECLARE_PER_CPU(unsigned long, cpu_scale);

struct sched_domain;
static inline
unsigned long topology_get_cpu_scale(struct sched_domain *sd, int cpu)
{
	return per_cpu(cpu_scale, cpu);
}

void topology_set_cpu_scale(unsigned int cpu, unsigned long capacity);

DECLARE_PER_CPU(unsigned long, freq_scale);

static inline
unsigned long topology_get_freq_scale(struct sched_domain *sd, int cpu)
{
	return per_cpu(freq_scale, cpu);
}

int atd_get_mc_sd_flags(void);
int atd_get_die_sd_flags(void);

#endif /* _LINUX_ARCH_TOPOLOGY_H_ */
