/*
 * linux/include/linux/errmem.h
 *
 * Copyright (C) 2013 Advanced Driver Information Technology GmbH
 * Written by Kai Tomerius (ktomerius@de.adit-jv.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 */

#ifndef __ERRMEM_H__
#define __ERRMEM_H__
#ifdef CONFIG_ERRMEM
/* errmem_store - kernel interface to store messages in error memory */
unsigned int errmem_store(int fatal, unsigned int length, unsigned char *msg);
#else
static inline unsigned int errmem_store(__maybe_unused int fatal,
					__maybe_unused unsigned int length,
					__maybe_unused unsigned char *msg)
{
	return 0;
}
#endif /* CONFIG_ERRMEM */

#endif /* ifndef __ERRMEM_H__ */
