/*
 * Copyright 2017, QNX Software Systems Limited (“QSS”).
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Additional Patent Grant
 *
 * QSS hereby grants to you a perpetual, worldwide, non-exclusive,
 * no-charge, irrevocable (except as stated in this section) patent
 * license to make, have made, use, offer to sell, sell, import,
 * transfer, and otherwise run, modify and propagate the contents of this
 * header file (“Implementation”) , where such license applies
 * only to those patent claims, both currently owned by QSS and
 * acquired in the future, licensable by QSS that are necessarily
 * infringed by this Implementation. This grant does
 * not include claims that would be infringed only as a consequence of
 * further modification of this Implementation. If you or your agent or
 * exclusive licensee institute or order or agree to the institution of
 * patent litigation against any entity (including a cross-claim or
 * counterclaim in a lawsuit) alleging that this Implementation constitutes
 * direct or contributory patent infringement, or inducement of patent
 * infringement, then any patent rights granted to you under this license for
 * this Implementation shall terminate as of the date such litigation is filed.
 */

#ifndef __VDEV_AUDIO_H
#define __VDEV_AUDIO_H

/* Virtq types */
#define VIRTIO_AUDIO_VIRTQ_TYPE_IN     0u
#define VIRTIO_AUDIO_VIRTQ_TYPE_OUT    1u
#define VIRTIO_AUDIO_VIRTQ_TYPE_CMD    2u
#define VIRTIO_AUDIO_VIRTQ_TYPE_NUM    3u

/* Virtq sizes */
#define VIRTIO_AUDIO_VIRTQ_SIZE_IN     128  /* max is 512 */
#define VIRTIO_AUDIO_VIRTQ_SIZE_OUT    128  /* max is 512 */
#define VIRTIO_AUDIO_VIRTQ_SIZE_CTRL   16

/* Audio commands */
#define VIRTIO_AUDIO_CMD_ACQUIRE       0
#define VIRTIO_AUDIO_CMD_PREPARE       1
#define VIRTIO_AUDIO_CMD_FLUSH         2
#define VIRTIO_AUDIO_CMD_DRAIN         3
#define VIRTIO_AUDIO_CMD_PAUSE         4
#define VIRTIO_AUDIO_CMD_RESUME        5
#define VIRTIO_AUDIO_CMD_RELEASE       6
#define VIRTIO_AUDIO_CMD_NUM           7
#define VIRTIO_AUDIO_CMD_NONE          0xFFFF

/* Audio status values */
#define VIRTIO_AUDIO_S_OK              0
#define VIRTIO_AUDIO_S_UNSUPP          1
#define VIRTIO_AUDIO_S_INVALID         2
#define VIRTIO_AUDIO_S_FAILURE         3
#define VIRTIO_AUDIO_S_BADSTATE        4
#define VIRTIO_AUDIO_S_NOCHANNEL       5
#define VIRTIO_AUDIO_S_XRUN            6

/* Audio channel types */
#define VIRTIO_AUDIO_CHANNEL_PLAYBACK  0
#define VIRTIO_AUDIO_CHANNEL_CAPTURE   1

/* Audio formats */
#define VIRTIO_AUDIO_FMT_U8                       0
#define VIRTIO_AUDIO_FMT_S8                       1
#define VIRTIO_AUDIO_FMT_U16_LE                   2
#define VIRTIO_AUDIO_FMT_U16_BE                   3
#define VIRTIO_AUDIO_FMT_S16_LE                   4
#define VIRTIO_AUDIO_FMT_S16_BE                   5
/* 24 bit PCM formats using lower three bytes in 32-bit word */
#define VIRTIO_AUDIO_FMT_U24_LE                   6
#define VIRTIO_AUDIO_FMT_U24_BE                   7
#define VIRTIO_AUDIO_FMT_S24_LE                   8
#define VIRTIO_AUDIO_FMT_S24_BE                   9
#define VIRTIO_AUDIO_FMT_U32_LE                   10
#define VIRTIO_AUDIO_FMT_U32_BE                   11
#define VIRTIO_AUDIO_FMT_S32_LE                   12
#define VIRTIO_AUDIO_FMT_S32_BE                   13
#define VIRTIO_AUDIO_FMT_A_LAW                    14
#define VIRTIO_AUDIO_FMT_MU_LAW                   15
#define VIRTIO_AUDIO_FMT_IEC958_SUBFRAME_LE       16
#define VIRTIO_AUDIO_FMT_IEC958_SUBFRAME_BE       17
#define VIRTIO_AUDIO_FMT_AC3                      18
#define VIRTIO_AUDIO_FMT_FLOAT_LE                 19
#define VIRTIO_AUDIO_FMT_FLOAT_BE                 20
#define VIRTIO_AUDIO_FMT_FLOAT64_LE               21
#define VIRTIO_AUDIO_FMT_FLOAT64_BE               22
#define VIRTIO_AUDIO_FMT_IMA_ADPCM                23
#define VIRTIO_AUDIO_FMT_GSM                      24
#define VIRTIO_AUDIO_FMT_MPEG                     25
#define VIRTIO_AUDIO_FMT_SPECIAL                  26
/* 24 bit PCM formats using three bytes */
#define VIRTIO_AUDIO_FMT_U24_3LE                  27
#define VIRTIO_AUDIO_FMT_U24_3BE                  28
#define VIRTIO_AUDIO_FMT_S24_3LE                  29
#define VIRTIO_AUDIO_FMT_S24_3BE                  30

#define VIRTIO_AUDIO_FMT_LAST		VIRTIO_AUDIO_FMT_S24_3BE

/* Audio format masks */
#define VIRTIO_AUDIO_FMT_MSK_U8          BIT(VIRTIO_AUDIO_FMT_U8)
#define VIRTIO_AUDIO_FMT_MSK_S8          BIT(VIRTIO_AUDIO_FMT_S8)
#define VIRTIO_AUDIO_FMT_MSK_U16_LE      BIT(VIRTIO_AUDIO_FMT_U16_LE)
#define VIRTIO_AUDIO_FMT_MSK_U16_BE      BIT(VIRTIO_AUDIO_FMT_U16_BE)
#define VIRTIO_AUDIO_FMT_MSK_S16_LE      BIT(VIRTIO_AUDIO_FMT_S16_LE)
#define VIRTIO_AUDIO_FMT_MSK_S16_BE      BIT(VIRTIO_AUDIO_FMT_S16_BE)
/* 24 bit PCM formats using lower three bytes in 32-bit word */
#define VIRTIO_AUDIO_FMT_MSK_U24_LE      BIT(VIRTIO_AUDIO_FMT_U24_LE)
#define VIRTIO_AUDIO_FMT_MSK_U24_BE      BIT(VIRTIO_AUDIO_FMT_U24_BE)
#define VIRTIO_AUDIO_FMT_MSK_S24_LE      BIT(VIRTIO_AUDIO_FMT_S24_LE)
#define VIRTIO_AUDIO_FMT_MSK_S24_BE      BIT(VIRTIO_AUDIO_FMT_S24_BE)
#define VIRTIO_AUDIO_FMT_MSK_U32_LE      BIT(VIRTIO_AUDIO_FMT_U32_LE)
#define VIRTIO_AUDIO_FMT_MSK_U32_BE      BIT(VIRTIO_AUDIO_FMT_U32_BE)
#define VIRTIO_AUDIO_FMT_MSK_S32_LE      BIT(VIRTIO_AUDIO_FMT_S32_LE)
#define VIRTIO_AUDIO_FMT_MSK_S32_BE      BIT(VIRTIO_AUDIO_FMT_S32_BE)
#define VIRTIO_AUDIO_FMT_MSK_A_LAW       BIT(VIRTIO_AUDIO_FMT_A_LAW)
#define VIRTIO_AUDIO_FMT_MSK_MU_LAW      BIT(VIRTIO_AUDIO_FMT_MU_LAW)
#define VIRTIO_AUDIO_FMT_MSK_IEC958_SUBFRAME_LE \
				BIT(VIRTIO_AUDIO_FMT_IEC958_SUBFRAME_LE)
#define VIRTIO_AUDIO_FMT_MSK_IEC958_SUBFRAME_BE \
				BIT(VIRTIO_AUDIO_FMT_IEC958_SUBFRAME_BE)
#define VIRTIO_AUDIO_FMT_MSK_AC3         BIT(VIRTIO_AUDIO_FMT_AC3)
#define VIRTIO_AUDIO_FMT_MSK_FLOAT_LE    BIT(VIRTIO_AUDIO_FMT_FLOAT_LE)
#define VIRTIO_AUDIO_FMT_MSK_FLOAT_BE    BIT(VIRTIO_AUDIO_FMT_FLOAT_BE)
#define VIRTIO_AUDIO_FMT_MSK_FLOAT64_LE  BIT(VIRTIO_AUDIO_FMT_FLOAT64_LE)
#define VIRTIO_AUDIO_FMT_MSK_FLOAT64_BE  BIT(VIRTIO_AUDIO_FMT_FLOAT64_BE)
#define VIRTIO_AUDIO_FMT_MSK_IMA_ADPCM   BIT(VIRTIO_AUDIO_FMT_IMA_ADPCM)
#define VIRTIO_AUDIO_FMT_MSK_GSM         BIT(VIRTIO_AUDIO_FMT_GSM)
#define VIRTIO_AUDIO_FMT_MSK_MPEG        BIT(VIRTIO_AUDIO_FMT_MPEG)
#define VIRTIO_AUDIO_FMT_MSK_SPECIAL     BIT(VIRTIO_AUDIO_FMT_SPECIAL)
/* 24 bit PCM formats using three bytes */
#define VIRTIO_AUDIO_FMT_MSK_U24_3LE     BIT(VIRTIO_AUDIO_FMT_U24_3LE)
#define VIRTIO_AUDIO_FMT_MSK_U24_3BE     BIT(VIRTIO_AUDIO_FMT_U24_3BE)
#define VIRTIO_AUDIO_FMT_MSK_S24_3LE     BIT(VIRTIO_AUDIO_FMT_S24_3LE)
#define VIRTIO_AUDIO_FMT_MSK_S24_3BE     BIT(VIRTIO_AUDIO_FMT_S24_3BE)

/* Audio sample rate masks */
#define VIRTIO_AUDIO_RATE_MSK_8000                BIT(1)
#define VIRTIO_AUDIO_RATE_MSK_11025               BIT(2)
#define VIRTIO_AUDIO_RATE_MSK_16000               BIT(3)
#define VIRTIO_AUDIO_RATE_MSK_18900               BIT(13)
#define VIRTIO_AUDIO_RATE_MSK_22050               BIT(4)
#define VIRTIO_AUDIO_RATE_MSK_24000               BIT(12)
#define VIRTIO_AUDIO_RATE_MSK_32000               BIT(5)
#define VIRTIO_AUDIO_RATE_MSK_44100               BIT(6)
#define VIRTIO_AUDIO_RATE_MSK_48000               BIT(7)
#define VIRTIO_AUDIO_RATE_MSK_88200               BIT(8)
#define VIRTIO_AUDIO_RATE_MSK_96000               BIT(9)
#define VIRTIO_AUDIO_RATE_MSK_176400              BIT(10)
#define VIRTIO_AUDIO_RATE_MSK_192000              BIT(11)
#define VIRTIO_AUDIO_RATE_MSK_12000               BIT(14)
#define VIRTIO_AUDIO_RATE_MSK_64000               BIT(15)

/* Audio sample rate bits */
#define VIRTIO_AUDIO_RATE_BIT_8000                1
#define VIRTIO_AUDIO_RATE_BIT_11025               2
#define VIRTIO_AUDIO_RATE_BIT_16000               3
#define VIRTIO_AUDIO_RATE_BIT_18900               13
#define VIRTIO_AUDIO_RATE_BIT_22050               4
#define VIRTIO_AUDIO_RATE_BIT_24000               12
#define VIRTIO_AUDIO_RATE_BIT_32000               5
#define VIRTIO_AUDIO_RATE_BIT_44100               6
#define VIRTIO_AUDIO_RATE_BIT_48000               7
#define VIRTIO_AUDIO_RATE_BIT_88200               8
#define VIRTIO_AUDIO_RATE_BIT_96000               9
#define VIRTIO_AUDIO_RATE_BIT_176400              10
#define VIRTIO_AUDIO_RATE_BIT_192000              11
#define VIRTIO_AUDIO_RATE_BIT_12000               14
#define VIRTIO_AUDIO_RATE_BIT_64000               15

#define VIRTIO_AUDIO_RATE_LAST	15

/* Define device specific features here */
/* TODO: volume or mute control would be device specific features,
 * TBD if required
 */

/* Define device specific configuration - for the virtio_audio case the device
 * capabilities, restricted in range via the qvm config file,
 * are treated as device config.
 */
struct virtio_audio_chan_config {
	u32    devno;
	u32    channel;		/* VIRTIO_AUDIO_CHANNEL_* */
	u32    rates;		/* bit mask of VIRTIO_AUDIO_RATE_MSK_* values */
	u32    formats;		/* bit mask of VIRTIO_AUDIO_FMT_MSK_* values */
	u32    min_fragsize;	/* min fragment size in bytes */
	u32    max_fragsize;	/* max fragment size in bytes */
	u32    min_voices;
	u32    max_voices;
	u32    fragment_align;	/* fragment alignment in bytes */
	u8     reserved[16];	/* reserved for future extensions */
};

struct virtio_audio_config {
	u32    channel_num;
	struct virtio_audio_chan_config channel_config[];
};

struct virtio_audio_acquire_params {
	u32    rate;		/* sample rate in Hz */
	u32    voices;
	u32    format;		/* VIRTIO_AUDIO_FMT_* value */
	u32    frag_size;	/* fragment size in bytes */
	u32    frags_max;	/* max number of fragments */
};

struct virtio_audio_cmd {
	u32 id;      /* command id */
	union {
		struct virtio_audio_acquire_params acquire_params;
		u8 reserved[32]; /* reserve a fixed size for command
				  * specific params
				  */
	};
};

struct virtio_audio_acquire_status {
	u32 frag_size;
};

struct virtio_audio_status {
	u32 status;
	union {
		struct virtio_audio_acquire_status acquire_status;
		u8 reserved[32]; /* reserve a fixed size for command
				  * specific status
				  */
	};
};

#endif /* __VDEV_AUDIO_H */
