/*******************************************************************************
*    Copyright (c) 2013 Neusoft Co., Ltd.
*    FileName	:	bvd_device.h
*    Module		:	bvd driver
*    Function	:	bvd driver module use for Neusoft Bluedragon
*					Bluetooth stack.
*-------------------------------------------------------------------------------
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc..
*******************************************************************************/

#ifndef _BVD_DEVICE_H_
#define _BVD_DEVICE_H_
#include "bvd_config.h"

#include <linux/fs.h>

#ifdef BVD_DEBUG	/*BVD_DEBUG*/
#define BVD_DBG(fmt, ...) \
	pr_debug("bvd %s %d %s:" \
			fmt, __FILE__, __LINE__, __func__,  ## __VA_ARGS__)
#else				/* ifdef BVD_DEBUG */
#define BVD_DBG(fmt, ...)
#endif	/* ifdef BVD_DEBUG */

/*check LINUX kernel version less than ver.patch_level.sub_level*/
#define LINUX_VERSION_LT(ver, patch_level, sub_level)	\
	(KERNEL_VERSION(BVD_KERNEL_VERSION, BVD_KERNEL_PATCHLEVEL,\
	BVD_KERNEL_SUBLEVEL) < KERNEL_VERSION(ver, patch_level, sub_level))

enum bvd_device_type {
	BVD_DEVICE_TYPE_TTY,
	BVD_DEVICE_TYPE_NET,
	BVD_DEVICE_TYPE_MAX
};

struct bvd_device_create_req_header {
	enum bvd_device_type type;
};

#ifdef __KERNEL__

struct bvd_device_operations {
	void* (*create)(void __user *arg);

	int (*destroy)(void *dev, unsigned long force);
	int (*read)(void *dev, char *buf,
				unsigned int count);
	int (*write)(void *dev, const char *buf,
				unsigned int count);
	int (*get_status)(void *dev);
	long (*ioctl)(void *dev, unsigned int cmd,
				unsigned long arg);

	unsigned int (*poll)(void *dev, struct file *file,
						struct poll_table_struct *wait);
};

int bvd_device_register(int type, const struct bvd_device_operations *new_ops);
int bvd_device_unregister(int type);
#endif	/* ifdef __KERNEL__ */
#endif	/* _BVD_DEVICE_H_ */
