/*******************************************************************************
*    Copyright (c) 2013 Neusoft Co., Ltd.
*    FileName	:	bvd_net_dev.h
*    Module		:	bvd driver
*    Function	:	bvd driver module use for Neusoft Bluedragon
*					Bluetooth stack.
*-------------------------------------------------------------------------------
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc..
*******************************************************************************/

#ifndef _BVD_NET_H_
#define _BVD_NET_H_

#include "bvd_config.h"

#include <linux/ioctl.h>
#include <linux/if_ether.h>
#include <linux/types.h>

/* ioctl cmd */
#define BVD_NET_DEV_GET_MC_LIST			_IOR('B', 78, int)
#define BVD_NET_DEV_SET_MC_FILTER		_IOW('B', 79, int)
#define BVD_NET_DEV_SET_PROTO_FILTER	_IOW('B', 80, int)

#define BVD_NET_DEV_MAX_PROTO_FILTER	5
#define BVD_NET_DEV_MAX_MC_FILTER		20
#define BVD_NET_DEV_MAX_NAME_LEN		15

/* status bit */
#define BVD_NET_DEV_BIT_MC_CHANGED    0x0

#define CONFIG_BVD_NET_DEV_MC_FILTER
#define CONFIG_BVD_NET_DEV_PROTO_FILTER

typedef unsigned char	 u8;
typedef u8	 bvd_net_dev_addr[ETH_ALEN];

struct bvd_net_dev_info {
	bvd_net_dev_addr dev_addr;	/* local dev addr */
	char name[BVD_NET_DEV_MAX_NAME_LEN + 1];/* plus 1 for "\0" */
};

struct bvd_net_dev_mc_range {
	bvd_net_dev_addr	start;
	bvd_net_dev_addr	end;
};

struct bvd_net_dev_mc_info {
	unsigned int				count;
	struct bvd_net_dev_mc_range *mc_range_list;
};

struct bvd_net_dev_proto_range {
	unsigned short	start;
	unsigned short	end;
};

struct bvd_net_dev_proto_filter {
	unsigned int count;
	struct bvd_net_dev_proto_range
		proto_range_list[BVD_NET_DEV_MAX_PROTO_FILTER];
};

#ifdef __KERNEL__

int __init bvd_net_dev_init(void);
int bvd_net_dev_exit(void);
#endif	/* ifdef __KERNEL__ */
#endif	/* _BVD_NET_H_ */
