/*******************************************************************************
*    Copyright (c) 2013 Neusoft Co., Ltd.
*    FileName	:	bvd_tty_dev.h
*    Module		:	bvd driver
*    Function	:	bvd driver module use for Neusoft Bluedragon
*					Bluetooth stack.
*-------------------------------------------------------------------------------
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU General Public License as published by
*   the Free Software Foundation; either version 2 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program; if not, write to the Free Software
*   Foundation, Inc..
*******************************************************************************/

#ifndef _BVD_TTY_H_
#define _BVD_TTY_H_
#include "bvd_config.h"

#define BVD_IOCTL_TTY_GET_TIOCM				_IOR('B', 73, long)
#define BVD_IOCTL_TTY_SET_MODEM_STATUS		_IOW('B', 74, int)

#define BVD_TTY_DEV_STATUS_HANGUP		(1 << 0)
#define BVD_TTY_DEV_STATUS_TIOCMSET		(1 << 1)

struct bvd_create_tty_req {
	int id;
};

struct bvd_tty_tiocm {
	unsigned int	set;
	unsigned int	clear;
};

#ifdef __KERNEL__
int bvd_tty_init(void);
void bvd_tty_exit(void);
#endif	/* __KERNEL__ */
#endif	/* _BVD_TTY_H_ */
