/*
 * Intel Broxton-P I2S Machine Driver for IVI reference platform
 *
 * Copyright (C) 2014-2015, Intel Corporation. All rights reserved.
 *
 * Modified from:
 *   Intel Skylake I2S Machine driver
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/module.h>
#include <linux/platform_device.h>
#include <sound/core.h>
#include <sound/pcm.h>
#include <sound/soc.h>
#include <linux/gpio.h>
#include <linux/i2c.h>
#include <sound/pcm_params.h>

static const struct snd_kcontrol_new broxton_controls[] = {
	SOC_DAPM_PIN_SWITCH("Speaker"),
};

static const struct snd_soc_dapm_widget broxton_widgets[] = {
	SND_SOC_DAPM_SPK("testPin1_pt_pb", NULL),
	SND_SOC_DAPM_MIC("testPin1_pt_cp", NULL),
	SND_SOC_DAPM_SPK("testPin2_pt_pb", NULL),
	SND_SOC_DAPM_MIC("testPin2_pt_cp", NULL),
	SND_SOC_DAPM_SPK("testPin3_pt_pb", NULL),
	SND_SOC_DAPM_MIC("testPin3_pt_cp", NULL),
	SND_SOC_DAPM_SPK("testPin4_pt_pb", NULL),
	SND_SOC_DAPM_MIC("testPin4_pt_cp", NULL),
	SND_SOC_DAPM_SPK("testPin5_pt_pb", NULL),
	SND_SOC_DAPM_MIC("testPin5_pt_cp", NULL),
	SND_SOC_DAPM_SPK("testPin6_pt_pb", NULL),
	SND_SOC_DAPM_MIC("testPin6_pt_cp", NULL),
};

static const struct snd_soc_dapm_route broxton_gpmrb_map[] = {

	/* test pin 1  BE connections */
	{ "testPin1_pt_pb", NULL, "ssp0 Tx"},
	{ "ssp0 Tx", NULL, "testPin1_pt_pbId0_in"},

	{ "testPin1_pt_cpId1_in", NULL, "ssp0 Rx"},
	{ "ssp0 Rx", NULL, "testPin1_pt_cp"},

	{ "testPin2_pt_pb", NULL, "ssp1 Tx"},
	{ "ssp1 Tx", NULL, "testPin2_pt_pbId2_in"},

	{ "testPin2_pt_cpId3_in", NULL, "ssp1 Rx"},
	{ "ssp1 Rx", NULL, "testPin2_pt_cp"},

	{ "testPin3_pt_pb", NULL, "ssp2 Tx"},
	{ "ssp2 Tx", NULL, "testPin3_pt_pbId4_in"},

	{ "testPin3_pt_cpId5_in", NULL, "ssp2 Rx"},
	{ "ssp2 Rx", NULL, "testPin3_pt_cp"},

	{ "testPin4_pt_pb", NULL, "ssp3 Tx"},
	{ "ssp3 Tx", NULL, "testPin4_pt_pbId6_in"},

	{ "testPin4_pt_cpId7_in", NULL, "ssp3 Rx"},
	{ "ssp3 Rx", NULL, "testPin4_pt_cp"},

	{ "testPin5_pt_pb", NULL, "ssp4 Tx"},
	{ "ssp4 Tx", NULL, "testPin5_pt_pbId8_in"},

	{ "testPin5_pt_cpId9_in", NULL, "ssp4 Rx"},
	{ "ssp4 Rx", NULL, "testPin5_pt_cp"},

	{ "testPin6_pt_pb", NULL, "ssp5 Tx"},
	{ "ssp5 Tx", NULL, "testPin6_pt_pbId10_in"},

	{ "testPin6_pt_cpId11_in", NULL, "ssp5 Rx"},
	{ "ssp5 Rx", NULL, "testPin6_pt_cp"},
};


static int broxton_gpmrb_hw_params(struct snd_pcm_substream *substream,
				   struct snd_pcm_hw_params *params)
{
	struct snd_soc_pcm_runtime *rtd = substream->private_data;
	int ret = 0;

	return ret;
}

static struct snd_soc_ops broxton_gpmrb_ops = {
	.hw_params = broxton_gpmrb_hw_params,
};

/* broxton digital audio interface glue - connects codec <--> CPU */
static struct snd_soc_dai_link broxton_gpmrb_dais[] = {
	/* Front End DAI links */
	{
		.name = "System pb Pin1 Port",
		.stream_name = "System pb Pin1",
		.cpu_dai_name = "System pb Pin 1",
		.platform_name = "0000:00:0e.0",
		.nonatomic = 1,
		.dynamic = 1,
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.trigger = {SND_SOC_DPCM_TRIGGER_POST, SND_SOC_DPCM_TRIGGER_POST},
		.dpcm_playback = 1,
	},
	{
		.name = "System Pin1 cp Port",
		.stream_name = "System cp Pin1",
		.cpu_dai_name = "System cp Pin 1",
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.platform_name = "0000:00:0e.0",
		.init = NULL,
		.dpcm_capture = 1,
		.ignore_suspend = 1,
		.nonatomic = 1,
		.dynamic = 1,
	},
	{
		.name = "System pb Pin2 Port",
		.stream_name = "System pb Pin2",
		.cpu_dai_name = "System pb Pin 2",
		.platform_name = "0000:00:0e.0",
		.nonatomic = 1,
		.dynamic = 1,
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.trigger = {SND_SOC_DPCM_TRIGGER_POST, SND_SOC_DPCM_TRIGGER_POST},
		.dpcm_playback = 1,
	},
	{
		.name = "System Pin2 cp Port",
		.stream_name = "System cp Pin2",
		.cpu_dai_name = "System cp Pin 2",
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.platform_name = "0000:00:0e.0",
		.init = NULL,
		.dpcm_capture = 1,
		.ignore_suspend = 1,
		.nonatomic = 1,
		.dynamic = 1,
	},
	{
		.name = "System pb Pin3 Port",
		.stream_name = "System pb Pin3",
		.cpu_dai_name = "System pb Pin 3",
		.platform_name = "0000:00:0e.0",
		.nonatomic = 1,
		.dynamic = 1,
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.trigger = {SND_SOC_DPCM_TRIGGER_POST, SND_SOC_DPCM_TRIGGER_POST},
		.dpcm_playback = 1,
	},
	{
		.name = "System Pin3 cp Port",
		.stream_name = "System cp Pin3",
		.cpu_dai_name = "System cp Pin 3",
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.platform_name = "0000:00:0e.0",
		.init = NULL,
		.dpcm_capture = 1,
		.ignore_suspend = 1,
		.nonatomic = 1,
		.dynamic = 1,
	},
	{
		.name = "System pb Pin4 Port",
		.stream_name = "System pb Pin4",
		.cpu_dai_name = "System pb Pin 4",
		.platform_name = "0000:00:0e.0",
		.nonatomic = 1,
		.dynamic = 1,
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.trigger = {SND_SOC_DPCM_TRIGGER_POST, SND_SOC_DPCM_TRIGGER_POST},
		.dpcm_playback = 1,
	},
	{
		.name = "System Pin4 cp Port",
		.stream_name = "System cp Pin4",
		.cpu_dai_name = "System cp Pin 4",
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.platform_name = "0000:00:0e.0",
		.init = NULL,
		.dpcm_capture = 1,
		.ignore_suspend = 1,
		.nonatomic = 1,
		.dynamic = 1,
	},
	{
		.name = "System pb Pin5 Port",
		.stream_name = "System pb Pin5",
		.cpu_dai_name = "System pb Pin 5",
		.platform_name = "0000:00:0e.0",
		.nonatomic = 1,
		.dynamic = 1,
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.trigger = {SND_SOC_DPCM_TRIGGER_POST, SND_SOC_DPCM_TRIGGER_POST},
		.dpcm_playback = 1,
	},
	{
		.name = "System Pin5 cp Port",
		.stream_name = "System cp Pin5",
		.cpu_dai_name = "System cp Pin 5",
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.platform_name = "0000:00:0e.0",
		.init = NULL,
		.dpcm_capture = 1,
		.ignore_suspend = 1,
		.nonatomic = 1,
		.dynamic = 1,
	},
	{
		.name = "System pb Pin6 Port",
		.stream_name = "System pb Pin6",
		.cpu_dai_name = "System pb Pin 6",
		.platform_name = "0000:00:0e.0",
		.nonatomic = 1,
		.dynamic = 1,
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.trigger = {SND_SOC_DPCM_TRIGGER_POST, SND_SOC_DPCM_TRIGGER_POST},
		.dpcm_playback = 1,
	},
	{
		.name = "System Pin6 cp Port",
		.stream_name = "System cp Pin6",
		.cpu_dai_name = "System cp Pin 6",
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.platform_name = "0000:00:0e.0",
		.init = NULL,
		.dpcm_capture = 1,
		.ignore_suspend = 1,
		.nonatomic = 1,
		.dynamic = 1,
	},
	/* Back End DAI links */
	{
		/* SSP0 - BT */
		.name = "SSP0-Codec",
		.cpu_dai_name = "SSP0 Pin",
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.platform_name = "0000:00:0e.0",
		.ignore_suspend = 1,
		.dpcm_capture = 1,
		.dpcm_playback = 1,
		.no_pcm = 1,
	},
	{
		/* SSP1 - HDMI-In */
		.name = "SSP1-Codec",
		.cpu_dai_name = "SSP1 Pin",
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.platform_name = "0000:00:0e.0",
		.ignore_suspend = 1,
		.dpcm_playback = 1,
		.dpcm_capture = 1,
		.no_pcm = 1,
	},
	{
		/* SSP2 - Dirana */
		.name = "SSP2-Codec",
		.cpu_dai_name = "SSP2 Pin",
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.platform_name = "0000:00:0e.0",
		.ignore_suspend = 1,
		.dpcm_capture = 1,
		.dpcm_playback = 1,
		.no_pcm = 1,
	},
	{
		/* SSP3 - Modem */
		.name = "SSP3-Codec",
		.cpu_dai_name = "SSP3 Pin",
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.platform_name = "0000:00:0e.0",
		.ignore_suspend = 1,
		.dpcm_capture = 1,
		.dpcm_playback = 1,
		.no_pcm = 1,
	},
	{
		/* SSP4 - Amplifier */
		.name = "SSP4-Codec",
		.cpu_dai_name = "SSP4 Pin",
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.platform_name = "0000:00:0e.0",
		.ignore_suspend = 1,
		.dpcm_playback = 1,
		.dpcm_capture = 1,
		.no_pcm = 1,
	},
	{
		/* SSP5 - TestPin */
		.name = "SSP5-Codec",
		.cpu_dai_name = "SSP5 Pin",
		.codec_name = "snd-soc-dummy",
		.codec_dai_name = "snd-soc-dummy-dai",
		.platform_name = "0000:00:0e.0",
		.ignore_suspend = 1,
		.dpcm_capture = 1,
		.dpcm_playback = 1,
		.no_pcm = 1,
	},
};

/* broxton audio machine driver for SPT + RT298S */
static struct snd_soc_card broxton_gpmrb = {
	.name = "broxton-hsboard",
	.owner = THIS_MODULE,
	.dai_link = broxton_gpmrb_dais,
	.num_links = ARRAY_SIZE(broxton_gpmrb_dais),
	.controls = broxton_controls,
	.num_controls = ARRAY_SIZE(broxton_controls),
	.dapm_widgets = broxton_widgets,
	.num_dapm_widgets = ARRAY_SIZE(broxton_widgets),
	.dapm_routes = broxton_gpmrb_map,
	.num_dapm_routes = ARRAY_SIZE(broxton_gpmrb_map),
	.fully_routed = true,
};

static int broxton_audio_probe(struct platform_device *pdev)
{
	broxton_gpmrb.dev = &pdev->dev;
	return snd_soc_register_card(&broxton_gpmrb);
}

static int broxton_audio_remove(struct platform_device *pdev)
{
	snd_soc_unregister_card(&broxton_gpmrb);
	return 0;
}

static struct platform_driver broxton_audio = {
	.probe = broxton_audio_probe,
	.remove = broxton_audio_remove,
	.driver = {
		.name = "hsboard_machine",
	},
};

module_platform_driver(broxton_audio)

/* Module information */
MODULE_DESCRIPTION("Intel SST Audio for Broxton HS IF Test Board");
MODULE_LICENSE("GPL v2");
MODULE_ALIAS("platform:hsboard_machine");
