
/*
 *  skl-compress.h - Skylake compress header file
 *
 *  Copyright (C) 2015-16 Intel Corp
 *  Author: Divya Prakash <divya1.prakash@intel.com>
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 * ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *
 */

#ifndef __SKL_COMPRESS_H__
#define __SKL_COMPRESS_H__

#include <sound/soc.h>
#include <sound/memalloc.h>
#include "skl.h"

static inline
struct hdac_ext_stream *get_hdac_ext_compr_stream(struct snd_compr_stream *stream)
{
	return stream->runtime->private_data;
}

struct hdac_ext_bus *get_bus_compr_ctx(struct snd_compr_stream *substream);
int skl_substream_alloc_compr_pages(struct hdac_ext_bus *ebus,
				 struct snd_compr_stream *substream,
				 size_t size);
int skl_substream_free_compr_pages(struct hdac_bus *bus,
				struct snd_compr_stream *substream);
#endif
