/*
 * $QNXLicenseC:
 * Copyright 2007, QNX Software Systems. All Rights Reserved.
 *
 * You must obtain a written license from and pay applicable license fees to QNX
 * Software Systems before you may reproduce, modify or distribute this software,
 * or any work that includes all or part of this software.   Free development
 * licenses are available for evaluation and non-commercial purposes.  For more
 * information visit http://licensing.qnx.com or email licensing@qnx.com.
 *
 * This file may contain contributions from others.  Please review this entire
 * file for other proprietary rights or license notices, as well as the QNX
 * Development Suite License Guide at http://licensing.qnx.com/license-guide/
 * for other information.
 * $
 */

// Workaround for the fact that snd_pcm_info is the name of both a struct and a function in asound
// and the name of a conflicting function in alsa
#define		SND_PCM_IOCTL_INFO_ALSA				_IOR ('A', 0x20, ioaudio_snd_pcm_info_t)
#define		SND_CTL_IOCTL_PCM_INFO_ALSA			_IOR ('C', 0x53, ioaudio_snd_pcm_info_t)

#include <sys/asound_common.h>
#include <alsa/asoundlib.h>
#include "pcm_internal.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>

int snd_card_load(int card)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_card_next(int *card)
{
    char buf[17+10+1];
    struct stat b;
    snprintf(buf, sizeof(buf), "/dev/snd/controlC%d", (*card)+1);
    if( stat(buf, &b) == EOK ) {
        (*card)++;
    } else {
        *card = -1;
    }
    return 0;
}

int snd_card_get_index(const char *name)
{
    int card;
    if( sscanf(name, "/dev/snd/controlC%d", &card) ) {
        return card;
    }

    return -ENODEV;
}

int snd_card_get_name(int card, char **name)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_card_get_longname(int card, char **name)
{
    UNIMPLEMENTED;
    return 0;
}

#ifdef __QNX__
int snd_device_name_hint(int card, const char *iface, void ***hints)
{
    int fd;
    int len;
    int status = EOK;
    char buf[14];
    int count = 1;
    void **ret = NULL;
    void **new_ret;
    char *hint;
    char *target;
    char path[FILENAME_MAX];
    char sym_path[FILENAME_MAX+1];
    int sym_len;
    ioaudio_snd_pcm_info_t info;

    // Iterate through files in /dev looking for pcmC%d
    struct dirent *de;
    DIR *dir = opendir("/dev/snd");
    if( dir == NULL ) {
        return -EINVAL;
    }
    if( card == -1 ) {
        len = snprintf(buf, sizeof(buf), "%s", iface);
    } else {
        len = snprintf(buf, sizeof(buf), "%sC%d", iface, card);
    }
    ret = malloc( sizeof(void *) );
    if( ret == NULL ) {
        closedir(dir);
        return -ENOMEM;
    }

    while( (de = readdir(dir)) != NULL ) {
        // See if the name matches the pattern
        // or if the name is a symlink to a name that mathces the pattern
        snprintf(sym_path, sizeof(sym_path), "/dev/snd/%s", de->d_name);
        sym_len = readlink(sym_path, sym_path, FILENAME_MAX);
        if( sym_len > 0 ) {
            sym_path[sym_len] = 0;
            target = sym_path;
        } else {
            continue;
        }
        if( !strncmp(target, buf, len) ) {
            snprintf(path, FILENAME_MAX, "/dev/snd/%s", de->d_name);
            fd = open(path, O_RDWR);
            if( fd < 0 ) {
                continue;
            }
            if (ioctl (fd, SND_PCM_IOCTL_INFO_ALSA, &info) < 0) {
                close(fd);
                continue;
            }
            close(fd);
            count ++;
            hint = malloc(2+strlen(de->d_name)+strlen(info.name)+1);
            if( hint == NULL ) {
                continue;
            }
            // Hint protocol:
            // 1st byte indicates playback or capture
            // 2nd byte indicates the size of the name
            // name
            // null terminator
            // description
            // null terminator
            hint[1] = strlen(de->d_name);
            hint[0] = de->d_name[hint[1]-1];
            strcpy(hint+2, de->d_name);
            // Wipe off the trailing playback/capture indicator
            hint[hint[1]+1] = 0;
            strcpy(hint+2+hint[1], info.name);
            new_ret = realloc( ret, sizeof(void *) * count );
            if( new_ret == NULL ) {
                free( hint );
                break;
            }
            ret = new_ret;
            ret[count-2] = hint;
        }
    }

    closedir(dir);
    *hints = ret;
    ret[count-1] = NULL;
    return status;
}
int snd_device_name_free_hint(void **hints)
{
    void **i;
    for(i = hints; (*i) != NULL; i ++ ) {
        free( *i );
    }
    free( hints );
    return EOK;
}

char *snd_device_name_get_hint(const void *hint, const char *id)
{
    const char *prefix="name=plug,slave={name=rate,slave={name=hw,device=%s}}";
    char *hintbuf = (char *)hint;

    if( !strcmp(id, "NAME") ) {
        char *ret = malloc(hintbuf[1]+strlen(prefix)-2+1);
        if( ret  ) {
            sprintf(ret, prefix, hintbuf+2);
        }
        return ret;
    } else if( !strcmp(id, "DESC") ) {
        return strdup(hintbuf+hintbuf[1]+2);
    } else {
        switch( hintbuf[0] ) {
            case 'c':
                return strdup("Input");
            case 'p':
                return strdup("Output");
        }
    }

    return NULL;
}

#else
// On non-QNX, hardcode to report just the file and sine_generator plugin
int snd_device_name_hint(int card, const char *iface, void ***hints)
{
    *hints = malloc(sizeof(char *)*3);
    if( *hints ) {
        (*hints)[0] = "pfile";
        (*hints)[1] = "csine_generator";
        (*hints)[2] = NULL;
        return EOK;
    } else {
        return -ENOMEM;
    }
}

int snd_device_name_free_hint(void **hints)
{
    free(hints);
    return EOK;
}

char *snd_device_name_get_hint(const void *hint, const char *id)
{
    const char *prefix="name=plug,slave={name=rate,slave={name=%s}}";
    char *hintbuf = (char *)hint;

    if( !strcmp(id, "NAME") ) {
        char *ret = malloc(strlen(hint)-1+strlen(prefix)-1);
        if( ret  ) {
            sprintf(ret, prefix, hintbuf+1);
        }
        return ret;
    } else if( !strcmp(id, "DESC") ) {
        return strdup("Default endpoint");
    } else {
        switch( hintbuf[0] ) {
            case 'c':
                return strdup("Input");
            case 'p':
                return strdup("Output");
        }
    }

    return NULL;
}

#endif

int snd_ctl_open(snd_ctl_t **ctl, const char *name, int mode)
{
    int flags;
    snd_ctl_t *ret;
    char *buf;
    int length;

    ret = calloc(1, sizeof(snd_ctl_t));

    if( ret == NULL ) {
        return -ENOMEM;
    }

    if( mode & SND_CTL_READONLY ) {
        flags = O_RDONLY;
    } else {
        flags = O_RDWR;
    }
    if( mode & SND_CTL_NONBLOCK ) {
        flags |= O_NONBLOCK;
    }
    if( mode & SND_CTL_ASYNC ) {
        flags |= O_ASYNC;
    }
    length = strlen(name);

    // Swap "hw:" for "/dev/snd/controlC"
    buf = alloca(length - 3 + 17 + 1);
    if( buf == NULL ) {
        free( ret );
        return -ENOMEM;
    }
    memcpy(buf, "/dev/snd/controlC", 17);
    memcpy(buf + 17, name + 3, length - 3 + 1);

    ret->fd = open(buf, flags);

    if( ret->fd == -1 ) {
        free( ret );
        return -errno;
    }

    *ctl = ret;
    return EOK;
}

int snd_ctl_open_lconf(snd_ctl_t **ctl, const char *name, int mode, snd_config_t *lconf)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_open_fallback(snd_ctl_t **ctl, snd_config_t *root, const char *name, const char *orig_name, int mode)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_close(snd_ctl_t *ctl)
{
    int ret;
    ret = close( ctl->fd );
    free( ctl );

    return ret;
}

int snd_ctl_nonblock(snd_ctl_t *ctl, int nonblock)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_async_add_ctl_handler(snd_async_handler_t **handler, snd_ctl_t *ctl,
                          snd_async_callback_t callback, void *private_data)
{
    UNIMPLEMENTED;
    return 0;
}

snd_ctl_t *snd_async_handler_get_ctl(snd_async_handler_t *handler)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_poll_descriptors_count(snd_ctl_t *ctl)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_poll_descriptors(snd_ctl_t *ctl, struct pollfd *pfds, unsigned int space)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_poll_descriptors_revents(snd_ctl_t *ctl, struct pollfd *pfds, unsigned int nfds, unsigned short *revents)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_subscribe_events(snd_ctl_t *ctl, int subscribe)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_card_info(snd_ctl_t *ctl, snd_ctl_card_info_t *info)
{
    if( ioctl(ctl->fd, SND_CTL_IOCTL_HW_INFO, &info->hwinfo) < 0 ) {
        return -errno;
    }

    return EOK;
}

int snd_ctl_elem_list(snd_ctl_t *ctl, snd_ctl_elem_list_t *list)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_elem_info(snd_ctl_t *ctl, snd_ctl_elem_info_t *info)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_elem_read(snd_ctl_t *ctl, snd_ctl_elem_value_t *value)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_elem_write(snd_ctl_t *ctl, snd_ctl_elem_value_t *value)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_elem_lock(snd_ctl_t *ctl, snd_ctl_elem_id_t *id)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_elem_unlock(snd_ctl_t *ctl, snd_ctl_elem_id_t *id)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_elem_tlv_read(snd_ctl_t *ctl, const snd_ctl_elem_id_t *id,
                      unsigned int *tlv, unsigned int tlv_size)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_elem_tlv_write(snd_ctl_t *ctl, const snd_ctl_elem_id_t *id,
                       const unsigned int *tlv)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_elem_tlv_command(snd_ctl_t *ctl, const snd_ctl_elem_id_t *id,
                         const unsigned int *tlv)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_ctl_pcm_next_device(snd_ctl_t *ctl, int *device)
{
    int32_t dev = *device + 1;
    if( ioctl (ctl->fd, SND_CTL_IOCTL_PCM_DEVICE, &dev) < 0 ) {
        if( errno == EINVAL ) {
            *device = -1;
            return EOK;
        } else {
            return -errno;
        }
    }

    *device = dev;

    return EOK;
}

int snd_ctl_pcm_info(snd_ctl_t *ctl, snd_pcm_info_t * info)
{
    ioctl (ctl->fd, SND_CTL_IOCTL_PCM_DEVICE, &info->dev);
    ioctl (ctl->fd, SND_CTL_IOCTL_PCM_SUBDEVICE, &info->subdev);
    ioctl (ctl->fd, SND_CTL_IOCTL_PCM_CHANNEL, &info->stream);

    if( ioctl (ctl->fd, SND_CTL_IOCTL_PCM_INFO_ALSA, &info->pcminfo) < 0 ) {
        return -errno;
    }
    if (ioctl (ctl->fd, SND_CTL_IOCTL_PCM_CHANNEL_INFO, &info->chaninfo) < 0) {
        return -errno;
    }

    return EOK;
}

int snd_ctl_pcm_prefer_subdevice(snd_ctl_t *ctl, int subdev)
{
    UNIMPLEMENTED;
    return 0;
}

size_t snd_ctl_card_info_sizeof(void)
{
    return sizeof(snd_ctl_card_info_t);
}

int snd_ctl_card_info_malloc(snd_ctl_card_info_t **ptr)
{
    UNIMPLEMENTED;
    return 0;
}

void snd_ctl_card_info_free(snd_ctl_card_info_t *obj)
{
    free( obj );
}

void snd_ctl_card_info_clear(snd_ctl_card_info_t *obj)
{
    UNIMPLEMENTED;
}

void snd_ctl_card_info_copy(snd_ctl_card_info_t *dst, const snd_ctl_card_info_t *src)
{
    UNIMPLEMENTED;
}

int snd_ctl_card_info_get_card(const snd_ctl_card_info_t *obj)
{
    UNIMPLEMENTED;
    return 0;
}

const char *snd_ctl_card_info_get_id(const snd_ctl_card_info_t *obj)
{
    return obj->hwinfo.id;
}

const char *snd_ctl_card_info_get_driver(const snd_ctl_card_info_t *obj)
{
    UNIMPLEMENTED;
    return 0;
}

const char *snd_ctl_card_info_get_name(const snd_ctl_card_info_t *obj)
{
    return obj->hwinfo.name;
}

const char *snd_ctl_card_info_get_longname(const snd_ctl_card_info_t *obj)
{
    UNIMPLEMENTED;
    return 0;
}

const char *snd_ctl_card_info_get_mixername(const snd_ctl_card_info_t *obj)
{
    UNIMPLEMENTED;
    return 0;
}

const char *snd_ctl_card_info_get_components(const snd_ctl_card_info_t *obj)
{
    UNIMPLEMENTED;
    return 0;
}

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn/product/branches/7.0.0/trunk/lib/asound/alsa/control_alsa.c $ $Rev: 781520 $")
#endif
