#ifndef __SLOG2_H__
#define __SLOG2_H__

#define SLOG2_SHUTDOWN  0
#define SLOG2_CRITICAL  1
#define SLOG2_ERROR     2
#define SLOG2_WARNING   3
#define SLOG2_NOTICE    4
#define SLOG2_INFO      5
#define SLOG2_DEBUG1    6
#define SLOG2_DEBUG2    7

#define slog2f(a, b, c, d, ...) if(c <= slog2_get_verbosity(0)) {printf(d, __VA_ARGS__); printf("\n");}
#define vslog2f(a, b, c, d, ...) if(c <= slog2_get_verbosity(0)) {printf(d, __VA_ARGS__); printf("\n");}
#define slog2fa(a, b, c, d, ...) if(c <= slog2_get_verbosity(0)) {printf(d, __VA_ARGS__); printf("\n");}
#define vslog2fa(a, b, c, d, ...) if(c <= slog2_get_verbosity(0)) {printf(d, __VA_ARGS__); printf("\n");}
#define slog2c(a, b, c, d) if(c <= slog2_get_verbosity(0)) {printf(d); printf("\n");}

#define SLOG2_FA_UNSIGNED(x) x
#define SLOG2_FA_SIGNED(x) x
#define SLOG2_FA_CHAR(x) x
#define SLOG2_FA_FLOAT(x) x
#define SLOG2_FA_DOUBLE(x) x
#define SLOG2_FA_STRING(x) x
#define SLOG2_FA_STAR(x) x
#define SLOG2_FA_END 0

typedef int slog2_buffer_t;

typedef struct
{
    const char    *buffer_name;
    int            num_pages;
} slog2_buffer_config_t;

typedef struct
{
    int                   num_buffers;
    const char           *buffer_set_name;
    int               verbosity_level;
    slog2_buffer_config_t buffer_config[ 4 ];
} slog2_buffer_set_config_t;

int slog2_register( const slog2_buffer_set_config_t *__config,
                    slog2_buffer_t *__handles,
                    int __flags );

int slog2_set_verbosity( slog2_buffer_t __buffer,
                         int __verbosity );

slog2_buffer_t slog2_set_default_buffer( slog2_buffer_t __buffer );

int slog2_get_verbosity( slog2_buffer_t __buffer );

#endif

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn/product/branches/7.0.0/trunk/lib/asound/alsa/linux/x86/so.g/sys/slog2.h $ $Rev: 756969 $")
#endif
