/*
 * $QNXLicenseC:
 * Copyright 2007, QNX Software Systems. All Rights Reserved.
 * 
 * You must obtain a written license from and pay applicable license fees to QNX 
 * Software Systems before you may reproduce, modify or distribute this software, 
 * or any work that includes all or part of this software.   Free development 
 * licenses are available for evaluation and non-commercial purposes.  For more 
 * information visit http://licensing.qnx.com or email licensing@qnx.com.
 *  
 * This file may contain contributions from others.  Please review this entire 
 * file for other proprietary rights or license notices, as well as the QNX 
 * Development Suite License Guide at http://licensing.qnx.com/license-guide/ 
 * for other information.
 * $
 */

#include <sys/asound_common.h>
#include <alsa/asoundlib.h>
#include "pcm_internal.h"

struct _snd_output {
    FILE *fp;
    int close;
};

int snd_output_stdio_attach(snd_output_t **outputp, FILE *fp, int _close)
{
    *outputp = calloc(1, sizeof(snd_output_t));
    if( *outputp == NULL ) {
        return ENOMEM;
    }
    (*outputp)->fp = fp;
    (*outputp)->close = _close;

    return EOK;
}

int snd_output_close(snd_output_t *output)
{
    if( output->close ) {
        fclose( output->fp );
    }
    free( output );

    return EOK;
}

int snd_output_printf(snd_output_t *output, const char *format, ...)
{
    va_list ap;
    va_start(ap, format);
    vfprintf(output->fp, format, ap);
    va_end(ap);
    return EOK;
}

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn/product/branches/7.0.0/trunk/lib/asound/alsa/output.c $ $Rev: 781520 $")
#endif
