/*
 * $QNXLicenseC:
 * Copyright 2007, QNX Software Systems. All Rights Reserved.
 * 
 * You must obtain a written license from and pay applicable license fees to QNX 
 * Software Systems before you may reproduce, modify or distribute this software, 
 * or any work that includes all or part of this software.   Free development 
 * licenses are available for evaluation and non-commercial purposes.  For more 
 * information visit http://licensing.qnx.com or email licensing@qnx.com.
 *  
 * This file may contain contributions from others.  Please review this entire 
 * file for other proprietary rights or license notices, as well as the QNX 
 * Development Suite License Guide at http://licensing.qnx.com/license-guide/ 
 * for other information.
 * $
 */

#include <sys/asound_common.h>
#include <alsa/asoundlib.h>
#include "pcm_internal.h"

size_t snd_pcm_info_sizeof(void)
{
    return sizeof(snd_pcm_info_t);
}

int snd_pcm_info_malloc(snd_pcm_info_t **ptr)
{
    UNIMPLEMENTED;
    return 0;
}

void snd_pcm_info_free(snd_pcm_info_t *obj)
{
    UNIMPLEMENTED;
}

void snd_pcm_info_copy(snd_pcm_info_t *dst, const snd_pcm_info_t *src)
{
    UNIMPLEMENTED;
}

unsigned int snd_pcm_info_get_device(const snd_pcm_info_t *obj)
{
    UNIMPLEMENTED;
    return 0;
}

unsigned int snd_pcm_info_get_subdevice(const snd_pcm_info_t *obj)
{
    UNIMPLEMENTED;
    return 0;
}

snd_pcm_stream_t snd_pcm_info_get_stream(const snd_pcm_info_t *obj)
{
    UNIMPLEMENTED;
    return 0;
}

int snd_pcm_info_get_card(const snd_pcm_info_t *obj)
{
    UNIMPLEMENTED;
    return 0;
}

const char *snd_pcm_info_get_id(const snd_pcm_info_t *obj)
{
    return (char *)obj->pcminfo.id;
}

const char *snd_pcm_info_get_name(const snd_pcm_info_t *obj)
{
    return obj->pcminfo.name;
}

const char *snd_pcm_info_get_subdevice_name(const snd_pcm_info_t *obj)
{
    return obj->chaninfo.subname;
}

snd_pcm_class_t snd_pcm_info_get_class(const snd_pcm_info_t *obj)
{
    UNIMPLEMENTED;
    return 0;
}

snd_pcm_subclass_t snd_pcm_info_get_subclass(const snd_pcm_info_t *obj)
{
    UNIMPLEMENTED;
    return 0;
}

unsigned int snd_pcm_info_get_subdevices_count(const snd_pcm_info_t *obj)
{
    if( obj->stream == SND_PCM_STREAM_PLAYBACK ) {
        return obj->pcminfo.playback+1;
    } else if( obj->stream == SND_PCM_STREAM_CAPTURE ) {
        return obj->pcminfo.capture+1;
    } else {
        return 0;
    }
}

unsigned int snd_pcm_info_get_subdevices_avail(const snd_pcm_info_t *obj)
{
    return snd_pcm_info_get_subdevices_count(obj);
}

snd_pcm_sync_id_t snd_pcm_info_get_sync(const snd_pcm_info_t *obj)
{
    snd_pcm_sync_id_t syncid;
    memset(&syncid, 0, sizeof(syncid));
    UNIMPLEMENTED;
    return syncid;
}

void snd_pcm_info_set_device(snd_pcm_info_t *obj, unsigned int val)
{
    obj->dev = val;
}

void snd_pcm_info_set_subdevice(snd_pcm_info_t *obj, unsigned int val)
{
    obj->subdev = val;
}

void snd_pcm_info_set_stream(snd_pcm_info_t *obj, snd_pcm_stream_t val)
{
    obj->stream = val;
}

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn/product/branches/7.0.0/trunk/lib/asound/alsa/pcm_info.c $ $Rev: 781520 $")
#endif
