#ifndef __PCM_INTERNAL_H__
#define __PCM_INTERNAL_H__

#include <poll.h>
#include <stdio.h>
#include <sys/types.h>
#include <stdint.h>
#include <stdarg.h>
#include <alsa/input.h>
#include <alsa/output.h>
#include <alsa/conf.h>
#include <alsa/global.h>
#include <alsa/pcm.h>
#include <sys/asound_common.h>
#include <alsa/pcm_extplug.h>
#include <alsa/pcm_ioplug.h>
#include <alsa/pcm_rate.h>

#define _BITS_BYTE  8

#ifndef MIN
#define MIN(x,y) ((x)<(y)?(x):(y))
#endif
#ifndef MAX
#define MAX(x,y) ((x)>(y)?(x):(y))
#endif
#define IS_POWER_OF_TWO(x) (!((x) & ((x) - 1)))

#ifndef __QNX__
#define __SRCVERSION(x)
#endif

#define UNIMPLEMENTED   printf("%s not implemented\n", __FUNCTION__);

typedef struct snd_pcm_rateplug snd_pcm_rateplug_t;

typedef struct _snd_pcm_plugin_callbacks {
    int (*close)(snd_pcm_t *pcm);
    snd_pcm_sframes_t (*readi)(snd_pcm_t *pcm, void *buffer, snd_pcm_uframes_t size);
    snd_pcm_sframes_t (*writei)(snd_pcm_t *pcm, const void *buffer, snd_pcm_uframes_t size);
    snd_pcm_sframes_t (*readn)(snd_pcm_t *pcm, void **buffs, snd_pcm_uframes_t size);
    snd_pcm_sframes_t (*writen)(snd_pcm_t *pcm, void **buffs, snd_pcm_uframes_t size);
    snd_pcm_sframes_t (*avail)(snd_pcm_t *pcm);
    snd_pcm_sframes_t (*avail_update)(snd_pcm_t *pcm);
    snd_pcm_chmap_query_t **(*query_chmaps)(snd_pcm_t *pcm);
    snd_pcm_chmap_t *(*get_chmap)(snd_pcm_t *ext);
    int (*set_chmap)(snd_pcm_t *ext, const snd_pcm_chmap_t *map);
    int (*recover)(snd_pcm_t *pcm, int err, int silent);
    int (*drain)(snd_pcm_t *pcm);
    int (*drop)(snd_pcm_t *pcm);
    int (*reset)(snd_pcm_t *pcm);
    int (*start)(snd_pcm_t *pcm);
    int (*prepare)(snd_pcm_t *pcm);
    int (*resume)(snd_pcm_t *pcm);
    int (*nonblock)(snd_pcm_t *pcm, int nonblock);
    int (*status)(snd_pcm_t *pcm, snd_pcm_status_t *status);
    int (*hw_params)(snd_pcm_t *pcm, snd_pcm_hw_params_t *params);
    int (*sw_params)(snd_pcm_t *pcm, snd_pcm_sw_params_t *params);
    int (*hw_params_any)(snd_pcm_t *pcm, snd_pcm_hw_params_t *params);
    int (*sw_params_any)(snd_pcm_t *pcm, snd_pcm_sw_params_t *params);
    int (*set_rate_resample)(snd_pcm_t *pcm, snd_pcm_hw_params_t *params, unsigned int val);
    int (*poll_descriptors_count)(snd_pcm_t *pcm);
    int (*poll_descriptors)(snd_pcm_t *pcm, struct pollfd *pfds, unsigned int space);
} snd_pcm_plugin_callbacks_t;

typedef enum {
    PARAM_RATE_SET,
    PARAM_VOICE_SET,
    PARAM_FORMAT_SET,
    PARAM_ACCESS_SET,
    PARAM_PERIOD_SET,
    PARAM_PERIOD_COUNT_SET,
    PARAM_BUFFER_SET,
} params_set_t;

struct _snd_pcm_hw_params {
    // Contains the list of supported rates. Only allocated if a list of
    // rates is supported, rather than a range of rates
    int *rates;
    // Number of rates supportes
    int rate_count;
    // Min and max rates are used when a range of rates are supported
    // where any rate in the range is legal
    unsigned int rate_min;
    unsigned int rate_max;
    // Bitmask of the number of voices supported. 1 << N is set if N voices are
    // supported
    int channels;
    int access_modes;
    int formats;
    snd_pcm_format_t format;
    snd_pcm_start_t startmode;
    // Number of voices supported. This is only set if there is a specific
    // number of voices supported, if multiple numbers are supported, this
    // is set to 0
    int voices;
    int rate;
    int buffer_time;
    unsigned int period_bytes_min;
    unsigned int period_bytes_max;
    unsigned int buffer_bytes_min;
    unsigned int buffer_bytes_max;
    unsigned int periods_min;
    unsigned int periods_max;
    uint32_t params_set;
    struct _snd_pcm_hw_params *parent;
};

struct _snd_pcm_access_mask {
    unsigned char data;
};

struct _snd_pcm_format_mask {
    uint32_t data;
};

struct _snd_pcm_sw_params {
    int start_threshold;
};

struct _snd_pcm {
    int stream;
    char *name;
    snd_pcm_plugin_callbacks_t *callbacks;
    union {
        snd_pcm_ioplug_t *ioplug;
        snd_pcm_rateplug_t *rateplug;
        snd_pcm_extplug_t *extplug;
    } callback_param;
    struct _snd_pcm_hw_params hw_params;
    struct _snd_pcm_sw_params sw_params;
    void *private_data;
};

struct _snd_pcm_info {
    unsigned int dev;
    unsigned int subdev;
    snd_pcm_stream_t stream;
    ioaudio_snd_pcm_info_t pcminfo;
    snd_pcm_channel_info_t chaninfo;
};

struct _snd_ctl_card_info {
    snd_ctl_hw_info_t hwinfo;
};

struct _snd_ctl {
    int fd;
};

struct _snd_pcm_status {
    int status;
    struct timeval start;
    struct timeval now;
    snd_pcm_sframes_t delay;
};


int snd_pcm_open_config(snd_pcm_t **pcmp, snd_config_t *root, snd_config_t *slave_conf, snd_pcm_stream_t stream, int mode);
int snd_pcm_area_size(snd_pcm_channel_area_t *area, int size, int channels, snd_pcm_format_t format);
int snd_pcm_is_interleaved_access_type(snd_pcm_access_t access);
int snd_pcm_allocate_pcm( snd_pcm_t **pcmp, snd_pcm_plugin_callbacks_t *callbacks );
int snd_pcm_destroy_pcm( snd_pcm_t *pcmp );
int snd_pcm_load_plugin( snd_pcm_t **pcmp, const char *name, snd_pcm_stream_t stream, int mode );
int snd_pcm_load_plugin_config( snd_pcm_t **pcmp, snd_config_t *root, snd_config_t *slave_conf, snd_pcm_stream_t stream, int mode );
int (*snd_pcm_get_rate_plugin( const char *name ))(unsigned int, void **, snd_pcm_rate_ops_t *);
void update_formats(snd_pcm_hw_params_t *params);
void update_channels(snd_pcm_hw_params_t *params);
const snd_pcm_hw_params_t *find_params_setting( const snd_pcm_hw_params_t *params, params_set_t param );
unsigned int transform_buffer_size( const snd_pcm_hw_params_t *start, const snd_pcm_hw_params_t *end, unsigned int size );

#endif /* __PCM_INTERNAL_H__ */

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn/product/branches/7.0.0/trunk/lib/asound/alsa/pcm_internal.h $ $Rev: 759464 $")
#endif
