/*
 * $QNXLicenseC:
 * Copyright 2007, QNX Software Systems. All Rights Reserved.
 * 
 * You must obtain a written license from and pay applicable license fees to QNX 
 * Software Systems before you may reproduce, modify or distribute this software, 
 * or any work that includes all or part of this software.   Free development 
 * licenses are available for evaluation and non-commercial purposes.  For more 
 * information visit http://licensing.qnx.com or email licensing@qnx.com.
 *  
 * This file may contain contributions from others.  Please review this entire 
 * file for other proprietary rights or license notices, as well as the QNX 
 * Development Suite License Guide at http://licensing.qnx.com/license-guide/ 
 * for other information.
 * $
 */

#include <sys/asound_common.h>
#include <alsa/asoundlib.h>
#include "pcm_internal.h"

size_t snd_pcm_status_sizeof(void)
{
    return sizeof(snd_pcm_status_t);
}

int snd_pcm_status_malloc(snd_pcm_status_t **ptr)
{
    *ptr = malloc(sizeof(snd_pcm_status_t));
    if( *ptr != NULL ) {
        return EOK;
    } else {
        return -ENOMEM;
    }
}

void snd_pcm_status_free(snd_pcm_status_t *obj)
{
    free(obj);
}

void snd_pcm_status_copy(snd_pcm_status_t *dst, const snd_pcm_status_t *src)
{
    memcpy(dst, src, sizeof(snd_pcm_status_t));
}

snd_pcm_state_t snd_pcm_status_get_state(const snd_pcm_status_t *obj)
{
    return obj->status;
}

void snd_pcm_status_get_trigger_tstamp(const snd_pcm_status_t *obj, snd_timestamp_t *ptr)
{
    ptr->tv_sec = obj->start.tv_sec;
    ptr->tv_usec = obj->start.tv_usec;
}

void snd_pcm_status_get_trigger_htstamp(const snd_pcm_status_t *obj, snd_htimestamp_t *ptr)
{
    ptr->tv_sec = obj->start.tv_sec;
    ptr->tv_nsec = obj->start.tv_usec * 1000;
}

void snd_pcm_status_get_tstamp(const snd_pcm_status_t *obj, snd_timestamp_t *ptr)
{
    ptr->tv_sec = obj->now.tv_sec;
    ptr->tv_usec = obj->now.tv_usec;
}

void snd_pcm_status_get_htstamp(const snd_pcm_status_t *obj, snd_htimestamp_t *ptr)
{
    ptr->tv_sec = obj->now.tv_sec;
    ptr->tv_nsec = obj->now.tv_usec * 1000;
}

void snd_pcm_status_get_audio_htstamp(const snd_pcm_status_t *obj, snd_htimestamp_t *ptr)
{
    // FIXME - What is the difference between this and snd_pcm_status_get_htstamp?
    ptr->tv_sec = obj->now.tv_sec;
    ptr->tv_nsec = obj->now.tv_usec * 1000;
}

snd_pcm_sframes_t snd_pcm_status_get_delay(const snd_pcm_status_t *obj)
{
    return obj->delay;
}

snd_pcm_uframes_t snd_pcm_status_get_avail(const snd_pcm_status_t *obj)
{
    UNIMPLEMENTED;
    return 0;
}

snd_pcm_uframes_t snd_pcm_status_get_avail_max(const snd_pcm_status_t *obj)
{
    UNIMPLEMENTED;
    return 0;
}

snd_pcm_uframes_t snd_pcm_status_get_overrange(const snd_pcm_status_t *obj)
{
    UNIMPLEMENTED;
    return 0;
}

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn/product/branches/7.0.0/trunk/lib/asound/alsa/status.c $ $Rev: 781520 $")
#endif
