ROOT_DIR=libasound-lgpl

ifndef QCONFIG
QCONFIG=qconfig.mk
endif
include $(QCONFIG)

define PINFO
PINFO DESCRIPTION=Client-side library for controlling the audio drivers.
endef

SO_VERSION = 2

NAME=asound

PUBLIC_INCVPATH=$(PROJECT_ROOT)/public/include
EXTRA_INCVPATH +=  $(PROJECT_ROOT)/include $(PUBLIC_INCVPATH)/sys

EXTRA_SRCVPATH  = $(PROJECT_ROOT)/conversion
EXTRA_SRCVPATH += $(PROJECT_ROOT)/control
EXTRA_SRCVPATH += $(PROJECT_ROOT)/mixer
EXTRA_SRCVPATH += $(PROJECT_ROOT)/afm_service
EXTRA_SRCVPATH += $(PROJECT_ROOT)/pcm
EXTRA_SRCVPATH += $(PROJECT_ROOT)/pcm/plugin
EXTRA_SRCVPATH += $(PROJECT_ROOT)/pcm/alsa_plugins
EXTRA_SRCVPATH += $(PROJECT_ROOT)/rawmidi
EXTRA_SRCVPATH += $(PROJECT_ROOT)/alsa
EXTRA_SRCVPATH += $(PROJECT_ROOT)/alsa/plugins

CCFLAGS_rate_poly_core_arm = -march=armv7-a -mfpu=neon -O3
CCFLAGS_rate_poly_core_x86 = -O3 -DNDEBUG
CCFLAGS_rate_arm = -O2 -DNDEBUG
CCFLAGS_rate_x86 = -O2 -DNDEBUG

CCFLAGS += $(CCFLAGS_$(basename $@)_$(CPU))

LIBS += m slog2
LDOPTS += -Wl,-z,defs

include $(MKFILES_ROOT)/qtargets.mk

