/*
 *  Control Interface - main file
 *  Copyright (c) 1998 by Jaroslav Kysela <perex@suse.cz>
 *
 *
 *   This library is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "asoundlib.h"


#define	SND_DEV_DIR			"/dev/snd"
#define	CONTROL_NAME		"controlC%i"


int
snd_cards (void)
{
	DIR    *dirp;
	struct dirent *direntp;
	int     dev_no;
	int     count = 0;

	dirp = opendir (SND_DEV_DIR);
	if (dirp != NULL)
	{
		for (;;)
		{
			direntp = readdir (dirp);
			if (direntp == NULL)
				break;
			if (sscanf (direntp->d_name, CONTROL_NAME, &dev_no) == 1)
			{
				if (dev_no + 1 > count)
					count = dev_no + 1;
			}
		}
		closedir (dirp);
	}
	return (count);
}


int
snd_cards_list (int *cards, int card_array_size, int *cards_over)
{
	DIR    *dirp;
	struct dirent *direntp;
	int     dev_no;
	int     count = 0;

	*cards_over = 0;
	dirp = opendir (SND_DEV_DIR);
	if (dirp != NULL)
	{
		for (;;)
		{
			direntp = readdir (dirp);
			if (direntp == NULL)
				break;
			if (sscanf (direntp->d_name, CONTROL_NAME, &dev_no) == 1)
			{
				if (count == card_array_size)
					*cards_over += 1;
				else
				{
					cards[count] = dev_no;
					count += 1;
				}
			}
		}
		closedir (dirp);
	}
	return (count);
}


int
snd_card_name (const char *string)
{
	int     rtn = -EINVAL;
	int     card;
	snd_ctl_t *handle;
	struct snd_ctl_hw_info info;

	if (!string || *string == '\0')
		return -EINVAL;

	if (strspn (string, "0123456789") == strlen (string))
	{
		card = atoi (string);
		if (snd_ctl_open (&handle, card) == 0)
		{
			snd_ctl_close (handle);
			rtn = card;
		}
		else
			rtn = -EINVAL;
	}
	else
	{
		int max_cards = snd_cards();
		for (card = 0; card < max_cards; card++)
		{
			if (snd_ctl_open (&handle, card) < 0)
				continue;
			if (snd_ctl_hw_info (handle, &info) < 0)
			{
				snd_ctl_close (handle);
				continue;
			}
			snd_ctl_close (handle);

			if (strcasecmp (info.id, string) == 0)
			{
				return card;
			}
		}
	}
	return (rtn);
}

int
snd_card_get_name (int card, char *name, size_t size)
{
	snd_ctl_t *handle;
	struct snd_ctl_hw_info info;
	int     err;

	if (name == NULL)
		return -EINVAL;
	if ((err = snd_ctl_open (&handle, card)) < 0)
		return err;
	if ((err = snd_ctl_hw_info (handle, &info)) < 0)
	{
		snd_ctl_close (handle);
		return err;
	}
	snd_ctl_close (handle);

	strncpy (name, info.name, size - 1);
	name[size - 1] = 0;									   /* null term string */
	return 0;
}


int
snd_card_get_longname (int card, char *name, size_t size)
{
	snd_ctl_t *handle;
	struct snd_ctl_hw_info info;
	int     err;

	if (name == NULL)
		return -EINVAL;
	if ((err = snd_ctl_open (&handle, card)) < 0)
		return err;
	if ((err = snd_ctl_hw_info (handle, &info)) < 0)
	{
		snd_ctl_close (handle);
		return err;
	}
	snd_ctl_close (handle);

	strncpy (name, info.longname, size - 1);
	name[size - 1] = 0;									   /* null term string */
	return 0;
}

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn/product/branches/7.0.0/trunk/lib/asound/control/cards.c $ $Rev: 821814 $")
#endif
