/*
 *  Mixer Interfaces - local header file
 */

#include "asoundlib.h"

#ifndef __MIXER_LOCAL__
#define __MIXER_LOCAL__

struct mixer_list
{
	int type;
	int ref_count;
	int local_card;
	int local_device;
	int remote_card;
	int remote_device;
	snd_mixer_gid_t local_gid;
	snd_mixer_gid_t remote_gid;
	struct mixer_list *next;
};

int mixer_list_add(snd_pcm_t *pcm, struct mixer_list *new_mixer);
int mixer_list_remove(struct mixer_list *new_mixer);
int mixer_list_update(snd_pcm_t *pcm, struct mixer_list * mixer);
int mixer_notify_handle_refresh(snd_pcm_t * pcm_handle);

// Given a description of a mixer group in the primary connection, give a
// description of the remote mixer group that should be used
int mixer_get_routing_path(int type, int local_card, int local_device,
						 int *remote_card, int *remote_device,
						 snd_mixer_gid_t *local_gid, snd_mixer_gid_t **remote_gid);

// Given a description of a ctl device in the primary connection, give a
// description of the remote mixer controller that should be used
int mixer_get_card(int type, int local_card, int *remote_card);

// Given a description of a ctl device in the primary connection, give a
// description of the remote mixer controller that should be used
int mixer_get_device(int type, int local_card, int local_device,
					 int *remote_card, int *remote_device);

#endif //#define __MIXER_LOCAL__

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn/product/branches/7.0.0/trunk/lib/asound/include/mixer_local.h $ $Rev: 756969 $")
#endif
