/*
 * $QNXLicenseC:
 * Copyright 2015, QNX Software Systems. All Rights Reserved.
 *
 * You must obtain a written license from and pay applicable license fees to QNX
 * Software Systems before you may reproduce, modify or distribute this software,
 * or any work that includes all or part of this software.   Free development
 * licenses are available for evaluation and non-commercial purposes.  For more
 * information visit http://licensing.qnx.com or email licensing@qnx.com.
 *
 * This file may contain contributions from others.  Please review this entire
 * file for other proprietary rights or license notices, as well as the QNX
 * Development Suite License Guide at http://licensing.qnx.com/license-guide/
 * for other information.
 * $
 */

#ifndef __RATE_POLY_H__
#define __RATE_POLY_H__

#include <inttypes.h>

#define RATE_POLY_MAX_CHANNELS   8

typedef int (*playbackRateMixConvertMonoFunc_t)  (const int16_t* in, int outSamples, int16_t* out, int upScale, int dnScale, int channels,
                                                  int *firPh, int *dlyUp, int16_t *dlyLine, int *dlyIdx, int16_t *poly, int taps);
typedef int (*playbackRateMixConvertStereoFunc_t)(const int16_t* in, int outSamples, int16_t* out, int upScale, int dnScale, int channels,
                                                  int *firPh, int *dlyUp, int32_t *dlyLine, int *dlyIdx, int16_t* poly, int taps);
typedef int (*captureRateMixConvertMonoFunc_t)   (const int16_t* in, int inSamples, int16_t* out, int upScale, int dnScale, int channels,
                                                  int *firPh, int *dlyUp, int16_t *dlyLine, int16_t *poly, int taps);
typedef int (*captureRateMixConvertStereoFunc_t) (const int16_t* in, int inSamples, int16_t* out, int upScale, int dnScale, int channels,
                                                  int *firPh, int *dlyUp, int32_t *dlyLine, int16_t *poly, int taps);
typedef int (*captureRateDownConvertMonoFunc_t)  (const int16_t* in, int inSamples, int16_t* out, int dnScale, int channels,
                                                  int *dlyUp, int16_t *dlyLine, int16_t *polyDn, int taps);
typedef int (*captureRateDownConvertStereoFunc_t)(const int16_t* in, int inSamples, int16_t* out, int dnScale, int channels,
                                                  int *dlyUp, int32_t *dlyLine, int16_t *polyDn, int taps);
typedef struct ResampleFuncs {
    playbackRateMixConvertMonoFunc_t playbackRateMixConvertMono;
    playbackRateMixConvertStereoFunc_t playbackRateMixConvertStereo;
    captureRateMixConvertMonoFunc_t captureRateMixConvertMono;
    captureRateMixConvertStereoFunc_t captureRateMixConvertStereo;
    captureRateDownConvertMonoFunc_t captureRateDownConvertMono;
    captureRateDownConvertStereoFunc_t captureRateDownConvertStereo;
} ResampleFuncs_t;

typedef enum {
    RATE_POLY_MONO,
    RATE_POLY_STEREO
} ChannelOptimization_t;

typedef enum {
    RATE_POLY_NEON_I_CONV_FUNC,
    RATE_POLY_NEON_I_24T_CONV_FUNC,
    RATE_POLY_GENERIC_CONV_FUNC
} ConversionFunctionVersion_t;

typedef struct ResampleState {
    int             magic;
    int             playback;                //  playback flag - 1 - var input size, fixed out, 0 - fixed input, var output
    int             inRate;
    int             outRate;
    int             upScale;
    int             dnScale;
    int             channels;
    int             taps;
    int             src_size;
    int             dst_size;
    const int16_t   *coefs;
    int16_t         *poly;                     // actual filter coefficient location
    void            *dlyLine;
    int16_t         *dlyLineM[RATE_POLY_MAX_CHANNELS];
    int32_t         *dlyLineS[RATE_POLY_MAX_CHANNELS/2];
    int32_t         dlySize;                   // delay line size
    int             dlyIdx;                    // delay line index
    int             firPhase;
    int             dlyUpdate;
    int             dlyUpdate0;
    int             lastSrcSize;
    int             lastDstSize;
    int             icount;
    int             ocount;
#if defined(POLY_ENABLE_PROFILING)
    uint64_t        cycles;
    uint32_t        iter;
#endif
    ResampleFuncs_t funcs;
    ChannelOptimization_t channelOptimization;
    ConversionFunctionVersion_t conversionFunctionVersion;
} ResampleState_t;

int rate_poly_create(void *state, uint32_t inRate, uint32_t channels, uint32_t outRate, uint32_t hwFragSize, uint32_t fixedSizes, int playback);
int rate_poly_mem_required(void);
int rate_poly_flush(void *state);
int rate_poly_support_idx(uint32_t inRate, uint32_t channels, uint32_t outRate, uint32_t hwFragSize, uint32_t fixedTransferSize);
int rate_poly_process( void *state, const int16_t* in, uint32_t inSizeBytes, int16_t* out, uint32_t outSizeBytes);
int rate_poly_reset(void *state, uint32_t hwFragSize);
int rate_poly_free(void *state);

#endif /* __RATE_POLY_H__ */

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn/product/branches/7.0.0/trunk/lib/asound/include/rate_poly.h $ $Rev: 804396 $")
#endif
