/*
 *  PCM Interface - local header file
 */
#include <stdio.h>
#include "asoundlib.h"

#ifdef PLUGIN_DEBUG
#define pdprintf( args... ) printf( "plugin: " args)
#else
#define pdprintf(args,... ) { ; }
#endif

#define SND_FILE_PCM_PATH                 "/dev/snd/"
#define SND_FILE_PCM_PLAYBACK             "/dev/snd/pcmC%iD%ip"
#define SND_FILE_PCM_CAPTURE              "/dev/snd/pcmC%iD%ic"
#define SND_FILE_PCM_PREFERRED_PLAYBACK   "/dev/snd/pcmPreferredp"
#define SND_FILE_PCM_PREFERRED_CAPTURE    "/dev/snd/pcmPreferredc"
#define SND_FILE_CFG_PREFERENCES          "/etc/config/trap/audio/%s-preferences"

typedef struct snd_stru_pcm_plugin snd_pcm_plugin_t;

#define LOG_PREPROCESSED_DATA  (1<<0)
#define LOG_POSTPROCESSED_DATA (1<<1)

struct snd_pcm {
	int card;
	int device;
	int mode;
	int ver;
	int fd[2];
	int setup_is_valid[2];
	snd_pcm_channel_params_t params[2];
	snd_pcm_channel_setup_t setup[2];
	snd_mixer_eid_t			setup_eid[2];
	snd_mixer_gid_t			setup_gid[2];
	snd_pcm_mmap_control_t *mmap_caddr[2];
	char *mmap_daddr[2];
	long mmap_size[2];
	snd_pcm_format_t pre_plugin_format[2];
	int32_t					start_mode[2];
	unsigned int plugin_disable_mask;
	unsigned int plugin_inactive_mask;
	unsigned int plugin_src_method;
	unsigned int plugin_src_mode;
	int	plugin_src_target;
	double plugin_src_max_rate;
	unsigned int plugin_partial_block_size[2];
	char *plugin_partial_block_buffer[2];
	unsigned int plugin_partial_block_len[2];
	snd_pcm_plugin_t *plugin_first[2];
	snd_pcm_plugin_t *plugin_last[2];
	void *plugin_alloc_ptr[4];
	long plugin_alloc_size[4];
	int plugin_alloc_lock[4];
	void *plugin_alloc_xptr[2];
	long plugin_alloc_xsize[2];
	double plugin_ratio[2];
	double plugin_cratio[2];
	struct snd_pcm_link_group *group;
	int32_t log_flags;
	int log_fd;
	int log_id;
};

struct  snd_pcm_link_group {
	snd_pcm_t			*handle;
	struct snd_pcm_link_group	*next;
};


/* ------------------------ plug-in ------------------------------------------*/

typedef enum {
	INIT,
	PREPARE,
	DRAIN,
	POST_DRAIN,
	FLUSH
} snd_pcm_plugin_action_t;

#define snd_pcm_plugin_extra_data(plugin) (((char *)plugin) + sizeof(*plugin))
#define snd_pcm_plugin_from_data(data) ((snd_pcm_plugin_t *)(((char *)data) - sizeof(struct snd_stru_pcm_plugin)))

struct snd_stru_pcm_plugin {
	char *name;				   /* plug-in name */
	int (*transfer_src_ptr)(snd_pcm_plugin_t *plugin, void **src_ptr, size_t *src_size);
	ssize_t (*transfer)(snd_pcm_plugin_t *plugin,
	                    void *src_ptr, size_t src_size,
	                    void *dst_ptr, size_t dst_size);
	ssize_t (*src_size)(snd_pcm_plugin_t *plugin, size_t dst_size);
	ssize_t (*dst_size)(snd_pcm_plugin_t *plugin, size_t src_size);
	int (*action)(snd_pcm_plugin_t *plugin, snd_pcm_plugin_action_t action);
	snd_pcm_plugin_t *prev;
	snd_pcm_plugin_t *next;
	void *private_data;
	void (*private_free)(snd_pcm_plugin_t *plugin, void *private_data);
	int (*status_override)(snd_pcm_plugin_t *plugin, snd_pcm_channel_status_t * status);
	ssize_t (*pass_through)(snd_pcm_plugin_t *plugin,
	                    void *src_ptr, size_t src_size);
};

/* ---------------------- pcm.c --------------------------------------------- */
ssize_t snd_pcm_write_internal (snd_pcm_t * pcm, const void *buffer, size_t count);
ssize_t snd_pcm_read_internal (snd_pcm_t * pcm, void *buffer, size_t count);
int open_pcm_log (snd_pcm_t *pcm, snd_pcm_channel_params_t *params);
int close_pcm_log (snd_pcm_t *pcm);
ssize_t snd_pcm_write_plugin_internal(snd_pcm_t * pcm, const void*buffer, size_t count);
int snd_pcm_open_internal (snd_pcm_t **pcm, const char *name, int *rcard, int *rdevice, int mode);

/* ---------------------- pcm_plugin_build.c -------------------------------- */
unsigned int snd_pcm_plugin_formats(unsigned int formats);
int snd_pcm_plugin_format(snd_pcm_t *pcm,
			  snd_pcm_channel_params_t *params,
			  snd_pcm_channel_params_t *hwparams);
ssize_t snd_pcm_plugin_transfer_size_internal (snd_pcm_t *pcm, int channel, size_t drv_size);
ssize_t snd_pcm_plugin_hardware_size_internal (snd_pcm_t * pcm, int channel, size_t trf_size);

/* ---------------------- pcm_plugin.c -------------------------------------- */
unsigned char snd_pcm_plugin_silence ( snd_pcm_format_t *format );
snd_pcm_plugin_t *snd_pcm_plugin_build(const char *name, int extra);
int snd_pcm_plugin_clear(snd_pcm_t *handle, int channel);
snd_pcm_plugin_t *snd_pcm_plugin_first(snd_pcm_t *handle, int channel);
int snd_pcm_plugin_free(snd_pcm_plugin_t *plugin);
snd_pcm_plugin_t *snd_pcm_plugin_last(snd_pcm_t *handle, int channel);
snd_pcm_plugin_t *snd_pcm_plugin_find (snd_pcm_t * pcm, int channel, char * plugin_name);
int snd_pcm_plugin_insert (snd_pcm_t * pcm, int channel, snd_pcm_plugin_t * plugin);
int snd_pcm_plugin_append (snd_pcm_t * pcm, int channel, snd_pcm_plugin_t * plugin);
int snd_pcm_plugin_action (snd_pcm_t * pcm, int channel, int action);
ssize_t snd_pcm_plugin_write1 (snd_pcm_t * pcm, const void *buffer, size_t count);
ssize_t snd_pcm_plugin_read1 (snd_pcm_t * pcm, void *buffer, size_t count);

/* ---------------------- plugin/adpcm.c ------------------------------------ */
int snd_pcm_plugin_build_adpcm(snd_pcm_format_t *src_format,
				   snd_pcm_format_t *dst_format,
				   snd_pcm_plugin_t **r_plugin);

/* ---------------------- plugin/alaw.c ------------------------------------- */
int snd_pcm_plugin_build_alaw(snd_pcm_format_t *src_format,
				  snd_pcm_format_t *dst_format,
				  snd_pcm_plugin_t **r_plugin);

/* ---------------------- plugin/block.c ------------------------------------ */
int snd_pcm_plugin_build_block(snd_pcm_t *handle, int channel, snd_pcm_plugin_t **r_plugin);

/* ---------------------- plugin/interleave.c ------------------------------- */
int snd_pcm_plugin_build_interleave(snd_pcm_format_t *src_format,
					snd_pcm_format_t *dst_format,
					snd_pcm_plugin_t **r_plugin);

/* ---------------------- plugin/linear.c ----------------------------------- */
int snd_pcm_plugin_build_linear(snd_pcm_format_t *src_format,
				snd_pcm_format_t *dst_format,
				snd_pcm_plugin_t **r_plugin);

/* ---------------------- plugin/mmap.c ------------------------------------- */
int snd_pcm_plugin_build_mmap(snd_pcm_t *handle, int channel, snd_pcm_plugin_t **r_plugin);

/* ---------------------- plugin/mulaw.c ------------------------------------ */
int snd_pcm_plugin_build_mulaw(snd_pcm_format_t *src_format,
				   snd_pcm_format_t *dst_format,
				   snd_pcm_plugin_t **r_plugin);

/* ---------------------- plugin/rate.c ------------------------------------- */
int snd_pcm_plugin_build_rate ( snd_pcm_format_t *src_format,
					snd_pcm_format_t *dst_format , unsigned int method,
					snd_pcm_plugin_t **r_plugin, unsigned int src_mode,
					int target, int32_t out_frag_size);
int snd_pcm_plugin_src_max_frag (snd_pcm_t * pcm, int channel, unsigned int fragsize);
int snd_pcm_plugin_update_src (snd_pcm_t * pcm, snd_pcm_channel_setup_t * setup, int currlevel);

/* ---------------------- plugin/rate_poly.c -------------------------------- */
int snd_pcm_plugin_build_rate_poly (snd_pcm_format_t * src_format,
				snd_pcm_format_t * dst_format, snd_pcm_plugin_t ** r_plugin, 
				unsigned int src_mode, int play_mode,
				unsigned int fixed_sizes, int out_frag_size, int playback);

/* ---------------------- plugin/stream.c ----------------------------------- */
int snd_pcm_plugin_build_stream(snd_pcm_t *handle, int channel, snd_pcm_plugin_t **r_plugin);

/* ---------------------- plugin/voices.c ----------------------------------- */
int snd_pcm_plugin_build_voices(snd_pcm_t *pcm, snd_pcm_format_t *src_format,
				snd_pcm_format_t *dst_format, int channel,
				snd_pcm_plugin_t **r_plugin);
int snd_pcm_plugin_get_voice_conversion_internal (snd_pcm_t * pcm, int channel,
	snd_pcm_voice_conversion_t * voice_conversion);
int snd_pcm_plugin_set_voice_conversion_internal (snd_pcm_t * pcm, int channel,
	snd_pcm_voice_conversion_t * voice_conversion);

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn/product/branches/7.0.0/trunk/lib/asound/pcm/pcm_local.h $ $Rev: 820289 $")
#endif
