# get the current git version
execute_process(COMMAND git tag
                WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
                OUTPUT_VARIABLE TAG_LIST
                OUTPUT_STRIP_TRAILING_WHITESPACE)

IF (TAG_LIST AND NOT VERSION)
    STRING (REPLACE "\n" ";" TAG_LIST ${TAG_LIST})

    set (VERSION_LIST)

    foreach (element ${TAG_LIST})
        STRING (REGEX MATCH "^[0-9]+\\.." SINGLE_VERSION ${element})
        LIST (APPEND VERSION_LIST ${SINGLE_VERSION})
    endforeach (element)

    LIST (REVERSE VERSION_LIST)

    LIST (GET VERSION_LIST 0 VERSION_MISSING_MINOR)

    execute_process(COMMAND git --no-pager log --pretty=oneline HEAD...${VERSION_MISSING_MINOR}
            WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
            OUTPUT_VARIABLE COMMIT_LIST
            OUTPUT_STRIP_TRAILING_WHITESPACE)

    STRING (REPLACE "\n" ";" COMMIT_LIST ${COMMIT_LIST})

    LIST (LENGTH COMMIT_LIST MINOR_VERSION)

    SET (DAEMONVERSION "${VERSION_MISSING_MINOR}.${MINOR_VERSION}")
ENDIF (TAGLIST AND NOT VERSION)

if (NOT DAEMONVERSION)
    #Can be changed via passing -DVERSION="XXX" to cmake
    if(NOT DEFINED VERSION)
        set( DAEMONVERSION "homebrew-${CMAKE_SOURCE_DIR}" )
    else (NOT DEFINED VERSION)
        set( DAEMONVERSION "${VERSION}" )   
    endif(NOT DEFINED VERSION)
else (NOT DAEMONVERSION)
    STRING(REGEX REPLACE "(-)[^-]+$" "" DAEMONVERSION ${DAEMONVERSION})
    STRING(REGEX REPLACE "-" "." DAEMONVERSION ${DAEMONVERSION})
endif(NOT DAEMONVERSION)

message(STATUS "Build Version ${DAEMONVERSION}")

execute_process(COMMAND git log --pretty=short WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR} 
                OUTPUT_FILE ${CMAKE_CURRENT_SOURCE_DIR}/CHANGELOG)

