
#include "hamsi.h"

enum { SUCCESS=0, FAIL=1, BAD_HASHBITLEN=2 };

#ifdef	UNUSED
/* ===== "words.h" */
typedef unsigned int   Row __attribute__ ((vector_size (16))); // 128 bits
/* ===== */
#endif

const hashFunction hamsi256 = {
    .name = "HAMSI-256",
    .paramsize = sizeof(hamsiParam),
    .blocksize = 64,
    .digestsize = 256/8,	/* XXX default to HAMSI-256 */
    .reset = (hashFunctionReset) hamsiReset,
    .update = (hashFunctionUpdate) hamsiUpdate,
    .digest = (hashFunctionDigest) hamsiDigest
};

/* ===== "hamsi-tables.h" */
// round constants
static const uint32_t alpha[2][4][8] = {
  {
    {0xff00f0f0, 0xccccaaaa, 0xf0f0cccc, 0xff00aaaa, 0xccccaaaa, 0xf0f0ff00, 0xaaaacccc, 0xf0f0ff00},
    {0xf0f0cccc, 0xaaaaff00, 0xccccff00, 0xaaaaf0f0, 0xaaaaf0f0, 0xff00cccc, 0xccccf0f0, 0xff00aaaa},
    {0xccccaaaa, 0xff00f0f0, 0xff00aaaa, 0xf0f0cccc, 0xf0f0ff00, 0xccccaaaa, 0xf0f0ff00, 0xaaaacccc},
    {0xaaaaff00, 0xf0f0cccc, 0xaaaaf0f0, 0xccccff00, 0xff00cccc, 0xaaaaf0f0, 0xff00aaaa, 0xccccf0f0}
  },{
    {0xcaf9639c, 0x0ff0f9c0, 0x639c0ff0, 0xcaf9f9c0, 0x0ff0f9c0, 0x639ccaf9, 0xf9c00ff0, 0x639ccaf9},
    {0x639c0ff0, 0xf9c0caf9, 0x0ff0caf9, 0xf9c0639c, 0xf9c0639c, 0xcaf90ff0, 0x0ff0639c, 0xcaf9f9c0},
    {0x0ff0f9c0, 0xcaf9639c, 0xcaf9f9c0, 0x639c0ff0, 0x639ccaf9, 0x0ff0f9c0, 0x639ccaf9, 0xf9c00ff0},
    {0xf9c0caf9, 0x639c0ff0, 0xf9c0639c, 0x0ff0caf9, 0xcaf90ff0, 0xf9c0639c, 0xcaf9f9c0, 0x0ff0639c}
  }
};

// IV's
static const uint32_t iv224[8] = { 
    0x3c967a67, 0x3cbc6c20, 0xb4c343c3, 0xa73cbc6b, 0x2c204b61, 0x74686f6c, 0x69656b65, 0x20556e69
};

static const uint32_t iv256[8] = { 
    0x76657273, 0x69746569, 0x74204c65, 0x7576656e, 0x2c204465, 0x70617274, 0x656d656e, 0x7420456c
};

static const uint32_t iv384[16] = { 
    0x656b7472, 0x6f746563, 0x686e6965, 0x6b2c2043, 0x6f6d7075, 0x74657220, 0x53656375, 0x72697479, 
    0x20616e64, 0x20496e64, 0x75737472, 0x69616c20, 0x43727970, 0x746f6772, 0x61706879, 0x2c204b61
};

static const uint32_t iv512[16] = { 
    0x73746565, 0x6c706172, 0x6b204172, 0x656e6265, 0x72672031, 0x302c2062, 0x75732032, 0x3434362c, 
    0x20422d33, 0x30303120, 0x4c657576, 0x656e2d48, 0x65766572, 0x6c65652c, 0x2042656c, 0x6769756d
};

static const uint32_t T256[4][256][8] = {
    {
	{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x74951000,0x5a2b467e,0x88fd1d2b,0x1ee68292,0xcba90000,0x90273769,0xbbdcf407,0xd0f4af61},
	{0xcba90000,0x90273769,0xbbdcf407,0xd0f4af61,0xbf3c1000,0xca0c7117,0x3321e92c,0xce122df3},
	{0xbf3c1000,0xca0c7117,0x3321e92c,0xce122df3,0x74951000,0x5a2b467e,0x88fd1d2b,0x1ee68292},
	{0xe92a2000,0xb4578cfc,0x11fa3a57,0x3dc90524,0x97530000,0x204f6ed3,0x77b9e80f,0xa1ec5ec1},
	{0x9dbf3000,0xee7cca82,0x9907277c,0x232f87b6,0x5cfa0000,0xb06859ba,0xcc651c08,0x7118f1a0},
	{0x22832000,0x2470bb95,0xaa26ce50,0xed3daa45,0x286f1000,0xea431fc4,0x44980123,0x6ffe7332},
	{0x56163000,0x7e5bfdeb,0x22dbd37b,0xf3db28d7,0xe3c61000,0x7a6428ad,0xff44f524,0xbf0adc53},
	{0x97530000,0x204f6ed3,0x77b9e80f,0xa1ec5ec1,0x7e792000,0x9418e22f,0x6643d258,0x9c255be5},
	{0xe3c61000,0x7a6428ad,0xff44f524,0xbf0adc53,0xb5d02000,0x043fd546,0xdd9f265f,0x4cd1f484},
	{0x5cfa0000,0xb06859ba,0xcc651c08,0x7118f1a0,0xc1453000,0x5e149338,0x55623b74,0x52377616},
	{0x286f1000,0xea431fc4,0x44980123,0x6ffe7332,0x0aec3000,0xce33a451,0xeebecf73,0x82c3d977},
	{0x7e792000,0x9418e22f,0x6643d258,0x9c255be5,0xe92a2000,0xb4578cfc,0x11fa3a57,0x3dc90524},
	{0x0aec3000,0xce33a451,0xeebecf73,0x82c3d977,0x22832000,0x2470bb95,0xaa26ce50,0xed3daa45},
	{0xb5d02000,0x043fd546,0xdd9f265f,0x4cd1f484,0x56163000,0x7e5bfdeb,0x22dbd37b,0xf3db28d7},
	{0xc1453000,0x5e149338,0x55623b74,0x52377616,0x9dbf3000,0xee7cca82,0x9907277c,0x232f87b6},
	{0x121b4000,0x5b17d9e8,0x8dfacfab,0xce36cc72,0xe6570000,0x4bb33a25,0x848598ba,0x1041003e},
	{0x668e5000,0x013c9f96,0x0507d280,0xd0d04ee0,0x2dfe0000,0xdb940d4c,0x3f596cbd,0xc0b5af5f},
	{0xd9b24000,0xcb30ee81,0x36263bac,0x1ec26313,0x596b1000,0x81bf4b32,0xb7a47196,0xde532dcd},
	{0xad275000,0x911ba8ff,0xbedb2687,0x0024e181,0x92c21000,0x11987c5b,0x0c788591,0x0ea782ac},
	{0xfb316000,0xef405514,0x9c00f5fc,0xf3ffc956,0x71040000,0x6bfc54f6,0xf33c70b5,0xb1ad5eff},
	{0x8fa47000,0xb56b136a,0x14fde8d7,0xed194bc4,0xbaad0000,0xfbdb639f,0x48e084b2,0x6159f19e},
	{0x30986000,0x7f67627d,0x27dc01fb,0x230b6637,0xce381000,0xa1f025e1,0xc01d9999,0x7fbf730c},
	{0x440d7000,0x254c2403,0xaf211cd0,0x3dede4a5,0x05911000,0x31d71288,0x7bc16d9e,0xaf4bdc6d},
	{0x85484000,0x7b58b73b,0xfa4327a4,0x6fda92b3,0x982e2000,0xdfabd80a,0xe2c64ae2,0x8c645bdb},
	{0xf1dd5000,0x2173f145,0x72be3a8f,0x713c1021,0x53872000,0x4f8cef63,0x591abee5,0x5c90f4ba},
	{0x4ee14000,0xeb7f8052,0x419fd3a3,0xbf2e3dd2,0x27123000,0x15a7a91d,0xd1e7a3ce,0x42767628},
	{0x3a745000,0xb154c62c,0xc962ce88,0xa1c8bf40,0xecbb3000,0x85809e74,0x6a3b57c9,0x9282d949},
	{0x6c626000,0xcf0f3bc7,0xebb91df3,0x52139797,0x0f7d2000,0xffe4b6d9,0x957fa2ed,0x2d88051a},
	{0x18f77000,0x95247db9,0x634400d8,0x4cf51505,0xc4d42000,0x6fc381b0,0x2ea356ea,0xfd7caa7b},
	{0xa7cb6000,0x5f280cae,0x5065e9f4,0x82e738f6,0xb0413000,0x35e8c7ce,0xa65e4bc1,0xe39a28e9},
	{0xd35e7000,0x05034ad0,0xd898f4df,0x9c01ba64,0x7be83000,0xa5cff0a7,0x1d82bfc6,0x336e8788},
	{0xe6570000,0x4bb33a25,0x848598ba,0x1041003e,0xf44c4000,0x10a4e3cd,0x097f5711,0xde77cc4c},
	{0x92c21000,0x11987c5b,0x0c788591,0x0ea782ac,0x3fe54000,0x8083d4a4,0xb2a3a316,0x0e83632d},
	{0x2dfe0000,0xdb940d4c,0x3f596cbd,0xc0b5af5f,0x4b705000,0xdaa892da,0x3a5ebe3d,0x1065e1bf},
	{0x596b1000,0x81bf4b32,0xb7a47196,0xde532dcd,0x80d95000,0x4a8fa5b3,0x81824a3a,0xc0914ede},
	{0x0f7d2000,0xffe4b6d9,0x957fa2ed,0x2d88051a,0x631f4000,0x30eb8d1e,0x7ec6bf1e,0x7f9b928d},
	{0x7be83000,0xa5cff0a7,0x1d82bfc6,0x336e8788,0xa8b64000,0xa0ccba77,0xc51a4b19,0xaf6f3dec},
	{0xc4d42000,0x6fc381b0,0x2ea356ea,0xfd7caa7b,0xdc235000,0xfae7fc09,0x4de75632,0xb189bf7e},
	{0xb0413000,0x35e8c7ce,0xa65e4bc1,0xe39a28e9,0x178a5000,0x6ac0cb60,0xf63ba235,0x617d101f},
	{0x71040000,0x6bfc54f6,0xf33c70b5,0xb1ad5eff,0x8a356000,0x84bc01e2,0x6f3c8549,0x425297a9},
	{0x05911000,0x31d71288,0x7bc16d9e,0xaf4bdc6d,0x419c6000,0x149b368b,0xd4e0714e,0x92a638c8},
	{0xbaad0000,0xfbdb639f,0x48e084b2,0x6159f19e,0x35097000,0x4eb070f5,0x5c1d6c65,0x8c40ba5a},
	{0xce381000,0xa1f025e1,0xc01d9999,0x7fbf730c,0xfea07000,0xde97479c,0xe7c19862,0x5cb4153b},
	{0x982e2000,0xdfabd80a,0xe2c64ae2,0x8c645bdb,0x1d666000,0xa4f36f31,0x18856d46,0xe3bec968},
	{0xecbb3000,0x85809e74,0x6a3b57c9,0x9282d949,0xd6cf6000,0x34d45858,0xa3599941,0x334a6609},
	{0x53872000,0x4f8cef63,0x591abee5,0x5c90f4ba,0xa25a7000,0x6eff1e26,0x2ba4846a,0x2dace49b},
	{0x27123000,0x15a7a91d,0xd1e7a3ce,0x42767628,0x69f37000,0xfed8294f,0x9078706d,0xfd584bfa},
	{0xf44c4000,0x10a4e3cd,0x097f5711,0xde77cc4c,0x121b4000,0x5b17d9e8,0x8dfacfab,0xce36cc72},
	{0x80d95000,0x4a8fa5b3,0x81824a3a,0xc0914ede,0xd9b24000,0xcb30ee81,0x36263bac,0x1ec26313},
	{0x3fe54000,0x8083d4a4,0xb2a3a316,0x0e83632d,0xad275000,0x911ba8ff,0xbedb2687,0x0024e181},
	{0x4b705000,0xdaa892da,0x3a5ebe3d,0x1065e1bf,0x668e5000,0x013c9f96,0x0507d280,0xd0d04ee0},
	{0x1d666000,0xa4f36f31,0x18856d46,0xe3bec968,0x85484000,0x7b58b73b,0xfa4327a4,0x6fda92b3},
	{0x69f37000,0xfed8294f,0x9078706d,0xfd584bfa,0x4ee14000,0xeb7f8052,0x419fd3a3,0xbf2e3dd2},
	{0xd6cf6000,0x34d45858,0xa3599941,0x334a6609,0x3a745000,0xb154c62c,0xc962ce88,0xa1c8bf40},
	{0xa25a7000,0x6eff1e26,0x2ba4846a,0x2dace49b,0xf1dd5000,0x2173f145,0x72be3a8f,0x713c1021},
	{0x631f4000,0x30eb8d1e,0x7ec6bf1e,0x7f9b928d,0x6c626000,0xcf0f3bc7,0xebb91df3,0x52139797},
	{0x178a5000,0x6ac0cb60,0xf63ba235,0x617d101f,0xa7cb6000,0x5f280cae,0x5065e9f4,0x82e738f6},
	{0xa8b64000,0xa0ccba77,0xc51a4b19,0xaf6f3dec,0xd35e7000,0x05034ad0,0xd898f4df,0x9c01ba64},
	{0xdc235000,0xfae7fc09,0x4de75632,0xb189bf7e,0x18f77000,0x95247db9,0x634400d8,0x4cf51505},
	{0x8a356000,0x84bc01e2,0x6f3c8549,0x425297a9,0xfb316000,0xef405514,0x9c00f5fc,0xf3ffc956},
	{0xfea07000,0xde97479c,0xe7c19862,0x5cb4153b,0x30986000,0x7f67627d,0x27dc01fb,0x230b6637},
	{0x419c6000,0x149b368b,0xd4e0714e,0x92a638c8,0x440d7000,0x254c2403,0xaf211cd0,0x3dede4a5},
	{0x35097000,0x4eb070f5,0x5c1d6c65,0x8c40ba5a,0x8fa47000,0xb56b136a,0x14fde8d7,0xed194bc4},
	{0xe4788000,0x859673c1,0xb5fb2452,0x29cc5edf,0x045f0000,0x9c4a93c9,0x62fc79d0,0x731ebdc2},
	{0x90ed9000,0xdfbd35bf,0x3d063979,0x372adc4d,0xcff60000,0x0c6da4a0,0xd9208dd7,0xa3ea12a3},
	{0x2fd18000,0x15b144a8,0x0e27d055,0xf938f1be,0xbb631000,0x5646e2de,0x51dd90fc,0xbd0c9031},
	{0x5b449000,0x4f9a02d6,0x86dacd7e,0xe7de732c,0x70ca1000,0xc661d5b7,0xea0164fb,0x6df83f50},
	{0x0d52a000,0x31c1ff3d,0xa4011e05,0x14055bfb,0x930c0000,0xbc05fd1a,0x154591df,0xd2f2e303},
	{0x79c7b000,0x6beab943,0x2cfc032e,0x0ae3d969,0x58a50000,0x2c22ca73,0xae9965d8,0x02064c62},
	{0xc6fba000,0xa1e6c854,0x1fddea02,0xc4f1f49a,0x2c301000,0x76098c0d,0x266478f3,0x1ce0cef0},
	{0xb26eb000,0xfbcd8e2a,0x9720f729,0xda177608,0xe7991000,0xe62ebb64,0x9db88cf4,0xcc146191},
	{0x732b8000,0xa5d91d12,0xc242cc5d,0x8820001e,0x7a262000,0x085271e6,0x04bfab88,0xef3be627},
	{0x07be9000,0xfff25b6c,0x4abfd176,0x96c6828c,0xb18f2000,0x9875468f,0xbf635f8f,0x3fcf4946},
	{0xb8828000,0x35fe2a7b,0x799e385a,0x58d4af7f,0xc51a3000,0xc25e00f1,0x379e42a4,0x2129cbd4},
	{0xcc179000,0x6fd56c05,0xf1632571,0x46322ded,0x0eb33000,0x52793798,0x8c42b6a3,0xf1dd64b5},
	{0x9a01a000,0x118e91ee,0xd3b8f60a,0xb5e9053a,0xed752000,0x281d1f35,0x73064387,0x4ed7b8e6},
	{0xee94b000,0x4ba5d790,0x5b45eb21,0xab0f87a8,0x26dc2000,0xb83a285c,0xc8dab780,0x9e231787},
	{0x51a8a000,0x81a9a687,0x6864020d,0x651daa5b,0x52493000,0xe2116e22,0x4027aaab,0x80c59515},
	{0x253db000,0xdb82e0f9,0xe0991f26,0x7bfb28c9,0x99e03000,0x7236594b,0xfbfb5eac,0x50313a74},
	{0xf663c000,0xde81aa29,0x3801ebf9,0xe7fa92ad,0xe2080000,0xd7f9a9ec,0xe679e16a,0x635fbdfc},
	{0x82f6d000,0x84aaec57,0xb0fcf6d2,0xf91c103f,0x29a10000,0x47de9e85,0x5da5156d,0xb3ab129d},
	{0x3dcac000,0x4ea69d40,0x83dd1ffe,0x370e3dcc,0x5d341000,0x1df5d8fb,0xd5580846,0xad4d900f},
	{0x495fd000,0x148ddb3e,0x0b2002d5,0x29e8bf5e,0x969d1000,0x8dd2ef92,0x6e84fc41,0x7db93f6e},
	{0x1f49e000,0x6ad626d5,0x29fbd1ae,0xda339789,0x755b0000,0xf7b6c73f,0x91c00965,0xc2b3e33d},
	{0x6bdcf000,0x30fd60ab,0xa106cc85,0xc4d5151b,0xbef20000,0x6791f056,0x2a1cfd62,0x12474c5c},
	{0xd4e0e000,0xfaf111bc,0x922725a9,0x0ac738e8,0xca671000,0x3dbab628,0xa2e1e049,0x0ca1cece},
	{0xa075f000,0xa0da57c2,0x1ada3882,0x1421ba7a,0x01ce1000,0xad9d8141,0x193d144e,0xdc5561af},
	{0x6130c000,0xfecec4fa,0x4fb803f6,0x4616cc6c,0x9c712000,0x43e14bc3,0x803a3332,0xff7ae619},
	{0x15a5d000,0xa4e58284,0xc7451edd,0x58f04efe,0x57d82000,0xd3c67caa,0x3be6c735,0x2f8e4978},
	{0xaa99c000,0x6ee9f393,0xf464f7f1,0x96e2630d,0x234d3000,0x89ed3ad4,0xb31bda1e,0x3168cbea},
	{0xde0cd000,0x34c2b5ed,0x7c99eada,0x8804e19f,0xe8e43000,0x19ca0dbd,0x08c72e19,0xe19c648b},
	{0x881ae000,0x4a994806,0x5e4239a1,0x7bdfc948,0x0b222000,0x63ae2510,0xf783db3d,0x5e96b8d8},
	{0xfc8ff000,0x10b20e78,0xd6bf248a,0x65394bda,0xc08b2000,0xf3891279,0x4c5f2f3a,0x8e6217b9},
	{0x43b3e000,0xdabe7f6f,0xe59ecda6,0xab2b6629,0xb41e3000,0xa9a25407,0xc4a23211,0x9084952b},
	{0x3726f000,0x80953911,0x6d63d08d,0xb5cde4bb,0x7fb73000,0x3985636e,0x7f7ec616,0x40703a4a},
	{0x022f8000,0xce2549e4,0x317ebce8,0x398d5ee1,0xf0134000,0x8cee7004,0x6b832ec1,0xad69718e},
	{0x76ba9000,0x940e0f9a,0xb983a1c3,0x276bdc73,0x3bba4000,0x1cc9476d,0xd05fdac6,0x7d9ddeef},
	{0xc9868000,0x5e027e8d,0x8aa248ef,0xe979f180,0x4f2f5000,0x46e20113,0x58a2c7ed,0x637b5c7d},
	{0xbd139000,0x042938f3,0x025f55c4,0xf79f7312,0x84865000,0xd6c5367a,0xe37e33ea,0xb38ff31c},
	{0xeb05a000,0x7a72c518,0x208486bf,0x04445bc5,0x67404000,0xaca11ed7,0x1c3ac6ce,0x0c852f4f},
	{0x9f90b000,0x20598366,0xa8799b94,0x1aa2d957,0xace94000,0x3c8629be,0xa7e632c9,0xdc71802e},
	{0x20aca000,0xea55f271,0x9b5872b8,0xd4b0f4a4,0xd87c5000,0x66ad6fc0,0x2f1b2fe2,0xc29702bc},
	{0x5439b000,0xb07eb40f,0x13a56f93,0xca567636,0x13d55000,0xf68a58a9,0x94c7dbe5,0x1263addd},
	{0x957c8000,0xee6a2737,0x46c754e7,0x98610020,0x8e6a6000,0x18f6922b,0x0dc0fc99,0x314c2a6b},
	{0xe1e99000,0xb4416149,0xce3a49cc,0x868782b2,0x45c36000,0x88d1a542,0xb61c089e,0xe1b8850a},
	{0x5ed58000,0x7e4d105e,0xfd1ba0e0,0x4895af41,0x31567000,0xd2fae33c,0x3ee115b5,0xff5e0798},
	{0x2a409000,0x24665620,0x75e6bdcb,0x56732dd3,0xfaff7000,0x42ddd455,0x853de1b2,0x2faaa8f9},
	{0x7c56a000,0x5a3dabcb,0x573d6eb0,0xa5a80504,0x19396000,0x38b9fcf8,0x7a791496,0x90a074aa},
	{0x08c3b000,0x0016edb5,0xdfc0739b,0xbb4e8796,0xd2906000,0xa89ecb91,0xc1a5e091,0x4054dbcb},
	{0xb7ffa000,0xca1a9ca2,0xece19ab7,0x755caa65,0xa6057000,0xf2b58def,0x4958fdba,0x5eb25959},
	{0xc36ab000,0x9031dadc,0x641c879c,0x6bba28f7,0x6dac7000,0x6292ba86,0xf28409bd,0x8e46f638},
	{0x1034c000,0x9532900c,0xbc847343,0xf7bb9293,0x16444000,0xc75d4a21,0xef06b67b,0xbd2871b0},
	{0x64a1d000,0xcf19d672,0x34796e68,0xe95d1001,0xdded4000,0x577a7d48,0x54da427c,0x6ddcded1},
	{0xdb9dc000,0x0515a765,0x07588744,0x274f3df2,0xa9785000,0x0d513b36,0xdc275f57,0x733a5c43},
	{0xaf08d000,0x5f3ee11b,0x8fa59a6f,0x39a9bf60,0x62d15000,0x9d760c5f,0x67fbab50,0xa3cef322},
	{0xf91ee000,0x21651cf0,0xad7e4914,0xca7297b7,0x81174000,0xe71224f2,0x98bf5e74,0x1cc42f71},
	{0x8d8bf000,0x7b4e5a8e,0x2583543f,0xd4941525,0x4abe4000,0x7735139b,0x2363aa73,0xcc308010},
	{0x32b7e000,0xb1422b99,0x16a2bd13,0x1a8638d6,0x3e2b5000,0x2d1e55e5,0xab9eb758,0xd2d60282},
	{0x4622f000,0xeb696de7,0x9e5fa038,0x0460ba44,0xf5825000,0xbd39628c,0x1042435f,0x0222ade3},
	{0x8767c000,0xb57dfedf,0xcb3d9b4c,0x5657cc52,0x683d6000,0x5345a80e,0x89456423,0x210d2a55},
	{0xf3f2d000,0xef56b8a1,0x43c08667,0x48b14ec0,0xa3946000,0xc3629f67,0x32999024,0xf1f98534},
	{0x4ccec000,0x255ac9b6,0x70e16f4b,0x86a36333,0xd7017000,0x9949d919,0xba648d0f,0xef1f07a6},
	{0x385bd000,0x7f718fc8,0xf81c7260,0x9845e1a1,0x1ca87000,0x096eee70,0x01b87908,0x3feba8c7},
	{0x6e4de000,0x012a7223,0xdac7a11b,0x6b9ec976,0xff6e6000,0x730ac6dd,0xfefc8c2c,0x80e17494},
	{0x1ad8f000,0x5b01345d,0x523abc30,0x75784be4,0x34c76000,0xe32df1b4,0x4520782b,0x5015dbf5},
	{0xa5e4e000,0x910d454a,0x611b551c,0xbb6a6617,0x40527000,0xb906b7ca,0xcddd6500,0x4ef35967},
	{0xd171f000,0xcb260334,0xe9e64837,0xa58ce485,0x8bfb7000,0x292180a3,0x76019107,0x9e07f606},
	{0x045f0000,0x9c4a93c9,0x62fc79d0,0x731ebdc2,0xe0278000,0x19dce008,0xd7075d82,0x5ad2e31d},
	{0x70ca1000,0xc661d5b7,0xea0164fb,0x6df83f50,0x2b8e8000,0x89fbd761,0x6cdba985,0x8a264c7c},
	{0xcff60000,0x0c6da4a0,0xd9208dd7,0xa3ea12a3,0x5f1b9000,0xd3d0911f,0xe426b4ae,0x94c0ceee},
	{0xbb631000,0x5646e2de,0x51dd90fc,0xbd0c9031,0x94b29000,0x43f7a676,0x5ffa40a9,0x4434618f},
	{0xed752000,0x281d1f35,0x73064387,0x4ed7b8e6,0x77748000,0x39938edb,0xa0beb58d,0xfb3ebddc},
	{0x99e03000,0x7236594b,0xfbfb5eac,0x50313a74,0xbcdd8000,0xa9b4b9b2,0x1b62418a,0x2bca12bd},
	{0x26dc2000,0xb83a285c,0xc8dab780,0x9e231787,0xc8489000,0xf39fffcc,0x939f5ca1,0x352c902f},
	{0x52493000,0xe2116e22,0x4027aaab,0x80c59515,0x03e19000,0x63b8c8a5,0x2843a8a6,0xe5d83f4e},
	{0x930c0000,0xbc05fd1a,0x154591df,0xd2f2e303,0x9e5ea000,0x8dc40227,0xb1448fda,0xc6f7b8f8},
	{0xe7991000,0xe62ebb64,0x9db88cf4,0xcc146191,0x55f7a000,0x1de3354e,0x0a987bdd,0x16031799},
	{0x58a50000,0x2c22ca73,0xae9965d8,0x02064c62,0x2162b000,0x47c87330,0x826566f6,0x08e5950b},
	{0x2c301000,0x76098c0d,0x266478f3,0x1ce0cef0,0xeacbb000,0xd7ef4459,0x39b992f1,0xd8113a6a},
	{0x7a262000,0x085271e6,0x04bfab88,0xef3be627,0x090da000,0xad8b6cf4,0xc6fd67d5,0x671be639},
	{0x0eb33000,0x52793798,0x8c42b6a3,0xf1dd64b5,0xc2a4a000,0x3dac5b9d,0x7d2193d2,0xb7ef4958},
	{0xb18f2000,0x9875468f,0xbf635f8f,0x3fcf4946,0xb631b000,0x67871de3,0xf5dc8ef9,0xa909cbca},
	{0xc51a3000,0xc25e00f1,0x379e42a4,0x2129cbd4,0x7d98b000,0xf7a02a8a,0x4e007afe,0x79fd64ab},
	{0x16444000,0xc75d4a21,0xef06b67b,0xbd2871b0,0x06708000,0x526fda2d,0x5382c538,0x4a93e323},
	{0x62d15000,0x9d760c5f,0x67fbab50,0xa3cef322,0xcdd98000,0xc248ed44,0xe85e313f,0x9a674c42},
	{0xdded4000,0x577a7d48,0x54da427c,0x6ddcded1,0xb94c9000,0x9863ab3a,0x60a32c14,0x8481ced0},
	{0xa9785000,0x0d513b36,0xdc275f57,0x733a5c43,0x72e59000,0x08449c53,0xdb7fd813,0x547561b1},
	{0xff6e6000,0x730ac6dd,0xfefc8c2c,0x80e17494,0x91238000,0x7220b4fe,0x243b2d37,0xeb7fbde2},
	{0x8bfb7000,0x292180a3,0x76019107,0x9e07f606,0x5a8a8000,0xe2078397,0x9fe7d930,0x3b8b1283},
	{0x34c76000,0xe32df1b4,0x4520782b,0x5015dbf5,0x2e1f9000,0xb82cc5e9,0x171ac41b,0x256d9011},
	{0x40527000,0xb906b7ca,0xcddd6500,0x4ef35967,0xe5b69000,0x280bf280,0xacc6301c,0xf5993f70},
	{0x81174000,0xe71224f2,0x98bf5e74,0x1cc42f71,0x7809a000,0xc6773802,0x35c11760,0xd6b6b8c6},
	{0xf5825000,0xbd39628c,0x1042435f,0x0222ade3,0xb3a0a000,0x56500f6b,0x8e1de367,0x064217a7},
	{0x4abe4000,0x7735139b,0x2363aa73,0xcc308010,0xc735b000,0x0c7b4915,0x06e0fe4c,0x18a49535},
	{0x3e2b5000,0x2d1e55e5,0xab9eb758,0xd2d60282,0x0c9cb000,0x9c5c7e7c,0xbd3c0a4b,0xc8503a54},
	{0x683d6000,0x5345a80e,0x89456423,0x210d2a55,0xef5aa000,0xe63856d1,0x4278ff6f,0x775ae607},
	{0x1ca87000,0x096eee70,0x01b87908,0x3feba8c7,0x24f3a000,0x761f61b8,0xf9a40b68,0xa7ae4966},
	{0xa3946000,0xc3629f67,0x32999024,0xf1f98534,0x5066b000,0x2c3427c6,0x71591643,0xb948cbf4},
	{0xd7017000,0x9949d919,0xba648d0f,0xef1f07a6,0x9bcfb000,0xbc1310af,0xca85e244,0x69bc6495},
	{0xe2080000,0xd7f9a9ec,0xe679e16a,0x635fbdfc,0x146bc000,0x097803c5,0xde780a93,0x84a52f51},
	{0x969d1000,0x8dd2ef92,0x6e84fc41,0x7db93f6e,0xdfc2c000,0x995f34ac,0x65a4fe94,0x54518030},
	{0x29a10000,0x47de9e85,0x5da5156d,0xb3ab129d,0xab57d000,0xc37472d2,0xed59e3bf,0x4ab702a2},
	{0x5d341000,0x1df5d8fb,0xd5580846,0xad4d900f,0x60fed000,0x535345bb,0x568517b8,0x9a43adc3},
	{0x0b222000,0x63ae2510,0xf783db3d,0x5e96b8d8,0x8338c000,0x29376d16,0xa9c1e29c,0x25497190},
	{0x7fb73000,0x3985636e,0x7f7ec616,0x40703a4a,0x4891c000,0xb9105a7f,0x121d169b,0xf5bddef1},
	{0xc08b2000,0xf3891279,0x4c5f2f3a,0x8e6217b9,0x3c04d000,0xe33b1c01,0x9ae00bb0,0xeb5b5c63},
	{0xb41e3000,0xa9a25407,0xc4a23211,0x9084952b,0xf7add000,0x731c2b68,0x213cffb7,0x3baff302},
	{0x755b0000,0xf7b6c73f,0x91c00965,0xc2b3e33d,0x6a12e000,0x9d60e1ea,0xb83bd8cb,0x188074b4},
	{0x01ce1000,0xad9d8141,0x193d144e,0xdc5561af,0xa1bbe000,0x0d47d683,0x03e72ccc,0xc874dbd5},
	{0xbef20000,0x6791f056,0x2a1cfd62,0x12474c5c,0xd52ef000,0x576c90fd,0x8b1a31e7,0xd6925947},
	{0xca671000,0x3dbab628,0xa2e1e049,0x0ca1cece,0x1e87f000,0xc74ba794,0x30c6c5e0,0x0666f626},
	{0x9c712000,0x43e14bc3,0x803a3332,0xff7ae619,0xfd41e000,0xbd2f8f39,0xcf8230c4,0xb96c2a75},
	{0xe8e43000,0x19ca0dbd,0x08c72e19,0xe19c648b,0x36e8e000,0x2d08b850,0x745ec4c3,0x69988514},
	{0x57d82000,0xd3c67caa,0x3be6c735,0x2f8e4978,0x427df000,0x7723fe2e,0xfca3d9e8,0x777e0786},
	{0x234d3000,0x89ed3ad4,0xb31bda1e,0x3168cbea,0x89d4f000,0xe704c947,0x477f2def,0xa78aa8e7},
	{0xf0134000,0x8cee7004,0x6b832ec1,0xad69718e,0xf23cc000,0x42cb39e0,0x5afd9229,0x94e42f6f},
	{0x84865000,0xd6c5367a,0xe37e33ea,0xb38ff31c,0x3995c000,0xd2ec0e89,0xe121662e,0x4410800e},
	{0x3bba4000,0x1cc9476d,0xd05fdac6,0x7d9ddeef,0x4d00d000,0x88c748f7,0x69dc7b05,0x5af6029c},
	{0x4f2f5000,0x46e20113,0x58a2c7ed,0x637b5c7d,0x86a9d000,0x18e07f9e,0xd2008f02,0x8a02adfd},
	{0x19396000,0x38b9fcf8,0x7a791496,0x90a074aa,0x656fc000,0x62845733,0x2d447a26,0x350871ae},
	{0x6dac7000,0x6292ba86,0xf28409bd,0x8e46f638,0xaec6c000,0xf2a3605a,0x96988e21,0xe5fcdecf},
	{0xd2906000,0xa89ecb91,0xc1a5e091,0x4054dbcb,0xda53d000,0xa8882624,0x1e65930a,0xfb1a5c5d},
	{0xa6057000,0xf2b58def,0x4958fdba,0x5eb25959,0x11fad000,0x38af114d,0xa5b9670d,0x2beef33c},
	{0x67404000,0xaca11ed7,0x1c3ac6ce,0x0c852f4f,0x8c45e000,0xd6d3dbcf,0x3cbe4071,0x08c1748a},
	{0x13d55000,0xf68a58a9,0x94c7dbe5,0x1263addd,0x47ece000,0x46f4eca6,0x8762b476,0xd835dbeb},
	{0xace94000,0x3c8629be,0xa7e632c9,0xdc71802e,0x3379f000,0x1cdfaad8,0x0f9fa95d,0xc6d35979},
	{0xd87c5000,0x66ad6fc0,0x2f1b2fe2,0xc29702bc,0xf8d0f000,0x8cf89db1,0xb4435d5a,0x1627f618},
	{0x8e6a6000,0x18f6922b,0x0dc0fc99,0x314c2a6b,0x1b16e000,0xf69cb51c,0x4b07a87e,0xa92d2a4b},
	{0xfaff7000,0x42ddd455,0x853de1b2,0x2faaa8f9,0xd0bfe000,0x66bb8275,0xf0db5c79,0x79d9852a},
	{0x45c36000,0x88d1a542,0xb61c089e,0xe1b8850a,0xa42af000,0x3c90c40b,0x78264152,0x673f07b8},
	{0x31567000,0xd2fae33c,0x3ee115b5,0xff5e0798,0x6f83f000,0xacb7f362,0xc3fab555,0xb7cba8d9},
	{0xe0278000,0x19dce008,0xd7075d82,0x5ad2e31d,0xe4788000,0x859673c1,0xb5fb2452,0x29cc5edf},
	{0x94b29000,0x43f7a676,0x5ffa40a9,0x4434618f,0x2fd18000,0x15b144a8,0x0e27d055,0xf938f1be},
	{0x2b8e8000,0x89fbd761,0x6cdba985,0x8a264c7c,0x5b449000,0x4f9a02d6,0x86dacd7e,0xe7de732c},
	{0x5f1b9000,0xd3d0911f,0xe426b4ae,0x94c0ceee,0x90ed9000,0xdfbd35bf,0x3d063979,0x372adc4d},
	{0x090da000,0xad8b6cf4,0xc6fd67d5,0x671be639,0x732b8000,0xa5d91d12,0xc242cc5d,0x8820001e},
	{0x7d98b000,0xf7a02a8a,0x4e007afe,0x79fd64ab,0xb8828000,0x35fe2a7b,0x799e385a,0x58d4af7f},
	{0xc2a4a000,0x3dac5b9d,0x7d2193d2,0xb7ef4958,0xcc179000,0x6fd56c05,0xf1632571,0x46322ded},
	{0xb631b000,0x67871de3,0xf5dc8ef9,0xa909cbca,0x07be9000,0xfff25b6c,0x4abfd176,0x96c6828c},
	{0x77748000,0x39938edb,0xa0beb58d,0xfb3ebddc,0x9a01a000,0x118e91ee,0xd3b8f60a,0xb5e9053a},
	{0x03e19000,0x63b8c8a5,0x2843a8a6,0xe5d83f4e,0x51a8a000,0x81a9a687,0x6864020d,0x651daa5b},
	{0xbcdd8000,0xa9b4b9b2,0x1b62418a,0x2bca12bd,0x253db000,0xdb82e0f9,0xe0991f26,0x7bfb28c9},
	{0xc8489000,0xf39fffcc,0x939f5ca1,0x352c902f,0xee94b000,0x4ba5d790,0x5b45eb21,0xab0f87a8},
	{0x9e5ea000,0x8dc40227,0xb1448fda,0xc6f7b8f8,0x0d52a000,0x31c1ff3d,0xa4011e05,0x14055bfb},
	{0xeacbb000,0xd7ef4459,0x39b992f1,0xd8113a6a,0xc6fba000,0xa1e6c854,0x1fddea02,0xc4f1f49a},
	{0x55f7a000,0x1de3354e,0x0a987bdd,0x16031799,0xb26eb000,0xfbcd8e2a,0x9720f729,0xda177608},
	{0x2162b000,0x47c87330,0x826566f6,0x08e5950b,0x79c7b000,0x6beab943,0x2cfc032e,0x0ae3d969},
	{0xf23cc000,0x42cb39e0,0x5afd9229,0x94e42f6f,0x022f8000,0xce2549e4,0x317ebce8,0x398d5ee1},
	{0x86a9d000,0x18e07f9e,0xd2008f02,0x8a02adfd,0xc9868000,0x5e027e8d,0x8aa248ef,0xe979f180},
	{0x3995c000,0xd2ec0e89,0xe121662e,0x4410800e,0xbd139000,0x042938f3,0x025f55c4,0xf79f7312},
	{0x4d00d000,0x88c748f7,0x69dc7b05,0x5af6029c,0x76ba9000,0x940e0f9a,0xb983a1c3,0x276bdc73},
	{0x1b16e000,0xf69cb51c,0x4b07a87e,0xa92d2a4b,0x957c8000,0xee6a2737,0x46c754e7,0x98610020},
	{0x6f83f000,0xacb7f362,0xc3fab555,0xb7cba8d9,0x5ed58000,0x7e4d105e,0xfd1ba0e0,0x4895af41},
	{0xd0bfe000,0x66bb8275,0xf0db5c79,0x79d9852a,0x2a409000,0x24665620,0x75e6bdcb,0x56732dd3},
	{0xa42af000,0x3c90c40b,0x78264152,0x673f07b8,0xe1e99000,0xb4416149,0xce3a49cc,0x868782b2},
	{0x656fc000,0x62845733,0x2d447a26,0x350871ae,0x7c56a000,0x5a3dabcb,0x573d6eb0,0xa5a80504},
	{0x11fad000,0x38af114d,0xa5b9670d,0x2beef33c,0xb7ffa000,0xca1a9ca2,0xece19ab7,0x755caa65},
	{0xaec6c000,0xf2a3605a,0x96988e21,0xe5fcdecf,0xc36ab000,0x9031dadc,0x641c879c,0x6bba28f7},
	{0xda53d000,0xa8882624,0x1e65930a,0xfb1a5c5d,0x08c3b000,0x0016edb5,0xdfc0739b,0xbb4e8796},
	{0x8c45e000,0xd6d3dbcf,0x3cbe4071,0x08c1748a,0xeb05a000,0x7a72c518,0x208486bf,0x04445bc5},
	{0xf8d0f000,0x8cf89db1,0xb4435d5a,0x1627f618,0x20aca000,0xea55f271,0x9b5872b8,0xd4b0f4a4},
	{0x47ece000,0x46f4eca6,0x8762b476,0xd835dbeb,0x5439b000,0xb07eb40f,0x13a56f93,0xca567636},
	{0x3379f000,0x1cdfaad8,0x0f9fa95d,0xc6d35979,0x9f90b000,0x20598366,0xa8799b94,0x1aa2d957},
	{0x06708000,0x526fda2d,0x5382c538,0x4a93e323,0x1034c000,0x9532900c,0xbc847343,0xf7bb9293},
	{0x72e59000,0x08449c53,0xdb7fd813,0x547561b1,0xdb9dc000,0x0515a765,0x07588744,0x274f3df2},
	{0xcdd98000,0xc248ed44,0xe85e313f,0x9a674c42,0xaf08d000,0x5f3ee11b,0x8fa59a6f,0x39a9bf60},
	{0xb94c9000,0x9863ab3a,0x60a32c14,0x8481ced0,0x64a1d000,0xcf19d672,0x34796e68,0xe95d1001},
	{0xef5aa000,0xe63856d1,0x4278ff6f,0x775ae607,0x8767c000,0xb57dfedf,0xcb3d9b4c,0x5657cc52},
	{0x9bcfb000,0xbc1310af,0xca85e244,0x69bc6495,0x4ccec000,0x255ac9b6,0x70e16f4b,0x86a36333},
	{0x24f3a000,0x761f61b8,0xf9a40b68,0xa7ae4966,0x385bd000,0x7f718fc8,0xf81c7260,0x9845e1a1},
	{0x5066b000,0x2c3427c6,0x71591643,0xb948cbf4,0xf3f2d000,0xef56b8a1,0x43c08667,0x48b14ec0},
	{0x91238000,0x7220b4fe,0x243b2d37,0xeb7fbde2,0x6e4de000,0x012a7223,0xdac7a11b,0x6b9ec976},
	{0xe5b69000,0x280bf280,0xacc6301c,0xf5993f70,0xa5e4e000,0x910d454a,0x611b551c,0xbb6a6617},
	{0x5a8a8000,0xe2078397,0x9fe7d930,0x3b8b1283,0xd171f000,0xcb260334,0xe9e64837,0xa58ce485},
	{0x2e1f9000,0xb82cc5e9,0x171ac41b,0x256d9011,0x1ad8f000,0x5b01345d,0x523abc30,0x75784be4},
	{0x7809a000,0xc6773802,0x35c11760,0xd6b6b8c6,0xf91ee000,0x21651cf0,0xad7e4914,0xca7297b7},
	{0x0c9cb000,0x9c5c7e7c,0xbd3c0a4b,0xc8503a54,0x32b7e000,0xb1422b99,0x16a2bd13,0x1a8638d6},
	{0xb3a0a000,0x56500f6b,0x8e1de367,0x064217a7,0x4622f000,0xeb696de7,0x9e5fa038,0x0460ba44},
	{0xc735b000,0x0c7b4915,0x06e0fe4c,0x18a49535,0x8d8bf000,0x7b4e5a8e,0x2583543f,0xd4941525},
	{0x146bc000,0x097803c5,0xde780a93,0x84a52f51,0xf663c000,0xde81aa29,0x3801ebf9,0xe7fa92ad},
	{0x60fed000,0x535345bb,0x568517b8,0x9a43adc3,0x3dcac000,0x4ea69d40,0x83dd1ffe,0x370e3dcc},
	{0xdfc2c000,0x995f34ac,0x65a4fe94,0x54518030,0x495fd000,0x148ddb3e,0x0b2002d5,0x29e8bf5e},
	{0xab57d000,0xc37472d2,0xed59e3bf,0x4ab702a2,0x82f6d000,0x84aaec57,0xb0fcf6d2,0xf91c103f},
	{0xfd41e000,0xbd2f8f39,0xcf8230c4,0xb96c2a75,0x6130c000,0xfecec4fa,0x4fb803f6,0x4616cc6c},
	{0x89d4f000,0xe704c947,0x477f2def,0xa78aa8e7,0xaa99c000,0x6ee9f393,0xf464f7f1,0x96e2630d},
	{0x36e8e000,0x2d08b850,0x745ec4c3,0x69988514,0xde0cd000,0x34c2b5ed,0x7c99eada,0x8804e19f},
	{0x427df000,0x7723fe2e,0xfca3d9e8,0x777e0786,0x15a5d000,0xa4e58284,0xc7451edd,0x58f04efe},
	{0x8338c000,0x29376d16,0xa9c1e29c,0x25497190,0x881ae000,0x4a994806,0x5e4239a1,0x7bdfc948},
	{0xf7add000,0x731c2b68,0x213cffb7,0x3baff302,0x43b3e000,0xdabe7f6f,0xe59ecda6,0xab2b6629},
	{0x4891c000,0xb9105a7f,0x121d169b,0xf5bddef1,0x3726f000,0x80953911,0x6d63d08d,0xb5cde4bb},
	{0x3c04d000,0xe33b1c01,0x9ae00bb0,0xeb5b5c63,0xfc8ff000,0x10b20e78,0xd6bf248a,0x65394bda},
	{0x6a12e000,0x9d60e1ea,0xb83bd8cb,0x188074b4,0x1f49e000,0x6ad626d5,0x29fbd1ae,0xda339789},
	{0x1e87f000,0xc74ba794,0x30c6c5e0,0x0666f626,0xd4e0e000,0xfaf111bc,0x922725a9,0x0ac738e8},
	{0xa1bbe000,0x0d47d683,0x03e72ccc,0xc874dbd5,0xa075f000,0xa0da57c2,0x1ada3882,0x1421ba7a},
	{0xd52ef000,0x576c90fd,0x8b1a31e7,0xd6925947,0x6bdcf000,0x30fd60ab,0xa106cc85,0xc4d5151b}
    },{
	{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0xb7a40100,0x8a1f31d8,0x8589d8ab,0xe6c46464,0x734c0000,0x956fa7d6,0xa29d1297,0x6ee56854},
	{0x734c0000,0x956fa7d6,0xa29d1297,0x6ee56854,0xc4e80100,0x1f70960e,0x2714ca3c,0x88210c30},
	{0xc4e80100,0x1f70960e,0x2714ca3c,0x88210c30,0xb7a40100,0x8a1f31d8,0x8589d8ab,0xe6c46464},
	{0xa7b80200,0x1f128433,0x60e5f9f2,0x9e147576,0xee260000,0x124b683e,0x80c2d68f,0x3bf3ab2c},
	{0x101c0300,0x950db5eb,0xe56c2159,0x78d01112,0x9d6a0000,0x8724cfe8,0x225fc418,0x5516c378},
	{0xd4f40200,0x8a7d23e5,0xc278eb65,0xf0f11d22,0x2ace0100,0x0d3bfe30,0xa7d61cb3,0xb3d2a71c},
	{0x63500300,0x0062123d,0x47f133ce,0x16357946,0x59820100,0x985459e6,0x054b0e24,0xdd37cf48},
	{0xee260000,0x124b683e,0x80c2d68f,0x3bf3ab2c,0x499e0200,0x0d59ec0d,0xe0272f7d,0xa5e7de5a},
	{0x59820100,0x985459e6,0x054b0e24,0xdd37cf48,0x3ad20200,0x98364bdb,0x42ba3dea,0xcb02b60e},
	{0x9d6a0000,0x8724cfe8,0x225fc418,0x5516c378,0x8d760300,0x12297a03,0xc733e541,0x2dc6d26a},
	{0x2ace0100,0x0d3bfe30,0xa7d61cb3,0xb3d2a71c,0xfe3a0300,0x8746ddd5,0x65aef7d6,0x4323ba3e},
	{0x499e0200,0x0d59ec0d,0xe0272f7d,0xa5e7de5a,0xa7b80200,0x1f128433,0x60e5f9f2,0x9e147576},
	{0xfe3a0300,0x8746ddd5,0x65aef7d6,0x4323ba3e,0xd4f40200,0x8a7d23e5,0xc278eb65,0xf0f11d22},
	{0x3ad20200,0x98364bdb,0x42ba3dea,0xcb02b60e,0x63500300,0x0062123d,0x47f133ce,0x16357946},
	{0x8d760300,0x12297a03,0xc733e541,0x2dc6d26a,0x101c0300,0x950db5eb,0xe56c2159,0x78d01112},
	{0x8f3e0400,0x0d9dc877,0x6fc548e1,0x898d2cd6,0x14bd0000,0x2fba37ff,0x6a72e5bb,0x247febe6},
	{0x389a0500,0x8782f9af,0xea4c904a,0x6f4948b2,0x67f10000,0xbad59029,0xc8eff72c,0x4a9a83b2},
	{0xfc720400,0x98f26fa1,0xcd585a76,0xe7684482,0xd0550100,0x30caa1f1,0x4d662f87,0xac5ee7d6},
	{0x4bd60500,0x12ed5e79,0x48d182dd,0x01ac20e6,0xa3190100,0xa5a50627,0xeffb3d10,0xc2bb8f82},
	{0x28860600,0x128f4c44,0x0f20b113,0x179959a0,0xfa9b0000,0x3df15fc1,0xeab03334,0x1f8c40ca},
	{0x9f220700,0x98907d9c,0x8aa969b8,0xf15d3dc4,0x89d70000,0xa89ef817,0x482d21a3,0x7169289e},
	{0x5bca0600,0x87e0eb92,0xadbda384,0x797c31f4,0x3e730100,0x2281c9cf,0xcda4f908,0x97ad4cfa},
	{0xec6e0700,0x0dffda4a,0x28347b2f,0x9fb85590,0x4d3f0100,0xb7ee6e19,0x6f39eb9f,0xf94824ae},
	{0x61180400,0x1fd6a049,0xef079e6e,0xb27e87fa,0x5d230200,0x22e3dbf2,0x8a55cac6,0x819835bc},
	{0xd6bc0500,0x95c99191,0x6a8e46c5,0x54bae39e,0x2e6f0200,0xb78c7c24,0x28c8d851,0xef7d5de8},
	{0x12540400,0x8ab9079f,0x4d9a8cf9,0xdc9befae,0x99cb0300,0x3d934dfc,0xad4100fa,0x09b9398c},
	{0xa5f00500,0x00a63647,0xc8135452,0x3a5f8bca,0xea870300,0xa8fcea2a,0x0fdc126d,0x675c51d8},
	{0xc6a00600,0x00c4247a,0x8fe2679c,0x2c6af28c,0xb3050200,0x30a8b3cc,0x0a971c49,0xba6b9e90},
	{0x71040700,0x8adb15a2,0x0a6bbf37,0xcaae96e8,0xc0490200,0xa5c7141a,0xa80a0ede,0xd48ef6c4},
	{0xb5ec0600,0x95ab83ac,0x2d7f750b,0x428f9ad8,0x77ed0300,0x2fd825c2,0x2d83d675,0x324a92a0},
	{0x02480700,0x1fb4b274,0xa8f6ada0,0xa44bfebc,0x04a10300,0xbab78214,0x8f1ec4e2,0x5caffaf4},
	{0x14bd0000,0x2fba37ff,0x6a72e5bb,0x247febe6,0x9b830400,0x2227ff88,0x05b7ad5a,0xadf2c730},
	{0xa3190100,0xa5a50627,0xeffb3d10,0xc2bb8f82,0xe8cf0400,0xb748585e,0xa72abfcd,0xc317af64},
	{0x67f10000,0xbad59029,0xc8eff72c,0x4a9a83b2,0x5f6b0500,0x3d576986,0x22a36766,0x25d3cb00},
	{0xd0550100,0x30caa1f1,0x4d662f87,0xac5ee7d6,0x2c270500,0xa838ce50,0x803e75f1,0x4b36a354},
	{0xb3050200,0x30a8b3cc,0x0a971c49,0xba6b9e90,0x75a50400,0x306c97b6,0x85757bd5,0x96016c1c},
	{0x04a10300,0xbab78214,0x8f1ec4e2,0x5caffaf4,0x06e90400,0xa5033060,0x27e86942,0xf8e40448},
	{0xc0490200,0xa5c7141a,0xa80a0ede,0xd48ef6c4,0xb14d0500,0x2f1c01b8,0xa261b1e9,0x1e20602c},
	{0x77ed0300,0x2fd825c2,0x2d83d675,0x324a92a0,0xc2010500,0xba73a66e,0x00fca37e,0x70c50878},
	{0xfa9b0000,0x3df15fc1,0xeab03334,0x1f8c40ca,0xd21d0600,0x2f7e1385,0xe5908227,0x0815196a},
	{0x4d3f0100,0xb7ee6e19,0x6f39eb9f,0xf94824ae,0xa1510600,0xba11b453,0x470d90b0,0x66f0713e},
	{0x89d70000,0xa89ef817,0x482d21a3,0x7169289e,0x16f50700,0x300e858b,0xc284481b,0x8034155a},
	{0x3e730100,0x2281c9cf,0xcda4f908,0x97ad4cfa,0x65b90700,0xa561225d,0x60195a8c,0xeed17d0e},
	{0x5d230200,0x22e3dbf2,0x8a55cac6,0x819835bc,0x3c3b0600,0x3d357bbb,0x655254a8,0x33e6b246},
	{0xea870300,0xa8fcea2a,0x0fdc126d,0x675c51d8,0x4f770600,0xa85adc6d,0xc7cf463f,0x5d03da12},
	{0x2e6f0200,0xb78c7c24,0x28c8d851,0xef7d5de8,0xf8d30700,0x2245edb5,0x42469e94,0xbbc7be76},
	{0x99cb0300,0x3d934dfc,0xad4100fa,0x09b9398c,0x8b9f0700,0xb72a4a63,0xe0db8c03,0xd522d622},
	{0x9b830400,0x2227ff88,0x05b7ad5a,0xadf2c730,0x8f3e0400,0x0d9dc877,0x6fc548e1,0x898d2cd6},
	{0x2c270500,0xa838ce50,0x803e75f1,0x4b36a354,0xfc720400,0x98f26fa1,0xcd585a76,0xe7684482},
	{0xe8cf0400,0xb748585e,0xa72abfcd,0xc317af64,0x4bd60500,0x12ed5e79,0x48d182dd,0x01ac20e6},
	{0x5f6b0500,0x3d576986,0x22a36766,0x25d3cb00,0x389a0500,0x8782f9af,0xea4c904a,0x6f4948b2},
	{0x3c3b0600,0x3d357bbb,0x655254a8,0x33e6b246,0x61180400,0x1fd6a049,0xef079e6e,0xb27e87fa},
	{0x8b9f0700,0xb72a4a63,0xe0db8c03,0xd522d622,0x12540400,0x8ab9079f,0x4d9a8cf9,0xdc9befae},
	{0x4f770600,0xa85adc6d,0xc7cf463f,0x5d03da12,0xa5f00500,0x00a63647,0xc8135452,0x3a5f8bca},
	{0xf8d30700,0x2245edb5,0x42469e94,0xbbc7be76,0xd6bc0500,0x95c99191,0x6a8e46c5,0x54bae39e},
	{0x75a50400,0x306c97b6,0x85757bd5,0x96016c1c,0xc6a00600,0x00c4247a,0x8fe2679c,0x2c6af28c},
	{0xc2010500,0xba73a66e,0x00fca37e,0x70c50878,0xb5ec0600,0x95ab83ac,0x2d7f750b,0x428f9ad8},
	{0x06e90400,0xa5033060,0x27e86942,0xf8e40448,0x02480700,0x1fb4b274,0xa8f6ada0,0xa44bfebc},
	{0xb14d0500,0x2f1c01b8,0xa261b1e9,0x1e20602c,0x71040700,0x8adb15a2,0x0a6bbf37,0xcaae96e8},
	{0xd21d0600,0x2f7e1385,0xe5908227,0x0815196a,0x28860600,0x128f4c44,0x0f20b113,0x179959a0},
	{0x65b90700,0xa561225d,0x60195a8c,0xeed17d0e,0x5bca0600,0x87e0eb92,0xadbda384,0x797c31f4},
	{0xa1510600,0xba11b453,0x470d90b0,0x66f0713e,0xec6e0700,0x0dffda4a,0x28347b2f,0x9fb85590},
	{0x16f50700,0x300e858b,0xc284481b,0x8034155a,0x9f220700,0x98907d9c,0x8aa969b8,0xf15d3dc4},
	{0xde320800,0x288350fe,0x71852ac7,0xa6bf9f96,0xe18b0000,0x5459887d,0xbf1283d3,0x1b666a73},
	{0x69960900,0xa29c6126,0xf40cf26c,0x407bfbf2,0x92c70000,0xc1362fab,0x1d8f9144,0x75830227},
	{0xad7e0800,0xbdecf728,0xd3183850,0xc85af7c2,0x25630100,0x4b291e73,0x980649ef,0x93476643},
	{0x1ada0900,0x37f3c6f0,0x5691e0fb,0x2e9e93a6,0x562f0100,0xde46b9a5,0x3a9b5b78,0xfda20e17},
	{0x798a0a00,0x3791d4cd,0x1160d335,0x38abeae0,0x0fad0000,0x4612e043,0x3fd0555c,0x2095c15f},
	{0xce2e0b00,0xbd8ee515,0x94e90b9e,0xde6f8e84,0x7ce10000,0xd37d4795,0x9d4d47cb,0x4e70a90b},
	{0x0ac60a00,0xa2fe731b,0xb3fdc1a2,0x564e82b4,0xcb450100,0x5962764d,0x18c49f60,0xa8b4cd6f},
	{0xbd620b00,0x28e142c3,0x36741909,0xb08ae6d0,0xb8090100,0xcc0dd19b,0xba598df7,0xc651a53b},
	{0x30140800,0x3ac838c0,0xf147fc48,0x9d4c34ba,0xa8150200,0x59006470,0x5f35acae,0xbe81b429},
	{0x87b00900,0xb0d70918,0x74ce24e3,0x7b8850de,0xdb590200,0xcc6fc3a6,0xfda8be39,0xd064dc7d},
	{0x43580800,0xafa79f16,0x53daeedf,0xf3a95cee,0x6cfd0300,0x4670f27e,0x78216692,0x36a0b819},
	{0xf4fc0900,0x25b8aece,0xd6533674,0x156d388a,0x1fb10300,0xd31f55a8,0xdabc7405,0x5845d04d},
	{0x97ac0a00,0x25dabcf3,0x91a205ba,0x035841cc,0x46330200,0x4b4b0c4e,0xdff77a21,0x85721f05},
	{0x20080b00,0xafc58d2b,0x142bdd11,0xe59c25a8,0x357f0200,0xde24ab98,0x7d6a68b6,0xeb977751},
	{0xe4e00a00,0xb0b51b25,0x333f172d,0x6dbd2998,0x82db0300,0x543b9a40,0xf8e3b01d,0x0d531335},
	{0x53440b00,0x3aaa2afd,0xb6b6cf86,0x8b794dfc,0xf1970300,0xc1543d96,0x5a7ea28a,0x63b67b61},
	{0x510c0c00,0x251e9889,0x1e406226,0x2f32b340,0xf5360000,0x7be3bf82,0xd5606668,0x3f198195},
	{0xe6a80d00,0xaf01a951,0x9bc9ba8d,0xc9f6d724,0x867a0000,0xee8c1854,0x77fd74ff,0x51fce9c1},
	{0x22400c00,0xb0713f5f,0xbcdd70b1,0x41d7db14,0x31de0100,0x6493298c,0xf274ac54,0xb7388da5},
	{0x95e40d00,0x3a6e0e87,0x3954a81a,0xa713bf70,0x42920100,0xf1fc8e5a,0x50e9bec3,0xd9dde5f1},
	{0xf6b40e00,0x3a0c1cba,0x7ea59bd4,0xb126c636,0x1b100000,0x69a8d7bc,0x55a2b0e7,0x04ea2ab9},
	{0x41100f00,0xb0132d62,0xfb2c437f,0x57e2a252,0x685c0000,0xfcc7706a,0xf73fa270,0x6a0f42ed},
	{0x85f80e00,0xaf63bb6c,0xdc388943,0xdfc3ae62,0xdff80100,0x76d841b2,0x72b67adb,0x8ccb2689},
	{0x325c0f00,0x257c8ab4,0x59b151e8,0x3907ca06,0xacb40100,0xe3b7e664,0xd02b684c,0xe22e4edd},
	{0xbf2a0c00,0x3755f0b7,0x9e82b4a9,0x14c1186c,0xbca80200,0x76ba538f,0x35474915,0x9afe5fcf},
	{0x088e0d00,0xbd4ac16f,0x1b0b6c02,0xf2057c08,0xcfe40200,0xe3d5f459,0x97da5b82,0xf41b379b},
	{0xcc660c00,0xa23a5761,0x3c1fa63e,0x7a247038,0x78400300,0x69cac581,0x12538329,0x12df53ff},
	{0x7bc20d00,0x282566b9,0xb9967e95,0x9ce0145c,0x0b0c0300,0xfca56257,0xb0ce91be,0x7c3a3bab},
	{0x18920e00,0x28477484,0xfe674d5b,0x8ad56d1a,0x528e0200,0x64f13bb1,0xb5859f9a,0xa10df4e3},
	{0xaf360f00,0xa258455c,0x7bee95f0,0x6c11097e,0x21c20200,0xf19e9c67,0x17188d0d,0xcfe89cb7},
	{0x6bde0e00,0xbd28d352,0x5cfa5fcc,0xe430054e,0x96660300,0x7b81adbf,0x929155a6,0x292cf8d3},
	{0xdc7a0f00,0x3737e28a,0xd9738767,0x02f4612a,0xe52a0300,0xeeee0a69,0x300c4731,0x47c99087},
	{0xca8f0800,0x07396701,0x1bf7cf7c,0x82c07470,0x7a080400,0x767e77f5,0xbaa52e89,0xb694ad43},
	{0x7d2b0900,0x8d2656d9,0x9e7e17d7,0x64041014,0x09440400,0xe311d023,0x18383c1e,0xd871c517},
	{0xb9c30800,0x9256c0d7,0xb96addeb,0xec251c24,0xbee00500,0x690ee1fb,0x9db1e4b5,0x3eb5a173},
	{0x0e670900,0x1849f10f,0x3ce30540,0x0ae17840,0xcdac0500,0xfc61462d,0x3f2cf622,0x5050c927},
	{0x6d370a00,0x182be332,0x7b12368e,0x1cd40106,0x942e0400,0x64351fcb,0x3a67f806,0x8d67066f},
	{0xda930b00,0x9234d2ea,0xfe9bee25,0xfa106562,0xe7620400,0xf15ab81d,0x98faea91,0xe3826e3b},
	{0x1e7b0a00,0x8d4444e4,0xd98f2419,0x72316952,0x50c60500,0x7b4589c5,0x1d73323a,0x05460a5f},
	{0xa9df0b00,0x075b753c,0x5c06fcb2,0x94f50d36,0x238a0500,0xee2a2e13,0xbfee20ad,0x6ba3620b},
	{0x24a90800,0x15720f3f,0x9b3519f3,0xb933df5c,0x33960600,0x7b279bf8,0x5a8201f4,0x13737319},
	{0x930d0900,0x9f6d3ee7,0x1ebcc158,0x5ff7bb38,0x40da0600,0xee483c2e,0xf81f1363,0x7d961b4d},
	{0x57e50800,0x801da8e9,0x39a80b64,0xd7d6b708,0xf77e0700,0x64570df6,0x7d96cbc8,0x9b527f29},
	{0xe0410900,0x0a029931,0xbc21d3cf,0x3112d36c,0x84320700,0xf138aa20,0xdf0bd95f,0xf5b7177d},
	{0x83110a00,0x0a608b0c,0xfbd0e001,0x2727aa2a,0xddb00600,0x696cf3c6,0xda40d77b,0x2880d835},
	{0x34b50b00,0x807fbad4,0x7e5938aa,0xc1e3ce4e,0xaefc0600,0xfc035410,0x78ddc5ec,0x4665b061},
	{0xf05d0a00,0x9f0f2cda,0x594df296,0x49c2c27e,0x19580700,0x761c65c8,0xfd541d47,0xa0a1d405},
	{0x47f90b00,0x15101d02,0xdcc42a3d,0xaf06a61a,0x6a140700,0xe373c21e,0x5fc90fd0,0xce44bc51},
	{0x45b10c00,0x0aa4af76,0x7432879d,0x0b4d58a6,0x6eb50400,0x59c4400a,0xd0d7cb32,0x92eb46a5},
	{0xf2150d00,0x80bb9eae,0xf1bb5f36,0xed893cc2,0x1df90400,0xccabe7dc,0x724ad9a5,0xfc0e2ef1},
	{0x36fd0c00,0x9fcb08a0,0xd6af950a,0x65a830f2,0xaa5d0500,0x46b4d604,0xf7c3010e,0x1aca4a95},
	{0x81590d00,0x15d43978,0x53264da1,0x836c5496,0xd9110500,0xd3db71d2,0x555e1399,0x742f22c1},
	{0xe2090e00,0x15b62b45,0x14d77e6f,0x95592dd0,0x80930400,0x4b8f2834,0x50151dbd,0xa918ed89},
	{0x55ad0f00,0x9fa91a9d,0x915ea6c4,0x739d49b4,0xf3df0400,0xdee08fe2,0xf2880f2a,0xc7fd85dd},
	{0x91450e00,0x80d98c93,0xb64a6cf8,0xfbbc4584,0x447b0500,0x54ffbe3a,0x7701d781,0x2139e1b9},
	{0x26e10f00,0x0ac6bd4b,0x33c3b453,0x1d7821e0,0x37370500,0xc19019ec,0xd59cc516,0x4fdc89ed},
	{0xab970c00,0x18efc748,0xf4f05112,0x30bef38a,0x272b0600,0x549dac07,0x30f0e44f,0x370c98ff},
	{0x1c330d00,0x92f0f690,0x717989b9,0xd67a97ee,0x54670600,0xc1f20bd1,0x926df6d8,0x59e9f0ab},
	{0xd8db0c00,0x8d80609e,0x566d4385,0x5e5b9bde,0xe3c30700,0x4bed3a09,0x17e42e73,0xbf2d94cf},
	{0x6f7f0d00,0x079f5146,0xd3e49b2e,0xb89fffba,0x908f0700,0xde829ddf,0xb5793ce4,0xd1c8fc9b},
	{0x0c2f0e00,0x07fd437b,0x9415a8e0,0xaeaa86fc,0xc90d0600,0x46d6c439,0xb03232c0,0x0cff33d3},
	{0xbb8b0f00,0x8de272a3,0x119c704b,0x486ee298,0xba410600,0xd3b963ef,0x12af2057,0x621a5b87},
	{0x7f630e00,0x9292e4ad,0x3688ba77,0xc04feea8,0x0de50700,0x59a65237,0x9726f8fc,0x84de3fe3},
	{0xc8c70f00,0x188dd575,0xb30162dc,0x268b8acc,0x7ea90700,0xccc9f5e1,0x35bbea6b,0xea3b57b7},
	{0xe18b0000,0x5459887d,0xbf1283d3,0x1b666a73,0x3fb90800,0x7cdad883,0xce97a914,0xbdd9f5e5},
	{0x562f0100,0xde46b9a5,0x3a9b5b78,0xfda20e17,0x4cf50800,0xe9b57f55,0x6c0abb83,0xd33c9db1},
	{0x92c70000,0xc1362fab,0x1d8f9144,0x75830227,0xfb510900,0x63aa4e8d,0xe9836328,0x35f8f9d5},
	{0x25630100,0x4b291e73,0x980649ef,0x93476643,0x881d0900,0xf6c5e95b,0x4b1e71bf,0x5b1d9181},
	{0x46330200,0x4b4b0c4e,0xdff77a21,0x85721f05,0xd19f0800,0x6e91b0bd,0x4e557f9b,0x862a5ec9},
	{0xf1970300,0xc1543d96,0x5a7ea28a,0x63b67b61,0xa2d30800,0xfbfe176b,0xecc86d0c,0xe8cf369d},
	{0x357f0200,0xde24ab98,0x7d6a68b6,0xeb977751,0x15770900,0x71e126b3,0x6941b5a7,0x0e0b52f9},
	{0x82db0300,0x543b9a40,0xf8e3b01d,0x0d531335,0x663b0900,0xe48e8165,0xcbdca730,0x60ee3aad},
	{0x0fad0000,0x4612e043,0x3fd0555c,0x2095c15f,0x76270a00,0x7183348e,0x2eb08669,0x183e2bbf},
	{0xb8090100,0xcc0dd19b,0xba598df7,0xc651a53b,0x056b0a00,0xe4ec9358,0x8c2d94fe,0x76db43eb},
	{0x7ce10000,0xd37d4795,0x9d4d47cb,0x4e70a90b,0xb2cf0b00,0x6ef3a280,0x09a44c55,0x901f278f},
	{0xcb450100,0x5962764d,0x18c49f60,0xa8b4cd6f,0xc1830b00,0xfb9c0556,0xab395ec2,0xfefa4fdb},
	{0xa8150200,0x59006470,0x5f35acae,0xbe81b429,0x98010a00,0x63c85cb0,0xae7250e6,0x23cd8093},
	{0x1fb10300,0xd31f55a8,0xdabc7405,0x5845d04d,0xeb4d0a00,0xf6a7fb66,0x0cef4271,0x4d28e8c7},
	{0xdb590200,0xcc6fc3a6,0xfda8be39,0xd064dc7d,0x5ce90b00,0x7cb8cabe,0x89669ada,0xabec8ca3},
	{0x6cfd0300,0x4670f27e,0x78216692,0x36a0b819,0x2fa50b00,0xe9d76d68,0x2bfb884d,0xc509e4f7},
	{0x6eb50400,0x59c4400a,0xd0d7cb32,0x92eb46a5,0x2b040800,0x5360ef7c,0xa4e54caf,0x99a61e03},
	{0xd9110500,0xd3db71d2,0x555e1399,0x742f22c1,0x58480800,0xc60f48aa,0x06785e38,0xf7437657},
	{0x1df90400,0xccabe7dc,0x724ad9a5,0xfc0e2ef1,0xefec0900,0x4c107972,0x83f18693,0x11871233},
	{0xaa5d0500,0x46b4d604,0xf7c3010e,0x1aca4a95,0x9ca00900,0xd97fdea4,0x216c9404,0x7f627a67},
	{0xc90d0600,0x46d6c439,0xb03232c0,0x0cff33d3,0xc5220800,0x412b8742,0x24279a20,0xa255b52f},
	{0x7ea90700,0xccc9f5e1,0x35bbea6b,0xea3b57b7,0xb66e0800,0xd4442094,0x86ba88b7,0xccb0dd7b},
	{0xba410600,0xd3b963ef,0x12af2057,0x621a5b87,0x01ca0900,0x5e5b114c,0x0333501c,0x2a74b91f},
	{0x0de50700,0x59a65237,0x9726f8fc,0x84de3fe3,0x72860900,0xcb34b69a,0xa1ae428b,0x4491d14b},
	{0x80930400,0x4b8f2834,0x50151dbd,0xa918ed89,0x629a0a00,0x5e390371,0x44c263d2,0x3c41c059},
	{0x37370500,0xc19019ec,0xd59cc516,0x4fdc89ed,0x11d60a00,0xcb56a4a7,0xe65f7145,0x52a4a80d},
	{0xf3df0400,0xdee08fe2,0xf2880f2a,0xc7fd85dd,0xa6720b00,0x4149957f,0x63d6a9ee,0xb460cc69},
	{0x447b0500,0x54ffbe3a,0x7701d781,0x2139e1b9,0xd53e0b00,0xd42632a9,0xc14bbb79,0xda85a43d},
	{0x272b0600,0x549dac07,0x30f0e44f,0x370c98ff,0x8cbc0a00,0x4c726b4f,0xc400b55d,0x07b26b75},
	{0x908f0700,0xde829ddf,0xb5793ce4,0xd1c8fc9b,0xfff00a00,0xd91dcc99,0x669da7ca,0x69570321},
	{0x54670600,0xc1f20bd1,0x926df6d8,0x59e9f0ab,0x48540b00,0x5302fd41,0xe3147f61,0x8f936745},
	{0xe3c30700,0x4bed3a09,0x17e42e73,0xbf2d94cf,0x3b180b00,0xc66d5a97,0x41896df6,0xe1760f11},
	{0xf5360000,0x7be3bf82,0xd5606668,0x3f198195,0xa43a0c00,0x5efd270b,0xcb20044e,0x102b32d5},
	{0x42920100,0xf1fc8e5a,0x50e9bec3,0xd9dde5f1,0xd7760c00,0xcb9280dd,0x69bd16d9,0x7ece5a81},
	{0x867a0000,0xee8c1854,0x77fd74ff,0x51fce9c1,0x60d20d00,0x418db105,0xec34ce72,0x980a3ee5},
	{0x31de0100,0x6493298c,0xf274ac54,0xb7388da5,0x139e0d00,0xd4e216d3,0x4ea9dce5,0xf6ef56b1},
	{0x528e0200,0x64f13bb1,0xb5859f9a,0xa10df4e3,0x4a1c0c00,0x4cb64f35,0x4be2d2c1,0x2bd899f9},
	{0xe52a0300,0xeeee0a69,0x300c4731,0x47c99087,0x39500c00,0xd9d9e8e3,0xe97fc056,0x453df1ad},
	{0x21c20200,0xf19e9c67,0x17188d0d,0xcfe89cb7,0x8ef40d00,0x53c6d93b,0x6cf618fd,0xa3f995c9},
	{0x96660300,0x7b81adbf,0x929155a6,0x292cf8d3,0xfdb80d00,0xc6a97eed,0xce6b0a6a,0xcd1cfd9d},
	{0x1b100000,0x69a8d7bc,0x55a2b0e7,0x04ea2ab9,0xeda40e00,0x53a4cb06,0x2b072b33,0xb5ccec8f},
	{0xacb40100,0xe3b7e664,0xd02b684c,0xe22e4edd,0x9ee80e00,0xc6cb6cd0,0x899a39a4,0xdb2984db},
	{0x685c0000,0xfcc7706a,0xf73fa270,0x6a0f42ed,0x294c0f00,0x4cd45d08,0x0c13e10f,0x3dede0bf},
	{0xdff80100,0x76d841b2,0x72b67adb,0x8ccb2689,0x5a000f00,0xd9bbfade,0xae8ef398,0x530888eb},
	{0xbca80200,0x76ba538f,0x35474915,0x9afe5fcf,0x03820e00,0x41efa338,0xabc5fdbc,0x8e3f47a3},
	{0x0b0c0300,0xfca56257,0xb0ce91be,0x7c3a3bab,0x70ce0e00,0xd48004ee,0x0958ef2b,0xe0da2ff7},
	{0xcfe40200,0xe3d5f459,0x97da5b82,0xf41b379b,0xc76a0f00,0x5e9f3536,0x8cd13780,0x061e4b93},
	{0x78400300,0x69cac581,0x12538329,0x12df53ff,0xb4260f00,0xcbf092e0,0x2e4c2517,0x68fb23c7},
	{0x7a080400,0x767e77f5,0xbaa52e89,0xb694ad43,0xb0870c00,0x714710f4,0xa152e1f5,0x3454d933},
	{0xcdac0500,0xfc61462d,0x3f2cf622,0x5050c927,0xc3cb0c00,0xe428b722,0x03cff362,0x5ab1b167},
	{0x09440400,0xe311d023,0x18383c1e,0xd871c517,0x746f0d00,0x6e3786fa,0x86462bc9,0xbc75d503},
	{0xbee00500,0x690ee1fb,0x9db1e4b5,0x3eb5a173,0x07230d00,0xfb58212c,0x24db395e,0xd290bd57},
	{0xddb00600,0x696cf3c6,0xda40d77b,0x2880d835,0x5ea10c00,0x630c78ca,0x2190377a,0x0fa7721f},
	{0x6a140700,0xe373c21e,0x5fc90fd0,0xce44bc51,0x2ded0c00,0xf663df1c,0x830d25ed,0x61421a4b},
	{0xaefc0600,0xfc035410,0x78ddc5ec,0x4665b061,0x9a490d00,0x7c7ceec4,0x0684fd46,0x87867e2f},
	{0x19580700,0x761c65c8,0xfd541d47,0xa0a1d405,0xe9050d00,0xe9134912,0xa419efd1,0xe963167b},
	{0x942e0400,0x64351fcb,0x3a67f806,0x8d67066f,0xf9190e00,0x7c1efcf9,0x4175ce88,0x91b30769},
	{0x238a0500,0xee2a2e13,0xbfee20ad,0x6ba3620b,0x8a550e00,0xe9715b2f,0xe3e8dc1f,0xff566f3d},
	{0xe7620400,0xf15ab81d,0x98faea91,0xe3826e3b,0x3df10f00,0x636e6af7,0x666104b4,0x19920b59},
	{0x50c60500,0x7b4589c5,0x1d73323a,0x05460a5f,0x4ebd0f00,0xf601cd21,0xc4fc1623,0x7777630d},
	{0x33960600,0x7b279bf8,0x5a8201f4,0x13737319,0x173f0e00,0x6e5594c7,0xc1b71807,0xaa40ac45},
	{0x84320700,0xf138aa20,0xdf0bd95f,0xf5b7177d,0x64730e00,0xfb3a3311,0x632a0a90,0xc4a5c411},
	{0x40da0600,0xee483c2e,0xf81f1363,0x7d961b4d,0xd3d70f00,0x712502c9,0xe6a3d23b,0x2261a075},
	{0xf77e0700,0x64570df6,0x7d96cbc8,0x9b527f29,0xa09b0f00,0xe44aa51f,0x443ec0ac,0x4c84c821},
	{0x3fb90800,0x7cdad883,0xce97a914,0xbdd9f5e5,0xde320800,0x288350fe,0x71852ac7,0xa6bf9f96},
	{0x881d0900,0xf6c5e95b,0x4b1e71bf,0x5b1d9181,0xad7e0800,0xbdecf728,0xd3183850,0xc85af7c2},
	{0x4cf50800,0xe9b57f55,0x6c0abb83,0xd33c9db1,0x1ada0900,0x37f3c6f0,0x5691e0fb,0x2e9e93a6},
	{0xfb510900,0x63aa4e8d,0xe9836328,0x35f8f9d5,0x69960900,0xa29c6126,0xf40cf26c,0x407bfbf2},
	{0x98010a00,0x63c85cb0,0xae7250e6,0x23cd8093,0x30140800,0x3ac838c0,0xf147fc48,0x9d4c34ba},
	{0x2fa50b00,0xe9d76d68,0x2bfb884d,0xc509e4f7,0x43580800,0xafa79f16,0x53daeedf,0xf3a95cee},
	{0xeb4d0a00,0xf6a7fb66,0x0cef4271,0x4d28e8c7,0xf4fc0900,0x25b8aece,0xd6533674,0x156d388a},
	{0x5ce90b00,0x7cb8cabe,0x89669ada,0xabec8ca3,0x87b00900,0xb0d70918,0x74ce24e3,0x7b8850de},
	{0xd19f0800,0x6e91b0bd,0x4e557f9b,0x862a5ec9,0x97ac0a00,0x25dabcf3,0x91a205ba,0x035841cc},
	{0x663b0900,0xe48e8165,0xcbdca730,0x60ee3aad,0xe4e00a00,0xb0b51b25,0x333f172d,0x6dbd2998},
	{0xa2d30800,0xfbfe176b,0xecc86d0c,0xe8cf369d,0x53440b00,0x3aaa2afd,0xb6b6cf86,0x8b794dfc},
	{0x15770900,0x71e126b3,0x6941b5a7,0x0e0b52f9,0x20080b00,0xafc58d2b,0x142bdd11,0xe59c25a8},
	{0x76270a00,0x7183348e,0x2eb08669,0x183e2bbf,0x798a0a00,0x3791d4cd,0x1160d335,0x38abeae0},
	{0xc1830b00,0xfb9c0556,0xab395ec2,0xfefa4fdb,0x0ac60a00,0xa2fe731b,0xb3fdc1a2,0x564e82b4},
	{0x056b0a00,0xe4ec9358,0x8c2d94fe,0x76db43eb,0xbd620b00,0x28e142c3,0x36741909,0xb08ae6d0},
	{0xb2cf0b00,0x6ef3a280,0x09a44c55,0x901f278f,0xce2e0b00,0xbd8ee515,0x94e90b9e,0xde6f8e84},
	{0xb0870c00,0x714710f4,0xa152e1f5,0x3454d933,0xca8f0800,0x07396701,0x1bf7cf7c,0x82c07470},
	{0x07230d00,0xfb58212c,0x24db395e,0xd290bd57,0xb9c30800,0x9256c0d7,0xb96addeb,0xec251c24},
	{0xc3cb0c00,0xe428b722,0x03cff362,0x5ab1b167,0x0e670900,0x1849f10f,0x3ce30540,0x0ae17840},
	{0x746f0d00,0x6e3786fa,0x86462bc9,0xbc75d503,0x7d2b0900,0x8d2656d9,0x9e7e17d7,0x64041014},
	{0x173f0e00,0x6e5594c7,0xc1b71807,0xaa40ac45,0x24a90800,0x15720f3f,0x9b3519f3,0xb933df5c},
	{0xa09b0f00,0xe44aa51f,0x443ec0ac,0x4c84c821,0x57e50800,0x801da8e9,0x39a80b64,0xd7d6b708},
	{0x64730e00,0xfb3a3311,0x632a0a90,0xc4a5c411,0xe0410900,0x0a029931,0xbc21d3cf,0x3112d36c},
	{0xd3d70f00,0x712502c9,0xe6a3d23b,0x2261a075,0x930d0900,0x9f6d3ee7,0x1ebcc158,0x5ff7bb38},
	{0x5ea10c00,0x630c78ca,0x2190377a,0x0fa7721f,0x83110a00,0x0a608b0c,0xfbd0e001,0x2727aa2a},
	{0xe9050d00,0xe9134912,0xa419efd1,0xe963167b,0xf05d0a00,0x9f0f2cda,0x594df296,0x49c2c27e},
	{0x2ded0c00,0xf663df1c,0x830d25ed,0x61421a4b,0x47f90b00,0x15101d02,0xdcc42a3d,0xaf06a61a},
	{0x9a490d00,0x7c7ceec4,0x0684fd46,0x87867e2f,0x34b50b00,0x807fbad4,0x7e5938aa,0xc1e3ce4e},
	{0xf9190e00,0x7c1efcf9,0x4175ce88,0x91b30769,0x6d370a00,0x182be332,0x7b12368e,0x1cd40106},
	{0x4ebd0f00,0xf601cd21,0xc4fc1623,0x7777630d,0x1e7b0a00,0x8d4444e4,0xd98f2419,0x72316952},
	{0x8a550e00,0xe9715b2f,0xe3e8dc1f,0xff566f3d,0xa9df0b00,0x075b753c,0x5c06fcb2,0x94f50d36},
	{0x3df10f00,0x636e6af7,0x666104b4,0x19920b59,0xda930b00,0x9234d2ea,0xfe9bee25,0xfa106562},
	{0x2b040800,0x5360ef7c,0xa4e54caf,0x99a61e03,0x45b10c00,0x0aa4af76,0x7432879d,0x0b4d58a6},
	{0x9ca00900,0xd97fdea4,0x216c9404,0x7f627a67,0x36fd0c00,0x9fcb08a0,0xd6af950a,0x65a830f2},
	{0x58480800,0xc60f48aa,0x06785e38,0xf7437657,0x81590d00,0x15d43978,0x53264da1,0x836c5496},
	{0xefec0900,0x4c107972,0x83f18693,0x11871233,0xf2150d00,0x80bb9eae,0xf1bb5f36,0xed893cc2},
	{0x8cbc0a00,0x4c726b4f,0xc400b55d,0x07b26b75,0xab970c00,0x18efc748,0xf4f05112,0x30bef38a},
	{0x3b180b00,0xc66d5a97,0x41896df6,0xe1760f11,0xd8db0c00,0x8d80609e,0x566d4385,0x5e5b9bde},
	{0xfff00a00,0xd91dcc99,0x669da7ca,0x69570321,0x6f7f0d00,0x079f5146,0xd3e49b2e,0xb89fffba},
	{0x48540b00,0x5302fd41,0xe3147f61,0x8f936745,0x1c330d00,0x92f0f690,0x717989b9,0xd67a97ee},
	{0xc5220800,0x412b8742,0x24279a20,0xa255b52f,0x0c2f0e00,0x07fd437b,0x9415a8e0,0xaeaa86fc},
	{0x72860900,0xcb34b69a,0xa1ae428b,0x4491d14b,0x7f630e00,0x9292e4ad,0x3688ba77,0xc04feea8},
	{0xb66e0800,0xd4442094,0x86ba88b7,0xccb0dd7b,0xc8c70f00,0x188dd575,0xb30162dc,0x268b8acc},
	{0x01ca0900,0x5e5b114c,0x0333501c,0x2a74b91f,0xbb8b0f00,0x8de272a3,0x119c704b,0x486ee298},
	{0x629a0a00,0x5e390371,0x44c263d2,0x3c41c059,0xe2090e00,0x15b62b45,0x14d77e6f,0x95592dd0},
	{0xd53e0b00,0xd42632a9,0xc14bbb79,0xda85a43d,0x91450e00,0x80d98c93,0xb64a6cf8,0xfbbc4584},
	{0x11d60a00,0xcb56a4a7,0xe65f7145,0x52a4a80d,0x26e10f00,0x0ac6bd4b,0x33c3b453,0x1d7821e0},
	{0xa6720b00,0x4149957f,0x63d6a9ee,0xb460cc69,0x55ad0f00,0x9fa91a9d,0x915ea6c4,0x739d49b4},
	{0xa43a0c00,0x5efd270b,0xcb20044e,0x102b32d5,0x510c0c00,0x251e9889,0x1e406226,0x2f32b340},
	{0x139e0d00,0xd4e216d3,0x4ea9dce5,0xf6ef56b1,0x22400c00,0xb0713f5f,0xbcdd70b1,0x41d7db14},
	{0xd7760c00,0xcb9280dd,0x69bd16d9,0x7ece5a81,0x95e40d00,0x3a6e0e87,0x3954a81a,0xa713bf70},
	{0x60d20d00,0x418db105,0xec34ce72,0x980a3ee5,0xe6a80d00,0xaf01a951,0x9bc9ba8d,0xc9f6d724},
	{0x03820e00,0x41efa338,0xabc5fdbc,0x8e3f47a3,0xbf2a0c00,0x3755f0b7,0x9e82b4a9,0x14c1186c},
	{0xb4260f00,0xcbf092e0,0x2e4c2517,0x68fb23c7,0xcc660c00,0xa23a5761,0x3c1fa63e,0x7a247038},
	{0x70ce0e00,0xd48004ee,0x0958ef2b,0xe0da2ff7,0x7bc20d00,0x282566b9,0xb9967e95,0x9ce0145c},
	{0xc76a0f00,0x5e9f3536,0x8cd13780,0x061e4b93,0x088e0d00,0xbd4ac16f,0x1b0b6c02,0xf2057c08},
	{0x4a1c0c00,0x4cb64f35,0x4be2d2c1,0x2bd899f9,0x18920e00,0x28477484,0xfe674d5b,0x8ad56d1a},
	{0xfdb80d00,0xc6a97eed,0xce6b0a6a,0xcd1cfd9d,0x6bde0e00,0xbd28d352,0x5cfa5fcc,0xe430054e},
	{0x39500c00,0xd9d9e8e3,0xe97fc056,0x453df1ad,0xdc7a0f00,0x3737e28a,0xd9738767,0x02f4612a},
	{0x8ef40d00,0x53c6d93b,0x6cf618fd,0xa3f995c9,0xaf360f00,0xa258455c,0x7bee95f0,0x6c11097e},
	{0xeda40e00,0x53a4cb06,0x2b072b33,0xb5ccec8f,0xf6b40e00,0x3a0c1cba,0x7ea59bd4,0xb126c636},
	{0x5a000f00,0xd9bbfade,0xae8ef398,0x530888eb,0x85f80e00,0xaf63bb6c,0xdc388943,0xdfc3ae62},
	{0x9ee80e00,0xc6cb6cd0,0x899a39a4,0xdb2984db,0x325c0f00,0x257c8ab4,0x59b151e8,0x3907ca06},
	{0x294c0f00,0x4cd45d08,0x0c13e10f,0x3dede0bf,0x41100f00,0xb0132d62,0xfb2c437f,0x57e2a252}
    },{
	{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x515c0010,0x40f372fb,0xfce72602,0x71575061,0x2e390000,0x64dd6689,0x3cd406fc,0xb1f490bc},
	{0x2e390000,0x64dd6689,0x3cd406fc,0xb1f490bc,0x7f650010,0x242e1472,0xc03320fe,0xc0a3c0dd},
	{0x7f650010,0x242e1472,0xc03320fe,0xc0a3c0dd,0x515c0010,0x40f372fb,0xfce72602,0x71575061},
	{0xa2b80020,0x81e7e5f6,0xf9ce4c04,0xe2afa0c0,0x5c720000,0xc9bacd12,0x79a90df9,0x63e92178},
	{0xf3e40030,0xc114970d,0x05296a06,0x93f8f0a1,0x724b0000,0xad67ab9b,0x457d0b05,0xd21db1c4},
	{0x8c810020,0xe53a837f,0xc51a4af8,0x535b307c,0x23170010,0xed94d960,0xb99a2d07,0xa34ae1a5},
	{0xdddd0030,0xa5c9f184,0x39fd6cfa,0x220c601d,0x0d2e0010,0x8949bfe9,0x854e2bfb,0x12be7119},
	{0x5c720000,0xc9bacd12,0x79a90df9,0x63e92178,0xfeca0020,0x485d28e4,0x806741fd,0x814681b8},
	{0x0d2e0010,0x8949bfe9,0x854e2bfb,0x12be7119,0xd0f30020,0x2c804e6d,0xbcb34701,0x30b21104},
	{0x724b0000,0xad67ab9b,0x457d0b05,0xd21db1c4,0x81af0030,0x6c733c96,0x40546103,0x41e54165},
	{0x23170010,0xed94d960,0xb99a2d07,0xa34ae1a5,0xaf960030,0x08ae5a1f,0x7c8067ff,0xf011d1d9},
	{0xfeca0020,0x485d28e4,0x806741fd,0x814681b8,0xa2b80020,0x81e7e5f6,0xf9ce4c04,0xe2afa0c0},
	{0xaf960030,0x08ae5a1f,0x7c8067ff,0xf011d1d9,0x8c810020,0xe53a837f,0xc51a4af8,0x535b307c},
	{0xd0f30020,0x2c804e6d,0xbcb34701,0x30b21104,0xdddd0030,0xa5c9f184,0x39fd6cfa,0x220c601d},
	{0x81af0030,0x6c733c96,0x40546103,0x41e54165,0xf3e40030,0xc114970d,0x05296a06,0x93f8f0a1},
	{0x4dce0040,0x3b5bec7e,0x36656ba8,0x23633a05,0x78ab0000,0xa0cd5a34,0x5d5ca0f7,0x727784cb},
	{0x1c920050,0x7ba89e85,0xca824daa,0x52346a64,0x56920000,0xc4103cbd,0x6188a60b,0xc3831477},
	{0x63f70040,0x5f868af7,0x0ab16d54,0x9297aab9,0x07ce0010,0x84e34e46,0x9d6f8009,0xb2d44416},
	{0x32ab0050,0x1f75f80c,0xf6564b56,0xe3c0fad8,0x29f70010,0xe03e28cf,0xa1bb86f5,0x0320d4aa},
	{0xef760060,0xbabc0988,0xcfab27ac,0xc1cc9ac5,0x24d90000,0x69779726,0x24f5ad0e,0x119ea5b3},
	{0xbe2a0070,0xfa4f7b73,0x334c01ae,0xb09bcaa4,0x0ae00000,0x0daaf1af,0x1821abf2,0xa06a350f},
	{0xc14f0060,0xde616f01,0xf37f2150,0x70380a79,0x5bbc0010,0x4d598354,0xe4c68df0,0xd13d656e},
	{0x90130070,0x9e921dfa,0x0f980752,0x016f5a18,0x75850010,0x2984e5dd,0xd8128b0c,0x60c9f5d2},
	{0x11bc0040,0xf2e1216c,0x4fcc6651,0x408a1b7d,0x86610020,0xe89072d0,0xdd3be10a,0xf3310573},
	{0x40e00050,0xb2125397,0xb32b4053,0x31dd4b1c,0xa8580020,0x8c4d1459,0xe1efe7f6,0x42c595cf},
	{0x3f850040,0x963c47e5,0x731860ad,0xf17e8bc1,0xf9040030,0xccbe66a2,0x1d08c1f4,0x3392c5ae},
	{0x6ed90050,0xd6cf351e,0x8fff46af,0x8029dba0,0xd73d0030,0xa863002b,0x21dcc708,0x82665512},
	{0xb3040060,0x7306c49a,0xb6022a55,0xa225bbbd,0xda130020,0x212abfc2,0xa492ecf3,0x90d8240b},
	{0xe2580070,0x33f5b661,0x4ae50c57,0xd372ebdc,0xf42a0020,0x45f7d94b,0x9846ea0f,0x212cb4b7},
	{0x9d3d0060,0x17dba213,0x8ad62ca9,0x13d12b01,0xa5760030,0x0504abb0,0x64a1cc0d,0x507be4d6},
	{0xcc610070,0x5728d0e8,0x76310aab,0x62867b60,0x8b4f0030,0x61d9cd39,0x5875caf1,0xe18f746a},
	{0x78ab0000,0xa0cd5a34,0x5d5ca0f7,0x727784cb,0x35650040,0x9b96b64a,0x6b39cb5f,0x5114bece},
	{0x29f70010,0xe03e28cf,0xa1bb86f5,0x0320d4aa,0x1b5c0040,0xff4bd0c3,0x57edcda3,0xe0e02e72},
	{0x56920000,0xc4103cbd,0x6188a60b,0xc3831477,0x4a000050,0xbfb8a238,0xab0aeba1,0x91b77e13},
	{0x07ce0010,0x84e34e46,0x9d6f8009,0xb2d44416,0x64390050,0xdb65c4b1,0x97deed5d,0x2043eeaf},
	{0xda130020,0x212abfc2,0xa492ecf3,0x90d8240b,0x69170040,0x522c7b58,0x1290c6a6,0x32fd9fb6},
	{0x8b4f0030,0x61d9cd39,0x5875caf1,0xe18f746a,0x472e0040,0x36f11dd1,0x2e44c05a,0x83090f0a},
	{0xf42a0020,0x45f7d94b,0x9846ea0f,0x212cb4b7,0x16720050,0x76026f2a,0xd2a3e658,0xf25e5f6b},
	{0xa5760030,0x0504abb0,0x64a1cc0d,0x507be4d6,0x384b0050,0x12df09a3,0xee77e0a4,0x43aacfd7},
	{0x24d90000,0x69779726,0x24f5ad0e,0x119ea5b3,0xcbaf0060,0xd3cb9eae,0xeb5e8aa2,0xd0523f76},
	{0x75850010,0x2984e5dd,0xd8128b0c,0x60c9f5d2,0xe5960060,0xb716f827,0xd78a8c5e,0x61a6afca},
	{0x0ae00000,0x0daaf1af,0x1821abf2,0xa06a350f,0xb4ca0070,0xf7e58adc,0x2b6daa5c,0x10f1ffab},
	{0x5bbc0010,0x4d598354,0xe4c68df0,0xd13d656e,0x9af30070,0x9338ec55,0x17b9aca0,0xa1056f17},
	{0x86610020,0xe89072d0,0xdd3be10a,0xf3310573,0x97dd0060,0x1a7153bc,0x92f7875b,0xb3bb1e0e},
	{0xd73d0030,0xa863002b,0x21dcc708,0x82665512,0xb9e40060,0x7eac3535,0xae2381a7,0x024f8eb2},
	{0xa8580020,0x8c4d1459,0xe1efe7f6,0x42c595cf,0xe8b80070,0x3e5f47ce,0x52c4a7a5,0x7318ded3},
	{0xf9040030,0xccbe66a2,0x1d08c1f4,0x3392c5ae,0xc6810070,0x5a822147,0x6e10a159,0xc2ec4e6f},
	{0x35650040,0x9b96b64a,0x6b39cb5f,0x5114bece,0x4dce0040,0x3b5bec7e,0x36656ba8,0x23633a05},
	{0x64390050,0xdb65c4b1,0x97deed5d,0x2043eeaf,0x63f70040,0x5f868af7,0x0ab16d54,0x9297aab9},
	{0x1b5c0040,0xff4bd0c3,0x57edcda3,0xe0e02e72,0x32ab0050,0x1f75f80c,0xf6564b56,0xe3c0fad8},
	{0x4a000050,0xbfb8a238,0xab0aeba1,0x91b77e13,0x1c920050,0x7ba89e85,0xca824daa,0x52346a64},
	{0x97dd0060,0x1a7153bc,0x92f7875b,0xb3bb1e0e,0x11bc0040,0xf2e1216c,0x4fcc6651,0x408a1b7d},
	{0xc6810070,0x5a822147,0x6e10a159,0xc2ec4e6f,0x3f850040,0x963c47e5,0x731860ad,0xf17e8bc1},
	{0xb9e40060,0x7eac3535,0xae2381a7,0x024f8eb2,0x6ed90050,0xd6cf351e,0x8fff46af,0x8029dba0},
	{0xe8b80070,0x3e5f47ce,0x52c4a7a5,0x7318ded3,0x40e00050,0xb2125397,0xb32b4053,0x31dd4b1c},
	{0x69170040,0x522c7b58,0x1290c6a6,0x32fd9fb6,0xb3040060,0x7306c49a,0xb6022a55,0xa225bbbd},
	{0x384b0050,0x12df09a3,0xee77e0a4,0x43aacfd7,0x9d3d0060,0x17dba213,0x8ad62ca9,0x13d12b01},
	{0x472e0040,0x36f11dd1,0x2e44c05a,0x83090f0a,0xcc610070,0x5728d0e8,0x76310aab,0x62867b60},
	{0x16720050,0x76026f2a,0xd2a3e658,0xf25e5f6b,0xe2580070,0x33f5b661,0x4ae50c57,0xd372ebdc},
	{0xcbaf0060,0xd3cb9eae,0xeb5e8aa2,0xd0523f76,0xef760060,0xbabc0988,0xcfab27ac,0xc1cc9ac5},
	{0x9af30070,0x9338ec55,0x17b9aca0,0xa1056f17,0xc14f0060,0xde616f01,0xf37f2150,0x70380a79},
	{0xe5960060,0xb716f827,0xd78a8c5e,0x61a6afca,0x90130070,0x9e921dfa,0x0f980752,0x016f5a18},
	{0xb4ca0070,0xf7e58adc,0x2b6daa5c,0x10f1ffab,0xbe2a0070,0xfa4f7b73,0x334c01ae,0xb09bcaa4},
	{0x5bd20080,0x450f18ec,0xc2c46c55,0xf362b233,0x39a60000,0x4ab753eb,0xd14e094b,0xb772b42b},
	{0x0a8e0090,0x05fc6a17,0x3e234a57,0x8235e252,0x179f0000,0x2e6a3562,0xed9a0fb7,0x06862497},
	{0x75eb0080,0x21d27e65,0xfe106aa9,0x4296228f,0x46c30010,0x6e994799,0x117d29b5,0x77d174f6},
	{0x24b70090,0x61210c9e,0x02f74cab,0x33c172ee,0x68fa0010,0x0a442110,0x2da92f49,0xc625e44a},
	{0xf96a00a0,0xc4e8fd1a,0x3b0a2051,0x11cd12f3,0x65d40000,0x830d9ef9,0xa8e704b2,0xd49b9553},
	{0xa83600b0,0x841b8fe1,0xc7ed0653,0x609a4292,0x4bed0000,0xe7d0f870,0x9433024e,0x656f05ef},
	{0xd75300a0,0xa0359b93,0x07de26ad,0xa039824f,0x1ab10010,0xa7238a8b,0x68d4244c,0x1438558e},
	{0x860f00b0,0xe0c6e968,0xfb3900af,0xd16ed22e,0x34880010,0xc3feec02,0x540022b0,0xa5ccc532},
	{0x07a00080,0x8cb5d5fe,0xbb6d61ac,0x908b934b,0xc76c0020,0x02ea7b0f,0x512948b6,0x36343593},
	{0x56fc0090,0xcc46a705,0x478a47ae,0xe1dcc32a,0xe9550020,0x66371d86,0x6dfd4e4a,0x87c0a52f},
	{0x29990080,0xe868b377,0x87b96750,0x217f03f7,0xb8090030,0x26c46f7d,0x911a6848,0xf697f54e},
	{0x78c50090,0xa89bc18c,0x7b5e4152,0x50285396,0x96300030,0x421909f4,0xadce6eb4,0x476365f2},
	{0xa51800a0,0x0d523008,0x42a32da8,0x7224338b,0x9b1e0020,0xcb50b61d,0x2880454f,0x55dd14eb},
	{0xf44400b0,0x4da142f3,0xbe440baa,0x037363ea,0xb5270020,0xaf8dd094,0x145443b3,0xe4298457},
	{0x8b2100a0,0x698f5681,0x7e772b54,0xc3d0a337,0xe47b0030,0xef7ea26f,0xe8b365b1,0x957ed436},
	{0xda7d00b0,0x297c247a,0x82900d56,0xb287f356,0xca420030,0x8ba3c4e6,0xd467634d,0x248a448a},
	{0x161c00c0,0x7e54f492,0xf4a107fd,0xd0018836,0x410d0000,0xea7a09df,0x8c12a9bc,0xc50530e0},
	{0x474000d0,0x3ea78669,0x084621ff,0xa156d857,0x6f340000,0x8ea76f56,0xb0c6af40,0x74f1a05c},
	{0x382500c0,0x1a89921b,0xc8750101,0x61f5188a,0x3e680010,0xce541dad,0x4c218942,0x05a6f03d},
	{0x697900d0,0x5a7ae0e0,0x34922703,0x10a248eb,0x10510010,0xaa897b24,0x70f58fbe,0xb4526081},
	{0xb4a400e0,0xffb31164,0x0d6f4bf9,0x32ae28f6,0x1d7f0000,0x23c0c4cd,0xf5bba445,0xa6ec1198},
	{0xe5f800f0,0xbf40639f,0xf1886dfb,0x43f97897,0x33460000,0x471da244,0xc96fa2b9,0x17188124},
	{0x9a9d00e0,0x9b6e77ed,0x31bb4d05,0x835ab84a,0x621a0010,0x07eed0bf,0x358884bb,0x664fd145},
	{0xcbc100f0,0xdb9d0516,0xcd5c6b07,0xf20de82b,0x4c230010,0x6333b636,0x095c8247,0xd7bb41f9},
	{0x4a6e00c0,0xb7ee3980,0x8d080a04,0xb3e8a94e,0xbfc70020,0xa227213b,0x0c75e841,0x4443b158},
	{0x1b3200d0,0xf71d4b7b,0x71ef2c06,0xc2bff92f,0x91fe0020,0xc6fa47b2,0x30a1eebd,0xf5b721e4},
	{0x645700c0,0xd3335f09,0xb1dc0cf8,0x021c39f2,0xc0a20030,0x86093549,0xcc46c8bf,0x84e07185},
	{0x350b00d0,0x93c02df2,0x4d3b2afa,0x734b6993,0xee9b0030,0xe2d453c0,0xf092ce43,0x3514e139},
	{0xe8d600e0,0x3609dc76,0x74c64600,0x5147098e,0xe3b50020,0x6b9dec29,0x75dce5b8,0x27aa9020},
	{0xb98a00f0,0x76faae8d,0x88216002,0x201059ef,0xcd8c0020,0x0f408aa0,0x4908e344,0x965e009c},
	{0xc6ef00e0,0x52d4baff,0x481240fc,0xe0b39932,0x9cd00030,0x4fb3f85b,0xb5efc546,0xe70950fd},
	{0x97b300f0,0x1227c804,0xb4f566fe,0x91e4c953,0xb2e90030,0x2b6e9ed2,0x893bc3ba,0x56fdc041},
	{0x23790080,0xe5c242d8,0x9f98cca2,0x811536f8,0x0cc30040,0xd121e5a1,0xba77c214,0xe6660ae5},
	{0x72250090,0xa5313023,0x637feaa0,0xf0426699,0x22fa0040,0xb5fc8328,0x86a3c4e8,0x57929a59},
	{0x0d400080,0x811f2451,0xa34cca5e,0x30e1a644,0x73a60050,0xf50ff1d3,0x7a44e2ea,0x26c5ca38},
	{0x5c1c0090,0xc1ec56aa,0x5fabec5c,0x41b6f625,0x5d9f0050,0x91d2975a,0x4690e416,0x97315a84},
	{0x81c100a0,0x6425a72e,0x665680a6,0x63ba9638,0x50b10040,0x189b28b3,0xc3decfed,0x858f2b9d},
	{0xd09d00b0,0x24d6d5d5,0x9ab1a6a4,0x12edc659,0x7e880040,0x7c464e3a,0xff0ac911,0x347bbb21},
	{0xaff800a0,0x00f8c1a7,0x5a82865a,0xd24e0684,0x2fd40050,0x3cb53cc1,0x03edef13,0x452ceb40},
	{0xfea400b0,0x400bb35c,0xa665a058,0xa31956e5,0x01ed0050,0x58685a48,0x3f39e9ef,0xf4d87bfc},
	{0x7f0b0080,0x2c788fca,0xe631c15b,0xe2fc1780,0xf2090060,0x997ccd45,0x3a1083e9,0x67208b5d},
	{0x2e570090,0x6c8bfd31,0x1ad6e759,0x93ab47e1,0xdc300060,0xfda1abcc,0x06c48515,0xd6d41be1},
	{0x51320080,0x48a5e943,0xdae5c7a7,0x5308873c,0x8d6c0070,0xbd52d937,0xfa23a317,0xa7834b80},
	{0x006e0090,0x08569bb8,0x2602e1a5,0x225fd75d,0xa3550070,0xd98fbfbe,0xc6f7a5eb,0x1677db3c},
	{0xddb300a0,0xad9f6a3c,0x1fff8d5f,0x0053b740,0xae7b0060,0x50c60057,0x43b98e10,0x04c9aa25},
	{0x8cef00b0,0xed6c18c7,0xe318ab5d,0x7104e721,0x80420060,0x341b66de,0x7f6d88ec,0xb53d3a99},
	{0xf38a00a0,0xc9420cb5,0x232b8ba3,0xb1a727fc,0xd11e0070,0x74e81425,0x838aaeee,0xc46a6af8},
	{0xa2d600b0,0x89b17e4e,0xdfccada1,0xc0f0779d,0xff270070,0x103572ac,0xbf5ea812,0x759efa44},
	{0x6eb700c0,0xde99aea6,0xa9fda70a,0xa2760cfd,0x74680040,0x71ecbf95,0xe72b62e3,0x94118e2e},
	{0x3feb00d0,0x9e6adc5d,0x551a8108,0xd3215c9c,0x5a510040,0x1531d91c,0xdbff641f,0x25e51e92},
	{0x408e00c0,0xba44c82f,0x9529a1f6,0x13829c41,0x0b0d0050,0x55c2abe7,0x2718421d,0x54b24ef3},
	{0x11d200d0,0xfab7bad4,0x69ce87f4,0x62d5cc20,0x25340050,0x311fcd6e,0x1bcc44e1,0xe546de4f},
	{0xcc0f00e0,0x5f7e4b50,0x5033eb0e,0x40d9ac3d,0x281a0040,0xb8567287,0x9e826f1a,0xf7f8af56},
	{0x9d5300f0,0x1f8d39ab,0xacd4cd0c,0x318efc5c,0x06230040,0xdc8b140e,0xa25669e6,0x460c3fea},
	{0xe23600e0,0x3ba32dd9,0x6ce7edf2,0xf12d3c81,0x577f0050,0x9c7866f5,0x5eb14fe4,0x375b6f8b},
	{0xb36a00f0,0x7b505f22,0x9000cbf0,0x807a6ce0,0x79460050,0xf8a5007c,0x62654918,0x86afff37},
	{0x32c500c0,0x172363b4,0xd054aaf3,0xc19f2d85,0x8aa20060,0x39b19771,0x674c231e,0x15570f96},
	{0x639900d0,0x57d0114f,0x2cb38cf1,0xb0c87de4,0xa49b0060,0x5d6cf1f8,0x5b9825e2,0xa4a39f2a},
	{0x1cfc00c0,0x73fe053d,0xec80ac0f,0x706bbd39,0xf5c70070,0x1d9f8303,0xa77f03e0,0xd5f4cf4b},
	{0x4da000d0,0x330d77c6,0x10678a0d,0x013ced58,0xdbfe0070,0x7942e58a,0x9bab051c,0x64005ff7},
	{0x907d00e0,0x96c48642,0x299ae6f7,0x23308d45,0xd6d00060,0xf00b5a63,0x1ee52ee7,0x76be2eee},
	{0xc12100f0,0xd637f4b9,0xd57dc0f5,0x5267dd24,0xf8e90060,0x94d63cea,0x2231281b,0xc74abe52},
	{0xbe4400e0,0xf219e0cb,0x154ee00b,0x92c41df9,0xa9b50070,0xd4254e11,0xded60e19,0xb61dee33},
	{0xef1800f0,0xb2ea9230,0xe9a9c609,0xe3934d98,0x878c0070,0xb0f82898,0xe20208e5,0x07e97e8f},
	{0x39a60000,0x4ab753eb,0xd14e094b,0xb772b42b,0x62740080,0x0fb84b07,0x138a651e,0x44100618},
	{0x68fa0010,0x0a442110,0x2da92f49,0xc625e44a,0x4c4d0080,0x6b652d8e,0x2f5e63e2,0xf5e496a4},
	{0x179f0000,0x2e6a3562,0xed9a0fb7,0x06862497,0x1d110090,0x2b965f75,0xd3b945e0,0x84b3c6c5},
	{0x46c30010,0x6e994799,0x117d29b5,0x77d174f6,0x33280090,0x4f4b39fc,0xef6d431c,0x35475679},
	{0x9b1e0020,0xcb50b61d,0x2880454f,0x55dd14eb,0x3e060080,0xc6028615,0x6a2368e7,0x27f92760},
	{0xca420030,0x8ba3c4e6,0xd467634d,0x248a448a,0x103f0080,0xa2dfe09c,0x56f76e1b,0x960db7dc},
	{0xb5270020,0xaf8dd094,0x145443b3,0xe4298457,0x41630090,0xe22c9267,0xaa104819,0xe75ae7bd},
	{0xe47b0030,0xef7ea26f,0xe8b365b1,0x957ed436,0x6f5a0090,0x86f1f4ee,0x96c44ee5,0x56ae7701},
	{0x65d40000,0x830d9ef9,0xa8e704b2,0xd49b9553,0x9cbe00a0,0x47e563e3,0x93ed24e3,0xc55687a0},
	{0x34880010,0xc3feec02,0x540022b0,0xa5ccc532,0xb28700a0,0x2338056a,0xaf39221f,0x74a2171c},
	{0x4bed0000,0xe7d0f870,0x9433024e,0x656f05ef,0xe3db00b0,0x63cb7791,0x53de041d,0x05f5477d},
	{0x1ab10010,0xa7238a8b,0x68d4244c,0x1438558e,0xcde200b0,0x07161118,0x6f0a02e1,0xb401d7c1},
	{0xc76c0020,0x02ea7b0f,0x512948b6,0x36343593,0xc0cc00a0,0x8e5faef1,0xea44291a,0xa6bfa6d8},
	{0x96300030,0x421909f4,0xadce6eb4,0x476365f2,0xeef500a0,0xea82c878,0xd6902fe6,0x174b3664},
	{0xe9550020,0x66371d86,0x6dfd4e4a,0x87c0a52f,0xbfa900b0,0xaa71ba83,0x2a7709e4,0x661c6605},
	{0xb8090030,0x26c46f7d,0x911a6848,0xf697f54e,0x919000b0,0xceacdc0a,0x16a30f18,0xd7e8f6b9},
	{0x74680040,0x71ecbf95,0xe72b62e3,0x94118e2e,0x1adf0080,0xaf751133,0x4ed6c5e9,0x366782d3},
	{0x25340050,0x311fcd6e,0x1bcc44e1,0xe546de4f,0x34e60080,0xcba877ba,0x7202c315,0x8793126f},
	{0x5a510040,0x1531d91c,0xdbff641f,0x25e51e92,0x65ba0090,0x8b5b0541,0x8ee5e517,0xf6c4420e},
	{0x0b0d0050,0x55c2abe7,0x2718421d,0x54b24ef3,0x4b830090,0xef8663c8,0xb231e3eb,0x4730d2b2},
	{0xd6d00060,0xf00b5a63,0x1ee52ee7,0x76be2eee,0x46ad0080,0x66cfdc21,0x377fc810,0x558ea3ab},
	{0x878c0070,0xb0f82898,0xe20208e5,0x07e97e8f,0x68940080,0x0212baa8,0x0babceec,0xe47a3317},
	{0xf8e90060,0x94d63cea,0x2231281b,0xc74abe52,0x39c80090,0x42e1c853,0xf74ce8ee,0x952d6376},
	{0xa9b50070,0xd4254e11,0xded60e19,0xb61dee33,0x17f10090,0x263caeda,0xcb98ee12,0x24d9f3ca},
	{0x281a0040,0xb8567287,0x9e826f1a,0xf7f8af56,0xe41500a0,0xe72839d7,0xceb18414,0xb721036b},
	{0x79460050,0xf8a5007c,0x62654918,0x86afff37,0xca2c00a0,0x83f55f5e,0xf26582e8,0x06d593d7},
	{0x06230040,0xdc8b140e,0xa25669e6,0x460c3fea,0x9b7000b0,0xc3062da5,0x0e82a4ea,0x7782c3b6},
	{0x577f0050,0x9c7866f5,0x5eb14fe4,0x375b6f8b,0xb54900b0,0xa7db4b2c,0x3256a216,0xc676530a},
	{0x8aa20060,0x39b19771,0x674c231e,0x15570f96,0xb86700a0,0x2e92f4c5,0xb71889ed,0xd4c82213},
	{0xdbfe0070,0x7942e58a,0x9bab051c,0x64005ff7,0x965e00a0,0x4a4f924c,0x8bcc8f11,0x653cb2af},
	{0xa49b0060,0x5d6cf1f8,0x5b9825e2,0xa4a39f2a,0xc70200b0,0x0abce0b7,0x772ba913,0x146be2ce},
	{0xf5c70070,0x1d9f8303,0xa77f03e0,0xd5f4cf4b,0xe93b00b0,0x6e61863e,0x4bffafef,0xa59f7272},
	{0x410d0000,0xea7a09df,0x8c12a9bc,0xc50530e0,0x571100c0,0x942efd4d,0x78b3ae41,0x1504b8d6},
	{0x10510010,0xaa897b24,0x70f58fbe,0xb4526081,0x792800c0,0xf0f39bc4,0x4467a8bd,0xa4f0286a},
	{0x6f340000,0x8ea76f56,0xb0c6af40,0x74f1a05c,0x287400d0,0xb000e93f,0xb8808ebf,0xd5a7780b},
	{0x3e680010,0xce541dad,0x4c218942,0x05a6f03d,0x064d00d0,0xd4dd8fb6,0x84548843,0x6453e8b7},
	{0xe3b50020,0x6b9dec29,0x75dce5b8,0x27aa9020,0x0b6300c0,0x5d94305f,0x011aa3b8,0x76ed99ae},
	{0xb2e90030,0x2b6e9ed2,0x893bc3ba,0x56fdc041,0x255a00c0,0x394956d6,0x3dcea544,0xc7190912},
	{0xcd8c0020,0x0f408aa0,0x4908e344,0x965e009c,0x740600d0,0x79ba242d,0xc1298346,0xb64e5973},
	{0x9cd00030,0x4fb3f85b,0xb5efc546,0xe70950fd,0x5a3f00d0,0x1d6742a4,0xfdfd85ba,0x07bac9cf},
	{0x1d7f0000,0x23c0c4cd,0xf5bba445,0xa6ec1198,0xa9db00e0,0xdc73d5a9,0xf8d4efbc,0x9442396e},
	{0x4c230010,0x6333b636,0x095c8247,0xd7bb41f9,0x87e200e0,0xb8aeb320,0xc400e940,0x25b6a9d2},
	{0x33460000,0x471da244,0xc96fa2b9,0x17188124,0xd6be00f0,0xf85dc1db,0x38e7cf42,0x54e1f9b3},
	{0x621a0010,0x07eed0bf,0x358884bb,0x664fd145,0xf88700f0,0x9c80a752,0x0433c9be,0xe515690f},
	{0xbfc70020,0xa227213b,0x0c75e841,0x4443b158,0xf5a900e0,0x15c918bb,0x817de245,0xf7ab1816},
	{0xee9b0030,0xe2d453c0,0xf092ce43,0x3514e139,0xdb9000e0,0x71147e32,0xbda9e4b9,0x465f88aa},
	{0x91fe0020,0xc6fa47b2,0x30a1eebd,0xf5b721e4,0x8acc00f0,0x31e70cc9,0x414ec2bb,0x3708d8cb},
	{0xc0a20030,0x86093549,0xcc46c8bf,0x84e07185,0xa4f500f0,0x553a6a40,0x7d9ac447,0x86fc4877},
	{0x0cc30040,0xd121e5a1,0xba77c214,0xe6660ae5,0x2fba00c0,0x34e3a779,0x25ef0eb6,0x67733c1d},
	{0x5d9f0050,0x91d2975a,0x4690e416,0x97315a84,0x018300c0,0x503ec1f0,0x193b084a,0xd687aca1},
	{0x22fa0040,0xb5fc8328,0x86a3c4e8,0x57929a59,0x50df00d0,0x10cdb30b,0xe5dc2e48,0xa7d0fcc0},
	{0x73a60050,0xf50ff1d3,0x7a44e2ea,0x26c5ca38,0x7ee600d0,0x7410d582,0xd90828b4,0x16246c7c},
	{0xae7b0060,0x50c60057,0x43b98e10,0x04c9aa25,0x73c800c0,0xfd596a6b,0x5c46034f,0x049a1d65},
	{0xff270070,0x103572ac,0xbf5ea812,0x759efa44,0x5df100c0,0x99840ce2,0x609205b3,0xb56e8dd9},
	{0x80420060,0x341b66de,0x7f6d88ec,0xb53d3a99,0x0cad00d0,0xd9777e19,0x9c7523b1,0xc439ddb8},
	{0xd11e0070,0x74e81425,0x838aaeee,0xc46a6af8,0x229400d0,0xbdaa1890,0xa0a1254d,0x75cd4d04},
	{0x50b10040,0x189b28b3,0xc3decfed,0x858f2b9d,0xd17000e0,0x7cbe8f9d,0xa5884f4b,0xe635bda5},
	{0x01ed0050,0x58685a48,0x3f39e9ef,0xf4d87bfc,0xff4900e0,0x1863e914,0x995c49b7,0x57c12d19},
	{0x7e880040,0x7c464e3a,0xff0ac911,0x347bbb21,0xae1500f0,0x58909bef,0x65bb6fb5,0x26967d78},
	{0x2fd40050,0x3cb53cc1,0x03edef13,0x452ceb40,0x802c00f0,0x3c4dfd66,0x596f6949,0x9762edc4},
	{0xf2090060,0x997ccd45,0x3a1083e9,0x67208b5d,0x8d0200e0,0xb504428f,0xdc2142b2,0x85dc9cdd},
	{0xa3550070,0xd98fbfbe,0xc6f7a5eb,0x1677db3c,0xa33b00e0,0xd1d92406,0xe0f5444e,0x34280c61},
	{0xdc300060,0xfda1abcc,0x06c48515,0xd6d41be1,0xf26700f0,0x912a56fd,0x1c12624c,0x457f5c00},
	{0x8d6c0070,0xbd52d937,0xfa23a317,0xa7834b80,0xdc5e00f0,0xf5f73074,0x20c664b0,0xf48bccbc},
	{0x62740080,0x0fb84b07,0x138a651e,0x44100618,0x5bd20080,0x450f18ec,0xc2c46c55,0xf362b233},
	{0x33280090,0x4f4b39fc,0xef6d431c,0x35475679,0x75eb0080,0x21d27e65,0xfe106aa9,0x4296228f},
	{0x4c4d0080,0x6b652d8e,0x2f5e63e2,0xf5e496a4,0x24b70090,0x61210c9e,0x02f74cab,0x33c172ee},
	{0x1d110090,0x2b965f75,0xd3b945e0,0x84b3c6c5,0x0a8e0090,0x05fc6a17,0x3e234a57,0x8235e252},
	{0xc0cc00a0,0x8e5faef1,0xea44291a,0xa6bfa6d8,0x07a00080,0x8cb5d5fe,0xbb6d61ac,0x908b934b},
	{0x919000b0,0xceacdc0a,0x16a30f18,0xd7e8f6b9,0x29990080,0xe868b377,0x87b96750,0x217f03f7},
	{0xeef500a0,0xea82c878,0xd6902fe6,0x174b3664,0x78c50090,0xa89bc18c,0x7b5e4152,0x50285396},
	{0xbfa900b0,0xaa71ba83,0x2a7709e4,0x661c6605,0x56fc0090,0xcc46a705,0x478a47ae,0xe1dcc32a},
	{0x3e060080,0xc6028615,0x6a2368e7,0x27f92760,0xa51800a0,0x0d523008,0x42a32da8,0x7224338b},
	{0x6f5a0090,0x86f1f4ee,0x96c44ee5,0x56ae7701,0x8b2100a0,0x698f5681,0x7e772b54,0xc3d0a337},
	{0x103f0080,0xa2dfe09c,0x56f76e1b,0x960db7dc,0xda7d00b0,0x297c247a,0x82900d56,0xb287f356},
	{0x41630090,0xe22c9267,0xaa104819,0xe75ae7bd,0xf44400b0,0x4da142f3,0xbe440baa,0x037363ea},
	{0x9cbe00a0,0x47e563e3,0x93ed24e3,0xc55687a0,0xf96a00a0,0xc4e8fd1a,0x3b0a2051,0x11cd12f3},
	{0xcde200b0,0x07161118,0x6f0a02e1,0xb401d7c1,0xd75300a0,0xa0359b93,0x07de26ad,0xa039824f},
	{0xb28700a0,0x2338056a,0xaf39221f,0x74a2171c,0x860f00b0,0xe0c6e968,0xfb3900af,0xd16ed22e},
	{0xe3db00b0,0x63cb7791,0x53de041d,0x05f5477d,0xa83600b0,0x841b8fe1,0xc7ed0653,0x609a4292},
	{0x2fba00c0,0x34e3a779,0x25ef0eb6,0x67733c1d,0x23790080,0xe5c242d8,0x9f98cca2,0x811536f8},
	{0x7ee600d0,0x7410d582,0xd90828b4,0x16246c7c,0x0d400080,0x811f2451,0xa34cca5e,0x30e1a644},
	{0x018300c0,0x503ec1f0,0x193b084a,0xd687aca1,0x5c1c0090,0xc1ec56aa,0x5fabec5c,0x41b6f625},
	{0x50df00d0,0x10cdb30b,0xe5dc2e48,0xa7d0fcc0,0x72250090,0xa5313023,0x637feaa0,0xf0426699},
	{0x8d0200e0,0xb504428f,0xdc2142b2,0x85dc9cdd,0x7f0b0080,0x2c788fca,0xe631c15b,0xe2fc1780},
	{0xdc5e00f0,0xf5f73074,0x20c664b0,0xf48bccbc,0x51320080,0x48a5e943,0xdae5c7a7,0x5308873c},
	{0xa33b00e0,0xd1d92406,0xe0f5444e,0x34280c61,0x006e0090,0x08569bb8,0x2602e1a5,0x225fd75d},
	{0xf26700f0,0x912a56fd,0x1c12624c,0x457f5c00,0x2e570090,0x6c8bfd31,0x1ad6e759,0x93ab47e1},
	{0x73c800c0,0xfd596a6b,0x5c46034f,0x049a1d65,0xddb300a0,0xad9f6a3c,0x1fff8d5f,0x0053b740},
	{0x229400d0,0xbdaa1890,0xa0a1254d,0x75cd4d04,0xf38a00a0,0xc9420cb5,0x232b8ba3,0xb1a727fc},
	{0x5df100c0,0x99840ce2,0x609205b3,0xb56e8dd9,0xa2d600b0,0x89b17e4e,0xdfccada1,0xc0f0779d},
	{0x0cad00d0,0xd9777e19,0x9c7523b1,0xc439ddb8,0x8cef00b0,0xed6c18c7,0xe318ab5d,0x7104e721},
	{0xd17000e0,0x7cbe8f9d,0xa5884f4b,0xe635bda5,0x81c100a0,0x6425a72e,0x665680a6,0x63ba9638},
	{0x802c00f0,0x3c4dfd66,0x596f6949,0x9762edc4,0xaff800a0,0x00f8c1a7,0x5a82865a,0xd24e0684},
	{0xff4900e0,0x1863e914,0x995c49b7,0x57c12d19,0xfea400b0,0x400bb35c,0xa665a058,0xa31956e5},
	{0xae1500f0,0x58909bef,0x65bb6fb5,0x26967d78,0xd09d00b0,0x24d6d5d5,0x9ab1a6a4,0x12edc659},
	{0x1adf0080,0xaf751133,0x4ed6c5e9,0x366782d3,0x6eb700c0,0xde99aea6,0xa9fda70a,0xa2760cfd},
	{0x4b830090,0xef8663c8,0xb231e3eb,0x4730d2b2,0x408e00c0,0xba44c82f,0x9529a1f6,0x13829c41},
	{0x34e60080,0xcba877ba,0x7202c315,0x8793126f,0x11d200d0,0xfab7bad4,0x69ce87f4,0x62d5cc20},
	{0x65ba0090,0x8b5b0541,0x8ee5e517,0xf6c4420e,0x3feb00d0,0x9e6adc5d,0x551a8108,0xd3215c9c},
	{0xb86700a0,0x2e92f4c5,0xb71889ed,0xd4c82213,0x32c500c0,0x172363b4,0xd054aaf3,0xc19f2d85},
	{0xe93b00b0,0x6e61863e,0x4bffafef,0xa59f7272,0x1cfc00c0,0x73fe053d,0xec80ac0f,0x706bbd39},
	{0x965e00a0,0x4a4f924c,0x8bcc8f11,0x653cb2af,0x4da000d0,0x330d77c6,0x10678a0d,0x013ced58},
	{0xc70200b0,0x0abce0b7,0x772ba913,0x146be2ce,0x639900d0,0x57d0114f,0x2cb38cf1,0xb0c87de4},
	{0x46ad0080,0x66cfdc21,0x377fc810,0x558ea3ab,0x907d00e0,0x96c48642,0x299ae6f7,0x23308d45},
	{0x17f10090,0x263caeda,0xcb98ee12,0x24d9f3ca,0xbe4400e0,0xf219e0cb,0x154ee00b,0x92c41df9},
	{0x68940080,0x0212baa8,0x0babceec,0xe47a3317,0xef1800f0,0xb2ea9230,0xe9a9c609,0xe3934d98},
	{0x39c80090,0x42e1c853,0xf74ce8ee,0x952d6376,0xc12100f0,0xd637f4b9,0xd57dc0f5,0x5267dd24},
	{0xe41500a0,0xe72839d7,0xceb18414,0xb721036b,0xcc0f00e0,0x5f7e4b50,0x5033eb0e,0x40d9ac3d},
	{0xb54900b0,0xa7db4b2c,0x3256a216,0xc676530a,0xe23600e0,0x3ba32dd9,0x6ce7edf2,0xf12d3c81},
	{0xca2c00a0,0x83f55f5e,0xf26582e8,0x06d593d7,0xb36a00f0,0x7b505f22,0x9000cbf0,0x807a6ce0},
	{0x9b7000b0,0xc3062da5,0x0e82a4ea,0x7782c3b6,0x9d5300f0,0x1f8d39ab,0xacd4cd0c,0x318efc5c},
	{0x571100c0,0x942efd4d,0x78b3ae41,0x1504b8d6,0x161c00c0,0x7e54f492,0xf4a107fd,0xd0018836},
	{0x064d00d0,0xd4dd8fb6,0x84548843,0x6453e8b7,0x382500c0,0x1a89921b,0xc8750101,0x61f5188a},
	{0x792800c0,0xf0f39bc4,0x4467a8bd,0xa4f0286a,0x697900d0,0x5a7ae0e0,0x34922703,0x10a248eb},
	{0x287400d0,0xb000e93f,0xb8808ebf,0xd5a7780b,0x474000d0,0x3ea78669,0x084621ff,0xa156d857},
	{0xf5a900e0,0x15c918bb,0x817de245,0xf7ab1816,0x4a6e00c0,0xb7ee3980,0x8d080a04,0xb3e8a94e},
	{0xa4f500f0,0x553a6a40,0x7d9ac447,0x86fc4877,0x645700c0,0xd3335f09,0xb1dc0cf8,0x021c39f2},
	{0xdb9000e0,0x71147e32,0xbda9e4b9,0x465f88aa,0x350b00d0,0x93c02df2,0x4d3b2afa,0x734b6993},
	{0x8acc00f0,0x31e70cc9,0x414ec2bb,0x3708d8cb,0x1b3200d0,0xf71d4b7b,0x71ef2c06,0xc2bff92f},
	{0x0b6300c0,0x5d94305f,0x011aa3b8,0x76ed99ae,0xe8d600e0,0x3609dc76,0x74c64600,0x5147098e},
	{0x5a3f00d0,0x1d6742a4,0xfdfd85ba,0x07bac9cf,0xc6ef00e0,0x52d4baff,0x481240fc,0xe0b39932},
	{0x255a00c0,0x394956d6,0x3dcea544,0xc7190912,0x97b300f0,0x1227c804,0xb4f566fe,0x91e4c953},
	{0x740600d0,0x79ba242d,0xc1298346,0xb64e5973,0xb98a00f0,0x76faae8d,0x88216002,0x201059ef},
	{0xa9db00e0,0xdc73d5a9,0xf8d4efbc,0x9442396e,0xb4a400e0,0xffb31164,0x0d6f4bf9,0x32ae28f6},
	{0xf88700f0,0x9c80a752,0x0433c9be,0xe515690f,0x9a9d00e0,0x9b6e77ed,0x31bb4d05,0x835ab84a},
	{0x87e200e0,0xb8aeb320,0xc400e940,0x25b6a9d2,0xcbc100f0,0xdb9d0516,0xcd5c6b07,0xf20de82b},
	{0xd6be00f0,0xf85dc1db,0x38e7cf42,0x54e1f9b3,0xe5f800f0,0xbf40639f,0xf1886dfb,0x43f97897}
    },{
	{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0xc04e0001,0x33b9c010,0xae0ebb05,0xb5a4c63b,0xc8f10000,0x0b2de782,0x6bf648a4,0x539cbdbf},
	{0xc8f10000,0x0b2de782,0x6bf648a4,0x539cbdbf,0x08bf0001,0x38942792,0xc5f8f3a1,0xe6387b84},
	{0x08bf0001,0x38942792,0xc5f8f3a1,0xe6387b84,0xc04e0001,0x33b9c010,0xae0ebb05,0xb5a4c63b},
	{0x88230002,0x5fe7a7b3,0x99e585aa,0x8d75f7f1,0x51ac0000,0x25e30f14,0x79e22a4c,0x1298bd46},
	{0x486d0003,0x6c5e67a3,0x37eb3eaf,0x38d131ca,0x995d0000,0x2ecee896,0x121462e8,0x410400f9},
	{0x40d20002,0x54ca4031,0xf213cd0e,0xdee94a4e,0x59130001,0x1d772886,0xbc1ad9ed,0xf4a0c6c2},
	{0x809c0003,0x67738021,0x5c1d760b,0x6b4d8c75,0x91e20001,0x165acf04,0xd7ec9149,0xa73c7b7d},
	{0x51ac0000,0x25e30f14,0x79e22a4c,0x1298bd46,0xd98f0002,0x7a04a8a7,0xe007afe6,0x9fed4ab7},
	{0x91e20001,0x165acf04,0xd7ec9149,0xa73c7b7d,0x117e0002,0x71294f25,0x8bf1e742,0xcc71f708},
	{0x995d0000,0x2ecee896,0x121462e8,0x410400f9,0xd1300003,0x42908f35,0x25ff5c47,0x79d53133},
	{0x59130001,0x1d772886,0xbc1ad9ed,0xf4a0c6c2,0x19c10003,0x49bd68b7,0x4e0914e3,0x2a498c8c},
	{0xd98f0002,0x7a04a8a7,0xe007afe6,0x9fed4ab7,0x88230002,0x5fe7a7b3,0x99e585aa,0x8d75f7f1},
	{0x19c10003,0x49bd68b7,0x4e0914e3,0x2a498c8c,0x40d20002,0x54ca4031,0xf213cd0e,0xdee94a4e},
	{0x117e0002,0x71294f25,0x8bf1e742,0xcc71f708,0x809c0003,0x67738021,0x5c1d760b,0x6b4d8c75},
	{0xd1300003,0x42908f35,0x25ff5c47,0x79d53133,0x486d0003,0x6c5e67a3,0x37eb3eaf,0x38d131ca},
	{0xd0080004,0x8c768f77,0x9dc5b050,0xaf4a29da,0x6ba90000,0x40ebf9aa,0x98321c3d,0x76acc733},
	{0x10460005,0xbfcf4f67,0x33cb0b55,0x1aeeefe1,0xa3580000,0x4bc61e28,0xf3c45499,0x25307a8c},
	{0x18f90004,0x875b68f5,0xf633f8f4,0xfcd69465,0x63160001,0x787fde38,0x5dcaef9c,0x9094bcb7},
	{0xd8b70005,0xb4e2a8e5,0x583d43f1,0x4972525e,0xabe70001,0x735239ba,0x363ca738,0xc3080108},
	{0x582b0006,0xd39128c4,0x042035fa,0x223fde2b,0x3a050000,0x6508f6be,0xe1d03671,0x64347a75},
	{0x98650007,0xe028e8d4,0xaa2e8eff,0x979b1810,0xf2f40000,0x6e25113c,0x8a267ed5,0x37a8c7ca},
	{0x90da0006,0xd8bccf46,0x6fd67d5e,0x71a36394,0x32ba0001,0x5d9cd12c,0x2428c5d0,0x820c01f1},
	{0x50940007,0xeb050f56,0xc1d8c65b,0xc407a5af,0xfa4b0001,0x56b136ae,0x4fde8d74,0xd190bc4e},
	{0x81a40004,0xa9958063,0xe4279a1c,0xbdd2949c,0xb2260002,0x3aef510d,0x7835b3db,0xe9418d84},
	{0x41ea0005,0x9a2c4073,0x4a292119,0x087652a7,0x7ad70002,0x31c2b68f,0x13c3fb7f,0xbadd303b},
	{0x49550004,0xa2b867e1,0x8fd1d2b8,0xee4e2923,0xba990003,0x027b769f,0xbdcd407a,0x0f79f600},
	{0x891b0005,0x9101a7f1,0x21df69bd,0x5beaef18,0x72680003,0x0956911d,0xd63b08de,0x5ce54bbf},
	{0x09870006,0xf67227d0,0x7dc21fb6,0x30a7636d,0xe38a0002,0x1f0c5e19,0x01d79997,0xfbd930c2},
	{0xc9c90007,0xc5cbe7c0,0xd3cca4b3,0x8503a556,0x2b7b0002,0x1421b99b,0x6a21d133,0xa8458d7d},
	{0xc1760006,0xfd5fc052,0x16345712,0x633bded2,0xeb350003,0x2798798b,0xc42f6a36,0x1de14b46},
	{0x01380007,0xcee60042,0xb83aec17,0xd69f18e9,0x23c40003,0x2cb59e09,0xafd92292,0x4e7df6f9},
	{0x6ba90000,0x40ebf9aa,0x98321c3d,0x76acc733,0xbba10004,0xcc9d76dd,0x05f7ac6d,0xd9e6eee9},
	{0xabe70001,0x735239ba,0x363ca738,0xc3080108,0x73500004,0xc7b0915f,0x6e01e4c9,0x8a7a5356},
	{0xa3580000,0x4bc61e28,0xf3c45499,0x25307a8c,0xb31e0005,0xf409514f,0xc00f5fcc,0x3fde956d},
	{0x63160001,0x787fde38,0x5dcaef9c,0x9094bcb7,0x7bef0005,0xff24b6cd,0xabf91768,0x6c4228d2},
	{0xe38a0002,0x1f0c5e19,0x01d79997,0xfbd930c2,0xea0d0004,0xe97e79c9,0x7c158621,0xcb7e53af},
	{0x23c40003,0x2cb59e09,0xafd92292,0x4e7df6f9,0x22fc0004,0xe2539e4b,0x17e3ce85,0x98e2ee10},
	{0x2b7b0002,0x1421b99b,0x6a21d133,0xa8458d7d,0xe2b20005,0xd1ea5e5b,0xb9ed7580,0x2d46282b},
	{0xeb350003,0x2798798b,0xc42f6a36,0x1de14b46,0x2a430005,0xdac7b9d9,0xd21b3d24,0x7eda9594},
	{0x3a050000,0x6508f6be,0xe1d03671,0x64347a75,0x622e0006,0xb699de7a,0xe5f0038b,0x460ba45e},
	{0xfa4b0001,0x56b136ae,0x4fde8d74,0xd190bc4e,0xaadf0006,0xbdb439f8,0x8e064b2f,0x159719e1},
	{0xf2f40000,0x6e25113c,0x8a267ed5,0x37a8c7ca,0x6a910007,0x8e0df9e8,0x2008f02a,0xa033dfda},
	{0x32ba0001,0x5d9cd12c,0x2428c5d0,0x820c01f1,0xa2600007,0x85201e6a,0x4bfeb88e,0xf3af6265},
	{0xb2260002,0x3aef510d,0x7835b3db,0xe9418d84,0x33820006,0x937ad16e,0x9c1229c7,0x54931918},
	{0x72680003,0x0956911d,0xd63b08de,0x5ce54bbf,0xfb730006,0x985736ec,0xf7e46163,0x070fa4a7},
	{0x7ad70002,0x31c2b68f,0x13c3fb7f,0xbadd303b,0x3b3d0007,0xabeef6fc,0x59eada66,0xb2ab629c},
	{0xba990003,0x027b769f,0xbdcd407a,0x0f79f600,0xf3cc0007,0xa0c3117e,0x321c92c2,0xe137df23},
	{0xbba10004,0xcc9d76dd,0x05f7ac6d,0xd9e6eee9,0xd0080004,0x8c768f77,0x9dc5b050,0xaf4a29da},
	{0x7bef0005,0xff24b6cd,0xabf91768,0x6c4228d2,0x18f90004,0x875b68f5,0xf633f8f4,0xfcd69465},
	{0x73500004,0xc7b0915f,0x6e01e4c9,0x8a7a5356,0xd8b70005,0xb4e2a8e5,0x583d43f1,0x4972525e},
	{0xb31e0005,0xf409514f,0xc00f5fcc,0x3fde956d,0x10460005,0xbfcf4f67,0x33cb0b55,0x1aeeefe1},
	{0x33820006,0x937ad16e,0x9c1229c7,0x54931918,0x81a40004,0xa9958063,0xe4279a1c,0xbdd2949c},
	{0xf3cc0007,0xa0c3117e,0x321c92c2,0xe137df23,0x49550004,0xa2b867e1,0x8fd1d2b8,0xee4e2923},
	{0xfb730006,0x985736ec,0xf7e46163,0x070fa4a7,0x891b0005,0x9101a7f1,0x21df69bd,0x5beaef18},
	{0x3b3d0007,0xabeef6fc,0x59eada66,0xb2ab629c,0x41ea0005,0x9a2c4073,0x4a292119,0x087652a7},
	{0xea0d0004,0xe97e79c9,0x7c158621,0xcb7e53af,0x09870006,0xf67227d0,0x7dc21fb6,0x30a7636d},
	{0x2a430005,0xdac7b9d9,0xd21b3d24,0x7eda9594,0xc1760006,0xfd5fc052,0x16345712,0x633bded2},
	{0x22fc0004,0xe2539e4b,0x17e3ce85,0x98e2ee10,0x01380007,0xcee60042,0xb83aec17,0xd69f18e9},
	{0xe2b20005,0xd1ea5e5b,0xb9ed7580,0x2d46282b,0xc9c90007,0xc5cbe7c0,0xd3cca4b3,0x8503a556},
	{0x622e0006,0xb699de7a,0xe5f0038b,0x460ba45e,0x582b0006,0xd39128c4,0x042035fa,0x223fde2b},
	{0xa2600007,0x85201e6a,0x4bfeb88e,0xf3af6265,0x90da0006,0xd8bccf46,0x6fd67d5e,0x71a36394},
	{0xaadf0006,0xbdb439f8,0x8e064b2f,0x159719e1,0x50940007,0xeb050f56,0xc1d8c65b,0xc407a5af},
	{0x6a910007,0x8e0df9e8,0x2008f02a,0xa033dfda,0x98650007,0xe028e8d4,0xaa2e8eff,0x979b1810},
	{0xa8ae0008,0x2079397d,0xfe739301,0xb8a92831,0x171c0000,0xb26e3344,0x9e6a837e,0x58f8485f},
	{0x68e00009,0x13c0f96d,0x507d2804,0x0d0dee0a,0xdfed0000,0xb943d4c6,0xf59ccbda,0x0b64f5e0},
	{0x605f0008,0x2b54deff,0x9585dba5,0xeb35958e,0x1fa30001,0x8afa14d6,0x5b9270df,0xbec033db},
	{0xa0110009,0x18ed1eef,0x3b8b60a0,0x5e9153b5,0xd7520001,0x81d7f354,0x3064387b,0xed5c8e64},
	{0x208d000a,0x7f9e9ece,0x679616ab,0x35dcdfc0,0x46b00000,0x978d3c50,0xe788a932,0x4a60f519},
	{0xe0c3000b,0x4c275ede,0xc998adae,0x807819fb,0x8e410000,0x9ca0dbd2,0x8c7ee196,0x19fc48a6},
	{0xe87c000a,0x74b3794c,0x0c605e0f,0x6640627f,0x4e0f0001,0xaf191bc2,0x22705a93,0xac588e9d},
	{0x2832000b,0x470ab95c,0xa26ee50a,0xd3e4a444,0x86fe0001,0xa434fc40,0x49861237,0xffc43322},
	{0xf9020008,0x059a3669,0x8791b94d,0xaa319577,0xce930002,0xc86a9be3,0x7e6d2c98,0xc71502e8},
	{0x394c0009,0x3623f679,0x299f0248,0x1f95534c,0x06620002,0xc3477c61,0x159b643c,0x9489bf57},
	{0x31f30008,0x0eb7d1eb,0xec67f1e9,0xf9ad28c8,0xc62c0003,0xf0febc71,0xbb95df39,0x212d796c},
	{0xf1bd0009,0x3d0e11fb,0x42694aec,0x4c09eef3,0x0edd0003,0xfbd35bf3,0xd063979d,0x72b1c4d3},
	{0x7121000a,0x5a7d91da,0x1e743ce7,0x27446286,0x9f3f0002,0xed8994f7,0x078f06d4,0xd58dbfae},
	{0xb16f000b,0x69c451ca,0xb07a87e2,0x92e0a4bd,0x57ce0002,0xe6a47375,0x6c794e70,0x86110211},
	{0xb9d0000a,0x51507658,0x75827443,0x74d8df39,0x97800003,0xd51db365,0xc277f575,0x33b5c42a},
	{0x799e000b,0x62e9b648,0xdb8ccf46,0xc17c1902,0x5f710003,0xde3054e7,0xa981bdd1,0x60297995},
	{0x78a6000c,0xac0fb60a,0x63b62351,0x17e301eb,0x7cb50000,0xf285caee,0x06589f43,0x2e548f6c},
	{0xb8e8000d,0x9fb6761a,0xcdb89854,0xa247c7d0,0xb4440000,0xf9a82d6c,0x6daed7e7,0x7dc832d3},
	{0xb057000c,0xa7225188,0x08406bf5,0x447fbc54,0x740a0001,0xca11ed7c,0xc3a06ce2,0xc86cf4e8},
	{0x7019000d,0x949b9198,0xa64ed0f0,0xf1db7a6f,0xbcfb0001,0xc13c0afe,0xa8562446,0x9bf04957},
	{0xf085000e,0xf3e811b9,0xfa53a6fb,0x9a96f61a,0x2d190000,0xd766c5fa,0x7fbab50f,0x3ccc322a},
	{0x30cb000f,0xc051d1a9,0x545d1dfe,0x2f323021,0xe5e80000,0xdc4b2278,0x144cfdab,0x6f508f95},
	{0x3874000e,0xf8c5f63b,0x91a5ee5f,0xc90a4ba5,0x25a60001,0xeff2e268,0xba4246ae,0xdaf449ae},
	{0xf83a000f,0xcb7c362b,0x3fab555a,0x7cae8d9e,0xed570001,0xe4df05ea,0xd1b40e0a,0x8968f411},
	{0x290a000c,0x89ecb91e,0x1a54091d,0x057bbcad,0xa53a0002,0x88816249,0xe65f30a5,0xb1b9c5db},
	{0xe944000d,0xba55790e,0xb45ab218,0xb0df7a96,0x6dcb0002,0x83ac85cb,0x8da97801,0xe2257864},
	{0xe1fb000c,0x82c15e9c,0x71a241b9,0x56e70112,0xad850003,0xb01545db,0x23a7c304,0x5781be5f},
	{0x21b5000d,0xb1789e8c,0xdfacfabc,0xe343c729,0x65740003,0xbb38a259,0x48518ba0,0x041d03e0},
	{0xa129000e,0xd60b1ead,0x83b18cb7,0x880e4b5c,0xf4960002,0xad626d5d,0x9fbd1ae9,0xa321789d},
	{0x6167000f,0xe5b2debd,0x2dbf37b2,0x3daa8d67,0x3c670002,0xa64f8adf,0xf44b524d,0xf0bdc522},
	{0x69d8000e,0xdd26f92f,0xe847c413,0xdb92f6e3,0xfc290003,0x95f64acf,0x5a45e948,0x45190319},
	{0xa996000f,0xee9f393f,0x46497f16,0x6e3630d8,0x34d80003,0x9edbad4d,0x31b3a1ec,0x1685bea6},
	{0xc3070008,0x6092c0d7,0x66418f3c,0xce05ef02,0xacbd0004,0x7ef34599,0x9b9d2f13,0x811ea6b6},
	{0x03490009,0x532b00c7,0xc84f3439,0x7ba12939,0x644c0004,0x75dea21b,0xf06b67b7,0xd2821b09},
	{0x0bf60008,0x6bbf2755,0x0db7c798,0x9d9952bd,0xa4020005,0x4667620b,0x5e65dcb2,0x6726dd32},
	{0xcbb80009,0x5806e745,0xa3b97c9d,0x283d9486,0x6cf30005,0x4d4a8589,0x35939416,0x34ba608d},
	{0x4b24000a,0x3f756764,0xffa40a96,0x437018f3,0xfd110004,0x5b104a8d,0xe27f055f,0x93861bf0},
	{0x8b6a000b,0x0ccca774,0x51aab193,0xf6d4dec8,0x35e00004,0x503dad0f,0x89894dfb,0xc01aa64f},
	{0x83d5000a,0x345880e6,0x94524232,0x10eca54c,0xf5ae0005,0x63846d1f,0x2787f6fe,0x75be6074},
	{0x439b000b,0x07e140f6,0x3a5cf937,0xa5486377,0x3d5f0005,0x68a98a9d,0x4c71be5a,0x2622ddcb},
	{0x92ab0008,0x4571cfc3,0x1fa3a570,0xdc9d5244,0x75320006,0x04f7ed3e,0x7b9a80f5,0x1ef3ec01},
	{0x52e50009,0x76c80fd3,0xb1ad1e75,0x6939947f,0xbdc30006,0x0fda0abc,0x106cc851,0x4d6f51be},
	{0x5a5a0008,0x4e5c2841,0x7455edd4,0x8f01effb,0x7d8d0007,0x3c63caac,0xbe627354,0xf8cb9785},
	{0x9a140009,0x7de5e851,0xda5b56d1,0x3aa529c0,0xb57c0007,0x374e2d2e,0xd5943bf0,0xab572a3a},
	{0x1a88000a,0x1a966870,0x864620da,0x51e8a5b5,0x249e0006,0x2114e22a,0x0278aab9,0x0c6b5147},
	{0xdac6000b,0x292fa860,0x28489bdf,0xe44c638e,0xec6f0006,0x2a3905a8,0x698ee21d,0x5ff7ecf8},
	{0xd279000a,0x11bb8ff2,0xedb0687e,0x0274180a,0x2c210007,0x1980c5b8,0xc7805918,0xea532ac3},
	{0x1237000b,0x22024fe2,0x43bed37b,0xb7d0de31,0xe4d00007,0x12ad223a,0xac7611bc,0xb9cf977c},
	{0x130f000c,0xece44fa0,0xfb843f6c,0x614fc6d8,0xc7140004,0x3e18bc33,0x03af332e,0xf7b26185},
	{0xd341000d,0xdf5d8fb0,0x558a8469,0xd4eb00e3,0x0fe50004,0x35355bb1,0x68597b8a,0xa42edc3a},
	{0xdbfe000c,0xe7c9a822,0x907277c8,0x32d37b67,0xcfab0005,0x068c9ba1,0xc657c08f,0x118a1a01},
	{0x1bb0000d,0xd4706832,0x3e7ccccd,0x8777bd5c,0x075a0005,0x0da17c23,0xada1882b,0x4216a7be},
	{0x9b2c000e,0xb303e813,0x6261bac6,0xec3a3129,0x96b80004,0x1bfbb327,0x7a4d1962,0xe52adcc3},
	{0x5b62000f,0x80ba2803,0xcc6f01c3,0x599ef712,0x5e490004,0x10d654a5,0x11bb51c6,0xb6b6617c},
	{0x53dd000e,0xb82e0f91,0x0997f262,0xbfa68c96,0x9e070005,0x236f94b5,0xbfb5eac3,0x0312a747},
	{0x9393000f,0x8b97cf81,0xa7994967,0x0a024aad,0x56f60005,0x28427337,0xd443a267,0x508e1af8},
	{0x42a3000c,0xc90740b4,0x82661520,0x73d77b9e,0x1e9b0006,0x441c1494,0xe3a89cc8,0x685f2b32},
	{0x82ed000d,0xfabe80a4,0x2c68ae25,0xc673bda5,0xd66a0006,0x4f31f316,0x885ed46c,0x3bc3968d},
	{0x8a52000c,0xc22aa736,0xe9905d84,0x204bc621,0x16240007,0x7c883306,0x26506f69,0x8e6750b6},
	{0x4a1c000d,0xf1936726,0x479ee681,0x95ef001a,0xded50007,0x77a5d484,0x4da627cd,0xddfbed09},
	{0xca80000e,0x96e0e707,0x1b83908a,0xfea28c6f,0x4f370006,0x61ff1b80,0x9a4ab684,0x7ac79674},
	{0x0ace000f,0xa5592717,0xb58d2b8f,0x4b064a54,0x87c60006,0x6ad2fc02,0xf1bcfe20,0x295b2bcb},
	{0x0271000e,0x9dcd0085,0x7075d82e,0xad3e31d0,0x47880007,0x596b3c12,0x5fb24525,0x9cffedf0},
	{0xc23f000f,0xae74c095,0xde7b632b,0x189af7eb,0x8f790007,0x5246db90,0x34440d81,0xcf63504f},
	{0x171c0000,0xb26e3344,0x9e6a837e,0x58f8485f,0xbfb20008,0x92170a39,0x6019107f,0xe051606e},
	{0xd7520001,0x81d7f354,0x3064387b,0xed5c8e64,0x77430008,0x993aedbb,0x0bef58db,0xb3cdddd1},
	{0xdfed0000,0xb943d4c6,0xf59ccbda,0x0b64f5e0,0xb70d0009,0xaa832dab,0xa5e1e3de,0x06691bea},
	{0x1fa30001,0x8afa14d6,0x5b9270df,0xbec033db,0x7ffc0009,0xa1aeca29,0xce17ab7a,0x55f5a655},
	{0x9f3f0002,0xed8994f7,0x078f06d4,0xd58dbfae,0xee1e0008,0xb7f4052d,0x19fb3a33,0xf2c9dd28},
	{0x5f710003,0xde3054e7,0xa981bdd1,0x60297995,0x26ef0008,0xbcd9e2af,0x720d7297,0xa1556097},
	{0x57ce0002,0xe6a47375,0x6c794e70,0x86110211,0xe6a10009,0x8f6022bf,0xdc03c992,0x14f1a6ac},
	{0x97800003,0xd51db365,0xc277f575,0x33b5c42a,0x2e500009,0x844dc53d,0xb7f58136,0x476d1b13},
	{0x46b00000,0x978d3c50,0xe788a932,0x4a60f519,0x663d000a,0xe813a29e,0x801ebf99,0x7fbc2ad9},
	{0x86fe0001,0xa434fc40,0x49861237,0xffc43322,0xaecc000a,0xe33e451c,0xebe8f73d,0x2c209766},
	{0x8e410000,0x9ca0dbd2,0x8c7ee196,0x19fc48a6,0x6e82000b,0xd087850c,0x45e64c38,0x9984515d},
	{0x4e0f0001,0xaf191bc2,0x22705a93,0xac588e9d,0xa673000b,0xdbaa628e,0x2e10049c,0xca18ece2},
	{0xce930002,0xc86a9be3,0x7e6d2c98,0xc71502e8,0x3791000a,0xcdf0ad8a,0xf9fc95d5,0x6d24979f},
	{0x0edd0003,0xfbd35bf3,0xd063979d,0x72b1c4d3,0xff60000a,0xc6dd4a08,0x920add71,0x3eb82a20},
	{0x06620002,0xc3477c61,0x159b643c,0x9489bf57,0x3f2e000b,0xf5648a18,0x3c046674,0x8b1cec1b},
	{0xc62c0003,0xf0febc71,0xbb95df39,0x212d796c,0xf7df000b,0xfe496d9a,0x57f22ed0,0xd88051a4},
	{0xc7140004,0x3e18bc33,0x03af332e,0xf7b26185,0xd41b0008,0xd2fcf393,0xf82b0c42,0x96fda75d},
	{0x075a0005,0x0da17c23,0xada1882b,0x4216a7be,0x1cea0008,0xd9d11411,0x93dd44e6,0xc5611ae2},
	{0x0fe50004,0x35355bb1,0x68597b8a,0xa42edc3a,0xdca40009,0xea68d401,0x3dd3ffe3,0x70c5dcd9},
	{0xcfab0005,0x068c9ba1,0xc657c08f,0x118a1a01,0x14550009,0xe1453383,0x5625b747,0x23596166},
	{0x4f370006,0x61ff1b80,0x9a4ab684,0x7ac79674,0x85b70008,0xf71ffc87,0x81c9260e,0x84651a1b},
	{0x8f790007,0x5246db90,0x34440d81,0xcf63504f,0x4d460008,0xfc321b05,0xea3f6eaa,0xd7f9a7a4},
	{0x87c60006,0x6ad2fc02,0xf1bcfe20,0x295b2bcb,0x8d080009,0xcf8bdb15,0x4431d5af,0x625d619f},
	{0x47880007,0x596b3c12,0x5fb24525,0x9cffedf0,0x45f90009,0xc4a63c97,0x2fc79d0b,0x31c1dc20},
	{0x96b80004,0x1bfbb327,0x7a4d1962,0xe52adcc3,0x0d94000a,0xa8f85b34,0x182ca3a4,0x0910edea},
	{0x56f60005,0x28427337,0xd443a267,0x508e1af8,0xc565000a,0xa3d5bcb6,0x73daeb00,0x5a8c5055},
	{0x5e490004,0x10d654a5,0x11bb51c6,0xb6b6617c,0x052b000b,0x906c7ca6,0xddd45005,0xef28966e},
	{0x9e070005,0x236f94b5,0xbfb5eac3,0x0312a747,0xcdda000b,0x9b419b24,0xb62218a1,0xbcb42bd1},
	{0x1e9b0006,0x441c1494,0xe3a89cc8,0x685f2b32,0x5c38000a,0x8d1b5420,0x61ce89e8,0x1b8850ac},
	{0xded50007,0x77a5d484,0x4da627cd,0xddfbed09,0x94c9000a,0x8636b3a2,0x0a38c14c,0x4814ed13},
	{0xd66a0006,0x4f31f316,0x885ed46c,0x3bc3968d,0x5487000b,0xb58f73b2,0xa4367a49,0xfdb02b28},
	{0x16240007,0x7c883306,0x26506f69,0x8e6750b6,0x9c76000b,0xbea29430,0xcfc032ed,0xae2c9697},
	{0x7cb50000,0xf285caee,0x06589f43,0x2e548f6c,0x0413000c,0x5e8a7ce4,0x65eebc12,0x39b78e87},
	{0xbcfb0001,0xc13c0afe,0xa8562446,0x9bf04957,0xcce2000c,0x55a79b66,0x0e18f4b6,0x6a2b3338},
	{0xb4440000,0xf9a82d6c,0x6daed7e7,0x7dc832d3,0x0cac000d,0x661e5b76,0xa0164fb3,0xdf8ff503},
	{0x740a0001,0xca11ed7c,0xc3a06ce2,0xc86cf4e8,0xc45d000d,0x6d33bcf4,0xcbe00717,0x8c1348bc},
	{0xf4960002,0xad626d5d,0x9fbd1ae9,0xa321789d,0x55bf000c,0x7b6973f0,0x1c0c965e,0x2b2f33c1},
	{0x34d80003,0x9edbad4d,0x31b3a1ec,0x1685bea6,0x9d4e000c,0x70449472,0x77fadefa,0x78b38e7e},
	{0x3c670002,0xa64f8adf,0xf44b524d,0xf0bdc522,0x5d00000d,0x43fd5462,0xd9f465ff,0xcd174845},
	{0xfc290003,0x95f64acf,0x5a45e948,0x45190319,0x95f1000d,0x48d0b3e0,0xb2022d5b,0x9e8bf5fa},
	{0x2d190000,0xd766c5fa,0x7fbab50f,0x3ccc322a,0xdd9c000e,0x248ed443,0x85e913f4,0xa65ac430},
	{0xed570001,0xe4df05ea,0xd1b40e0a,0x8968f411,0x156d000e,0x2fa333c1,0xee1f5b50,0xf5c6798f},
	{0xe5e80000,0xdc4b2278,0x144cfdab,0x6f508f95,0xd523000f,0x1c1af3d1,0x4011e055,0x4062bfb4},
	{0x25a60001,0xeff2e268,0xba4246ae,0xdaf449ae,0x1dd2000f,0x17371453,0x2be7a8f1,0x13fe020b},
	{0xa53a0002,0x88816249,0xe65f30a5,0xb1b9c5db,0x8c30000e,0x016ddb57,0xfc0b39b8,0xb4c27976},
	{0x65740003,0xbb38a259,0x48518ba0,0x041d03e0,0x44c1000e,0x0a403cd5,0x97fd711c,0xe75ec4c9},
	{0x6dcb0002,0x83ac85cb,0x8da97801,0xe2257864,0x848f000f,0x39f9fcc5,0x39f3ca19,0x52fa02f2},
	{0xad850003,0xb01545db,0x23a7c304,0x5781be5f,0x4c7e000f,0x32d41b47,0x520582bd,0x0166bf4d},
	{0xacbd0004,0x7ef34599,0x9b9d2f13,0x811ea6b6,0x6fba000c,0x1e61854e,0xfddca02f,0x4f1b49b4},
	{0x6cf30005,0x4d4a8589,0x35939416,0x34ba608d,0xa74b000c,0x154c62cc,0x962ae88b,0x1c87f40b},
	{0x644c0004,0x75dea21b,0xf06b67b7,0xd2821b09,0x6705000d,0x26f5a2dc,0x3824538e,0xa9233230},
	{0xa4020005,0x4667620b,0x5e65dcb2,0x6726dd32,0xaff4000d,0x2dd8455e,0x53d21b2a,0xfabf8f8f},
	{0x249e0006,0x2114e22a,0x0278aab9,0x0c6b5147,0x3e16000c,0x3b828a5a,0x843e8a63,0x5d83f4f2},
	{0xe4d00007,0x12ad223a,0xac7611bc,0xb9cf977c,0xf6e7000c,0x30af6dd8,0xefc8c2c7,0x0e1f494d},
	{0xec6f0006,0x2a3905a8,0x698ee21d,0x5ff7ecf8,0x36a9000d,0x0316adc8,0x41c679c2,0xbbbb8f76},
	{0x2c210007,0x1980c5b8,0xc7805918,0xea532ac3,0xfe58000d,0x083b4a4a,0x2a303166,0xe82732c9},
	{0xfd110004,0x5b104a8d,0xe27f055f,0x93861bf0,0xb635000e,0x64652de9,0x1ddb0fc9,0xd0f60303},
	{0x3d5f0005,0x68a98a9d,0x4c71be5a,0x2622ddcb,0x7ec4000e,0x6f48ca6b,0x762d476d,0x836abebc},
	{0x35e00004,0x503dad0f,0x89894dfb,0xc01aa64f,0xbe8a000f,0x5cf10a7b,0xd823fc68,0x36ce7887},
	{0xf5ae0005,0x63846d1f,0x2787f6fe,0x75be6074,0x767b000f,0x57dcedf9,0xb3d5b4cc,0x6552c538},
	{0x75320006,0x04f7ed3e,0x7b9a80f5,0x1ef3ec01,0xe799000e,0x418622fd,0x64392585,0xc26ebe45},
	{0xb57c0007,0x374e2d2e,0xd5943bf0,0xab572a3a,0x2f68000e,0x4aabc57f,0x0fcf6d21,0x91f203fa},
	{0xbdc30006,0x0fda0abc,0x106cc851,0x4d6f51be,0xef26000f,0x7912056f,0xa1c1d624,0x2456c5c1},
	{0x7d8d0007,0x3c63caac,0xbe627354,0xf8cb9785,0x27d7000f,0x723fe2ed,0xca379e80,0x77ca787e},
	{0xbfb20008,0x92170a39,0x6019107f,0xe051606e,0xa8ae0008,0x2079397d,0xfe739301,0xb8a92831},
	{0x7ffc0009,0xa1aeca29,0xce17ab7a,0x55f5a655,0x605f0008,0x2b54deff,0x9585dba5,0xeb35958e},
	{0x77430008,0x993aedbb,0x0bef58db,0xb3cdddd1,0xa0110009,0x18ed1eef,0x3b8b60a0,0x5e9153b5},
	{0xb70d0009,0xaa832dab,0xa5e1e3de,0x06691bea,0x68e00009,0x13c0f96d,0x507d2804,0x0d0dee0a},
	{0x3791000a,0xcdf0ad8a,0xf9fc95d5,0x6d24979f,0xf9020008,0x059a3669,0x8791b94d,0xaa319577},
	{0xf7df000b,0xfe496d9a,0x57f22ed0,0xd88051a4,0x31f30008,0x0eb7d1eb,0xec67f1e9,0xf9ad28c8},
	{0xff60000a,0xc6dd4a08,0x920add71,0x3eb82a20,0xf1bd0009,0x3d0e11fb,0x42694aec,0x4c09eef3},
	{0x3f2e000b,0xf5648a18,0x3c046674,0x8b1cec1b,0x394c0009,0x3623f679,0x299f0248,0x1f95534c},
	{0xee1e0008,0xb7f4052d,0x19fb3a33,0xf2c9dd28,0x7121000a,0x5a7d91da,0x1e743ce7,0x27446286},
	{0x2e500009,0x844dc53d,0xb7f58136,0x476d1b13,0xb9d0000a,0x51507658,0x75827443,0x74d8df39},
	{0x26ef0008,0xbcd9e2af,0x720d7297,0xa1556097,0x799e000b,0x62e9b648,0xdb8ccf46,0xc17c1902},
	{0xe6a10009,0x8f6022bf,0xdc03c992,0x14f1a6ac,0xb16f000b,0x69c451ca,0xb07a87e2,0x92e0a4bd},
	{0x663d000a,0xe813a29e,0x801ebf99,0x7fbc2ad9,0x208d000a,0x7f9e9ece,0x679616ab,0x35dcdfc0},
	{0xa673000b,0xdbaa628e,0x2e10049c,0xca18ece2,0xe87c000a,0x74b3794c,0x0c605e0f,0x6640627f},
	{0xaecc000a,0xe33e451c,0xebe8f73d,0x2c209766,0x2832000b,0x470ab95c,0xa26ee50a,0xd3e4a444},
	{0x6e82000b,0xd087850c,0x45e64c38,0x9984515d,0xe0c3000b,0x4c275ede,0xc998adae,0x807819fb},
	{0x6fba000c,0x1e61854e,0xfddca02f,0x4f1b49b4,0xc3070008,0x6092c0d7,0x66418f3c,0xce05ef02},
	{0xaff4000d,0x2dd8455e,0x53d21b2a,0xfabf8f8f,0x0bf60008,0x6bbf2755,0x0db7c798,0x9d9952bd},
	{0xa74b000c,0x154c62cc,0x962ae88b,0x1c87f40b,0xcbb80009,0x5806e745,0xa3b97c9d,0x283d9486},
	{0x6705000d,0x26f5a2dc,0x3824538e,0xa9233230,0x03490009,0x532b00c7,0xc84f3439,0x7ba12939},
	{0xe799000e,0x418622fd,0x64392585,0xc26ebe45,0x92ab0008,0x4571cfc3,0x1fa3a570,0xdc9d5244},
	{0x27d7000f,0x723fe2ed,0xca379e80,0x77ca787e,0x5a5a0008,0x4e5c2841,0x7455edd4,0x8f01effb},
	{0x2f68000e,0x4aabc57f,0x0fcf6d21,0x91f203fa,0x9a140009,0x7de5e851,0xda5b56d1,0x3aa529c0},
	{0xef26000f,0x7912056f,0xa1c1d624,0x2456c5c1,0x52e50009,0x76c80fd3,0xb1ad1e75,0x6939947f},
	{0x3e16000c,0x3b828a5a,0x843e8a63,0x5d83f4f2,0x1a88000a,0x1a966870,0x864620da,0x51e8a5b5},
	{0xfe58000d,0x083b4a4a,0x2a303166,0xe82732c9,0xd279000a,0x11bb8ff2,0xedb0687e,0x0274180a},
	{0xf6e7000c,0x30af6dd8,0xefc8c2c7,0x0e1f494d,0x1237000b,0x22024fe2,0x43bed37b,0xb7d0de31},
	{0x36a9000d,0x0316adc8,0x41c679c2,0xbbbb8f76,0xdac6000b,0x292fa860,0x28489bdf,0xe44c638e},
	{0xb635000e,0x64652de9,0x1ddb0fc9,0xd0f60303,0x4b24000a,0x3f756764,0xffa40a96,0x437018f3},
	{0x767b000f,0x57dcedf9,0xb3d5b4cc,0x6552c538,0x83d5000a,0x345880e6,0x94524232,0x10eca54c},
	{0x7ec4000e,0x6f48ca6b,0x762d476d,0x836abebc,0x439b000b,0x07e140f6,0x3a5cf937,0xa5486377},
	{0xbe8a000f,0x5cf10a7b,0xd823fc68,0x36ce7887,0x8b6a000b,0x0ccca774,0x51aab193,0xf6d4dec8},
	{0xd41b0008,0xd2fcf393,0xf82b0c42,0x96fda75d,0x130f000c,0xece44fa0,0xfb843f6c,0x614fc6d8},
	{0x14550009,0xe1453383,0x5625b747,0x23596166,0xdbfe000c,0xe7c9a822,0x907277c8,0x32d37b67},
	{0x1cea0008,0xd9d11411,0x93dd44e6,0xc5611ae2,0x1bb0000d,0xd4706832,0x3e7ccccd,0x8777bd5c},
	{0xdca40009,0xea68d401,0x3dd3ffe3,0x70c5dcd9,0xd341000d,0xdf5d8fb0,0x558a8469,0xd4eb00e3},
	{0x5c38000a,0x8d1b5420,0x61ce89e8,0x1b8850ac,0x42a3000c,0xc90740b4,0x82661520,0x73d77b9e},
	{0x9c76000b,0xbea29430,0xcfc032ed,0xae2c9697,0x8a52000c,0xc22aa736,0xe9905d84,0x204bc621},
	{0x94c9000a,0x8636b3a2,0x0a38c14c,0x4814ed13,0x4a1c000d,0xf1936726,0x479ee681,0x95ef001a},
	{0x5487000b,0xb58f73b2,0xa4367a49,0xfdb02b28,0x82ed000d,0xfabe80a4,0x2c68ae25,0xc673bda5},
	{0x85b70008,0xf71ffc87,0x81c9260e,0x84651a1b,0xca80000e,0x96e0e707,0x1b83908a,0xfea28c6f},
	{0x45f90009,0xc4a63c97,0x2fc79d0b,0x31c1dc20,0x0271000e,0x9dcd0085,0x7075d82e,0xad3e31d0},
	{0x4d460008,0xfc321b05,0xea3f6eaa,0xd7f9a7a4,0xc23f000f,0xae74c095,0xde7b632b,0x189af7eb},
	{0x8d080009,0xcf8bdb15,0x4431d5af,0x625d619f,0x0ace000f,0xa5592717,0xb58d2b8f,0x4b064a54},
	{0x0d94000a,0xa8f85b34,0x182ca3a4,0x0910edea,0x9b2c000e,0xb303e813,0x6261bac6,0xec3a3129},
	{0xcdda000b,0x9b419b24,0xb62218a1,0xbcb42bd1,0x53dd000e,0xb82e0f91,0x0997f262,0xbfa68c96},
	{0xc565000a,0xa3d5bcb6,0x73daeb00,0x5a8c5055,0x9393000f,0x8b97cf81,0xa7994967,0x0a024aad},
	{0x052b000b,0x906c7ca6,0xddd45005,0xef28966e,0x5b62000f,0x80ba2803,0xcc6f01c3,0x599ef712},
	{0x0413000c,0x5e8a7ce4,0x65eebc12,0x39b78e87,0x78a6000c,0xac0fb60a,0x63b62351,0x17e301eb},
	{0xc45d000d,0x6d33bcf4,0xcbe00717,0x8c1348bc,0xb057000c,0xa7225188,0x08406bf5,0x447fbc54},
	{0xcce2000c,0x55a79b66,0x0e18f4b6,0x6a2b3338,0x7019000d,0x949b9198,0xa64ed0f0,0xf1db7a6f},
	{0x0cac000d,0x661e5b76,0xa0164fb3,0xdf8ff503,0xb8e8000d,0x9fb6761a,0xcdb89854,0xa247c7d0},
	{0x8c30000e,0x016ddb57,0xfc0b39b8,0xb4c27976,0x290a000c,0x89ecb91e,0x1a54091d,0x057bbcad},
	{0x4c7e000f,0x32d41b47,0x520582bd,0x0166bf4d,0xe1fb000c,0x82c15e9c,0x71a241b9,0x56e70112},
	{0x44c1000e,0x0a403cd5,0x97fd711c,0xe75ec4c9,0x21b5000d,0xb1789e8c,0xdfacfabc,0xe343c729},
	{0x848f000f,0x39f9fcc5,0x39f3ca19,0x52fa02f2,0xe944000d,0xba55790e,0xb45ab218,0xb0df7a96},
	{0x55bf000c,0x7b6973f0,0x1c0c965e,0x2b2f33c1,0xa129000e,0xd60b1ead,0x83b18cb7,0x880e4b5c},
	{0x95f1000d,0x48d0b3e0,0xb2022d5b,0x9e8bf5fa,0x69d8000e,0xdd26f92f,0xe847c413,0xdb92f6e3},
	{0x9d4e000c,0x70449472,0x77fadefa,0x78b38e7e,0xa996000f,0xee9f393f,0x46497f16,0x6e3630d8},
	{0x5d00000d,0x43fd5462,0xd9f465ff,0xcd174845,0x6167000f,0xe5b2debd,0x2dbf37b2,0x3daa8d67},
	{0xdd9c000e,0x248ed443,0x85e913f4,0xa65ac430,0xf085000e,0xf3e811b9,0xfa53a6fb,0x9a96f61a},
	{0x1dd2000f,0x17371453,0x2be7a8f1,0x13fe020b,0x3874000e,0xf8c5f63b,0x91a5ee5f,0xc90a4ba5},
	{0x156d000e,0x2fa333c1,0xee1f5b50,0xf5c6798f,0xf83a000f,0xcb7c362b,0x3fab555a,0x7cae8d9e},
	{0xd523000f,0x1c1af3d1,0x4011e055,0x4062bfb4,0x30cb000f,0xc051d1a9,0x545d1dfe,0x2f323021}
    }
};

static const uint32_t T512[8][256][16] = {
    {
	{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0xfc0e05c0,0x419e0000,0xcfa50000,0xde010000,0x233002b8,0xe8aa8ce8,0x3018a3e8,0x9b46f1b0,0x246d0140,0x82750000,0x8ad10000,0x4afd0000,0x78860214,0x494e6249,0xb9274e7a,0x05f69189},
	{0x246d0140,0x82750000,0x8ad10000,0x4afd0000,0x78860214,0x494e6249,0xb9274e7a,0x05f69189,0xd8630480,0xc3eb0000,0x45740000,0x94fc0000,0x5bb600ac,0xa1e4eea1,0x893fed92,0x9eb06039},
	{0xd8630480,0xc3eb0000,0x45740000,0x94fc0000,0x5bb600ac,0xa1e4eea1,0x893fed92,0x9eb06039,0xfc0e05c0,0x419e0000,0xcfa50000,0xde010000,0x233002b8,0xe8aa8ce8,0x3018a3e8,0x9b46f1b0},
	{0xf01b09c0,0x914c0000,0x9f590000,0xf5e60000,0x4a18017f,0x31442831,0x61164b91,0xbafcc36f,0x39d800c0,0x94a20000,0xf2b00000,0xd4da0000,0x717c03a6,0x7613c576,0x0a4a1ccc,0x17a4e700},
	{0x0c150c00,0xd0d20000,0x50fc0000,0x2be70000,0x692803c7,0xd9eea4d9,0x510ee879,0x21ba32df,0x1db50180,0x16d70000,0x78610000,0x9e270000,0x09fa01b2,0x3f5da73f,0xb36d52b6,0x12527689},
	{0xd4760880,0x13390000,0x15880000,0xbf1b0000,0x329e036b,0x780a4a78,0xd83105eb,0xbf0a52e6,0xe1bb0440,0x57490000,0xb7c40000,0x40260000,0x2aca030a,0xd7f72bd7,0x8375f15e,0x89148739},
	{0x28780d40,0x52a70000,0xda2d0000,0x611a0000,0x11ae01d3,0x90a0c690,0xe829a603,0x244ca356,0xc5d60500,0xd53c0000,0x3d150000,0x0adb0000,0x524c011e,0x9eb9499e,0x3a52bf24,0x8ce216b0},
	{0x39d800c0,0x94a20000,0xf2b00000,0xd4da0000,0x717c03a6,0x7613c576,0x0a4a1ccc,0x17a4e700,0xc9c30900,0x05ee0000,0x6de90000,0x213c0000,0x3b6402d9,0x4757ed47,0x6b5c575d,0xad58246f},
	{0xc5d60500,0xd53c0000,0x3d150000,0x0adb0000,0x524c011e,0x9eb9499e,0x3a52bf24,0x8ce216b0,0xedae0840,0x879b0000,0xe7380000,0x6bc10000,0x43e200cd,0x0e198f0e,0xd27b1927,0xa8aeb5e6},
	{0x1db50180,0x16d70000,0x78610000,0x9e270000,0x09fa01b2,0x3f5da73f,0xb36d52b6,0x12527689,0x11a00d80,0xc6050000,0x289d0000,0xb5c00000,0x60d20275,0xe6b303e6,0xe263bacf,0x33e84456},
	{0xe1bb0440,0x57490000,0xb7c40000,0x40260000,0x2aca030a,0xd7f72bd7,0x8375f15e,0x89148739,0x35cd0cc0,0x44700000,0xa24c0000,0xff3d0000,0x18540061,0xaffd61af,0x5b44f4b5,0x361ed5df},
	{0xc9c30900,0x05ee0000,0x6de90000,0x213c0000,0x3b6402d9,0x4757ed47,0x6b5c575d,0xad58246f,0xf01b09c0,0x914c0000,0x9f590000,0xf5e60000,0x4a18017f,0x31442831,0x61164b91,0xbafcc36f},
	{0x35cd0cc0,0x44700000,0xa24c0000,0xff3d0000,0x18540061,0xaffd61af,0x5b44f4b5,0x361ed5df,0xd4760880,0x13390000,0x15880000,0xbf1b0000,0x329e036b,0x780a4a78,0xd83105eb,0xbf0a52e6},
	{0xedae0840,0x879b0000,0xe7380000,0x6bc10000,0x43e200cd,0x0e198f0e,0xd27b1927,0xa8aeb5e6,0x28780d40,0x52a70000,0xda2d0000,0x611a0000,0x11ae01d3,0x90a0c690,0xe829a603,0x244ca356},
	{0x11a00d80,0xc6050000,0x289d0000,0xb5c00000,0x60d20275,0xe6b303e6,0xe263bacf,0x33e84456,0x0c150c00,0xd0d20000,0x50fc0000,0x2be70000,0x692803c7,0xd9eea4d9,0x510ee879,0x21ba32df},
	{0xa4ff7000,0x5cfa0000,0x63f10000,0x51fc0000,0x9ea80183,0x31efc50e,0xd8d6849b,0xbb515dde,0xa7013000,0x476d0000,0xf0040000,0x8c000000,0xfb450031,0x8b50ad90,0x3cae5a27,0x1a0ceae4},
	{0x58f175c0,0x1d640000,0xac540000,0x8ffd0000,0xbd98033b,0xd94549e6,0xe8ce2773,0x2017ac6e,0x836c3140,0xc5180000,0x7ad50000,0xc6fd0000,0x83c30225,0xc21ecfd9,0x8589145d,0x1ffa7b6d},
	{0x80927140,0xde8f0000,0xe9200000,0x1b010000,0xe62e0397,0x78a1a747,0x61f1cae1,0xbea7cc57,0x7f623480,0x84860000,0xb5700000,0x18fc0000,0xa0f3009d,0x2ab44331,0xb591b7b5,0x84bc8add},
	{0x7c9c7480,0x9f110000,0x26850000,0xc5000000,0xc51e012f,0x900b2baf,0x51e96909,0x25e13de7,0x5b0f35c0,0x06f30000,0x3fa10000,0x52010000,0xd8750289,0x63fa2178,0x0cb6f9cf,0x814a1b54},
	{0x54e479c0,0xcdb60000,0xfca80000,0xa41a0000,0xd4b000fc,0x00abed3f,0xb9c0cf0a,0x01ad9eb1,0x9ed930c0,0xd3cf0000,0x02b40000,0x58da0000,0x8a390397,0xfd4368e6,0x36e446eb,0x0da80de4},
	{0xa8ea7c00,0x8c280000,0x330d0000,0x7a1b0000,0xf7800244,0xe80161d7,0x89d86ce2,0x9aeb6f01,0xbab43180,0x51ba0000,0x88650000,0x12270000,0xf2bf0183,0xb40d0aaf,0x8fc30891,0x085e9c6d},
	{0x70897880,0x4fc30000,0x76790000,0xeee70000,0xac3602e8,0x49e58f76,0x00e78170,0x045b0f38,0x46ba3440,0x10240000,0x47c00000,0xcc260000,0xd18f033b,0x5ca78647,0xbfdbab79,0x93186ddd},
	{0x8c877d40,0x0e5d0000,0xb9dc0000,0x30e60000,0x8f060050,0xa14f039e,0x30ff2298,0x9f1dfe88,0x62d73500,0x92510000,0xcd110000,0x86db0000,0xa909012f,0x15e9e40e,0x06fce503,0x96eefc54},
	{0x9d2770c0,0xc8580000,0x91410000,0x85260000,0xefd40225,0x47fc0078,0xd29c9857,0xacf5bade,0x6ec23900,0x42830000,0x9ded0000,0xad3c0000,0xc02102e8,0xcc0740d7,0x57f20d7a,0xb754ce8b},
	{0x61297500,0x89c60000,0x5ee40000,0x5b270000,0xcce4009d,0xaf568c90,0xe2843bbf,0x37b34b6e,0x4aaf3840,0xc0f60000,0x173c0000,0xe7c10000,0xb8a700fc,0x8549229e,0xeed54300,0xb2a25f02},
	{0xb94a7180,0x4a2d0000,0x1b900000,0xcfdb0000,0x97520031,0x0eb26231,0x6bbbd62d,0xa9032b57,0xb6a13d80,0x81680000,0xd8990000,0x39c00000,0x9b970244,0x6de3ae76,0xdecde0e8,0x29e4aeb2},
	{0x45447440,0x0bb30000,0xd4350000,0x11da0000,0xb4620289,0xe618eed9,0x5ba375c5,0x3245dae7,0x92cc3cc0,0x031d0000,0x52480000,0x733d0000,0xe3110050,0x24adcc3f,0x67eaae92,0x2c123f3b},
	{0x6d3c7900,0x59140000,0x0e180000,0x70c00000,0xa5cc035a,0x76b82849,0xb38ad3c6,0x160979b1,0x571a39c0,0xd6210000,0x6f5d0000,0x79e60000,0xb15d014e,0xba1485a1,0x5db811b6,0xa0f0298b},
	{0x91327cc0,0x188a0000,0xc1bd0000,0xaec10000,0x86fc01e2,0x9e12a4a1,0x8392702e,0x8d4f8801,0x73773880,0x54540000,0xe58c0000,0x331b0000,0xc9db035a,0xf35ae7e8,0xe49f5fcc,0xa506b802},
	{0x49517840,0xdb610000,0x84c90000,0x3a3d0000,0xdd4a014e,0x3ff64a00,0x0aad9dbc,0x13ffe838,0x8f793d40,0x15ca0000,0x2a290000,0xed1a0000,0xeaeb01e2,0x1bf06b00,0xd487fc24,0x3e4049b2},
	{0xb55f7d80,0x9aff0000,0x4b6c0000,0xe43c0000,0xfe7a03f6,0xd75cc6e8,0x3ab53e54,0x88b91988,0xab143c00,0x97bf0000,0xa0f80000,0xa7e70000,0x926d03f6,0x52be0949,0x6da0b25e,0x3bb6d83b},
	{0xa7013000,0x476d0000,0xf0040000,0x8c000000,0xfb450031,0x8b50ad90,0x3cae5a27,0x1a0ceae4,0x03fe4000,0x1b970000,0x93f50000,0xddfc0000,0x65ed01b2,0xbabf689e,0xe478debc,0xa15db73a},
	{0x5b0f35c0,0x06f30000,0x3fa10000,0x52010000,0xd8750289,0x63fa2178,0x0cb6f9cf,0x814a1b54,0x27934140,0x99e20000,0x19240000,0x97010000,0x1d6b03a6,0xf3f10ad7,0x5d5f90c6,0xa4ab26b3},
	{0x836c3140,0xc5180000,0x7ad50000,0xc6fd0000,0x83c30225,0xc21ecfd9,0x8589145d,0x1ffa7b6d,0xdb9d4480,0xd87c0000,0xd6810000,0x49000000,0x3e5b011e,0x1b5b863f,0x6d47332e,0x3fedd703},
	{0x7f623480,0x84860000,0xb5700000,0x18fc0000,0xa0f3009d,0x2ab44331,0xb591b7b5,0x84bc8add,0xfff045c0,0x5a090000,0x5c500000,0x03fd0000,0x46dd030a,0x5215e476,0xd4607d54,0x3a1b468a},
	{0x571a39c0,0xd6210000,0x6f5d0000,0x79e60000,0xb15d014e,0xba1485a1,0x5db811b6,0xa0f0298b,0x3a2640c0,0x8f350000,0x61450000,0x09260000,0x14910214,0xccacade8,0xee32c270,0xb6f9503a},
	{0xab143c00,0x97bf0000,0xa0f80000,0xa7e70000,0x926d03f6,0x52be0949,0x6da0b25e,0x3bb6d83b,0x1e4b4180,0x0d400000,0xeb940000,0x43db0000,0x6c170000,0x85e2cfa1,0x57158c0a,0xb30fc1b3},
	{0x73773880,0x54540000,0xe58c0000,0x331b0000,0xc9db035a,0xf35ae7e8,0xe49f5fcc,0xa506b802,0xe2454440,0x4cde0000,0x24310000,0x9dda0000,0x4f2702b8,0x6d484349,0x670d2fe2,0x28493003},
	{0x8f793d40,0x15ca0000,0x2a290000,0xed1a0000,0xeaeb01e2,0x1bf06b00,0xd487fc24,0x3e4049b2,0xc6284500,0xceab0000,0xaee00000,0xd7270000,0x37a100ac,0x24062100,0xde2a6198,0x2dbfa18a},
	{0x9ed930c0,0xd3cf0000,0x02b40000,0x58da0000,0x8a390397,0xfd4368e6,0x36e446eb,0x0da80de4,0xca3d4900,0x1e790000,0xfe1c0000,0xfcc00000,0x5e89036b,0xfde885d9,0x8f2489e1,0x0c059355},
	{0x62d73500,0x92510000,0xcd110000,0x86db0000,0xa909012f,0x15e9e40e,0x06fce503,0x96eefc54,0xee504840,0x9c0c0000,0x74cd0000,0xb63d0000,0x260f017f,0xb4a6e790,0x3603c79b,0x09f302dc},
	{0xbab43180,0x51ba0000,0x88650000,0x12270000,0xf2bf0183,0xb40d0aaf,0x8fc30891,0x085e9c6d,0x125e4d80,0xdd920000,0xbb680000,0x683c0000,0x053f03c7,0x5c0c6b78,0x061b6473,0x92b5f36c},
	{0x46ba3440,0x10240000,0x47c00000,0xcc260000,0xd18f033b,0x5ca78647,0xbfdbab79,0x93186ddd,0x36334cc0,0x5fe70000,0x31b90000,0x22c10000,0x7db901d3,0x15420931,0xbf3c2a09,0x974362e5},
	{0x6ec23900,0x42830000,0x9ded0000,0xad3c0000,0xc02102e8,0xcc0740d7,0x57f20d7a,0xb754ce8b,0xf3e549c0,0x8adb0000,0x0cac0000,0x281a0000,0x2ff500cd,0x8bfb40af,0x856e952d,0x1ba17455},
	{0x92cc3cc0,0x031d0000,0x52480000,0x733d0000,0xe3110050,0x24adcc3f,0x67eaae92,0x2c123f3b,0xd7884880,0x08ae0000,0x867d0000,0x62e70000,0x577302d9,0xc2b522e6,0x3c49db57,0x1e57e5dc},
	{0x4aaf3840,0xc0f60000,0x173c0000,0xe7c10000,0xb8a700fc,0x8549229e,0xeed54300,0xb2a25f02,0x2b864d40,0x49300000,0x49d80000,0xbce60000,0x74430061,0x2a1fae0e,0x0c5178bf,0x8511146c},
	{0xb6a13d80,0x81680000,0xd8990000,0x39c00000,0x9b970244,0x6de3ae76,0xdecde0e8,0x29e4aeb2,0x0feb4c00,0xcb450000,0xc3090000,0xf61b0000,0x0cc50275,0x6351cc47,0xb57636c5,0x80e785e5},
	{0x03fe4000,0x1b970000,0x93f50000,0xddfc0000,0x65ed01b2,0xbabf689e,0xe478debc,0xa15db73a,0xa4ff7000,0x5cfa0000,0x63f10000,0x51fc0000,0x9ea80183,0x31efc50e,0xd8d6849b,0xbb515dde},
	{0xfff045c0,0x5a090000,0x5c500000,0x03fd0000,0x46dd030a,0x5215e476,0xd4607d54,0x3a1b468a,0x80927140,0xde8f0000,0xe9200000,0x1b010000,0xe62e0397,0x78a1a747,0x61f1cae1,0xbea7cc57},
	{0x27934140,0x99e20000,0x19240000,0x97010000,0x1d6b03a6,0xf3f10ad7,0x5d5f90c6,0xa4ab26b3,0x7c9c7480,0x9f110000,0x26850000,0xc5000000,0xc51e012f,0x900b2baf,0x51e96909,0x25e13de7},
	{0xdb9d4480,0xd87c0000,0xd6810000,0x49000000,0x3e5b011e,0x1b5b863f,0x6d47332e,0x3fedd703,0x58f175c0,0x1d640000,0xac540000,0x8ffd0000,0xbd98033b,0xd94549e6,0xe8ce2773,0x2017ac6e},
	{0xf3e549c0,0x8adb0000,0x0cac0000,0x281a0000,0x2ff500cd,0x8bfb40af,0x856e952d,0x1ba17455,0x9d2770c0,0xc8580000,0x91410000,0x85260000,0xefd40225,0x47fc0078,0xd29c9857,0xacf5bade},
	{0x0feb4c00,0xcb450000,0xc3090000,0xf61b0000,0x0cc50275,0x6351cc47,0xb57636c5,0x80e785e5,0xb94a7180,0x4a2d0000,0x1b900000,0xcfdb0000,0x97520031,0x0eb26231,0x6bbbd62d,0xa9032b57},
	{0xd7884880,0x08ae0000,0x867d0000,0x62e70000,0x577302d9,0xc2b522e6,0x3c49db57,0x1e57e5dc,0x45447440,0x0bb30000,0xd4350000,0x11da0000,0xb4620289,0xe618eed9,0x5ba375c5,0x3245dae7},
	{0x2b864d40,0x49300000,0x49d80000,0xbce60000,0x74430061,0x2a1fae0e,0x0c5178bf,0x8511146c,0x61297500,0x89c60000,0x5ee40000,0x5b270000,0xcce4009d,0xaf568c90,0xe2843bbf,0x37b34b6e},
	{0x3a2640c0,0x8f350000,0x61450000,0x09260000,0x14910214,0xccacade8,0xee32c270,0xb6f9503a,0x6d3c7900,0x59140000,0x0e180000,0x70c00000,0xa5cc035a,0x76b82849,0xb38ad3c6,0x160979b1},
	{0xc6284500,0xceab0000,0xaee00000,0xd7270000,0x37a100ac,0x24062100,0xde2a6198,0x2dbfa18a,0x49517840,0xdb610000,0x84c90000,0x3a3d0000,0xdd4a014e,0x3ff64a00,0x0aad9dbc,0x13ffe838},
	{0x1e4b4180,0x0d400000,0xeb940000,0x43db0000,0x6c170000,0x85e2cfa1,0x57158c0a,0xb30fc1b3,0xb55f7d80,0x9aff0000,0x4b6c0000,0xe43c0000,0xfe7a03f6,0xd75cc6e8,0x3ab53e54,0x88b91988},
	{0xe2454440,0x4cde0000,0x24310000,0x9dda0000,0x4f2702b8,0x6d484349,0x670d2fe2,0x28493003,0x91327cc0,0x188a0000,0xc1bd0000,0xaec10000,0x86fc01e2,0x9e12a4a1,0x8392702e,0x8d4f8801},
	{0xca3d4900,0x1e790000,0xfe1c0000,0xfcc00000,0x5e89036b,0xfde885d9,0x8f2489e1,0x0c059355,0x54e479c0,0xcdb60000,0xfca80000,0xa41a0000,0xd4b000fc,0x00abed3f,0xb9c0cf0a,0x01ad9eb1},
	{0x36334cc0,0x5fe70000,0x31b90000,0x22c10000,0x7db901d3,0x15420931,0xbf3c2a09,0x974362e5,0x70897880,0x4fc30000,0x76790000,0xeee70000,0xac3602e8,0x49e58f76,0x00e78170,0x045b0f38},
	{0xee504840,0x9c0c0000,0x74cd0000,0xb63d0000,0x260f017f,0xb4a6e790,0x3603c79b,0x09f302dc,0x8c877d40,0x0e5d0000,0xb9dc0000,0x30e60000,0x8f060050,0xa14f039e,0x30ff2298,0x9f1dfe88},
	{0x125e4d80,0xdd920000,0xbb680000,0x683c0000,0x053f03c7,0x5c0c6b78,0x061b6473,0x92b5f36c,0xa8ea7c00,0x8c280000,0x330d0000,0x7a1b0000,0xf7800244,0xe80161d7,0x89d86ce2,0x9aeb6f01},
	{0x8ae9b000,0x2ba70000,0xf3ac0000,0x35ea0000,0x49f30116,0xe40e1d87,0xbcfd3530,0x2bb590c2,0x2bb61000,0x83030000,0x6ede0000,0x54b50000,0x80dd00cf,0xdbfb2e29,0x5bfdd786,0x7cd49e25},
	{0x76e7b5c0,0x6a390000,0x3c090000,0xebeb0000,0x6ac303ae,0x0ca4916f,0x8ce596d8,0xb0f36172,0x0fdb1140,0x01760000,0xe40f0000,0x1e480000,0xf85b02db,0x92b54c60,0xe2da99fc,0x79220fac},
	{0xae84b140,0xa9d20000,0x797d0000,0x7f170000,0x31750302,0xad407fce,0x05da7b4a,0x2e43014b,0xf3d51480,0x40e80000,0x2baa0000,0xc0490000,0xdb6b0063,0x7a1fc088,0xd2c23a14,0xe264fe1c},
	{0x528ab480,0xe84c0000,0xb6d80000,0xa1160000,0x124501ba,0x45eaf326,0x35c2d8a2,0xb505f0fb,0xd7b815c0,0xc29d0000,0xa17b0000,0x8ab40000,0xa3ed0277,0x3351a2c1,0x6be5746e,0xe7926f95},
	{0x7af2b9c0,0xbaeb0000,0x6cf50000,0xc00c0000,0x03eb0069,0xd54a35b6,0xddeb7ea1,0x914953ad,0x126e10c0,0x17a10000,0x9c6e0000,0x806f0000,0xf1a10369,0xade8eb5f,0x51b7cb4a,0x6b707925},
	{0x86fcbc00,0xfb750000,0xa3500000,0x1e0d0000,0x20db02d1,0x3de0b95e,0xedf3dd49,0x0a0fa21d,0x36031180,0x95d40000,0x16bf0000,0xca920000,0x8927017d,0xe4a68916,0xe8908530,0x6e86e8ac},
	{0x5e9fb880,0x389e0000,0xe6240000,0x8af10000,0x7b6d027d,0x9c0457ff,0x64cc30db,0x94bfc224,0xca0d1440,0xd44a0000,0xd91a0000,0x14930000,0xaa1703c5,0x0c0c05fe,0xd88826d8,0xf5c0191c},
	{0xa291bd40,0x79000000,0x29810000,0x54f00000,0x585d00c5,0x74aedb17,0x54d49333,0x0ff93394,0xee601500,0x563f0000,0x53cb0000,0x5e6e0000,0xd29101d1,0x454267b7,0x61af68a2,0xf0368895},
	{0xb331b0c0,0xbf050000,0x011c0000,0xe1300000,0x388f02b0,0x921dd8f1,0xb6b729fc,0x3c1177c2,0xe2751900,0x86ed0000,0x03370000,0x75890000,0xbbb90216,0x9cacc36e,0x30a180db,0xd18cba4a},
	{0x4f3fb500,0xfe9b0000,0xceb90000,0x3f310000,0x1bbf0008,0x7ab75419,0x86af8a14,0xa7578672,0xc6181840,0x04980000,0x89e60000,0x3f740000,0xc33f0002,0xd5e2a127,0x8986cea1,0xd47a2bc3},
	{0x975cb180,0x3d700000,0x8bcd0000,0xabcd0000,0x400900a4,0xdb53bab8,0x0f906786,0x39e7e64b,0x3a161d80,0x45060000,0x46430000,0xe1750000,0xe00f02ba,0x3d482dcf,0xb99e6d49,0x4f3cda73},
	{0x6b52b440,0x7cee0000,0x44680000,0x75cc0000,0x6339021c,0x33f93650,0x3f88c46e,0xa2a117fb,0x1e7b1cc0,0xc7730000,0xcc920000,0xab880000,0x988900ae,0x74064f86,0x00b92333,0x4aca4bfa},
	{0x432ab900,0x2e490000,0x9e450000,0x14d60000,0x729703cf,0xa359f0c0,0xd7a1626d,0x86edb4ad,0xdbad19c0,0x124f0000,0xf1870000,0xa1530000,0xcac501b0,0xeabf0618,0x3aeb9c17,0xc6285d4a},
	{0xbf24bcc0,0x6fd70000,0x51e00000,0xcad70000,0x51a70177,0x4bf37c28,0xe7b9c185,0x1dab451d,0xffc01880,0x903a0000,0x7b560000,0xebae0000,0xb24303a4,0xa3f16451,0x83ccd26d,0xc3deccc3},
	{0x6747b840,0xac3c0000,0x14940000,0x5e2b0000,0x0a1101db,0xea179289,0x6e862c17,0x831b2524,0x03ce1d40,0xd1a40000,0xb4f30000,0x35af0000,0x9173011c,0x4b5be8b9,0xb3d47185,0x58983d73},
	{0x9b49bd80,0xeda20000,0xdb310000,0x802a0000,0x29210363,0x02bd1e61,0x5e9e8fff,0x185dd494,0x27a31c00,0x53d10000,0x3e220000,0x7f520000,0xe9f50308,0x02158af0,0x0af33fff,0x5d6eacfa},
	{0x2e16c000,0x775d0000,0x905d0000,0x64160000,0xd75b0095,0xd5e1d889,0x642bb1ab,0x90e4cd1c,0x8cb72000,0xc46e0000,0x9eda0000,0xd8b50000,0x7b9800fe,0x50ab83b9,0x67538da1,0x66d874c1},
	{0xd218c5c0,0x36c30000,0x5ff80000,0xba170000,0xf46b022d,0x3d4b5461,0x54331243,0x0ba23cac,0xa8da2140,0x461b0000,0x140b0000,0x92480000,0x031e02ea,0x19e5e1f0,0xde74c3db,0x632ee548},
	{0x0a7bc140,0xf5280000,0x1a8c0000,0x2eeb0000,0xafdd0281,0x9cafbac0,0xdd0cffd1,0x95125c95,0x54d42480,0x07850000,0xdbae0000,0x4c490000,0x202e0052,0xf14f6d18,0xee6c6033,0xf86814f8},
	{0xf675c480,0xb4b60000,0xd5290000,0xf0ea0000,0x8ced0039,0x74053628,0xed145c39,0x0e54ad25,0x70b925c0,0x85f00000,0x517f0000,0x06b40000,0x58a80246,0xb8010f51,0x574b2e49,0xfd9e8571},
	{0xde0dc9c0,0xe6110000,0x0f040000,0x91f00000,0x9d4301ea,0xe4a5f0b8,0x053dfa3a,0x2a180e73,0xb56f20c0,0x50cc0000,0x6c6a0000,0x0c6f0000,0x0ae40358,0x26b846cf,0x6d19916d,0x717c93c1},
	{0x2203cc00,0xa78f0000,0xc0a10000,0x4ff10000,0xbe730352,0x0c0f7c50,0x352559d2,0xb15effc3,0x91022180,0xd2b90000,0xe6bb0000,0x46920000,0x7262014c,0x6ff62486,0xd43edf17,0x748a0248},
	{0xfa60c880,0x64640000,0x85d50000,0xdb0d0000,0xe5c503fe,0xadeb92f1,0xbc1ab440,0x2fee9ffa,0x6d0c2440,0x93270000,0x291e0000,0x98930000,0x515203f4,0x875ca86e,0xe4267cff,0xefccf3f8},
	{0x066ecd40,0x25fa0000,0x4a700000,0x050c0000,0xc6f50146,0x45411e19,0x8c0217a8,0xb4a86e4a,0x49612500,0x11520000,0xa3cf0000,0xd26e0000,0x29d401e0,0xce12ca27,0x5d013285,0xea3a6271},
	{0x17cec0c0,0xe3ff0000,0x62ed0000,0xb0cc0000,0xa6270333,0xa3f21dff,0x6e61ad67,0x87402a1c,0x45742900,0xc1800000,0xf3330000,0xf9890000,0x40fc0227,0x17fc6efe,0x0c0fdafc,0xcb8050ae},
	{0xebc0c500,0xa2610000,0xad480000,0x6ecd0000,0x8517018b,0x4b589117,0x5e790e8f,0x1c06dbac,0x61192840,0x43f50000,0x79e20000,0xb3740000,0x387a0033,0x5eb20cb7,0xb5289486,0xce76c127},
	{0x33a3c180,0x618a0000,0xe83c0000,0xfa310000,0xdea10127,0xeabc7fb6,0xd746e31d,0x82b6bb95,0x9d172d80,0x026b0000,0xb6470000,0x6d750000,0x1b4a028b,0xb618805f,0x8530376e,0x55303097},
	{0xcfadc440,0x20140000,0x27990000,0x24300000,0xfd91039f,0x0216f35e,0xe75e40f5,0x19f04a25,0xb97a2cc0,0x801e0000,0x3c960000,0x27880000,0x63cc009f,0xff56e216,0x3c177914,0x50c6a11e},
	{0xe7d5c900,0x72b30000,0xfdb40000,0x452a0000,0xec3f024c,0x92b635ce,0x0f77e6f6,0x3dbce973,0x7cac29c0,0x55220000,0x01830000,0x2d530000,0x31800181,0x61efab88,0x0645c630,0xdc24b7ae},
	{0x1bdbccc0,0x332d0000,0x32110000,0x9b2b0000,0xcf0f00f4,0x7a1cb926,0x3f6f451e,0xa6fa18c3,0x58c12880,0xd7570000,0x8b520000,0x67ae0000,0x49060395,0x28a1c9c1,0xbf62884a,0xd9d22627},
	{0xc3b8c840,0xf0c60000,0x77650000,0x0fd70000,0x94b90058,0xdbf85787,0xb650a88c,0x384a78fa,0xa4cf2d40,0x96c90000,0x44f70000,0xb9af0000,0x6a36012d,0xc00b4529,0x8f7a2ba2,0x4294d797},
	{0x3fb6cd80,0xb1580000,0xb8c00000,0xd1d60000,0xb78902e0,0x3352db6f,0x86480b64,0xa30c894a,0x80a22c00,0x14bc0000,0xce260000,0xf3520000,0x12b00339,0x89452760,0x365d65d8,0x4762461e},
	{0x2de88000,0x6cca0000,0x03a80000,0xb9ea0000,0xb2b60127,0x6f5eb017,0x80536f17,0x31b97a26,0x28485000,0x98940000,0xfd2b0000,0x89490000,0xe530017d,0x614446b7,0xbf85093a,0xdd89291f},
	{0xd1e685c0,0x2d540000,0xcc0d0000,0x67eb0000,0x9186039f,0x87f43cff,0xb04bccff,0xaaff8b96,0x0c255140,0x1ae10000,0x77fa0000,0xc3b40000,0x9db60369,0x280a24fe,0x06a24740,0xd87fb896},
	{0x09858140,0xeebf0000,0x89790000,0xf3170000,0xca300333,0x2610d25e,0x3974216d,0x344febaf,0xf02b5480,0x5b7f0000,0xb85f0000,0x1db50000,0xbe8601d1,0xc0a0a816,0x36bae4a8,0x43394926},
	{0xf58b8480,0xaf210000,0x46dc0000,0x2d160000,0xe900018b,0xceba5eb6,0x096c8285,0xaf091a1f,0xd44655c0,0xd90a0000,0x328e0000,0x57480000,0xc60003c5,0x89eeca5f,0x8f9daad2,0x46cfd8af},
	{0xddf389c0,0xfd860000,0x9cf10000,0x4c0c0000,0xf8ae0058,0x5e1a9826,0xe1452486,0x8b45b949,0x119050c0,0x0c360000,0x0f9b0000,0x5d930000,0x944c02db,0x175783c1,0xb5cf15f6,0xca2dce1f},
	{0x21fd8c00,0xbc180000,0x53540000,0x920d0000,0xdb9e02e0,0xb6b014ce,0xd15d876e,0x100348f9,0x35fd5180,0x8e430000,0x854a0000,0x176e0000,0xecca00cf,0x5e19e188,0x0ce85b8c,0xcfdb5f96},
	{0xf99e8880,0x7ff30000,0x16200000,0x06f10000,0x8028024c,0x1754fa6f,0x58626afc,0x8eb328c0,0xc9f35440,0xcfdd0000,0x4aef0000,0xc96f0000,0xcffa0277,0xb6b36d60,0x3cf0f864,0x549dae26},
	{0x05908d40,0x3e6d0000,0xd9850000,0xd8f00000,0xa31800f4,0xfffe7687,0x687ac914,0x15f5d970,0xed9e5500,0x4da80000,0xc03e0000,0x83920000,0xb77c0063,0xfffd0f29,0x85d7b61e,0x516b3faf},
	{0x143080c0,0xf8680000,0xf1180000,0x6d300000,0xc3ca0281,0x194d7561,0x8a1973db,0x261d9d26,0xe18b5900,0x9d7a0000,0x90c20000,0xa8750000,0xde5403a4,0x2613abf0,0xd4d95e67,0x70d10d70},
	{0xe83e8500,0xb9f60000,0x3ebd0000,0xb3310000,0xe0fa0039,0xf1e7f989,0xba01d033,0xbd5b6c96,0xc5e65840,0x1f0f0000,0x1a130000,0xe2880000,0xa6d201b0,0x6f5dc9b9,0x6dfe101d,0x75279cf9},
	{0x305d8180,0x7a1d0000,0x7bc90000,0x27cd0000,0xbb4c0095,0x50031728,0x333e3da1,0x23eb0caf,0x39e85d80,0x5e910000,0xd5b60000,0x3c890000,0x85e20308,0x87f74551,0x5de6b3f5,0xee616d49},
	{0xcc538440,0x3b830000,0xb46c0000,0xf9cc0000,0x987c022d,0xb8a99bc0,0x03269e49,0xb8adfd1f,0x1d855cc0,0xdce40000,0x5f670000,0x76740000,0xfd64011c,0xceb92718,0xe4c1fd8f,0xeb97fcc0},
	{0xe42b8900,0x69240000,0x6e410000,0x98d60000,0x89d203fe,0x28095d50,0xeb0f384a,0x9ce15e49,0xd85359c0,0x09d80000,0x62720000,0x7caf0000,0xaf280002,0x50006e86,0xde9342ab,0x6775ea70},
	{0x18258cc0,0x28ba0000,0xa1e40000,0x46d70000,0xaae20146,0xc0a3d1b8,0xdb179ba2,0x07a7aff9,0xfc3e5880,0x8bad0000,0xe8a30000,0x36520000,0xd7ae0216,0x194e0ccf,0x67b40cd1,0x62837bf9},
	{0xc0468840,0xeb510000,0xe4900000,0xd22b0000,0xf15401ea,0x61473f19,0x52287630,0x9917cfc0,0x00305d40,0xca330000,0x27060000,0xe8530000,0xf49e00ae,0xf1e48027,0x57acaf39,0xf9c58a49},
	{0x3c488d80,0xaacf0000,0x2b350000,0x0c2a0000,0xd2640352,0x89edb3f1,0x6230d5d8,0x02513e70,0x245d5c00,0x48460000,0xadd70000,0xa2ae0000,0x8c1802ba,0xb8aae26e,0xee8be143,0xfc331bc0},
	{0x8917f000,0x30300000,0x60590000,0xe8160000,0x2c1e00a4,0x5eb17519,0x5885eb8c,0x8ae827f8,0x8f496000,0xdff90000,0x0d2f0000,0x05490000,0x1e75014c,0xea14eb27,0x832b531d,0xc785c3fb},
	{0x7519f5c0,0x71ae0000,0xaffc0000,0x36170000,0x0f2e021c,0xb61bf9f1,0x689d4864,0x11aed648,0xab246140,0x5d8c0000,0x87fe0000,0x4fb40000,0x66f30358,0xa35a896e,0x3a0c1d67,0xc2735272},
	{0xad7af140,0xb2450000,0xea880000,0xa2eb0000,0x549802b0,0x17ff1750,0xe1a2a5f6,0x8f1eb671,0x572a6480,0x1c120000,0x485b0000,0x91b50000,0x45c301e0,0x4bf00586,0x0a14be8f,0x5935a3c2},
	{0x5174f480,0xf3db0000,0x252d0000,0x7cea0000,0x77a80008,0xff559bb8,0xd1ba061e,0x145847c1,0x734765c0,0x9e670000,0xc28a0000,0xdb480000,0x3d4503f4,0x02be67cf,0xb333f0f5,0x5cc3324b},
	{0x790cf9c0,0xa17c0000,0xff000000,0x1df00000,0x660601db,0x6ff55d28,0x3993a01d,0x3014e497,0xb69160c0,0x4b5b0000,0xff9f0000,0xd1930000,0x6f0902ea,0x9c072e51,0x89614fd1,0xd02124fb},
	{0x8502fc00,0xe0e20000,0x30a50000,0xc3f10000,0x45360363,0x875fd1c0,0x098b03f5,0xab521527,0x92fc6180,0xc92e0000,0x754e0000,0x9b6e0000,0x178f00fe,0xd5494c18,0x304601ab,0xd5d7b572},
	{0x5d61f880,0x23090000,0x75d10000,0x570d0000,0x1e8003cf,0x26bb3f61,0x80b4ee67,0x35e2751e,0x6ef26440,0x88b00000,0xbaeb0000,0x456f0000,0x34bf0246,0x3de3c0f0,0x005ea243,0x4e9144c2},
	{0xa16ffd40,0x62970000,0xba740000,0x890c0000,0x3db00177,0xce11b389,0xb0ac4d8f,0xaea484ae,0x4a9f6500,0x0ac50000,0x303a0000,0x0f920000,0x4c390052,0x74ada2b9,0xb979ec39,0x4b67d54b},
	{0xb0cff0c0,0xa4920000,0x92e90000,0x3ccc0000,0x5d620302,0x28a2b06f,0x52cff740,0x9d4cc0f8,0x468a6900,0xda170000,0x60c60000,0x24750000,0x25110395,0xad430660,0xe8770440,0x6adde794},
	{0x4cc1f500,0xe50c0000,0x5d4c0000,0xe2cd0000,0x7e5201ba,0xc0083c87,0x62d754a8,0x060a3148,0x62e76840,0x58620000,0xea170000,0x6e880000,0x5d970181,0xe40d6429,0x51504a3a,0x6f2b761d},
	{0x94a2f180,0x26e70000,0x18380000,0x76310000,0x25e40116,0x61ecd226,0xebe8b93a,0x98ba5171,0x9ee96d80,0x19fc0000,0x25b20000,0xb0890000,0x7ea70339,0x0ca7e8c1,0x6148e9d2,0xf46d87ad},
	{0x68acf440,0x67790000,0xd79d0000,0xa8300000,0x06d403ae,0x89465ece,0xdbf01ad2,0x03fca0c1,0xba846cc0,0x9b890000,0xaf630000,0xfa740000,0x0621012d,0x45e98a88,0xd86fa7a8,0xf19b1624},
	{0x40d4f900,0x35de0000,0x0db00000,0xc92a0000,0x177a027d,0x19e6985e,0x33d9bcd1,0x27b00397,0x7f5269c0,0x4eb50000,0x92760000,0xf0af0000,0x546d0033,0xdb50c316,0xe23d188c,0x7d790094},
	{0xbcdafcc0,0x74400000,0xc2150000,0x172b0000,0x344a00c5,0xf14c14b6,0x03c11f39,0xbcf6f227,0x5b3f6880,0xccc00000,0x18a70000,0xba520000,0x2ceb0227,0x921ea15f,0x5b1a56f6,0x788f911d},
	{0x64b9f840,0xb7ab0000,0x87610000,0x83d70000,0x6ffc0069,0x50a8fa17,0x8afef2ab,0x2246921e,0xa7316d40,0x8d5e0000,0xd7020000,0x64530000,0x0fdb009f,0x7ab42db7,0x6b02f51e,0xe3c960ad},
	{0x98b7fd80,0xf6350000,0x48c40000,0x5dd60000,0x4ccc02d1,0xb80276ff,0xbae65143,0xb90063ae,0x835c6c00,0x0f2b0000,0x5dd30000,0x2eae0000,0x775d028b,0x33fa4ffe,0xd225bb64,0xe63ff124},
	{0x2bb61000,0x83030000,0x6ede0000,0x54b50000,0x80dd00cf,0xdbfb2e29,0x5bfdd786,0x7cd49e25,0xa15fa000,0xa8a40000,0x9d720000,0x615f0000,0xc92e01d9,0x3ff533ae,0xe700e2b6,0x57610ee7},
	{0xd7b815c0,0xc29d0000,0xa17b0000,0x8ab40000,0xa3ed0277,0x3351a2c1,0x6be5746e,0xe7926f95,0x8532a140,0x2ad10000,0x17a30000,0x2ba20000,0xb1a803cd,0x76bb51e7,0x5e27accc,0x52979f6e},
	{0x0fdb1140,0x01760000,0xe40f0000,0x1e480000,0xf85b02db,0x92b54c60,0xe2da99fc,0x79220fac,0x793ca480,0x6b4f0000,0xd8060000,0xf5a30000,0x92980175,0x9e11dd0f,0x6e3f0f24,0xc9d16ede},
	{0xf3d51480,0x40e80000,0x2baa0000,0xc0490000,0xdb6b0063,0x7a1fc088,0xd2c23a14,0xe264fe1c,0x5d51a5c0,0xe93a0000,0x52d70000,0xbf5e0000,0xea1e0361,0xd75fbf46,0xd718415e,0xcc27ff57},
	{0xdbad19c0,0x124f0000,0xf1870000,0xa1530000,0xcac501b0,0xeabf0618,0x3aeb9c17,0xc6285d4a,0x9887a0c0,0x3c060000,0x6fc20000,0xb5850000,0xb852027f,0x49e6f6d8,0xed4afe7a,0x40c5e9e7},
	{0x27a31c00,0x53d10000,0x3e220000,0x7f520000,0xe9f50308,0x02158af0,0x0af33fff,0x5d6eacfa,0xbceaa180,0xbe730000,0xe5130000,0xff780000,0xc0d4006b,0x00a89491,0x546db000,0x4533786e},
	{0xffc01880,0x903a0000,0x7b560000,0xebae0000,0xb24303a4,0xa3f16451,0x83ccd26d,0xc3deccc3,0x40e4a440,0xffed0000,0x2ab60000,0x21790000,0xe3e402d3,0xe8021879,0x647513e8,0xde7589de},
	{0x03ce1d40,0xd1a40000,0xb4f30000,0x35af0000,0x9173011c,0x4b5be8b9,0xb3d47185,0x58983d73,0x6489a500,0x7d980000,0xa0670000,0x6b840000,0x9b6200c7,0xa14c7a30,0xdd525d92,0xdb831857},
	{0x126e10c0,0x17a10000,0x9c6e0000,0x806f0000,0xf1a10369,0xade8eb5f,0x51b7cb4a,0x6b707925,0x689ca900,0xad4a0000,0xf09b0000,0x40630000,0xf24a0300,0x78a2dee9,0x8c5cb5eb,0xfa392a88},
	{0xee601500,0x563f0000,0x53cb0000,0x5e6e0000,0xd29101d1,0x454267b7,0x61af68a2,0xf0368895,0x4cf1a840,0x2f3f0000,0x7a4a0000,0x0a9e0000,0x8acc0114,0x31ecbca0,0x357bfb91,0xffcfbb01},
	{0x36031180,0x95d40000,0x16bf0000,0xca920000,0x8927017d,0xe4a68916,0xe8908530,0x6e86e8ac,0xb0ffad80,0x6ea10000,0xb5ef0000,0xd49f0000,0xa9fc03ac,0xd9463048,0x05635879,0x64894ab1},
	{0xca0d1440,0xd44a0000,0xd91a0000,0x14930000,0xaa1703c5,0x0c0c05fe,0xd88826d8,0xf5c0191c,0x9492acc0,0xecd40000,0x3f3e0000,0x9e620000,0xd17a01b8,0x90085201,0xbc441603,0x617fdb38},
	{0xe2751900,0x86ed0000,0x03370000,0x75890000,0xbbb90216,0x9cacc36e,0x30a180db,0xd18cba4a,0x5144a9c0,0x39e80000,0x022b0000,0x94b90000,0x833600a6,0x0eb11b9f,0x8616a927,0xed9dcd88},
	{0x1e7b1cc0,0xc7730000,0xcc920000,0xab880000,0x988900ae,0x74064f86,0x00b92333,0x4aca4bfa,0x7529a880,0xbb9d0000,0x88fa0000,0xde440000,0xfbb002b2,0x47ff79d6,0x3f31e75d,0xe86b5c01},
	{0xc6181840,0x04980000,0x89e60000,0x3f740000,0xc33f0002,0xd5e2a127,0x8986cea1,0xd47a2bc3,0x8927ad40,0xfa030000,0x475f0000,0x00450000,0xd880000a,0xaf55f53e,0x0f2944b5,0x732dadb1},
	{0x3a161d80,0x45060000,0x46430000,0xe1750000,0xe00f02ba,0x3d482dcf,0xb99e6d49,0x4f3cda73,0xad4aac00,0x78760000,0xcd8e0000,0x4ab80000,0xa006021e,0xe61b9777,0xb60e0acf,0x76db3c38},
	{0x8f496000,0xdff90000,0x0d2f0000,0x05490000,0x1e75014c,0xea14eb27,0x832b531d,0xc785c3fb,0x065e9000,0xefc90000,0x6d760000,0xed5f0000,0x326b01e8,0xb4a59e3e,0xdbaeb891,0x4d6de403},
	{0x734765c0,0x9e670000,0xc28a0000,0xdb480000,0x3d4503f4,0x02be67cf,0xb333f0f5,0x5cc3324b,0x22339140,0x6dbc0000,0xe7a70000,0xa7a20000,0x4aed03fc,0xfdebfc77,0x6289f6eb,0x489b758a},
	{0xab246140,0x5d8c0000,0x87fe0000,0x4fb40000,0x66f30358,0xa35a896e,0x3a0c1d67,0xc2735272,0xde3d9480,0x2c220000,0x28020000,0x79a30000,0x69dd0144,0x1541709f,0x52915503,0xd3dd843a},
	{0x572a6480,0x1c120000,0x485b0000,0x91b50000,0x45c301e0,0x4bf00586,0x0a14be8f,0x5935a3c2,0xfa5095c0,0xae570000,0xa2d30000,0x335e0000,0x115b0350,0x5c0f12d6,0xebb61b79,0xd62b15b3},
	{0x7f5269c0,0x4eb50000,0x92760000,0xf0af0000,0x546d0033,0xdb50c316,0xe23d188c,0x7d790094,0x3f8690c0,0x7b6b0000,0x9fc60000,0x39850000,0x4317024e,0xc2b65b48,0xd1e4a45d,0x5ac90303},
	{0x835c6c00,0x0f2b0000,0x5dd30000,0x2eae0000,0x775d028b,0x33fa4ffe,0xd225bb64,0xe63ff124,0x1beb9180,0xf91e0000,0x15170000,0x73780000,0x3b91005a,0x8bf83901,0x68c3ea27,0x5f3f928a},
	{0x5b3f6880,0xccc00000,0x18a70000,0xba520000,0x2ceb0227,0x921ea15f,0x5b1a56f6,0x788f911d,0xe7e59440,0xb8800000,0xdab20000,0xad790000,0x18a102e2,0x6352b5e9,0x58db49cf,0xc479633a},
	{0xa7316d40,0x8d5e0000,0xd7020000,0x64530000,0x0fdb009f,0x7ab42db7,0x6b02f51e,0xe3c960ad,0xc3889500,0x3af50000,0x50630000,0xe7840000,0x602700f6,0x2a1cd7a0,0xe1fc07b5,0xc18ff2b3},
	{0xb69160c0,0x4b5b0000,0xff9f0000,0xd1930000,0x6f0902ea,0x9c072e51,0x89614fd1,0xd02124fb,0xcf9d9900,0xea270000,0x009f0000,0xcc630000,0x090f0331,0xf3f27379,0xb0f2efcc,0xe035c06c},
	{0x4a9f6500,0x0ac50000,0x303a0000,0x0f920000,0x4c390052,0x74ada2b9,0xb979ec39,0x4b67d54b,0xebf09840,0x68520000,0x8a4e0000,0x869e0000,0x71890125,0xbabc1130,0x09d5a1b6,0xe5c351e5},
	{0x92fc6180,0xc92e0000,0x754e0000,0x9b6e0000,0x178f00fe,0xd5494c18,0x304601ab,0xd5d7b572,0x17fe9d80,0x29cc0000,0x45eb0000,0x589f0000,0x52b9039d,0x52169dd8,0x39cd025e,0x7e85a055},
	{0x6ef26440,0x88b00000,0xbaeb0000,0x456f0000,0x34bf0246,0x3de3c0f0,0x005ea243,0x4e9144c2,0x33939cc0,0xabb90000,0xcf3a0000,0x12620000,0x2a3f0189,0x1b58ff91,0x80ea4c24,0x7b7331dc},
	{0x468a6900,0xda170000,0x60c60000,0x24750000,0x25110395,0xad430660,0xe8770440,0x6adde794,0xf64599c0,0x7e850000,0xf22f0000,0x18b90000,0x78730097,0x85e1b60f,0xbab8f300,0xf791276c},
	{0xba846cc0,0x9b890000,0xaf630000,0xfa740000,0x0621012d,0x45e98a88,0xd86fa7a8,0xf19b1624,0xd2289880,0xfcf00000,0x78fe0000,0x52440000,0x00f50283,0xccafd446,0x039fbd7a,0xf267b6e5},
	{0x62e76840,0x58620000,0xea170000,0x6e880000,0x5d970181,0xe40d6429,0x51504a3a,0x6f2b761d,0x2e269d40,0xbd6e0000,0xb75b0000,0x8c450000,0x23c5003b,0x240558ae,0x33871e92,0x69214755},
	{0x9ee96d80,0x19fc0000,0x25b20000,0xb0890000,0x7ea70339,0x0ca7e8c1,0x6148e9d2,0xf46d87ad,0x0a4b9c00,0x3f1b0000,0x3d8a0000,0xc6b80000,0x5b43022f,0x6d4b3ae7,0x8aa050e8,0x6cd7d6dc},
	{0x8cb72000,0xc46e0000,0x9eda0000,0xd8b50000,0x7b9800fe,0x50ab83b9,0x67538da1,0x66d874c1,0xa2a1e000,0xb3330000,0x0e870000,0xbca30000,0xacc3006b,0x854a5b30,0x03783c0a,0xf63cb9dd},
	{0x70b925c0,0x85f00000,0x517f0000,0x06b40000,0x58a80246,0xb8010f51,0x574b2e49,0xfd9e8571,0x86cce140,0x31460000,0x84560000,0xf65e0000,0xd445027f,0xcc043979,0xba5f7270,0xf3ca2854},
	{0xa8da2140,0x461b0000,0x140b0000,0x92480000,0x031e02ea,0x19e5e1f0,0xde74c3db,0x632ee548,0x7ac2e480,0x70d80000,0x4bf30000,0x285f0000,0xf77500c7,0x24aeb591,0x8a47d198,0x688cd9e4},
	{0x54d42480,0x07850000,0xdbae0000,0x4c490000,0x202e0052,0xf14f6d18,0xee6c6033,0xf86814f8,0x5eafe5c0,0xf2ad0000,0xc1220000,0x62a20000,0x8ff302d3,0x6de0d7d8,0x33609fe2,0x6d7a486d},
	{0x7cac29c0,0x55220000,0x01830000,0x2d530000,0x31800181,0x61efab88,0x0645c630,0xdc24b7ae,0x9b79e0c0,0x27910000,0xfc370000,0x68790000,0xddbf03cd,0xf3599e46,0x093220c6,0xe1985edd},
	{0x80a22c00,0x14bc0000,0xce260000,0xf3520000,0x12b00339,0x89452760,0x365d65d8,0x4762461e,0xbf14e180,0xa5e40000,0x76e60000,0x22840000,0xa53901d9,0xba17fc0f,0xb0156ebc,0xe46ecf54},
	{0x58c12880,0xd7570000,0x8b520000,0x67ae0000,0x49060395,0x28a1c9c1,0xbf62884a,0xd9d22627,0x431ae440,0xe47a0000,0xb9430000,0xfc850000,0x86090361,0x52bd70e7,0x800dcd54,0x7f283ee4},
	{0xa4cf2d40,0x96c90000,0x44f70000,0xb9af0000,0x6a36012d,0xc00b4529,0x8f7a2ba2,0x4294d797,0x6777e500,0x660f0000,0x33920000,0xb6780000,0xfe8f0175,0x1bf312ae,0x392a832e,0x7adeaf6d},
	{0xb56f20c0,0x50cc0000,0x6c6a0000,0x0c6f0000,0x0ae40358,0x26b846cf,0x6d19916d,0x717c93c1,0x6b62e900,0xb6dd0000,0x636e0000,0x9d9f0000,0x97a702b2,0xc21db677,0x68246b57,0x5b649db2},
	{0x49612500,0x11520000,0xa3cf0000,0xd26e0000,0x29d401e0,0xce12ca27,0x5d013285,0xea3a6271,0x4f0fe840,0x34a80000,0xe9bf0000,0xd7620000,0xef2100a6,0x8b53d43e,0xd103252d,0x5e920c3b},
	{0x91022180,0xd2b90000,0xe6bb0000,0x46920000,0x7262014c,0x6ff62486,0xd43edf17,0x748a0248,0xb301ed80,0x75360000,0x261a0000,0x09630000,0xcc11021e,0x63f958d6,0xe11b86c5,0xc5d4fd8b},
	{0x6d0c2440,0x93270000,0x291e0000,0x98930000,0x515203f4,0x875ca86e,0xe4267cff,0xefccf3f8,0x976cecc0,0xf7430000,0xaccb0000,0x439e0000,0xb497000a,0x2ab73a9f,0x583cc8bf,0xc0226c02},
	{0x45742900,0xc1800000,0xf3330000,0xf9890000,0x40fc0227,0x17fc6efe,0x0c0fdafc,0xcb8050ae,0x52bae9c0,0x227f0000,0x91de0000,0x49450000,0xe6db0114,0xb40e7301,0x626e779b,0x4cc07ab2},
	{0xb97a2cc0,0x801e0000,0x3c960000,0x27880000,0x63cc009f,0xff56e216,0x3c177914,0x50c6a11e,0x76d7e880,0xa00a0000,0x1b0f0000,0x03b80000,0x9e5d0300,0xfd401148,0xdb4939e1,0x4936eb3b},
	{0x61192840,0x43f50000,0x79e20000,0xb3740000,0x387a0033,0x5eb20cb7,0xb5289486,0xce76c127,0x8ad9ed40,0xe1940000,0xd4aa0000,0xddb90000,0xbd6d01b8,0x15ea9da0,0xeb519a09,0xd2701a8b},
	{0x9d172d80,0x026b0000,0xb6470000,0x6d750000,0x1b4a028b,0xb618805f,0x8530376e,0x55303097,0xaeb4ec00,0x63e10000,0x5e7b0000,0x97440000,0xc5eb03ac,0x5ca4ffe9,0x5276d473,0xd7868b02},
	{0x28485000,0x98940000,0xfd2b0000,0x89490000,0xe530017d,0x614446b7,0xbf85093a,0xdd89291f,0x05a0d000,0xf45e0000,0xfe830000,0x30a30000,0x5786005a,0x0e1af6a0,0x3fd6662d,0xec305339},
	{0xd44655c0,0xd90a0000,0x328e0000,0x57480000,0xc60003c5,0x89eeca5f,0x8f9daad2,0x46cfd8af,0x21cdd140,0x762b0000,0x74520000,0x7a5e0000,0x2f00024e,0x475494e9,0x86f12857,0xe9c6c2b0},
	{0x0c255140,0x1ae10000,0x77fa0000,0xc3b40000,0x9db60369,0x280a24fe,0x06a24740,0xd87fb896,0xddc3d480,0x37b50000,0xbbf70000,0xa45f0000,0x0c3000f6,0xaffe1801,0xb6e98bbf,0x72803300},
	{0xf02b5480,0x5b7f0000,0xb85f0000,0x1db50000,0xbe8601d1,0xc0a0a816,0x36bae4a8,0x43394926,0xf9aed5c0,0xb5c00000,0x31260000,0xeea20000,0x74b602e2,0xe6b07a48,0x0fcec5c5,0x7776a289},
	{0xd85359c0,0x09d80000,0x62720000,0x7caf0000,0xaf280002,0x50006e86,0xde9342ab,0x6775ea70,0x3c78d0c0,0x60fc0000,0x0c330000,0xe4790000,0x26fa03fc,0x780933d6,0x359c7ae1,0xfb94b439},
	{0x245d5c00,0x48460000,0xadd70000,0xa2ae0000,0x8c1802ba,0xb8aae26e,0xee8be143,0xfc331bc0,0x1815d180,0xe2890000,0x86e20000,0xae840000,0x5e7c01e8,0x3147519f,0x8cbb349b,0xfe6225b0},
	{0xfc3e5880,0x8bad0000,0xe8a30000,0x36520000,0xd7ae0216,0x194e0ccf,0x67b40cd1,0x62837bf9,0xe41bd440,0xa3170000,0x49470000,0x70850000,0x7d4c0350,0xd9eddd77,0xbca39773,0x6524d400},
	{0x00305d40,0xca330000,0x27060000,0xe8530000,0xf49e00ae,0xf1e48027,0x57acaf39,0xf9c58a49,0xc076d500,0x21620000,0xc3960000,0x3a780000,0x05ca0144,0x90a3bf3e,0x0584d909,0x60d24589},
	{0x119050c0,0x0c360000,0x0f9b0000,0x5d930000,0x944c02db,0x175783c1,0xb5cf15f6,0xca2dce1f,0xcc63d900,0xf1b00000,0x936a0000,0x119f0000,0x6ce20283,0x494d1be7,0x548a3170,0x41687756},
	{0xed9e5500,0x4da80000,0xc03e0000,0x83920000,0xb77c0063,0xfffd0f29,0x85d7b61e,0x516b3faf,0xe80ed840,0x73c50000,0x19bb0000,0x5b620000,0x14640097,0x000379ae,0xedad7f0a,0x449ee6df},
	{0x35fd5180,0x8e430000,0x854a0000,0x176e0000,0xecca00cf,0x5e19e188,0x0ce85b8c,0xcfdb5f96,0x1400dd80,0x325b0000,0xd61e0000,0x85630000,0x3754022f,0xe8a9f546,0xddb5dce2,0xdfd8176f},
	{0xc9f35440,0xcfdd0000,0x4aef0000,0xc96f0000,0xcffa0277,0xb6b36d60,0x3cf0f864,0x549dae26,0x306ddcc0,0xb02e0000,0x5ccf0000,0xcf9e0000,0x4fd2003b,0xa1e7970f,0x64929298,0xda2e86e6},
	{0xe18b5900,0x9d7a0000,0x90c20000,0xa8750000,0xde5403a4,0x2613abf0,0xd4d95e67,0x70d10d70,0xf5bbd9c0,0x65120000,0x61da0000,0xc5450000,0x1d9e0125,0x3f5ede91,0x5ec02dbc,0x56cc9056},
	{0x1d855cc0,0xdce40000,0x5f670000,0x76740000,0xfd64011c,0xceb92718,0xe4c1fd8f,0xeb97fcc0,0xd1d6d880,0xe7670000,0xeb0b0000,0x8fb80000,0x65180331,0x7610bcd8,0xe7e763c6,0x533a01df},
	{0xc5e65840,0x1f0f0000,0x1a130000,0xe2880000,0xa6d201b0,0x6f5dc9b9,0x6dfe101d,0x75279cf9,0x2dd8dd40,0xa6f90000,0x24ae0000,0x51b90000,0x46280189,0x9eba3030,0xd7ffc02e,0xc87cf06f},
	{0x39e85d80,0x5e910000,0xd5b60000,0x3c890000,0x85e20308,0x87f74551,0x5de6b3f5,0xee616d49,0x09b5dc00,0x248c0000,0xae7f0000,0x1b440000,0x3eae039d,0xd7f45279,0x6ed88e54,0xcd8a61e6},
	{0xa15fa000,0xa8a40000,0x9d720000,0x615f0000,0xc92e01d9,0x3ff533ae,0xe700e2b6,0x57610ee7,0x8ae9b000,0x2ba70000,0xf3ac0000,0x35ea0000,0x49f30116,0xe40e1d87,0xbcfd3530,0x2bb590c2},
	{0x5d51a5c0,0xe93a0000,0x52d70000,0xbf5e0000,0xea1e0361,0xd75fbf46,0xd718415e,0xcc27ff57,0xae84b140,0xa9d20000,0x797d0000,0x7f170000,0x31750302,0xad407fce,0x05da7b4a,0x2e43014b},
	{0x8532a140,0x2ad10000,0x17a30000,0x2ba20000,0xb1a803cd,0x76bb51e7,0x5e27accc,0x52979f6e,0x528ab480,0xe84c0000,0xb6d80000,0xa1160000,0x124501ba,0x45eaf326,0x35c2d8a2,0xb505f0fb},
	{0x793ca480,0x6b4f0000,0xd8060000,0xf5a30000,0x92980175,0x9e11dd0f,0x6e3f0f24,0xc9d16ede,0x76e7b5c0,0x6a390000,0x3c090000,0xebeb0000,0x6ac303ae,0x0ca4916f,0x8ce596d8,0xb0f36172},
	{0x5144a9c0,0x39e80000,0x022b0000,0x94b90000,0x833600a6,0x0eb11b9f,0x8616a927,0xed9dcd88,0xb331b0c0,0xbf050000,0x011c0000,0xe1300000,0x388f02b0,0x921dd8f1,0xb6b729fc,0x3c1177c2},
	{0xad4aac00,0x78760000,0xcd8e0000,0x4ab80000,0xa006021e,0xe61b9777,0xb60e0acf,0x76db3c38,0x975cb180,0x3d700000,0x8bcd0000,0xabcd0000,0x400900a4,0xdb53bab8,0x0f906786,0x39e7e64b},
	{0x7529a880,0xbb9d0000,0x88fa0000,0xde440000,0xfbb002b2,0x47ff79d6,0x3f31e75d,0xe86b5c01,0x6b52b440,0x7cee0000,0x44680000,0x75cc0000,0x6339021c,0x33f93650,0x3f88c46e,0xa2a117fb},
	{0x8927ad40,0xfa030000,0x475f0000,0x00450000,0xd880000a,0xaf55f53e,0x0f2944b5,0x732dadb1,0x4f3fb500,0xfe9b0000,0xceb90000,0x3f310000,0x1bbf0008,0x7ab75419,0x86af8a14,0xa7578672},
	{0x9887a0c0,0x3c060000,0x6fc20000,0xb5850000,0xb852027f,0x49e6f6d8,0xed4afe7a,0x40c5e9e7,0x432ab900,0x2e490000,0x9e450000,0x14d60000,0x729703cf,0xa359f0c0,0xd7a1626d,0x86edb4ad},
	{0x6489a500,0x7d980000,0xa0670000,0x6b840000,0x9b6200c7,0xa14c7a30,0xdd525d92,0xdb831857,0x6747b840,0xac3c0000,0x14940000,0x5e2b0000,0x0a1101db,0xea179289,0x6e862c17,0x831b2524},
	{0xbceaa180,0xbe730000,0xe5130000,0xff780000,0xc0d4006b,0x00a89491,0x546db000,0x4533786e,0x9b49bd80,0xeda20000,0xdb310000,0x802a0000,0x29210363,0x02bd1e61,0x5e9e8fff,0x185dd494},
	{0x40e4a440,0xffed0000,0x2ab60000,0x21790000,0xe3e402d3,0xe8021879,0x647513e8,0xde7589de,0xbf24bcc0,0x6fd70000,0x51e00000,0xcad70000,0x51a70177,0x4bf37c28,0xe7b9c185,0x1dab451d},
	{0x689ca900,0xad4a0000,0xf09b0000,0x40630000,0xf24a0300,0x78a2dee9,0x8c5cb5eb,0xfa392a88,0x7af2b9c0,0xbaeb0000,0x6cf50000,0xc00c0000,0x03eb0069,0xd54a35b6,0xddeb7ea1,0x914953ad},
	{0x9492acc0,0xecd40000,0x3f3e0000,0x9e620000,0xd17a01b8,0x90085201,0xbc441603,0x617fdb38,0x5e9fb880,0x389e0000,0xe6240000,0x8af10000,0x7b6d027d,0x9c0457ff,0x64cc30db,0x94bfc224},
	{0x4cf1a840,0x2f3f0000,0x7a4a0000,0x0a9e0000,0x8acc0114,0x31ecbca0,0x357bfb91,0xffcfbb01,0xa291bd40,0x79000000,0x29810000,0x54f00000,0x585d00c5,0x74aedb17,0x54d49333,0x0ff93394},
	{0xb0ffad80,0x6ea10000,0xb5ef0000,0xd49f0000,0xa9fc03ac,0xd9463048,0x05635879,0x64894ab1,0x86fcbc00,0xfb750000,0xa3500000,0x1e0d0000,0x20db02d1,0x3de0b95e,0xedf3dd49,0x0a0fa21d},
	{0x05a0d000,0xf45e0000,0xfe830000,0x30a30000,0x5786005a,0x0e1af6a0,0x3fd6662d,0xec305339,0x2de88000,0x6cca0000,0x03a80000,0xb9ea0000,0xb2b60127,0x6f5eb017,0x80536f17,0x31b97a26},
	{0xf9aed5c0,0xb5c00000,0x31260000,0xeea20000,0x74b602e2,0xe6b07a48,0x0fcec5c5,0x7776a289,0x09858140,0xeebf0000,0x89790000,0xf3170000,0xca300333,0x2610d25e,0x3974216d,0x344febaf},
	{0x21cdd140,0x762b0000,0x74520000,0x7a5e0000,0x2f00024e,0x475494e9,0x86f12857,0xe9c6c2b0,0xf58b8480,0xaf210000,0x46dc0000,0x2d160000,0xe900018b,0xceba5eb6,0x096c8285,0xaf091a1f},
	{0xddc3d480,0x37b50000,0xbbf70000,0xa45f0000,0x0c3000f6,0xaffe1801,0xb6e98bbf,0x72803300,0xd1e685c0,0x2d540000,0xcc0d0000,0x67eb0000,0x9186039f,0x87f43cff,0xb04bccff,0xaaff8b96},
	{0xf5bbd9c0,0x65120000,0x61da0000,0xc5450000,0x1d9e0125,0x3f5ede91,0x5ec02dbc,0x56cc9056,0x143080c0,0xf8680000,0xf1180000,0x6d300000,0xc3ca0281,0x194d7561,0x8a1973db,0x261d9d26},
	{0x09b5dc00,0x248c0000,0xae7f0000,0x1b440000,0x3eae039d,0xd7f45279,0x6ed88e54,0xcd8a61e6,0x305d8180,0x7a1d0000,0x7bc90000,0x27cd0000,0xbb4c0095,0x50031728,0x333e3da1,0x23eb0caf},
	{0xd1d6d880,0xe7670000,0xeb0b0000,0x8fb80000,0x65180331,0x7610bcd8,0xe7e763c6,0x533a01df,0xcc538440,0x3b830000,0xb46c0000,0xf9cc0000,0x987c022d,0xb8a99bc0,0x03269e49,0xb8adfd1f},
	{0x2dd8dd40,0xa6f90000,0x24ae0000,0x51b90000,0x46280189,0x9eba3030,0xd7ffc02e,0xc87cf06f,0xe83e8500,0xb9f60000,0x3ebd0000,0xb3310000,0xe0fa0039,0xf1e7f989,0xba01d033,0xbd5b6c96},
	{0x3c78d0c0,0x60fc0000,0x0c330000,0xe4790000,0x26fa03fc,0x780933d6,0x359c7ae1,0xfb94b439,0xe42b8900,0x69240000,0x6e410000,0x98d60000,0x89d203fe,0x28095d50,0xeb0f384a,0x9ce15e49},
	{0xc076d500,0x21620000,0xc3960000,0x3a780000,0x05ca0144,0x90a3bf3e,0x0584d909,0x60d24589,0xc0468840,0xeb510000,0xe4900000,0xd22b0000,0xf15401ea,0x61473f19,0x52287630,0x9917cfc0},
	{0x1815d180,0xe2890000,0x86e20000,0xae840000,0x5e7c01e8,0x3147519f,0x8cbb349b,0xfe6225b0,0x3c488d80,0xaacf0000,0x2b350000,0x0c2a0000,0xd2640352,0x89edb3f1,0x6230d5d8,0x02513e70},
	{0xe41bd440,0xa3170000,0x49470000,0x70850000,0x7d4c0350,0xd9eddd77,0xbca39773,0x6524d400,0x18258cc0,0x28ba0000,0xa1e40000,0x46d70000,0xaae20146,0xc0a3d1b8,0xdb179ba2,0x07a7aff9},
	{0xcc63d900,0xf1b00000,0x936a0000,0x119f0000,0x6ce20283,0x494d1be7,0x548a3170,0x41687756,0xddf389c0,0xfd860000,0x9cf10000,0x4c0c0000,0xf8ae0058,0x5e1a9826,0xe1452486,0x8b45b949},
	{0x306ddcc0,0xb02e0000,0x5ccf0000,0xcf9e0000,0x4fd2003b,0xa1e7970f,0x64929298,0xda2e86e6,0xf99e8880,0x7ff30000,0x16200000,0x06f10000,0x8028024c,0x1754fa6f,0x58626afc,0x8eb328c0},
	{0xe80ed840,0x73c50000,0x19bb0000,0x5b620000,0x14640097,0x000379ae,0xedad7f0a,0x449ee6df,0x05908d40,0x3e6d0000,0xd9850000,0xd8f00000,0xa31800f4,0xfffe7687,0x687ac914,0x15f5d970},
	{0x1400dd80,0x325b0000,0xd61e0000,0x85630000,0x3754022f,0xe8a9f546,0xddb5dce2,0xdfd8176f,0x21fd8c00,0xbc180000,0x53540000,0x920d0000,0xdb9e02e0,0xb6b014ce,0xd15d876e,0x100348f9},
	{0x065e9000,0xefc90000,0x6d760000,0xed5f0000,0x326b01e8,0xb4a59e3e,0xdbaeb891,0x4d6de403,0x8917f000,0x30300000,0x60590000,0xe8160000,0x2c1e00a4,0x5eb17519,0x5885eb8c,0x8ae827f8},
	{0xfa5095c0,0xae570000,0xa2d30000,0x335e0000,0x115b0350,0x5c0f12d6,0xebb61b79,0xd62b15b3,0xad7af140,0xb2450000,0xea880000,0xa2eb0000,0x549802b0,0x17ff1750,0xe1a2a5f6,0x8f1eb671},
	{0x22339140,0x6dbc0000,0xe7a70000,0xa7a20000,0x4aed03fc,0xfdebfc77,0x6289f6eb,0x489b758a,0x5174f480,0xf3db0000,0x252d0000,0x7cea0000,0x77a80008,0xff559bb8,0xd1ba061e,0x145847c1},
	{0xde3d9480,0x2c220000,0x28020000,0x79a30000,0x69dd0144,0x1541709f,0x52915503,0xd3dd843a,0x7519f5c0,0x71ae0000,0xaffc0000,0x36170000,0x0f2e021c,0xb61bf9f1,0x689d4864,0x11aed648},
	{0xf64599c0,0x7e850000,0xf22f0000,0x18b90000,0x78730097,0x85e1b60f,0xbab8f300,0xf791276c,0xb0cff0c0,0xa4920000,0x92e90000,0x3ccc0000,0x5d620302,0x28a2b06f,0x52cff740,0x9d4cc0f8},
	{0x0a4b9c00,0x3f1b0000,0x3d8a0000,0xc6b80000,0x5b43022f,0x6d4b3ae7,0x8aa050e8,0x6cd7d6dc,0x94a2f180,0x26e70000,0x18380000,0x76310000,0x25e40116,0x61ecd226,0xebe8b93a,0x98ba5171},
	{0xd2289880,0xfcf00000,0x78fe0000,0x52440000,0x00f50283,0xccafd446,0x039fbd7a,0xf267b6e5,0x68acf440,0x67790000,0xd79d0000,0xa8300000,0x06d403ae,0x89465ece,0xdbf01ad2,0x03fca0c1},
	{0x2e269d40,0xbd6e0000,0xb75b0000,0x8c450000,0x23c5003b,0x240558ae,0x33871e92,0x69214755,0x4cc1f500,0xe50c0000,0x5d4c0000,0xe2cd0000,0x7e5201ba,0xc0083c87,0x62d754a8,0x060a3148},
	{0x3f8690c0,0x7b6b0000,0x9fc60000,0x39850000,0x4317024e,0xc2b65b48,0xd1e4a45d,0x5ac90303,0x40d4f900,0x35de0000,0x0db00000,0xc92a0000,0x177a027d,0x19e6985e,0x33d9bcd1,0x27b00397},
	{0xc3889500,0x3af50000,0x50630000,0xe7840000,0x602700f6,0x2a1cd7a0,0xe1fc07b5,0xc18ff2b3,0x64b9f840,0xb7ab0000,0x87610000,0x83d70000,0x6ffc0069,0x50a8fa17,0x8afef2ab,0x2246921e},
	{0x1beb9180,0xf91e0000,0x15170000,0x73780000,0x3b91005a,0x8bf83901,0x68c3ea27,0x5f3f928a,0x98b7fd80,0xf6350000,0x48c40000,0x5dd60000,0x4ccc02d1,0xb80276ff,0xbae65143,0xb90063ae},
	{0xe7e59440,0xb8800000,0xdab20000,0xad790000,0x18a102e2,0x6352b5e9,0x58db49cf,0xc479633a,0xbcdafcc0,0x74400000,0xc2150000,0x172b0000,0x344a00c5,0xf14c14b6,0x03c11f39,0xbcf6f227},
	{0xcf9d9900,0xea270000,0x009f0000,0xcc630000,0x090f0331,0xf3f27379,0xb0f2efcc,0xe035c06c,0x790cf9c0,0xa17c0000,0xff000000,0x1df00000,0x660601db,0x6ff55d28,0x3993a01d,0x3014e497},
	{0x33939cc0,0xabb90000,0xcf3a0000,0x12620000,0x2a3f0189,0x1b58ff91,0x80ea4c24,0x7b7331dc,0x5d61f880,0x23090000,0x75d10000,0x570d0000,0x1e8003cf,0x26bb3f61,0x80b4ee67,0x35e2751e},
	{0xebf09840,0x68520000,0x8a4e0000,0x869e0000,0x71890125,0xbabc1130,0x09d5a1b6,0xe5c351e5,0xa16ffd40,0x62970000,0xba740000,0x890c0000,0x3db00177,0xce11b389,0xb0ac4d8f,0xaea484ae},
	{0x17fe9d80,0x29cc0000,0x45eb0000,0x589f0000,0x52b9039d,0x52169dd8,0x39cd025e,0x7e85a055,0x8502fc00,0xe0e20000,0x30a50000,0xc3f10000,0x45360363,0x875fd1c0,0x098b03f5,0xab521527},
	{0xa2a1e000,0xb3330000,0x0e870000,0xbca30000,0xacc3006b,0x854a5b30,0x03783c0a,0xf63cb9dd,0x2e16c000,0x775d0000,0x905d0000,0x64160000,0xd75b0095,0xd5e1d889,0x642bb1ab,0x90e4cd1c},
	{0x5eafe5c0,0xf2ad0000,0xc1220000,0x62a20000,0x8ff302d3,0x6de0d7d8,0x33609fe2,0x6d7a486d,0x0a7bc140,0xf5280000,0x1a8c0000,0x2eeb0000,0xafdd0281,0x9cafbac0,0xdd0cffd1,0x95125c95},
	{0x86cce140,0x31460000,0x84560000,0xf65e0000,0xd445027f,0xcc043979,0xba5f7270,0xf3ca2854,0xf675c480,0xb4b60000,0xd5290000,0xf0ea0000,0x8ced0039,0x74053628,0xed145c39,0x0e54ad25},
	{0x7ac2e480,0x70d80000,0x4bf30000,0x285f0000,0xf77500c7,0x24aeb591,0x8a47d198,0x688cd9e4,0xd218c5c0,0x36c30000,0x5ff80000,0xba170000,0xf46b022d,0x3d4b5461,0x54331243,0x0ba23cac},
	{0x52bae9c0,0x227f0000,0x91de0000,0x49450000,0xe6db0114,0xb40e7301,0x626e779b,0x4cc07ab2,0x17cec0c0,0xe3ff0000,0x62ed0000,0xb0cc0000,0xa6270333,0xa3f21dff,0x6e61ad67,0x87402a1c},
	{0xaeb4ec00,0x63e10000,0x5e7b0000,0x97440000,0xc5eb03ac,0x5ca4ffe9,0x5276d473,0xd7868b02,0x33a3c180,0x618a0000,0xe83c0000,0xfa310000,0xdea10127,0xeabc7fb6,0xd746e31d,0x82b6bb95},
	{0x76d7e880,0xa00a0000,0x1b0f0000,0x03b80000,0x9e5d0300,0xfd401148,0xdb4939e1,0x4936eb3b,0xcfadc440,0x20140000,0x27990000,0x24300000,0xfd91039f,0x0216f35e,0xe75e40f5,0x19f04a25},
	{0x8ad9ed40,0xe1940000,0xd4aa0000,0xddb90000,0xbd6d01b8,0x15ea9da0,0xeb519a09,0xd2701a8b,0xebc0c500,0xa2610000,0xad480000,0x6ecd0000,0x8517018b,0x4b589117,0x5e790e8f,0x1c06dbac},
	{0x9b79e0c0,0x27910000,0xfc370000,0x68790000,0xddbf03cd,0xf3599e46,0x093220c6,0xe1985edd,0xe7d5c900,0x72b30000,0xfdb40000,0x452a0000,0xec3f024c,0x92b635ce,0x0f77e6f6,0x3dbce973},
	{0x6777e500,0x660f0000,0x33920000,0xb6780000,0xfe8f0175,0x1bf312ae,0x392a832e,0x7adeaf6d,0xc3b8c840,0xf0c60000,0x77650000,0x0fd70000,0x94b90058,0xdbf85787,0xb650a88c,0x384a78fa},
	{0xbf14e180,0xa5e40000,0x76e60000,0x22840000,0xa53901d9,0xba17fc0f,0xb0156ebc,0xe46ecf54,0x3fb6cd80,0xb1580000,0xb8c00000,0xd1d60000,0xb78902e0,0x3352db6f,0x86480b64,0xa30c894a},
	{0x431ae440,0xe47a0000,0xb9430000,0xfc850000,0x86090361,0x52bd70e7,0x800dcd54,0x7f283ee4,0x1bdbccc0,0x332d0000,0x32110000,0x9b2b0000,0xcf0f00f4,0x7a1cb926,0x3f6f451e,0xa6fa18c3},
	{0x6b62e900,0xb6dd0000,0x636e0000,0x9d9f0000,0x97a702b2,0xc21db677,0x68246b57,0x5b649db2,0xde0dc9c0,0xe6110000,0x0f040000,0x91f00000,0x9d4301ea,0xe4a5f0b8,0x053dfa3a,0x2a180e73},
	{0x976cecc0,0xf7430000,0xaccb0000,0x439e0000,0xb497000a,0x2ab73a9f,0x583cc8bf,0xc0226c02,0xfa60c880,0x64640000,0x85d50000,0xdb0d0000,0xe5c503fe,0xadeb92f1,0xbc1ab440,0x2fee9ffa},
	{0x4f0fe840,0x34a80000,0xe9bf0000,0xd7620000,0xef2100a6,0x8b53d43e,0xd103252d,0x5e920c3b,0x066ecd40,0x25fa0000,0x4a700000,0x050c0000,0xc6f50146,0x45411e19,0x8c0217a8,0xb4a86e4a},
	{0xb301ed80,0x75360000,0x261a0000,0x09630000,0xcc11021e,0x63f958d6,0xe11b86c5,0xc5d4fd8b,0x2203cc00,0xa78f0000,0xc0a10000,0x4ff10000,0xbe730352,0x0c0f7c50,0x352559d2,0xb15effc3}
    },{
	{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x5e2b000f,0x3afc0000,0xf2b50000,0xd2920000,0x12920305,0x1b36c028,0xccac9ccc,0x39093051,0x4a510006,0xd79b0000,0x92110000,0x689c0000,0xa517006e,0x2629bf53,0xe2850762,0xb9f076db},
	{0x4a510006,0xd79b0000,0x92110000,0x689c0000,0xa517006e,0x2629bf53,0xe2850762,0xb9f076db,0x147a0009,0xed670000,0x60a40000,0xba0e0000,0xb785036b,0x3d1f7f7b,0x2e299bae,0x80f9468a},
	{0x147a0009,0xed670000,0x60a40000,0xba0e0000,0xb785036b,0x3d1f7f7b,0x2e299bae,0x80f9468a,0x5e2b000f,0x3afc0000,0xf2b50000,0xd2920000,0x12920305,0x1b36c028,0xccac9ccc,0x39093051},
	{0xb5510017,0xeb890000,0xc1790000,0xdd030000,0xa5240187,0x1673b952,0xe85cb7a8,0x602b47ae,0x94840005,0xa30f0000,0xe7a00000,0xd1fe0000,0xd86703cd,0x4bc17686,0x85eb1285,0x6fe1cd24},
	{0xeb7a0018,0xd1750000,0x33cc0000,0x0f910000,0xb7b60282,0x0d45797a,0x24f02b64,0x592277ff,0xded50003,0x74940000,0x75b10000,0xb9620000,0x7d7003a3,0x6de8c9d5,0x676e15e7,0xd611bbff},
	{0xff000011,0x3c120000,0x53680000,0xb59f0000,0x003301e9,0x305a0601,0x0ad9b0ca,0xd9db3175,0x80fe000c,0x4e680000,0x87040000,0x6bf00000,0x6fe200a6,0x76de09fd,0xabc2892b,0xef188bae},
	{0xa12b001e,0x06ee0000,0xa1dd0000,0x670d0000,0x12a102ec,0x2b6cc629,0xc6752c06,0xe0d20124,0xcaaf000a,0x99f30000,0x15150000,0x036c0000,0xcaf500c8,0x50f7b6ae,0x49478e49,0x56e8fd75},
	{0x94840005,0xa30f0000,0xe7a00000,0xd1fe0000,0xd86703cd,0x4bc17686,0x85eb1285,0x6fe1cd24,0x21d50012,0x48860000,0x26d90000,0x0cfd0000,0x7d43024a,0x5db2cfd4,0x6db7a52d,0x0fca8a8a},
	{0xcaaf000a,0x99f30000,0x15150000,0x036c0000,0xcaf500c8,0x50f7b6ae,0x49478e49,0x56e8fd75,0x6b840014,0x9f1d0000,0xb4c80000,0x64610000,0xd8540224,0x7b9b7087,0x8f32a24f,0xb63afc51},
	{0xded50003,0x74940000,0x75b10000,0xb9620000,0x7d7003a3,0x6de8c9d5,0x676e15e7,0xd611bbff,0x35af001b,0xa5e10000,0x467d0000,0xb6f30000,0xcac60121,0x60adb0af,0x439e3e83,0x8f33cc00},
	{0x80fe000c,0x4e680000,0x87040000,0x6bf00000,0x6fe200a6,0x76de09fd,0xabc2892b,0xef188bae,0x7ffe001d,0x727a0000,0xd46c0000,0xde6f0000,0x6fd1014f,0x46840ffc,0xa11b39e1,0x36c3badb},
	{0x21d50012,0x48860000,0x26d90000,0x0cfd0000,0x7d43024a,0x5db2cfd4,0x6db7a52d,0x0fca8a8a,0xb5510017,0xeb890000,0xc1790000,0xdd030000,0xa5240187,0x1673b952,0xe85cb7a8,0x602b47ae},
	{0x7ffe001d,0x727a0000,0xd46c0000,0xde6f0000,0x6fd1014f,0x46840ffc,0xa11b39e1,0x36c3badb,0xff000011,0x3c120000,0x53680000,0xb59f0000,0x003301e9,0x305a0601,0x0ad9b0ca,0xd9db3175},
	{0x6b840014,0x9f1d0000,0xb4c80000,0x64610000,0xd8540224,0x7b9b7087,0x8f32a24f,0xb63afc51,0xa12b001e,0x06ee0000,0xa1dd0000,0x670d0000,0x12a102ec,0x2b6cc629,0xc6752c06,0xe0d20124},
	{0x35af001b,0xa5e10000,0x467d0000,0xb6f30000,0xcac60121,0x60adb0af,0x439e3e83,0x8f33cc00,0xeb7a0018,0xd1750000,0x33cc0000,0x0f910000,0xb7b60282,0x0d45797a,0x24f02b64,0x592277ff},
	{0x1b630027,0x5b520000,0x85ef0000,0xf3e70000,0x56000093,0x0c653361,0xe87b7d68,0xce576cc3,0x580d0003,0x4a170000,0x2b5f0000,0xe2da0000,0xb0ff0308,0x90919d0f,0x7ad6a53a,0x4dba9dd7},
	{0x45480028,0x61ae0000,0x775a0000,0x21750000,0x44920396,0x1753f349,0x24d7e1a4,0xf75e5c92,0x125c0005,0x9d8c0000,0xb94e0000,0x8a460000,0x15e80366,0xb6b8225c,0x9853a258,0xf44aeb0c},
	{0x51320021,0x8cc90000,0x17fe0000,0x9b7b0000,0xf31700fd,0x2a4c8c32,0x0afe7a0a,0x77a71a18,0x4c77000a,0xa7700000,0x4bfb0000,0x58d40000,0x077a0063,0xad8ee274,0x54ff3e94,0xcd43db5d},
	{0x0f19002e,0xb6350000,0xe54b0000,0x49e90000,0xe18503f8,0x317a4c1a,0xc652e6c6,0x4eae2a49,0x0626000c,0x70eb0000,0xd9ea0000,0x30480000,0xa26d000d,0x8ba75d27,0xb67a39f6,0x74b3ad86},
	{0xae320030,0xb0db0000,0x44960000,0x2ee40000,0xf3240114,0x1a168a33,0x0027cac0,0xae7c2b6d,0xcc890006,0xe9180000,0xccff0000,0x33240000,0x689800c5,0xdb50eb89,0xff3db7bf,0x225b50f3},
	{0xf019003f,0x8a270000,0xb6230000,0xfc760000,0xe1b60211,0x01204a1b,0xcc8b560c,0x97751b3c,0x86d80000,0x3e830000,0x5eee0000,0x5bb80000,0xcd8f00ab,0xfd7954da,0x1db8b0dd,0x9bab2628},
	{0xe4630036,0x67400000,0xd6870000,0x46780000,0x5633017a,0x3c3f3560,0xe2a2cda2,0x178c5db6,0xd8f3000f,0x047f0000,0xac5b0000,0x892a0000,0xdf1d03ae,0xe64f94f2,0xd1142c11,0xa2a21679},
	{0xba480039,0x5dbc0000,0x24320000,0x94ea0000,0x44a1027f,0x2709f548,0x2e0e516e,0x2e856de7,0x92a20009,0xd3e40000,0x3e4a0000,0xe1b60000,0x7a0a03c0,0xc0662ba1,0x33912b73,0x1b5260a2},
	{0x8fe70022,0xf85d0000,0x624f0000,0x22190000,0x8e67035e,0x47a445e7,0x6d906fed,0xa1b6a1e7,0x79d80011,0x02910000,0x0d860000,0xee270000,0xcdbc0142,0xcd2352db,0x17610017,0x4270175d},
	{0xd1cc002d,0xc2a10000,0x90fa0000,0xf08b0000,0x9cf5005b,0x5c9285cf,0xa13cf321,0x98bf91b6,0x33890017,0xd50a0000,0x9f970000,0x86bb0000,0x68ab012c,0xeb0aed88,0xf5e40775,0xfb806186},
	{0xc5b60024,0x2fc60000,0xf05e0000,0x4a850000,0x2b700330,0x618dfab4,0x8f15688f,0x1846d73c,0x6da20018,0xeff60000,0x6d220000,0x54290000,0x7a390229,0xf03c2da0,0x39489bb9,0xc28951d7},
	{0x9b9d002b,0x153a0000,0x02eb0000,0x98170000,0x39e20035,0x7abb3a9c,0x43b9f443,0x214fe76d,0x27f3001e,0x386d0000,0xff330000,0x3cb50000,0xdf2e0247,0xd61592f3,0xdbcd9cdb,0x7b79270c},
	{0x3ab60035,0x13d40000,0xa3360000,0xff1a0000,0x2b4302d9,0x51d7fcb5,0x85ccd845,0xc19de649,0xed5c0014,0xa19e0000,0xea260000,0x3fd90000,0x15db028f,0x86e2245d,0x928a1292,0x2d91da79},
	{0x649d003a,0x29280000,0x51830000,0x2d880000,0x39d101dc,0x4ae13c9d,0x49604489,0xf894d618,0xa70d0012,0x76050000,0x78370000,0x57450000,0xb0cc02e1,0xa0cb9b0e,0x700f15f0,0x9461aca2},
	{0x70e70033,0xc44f0000,0x31270000,0x97860000,0x8e5402b7,0x77fe43e6,0x6749df27,0x786d9092,0xf926001d,0x4cf90000,0x8a820000,0x85d70000,0xa25e01e4,0xbbfd5b26,0xbca3893c,0xad689cf3},
	{0x2ecc003c,0xfeb30000,0xc3920000,0x45140000,0x9cc601b2,0x6cc883ce,0xabe543eb,0x4164a0c3,0xb377001b,0x9b620000,0x18930000,0xed4b0000,0x0749018a,0x9dd4e475,0x5e268e5e,0x1498ea28},
	{0x580d0003,0x4a170000,0x2b5f0000,0xe2da0000,0xb0ff0308,0x90919d0f,0x7ad6a53a,0x4dba9dd7,0x436e0024,0x11450000,0xaeb00000,0x113d0000,0xe6ff039b,0x9cf4ae6e,0x92add852,0x83edf114},
	{0x0626000c,0x70eb0000,0xd9ea0000,0x30480000,0xa26d000d,0x8ba75d27,0xb67a39f6,0x74b3ad86,0x093f0022,0xc6de0000,0x3ca10000,0x79a10000,0x43e803f5,0xbadd113d,0x7028df30,0x3a1d87cf},
	{0x125c0005,0x9d8c0000,0xb94e0000,0x8a460000,0x15e80366,0xb6b8225c,0x9853a258,0xf44aeb0c,0x5714002d,0xfc220000,0xce140000,0xab330000,0x517a00f0,0xa1ebd115,0xbc8443fc,0x0314b79e},
	{0x4c77000a,0xa7700000,0x4bfb0000,0x58d40000,0x077a0063,0xad8ee274,0x54ff3e94,0xcd43db5d,0x1d45002b,0x2bb90000,0x5c050000,0xc3af0000,0xf46d009e,0x87c26e46,0x5e01449e,0xbae4c145},
	{0xed5c0014,0xa19e0000,0xea260000,0x3fd90000,0x15db028f,0x86e2245d,0x928a1292,0x2d91da79,0xd7ea0021,0xb24a0000,0x49100000,0xc0c30000,0x3e980056,0xd735d8e8,0x1746cad7,0xec0c3c30},
	{0xb377001b,0x9b620000,0x18930000,0xed4b0000,0x0749018a,0x9dd4e475,0x5e268e5e,0x1498ea28,0x9dbb0027,0x65d10000,0xdb010000,0xa85f0000,0x9b8f0038,0xf11c67bb,0xf5c3cdb5,0x55fc4aeb},
	{0xa70d0012,0x76050000,0x78370000,0x57450000,0xb0cc02e1,0xa0cb9b0e,0x700f15f0,0x9461aca2,0xc3900028,0x5f2d0000,0x29b40000,0x7acd0000,0x891d033d,0xea2aa793,0x396f5179,0x6cf57aba},
	{0xf926001d,0x4cf90000,0x8a820000,0x85d70000,0xa25e01e4,0xbbfd5b26,0xbca3893c,0xad689cf3,0x89c1002e,0x88b60000,0xbba50000,0x12510000,0x2c0a0353,0xcc0318c0,0xdbea561b,0xd5050c61},
	{0xcc890006,0xe9180000,0xccff0000,0x33240000,0x689800c5,0xdb50eb89,0xff3db7bf,0x225b50f3,0x62bb0036,0x59c30000,0x88690000,0x1dc00000,0x9bbc01d1,0xc14661ba,0xff1a7d7f,0x8c277b9e},
	{0x92a20009,0xd3e40000,0x3e4a0000,0xe1b60000,0x7a0a03c0,0xc0662ba1,0x33912b73,0x1b5260a2,0x28ea0030,0x8e580000,0x1a780000,0x755c0000,0x3eab01bf,0xe76fdee9,0x1d9f7a1d,0x35d70d45},
	{0x86d80000,0x3e830000,0x5eee0000,0x5bb80000,0xcd8f00ab,0xfd7954da,0x1db8b0dd,0x9bab2628,0x76c1003f,0xb4a40000,0xe8cd0000,0xa7ce0000,0x2c3902ba,0xfc591ec1,0xd133e6d1,0x0cde3d14},
	{0xd8f3000f,0x047f0000,0xac5b0000,0x892a0000,0xdf1d03ae,0xe64f94f2,0xd1142c11,0xa2a21679,0x3c900039,0x633f0000,0x7adc0000,0xcf520000,0x892e02d4,0xda70a192,0x33b6e1b3,0xb52e4bcf},
	{0x79d80011,0x02910000,0x0d860000,0xee270000,0xcdbc0142,0xcd2352db,0x17610017,0x4270175d,0xf63f0033,0xfacc0000,0x6fc90000,0xcc3e0000,0x43db021c,0x8a87173c,0x7af16ffa,0xe3c6b6ba},
	{0x27f3001e,0x386d0000,0xff330000,0x3cb50000,0xdf2e0247,0xd61592f3,0xdbcd9cdb,0x7b79270c,0xbc6e0035,0x2d570000,0xfdd80000,0xa4a20000,0xe6cc0272,0xacaea86f,0x98746898,0x5a36c061},
	{0x33890017,0xd50a0000,0x9f970000,0x86bb0000,0x68ab012c,0xeb0aed88,0xf5e40775,0xfb806186,0xe245003a,0x17ab0000,0x0f6d0000,0x76300000,0xf45e0177,0xb7986847,0x54d8f454,0x633ff030},
	{0x6da20018,0xeff60000,0x6d220000,0x54290000,0x7a390229,0xf03c2da0,0x39489bb9,0xc28951d7,0xa814003c,0xc0300000,0x9d7c0000,0x1eac0000,0x51490119,0x91b1d714,0xb65df336,0xdacf86eb},
	{0x436e0024,0x11450000,0xaeb00000,0x113d0000,0xe6ff039b,0x9cf4ae6e,0x92add852,0x83edf114,0x1b630027,0x5b520000,0x85ef0000,0xf3e70000,0x56000093,0x0c653361,0xe87b7d68,0xce576cc3},
	{0x1d45002b,0x2bb90000,0x5c050000,0xc3af0000,0xf46d009e,0x87c26e46,0x5e01449e,0xbae4c145,0x51320021,0x8cc90000,0x17fe0000,0x9b7b0000,0xf31700fd,0x2a4c8c32,0x0afe7a0a,0x77a71a18},
	{0x093f0022,0xc6de0000,0x3ca10000,0x79a10000,0x43e803f5,0xbadd113d,0x7028df30,0x3a1d87cf,0x0f19002e,0xb6350000,0xe54b0000,0x49e90000,0xe18503f8,0x317a4c1a,0xc652e6c6,0x4eae2a49},
	{0x5714002d,0xfc220000,0xce140000,0xab330000,0x517a00f0,0xa1ebd115,0xbc8443fc,0x0314b79e,0x45480028,0x61ae0000,0x775a0000,0x21750000,0x44920396,0x1753f349,0x24d7e1a4,0xf75e5c92},
	{0xf63f0033,0xfacc0000,0x6fc90000,0xcc3e0000,0x43db021c,0x8a87173c,0x7af16ffa,0xe3c6b6ba,0x8fe70022,0xf85d0000,0x624f0000,0x22190000,0x8e67035e,0x47a445e7,0x6d906fed,0xa1b6a1e7},
	{0xa814003c,0xc0300000,0x9d7c0000,0x1eac0000,0x51490119,0x91b1d714,0xb65df336,0xdacf86eb,0xc5b60024,0x2fc60000,0xf05e0000,0x4a850000,0x2b700330,0x618dfab4,0x8f15688f,0x1846d73c},
	{0xbc6e0035,0x2d570000,0xfdd80000,0xa4a20000,0xe6cc0272,0xacaea86f,0x98746898,0x5a36c061,0x9b9d002b,0x153a0000,0x02eb0000,0x98170000,0x39e20035,0x7abb3a9c,0x43b9f443,0x214fe76d},
	{0xe245003a,0x17ab0000,0x0f6d0000,0x76300000,0xf45e0177,0xb7986847,0x54d8f454,0x633ff030,0xd1cc002d,0xc2a10000,0x90fa0000,0xf08b0000,0x9cf5005b,0x5c9285cf,0xa13cf321,0x98bf91b6},
	{0xd7ea0021,0xb24a0000,0x49100000,0xc0c30000,0x3e980056,0xd735d8e8,0x1746cad7,0xec0c3c30,0x3ab60035,0x13d40000,0xa3360000,0xff1a0000,0x2b4302d9,0x51d7fcb5,0x85ccd845,0xc19de649},
	{0x89c1002e,0x88b60000,0xbba50000,0x12510000,0x2c0a0353,0xcc0318c0,0xdbea561b,0xd5050c61,0x70e70033,0xc44f0000,0x31270000,0x97860000,0x8e5402b7,0x77fe43e6,0x6749df27,0x786d9092},
	{0x9dbb0027,0x65d10000,0xdb010000,0xa85f0000,0x9b8f0038,0xf11c67bb,0xf5c3cdb5,0x55fc4aeb,0x2ecc003c,0xfeb30000,0xc3920000,0x45140000,0x9cc601b2,0x6cc883ce,0xabe543eb,0x4164a0c3},
	{0xc3900028,0x5f2d0000,0x29b40000,0x7acd0000,0x891d033d,0xea2aa793,0x396f5179,0x6cf57aba,0x649d003a,0x29280000,0x51830000,0x2d880000,0x39d101dc,0x4ae13c9d,0x49604489,0xf894d618},
	{0x62bb0036,0x59c30000,0x88690000,0x1dc00000,0x9bbc01d1,0xc14661ba,0xff1a7d7f,0x8c277b9e,0xae320030,0xb0db0000,0x44960000,0x2ee40000,0xf3240114,0x1a168a33,0x0027cac0,0xae7c2b6d},
	{0x3c900039,0x633f0000,0x7adc0000,0xcf520000,0x892e02d4,0xda70a192,0x33b6e1b3,0xb52e4bcf,0xe4630036,0x67400000,0xd6870000,0x46780000,0x5633017a,0x3c3f3560,0xe2a2cda2,0x178c5db6},
	{0x28ea0030,0x8e580000,0x1a780000,0x755c0000,0x3eab01bf,0xe76fdee9,0x1d9f7a1d,0x35d70d45,0xba480039,0x5dbc0000,0x24320000,0x94ea0000,0x44a1027f,0x2709f548,0x2e0e516e,0x2e856de7},
	{0x76c1003f,0xb4a40000,0xe8cd0000,0xa7ce0000,0x2c3902ba,0xfc591ec1,0xd133e6d1,0x0cde3d14,0xf019003f,0x8a270000,0xb6230000,0xfc760000,0xe1b60211,0x01204a1b,0xcc8b560c,0x97751b3c},
	{0x468703c0,0x69d70000,0x76130000,0xf3900000,0x97980094,0x15da5e15,0x3c9ddfe8,0x82831b51,0xb6d70180,0x0f3a0000,0x44a10000,0x9d9c0000,0xfd430303,0xb6e135b6,0x64f3e005,0xcadbd944},
	{0x18ac03cf,0x532b0000,0x84a60000,0x21020000,0x850a0391,0x0eec9e3d,0xf0314324,0xbb8a2b00,0xfc860186,0xd8a10000,0xd6b00000,0xf5000000,0x5854036d,0x90c88ae5,0x8676e767,0x732baf9f},
	{0x0cd603c6,0xbe4c0000,0xe4020000,0x9b0c0000,0x328f00fa,0x33f3e146,0xde18d88a,0x3b736d8a,0xa2ad0189,0xe25d0000,0x24050000,0x27920000,0x4ac60068,0x8bfe4acd,0x4ada7bab,0x4a229fce},
	{0x52fd03c9,0x84b00000,0x16b70000,0x499e0000,0x201d03ff,0x28c5216e,0x12b44446,0x027a5ddb,0xe8fc018f,0x35c60000,0xb6140000,0x4f0e0000,0xefd10006,0xadd7f59e,0xa85f7cc9,0xf3d2e915},
	{0xf3d603d7,0x825e0000,0xb76a0000,0x2e930000,0x32bc0113,0x03a9e747,0xd4c16840,0xe2a85cff,0x22530185,0xac350000,0xa3010000,0x4c620000,0x252400ce,0xfd204330,0xe118f280,0xa53a1460},
	{0xadfd03d8,0xb8a20000,0x45df0000,0xfc010000,0x202e0216,0x189f276f,0x186df48c,0xdba16cae,0x68020183,0x7bae0000,0x31100000,0x24fe0000,0x803300a0,0xdb09fc63,0x039df5e2,0x1cca62bb},
	{0xb98703d1,0x55c50000,0x257b0000,0x460f0000,0x97ab017d,0x25805814,0x36446f22,0x5b582a24,0x3629018c,0x41520000,0xc3a50000,0xf66c0000,0x92a103a5,0xc03f3c4b,0xcf31692e,0x25c352ea},
	{0xe7ac03de,0x6f390000,0xd7ce0000,0x949d0000,0x85390278,0x3eb6983c,0xfae8f3ee,0x62511a75,0x7c78018a,0x96c90000,0x51b40000,0x9ef00000,0x37b603cb,0xe6168318,0x2db46e4c,0x9c332431},
	{0xd20303c5,0xcad80000,0x91b30000,0x226e0000,0x4fff0359,0x5e1b2893,0xb976cd6d,0xed62d675,0x97020192,0x47bc0000,0x62780000,0x91610000,0x80000149,0xeb53fa62,0x09444528,0xc51153ce},
	{0x8c2803ca,0xf0240000,0x63060000,0xf0fc0000,0x5d6d005c,0x452de8bb,0x75da51a1,0xd46be624,0xdd530194,0x90270000,0xf0690000,0xf9fd0000,0x25170127,0xcd7a4531,0xebc1424a,0x7ce12515},
	{0x985203c3,0x1d430000,0x03a20000,0x4af20000,0xeae80337,0x783297c0,0x5bf3ca0f,0x5492a0ae,0x8378019b,0xaadb0000,0x02dc0000,0x2b6f0000,0x37850222,0xd64c8519,0x276dde86,0x45e81544},
	{0xc67903cc,0x27bf0000,0xf1170000,0x98600000,0xf87a0032,0x630457e8,0x975f56c3,0x6d9b90ff,0xc929019d,0x7d400000,0x90cd0000,0x43f30000,0x9292024c,0xf0653a4a,0xc5e8d9e4,0xfc18639f},
	{0x675203d2,0x21510000,0x50ca0000,0xff6d0000,0xeadb02de,0x486891c1,0x512a7ac5,0x8d4991db,0x03860197,0xe4b30000,0x85d80000,0x409f0000,0x58670284,0xa0928ce4,0x8caf57ad,0xaaf09eea},
	{0x397903dd,0x1bad0000,0xa27f0000,0x2dff0000,0xf84901db,0x535e51e9,0x9d86e609,0xb440a18a,0x49d70191,0x33280000,0x17c90000,0x28030000,0xfd7002ea,0x86bb33b7,0x6e2a50cf,0x1300e831},
	{0x2d0303d4,0xf6ca0000,0xc2db0000,0x97f10000,0x4fcc02b0,0x6e412e92,0xb3af7da7,0x34b9e700,0x17fc019e,0x09d40000,0xe57c0000,0xfa910000,0xefe201ef,0x9d8df39f,0xa286cc03,0x2a09d860},
	{0x732803db,0xcc360000,0x306e0000,0x45630000,0x5d5e01b5,0x7577eeba,0x7f03e16b,0x0db0d751,0x5dad0198,0xde4f0000,0x776d0000,0x920d0000,0x4af50181,0xbba44ccc,0x4003cb61,0x93f9aebb},
	{0x5de403e7,0x32850000,0xf3fc0000,0x00770000,0xc1980007,0x19bf6d74,0xd4e6a280,0x4cd47792,0xeeda0183,0x452d0000,0x6ffe0000,0x7f460000,0x4dbc000b,0x2670a8b9,0x1e25453f,0x87614493},
	{0x03cf03e8,0x08790000,0x01490000,0xd2e50000,0xd30a0302,0x0289ad5c,0x184a3e4c,0x75dd47c3,0xa48b0185,0x92b60000,0xfdef0000,0x17da0000,0xe8ab0065,0x005917ea,0xfca0425d,0x3e913248},
	{0x17b503e1,0xe51e0000,0x61ed0000,0x68eb0000,0x648f0069,0x3f96d227,0x3663a5e2,0xf5240149,0xfaa0018a,0xa84a0000,0x0f5a0000,0xc5480000,0xfa390360,0x1b6fd7c2,0x300cde91,0x07980219},
	{0x499e03ee,0xdfe20000,0x93580000,0xba790000,0x761d036c,0x24a0120f,0xfacf392e,0xcc2d3118,0xb0f1018c,0x7fd10000,0x9d4b0000,0xadd40000,0x5f2e030e,0x3d466891,0xd289d9f3,0xbe6874c2},
	{0xe8b503f0,0xd90c0000,0x32850000,0xdd740000,0x64bc0180,0x0fccd426,0x3cba1528,0x2cff303c,0x7a5e0186,0xe6220000,0x885e0000,0xaeb80000,0x95db03c6,0x6db1de3f,0x9bce57ba,0xe88089b7},
	{0xb69e03ff,0xe3f00000,0xc0300000,0x0fe60000,0x762e0285,0x14fa140e,0xf01689e4,0x15f6006d,0x300f0180,0x31b90000,0x1a4f0000,0xc6240000,0x30cc03a8,0x4b98616c,0x794b50d8,0x5170ff6c},
	{0xa2e403f6,0x0e970000,0xa0940000,0xb5e80000,0xc1ab01ee,0x29e56b75,0xde3f124a,0x950f46e7,0x6e24018f,0x0b450000,0xe8fa0000,0x14b60000,0x225e00ad,0x50aea144,0xb5e7cc14,0x6879cf3d},
	{0xfccf03f9,0x346b0000,0x52210000,0x677a0000,0xd33902eb,0x32d3ab5d,0x12938e86,0xac0676b6,0x24750189,0xdcde0000,0x7aeb0000,0x7c2a0000,0x874900c3,0x76871e17,0x5762cb76,0xd189b9e6},
	{0xc96003e2,0x918a0000,0x145c0000,0xd1890000,0x19ff03ca,0x527e1bf2,0x510db005,0x2335bab6,0xcf0f0191,0x0dab0000,0x49270000,0x73bb0000,0x30ff0241,0x7bc2676d,0x7392e012,0x88abce19},
	{0x974b03ed,0xab760000,0xe6e90000,0x031b0000,0x0b6d00cf,0x4948dbda,0x9da12cc9,0x1a3c8ae7,0x855e0197,0xda300000,0xdb360000,0x1b270000,0x95e8022f,0x5debd83e,0x9117e770,0x315bb8c2},
	{0x833103e4,0x46110000,0x864d0000,0xb9150000,0xbce803a4,0x7457a4a1,0xb388b767,0x9ac5cc6d,0xdb750198,0xe0cc0000,0x29830000,0xc9b50000,0x877a012a,0x46dd1816,0x5dbb7bbc,0x08528893},
	{0xdd1a03eb,0x7ced0000,0x74f80000,0x6b870000,0xae7a00a1,0x6f616489,0x7f242bab,0xa3ccfc3c,0x9124019e,0x37570000,0xbb920000,0xa1290000,0x226d0144,0x60f4a745,0xbf3e7cde,0xb1a2fe48},
	{0x7c3103f5,0x7a030000,0xd5250000,0x0c8a0000,0xbcdb024d,0x440da2a0,0xb95107ad,0x431efd18,0x5b8b0194,0xaea40000,0xae870000,0xa2450000,0xe898018c,0x300311eb,0xf679f297,0xe74a033d},
	{0x221a03fa,0x40ff0000,0x27900000,0xde180000,0xae490148,0x5f3b6288,0x75fd9b61,0x7a17cd49,0x11da0192,0x793f0000,0x3c960000,0xcad90000,0x4d8f01e2,0x162aaeb8,0x14fcf5f5,0x5eba75e6},
	{0x366003f3,0xad980000,0x47340000,0x64160000,0x19cc0223,0x62241df3,0x5bd400cf,0xfaee8bc3,0x4ff1019d,0x43c30000,0xce230000,0x184b0000,0x5f1d02e7,0x0d1c6e90,0xd8506939,0x67b345b7},
	{0x684b03fc,0x97640000,0xb5810000,0xb6840000,0x0b5e0126,0x7912dddb,0x97789c03,0xc3e7bb92,0x05a0019b,0x94580000,0x5c320000,0x70d70000,0xfa0a0289,0x2b35d1c3,0x3ad56e5b,0xde43336c},
	{0x1e8a03c3,0x23c00000,0x5d4c0000,0x114a0000,0x2767039c,0x854bc31a,0x464b7ad2,0xcf398686,0xf5b901a4,0x1e7f0000,0xea110000,0x8ca10000,0x1bbc0098,0x2a159bd8,0xf65e3857,0x49362850},
	{0x40a103cc,0x193c0000,0xaff90000,0xc3d80000,0x35f50099,0x9e7d0332,0x8ae7e61e,0xf630b6d7,0xbfe801a2,0xc9e40000,0x78000000,0xe43d0000,0xbeab00f6,0x0c3c248b,0x14db3f35,0xf0c65e8b},
	{0x54db03c5,0xf45b0000,0xcf5d0000,0x79d60000,0x827003f2,0xa3627c49,0xa4ce7db0,0x76c9f05d,0xe1c301ad,0xf3180000,0x8ab50000,0x36af0000,0xac3903f3,0x170ae4a3,0xd877a3f9,0xc9cf6eda},
	{0x0af003ca,0xcea70000,0x3de80000,0xab440000,0x90e200f7,0xb854bc61,0x6862e17c,0x4fc0c00c,0xab9201ab,0x24830000,0x18a40000,0x5e330000,0x092e039d,0x31235bf0,0x3af2a49b,0x703f1801},
	{0xabdb03d4,0xc8490000,0x9c350000,0xcc490000,0x8243021b,0x93387a48,0xae17cd7a,0xaf12c128,0x613d01a1,0xbd700000,0x0db10000,0x5d5f0000,0xc3db0355,0x61d4ed5e,0x73b52ad2,0x26d7e574},
	{0xf5f003db,0xf2b50000,0x6e800000,0x1edb0000,0x90d1011e,0x880eba60,0x62bb51b6,0x961bf179,0x2b6c01a7,0x6aeb0000,0x9fa00000,0x35c30000,0x66cc033b,0x47fd520d,0x91302db0,0x9f2793af},
	{0xe18a03d2,0x1fd20000,0x0e240000,0xa4d50000,0x27540275,0xb511c51b,0x4c92ca18,0x16e2b7f3,0x754701a8,0x50170000,0x6d150000,0xe7510000,0x745e003e,0x5ccb9225,0x5d9cb17c,0xa62ea3fe},
	{0xbfa103dd,0x252e0000,0xfc910000,0x76470000,0x35c60170,0xae270533,0x803e56d4,0x2feb87a2,0x3f1601ae,0x878c0000,0xff040000,0x8fcd0000,0xd1490050,0x7ae22d76,0xbf19b61e,0x1fded525},
	{0x8a0e03c6,0x80cf0000,0xbaec0000,0xc0b40000,0xff000051,0xce8ab59c,0xc3a06857,0xa0d84ba2,0xd46c01b6,0x56f90000,0xccc80000,0x805c0000,0x66ff02d2,0x77a7540c,0x9be99d7a,0x46fca2da},
	{0xd42503c9,0xba330000,0x48590000,0x12260000,0xed920354,0xd5bc75b4,0x0f0cf49b,0x99d17bf3,0x9e3d01b0,0x81620000,0x5ed90000,0xe8c00000,0xc3e802bc,0x518eeb5f,0x796c9a18,0xff0cd401},
	{0xc05f03c0,0x57540000,0x28fd0000,0xa8280000,0x5a17003f,0xe8a30acf,0x21256f35,0x19283d79,0xc01601bf,0xbb9e0000,0xac6c0000,0x3a520000,0xd17a01b9,0x4ab82b77,0xb5c006d4,0xc605e450},
	{0x9e7403cf,0x6da80000,0xda480000,0x7aba0000,0x4885033a,0xf395cae7,0xed89f3f9,0x20210d28,0x8a4701b9,0x6c050000,0x3e7d0000,0x52ce0000,0x746d01d7,0x6c919424,0x574501b6,0x7ff5928b},
	{0x3f5f03d1,0x6b460000,0x7b950000,0x1db70000,0x5a2401d6,0xd8f90cce,0x2bfcdfff,0xc0f30c0c,0x40e801b3,0xf5f60000,0x2b680000,0x51a20000,0xbe98011f,0x3c66228a,0x1e028fff,0x291d6ffe},
	{0x617403de,0x51ba0000,0x89200000,0xcf250000,0x48b602d3,0xc3cfcce6,0xe7504333,0xf9fa3c5d,0x0ab901b5,0x226d0000,0xb9790000,0x393e0000,0x1b8f0171,0x1a4f9dd9,0xfc87889d,0x90ed1925},
	{0x750e03d7,0xbcdd0000,0xe9840000,0x752b0000,0xff3301b8,0xfed0b39d,0xc979d89d,0x79037ad7,0x549201ba,0x18910000,0x4bcc0000,0xebac0000,0x091d0274,0x01795df1,0x302b1451,0xa9e42974},
	{0x2b2503d8,0x86210000,0x1b310000,0xa7b90000,0xeda102bd,0xe5e673b5,0x05d54451,0x400a4a86,0x1ec301bc,0xcf0a0000,0xd9dd0000,0x83300000,0xac0a021a,0x2750e2a2,0xd2ae1333,0x10145faf},
	{0x05e903e4,0x78920000,0xd8a30000,0xe2ad0000,0x7167030f,0x892ef07b,0xae3007ba,0x016eea45,0xadb401a7,0x54680000,0xc14e0000,0x6e7b0000,0xab430390,0xba8406d7,0x8c889d6d,0x048cb587},
	{0x5bc203eb,0x426e0000,0x2a160000,0x303f0000,0x63f5000a,0x92183053,0x629c9b76,0x3867da14,0xe7e501a1,0x83f30000,0x535f0000,0x06e70000,0x0e5403fe,0x9cadb984,0x6e0d9a0f,0xbd7cc35c},
	{0x4fb803e2,0xaf090000,0x4ab20000,0x8a310000,0xd4700361,0xaf074f28,0x4cb500d8,0xb89e9c9e,0xb9ce01ae,0xb90f0000,0xa1ea0000,0xd4750000,0x1cc600fb,0x879b79ac,0xa2a106c3,0x8475f30d},
	{0x119303ed,0x95f50000,0xb8070000,0x58a30000,0xc6e20064,0xb4318f00,0x80199c14,0x8197accf,0xf39f01a8,0x6e940000,0x33fb0000,0xbce90000,0xb9d10095,0xa1b2c6ff,0x402401a1,0x3d8585d6},
	{0xb0b803f3,0x931b0000,0x19da0000,0x3fae0000,0xd4430288,0x9f5d4929,0x466cb012,0x6145adeb,0x393001a2,0xf7670000,0x26ee0000,0xbf850000,0x7324005d,0xf1457051,0x09638fe8,0x6b6d78a3},
	{0xee9303fc,0xa9e70000,0xeb6f0000,0xed3c0000,0xc6d1018d,0x846b8901,0x8ac02cde,0x584c9dba,0x736101a4,0x20fc0000,0xb4ff0000,0xd7190000,0xd6330033,0xd76ccf02,0xebe6888a,0xd29d0e78},
	{0xfae903f5,0x44800000,0x8bcb0000,0x57320000,0x715402e6,0xb974f67a,0xa4e9b770,0xd8b5db30,0x2d4a01ab,0x1a000000,0x464a0000,0x058b0000,0xc4a10336,0xcc5a0f2a,0x274a1446,0xeb943e29},
	{0xa4c203fa,0x7e7c0000,0x797e0000,0x85a00000,0x63c601e3,0xa2423652,0x68452bbc,0xe1bceb61,0x671b01ad,0xcd9b0000,0xd45b0000,0x6d170000,0x61b60358,0xea73b079,0xc5cf1324,0x526448f2},
	{0x916d03e1,0xdb9d0000,0x3f030000,0x33530000,0xa90000c2,0xc2ef86fd,0x2bdb153f,0x6e8f2761,0x8c6101b5,0x1cee0000,0xe7970000,0x62860000,0xd60001da,0xe736c903,0xe13f3840,0x0b463f0d},
	{0xcf4603ee,0xe1610000,0xcdb60000,0xe1c10000,0xbb9203c7,0xd9d946d5,0xe77789f3,0x57861730,0xc63001b3,0xcb750000,0x75860000,0x0a1a0000,0x731701b4,0xc11f7650,0x03ba3f22,0xb2b649d6},
	{0xdb3c03e7,0x0c060000,0xad120000,0x5bcf0000,0x0c1700ac,0xe4c639ae,0xc95e125d,0xd77f51ba,0x981b01bc,0xf1890000,0x87330000,0xd8880000,0x618502b1,0xda29b678,0xcf16a3ee,0x8bbf7987},
	{0x851703e8,0x36fa0000,0x5fa70000,0x895d0000,0x1e8503a9,0xfff0f986,0x05f28e91,0xee7661eb,0xd24a01ba,0x26120000,0x15220000,0xb0140000,0xc49202df,0xfc00092b,0x2d93a48c,0x324f0f5c},
	{0x243c03f6,0x30140000,0xfe7a0000,0xee500000,0x0c240145,0xd49c3faf,0xc387a297,0x0ea460cf,0x18e501b0,0xbfe10000,0x00370000,0xb3780000,0x0e670217,0xacf7bf85,0x64d42ac5,0x64a7f229},
	{0x7a1703f9,0x0ae80000,0x0ccf0000,0x3cc20000,0x1eb60240,0xcfaaff87,0x0f2b3e5b,0x37ad509e,0x52b401b6,0x687a0000,0x92260000,0xdbe40000,0xab700279,0x8ade00d6,0x86512da7,0xdd5784f2},
	{0x6e6d03f0,0xe78f0000,0x6c6b0000,0x86cc0000,0xa933012b,0xf2b580fc,0x2102a5f5,0xb7541614,0x0c9f01b9,0x52860000,0x60930000,0x09760000,0xb9e2017c,0x91e8c0fe,0x4afdb16b,0xe45eb4a3},
	{0x304603ff,0xdd730000,0x9ede0000,0x545e0000,0xbba1022e,0xe98340d4,0xedae3939,0x8e5d2645,0x46ce01bf,0x851d0000,0xf2820000,0x61ea0000,0x1cf50112,0xb7c17fad,0xa878b609,0x5daec278},
	{0xb6d70180,0x0f3a0000,0x44a10000,0x9d9c0000,0xfd430303,0xb6e135b6,0x64f3e005,0xcadbd944,0xf0500240,0x66ed0000,0x32b20000,0x6e0c0000,0x6adb0397,0xa33b6ba3,0x586e3fed,0x4858c215},
	{0xe8fc018f,0x35c60000,0xb6140000,0x4f0e0000,0xefd10006,0xadd7f59e,0xa85f7cc9,0xf3d2e915,0xba010246,0xb1760000,0xa0a30000,0x06900000,0xcfcc03f9,0x8512d4f0,0xbaeb388f,0xf1a8b4ce},
	{0xfc860186,0xd8a10000,0xd6b00000,0xf5000000,0x5854036d,0x90c88ae5,0x8676e767,0x732baf9f,0xe42a0249,0x8b8a0000,0x52160000,0xd4020000,0xdd5e00fc,0x9e2414d8,0x7647a443,0xc8a1849f},
	{0xa2ad0189,0xe25d0000,0x24050000,0x27920000,0x4ac60068,0x8bfe4acd,0x4ada7bab,0x4a229fce,0xae7b024f,0x5c110000,0xc0070000,0xbc9e0000,0x78490092,0xb80dab8b,0x94c2a321,0x7151f244},
	{0x03860197,0xe4b30000,0x85d80000,0x409f0000,0x58670284,0xa0928ce4,0x8caf57ad,0xaaf09eea,0x64d40245,0xc5e20000,0xd5120000,0xbff20000,0xb2bc005a,0xe8fa1d25,0xdd852d68,0x27b90f31},
	{0x5dad0198,0xde4f0000,0x776d0000,0x920d0000,0x4af50181,0xbba44ccc,0x4003cb61,0x93f9aebb,0x2e850243,0x12790000,0x47030000,0xd76e0000,0x17ab0034,0xced3a276,0x3f002a0a,0x9e4979ea},
	{0x49d70191,0x33280000,0x17c90000,0x28030000,0xfd7002ea,0x86bb33b7,0x6e2a50cf,0x1300e831,0x70ae024c,0x28850000,0xb5b60000,0x05fc0000,0x05390331,0xd5e5625e,0xf3acb6c6,0xa74049bb},
	{0x17fc019e,0x09d40000,0xe57c0000,0xfa910000,0xefe201ef,0x9d8df39f,0xa286cc03,0x2a09d860,0x3aff024a,0xff1e0000,0x27a70000,0x6d600000,0xa02e035f,0xf3ccdd0d,0x1129b1a4,0x1eb03f60},
	{0x22530185,0xac350000,0xa3010000,0x4c620000,0x252400ce,0xfd204330,0xe118f280,0xa53a1460,0xd1850252,0x2e6b0000,0x146b0000,0x62f10000,0x179801dd,0xfe89a477,0x35d99ac0,0x4792489f},
	{0x7c78018a,0x96c90000,0x51b40000,0x9ef00000,0x37b603cb,0xe6168318,0x2db46e4c,0x9c332431,0x9bd40254,0xf9f00000,0x867a0000,0x0a6d0000,0xb28f01b3,0xd8a01b24,0xd75c9da2,0xfe623e44},
	{0x68020183,0x7bae0000,0x31100000,0x24fe0000,0x803300a0,0xdb09fc63,0x039df5e2,0x1cca62bb,0xc5ff025b,0xc30c0000,0x74cf0000,0xd8ff0000,0xa01d02b6,0xc396db0c,0x1bf0016e,0xc76b0e15},
	{0x3629018c,0x41520000,0xc3a50000,0xf66c0000,0x92a103a5,0xc03f3c4b,0xcf31692e,0x25c352ea,0x8fae025d,0x14970000,0xe6de0000,0xb0630000,0x050a02d8,0xe5bf645f,0xf975060c,0x7e9b78ce},
	{0x97020192,0x47bc0000,0x62780000,0x91610000,0x80000149,0xeb53fa62,0x09444528,0xc51153ce,0x45010257,0x8d640000,0xf3cb0000,0xb30f0000,0xcfff0210,0xb548d2f1,0xb0328845,0x287385bb},
	{0xc929019d,0x7d400000,0x90cd0000,0x43f30000,0x9292024c,0xf0653a4a,0xc5e8d9e4,0xfc18639f,0x0f500251,0x5aff0000,0x61da0000,0xdb930000,0x6ae8027e,0x93616da2,0x52b78f27,0x9183f360},
	{0xdd530194,0x90270000,0xf0690000,0xf9fd0000,0x25170127,0xcd7a4531,0xebc1424a,0x7ce12515,0x517b025e,0x60030000,0x936f0000,0x09010000,0x787a017b,0x8857ad8a,0x9e1b13eb,0xa88ac331},
	{0x8378019b,0xaadb0000,0x02dc0000,0x2b6f0000,0x37850222,0xd64c8519,0x276dde86,0x45e81544,0x1b2a0258,0xb7980000,0x017e0000,0x619d0000,0xdd6d0115,0xae7e12d9,0x7c9e1489,0x117ab5ea},
	{0xadb401a7,0x54680000,0xc14e0000,0x6e7b0000,0xab430390,0xba8406d7,0x8c889d6d,0x048cb587,0xa85d0243,0x2cfa0000,0x19ed0000,0x8cd60000,0xda24009f,0x33aaf6ac,0x22b89ad7,0x05e25fc2},
	{0xf39f01a8,0x6e940000,0x33fb0000,0xbce90000,0xb9d10095,0xa1b2c6ff,0x402401a1,0x3d8585d6,0xe20c0245,0xfb610000,0x8bfc0000,0xe44a0000,0x7f3300f1,0x158349ff,0xc03d9db5,0xbc122919},
	{0xe7e501a1,0x83f30000,0x535f0000,0x06e70000,0x0e5403fe,0x9cadb984,0x6e0d9a0f,0xbd7cc35c,0xbc27024a,0xc19d0000,0x79490000,0x36d80000,0x6da103f4,0x0eb589d7,0x0c910179,0x851b1948},
	{0xb9ce01ae,0xb90f0000,0xa1ea0000,0xd4750000,0x1cc600fb,0x879b79ac,0xa2a106c3,0x8475f30d,0xf676024c,0x16060000,0xeb580000,0x5e440000,0xc8b6039a,0x289c3684,0xee14061b,0x3ceb6f93},
	{0x18e501b0,0xbfe10000,0x00370000,0xb3780000,0x0e670217,0xacf7bf85,0x64d42ac5,0x64a7f229,0x3cd90246,0x8ff50000,0xfe4d0000,0x5d280000,0x02430352,0x786b802a,0xa7538852,0x6a0392e6},
	{0x46ce01bf,0x851d0000,0xf2820000,0x61ea0000,0x1cf50112,0xb7c17fad,0xa878b609,0x5daec278,0x76880240,0x586e0000,0x6c5c0000,0x35b40000,0xa754033c,0x5e423f79,0x45d68f30,0xd3f3e43d},
	{0x52b401b6,0x687a0000,0x92260000,0xdbe40000,0xab700279,0x8ade00d6,0x86512da7,0xdd5784f2,0x28a3024f,0x62920000,0x9ee90000,0xe7260000,0xb5c60039,0x4574ff51,0x897a13fc,0xeafad46c},
	{0x0c9f01b9,0x52860000,0x60930000,0x09760000,0xb9e2017c,0x91e8c0fe,0x4afdb16b,0xe45eb4a3,0x62f20249,0xb5090000,0x0cf80000,0x8fba0000,0x10d10057,0x635d4002,0x6bff149e,0x530aa2b7},
	{0x393001a2,0xf7670000,0x26ee0000,0xbf850000,0x7324005d,0xf1457051,0x09638fe8,0x6b6d78a3,0x89880251,0x647c0000,0x3f340000,0x802b0000,0xa76702d5,0x6e183978,0x4f0f3ffa,0x0a28d548},
	{0x671b01ad,0xcd9b0000,0xd45b0000,0x6d170000,0x61b60358,0xea73b079,0xc5cf1324,0x526448f2,0xc3d90257,0xb3e70000,0xad250000,0xe8b70000,0x027002bb,0x4831862b,0xad8a3898,0xb3d8a393},
	{0x736101a4,0x20fc0000,0xb4ff0000,0xd7190000,0xd6330033,0xd76ccf02,0xebe6888a,0xd29d0e78,0x9df20258,0x891b0000,0x5f900000,0x3a250000,0x10e201be,0x53074603,0x6126a454,0x8ad193c2},
	{0x2d4a01ab,0x1a000000,0x464a0000,0x058b0000,0xc4a10336,0xcc5a0f2a,0x274a1446,0xeb943e29,0xd7a3025e,0x5e800000,0xcd810000,0x52b90000,0xb5f501d0,0x752ef950,0x83a3a336,0x3321e519},
	{0x8c6101b5,0x1cee0000,0xe7970000,0x62860000,0xd60001da,0xe736c903,0xe13f3840,0x0b463f0d,0x1d0c0254,0xc7730000,0xd8940000,0x51d50000,0x7f000118,0x25d94ffe,0xcae42d7f,0x65c9186c},
	{0xd24a01ba,0x26120000,0x15220000,0xb0140000,0xc49202df,0xfc00092b,0x2d93a48c,0x324f0f5c,0x575d0252,0x10e80000,0x4a850000,0x39490000,0xda170176,0x03f0f0ad,0x28612a1d,0xdc396eb7},
	{0xc63001b3,0xcb750000,0x75860000,0x0a1a0000,0x731701b4,0xc11f7650,0x03ba3f22,0xb2b649d6,0x0976025d,0x2a140000,0xb8300000,0xebdb0000,0xc8850273,0x18c63085,0xe4cdb6d1,0xe5305ee6},
	{0x981b01bc,0xf1890000,0x87330000,0xd8880000,0x618502b1,0xda29b678,0xcf16a3ee,0x8bbf7987,0x4327025b,0xfd8f0000,0x2a210000,0x83470000,0x6d92021d,0x3eef8fd6,0x0648b1b3,0x5cc0283d},
	{0xeeda0183,0x452d0000,0x6ffe0000,0x7f460000,0x4dbc000b,0x2670a8b9,0x1e25453f,0x87614493,0xb33e0264,0x77a80000,0x9c020000,0x7f310000,0x8c24000c,0x3fcfc5cd,0xcac3e7bf,0xcbb53301},
	{0xb0f1018c,0x7fd10000,0x9d4b0000,0xadd40000,0x5f2e030e,0x3d466891,0xd289d9f3,0xbe6874c2,0xf96f0262,0xa0330000,0x0e130000,0x17ad0000,0x29330062,0x19e67a9e,0x2846e0dd,0x724545da},
	{0xa48b0185,0x92b60000,0xfdef0000,0x17da0000,0xe8ab0065,0x005917ea,0xfca0425d,0x3e913248,0xa744026d,0x9acf0000,0xfca60000,0xc53f0000,0x3ba10367,0x02d0bab6,0xe4ea7c11,0x4b4c758b},
	{0xfaa0018a,0xa84a0000,0x0f5a0000,0xc5480000,0xfa390360,0x1b6fd7c2,0x300cde91,0x07980219,0xed15026b,0x4d540000,0x6eb70000,0xada30000,0x9eb60309,0x24f905e5,0x066f7b73,0xf2bc0350},
	{0x5b8b0194,0xaea40000,0xae870000,0xa2450000,0xe898018c,0x300311eb,0xf679f297,0xe74a033d,0x27ba0261,0xd4a70000,0x7ba20000,0xaecf0000,0x544303c1,0x740eb34b,0x4f28f53a,0xa454fe25},
	{0x05a0019b,0x94580000,0x5c320000,0x70d70000,0xfa0a0289,0x2b35d1c3,0x3ad56e5b,0xde43336c,0x6deb0267,0x033c0000,0xe9b30000,0xc6530000,0xf15403af,0x52270c18,0xadadf258,0x1da488fe},
	{0x11da0192,0x793f0000,0x3c960000,0xcad90000,0x4d8f01e2,0x162aaeb8,0x14fcf5f5,0x5eba75e6,0x33c00268,0x39c00000,0x1b060000,0x14c10000,0xe3c600aa,0x4911cc30,0x61016e94,0x24adb8af},
	{0x4ff1019d,0x43c30000,0xce230000,0x184b0000,0x5f1d02e7,0x0d1c6e90,0xd8506939,0x67b345b7,0x7991026e,0xee5b0000,0x89170000,0x7c5d0000,0x46d100c4,0x6f387363,0x838469f6,0x9d5dce74},
	{0x7a5e0186,0xe6220000,0x885e0000,0xaeb80000,0x95db03c6,0x6db1de3f,0x9bce57ba,0xe88089b7,0x92eb0276,0x3f2e0000,0xbadb0000,0x73cc0000,0xf1670246,0x627d0a19,0xa7744292,0xc47fb98b},
	{0x24750189,0xdcde0000,0x7aeb0000,0x7c2a0000,0x874900c3,0x76871e17,0x5762cb76,0xd189b9e6,0xd8ba0270,0xe8b50000,0x28ca0000,0x1b500000,0x54700228,0x4454b54a,0x45f145f0,0x7d8fcf50},
	{0x300f0180,0x31b90000,0x1a4f0000,0xc6240000,0x30cc03a8,0x4b98616c,0x794b50d8,0x5170ff6c,0x8691027f,0xd2490000,0xda7f0000,0xc9c20000,0x46e2012d,0x5f627562,0x895dd93c,0x4486ff01},
	{0x6e24018f,0x0b450000,0xe8fa0000,0x14b60000,0x225e00ad,0x50aea144,0xb5e7cc14,0x6879cf3d,0xccc00279,0x05d20000,0x486e0000,0xa15e0000,0xe3f50143,0x794bca31,0x6bd8de5e,0xfd7689da},
	{0xcf0f0191,0x0dab0000,0x49270000,0x73bb0000,0x30ff0241,0x7bc2676d,0x7392e012,0x88abce19,0x066f0273,0x9c210000,0x5d7b0000,0xa2320000,0x2900018b,0x29bc7c9f,0x229f5017,0xab9e74af},
	{0x9124019e,0x37570000,0xbb920000,0xa1290000,0x226d0144,0x60f4a745,0xbf3e7cde,0xb1a2fe48,0x4c3e0275,0x4bba0000,0xcf6a0000,0xcaae0000,0x8c1701e5,0x0f95c3cc,0xc01a5775,0x126e0274},
	{0x855e0197,0xda300000,0xdb360000,0x1b270000,0x95e8022f,0x5debd83e,0x9117e770,0x315bb8c2,0x1215027a,0x71460000,0x3ddf0000,0x183c0000,0x9e8502e0,0x14a303e4,0x0cb6cbb9,0x2b673225},
	{0xdb750198,0xe0cc0000,0x29830000,0xc9b50000,0x877a012a,0x46dd1816,0x5dbb7bbc,0x08528893,0x5844027c,0xa6dd0000,0xafce0000,0x70a00000,0x3b92028e,0x328abcb7,0xee33ccdb,0x929744fe},
	{0xf5b901a4,0x1e7f0000,0xea110000,0x8ca10000,0x1bbc0098,0x2a159bd8,0xf65e3857,0x49362850,0xeb330267,0x3dbf0000,0xb75d0000,0x9deb0000,0x3cdb0304,0xaf5e58c2,0xb0154285,0x860faed6},
	{0xab9201ab,0x24830000,0x18a40000,0x5e330000,0x092e039d,0x31235bf0,0x3af2a49b,0x703f1801,0xa1620261,0xea240000,0x254c0000,0xf5770000,0x99cc036a,0x8977e791,0x529045e7,0x3fffd80d},
	{0xbfe801a2,0xc9e40000,0x78000000,0xe43d0000,0xbeab00f6,0x0c3c248b,0x14db3f35,0xf0c65e8b,0xff49026e,0xd0d80000,0xd7f90000,0x27e50000,0x8b5e006f,0x924127b9,0x9e3cd92b,0x06f6e85c},
	{0xe1c301ad,0xf3180000,0x8ab50000,0x36af0000,0xac3903f3,0x170ae4a3,0xd877a3f9,0xc9cf6eda,0xb5180268,0x07430000,0x45e80000,0x4f790000,0x2e490001,0xb46898ea,0x7cb9de49,0xbf069e87},
	{0x40e801b3,0xf5f60000,0x2b680000,0x51a20000,0xbe98011f,0x3c66228a,0x1e028fff,0x291d6ffe,0x7fb70262,0x9eb00000,0x50fd0000,0x4c150000,0xe4bc00c9,0xe49f2e44,0x35fe5000,0xe9ee63f2},
	{0x1ec301bc,0xcf0a0000,0xd9dd0000,0x83300000,0xac0a021a,0x2750e2a2,0xd2ae1333,0x10145faf,0x35e60264,0x492b0000,0xc2ec0000,0x24890000,0x41ab00a7,0xc2b69117,0xd77b5762,0x501e1529},
	{0x0ab901b5,0x226d0000,0xb9790000,0x393e0000,0x1b8f0171,0x1a4f9dd9,0xfc87889d,0x90ed1925,0x6bcd026b,0x73d70000,0x30590000,0xf61b0000,0x533903a2,0xd980513f,0x1bd7cbae,0x69172578},
	{0x549201ba,0x18910000,0x4bcc0000,0xebac0000,0x091d0274,0x01795df1,0x302b1451,0xa9e42974,0x219c026d,0xa44c0000,0xa2480000,0x9e870000,0xf62e03cc,0xffa9ee6c,0xf952cccc,0xd0e753a3},
	{0x613d01a1,0xbd700000,0x0db10000,0x5d5f0000,0xc3db0355,0x61d4ed5e,0x73b52ad2,0x26d7e574,0xcae60275,0x75390000,0x91840000,0x91160000,0x4198014e,0xf2ec9716,0xdda2e7a8,0x89c5245c},
	{0x3f1601ae,0x878c0000,0xff040000,0x8fcd0000,0xd1490050,0x7ae22d76,0xbf19b61e,0x1fded525,0x80b70273,0xa2a20000,0x03950000,0xf98a0000,0xe48f0120,0xd4c52845,0x3f27e0ca,0x30355287},
	{0x2b6c01a7,0x6aeb0000,0x9fa00000,0x35c30000,0x66cc033b,0x47fd520d,0x91302db0,0x9f2793af,0xde9c027c,0x985e0000,0xf1200000,0x2b180000,0xf61d0225,0xcff3e86d,0xf38b7c06,0x093c62d6},
	{0x754701a8,0x50170000,0x6d150000,0xe7510000,0x745e003e,0x5ccb9225,0x5d9cb17c,0xa62ea3fe,0x94cd027a,0x4fc50000,0x63310000,0x43840000,0x530a024b,0xe9da573e,0x110e7b64,0xb0cc140d},
	{0xd46c01b6,0x56f90000,0xccc80000,0x805c0000,0x66ff02d2,0x77a7540c,0x9be99d7a,0x46fca2da,0x5e620270,0xd6360000,0x76240000,0x40e80000,0x99ff0283,0xb92de190,0x5849f52d,0xe624e978},
	{0x8a4701b9,0x6c050000,0x3e7d0000,0x52ce0000,0x746d01d7,0x6c919424,0x574501b6,0x7ff5928b,0x14330276,0x01ad0000,0xe4350000,0x28740000,0x3ce802ed,0x9f045ec3,0xbaccf24f,0x5fd49fa3},
	{0x9e3d01b0,0x81620000,0x5ed90000,0xe8c00000,0xc3e802bc,0x518eeb5f,0x796c9a18,0xff0cd401,0x4a180279,0x3b510000,0x16800000,0xfae60000,0x2e7a01e8,0x84329eeb,0x76606e83,0x66ddaff2},
	{0xc01601bf,0xbb9e0000,0xac6c0000,0x3a520000,0xd17a01b9,0x4ab82b77,0xb5c006d4,0xc605e450,0x0049027f,0xecca0000,0x84910000,0x927a0000,0x8b6d0186,0xa21b21b8,0x94e569e1,0xdf2dd929},
	{0xf0500240,0x66ed0000,0x32b20000,0x6e0c0000,0x6adb0397,0xa33b6ba3,0x586e3fed,0x4858c215,0x468703c0,0x69d70000,0x76130000,0xf3900000,0x97980094,0x15da5e15,0x3c9ddfe8,0x82831b51},
	{0xae7b024f,0x5c110000,0xc0070000,0xbc9e0000,0x78490092,0xb80dab8b,0x94c2a321,0x7151f244,0x0cd603c6,0xbe4c0000,0xe4020000,0x9b0c0000,0x328f00fa,0x33f3e146,0xde18d88a,0x3b736d8a},
	{0xba010246,0xb1760000,0xa0a30000,0x06900000,0xcfcc03f9,0x8512d4f0,0xbaeb388f,0xf1a8b4ce,0x52fd03c9,0x84b00000,0x16b70000,0x499e0000,0x201d03ff,0x28c5216e,0x12b44446,0x027a5ddb},
	{0xe42a0249,0x8b8a0000,0x52160000,0xd4020000,0xdd5e00fc,0x9e2414d8,0x7647a443,0xc8a1849f,0x18ac03cf,0x532b0000,0x84a60000,0x21020000,0x850a0391,0x0eec9e3d,0xf0314324,0xbb8a2b00},
	{0x45010257,0x8d640000,0xf3cb0000,0xb30f0000,0xcfff0210,0xb548d2f1,0xb0328845,0x287385bb,0xd20303c5,0xcad80000,0x91b30000,0x226e0000,0x4fff0359,0x5e1b2893,0xb976cd6d,0xed62d675},
	{0x1b2a0258,0xb7980000,0x017e0000,0x619d0000,0xdd6d0115,0xae7e12d9,0x7c9e1489,0x117ab5ea,0x985203c3,0x1d430000,0x03a20000,0x4af20000,0xeae80337,0x783297c0,0x5bf3ca0f,0x5492a0ae},
	{0x0f500251,0x5aff0000,0x61da0000,0xdb930000,0x6ae8027e,0x93616da2,0x52b78f27,0x9183f360,0xc67903cc,0x27bf0000,0xf1170000,0x98600000,0xf87a0032,0x630457e8,0x975f56c3,0x6d9b90ff},
	{0x517b025e,0x60030000,0x936f0000,0x09010000,0x787a017b,0x8857ad8a,0x9e1b13eb,0xa88ac331,0x8c2803ca,0xf0240000,0x63060000,0xf0fc0000,0x5d6d005c,0x452de8bb,0x75da51a1,0xd46be624},
	{0x64d40245,0xc5e20000,0xd5120000,0xbff20000,0xb2bc005a,0xe8fa1d25,0xdd852d68,0x27b90f31,0x675203d2,0x21510000,0x50ca0000,0xff6d0000,0xeadb02de,0x486891c1,0x512a7ac5,0x8d4991db},
	{0x3aff024a,0xff1e0000,0x27a70000,0x6d600000,0xa02e035f,0xf3ccdd0d,0x1129b1a4,0x1eb03f60,0x2d0303d4,0xf6ca0000,0xc2db0000,0x97f10000,0x4fcc02b0,0x6e412e92,0xb3af7da7,0x34b9e700},
	{0x2e850243,0x12790000,0x47030000,0xd76e0000,0x17ab0034,0xced3a276,0x3f002a0a,0x9e4979ea,0x732803db,0xcc360000,0x306e0000,0x45630000,0x5d5e01b5,0x7577eeba,0x7f03e16b,0x0db0d751},
	{0x70ae024c,0x28850000,0xb5b60000,0x05fc0000,0x05390331,0xd5e5625e,0xf3acb6c6,0xa74049bb,0x397903dd,0x1bad0000,0xa27f0000,0x2dff0000,0xf84901db,0x535e51e9,0x9d86e609,0xb440a18a},
	{0xd1850252,0x2e6b0000,0x146b0000,0x62f10000,0x179801dd,0xfe89a477,0x35d99ac0,0x4792489f,0xf3d603d7,0x825e0000,0xb76a0000,0x2e930000,0x32bc0113,0x03a9e747,0xd4c16840,0xe2a85cff},
	{0x8fae025d,0x14970000,0xe6de0000,0xb0630000,0x050a02d8,0xe5bf645f,0xf975060c,0x7e9b78ce,0xb98703d1,0x55c50000,0x257b0000,0x460f0000,0x97ab017d,0x25805814,0x36446f22,0x5b582a24},
	{0x9bd40254,0xf9f00000,0x867a0000,0x0a6d0000,0xb28f01b3,0xd8a01b24,0xd75c9da2,0xfe623e44,0xe7ac03de,0x6f390000,0xd7ce0000,0x949d0000,0x85390278,0x3eb6983c,0xfae8f3ee,0x62511a75},
	{0xc5ff025b,0xc30c0000,0x74cf0000,0xd8ff0000,0xa01d02b6,0xc396db0c,0x1bf0016e,0xc76b0e15,0xadfd03d8,0xb8a20000,0x45df0000,0xfc010000,0x202e0216,0x189f276f,0x186df48c,0xdba16cae},
	{0xeb330267,0x3dbf0000,0xb75d0000,0x9deb0000,0x3cdb0304,0xaf5e58c2,0xb0154285,0x860faed6,0x1e8a03c3,0x23c00000,0x5d4c0000,0x114a0000,0x2767039c,0x854bc31a,0x464b7ad2,0xcf398686},
	{0xb5180268,0x07430000,0x45e80000,0x4f790000,0x2e490001,0xb46898ea,0x7cb9de49,0xbf069e87,0x54db03c5,0xf45b0000,0xcf5d0000,0x79d60000,0x827003f2,0xa3627c49,0xa4ce7db0,0x76c9f05d},
	{0xa1620261,0xea240000,0x254c0000,0xf5770000,0x99cc036a,0x8977e791,0x529045e7,0x3fffd80d,0x0af003ca,0xcea70000,0x3de80000,0xab440000,0x90e200f7,0xb854bc61,0x6862e17c,0x4fc0c00c},
	{0xff49026e,0xd0d80000,0xd7f90000,0x27e50000,0x8b5e006f,0x924127b9,0x9e3cd92b,0x06f6e85c,0x40a103cc,0x193c0000,0xaff90000,0xc3d80000,0x35f50099,0x9e7d0332,0x8ae7e61e,0xf630b6d7},
	{0x5e620270,0xd6360000,0x76240000,0x40e80000,0x99ff0283,0xb92de190,0x5849f52d,0xe624e978,0x8a0e03c6,0x80cf0000,0xbaec0000,0xc0b40000,0xff000051,0xce8ab59c,0xc3a06857,0xa0d84ba2},
	{0x0049027f,0xecca0000,0x84910000,0x927a0000,0x8b6d0186,0xa21b21b8,0x94e569e1,0xdf2dd929,0xc05f03c0,0x57540000,0x28fd0000,0xa8280000,0x5a17003f,0xe8a30acf,0x21256f35,0x19283d79},
	{0x14330276,0x01ad0000,0xe4350000,0x28740000,0x3ce802ed,0x9f045ec3,0xbaccf24f,0x5fd49fa3,0x9e7403cf,0x6da80000,0xda480000,0x7aba0000,0x4885033a,0xf395cae7,0xed89f3f9,0x20210d28},
	{0x4a180279,0x3b510000,0x16800000,0xfae60000,0x2e7a01e8,0x84329eeb,0x76606e83,0x66ddaff2,0xd42503c9,0xba330000,0x48590000,0x12260000,0xed920354,0xd5bc75b4,0x0f0cf49b,0x99d17bf3},
	{0x7fb70262,0x9eb00000,0x50fd0000,0x4c150000,0xe4bc00c9,0xe49f2e44,0x35fe5000,0xe9ee63f2,0x3f5f03d1,0x6b460000,0x7b950000,0x1db70000,0x5a2401d6,0xd8f90cce,0x2bfcdfff,0xc0f30c0c},
	{0x219c026d,0xa44c0000,0xa2480000,0x9e870000,0xf62e03cc,0xffa9ee6c,0xf952cccc,0xd0e753a3,0x750e03d7,0xbcdd0000,0xe9840000,0x752b0000,0xff3301b8,0xfed0b39d,0xc979d89d,0x79037ad7},
	{0x35e60264,0x492b0000,0xc2ec0000,0x24890000,0x41ab00a7,0xc2b69117,0xd77b5762,0x501e1529,0x2b2503d8,0x86210000,0x1b310000,0xa7b90000,0xeda102bd,0xe5e673b5,0x05d54451,0x400a4a86},
	{0x6bcd026b,0x73d70000,0x30590000,0xf61b0000,0x533903a2,0xd980513f,0x1bd7cbae,0x69172578,0x617403de,0x51ba0000,0x89200000,0xcf250000,0x48b602d3,0xc3cfcce6,0xe7504333,0xf9fa3c5d},
	{0xcae60275,0x75390000,0x91840000,0x91160000,0x4198014e,0xf2ec9716,0xdda2e7a8,0x89c5245c,0xabdb03d4,0xc8490000,0x9c350000,0xcc490000,0x8243021b,0x93387a48,0xae17cd7a,0xaf12c128},
	{0x94cd027a,0x4fc50000,0x63310000,0x43840000,0x530a024b,0xe9da573e,0x110e7b64,0xb0cc140d,0xe18a03d2,0x1fd20000,0x0e240000,0xa4d50000,0x27540275,0xb511c51b,0x4c92ca18,0x16e2b7f3},
	{0x80b70273,0xa2a20000,0x03950000,0xf98a0000,0xe48f0120,0xd4c52845,0x3f27e0ca,0x30355287,0xbfa103dd,0x252e0000,0xfc910000,0x76470000,0x35c60170,0xae270533,0x803e56d4,0x2feb87a2},
	{0xde9c027c,0x985e0000,0xf1200000,0x2b180000,0xf61d0225,0xcff3e86d,0xf38b7c06,0x093c62d6,0xf5f003db,0xf2b50000,0x6e800000,0x1edb0000,0x90d1011e,0x880eba60,0x62bb51b6,0x961bf179},
	{0xa85d0243,0x2cfa0000,0x19ed0000,0x8cd60000,0xda24009f,0x33aaf6ac,0x22b89ad7,0x05e25fc2,0x05e903e4,0x78920000,0xd8a30000,0xe2ad0000,0x7167030f,0x892ef07b,0xae3007ba,0x016eea45},
	{0xf676024c,0x16060000,0xeb580000,0x5e440000,0xc8b6039a,0x289c3684,0xee14061b,0x3ceb6f93,0x4fb803e2,0xaf090000,0x4ab20000,0x8a310000,0xd4700361,0xaf074f28,0x4cb500d8,0xb89e9c9e},
	{0xe20c0245,0xfb610000,0x8bfc0000,0xe44a0000,0x7f3300f1,0x158349ff,0xc03d9db5,0xbc122919,0x119303ed,0x95f50000,0xb8070000,0x58a30000,0xc6e20064,0xb4318f00,0x80199c14,0x8197accf},
	{0xbc27024a,0xc19d0000,0x79490000,0x36d80000,0x6da103f4,0x0eb589d7,0x0c910179,0x851b1948,0x5bc203eb,0x426e0000,0x2a160000,0x303f0000,0x63f5000a,0x92183053,0x629c9b76,0x3867da14},
	{0x1d0c0254,0xc7730000,0xd8940000,0x51d50000,0x7f000118,0x25d94ffe,0xcae42d7f,0x65c9186c,0x916d03e1,0xdb9d0000,0x3f030000,0x33530000,0xa90000c2,0xc2ef86fd,0x2bdb153f,0x6e8f2761},
	{0x4327025b,0xfd8f0000,0x2a210000,0x83470000,0x6d92021d,0x3eef8fd6,0x0648b1b3,0x5cc0283d,0xdb3c03e7,0x0c060000,0xad120000,0x5bcf0000,0x0c1700ac,0xe4c639ae,0xc95e125d,0xd77f51ba},
	{0x575d0252,0x10e80000,0x4a850000,0x39490000,0xda170176,0x03f0f0ad,0x28612a1d,0xdc396eb7,0x851703e8,0x36fa0000,0x5fa70000,0x895d0000,0x1e8503a9,0xfff0f986,0x05f28e91,0xee7661eb},
	{0x0976025d,0x2a140000,0xb8300000,0xebdb0000,0xc8850273,0x18c63085,0xe4cdb6d1,0xe5305ee6,0xcf4603ee,0xe1610000,0xcdb60000,0xe1c10000,0xbb9203c7,0xd9d946d5,0xe77789f3,0x57861730},
	{0x3cd90246,0x8ff50000,0xfe4d0000,0x5d280000,0x02430352,0x786b802a,0xa7538852,0x6a0392e6,0x243c03f6,0x30140000,0xfe7a0000,0xee500000,0x0c240145,0xd49c3faf,0xc387a297,0x0ea460cf},
	{0x62f20249,0xb5090000,0x0cf80000,0x8fba0000,0x10d10057,0x635d4002,0x6bff149e,0x530aa2b7,0x6e6d03f0,0xe78f0000,0x6c6b0000,0x86cc0000,0xa933012b,0xf2b580fc,0x2102a5f5,0xb7541614},
	{0x76880240,0x586e0000,0x6c5c0000,0x35b40000,0xa754033c,0x5e423f79,0x45d68f30,0xd3f3e43d,0x304603ff,0xdd730000,0x9ede0000,0x545e0000,0xbba1022e,0xe98340d4,0xedae3939,0x8e5d2645},
	{0x28a3024f,0x62920000,0x9ee90000,0xe7260000,0xb5c60039,0x4574ff51,0x897a13fc,0xeafad46c,0x7a1703f9,0x0ae80000,0x0ccf0000,0x3cc20000,0x1eb60240,0xcfaaff87,0x0f2b3e5b,0x37ad509e},
	{0x89880251,0x647c0000,0x3f340000,0x802b0000,0xa76702d5,0x6e183978,0x4f0f3ffa,0x0a28d548,0xb0b803f3,0x931b0000,0x19da0000,0x3fae0000,0xd4430288,0x9f5d4929,0x466cb012,0x6145adeb},
	{0xd7a3025e,0x5e800000,0xcd810000,0x52b90000,0xb5f501d0,0x752ef950,0x83a3a336,0x3321e519,0xfae903f5,0x44800000,0x8bcb0000,0x57320000,0x715402e6,0xb974f67a,0xa4e9b770,0xd8b5db30},
	{0xc3d90257,0xb3e70000,0xad250000,0xe8b70000,0x027002bb,0x4831862b,0xad8a3898,0xb3d8a393,0xa4c203fa,0x7e7c0000,0x797e0000,0x85a00000,0x63c601e3,0xa2423652,0x68452bbc,0xe1bceb61},
	{0x9df20258,0x891b0000,0x5f900000,0x3a250000,0x10e201be,0x53074603,0x6126a454,0x8ad193c2,0xee9303fc,0xa9e70000,0xeb6f0000,0xed3c0000,0xc6d1018d,0x846b8901,0x8ac02cde,0x584c9dba},
	{0xb33e0264,0x77a80000,0x9c020000,0x7f310000,0x8c24000c,0x3fcfc5cd,0xcac3e7bf,0xcbb53301,0x5de403e7,0x32850000,0xf3fc0000,0x00770000,0xc1980007,0x19bf6d74,0xd4e6a280,0x4cd47792},
	{0xed15026b,0x4d540000,0x6eb70000,0xada30000,0x9eb60309,0x24f905e5,0x066f7b73,0xf2bc0350,0x17b503e1,0xe51e0000,0x61ed0000,0x68eb0000,0x648f0069,0x3f96d227,0x3663a5e2,0xf5240149},
	{0xf96f0262,0xa0330000,0x0e130000,0x17ad0000,0x29330062,0x19e67a9e,0x2846e0dd,0x724545da,0x499e03ee,0xdfe20000,0x93580000,0xba790000,0x761d036c,0x24a0120f,0xfacf392e,0xcc2d3118},
	{0xa744026d,0x9acf0000,0xfca60000,0xc53f0000,0x3ba10367,0x02d0bab6,0xe4ea7c11,0x4b4c758b,0x03cf03e8,0x08790000,0x01490000,0xd2e50000,0xd30a0302,0x0289ad5c,0x184a3e4c,0x75dd47c3},
	{0x066f0273,0x9c210000,0x5d7b0000,0xa2320000,0x2900018b,0x29bc7c9f,0x229f5017,0xab9e74af,0xc96003e2,0x918a0000,0x145c0000,0xd1890000,0x19ff03ca,0x527e1bf2,0x510db005,0x2335bab6},
	{0x5844027c,0xa6dd0000,0xafce0000,0x70a00000,0x3b92028e,0x328abcb7,0xee33ccdb,0x929744fe,0x833103e4,0x46110000,0x864d0000,0xb9150000,0xbce803a4,0x7457a4a1,0xb388b767,0x9ac5cc6d},
	{0x4c3e0275,0x4bba0000,0xcf6a0000,0xcaae0000,0x8c1701e5,0x0f95c3cc,0xc01a5775,0x126e0274,0xdd1a03eb,0x7ced0000,0x74f80000,0x6b870000,0xae7a00a1,0x6f616489,0x7f242bab,0xa3ccfc3c},
	{0x1215027a,0x71460000,0x3ddf0000,0x183c0000,0x9e8502e0,0x14a303e4,0x0cb6cbb9,0x2b673225,0x974b03ed,0xab760000,0xe6e90000,0x031b0000,0x0b6d00cf,0x4948dbda,0x9da12cc9,0x1a3c8ae7},
	{0x27ba0261,0xd4a70000,0x7ba20000,0xaecf0000,0x544303c1,0x740eb34b,0x4f28f53a,0xa454fe25,0x7c3103f5,0x7a030000,0xd5250000,0x0c8a0000,0xbcdb024d,0x440da2a0,0xb95107ad,0x431efd18},
	{0x7991026e,0xee5b0000,0x89170000,0x7c5d0000,0x46d100c4,0x6f387363,0x838469f6,0x9d5dce74,0x366003f3,0xad980000,0x47340000,0x64160000,0x19cc0223,0x62241df3,0x5bd400cf,0xfaee8bc3},
	{0x6deb0267,0x033c0000,0xe9b30000,0xc6530000,0xf15403af,0x52270c18,0xadadf258,0x1da488fe,0x684b03fc,0x97640000,0xb5810000,0xb6840000,0x0b5e0126,0x7912dddb,0x97789c03,0xc3e7bb92},
	{0x33c00268,0x39c00000,0x1b060000,0x14c10000,0xe3c600aa,0x4911cc30,0x61016e94,0x24adb8af,0x221a03fa,0x40ff0000,0x27900000,0xde180000,0xae490148,0x5f3b6288,0x75fd9b61,0x7a17cd49},
	{0x92eb0276,0x3f2e0000,0xbadb0000,0x73cc0000,0xf1670246,0x627d0a19,0xa7744292,0xc47fb98b,0xe8b503f0,0xd90c0000,0x32850000,0xdd740000,0x64bc0180,0x0fccd426,0x3cba1528,0x2cff303c},
	{0xccc00279,0x05d20000,0x486e0000,0xa15e0000,0xe3f50143,0x794bca31,0x6bd8de5e,0xfd7689da,0xa2e403f6,0x0e970000,0xa0940000,0xb5e80000,0xc1ab01ee,0x29e56b75,0xde3f124a,0x950f46e7},
	{0xd8ba0270,0xe8b50000,0x28ca0000,0x1b500000,0x54700228,0x4454b54a,0x45f145f0,0x7d8fcf50,0xfccf03f9,0x346b0000,0x52210000,0x677a0000,0xd33902eb,0x32d3ab5d,0x12938e86,0xac0676b6},
	{0x8691027f,0xd2490000,0xda7f0000,0xc9c20000,0x46e2012d,0x5f627562,0x895dd93c,0x4486ff01,0xb69e03ff,0xe3f00000,0xc0300000,0x0fe60000,0x762e0285,0x14fa140e,0xf01689e4,0x15f6006d}
    },{
	{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x3f280000,0x500f0270,0xcdd60000,0x0ac10000,0xdafc0334,0x2498b0b9,0x4a8bda12,0xc5395dd5,0x40ae0000,0xdff90030,0x76e00000,0xeb190000,0x185b022a,0x3f0239ce,0x94b9e168,0xb849e918},
	{0x40ae0000,0xdff90030,0x76e00000,0xeb190000,0x185b022a,0x3f0239ce,0x94b9e168,0xb849e918,0x7f860000,0x8ff60240,0xbb360000,0xe1d80000,0xc2a7011e,0x1b9a8977,0xde323b7a,0x7d70b4cd},
	{0x7f860000,0x8ff60240,0xbb360000,0xe1d80000,0xc2a7011e,0x1b9a8977,0xde323b7a,0x7d70b4cd,0x3f280000,0x500f0270,0xcdd60000,0x0ac10000,0xdafc0334,0x2498b0b9,0x4a8bda12,0xc5395dd5},
	{0x270f0000,0xfd973c00,0x14020000,0x52b70000,0x049701b6,0xea421130,0x8cb79905,0xc6ed17f0,0xfc900000,0x0c3a1800,0xb7f30000,0xe85f0000,0x9a3a027f,0xb67a0c88,0xdda1f62d,0xb9d7b7ff},
	{0x18270000,0xad983e70,0xd9d40000,0x58760000,0xde6b0282,0xcedaa189,0xc63c4317,0x03d44a25,0xbc3e0000,0xd3c31830,0xc1130000,0x03460000,0x82610055,0x89783546,0x49181745,0x019e5ee7},
	{0x67a10000,0x226e3c30,0x62e20000,0xb9ae0000,0x1ccc039c,0xd54028fe,0x180e786d,0x7ea4fee8,0x83160000,0x83cc1a40,0x0cc50000,0x09870000,0x589d0361,0xade085ff,0x0393cd57,0xc4a70332},
	{0x58890000,0x72613e40,0xaf340000,0xb36f0000,0xc63000a8,0xf1d89847,0x5285a27f,0xbb9da33d,0xc3b80000,0x5c351a70,0x7a250000,0xe29e0000,0x40c6014b,0x92e2bc31,0x972a2c3f,0x7ceeea2a},
	{0xfc900000,0x0c3a1800,0xb7f30000,0xe85f0000,0x9a3a027f,0xb67a0c88,0xdda1f62d,0xb9d7b7ff,0xdb9f0000,0xf1ad2400,0xa3f10000,0xbae80000,0x9ead03c9,0x5c381db8,0x51166f28,0x7f3aa00f},
	{0xc3b80000,0x5c351a70,0x7a250000,0xe29e0000,0x40c6014b,0x92e2bc31,0x972a2c3f,0x7ceeea2a,0x9b310000,0x2e542430,0xd5110000,0x51f10000,0x86f601e3,0x633a2476,0xc5af8e40,0xc7734917},
	{0xbc3e0000,0xd3c31830,0xc1130000,0x03460000,0x82610055,0x89783546,0x49181745,0x019e5ee7,0xa4190000,0x7e5b2640,0x18c70000,0x5b300000,0x5c0a02d7,0x47a294cf,0x8f245452,0x024a14c2},
	{0x83160000,0x83cc1a40,0x0cc50000,0x09870000,0x589d0361,0xade085ff,0x0393cd57,0xc4a70332,0xe4b70000,0xa1a22670,0x6e270000,0xb0290000,0x445100fd,0x78a0ad01,0x1b9db53a,0xba03fdda},
	{0xdb9f0000,0xf1ad2400,0xa3f10000,0xbae80000,0x9ead03c9,0x5c381db8,0x51166f28,0x7f3aa00f,0x270f0000,0xfd973c00,0x14020000,0x52b70000,0x049701b6,0xea421130,0x8cb79905,0xc6ed17f0},
	{0xe4b70000,0xa1a22670,0x6e270000,0xb0290000,0x445100fd,0x78a0ad01,0x1b9db53a,0xba03fdda,0x67a10000,0x226e3c30,0x62e20000,0xb9ae0000,0x1ccc039c,0xd54028fe,0x180e786d,0x7ea4fee8},
	{0x9b310000,0x2e542430,0xd5110000,0x51f10000,0x86f601e3,0x633a2476,0xc5af8e40,0xc7734917,0x58890000,0x72613e40,0xaf340000,0xb36f0000,0xc63000a8,0xf1d89847,0x5285a27f,0xbb9da33d},
	{0xa4190000,0x7e5b2640,0x18c70000,0x5b300000,0x5c0a02d7,0x47a294cf,0x8f245452,0x024a14c2,0x18270000,0xad983e70,0xd9d40000,0x58760000,0xde6b0282,0xcedaa189,0xc63c4317,0x03d44a25},
	{0x46fc0000,0xf91e5c00,0xeb940000,0x9dae0000,0x175e00f2,0xd40b62a1,0x51482e7a,0x93ebeb6e,0x89030000,0x96351400,0x4b650000,0xd1780000,0xa475006c,0xaff51115,0xf3a07252,0xf19e48fd},
	{0x79d40000,0xa9115e70,0x26420000,0x976f0000,0xcda203c6,0xf093d218,0x1bc3f468,0x56d2b6bb,0xc9ad0000,0x49cc1430,0x3d850000,0x3a610000,0xbc2e0246,0x90f728db,0x6719933a,0x49d7a1e5},
	{0x06520000,0x26e75c30,0x9d740000,0x76b70000,0x0f0502d8,0xeb095b6f,0xc5f1cf12,0x2ba20276,0xf6850000,0x19c31640,0xf0530000,0x30a00000,0x66d20172,0xb46f9862,0x2d924928,0x8ceefc30},
	{0x397a0000,0x76e85e40,0x50a20000,0x7c760000,0xd5f901ec,0xcf91ebd6,0x8f7a1500,0xee9b5fa3,0xb62b0000,0xc63a1670,0x86b30000,0xdbb90000,0x7e890358,0x8b6da1ac,0xb92ba840,0x34a71528},
	{0x61f30000,0x04896000,0xff960000,0xcf190000,0x13c90144,0x3e497391,0xddffb77f,0x5506fc9e,0x75930000,0x9a0f0c00,0xfc960000,0x39270000,0x3e4f0213,0x198f1d9d,0x2e01847f,0x4849ff02},
	{0x5edb0000,0x54866270,0x32400000,0xc5d80000,0xc9350270,0x1ad1c328,0x97746d6d,0x903fa14b,0x353d0000,0x45f60c30,0x8a760000,0xd23e0000,0x26140039,0x268d2453,0xbab86517,0xf000161a},
	{0x215d0000,0xdb706030,0x89760000,0x24000000,0x0b92036e,0x014b4a5f,0x49465617,0xed4f1586,0x0a150000,0x15f90e40,0x47a00000,0xd8ff0000,0xfce8030d,0x021594ea,0xf033bf05,0x35394bcf},
	{0x1e750000,0x8b7f6240,0x44a00000,0x2ec10000,0xd16e005a,0x25d3fae6,0x03cd8c05,0x28764853,0x4abb0000,0xca000e70,0x31400000,0x33e60000,0xe4b30127,0x3d17ad24,0x648a5e6d,0x8d70a2d7},
	{0xba6c0000,0xf5244400,0x5c670000,0x75f10000,0x8d64028d,0x62716e29,0x8ce9d857,0x2a3c5c91,0x529c0000,0x67983000,0xe8940000,0x6b900000,0x3ad803a5,0xf3cd0cad,0xa2b61d7a,0x8ea4e8f2},
	{0x85440000,0xa52b4670,0x91b10000,0x7f300000,0x579801b9,0x46e9de90,0xc6620245,0xef050144,0x12320000,0xb8613030,0x9e740000,0x80890000,0x2283018f,0xcccf3563,0x360ffc12,0x36ed01ea},
	{0xfac20000,0x2add4430,0x2a870000,0x9ee80000,0x953f00a7,0x5d7357e7,0x1850393f,0x9275b589,0x2d1a0000,0xe86e3240,0x53a20000,0x8a480000,0xf87f02bb,0xe85785da,0x7c842600,0xf3d45c3f},
	{0xc5ea0000,0x7ad24640,0xe7510000,0x94290000,0x4fc30393,0x79ebe75e,0x52dbe32d,0x574ce85c,0x6db40000,0x37973270,0x25420000,0x61510000,0xe0240091,0xd755bc14,0xe83dc768,0x4b9db527},
	{0x9d630000,0x08b37800,0x48650000,0x27460000,0x89f3033b,0x88337f19,0x005e4152,0xecd14b61,0xae0c0000,0x6ba22800,0x5f670000,0x83cf0000,0xa0e201da,0x45b70025,0x7f17eb57,0x37735f0d},
	{0xa24b0000,0x58bc7a70,0x85b30000,0x2d870000,0x530f000f,0xacabcfa0,0x4ad59b40,0x29e816b4,0xeea20000,0xb45b2830,0x29870000,0x68d60000,0xb8b903f0,0x7ab539eb,0xebae0a3f,0x8f3ab615},
	{0xddcd0000,0xd74a7830,0x3e850000,0xcc5f0000,0x91a80111,0xb73146d7,0x94e7a03a,0x5498a279,0xd18a0000,0xe4542a40,0xe4510000,0x62170000,0x624500c4,0x5e2d8952,0xa125d02d,0x4a03ebc0},
	{0xe2e50000,0x87457a40,0xf3530000,0xc69e0000,0x4b540225,0x93a9f66e,0xde6c7a28,0x91a1ffac,0x91240000,0x3bad2a70,0x92b10000,0x890e0000,0x7a1e02ee,0x612fb09c,0x359c3145,0xf24a02d8},
	{0x89030000,0x96351400,0x4b650000,0xd1780000,0xa475006c,0xaff51115,0xf3a07252,0xf19e48fd,0xcfff0000,0x6f2b4800,0xa0f10000,0x4cd60000,0xb32b009e,0x7bfe73b4,0xa2e85c28,0x6275a393},
	{0xb62b0000,0xc63a1670,0x86b30000,0xdbb90000,0x7e890358,0x8b6da1ac,0xb92ba840,0x34a71528,0x8f510000,0xb0d24830,0xd6110000,0xa7cf0000,0xab7002b4,0x44fc4a7a,0x3651bd40,0xda3c4a8b},
	{0xc9ad0000,0x49cc1430,0x3d850000,0x3a610000,0xbc2e0246,0x90f728db,0x6719933a,0x49d7a1e5,0xb0790000,0xe0dd4a40,0x1bc70000,0xad0e0000,0x718c0180,0x6064fac3,0x7cda6752,0x1f05175e},
	{0xf6850000,0x19c31640,0xf0530000,0x30a00000,0x66d20172,0xb46f9862,0x2d924928,0x8ceefc30,0xf0d70000,0x3f244a70,0x6d270000,0x46170000,0x69d703aa,0x5f66c30d,0xe863863a,0xa74cfe46},
	{0xae0c0000,0x6ba22800,0x5f670000,0x83cf0000,0xa0e201da,0x45b70025,0x7f17eb57,0x37735f0d,0x336f0000,0x63115000,0x17020000,0xa4890000,0x291102e1,0xcd847f3c,0x7f49aa05,0xdba2146c},
	{0x91240000,0x3bad2a70,0x92b10000,0x890e0000,0x7a1e02ee,0x612fb09c,0x359c3145,0xf24a02d8,0x73c10000,0xbce85030,0x61e20000,0x4f900000,0x314a00cb,0xf28646f2,0xebf04b6d,0x63ebfd74},
	{0xeea20000,0xb45b2830,0x29870000,0x68d60000,0xb8b903f0,0x7ab539eb,0xebae0a3f,0x8f3ab615,0x4ce90000,0xece75240,0xac340000,0x45510000,0xebb603ff,0xd61ef64b,0xa17b917f,0xa6d2a0a1},
	{0xd18a0000,0xe4542a40,0xe4510000,0x62170000,0x624500c4,0x5e2d8952,0xa125d02d,0x4a03ebc0,0x0c470000,0x331e5270,0xdad40000,0xae480000,0xf3ed01d5,0xe91ccf85,0x35c27017,0x1e9b49b9},
	{0x75930000,0x9a0f0c00,0xfc960000,0x39270000,0x3e4f0213,0x198f1d9d,0x2e01847f,0x4849ff02,0x14600000,0x9e866c00,0x03000000,0xf63e0000,0x2d860357,0x27c66e0c,0xf3fe3300,0x1d4f039c},
	{0x4abb0000,0xca000e70,0x31400000,0x33e60000,0xe4b30127,0x3d17ad24,0x648a5e6d,0x8d70a2d7,0x54ce0000,0x417f6c30,0x75e00000,0x1d270000,0x35dd017d,0x18c457c2,0x6747d268,0xa506ea84},
	{0x353d0000,0x45f60c30,0x8a760000,0xd23e0000,0x26140039,0x268d2453,0xbab86517,0xf000161a,0x6be60000,0x11706e40,0xb8360000,0x17e60000,0xef210249,0x3c5ce77b,0x2dcc087a,0x603fb751},
	{0x0a150000,0x15f90e40,0x47a00000,0xd8ff0000,0xfce8030d,0x021594ea,0xf033bf05,0x35394bcf,0x2b480000,0xce896e70,0xced60000,0xfcff0000,0xf77a0063,0x035edeb5,0xb975e912,0xd8765e49},
	{0x529c0000,0x67983000,0xe8940000,0x6b900000,0x3ad803a5,0xf3cd0cad,0xa2b61d7a,0x8ea4e8f2,0xe8f00000,0x92bc7400,0xb4f30000,0x1e610000,0xb7bc0128,0x91bc6284,0x2e5fc52d,0xa498b463},
	{0x6db40000,0x37973270,0x25420000,0x61510000,0xe0240091,0xd755bc14,0xe83dc768,0x4b9db527,0xa85e0000,0x4d457430,0xc2130000,0xf5780000,0xafe70302,0xaebe5b4a,0xbae62445,0x1cd15d7b},
	{0x12320000,0xb8613030,0x9e740000,0x80890000,0x2283018f,0xcccf3563,0x360ffc12,0x36ed01ea,0x97760000,0x1d4a7640,0x0fc50000,0xffb90000,0x751b0036,0x8a26ebf3,0xf06dfe57,0xd9e800ae},
	{0x2d1a0000,0xe86e3240,0x53a20000,0x8a480000,0xf87f02bb,0xe85785da,0x7c842600,0xf3d45c3f,0xd7d80000,0xc2b37670,0x79250000,0x14a00000,0x6d40021c,0xb524d23d,0x64d41f3f,0x61a1e9b6},
	{0xcfff0000,0x6f2b4800,0xa0f10000,0x4cd60000,0xb32b009e,0x7bfe73b4,0xa2e85c28,0x6275a393,0x46fc0000,0xf91e5c00,0xeb940000,0x9dae0000,0x175e00f2,0xd40b62a1,0x51482e7a,0x93ebeb6e},
	{0xf0d70000,0x3f244a70,0x6d270000,0x46170000,0x69d703aa,0x5f66c30d,0xe863863a,0xa74cfe46,0x06520000,0x26e75c30,0x9d740000,0x76b70000,0x0f0502d8,0xeb095b6f,0xc5f1cf12,0x2ba20276},
	{0x8f510000,0xb0d24830,0xd6110000,0xa7cf0000,0xab7002b4,0x44fc4a7a,0x3651bd40,0xda3c4a8b,0x397a0000,0x76e85e40,0x50a20000,0x7c760000,0xd5f901ec,0xcf91ebd6,0x8f7a1500,0xee9b5fa3},
	{0xb0790000,0xe0dd4a40,0x1bc70000,0xad0e0000,0x718c0180,0x6064fac3,0x7cda6752,0x1f05175e,0x79d40000,0xa9115e70,0x26420000,0x976f0000,0xcda203c6,0xf093d218,0x1bc3f468,0x56d2b6bb},
	{0xe8f00000,0x92bc7400,0xb4f30000,0x1e610000,0xb7bc0128,0x91bc6284,0x2e5fc52d,0xa498b463,0xba6c0000,0xf5244400,0x5c670000,0x75f10000,0x8d64028d,0x62716e29,0x8ce9d857,0x2a3c5c91},
	{0xd7d80000,0xc2b37670,0x79250000,0x14a00000,0x6d40021c,0xb524d23d,0x64d41f3f,0x61a1e9b6,0xfac20000,0x2add4430,0x2a870000,0x9ee80000,0x953f00a7,0x5d7357e7,0x1850393f,0x9275b589},
	{0xa85e0000,0x4d457430,0xc2130000,0xf5780000,0xafe70302,0xaebe5b4a,0xbae62445,0x1cd15d7b,0xc5ea0000,0x7ad24640,0xe7510000,0x94290000,0x4fc30393,0x79ebe75e,0x52dbe32d,0x574ce85c},
	{0x97760000,0x1d4a7640,0x0fc50000,0xffb90000,0x751b0036,0x8a26ebf3,0xf06dfe57,0xd9e800ae,0x85440000,0xa52b4670,0x91b10000,0x7f300000,0x579801b9,0x46e9de90,0xc6620245,0xef050144},
	{0x336f0000,0x63115000,0x17020000,0xa4890000,0x291102e1,0xcd847f3c,0x7f49aa05,0xdba2146c,0x9d630000,0x08b37800,0x48650000,0x27460000,0x89f3033b,0x88337f19,0x005e4152,0xecd14b61},
	{0x0c470000,0x331e5270,0xdad40000,0xae480000,0xf3ed01d5,0xe91ccf85,0x35c27017,0x1e9b49b9,0xddcd0000,0xd74a7830,0x3e850000,0xcc5f0000,0x91a80111,0xb73146d7,0x94e7a03a,0x5498a279},
	{0x73c10000,0xbce85030,0x61e20000,0x4f900000,0x314a00cb,0xf28646f2,0xebf04b6d,0x63ebfd74,0xe2e50000,0x87457a40,0xf3530000,0xc69e0000,0x4b540225,0x93a9f66e,0xde6c7a28,0x91a1ffac},
	{0x4ce90000,0xece75240,0xac340000,0x45510000,0xebb603ff,0xd61ef64b,0xa17b917f,0xa6d2a0a1,0xa24b0000,0x58bc7a70,0x85b30000,0x2d870000,0x530f000f,0xacabcfa0,0x4ad59b40,0x29e816b4},
	{0x14600000,0x9e866c00,0x03000000,0xf63e0000,0x2d860357,0x27c66e0c,0xf3fe3300,0x1d4f039c,0x61f30000,0x04896000,0xff960000,0xcf190000,0x13c90144,0x3e497391,0xddffb77f,0x5506fc9e},
	{0x2b480000,0xce896e70,0xced60000,0xfcff0000,0xf77a0063,0x035edeb5,0xb975e912,0xd8765e49,0x215d0000,0xdb706030,0x89760000,0x24000000,0x0b92036e,0x014b4a5f,0x49465617,0xed4f1586},
	{0x54ce0000,0x417f6c30,0x75e00000,0x1d270000,0x35dd017d,0x18c457c2,0x6747d268,0xa506ea84,0x1e750000,0x8b7f6240,0x44a00000,0x2ec10000,0xd16e005a,0x25d3fae6,0x03cd8c05,0x28764853},
	{0x6be60000,0x11706e40,0xb8360000,0x17e60000,0xef210249,0x3c5ce77b,0x2dcc087a,0x603fb751,0x5edb0000,0x54866270,0x32400000,0xc5d80000,0xc9350270,0x1ad1c328,0x97746d6d,0x903fa14b},
	{0xc53e0000,0xee4c9c00,0x33390000,0x33bb0000,0xaccc017a,0x8b9afca2,0xdb75428c,0x25ee31dc,0x52e70000,0x32620c00,0x75d90000,0xe2320000,0xd8a20058,0xbb675bea,0xa7457add,0x714c76e7},
	{0xfa160000,0xbe439e70,0xfeef0000,0x397a0000,0x7630024e,0xaf024c1b,0x91fe989e,0xe0d76c09,0x12490000,0xed9b0c30,0x03390000,0x092b0000,0xc0f90272,0x84656224,0x33fc9bb5,0xc9059fff},
	{0x85900000,0x31b59c30,0x45d90000,0xd8a20000,0xb4970350,0xb498c56c,0x4fcca3e4,0x9da7d8c4,0x2d610000,0xbd940e40,0xceef0000,0x03ea0000,0x1a050146,0xa0fdd29d,0x797741a7,0x0c3cc22a},
	{0xbab80000,0x61ba9e40,0x880f0000,0xd2630000,0x6e6b0064,0x900075d5,0x054779f6,0x589e8511,0x6dcf0000,0x626d0e70,0xb80f0000,0xe8f30000,0x025e036c,0x9fffeb53,0xedcea0cf,0xb4752b32},
	{0xe2310000,0x13dba000,0x273b0000,0x610c0000,0xa85b00cc,0x61d8ed92,0x57c2db89,0xe303262c,0xae770000,0x3e581400,0xc22a0000,0x0a6d0000,0x42980227,0x0d1d5762,0x7ae48cf0,0xc89bc118},
	{0xdd190000,0x43d4a270,0xeaed0000,0x6bcd0000,0x72a703f8,0x45405d2b,0x1d49019b,0x263a7bf9,0xeed90000,0xe1a11430,0xb4ca0000,0xe1740000,0x5ac3000d,0x321f6eac,0xee5d6d98,0x70d22800},
	{0xa29f0000,0xcc22a030,0x51db0000,0x8a150000,0xb00002e6,0x5edad45c,0xc37b3ae1,0x5b4acf34,0xd1f10000,0xb1ae1640,0x791c0000,0xebb50000,0x803f0339,0x1687de15,0xa4d6b78a,0xb5eb75d5},
	{0x9db70000,0x9c2da240,0x9c0d0000,0x80d40000,0x6afc01d2,0x7a4264e5,0x89f0e0f3,0x9e7392e1,0x915f0000,0x6e571670,0x0ffc0000,0x00ac0000,0x98640113,0x2985e7db,0x306f56e2,0x0da29ccd},
	{0x39ae0000,0xe2768400,0x84ca0000,0xdbe40000,0x36f60305,0x3de0f02a,0x06d4b4a1,0x9c398623,0x89780000,0xc3cf2800,0xd6280000,0x58da0000,0x460f0391,0xe75f4652,0xf65315f5,0x0e76d6e8},
	{0x06860000,0xb2798670,0x491c0000,0xd1250000,0xec0a0031,0x19784093,0x4c5f6eb3,0x5900dbf6,0xc9d60000,0x1c362830,0xa0c80000,0xb3c30000,0x5e5401bb,0xd85d7f9c,0x62eaf49d,0xb63f3ff0},
	{0x79000000,0x3d8f8430,0xf22a0000,0x30fd0000,0x2ead012f,0x02e2c9e4,0x926d55c9,0x24706f3b,0xf6fe0000,0x4c392a40,0x6d1e0000,0xb9020000,0x84a8028f,0xfcc5cf25,0x28612e8f,0x73066225},
	{0x46280000,0x6d808640,0x3ffc0000,0x3a3c0000,0xf451021b,0x267a795d,0xd8e68fdb,0xe14932ee,0xb6500000,0x93c02a70,0x1bfe0000,0x521b0000,0x9cf300a5,0xc3c7f6eb,0xbcd8cfe7,0xcb4f8b3d},
	{0x1ea10000,0x1fe1b800,0x90c80000,0x89530000,0x326102b3,0xd7a2e11a,0x8a632da4,0x5ad491d3,0x75e80000,0xcff53000,0x61db0000,0xb0850000,0xdc3501ee,0x51254ada,0x2bf2e3d8,0xb7a16117},
	{0x21890000,0x4feeba70,0x5d1e0000,0x83920000,0xe89d0187,0xf33a51a3,0xc0e8f7b6,0x9fedcc06,0x35460000,0x100c3030,0x173b0000,0x5b9c0000,0xc46e03c4,0x6e277314,0xbf4b02b0,0x0fe8880f},
	{0x5e0f0000,0xc018b830,0xe6280000,0x624a0000,0x2a3a0099,0xe8a0d8d4,0x1edacccc,0xe29d78cb,0x0a6e0000,0x40033240,0xdaed0000,0x515d0000,0x1e9200f0,0x4abfc3ad,0xf5c0d8a2,0xcad1d5da},
	{0x61270000,0x9017ba40,0x2bfe0000,0x688b0000,0xf0c603ad,0xcc38686d,0x545116de,0x27a4251e,0x4ac00000,0x9ffa3270,0xac0d0000,0xba440000,0x06c902da,0x75bdfa63,0x617939ca,0x72983cc2},
	{0x83c20000,0x1752c000,0xd8ad0000,0xae150000,0xbb920188,0x5f919e03,0x8a3d6cf6,0xb605dab2,0xdbe40000,0xa4571800,0x3ebc0000,0x334a0000,0x7cd70034,0x14924aff,0x54e5088f,0x80d23e1a},
	{0xbcea0000,0x475dc270,0x157b0000,0xa4d40000,0x616e02bc,0x7b092eba,0xc0b6b6e4,0x733c8767,0x9b4a0000,0x7bae1830,0x485c0000,0xd8530000,0x648c021e,0x2b907331,0xc05ce9e7,0x389bd702},
	{0xc36c0000,0xc8abc030,0xae4d0000,0x450c0000,0xa3c903a2,0x6093a7cd,0x1e848d9e,0x0e4c33aa,0xa4620000,0x2ba11a40,0x858a0000,0xd2920000,0xbe70012a,0x0f08c388,0x8ad733f5,0xfda28ad7},
	{0xfc440000,0x98a4c240,0x639b0000,0x4fcd0000,0x79350096,0x440b1774,0x540f578c,0xcb756e7f,0xe4cc0000,0xf4581a70,0xf36a0000,0x398b0000,0xa62b0300,0x300afa46,0x1e6ed29d,0x45eb63cf},
	{0xa4cd0000,0xeac5fc00,0xccaf0000,0xfca20000,0xbf05003e,0xb5d38f33,0x068af5f3,0x70e8cd42,0x27740000,0xa86d0000,0x894f0000,0xdb150000,0xe6ed024b,0xa2e84677,0x8944fea2,0x390589e5},
	{0x9be50000,0xbacafe70,0x01790000,0xf6630000,0x65f9030a,0x914b3f8a,0x4c012fe1,0xb5d19097,0x67da0000,0x77940030,0xffaf0000,0x300c0000,0xfeb60061,0x9dea7fb9,0x1dfd1fca,0x814c60fd},
	{0xe4630000,0x353cfc30,0xba4f0000,0x17bb0000,0xa75e0214,0x8ad1b6fd,0x9233149b,0xc8a1245a,0x58f20000,0x279b0240,0x32790000,0x3acd0000,0x244a0355,0xb972cf00,0x5776c5d8,0x44753d28},
	{0xdb4b0000,0x6533fe40,0x77990000,0x1d7a0000,0x7da20120,0xae490644,0xd8b8ce89,0x0d98798f,0x185c0000,0xf8620270,0x44990000,0xd1d40000,0x3c11017f,0x8670f6ce,0xc3cf24b0,0xfc3cd430},
	{0x7f520000,0x1b68d800,0x6f5e0000,0x464a0000,0x21a803f7,0xe9eb928b,0x579c9adb,0x0fd26d4d,0x007b0000,0x55fa3c00,0x9d4d0000,0x89a20000,0xe27a03fd,0x48aa5747,0x05f367a7,0xffe89e15},
	{0x407a0000,0x4b67da70,0xa2880000,0x4c8b0000,0xfb5400c3,0xcd732232,0x1d1740c9,0xcaeb3098,0x40d50000,0x8a033c30,0xebad0000,0x62bb0000,0xfa2101d7,0x77a86e89,0x914a86cf,0x47a1770d},
	{0x3ffc0000,0xc491d830,0x19be0000,0xad530000,0x39f301dd,0xd6e9ab45,0xc3257bb3,0xb79b8455,0x7ffd0000,0xda0c3e40,0x267b0000,0x687a0000,0x20dd02e3,0x5330de30,0xdbc15cdd,0x82982ad8},
	{0x00d40000,0x949eda40,0xd4680000,0xa7920000,0xe30f02e9,0xf2711bfc,0x89aea1a1,0x72a2d980,0x3f530000,0x05f53e70,0x509b0000,0x83630000,0x388600c9,0x6c32e7fe,0x4f78bdb5,0x3ad1c3c0},
	{0x585d0000,0xe6ffe400,0x7b5c0000,0x14fd0000,0x253f0241,0x03a983bb,0xdb2b03de,0xc93f7abd,0xfceb0000,0x59c02400,0x2abe0000,0x61fd0000,0x78400182,0xfed05bcf,0xd852918a,0x463f29ea},
	{0x67750000,0xb6f0e670,0xb68a0000,0x1e3c0000,0xffc30175,0x27313302,0x91a0d9cc,0x0c062768,0xbc450000,0x86392430,0x5c5e0000,0x8ae40000,0x601b03a8,0xc1d26201,0x4ceb70e2,0xfe76c0f2},
	{0x18f30000,0x3906e430,0x0dbc0000,0xffe40000,0x3d64006b,0x3cabba75,0x4f92e2b6,0x717693a5,0x836d0000,0xd6362640,0x91880000,0x80250000,0xbae7009c,0xe54ad2b8,0x0660aaf0,0x3b4f9d27},
	{0x27db0000,0x6909e640,0xc06a0000,0xf5250000,0xe798035f,0x18330acc,0x051938a4,0xb44fce70,0xc3c30000,0x09cf2670,0xe7680000,0x6b3c0000,0xa2bc02b6,0xda48eb76,0x92d94b98,0x8306743f},
	{0x4c3d0000,0x78798800,0x785c0000,0xe2c30000,0x08b90116,0x246fedb7,0x28d530de,0xd4707921,0x9d180000,0x5d494400,0xd5280000,0xaee40000,0x6b8900c6,0xc099285e,0x05ad26f5,0x1339d574},
	{0x73150000,0x28768a70,0xb58a0000,0xe8020000,0xd2450222,0x00f75d0e,0x625eeacc,0x114924f4,0xddb60000,0x82b04430,0xa3c80000,0x45fd0000,0x73d202ec,0xff9b1190,0x9114c79d,0xab703c6c},
	{0x0c930000,0xa7808830,0x0ebc0000,0x09da0000,0x10e2033c,0x1b6dd479,0xbc6cd1b6,0x6c399039,0xe29e0000,0xd2bf4640,0x6e1e0000,0x4f3c0000,0xa92e01d8,0xdb03a129,0xdb9f1d8f,0x6e4961b9},
	{0x33bb0000,0xf78f8a40,0xc36a0000,0x031b0000,0xca1e0008,0x3ff564c0,0xf6e70ba4,0xa900cdec,0xa2300000,0x0d464670,0x18fe0000,0xa4250000,0xb17503f2,0xe40198e7,0x4f26fce7,0xd60088a1},
	{0x6b320000,0x85eeb400,0x6c5e0000,0xb0740000,0x0c2e00a0,0xce2dfc87,0xa462a9db,0x129d6ed1,0x61880000,0x51735c00,0x62db0000,0x46bb0000,0xf1b302b9,0x76e324d6,0xd80cd0d8,0xaaee628b},
	{0x541a0000,0xd5e1b670,0xa1880000,0xbab50000,0xd6d20394,0xeab54c3e,0xeee973c9,0xd7a43304,0x21260000,0x8e8a5c30,0x143b0000,0xada20000,0xe9e80093,0x49e11d18,0x4cb531b0,0x12a78b93},
	{0x2b9c0000,0x5a17b430,0x1abe0000,0x5b6d0000,0x1475028a,0xf12fc549,0x30db48b3,0xaad487c9,0x1e0e0000,0xde855e40,0xd9ed0000,0xa7630000,0x331403a7,0x6d79ada1,0x063eeba2,0xd79ed646},
	{0x14b40000,0x0a18b640,0xd7680000,0x51ac0000,0xce8901be,0xd5b775f0,0x7a5092a1,0x6fedda1c,0x5ea00000,0x017c5e70,0xaf0d0000,0x4c7a0000,0x2b4f018d,0x527b946f,0x92870aca,0x6fd73f5e},
	{0xb0ad0000,0x74439000,0xcfaf0000,0x0a9c0000,0x92830369,0x9215e13f,0xf574c6f3,0x6da7cede,0x46870000,0xace46000,0x76d90000,0x140c0000,0xf524030f,0x9ca135e6,0x54bb49dd,0x6c03757b},
	{0x8f850000,0x244c9270,0x02790000,0x005d0000,0x487f005d,0xb68d5186,0xbfff1ce1,0xa89e930b,0x06290000,0x731d6030,0x00390000,0xff150000,0xed7f0125,0xa3a30c28,0xc002a8b5,0xd44a9c63},
	{0xf0030000,0xabba9030,0xb94f0000,0xe1850000,0x8ad80143,0xad17d8f1,0x61cd279b,0xd5ee27c6,0x39010000,0x23126240,0xcdef0000,0xf5d40000,0x37830211,0x873bbc91,0x8a8972a7,0x1173c1b6},
	{0xcf2b0000,0xfbb59240,0x74990000,0xeb440000,0x50240277,0x898f6848,0x2b46fd89,0x10d77a13,0x79af0000,0xfceb6270,0xbb0f0000,0x1ecd0000,0x2fd8003b,0xb839855f,0x1e3093cf,0xa93a28ae},
	{0x97a20000,0x89d4ac00,0xdbad0000,0x582b0000,0x961402df,0x7857f00f,0x79c35ff6,0xab4ad92e,0xba170000,0xa0de7800,0xc12a0000,0xfc530000,0x6f1e0170,0x2adb396e,0x891abff0,0xd5d4c284},
	{0xa88a0000,0xd9dbae70,0x167b0000,0x52ea0000,0x4ce801eb,0x5ccf40b6,0x334885e4,0x6e7384fb,0xfab90000,0x7f277830,0xb7ca0000,0x174a0000,0x7745035a,0x15d900a0,0x1da35e98,0x6d9d2b9c},
	{0xd70c0000,0x562dac30,0xad4d0000,0xb3320000,0x8e4f00f5,0x4755c9c1,0xed7abe9e,0x13033036,0xc5910000,0x2f287a40,0x7a1c0000,0x1d8b0000,0xadb9006e,0x3141b019,0x5728848a,0xa8a47649},
	{0xe8240000,0x0622ae40,0x609b0000,0xb9f30000,0x54b303c1,0x63cd7978,0xa7f1648c,0xd63a6de3,0x853f0000,0xf0d17a70,0x0cfc0000,0xf6920000,0xb5e20244,0x0e4389d7,0xc39165e2,0x10ed9f51},
	{0x0ac10000,0x8167d400,0x93c80000,0x7f6d0000,0x1fe701e4,0xf0648f16,0x799d1ea4,0x479b924f,0x141b0000,0xcb7c5000,0x9e4d0000,0x7f9c0000,0xcffc00aa,0x6f6c394b,0xf60d54a7,0xe2a79d89},
	{0x35e90000,0xd168d670,0x5e1e0000,0x75ac0000,0xc51b02d0,0xd4fc3faf,0x3316c4b6,0x82a2cf9a,0x54b50000,0x14855030,0xe8ad0000,0x94850000,0xd7a70280,0x506e0085,0x62b4b5cf,0x5aee7491},
	{0x4a6f0000,0x5e9ed430,0xe5280000,0x94740000,0x07bc03ce,0xcf66b6d8,0xed24ffcc,0xffd27b57,0x6b9d0000,0x448a5240,0x257b0000,0x9e440000,0x0d5b01b4,0x74f6b03c,0x283f6fdd,0x9fd72944},
	{0x75470000,0x0e91d640,0x28fe0000,0x9eb50000,0xdd4000fa,0xebfe0661,0xa7af25de,0x3aeb2682,0x2b330000,0x9b735270,0x539b0000,0x755d0000,0x1500039e,0x4bf489f2,0xbc868eb5,0x279ec05c},
	{0x2dce0000,0x7cf0e800,0x87ca0000,0x2dda0000,0x1b700052,0x1a269e26,0xf52a87a1,0x817685bf,0xe88b0000,0xc7464800,0x29be0000,0x97c30000,0x55c602d5,0xd91635c3,0x2baca28a,0x5b702a76},
	{0x12e60000,0x2cffea70,0x4a1c0000,0x271b0000,0xc18c0366,0x3ebe2e9f,0xbfa15db3,0x444fd86a,0xa8250000,0x18bf4830,0x5f5e0000,0x7cda0000,0x4d9d00ff,0xe6140c0d,0xbf1543e2,0xe339c36e},
	{0x6d600000,0xa309e830,0xf12a0000,0xc6c30000,0x032b0278,0x2524a7e8,0x619366c9,0x393f6ca7,0x970d0000,0x48b04a40,0x92880000,0x761b0000,0x976103cb,0xc28cbcb4,0xf59e99f0,0x26009ebb},
	{0x52480000,0xf306ea40,0x3cfc0000,0xcc020000,0xd9d7014c,0x01bc1751,0x2b18bcdb,0xfc063172,0xd7a30000,0x97494a70,0xe4680000,0x9d020000,0x8f3a01e1,0xfd8e857a,0x61277898,0x9e4977a3},
	{0xf6510000,0x8d5dcc00,0x243b0000,0x97320000,0x85dd039b,0x461e839e,0xa43ce889,0xfe4c25b0,0xcf840000,0x3ad17400,0x3dbc0000,0xc5740000,0x51510363,0x335424f3,0xa71b3b8f,0x9d9d3d86},
	{0xc9790000,0xdd52ce70,0xe9ed0000,0x9df30000,0x5f2100af,0x62863327,0xeeb7329b,0x3b757865,0x8f2a0000,0xe5287430,0x4b5c0000,0x2e6d0000,0x490a0149,0x0c561d3d,0x33a2dae7,0x25d4d49e},
	{0xb6ff0000,0x52a4cc30,0x52db0000,0x7c2b0000,0x9d8601b1,0x791cba50,0x308509e1,0x4605cca8,0xb0020000,0xb5277640,0x868a0000,0x24ac0000,0x93f6027d,0x28cead84,0x792900f5,0xe0ed894b},
	{0x89d70000,0x02abce40,0x9f0d0000,0x76ea0000,0x477a0285,0x5d840ae9,0x7a0ed3f3,0x833c917d,0xf0ac0000,0x6ade7670,0xf06a0000,0xcfb50000,0x8bad0057,0x17cc944a,0xed90e19d,0x58a46053},
	{0xd15e0000,0x70caf000,0x30390000,0xc5850000,0x814a022d,0xac5c92ae,0x288b718c,0x38a13240,0x33140000,0x36eb6c00,0x8a4f0000,0x2d2b0000,0xcb6b011c,0x852e287b,0x7abacda2,0x244a8a79},
	{0xee760000,0x20c5f270,0xfdef0000,0xcf440000,0x5bb60119,0x88c42217,0x6200ab9e,0xfd986f95,0x73ba0000,0xe9126c30,0xfcaf0000,0xc6320000,0xd3300336,0xba2c11b5,0xee032cca,0x9c036361},
	{0x91f00000,0xaf33f030,0x46d90000,0x2e9c0000,0x99110007,0x935eab60,0xbc3290e4,0x80e8db58,0x4c920000,0xb91d6e40,0x31790000,0xccf30000,0x09cc0002,0x9eb4a10c,0xa488f6d8,0x593a3eb4},
	{0xaed80000,0xff3cf240,0x8b0f0000,0x245d0000,0x43ed0333,0xb7c61bd9,0xf6b94af6,0x45d1868d,0x0c3c0000,0x66e46e70,0x47990000,0x27ea0000,0x11970228,0xa1b698c2,0x303117b0,0xe173d7ac},
	{0x52e70000,0x32620c00,0x75d90000,0xe2320000,0xd8a20058,0xbb675bea,0xa7457add,0x714c76e7,0x97d90000,0xdc2e9000,0x46e00000,0xd1890000,0x746e0122,0x30fda748,0x7c303851,0x54a2473b},
	{0x6dcf0000,0x626d0e70,0xb80f0000,0xe8f30000,0x025e036c,0x9fffeb53,0xedcea0cf,0xb4752b32,0xd7770000,0x03d79030,0x30000000,0x3a900000,0x6c350308,0x0fff9e86,0xe889d939,0xecebae23},
	{0x12490000,0xed9b0c30,0x03390000,0x092b0000,0xc0f90272,0x84656224,0x33fc9bb5,0xc9059fff,0xe85f0000,0x53d89240,0xfdd60000,0x30510000,0xb6c9003c,0x2b672e3f,0xa202032b,0x29d2f3f6},
	{0x2d610000,0xbd940e40,0xceef0000,0x03ea0000,0x1a050146,0xa0fdd29d,0x797741a7,0x0c3cc22a,0xa8f10000,0x8c219270,0x8b360000,0xdb480000,0xae920216,0x146517f1,0x36bbe243,0x919b1aee},
	{0x75e80000,0xcff53000,0x61db0000,0xb0850000,0xdc3501ee,0x51254ada,0x2bf2e3d8,0xb7a16117,0x6b490000,0xd0148800,0xf1130000,0x39d60000,0xee54035d,0x8687abc0,0xa191ce7c,0xed75f0c4},
	{0x4ac00000,0x9ffa3270,0xac0d0000,0xba440000,0x06c902da,0x75bdfa63,0x617939ca,0x72983cc2,0x2be70000,0x0fed8830,0x87f30000,0xd2cf0000,0xf60f0177,0xb985920e,0x35282f14,0x553c19dc},
	{0x35460000,0x100c3030,0x173b0000,0x5b9c0000,0xc46e03c4,0x6e277314,0xbf4b02b0,0x0fe8880f,0x14cf0000,0x5fe28a40,0x4a250000,0xd80e0000,0x2cf30243,0x9d1d22b7,0x7fa3f506,0x90054409},
	{0x0a6e0000,0x40033240,0xdaed0000,0x515d0000,0x1e9200f0,0x4abfc3ad,0xf5c0d8a2,0xcad1d5da,0x54610000,0x801b8a70,0x3cc50000,0x33170000,0x34a80069,0xa21f1b79,0xeb1a146e,0x284cad11},
	{0xae770000,0x3e581400,0xc22a0000,0x0a6d0000,0x42980227,0x0d1d5762,0x7ae48cf0,0xc89bc118,0x4c460000,0x2d83b400,0xe5110000,0x6b610000,0xeac302eb,0x6cc5baf0,0x2d265779,0x2b98e734},
	{0x915f0000,0x6e571670,0x0ffc0000,0x00ac0000,0x98640113,0x2985e7db,0x306f56e2,0x0da29ccd,0x0ce80000,0xf27ab430,0x93f10000,0x80780000,0xf29800c1,0x53c7833e,0xb99fb611,0x93d10e2c},
	{0xeed90000,0xe1a11430,0xb4ca0000,0xe1740000,0x5ac3000d,0x321f6eac,0xee5d6d98,0x70d22800,0x33c00000,0xa275b640,0x5e270000,0x8ab90000,0x286403f5,0x775f3387,0xf3146c03,0x56e853f9},
	{0xd1f10000,0xb1ae1640,0x791c0000,0xebb50000,0x803f0339,0x1687de15,0xa4d6b78a,0xb5eb75d5,0x736e0000,0x7d8cb670,0x28c70000,0x61a00000,0x303f01df,0x485d0a49,0x67ad8d6b,0xeea1bae1},
	{0x89780000,0xc3cf2800,0xd6280000,0x58da0000,0x460f0391,0xe75f4652,0xf65315f5,0x0e76d6e8,0xb0d60000,0x21b9ac00,0x52e20000,0x833e0000,0x70f90094,0xdabfb678,0xf087a154,0x924f50cb},
	{0xb6500000,0x93c02a70,0x1bfe0000,0x521b0000,0x9cf300a5,0xc3c7f6eb,0xbcd8cfe7,0xcb4f8b3d,0xf0780000,0xfe40ac30,0x24020000,0x68270000,0x68a202be,0xe5bd8fb6,0x643e403c,0x2a06b9d3},
	{0xc9d60000,0x1c362830,0xa0c80000,0xb3c30000,0x5e5401bb,0xd85d7f9c,0x62eaf49d,0xb63f3ff0,0xcf500000,0xae4fae40,0xe9d40000,0x62e60000,0xb25e018a,0xc1253f0f,0x2eb59a2e,0xef3fe406},
	{0xf6fe0000,0x4c392a40,0x6d1e0000,0xb9020000,0x84a8028f,0xfcc5cf25,0x28612e8f,0x73066225,0x8ffe0000,0x71b6ae70,0x9f340000,0x89ff0000,0xaa0503a0,0xfe2706c1,0xba0c7b46,0x57760d1e},
	{0x141b0000,0xcb7c5000,0x9e4d0000,0x7f9c0000,0xcffc00aa,0x6f6c394b,0xf60d54a7,0xe2a79d89,0x1eda0000,0x4a1b8400,0x0d850000,0x00f10000,0xd01b014e,0x9f08b65d,0x8f904a03,0xa53c0fc6},
	{0x2b330000,0x9b735270,0x539b0000,0x755d0000,0x1500039e,0x4bf489f2,0xbc868eb5,0x279ec05c,0x5e740000,0x95e28430,0x7b650000,0xebe80000,0xc8400364,0xa00a8f93,0x1b29ab6b,0x1d75e6de},
	{0x54b50000,0x14855030,0xe8ad0000,0x94850000,0xd7a70280,0x506e0085,0x62b4b5cf,0x5aee7491,0x615c0000,0xc5ed8640,0xb6b30000,0xe1290000,0x12bc0050,0x84923f2a,0x51a27179,0xd84cbb0b},
	{0x6b9d0000,0x448a5240,0x257b0000,0x9e440000,0x0d5b01b4,0x74f6b03c,0x283f6fdd,0x9fd72944,0x21f20000,0x1a148670,0xc0530000,0x0a300000,0x0ae7027a,0xbb9006e4,0xc51b9011,0x60055213},
	{0x33140000,0x36eb6c00,0x8a4f0000,0x2d2b0000,0xcb6b011c,0x852e287b,0x7abacda2,0x244a8a79,0xe24a0000,0x46219c00,0xba760000,0xe8ae0000,0x4a210331,0x2972bad5,0x5231bc2e,0x1cebb839},
	{0x0c3c0000,0x66e46e70,0x47990000,0x27ea0000,0x11970228,0xa1b698c2,0x303117b0,0xe173d7ac,0xa2e40000,0x99d89c30,0xcc960000,0x03b70000,0x527a011b,0x1670831b,0xc6885d46,0xa4a25121},
	{0x73ba0000,0xe9126c30,0xfcaf0000,0xc6320000,0xd3300336,0xba2c11b5,0xee032cca,0x9c036361,0x9dcc0000,0xc9d79e40,0x01400000,0x09760000,0x8886022f,0x32e833a2,0x8c038754,0x619b0cf4},
	{0x4c920000,0xb91d6e40,0x31790000,0xccf30000,0x09cc0002,0x9eb4a10c,0xa488f6d8,0x593a3eb4,0xdd620000,0x162e9e70,0x77a00000,0xe26f0000,0x90dd0005,0x0dea0a6c,0x18ba663c,0xd9d2e5ec},
	{0xe88b0000,0xc7464800,0x29be0000,0x97c30000,0x55c602d5,0xd91635c3,0x2baca28a,0x5b702a76,0xc5450000,0xbbb6a000,0xae740000,0xba190000,0x4eb60287,0xc330abe5,0xde86252b,0xda06afc9},
	{0xd7a30000,0x97494a70,0xe4680000,0x9d020000,0x8f3a01e1,0xfd8e857a,0x61277898,0x9e4977a3,0x85eb0000,0x644fa030,0xd8940000,0x51000000,0x56ed00ad,0xfc32922b,0x4a3fc443,0x624f46d1},
	{0xa8250000,0x18bf4830,0x5f5e0000,0x7cda0000,0x4d9d00ff,0xe6140c0d,0xbf1543e2,0xe339c36e,0xbac30000,0x3440a240,0x15420000,0x5bc10000,0x8c110399,0xd8aa2292,0x00b41e51,0xa7761b04},
	{0x970d0000,0x48b04a40,0x92880000,0x761b0000,0x976103cb,0xc28cbcb4,0xf59e99f0,0x26009ebb,0xfa6d0000,0xebb9a270,0x63a20000,0xb0d80000,0x944a01b3,0xe7a81b5c,0x940dff39,0x1f3ff21c},
	{0xcf840000,0x3ad17400,0x3dbc0000,0xc5740000,0x51510363,0x335424f3,0xa71b3b8f,0x9d9d3d86,0x39d50000,0xb78cb800,0x19870000,0x52460000,0xd48c00f8,0x754aa76d,0x0327d306,0x63d11836},
	{0xf0ac0000,0x6ade7670,0xf06a0000,0xcfb50000,0x8bad0057,0x17cc944a,0xed90e19d,0x58a46053,0x797b0000,0x6875b830,0x6f670000,0xb95f0000,0xccd702d2,0x4a489ea3,0x979e326e,0xdb98f12e},
	{0x8f2a0000,0xe5287430,0x4b5c0000,0x2e6d0000,0x490a0149,0x0c561d3d,0x33a2dae7,0x25d4d49e,0x46530000,0x387aba40,0xa2b10000,0xb39e0000,0x162b01e6,0x6ed02e1a,0xdd15e87c,0x1ea1acfb},
	{0xb0020000,0xb5277640,0x868a0000,0x24ac0000,0x93f6027d,0x28cead84,0x792900f5,0xe0ed894b,0x06fd0000,0xe783ba70,0xd4510000,0x58870000,0x0e7003cc,0x51d217d4,0x49ac0914,0xa6e845e3},
	{0xdbe40000,0xa4571800,0x3ebc0000,0x334a0000,0x7cd70034,0x14924aff,0x54e5088f,0x80d23e1a,0x58260000,0xb305d800,0xe6110000,0x9d5f0000,0xc74501bc,0x4b03d4fc,0xded86479,0x36d7e4a8},
	{0xe4cc0000,0xf4581a70,0xf36a0000,0x398b0000,0xa62b0300,0x300afa46,0x1e6ed29d,0x45eb63cf,0x18880000,0x6cfcd830,0x90f10000,0x76460000,0xdf1e0396,0x7401ed32,0x4a618511,0x8e9e0db0},
	{0x9b4a0000,0x7bae1830,0x485c0000,0xd8530000,0x648c021e,0x2b907331,0xc05ce9e7,0x389bd702,0x27a00000,0x3cf3da40,0x5d270000,0x7c870000,0x05e200a2,0x50995d8b,0x00ea5f03,0x4ba75065},
	{0xa4620000,0x2ba11a40,0x858a0000,0xd2920000,0xbe70012a,0x0f08c388,0x8ad733f5,0xfda28ad7,0x670e0000,0xe30ada70,0x2bc70000,0x979e0000,0x1db90288,0x6f9b6445,0x9453be6b,0xf3eeb97d},
	{0xfceb0000,0x59c02400,0x2abe0000,0x61fd0000,0x78400182,0xfed05bcf,0xd852918a,0x463f29ea,0xa4b60000,0xbf3fc000,0x51e20000,0x75000000,0x5d7f03c3,0xfd79d874,0x03799254,0x8f005357},
	{0xc3c30000,0x09cf2670,0xe7680000,0x6b3c0000,0xa2bc02b6,0xda48eb76,0x92d94b98,0x8306743f,0xe4180000,0x60c6c030,0x27020000,0x9e190000,0x452401e9,0xc27be1ba,0x97c0733c,0x3749ba4f},
	{0xbc450000,0x86392430,0x5c5e0000,0x8ae40000,0x601b03a8,0xc1d26201,0x4ceb70e2,0xfe76c0f2,0xdb300000,0x30c9c240,0xead40000,0x94d80000,0x9fd802dd,0xe6e35103,0xdd4ba92e,0xf270e79a},
	{0x836d0000,0xd6362640,0x91880000,0x80250000,0xbae7009c,0xe54ad2b8,0x0660aaf0,0x3b4f9d27,0x9b9e0000,0xef30c270,0x9c340000,0x7fc10000,0x878300f7,0xd9e168cd,0x49f24846,0x4a390e82},
	{0x27740000,0xa86d0000,0x894f0000,0xdb150000,0xe6ed024b,0xa2e84677,0x8944fea2,0x390589e5,0x83b90000,0x42a8fc00,0x45e00000,0x27b70000,0x59e80275,0x173bc944,0x8fce0b51,0x49ed44a7},
	{0x185c0000,0xf8620270,0x44990000,0xd1d40000,0x3c11017f,0x8670f6ce,0xc3cf24b0,0xfc3cd430,0xc3170000,0x9d51fc30,0x33000000,0xccae0000,0x41b3005f,0x2839f08a,0x1b77ea39,0xf1a4adbf},
	{0x67da0000,0x77940030,0xffaf0000,0x300c0000,0xfeb60061,0x9dea7fb9,0x1dfd1fca,0x814c60fd,0xfc3f0000,0xcd5efe40,0xfed60000,0xc66f0000,0x9b4f036b,0x0ca14033,0x51fc302b,0x349df06a},
	{0x58f20000,0x279b0240,0x32790000,0x3acd0000,0x244a0355,0xb972cf00,0x5776c5d8,0x44753d28,0xbc910000,0x12a7fe70,0x88360000,0x2d760000,0x83140141,0x33a379fd,0xc545d143,0x8cd41972},
	{0x007b0000,0x55fa3c00,0x9d4d0000,0x89a20000,0xe27a03fd,0x48aa5747,0x05f367a7,0xffe89e15,0x7f290000,0x4e92e400,0xf2130000,0xcfe80000,0xc3d2000a,0xa141c5cc,0x526ffd7c,0xf03af358},
	{0x3f530000,0x05f53e70,0x509b0000,0x83630000,0x388600c9,0x6c32e7fe,0x4f78bdb5,0x3ad1c3c0,0x3f870000,0x916be430,0x84f30000,0x24f10000,0xdb890220,0x9e43fc02,0xc6d61c14,0x48731a40},
	{0x40d50000,0x8a033c30,0xebad0000,0x62bb0000,0xfa2101d7,0x77a86e89,0x914a86cf,0x47a1770d,0x00af0000,0xc164e640,0x49250000,0x2e300000,0x01750114,0xbadb4cbb,0x8c5dc606,0x8d4a4795},
	{0x7ffd0000,0xda0c3e40,0x267b0000,0x687a0000,0x20dd02e3,0x5330de30,0xdbc15cdd,0x82982ad8,0x40010000,0x1e9de670,0x3fc50000,0xc5290000,0x192e033e,0x85d97575,0x18e4276e,0x3503ae8d},
	{0x9d180000,0x5d494400,0xd5280000,0xaee40000,0x6b8900c6,0xc099285e,0x05ad26f5,0x1339d574,0xd1250000,0x2530cc00,0xad740000,0x4c270000,0x633001d0,0xe4f6c5e9,0x2d78162b,0xc749ac55},
	{0xa2300000,0x0d464670,0x18fe0000,0xa4250000,0xb17503f2,0xe40198e7,0x4f26fce7,0xd60088a1,0x918b0000,0xfac9cc30,0xdb940000,0xa73e0000,0x7b6b03fa,0xdbf4fc27,0xb9c1f743,0x7f00454d},
	{0xddb60000,0x82b04430,0xa3c80000,0x45fd0000,0x73d202ec,0xff9b1190,0x9114c79d,0xab703c6c,0xaea30000,0xaac6ce40,0x16420000,0xadff0000,0xa19700ce,0xff6c4c9e,0xf34a2d51,0xba391898},
	{0xe29e0000,0xd2bf4640,0x6e1e0000,0x4f3c0000,0xa92e01d8,0xdb03a129,0xdb9f1d8f,0x6e4961b9,0xee0d0000,0x753fce70,0x60a20000,0x46e60000,0xb9cc02e4,0xc06e7550,0x67f3cc39,0x0270f180},
	{0xba170000,0xa0de7800,0xc12a0000,0xfc530000,0x6f1e0170,0x2adb396e,0x891abff0,0xd5d4c284,0x2db50000,0x290ad400,0x1a870000,0xa4780000,0xf90a03af,0x528cc961,0xf0d9e006,0x7e9e1baa},
	{0x853f0000,0xf0d17a70,0x0cfc0000,0xf6920000,0xb5e20244,0x0e4389d7,0xc39165e2,0x10ed9f51,0x6d1b0000,0xf6f3d430,0x6c670000,0x4f610000,0xe1510185,0x6d8ef0af,0x6460016e,0xc6d7f2b2},
	{0xfab90000,0x7f277830,0xb7ca0000,0x174a0000,0x7745035a,0x15d900a0,0x1da35e98,0x6d9d2b9c,0x52330000,0xa6fcd640,0xa1b10000,0x45a00000,0x3bad02b1,0x49164016,0x2eebdb7c,0x03eeaf67},
	{0xc5910000,0x2f287a40,0x7a1c0000,0x1d8b0000,0xadb9006e,0x3141b019,0x5728848a,0xa8a47649,0x129d0000,0x7905d670,0xd7510000,0xaeb90000,0x23f6009b,0x761479d8,0xba523a14,0xbba7467f},
	{0x61880000,0x51735c00,0x62db0000,0x46bb0000,0xf1b302b9,0x76e324d6,0xd80cd0d8,0xaaee628b,0x0aba0000,0xd49de800,0x0e850000,0xf6cf0000,0xfd9d0219,0xb8ced851,0x7c6e7903,0xb8730c5a},
	{0x5ea00000,0x017c5e70,0xaf0d0000,0x4c7a0000,0x2b4f018d,0x527b946f,0x92870aca,0x6fd73f5e,0x4a140000,0x0b64e830,0x78650000,0x1dd60000,0xe5c60033,0x87cce19f,0xe8d7986b,0x003ae542},
	{0x21260000,0x8e8a5c30,0x143b0000,0xada20000,0xe9e80093,0x49e11d18,0x4cb531b0,0x12a78b93,0x753c0000,0x5b6bea40,0xb5b30000,0x17170000,0x3f3a0307,0xa3545126,0xa25c4279,0xc503b897},
	{0x1e0e0000,0xde855e40,0xd9ed0000,0xa7630000,0x331403a7,0x6d79ada1,0x063eeba2,0xd79ed646,0x35920000,0x8492ea70,0xc3530000,0xfc0e0000,0x2761012d,0x9c5668e8,0x36e5a311,0x7d4a518f},
	{0x46870000,0xace46000,0x76d90000,0x140c0000,0xf524030f,0x9ca135e6,0x54bb49dd,0x6c03757b,0xf62a0000,0xd8a7f000,0xb9760000,0x1e900000,0x67a70066,0x0eb4d4d9,0xa1cf8f2e,0x01a4bba5},
	{0x79af0000,0xfceb6270,0xbb0f0000,0x1ecd0000,0x2fd8003b,0xb839855f,0x1e3093cf,0xa93a28ae,0xb6840000,0x075ef030,0xcf960000,0xf5890000,0x7ffc024c,0x31b6ed17,0x35766e46,0xb9ed52bd},
	{0x06290000,0x731d6030,0x00390000,0xff150000,0xed7f0125,0xa3a30c28,0xc002a8b5,0xd44a9c63,0x89ac0000,0x5751f240,0x02400000,0xff480000,0xa5000178,0x152e5dae,0x7ffdb454,0x7cd40f68},
	{0x39010000,0x23126240,0xcdef0000,0xf5d40000,0x37830211,0x873bbc91,0x8a8972a7,0x1173c1b6,0xc9020000,0x88a8f270,0x74a00000,0x14510000,0xbd5b0352,0x2a2c6460,0xeb44553c,0xc49de670},
	{0x97d90000,0xdc2e9000,0x46e00000,0xd1890000,0x746e0122,0x30fda748,0x7c303851,0x54a2473b,0xc53e0000,0xee4c9c00,0x33390000,0x33bb0000,0xaccc017a,0x8b9afca2,0xdb75428c,0x25ee31dc},
	{0xa8f10000,0x8c219270,0x8b360000,0xdb480000,0xae920216,0x146517f1,0x36bbe243,0x919b1aee,0x85900000,0x31b59c30,0x45d90000,0xd8a20000,0xb4970350,0xb498c56c,0x4fcca3e4,0x9da7d8c4},
	{0xd7770000,0x03d79030,0x30000000,0x3a900000,0x6c350308,0x0fff9e86,0xe889d939,0xecebae23,0xbab80000,0x61ba9e40,0x880f0000,0xd2630000,0x6e6b0064,0x900075d5,0x054779f6,0x589e8511},
	{0xe85f0000,0x53d89240,0xfdd60000,0x30510000,0xb6c9003c,0x2b672e3f,0xa202032b,0x29d2f3f6,0xfa160000,0xbe439e70,0xfeef0000,0x397a0000,0x7630024e,0xaf024c1b,0x91fe989e,0xe0d76c09},
	{0xb0d60000,0x21b9ac00,0x52e20000,0x833e0000,0x70f90094,0xdabfb678,0xf087a154,0x924f50cb,0x39ae0000,0xe2768400,0x84ca0000,0xdbe40000,0x36f60305,0x3de0f02a,0x06d4b4a1,0x9c398623},
	{0x8ffe0000,0x71b6ae70,0x9f340000,0x89ff0000,0xaa0503a0,0xfe2706c1,0xba0c7b46,0x57760d1e,0x79000000,0x3d8f8430,0xf22a0000,0x30fd0000,0x2ead012f,0x02e2c9e4,0x926d55c9,0x24706f3b},
	{0xf0780000,0xfe40ac30,0x24020000,0x68270000,0x68a202be,0xe5bd8fb6,0x643e403c,0x2a06b9d3,0x46280000,0x6d808640,0x3ffc0000,0x3a3c0000,0xf451021b,0x267a795d,0xd8e68fdb,0xe14932ee},
	{0xcf500000,0xae4fae40,0xe9d40000,0x62e60000,0xb25e018a,0xc1253f0f,0x2eb59a2e,0xef3fe406,0x06860000,0xb2798670,0x491c0000,0xd1250000,0xec0a0031,0x19784093,0x4c5f6eb3,0x5900dbf6},
	{0x6b490000,0xd0148800,0xf1130000,0x39d60000,0xee54035d,0x8687abc0,0xa191ce7c,0xed75f0c4,0x1ea10000,0x1fe1b800,0x90c80000,0x89530000,0x326102b3,0xd7a2e11a,0x8a632da4,0x5ad491d3},
	{0x54610000,0x801b8a70,0x3cc50000,0x33170000,0x34a80069,0xa21f1b79,0xeb1a146e,0x284cad11,0x5e0f0000,0xc018b830,0xe6280000,0x624a0000,0x2a3a0099,0xe8a0d8d4,0x1edacccc,0xe29d78cb},
	{0x2be70000,0x0fed8830,0x87f30000,0xd2cf0000,0xf60f0177,0xb985920e,0x35282f14,0x553c19dc,0x61270000,0x9017ba40,0x2bfe0000,0x688b0000,0xf0c603ad,0xcc38686d,0x545116de,0x27a4251e},
	{0x14cf0000,0x5fe28a40,0x4a250000,0xd80e0000,0x2cf30243,0x9d1d22b7,0x7fa3f506,0x90054409,0x21890000,0x4feeba70,0x5d1e0000,0x83920000,0xe89d0187,0xf33a51a3,0xc0e8f7b6,0x9fedcc06},
	{0x4c460000,0x2d83b400,0xe5110000,0x6b610000,0xeac302eb,0x6cc5baf0,0x2d265779,0x2b98e734,0xe2310000,0x13dba000,0x273b0000,0x610c0000,0xa85b00cc,0x61d8ed92,0x57c2db89,0xe303262c},
	{0x736e0000,0x7d8cb670,0x28c70000,0x61a00000,0x303f01df,0x485d0a49,0x67ad8d6b,0xeea1bae1,0xa29f0000,0xcc22a030,0x51db0000,0x8a150000,0xb00002e6,0x5edad45c,0xc37b3ae1,0x5b4acf34},
	{0x0ce80000,0xf27ab430,0x93f10000,0x80780000,0xf29800c1,0x53c7833e,0xb99fb611,0x93d10e2c,0x9db70000,0x9c2da240,0x9c0d0000,0x80d40000,0x6afc01d2,0x7a4264e5,0x89f0e0f3,0x9e7392e1},
	{0x33c00000,0xa275b640,0x5e270000,0x8ab90000,0x286403f5,0x775f3387,0xf3146c03,0x56e853f9,0xdd190000,0x43d4a270,0xeaed0000,0x6bcd0000,0x72a703f8,0x45405d2b,0x1d49019b,0x263a7bf9},
	{0xd1250000,0x2530cc00,0xad740000,0x4c270000,0x633001d0,0xe4f6c5e9,0x2d78162b,0xc749ac55,0x4c3d0000,0x78798800,0x785c0000,0xe2c30000,0x08b90116,0x246fedb7,0x28d530de,0xd4707921},
	{0xee0d0000,0x753fce70,0x60a20000,0x46e60000,0xb9cc02e4,0xc06e7550,0x67f3cc39,0x0270f180,0x0c930000,0xa7808830,0x0ebc0000,0x09da0000,0x10e2033c,0x1b6dd479,0xbc6cd1b6,0x6c399039},
	{0x918b0000,0xfac9cc30,0xdb940000,0xa73e0000,0x7b6b03fa,0xdbf4fc27,0xb9c1f743,0x7f00454d,0x33bb0000,0xf78f8a40,0xc36a0000,0x031b0000,0xca1e0008,0x3ff564c0,0xf6e70ba4,0xa900cdec},
	{0xaea30000,0xaac6ce40,0x16420000,0xadff0000,0xa19700ce,0xff6c4c9e,0xf34a2d51,0xba391898,0x73150000,0x28768a70,0xb58a0000,0xe8020000,0xd2450222,0x00f75d0e,0x625eeacc,0x114924f4},
	{0xf62a0000,0xd8a7f000,0xb9760000,0x1e900000,0x67a70066,0x0eb4d4d9,0xa1cf8f2e,0x01a4bba5,0xb0ad0000,0x74439000,0xcfaf0000,0x0a9c0000,0x92830369,0x9215e13f,0xf574c6f3,0x6da7cede},
	{0xc9020000,0x88a8f270,0x74a00000,0x14510000,0xbd5b0352,0x2a2c6460,0xeb44553c,0xc49de670,0xf0030000,0xabba9030,0xb94f0000,0xe1850000,0x8ad80143,0xad17d8f1,0x61cd279b,0xd5ee27c6},
	{0xb6840000,0x075ef030,0xcf960000,0xf5890000,0x7ffc024c,0x31b6ed17,0x35766e46,0xb9ed52bd,0xcf2b0000,0xfbb59240,0x74990000,0xeb440000,0x50240277,0x898f6848,0x2b46fd89,0x10d77a13},
	{0x89ac0000,0x5751f240,0x02400000,0xff480000,0xa5000178,0x152e5dae,0x7ffdb454,0x7cd40f68,0x8f850000,0x244c9270,0x02790000,0x005d0000,0x487f005d,0xb68d5186,0xbfff1ce1,0xa89e930b},
	{0x2db50000,0x290ad400,0x1a870000,0xa4780000,0xf90a03af,0x528cc961,0xf0d9e006,0x7e9e1baa,0x97a20000,0x89d4ac00,0xdbad0000,0x582b0000,0x961402df,0x7857f00f,0x79c35ff6,0xab4ad92e},
	{0x129d0000,0x7905d670,0xd7510000,0xaeb90000,0x23f6009b,0x761479d8,0xba523a14,0xbba7467f,0xd70c0000,0x562dac30,0xad4d0000,0xb3320000,0x8e4f00f5,0x4755c9c1,0xed7abe9e,0x13033036},
	{0x6d1b0000,0xf6f3d430,0x6c670000,0x4f610000,0xe1510185,0x6d8ef0af,0x6460016e,0xc6d7f2b2,0xe8240000,0x0622ae40,0x609b0000,0xb9f30000,0x54b303c1,0x63cd7978,0xa7f1648c,0xd63a6de3},
	{0x52330000,0xa6fcd640,0xa1b10000,0x45a00000,0x3bad02b1,0x49164016,0x2eebdb7c,0x03eeaf67,0xa88a0000,0xd9dbae70,0x167b0000,0x52ea0000,0x4ce801eb,0x5ccf40b6,0x334885e4,0x6e7384fb},
	{0x0aba0000,0xd49de800,0x0e850000,0xf6cf0000,0xfd9d0219,0xb8ced851,0x7c6e7903,0xb8730c5a,0x6b320000,0x85eeb400,0x6c5e0000,0xb0740000,0x0c2e00a0,0xce2dfc87,0xa462a9db,0x129d6ed1},
	{0x35920000,0x8492ea70,0xc3530000,0xfc0e0000,0x2761012d,0x9c5668e8,0x36e5a311,0x7d4a518f,0x2b9c0000,0x5a17b430,0x1abe0000,0x5b6d0000,0x1475028a,0xf12fc549,0x30db48b3,0xaad487c9},
	{0x4a140000,0x0b64e830,0x78650000,0x1dd60000,0xe5c60033,0x87cce19f,0xe8d7986b,0x003ae542,0x14b40000,0x0a18b640,0xd7680000,0x51ac0000,0xce8901be,0xd5b775f0,0x7a5092a1,0x6fedda1c},
	{0x753c0000,0x5b6bea40,0xb5b30000,0x17170000,0x3f3a0307,0xa3545126,0xa25c4279,0xc503b897,0x541a0000,0xd5e1b670,0xa1880000,0xbab50000,0xd6d20394,0xeab54c3e,0xeee973c9,0xd7a43304},
	{0x1eda0000,0x4a1b8400,0x0d850000,0x00f10000,0xd01b014e,0x9f08b65d,0x8f904a03,0xa53c0fc6,0x0ac10000,0x8167d400,0x93c80000,0x7f6d0000,0x1fe701e4,0xf0648f16,0x799d1ea4,0x479b924f},
	{0x21f20000,0x1a148670,0xc0530000,0x0a300000,0x0ae7027a,0xbb9006e4,0xc51b9011,0x60055213,0x4a6f0000,0x5e9ed430,0xe5280000,0x94740000,0x07bc03ce,0xcf66b6d8,0xed24ffcc,0xffd27b57},
	{0x5e740000,0x95e28430,0x7b650000,0xebe80000,0xc8400364,0xa00a8f93,0x1b29ab6b,0x1d75e6de,0x75470000,0x0e91d640,0x28fe0000,0x9eb50000,0xdd4000fa,0xebfe0661,0xa7af25de,0x3aeb2682},
	{0x615c0000,0xc5ed8640,0xb6b30000,0xe1290000,0x12bc0050,0x84923f2a,0x51a27179,0xd84cbb0b,0x35e90000,0xd168d670,0x5e1e0000,0x75ac0000,0xc51b02d0,0xd4fc3faf,0x3316c4b6,0x82a2cf9a},
	{0x39d50000,0xb78cb800,0x19870000,0x52460000,0xd48c00f8,0x754aa76d,0x0327d306,0x63d11836,0xf6510000,0x8d5dcc00,0x243b0000,0x97320000,0x85dd039b,0x461e839e,0xa43ce889,0xfe4c25b0},
	{0x06fd0000,0xe783ba70,0xd4510000,0x58870000,0x0e7003cc,0x51d217d4,0x49ac0914,0xa6e845e3,0xb6ff0000,0x52a4cc30,0x52db0000,0x7c2b0000,0x9d8601b1,0x791cba50,0x308509e1,0x4605cca8},
	{0x797b0000,0x6875b830,0x6f670000,0xb95f0000,0xccd702d2,0x4a489ea3,0x979e326e,0xdb98f12e,0x89d70000,0x02abce40,0x9f0d0000,0x76ea0000,0x477a0285,0x5d840ae9,0x7a0ed3f3,0x833c917d},
	{0x46530000,0x387aba40,0xa2b10000,0xb39e0000,0x162b01e6,0x6ed02e1a,0xdd15e87c,0x1ea1acfb,0xc9790000,0xdd52ce70,0xe9ed0000,0x9df30000,0x5f2100af,0x62863327,0xeeb7329b,0x3b757865},
	{0xe24a0000,0x46219c00,0xba760000,0xe8ae0000,0x4a210331,0x2972bad5,0x5231bc2e,0x1cebb839,0xd15e0000,0x70caf000,0x30390000,0xc5850000,0x814a022d,0xac5c92ae,0x288b718c,0x38a13240},
	{0xdd620000,0x162e9e70,0x77a00000,0xe26f0000,0x90dd0005,0x0dea0a6c,0x18ba663c,0xd9d2e5ec,0x91f00000,0xaf33f030,0x46d90000,0x2e9c0000,0x99110007,0x935eab60,0xbc3290e4,0x80e8db58},
	{0xa2e40000,0x99d89c30,0xcc960000,0x03b70000,0x527a011b,0x1670831b,0xc6885d46,0xa4a25121,0xaed80000,0xff3cf240,0x8b0f0000,0x245d0000,0x43ed0333,0xb7c61bd9,0xf6b94af6,0x45d1868d},
	{0x9dcc0000,0xc9d79e40,0x01400000,0x09760000,0x8886022f,0x32e833a2,0x8c038754,0x619b0cf4,0xee760000,0x20c5f270,0xfdef0000,0xcf440000,0x5bb60119,0x88c42217,0x6200ab9e,0xfd986f95},
	{0xc5450000,0xbbb6a000,0xae740000,0xba190000,0x4eb60287,0xc330abe5,0xde86252b,0xda06afc9,0x2dce0000,0x7cf0e800,0x87ca0000,0x2dda0000,0x1b700052,0x1a269e26,0xf52a87a1,0x817685bf},
	{0xfa6d0000,0xebb9a270,0x63a20000,0xb0d80000,0x944a01b3,0xe7a81b5c,0x940dff39,0x1f3ff21c,0x6d600000,0xa309e830,0xf12a0000,0xc6c30000,0x032b0278,0x2524a7e8,0x619366c9,0x393f6ca7},
	{0x85eb0000,0x644fa030,0xd8940000,0x51000000,0x56ed00ad,0xfc32922b,0x4a3fc443,0x624f46d1,0x52480000,0xf306ea40,0x3cfc0000,0xcc020000,0xd9d7014c,0x01bc1751,0x2b18bcdb,0xfc063172},
	{0xbac30000,0x3440a240,0x15420000,0x5bc10000,0x8c110399,0xd8aa2292,0x00b41e51,0xa7761b04,0x12e60000,0x2cffea70,0x4a1c0000,0x271b0000,0xc18c0366,0x3ebe2e9f,0xbfa15db3,0x444fd86a},
	{0x58260000,0xb305d800,0xe6110000,0x9d5f0000,0xc74501bc,0x4b03d4fc,0xded86479,0x36d7e4a8,0x83c20000,0x1752c000,0xd8ad0000,0xae150000,0xbb920188,0x5f919e03,0x8a3d6cf6,0xb605dab2},
	{0x670e0000,0xe30ada70,0x2bc70000,0x979e0000,0x1db90288,0x6f9b6445,0x9453be6b,0xf3eeb97d,0xc36c0000,0xc8abc030,0xae4d0000,0x450c0000,0xa3c903a2,0x6093a7cd,0x1e848d9e,0x0e4c33aa},
	{0x18880000,0x6cfcd830,0x90f10000,0x76460000,0xdf1e0396,0x7401ed32,0x4a618511,0x8e9e0db0,0xfc440000,0x98a4c240,0x639b0000,0x4fcd0000,0x79350096,0x440b1774,0x540f578c,0xcb756e7f},
	{0x27a00000,0x3cf3da40,0x5d270000,0x7c870000,0x05e200a2,0x50995d8b,0x00ea5f03,0x4ba75065,0xbcea0000,0x475dc270,0x157b0000,0xa4d40000,0x616e02bc,0x7b092eba,0xc0b6b6e4,0x733c8767},
	{0x7f290000,0x4e92e400,0xf2130000,0xcfe80000,0xc3d2000a,0xa141c5cc,0x526ffd7c,0xf03af358,0x7f520000,0x1b68d800,0x6f5e0000,0x464a0000,0x21a803f7,0xe9eb928b,0x579c9adb,0x0fd26d4d},
	{0x40010000,0x1e9de670,0x3fc50000,0xc5290000,0x192e033e,0x85d97575,0x18e4276e,0x3503ae8d,0x3ffc0000,0xc491d830,0x19be0000,0xad530000,0x39f301dd,0xd6e9ab45,0xc3257bb3,0xb79b8455},
	{0x3f870000,0x916be430,0x84f30000,0x24f10000,0xdb890220,0x9e43fc02,0xc6d61c14,0x48731a40,0x00d40000,0x949eda40,0xd4680000,0xa7920000,0xe30f02e9,0xf2711bfc,0x89aea1a1,0x72a2d980},
	{0x00af0000,0xc164e640,0x49250000,0x2e300000,0x01750114,0xbadb4cbb,0x8c5dc606,0x8d4a4795,0x407a0000,0x4b67da70,0xa2880000,0x4c8b0000,0xfb5400c3,0xcd732232,0x1d1740c9,0xcaeb3098},
	{0xa4b60000,0xbf3fc000,0x51e20000,0x75000000,0x5d7f03c3,0xfd79d874,0x03799254,0x8f005357,0x585d0000,0xe6ffe400,0x7b5c0000,0x14fd0000,0x253f0241,0x03a983bb,0xdb2b03de,0xc93f7abd},
	{0x9b9e0000,0xef30c270,0x9c340000,0x7fc10000,0x878300f7,0xd9e168cd,0x49f24846,0x4a390e82,0x18f30000,0x3906e430,0x0dbc0000,0xffe40000,0x3d64006b,0x3cabba75,0x4f92e2b6,0x717693a5},
	{0xe4180000,0x60c6c030,0x27020000,0x9e190000,0x452401e9,0xc27be1ba,0x97c0733c,0x3749ba4f,0x27db0000,0x6909e640,0xc06a0000,0xf5250000,0xe798035f,0x18330acc,0x051938a4,0xb44fce70},
	{0xdb300000,0x30c9c240,0xead40000,0x94d80000,0x9fd802dd,0xe6e35103,0xdd4ba92e,0xf270e79a,0x67750000,0xb6f0e670,0xb68a0000,0x1e3c0000,0xffc30175,0x27313302,0x91a0d9cc,0x0c062768},
	{0x83b90000,0x42a8fc00,0x45e00000,0x27b70000,0x59e80275,0x173bc944,0x8fce0b51,0x49ed44a7,0xa4cd0000,0xeac5fc00,0xccaf0000,0xfca20000,0xbf05003e,0xb5d38f33,0x068af5f3,0x70e8cd42},
	{0xbc910000,0x12a7fe70,0x88360000,0x2d760000,0x83140141,0x33a379fd,0xc545d143,0x8cd41972,0xe4630000,0x353cfc30,0xba4f0000,0x17bb0000,0xa75e0214,0x8ad1b6fd,0x9233149b,0xc8a1245a},
	{0xc3170000,0x9d51fc30,0x33000000,0xccae0000,0x41b3005f,0x2839f08a,0x1b77ea39,0xf1a4adbf,0xdb4b0000,0x6533fe40,0x77990000,0x1d7a0000,0x7da20120,0xae490644,0xd8b8ce89,0x0d98798f},
	{0xfc3f0000,0xcd5efe40,0xfed60000,0xc66f0000,0x9b4f036b,0x0ca14033,0x51fc302b,0x349df06a,0x9be50000,0xbacafe70,0x01790000,0xf6630000,0x65f9030a,0x914b3f8a,0x4c012fe1,0xb5d19097}
    },{
	{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x6d170000,0x014f0005,0x9c61c000,0x73630000,0xcd8f03f4,0xb4f580e4,0x0ac0529b,0xf5ee6cf8,0x574b0000,0x94b90001,0x0c9b4000,0x5df10000,0xb3c60005,0x5f97ffd9,0xab1b2518,0x9e8c9c6d},
	{0x574b0000,0x94b90001,0x0c9b4000,0x5df10000,0xb3c60005,0x5f97ffd9,0xab1b2518,0x9e8c9c6d,0x3a5c0000,0x95f60004,0x90fa8000,0x2e920000,0x7e4903f1,0xeb627f3d,0xa1db7783,0x6b62f095},
	{0x3a5c0000,0x95f60004,0x90fa8000,0x2e920000,0x7e4903f1,0xeb627f3d,0xa1db7783,0x6b62f095,0x6d170000,0x014f0005,0x9c61c000,0x73630000,0xcd8f03f4,0xb4f580e4,0x0ac0529b,0xf5ee6cf8},
	{0xeb0e0000,0x10ee0009,0xfc5ec000,0x9e240000,0x975700f9,0xaee839cc,0x6d623536,0xe7ad3d70,0xde900000,0xa9330000,0xfd24c000,0x8ac00000,0xfb850399,0x7b3df676,0x57f34870,0x3d681856},
	{0x86190000,0x11a1000c,0x603f0000,0xed470000,0x5ad8030d,0x1a1db928,0x67a267ad,0x12435188,0x89db0000,0x3d8a0001,0xf1bf8000,0xd7310000,0x4843039c,0x24aa09af,0xfce86d68,0xa3e4843b},
	{0xbc450000,0x84570008,0xf0c58000,0xc3d50000,0x249100fc,0xf17fc615,0xc679102e,0x7921a11d,0xe4cc0000,0x3cc50004,0x6dde4000,0xa4520000,0x85cc0068,0x905f894b,0xf6283ff3,0x560ae8c3},
	{0xd1520000,0x8518000d,0x6ca44000,0xb0b60000,0xe91e0308,0x458a46f1,0xccb942b5,0x8ccfcde5,0xb3870000,0xa87c0005,0x61450000,0xf9a30000,0x360a006d,0xcfc87692,0x5d331aeb,0xc88674ae},
	{0xde900000,0xa9330000,0xfd24c000,0x8ac00000,0xfb850399,0x7b3df676,0x57f34870,0x3d681856,0x359e0000,0xb9dd0009,0x017a0000,0x14e40000,0x6cd20360,0xd5d5cfba,0x3a917d46,0xdac52526},
	{0xb3870000,0xa87c0005,0x61450000,0xf9a30000,0x360a006d,0xcfc87692,0x5d331aeb,0xc88674ae,0x62d50000,0x2d640008,0x0de14000,0x49150000,0xdf140365,0x8a423063,0x918a585e,0x4449b94b},
	{0x89db0000,0x3d8a0001,0xf1bf8000,0xd7310000,0x4843039c,0x24aa09af,0xfce86d68,0xa3e4843b,0x0fc20000,0x2c2b000d,0x91808000,0x3a760000,0x129b0091,0x3eb7b087,0x9b4a0ac5,0xb1a7d5b3},
	{0xe4cc0000,0x3cc50004,0x6dde4000,0xa4520000,0x85cc0068,0x905f894b,0xf6283ff3,0x560ae8c3,0x58890000,0xb892000c,0x9d1bc000,0x67870000,0xa15d0094,0x61204f5e,0x30512fdd,0x2f2b49de},
	{0x359e0000,0xb9dd0009,0x017a0000,0x14e40000,0x6cd20360,0xd5d5cfba,0x3a917d46,0xdac52526,0xeb0e0000,0x10ee0009,0xfc5ec000,0x9e240000,0x975700f9,0xaee839cc,0x6d623536,0xe7ad3d70},
	{0x58890000,0xb892000c,0x9d1bc000,0x67870000,0xa15d0094,0x61204f5e,0x30512fdd,0x2f2b49de,0xbc450000,0x84570008,0xf0c58000,0xc3d50000,0x249100fc,0xf17fc615,0xc679102e,0x7921a11d},
	{0x62d50000,0x2d640008,0x0de14000,0x49150000,0xdf140365,0x8a423063,0x918a585e,0x4449b94b,0xd1520000,0x8518000d,0x6ca44000,0xb0b60000,0xe91e0308,0x458a46f1,0xccb942b5,0x8ccfcde5},
	{0x0fc20000,0x2c2b000d,0x91808000,0x3a760000,0x129b0091,0x3eb7b087,0x9b4a0ac5,0xb1a7d5b3,0x86190000,0x11a1000c,0x603f0000,0xed470000,0x5ad8030d,0x1a1db928,0x67a267ad,0x12435188},
	{0x45930000,0x548300f0,0x03f20000,0xa4520000,0xd611012b,0x8b0f86ff,0x36e9f7ae,0x177626d7,0x92620000,0xb5e40060,0xfff50000,0x18860000,0x8f0c0283,0x44693603,0x0fb4fd4c,0xcbb0c28b},
	{0x28840000,0x55cc00f5,0x9f93c000,0xd7310000,0x1b9e02df,0x3ffa061b,0x3c29a535,0xe2984a2f,0xc5290000,0x215d0061,0xf36e4000,0x45770000,0x3cca0286,0x1bfec9da,0xa4afd854,0x553c5ee6},
	{0x12d80000,0xc03a00f1,0x0f694000,0xf9a30000,0x65d7012e,0xd4987926,0x9df2d2b6,0x89fababa,0xa83e0000,0x20120064,0x6f0f8000,0x36140000,0xf1450172,0xaf0b493e,0xae6f8acf,0xa0d2321e},
	{0x7fcf0000,0xc17500f4,0x93088000,0x8ac00000,0xa85802da,0x606df9c2,0x9732802d,0x7c14d642,0xff750000,0xb4ab0065,0x6394c000,0x6be50000,0x42830177,0xf09cb6e7,0x0574afd7,0x3e5eae73},
	{0xae9d0000,0x446d00f9,0xffacc000,0x3a760000,0x414601d2,0x25e7bf33,0x5b8bc298,0xf0db1ba7,0x4cf20000,0x1cd70060,0x02d1c000,0x92460000,0x7489011a,0x3f54c075,0x5847b53c,0xf6d8dadd},
	{0xc38a0000,0x452200fc,0x63cd0000,0x49150000,0x8cc90226,0x91123fd7,0x514b9003,0x0535775f,0x1bb90000,0x886e0061,0x0e4a8000,0xcfb70000,0xc74f011f,0x60c33fac,0xf35c9024,0x685446b0},
	{0xf9d60000,0xd0d400f8,0xf3378000,0x67870000,0xf28001d7,0x7a7040ea,0xf090e780,0x6e5787ca,0x76ae0000,0x89210064,0x922b4000,0xbcd40000,0x0ac002eb,0xd436bf48,0xf99cc2bf,0x9dba2a48},
	{0x94c10000,0xd19b00fd,0x6f564000,0x14e40000,0x3f0f0223,0xce85c00e,0xfa50b51b,0x9bb9eb32,0x21e50000,0x1d980065,0x9eb00000,0xe1250000,0xb90602ee,0x8ba14091,0x5287e7a7,0x0336b625},
	{0x9b030000,0xfdb000f0,0xfed6c000,0x2e920000,0x2d9402b2,0xf0327089,0x611abfde,0x2a1e3e81,0xa7fc0000,0x0c390069,0xfe8f0000,0x0c620000,0xe3de01e3,0x91bcf9b9,0x3525800a,0x1175e7ad},
	{0xf6140000,0xfcff00f5,0x62b70000,0x5df10000,0xe01b0146,0x44c7f06d,0x6bdaed45,0xdff05279,0xf0b70000,0x98800068,0xf2144000,0x51930000,0x501801e6,0xce2b0660,0x9e3ea512,0x8ff97bc0},
	{0xcc480000,0x690900f1,0xf24d8000,0x73630000,0x9e5202b7,0xafa58f50,0xca019ac6,0xb492a2ec,0x9da00000,0x99cf006d,0x6e758000,0x22f00000,0x9d970212,0x7ade8684,0x94fef789,0x7a171738},
	{0xa15f0000,0x684600f4,0x6e2c4000,0x00000000,0x53dd0143,0x1b500fb4,0xc0c1c85d,0x417cce14,0xcaeb0000,0x0d76006c,0x62eec000,0x7f010000,0x2e510217,0x2549795d,0x3fe5d291,0xe49b8b55},
	{0x700d0000,0xed5e00f9,0x02880000,0xb0b60000,0xbac3024b,0x5eda4945,0x0c788ae8,0xcdb303f1,0x796c0000,0xa50a0069,0x03abc000,0x86a20000,0x185b027a,0xea810fcf,0x62d6c87a,0x2c1dfffb},
	{0x1d1a0000,0xec1100fc,0x9ee9c000,0xc3d50000,0x774c01bf,0xea2fc9a1,0x06b8d873,0x385d6f09,0x2e270000,0x31b30068,0x0f308000,0xdb530000,0xab9d027f,0xb516f016,0xc9cded62,0xb2916396},
	{0x27460000,0x79e700f8,0x0e134000,0xed470000,0x0905024e,0x014db69c,0xa763aff0,0x533f9f9c,0x43300000,0x30fc006d,0x93514000,0xa8300000,0x6612018b,0x01e370f2,0xc30dbff9,0x477f0f6e},
	{0x4a510000,0x78a800fd,0x92728000,0x9e240000,0xc48a01ba,0xb5b83678,0xada3fd6b,0xa6d1f364,0x147b0000,0xa445006c,0x9fca0000,0xf5c10000,0xd5d4018e,0x5e748f2b,0x68169ae1,0xd9f39303},
	{0x92620000,0xb5e40060,0xfff50000,0x18860000,0x8f0c0283,0x44693603,0x0fb4fd4c,0xcbb0c28b,0xd7f10000,0xe1670090,0xfc070000,0xbcd40000,0x591d03a8,0xcf66b0fc,0x395d0ae2,0xdcc6e45c},
	{0xff750000,0xb4ab0065,0x6394c000,0x6be50000,0x42830177,0xf09cb6e7,0x0574afd7,0x3e5eae73,0x80ba0000,0x75de0091,0xf09c4000,0xe1250000,0xeadb03ad,0x90f14f25,0x92462ffa,0x424a7831},
	{0xc5290000,0x215d0061,0xf36e4000,0x45770000,0x3cca0286,0x1bfec9da,0xa4afd854,0x553c5ee6,0xedad0000,0x74910094,0x6cfd8000,0x92460000,0x27540059,0x2404cfc1,0x98867d61,0xb7a414c9},
	{0xa83e0000,0x20120064,0x6f0f8000,0x36140000,0xf1450172,0xaf0b493e,0xae6f8acf,0xa0d2321e,0xbae60000,0xe0280095,0x6066c000,0xcfb70000,0x9492005c,0x7b933018,0x339d5879,0x292888a4},
	{0x796c0000,0xa50a0069,0x03abc000,0x86a20000,0x185b027a,0xea810fcf,0x62d6c87a,0x2c1dfffb,0x09610000,0x48540090,0x0123c000,0x36140000,0xa2980031,0xb45b468a,0x6eae4292,0xe1aefc0a},
	{0x147b0000,0xa445006c,0x9fca0000,0xf5c10000,0xd5d4018e,0x5e748f2b,0x68169ae1,0xd9f39303,0x5e2a0000,0xdced0091,0x0db88000,0x6be50000,0x115e0034,0xebccb953,0xc5b5678a,0x7f226067},
	{0x2e270000,0x31b30068,0x0f308000,0xdb530000,0xab9d027f,0xb516f016,0xc9cded62,0xb2916396,0x333d0000,0xdda20094,0x91d94000,0x18860000,0xdcd103c0,0x5f3939b7,0xcf753511,0x8acc0c9f},
	{0x43300000,0x30fc006d,0x93514000,0xa8300000,0x6612018b,0x01e370f2,0xc30dbff9,0x477f0f6e,0x64760000,0x491b0095,0x9d420000,0x45770000,0x6f1703c5,0x00aec66e,0x646e1009,0x144090f2},
	{0x4cf20000,0x1cd70060,0x02d1c000,0x92460000,0x7489011a,0x3f54c075,0x5847b53c,0xf6d8dadd,0xe26f0000,0x58ba0099,0xfd7d0000,0xa8300000,0x35cf00c8,0x1ab37f46,0x03cc77a4,0x0603c17a},
	{0x21e50000,0x1d980065,0x9eb00000,0xe1250000,0xb90602ee,0x8ba14091,0x5287e7a7,0x0336b625,0xb5240000,0xcc030098,0xf1e64000,0xf5c10000,0x860900cd,0x4524809f,0xa8d752bc,0x988f5d17},
	{0x1bb90000,0x886e0061,0x0e4a8000,0xcfb70000,0xc74f011f,0x60c33fac,0xf35c9024,0x685446b0,0xd8330000,0xcd4c009d,0x6d878000,0x86a20000,0x4b860339,0xf1d1007b,0xa2170027,0x6d6131ef},
	{0x76ae0000,0x89210064,0x922b4000,0xbcd40000,0x0ac002eb,0xd436bf48,0xf99cc2bf,0x9dba2a48,0x8f780000,0x59f5009c,0x611cc000,0xdb530000,0xf840033c,0xae46ffa2,0x090c253f,0xf3edad82},
	{0xa7fc0000,0x0c390069,0xfe8f0000,0x0c620000,0xe3de01e3,0x91bcf9b9,0x3525800a,0x1175e7ad,0x3cff0000,0xf1890099,0x0059c000,0x22f00000,0xce4a0351,0x618e8930,0x543f3fd4,0x3b6bd92c},
	{0xcaeb0000,0x0d76006c,0x62eec000,0x7f010000,0x2e510217,0x2549795d,0x3fe5d291,0xe49b8b55,0x6bb40000,0x65300098,0x0cc28000,0x7f010000,0x7d8c0354,0x3e1976e9,0xff241acc,0xa5e74541},
	{0xf0b70000,0x98800068,0xf2144000,0x51930000,0x501801e6,0xce2b0660,0x9e3ea512,0x8ff97bc0,0x06a30000,0x647f009d,0x90a34000,0x0c620000,0xb00300a0,0x8aecf60d,0xf5e44857,0x500929b9},
	{0x9da00000,0x99cf006d,0x6e758000,0x22f00000,0x9d970212,0x7ade8684,0x94fef789,0x7a171738,0x51e80000,0xf0c6009c,0x9c380000,0x51930000,0x03c500a5,0xd57b09d4,0x5eff6d4f,0xce85b5d4},
	{0xd7f10000,0xe1670090,0xfc070000,0xbcd40000,0x591d03a8,0xcf66b0fc,0x395d0ae2,0xdcc6e45c,0x45930000,0x548300f0,0x03f20000,0xa4520000,0xd611012b,0x8b0f86ff,0x36e9f7ae,0x177626d7},
	{0xbae60000,0xe0280095,0x6066c000,0xcfb70000,0x9492005c,0x7b933018,0x339d5879,0x292888a4,0x12d80000,0xc03a00f1,0x0f694000,0xf9a30000,0x65d7012e,0xd4987926,0x9df2d2b6,0x89fababa},
	{0x80ba0000,0x75de0091,0xf09c4000,0xe1250000,0xeadb03ad,0x90f14f25,0x92462ffa,0x424a7831,0x7fcf0000,0xc17500f4,0x93088000,0x8ac00000,0xa85802da,0x606df9c2,0x9732802d,0x7c14d642},
	{0xedad0000,0x74910094,0x6cfd8000,0x92460000,0x27540059,0x2404cfc1,0x98867d61,0xb7a414c9,0x28840000,0x55cc00f5,0x9f93c000,0xd7310000,0x1b9e02df,0x3ffa061b,0x3c29a535,0xe2984a2f},
	{0x3cff0000,0xf1890099,0x0059c000,0x22f00000,0xce4a0351,0x618e8930,0x543f3fd4,0x3b6bd92c,0x9b030000,0xfdb000f0,0xfed6c000,0x2e920000,0x2d9402b2,0xf0327089,0x611abfde,0x2a1e3e81},
	{0x51e80000,0xf0c6009c,0x9c380000,0x51930000,0x03c500a5,0xd57b09d4,0x5eff6d4f,0xce85b5d4,0xcc480000,0x690900f1,0xf24d8000,0x73630000,0x9e5202b7,0xafa58f50,0xca019ac6,0xb492a2ec},
	{0x6bb40000,0x65300098,0x0cc28000,0x7f010000,0x7d8c0354,0x3e1976e9,0xff241acc,0xa5e74541,0xa15f0000,0x684600f4,0x6e2c4000,0x00000000,0x53dd0143,0x1b500fb4,0xc0c1c85d,0x417cce14},
	{0x06a30000,0x647f009d,0x90a34000,0x0c620000,0xb00300a0,0x8aecf60d,0xf5e44857,0x500929b9,0xf6140000,0xfcff00f5,0x62b70000,0x5df10000,0xe01b0146,0x44c7f06d,0x6bdaed45,0xdff05279},
	{0x09610000,0x48540090,0x0123c000,0x36140000,0xa2980031,0xb45b468a,0x6eae4292,0xe1aefc0a,0x700d0000,0xed5e00f9,0x02880000,0xb0b60000,0xbac3024b,0x5eda4945,0x0c788ae8,0xcdb303f1},
	{0x64760000,0x491b0095,0x9d420000,0x45770000,0x6f1703c5,0x00aec66e,0x646e1009,0x144090f2,0x27460000,0x79e700f8,0x0e134000,0xed470000,0x0905024e,0x014db69c,0xa763aff0,0x533f9f9c},
	{0x5e2a0000,0xdced0091,0x0db88000,0x6be50000,0x115e0034,0xebccb953,0xc5b5678a,0x7f226067,0x4a510000,0x78a800fd,0x92728000,0x9e240000,0xc48a01ba,0xb5b83678,0xada3fd6b,0xa6d1f364},
	{0x333d0000,0xdda20094,0x91d94000,0x18860000,0xdcd103c0,0x5f3939b7,0xcf753511,0x8acc0c9f,0x1d1a0000,0xec1100fc,0x9ee9c000,0xc3d50000,0x774c01bf,0xea2fc9a1,0x06b8d873,0x385d6f09},
	{0xe26f0000,0x58ba0099,0xfd7d0000,0xa8300000,0x35cf00c8,0x1ab37f46,0x03cc77a4,0x0603c17a,0xae9d0000,0x446d00f9,0xffacc000,0x3a760000,0x414601d2,0x25e7bf33,0x5b8bc298,0xf0db1ba7},
	{0x8f780000,0x59f5009c,0x611cc000,0xdb530000,0xf840033c,0xae46ffa2,0x090c253f,0xf3edad82,0xf9d60000,0xd0d400f8,0xf3378000,0x67870000,0xf28001d7,0x7a7040ea,0xf090e780,0x6e5787ca},
	{0xb5240000,0xcc030098,0xf1e64000,0xf5c10000,0x860900cd,0x4524809f,0xa8d752bc,0x988f5d17,0x94c10000,0xd19b00fd,0x6f564000,0x14e40000,0x3f0f0223,0xce85c00e,0xfa50b51b,0x9bb9eb32},
	{0xd8330000,0xcd4c009d,0x6d878000,0x86a20000,0x4b860339,0xf1d1007b,0xa2170027,0x6d6131ef,0xc38a0000,0x452200fc,0x63cd0000,0x49150000,0x8cc90226,0x91123fd7,0x514b9003,0x0535775f},
	{0x83e60000,0x293f0170,0xe7650000,0x39610000,0x226201db,0xf18c7c3f,0x1dd6632d,0x22a4ad22,0x24260000,0xe9c00050,0xd8f80000,0x490e0000,0x8c11011a,0x6fce24e4,0x6eadf8a8,0x15188685},
	{0xeef10000,0x28700175,0x7b04c000,0x4a020000,0xefed022f,0x4579fcdb,0x171631b6,0xd74ac1da,0x736d0000,0x7d790051,0xd4634000,0x14ff0000,0x3fd7011f,0x3059db3d,0xc5b6ddb0,0x8b941ae8},
	{0xd4ad0000,0xbd860171,0xebfe4000,0x64900000,0x91a401de,0xae1b83e6,0xb6cd4635,0xbc28314f,0x1e7a0000,0x7c360054,0x48028000,0x679c0000,0xf25802eb,0x84ac5bd9,0xcf768f2b,0x7e7a7610},
	{0xb9ba0000,0xbcc90174,0x779f8000,0x17f30000,0x5c2b022a,0x1aee0302,0xbc0d14ae,0x49c65db7,0x49310000,0xe88f0055,0x4499c000,0x3a6d0000,0x419e02ee,0xdb3ba400,0x646daa33,0xe0f6ea7d},
	{0x68e80000,0x39d10179,0x1b3bc000,0xa7450000,0xb5350122,0x5f6445f3,0x70b4561b,0xc5099052,0xfab60000,0x40f30050,0x25dcc000,0xc3ce0000,0x77940283,0x14f3d292,0x395eb0d8,0x28709ed3},
	{0x05ff0000,0x389e017c,0x875a0000,0xd4260000,0x78ba02d6,0xeb91c517,0x7a740480,0x30e7fcaa,0xadfd0000,0xd44a0051,0x29478000,0x9e3f0000,0xc4520286,0x4b642d4b,0x924595c0,0xb6fc02be},
	{0x3fa30000,0xad680178,0x17a08000,0xfab40000,0x06f30127,0x00f3ba2a,0xdbaf7303,0x5b850c3f,0xc0ea0000,0xd5050054,0xb5264000,0xed5c0000,0x09dd0172,0xff91adaf,0x9885c75b,0x43126e46},
	{0x52b40000,0xac27017d,0x8bc14000,0x89d70000,0xcb7c02d3,0xb4063ace,0xd16f2198,0xae6b60c7,0x97a10000,0x41bc0055,0xb9bd0000,0xb0ad0000,0xba1b0177,0xa0065276,0x339ee243,0xdd9ef22b},
	{0x5d760000,0x800c0170,0x1a41c000,0xb3a10000,0xd9e70242,0x8ab18a49,0x4a252b5d,0x1fccb574,0x11b80000,0x501d0059,0xd9820000,0x5dea0000,0xe0c3027a,0xba1beb5e,0x543c85ee,0xcfdda3a3},
	{0x30610000,0x81430175,0x86200000,0xc0c20000,0x146801b6,0x3e440aad,0x40e579c6,0xea22d98c,0x46f30000,0xc4a40058,0xd5194000,0x001b0000,0x5305027f,0xe58c1487,0xff27a0f6,0x51513fce},
	{0x0a3d0000,0x14b50171,0x16da8000,0xee500000,0x6a210247,0xd5267590,0xe13e0e45,0x81402919,0x2be40000,0xc5eb005d,0x49788000,0x73780000,0x9e8a018b,0x51799463,0xf5e7f26d,0xa4bf5336},
	{0x672a0000,0x15fa0174,0x8abb4000,0x9d330000,0xa7ae01b3,0x61d3f574,0xebfe5cde,0x74ae45e1,0x7caf0000,0x5152005c,0x45e3c000,0x2e890000,0x2d4c018e,0x0eee6bba,0x5efcd775,0x3a33cf5b},
	{0xb6780000,0x90e20179,0xe61f0000,0x2d850000,0x4eb002bb,0x2459b385,0x27471e6b,0xf8618804,0xcf280000,0xf92e0059,0x24a6c000,0xd72a0000,0x1b4601e3,0xc1261d28,0x03cfcd9e,0xf2b5bbf5},
	{0xdb6f0000,0x91ad017c,0x7a7ec000,0x5ee60000,0x833f014f,0x90ac3361,0x2d874cf0,0x0d8fe4fc,0x98630000,0x6d970058,0x283d8000,0x8adb0000,0xa88001e6,0x9eb1e2f1,0xa8d4e886,0x6c392798},
	{0xe1330000,0x045b0178,0xea844000,0x70740000,0xfd7602be,0x7bce4c5c,0x8c5c3b73,0x66ed1469,0xf5740000,0x6cd8005d,0xb45c4000,0xf9b80000,0x650f0212,0x2a446215,0xa214ba1d,0x99d74b60},
	{0x8c240000,0x0514017d,0x76e58000,0x03170000,0x30f9014a,0xcf3bccb8,0x869c69e8,0x93037891,0xa23f0000,0xf861005c,0xb8c70000,0xa4490000,0xd6c90217,0x75d39dcc,0x090f9f05,0x075bd70d},
	{0xc6750000,0x7dbc0180,0xe4970000,0x9d330000,0xf47300f0,0x7a83fac0,0x2b3f9483,0x35d28bf5,0xb6440000,0x5c240030,0x270d0000,0x51880000,0x031d0399,0x2ba712e7,0x611905e4,0xdea8440e},
	{0xab620000,0x7cf30185,0x78f6c000,0xee500000,0x39fc0304,0xce767a24,0x21ffc618,0xc03ce70d,0xe10f0000,0xc89d0031,0x2b964000,0x0c790000,0xb0db039c,0x7430ed3e,0xca0220fc,0x4024d863},
	{0x913e0000,0xe9050181,0xe80c4000,0xc0c20000,0x47b500f5,0x25140519,0x8024b19b,0xab5e1798,0x8c180000,0xc9d20034,0xb7f78000,0x7f1a0000,0x7d540068,0xc0c56dda,0xc0c27267,0xb5cab49b},
	{0xfc290000,0xe84a0184,0x746d8000,0xb3a10000,0x8a3a0301,0x91e185fd,0x8ae4e300,0x5eb07b60,0xdb530000,0x5d6b0035,0xbb6cc000,0x22eb0000,0xce92006d,0x9f529203,0x6bd9577f,0x2b4628f6},
	{0x2d7b0000,0x6d520189,0x18c9c000,0x03170000,0x63240009,0xd46bc30c,0x465da1b5,0xd27fb685,0x68d40000,0xf5170030,0xda29c000,0xdb480000,0xf8980000,0x509ae491,0x36ea4d94,0xe3c05c58},
	{0x406c0000,0x6c1d018c,0x84a80000,0x70740000,0xaeab03fd,0x609e43e8,0x4c9df32e,0x2791da7d,0x3f9f0000,0x61ae0031,0xd6b28000,0x86b90000,0x4b5e0005,0x0f0d1b48,0x9df1688c,0x7d4cc035},
	{0x7a300000,0xf9eb0188,0x14528000,0x5ee60000,0xd0e2000c,0x8bfc3cd5,0xed4684ad,0x4cf32ae8,0x52880000,0x60e10034,0x4ad34000,0xf5da0000,0x86d103f1,0xbbf89bac,0x97313a17,0x88a2accd},
	{0x17270000,0xf8a4018d,0x88334000,0x2d850000,0x1d6d03f8,0x3f09bc31,0xe786d636,0xb91d4610,0x05c30000,0xf4580035,0x46480000,0xa82b0000,0x351703f4,0xe46f6475,0x3c2a1f0f,0x162e30a0},
	{0x18e50000,0xd48f0180,0x19b3c000,0x17f30000,0x0ff60369,0x01be0cb6,0x7cccdcf3,0x08ba93a3,0x83da0000,0xe5f90039,0x26770000,0x456c0000,0x6fcf00f9,0xfe72dd5d,0x5b8878a2,0x046d6128},
	{0x75f20000,0xd5c00185,0x85d20000,0x64900000,0xc279009d,0xb54b8c52,0x760c8e68,0xfd54ff5b,0xd4910000,0x71400038,0x2aec4000,0x189d0000,0xdc0900fc,0xa1e52284,0xf0935dba,0x9ae1fd45},
	{0x4fae0000,0x40360181,0x15288000,0x4a020000,0xbc30036c,0x5e29f36f,0xd7d7f9eb,0x96360fce,0xb9860000,0x700f003d,0xb68d8000,0x6bfe0000,0x11860308,0x1510a260,0xfa530f21,0x6f0f91bd},
	{0x22b90000,0x41790184,0x89494000,0x39610000,0x71bf0098,0xeadc738b,0xdd17ab70,0x63d86336,0xeecd0000,0xe4b6003c,0xba16c000,0x360f0000,0xa240030d,0x4a875db9,0x51482a39,0xf1830dd0},
	{0xf3eb0000,0xc4610189,0xe5ed0000,0x89d70000,0x98a10390,0xaf56357a,0x11aee9c5,0xef17aed3,0x5d4a0000,0x4cca0039,0xdb53c000,0xcfac0000,0x944a0360,0x854f2b2b,0x0c7b30d2,0x3905797e},
	{0x9efc0000,0xc52e018c,0x798cc000,0xfab40000,0x552e0064,0x1ba3b59e,0x1b6ebb5e,0x1af9c22b,0x0a010000,0xd8730038,0xd7c88000,0x925d0000,0x278c0365,0xdad8d4f2,0xa76015ca,0xa789e513},
	{0xa4a00000,0x50d80188,0xe9764000,0xd4260000,0x2b670395,0xf0c1caa3,0xbab5ccdd,0x719b32be,0x67160000,0xd93c003d,0x4ba94000,0xe13e0000,0xea030091,0x6e2d5416,0xada04751,0x526789eb},
	{0xc9b70000,0x5197018d,0x75178000,0xa7450000,0xe6e80061,0x44344a47,0xb0759e46,0x84755e46,0x305d0000,0x4d85003c,0x47320000,0xbccf0000,0x59c50094,0x31baabcf,0x06bb6249,0xcceb1586},
	{0x11840000,0x9cdb0110,0x18900000,0x21e70000,0xad6e0358,0xb5e54a3c,0x12629e61,0xe9146fa9,0xf3d70000,0x08a700c0,0x24ff0000,0xf5da0000,0xd50c02b2,0xa0a89418,0x57f0f24a,0xc9de62d9},
	{0x7c930000,0x9d940115,0x84f1c000,0x52840000,0x60e100ac,0x0110cad8,0x18a2ccfa,0x1cfa0351,0xa49c0000,0x9c1e00c1,0x28644000,0xa82b0000,0x66ca02b7,0xff3f6bc1,0xfcebd752,0x5752feb4},
	{0x46cf0000,0x08620111,0x140b4000,0x7c160000,0x1ea8035d,0xea72b5e5,0xb979bb79,0x7798f3c4,0xc98b0000,0x9d5100c4,0xb4058000,0xdb480000,0xab450143,0x4bcaeb25,0xf62b85c9,0xa2bc924c},
	{0x2bd80000,0x092d0114,0x886a8000,0x0f750000,0xd32700a9,0x5e873501,0xb3b9e9e2,0x82769f3c,0x9ec00000,0x09e800c5,0xb89ec000,0x86b90000,0x18830146,0x145d14fc,0x5d30a0d1,0x3c300e21},
	{0xfa8a0000,0x8c350119,0xe4cec000,0xbfc30000,0x3a3903a1,0x1b0d73f0,0x7f00ab57,0x0eb952d9,0x2d470000,0xa19400c0,0xd9dbc000,0x7f1a0000,0x2e89012b,0xdb95626e,0x0003ba3a,0xf4b67a8f},
	{0x979d0000,0x8d7a011c,0x78af0000,0xcca00000,0xf7b60055,0xaff8f314,0x75c0f9cc,0xfb573e21,0x7a0c0000,0x352d00c1,0xd5408000,0x22eb0000,0x9d4f012e,0x84029db7,0xab189f22,0x6a3ae6e2},
	{0xadc10000,0x188c0118,0xe8558000,0xe2320000,0x89ff03a4,0x449a8c29,0xd41b8e4f,0x9035ceb4,0x171b0000,0x346200c4,0x49214000,0x51880000,0x50c002da,0x30f71d53,0xa1d8cdb9,0x9fd48a1a},
	{0xc0d60000,0x19c3011d,0x74344000,0x91510000,0x44700050,0xf06f0ccd,0xdedbdcd4,0x65dba24c,0x40500000,0xa0db00c5,0x45ba0000,0x0c790000,0xe30602df,0x6f60e28a,0x0ac3e8a1,0x01581677},
	{0xcf140000,0x35e80110,0xe5b4c000,0xab270000,0x56eb00c1,0xced8bc4a,0x4591d611,0xd47c77ff,0xc6490000,0xb17a00c9,0x25850000,0xe13e0000,0xb9de01d2,0x757d5ba2,0x6d618f0c,0x131b47ff},
	{0xa2030000,0x34a70115,0x79d50000,0xd8440000,0x9b640335,0x7a2d3cae,0x4f51848a,0x21921b07,0x91020000,0x25c300c8,0x291e4000,0xbccf0000,0x0a1801d7,0x2aeaa47b,0xc67aaa14,0x8d97db92},
	{0x985f0000,0xa1510111,0xe92f8000,0xf6d60000,0xe52d00c4,0x914f4393,0xee8af309,0x4af0eb92,0xfc150000,0x248c00cd,0xb57f8000,0xcfac0000,0xc7970223,0x9e1f249f,0xccbaf88f,0x7879b76a},
	{0xf5480000,0xa01e0114,0x754e4000,0x85b50000,0x28a20330,0x25bac377,0xe44aa192,0xbf1e876a,0xab5e0000,0xb03500cc,0xb9e4c000,0x925d0000,0x74510226,0xc188db46,0x67a1dd97,0xe6f52b07},
	{0x241a0000,0x25060119,0x19ea0000,0x35030000,0xc1bc0038,0x60308586,0x28f3e327,0x33d14a8f,0x18d90000,0x184900c9,0xd8a1c000,0x6bfe0000,0x425b024b,0x0e40add4,0x3a92c77c,0x2e735fa9},
	{0x490d0000,0x2449011c,0x858bc000,0x46600000,0x0c3303cc,0xd4c50562,0x2233b1bc,0xc63f2677,0x4f920000,0x8cf000c8,0xd43a8000,0x360f0000,0xf19d024e,0x51d7520d,0x9189e264,0xb0ffc3c4},
	{0x73510000,0xb1bf0118,0x15714000,0x68f20000,0x727a003d,0x3fa77a5f,0x83e8c63f,0xad5dd6e2,0x22850000,0x8dbf00cd,0x485b4000,0x456c0000,0x3c1201ba,0xe522d2e9,0x9b49b0ff,0x4511af3c},
	{0x1e460000,0xb0f0011d,0x89108000,0x1b910000,0xbff503c9,0x8b52fabb,0x892894a4,0x58b3ba1a,0x75ce0000,0x190600cc,0x44c00000,0x189d0000,0x8fd401bf,0xbab52d30,0x305295e7,0xdb9d3351},
	{0x54170000,0xc85801e0,0x1b620000,0x85b50000,0x7b7f0273,0x3eeaccc3,0x248b69cf,0xfe62497e,0x61b50000,0xbd4300a0,0xdb0a0000,0xed5c0000,0x5a000031,0xe4c1a21b,0x58440f06,0x026ea052},
	{0x39000000,0xc91701e5,0x8703c000,0xf6d60000,0xb6f00187,0x8a1f4c27,0x2e4b3b54,0x0b8c2586,0x36fe0000,0x29fa00a1,0xd7914000,0xb0ad0000,0xe9c60034,0xbb565dc2,0xf35f2a1e,0x9ce23c3f},
	{0x035c0000,0x5ce101e1,0x17f94000,0xd8440000,0xc8b90276,0x617d331a,0x8f904cd7,0x60eed513,0x5be90000,0x28b500a4,0x4bf08000,0xc3ce0000,0x244903c0,0x0fa3dd26,0xf99f7885,0x690c50c7},
	{0x6e4b0000,0x5dae01e4,0x8b988000,0xab270000,0x05360182,0xd588b3fe,0x85501e4c,0x9500b9eb,0x0ca20000,0xbc0c00a5,0x476bc000,0x9e3f0000,0x978f03c5,0x503422ff,0x52845d9d,0xf780ccaa},
	{0xbf190000,0xd8b601e9,0xe73cc000,0x1b910000,0xec28028a,0x9002f50f,0x49e95cf9,0x19cf740e,0xbf250000,0x147000a0,0x262ec000,0x679c0000,0xa18503a8,0x9ffc546d,0x0fb74776,0x3f06b804},
	{0xd20e0000,0xd9f901ec,0x7b5d0000,0x68f20000,0x21a7017e,0x24f775eb,0x43290e62,0xec2118f6,0xe86e0000,0x80c900a1,0x2ab58000,0x3a6d0000,0x124303ad,0xc06babb4,0xa4ac626e,0xa18a2469},
	{0xe8520000,0x4c0f01e8,0xeba78000,0x46600000,0x5fee028f,0xcf950ad6,0xe2f279e1,0x8743e863,0x85790000,0x818600a4,0xb6d44000,0x490e0000,0xdfcc0059,0x749e2b50,0xae6c30f5,0x54644891},
	{0x85450000,0x4d4001ed,0x77c64000,0x35030000,0x9261017b,0x7b608a32,0xe8322b7a,0x72ad849b,0xd2320000,0x153f00a5,0xba4f0000,0x14ff0000,0x6c0a005c,0x2b09d489,0x057715ed,0xcae8d4fc},
	{0x8a870000,0x616b01e0,0xe646c000,0x0f750000,0x80fa01ea,0x45d73ab5,0x737821bf,0xc30a5128,0x542b0000,0x049e00a9,0xda700000,0xf9b80000,0x36d20351,0x31146da1,0x62d57240,0xd8ab8574},
	{0xe7900000,0x602401e5,0x7a270000,0x7c160000,0x4d75021e,0xf122ba51,0x79b87324,0x36e43dd0,0x03600000,0x902700a8,0xd6eb4000,0xa4490000,0x85140354,0x6e839278,0xc9ce5758,0x46271919},
	{0xddcc0000,0xf5d201e1,0xeadd8000,0x52840000,0x333c01ef,0x1a40c56c,0xd86304a7,0x5d86cd45,0x6e770000,0x916800ad,0x4a8a8000,0xd72a0000,0x489b00a0,0xda76129c,0xc30e05c3,0xb3c975e1},
	{0xb0db0000,0xf49d01e4,0x76bc4000,0x21e70000,0xfeb3021b,0xaeb54588,0xd2a3563c,0xa868a1bd,0x393c0000,0x05d100ac,0x4611c000,0x8adb0000,0xfb5d00a5,0x85e1ed45,0x681520db,0x2d45e98c},
	{0x61890000,0x718501e9,0x1a180000,0x91510000,0x17ad0113,0xeb3f0379,0x1e1a1489,0x24a76c58,0x8abb0000,0xadad00a9,0x2754c000,0x73780000,0xcd5700c8,0x4a299bd7,0x35263a30,0xe5c39d22},
	{0x0c9e0000,0x70ca01ec,0x8679c000,0xe2320000,0xda2202e7,0x5fca839d,0x14da4612,0xd14900a0,0xddf00000,0x391400a8,0x2bcf8000,0x2e890000,0x7e9100cd,0x15be640e,0x9e3d1f28,0x7b4f014f},
	{0x36c20000,0xe53c01e8,0x16834000,0xcca00000,0xa46b0116,0xb4a8fca0,0xb5013191,0xba2bf035,0xb0e70000,0x385b00ad,0xb7ae4000,0x5dea0000,0xb31e0339,0xa14be4ea,0x94fd4db3,0x8ea16db7},
	{0x5bd50000,0xe47301ed,0x8ae28000,0xbfc30000,0x69e402e2,0x005d7c44,0xbfc1630a,0x4fc59ccd,0xe7ac0000,0xace200ac,0xbb350000,0x001b0000,0x00d8033c,0xfedc1b33,0x3fe668ab,0x102df1da},
	{0x24260000,0xe9c00050,0xd8f80000,0x490e0000,0x8c11011a,0x6fce24e4,0x6eadf8a8,0x15188685,0xa7c00000,0xc0ff0120,0x3f9d0000,0x706f0000,0xae7300c1,0x9e4258db,0x737b9b85,0x37bc2ba7},
	{0x49310000,0xe88f0055,0x4499c000,0x3a6d0000,0x419e02ee,0xdb3ba400,0x646daa33,0xe0f6ea7d,0xf08b0000,0x54460121,0x33064000,0x2d9e0000,0x1db500c4,0xc1d5a702,0xd860be9d,0xa930b7ca},
	{0x736d0000,0x7d790051,0xd4634000,0x14ff0000,0x3fd7011f,0x3059db3d,0xc5b6ddb0,0x8b941ae8,0x9d9c0000,0x55090124,0xaf678000,0x5efd0000,0xd03a0330,0x752027e6,0xd2a0ec06,0x5cdedb32},
	{0x1e7a0000,0x7c360054,0x48028000,0x679c0000,0xf25802eb,0x84ac5bd9,0xcf768f2b,0x7e7a7610,0xcad70000,0xc1b00125,0xa3fcc000,0x030c0000,0x63fc0335,0x2ab7d83f,0x79bbc91e,0xc252475f},
	{0xcf280000,0xf92e0059,0x24a6c000,0xd72a0000,0x1b4601e3,0xc1261d28,0x03cfcd9e,0xf2b5bbf5,0x79500000,0x69cc0120,0xc2b9c000,0xfaaf0000,0x55f60358,0xe57faead,0x2488d3f5,0x0ad433f1},
	{0xa23f0000,0xf861005c,0xb8c70000,0xa4490000,0xd6c90217,0x75d39dcc,0x090f9f05,0x075bd70d,0x2e1b0000,0xfd750121,0xce228000,0xa75e0000,0xe630035d,0xbae85174,0x8f93f6ed,0x9458af9c},
	{0x98630000,0x6d970058,0x283d8000,0x8adb0000,0xa88001e6,0x9eb1e2f1,0xa8d4e886,0x6c392798,0x430c0000,0xfc3a0124,0x52434000,0xd43d0000,0x2bbf00a9,0x0e1dd190,0x8553a476,0x61b6c364},
	{0xf5740000,0x6cd8005d,0xb45c4000,0xf9b80000,0x650f0212,0x2a446215,0xa214ba1d,0x99d74b60,0x14470000,0x68830125,0x5ed80000,0x89cc0000,0x987900ac,0x518a2e49,0x2e48816e,0xff3a5f09},
	{0xfab60000,0x40f30050,0x25dcc000,0xc3ce0000,0x77940283,0x14f3d292,0x395eb0d8,0x28709ed3,0x925e0000,0x79220129,0x3ee70000,0x648b0000,0xc2a103a1,0x4b979761,0x49eae6c3,0xed790e81},
	{0x97a10000,0x41bc0055,0xb9bd0000,0xb0ad0000,0xba1b0177,0xa0065276,0x339ee243,0xdd9ef22b,0xc5150000,0xed9b0128,0x327c4000,0x397a0000,0x716703a4,0x140068b8,0xe2f1c3db,0x73f592ec},
	{0xadfd0000,0xd44a0051,0x29478000,0x9e3f0000,0xc4520286,0x4b642d4b,0x924595c0,0xb6fc02be,0xa8020000,0xecd4012d,0xae1d8000,0x4a190000,0xbce80050,0xa0f5e85c,0xe8319140,0x861bfe14},
	{0xc0ea0000,0xd5050054,0xb5264000,0xed5c0000,0x09dd0172,0xff91adaf,0x9885c75b,0x43126e46,0xff490000,0x786d012c,0xa286c000,0x17e80000,0x0f2e0055,0xff621785,0x432ab458,0x18976279},
	{0x11b80000,0x501d0059,0xd9820000,0x5dea0000,0xe0c3027a,0xba1beb5e,0x543c85ee,0xcfdda3a3,0x4cce0000,0xd0110129,0xc3c3c000,0xee4b0000,0x39240038,0x30aa6117,0x1e19aeb3,0xd01116d7},
	{0x7caf0000,0x5152005c,0x45e3c000,0x2e890000,0x2d4c018e,0x0eee6bba,0x5efcd775,0x3a33cf5b,0x1b850000,0x44a80128,0xcf588000,0xb3ba0000,0x8ae2003d,0x6f3d9ece,0xb5028bab,0x4e9d8aba},
	{0x46f30000,0xc4a40058,0xd5194000,0x001b0000,0x5305027f,0xe58c1487,0xff27a0f6,0x51513fce,0x76920000,0x45e7012d,0x53394000,0xc0d90000,0x476d03c9,0xdbc81e2a,0xbfc2d930,0xbb73e642},
	{0x2be40000,0xc5eb005d,0x49788000,0x73780000,0x9e8a018b,0x51799463,0xf5e7f26d,0xa4bf5336,0x21d90000,0xd15e012c,0x5fa20000,0x9d280000,0xf4ab03cc,0x845fe1f3,0x14d9fc28,0x25ff7a2f},
	{0x61b50000,0xbd4300a0,0xdb0a0000,0xed5c0000,0x5a000031,0xe4c1a21b,0x58440f06,0x026ea052,0x35a20000,0x751b0140,0xc0680000,0x68e90000,0x217f0242,0xda2b6ed8,0x7ccf66c9,0xfc0ce92c},
	{0x0ca20000,0xbc0c00a5,0x476bc000,0x9e3f0000,0x978f03c5,0x503422ff,0x52845d9d,0xf780ccaa,0x62e90000,0xe1a20141,0xccf34000,0x35180000,0x92b90247,0x85bc9101,0xd7d443d1,0x62807541},
	{0x36fe0000,0x29fa00a1,0xd7914000,0xb0ad0000,0xe9c60034,0xbb565dc2,0xf35f2a1e,0x9ce23c3f,0x0ffe0000,0xe0ed0144,0x50928000,0x467b0000,0x5f3601b3,0x314911e5,0xdd14114a,0x976e19b9},
	{0x5be90000,0x28b500a4,0x4bf08000,0xc3ce0000,0x244903c0,0x0fa3dd26,0xf99f7885,0x690c50c7,0x58b50000,0x74540145,0x5c09c000,0x1b8a0000,0xecf001b6,0x6edeee3c,0x760f3452,0x09e285d4},
	{0x8abb0000,0xadad00a9,0x2754c000,0x73780000,0xcd5700c8,0x4a299bd7,0x35263a30,0xe5c39d22,0xeb320000,0xdc280140,0x3d4cc000,0xe2290000,0xdafa01db,0xa11698ae,0x2b3c2eb9,0xc164f17a},
	{0xe7ac0000,0xace200ac,0xbb350000,0x001b0000,0x00d8033c,0xfedc1b33,0x3fe668ab,0x102df1da,0xbc790000,0x48910141,0x31d78000,0xbfd80000,0x693c01de,0xfe816777,0x80270ba1,0x5fe86d17},
	{0xddf00000,0x391400a8,0x2bcf8000,0x2e890000,0x7e9100cd,0x15be640e,0x9e3d1f28,0x7b4f014f,0xd16e0000,0x49de0144,0xadb64000,0xccbb0000,0xa4b3022a,0x4a74e793,0x8ae7593a,0xaa0601ef},
	{0xb0e70000,0x385b00ad,0xb7ae4000,0x5dea0000,0xb31e0339,0xa14be4ea,0x94fd4db3,0x8ea16db7,0x86250000,0xdd670145,0xa12d0000,0x914a0000,0x1775022f,0x15e3184a,0x21fc7c22,0x348a9d82},
	{0xbf250000,0x147000a0,0x262ec000,0x679c0000,0xa18503a8,0x9ffc546d,0x0fb74776,0x3f06b804,0x003c0000,0xccc60149,0xc1120000,0x7c0d0000,0x4dad0122,0x0ffea162,0x465e1b8f,0x26c9cc0a},
	{0xd2320000,0x153f00a5,0xba4f0000,0x14ff0000,0x6c0a005c,0x2b09d489,0x057715ed,0xcae8d4fc,0x57770000,0x587f0148,0xcd894000,0x21fc0000,0xfe6b0127,0x50695ebb,0xed453e97,0xb8455067},
	{0xe86e0000,0x80c900a1,0x2ab58000,0x3a6d0000,0x124303ad,0xc06babb4,0xa4ac626e,0xa18a2469,0x3a600000,0x5930014d,0x51e88000,0x529f0000,0x33e402d3,0xe49cde5f,0xe7856c0c,0x4dab3c9f},
	{0x85790000,0x818600a4,0xb6d44000,0x490e0000,0xdfcc0059,0x749e2b50,0xae6c30f5,0x54644891,0x6d2b0000,0xcd89014c,0x5d73c000,0x0f6e0000,0x802202d6,0xbb0b2186,0x4c9e4914,0xd327a0f2},
	{0x542b0000,0x049e00a9,0xda700000,0xf9b80000,0x36d20351,0x31146da1,0x62d57240,0xd8ab8574,0xdeac0000,0x65f50149,0x3c36c000,0xf6cd0000,0xb62802bb,0x74c35714,0x11ad53ff,0x1ba1d45c},
	{0x393c0000,0x05d100ac,0x4611c000,0x8adb0000,0xfb5d00a5,0x85e1ed45,0x681520db,0x2d45e98c,0x89e70000,0xf14c0148,0x30ad8000,0xab3c0000,0x05ee02be,0x2b54a8cd,0xbab676e7,0x852d4831},
	{0x03600000,0x902700a8,0xd6eb4000,0xa4490000,0x85140354,0x6e839278,0xc9ce5758,0x46271919,0xe4f00000,0xf003014d,0xaccc4000,0xd85f0000,0xc861014a,0x9fa12829,0xb076247c,0x70c324c9},
	{0x6e770000,0x916800ad,0x4a8a8000,0xd72a0000,0x489b00a0,0xda76129c,0xc30e05c3,0xb3c975e1,0xb3bb0000,0x64ba014c,0xa0570000,0x85ae0000,0x7ba7014f,0xc036d7f0,0x1b6d0164,0xee4fb8a4},
	{0xb6440000,0x5c240030,0x270d0000,0x51880000,0x031d0399,0x2ba712e7,0x611905e4,0xdea8440e,0x70310000,0x219801b0,0xc39a0000,0xccbb0000,0xf76e0369,0x5124e827,0x4a269167,0xeb7acffb},
	{0xdb530000,0x5d6b0035,0xbb6cc000,0x22eb0000,0xce92006d,0x9f529203,0x6bd9577f,0x2b4628f6,0x277a0000,0xb52101b1,0xcf014000,0x914a0000,0x44a8036c,0x0eb317fe,0xe13db47f,0x75f65396},
	{0xe10f0000,0xc89d0031,0x2b964000,0x0c790000,0xb0db039c,0x7430ed3e,0xca0220fc,0x4024d863,0x4a6d0000,0xb46e01b4,0x53608000,0xe2290000,0x89270098,0xba46971a,0xebfde6e4,0x80183f6e},
	{0x8c180000,0xc9d20034,0xb7f78000,0x7f1a0000,0x7d540068,0xc0c56dda,0xc0c27267,0xb5cab49b,0x1d260000,0x20d701b5,0x5ffbc000,0xbfd80000,0x3ae1009d,0xe5d168c3,0x40e6c3fc,0x1e94a303},
	{0x5d4a0000,0x4cca0039,0xdb53c000,0xcfac0000,0x944a0360,0x854f2b2b,0x0c7b30d2,0x3905797e,0xaea10000,0x88ab01b0,0x3ebec000,0x467b0000,0x0ceb00f0,0x2a191e51,0x1dd5d917,0xd612d7ad},
	{0x305d0000,0x4d85003c,0x47320000,0xbccf0000,0x59c50094,0x31baabcf,0x06bb6249,0xcceb1586,0xf9ea0000,0x1c1201b1,0x32258000,0x1b8a0000,0xbf2d00f5,0x758ee188,0xb6cefc0f,0x489e4bc0},
	{0x0a010000,0xd8730038,0xd7c88000,0x925d0000,0x278c0365,0xdad8d4f2,0xa76015ca,0xa789e513,0x94fd0000,0x1d5d01b4,0xae444000,0x68e90000,0x72a20301,0xc17b616c,0xbc0eae94,0xbd702738},
	{0x67160000,0xd93c003d,0x4ba94000,0xe13e0000,0xea030091,0x6e2d5416,0xada04751,0x526789eb,0xc3b60000,0x89e401b5,0xa2df0000,0x35180000,0xc1640304,0x9eec9eb5,0x17158b8c,0x23fcbb55},
	{0x68d40000,0xf5170030,0xda29c000,0xdb480000,0xf8980000,0x509ae491,0x36ea4d94,0xe3c05c58,0x45af0000,0x984501b9,0xc2e00000,0xd85f0000,0x9bbc0009,0x84f1279d,0x70b7ec21,0x31bfeadd},
	{0x05c30000,0xf4580035,0x46480000,0xa82b0000,0x351703f4,0xe46f6475,0x3c2a1f0f,0x162e30a0,0x12e40000,0x0cfc01b8,0xce7b4000,0x85ae0000,0x287a000c,0xdb66d844,0xdbacc939,0xaf3376b0},
	{0x3f9f0000,0x61ae0031,0xd6b28000,0x86b90000,0x4b5e0005,0x0f0d1b48,0x9df1688c,0x7d4cc035,0x7ff30000,0x0db301bd,0x521a8000,0xf6cd0000,0xe5f503f8,0x6f9358a0,0xd16c9ba2,0x5add1a48},
	{0x52880000,0x60e10034,0x4ad34000,0xf5da0000,0x86d103f1,0xbbf89bac,0x97313a17,0x88a2accd,0x28b80000,0x990a01bc,0x5e81c000,0xab3c0000,0x563303fd,0x3004a779,0x7a77beba,0xc4518625},
	{0x83da0000,0xe5f90039,0x26770000,0x456c0000,0x6fcf00f9,0xfe72dd5d,0x5b8878a2,0x046d6128,0x9b3f0000,0x317601b9,0x3fc4c000,0x529f0000,0x60390390,0xffccd1eb,0x2744a451,0x0cd7f28b},
	{0xeecd0000,0xe4b6003c,0xba16c000,0x360f0000,0xa240030d,0x4a875db9,0x51482a39,0xf1830dd0,0xcc740000,0xa5cf01b8,0x335f8000,0x0f6e0000,0xd3ff0395,0xa05b2e32,0x8c5f8149,0x925b6ee6},
	{0xd4910000,0x71400038,0x2aec4000,0x189d0000,0xdc0900fc,0xa1e52284,0xf0935dba,0x9ae1fd45,0xa1630000,0xa48001bd,0xaf3e4000,0x7c0d0000,0x1e700061,0x14aeaed6,0x869fd3d2,0x67b5021e},
	{0xb9860000,0x700f003d,0xb68d8000,0x6bfe0000,0x11860308,0x1510a260,0xfa530f21,0x6f0f91bd,0xf6280000,0x303901bc,0xa3a50000,0x21fc0000,0xadb60064,0x4b39510f,0x2d84f6ca,0xf9399e73},
	{0xf3d70000,0x08a700c0,0x24ff0000,0xf5da0000,0xd50c02b2,0xa0a89418,0x57f0f24a,0xc9de62d9,0xe2530000,0x947c01d0,0x3c6f0000,0xd43d0000,0x786201ea,0x154dde24,0x45926c2b,0x20ca0d70},
	{0x9ec00000,0x09e800c5,0xb89ec000,0x86b90000,0x18830146,0x145d14fc,0x5d30a0d1,0x3c300e21,0xb5180000,0x00c501d1,0x30f44000,0x89cc0000,0xcba401ef,0x4ada21fd,0xee894933,0xbe46911d},
	{0xa49c0000,0x9c1e00c1,0x28644000,0xa82b0000,0x66ca02b7,0xff3f6bc1,0xfcebd752,0x5752feb4,0xd80f0000,0x018a01d4,0xac958000,0xfaaf0000,0x062b021b,0xfe2fa119,0xe4491ba8,0x4ba8fde5},
	{0xc98b0000,0x9d5100c4,0xb4058000,0xdb480000,0xab450143,0x4bcaeb25,0xf62b85c9,0xa2bc924c,0x8f440000,0x953301d5,0xa00ec000,0xa75e0000,0xb5ed021e,0xa1b85ec0,0x4f523eb0,0xd5246188},
	{0x18d90000,0x184900c9,0xd8a1c000,0x6bfe0000,0x425b024b,0x0e40add4,0x3a92c77c,0x2e735fa9,0x3cc30000,0x3d4f01d0,0xc14bc000,0x5efd0000,0x83e70273,0x6e702852,0x1261245b,0x1da21526},
	{0x75ce0000,0x190600cc,0x44c00000,0x189d0000,0x8fd401bf,0xbab52d30,0x305295e7,0xdb9d3351,0x6b880000,0xa9f601d1,0xcdd08000,0x030c0000,0x30210276,0x31e7d78b,0xb97a0143,0x832e894b},
	{0x4f920000,0x8cf000c8,0xd43a8000,0x360f0000,0xf19d024e,0x51d7520d,0x9189e264,0xb0ffc3c4,0x069f0000,0xa8b901d4,0x51b14000,0x706f0000,0xfdae0182,0x8512576f,0xb3ba53d8,0x76c0e5b3},
	{0x22850000,0x8dbf00cd,0x485b4000,0x456c0000,0x3c1201ba,0xe522d2e9,0x9b49b0ff,0x4511af3c,0x51d40000,0x3c0001d5,0x5d2a0000,0x2d9e0000,0x4e680187,0xda85a8b6,0x18a176c0,0xe84c79de},
	{0x2d470000,0xa19400c0,0xd9dbc000,0x7f1a0000,0x2e89012b,0xdb95626e,0x0003ba3a,0xf4b67a8f,0xd7cd0000,0x2da101d9,0x3d150000,0xc0d90000,0x14b0028a,0xc098119e,0x7f03116d,0xfa0f2856},
	{0x40500000,0xa0db00c5,0x45ba0000,0x0c790000,0xe30602df,0x6f60e28a,0x0ac3e8a1,0x01581677,0x80860000,0xb91801d8,0x318e4000,0x9d280000,0xa776028f,0x9f0fee47,0xd4183475,0x6483b43b},
	{0x7a0c0000,0x352d00c1,0xd5408000,0x22eb0000,0x9d4f012e,0x84029db7,0xab189f22,0x6a3ae6e2,0xed910000,0xb85701dd,0xadef8000,0xee4b0000,0x6af9017b,0x2bfa6ea3,0xded866ee,0x916dd8c3},
	{0x171b0000,0x346200c4,0x49214000,0x51880000,0x50c002da,0x30f71d53,0xa1d8cdb9,0x9fd48a1a,0xbada0000,0x2cee01dc,0xa174c000,0xb3ba0000,0xd93f017e,0x746d917a,0x75c343f6,0x0fe144ae},
	{0xc6490000,0xb17a00c9,0x25850000,0xe13e0000,0xb9de01d2,0x757d5ba2,0x6d618f0c,0x131b47ff,0x095d0000,0x849201d9,0xc031c000,0x4a190000,0xef350113,0xbba5e7e8,0x28f0591d,0xc7673000},
	{0xab5e0000,0xb03500cc,0xb9e4c000,0x925d0000,0x74510226,0xc188db46,0x67a1dd97,0xe6f52b07,0x5e160000,0x102b01d8,0xccaa8000,0x17e80000,0x5cf30116,0xe4321831,0x83eb7c05,0x59ebac6d},
	{0x91020000,0x25c300c8,0x291e4000,0xbccf0000,0x0a1801d7,0x2aeaa47b,0xc67aaa14,0x8d97db92,0x33010000,0x116401dd,0x50cb4000,0x648b0000,0x917c02e2,0x50c798d5,0x892b2e9e,0xac05c095},
	{0xfc150000,0x248c00cd,0xb57f8000,0xcfac0000,0xc7970223,0x9e1f249f,0xccbaf88f,0x7879b76a,0x644a0000,0x85dd01dc,0x5c500000,0x397a0000,0x22ba02e7,0x0f50670c,0x22300b86,0x32895cf8},
	{0xa7c00000,0xc0ff0120,0x3f9d0000,0x706f0000,0xae7300c1,0x9e4258db,0x737b9b85,0x37bc2ba7,0x83e60000,0x293f0170,0xe7650000,0x39610000,0x226201db,0xf18c7c3f,0x1dd6632d,0x22a4ad22},
	{0xcad70000,0xc1b00125,0xa3fcc000,0x030c0000,0x63fc0335,0x2ab7d83f,0x79bbc91e,0xc252475f,0xd4ad0000,0xbd860171,0xebfe4000,0x64900000,0x91a401de,0xae1b83e6,0xb6cd4635,0xbc28314f},
	{0xf08b0000,0x54460121,0x33064000,0x2d9e0000,0x1db500c4,0xc1d5a702,0xd860be9d,0xa930b7ca,0xb9ba0000,0xbcc90174,0x779f8000,0x17f30000,0x5c2b022a,0x1aee0302,0xbc0d14ae,0x49c65db7},
	{0x9d9c0000,0x55090124,0xaf678000,0x5efd0000,0xd03a0330,0x752027e6,0xd2a0ec06,0x5cdedb32,0xeef10000,0x28700175,0x7b04c000,0x4a020000,0xefed022f,0x4579fcdb,0x171631b6,0xd74ac1da},
	{0x4cce0000,0xd0110129,0xc3c3c000,0xee4b0000,0x39240038,0x30aa6117,0x1e19aeb3,0xd01116d7,0x5d760000,0x800c0170,0x1a41c000,0xb3a10000,0xd9e70242,0x8ab18a49,0x4a252b5d,0x1fccb574},
	{0x21d90000,0xd15e012c,0x5fa20000,0x9d280000,0xf4ab03cc,0x845fe1f3,0x14d9fc28,0x25ff7a2f,0x0a3d0000,0x14b50171,0x16da8000,0xee500000,0x6a210247,0xd5267590,0xe13e0e45,0x81402919},
	{0x1b850000,0x44a80128,0xcf588000,0xb3ba0000,0x8ae2003d,0x6f3d9ece,0xb5028bab,0x4e9d8aba,0x672a0000,0x15fa0174,0x8abb4000,0x9d330000,0xa7ae01b3,0x61d3f574,0xebfe5cde,0x74ae45e1},
	{0x76920000,0x45e7012d,0x53394000,0xc0d90000,0x476d03c9,0xdbc81e2a,0xbfc2d930,0xbb73e642,0x30610000,0x81430175,0x86200000,0xc0c20000,0x146801b6,0x3e440aad,0x40e579c6,0xea22d98c},
	{0x79500000,0x69cc0120,0xc2b9c000,0xfaaf0000,0x55f60358,0xe57faead,0x2488d3f5,0x0ad433f1,0xb6780000,0x90e20179,0xe61f0000,0x2d850000,0x4eb002bb,0x2459b385,0x27471e6b,0xf8618804},
	{0x14470000,0x68830125,0x5ed80000,0x89cc0000,0x987900ac,0x518a2e49,0x2e48816e,0xff3a5f09,0xe1330000,0x045b0178,0xea844000,0x70740000,0xfd7602be,0x7bce4c5c,0x8c5c3b73,0x66ed1469},
	{0x2e1b0000,0xfd750121,0xce228000,0xa75e0000,0xe630035d,0xbae85174,0x8f93f6ed,0x9458af9c,0x8c240000,0x0514017d,0x76e58000,0x03170000,0x30f9014a,0xcf3bccb8,0x869c69e8,0x93037891},
	{0x430c0000,0xfc3a0124,0x52434000,0xd43d0000,0x2bbf00a9,0x0e1dd190,0x8553a476,0x61b6c364,0xdb6f0000,0x91ad017c,0x7a7ec000,0x5ee60000,0x833f014f,0x90ac3361,0x2d874cf0,0x0d8fe4fc},
	{0x925e0000,0x79220129,0x3ee70000,0x648b0000,0xc2a103a1,0x4b979761,0x49eae6c3,0xed790e81,0x68e80000,0x39d10179,0x1b3bc000,0xa7450000,0xb5350122,0x5f6445f3,0x70b4561b,0xc5099052},
	{0xff490000,0x786d012c,0xa286c000,0x17e80000,0x0f2e0055,0xff621785,0x432ab458,0x18976279,0x3fa30000,0xad680178,0x17a08000,0xfab40000,0x06f30127,0x00f3ba2a,0xdbaf7303,0x5b850c3f},
	{0xc5150000,0xed9b0128,0x327c4000,0x397a0000,0x716703a4,0x140068b8,0xe2f1c3db,0x73f592ec,0x52b40000,0xac27017d,0x8bc14000,0x89d70000,0xcb7c02d3,0xb4063ace,0xd16f2198,0xae6b60c7},
	{0xa8020000,0xecd4012d,0xae1d8000,0x4a190000,0xbce80050,0xa0f5e85c,0xe8319140,0x861bfe14,0x05ff0000,0x389e017c,0x875a0000,0xd4260000,0x78ba02d6,0xeb91c517,0x7a740480,0x30e7fcaa},
	{0xe2530000,0x947c01d0,0x3c6f0000,0xd43d0000,0x786201ea,0x154dde24,0x45926c2b,0x20ca0d70,0x11840000,0x9cdb0110,0x18900000,0x21e70000,0xad6e0358,0xb5e54a3c,0x12629e61,0xe9146fa9},
	{0x8f440000,0x953301d5,0xa00ec000,0xa75e0000,0xb5ed021e,0xa1b85ec0,0x4f523eb0,0xd5246188,0x46cf0000,0x08620111,0x140b4000,0x7c160000,0x1ea8035d,0xea72b5e5,0xb979bb79,0x7798f3c4},
	{0xb5180000,0x00c501d1,0x30f44000,0x89cc0000,0xcba401ef,0x4ada21fd,0xee894933,0xbe46911d,0x2bd80000,0x092d0114,0x886a8000,0x0f750000,0xd32700a9,0x5e873501,0xb3b9e9e2,0x82769f3c},
	{0xd80f0000,0x018a01d4,0xac958000,0xfaaf0000,0x062b021b,0xfe2fa119,0xe4491ba8,0x4ba8fde5,0x7c930000,0x9d940115,0x84f1c000,0x52840000,0x60e100ac,0x0110cad8,0x18a2ccfa,0x1cfa0351},
	{0x095d0000,0x849201d9,0xc031c000,0x4a190000,0xef350113,0xbba5e7e8,0x28f0591d,0xc7673000,0xcf140000,0x35e80110,0xe5b4c000,0xab270000,0x56eb00c1,0xced8bc4a,0x4591d611,0xd47c77ff},
	{0x644a0000,0x85dd01dc,0x5c500000,0x397a0000,0x22ba02e7,0x0f50670c,0x22300b86,0x32895cf8,0x985f0000,0xa1510111,0xe92f8000,0xf6d60000,0xe52d00c4,0x914f4393,0xee8af309,0x4af0eb92},
	{0x5e160000,0x102b01d8,0xccaa8000,0x17e80000,0x5cf30116,0xe4321831,0x83eb7c05,0x59ebac6d,0xf5480000,0xa01e0114,0x754e4000,0x85b50000,0x28a20330,0x25bac377,0xe44aa192,0xbf1e876a},
	{0x33010000,0x116401dd,0x50cb4000,0x648b0000,0x917c02e2,0x50c798d5,0x892b2e9e,0xac05c095,0xa2030000,0x34a70115,0x79d50000,0xd8440000,0x9b640335,0x7a2d3cae,0x4f51848a,0x21921b07},
	{0x3cc30000,0x3d4f01d0,0xc14bc000,0x5efd0000,0x83e70273,0x6e702852,0x1261245b,0x1da21526,0x241a0000,0x25060119,0x19ea0000,0x35030000,0xc1bc0038,0x60308586,0x28f3e327,0x33d14a8f},
	{0x51d40000,0x3c0001d5,0x5d2a0000,0x2d9e0000,0x4e680187,0xda85a8b6,0x18a176c0,0xe84c79de,0x73510000,0xb1bf0118,0x15714000,0x68f20000,0x727a003d,0x3fa77a5f,0x83e8c63f,0xad5dd6e2},
	{0x6b880000,0xa9f601d1,0xcdd08000,0x030c0000,0x30210276,0x31e7d78b,0xb97a0143,0x832e894b,0x1e460000,0xb0f0011d,0x89108000,0x1b910000,0xbff503c9,0x8b52fabb,0x892894a4,0x58b3ba1a},
	{0x069f0000,0xa8b901d4,0x51b14000,0x706f0000,0xfdae0182,0x8512576f,0xb3ba53d8,0x76c0e5b3,0x490d0000,0x2449011c,0x858bc000,0x46600000,0x0c3303cc,0xd4c50562,0x2233b1bc,0xc63f2677},
	{0xd7cd0000,0x2da101d9,0x3d150000,0xc0d90000,0x14b0028a,0xc098119e,0x7f03116d,0xfa0f2856,0xfa8a0000,0x8c350119,0xe4cec000,0xbfc30000,0x3a3903a1,0x1b0d73f0,0x7f00ab57,0x0eb952d9},
	{0xbada0000,0x2cee01dc,0xa174c000,0xb3ba0000,0xd93f017e,0x746d917a,0x75c343f6,0x0fe144ae,0xadc10000,0x188c0118,0xe8558000,0xe2320000,0x89ff03a4,0x449a8c29,0xd41b8e4f,0x9035ceb4},
	{0x80860000,0xb91801d8,0x318e4000,0x9d280000,0xa776028f,0x9f0fee47,0xd4183475,0x6483b43b,0xc0d60000,0x19c3011d,0x74344000,0x91510000,0x44700050,0xf06f0ccd,0xdedbdcd4,0x65dba24c},
	{0xed910000,0xb85701dd,0xadef8000,0xee4b0000,0x6af9017b,0x2bfa6ea3,0xded866ee,0x916dd8c3,0x979d0000,0x8d7a011c,0x78af0000,0xcca00000,0xf7b60055,0xaff8f314,0x75c0f9cc,0xfb573e21},
	{0x35a20000,0x751b0140,0xc0680000,0x68e90000,0x217f0242,0xda2b6ed8,0x7ccf66c9,0xfc0ce92c,0x54170000,0xc85801e0,0x1b620000,0x85b50000,0x7b7f0273,0x3eeaccc3,0x248b69cf,0xfe62497e},
	{0x58b50000,0x74540145,0x5c09c000,0x1b8a0000,0xecf001b6,0x6edeee3c,0x760f3452,0x09e285d4,0x035c0000,0x5ce101e1,0x17f94000,0xd8440000,0xc8b90276,0x617d331a,0x8f904cd7,0x60eed513},
	{0x62e90000,0xe1a20141,0xccf34000,0x35180000,0x92b90247,0x85bc9101,0xd7d443d1,0x62807541,0x6e4b0000,0x5dae01e4,0x8b988000,0xab270000,0x05360182,0xd588b3fe,0x85501e4c,0x9500b9eb},
	{0x0ffe0000,0xe0ed0144,0x50928000,0x467b0000,0x5f3601b3,0x314911e5,0xdd14114a,0x976e19b9,0x39000000,0xc91701e5,0x8703c000,0xf6d60000,0xb6f00187,0x8a1f4c27,0x2e4b3b54,0x0b8c2586},
	{0xdeac0000,0x65f50149,0x3c36c000,0xf6cd0000,0xb62802bb,0x74c35714,0x11ad53ff,0x1ba1d45c,0x8a870000,0x616b01e0,0xe646c000,0x0f750000,0x80fa01ea,0x45d73ab5,0x737821bf,0xc30a5128},
	{0xb3bb0000,0x64ba014c,0xa0570000,0x85ae0000,0x7ba7014f,0xc036d7f0,0x1b6d0164,0xee4fb8a4,0xddcc0000,0xf5d201e1,0xeadd8000,0x52840000,0x333c01ef,0x1a40c56c,0xd86304a7,0x5d86cd45},
	{0x89e70000,0xf14c0148,0x30ad8000,0xab3c0000,0x05ee02be,0x2b54a8cd,0xbab676e7,0x852d4831,0xb0db0000,0xf49d01e4,0x76bc4000,0x21e70000,0xfeb3021b,0xaeb54588,0xd2a3563c,0xa868a1bd},
	{0xe4f00000,0xf003014d,0xaccc4000,0xd85f0000,0xc861014a,0x9fa12829,0xb076247c,0x70c324c9,0xe7900000,0x602401e5,0x7a270000,0x7c160000,0x4d75021e,0xf122ba51,0x79b87324,0x36e43dd0},
	{0xeb320000,0xdc280140,0x3d4cc000,0xe2290000,0xdafa01db,0xa11698ae,0x2b3c2eb9,0xc164f17a,0x61890000,0x718501e9,0x1a180000,0x91510000,0x17ad0113,0xeb3f0379,0x1e1a1489,0x24a76c58},
	{0x86250000,0xdd670145,0xa12d0000,0x914a0000,0x1775022f,0x15e3184a,0x21fc7c22,0x348a9d82,0x36c20000,0xe53c01e8,0x16834000,0xcca00000,0xa46b0116,0xb4a8fca0,0xb5013191,0xba2bf035},
	{0xbc790000,0x48910141,0x31d78000,0xbfd80000,0x693c01de,0xfe816777,0x80270ba1,0x5fe86d17,0x5bd50000,0xe47301ed,0x8ae28000,0xbfc30000,0x69e402e2,0x005d7c44,0xbfc1630a,0x4fc59ccd},
	{0xd16e0000,0x49de0144,0xadb64000,0xccbb0000,0xa4b3022a,0x4a74e793,0x8ae7593a,0xaa0601ef,0x0c9e0000,0x70ca01ec,0x8679c000,0xe2320000,0xda2202e7,0x5fca839d,0x14da4612,0xd14900a0},
	{0x003c0000,0xccc60149,0xc1120000,0x7c0d0000,0x4dad0122,0x0ffea162,0x465e1b8f,0x26c9cc0a,0xbf190000,0xd8b601e9,0xe73cc000,0x1b910000,0xec28028a,0x9002f50f,0x49e95cf9,0x19cf740e},
	{0x6d2b0000,0xcd89014c,0x5d73c000,0x0f6e0000,0x802202d6,0xbb0b2186,0x4c9e4914,0xd327a0f2,0xe8520000,0x4c0f01e8,0xeba78000,0x46600000,0x5fee028f,0xcf950ad6,0xe2f279e1,0x8743e863},
	{0x57770000,0x587f0148,0xcd894000,0x21fc0000,0xfe6b0127,0x50695ebb,0xed453e97,0xb8455067,0x85450000,0x4d4001ed,0x77c64000,0x35030000,0x9261017b,0x7b608a32,0xe8322b7a,0x72ad849b},
	{0x3a600000,0x5930014d,0x51e88000,0x529f0000,0x33e402d3,0xe49cde5f,0xe7856c0c,0x4dab3c9f,0xd20e0000,0xd9f901ec,0x7b5d0000,0x68f20000,0x21a7017e,0x24f775eb,0x43290e62,0xec2118f6},
	{0x70310000,0x219801b0,0xc39a0000,0xccbb0000,0xf76e0369,0x5124e827,0x4a269167,0xeb7acffb,0xc6750000,0x7dbc0180,0xe4970000,0x9d330000,0xf47300f0,0x7a83fac0,0x2b3f9483,0x35d28bf5},
	{0x1d260000,0x20d701b5,0x5ffbc000,0xbfd80000,0x3ae1009d,0xe5d168c3,0x40e6c3fc,0x1e94a303,0x913e0000,0xe9050181,0xe80c4000,0xc0c20000,0x47b500f5,0x25140519,0x8024b19b,0xab5e1798},
	{0x277a0000,0xb52101b1,0xcf014000,0x914a0000,0x44a8036c,0x0eb317fe,0xe13db47f,0x75f65396,0xfc290000,0xe84a0184,0x746d8000,0xb3a10000,0x8a3a0301,0x91e185fd,0x8ae4e300,0x5eb07b60},
	{0x4a6d0000,0xb46e01b4,0x53608000,0xe2290000,0x89270098,0xba46971a,0xebfde6e4,0x80183f6e,0xab620000,0x7cf30185,0x78f6c000,0xee500000,0x39fc0304,0xce767a24,0x21ffc618,0xc03ce70d},
	{0x9b3f0000,0x317601b9,0x3fc4c000,0x529f0000,0x60390390,0xffccd1eb,0x2744a451,0x0cd7f28b,0x18e50000,0xd48f0180,0x19b3c000,0x17f30000,0x0ff60369,0x01be0cb6,0x7cccdcf3,0x08ba93a3},
	{0xf6280000,0x303901bc,0xa3a50000,0x21fc0000,0xadb60064,0x4b39510f,0x2d84f6ca,0xf9399e73,0x4fae0000,0x40360181,0x15288000,0x4a020000,0xbc30036c,0x5e29f36f,0xd7d7f9eb,0x96360fce},
	{0xcc740000,0xa5cf01b8,0x335f8000,0x0f6e0000,0xd3ff0395,0xa05b2e32,0x8c5f8149,0x925b6ee6,0x22b90000,0x41790184,0x89494000,0x39610000,0x71bf0098,0xeadc738b,0xdd17ab70,0x63d86336},
	{0xa1630000,0xa48001bd,0xaf3e4000,0x7c0d0000,0x1e700061,0x14aeaed6,0x869fd3d2,0x67b5021e,0x75f20000,0xd5c00185,0x85d20000,0x64900000,0xc279009d,0xb54b8c52,0x760c8e68,0xfd54ff5b},
	{0xaea10000,0x88ab01b0,0x3ebec000,0x467b0000,0x0ceb00f0,0x2a191e51,0x1dd5d917,0xd612d7ad,0xf3eb0000,0xc4610189,0xe5ed0000,0x89d70000,0x98a10390,0xaf56357a,0x11aee9c5,0xef17aed3},
	{0xc3b60000,0x89e401b5,0xa2df0000,0x35180000,0xc1640304,0x9eec9eb5,0x17158b8c,0x23fcbb55,0xa4a00000,0x50d80188,0xe9764000,0xd4260000,0x2b670395,0xf0c1caa3,0xbab5ccdd,0x719b32be},
	{0xf9ea0000,0x1c1201b1,0x32258000,0x1b8a0000,0xbf2d00f5,0x758ee188,0xb6cefc0f,0x489e4bc0,0xc9b70000,0x5197018d,0x75178000,0xa7450000,0xe6e80061,0x44344a47,0xb0759e46,0x84755e46},
	{0x94fd0000,0x1d5d01b4,0xae444000,0x68e90000,0x72a20301,0xc17b616c,0xbc0eae94,0xbd702738,0x9efc0000,0xc52e018c,0x798cc000,0xfab40000,0x552e0064,0x1ba3b59e,0x1b6ebb5e,0x1af9c22b},
	{0x45af0000,0x984501b9,0xc2e00000,0xd85f0000,0x9bbc0009,0x84f1279d,0x70b7ec21,0x31bfeadd,0x2d7b0000,0x6d520189,0x18c9c000,0x03170000,0x63240009,0xd46bc30c,0x465da1b5,0xd27fb685},
	{0x28b80000,0x990a01bc,0x5e81c000,0xab3c0000,0x563303fd,0x3004a779,0x7a77beba,0xc4518625,0x7a300000,0xf9eb0188,0x14528000,0x5ee60000,0xd0e2000c,0x8bfc3cd5,0xed4684ad,0x4cf32ae8},
	{0x12e40000,0x0cfc01b8,0xce7b4000,0x85ae0000,0x287a000c,0xdb66d844,0xdbacc939,0xaf3376b0,0x17270000,0xf8a4018d,0x88334000,0x2d850000,0x1d6d03f8,0x3f09bc31,0xe786d636,0xb91d4610},
	{0x7ff30000,0x0db301bd,0x521a8000,0xf6cd0000,0xe5f503f8,0x6f9358a0,0xd16c9ba2,0x5add1a48,0x406c0000,0x6c1d018c,0x84a80000,0x70740000,0xaeab03fd,0x609e43e8,0x4c9df32e,0x2791da7d}
    },{
	{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x8ca20000,0xe4a10000,0x867a0f00,0x0c0d0000,0xde5d0062,0x445d7a15,0x89f3dd7f,0xf900b4a8,0x9d170000,0x35f50000,0xd4310600,0x5d6e0000,0xe251036c,0xcd232d4a,0xf06ce53f,0x09ffa2bb},
	{0x9d170000,0x35f50000,0xd4310600,0x5d6e0000,0xe251036c,0xcd232d4a,0xf06ce53f,0x09ffa2bb,0x11b50000,0xd1540000,0x524b0900,0x51630000,0x3c0c030e,0x897e575f,0x799f3840,0xf0ff1613},
	{0x11b50000,0xd1540000,0x524b0900,0x51630000,0x3c0c030e,0x897e575f,0x799f3840,0xf0ff1613,0x8ca20000,0xe4a10000,0x867a0f00,0x0c0d0000,0xde5d0062,0x445d7a15,0x89f3dd7f,0xf900b4a8},
	{0x51a10000,0x49030000,0x0ffa1700,0x11180000,0xa2b303ca,0x6c37f50c,0x6b24a6f6,0xf0394ad1,0x73e90000,0xe9db0000,0x6ffe0500,0xb3d90000,0x4ae20248,0x9e4b6b91,0xa13f460f,0x9ff6a17b},
	{0xdd030000,0xada20000,0x89801800,0x1d150000,0x7cee03a8,0x286a8f19,0xe2d77b89,0x0939fe79,0xeefe0000,0xdc2e0000,0xbbcf0300,0xeeb70000,0xa8b30124,0x536846db,0x5153a330,0x960903c0},
	{0xccb60000,0x7cf60000,0xdbcb1100,0x4c760000,0x40e200a6,0xa114d846,0x9b4843c9,0xf9c6e86a,0x625c0000,0x388f0000,0x3db50c00,0xe2ba0000,0x76ee0146,0x17353cce,0xd8a07e4f,0x6f09b768},
	{0x40140000,0x98570000,0x5db11e00,0x407b0000,0x9ebf00c4,0xe549a253,0x12bb9eb6,0x00c65cc2,0xff4b0000,0x0d7a0000,0xe9840a00,0xbfd40000,0x94bf022a,0xda161184,0x28cc9b70,0x66f615d3},
	{0x73e90000,0xe9db0000,0x6ffe0500,0xb3d90000,0x4ae20248,0x9e4b6b91,0xa13f460f,0x9ff6a17b,0x22480000,0xa0d80000,0x60041200,0xa2c10000,0xe8510182,0xf27c9e9d,0xca1be0f9,0x6fcfebaa},
	{0xff4b0000,0x0d7a0000,0xe9840a00,0xbfd40000,0x94bf022a,0xda161184,0x28cc9b70,0x66f615d3,0xbf5f0000,0x952d0000,0xb4351400,0xffaf0000,0x0a0002ee,0x3f5fb3d7,0x3a7705c6,0x66304911},
	{0xeefe0000,0xdc2e0000,0xbbcf0300,0xeeb70000,0xa8b30124,0x536846db,0x5153a330,0x960903c0,0x33fd0000,0x718c0000,0x324f1b00,0xf3a20000,0xd45d028c,0x7b02c9c2,0xb384d8b9,0x9f30fdb9},
	{0x625c0000,0x388f0000,0x3db50c00,0xe2ba0000,0x76ee0146,0x17353cce,0xd8a07e4f,0x6f09b768,0xaeea0000,0x44790000,0xe67e1d00,0xaecc0000,0x360c01e0,0xb621e488,0x43e83d86,0x96cf5f02},
	{0x22480000,0xa0d80000,0x60041200,0xa2c10000,0xe8510182,0xf27c9e9d,0xca1be0f9,0x6fcfebaa,0x51a10000,0x49030000,0x0ffa1700,0x11180000,0xa2b303ca,0x6c37f50c,0x6b24a6f6,0xf0394ad1},
	{0xaeea0000,0x44790000,0xe67e1d00,0xaecc0000,0x360c01e0,0xb621e488,0x43e83d86,0x96cf5f02,0xccb60000,0x7cf60000,0xdbcb1100,0x4c760000,0x40e200a6,0xa114d846,0x9b4843c9,0xf9c6e86a},
	{0xbf5f0000,0x952d0000,0xb4351400,0xffaf0000,0x0a0002ee,0x3f5fb3d7,0x3a7705c6,0x66304911,0x40140000,0x98570000,0x5db11e00,0x407b0000,0x9ebf00c4,0xe549a253,0x12bb9eb6,0x00c65cc2},
	{0x33fd0000,0x718c0000,0x324f1b00,0xf3a20000,0xd45d028c,0x7b02c9c2,0xb384d8b9,0x9f30fdb9,0xdd030000,0xada20000,0x89801800,0x1d150000,0x7cee03a8,0x286a8f19,0xe2d77b89,0x0939fe79},
	{0x9b460000,0x10060000,0x1b642700,0x5bf10000,0x4b670305,0x3ff2e2fd,0x974a4d9d,0xee7376be,0xa7330000,0x5ff60000,0xd8f30300,0x27920000,0x15fc039e,0x1805ae02,0x3a5f1c2e,0x3d9d45e4},
	{0x17e40000,0xf4a70000,0x9d1e2800,0x57fc0000,0x953a0367,0x7baf98e8,0x1eb990e2,0x1773c216,0x3a240000,0x6a030000,0x0cc20500,0x7afc0000,0xf7ad00f2,0xd5268348,0xca33f911,0x3462e75f},
	{0x06510000,0x25f30000,0xcf552100,0x069f0000,0xa9360069,0xf2d1cfb7,0x6726a8a2,0xe78cd405,0xb6860000,0x8ea20000,0x8ab80a00,0x76f10000,0x29f00090,0x917bf95d,0x43c0246e,0xcd6253f7},
	{0x8af30000,0xc1520000,0x492f2e00,0x0a920000,0x776b000b,0xb68cb5a2,0xeed575dd,0x1e8c60ad,0x2b910000,0xbb570000,0x5e890c00,0x2b9f0000,0xcba103fc,0x5c58d417,0xb3acc151,0xc49df14c},
	{0xcae70000,0x59050000,0x149e3000,0x4ae90000,0xe9d400cf,0x53c517f1,0xfc6eeb6b,0x1e4a3c6f,0xd4da0000,0xb62d0000,0xb70d0600,0x944b0000,0x5f1e01d6,0x864ec593,0x9b605a21,0xa26be49f},
	{0x46450000,0xbda40000,0x92e43f00,0x46e40000,0x378900ad,0x17986de4,0x759d3614,0xe74a88c7,0x49cd0000,0x83d80000,0x633c0000,0xc9250000,0xbd4f02ba,0x4b6de8d9,0x6b0cbf1e,0xab944624},
	{0x57f00000,0x6cf00000,0xc0af3600,0x17870000,0x0b8503a3,0x9ee63abb,0x0c020e54,0x17b59ed4,0xc56f0000,0x67790000,0xe5460f00,0xc5280000,0x631202d8,0x0f3092cc,0xe2ff6261,0x5294f28c},
	{0xdb520000,0x88510000,0x46d53900,0x1b8a0000,0xd5d803c1,0xdabb40ae,0x85f1d32b,0xeeb52a7c,0x58780000,0x528c0000,0x31770900,0x98460000,0x814301b4,0xc213bf86,0x1293875e,0x5b6b5037},
	{0xe8af0000,0xf9dd0000,0x749a2200,0xe8280000,0x0185014d,0xa1b9896c,0x36750b92,0x7185d7c5,0x857b0000,0xff2e0000,0xb8f71100,0x85530000,0xfdad021c,0xea79309f,0xf044fcd7,0x5252ae4e},
	{0x640d0000,0x1d7c0000,0xf2e02d00,0xe4250000,0xdfd8012f,0xe5e4f379,0xbf86d6ed,0x8885636d,0x186c0000,0xcadb0000,0x6cc61700,0xd83d0000,0x1ffc0170,0x275a1dd5,0x002819e8,0x5bad0cf5},
	{0x75b80000,0xcc280000,0xa0ab2400,0xb5460000,0xe3d40221,0x6c9aa426,0xc619eead,0x787a757e,0x94ce0000,0x2e7a0000,0xeabc1800,0xd4300000,0xc1a10112,0x630767c0,0x89dbc497,0xa2adb85d},
	{0xf91a0000,0x28890000,0x26d12b00,0xb94b0000,0x3d890243,0x28c7de33,0x4fea33d2,0x817ac1d6,0x09d90000,0x1b8f0000,0x3e8d1e00,0x895e0000,0x23f0027e,0xae244a8a,0x79b721a8,0xab521ae6},
	{0xb90e0000,0xb0de0000,0x7b603500,0xf9300000,0xa3360287,0xcd8e7c60,0x5d51ad64,0x81bc9d14,0xf6920000,0x16f50000,0xd7091400,0x368a0000,0xb74f0054,0x74325b0e,0x517bbad8,0xcda40f35},
	{0x35ac0000,0x547f0000,0xfd1a3a00,0xf53d0000,0x7d6b02e5,0x89d30675,0xd4a2701b,0x78bc29bc,0x6b850000,0x23000000,0x03381200,0x6be40000,0x551e0338,0xb9117644,0xa1175fe7,0xc45bad8e},
	{0x24190000,0x852b0000,0xaf513300,0xa45e0000,0x416701eb,0x00ad512a,0xad3d485b,0x88433faf,0xe7270000,0xc7a10000,0x85421d00,0x67e90000,0x8b43035a,0xfd4c0c51,0x28e48298,0x3d5b1926},
	{0xa8bb0000,0x618a0000,0x292b3c00,0xa8530000,0x9f3a0189,0x44f02b3f,0x24ce9524,0x71438b07,0x7a300000,0xf2540000,0x51731b00,0x3a870000,0x69120036,0x306f211b,0xd88867a7,0x34a4bb9d},
	{0xa7330000,0x5ff60000,0xd8f30300,0x27920000,0x15fc039e,0x1805ae02,0x3a5f1c2e,0x3d9d45e4,0x3c750000,0x4ff00000,0xc3972400,0x7c630000,0x5e9b009b,0x27f74cff,0xad1551b3,0xd3ee335a},
	{0x2b910000,0xbb570000,0x5e890c00,0x2b9f0000,0xcba103fc,0x5c58d417,0xb3acc151,0xc49df14c,0xa1620000,0x7a050000,0x17a62200,0x210d0000,0xbcca03f7,0xead461b5,0x5d79b48c,0xda1191e1},
	{0x3a240000,0x6a030000,0x0cc20500,0x7afc0000,0xf7ad00f2,0xd5268348,0xca33f911,0x3462e75f,0x2dc00000,0x9ea40000,0x91dc2d00,0x2d000000,0x62970395,0xae891ba0,0xd48a69f3,0x23112549},
	{0xb6860000,0x8ea20000,0x8ab80a00,0x76f10000,0x29f00090,0x917bf95d,0x43c0246e,0xcd6253f7,0xb0d70000,0xab510000,0x45ed2b00,0x706e0000,0x80c600f9,0x63aa36ea,0x24e68ccc,0x2aee87f2},
	{0xf6920000,0x16f50000,0xd7091400,0x368a0000,0xb74f0054,0x74325b0e,0x517bbad8,0xcda40f35,0x4f9c0000,0xa62b0000,0xac692100,0xcfba0000,0x147902d3,0xb9bc276e,0x0c2a17bc,0x4c189221},
	{0x7a300000,0xf2540000,0x51731b00,0x3a870000,0x69120036,0x306f211b,0xd88867a7,0x34a4bb9d,0xd28b0000,0x93de0000,0x78582700,0x92d40000,0xf62801bf,0x749f0a24,0xfc46f283,0x45e7309a},
	{0x6b850000,0x23000000,0x03381200,0x6be40000,0x551e0338,0xb9117644,0xa1175fe7,0xc45bad8e,0x5e290000,0x777f0000,0xfe222800,0x9ed90000,0x287501dd,0x30c27031,0x75b52ffc,0xbce78432},
	{0xe7270000,0xc7a10000,0x85421d00,0x67e90000,0x8b43035a,0xfd4c0c51,0x28e48298,0x3d5b1926,0xc33e0000,0x428a0000,0x2a132e00,0xc3b70000,0xca2402b1,0xfde15d7b,0x85d9cac3,0xb5182689},
	{0xd4da0000,0xb62d0000,0xb70d0600,0x944b0000,0x5f1e01d6,0x864ec593,0x9b605a21,0xa26be49f,0x1e3d0000,0xef280000,0xa3933600,0xdea20000,0xb6ca0119,0xd58bd262,0x670eb14a,0xbc21d8f0},
	{0x58780000,0x528c0000,0x31770900,0x98460000,0x814301b4,0xc213bf86,0x1293875e,0x5b6b5037,0x832a0000,0xdadd0000,0x77a23000,0x83cc0000,0x549b0275,0x18a8ff28,0x97625475,0xb5de7a4b},
	{0x49cd0000,0x83d80000,0x633c0000,0xc9250000,0xbd4f02ba,0x4b6de8d9,0x6b0cbf1e,0xab944624,0x0f880000,0x3e7c0000,0xf1d83f00,0x8fc10000,0x8ac60217,0x5cf5853d,0x1e91890a,0x4cdecee3},
	{0xc56f0000,0x67790000,0xe5460f00,0xc5280000,0x631202d8,0x0f3092cc,0xe2ff6261,0x5294f28c,0x929f0000,0x0b890000,0x25e93900,0xd2af0000,0x6897017b,0x91d6a877,0xeefd6c35,0x45216c58},
	{0x857b0000,0xff2e0000,0xb8f71100,0x85530000,0xfdad021c,0xea79309f,0xf044fcd7,0x5252ae4e,0x6dd40000,0x06f30000,0xcc6d3300,0x6d7b0000,0xfc280351,0x4bc0b9f3,0xc631f745,0x23d7798b},
	{0x09d90000,0x1b8f0000,0x3e8d1e00,0x895e0000,0x23f0027e,0xae244a8a,0x79b721a8,0xab521ae6,0xf0c30000,0x33060000,0x185c3500,0x30150000,0x1e79003d,0x86e394b9,0x365d127a,0x2a28db30},
	{0x186c0000,0xcadb0000,0x6cc61700,0xd83d0000,0x1ffc0170,0x275a1dd5,0x002819e8,0x5bad0cf5,0x7c610000,0xd7a70000,0x9e263a00,0x3c180000,0xc024005f,0xc2beeeac,0xbfaecf05,0xd3286f98},
	{0x94ce0000,0x2e7a0000,0xeabc1800,0xd4300000,0xc1a10112,0x630767c0,0x89dbc497,0xa2adb85d,0xe1760000,0xe2520000,0x4a173c00,0x61760000,0x22750333,0x0f9dc3e6,0x4fc22a3a,0xdad7cd23},
	{0x3c750000,0x4ff00000,0xc3972400,0x7c630000,0x5e9b009b,0x27f74cff,0xad1551b3,0xd3ee335a,0x9b460000,0x10060000,0x1b642700,0x5bf10000,0x4b670305,0x3ff2e2fd,0x974a4d9d,0xee7376be},
	{0xb0d70000,0xab510000,0x45ed2b00,0x706e0000,0x80c600f9,0x63aa36ea,0x24e68ccc,0x2aee87f2,0x06510000,0x25f30000,0xcf552100,0x069f0000,0xa9360069,0xf2d1cfb7,0x6726a8a2,0xe78cd405},
	{0xa1620000,0x7a050000,0x17a62200,0x210d0000,0xbcca03f7,0xead461b5,0x5d79b48c,0xda1191e1,0x8af30000,0xc1520000,0x492f2e00,0x0a920000,0x776b000b,0xb68cb5a2,0xeed575dd,0x1e8c60ad},
	{0x2dc00000,0x9ea40000,0x91dc2d00,0x2d000000,0x62970395,0xae891ba0,0xd48a69f3,0x23112549,0x17e40000,0xf4a70000,0x9d1e2800,0x57fc0000,0x953a0367,0x7baf98e8,0x1eb990e2,0x1773c216},
	{0x6dd40000,0x06f30000,0xcc6d3300,0x6d7b0000,0xfc280351,0x4bc0b9f3,0xc631f745,0x23d7798b,0xe8af0000,0xf9dd0000,0x749a2200,0xe8280000,0x0185014d,0xa1b9896c,0x36750b92,0x7185d7c5},
	{0xe1760000,0xe2520000,0x4a173c00,0x61760000,0x22750333,0x0f9dc3e6,0x4fc22a3a,0xdad7cd23,0x75b80000,0xcc280000,0xa0ab2400,0xb5460000,0xe3d40221,0x6c9aa426,0xc619eead,0x787a757e},
	{0xf0c30000,0x33060000,0x185c3500,0x30150000,0x1e79003d,0x86e394b9,0x365d127a,0x2a28db30,0xf91a0000,0x28890000,0x26d12b00,0xb94b0000,0x3d890243,0x28c7de33,0x4fea33d2,0x817ac1d6},
	{0x7c610000,0xd7a70000,0x9e263a00,0x3c180000,0xc024005f,0xc2beeeac,0xbfaecf05,0xd3286f98,0x640d0000,0x1d7c0000,0xf2e02d00,0xe4250000,0xdfd8012f,0xe5e4f379,0xbf86d6ed,0x8885636d},
	{0x4f9c0000,0xa62b0000,0xac692100,0xcfba0000,0x147902d3,0xb9bc276e,0x0c2a17bc,0x4c189221,0xb90e0000,0xb0de0000,0x7b603500,0xf9300000,0xa3360287,0xcd8e7c60,0x5d51ad64,0x81bc9d14},
	{0xc33e0000,0x428a0000,0x2a132e00,0xc3b70000,0xca2402b1,0xfde15d7b,0x85d9cac3,0xb5182689,0x24190000,0x852b0000,0xaf513300,0xa45e0000,0x416701eb,0x00ad512a,0xad3d485b,0x88433faf},
	{0xd28b0000,0x93de0000,0x78582700,0x92d40000,0xf62801bf,0x749f0a24,0xfc46f283,0x45e7309a,0xa8bb0000,0x618a0000,0x292b3c00,0xa8530000,0x9f3a0189,0x44f02b3f,0x24ce9524,0x71438b07},
	{0x5e290000,0x777f0000,0xfe222800,0x9ed90000,0x287501dd,0x30c27031,0x75b52ffc,0xbce78432,0x35ac0000,0x547f0000,0xfd1a3a00,0xf53d0000,0x7d6b02e5,0x89d30675,0xd4a2701b,0x78bc29bc},
	{0x1e3d0000,0xef280000,0xa3933600,0xdea20000,0xb6ca0119,0xd58bd262,0x670eb14a,0xbc21d8f0,0xcae70000,0x59050000,0x149e3000,0x4ae90000,0xe9d400cf,0x53c517f1,0xfc6eeb6b,0x1e4a3c6f},
	{0x929f0000,0x0b890000,0x25e93900,0xd2af0000,0x6897017b,0x91d6a877,0xeefd6c35,0x45216c58,0x57f00000,0x6cf00000,0xc0af3600,0x17870000,0x0b8503a3,0x9ee63abb,0x0c020e54,0x17b59ed4},
	{0x832a0000,0xdadd0000,0x77a23000,0x83cc0000,0x549b0275,0x18a8ff28,0x97625475,0xb5de7a4b,0xdb520000,0x88510000,0x46d53900,0x1b8a0000,0xd5d803c1,0xdabb40ae,0x85f1d32b,0xeeb52a7c},
	{0x0f880000,0x3e7c0000,0xf1d83f00,0x8fc10000,0x8ac60217,0x5cf5853d,0x1e91890a,0x4cdecee3,0x46450000,0xbda40000,0x92e43f00,0x46e40000,0x378900ad,0x17986de4,0x759d3614,0xe74a88c7},
	{0x0a1b0000,0xc1bf0003,0x5e78c000,0xb9c20000,0x2fdb0032,0x2bfb6400,0xb9636775,0xfaeb45b5,0xab260000,0x42400001,0x17cb8000,0xb6190000,0x1fe70243,0xac0ce7fc,0xc90c9b94,0x085ece77},
	{0x86b90000,0x251e0003,0xd802cf00,0xb5cf0000,0xf1860050,0x6fa61e15,0x3090ba0a,0x03ebf11d,0x36310000,0x77b50001,0xc3fa8600,0xeb770000,0xfdb6012f,0x612fcab6,0x39607eab,0x01a16ccc},
	{0x970c0000,0xf44a0003,0x8a49c600,0xe4ac0000,0xcd8a035e,0xe6d8494a,0x490f824a,0xf314e70e,0xba930000,0x93140001,0x45808900,0xe77a0000,0x23eb014d,0x2572b0a3,0xb093a3d4,0xf8a1d864},
	{0x1bae0000,0x10eb0003,0x0c33c900,0xe8a10000,0x13d7033c,0xa285335f,0xc0fc5f35,0x0a1453a6,0x27840000,0xa6e10001,0x91b18f00,0xba140000,0xc1ba0221,0xe8519de9,0x40ff46eb,0xf15e7adf},
	{0x5bba0000,0x88bc0003,0x5182d700,0xa8da0000,0x8d6803f8,0x47cc910c,0xd247c183,0x0ad20f64,0xd8cf0000,0xab9b0001,0x78358500,0x05c00000,0x5505000b,0x32478c6d,0x6833dd9b,0x97a86f0c},
	{0xd7180000,0x6c1d0003,0xd7f8d800,0xa4d70000,0x5335039a,0x0391eb19,0x5bb41cfc,0xf3d2bbcc,0x45d80000,0x9e6e0001,0xac048300,0x58ae0000,0xb7540367,0xff64a127,0x985f38a4,0x9e57cdb7},
	{0xc6ad0000,0xbd490003,0x85b3d100,0xf5b40000,0x6f390094,0x8aefbc46,0x222b24bc,0x032daddf,0xc97a0000,0x7acf0001,0x2a7e8c00,0x54a30000,0x69090305,0xbb39db32,0x11ace5db,0x6757791f},
	{0x4a0f0000,0x59e80003,0x03c9de00,0xf9b90000,0xb16400f6,0xceb2c653,0xabd8f9c3,0xfa2d1977,0x546d0000,0x4f3a0001,0xfe4f8a00,0x09cd0000,0x8b580069,0x761af678,0xe1c000e4,0x6ea8dba4},
	{0x79f20000,0x28640003,0x3186c500,0x0a1b0000,0x6539027a,0xb5b00f91,0x185c217a,0x651de4ce,0x896e0000,0xe2980001,0x77cf9200,0x14d80000,0xf7b603c1,0x5e707961,0x03177b6d,0x679125dd},
	{0xf5500000,0xccc50003,0xb7fcca00,0x06160000,0xbb640218,0xf1ed7584,0x91affc05,0x9c1d5066,0x14790000,0xd76d0001,0xa3fe9400,0x49b60000,0x15e700ad,0x9353542b,0xf37b9e52,0x6e6e8766},
	{0xe4e50000,0x1d910003,0xe5b7c300,0x57750000,0x87680116,0x789322db,0xe830c445,0x6ce24675,0x98db0000,0x33cc0001,0x25849b00,0x45bb0000,0xcbba00cf,0xd70e2e3e,0x7a88432d,0x976e33ce},
	{0x68470000,0xf9300003,0x63cdcc00,0x5b780000,0x59350174,0x3cce58ce,0x61c3193a,0x95e2f2dd,0x05cc0000,0x06390001,0xf1b59d00,0x18d50000,0x29eb03a3,0x1a2d0374,0x8ae4a612,0x9e919175},
	{0x28530000,0x61670003,0x3e7cd200,0x1b030000,0xc78a01b0,0xd987fa9d,0x7378878c,0x9524ae1f,0xfa870000,0x0b430001,0x18319700,0xa7010000,0xbd540189,0xc03b12f0,0xa2283d62,0xf86784a6},
	{0xa4f10000,0x85c60003,0xb806dd00,0x170e0000,0x19d701d2,0x9dda8088,0xfa8b5af3,0x6c241ab7,0x67900000,0x3eb60001,0xcc009100,0xfa6f0000,0x5f0502e5,0x0d183fba,0x5244d85d,0xf198261d},
	{0xb5440000,0x54920003,0xea4dd400,0x466d0000,0x25db02dc,0x14a4d7d7,0x831462b3,0x9cdb0ca4,0xeb320000,0xda170001,0x4a7a9e00,0xf6620000,0x81580287,0x494545af,0xdbb70522,0x089892b5},
	{0x39e60000,0xb0330003,0x6c37db00,0x4a600000,0xfb8602be,0x50f9adc2,0x0ae7bfcc,0x65dbb80c,0x76250000,0xefe20001,0x9e4b9800,0xab0c0000,0x630901eb,0x846668e5,0x2bdbe01d,0x0167300e},
	{0x915d0000,0xd1b90003,0x451ce700,0xe2330000,0x64bc0337,0x140986fd,0x2e292ae8,0x1498330b,0x0c150000,0x1db60001,0xcf388300,0x918b0000,0x0a1b01dd,0xb40949fe,0xf35387ba,0x35c38b93},
	{0x1dff0000,0x35180003,0xc366e800,0xee3e0000,0xbae10355,0x5054fce8,0xa7daf797,0xed9887a3,0x91020000,0x28430001,0x1b098500,0xcce50000,0xe84a02b1,0x792a64b4,0x033f6285,0x3c3c2928},
	{0x0c4a0000,0xe44c0003,0x912de100,0xbf5d0000,0x86ed005b,0xd92aabb7,0xde45cfd7,0x1d6791b0,0x1da00000,0xcce20001,0x9d738a00,0xc0e80000,0x361702d3,0x3d771ea1,0x8accbffa,0xc53c9d80},
	{0x80e80000,0x00ed0003,0x1757ee00,0xb3500000,0x58b00039,0x9d77d1a2,0x57b612a8,0xe4672518,0x80b70000,0xf9170001,0x49428c00,0x9d860000,0xd44601bf,0xf05433eb,0x7aa05ac5,0xccc33f3b},
	{0xc0fc0000,0x98ba0003,0x4ae6f000,0xf32b0000,0xc60f00fd,0x783e73f1,0x450d8c1e,0xe4a179da,0x7ffc0000,0xf46d0001,0xa0c68600,0x22520000,0x40f90395,0x2a42226f,0x526cc1b5,0xaa352ae8},
	{0x4c5e0000,0x7c1b0003,0xcc9cff00,0xff260000,0x1852009f,0x3c6309e4,0xccfe5161,0x1da1cd72,0xe2eb0000,0xc1980001,0x74f78000,0x7f3c0000,0xa2a800f9,0xe7610f25,0xa200248a,0xa3ca8853},
	{0x5deb0000,0xad4f0003,0x9ed7f600,0xae450000,0x245e0391,0xb51d5ebb,0xb5616921,0xed5edb61,0x6e490000,0x25390001,0xf28d8f00,0x73310000,0x7cf5009b,0xa33c7530,0x2bf3f9f5,0x5aca3cfb},
	{0xd1490000,0x49ee0003,0x18adf900,0xa2480000,0xfa0303f3,0xf14024ae,0x3c92b45e,0x145e6fc9,0xf35e0000,0x10cc0001,0x26bc8900,0x2e5f0000,0x9ea403f7,0x6e1f587a,0xdb9f1cca,0x53359e40},
	{0xe2b40000,0x38620003,0x2ae2e200,0x51ea0000,0x2e5e017f,0x8a42ed6c,0x8f166ce7,0x8b6e9270,0x2e5d0000,0xbd6e0001,0xaf3c9100,0x334a0000,0xe24a005f,0x4675d763,0x39486743,0x5a0c6039},
	{0x6e160000,0xdcc30003,0xac98ed00,0x5de70000,0xf003011d,0xce1f9779,0x06e5b198,0x726e26d8,0xb34a0000,0x889b0001,0x7b0d9700,0x6e240000,0x001b0333,0x8b56fa29,0xc924827c,0x53f3c282},
	{0x7fa30000,0x0d970003,0xfed3e400,0x0c840000,0xcc0f0213,0x4761c026,0x7f7a89d8,0x829130cb,0x3fe80000,0x6c3a0001,0xfd779800,0x62290000,0xde460351,0xcf0b803c,0x40d75f03,0xaaf3762a},
	{0xf3010000,0xe9360003,0x78a9eb00,0x00890000,0x12520271,0x033cba33,0xf68954a7,0x7b918463,0xa2ff0000,0x59cf0001,0x29469e00,0x3f470000,0x3c17003d,0x0228ad76,0xb0bbba3c,0xa30cd491},
	{0xb3150000,0x71610003,0x2518f500,0x40f20000,0x8ced02b5,0xe6751860,0xe432ca11,0x7b57d8a1,0x5db40000,0x54b50001,0xc0c29400,0x80930000,0xa8a80217,0xd83ebcf2,0x9877214c,0xc5fac142},
	{0x3fb70000,0x95c00003,0xa362fa00,0x4cff0000,0x52b002d7,0xa2286275,0x6dc1176e,0x82576c09,0xc0a30000,0x61400001,0x14f39200,0xddfd0000,0x4af9017b,0x151d91b8,0x681bc473,0xcc0563f9},
	{0x2e020000,0x44940003,0xf129f300,0x1d9c0000,0x6ebc01d9,0x2b56352a,0x145e2f2e,0x72a87a1a,0x4c010000,0x85e10001,0x92899d00,0xd1f00000,0x94a40119,0x5140ebad,0xe1e8190c,0x3505d751},
	{0xa2a00000,0xa0350003,0x7753fc00,0x11910000,0xb0e101bb,0x6f0b4f3f,0x9dadf251,0x8ba8ceb2,0xd1160000,0xb0140001,0x46b89b00,0x8c9e0000,0x76f50275,0x9c63c6e7,0x1184fc33,0x3cfa75ea},
	{0xad280000,0x9e490003,0x868bc300,0x9e500000,0x3a2703ac,0x33feca02,0x833c7b5b,0xc7760051,0x97530000,0x0db00001,0xd45ca400,0xca7a0000,0x417c02d8,0x8bfbab03,0x6419ca27,0xdbb0fd2d},
	{0x218a0000,0x7ae80003,0x00f1cc00,0x925d0000,0xe47a03ce,0x77a3b017,0x0acfa624,0x3e76b4f9,0x0a440000,0x38450001,0x006da200,0x97140000,0xa32d01b4,0x46d88649,0x94752f18,0xd24f5f96},
	{0x303f0000,0xabbc0003,0x52bac500,0xc33e0000,0xd87600c0,0xfedde748,0x73509e64,0xce89a2ea,0x86e60000,0xdce40001,0x8617ad00,0x9b190000,0x7d7001d6,0x0285fc5c,0x1d86f267,0x2b4feb3e},
	{0xbc9d0000,0x4f1d0003,0xd4c0ca00,0xcf330000,0x062b00a2,0xba809d5d,0xfaa3431b,0x37891642,0x1bf10000,0xe9110001,0x5226ab00,0xc6770000,0x9f2102ba,0xcfa6d116,0xedea1758,0x22b04985},
	{0xfc890000,0xd74a0003,0x8971d400,0x8f480000,0x98940066,0x5fc93f0e,0xe818ddad,0x374f4a80,0xe4ba0000,0xe46b0001,0xbba2a100,0x79a30000,0x0b9e0090,0x15b0c092,0xc5268c28,0x44465c56},
	{0x702b0000,0x33eb0003,0x0f0bdb00,0x83450000,0x46c90004,0x1b94451b,0x61eb00d2,0xce4ffe28,0x79ad0000,0xd19e0001,0x6f93a700,0x24cd0000,0xe9cf03fc,0xd893edd8,0x354a6917,0x4db9feed},
	{0x619e0000,0xe2bf0003,0x5d40d200,0xd2260000,0x7ac5030a,0x92ea1244,0x18743892,0x3eb0e83b,0xf50f0000,0x353f0001,0xe9e9a800,0x28c00000,0x3792039e,0x9cce97cd,0xbcb9b468,0xb4b94a45},
	{0xed3c0000,0x061e0003,0xdb3add00,0xde2b0000,0xa4980368,0xd6b76851,0x9187e5ed,0xc7b05c93,0x68180000,0x00ca0001,0x3dd8ae00,0x75ae0000,0xd5c300f2,0x51edba87,0x4cd55157,0xbd46e8fe},
	{0xdec10000,0x77920003,0xe975c600,0x2d890000,0x70c501e4,0xadb5a193,0x22033d54,0x5880a12a,0xb51b0000,0xad680001,0xb458b600,0x68bb0000,0xa92d035a,0x7987359e,0xae022ade,0xb47f1687},
	{0x52630000,0x93330003,0x6f0fc900,0x21840000,0xae980186,0xe9e8db86,0xabf0e02b,0xa1801582,0x280c0000,0x989d0001,0x6069b000,0x35d50000,0x4b7c0036,0xb4a418d4,0x5e6ecfe1,0xbd80b43c},
	{0x43d60000,0x42670003,0x3d44c000,0x70e70000,0x92940288,0x60968cd9,0xd26fd86b,0x517f0391,0xa4ae0000,0x7c3c0001,0xe613bf00,0x39d80000,0x95210054,0xf0f962c1,0xd79d129e,0x44800094},
	{0xcf740000,0xa6c60003,0xbb3ecf00,0x7cea0000,0x4cc902ea,0x24cbf6cc,0x5b9c0514,0xa87fb739,0x39b90000,0x49c90001,0x3222b900,0x64b60000,0x77700338,0x3dda4f8b,0x27f1f7a1,0x4d7fa22f},
	{0x8f600000,0x3e910003,0xe68fd100,0x3c910000,0xd276022e,0xc182549f,0x49279ba2,0xa8b9ebfb,0xc6f20000,0x44b30001,0xdba6b300,0xdb620000,0xe3cf0112,0xe7cc5e0f,0x0f3d6cd1,0x2b89b7fc},
	{0x03c20000,0xda300003,0x60f5de00,0x309c0000,0x0c2b024c,0x85df2e8a,0xc0d446dd,0x51b95f53,0x5be50000,0x71460001,0x0f97b500,0x860c0000,0x019e027e,0x2aef7345,0xff5189ee,0x22761547},
	{0x12770000,0x0b640003,0x32bed700,0x61ff0000,0x30270142,0x0ca179d5,0xb94b7e9d,0xa1464940,0xd7470000,0x95e70001,0x89edba00,0x8a010000,0xdfc3021c,0x6eb20950,0x76a25491,0xdb76a1ef},
	{0x9ed50000,0xefc50003,0xb4c4d800,0x6df20000,0xee7a0120,0x48fc03c0,0x30b8a3e2,0x5846fde8,0x4a500000,0xa0120001,0x5ddcbc00,0xd76f0000,0x3d920170,0xa391241a,0x86ceb1ae,0xd2890354},
	{0x366e0000,0x8e4f0003,0x9defe400,0xc5a10000,0x714000a9,0x0c0c28ff,0x147636c6,0x290576ef,0x30600000,0x52460001,0x0cafa700,0xede80000,0x54800146,0x93fe0501,0x5e46d609,0xe62db8c9},
	{0xbacc0000,0x6aee0003,0x1b95eb00,0xc9ac0000,0xaf1d00cb,0x485152ea,0x9d85ebb9,0xd005c247,0xad770000,0x67b30001,0xd89ea100,0xb0860000,0xb6d1022a,0x5edd284b,0xae2a3336,0xefd21a72},
	{0xab790000,0xbbba0003,0x49dee200,0x98cf0000,0x931103c5,0xc12f05b5,0xe41ad3f9,0x20fad454,0x21d50000,0x83120001,0x5ee4ae00,0xbc8b0000,0x688c0248,0x1a80525e,0x27d9ee49,0x16d2aeda},
	{0x27db0000,0x5f1b0003,0xcfa4ed00,0x94c20000,0x4d4c03a7,0x85727fa0,0x6de90e86,0xd9fa60fc,0xbcc20000,0xb6e70001,0x8ad5a800,0xe1e50000,0x8add0124,0xd7a37f14,0xd7b50b76,0x1f2d0c61},
	{0x67cf0000,0xc74c0003,0x9215f300,0xd4b90000,0xd3f30363,0x603bddf3,0x7f529030,0xd93c3c3e,0x43890000,0xbb9d0001,0x6351a200,0x5e310000,0x1e62030e,0x0db56e90,0xff799006,0x79db19b2},
	{0xeb6d0000,0x23ed0003,0x146ffc00,0xd8b40000,0x0dae0301,0x2466a7e6,0xf6a14d4f,0x203c8896,0xde9e0000,0x8e680001,0xb760a400,0x035f0000,0xfc330062,0xc09643da,0x0f157539,0x7024bb09},
	{0xfad80000,0xf2b90003,0x4624f500,0x89d70000,0x31a2000f,0xad18f0b9,0x8f3e750f,0xd0c39e85,0x523c0000,0x6ac90001,0x311aab00,0x0f520000,0x226e0000,0x84cb39cf,0x86e6a846,0x89240fa1},
	{0x767a0000,0x16180003,0xc05efa00,0x85da0000,0xefff006d,0xe9458aac,0x06cda870,0x29c32a2d,0xcf2b0000,0x5f3c0001,0xe52bad00,0x523c0000,0xc03f036c,0x49e81485,0x768a4d79,0x80dbad1a},
	{0x45870000,0x67940003,0xf211e100,0x76780000,0x3ba202e1,0x9247436e,0xb54970c9,0xb6f3d794,0x12280000,0xf29e0001,0x6cabb500,0x4f290000,0xbcd100c4,0x61829b9c,0x945d36f0,0x89e25363},
	{0xc9250000,0x83350003,0x746bee00,0x7a750000,0xe5ff0283,0xd61a397b,0x3cbaadb6,0x4ff3633c,0x8f3f0000,0xc76b0001,0xb89ab300,0x12470000,0x5e8003a8,0xaca1b6d6,0x6431d3cf,0x801df1d8},
	{0xd8900000,0x52610003,0x2620e700,0x2b160000,0xd9f3018d,0x5f646e24,0x452595f6,0xbf0c752f,0x039d0000,0x23ca0001,0x3ee0bc00,0x1e4a0000,0x80dd03ca,0xe8fcccc3,0xedc20eb0,0x791d4570},
	{0x54320000,0xb6c00003,0xa05ae800,0x271b0000,0x07ae01ef,0x1b391431,0xccd64889,0x460cc187,0x9e8a0000,0x163f0001,0xead1ba00,0x43240000,0x628c00a6,0x25dfe189,0x1daeeb8f,0x70e2e7cb},
	{0x14260000,0x2e970003,0xfdebf600,0x67600000,0x9911012b,0xfe70b662,0xde6dd63f,0x46ca9d45,0x61c10000,0x1b450001,0x0355b000,0xfcf00000,0xf633028c,0xffc9f00d,0x356270ff,0x1614f218},
	{0x98840000,0xca360003,0x7b91f900,0x6b6d0000,0x474c0149,0xba2dcc77,0x579e0b40,0xbfca29ed,0xfcd60000,0x2eb00001,0xd764b600,0xa19e0000,0x146201e0,0x32eadd47,0xc50e95c0,0x1feb50a3},
	{0x89310000,0x1b620003,0x29daf000,0x3a0e0000,0x7b400247,0x33539b28,0x2e013300,0x4f353ffe,0x70740000,0xca110001,0x511eb900,0xad930000,0xca3f0182,0x76b7a752,0x4cfd48bf,0xe6ebe40b},
	{0x05930000,0xffc30003,0xafa0ff00,0x36030000,0xa51d0225,0x770ee13d,0xa7f2ee7f,0xb6358b56,0xed630000,0xffe40001,0x852fbf00,0xf0fd0000,0x286e02ee,0xbb948a18,0xbc91ad80,0xef1446b0},
	{0xab260000,0x42400001,0x17cb8000,0xb6190000,0x1fe70243,0xac0ce7fc,0xc90c9b94,0x085ece77,0xa13d0000,0x83ff0002,0x49b34000,0x0fdb0000,0x303c0271,0x87f783fc,0x706ffce1,0xf2b58bc2},
	{0x27840000,0xa6e10001,0x91b18f00,0xba140000,0xc1ba0221,0xe8519de9,0x40ff46eb,0xf15e7adf,0x3c2a0000,0xb60a0002,0x9d824600,0x52b50000,0xd26d011d,0x4ad4aeb6,0x800319de,0xfb4a2979},
	{0x36310000,0x77b50001,0xc3fa8600,0xeb770000,0xfdb6012f,0x612fcab6,0x39607eab,0x01a16ccc,0xb0880000,0x52ab0002,0x1bf84900,0x5eb80000,0x0c30017f,0x0e89d4a3,0x09f0c4a1,0x024a9dd1},
	{0xba930000,0x93140001,0x45808900,0xe77a0000,0x23eb014d,0x2572b0a3,0xb093a3d4,0xf8a1d864,0x2d9f0000,0x675e0002,0xcfc94f00,0x03d60000,0xee610213,0xc3aaf9e9,0xf99c219e,0x0bb53f6a},
	{0xfa870000,0x0b430001,0x18319700,0xa7010000,0xbd540189,0xc03b12f0,0xa2283d62,0xf86784a6,0xd2d40000,0x6a240002,0x264d4500,0xbc020000,0x7ade0039,0x19bce86d,0xd150baee,0x6d432ab9},
	{0x76250000,0xefe20001,0x9e4b9800,0xab0c0000,0x630901eb,0x846668e5,0x2bdbe01d,0x0167300e,0x4fc30000,0x5fd10002,0xf27c4300,0xe16c0000,0x988f0355,0xd49fc527,0x213c5fd1,0x64bc8802},
	{0x67900000,0x3eb60001,0xcc009100,0xfa6f0000,0x5f0502e5,0x0d183fba,0x5244d85d,0xf198261d,0xc3610000,0xbb700002,0x74064c00,0xed610000,0x46d20337,0x90c2bf32,0xa8cf82ae,0x9dbc3caa},
	{0xeb320000,0xda170001,0x4a7a9e00,0xf6620000,0x81580287,0x494545af,0xdbb70522,0x089892b5,0x5e760000,0x8e850002,0xa0374a00,0xb00f0000,0xa483005b,0x5de19278,0x58a36791,0x94439e11},
	{0xd8cf0000,0xab9b0001,0x78358500,0x05c00000,0x5505000b,0x32478c6d,0x6833dd9b,0x97a86f0c,0x83750000,0x23270002,0x29b75200,0xad1a0000,0xd86d03f3,0x758b1d61,0xba741c18,0x9d7a6068},
	{0x546d0000,0x4f3a0001,0xfe4f8a00,0x09cd0000,0x8b580069,0x761af678,0xe1c000e4,0x6ea8dba4,0x1e620000,0x16d20002,0xfd865400,0xf0740000,0x3a3c009f,0xb8a8302b,0x4a18f927,0x9485c2d3},
	{0x45d80000,0x9e6e0001,0xac048300,0x58ae0000,0xb7540367,0xff64a127,0x985f38a4,0x9e57cdb7,0x92c00000,0xf2730002,0x7bfc5b00,0xfc790000,0xe46100fd,0xfcf54a3e,0xc3eb2458,0x6d85767b},
	{0xc97a0000,0x7acf0001,0x2a7e8c00,0x54a30000,0x69090305,0xbb39db32,0x11ace5db,0x6757791f,0x0fd70000,0xc7860002,0xafcd5d00,0xa1170000,0x06300391,0x31d66774,0x3387c167,0x647ad4c0},
	{0x896e0000,0xe2980001,0x77cf9200,0x14d80000,0xf7b603c1,0x5e707961,0x03177b6d,0x679125dd,0xf09c0000,0xcafc0002,0x46495700,0x1ec30000,0x928f01bb,0xebc076f0,0x1b4b5a17,0x028cc113},
	{0x05cc0000,0x06390001,0xf1b59d00,0x18d50000,0x29eb03a3,0x1a2d0374,0x8ae4a612,0x9e919175,0x6d8b0000,0xff090002,0x92785100,0x43ad0000,0x70de02d7,0x26e35bba,0xeb27bf28,0x0b7363a8},
	{0x14790000,0xd76d0001,0xa3fe9400,0x49b60000,0x15e700ad,0x9353542b,0xf37b9e52,0x6e6e8766,0xe1290000,0x1ba80002,0x14025e00,0x4fa00000,0xae8302b5,0x62be21af,0x62d46257,0xf273d700},
	{0x98db0000,0x33cc0001,0x25849b00,0x45bb0000,0xcbba00cf,0xd70e2e3e,0x7a88432d,0x976e33ce,0x7c3e0000,0x2e5d0002,0xc0335800,0x12ce0000,0x4cd201d9,0xaf9d0ce5,0x92b88768,0xfb8c75bb},
	{0x30600000,0x52460001,0x0cafa700,0xede80000,0x54800146,0x93fe0501,0x5e46d609,0xe62db8c9,0x060e0000,0xdc090002,0x91404300,0x28490000,0x25c001ef,0x9ff22dfe,0x4a30e0cf,0xcf28ce26},
	{0xbcc20000,0xb6e70001,0x8ad5a800,0xe1e50000,0x8add0124,0xd7a37f14,0xd7b50b76,0x1f2d0c61,0x9b190000,0xe9fc0002,0x45714500,0x75270000,0xc7910283,0x52d100b4,0xba5c05f0,0xc6d76c9d},
	{0xad770000,0x67b30001,0xd89ea100,0xb0860000,0xb6d1022a,0x5edd284b,0xae2a3336,0xefd21a72,0x17bb0000,0x0d5d0002,0xc30b4a00,0x792a0000,0x19cc02e1,0x168c7aa1,0x33afd88f,0x3fd7d835},
	{0x21d50000,0x83120001,0x5ee4ae00,0xbc8b0000,0x688c0248,0x1a80525e,0x27d9ee49,0x16d2aeda,0x8aac0000,0x38a80002,0x173a4c00,0x24440000,0xfb9d018d,0xdbaf57eb,0xc3c33db0,0x36287a8e},
	{0x61c10000,0x1b450001,0x0355b000,0xfcf00000,0xf633028c,0xffc9f00d,0x356270ff,0x1614f218,0x75e70000,0x35d20002,0xfebe4600,0x9b900000,0x6f2203a7,0x01b9466f,0xeb0fa6c0,0x50de6f5d},
	{0xed630000,0xffe40001,0x852fbf00,0xf0fd0000,0x286e02ee,0xbb948a18,0xbc91ad80,0xef1446b0,0xe8f00000,0x00270002,0x2a8f4000,0xc6fe0000,0x8d7300cb,0xcc9a6b25,0x1b6343ff,0x5921cde6},
	{0xfcd60000,0x2eb00001,0xd764b600,0xa19e0000,0x146201e0,0x32eadd47,0xc50e95c0,0x1feb50a3,0x64520000,0xe4860002,0xacf54f00,0xcaf30000,0x532e00a9,0x88c71130,0x92909e80,0xa021794e},
	{0x70740000,0xca110001,0x511eb900,0xad930000,0xca3f0182,0x76b7a752,0x4cfd48bf,0xe6ebe40b,0xf9450000,0xd1730002,0x78c44900,0x979d0000,0xb17f03c5,0x45e43c7a,0x62fc7bbf,0xa9dedbf5},
	{0x43890000,0xbb9d0001,0x6351a200,0x5e310000,0x1e62030e,0x0db56e90,0xff799006,0x79db19b2,0x24460000,0x7cd10002,0xf1445100,0x8a880000,0xcd91006d,0x6d8eb363,0x802b0036,0xa0e7258c},
	{0xcf2b0000,0x5f3c0001,0xe52bad00,0x523c0000,0xc03f036c,0x49e81485,0x768a4d79,0x80dbad1a,0xb9510000,0x49240002,0x25755700,0xd7e60000,0x2fc00301,0xa0ad9e29,0x7047e509,0xa9188737},
	{0xde9e0000,0x8e680001,0xb760a400,0x035f0000,0xfc330062,0xc09643da,0x0f157539,0x7024bb09,0x35f30000,0xad850002,0xa30f5800,0xdbeb0000,0xf19d0363,0xe4f0e43c,0xf9b43876,0x5018339f},
	{0x523c0000,0x6ac90001,0x311aab00,0x0f520000,0x226e0000,0x84cb39cf,0x86e6a846,0x89240fa1,0xa8e40000,0x98700002,0x773e5e00,0x86850000,0x13cc000f,0x29d3c976,0x09d8dd49,0x59e79124},
	{0x12280000,0xf29e0001,0x6cabb500,0x4f290000,0xbcd100c4,0x61829b9c,0x945d36f0,0x89e25363,0x57af0000,0x950a0002,0x9eba5400,0x39510000,0x87730225,0xf3c5d8f2,0x21144639,0x3f1184f7},
	{0x9e8a0000,0x163f0001,0xead1ba00,0x43240000,0x628c00a6,0x25dfe189,0x1daeeb8f,0x70e2e7cb,0xcab80000,0xa0ff0002,0x4a8b5200,0x643f0000,0x65220149,0x3ee6f5b8,0xd178a306,0x36ee264c},
	{0x8f3f0000,0xc76b0001,0xb89ab300,0x12470000,0x5e8003a8,0xaca1b6d6,0x6431d3cf,0x801df1d8,0x461a0000,0x445e0002,0xccf15d00,0x68320000,0xbb7f012b,0x7abb8fad,0x588b7e79,0xcfee92e4},
	{0x039d0000,0x23ca0001,0x3ee0bc00,0x1e4a0000,0x80dd03ca,0xe8fcccc3,0xedc20eb0,0x791d4570,0xdb0d0000,0x71ab0002,0x18c05b00,0x355c0000,0x592e0247,0xb798a2e7,0xa8e79b46,0xc611305f},
	{0x0c150000,0x1db60001,0xcf388300,0x918b0000,0x0a1b01dd,0xb40949fe,0xf35387ba,0x35c38b93,0x9d480000,0xcc0f0002,0x8a246400,0x73b80000,0x6ea702ea,0xa000cf03,0xdd7aad52,0x215bb898},
	{0x80b70000,0xf9170001,0x49428c00,0x9d860000,0xd44601bf,0xf05433eb,0x7aa05ac5,0xccc33f3b,0x005f0000,0xf9fa0002,0x5e156200,0x2ed60000,0x8cf60186,0x6d23e249,0x2d16486d,0x28a41a23},
	{0x91020000,0x28430001,0x1b098500,0xcce50000,0xe84a02b1,0x792a64b4,0x033f6285,0x3c3c2928,0x8cfd0000,0x1d5b0002,0xd86f6d00,0x22db0000,0x52ab01e4,0x297e985c,0xa4e59512,0xd1a4ae8b},
	{0x1da00000,0xcce20001,0x9d738a00,0xc0e80000,0x361702d3,0x3d771ea1,0x8accbffa,0xc53c9d80,0x11ea0000,0x28ae0002,0x0c5e6b00,0x7fb50000,0xb0fa0288,0xe45db516,0x5489702d,0xd85b0c30},
	{0x5db40000,0x54b50001,0xc0c29400,0x80930000,0xa8a80217,0xd83ebcf2,0x9877214c,0xc5fac142,0xeea10000,0x25d40002,0xe5da6100,0xc0610000,0x244500a2,0x3e4ba492,0x7c45eb5d,0xbead19e3},
	{0xd1160000,0xb0140001,0x46b89b00,0x8c9e0000,0x76f50275,0x9c63c6e7,0x1184fc33,0x3cfa75ea,0x73b60000,0x10210002,0x31eb6700,0x9d0f0000,0xc61403ce,0xf36889d8,0x8c290e62,0xb752bb58},
	{0xc0a30000,0x61400001,0x14f39200,0xddfd0000,0x4af9017b,0x151d91b8,0x681bc473,0xcc0563f9,0xff140000,0xf4800002,0xb7916800,0x91020000,0x184903ac,0xb735f3cd,0x05dad31d,0x4e520ff0},
	{0x4c010000,0x85e10001,0x92899d00,0xd1f00000,0x94a40119,0x5140ebad,0xe1e8190c,0x3505d751,0x62030000,0xc1750002,0x63a06e00,0xcc6c0000,0xfa1800c0,0x7a16de87,0xf5b63622,0x47adad4b},
	{0x7ffc0000,0xf46d0001,0xa0c68600,0x22520000,0x40f90395,0x2a42226f,0x526cc1b5,0xaa352ae8,0xbf000000,0x6cd70002,0xea207600,0xd1790000,0x86f60368,0x527c519e,0x17614dab,0x4e945332},
	{0xf35e0000,0x10cc0001,0x26bc8900,0x2e5f0000,0x9ea403f7,0x6e1f587a,0xdb9f1cca,0x53359e40,0x22170000,0x59220002,0x3e117000,0x8c170000,0x64a70004,0x9f5f7cd4,0xe70da894,0x476bf189},
	{0xe2eb0000,0xc1980001,0x74f78000,0x7f3c0000,0xa2a800f9,0xe7610f25,0xa200248a,0xa3ca8853,0xaeb50000,0xbd830002,0xb86b7f00,0x801a0000,0xbafa0066,0xdb0206c1,0x6efe75eb,0xbe6b4521},
	{0x6e490000,0x25390001,0xf28d8f00,0x73310000,0x7cf5009b,0xa33c7530,0x2bf3f9f5,0x5aca3cfb,0x33a20000,0x88760002,0x6c5a7900,0xdd740000,0x58ab030a,0x16212b8b,0x9e9290d4,0xb794e79a},
	{0x2e5d0000,0xbd6e0001,0xaf3c9100,0x334a0000,0xe24a005f,0x4675d763,0x39486743,0x5a0c6039,0xcce90000,0x850c0002,0x85de7300,0x62a00000,0xcc140120,0xcc373a0f,0xb65e0ba4,0xd162f249},
	{0xa2ff0000,0x59cf0001,0x29469e00,0x3f470000,0x3c17003d,0x0228ad76,0xb0bbba3c,0xa30cd491,0x51fe0000,0xb0f90002,0x51ef7500,0x3fce0000,0x2e45024c,0x01141745,0x4632ee9b,0xd89d50f2},
	{0xb34a0000,0x889b0001,0x7b0d9700,0x6e240000,0x001b0333,0x8b56fa29,0xc924827c,0x53f3c282,0xdd5c0000,0x54580002,0xd7957a00,0x33c30000,0xf018022e,0x45496d50,0xcfc133e4,0x219de45a},
	{0x3fe80000,0x6c3a0001,0xfd779800,0x62290000,0xde460351,0xcf0b803c,0x40d75f03,0xaaf3762a,0x404b0000,0x61ad0002,0x03a47c00,0x6ead0000,0x12490142,0x886a401a,0x3fadd6db,0x286246e1},
	{0x97530000,0x0db00001,0xd45ca400,0xca7a0000,0x417c02d8,0x8bfbab03,0x6419ca27,0xdbb0fd2d,0x3a7b0000,0x93f90002,0x52d76700,0x542a0000,0x7b5b0174,0xb8056101,0xe725b17c,0x1cc6fd7c},
	{0x1bf10000,0xe9110001,0x5226ab00,0xc6770000,0x9f2102ba,0xcfa6d116,0xedea1758,0x22b04985,0xa76c0000,0xa60c0002,0x86e66100,0x09440000,0x990a0218,0x75264c4b,0x17495443,0x15395fc7},
	{0x0a440000,0x38450001,0x006da200,0x97140000,0xa32d01b4,0x46d88649,0x94752f18,0xd24f5f96,0x2bce0000,0x42ad0002,0x009c6e00,0x05490000,0x4757027a,0x317b365e,0x9eba893c,0xec39eb6f},
	{0x86e60000,0xdce40001,0x8617ad00,0x9b190000,0x7d7001d6,0x0285fc5c,0x1d86f267,0x2b4feb3e,0xb6d90000,0x77580002,0xd4ad6800,0x58270000,0xa5060116,0xfc581b14,0x6ed66c03,0xe5c649d4},
	{0xc6f20000,0x44b30001,0xdba6b300,0xdb620000,0xe3cf0112,0xe7cc5e0f,0x0f3d6cd1,0x2b89b7fc,0x49920000,0x7a220002,0x3d296200,0xe7f30000,0x31b9033c,0x264e0a90,0x461af773,0x83305c07},
	{0x4a500000,0xa0120001,0x5ddcbc00,0xd76f0000,0x3d920170,0xa391241a,0x86ceb1ae,0xd2890354,0xd4850000,0x4fd70002,0xe9186400,0xba9d0000,0xd3e80050,0xeb6d27da,0xb676124c,0x8acffebc},
	{0x5be50000,0x71460001,0x0f97b500,0x860c0000,0x019e027e,0x2aef7345,0xff5189ee,0x22761547,0x58270000,0xab760002,0x6f626b00,0xb6900000,0x0db50032,0xaf305dcf,0x3f85cf33,0x73cf4a14},
	{0xd7470000,0x95e70001,0x89edba00,0x8a010000,0xdfc3021c,0x6eb20950,0x76a25491,0xdb76a1ef,0xc5300000,0x9e830002,0xbb536d00,0xebfe0000,0xefe4035e,0x62137085,0xcfe92a0c,0x7a30e8af},
	{0xe4ba0000,0xe46b0001,0xbba2a100,0x79a30000,0x0b9e0090,0x15b0c092,0xc5268c28,0x44465c56,0x18330000,0x33210002,0x32d37500,0xf6eb0000,0x930a00f6,0x4a79ff9c,0x2d3e5185,0x730916d6},
	{0x68180000,0x00ca0001,0x3dd8ae00,0x75ae0000,0xd5c300f2,0x51edba87,0x4cd55157,0xbd46e8fe,0x85240000,0x06d40002,0xe6e27300,0xab850000,0x715b039a,0x875ad2d6,0xdd52b4ba,0x7af6b46d},
	{0x79ad0000,0xd19e0001,0x6f93a700,0x24cd0000,0xe9cf03fc,0xd893edd8,0x354a6917,0x4db9feed,0x09860000,0xe2750002,0x60987c00,0xa7880000,0xaf0603f8,0xc307a8c3,0x54a169c5,0x83f600c5},
	{0xf50f0000,0x353f0001,0xe9e9a800,0x28c00000,0x3792039e,0x9cce97cd,0xbcb9b468,0xb4b94a45,0x94910000,0xd7800002,0xb4a97a00,0xfae60000,0x4d570094,0x0e248589,0xa4cd8cfa,0x8a09a27e},
	{0xb51b0000,0xad680001,0xb458b600,0x68bb0000,0xa92d035a,0x7987359e,0xae022ade,0xb47f1687,0x6bda0000,0xdafa0002,0x5d2d7000,0x45320000,0xd9e802be,0xd432940d,0x8c01178a,0xecffb7ad},
	{0x39b90000,0x49c90001,0x3222b900,0x64b60000,0x77700338,0x3dda4f8b,0x27f1f7a1,0x4d7fa22f,0xf6cd0000,0xef0f0002,0x891c7600,0x185c0000,0x3bb901d2,0x1911b947,0x7c6df2b5,0xe5001516},
	{0x280c0000,0x989d0001,0x6069b000,0x35d50000,0x4b7c0036,0xb4a418d4,0x5e6ecfe1,0xbd80b43c,0x7a6f0000,0x0bae0002,0x0f667900,0x14510000,0xe5e401b0,0x5d4cc352,0xf59e2fca,0x1c00a1be},
	{0xa4ae0000,0x7c3c0001,0xe613bf00,0x39d80000,0x95210054,0xf0f962c1,0xd79d129e,0x44800094,0xe7780000,0x3e5b0002,0xdb577f00,0x493f0000,0x07b502dc,0x906fee18,0x05f2caf5,0x15ff0305},
	{0xa13d0000,0x83ff0002,0x49b34000,0x0fdb0000,0x303c0271,0x87f783fc,0x706ffce1,0xf2b58bc2,0x0a1b0000,0xc1bf0003,0x5e78c000,0xb9c20000,0x2fdb0032,0x2bfb6400,0xb9636775,0xfaeb45b5},
	{0x2d9f0000,0x675e0002,0xcfc94f00,0x03d60000,0xee610213,0xc3aaf9e9,0xf99c219e,0x0bb53f6a,0x970c0000,0xf44a0003,0x8a49c600,0xe4ac0000,0xcd8a035e,0xe6d8494a,0x490f824a,0xf314e70e},
	{0x3c2a0000,0xb60a0002,0x9d824600,0x52b50000,0xd26d011d,0x4ad4aeb6,0x800319de,0xfb4a2979,0x1bae0000,0x10eb0003,0x0c33c900,0xe8a10000,0x13d7033c,0xa285335f,0xc0fc5f35,0x0a1453a6},
	{0xb0880000,0x52ab0002,0x1bf84900,0x5eb80000,0x0c30017f,0x0e89d4a3,0x09f0c4a1,0x024a9dd1,0x86b90000,0x251e0003,0xd802cf00,0xb5cf0000,0xf1860050,0x6fa61e15,0x3090ba0a,0x03ebf11d},
	{0xf09c0000,0xcafc0002,0x46495700,0x1ec30000,0x928f01bb,0xebc076f0,0x1b4b5a17,0x028cc113,0x79f20000,0x28640003,0x3186c500,0x0a1b0000,0x6539027a,0xb5b00f91,0x185c217a,0x651de4ce},
	{0x7c3e0000,0x2e5d0002,0xc0335800,0x12ce0000,0x4cd201d9,0xaf9d0ce5,0x92b88768,0xfb8c75bb,0xe4e50000,0x1d910003,0xe5b7c300,0x57750000,0x87680116,0x789322db,0xe830c445,0x6ce24675},
	{0x6d8b0000,0xff090002,0x92785100,0x43ad0000,0x70de02d7,0x26e35bba,0xeb27bf28,0x0b7363a8,0x68470000,0xf9300003,0x63cdcc00,0x5b780000,0x59350174,0x3cce58ce,0x61c3193a,0x95e2f2dd},
	{0xe1290000,0x1ba80002,0x14025e00,0x4fa00000,0xae8302b5,0x62be21af,0x62d46257,0xf273d700,0xf5500000,0xccc50003,0xb7fcca00,0x06160000,0xbb640218,0xf1ed7584,0x91affc05,0x9c1d5066},
	{0xd2d40000,0x6a240002,0x264d4500,0xbc020000,0x7ade0039,0x19bce86d,0xd150baee,0x6d432ab9,0x28530000,0x61670003,0x3e7cd200,0x1b030000,0xc78a01b0,0xd987fa9d,0x7378878c,0x9524ae1f},
	{0x5e760000,0x8e850002,0xa0374a00,0xb00f0000,0xa483005b,0x5de19278,0x58a36791,0x94439e11,0xb5440000,0x54920003,0xea4dd400,0x466d0000,0x25db02dc,0x14a4d7d7,0x831462b3,0x9cdb0ca4},
	{0x4fc30000,0x5fd10002,0xf27c4300,0xe16c0000,0x988f0355,0xd49fc527,0x213c5fd1,0x64bc8802,0x39e60000,0xb0330003,0x6c37db00,0x4a600000,0xfb8602be,0x50f9adc2,0x0ae7bfcc,0x65dbb80c},
	{0xc3610000,0xbb700002,0x74064c00,0xed610000,0x46d20337,0x90c2bf32,0xa8cf82ae,0x9dbc3caa,0xa4f10000,0x85c60003,0xb806dd00,0x170e0000,0x19d701d2,0x9dda8088,0xfa8b5af3,0x6c241ab7},
	{0x83750000,0x23270002,0x29b75200,0xad1a0000,0xd86d03f3,0x758b1d61,0xba741c18,0x9d7a6068,0x5bba0000,0x88bc0003,0x5182d700,0xa8da0000,0x8d6803f8,0x47cc910c,0xd247c183,0x0ad20f64},
	{0x0fd70000,0xc7860002,0xafcd5d00,0xa1170000,0x06300391,0x31d66774,0x3387c167,0x647ad4c0,0xc6ad0000,0xbd490003,0x85b3d100,0xf5b40000,0x6f390094,0x8aefbc46,0x222b24bc,0x032daddf},
	{0x1e620000,0x16d20002,0xfd865400,0xf0740000,0x3a3c009f,0xb8a8302b,0x4a18f927,0x9485c2d3,0x4a0f0000,0x59e80003,0x03c9de00,0xf9b90000,0xb16400f6,0xceb2c653,0xabd8f9c3,0xfa2d1977},
	{0x92c00000,0xf2730002,0x7bfc5b00,0xfc790000,0xe46100fd,0xfcf54a3e,0xc3eb2458,0x6d85767b,0xd7180000,0x6c1d0003,0xd7f8d800,0xa4d70000,0x5335039a,0x0391eb19,0x5bb41cfc,0xf3d2bbcc},
	{0x3a7b0000,0x93f90002,0x52d76700,0x542a0000,0x7b5b0174,0xb8056101,0xe725b17c,0x1cc6fd7c,0xad280000,0x9e490003,0x868bc300,0x9e500000,0x3a2703ac,0x33feca02,0x833c7b5b,0xc7760051},
	{0xb6d90000,0x77580002,0xd4ad6800,0x58270000,0xa5060116,0xfc581b14,0x6ed66c03,0xe5c649d4,0x303f0000,0xabbc0003,0x52bac500,0xc33e0000,0xd87600c0,0xfedde748,0x73509e64,0xce89a2ea},
	{0xa76c0000,0xa60c0002,0x86e66100,0x09440000,0x990a0218,0x75264c4b,0x17495443,0x15395fc7,0xbc9d0000,0x4f1d0003,0xd4c0ca00,0xcf330000,0x062b00a2,0xba809d5d,0xfaa3431b,0x37891642},
	{0x2bce0000,0x42ad0002,0x009c6e00,0x05490000,0x4757027a,0x317b365e,0x9eba893c,0xec39eb6f,0x218a0000,0x7ae80003,0x00f1cc00,0x925d0000,0xe47a03ce,0x77a3b017,0x0acfa624,0x3e76b4f9},
	{0x6bda0000,0xdafa0002,0x5d2d7000,0x45320000,0xd9e802be,0xd432940d,0x8c01178a,0xecffb7ad,0xdec10000,0x77920003,0xe975c600,0x2d890000,0x70c501e4,0xadb5a193,0x22033d54,0x5880a12a},
	{0xe7780000,0x3e5b0002,0xdb577f00,0x493f0000,0x07b502dc,0x906fee18,0x05f2caf5,0x15ff0305,0x43d60000,0x42670003,0x3d44c000,0x70e70000,0x92940288,0x60968cd9,0xd26fd86b,0x517f0391},
	{0xf6cd0000,0xef0f0002,0x891c7600,0x185c0000,0x3bb901d2,0x1911b947,0x7c6df2b5,0xe5001516,0xcf740000,0xa6c60003,0xbb3ecf00,0x7cea0000,0x4cc902ea,0x24cbf6cc,0x5b9c0514,0xa87fb739},
	{0x7a6f0000,0x0bae0002,0x0f667900,0x14510000,0xe5e401b0,0x5d4cc352,0xf59e2fca,0x1c00a1be,0x52630000,0x93330003,0x6f0fc900,0x21840000,0xae980186,0xe9e8db86,0xabf0e02b,0xa1801582},
	{0x49920000,0x7a220002,0x3d296200,0xe7f30000,0x31b9033c,0x264e0a90,0x461af773,0x83305c07,0x8f600000,0x3e910003,0xe68fd100,0x3c910000,0xd276022e,0xc182549f,0x49279ba2,0xa8b9ebfb},
	{0xc5300000,0x9e830002,0xbb536d00,0xebfe0000,0xefe4035e,0x62137085,0xcfe92a0c,0x7a30e8af,0x12770000,0x0b640003,0x32bed700,0x61ff0000,0x30270142,0x0ca179d5,0xb94b7e9d,0xa1464940},
	{0xd4850000,0x4fd70002,0xe9186400,0xba9d0000,0xd3e80050,0xeb6d27da,0xb676124c,0x8acffebc,0x9ed50000,0xefc50003,0xb4c4d800,0x6df20000,0xee7a0120,0x48fc03c0,0x30b8a3e2,0x5846fde8},
	{0x58270000,0xab760002,0x6f626b00,0xb6900000,0x0db50032,0xaf305dcf,0x3f85cf33,0x73cf4a14,0x03c20000,0xda300003,0x60f5de00,0x309c0000,0x0c2b024c,0x85df2e8a,0xc0d446dd,0x51b95f53},
	{0x18330000,0x33210002,0x32d37500,0xf6eb0000,0x930a00f6,0x4a79ff9c,0x2d3e5185,0x730916d6,0xfc890000,0xd74a0003,0x8971d400,0x8f480000,0x98940066,0x5fc93f0e,0xe818ddad,0x374f4a80},
	{0x94910000,0xd7800002,0xb4a97a00,0xfae60000,0x4d570094,0x0e248589,0xa4cd8cfa,0x8a09a27e,0x619e0000,0xe2bf0003,0x5d40d200,0xd2260000,0x7ac5030a,0x92ea1244,0x18743892,0x3eb0e83b},
	{0x85240000,0x06d40002,0xe6e27300,0xab850000,0x715b039a,0x875ad2d6,0xdd52b4ba,0x7af6b46d,0xed3c0000,0x061e0003,0xdb3add00,0xde2b0000,0xa4980368,0xd6b76851,0x9187e5ed,0xc7b05c93},
	{0x09860000,0xe2750002,0x60987c00,0xa7880000,0xaf0603f8,0xc307a8c3,0x54a169c5,0x83f600c5,0x702b0000,0x33eb0003,0x0f0bdb00,0x83450000,0x46c90004,0x1b94451b,0x61eb00d2,0xce4ffe28},
	{0x060e0000,0xdc090002,0x91404300,0x28490000,0x25c001ef,0x9ff22dfe,0x4a30e0cf,0xcf28ce26,0x366e0000,0x8e4f0003,0x9defe400,0xc5a10000,0x714000a9,0x0c0c28ff,0x147636c6,0x290576ef},
	{0x8aac0000,0x38a80002,0x173a4c00,0x24440000,0xfb9d018d,0xdbaf57eb,0xc3c33db0,0x36287a8e,0xab790000,0xbbba0003,0x49dee200,0x98cf0000,0x931103c5,0xc12f05b5,0xe41ad3f9,0x20fad454},
	{0x9b190000,0xe9fc0002,0x45714500,0x75270000,0xc7910283,0x52d100b4,0xba5c05f0,0xc6d76c9d,0x27db0000,0x5f1b0003,0xcfa4ed00,0x94c20000,0x4d4c03a7,0x85727fa0,0x6de90e86,0xd9fa60fc},
	{0x17bb0000,0x0d5d0002,0xc30b4a00,0x792a0000,0x19cc02e1,0x168c7aa1,0x33afd88f,0x3fd7d835,0xbacc0000,0x6aee0003,0x1b95eb00,0xc9ac0000,0xaf1d00cb,0x485152ea,0x9d85ebb9,0xd005c247},
	{0x57af0000,0x950a0002,0x9eba5400,0x39510000,0x87730225,0xf3c5d8f2,0x21144639,0x3f1184f7,0x45870000,0x67940003,0xf211e100,0x76780000,0x3ba202e1,0x9247436e,0xb54970c9,0xb6f3d794},
	{0xdb0d0000,0x71ab0002,0x18c05b00,0x355c0000,0x592e0247,0xb798a2e7,0xa8e79b46,0xc611305f,0xd8900000,0x52610003,0x2620e700,0x2b160000,0xd9f3018d,0x5f646e24,0x452595f6,0xbf0c752f},
	{0xcab80000,0xa0ff0002,0x4a8b5200,0x643f0000,0x65220149,0x3ee6f5b8,0xd178a306,0x36ee264c,0x54320000,0xb6c00003,0xa05ae800,0x271b0000,0x07ae01ef,0x1b391431,0xccd64889,0x460cc187},
	{0x461a0000,0x445e0002,0xccf15d00,0x68320000,0xbb7f012b,0x7abb8fad,0x588b7e79,0xcfee92e4,0xc9250000,0x83350003,0x746bee00,0x7a750000,0xe5ff0283,0xd61a397b,0x3cbaadb6,0x4ff3633c},
	{0x75e70000,0x35d20002,0xfebe4600,0x9b900000,0x6f2203a7,0x01b9466f,0xeb0fa6c0,0x50de6f5d,0x14260000,0x2e970003,0xfdebf600,0x67600000,0x9911012b,0xfe70b662,0xde6dd63f,0x46ca9d45},
	{0xf9450000,0xd1730002,0x78c44900,0x979d0000,0xb17f03c5,0x45e43c7a,0x62fc7bbf,0xa9dedbf5,0x89310000,0x1b620003,0x29daf000,0x3a0e0000,0x7b400247,0x33539b28,0x2e013300,0x4f353ffe},
	{0xe8f00000,0x00270002,0x2a8f4000,0xc6fe0000,0x8d7300cb,0xcc9a6b25,0x1b6343ff,0x5921cde6,0x05930000,0xffc30003,0xafa0ff00,0x36030000,0xa51d0225,0x770ee13d,0xa7f2ee7f,0xb6358b56},
	{0x64520000,0xe4860002,0xacf54f00,0xcaf30000,0x532e00a9,0x88c71130,0x92909e80,0xa021794e,0x98840000,0xca360003,0x7b91f900,0x6b6d0000,0x474c0149,0xba2dcc77,0x579e0b40,0xbfca29ed},
	{0x24460000,0x7cd10002,0xf1445100,0x8a880000,0xcd91006d,0x6d8eb363,0x802b0036,0xa0e7258c,0x67cf0000,0xc74c0003,0x9215f300,0xd4b90000,0xd3f30363,0x603bddf3,0x7f529030,0xd93c3c3e},
	{0xa8e40000,0x98700002,0x773e5e00,0x86850000,0x13cc000f,0x29d3c976,0x09d8dd49,0x59e79124,0xfad80000,0xf2b90003,0x4624f500,0x89d70000,0x31a2000f,0xad18f0b9,0x8f3e750f,0xd0c39e85},
	{0xb9510000,0x49240002,0x25755700,0xd7e60000,0x2fc00301,0xa0ad9e29,0x7047e509,0xa9188737,0x767a0000,0x16180003,0xc05efa00,0x85da0000,0xefff006d,0xe9458aac,0x06cda870,0x29c32a2d},
	{0x35f30000,0xad850002,0xa30f5800,0xdbeb0000,0xf19d0363,0xe4f0e43c,0xf9b43876,0x5018339f,0xeb6d0000,0x23ed0003,0x146ffc00,0xd8b40000,0x0dae0301,0x2466a7e6,0xf6a14d4f,0x203c8896},
	{0x9d480000,0xcc0f0002,0x8a246400,0x73b80000,0x6ea702ea,0xa000cf03,0xdd7aad52,0x215bb898,0x915d0000,0xd1b90003,0x451ce700,0xe2330000,0x64bc0337,0x140986fd,0x2e292ae8,0x1498330b},
	{0x11ea0000,0x28ae0002,0x0c5e6b00,0x7fb50000,0xb0fa0288,0xe45db516,0x5489702d,0xd85b0c30,0x0c4a0000,0xe44c0003,0x912de100,0xbf5d0000,0x86ed005b,0xd92aabb7,0xde45cfd7,0x1d6791b0},
	{0x005f0000,0xf9fa0002,0x5e156200,0x2ed60000,0x8cf60186,0x6d23e249,0x2d16486d,0x28a41a23,0x80e80000,0x00ed0003,0x1757ee00,0xb3500000,0x58b00039,0x9d77d1a2,0x57b612a8,0xe4672518},
	{0x8cfd0000,0x1d5b0002,0xd86f6d00,0x22db0000,0x52ab01e4,0x297e985c,0xa4e59512,0xd1a4ae8b,0x1dff0000,0x35180003,0xc366e800,0xee3e0000,0xbae10355,0x5054fce8,0xa7daf797,0xed9887a3},
	{0xcce90000,0x850c0002,0x85de7300,0x62a00000,0xcc140120,0xcc373a0f,0xb65e0ba4,0xd162f249,0xe2b40000,0x38620003,0x2ae2e200,0x51ea0000,0x2e5e017f,0x8a42ed6c,0x8f166ce7,0x8b6e9270},
	{0x404b0000,0x61ad0002,0x03a47c00,0x6ead0000,0x12490142,0x886a401a,0x3fadd6db,0x286246e1,0x7fa30000,0x0d970003,0xfed3e400,0x0c840000,0xcc0f0213,0x4761c026,0x7f7a89d8,0x829130cb},
	{0x51fe0000,0xb0f90002,0x51ef7500,0x3fce0000,0x2e45024c,0x01141745,0x4632ee9b,0xd89d50f2,0xf3010000,0xe9360003,0x78a9eb00,0x00890000,0x12520271,0x033cba33,0xf68954a7,0x7b918463},
	{0xdd5c0000,0x54580002,0xd7957a00,0x33c30000,0xf018022e,0x45496d50,0xcfc133e4,0x219de45a,0x6e160000,0xdcc30003,0xac98ed00,0x5de70000,0xf003011d,0xce1f9779,0x06e5b198,0x726e26d8},
	{0xeea10000,0x25d40002,0xe5da6100,0xc0610000,0x244500a2,0x3e4ba492,0x7c45eb5d,0xbead19e3,0xb3150000,0x71610003,0x2518f500,0x40f20000,0x8ced02b5,0xe6751860,0xe432ca11,0x7b57d8a1},
	{0x62030000,0xc1750002,0x63a06e00,0xcc6c0000,0xfa1800c0,0x7a16de87,0xf5b63622,0x47adad4b,0x2e020000,0x44940003,0xf129f300,0x1d9c0000,0x6ebc01d9,0x2b56352a,0x145e2f2e,0x72a87a1a},
	{0x73b60000,0x10210002,0x31eb6700,0x9d0f0000,0xc61403ce,0xf36889d8,0x8c290e62,0xb752bb58,0xa2a00000,0xa0350003,0x7753fc00,0x11910000,0xb0e101bb,0x6f0b4f3f,0x9dadf251,0x8ba8ceb2},
	{0xff140000,0xf4800002,0xb7916800,0x91020000,0x184903ac,0xb735f3cd,0x05dad31d,0x4e520ff0,0x3fb70000,0x95c00003,0xa362fa00,0x4cff0000,0x52b002d7,0xa2286275,0x6dc1176e,0x82576c09},
	{0xbf000000,0x6cd70002,0xea207600,0xd1790000,0x86f60368,0x527c519e,0x17614dab,0x4e945332,0xc0fc0000,0x98ba0003,0x4ae6f000,0xf32b0000,0xc60f00fd,0x783e73f1,0x450d8c1e,0xe4a179da},
	{0x33a20000,0x88760002,0x6c5a7900,0xdd740000,0x58ab030a,0x16212b8b,0x9e9290d4,0xb794e79a,0x5deb0000,0xad4f0003,0x9ed7f600,0xae450000,0x245e0391,0xb51d5ebb,0xb5616921,0xed5edb61},
	{0x22170000,0x59220002,0x3e117000,0x8c170000,0x64a70004,0x9f5f7cd4,0xe70da894,0x476bf189,0xd1490000,0x49ee0003,0x18adf900,0xa2480000,0xfa0303f3,0xf14024ae,0x3c92b45e,0x145e6fc9},
	{0xaeb50000,0xbd830002,0xb86b7f00,0x801a0000,0xbafa0066,0xdb0206c1,0x6efe75eb,0xbe6b4521,0x4c5e0000,0x7c1b0003,0xcc9cff00,0xff260000,0x1852009f,0x3c6309e4,0xccfe5161,0x1da1cd72}
    },{
	{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x09290000,0xbadd0000,0x7ab20002,0x80e57000,0xbceb022e,0x51b28a3e,0x583ed84a,0x8a0fa355,0x8fad0000,0x87ae0000,0xd5e50000,0x3fda3000,0x789e011b,0x798c6be6,0x3c1b82ab,0xa1791547},
	{0x8fad0000,0x87ae0000,0xd5e50000,0x3fda3000,0x789e011b,0x798c6be6,0x3c1b82ab,0xa1791547,0x86840000,0x3d730000,0xaf570002,0xbf3f4000,0xc4750335,0x283ee1d8,0x64255ae1,0x2b76b612},
	{0x86840000,0x3d730000,0xaf570002,0xbf3f4000,0xc4750335,0x283ee1d8,0x64255ae1,0x2b76b612,0x09290000,0xbadd0000,0x7ab20002,0x80e57000,0xbceb022e,0x51b28a3e,0x583ed84a,0x8a0fa355},
	{0xc0450000,0xdaee0000,0x61d1003c,0x6dcd0000,0x7ba401bb,0xd73f8fd8,0x21a26c03,0xb9e4d9e3,0x7fcd0000,0x17b30000,0x0eeb0018,0x68880000,0x53270273,0xadd606c0,0xf5ea91a4,0x1f18c0ae},
	{0xc96c0000,0x60330000,0x1b63003e,0xed287000,0xc74f0395,0x868d05e6,0x799cb449,0x33eb7ab6,0xf0600000,0x901d0000,0xdb0e0018,0x57523000,0x2bb90368,0xd45a6d26,0xc9f1130f,0xbe61d5e9},
	{0x4fe80000,0x5d400000,0xb434003c,0x52173000,0x033a00a0,0xaeb3e43e,0x1db9eea8,0x189dcca4,0xf9490000,0x2ac00000,0xa1bc001a,0xd7b74000,0x97520146,0x85e8e718,0x91cfcb45,0x346e76bc},
	{0x46c10000,0xe79d0000,0xce86003e,0xd2f24000,0xbfd1028e,0xff016e00,0x458736e2,0x92926ff1,0x76e40000,0xad6e0000,0x7459001a,0xe86d7000,0xefcc005d,0xfc648cfe,0xadd449ee,0x951763fb},
	{0x7fcd0000,0x17b30000,0x0eeb0018,0x68880000,0x53270273,0xadd606c0,0xf5ea91a4,0x1f18c0ae,0xbf880000,0xcd5d0000,0x6f3a0024,0x05450000,0x288303c8,0x7ae98918,0xd448fda7,0xa6fc194d},
	{0x76e40000,0xad6e0000,0x7459001a,0xe86d7000,0xefcc005d,0xfc648cfe,0xadd449ee,0x951763fb,0x30250000,0x4af30000,0xbadf0024,0x3a9f3000,0x501d02d3,0x0365e2fe,0xe8537f0c,0x07850c0a},
	{0xf0600000,0x901d0000,0xdb0e0018,0x57523000,0x2bb90368,0xd45a6d26,0xc9f1130f,0xbe61d5e9,0x390c0000,0xf02e0000,0xc06d0026,0xba7a4000,0xecf600fd,0x52d768c0,0xb06da746,0x8d8aaf5f},
	{0xf9490000,0x2ac00000,0xa1bc001a,0xd7b74000,0x97520146,0x85e8e718,0x91cfcb45,0x346e76bc,0xb6a10000,0x77800000,0x15880026,0x85a07000,0x946801e6,0x2b5b0326,0x8c7625ed,0x2cf3ba18},
	{0xbf880000,0xcd5d0000,0x6f3a0024,0x05450000,0x288303c8,0x7ae98918,0xd448fda7,0xa6fc194d,0xc0450000,0xdaee0000,0x61d1003c,0x6dcd0000,0x7ba401bb,0xd73f8fd8,0x21a26c03,0xb9e4d9e3},
	{0xb6a10000,0x77800000,0x15880026,0x85a07000,0x946801e6,0x2b5b0326,0x8c7625ed,0x2cf3ba18,0x4fe80000,0x5d400000,0xb434003c,0x52173000,0x033a00a0,0xaeb3e43e,0x1db9eea8,0x189dcca4},
	{0x30250000,0x4af30000,0xbadf0024,0x3a9f3000,0x501d02d3,0x0365e2fe,0xe8537f0c,0x07850c0a,0x46c10000,0xe79d0000,0xce86003e,0xd2f24000,0xbfd1028e,0xff016e00,0x458736e2,0x92926ff1},
	{0x390c0000,0xf02e0000,0xc06d0026,0xba7a4000,0xecf600fd,0x52d768c0,0xb06da746,0x8d8aaf5f,0xc96c0000,0x60330000,0x1b63003e,0xed287000,0xc74f0395,0x868d05e6,0x799cb449,0x33eb7ab6},
	{0xb96f0000,0x3b940000,0xc0ae005c,0x929e0000,0x7b4000fb,0x89e25790,0x4345563f,0x71b9935b,0xf69e0000,0x231e0000,0x19440014,0xa8f00000,0x3a3f006a,0xb8a30561,0xdb332f00,0xa249614c},
	{0xb0460000,0x81490000,0xba1c005e,0x127b7000,0xc7ab02d5,0xd850ddae,0x1b7b8e75,0xfbb6300e,0x79330000,0xa4b00000,0xcca10014,0x972a3000,0x42a10171,0xc12f6e87,0xe728adab,0x0330740b},
	{0x36c20000,0xbc3a0000,0x154b005c,0xad443000,0x03de01e0,0xf06e3c76,0x7f5ed494,0xd0c0861c,0x701a0000,0x1e6d0000,0xb6130016,0x17cf4000,0xfe4a035f,0x909de4b9,0xbf1675e1,0x893fd75e},
	{0x3feb0000,0x06e70000,0x6ff9005e,0x2da14000,0xbf3503ce,0xa1dcb648,0x27600cde,0x5acf2549,0xffb70000,0x99c30000,0x63f60016,0x28157000,0x86d40244,0xe9118f5f,0x830df74a,0x2846c219},
	{0x792a0000,0xe17a0000,0xa17f0060,0xff530000,0x00e40140,0x5eddd848,0x62e73a3c,0xc85d4ab8,0x89530000,0x34ad0000,0x17af000c,0xc0780000,0x69180219,0x157503a1,0x2ed9bea4,0xbd51a1e2},
	{0x70030000,0x5ba70000,0xdbcd0062,0x7fb67000,0xbc0f036e,0x0f6f5276,0x3ad9e276,0x4252e9ed,0x06fe0000,0xb3030000,0xc24a000c,0xffa23000,0x11860302,0x6cf96847,0x12c23c0f,0x1c28b4a5},
	{0xf6870000,0x66d40000,0x749a0060,0xc0893000,0x787a005b,0x2751b3ae,0x5efcb897,0x69245fff,0x0fd70000,0x09de0000,0xb8f8000e,0x7f474000,0xad6d012c,0x3d4be279,0x4afce445,0x962717f0},
	{0xffae0000,0xdc090000,0x0e280062,0x406c4000,0xc4910275,0x76e33990,0x06c260dd,0xe32bfcaa,0x807a0000,0x8e700000,0x6d1d000e,0x409d7000,0xd5f30037,0x44c7899f,0x76e766ee,0x375e02b7},
	{0xc6a20000,0x2c270000,0xce450044,0xfa160000,0x28670288,0x24345150,0xb6afc79b,0x6ea153f5,0x49160000,0xee430000,0x767e0030,0xadb50000,0x12bc03a2,0xc24a8c79,0x0f7bd2a7,0x04b57801},
	{0xcf8b0000,0x96fa0000,0xb4f70046,0x7af37000,0x948c00a6,0x7586db6e,0xee911fd1,0xe4aef0a0,0xc6bb0000,0x69ed0000,0xa39b0030,0x926f3000,0x6a2202b9,0xbbc6e79f,0x3360500c,0xa5cc6d46},
	{0x490f0000,0xab890000,0x1ba00044,0xc5cc3000,0x50f90393,0x5db83ab6,0x8ab44530,0xcfd846b2,0xcf920000,0xd3300000,0xd9290032,0x128a4000,0xd6c90097,0xea746da1,0x6b5e8846,0x2fc3ce13},
	{0x40260000,0x11540000,0x61120046,0x45294000,0xec1201bd,0x0c0ab088,0xd28a9d7a,0x45d7e5e7,0x403f0000,0x549e0000,0x0ccc0032,0x2d507000,0xae57018c,0x93f80647,0x57450aed,0x8ebadb54},
	{0x06e70000,0xf6c90000,0xaf940078,0x97db0000,0x53c30333,0xf30bde88,0x970dab98,0xd7458a16,0x36db0000,0xf9f00000,0x78950028,0xc53d0000,0x419b01d1,0x6f9c8ab9,0xfa914303,0x1badb8af},
	{0x0fce0000,0x4c140000,0xd526007a,0x173e7000,0xef28011d,0xa2b954b6,0xcf3373d2,0x5d4a2943,0xb9760000,0x7e5e0000,0xad700028,0xfae73000,0x390500ca,0x1610e15f,0xc68ac1a8,0xbad4ade8},
	{0x894a0000,0x71670000,0x7a710078,0xa8013000,0x2b5d0228,0x8a87b56e,0xab162933,0x763c9f51,0xb05f0000,0xc4830000,0xd7c2002a,0x7a024000,0x85ee02e4,0x47a26b61,0x9eb419e2,0x30db0ebd},
	{0x80630000,0xcbba0000,0x00c3007a,0x28e44000,0x97b60006,0xdb353f50,0xf328f179,0xfc333c04,0x3ff20000,0x432d0000,0x0227002a,0x45d87000,0xfd7003ff,0x3e2e0087,0xa2af9b49,0x91a21bfa},
	{0xf69e0000,0x231e0000,0x19440014,0xa8f00000,0x3a3f006a,0xb8a30561,0xdb332f00,0xa249614c,0x4ff10000,0x188a0000,0xd9ea0048,0x3a6e0000,0x417f0091,0x314152f1,0x9876793f,0xd3f0f217},
	{0xffb70000,0x99c30000,0x63f60016,0x28157000,0x86d40244,0xe9118f5f,0x830df74a,0x2846c219,0xc05c0000,0x9f240000,0x0c0f0048,0x05b43000,0x39e1018a,0x48cd3917,0xa46dfb94,0x7289e750},
	{0x79330000,0xa4b00000,0xcca10014,0x972a3000,0x42a10171,0xc12f6e87,0xe728adab,0x0330740b,0xc9750000,0x25f90000,0x76bd004a,0x85514000,0x850a03a4,0x197fb329,0xfc5323de,0xf8864405},
	{0x701a0000,0x1e6d0000,0xb6130016,0x17cf4000,0xfe4a035f,0x909de4b9,0xbf1675e1,0x893fd75e,0x46d80000,0xa2570000,0xa358004a,0xba8b7000,0xfd9402bf,0x60f3d8cf,0xc048a175,0x59ff5142},
	{0x36db0000,0xf9f00000,0x78950028,0xc53d0000,0x419b01d1,0x6f9c8ab9,0xfa914303,0x1badb8af,0x303c0000,0x0f390000,0xd7010050,0x52e60000,0x125802e2,0x9c975431,0x6d9ce89b,0xcce832b9},
	{0x3ff20000,0x432d0000,0x0227002a,0x45d87000,0xfd7003ff,0x3e2e0087,0xa2af9b49,0x91a21bfa,0xbf910000,0x88970000,0x02e40050,0x6d3c3000,0x6ac603f9,0xe51b3fd7,0x51876a30,0x6d9127fe},
	{0xb9760000,0x7e5e0000,0xad700028,0xfae73000,0x390500ca,0x1610e15f,0xc68ac1a8,0xbad4ade8,0xb6b80000,0x324a0000,0x78560052,0xedd94000,0xd62d01d7,0xb4a9b5e9,0x09b9b27a,0xe79e84ab},
	{0xb05f0000,0xc4830000,0xd7c2002a,0x7a024000,0x85ee02e4,0x47a26b61,0x9eb419e2,0x30db0ebd,0x39150000,0xb5e40000,0xadb30052,0xd2037000,0xaeb300cc,0xcd25de0f,0x35a230d1,0x46e791ec},
	{0x89530000,0x34ad0000,0x17af000c,0xc0780000,0x69180219,0x157503a1,0x2ed9bea4,0xbd51a1e2,0xf0790000,0xd5d70000,0xb6d0006c,0x3f2b0000,0x69fc0359,0x4ba8dbe9,0x4c3e8498,0x750ceb5a},
	{0x807a0000,0x8e700000,0x6d1d000e,0x409d7000,0xd5f30037,0x44c7899f,0x76e766ee,0x375e02b7,0x7fd40000,0x52790000,0x6335006c,0x00f13000,0x11620242,0x3224b00f,0x70250633,0xd475fe1d},
	{0x06fe0000,0xb3030000,0xc24a000c,0xffa23000,0x11860302,0x6cf96847,0x12c23c0f,0x1c28b4a5,0x76fd0000,0xe8a40000,0x1987006e,0x80144000,0xad89006c,0x63963a31,0x281bde79,0x5e7a5d48},
	{0x0fd70000,0x09de0000,0xb8f8000e,0x7f474000,0xad6d012c,0x3d4be279,0x4afce445,0x962717f0,0xf9500000,0x6f0a0000,0xcc62006e,0xbfce7000,0xd5170177,0x1a1a51d7,0x14005cd2,0xff03480f},
	{0x49160000,0xee430000,0x767e0030,0xadb50000,0x12bc03a2,0xc24a8c79,0x0f7bd2a7,0x04b57801,0x8fb40000,0xc2640000,0xb83b0074,0x57a30000,0x3adb012a,0xe67edd29,0xb9d4153c,0x6a142bf4},
	{0x403f0000,0x549e0000,0x0ccc0032,0x2d507000,0xae57018c,0x93f80647,0x57450aed,0x8ebadb54,0x00190000,0x45ca0000,0x6dde0074,0x68793000,0x42450031,0x9ff2b6cf,0x85cf9797,0xcb6d3eb3},
	{0xc6bb0000,0x69ed0000,0xa39b0030,0x926f3000,0x6a2202b9,0xbbc6e79f,0x3360500c,0xa5cc6d46,0x09300000,0xff170000,0x176c0076,0xe89c4000,0xfeae021f,0xce403cf1,0xddf14fdd,0x41629de6},
	{0xcf920000,0xd3300000,0xd9290032,0x128a4000,0xd6c90097,0xea746da1,0x6b5e8846,0x2fc3ce13,0x869d0000,0x78b90000,0xc2890076,0xd7467000,0x86300304,0xb7cc5717,0xe1eacd76,0xe01b88a1},
	{0x4ff10000,0x188a0000,0xd9ea0048,0x3a6e0000,0x417f0091,0x314152f1,0x9876793f,0xd3f0f217,0xb96f0000,0x3b940000,0xc0ae005c,0x929e0000,0x7b4000fb,0x89e25790,0x4345563f,0x71b9935b},
	{0x46d80000,0xa2570000,0xa358004a,0xba8b7000,0xfd9402bf,0x60f3d8cf,0xc048a175,0x59ff5142,0x36c20000,0xbc3a0000,0x154b005c,0xad443000,0x03de01e0,0xf06e3c76,0x7f5ed494,0xd0c0861c},
	{0xc05c0000,0x9f240000,0x0c0f0048,0x05b43000,0x39e1018a,0x48cd3917,0xa46dfb94,0x7289e750,0x3feb0000,0x06e70000,0x6ff9005e,0x2da14000,0xbf3503ce,0xa1dcb648,0x27600cde,0x5acf2549},
	{0xc9750000,0x25f90000,0x76bd004a,0x85514000,0x850a03a4,0x197fb329,0xfc5323de,0xf8864405,0xb0460000,0x81490000,0xba1c005e,0x127b7000,0xc7ab02d5,0xd850ddae,0x1b7b8e75,0xfbb6300e},
	{0x8fb40000,0xc2640000,0xb83b0074,0x57a30000,0x3adb012a,0xe67edd29,0xb9d4153c,0x6a142bf4,0xc6a20000,0x2c270000,0xce450044,0xfa160000,0x28670288,0x24345150,0xb6afc79b,0x6ea153f5},
	{0x869d0000,0x78b90000,0xc2890076,0xd7467000,0x86300304,0xb7cc5717,0xe1eacd76,0xe01b88a1,0x490f0000,0xab890000,0x1ba00044,0xc5cc3000,0x50f90393,0x5db83ab6,0x8ab44530,0xcfd846b2},
	{0x00190000,0x45ca0000,0x6dde0074,0x68793000,0x42450031,0x9ff2b6cf,0x85cf9797,0xcb6d3eb3,0x40260000,0x11540000,0x61120046,0x45294000,0xec1201bd,0x0c0ab088,0xd28a9d7a,0x45d7e5e7},
	{0x09300000,0xff170000,0x176c0076,0xe89c4000,0xfeae021f,0xce403cf1,0xddf14fdd,0x41629de6,0xcf8b0000,0x96fa0000,0xb4f70046,0x7af37000,0x948c00a6,0x7586db6e,0xee911fd1,0xe4aef0a0},
	{0x303c0000,0x0f390000,0xd7010050,0x52e60000,0x125802e2,0x9c975431,0x6d9ce89b,0xcce832b9,0x06e70000,0xf6c90000,0xaf940078,0x97db0000,0x53c30333,0xf30bde88,0x970dab98,0xd7458a16},
	{0x39150000,0xb5e40000,0xadb30052,0xd2037000,0xaeb300cc,0xcd25de0f,0x35a230d1,0x46e791ec,0x894a0000,0x71670000,0x7a710078,0xa8013000,0x2b5d0228,0x8a87b56e,0xab162933,0x763c9f51},
	{0xbf910000,0x88970000,0x02e40050,0x6d3c3000,0x6ac603f9,0xe51b3fd7,0x51876a30,0x6d9127fe,0x80630000,0xcbba0000,0x00c3007a,0x28e44000,0x97b60006,0xdb353f50,0xf328f179,0xfc333c04},
	{0xb6b80000,0x324a0000,0x78560052,0xedd94000,0xd62d01d7,0xb4a9b5e9,0x09b9b27a,0xe79e84ab,0x0fce0000,0x4c140000,0xd526007a,0x173e7000,0xef28011d,0xa2b954b6,0xcf3373d2,0x5d4a2943},
	{0xf0790000,0xd5d70000,0xb6d0006c,0x3f2b0000,0x69fc0359,0x4ba8dbe9,0x4c3e8498,0x750ceb5a,0x792a0000,0xe17a0000,0xa17f0060,0xff530000,0x00e40140,0x5eddd848,0x62e73a3c,0xc85d4ab8},
	{0xf9500000,0x6f0a0000,0xcc62006e,0xbfce7000,0xd5170177,0x1a1a51d7,0x14005cd2,0xff03480f,0xf6870000,0x66d40000,0x749a0060,0xc0893000,0x787a005b,0x2751b3ae,0x5efcb897,0x69245fff},
	{0x7fd40000,0x52790000,0x6335006c,0x00f13000,0x11620242,0x3224b00f,0x70250633,0xd475fe1d,0xffae0000,0xdc090000,0x0e280062,0x406c4000,0xc4910275,0x76e33990,0x06c260dd,0xe32bfcaa},
	{0x76fd0000,0xe8a40000,0x1987006e,0x80144000,0xad89006c,0x63963a31,0x281bde79,0x5e7a5d48,0x70030000,0x5ba70000,0xdbcd0062,0x7fb67000,0xbc0f036e,0x0f6f5276,0x3ad9e276,0x4252e9ed},
	{0x333e0000,0x7b610000,0x6143009c,0x1d1b0000,0xf4b90174,0x1754a7e4,0x8689324f,0xe14ae5b5,0x9d1b0000,0xca350000,0xf217000c,0x51270000,0xfa36005a,0xb5450326,0xf6474c39,0x54ab2587},
	{0x3a170000,0xc1bc0000,0x1bf1009e,0x9dfe7000,0x4852035a,0x46e62dda,0xdeb7ea05,0x6b4546e0,0x12b60000,0x4d9b0000,0x27f2000c,0x6efd3000,0x82a80141,0xccc968c0,0xca5cce92,0xf5d230c0},
	{0xbc930000,0xfccf0000,0xb4a6009c,0x22c13000,0x8c27006f,0x6ed8cc02,0xba92b0e4,0x4033f0f2,0x1b9f0000,0xf7460000,0x5d40000e,0xee184000,0x3e43036f,0x9d7be2fe,0x926216d8,0x7fdd9395},
	{0xb5ba0000,0x46120000,0xce14009e,0xa2244000,0x30cc0241,0x3f6a463c,0xe2ac68ae,0xca3c53a7,0x94320000,0x70e80000,0x88a5000e,0xd1c27000,0x46dd0274,0xe4f78918,0xae799473,0xdea486d2},
	{0xf37b0000,0xa18f0000,0x009200a0,0x70d60000,0x8f1d00cf,0xc06b283c,0xa72b5e4c,0x58ae3c56,0xe2d60000,0xdd860000,0xfcfc0014,0x39af0000,0xa9110229,0x189305e6,0x03addd9d,0x4bb3e529},
	{0xfa520000,0x1b520000,0x7a2000a2,0xf0337000,0x33f602e1,0x91d9a202,0xff158606,0xd2a19f03,0x6d7b0000,0x5a280000,0x29190014,0x06753000,0xd18f0332,0x611f6e00,0x3fb65f36,0xeacaf06e},
	{0x7cd60000,0x26210000,0xd57700a0,0x4f0c3000,0xf78301d4,0xb9e743da,0x9b30dce7,0xf9d72911,0x64520000,0xe0f50000,0x53ab0016,0x86904000,0x6d64011c,0x30ade43e,0x6788877c,0x60c5533b},
	{0x75ff0000,0x9cfc0000,0xafc500a2,0xcfe94000,0x4b6803fa,0xe855c9e4,0xc30e04ad,0x73d88a44,0xebff0000,0x675b0000,0x864e0016,0xb94a7000,0x15fa0007,0x49218fd8,0x5b9305d7,0xc1bc467c},
	{0x4cf30000,0x6cd20000,0x6fa80084,0x75930000,0xa79e0307,0xba82a124,0x7363a3eb,0xfe52251b,0x22930000,0x07680000,0x9d2d0028,0x54620000,0xd2b50392,0xcfac8a3e,0x220fb19e,0xf2573cca},
	{0x45da0000,0xd60f0000,0x151a0086,0xf5767000,0x1b750129,0xeb302b1a,0x2b5d7ba1,0x745d864e,0xad3e0000,0x80c60000,0x48c80028,0x6bb83000,0xaa2b0289,0xb620e1d8,0x1e143335,0x532e298d},
	{0xc35e0000,0xeb7c0000,0xba4d0084,0x4a493000,0xdf00021c,0xc30ecac2,0x4f782140,0x5f2b305c,0xa4170000,0x3a1b0000,0x327a002a,0xeb5d4000,0x16c000a7,0xe7926be6,0x462aeb7f,0xd9218ad8},
	{0xca770000,0x51a10000,0xc0ff0086,0xcaac4000,0x63eb0032,0x92bc40fc,0x1746f90a,0xd5249309,0x2bba0000,0xbdb50000,0xe79f002a,0xd4877000,0x6e5e01bc,0x9e1e0000,0x7a3169d4,0x78589f9f},
	{0x8cb60000,0xb63c0000,0x0e7900b8,0x185e0000,0xdc3a02bc,0x6dbd2efc,0x52c1cfe8,0x47b6fcf8,0x5d5e0000,0x10db0000,0x93c60030,0x3cea0000,0x819201e1,0x627a8cfe,0xd7e5203a,0xed4ffc64},
	{0x859f0000,0x0ce10000,0x74cb00ba,0x98bb7000,0x60d10092,0x3c0fa4c2,0x0aff17a2,0xcdb95fad,0xd2f30000,0x97750000,0x46230030,0x03303000,0xf90c00fa,0x1bf6e718,0xebfea291,0x4c36e923},
	{0x031b0000,0x31920000,0xdb9c00b8,0x27843000,0xa4a403a7,0x1431451a,0x6eda4d43,0xe6cfe9bf,0xdbda0000,0x2da80000,0x3c910032,0x83d54000,0x45e702d4,0x4a446d26,0xb3c07adb,0xc6394a76},
	{0x0a320000,0x8b4f0000,0xa12e00ba,0xa7614000,0x184f0189,0x4583cf24,0x36e49509,0x6cc04aea,0x54770000,0xaa060000,0xe9740032,0xbc0f7000,0x3d7903cf,0x33c806c0,0x8fdbf870,0x67405f31},
	{0x8a510000,0x40f50000,0xa1ed00c0,0x8f850000,0x8ff9018f,0x9eb6f074,0xc5cc6470,0x90f376ee,0x6b850000,0xe92b0000,0xeb530018,0xf9d70000,0xc0090030,0x0de60647,0x2d746339,0xf6e244cb},
	{0x83780000,0xfa280000,0xdb5f00c2,0x0f607000,0x331203a1,0xcf047a4a,0x9df2bc3a,0x1afcd5bb,0xe4280000,0x6e850000,0x3eb60018,0xc60d3000,0xb897012b,0x746a6da1,0x116fe192,0x579b518c},
	{0x05fc0000,0xc75b0000,0x740800c0,0xb05f3000,0xf7670094,0xe73a9b92,0xf9d7e6db,0x318a63a9,0xed010000,0xd4580000,0x4404001a,0x46e84000,0x047c0305,0x25d8e79f,0x495139d8,0xdd94f2d9},
	{0x0cd50000,0x7d860000,0x0eba00c2,0x30ba4000,0x4b8c02ba,0xb68811ac,0xa1e93e91,0xbb85c0fc,0x62ac0000,0x53f60000,0x91e1001a,0x79327000,0x7ce2021e,0x5c548c79,0x754abb73,0x7cede79e},
	{0x4a140000,0x9a1b0000,0xc03c00fc,0xe2480000,0xf45d0034,0x49897fac,0xe46e0873,0x2917af0d,0x14480000,0xfe980000,0xe5b80000,0x915f0000,0x932e0243,0xa0300087,0xd89ef29d,0xe9fa8465},
	{0x433d0000,0x20c60000,0xba8e00fe,0x62ad7000,0x48b6021a,0x183bf592,0xbc50d039,0xa3180c58,0x9be50000,0x79360000,0x305d0000,0xae853000,0xebb00358,0xd9bc6b61,0xe4857036,0x48839122},
	{0xc5b90000,0x1db50000,0x15d900fc,0xdd923000,0x8cc3012f,0x3005144a,0xd8758ad8,0x886eba4a,0x92cc0000,0xc3eb0000,0x4aef0002,0x2e604000,0x575b0176,0x880ee15f,0xbcbba87c,0xc28c3277},
	{0xcc900000,0xa7680000,0x6f6b00fe,0x5d774000,0x30280301,0x61b79e74,0x804b5292,0x0261191f,0x1d610000,0x44450000,0x9f0a0002,0x11ba7000,0x2fc5006d,0xf1828ab9,0x80a02ad7,0x63f52730},
	{0xf59c0000,0x57460000,0xaf0600d8,0xe70d0000,0xdcde03fc,0x3360f6b4,0x3026f5d4,0x8febb640,0xd40d0000,0x24760000,0x8469003c,0xfc920000,0xe88a03f8,0x770f8f5f,0xf93c9e9e,0x501e5d86},
	{0xfcb50000,0xed9b0000,0xd5b400da,0x67e87000,0x603501d2,0x62d27c8a,0x68182d9e,0x05e41515,0x5ba00000,0xa3d80000,0x518c003c,0xc3483000,0x901402e3,0x0e83e4b9,0xc5271c35,0xf16748c1},
	{0x7a310000,0xd0e80000,0x7ae300d8,0xd8d73000,0xa44002e7,0x4aec9d52,0x0c3d777f,0x2e92a307,0x52890000,0x19050000,0x2b3e003e,0x43ad4000,0x2cff00cd,0x5f316e87,0x9d19c47f,0x7b68eb94},
	{0x73180000,0x6a350000,0x005100da,0x58324000,0x18ab00c9,0x1b5e176c,0x5403af35,0xa49d0052,0xdd240000,0x9eab0000,0xfedb003e,0x7c777000,0x546101d6,0x26bd0561,0xa10246d4,0xda11fed3},
	{0x35d90000,0x8da80000,0xced700e4,0x8ac00000,0xa77a0247,0xe45f796c,0x118499d7,0x360f6fa3,0xabc00000,0x33c50000,0x8a820024,0x941a0000,0xbbad018b,0xdad9899f,0x0cd60f3a,0x4f069d28},
	{0x3cf00000,0x37750000,0xb46500e6,0x0a257000,0x1b910069,0xb5edf352,0x49ba419d,0xbc00ccf6,0x246d0000,0xb46b0000,0x5f670024,0xabc03000,0xc3330090,0xa355e279,0x30cd8d91,0xee7f886f},
	{0xba740000,0x0a060000,0x1b3200e4,0xb51a3000,0xdfe4035c,0x9dd3128a,0x2d9f1b7c,0x97767ae4,0x2d440000,0x0eb60000,0x25d50026,0x2b254000,0x7fd802be,0xf2e76847,0x68f355db,0x64702b3a},
	{0xb35d0000,0xb0db0000,0x618000e6,0x35ff4000,0x630f0172,0xcc6198b4,0x75a1c336,0x1d79d9b1,0xa2e90000,0x89180000,0xf0300026,0x14ff7000,0x074603a5,0x8b6b03a1,0x54e8d770,0xc5093e7d},
	{0xc5a00000,0x587f0000,0x78070088,0xb5eb0000,0xce86011e,0xaff7a285,0x5dba1d4f,0x430384f9,0xd2ea0000,0xd2bf0000,0x2bfd0044,0x6b490000,0xbb4900cb,0x840451d7,0x6e313506,0x875bd790},
	{0xcc890000,0xe2a20000,0x02b5008a,0x350e7000,0x726d0330,0xfe4528bb,0x0584c505,0xc90c27ac,0x5d470000,0x55110000,0xfe180044,0x54933000,0xc3d701d0,0xfd883a31,0x522ab7ad,0x2622c2d7},
	{0x4a0d0000,0xdfd10000,0xade20088,0x8a313000,0xb6180005,0xd67bc963,0x61a19fe4,0xe27a91be,0x546e0000,0xefcc0000,0x84aa0046,0xd4764000,0x7f3c03fe,0xac3ab00f,0x0a146fe7,0xac2d6182},
	{0x43240000,0x650c0000,0xd750008a,0x0ad44000,0x0af3022b,0x87c9435d,0x399f47ae,0x687532eb,0xdbc30000,0x68620000,0x514f0046,0xebac7000,0x07a202e5,0xd5b6dbe9,0x360fed4c,0x0d5474c5},
	{0x05e50000,0x82910000,0x19d600b4,0xd8260000,0xb52200a5,0x78c82d5d,0x7c18714c,0xfae75d1a,0xad270000,0xc50c0000,0x2516005c,0x03c10000,0xe86e02b8,0x29d25717,0x9bdba4a2,0x9843173e},
	{0x0ccc0000,0x384c0000,0x636400b6,0x58c37000,0x09c9028b,0x297aa763,0x2426a906,0x70e8fe4f,0x228a0000,0x42a20000,0xf0f3005c,0x3c1b3000,0x90f003a3,0x505e3cf1,0xa7c02609,0x393a0279},
	{0x8a480000,0x053f0000,0xcc3300b4,0xe7fc3000,0xcdbc01be,0x014446bb,0x4003f3e7,0x5b9e485d,0x2ba30000,0xf87f0000,0x8a41005e,0xbcfe4000,0x2c1b018d,0x01ecb6cf,0xfffefe43,0xb335a12c},
	{0x83610000,0xbfe20000,0xb68100b6,0x67194000,0x71570390,0x50f6cc85,0x183d2bad,0xd191eb08,0xa40e0000,0x7fd10000,0x5fa4005e,0x83247000,0x54850096,0x7860dd29,0xc3e57ce8,0x124cb46b},
	{0xba6d0000,0x4fcc0000,0x76ec0090,0xdd630000,0x9da1036d,0x0221a445,0xa8508ceb,0x5c1b4457,0x6d620000,0x1fe20000,0x44c70060,0x6e0c0000,0x93ca0303,0xfeedd8cf,0xba79c8a1,0x21a7cedd},
	{0xb3440000,0xf5110000,0x0c5e0092,0x5d867000,0x214a0143,0x53932e7b,0xf06e54a1,0xd614e702,0xe2cf0000,0x984c0000,0x91220060,0x51d63000,0xeb540218,0x8761b329,0x86624a0a,0x80dedb9a},
	{0x35c00000,0xc8620000,0xa3090090,0xe2b93000,0xe53f0276,0x7badcfa3,0x944b0e40,0xfd625110,0xebe60000,0x22910000,0xeb900062,0xd1334000,0x57bf0036,0xd6d33917,0xde5c9240,0x0ad178cf},
	{0x3ce90000,0x72bf0000,0xd9bb0092,0x625c4000,0x59d40058,0x2a1f459d,0xcc75d60a,0x776df245,0x644b0000,0xa53f0000,0x3e750062,0xeee97000,0x2f21012d,0xaf5f52f1,0xe24710eb,0xaba86d88},
	{0x7a280000,0x95220000,0x173d00ac,0xb0ae0000,0xe60502d6,0xd51e2b9d,0x89f2e0e8,0xe5ff9db4,0x12af0000,0x08510000,0x4a2c0078,0x06840000,0xc0ed0170,0x533bde0f,0x4f935905,0x3ebf0e73},
	{0x73010000,0x2fff0000,0x6d8f00ae,0x304b7000,0x5aee00f8,0x84aca1a3,0xd1cc38a2,0x6ff03ee1,0x9d020000,0x8fff0000,0x9fc90078,0x395e3000,0xb873006b,0x2ab7b5e9,0x7388dbae,0x9fc61b34},
	{0xf5850000,0x128c0000,0xc2d800ac,0x8f743000,0x9e9b03cd,0xac92407b,0xb5e96243,0x448688f3,0x942b0000,0x35220000,0xe57b007a,0xb9bb4000,0x04980245,0x7b053fd7,0x2bb603e4,0x15c9b861},
	{0xfcac0000,0xa8510000,0xb86a00ae,0x0f914000,0x227001e3,0xfd20ca45,0xedd7ba09,0xce892ba6,0x1b860000,0xb28c0000,0x309e007a,0x86617000,0x7c06035e,0x02895431,0x17ad814f,0xb4b0ad26},
	{0x7ccf0000,0x63eb0000,0xb8a900d4,0x27750000,0xb5c601e5,0x2615f515,0x1eff4b70,0x32ba17a2,0x24740000,0xf1a10000,0x32b90050,0xc3b90000,0x817600a1,0x3ca754b6,0xb5021a06,0x2512b6dc},
	{0x75e60000,0xd9360000,0xc21b00d6,0xa7907000,0x092d03cb,0x77a77f2b,0x46c1933a,0xb8b5b4f7,0xabd90000,0x760f0000,0xe75c0050,0xfc633000,0xf9e801ba,0x452b3f50,0x891998ad,0x846ba39b},
	{0xf3620000,0xe4450000,0x6d4c00d4,0x18af3000,0xcd5800fe,0x5f999ef3,0x22e4c9db,0x93c302e5,0xa2f00000,0xccd20000,0x9dee0052,0x7c864000,0x45030394,0x1499b56e,0xd12740e7,0x0e6400ce},
	{0xfa4b0000,0x5e980000,0x17fe00d6,0x984a4000,0x71b302d0,0x0e2b14cd,0x7ada1191,0x19cca1b0,0x2d5d0000,0x4b7c0000,0x480b0052,0x435c7000,0x3d9d028f,0x6d15de88,0xed3cc24c,0xaf1d1589},
	{0xbc8a0000,0xb9050000,0xd97800e8,0x4ab80000,0xce62005e,0xf12a7acd,0x3f5d2773,0x8b5ece41,0x5bb90000,0xe6120000,0x3c520048,0xab310000,0xd25102d2,0x91715276,0x40e88ba2,0x3a0a7672},
	{0xb5a30000,0x03d80000,0xa3ca00ea,0xca5d7000,0x72890270,0xa098f0f3,0x6763ff39,0x01516d14,0xd4140000,0x61bc0000,0xe9b70048,0x94eb3000,0xaacf03c9,0xe8fd3990,0x7cf30909,0x9b736335},
	{0x33270000,0x3eab0000,0x0c9d00e8,0x75623000,0xb6fc0145,0x88a6112b,0x0346a5d8,0x2a27db06,0xdd3d0000,0xdb610000,0x9305004a,0x140e4000,0x162401e7,0xb94fb3ae,0x24cdd143,0x117cc060},
	{0x3a0e0000,0x84760000,0x762f00ea,0xf5874000,0x0a17036b,0xd9149b15,0x5b787d92,0xa0287853,0x52900000,0x5ccf0000,0x46e0004a,0x2bd47000,0x6eba00fc,0xc0c3d848,0x18d653e8,0xb005d527},
	{0x03020000,0x74580000,0xb64200cc,0x4ffd0000,0xe6e10396,0x8bc3f3d5,0xeb15dad4,0x2da2d70c,0x9bfc0000,0x3cfc0000,0x5d830074,0xc6fc0000,0xa9f50369,0x464eddae,0x614ae7a1,0x83eeaf91},
	{0x0a2b0000,0xce850000,0xccf000ce,0xcf187000,0x5a0a01b8,0xda7179eb,0xb32b029e,0xa7ad7459,0x14510000,0xbb520000,0x88660074,0xf9263000,0xd16b0272,0x3fc2b648,0x5d51650a,0x2297bad6},
	{0x8caf0000,0xf3f60000,0x63a700cc,0x70273000,0x9e7f028d,0xf24f9833,0xd70e587f,0x8cdbc24b,0x1d780000,0x018f0000,0xf2d40076,0x79c34000,0x6d80005c,0x6e703c76,0x056fbd40,0xa8981983},
	{0x85860000,0x492b0000,0x191500ce,0xf0c24000,0x229400a3,0xa3fd120d,0x8f308035,0x06d4611e,0x92d50000,0x86210000,0x27310076,0x46197000,0x151e0147,0x17fc5790,0x39743feb,0x09e10cc4},
	{0xc3470000,0xaeb60000,0xd79300f0,0x22300000,0x9d45022d,0x5cfc7c0d,0xcab7b6d7,0x94460eef,0xe4310000,0x2b4f0000,0x5368006c,0xae740000,0xfad2011a,0xeb98db6e,0x94a07605,0x9cf66f3f},
	{0xca6e0000,0x146b0000,0xad2100f2,0xa2d57000,0x21ae0003,0x0d4ef633,0x92896e9d,0x1e49adba,0x6b9c0000,0xace10000,0x868d006c,0x91ae3000,0x824c0001,0x9214b088,0xa8bbf4ae,0x3d8f7a78},
	{0x4cea0000,0x29180000,0x027600f0,0x1dea3000,0xe5db0336,0x257017eb,0xf6ac347c,0x353f1ba8,0x62b50000,0x163c0000,0xfc3f006e,0x114b4000,0x3ea7022f,0xc3a63ab6,0xf0852ce4,0xb780d92d},
	{0x45c30000,0x93c50000,0x78c400f2,0x9d0f4000,0x59300118,0x74c29dd5,0xae92ec36,0xbf30b8fd,0xed180000,0x91920000,0x29da006e,0x2e917000,0x46390334,0xba2a5150,0xcc9eae4f,0x16f9cc6a},
	{0x9d1b0000,0xca350000,0xf217000c,0x51270000,0xfa36005a,0xb5450326,0xf6474c39,0x54ab2587,0xae250000,0xb1540000,0x93540090,0x4c3c0000,0x0e8f012e,0xa211a4c2,0x70ce7e76,0xb5e1c032},
	{0x94320000,0x70e80000,0x88a5000e,0xd1c27000,0x46dd0274,0xe4f78918,0xae799473,0xdea486d2,0x21880000,0x36fa0000,0x46b10090,0x73e63000,0x76110035,0xdb9dcf24,0x4cd5fcdd,0x1498d575},
	{0x12b60000,0x4d9b0000,0x27f2000c,0x6efd3000,0x82a80141,0xccc968c0,0xca5cce92,0xf5d230c0,0x28a10000,0x8c270000,0x3c030092,0xf3034000,0xcafa021b,0x8a2f451a,0x14eb2497,0x9e977620},
	{0x1b9f0000,0xf7460000,0x5d40000e,0xee184000,0x3e43036f,0x9d7be2fe,0x926216d8,0x7fdd9395,0xa70c0000,0x0b890000,0xe9e60092,0xccd97000,0xb2640300,0xf3a32efc,0x28f0a63c,0x3fee6367},
	{0x5d5e0000,0x10db0000,0x93c60030,0x3cea0000,0x819201e1,0x627a8cfe,0xd7e5203a,0xed4ffc64,0xd1e80000,0xa6e70000,0x9dbf0088,0x24b40000,0x5da8035d,0x0fc7a202,0x8524efd2,0xaaf9009c},
	{0x54770000,0xaa060000,0xe9740032,0xbc0f7000,0x3d7903cf,0x33c806c0,0x8fdbf870,0x67405f31,0x5e450000,0x21490000,0x485a0088,0x1b6e3000,0x25360246,0x764bc9e4,0xb93f6d79,0x0b8015db},
	{0xd2f30000,0x97750000,0x46230030,0x03303000,0xf90c00fa,0x1bf6e718,0xebfea291,0x4c36e923,0x576c0000,0x9b940000,0x32e8008a,0x9b8b4000,0x99dd0068,0x27f943da,0xe101b533,0x818fb68e},
	{0xdbda0000,0x2da80000,0x3c910032,0x83d54000,0x45e702d4,0x4a446d26,0xb3c07adb,0xc6394a76,0xd8c10000,0x1c3a0000,0xe70d008a,0xa4517000,0xe1430173,0x5e75283c,0xdd1a3798,0x20f6a3c9},
	{0xe2d60000,0xdd860000,0xfcfc0014,0x39af0000,0xa9110229,0x189305e6,0x03addd9d,0x4bb3e529,0x11ad0000,0x7c090000,0xfc6e00b4,0x49790000,0x260c02e6,0xd8f82dda,0xa48683d1,0x131dd97f},
	{0xebff0000,0x675b0000,0x864e0016,0xb94a7000,0x15fa0007,0x49218fd8,0x5b9305d7,0xc1bc467c,0x9e000000,0xfba70000,0x298b00b4,0x76a33000,0x5e9203fd,0xa174463c,0x989d017a,0xb264cc38},
	{0x6d7b0000,0x5a280000,0x29190014,0x06753000,0xd18f0332,0x611f6e00,0x3fb65f36,0xeacaf06e,0x97290000,0x417a0000,0x533900b6,0xf6464000,0xe27901d3,0xf0c6cc02,0xc0a3d930,0x386b6f6d},
	{0x64520000,0xe0f50000,0x53ab0016,0x86904000,0x6d64011c,0x30ade43e,0x6788877c,0x60c5533b,0x18840000,0xc6d40000,0x86dc00b6,0xc99c7000,0x9ae700c8,0x894aa7e4,0xfcb85b9b,0x99127a2a},
	{0x22930000,0x07680000,0x9d2d0028,0x54620000,0xd2b50392,0xcfac8a3e,0x220fb19e,0xf2573cca,0x6e600000,0x6bba0000,0xf28500ac,0x21f10000,0x752b0095,0x752e2b1a,0x516c1275,0x0c0519d1},
	{0x2bba0000,0xbdb50000,0xe79f002a,0xd4877000,0x6e5e01bc,0x9e1e0000,0x7a3169d4,0x78589f9f,0xe1cd0000,0xec140000,0x276000ac,0x1e2b3000,0x0db5018e,0x0ca240fc,0x6d7790de,0xad7c0c96},
	{0xad3e0000,0x80c60000,0x48c80028,0x6bb83000,0xaa2b0289,0xb620e1d8,0x1e143335,0x532e298d,0xe8e40000,0x56c90000,0x5dd200ae,0x9ece4000,0xb15e03a0,0x5d10cac2,0x35494894,0x2773afc3},
	{0xa4170000,0x3a1b0000,0x327a002a,0xeb5d4000,0x16c000a7,0xe7926be6,0x462aeb7f,0xd9218ad8,0x67490000,0xd1670000,0x883700ae,0xa1147000,0xc9c002bb,0x249ca124,0x0952ca3f,0x860aba84},
	{0x24740000,0xf1a10000,0x32b90050,0xc3b90000,0x817600a1,0x3ca754b6,0xb5021a06,0x2512b6dc,0x58bb0000,0x924a0000,0x8a100084,0xe4cc0000,0x34b00144,0x1ab2a1a3,0xabfd5176,0x17a8a17e},
	{0x2d5d0000,0x4b7c0000,0x480b0052,0x435c7000,0x3d9d028f,0x6d15de88,0xed3cc24c,0xaf1d1589,0xd7160000,0x15e40000,0x5ff50084,0xdb163000,0x4c2e005f,0x633eca45,0x97e6d3dd,0xb6d1b439},
	{0xabd90000,0x760f0000,0xe75c0050,0xfc633000,0xf9e801ba,0x452b3f50,0x891998ad,0x846ba39b,0xde3f0000,0xaf390000,0x25470086,0x5bf34000,0xf0c50271,0x328c407b,0xcfd80b97,0x3cde176c},
	{0xa2f00000,0xccd20000,0x9dee0052,0x7c864000,0x45030394,0x1499b56e,0xd12740e7,0x0e6400ce,0x51920000,0x28970000,0xf0a20086,0x64297000,0x885b036a,0x4b002b9d,0xf3c3893c,0x9da7022b},
	{0xe4310000,0x2b4f0000,0x5368006c,0xae740000,0xfad2011a,0xeb98db6e,0x94a07605,0x9cf66f3f,0x27760000,0x85f90000,0x84fb009c,0x8c440000,0x67970337,0xb764a763,0x5e17c0d2,0x08b061d0},
	{0xed180000,0x91920000,0x29da006e,0x2e917000,0x46390334,0xba2a5150,0xcc9eae4f,0x16f9cc6a,0xa8db0000,0x02570000,0x511e009c,0xb39e3000,0x1f09022c,0xcee8cc85,0x620c4279,0xa9c97497},
	{0x6b9c0000,0xace10000,0x868d006c,0x91ae3000,0x824c0001,0x9214b088,0xa8bbf4ae,0x3d8f7a78,0xa1f20000,0xb88a0000,0x2bac009e,0x337b4000,0xa3e20002,0x9f5a46bb,0x3a329a33,0x23c6d7c2},
	{0x62b50000,0x163c0000,0xfc3f006e,0x114b4000,0x3ea7022f,0xc3a63ab6,0xf0852ce4,0xb780d92d,0x2e5f0000,0x3f240000,0xfe49009e,0x0ca17000,0xdb7c0119,0xe6d62d5d,0x06291898,0x82bfc285},
	{0x5bb90000,0xe6120000,0x3c520048,0xab310000,0xd25102d2,0x91715276,0x40e88ba2,0x3a0a7672,0xe7330000,0x5f170000,0xe52a00a0,0xe1890000,0x1c33028c,0x605b28bb,0x7fb5acd1,0xb154b833},
	{0x52900000,0x5ccf0000,0x46e0004a,0x2bd47000,0x6eba00fc,0xc0c3d848,0x18d653e8,0xb005d527,0x689e0000,0xd8b90000,0x30cf00a0,0xde533000,0x64ad0397,0x19d7435d,0x43ae2e7a,0x102dad74},
	{0xd4140000,0x61bc0000,0xe9b70048,0x94eb3000,0xaacf03c9,0xe8fd3990,0x7cf30909,0x9b736335,0x61b70000,0x62640000,0x4a7d00a2,0x5eb64000,0xd84601b9,0x4865c963,0x1b90f630,0x9a220e21},
	{0xdd3d0000,0xdb610000,0x9305004a,0x140e4000,0x162401e7,0xb94fb3ae,0x24cdd143,0x117cc060,0xee1a0000,0xe5ca0000,0x9f9800a2,0x616c7000,0xa0d800a2,0x31e9a285,0x278b749b,0x3b5b1b66},
	{0x9bfc0000,0x3cfc0000,0x5d830074,0xc6fc0000,0xa9f50369,0x464eddae,0x614ae7a1,0x83eeaf91,0x98fe0000,0x48a40000,0xebc100b8,0x89010000,0x4f1400ff,0xcd8d2e7b,0x8a5f3d75,0xae4c789d},
	{0x92d50000,0x86210000,0x27310076,0x46197000,0x151e0147,0x17fc5790,0x39743feb,0x09e10cc4,0x17530000,0xcf0a0000,0x3e2400b8,0xb6db3000,0x378a01e4,0xb401459d,0xb644bfde,0x0f356dda},
	{0x14510000,0xbb520000,0x88660074,0xf9263000,0xd16b0272,0x3fc2b648,0x5d51650a,0x2297bad6,0x1e7a0000,0x75d70000,0x449600ba,0x363e4000,0x8b6103ca,0xe5b3cfa3,0xee7a6794,0x853ace8f},
	{0x1d780000,0x018f0000,0xf2d40076,0x79c34000,0x6d80005c,0x6e703c76,0x056fbd40,0xa8981983,0x91d70000,0xf2790000,0x917300ba,0x09e47000,0xf3ff02d1,0x9c3fa445,0xd261e53f,0x2443dbc8},
	{0x6b850000,0xe92b0000,0xeb530018,0xf9d70000,0xc0090030,0x0de60647,0x2d746339,0xf6e244cb,0xe1d40000,0xa9de0000,0x4abe00d8,0x76520000,0x4ff001bf,0x9350f633,0xe8b80749,0x66113225},
	{0x62ac0000,0x53f60000,0x91e1001a,0x79327000,0x7ce2021e,0x5c548c79,0x754abb73,0x7cede79e,0x6e790000,0x2e700000,0x9f5b00d8,0x49883000,0x376e00a4,0xeadc9dd5,0xd4a385e2,0xc7682762},
	{0xe4280000,0x6e850000,0x3eb60018,0xc60d3000,0xb897012b,0x746a6da1,0x116fe192,0x579b518c,0x67500000,0x94ad0000,0xe5e900da,0xc96d4000,0x8b85028a,0xbb6e17eb,0x8c9d5da8,0x4d678437},
	{0xed010000,0xd4580000,0x4404001a,0x46e84000,0x047c0305,0x25d8e79f,0x495139d8,0xdd94f2d9,0xe8fd0000,0x13030000,0x300c00da,0xf6b77000,0xf31b0391,0xc2e27c0d,0xb086df03,0xec1e9170},
	{0xabc00000,0x33c50000,0x8a820024,0x941a0000,0xbbad018b,0xdad9899f,0x0cd60f3a,0x4f069d28,0x9e190000,0xbe6d0000,0x445500c0,0x1eda0000,0x1cd703cc,0x3e86f0f3,0x1d5296ed,0x7909f28b},
	{0xa2e90000,0x89180000,0xf0300026,0x14ff7000,0x074603a5,0x8b6b03a1,0x54e8d770,0xc5093e7d,0x11b40000,0x39c30000,0x91b000c0,0x21003000,0x644902d7,0x470a9b15,0x21491446,0xd870e7cc},
	{0x246d0000,0xb46b0000,0x5f670024,0xabc03000,0xc3330090,0xa355e279,0x30cd8d91,0xee7f886f,0x189d0000,0x831e0000,0xeb0200c2,0xa1e54000,0xd8a200f9,0x16b8112b,0x7977cc0c,0x527f4499},
	{0x2d440000,0x0eb60000,0x25d50026,0x2b254000,0x7fd802be,0xf2e76847,0x68f355db,0x64702b3a,0x97300000,0x04b00000,0x3ee700c2,0x9e3f7000,0xa03c01e2,0x6f347acd,0x456c4ea7,0xf30651de},
	{0x14480000,0xfe980000,0xe5b80000,0x915f0000,0x932e0243,0xa0300087,0xd89ef29d,0xe9fa8465,0x5e5c0000,0x64830000,0x258400fc,0x73170000,0x67730277,0xe9b97f2b,0x3cf0faee,0xc0ed2b68},
	{0x1d610000,0x44450000,0x9f0a0002,0x11ba7000,0x2fc5006d,0xf1828ab9,0x80a02ad7,0x63f52730,0xd1f10000,0xe32d0000,0xf06100fc,0x4ccd3000,0x1fed036c,0x903514cd,0x00eb7845,0x61943e2f},
	{0x9be50000,0x79360000,0x305d0000,0xae853000,0xebb00358,0xd9bc6b61,0xe4857036,0x48839122,0xd8d80000,0x59f00000,0x8ad300fe,0xcc284000,0xa3060142,0xc1879ef3,0x58d5a00f,0xeb9b9d7a},
	{0x92cc0000,0xc3eb0000,0x4aef0002,0x2e604000,0x575b0176,0x880ee15f,0xbcbba87c,0xc28c3277,0x57750000,0xde5e0000,0x5f3600fe,0xf3f27000,0xdb980059,0xb80bf515,0x64ce22a4,0x4ae2883d},
	{0xd40d0000,0x24760000,0x8469003c,0xfc920000,0xe88a03f8,0x770f8f5f,0xf93c9e9e,0x501e5d86,0x21910000,0x73300000,0x2b6f00e4,0x1b9f0000,0x34540004,0x446f79eb,0xc91a6b4a,0xdff5ebc6},
	{0xdd240000,0x9eab0000,0xfedb003e,0x7c777000,0x546101d6,0x26bd0561,0xa10246d4,0xda11fed3,0xae3c0000,0xf49e0000,0xfe8a00e4,0x24453000,0x4cca011f,0x3de3120d,0xf501e9e1,0x7e8cfe81},
	{0x5ba00000,0xa3d80000,0x518c003c,0xc3483000,0x901402e3,0x0e83e4b9,0xc5271c35,0xf16748c1,0xa7150000,0x4e430000,0x843800e6,0xa4a04000,0xf0210331,0x6c519833,0xad3f31ab,0xf4835dd4},
	{0x52890000,0x19050000,0x2b3e003e,0x43ad4000,0x2cff00cd,0x5f316e87,0x9d19c47f,0x7b68eb94,0x28b80000,0xc9ed0000,0x51dd00e6,0x9b7a7000,0x88bf022a,0x15ddf3d5,0x9124b300,0x55fa4893},
	{0xd2ea0000,0xd2bf0000,0x2bfd0044,0x6b490000,0xbb4900cb,0x840451d7,0x6e313506,0x875bd790,0x174a0000,0x8ac00000,0x53fa00cc,0xdea20000,0x75cf01d5,0x2bf3f352,0x338b2849,0xc4585369},
	{0xdbc30000,0x68620000,0x514f0046,0xebac7000,0x07a202e5,0xd5b6dbe9,0x360fed4c,0x0d5474c5,0x98e70000,0x0d6e0000,0x861f00cc,0xe1783000,0x0d5100ce,0x527f98b4,0x0f90aae2,0x6521462e},
	{0x5d470000,0x55110000,0xfe180044,0x54933000,0xc3d701d0,0xfd883a31,0x522ab7ad,0x2622c2d7,0x91ce0000,0xb7b30000,0xfcad00ce,0x619d4000,0xb1ba02e0,0x03cd128a,0x57ae72a8,0xef2ee57b},
	{0x546e0000,0xefcc0000,0x84aa0046,0xd4764000,0x7f3c03fe,0xac3ab00f,0x0a146fe7,0xac2d6182,0x1e630000,0x301d0000,0x294800ce,0x5e477000,0xc92403fb,0x7a41796c,0x6bb5f003,0x4e57f03c},
	{0x12af0000,0x08510000,0x4a2c0078,0x06840000,0xc0ed0170,0x533bde0f,0x4f935905,0x3ebf0e73,0x68870000,0x9d730000,0x5d1100d4,0xb62a0000,0x26e803a6,0x8625f592,0xc661b9ed,0xdb4093c7},
	{0x1b860000,0xb28c0000,0x309e007a,0x86617000,0x7c06035e,0x02895431,0x17ad814f,0xb4b0ad26,0xe72a0000,0x1add0000,0x88f400d4,0x89f03000,0x5e7602bd,0xffa99e74,0xfa7a3b46,0x7a398680},
	{0x9d020000,0x8fff0000,0x9fc90078,0x395e3000,0xb873006b,0x2ab7b5e9,0x7388dbae,0x9fc61b34,0xee030000,0xa0000000,0xf24600d6,0x09154000,0xe29d0093,0xae1b144a,0xa244e30c,0xf03625d5},
	{0x942b0000,0x35220000,0xe57b007a,0xb9bb4000,0x04980245,0x7b053fd7,0x2bb603e4,0x15c9b861,0x61ae0000,0x27ae0000,0x27a300d6,0x36cf7000,0x9a030188,0xd7977fac,0x9e5f61a7,0x514f3092},
	{0xad270000,0xc50c0000,0x2516005c,0x03c10000,0xe86e02b8,0x29d25717,0x9bdba4a2,0x9843173e,0xa8c20000,0x479d0000,0x3cc000e8,0xdbe70000,0x5d4c021d,0x511a7a4a,0xe7c3d5ee,0x62a44a24},
	{0xa40e0000,0x7fd10000,0x5fa4005e,0x83247000,0x54850096,0x7860dd29,0xc3e57ce8,0x124cb46b,0x276f0000,0xc0330000,0xe92500e8,0xe43d3000,0x25d20306,0x289611ac,0xdbd85745,0xc3dd5f63},
	{0x228a0000,0x42a20000,0xf0f3005c,0x3c1b3000,0x90f003a3,0x505e3cf1,0xa7c02609,0x393a0279,0x2e460000,0x7aee0000,0x939700ea,0x64d84000,0x99390128,0x79249b92,0x83e68f0f,0x49d2fc36},
	{0x2ba30000,0xf87f0000,0x8a41005e,0xbcfe4000,0x2c1b018d,0x01ecb6cf,0xfffefe43,0xb335a12c,0xa1eb0000,0xfd400000,0x467200ea,0x5b027000,0xe1a70033,0x00a8f074,0xbffd0da4,0xe8abe971},
	{0x6d620000,0x1fe20000,0x44c70060,0x6e0c0000,0x93ca0303,0xfeedd8cf,0xba79c8a1,0x21a7cedd,0xd70f0000,0x502e0000,0x322b00f0,0xb36f0000,0x0e6b006e,0xfccc7c8a,0x1229444a,0x7dbc8a8a},
	{0x644b0000,0xa53f0000,0x3e750062,0xeee97000,0x2f21012d,0xaf5f52f1,0xe24710eb,0xaba86d88,0x58a20000,0xd7800000,0xe7ce00f0,0x8cb53000,0x76f50175,0x8540176c,0x2e32c6e1,0xdcc59fcd},
	{0xe2cf0000,0x984c0000,0x91220060,0x51d63000,0xeb540218,0x8761b329,0x86624a0a,0x80dedb9a,0x518b0000,0x6d5d0000,0x9d7c00f2,0x0c504000,0xca1e035b,0xd4f29d52,0x760c1eab,0x56ca3c98},
	{0xebe60000,0x22910000,0xeb900062,0xd1334000,0x57bf0036,0xd6d33917,0xde5c9240,0x0ad178cf,0xde260000,0xeaf30000,0x489900f2,0x338a7000,0xb2800240,0xad7ef6b4,0x4a179c00,0xf7b329df},
	{0xae250000,0xb1540000,0x93540090,0x4c3c0000,0x0e8f012e,0xa211a4c2,0x70ce7e76,0xb5e1c032,0x333e0000,0x7b610000,0x6143009c,0x1d1b0000,0xf4b90174,0x1754a7e4,0x8689324f,0xe14ae5b5},
	{0xa70c0000,0x0b890000,0xe9e60092,0xccd97000,0xb2640300,0xf3a32efc,0x28f0a63c,0x3fee6367,0xbc930000,0xfccf0000,0xb4a6009c,0x22c13000,0x8c27006f,0x6ed8cc02,0xba92b0e4,0x4033f0f2},
	{0x21880000,0x36fa0000,0x46b10090,0x73e63000,0x76110035,0xdb9dcf24,0x4cd5fcdd,0x1498d575,0xb5ba0000,0x46120000,0xce14009e,0xa2244000,0x30cc0241,0x3f6a463c,0xe2ac68ae,0xca3c53a7},
	{0x28a10000,0x8c270000,0x3c030092,0xf3034000,0xcafa021b,0x8a2f451a,0x14eb2497,0x9e977620,0x3a170000,0xc1bc0000,0x1bf1009e,0x9dfe7000,0x4852035a,0x46e62dda,0xdeb7ea05,0x6b4546e0},
	{0x6e600000,0x6bba0000,0xf28500ac,0x21f10000,0x752b0095,0x752e2b1a,0x516c1275,0x0c0519d1,0x4cf30000,0x6cd20000,0x6fa80084,0x75930000,0xa79e0307,0xba82a124,0x7363a3eb,0xfe52251b},
	{0x67490000,0xd1670000,0x883700ae,0xa1147000,0xc9c002bb,0x249ca124,0x0952ca3f,0x860aba84,0xc35e0000,0xeb7c0000,0xba4d0084,0x4a493000,0xdf00021c,0xc30ecac2,0x4f782140,0x5f2b305c},
	{0xe1cd0000,0xec140000,0x276000ac,0x1e2b3000,0x0db5018e,0x0ca240fc,0x6d7790de,0xad7c0c96,0xca770000,0x51a10000,0xc0ff0086,0xcaac4000,0x63eb0032,0x92bc40fc,0x1746f90a,0xd5249309},
	{0xe8e40000,0x56c90000,0x5dd200ae,0x9ece4000,0xb15e03a0,0x5d10cac2,0x35494894,0x2773afc3,0x45da0000,0xd60f0000,0x151a0086,0xf5767000,0x1b750129,0xeb302b1a,0x2b5d7ba1,0x745d864e},
	{0xd1e80000,0xa6e70000,0x9dbf0088,0x24b40000,0x5da8035d,0x0fc7a202,0x8524efd2,0xaaf9009c,0x8cb60000,0xb63c0000,0x0e7900b8,0x185e0000,0xdc3a02bc,0x6dbd2efc,0x52c1cfe8,0x47b6fcf8},
	{0xd8c10000,0x1c3a0000,0xe70d008a,0xa4517000,0xe1430173,0x5e75283c,0xdd1a3798,0x20f6a3c9,0x031b0000,0x31920000,0xdb9c00b8,0x27843000,0xa4a403a7,0x1431451a,0x6eda4d43,0xe6cfe9bf},
	{0x5e450000,0x21490000,0x485a0088,0x1b6e3000,0x25360246,0x764bc9e4,0xb93f6d79,0x0b8015db,0x0a320000,0x8b4f0000,0xa12e00ba,0xa7614000,0x184f0189,0x4583cf24,0x36e49509,0x6cc04aea},
	{0x576c0000,0x9b940000,0x32e8008a,0x9b8b4000,0x99dd0068,0x27f943da,0xe101b533,0x818fb68e,0x859f0000,0x0ce10000,0x74cb00ba,0x98bb7000,0x60d10092,0x3c0fa4c2,0x0aff17a2,0xcdb95fad},
	{0x11ad0000,0x7c090000,0xfc6e00b4,0x49790000,0x260c02e6,0xd8f82dda,0xa48683d1,0x131dd97f,0xf37b0000,0xa18f0000,0x009200a0,0x70d60000,0x8f1d00cf,0xc06b283c,0xa72b5e4c,0x58ae3c56},
	{0x18840000,0xc6d40000,0x86dc00b6,0xc99c7000,0x9ae700c8,0x894aa7e4,0xfcb85b9b,0x99127a2a,0x7cd60000,0x26210000,0xd57700a0,0x4f0c3000,0xf78301d4,0xb9e743da,0x9b30dce7,0xf9d72911},
	{0x9e000000,0xfba70000,0x298b00b4,0x76a33000,0x5e9203fd,0xa174463c,0x989d017a,0xb264cc38,0x75ff0000,0x9cfc0000,0xafc500a2,0xcfe94000,0x4b6803fa,0xe855c9e4,0xc30e04ad,0x73d88a44},
	{0x97290000,0x417a0000,0x533900b6,0xf6464000,0xe27901d3,0xf0c6cc02,0xc0a3d930,0x386b6f6d,0xfa520000,0x1b520000,0x7a2000a2,0xf0337000,0x33f602e1,0x91d9a202,0xff158606,0xd2a19f03},
	{0x174a0000,0x8ac00000,0x53fa00cc,0xdea20000,0x75cf01d5,0x2bf3f352,0x338b2849,0xc4585369,0xc5a00000,0x587f0000,0x78070088,0xb5eb0000,0xce86011e,0xaff7a285,0x5dba1d4f,0x430384f9},
	{0x1e630000,0x301d0000,0x294800ce,0x5e477000,0xc92403fb,0x7a41796c,0x6bb5f003,0x4e57f03c,0x4a0d0000,0xdfd10000,0xade20088,0x8a313000,0xb6180005,0xd67bc963,0x61a19fe4,0xe27a91be},
	{0x98e70000,0x0d6e0000,0x861f00cc,0xe1783000,0x0d5100ce,0x527f98b4,0x0f90aae2,0x6521462e,0x43240000,0x650c0000,0xd750008a,0x0ad44000,0x0af3022b,0x87c9435d,0x399f47ae,0x687532eb},
	{0x91ce0000,0xb7b30000,0xfcad00ce,0x619d4000,0xb1ba02e0,0x03cd128a,0x57ae72a8,0xef2ee57b,0xcc890000,0xe2a20000,0x02b5008a,0x350e7000,0x726d0330,0xfe4528bb,0x0584c505,0xc90c27ac},
	{0xd70f0000,0x502e0000,0x322b00f0,0xb36f0000,0x0e6b006e,0xfccc7c8a,0x1229444a,0x7dbc8a8a,0xba6d0000,0x4fcc0000,0x76ec0090,0xdd630000,0x9da1036d,0x0221a445,0xa8508ceb,0x5c1b4457},
	{0xde260000,0xeaf30000,0x489900f2,0x338a7000,0xb2800240,0xad7ef6b4,0x4a179c00,0xf7b329df,0x35c00000,0xc8620000,0xa3090090,0xe2b93000,0xe53f0276,0x7badcfa3,0x944b0e40,0xfd625110},
	{0x58a20000,0xd7800000,0xe7ce00f0,0x8cb53000,0x76f50175,0x8540176c,0x2e32c6e1,0xdcc59fcd,0x3ce90000,0x72bf0000,0xd9bb0092,0x625c4000,0x59d40058,0x2a1f459d,0xcc75d60a,0x776df245},
	{0x518b0000,0x6d5d0000,0x9d7c00f2,0x0c504000,0xca1e035b,0xd4f29d52,0x760c1eab,0x56ca3c98,0xb3440000,0xf5110000,0x0c5e0092,0x5d867000,0x214a0143,0x53932e7b,0xf06e54a1,0xd614e702},
	{0x68870000,0x9d730000,0x5d1100d4,0xb62a0000,0x26e803a6,0x8625f592,0xc661b9ed,0xdb4093c7,0x7a280000,0x95220000,0x173d00ac,0xb0ae0000,0xe60502d6,0xd51e2b9d,0x89f2e0e8,0xe5ff9db4},
	{0x61ae0000,0x27ae0000,0x27a300d6,0x36cf7000,0x9a030188,0xd7977fac,0x9e5f61a7,0x514f3092,0xf5850000,0x128c0000,0xc2d800ac,0x8f743000,0x9e9b03cd,0xac92407b,0xb5e96243,0x448688f3},
	{0xe72a0000,0x1add0000,0x88f400d4,0x89f03000,0x5e7602bd,0xffa99e74,0xfa7a3b46,0x7a398680,0xfcac0000,0xa8510000,0xb86a00ae,0x0f914000,0x227001e3,0xfd20ca45,0xedd7ba09,0xce892ba6},
	{0xee030000,0xa0000000,0xf24600d6,0x09154000,0xe29d0093,0xae1b144a,0xa244e30c,0xf03625d5,0x73010000,0x2fff0000,0x6d8f00ae,0x304b7000,0x5aee00f8,0x84aca1a3,0xd1cc38a2,0x6ff03ee1},
	{0xa8c20000,0x479d0000,0x3cc000e8,0xdbe70000,0x5d4c021d,0x511a7a4a,0xe7c3d5ee,0x62a44a24,0x05e50000,0x82910000,0x19d600b4,0xd8260000,0xb52200a5,0x78c82d5d,0x7c18714c,0xfae75d1a},
	{0xa1eb0000,0xfd400000,0x467200ea,0x5b027000,0xe1a70033,0x00a8f074,0xbffd0da4,0xe8abe971,0x8a480000,0x053f0000,0xcc3300b4,0xe7fc3000,0xcdbc01be,0x014446bb,0x4003f3e7,0x5b9e485d},
	{0x276f0000,0xc0330000,0xe92500e8,0xe43d3000,0x25d20306,0x289611ac,0xdbd85745,0xc3dd5f63,0x83610000,0xbfe20000,0xb68100b6,0x67194000,0x71570390,0x50f6cc85,0x183d2bad,0xd191eb08},
	{0x2e460000,0x7aee0000,0x939700ea,0x64d84000,0x99390128,0x79249b92,0x83e68f0f,0x49d2fc36,0x0ccc0000,0x384c0000,0x636400b6,0x58c37000,0x09c9028b,0x297aa763,0x2426a906,0x70e8fe4f},
	{0x58bb0000,0x924a0000,0x8a100084,0xe4cc0000,0x34b00144,0x1ab2a1a3,0xabfd5176,0x17a8a17e,0x7ccf0000,0x63eb0000,0xb8a900d4,0x27750000,0xb5c601e5,0x2615f515,0x1eff4b70,0x32ba17a2},
	{0x51920000,0x28970000,0xf0a20086,0x64297000,0x885b036a,0x4b002b9d,0xf3c3893c,0x9da7022b,0xf3620000,0xe4450000,0x6d4c00d4,0x18af3000,0xcd5800fe,0x5f999ef3,0x22e4c9db,0x93c302e5},
	{0xd7160000,0x15e40000,0x5ff50084,0xdb163000,0x4c2e005f,0x633eca45,0x97e6d3dd,0xb6d1b439,0xfa4b0000,0x5e980000,0x17fe00d6,0x984a4000,0x71b302d0,0x0e2b14cd,0x7ada1191,0x19cca1b0},
	{0xde3f0000,0xaf390000,0x25470086,0x5bf34000,0xf0c50271,0x328c407b,0xcfd80b97,0x3cde176c,0x75e60000,0xd9360000,0xc21b00d6,0xa7907000,0x092d03cb,0x77a77f2b,0x46c1933a,0xb8b5b4f7},
	{0x98fe0000,0x48a40000,0xebc100b8,0x89010000,0x4f1400ff,0xcd8d2e7b,0x8a5f3d75,0xae4c789d,0x03020000,0x74580000,0xb64200cc,0x4ffd0000,0xe6e10396,0x8bc3f3d5,0xeb15dad4,0x2da2d70c},
	{0x91d70000,0xf2790000,0x917300ba,0x09e47000,0xf3ff02d1,0x9c3fa445,0xd261e53f,0x2443dbc8,0x8caf0000,0xf3f60000,0x63a700cc,0x70273000,0x9e7f028d,0xf24f9833,0xd70e587f,0x8cdbc24b},
	{0x17530000,0xcf0a0000,0x3e2400b8,0xb6db3000,0x378a01e4,0xb401459d,0xb644bfde,0x0f356dda,0x85860000,0x492b0000,0x191500ce,0xf0c24000,0x229400a3,0xa3fd120d,0x8f308035,0x06d4611e},
	{0x1e7a0000,0x75d70000,0x449600ba,0x363e4000,0x8b6103ca,0xe5b3cfa3,0xee7a6794,0x853ace8f,0x0a2b0000,0xce850000,0xccf000ce,0xcf187000,0x5a0a01b8,0xda7179eb,0xb32b029e,0xa7ad7459},
	{0x27760000,0x85f90000,0x84fb009c,0x8c440000,0x67970337,0xb764a763,0x5e17c0d2,0x08b061d0,0xc3470000,0xaeb60000,0xd79300f0,0x22300000,0x9d45022d,0x5cfc7c0d,0xcab7b6d7,0x94460eef},
	{0x2e5f0000,0x3f240000,0xfe49009e,0x0ca17000,0xdb7c0119,0xe6d62d5d,0x06291898,0x82bfc285,0x4cea0000,0x29180000,0x027600f0,0x1dea3000,0xe5db0336,0x257017eb,0xf6ac347c,0x353f1ba8},
	{0xa8db0000,0x02570000,0x511e009c,0xb39e3000,0x1f09022c,0xcee8cc85,0x620c4279,0xa9c97497,0x45c30000,0x93c50000,0x78c400f2,0x9d0f4000,0x59300118,0x74c29dd5,0xae92ec36,0xbf30b8fd},
	{0xa1f20000,0xb88a0000,0x2bac009e,0x337b4000,0xa3e20002,0x9f5a46bb,0x3a329a33,0x23c6d7c2,0xca6e0000,0x146b0000,0xad2100f2,0xa2d57000,0x21ae0003,0x0d4ef633,0x92896e9d,0x1e49adba},
	{0xe7330000,0x5f170000,0xe52a00a0,0xe1890000,0x1c33028c,0x605b28bb,0x7fb5acd1,0xb154b833,0xbc8a0000,0xb9050000,0xd97800e8,0x4ab80000,0xce62005e,0xf12a7acd,0x3f5d2773,0x8b5ece41},
	{0xee1a0000,0xe5ca0000,0x9f9800a2,0x616c7000,0xa0d800a2,0x31e9a285,0x278b749b,0x3b5b1b66,0x33270000,0x3eab0000,0x0c9d00e8,0x75623000,0xb6fc0145,0x88a6112b,0x0346a5d8,0x2a27db06},
	{0x689e0000,0xd8b90000,0x30cf00a0,0xde533000,0x64ad0397,0x19d7435d,0x43ae2e7a,0x102dad74,0x3a0e0000,0x84760000,0x762f00ea,0xf5874000,0x0a17036b,0xd9149b15,0x5b787d92,0xa0287853},
	{0x61b70000,0x62640000,0x4a7d00a2,0x5eb64000,0xd84601b9,0x4865c963,0x1b90f630,0x9a220e21,0xb5a30000,0x03d80000,0xa3ca00ea,0xca5d7000,0x72890270,0xa098f0f3,0x6763ff39,0x01516d14},
	{0xe1d40000,0xa9de0000,0x4abe00d8,0x76520000,0x4ff001bf,0x9350f633,0xe8b80749,0x66113225,0x8a510000,0x40f50000,0xa1ed00c0,0x8f850000,0x8ff9018f,0x9eb6f074,0xc5cc6470,0x90f376ee},
	{0xe8fd0000,0x13030000,0x300c00da,0xf6b77000,0xf31b0391,0xc2e27c0d,0xb086df03,0xec1e9170,0x05fc0000,0xc75b0000,0x740800c0,0xb05f3000,0xf7670094,0xe73a9b92,0xf9d7e6db,0x318a63a9},
	{0x6e790000,0x2e700000,0x9f5b00d8,0x49883000,0x376e00a4,0xeadc9dd5,0xd4a385e2,0xc7682762,0x0cd50000,0x7d860000,0x0eba00c2,0x30ba4000,0x4b8c02ba,0xb68811ac,0xa1e93e91,0xbb85c0fc},
	{0x67500000,0x94ad0000,0xe5e900da,0xc96d4000,0x8b85028a,0xbb6e17eb,0x8c9d5da8,0x4d678437,0x83780000,0xfa280000,0xdb5f00c2,0x0f607000,0x331203a1,0xcf047a4a,0x9df2bc3a,0x1afcd5bb},
	{0x21910000,0x73300000,0x2b6f00e4,0x1b9f0000,0x34540004,0x446f79eb,0xc91a6b4a,0xdff5ebc6,0xf59c0000,0x57460000,0xaf0600d8,0xe70d0000,0xdcde03fc,0x3360f6b4,0x3026f5d4,0x8febb640},
	{0x28b80000,0xc9ed0000,0x51dd00e6,0x9b7a7000,0x88bf022a,0x15ddf3d5,0x9124b300,0x55fa4893,0x7a310000,0xd0e80000,0x7ae300d8,0xd8d73000,0xa44002e7,0x4aec9d52,0x0c3d777f,0x2e92a307},
	{0xae3c0000,0xf49e0000,0xfe8a00e4,0x24453000,0x4cca011f,0x3de3120d,0xf501e9e1,0x7e8cfe81,0x73180000,0x6a350000,0x005100da,0x58324000,0x18ab00c9,0x1b5e176c,0x5403af35,0xa49d0052},
	{0xa7150000,0x4e430000,0x843800e6,0xa4a04000,0xf0210331,0x6c519833,0xad3f31ab,0xf4835dd4,0xfcb50000,0xed9b0000,0xd5b400da,0x67e87000,0x603501d2,0x62d27c8a,0x68182d9e,0x05e41515},
	{0x9e190000,0xbe6d0000,0x445500c0,0x1eda0000,0x1cd703cc,0x3e86f0f3,0x1d5296ed,0x7909f28b,0x35d90000,0x8da80000,0xced700e4,0x8ac00000,0xa77a0247,0xe45f796c,0x118499d7,0x360f6fa3},
	{0x97300000,0x04b00000,0x3ee700c2,0x9e3f7000,0xa03c01e2,0x6f347acd,0x456c4ea7,0xf30651de,0xba740000,0x0a060000,0x1b3200e4,0xb51a3000,0xdfe4035c,0x9dd3128a,0x2d9f1b7c,0x97767ae4},
	{0x11b40000,0x39c30000,0x91b000c0,0x21003000,0x644902d7,0x470a9b15,0x21491446,0xd870e7cc,0xb35d0000,0xb0db0000,0x618000e6,0x35ff4000,0x630f0172,0xcc6198b4,0x75a1c336,0x1d79d9b1},
	{0x189d0000,0x831e0000,0xeb0200c2,0xa1e54000,0xd8a200f9,0x16b8112b,0x7977cc0c,0x527f4499,0x3cf00000,0x37750000,0xb46500e6,0x0a257000,0x1b910069,0xb5edf352,0x49ba419d,0xbc00ccf6},
	{0x5e5c0000,0x64830000,0x258400fc,0x73170000,0x67730277,0xe9b97f2b,0x3cf0faee,0xc0ed2b68,0x4a140000,0x9a1b0000,0xc03c00fc,0xe2480000,0xf45d0034,0x49897fac,0xe46e0873,0x2917af0d},
	{0x57750000,0xde5e0000,0x5f3600fe,0xf3f27000,0xdb980059,0xb80bf515,0x64ce22a4,0x4ae2883d,0xc5b90000,0x1db50000,0x15d900fc,0xdd923000,0x8cc3012f,0x3005144a,0xd8758ad8,0x886eba4a},
	{0xd1f10000,0xe32d0000,0xf06100fc,0x4ccd3000,0x1fed036c,0x903514cd,0x00eb7845,0x61943e2f,0xcc900000,0xa7680000,0x6f6b00fe,0x5d774000,0x30280301,0x61b79e74,0x804b5292,0x0261191f},
	{0xd8d80000,0x59f00000,0x8ad300fe,0xcc284000,0xa3060142,0xc1879ef3,0x58d5a00f,0xeb9b9d7a,0x433d0000,0x20c60000,0xba8e00fe,0x62ad7000,0x48b6021a,0x183bf592,0xbc50d039,0xa3180c58}
    },{
	{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x67c00000,0x5dae0000,0x7bc30000,0x1e8705c0,0x3a110218,0x74fd6417,0x45fc9d62,0x63f3bb5d,0x03190000,0x23f30000,0xd5b80000,0xb5290140,0xde8c00a2,0x446a98b4,0xd2fc952e,0x91a2ceb5},
	{0x03190000,0x23f30000,0xd5b80000,0xb5290140,0xde8c00a2,0x446a98b4,0xd2fc952e,0x91a2ceb5,0x64d90000,0x7e5d0000,0xae7b0000,0xabae0480,0xe49d02ba,0x3097fca3,0x9700084c,0xf25175e8},
	{0x64d90000,0x7e5d0000,0xae7b0000,0xabae0480,0xe49d02ba,0x3097fca3,0x9700084c,0xf25175e8,0x67c00000,0x5dae0000,0x7bc30000,0x1e8705c0,0x3a110218,0x74fd6417,0x45fc9d62,0x63f3bb5d},
	{0xff600000,0x37540000,0x309a0000,0x0ce909c0,0xe46203ae,0xcd78b9e8,0x83d8a6c5,0x55e75226,0x3ff20000,0x4b9e0000,0x88f10000,0x62b400c0,0xa31102db,0x885b494a,0xa43db62d,0x217c7ae6},
	{0x98a00000,0x6afa0000,0x4b590000,0x126e0c00,0xde7301b6,0xb985ddff,0xc6243ba7,0x3614e97b,0x3ceb0000,0x686d0000,0x5d490000,0xd79d0180,0x7d9d0279,0xcc31d1fe,0x76c12303,0xb0deb453},
	{0xfc790000,0x14a70000,0xe5220000,0xb9c00880,0x3aee030c,0x8912215c,0x512433eb,0xc4459c93,0x5b2b0000,0x35c30000,0x268a0000,0xc91a0440,0x478c0061,0xb8ccb5e9,0x333dbe61,0xd32d0f0e},
	{0x9bb90000,0x49090000,0x9ee10000,0xa7470d40,0x00ff0114,0xfdef454b,0x14d8ae89,0xa7b627ce,0x58320000,0x16300000,0xf3320000,0x7c330500,0x990000c3,0xfca62d5d,0xe1c12b4f,0x428fc1bb},
	{0x3ff20000,0x4b9e0000,0x88f10000,0x62b400c0,0xa31102db,0x885b494a,0xa43db62d,0x217c7ae6,0xc0920000,0x7cca0000,0xb86b0000,0x6e5d0900,0x47730175,0x4523f0a2,0x27e510e8,0x749b28c0},
	{0x58320000,0x16300000,0xf3320000,0x7c330500,0x990000c3,0xfca62d5d,0xe1c12b4f,0x428fc1bb,0xc38b0000,0x5f390000,0x6dd30000,0xdb740840,0x99ff01d7,0x01496816,0xf51985c6,0xe539e675},
	{0x3ceb0000,0x686d0000,0x5d490000,0xd79d0180,0x7d9d0279,0xcc31d1fe,0x76c12303,0xb0deb453,0xa44b0000,0x02970000,0x16100000,0xc5f30d80,0xa3ee03cf,0x75b40c01,0xb0e518a4,0x86ca5d28},
	{0x5b2b0000,0x35c30000,0x268a0000,0xc91a0440,0x478c0061,0xb8ccb5e9,0x333dbe61,0xd32d0f0e,0xa7520000,0x21640000,0xc3a80000,0x70da0cc0,0x7d62036d,0x31de94b5,0x62198d8a,0x1768939d},
	{0xc0920000,0x7cca0000,0xb86b0000,0x6e5d0900,0x47730175,0x4523f0a2,0x27e510e8,0x749b28c0,0xff600000,0x37540000,0x309a0000,0x0ce909c0,0xe46203ae,0xcd78b9e8,0x83d8a6c5,0x55e75226},
	{0xa7520000,0x21640000,0xc3a80000,0x70da0cc0,0x7d62036d,0x31de94b5,0x62198d8a,0x1768939d,0xfc790000,0x14a70000,0xe5220000,0xb9c00880,0x3aee030c,0x8912215c,0x512433eb,0xc4459c93},
	{0xc38b0000,0x5f390000,0x6dd30000,0xdb740840,0x99ff01d7,0x01496816,0xf51985c6,0xe539e675,0x9bb90000,0x49090000,0x9ee10000,0xa7470d40,0x00ff0114,0xfdef454b,0x14d8ae89,0xa7b627ce},
	{0xa44b0000,0x02970000,0x16100000,0xc5f30d80,0xa3ee03cf,0x75b40c01,0xb0e518a4,0x86ca5d28,0x98a00000,0x6afa0000,0x4b590000,0x126e0c00,0xde7301b6,0xb985ddff,0xc6243ba7,0x3614e97b},
	{0xe2910000,0xe2bf0000,0xacad0000,0x9290f000,0xc48a028c,0x3dec240e,0x1844bf24,0xc7837b33,0x51600000,0xaaff0000,0x86b30000,0xd79d6000,0xda2b03ae,0xe4a15891,0x83cee918,0x2d64d5de},
	{0x85510000,0xbf110000,0xd76e0000,0x8c17f5c0,0xfe9b0094,0x49114019,0x5db82246,0xa470c06e,0x52790000,0x890c0000,0x530b0000,0x62b46140,0x04a7030c,0xa0cbc025,0x51327c36,0xbcc61b6b},
	{0xe1880000,0xc14c0000,0x79150000,0x27b9f140,0x1a06022e,0x7986bcba,0xcab82a0a,0x5621b586,0x35b90000,0xd4a20000,0x28c80000,0x7c336480,0x3eb60114,0xd436a432,0x14cee154,0xdf35a036},
	{0x86480000,0x9ce20000,0x02d60000,0x393ef480,0x20170036,0x0d7bd8ad,0x8f44b768,0x35d20edb,0x36a00000,0xf7510000,0xfd700000,0xc91a65c0,0xe03a01b6,0x905c3c86,0xc632747a,0x4e976e83},
	{0x1df10000,0xd5eb0000,0x9c370000,0x9e79f9c0,0x20e80122,0xf0949de6,0x9b9c19e1,0x92642915,0x6e920000,0xe1610000,0x0e420000,0xb52960c0,0x793a0175,0x6cfa11db,0x27f35f35,0x0c18af38},
	{0x7a310000,0x88450000,0xe7f40000,0x80fefc00,0x1af9033a,0x8469f9f1,0xde608483,0xf1979248,0x6d8b0000,0xc2920000,0xdbfa0000,0x00006180,0xa7b601d7,0x2890896f,0xf50fca1b,0x9dba618d},
	{0x1ee80000,0xf6180000,0x498f0000,0x2b50f880,0xfe640180,0xb4fe0552,0x49608ccf,0x03c6e7a0,0x0a4b0000,0x9f3c0000,0xa0390000,0x1e876440,0x9da703cf,0x5c6ded78,0xb0f35779,0xfe49dad0},
	{0x79280000,0xabb60000,0x324c0000,0x35d7fd40,0xc4750398,0xc0036145,0x0c9c11ad,0x60355cfd,0x09520000,0xbccf0000,0x75810000,0xabae6500,0x432b036d,0x180775cc,0x620fc257,0x6feb1465},
	{0xdd630000,0xa9210000,0x245c0000,0xf024f0c0,0x679b0057,0xb5b76d44,0xbc790909,0xe6ff01d5,0x91f20000,0xd6350000,0x3ed80000,0xb9c06900,0x9d5802db,0xa182a833,0xa42bf9f0,0x59fffd1e},
	{0xbaa30000,0xf48f0000,0x5f9f0000,0xeea3f500,0x5d8a024f,0xc14a0953,0xf985946b,0x850cba88,0x92eb0000,0xf5c60000,0xeb600000,0x0ce96840,0x43d40279,0xe5e83087,0x76d76cde,0xc85d33ab},
	{0xde7a0000,0x8ad20000,0xf1e40000,0x450df180,0xb91700f5,0xf1ddf5f0,0x6e859c27,0x775dcf60,0xf52b0000,0xa8680000,0x90a30000,0x126e6d80,0x79c50061,0x91155490,0x332bf1bc,0xabae88f6},
	{0xb9ba0000,0xd77c0000,0x8a270000,0x5b8af440,0x830602ed,0x852091e7,0x2b790145,0x14ae743d,0xf6320000,0x8b9b0000,0x451b0000,0xa7476cc0,0xa74900c3,0xd57fcc24,0xe1d76492,0x3a0c4643},
	{0x22030000,0x9e750000,0x14c60000,0xfccdf900,0x83f903f9,0x78cfd4ac,0x3fa1afcc,0xb31853f3,0xae000000,0x9dab0000,0xb6290000,0xdb7469c0,0x3e490000,0x29d9e179,0x00164fdd,0x788387f8},
	{0x45c30000,0xc3db0000,0x6f050000,0xe24afcc0,0xb9e801e1,0x0c32b0bb,0x7a5d32ae,0xd0ebe8ae,0xad190000,0xbe580000,0x63910000,0x6e5d6880,0xe0c500a2,0x6db379cd,0xd2eadaf3,0xe921494d},
	{0x211a0000,0xbd860000,0xc17e0000,0x49e4f840,0x5d75035b,0x3ca54c18,0xed5d3ae2,0x22ba9d46,0xcad90000,0xe3f60000,0x18520000,0x70da6d40,0xdad402ba,0x194e1dda,0x97164791,0x8ad2f210},
	{0x46da0000,0xe0280000,0xbabd0000,0x5763fd80,0x67640143,0x4858280f,0xa8a1a780,0x4149261b,0xc9c00000,0xc0050000,0xcdea0000,0xc5f36c00,0x04580218,0x5d24856e,0x45ead2bf,0x1b703ca5},
	{0x51600000,0xaaff0000,0x86b30000,0xd79d6000,0xda2b03ae,0xe4a15891,0x83cee918,0x2d64d5de,0xb3f10000,0x48400000,0x2a1e0000,0x450d9000,0x1ea10122,0xd94d7c9f,0x9b8a563c,0xeae7aeed},
	{0x36a00000,0xf7510000,0xfd700000,0xc91a65c0,0xe03a01b6,0x905c3c86,0xc632747a,0x4e976e83,0xb0e80000,0x6bb30000,0xffa60000,0xf0249140,0xc02d0180,0x9d27e42b,0x4976c312,0x7b456058},
	{0x52790000,0x890c0000,0x530b0000,0x62b46140,0x04a7030c,0xa0cbc025,0x51327c36,0xbcc61b6b,0xd7280000,0x361d0000,0x84650000,0xeea39480,0xfa3c0398,0xe9da803c,0x0c8a5e70,0x18b6db05},
	{0x35b90000,0xd4a20000,0x28c80000,0x7c336480,0x3eb60114,0xd436a432,0x14cee154,0xdf35a036,0xd4310000,0x15ee0000,0x51dd0000,0x5b8a95c0,0x24b0033a,0xadb01888,0xde76cb5e,0x891415b0},
	{0xae000000,0x9dab0000,0xb6290000,0xdb7469c0,0x3e490000,0x29d9e179,0x00164fdd,0x788387f8,0x8c030000,0x03de0000,0xa2ef0000,0x27b990c0,0xbdb003f9,0x511635d5,0x3fb7e011,0xcb9bd40b},
	{0xc9c00000,0xc0050000,0xcdea0000,0xc5f36c00,0x04580218,0x5d24856e,0x45ead2bf,0x1b703ca5,0x8f1a0000,0x202d0000,0x77570000,0x92909180,0x633c035b,0x157cad61,0xed4b753f,0x5a391abe},
	{0xad190000,0xbe580000,0x63910000,0x6e5d6880,0xe0c500a2,0x6db379cd,0xd2eadaf3,0xe921494d,0xe8da0000,0x7d830000,0x0c940000,0x8c179440,0x592d0143,0x6181c976,0xa8b7e85d,0x39caa1e3},
	{0xcad90000,0xe3f60000,0x18520000,0x70da6d40,0xdad402ba,0x194e1dda,0x97164791,0x8ad2f210,0xebc30000,0x5e700000,0xd92c0000,0x393e9500,0x87a101e1,0x25eb51c2,0x7a4b7d73,0xa8686f56},
	{0x6e920000,0xe1610000,0x0e420000,0xb52960c0,0x793a0175,0x6cfa11db,0x27f35f35,0x0c18af38,0x73630000,0x348a0000,0x92750000,0x2b509900,0x59d20057,0x9c6e8c3d,0xbc6f46d4,0x9e7c862d},
	{0x09520000,0xbccf0000,0x75810000,0xabae6500,0x432b036d,0x180775cc,0x620fc257,0x6feb1465,0x707a0000,0x17790000,0x47cd0000,0x9e799840,0x875e00f5,0xd8041489,0x6e93d3fa,0x0fde4898},
	{0x6d8b0000,0xc2920000,0xdbfa0000,0x00006180,0xa7b601d7,0x2890896f,0xf50fca1b,0x9dba618d,0x17ba0000,0x4ad70000,0x3c0e0000,0x80fe9d80,0xbd4f02ed,0xacf9709e,0x2b6f4e98,0x6c2df3c5},
	{0x0a4b0000,0x9f3c0000,0xa0390000,0x1e876440,0x9da703cf,0x5c6ded78,0xb0f35779,0xfe49dad0,0x14a30000,0x69240000,0xe9b60000,0x35d79cc0,0x63c3024f,0xe893e82a,0xf993dbb6,0xfd8f3d70},
	{0x91f20000,0xd6350000,0x3ed80000,0xb9c06900,0x9d5802db,0xa182a833,0xa42bf9f0,0x59fffd1e,0x4c910000,0x7f140000,0x1a840000,0x49e499c0,0xfac3028c,0x1435c577,0x1852f0f9,0xbf00fccb},
	{0xf6320000,0x8b9b0000,0x451b0000,0xa7476cc0,0xa74900c3,0xd57fcc24,0xe1d76492,0x3a0c4643,0x4f880000,0x5ce70000,0xcf3c0000,0xfccd9880,0x244f022e,0x505f5dc3,0xcaae65d7,0x2ea2327e},
	{0x92eb0000,0xf5c60000,0xeb600000,0x0ce96840,0x43d40279,0xe5e83087,0x76d76cde,0xc85d33ab,0x28480000,0x01490000,0xb4ff0000,0xe24a9d40,0x1e5e0036,0x24a239d4,0x8f52f8b5,0x4d518923},
	{0xf52b0000,0xa8680000,0x90a30000,0x126e6d80,0x79c50061,0x91155490,0x332bf1bc,0xabae88f6,0x2b510000,0x22ba0000,0x61470000,0x57639c00,0xc0d20094,0x60c8a160,0x5dae6d9b,0xdcf34796},
	{0xb3f10000,0x48400000,0x2a1e0000,0x450d9000,0x1ea10122,0xd94d7c9f,0x9b8a563c,0xeae7aeed,0xe2910000,0xe2bf0000,0xacad0000,0x9290f000,0xc48a028c,0x3dec240e,0x1844bf24,0xc7837b33},
	{0xd4310000,0x15ee0000,0x51dd0000,0x5b8a95c0,0x24b0033a,0xadb01888,0xde76cb5e,0x891415b0,0xe1880000,0xc14c0000,0x79150000,0x27b9f140,0x1a06022e,0x7986bcba,0xcab82a0a,0x5621b586},
	{0xb0e80000,0x6bb30000,0xffa60000,0xf0249140,0xc02d0180,0x9d27e42b,0x4976c312,0x7b456058,0x86480000,0x9ce20000,0x02d60000,0x393ef480,0x20170036,0x0d7bd8ad,0x8f44b768,0x35d20edb},
	{0xd7280000,0x361d0000,0x84650000,0xeea39480,0xfa3c0398,0xe9da803c,0x0c8a5e70,0x18b6db05,0x85510000,0xbf110000,0xd76e0000,0x8c17f5c0,0xfe9b0094,0x49114019,0x5db82246,0xa470c06e},
	{0x4c910000,0x7f140000,0x1a840000,0x49e499c0,0xfac3028c,0x1435c577,0x1852f0f9,0xbf00fccb,0xdd630000,0xa9210000,0x245c0000,0xf024f0c0,0x679b0057,0xb5b76d44,0xbc790909,0xe6ff01d5},
	{0x2b510000,0x22ba0000,0x61470000,0x57639c00,0xc0d20094,0x60c8a160,0x5dae6d9b,0xdcf34796,0xde7a0000,0x8ad20000,0xf1e40000,0x450df180,0xb91700f5,0xf1ddf5f0,0x6e859c27,0x775dcf60},
	{0x4f880000,0x5ce70000,0xcf3c0000,0xfccd9880,0x244f022e,0x505f5dc3,0xcaae65d7,0x2ea2327e,0xb9ba0000,0xd77c0000,0x8a270000,0x5b8af440,0x830602ed,0x852091e7,0x2b790145,0x14ae743d},
	{0x28480000,0x01490000,0xb4ff0000,0xe24a9d40,0x1e5e0036,0x24a239d4,0x8f52f8b5,0x4d518923,0xbaa30000,0xf48f0000,0x5f9f0000,0xeea3f500,0x5d8a024f,0xc14a0953,0xf985946b,0x850cba88},
	{0x8c030000,0x03de0000,0xa2ef0000,0x27b990c0,0xbdb003f9,0x511635d5,0x3fb7e011,0xcb9bd40b,0x22030000,0x9e750000,0x14c60000,0xfccdf900,0x83f903f9,0x78cfd4ac,0x3fa1afcc,0xb31853f3},
	{0xebc30000,0x5e700000,0xd92c0000,0x393e9500,0x87a101e1,0x25eb51c2,0x7a4b7d73,0xa8686f56,0x211a0000,0xbd860000,0xc17e0000,0x49e4f840,0x5d75035b,0x3ca54c18,0xed5d3ae2,0x22ba9d46},
	{0x8f1a0000,0x202d0000,0x77570000,0x92909180,0x633c035b,0x157cad61,0xed4b753f,0x5a391abe,0x46da0000,0xe0280000,0xbabd0000,0x5763fd80,0x67640143,0x4858280f,0xa8a1a780,0x4149261b},
	{0xe8da0000,0x7d830000,0x0c940000,0x8c179440,0x592d0143,0x6181c976,0xa8b7e85d,0x39caa1e3,0x45c30000,0xc3db0000,0x6f050000,0xe24afcc0,0xb9e801e1,0x0c32b0bb,0x7a5d32ae,0xd0ebe8ae},
	{0x73630000,0x348a0000,0x92750000,0x2b509900,0x59d20057,0x9c6e8c3d,0xbc6f46d4,0x9e7c862d,0x1df10000,0xd5eb0000,0x9c370000,0x9e79f9c0,0x20e80122,0xf0949de6,0x9b9c19e1,0x92642915},
	{0x14a30000,0x69240000,0xe9b60000,0x35d79cc0,0x63c3024f,0xe893e82a,0xf993dbb6,0xfd8f3d70,0x1ee80000,0xf6180000,0x498f0000,0x2b50f880,0xfe640180,0xb4fe0552,0x49608ccf,0x03c6e7a0},
	{0x707a0000,0x17790000,0x47cd0000,0x9e799840,0x875e00f5,0xd8041489,0x6e93d3fa,0x0fde4898,0x79280000,0xabb60000,0x324c0000,0x35d7fd40,0xc4750398,0xc0036145,0x0c9c11ad,0x60355cfd},
	{0x17ba0000,0x4ad70000,0x3c0e0000,0x80fe9d80,0xbd4f02ed,0xacf9709e,0x2b6f4e98,0x6c2df3c5,0x7a310000,0x88450000,0xe7f40000,0x80fefc00,0x1af9033a,0x8469f9f1,0xde608483,0xf1979248},
	{0xbce70000,0x5b760000,0x5ed70001,0x64017000,0x176d0118,0xbb5679fe,0x306eec39,0x833f31eb,0xdb250000,0x45cf0000,0xe97b0000,0xa7ff5000,0x345700c2,0xcd4f8900,0x069cce49,0x588088ac},
	{0xdb270000,0x06d80000,0x25140001,0x7a8675c0,0x2d7c0300,0xcfab1de9,0x7592715b,0xe0cc8ab6,0xd83c0000,0x663c0000,0x3cc30000,0x12d65140,0xeadb0060,0x892511b4,0xd4605b67,0xc9224619},
	{0xbffe0000,0x78850000,0x8b6f0001,0xd1287140,0xc9e101ba,0xff3ce14a,0xe2927917,0x129dff5e,0xbffc0000,0x3b920000,0x47000000,0x0c515480,0xd0ca0278,0xfdd875a3,0x919cc605,0xaad1fd44},
	{0xd83e0000,0x252b0000,0xf0ac0001,0xcfaf7480,0xf3f003a2,0x8bc1855d,0xa76ee475,0x716e4403,0xbce50000,0x18610000,0x92b80000,0xb97855c0,0x0e4602da,0xb9b2ed17,0x4360532b,0x3b7333f1},
	{0x43870000,0x6c220000,0x6e4d0001,0x68e879c0,0xf30f02b6,0x762ec016,0xb3b64afc,0xd6d863cd,0xe4d70000,0x0e510000,0x618a0000,0xc54b50c0,0x97460219,0x4514c04a,0xa2a17864,0x79fcf24a},
	{0x24470000,0x318c0000,0x158e0001,0x766f7c00,0xc91e00ae,0x02d3a401,0xf64ad79e,0xb52bd890,0xe7ce0000,0x2da20000,0xb4320000,0x70625180,0x49ca02bb,0x017e58fe,0x705ded4a,0xe85e3cff},
	{0x409e0000,0x4fd10000,0xbbf50001,0xddc17880,0x2d830214,0x324458a2,0x614adfd2,0x477aad78,0x800e0000,0x700c0000,0xcff10000,0x6ee55440,0x73db00a3,0x75833ce9,0x35a17028,0x8bad87a2},
	{0x275e0000,0x127f0000,0xc0360001,0xc3467d40,0x1792000c,0x46b93cb5,0x24b642b0,0x24891625,0x83170000,0x53ff0000,0x1a490000,0xdbcc5500,0xad570001,0x31e9a45d,0xe75de506,0x1a0f4917},
	{0x83150000,0x10e80000,0xd6260001,0x06b570c0,0xb47c03c3,0x330d30b4,0x94535a14,0xa2434b0d,0x1bb70000,0x39050000,0x51100000,0xc9a25900,0x732401b7,0x886c79a2,0x2179dea1,0x2c1ba06c},
	{0xe4d50000,0x4d460000,0xade50001,0x18327500,0x8e6d01db,0x47f054a3,0xd1afc776,0xc1b0f050,0x18ae0000,0x1af60000,0x84a80000,0x7c8b5840,0xada80115,0xcc06e116,0xf3854b8f,0xbdb96ed9},
	{0x800c0000,0x331b0000,0x039e0001,0xb39c7180,0x6af00361,0x7767a800,0x46afcf3a,0x33e185b8,0x7f6e0000,0x47580000,0xff6b0000,0x620c5d80,0x97b9030d,0xb8fb8501,0xb679d6ed,0xde4ad584},
	{0xe7cc0000,0x6eb50000,0x785d0001,0xad1b7440,0x50e10179,0x039acc17,0x03535258,0x50123ee5,0x7c770000,0x64ab0000,0x2ad30000,0xd7255cc0,0x493503af,0xfc911db5,0x648543c3,0x4fe81b31},
	{0x7c750000,0x27bc0000,0xe6bc0001,0x0a5c7900,0x501e006d,0xfe75895c,0x178bfcd1,0xf7a4192b,0x24450000,0x729b0000,0xd9e10000,0xab1659c0,0xd035036c,0x003730e8,0x8544688c,0x0d67da8a},
	{0x1bb50000,0x7a120000,0x9d7f0001,0x14db7cc0,0x6a0f0275,0x8a88ed4b,0x527761b3,0x9457a276,0x275c0000,0x51680000,0x0c590000,0x1e3f5880,0x0eb903ce,0x445da85c,0x57b8fda2,0x9cc5143f},
	{0x7f6c0000,0x044f0000,0x33040001,0xbf757840,0x8e9200cf,0xba1f11e8,0xc57769ff,0x6606d79e,0x409c0000,0x0cc60000,0x779a0000,0x00b85d40,0x34a801d6,0x30a0cc4b,0x124460c0,0xff36af62},
	{0x18ac0000,0x59e10000,0x48c70001,0xa1f27d80,0xb48302d7,0xcee275ff,0x808bf49d,0x05f56cc3,0x43850000,0x2f350000,0xa2220000,0xb5915c00,0xea240174,0x74ca54ff,0xc0b8f5ee,0x6e9461d7},
	{0x5e760000,0xb9c90000,0xf27a0001,0xf6918000,0xd3e70394,0x86ba5df0,0x282a531d,0x44bc4ad8,0x8a450000,0xef300000,0x6fc80000,0x70623000,0xee7c036c,0x29eed191,0x85522751,0x75e45d72},
	{0x39b60000,0xe4670000,0x89b90001,0xe81685c0,0xe9f6018c,0xf24739e7,0x6dd6ce7f,0x274ff185,0x895c0000,0xccc30000,0xba700000,0xc54b3140,0x30f003ce,0x6d844925,0x57aeb27f,0xe44693c7},
	{0x5d6f0000,0x9a3a0000,0x27c20001,0x43b88140,0x0d6b0336,0xc2d0c544,0xfad6c633,0xd51e846d,0xee9c0000,0x916d0000,0xc1b30000,0xdbcc3480,0x0ae101d6,0x19792d32,0x12522f1d,0x87b5289a},
	{0x3aaf0000,0xc7940000,0x5c010001,0x5d3f8480,0x377a012e,0xb62da153,0xbf2a5b51,0xb6ed3f30,0xed850000,0xb29e0000,0x140b0000,0x6ee535c0,0xd46d0174,0x5d13b586,0xc0aeba33,0x1617e62f},
	{0xa1160000,0x8e9d0000,0xc2e00001,0xfa7889c0,0x3785003a,0x4bc2e418,0xabf2f5d8,0x115b18fe,0xb5b70000,0xa4ae0000,0xe7390000,0x12d630c0,0x4d6d01b7,0xa1b598db,0x216f917c,0x54982794},
	{0xc6d60000,0xd3330000,0xb9230001,0xe4ff8c00,0x0d940222,0x3f3f800f,0xee0e68ba,0x72a8a3a3,0xb6ae0000,0x875d0000,0x32810000,0xa7ff3180,0x93e10115,0xe5df006f,0xf3930452,0xc53ae921},
	{0xa20f0000,0xad6e0000,0x17580001,0x4f518880,0xe9090098,0x0fa87cac,0x790e60f6,0x80f9d64b,0xd16e0000,0xdaf30000,0x49420000,0xb9783440,0xa9f0030d,0x91226478,0xb66f9930,0xa6c9527c},
	{0xc5cf0000,0xf0c00000,0x6c9b0001,0x51d68d40,0xd3180280,0x7b5518bb,0x3cf2fd94,0xe30a6d16,0xd2770000,0xf9000000,0x9cfa0000,0x0c513500,0x777c03af,0xd548fccc,0x64930c1e,0x376b9cc9},
	{0x61840000,0xf2570000,0x7a8b0001,0x942580c0,0x70f6014f,0x0ee114ba,0x8c17e530,0x65c0303e,0x4ad70000,0x93fa0000,0xd7a30000,0x1e3f3900,0xa90f0219,0x6ccd2133,0xa2b737b9,0x017f75b2},
	{0x06440000,0xaff90000,0x01480001,0x8aa28500,0x4ae70357,0x7a1c70ad,0xc9eb7852,0x06338b63,0x49ce0000,0xb0090000,0x021b0000,0xab163840,0x778302bb,0x28a7b987,0x704ba297,0x90ddbb07},
	{0x629d0000,0xd1a40000,0xaf330001,0x210c8180,0xae7a01ed,0x4a8b8c0e,0x5eeb701e,0xf462fe8b,0x2e0e0000,0xeda70000,0x79d80000,0xb5913d80,0x4d9200a3,0x5c5add90,0x35b73ff5,0xf32e005a},
	{0x055d0000,0x8c0a0000,0xd4f00001,0x3f8b8440,0x946b03f5,0x3e76e819,0x1b17ed7c,0x979145d6,0x2d170000,0xce540000,0xac600000,0x00b83cc0,0x931e0001,0x18304524,0xe74baadb,0x628cceef},
	{0x9ee40000,0xc5030000,0x4a110001,0x98cc8900,0x949402e1,0xc399ad52,0x0fcf43f5,0x30276218,0x75250000,0xd8640000,0x5f520000,0x7c8b39c0,0x0a1e00c2,0xe4966879,0x068a8194,0x20030f54},
	{0xf9240000,0x98ad0000,0x31d20001,0x864b8cc0,0xae8500f9,0xb764c945,0x4a33de97,0x53d4d945,0x763c0000,0xfb970000,0x8aea0000,0xc9a23880,0xd4920060,0xa0fcf0cd,0xd47614ba,0xb1a1c1e1},
	{0x9dfd0000,0xe6f00000,0x9fa90001,0x2de58840,0x4a180243,0x87f335e6,0xdd33d6db,0xa185acad,0x11fc0000,0xa6390000,0xf1290000,0xd7253d40,0xee830278,0xd40194da,0x918a89d8,0xd2527abc},
	{0xfa3d0000,0xbb5e0000,0xe46a0001,0x33628d80,0x7009005b,0xf30e51f1,0x98cf4bb9,0xc27617f0,0x12e50000,0x85ca0000,0x24910000,0x620c3c00,0x300f02da,0x906b0c6e,0x43761cf6,0x43f0b409},
	{0xed870000,0xf1890000,0xd8640001,0xb39c1000,0xcd4602b6,0x5ff7216f,0xb3a00521,0xae5be435,0x68d40000,0x0d8f0000,0xc3650000,0xe2f2c000,0x2af601e0,0x1402f59f,0x9d169875,0xb2672641},
	{0x8a470000,0xac270000,0xa3a70001,0xad1b15c0,0xf75700ae,0x2b0a4578,0xf65c9843,0xcda85f68,0x6bcd0000,0x2e7c0000,0x16dd0000,0x57dbc140,0xf47a0142,0x50686d2b,0x4fea0d5b,0x23c5e8f4},
	{0xee9e0000,0xd27a0000,0x0ddc0001,0x06b51140,0x13ca0214,0x1b9db9db,0x615c900f,0x3ff92a80,0x0c0d0000,0x73d20000,0x6d1e0000,0x495cc480,0xce6b035a,0x2495093c,0x0a169039,0x403653a9},
	{0x895e0000,0x8fd40000,0x761f0001,0x18321480,0x29db000c,0x6f60ddcc,0x24a00d6d,0x5c0a91dd,0x0f140000,0x50210000,0xb8a60000,0xfc75c5c0,0x10e703f8,0x60ff9188,0xd8ea0517,0xd1949d1c},
	{0x12e70000,0xc6dd0000,0xe8fe0001,0xbf7519c0,0x29240118,0x928f9887,0x3078a3e4,0xfbbcb613,0x57260000,0x46110000,0x4b940000,0x8046c0c0,0x89e7033b,0x9c59bcd5,0x392b2e58,0x931b5ca7},
	{0x75270000,0x9b730000,0x933d0001,0xa1f21c00,0x13350300,0xe672fc90,0x75843e86,0x984f0d4e,0x543f0000,0x65e20000,0x9e2c0000,0x356fc180,0x576b0399,0xd8332461,0xebd7bb76,0x02b99212},
	{0x11fe0000,0xe52e0000,0x3d460001,0x0a5c1880,0xf7a801ba,0xd6e50033,0xe28436ca,0x6a1e78a6,0x33ff0000,0x384c0000,0xe5ef0000,0x2be8c440,0x6d7a0181,0xacce4076,0xae2b2614,0x614a294f},
	{0x763e0000,0xb8800000,0x46850001,0x14db1d40,0xcdb903a2,0xa2186424,0xa778aba8,0x09edc3fb,0x30e60000,0x1bbf0000,0x30570000,0x9ec1c500,0xb3f60123,0xe8a4d8c2,0x7cd7b33a,0xf0e8e7fa},
	{0xd2750000,0xba170000,0x50950001,0xd12810c0,0x6e57006d,0xd7ac6825,0x179db30c,0x8f279ed3,0xa8460000,0x71450000,0x7b0e0000,0x8cafc900,0x6d850095,0x5121053d,0xbaf3889d,0xc6fc0e81},
	{0xb5b50000,0xe7b90000,0x2b560001,0xcfaf1500,0x54460275,0xa3510c32,0x52612e6e,0xecd4258e,0xab5f0000,0x52b60000,0xaeb60000,0x3986c840,0xb3090037,0x154b9d89,0x680f1db3,0x575ec034},
	{0xd16c0000,0x99e40000,0x852d0001,0x64011180,0xb0db00cf,0x93c6f091,0xc5612622,0x1e855066,0xcc9f0000,0x0f180000,0xd5750000,0x2701cd80,0x8918022f,0x61b6f99e,0x2df380d1,0x34ad7b69},
	{0xb6ac0000,0xc44a0000,0xfeee0001,0x7a861440,0x8aca02d7,0xe73b9486,0x809dbb40,0x7d76eb3b,0xcf860000,0x2ceb0000,0x00cd0000,0x9228ccc0,0x5794028d,0x25dc612a,0xff0f15ff,0xa50fb5dc},
	{0x2d150000,0x8d430000,0x600f0001,0xddc11900,0x8a3503c3,0x1ad4d1cd,0x944515c9,0xdac0ccf5,0x97b40000,0x3adb0000,0xf3ff0000,0xee1bc9c0,0xce94024e,0xd97a4c77,0x1ece3eb0,0xe7807467},
	{0x4ad50000,0xd0ed0000,0x1bcc0001,0xc3461cc0,0xb02401db,0x6e29b5da,0xd1b988ab,0xb93377a8,0x94ad0000,0x19280000,0x26470000,0x5b32c880,0x101802ec,0x9d10d4c3,0xcc32ab9e,0x7622bad2},
	{0x2e0c0000,0xaeb00000,0xb5b70001,0x68e81840,0x54b90361,0x5ebe4979,0x46b980e7,0x4b620240,0xf36d0000,0x44860000,0x5d840000,0x45b5cd40,0x2a0900f4,0xe9edb0d4,0x89ce36fc,0x15d1018f},
	{0x49cc0000,0xf31e0000,0xce740001,0x766f1d80,0x6ea80179,0x2a432d6e,0x03451d85,0x2891b91d,0xf0740000,0x67750000,0x883c0000,0xf09ccc00,0xf4850056,0xad872860,0x5b32a3d2,0x8473cf3a},
	{0x0f160000,0x13360000,0x74c90001,0x210ce000,0x09cc003a,0x621b0561,0xabe4ba05,0x69d89f06,0x39b40000,0xa7700000,0x45d60000,0x356fa000,0xf0dd024e,0xf0a3ad0e,0x1ed8716d,0x9f03f39f},
	{0x68d60000,0x4e980000,0x0f0a0001,0x3f8be5c0,0x33dd0222,0x16e66176,0xee182767,0x0a2b245b,0x3aad0000,0x84830000,0x906e0000,0x8046a140,0x2e5102ec,0xb4c935ba,0xcc24e443,0x0ea13d2a},
	{0x0c0f0000,0x30c50000,0xa1710001,0x9425e140,0xd7400098,0x26719dd5,0x79182f2b,0xf87a51b3,0x5d6d0000,0xd92d0000,0xebad0000,0x9ec1a480,0x144000f4,0xc03451ad,0x89d87921,0x6d528677},
	{0x6bcf0000,0x6d6b0000,0xdab20001,0x8aa2e480,0xed510280,0x528cf9c2,0x3ce4b249,0x9b89eaee,0x5e740000,0xfade0000,0x3e150000,0x2be8a5c0,0xcacc0056,0x845ec919,0x5b24ec0f,0xfcf048c2},
	{0xf0760000,0x24620000,0x44530001,0x2de5e9c0,0xedae0394,0xaf63bc89,0x283c1cc0,0x3c3fcd20,0x06460000,0xecee0000,0xcd270000,0x57dba0c0,0x53cc0095,0x78f8e444,0xbae5c740,0xbe7f8979},
	{0x97b60000,0x79cc0000,0x3f900001,0x3362ec00,0xd7bf018c,0xdb9ed89e,0x6dc081a2,0x5fcc767d,0x055f0000,0xcf1d0000,0x189f0000,0xe2f2a180,0x8d400037,0x3c927cf0,0x6819526e,0x2fdd47cc},
	{0xf36f0000,0x07910000,0x91eb0001,0x98cce880,0x33220336,0xeb09243d,0xfac089ee,0xad9d0395,0x629f0000,0x92b30000,0x635c0000,0xfc75a440,0xb751022f,0x486f18e7,0x2de5cf0c,0x4c2efc91},
	{0x94af0000,0x5a3f0000,0xea280001,0x864bed40,0x0933012e,0x9ff4402a,0xbf3c148c,0xce6eb8c8,0x61860000,0xb1400000,0xb6e40000,0x495ca500,0x69dd028d,0x0c058053,0xff195a22,0xdd8c3224},
	{0x30e40000,0x58a80000,0xfc380001,0x43b8e0c0,0xaadd02e1,0xea404c2b,0x0fd90c28,0x48a4e5e0,0xf9260000,0xdbba0000,0xfdbd0000,0x5b32a900,0xb7ae033b,0xb5805dac,0x393d6185,0xeb98db5f},
	{0x57240000,0x05060000,0x87fb0001,0x5d3fe500,0x90cc00f9,0x9ebd283c,0x4a25914a,0x2b575ebd,0xfa3f0000,0xf8490000,0x28050000,0xee1ba840,0x69220399,0xf1eac518,0xebc1f4ab,0x7a3a15ea},
	{0x33fd0000,0x7b5b0000,0x29800001,0xf691e180,0x74510243,0xae2ad49f,0xdd259906,0xd9062b55,0x9dff0000,0xa5e70000,0x53c60000,0xf09cad80,0x53330181,0x8517a10f,0xae3d69c9,0x19c9aeb7},
	{0x543d0000,0x26f50000,0x52430001,0xe816e440,0x4e40005b,0xdad7b088,0x98d90464,0xbaf59008,0x9ee60000,0x86140000,0x867e0000,0x45b5acc0,0x8dbf0123,0xc17d39bb,0x7cc1fce7,0x886b6002},
	{0xcf840000,0x6ffc0000,0xcca20001,0x4f51e900,0x4ebf014f,0x2738f5c3,0x8c01aaed,0x1d43b7c6,0xc6d40000,0x90240000,0x754c0000,0x3986a9c0,0x14bf01e0,0x3ddb14e6,0x9d00d7a8,0xcae4a1b9},
	{0xa8440000,0x32520000,0xb7610001,0x51d6ecc0,0x74ae0357,0x53c591d4,0xc9fd378f,0x7eb00c9b,0xc5cd0000,0xb3d70000,0xa0f40000,0x8cafa880,0xca330142,0x79b18c52,0x4ffc4286,0x5b466f0c},
	{0xcc9d0000,0x4c0f0000,0x191a0001,0xfa78e840,0x903301ed,0x63526d77,0x5efd3fc3,0x8ce17973,0xa20d0000,0xee790000,0xdb370000,0x9228ad40,0xf022035a,0x0d4ce845,0x0a00dfe4,0x38b5d451},
	{0xab5d0000,0x11a10000,0x62d90001,0xe4ffed80,0xaa2203f5,0x17af0960,0x1b01a2a1,0xef12c22e,0xa1140000,0xcd8a0000,0x0e8f0000,0x2701ac00,0x2eae03f8,0x492670f1,0xd8fc4aca,0xa9171ae4},
	{0xdb250000,0x45cf0000,0xe97b0000,0xa7ff5000,0x345700c2,0xcd4f8900,0x069cce49,0x588088ac,0x67c20000,0x1eb90000,0xb7ac0001,0xc3fe2000,0x233a01da,0x7619f0fe,0x36f22270,0xdbbfb947},
	{0xbce50000,0x18610000,0x92b80000,0xb97855c0,0x0e4602da,0xb9b2ed17,0x4360532b,0x3b7333f1,0x64db0000,0x3d4a0000,0x62140001,0x76d72140,0xfdb60178,0x3273684a,0xe40eb75e,0x4a1d77f2},
	{0xd83c0000,0x663c0000,0x3cc30000,0x12d65140,0xeadb0060,0x892511b4,0xd4605b67,0xc9224619,0x031b0000,0x60e40000,0x19d70001,0x68502480,0xc7a70360,0x468e0c5d,0xa1f22a3c,0x29eeccaf},
	{0xbffc0000,0x3b920000,0x47000000,0x0c515480,0xd0ca0278,0xfdd875a3,0x919cc605,0xaad1fd44,0x00020000,0x43170000,0xcc6f0001,0xdd7925c0,0x192b03c2,0x02e494e9,0x730ebf12,0xb84c021a},
	{0x24450000,0x729b0000,0xd9e10000,0xab1659c0,0xd035036c,0x003730e8,0x8544688c,0x0d67da8a,0x58300000,0x55270000,0x3f5d0001,0xa14a20c0,0x802b0301,0xfe42b9b4,0x92cf945d,0xfac3c3a1},
	{0x43850000,0x2f350000,0xa2220000,0xb5915c00,0xea240174,0x74ca54ff,0xc0b8f5ee,0x6e9461d7,0x5b290000,0x76d40000,0xeae50001,0x14632180,0x5ea703a3,0xba282100,0x40330173,0x6b610d14},
	{0x275c0000,0x51680000,0x0c590000,0x1e3f5880,0x0eb903ce,0x445da85c,0x57b8fda2,0x9cc5143f,0x3ce90000,0x2b7a0000,0x91260001,0x0ae42440,0x64b601bb,0xced54517,0x05cf9c11,0x0892b649},
	{0x409c0000,0x0cc60000,0x779a0000,0x00b85d40,0x34a801d6,0x30a0cc4b,0x124460c0,0xff36af62,0x3ff00000,0x08890000,0x449e0001,0xbfcd2500,0xba3a0119,0x8abfdda3,0xd733093f,0x993078fc},
	{0xe4d70000,0x0e510000,0x618a0000,0xc54b50c0,0x97460219,0x4514c04a,0xa2a17864,0x79fcf24a,0xa7500000,0x62730000,0x0fc70001,0xada32900,0x644900af,0x333a005c,0x11173298,0xaf249187},
	{0x83170000,0x53ff0000,0x1a490000,0xdbcc5500,0xad570001,0x31e9a45d,0xe75de506,0x1a0f4917,0xa4490000,0x41800000,0xda7f0001,0x188a2840,0xbac5000d,0x775098e8,0xc3eba7b6,0x3e865f32},
	{0xe7ce0000,0x2da20000,0xb4320000,0x70625180,0x49ca02bb,0x017e58fe,0x705ded4a,0xe85e3cff,0xc3890000,0x1c2e0000,0xa1bc0001,0x060d2d80,0x80d40215,0x03adfcff,0x86173ad4,0x5d75e46f},
	{0x800e0000,0x700c0000,0xcff10000,0x6ee55440,0x73db00a3,0x75833ce9,0x35a17028,0x8bad87a2,0xc0900000,0x3fdd0000,0x74040001,0xb3242cc0,0x5e5802b7,0x47c7644b,0x54ebaffa,0xccd72ada},
	{0x1bb70000,0x39050000,0x51100000,0xc9a25900,0x732401b7,0x886c79a2,0x2179dea1,0x2c1ba06c,0x98a20000,0x29ed0000,0x87360001,0xcf1729c0,0xc7580274,0xbb614916,0xb52a84b5,0x8e58eb61},
	{0x7c770000,0x64ab0000,0x2ad30000,0xd7255cc0,0x493503af,0xfc911db5,0x648543c3,0x4fe81b31,0x9bbb0000,0x0a1e0000,0x528e0001,0x7a3e2880,0x19d402d6,0xff0bd1a2,0x67d6119b,0x1ffa25d4},
	{0x18ae0000,0x1af60000,0x84a80000,0x7c8b5840,0xada80115,0xcc06e116,0xf3854b8f,0xbdb96ed9,0xfc7b0000,0x57b00000,0x294d0001,0x64b92d40,0x23c500ce,0x8bf6b5b5,0x222a8cf9,0x7c099e89},
	{0x7f6e0000,0x47580000,0xff6b0000,0x620c5d80,0x97b9030d,0xb8fb8501,0xb679d6ed,0xde4ad584,0xff620000,0x74430000,0xfcf50001,0xd1902c00,0xfd49006c,0xcf9c2d01,0xf0d619d7,0xedab503c},
	{0x39b40000,0xa7700000,0x45d60000,0x356fa000,0xf0dd024e,0xf0a3ad0e,0x1ed8716d,0x9f03f39f,0x36a20000,0xb4460000,0x311f0001,0x14634000,0xf9110274,0x92b8a86f,0xb53ccb68,0xf6db6c99},
	{0x5e740000,0xfade0000,0x3e150000,0x2be8a5c0,0xcacc0056,0x845ec919,0x5b24ec0f,0xfcf048c2,0x35bb0000,0x97b50000,0xe4a70001,0xa14a4140,0x279d02d6,0xd6d230db,0x67c05e46,0x6779a22c},
	{0x3aad0000,0x84830000,0x906e0000,0x8046a140,0x2e5102ec,0xb4c935ba,0xcc24e443,0x0ea13d2a,0x527b0000,0xca1b0000,0x9f640001,0xbfcd4480,0x1d8c00ce,0xa22f54cc,0x223cc324,0x048a1971},
	{0x5d6d0000,0xd92d0000,0xebad0000,0x9ec1a480,0x144000f4,0xc03451ad,0x89d87921,0x6d528677,0x51620000,0xe9e80000,0x4adc0001,0x0ae445c0,0xc300006c,0xe645cc78,0xf0c0560a,0x9528d7c4},
	{0xc6d40000,0x90240000,0x754c0000,0x3986a9c0,0x14bf01e0,0x3ddb14e6,0x9d00d7a8,0xcae4a1b9,0x09500000,0xffd80000,0xb9ee0001,0x76d740c0,0x5a0000af,0x1ae3e125,0x11017d45,0xd7a7167f},
	{0xa1140000,0xcd8a0000,0x0e8f0000,0x2701ac00,0x2eae03f8,0x492670f1,0xd8fc4aca,0xa9171ae4,0x0a490000,0xdc2b0000,0x6c560001,0xc3fe4180,0x848c000d,0x5e897991,0xc3fde86b,0x4605d8ca},
	{0xc5cd0000,0xb3d70000,0xa0f40000,0x8cafa880,0xca330142,0x79b18c52,0x4ffc4286,0x5b466f0c,0x6d890000,0x81850000,0x17950001,0xdd794440,0xbe9d0215,0x2a741d86,0x86017509,0x25f66397},
	{0xa20d0000,0xee790000,0xdb370000,0x9228ad40,0xf022035a,0x0d4ce845,0x0a00dfe4,0x38b5d451,0x6e900000,0xa2760000,0xc22d0001,0x68504500,0x601102b7,0x6e1e8532,0x54fde027,0xb454ad22},
	{0x06460000,0xecee0000,0xcd270000,0x57dba0c0,0x53cc0095,0x78f8e444,0xbae5c740,0xbe7f8979,0xf6300000,0xc88c0000,0x89740001,0x7a3e4900,0xbe620301,0xd79b58cd,0x92d9db80,0x82404459},
	{0x61860000,0xb1400000,0xb6e40000,0x495ca500,0x69dd028d,0x0c058053,0xff195a22,0xdd8c3224,0xf5290000,0xeb7f0000,0x5ccc0001,0xcf174840,0x60ee03a3,0x93f1c079,0x40254eae,0x13e28aec},
	{0x055f0000,0xcf1d0000,0x189f0000,0xe2f2a180,0x8d400037,0x3c927cf0,0x6819526e,0x2fdd47cc,0x92e90000,0xb6d10000,0x270f0001,0xd1904d80,0x5aff01bb,0xe70ca46e,0x05d9d3cc,0x701131b1},
	{0x629f0000,0x92b30000,0x635c0000,0xfc75a440,0xb751022f,0x486f18e7,0x2de5cf0c,0x4c2efc91,0x91f00000,0x95220000,0xf2b70001,0x64b94cc0,0x84730119,0xa3663cda,0xd72546e2,0xe1b3ff04},
	{0xf9260000,0xdbba0000,0xfdbd0000,0x5b32a900,0xb7ae033b,0xb5805dac,0x393d6185,0xeb98db5f,0xc9c20000,0x83120000,0x01850001,0x188a49c0,0x1d7301da,0x5fc01187,0x36e46dad,0xa33c3ebf},
	{0x9ee60000,0x86140000,0x867e0000,0x45b5acc0,0x8dbf0123,0xc17d39bb,0x7cc1fce7,0x886b6002,0xcadb0000,0xa0e10000,0xd43d0001,0xada34880,0xc3ff0178,0x1baa8933,0xe418f883,0x329ef00a},
	{0xfa3f0000,0xf8490000,0x28050000,0xee1ba840,0x69220399,0xf1eac518,0xebc1f4ab,0x7a3a15ea,0xad1b0000,0xfd4f0000,0xaffe0001,0xb3244d40,0xf9ee0360,0x6f57ed24,0xa1e465e1,0x516d4b57},
	{0x9dff0000,0xa5e70000,0x53c60000,0xf09cad80,0x53330181,0x8517a10f,0xae3d69c9,0x19c9aeb7,0xae020000,0xdebc0000,0x7a460001,0x060d4c00,0x276203c2,0x2b3d7590,0x7318f0cf,0xc0cf85e2},
	{0x8a450000,0xef300000,0x6fc80000,0x70623000,0xee7c036c,0x29eed191,0x85522751,0x75e45d72,0xd4330000,0x56f90000,0x9db20001,0x86f3b000,0x3d9b00f8,0xaf548c61,0xad78744c,0x315817aa},
	{0xed850000,0xb29e0000,0x140b0000,0x6ee535c0,0xd46d0174,0x5d13b586,0xc0aeba33,0x1617e62f,0xd72a0000,0x750a0000,0x480a0001,0x33dab140,0xe317005a,0xeb3e14d5,0x7f84e162,0xa0fad91f},
	{0x895c0000,0xccc30000,0xba700000,0xc54b3140,0x30f003ce,0x6d844925,0x57aeb27f,0xe44693c7,0xb0ea0000,0x28a40000,0x33c90001,0x2d5db480,0xd9060242,0x9fc370c2,0x3a787c00,0xc3096242},
	{0xee9c0000,0x916d0000,0xc1b30000,0xdbcc3480,0x0ae101d6,0x19792d32,0x12522f1d,0x87b5289a,0xb3f30000,0x0b570000,0xe6710001,0x9874b5c0,0x078a02e0,0xdba9e876,0xe884e92e,0x52abacf7},
	{0x75250000,0xd8640000,0x5f520000,0x7c8b39c0,0x0a1e00c2,0xe4966879,0x068a8194,0x20030f54,0xebc10000,0x1d670000,0x15430001,0xe447b0c0,0x9e8a0223,0x270fc52b,0x0945c261,0x10246d4c},
	{0x12e50000,0x85ca0000,0x24910000,0x620c3c00,0x300f02da,0x906b0c6e,0x43761cf6,0x43f0b409,0xe8d80000,0x3e940000,0xc0fb0001,0x516eb180,0x40060281,0x63655d9f,0xdbb9574f,0x8186a3f9},
	{0x763c0000,0xfb970000,0x8aea0000,0xc9a23880,0xd4920060,0xa0fcf0cd,0xd47614ba,0xb1a1c1e1,0x8f180000,0x633a0000,0xbb380001,0x4fe9b440,0x7a170099,0x17983988,0x9e45ca2d,0xe27518a4},
	{0x11fc0000,0xa6390000,0xf1290000,0xd7253d40,0xee830278,0xd40194da,0x918a89d8,0xd2527abc,0x8c010000,0x40c90000,0x6e800001,0xfac0b500,0xa49b003b,0x53f2a13c,0x4cb95f03,0x73d7d611},
	{0xb5b70000,0xa4ae0000,0xe7390000,0x12d630c0,0x4d6d01b7,0xa1b598db,0x216f917c,0x54982794,0x14a10000,0x2a330000,0x25d90001,0xe8aeb900,0x7ae8018d,0xea777cc3,0x8a9d64a4,0x45c33f6a},
	{0xd2770000,0xf9000000,0x9cfa0000,0x0c513500,0x777c03af,0xd548fccc,0x64930c1e,0x376b9cc9,0x17b80000,0x09c00000,0xf0610001,0x5d87b840,0xa464012f,0xae1de477,0x5861f18a,0xd461f1df},
	{0xb6ae0000,0x875d0000,0x32810000,0xa7ff3180,0x93e10115,0xe5df006f,0xf3930452,0xc53ae921,0x70780000,0x546e0000,0x8ba20001,0x4300bd80,0x9e750337,0xdae08060,0x1d9d6ce8,0xb7924a82},
	{0xd16e0000,0xdaf30000,0x49420000,0xb9783440,0xa9f0030d,0x91226478,0xb66f9930,0xa6c9527c,0x73610000,0x779d0000,0x5e1a0001,0xf629bcc0,0x40f90395,0x9e8a18d4,0xcf61f9c6,0x26308437},
	{0x4ad70000,0x93fa0000,0xd7a30000,0x1e3f3900,0xa90f0219,0x6ccd2133,0xa2b737b9,0x017f75b2,0x2b530000,0x61ad0000,0xad280001,0x8a1ab9c0,0xd9f90356,0x622c3589,0x2ea0d289,0x64bf458c},
	{0x2d170000,0xce540000,0xac600000,0x00b83cc0,0x931e0001,0x18304524,0xe74baadb,0x628cceef,0x284a0000,0x425e0000,0x78900001,0x3f33b880,0x077503f4,0x2646ad3d,0xfc5c47a7,0xf51d8b39},
	{0x49ce0000,0xb0090000,0x021b0000,0xab163840,0x778302bb,0x28a7b987,0x704ba297,0x90ddbb07,0x4f8a0000,0x1ff00000,0x03530001,0x21b4bd40,0x3d6401ec,0x52bbc92a,0xb9a0dac5,0x96ee3064},
	{0x2e0e0000,0xeda70000,0x79d80000,0xb5913d80,0x4d9200a3,0x5c5add90,0x35b73ff5,0xf32e005a,0x4c930000,0x3c030000,0xd6eb0001,0x949dbc00,0xe3e8014e,0x16d1519e,0x6b5c4feb,0x074cfed1},
	{0x68d40000,0x0d8f0000,0xc3650000,0xe2f2c000,0x2af601e0,0x1402f59f,0x9d169875,0xb2672641,0x85530000,0xfc060000,0x1b010001,0x516ed000,0xe7b00356,0x4bf5d4f0,0x2eb69d54,0x1c3cc274},
	{0x0f140000,0x50210000,0xb8a60000,0xfc75c5c0,0x10e703f8,0x60ff9188,0xd8ea0517,0xd1949d1c,0x864a0000,0xdff50000,0xceb90001,0xe447d140,0x393c03f4,0x0f9f4c44,0xfc4a087a,0x8d9e0cc1},
	{0x6bcd0000,0x2e7c0000,0x16dd0000,0x57dbc140,0xf47a0142,0x50686d2b,0x4fea0d5b,0x23c5e8f4,0xe18a0000,0x825b0000,0xb57a0001,0xfac0d480,0x032d01ec,0x7b622853,0xb9b69518,0xee6db79c},
	{0x0c0d0000,0x73d20000,0x6d1e0000,0x495cc480,0xce6b035a,0x2495093c,0x0a169039,0x403653a9,0xe2930000,0xa1a80000,0x60c20001,0x4fe9d5c0,0xdda1014e,0x3f08b0e7,0x6b4a0036,0x7fcf7929},
	{0x97b40000,0x3adb0000,0xf3ff0000,0xee1bc9c0,0xce94024e,0xd97a4c77,0x1ece3eb0,0xe7807467,0xbaa10000,0xb7980000,0x93f00001,0x33dad0c0,0x44a1018d,0xc3ae9dba,0x8a8b2b79,0x3d40b892},
	{0xf0740000,0x67750000,0x883c0000,0xf09ccc00,0xf4850056,0xad872860,0x5b32a3d2,0x8473cf3a,0xb9b80000,0x946b0000,0x46480001,0x86f3d180,0x9a2d012f,0x87c4050e,0x5877be57,0xace27627},
	{0x94ad0000,0x19280000,0x26470000,0x5b32c880,0x101802ec,0x9d10d4c3,0xcc32ab9e,0x7622bad2,0xde780000,0xc9c50000,0x3d8b0001,0x9874d440,0xa03c0337,0xf3396119,0x1d8b2335,0xcf11cd7a},
	{0xf36d0000,0x44860000,0x5d840000,0x45b5cd40,0x2a0900f4,0xe9edb0d4,0x89ce36fc,0x15d1018f,0xdd610000,0xea360000,0xe8330001,0x2d5dd500,0x7eb00395,0xb753f9ad,0xcf77b61b,0x5eb303cf},
	{0x57260000,0x46110000,0x4b940000,0x8046c0c0,0x89e7033b,0x9c59bcd5,0x392b2e58,0x931b5ca7,0x45c10000,0x80cc0000,0xa36a0001,0x3f33d900,0xa0c30223,0x0ed62452,0x09538dbc,0x68a7eab4},
	{0x30e60000,0x1bbf0000,0x30570000,0x9ec1c500,0xb3f60123,0xe8a4d8c2,0x7cd7b33a,0xf0e8e7fa,0x46d80000,0xa33f0000,0x76d20001,0x8a1ad840,0x7e4f0281,0x4abcbce6,0xdbaf1892,0xf9052401},
	{0x543f0000,0x65e20000,0x9e2c0000,0x356fc180,0x576b0399,0xd8332461,0xebd7bb76,0x02b99212,0x21180000,0xfe910000,0x0d110001,0x949ddd80,0x445e0099,0x3e41d8f1,0x9e5385f0,0x9af69f5c},
	{0x33ff0000,0x384c0000,0xe5ef0000,0x2be8c440,0x6d7a0181,0xacce4076,0xae2b2614,0x614a294f,0x22010000,0xdd620000,0xd8a90001,0x21b4dcc0,0x9ad2003b,0x7a2b4045,0x4caf10de,0x0b5451e9},
	{0xa8460000,0x71450000,0x7b0e0000,0x8cafc900,0x6d850095,0x5121053d,0xbaf3889d,0xc6fc0e81,0x7a330000,0xcb520000,0x2b9b0001,0x5d87d9c0,0x03d200f8,0x868d6d18,0xad6e3b91,0x49db9052},
	{0xcf860000,0x2ceb0000,0x00cd0000,0x9228ccc0,0x5794028d,0x25dc612a,0xff0f15ff,0xa50fb5dc,0x792a0000,0xe8a10000,0xfe230001,0xe8aed880,0xdd5e005a,0xc2e7f5ac,0x7f92aebf,0xd8795ee7},
	{0xab5f0000,0x52b60000,0xaeb60000,0x3986c840,0xb3090037,0x154b9d89,0x680f1db3,0x575ec034,0x1eea0000,0xb50f0000,0x85e00001,0xf629dd40,0xe74f0242,0xb61a91bb,0x3a6e33dd,0xbb8ae5ba},
	{0xcc9f0000,0x0f180000,0xd5750000,0x2701cd80,0x8918022f,0x61b6f99e,0x2df380d1,0x34ad7b69,0x1df30000,0x96fc0000,0x50580001,0x4300dc00,0x39c302e0,0xf270090f,0xe892a6f3,0x2a282b0f},
	{0x67c20000,0x1eb90000,0xb7ac0001,0xc3fe2000,0x233a01da,0x7619f0fe,0x36f22270,0xdbbfb947,0xbce70000,0x5b760000,0x5ed70001,0x64017000,0x176d0118,0xbb5679fe,0x306eec39,0x833f31eb},
	{0x00020000,0x43170000,0xcc6f0001,0xdd7925c0,0x192b03c2,0x02e494e9,0x730ebf12,0xb84c021a,0xbffe0000,0x78850000,0x8b6f0001,0xd1287140,0xc9e101ba,0xff3ce14a,0xe2927917,0x129dff5e},
	{0x64db0000,0x3d4a0000,0x62140001,0x76d72140,0xfdb60178,0x3273684a,0xe40eb75e,0x4a1d77f2,0xd83e0000,0x252b0000,0xf0ac0001,0xcfaf7480,0xf3f003a2,0x8bc1855d,0xa76ee475,0x716e4403},
	{0x031b0000,0x60e40000,0x19d70001,0x68502480,0xc7a70360,0x468e0c5d,0xa1f22a3c,0x29eeccaf,0xdb270000,0x06d80000,0x25140001,0x7a8675c0,0x2d7c0300,0xcfab1de9,0x7592715b,0xe0cc8ab6},
	{0x98a20000,0x29ed0000,0x87360001,0xcf1729c0,0xc7580274,0xbb614916,0xb52a84b5,0x8e58eb61,0x83150000,0x10e80000,0xd6260001,0x06b570c0,0xb47c03c3,0x330d30b4,0x94535a14,0xa2434b0d},
	{0xff620000,0x74430000,0xfcf50001,0xd1902c00,0xfd49006c,0xcf9c2d01,0xf0d619d7,0xedab503c,0x800c0000,0x331b0000,0x039e0001,0xb39c7180,0x6af00361,0x7767a800,0x46afcf3a,0x33e185b8},
	{0x9bbb0000,0x0a1e0000,0x528e0001,0x7a3e2880,0x19d402d6,0xff0bd1a2,0x67d6119b,0x1ffa25d4,0xe7cc0000,0x6eb50000,0x785d0001,0xad1b7440,0x50e10179,0x039acc17,0x03535258,0x50123ee5},
	{0xfc7b0000,0x57b00000,0x294d0001,0x64b92d40,0x23c500ce,0x8bf6b5b5,0x222a8cf9,0x7c099e89,0xe4d50000,0x4d460000,0xade50001,0x18327500,0x8e6d01db,0x47f054a3,0xd1afc776,0xc1b0f050},
	{0x58300000,0x55270000,0x3f5d0001,0xa14a20c0,0x802b0301,0xfe42b9b4,0x92cf945d,0xfac3c3a1,0x7c750000,0x27bc0000,0xe6bc0001,0x0a5c7900,0x501e006d,0xfe75895c,0x178bfcd1,0xf7a4192b},
	{0x3ff00000,0x08890000,0x449e0001,0xbfcd2500,0xba3a0119,0x8abfdda3,0xd733093f,0x993078fc,0x7f6c0000,0x044f0000,0x33040001,0xbf757840,0x8e9200cf,0xba1f11e8,0xc57769ff,0x6606d79e},
	{0x5b290000,0x76d40000,0xeae50001,0x14632180,0x5ea703a3,0xba282100,0x40330173,0x6b610d14,0x18ac0000,0x59e10000,0x48c70001,0xa1f27d80,0xb48302d7,0xcee275ff,0x808bf49d,0x05f56cc3},
	{0x3ce90000,0x2b7a0000,0x91260001,0x0ae42440,0x64b601bb,0xced54517,0x05cf9c11,0x0892b649,0x1bb50000,0x7a120000,0x9d7f0001,0x14db7cc0,0x6a0f0275,0x8a88ed4b,0x527761b3,0x9457a276},
	{0xa7500000,0x62730000,0x0fc70001,0xada32900,0x644900af,0x333a005c,0x11173298,0xaf249187,0x43870000,0x6c220000,0x6e4d0001,0x68e879c0,0xf30f02b6,0x762ec016,0xb3b64afc,0xd6d863cd},
	{0xc0900000,0x3fdd0000,0x74040001,0xb3242cc0,0x5e5802b7,0x47c7644b,0x54ebaffa,0xccd72ada,0x409e0000,0x4fd10000,0xbbf50001,0xddc17880,0x2d830214,0x324458a2,0x614adfd2,0x477aad78},
	{0xa4490000,0x41800000,0xda7f0001,0x188a2840,0xbac5000d,0x775098e8,0xc3eba7b6,0x3e865f32,0x275e0000,0x127f0000,0xc0360001,0xc3467d40,0x1792000c,0x46b93cb5,0x24b642b0,0x24891625},
	{0xc3890000,0x1c2e0000,0xa1bc0001,0x060d2d80,0x80d40215,0x03adfcff,0x86173ad4,0x5d75e46f,0x24470000,0x318c0000,0x158e0001,0x766f7c00,0xc91e00ae,0x02d3a401,0xf64ad79e,0xb52bd890},
	{0x85530000,0xfc060000,0x1b010001,0x516ed000,0xe7b00356,0x4bf5d4f0,0x2eb69d54,0x1c3cc274,0xed870000,0xf1890000,0xd8640001,0xb39c1000,0xcd4602b6,0x5ff7216f,0xb3a00521,0xae5be435},
	{0xe2930000,0xa1a80000,0x60c20001,0x4fe9d5c0,0xdda1014e,0x3f08b0e7,0x6b4a0036,0x7fcf7929,0xee9e0000,0xd27a0000,0x0ddc0001,0x06b51140,0x13ca0214,0x1b9db9db,0x615c900f,0x3ff92a80},
	{0x864a0000,0xdff50000,0xceb90001,0xe447d140,0x393c03f4,0x0f9f4c44,0xfc4a087a,0x8d9e0cc1,0x895e0000,0x8fd40000,0x761f0001,0x18321480,0x29db000c,0x6f60ddcc,0x24a00d6d,0x5c0a91dd},
	{0xe18a0000,0x825b0000,0xb57a0001,0xfac0d480,0x032d01ec,0x7b622853,0xb9b69518,0xee6db79c,0x8a470000,0xac270000,0xa3a70001,0xad1b15c0,0xf75700ae,0x2b0a4578,0xf65c9843,0xcda85f68},
	{0x7a330000,0xcb520000,0x2b9b0001,0x5d87d9c0,0x03d200f8,0x868d6d18,0xad6e3b91,0x49db9052,0xd2750000,0xba170000,0x50950001,0xd12810c0,0x6e57006d,0xd7ac6825,0x179db30c,0x8f279ed3},
	{0x1df30000,0x96fc0000,0x50580001,0x4300dc00,0x39c302e0,0xf270090f,0xe892a6f3,0x2a282b0f,0xd16c0000,0x99e40000,0x852d0001,0x64011180,0xb0db00cf,0x93c6f091,0xc5612622,0x1e855066},
	{0x792a0000,0xe8a10000,0xfe230001,0xe8aed880,0xdd5e005a,0xc2e7f5ac,0x7f92aebf,0xd8795ee7,0xb6ac0000,0xc44a0000,0xfeee0001,0x7a861440,0x8aca02d7,0xe73b9486,0x809dbb40,0x7d76eb3b},
	{0x1eea0000,0xb50f0000,0x85e00001,0xf629dd40,0xe74f0242,0xb61a91bb,0x3a6e33dd,0xbb8ae5ba,0xb5b50000,0xe7b90000,0x2b560001,0xcfaf1500,0x54460275,0xa3510c32,0x52612e6e,0xecd4258e},
	{0xbaa10000,0xb7980000,0x93f00001,0x33dad0c0,0x44a1018d,0xc3ae9dba,0x8a8b2b79,0x3d40b892,0x2d150000,0x8d430000,0x600f0001,0xddc11900,0x8a3503c3,0x1ad4d1cd,0x944515c9,0xdac0ccf5},
	{0xdd610000,0xea360000,0xe8330001,0x2d5dd500,0x7eb00395,0xb753f9ad,0xcf77b61b,0x5eb303cf,0x2e0c0000,0xaeb00000,0xb5b70001,0x68e81840,0x54b90361,0x5ebe4979,0x46b980e7,0x4b620240},
	{0xb9b80000,0x946b0000,0x46480001,0x86f3d180,0x9a2d012f,0x87c4050e,0x5877be57,0xace27627,0x49cc0000,0xf31e0000,0xce740001,0x766f1d80,0x6ea80179,0x2a432d6e,0x03451d85,0x2891b91d},
	{0xde780000,0xc9c50000,0x3d8b0001,0x9874d440,0xa03c0337,0xf3396119,0x1d8b2335,0xcf11cd7a,0x4ad50000,0xd0ed0000,0x1bcc0001,0xc3461cc0,0xb02401db,0x6e29b5da,0xd1b988ab,0xb93377a8},
	{0x45c10000,0x80cc0000,0xa36a0001,0x3f33d900,0xa0c30223,0x0ed62452,0x09538dbc,0x68a7eab4,0x12e70000,0xc6dd0000,0xe8fe0001,0xbf7519c0,0x29240118,0x928f9887,0x3078a3e4,0xfbbcb613},
	{0x22010000,0xdd620000,0xd8a90001,0x21b4dcc0,0x9ad2003b,0x7a2b4045,0x4caf10de,0x0b5451e9,0x11fe0000,0xe52e0000,0x3d460001,0x0a5c1880,0xf7a801ba,0xd6e50033,0xe28436ca,0x6a1e78a6},
	{0x46d80000,0xa33f0000,0x76d20001,0x8a1ad840,0x7e4f0281,0x4abcbce6,0xdbaf1892,0xf9052401,0x763e0000,0xb8800000,0x46850001,0x14db1d40,0xcdb903a2,0xa2186424,0xa778aba8,0x09edc3fb},
	{0x21180000,0xfe910000,0x0d110001,0x949ddd80,0x445e0099,0x3e41d8f1,0x9e5385f0,0x9af69f5c,0x75270000,0x9b730000,0x933d0001,0xa1f21c00,0x13350300,0xe672fc90,0x75843e86,0x984f0d4e},
	{0x36a20000,0xb4460000,0x311f0001,0x14634000,0xf9110274,0x92b8a86f,0xb53ccb68,0xf6db6c99,0x0f160000,0x13360000,0x74c90001,0x210ce000,0x09cc003a,0x621b0561,0xabe4ba05,0x69d89f06},
	{0x51620000,0xe9e80000,0x4adc0001,0x0ae445c0,0xc300006c,0xe645cc78,0xf0c0560a,0x9528d7c4,0x0c0f0000,0x30c50000,0xa1710001,0x9425e140,0xd7400098,0x26719dd5,0x79182f2b,0xf87a51b3},
	{0x35bb0000,0x97b50000,0xe4a70001,0xa14a4140,0x279d02d6,0xd6d230db,0x67c05e46,0x6779a22c,0x6bcf0000,0x6d6b0000,0xdab20001,0x8aa2e480,0xed510280,0x528cf9c2,0x3ce4b249,0x9b89eaee},
	{0x527b0000,0xca1b0000,0x9f640001,0xbfcd4480,0x1d8c00ce,0xa22f54cc,0x223cc324,0x048a1971,0x68d60000,0x4e980000,0x0f0a0001,0x3f8be5c0,0x33dd0222,0x16e66176,0xee182767,0x0a2b245b},
	{0xc9c20000,0x83120000,0x01850001,0x188a49c0,0x1d7301da,0x5fc01187,0x36e46dad,0xa33c3ebf,0x30e40000,0x58a80000,0xfc380001,0x43b8e0c0,0xaadd02e1,0xea404c2b,0x0fd90c28,0x48a4e5e0},
	{0xae020000,0xdebc0000,0x7a460001,0x060d4c00,0x276203c2,0x2b3d7590,0x7318f0cf,0xc0cf85e2,0x33fd0000,0x7b5b0000,0x29800001,0xf691e180,0x74510243,0xae2ad49f,0xdd259906,0xd9062b55},
	{0xcadb0000,0xa0e10000,0xd43d0001,0xada34880,0xc3ff0178,0x1baa8933,0xe418f883,0x329ef00a,0x543d0000,0x26f50000,0x52430001,0xe816e440,0x4e40005b,0xdad7b088,0x98d90464,0xbaf59008},
	{0xad1b0000,0xfd4f0000,0xaffe0001,0xb3244d40,0xf9ee0360,0x6f57ed24,0xa1e465e1,0x516d4b57,0x57240000,0x05060000,0x87fb0001,0x5d3fe500,0x90cc00f9,0x9ebd283c,0x4a25914a,0x2b575ebd},
	{0x09500000,0xffd80000,0xb9ee0001,0x76d740c0,0x5a0000af,0x1ae3e125,0x11017d45,0xd7a7167f,0xcf840000,0x6ffc0000,0xcca20001,0x4f51e900,0x4ebf014f,0x2738f5c3,0x8c01aaed,0x1d43b7c6},
	{0x6e900000,0xa2760000,0xc22d0001,0x68504500,0x601102b7,0x6e1e8532,0x54fde027,0xb454ad22,0xcc9d0000,0x4c0f0000,0x191a0001,0xfa78e840,0x903301ed,0x63526d77,0x5efd3fc3,0x8ce17973},
	{0x0a490000,0xdc2b0000,0x6c560001,0xc3fe4180,0x848c000d,0x5e897991,0xc3fde86b,0x4605d8ca,0xab5d0000,0x11a10000,0x62d90001,0xe4ffed80,0xaa2203f5,0x17af0960,0x1b01a2a1,0xef12c22e},
	{0x6d890000,0x81850000,0x17950001,0xdd794440,0xbe9d0215,0x2a741d86,0x86017509,0x25f66397,0xa8440000,0x32520000,0xb7610001,0x51d6ecc0,0x74ae0357,0x53c591d4,0xc9fd378f,0x7eb00c9b},
	{0xf6300000,0xc88c0000,0x89740001,0x7a3e4900,0xbe620301,0xd79b58cd,0x92d9db80,0x82404459,0xf0760000,0x24620000,0x44530001,0x2de5e9c0,0xedae0394,0xaf63bc89,0x283c1cc0,0x3c3fcd20},
	{0x91f00000,0x95220000,0xf2b70001,0x64b94cc0,0x84730119,0xa3663cda,0xd72546e2,0xe1b3ff04,0xf36f0000,0x07910000,0x91eb0001,0x98cce880,0x33220336,0xeb09243d,0xfac089ee,0xad9d0395},
	{0xf5290000,0xeb7f0000,0x5ccc0001,0xcf174840,0x60ee03a3,0x93f1c079,0x40254eae,0x13e28aec,0x94af0000,0x5a3f0000,0xea280001,0x864bed40,0x0933012e,0x9ff4402a,0xbf3c148c,0xce6eb8c8},
	{0x92e90000,0xb6d10000,0x270f0001,0xd1904d80,0x5aff01bb,0xe70ca46e,0x05d9d3cc,0x701131b1,0x97b60000,0x79cc0000,0x3f900001,0x3362ec00,0xd7bf018c,0xdb9ed89e,0x6dc081a2,0x5fcc767d},
	{0xd4330000,0x56f90000,0x9db20001,0x86f3b000,0x3d9b00f8,0xaf548c61,0xad78744c,0x315817aa,0x5e760000,0xb9c90000,0xf27a0001,0xf6918000,0xd3e70394,0x86ba5df0,0x282a531d,0x44bc4ad8},
	{0xb3f30000,0x0b570000,0xe6710001,0x9874b5c0,0x078a02e0,0xdba9e876,0xe884e92e,0x52abacf7,0x5d6f0000,0x9a3a0000,0x27c20001,0x43b88140,0x0d6b0336,0xc2d0c544,0xfad6c633,0xd51e846d},
	{0xd72a0000,0x750a0000,0x480a0001,0x33dab140,0xe317005a,0xeb3e14d5,0x7f84e162,0xa0fad91f,0x3aaf0000,0xc7940000,0x5c010001,0x5d3f8480,0x377a012e,0xb62da153,0xbf2a5b51,0xb6ed3f30},
	{0xb0ea0000,0x28a40000,0x33c90001,0x2d5db480,0xd9060242,0x9fc370c2,0x3a787c00,0xc3096242,0x39b60000,0xe4670000,0x89b90001,0xe81685c0,0xe9f6018c,0xf24739e7,0x6dd6ce7f,0x274ff185},
	{0x2b530000,0x61ad0000,0xad280001,0x8a1ab9c0,0xd9f90356,0x622c3589,0x2ea0d289,0x64bf458c,0x61840000,0xf2570000,0x7a8b0001,0x942580c0,0x70f6014f,0x0ee114ba,0x8c17e530,0x65c0303e},
	{0x4c930000,0x3c030000,0xd6eb0001,0x949dbc00,0xe3e8014e,0x16d1519e,0x6b5c4feb,0x074cfed1,0x629d0000,0xd1a40000,0xaf330001,0x210c8180,0xae7a01ed,0x4a8b8c0e,0x5eeb701e,0xf462fe8b},
	{0x284a0000,0x425e0000,0x78900001,0x3f33b880,0x077503f4,0x2646ad3d,0xfc5c47a7,0xf51d8b39,0x055d0000,0x8c0a0000,0xd4f00001,0x3f8b8440,0x946b03f5,0x3e76e819,0x1b17ed7c,0x979145d6},
	{0x4f8a0000,0x1ff00000,0x03530001,0x21b4bd40,0x3d6401ec,0x52bbc92a,0xb9a0dac5,0x96ee3064,0x06440000,0xaff90000,0x01480001,0x8aa28500,0x4ae70357,0x7a1c70ad,0xc9eb7852,0x06338b63},
	{0xebc10000,0x1d670000,0x15430001,0xe447b0c0,0x9e8a0223,0x270fc52b,0x0945c261,0x10246d4c,0x9ee40000,0xc5030000,0x4a110001,0x98cc8900,0x949402e1,0xc399ad52,0x0fcf43f5,0x30276218},
	{0x8c010000,0x40c90000,0x6e800001,0xfac0b500,0xa49b003b,0x53f2a13c,0x4cb95f03,0x73d7d611,0x9dfd0000,0xe6f00000,0x9fa90001,0x2de58840,0x4a180243,0x87f335e6,0xdd33d6db,0xa185acad},
	{0xe8d80000,0x3e940000,0xc0fb0001,0x516eb180,0x40060281,0x63655d9f,0xdbb9574f,0x8186a3f9,0xfa3d0000,0xbb5e0000,0xe46a0001,0x33628d80,0x7009005b,0xf30e51f1,0x98cf4bb9,0xc27617f0},
	{0x8f180000,0x633a0000,0xbb380001,0x4fe9b440,0x7a170099,0x17983988,0x9e45ca2d,0xe27518a4,0xf9240000,0x98ad0000,0x31d20001,0x864b8cc0,0xae8500f9,0xb764c945,0x4a33de97,0x53d4d945},
	{0x14a10000,0x2a330000,0x25d90001,0xe8aeb900,0x7ae8018d,0xea777cc3,0x8a9d64a4,0x45c33f6a,0xa1160000,0x8e9d0000,0xc2e00001,0xfa7889c0,0x3785003a,0x4bc2e418,0xabf2f5d8,0x115b18fe},
	{0x73610000,0x779d0000,0x5e1a0001,0xf629bcc0,0x40f90395,0x9e8a18d4,0xcf61f9c6,0x26308437,0xa20f0000,0xad6e0000,0x17580001,0x4f518880,0xe9090098,0x0fa87cac,0x790e60f6,0x80f9d64b},
	{0x17b80000,0x09c00000,0xf0610001,0x5d87b840,0xa464012f,0xae1de477,0x5861f18a,0xd461f1df,0xc5cf0000,0xf0c00000,0x6c9b0001,0x51d68d40,0xd3180280,0x7b5518bb,0x3cf2fd94,0xe30a6d16},
	{0x70780000,0x546e0000,0x8ba20001,0x4300bd80,0x9e750337,0xdae08060,0x1d9d6ce8,0xb7924a82,0xc6d60000,0xd3330000,0xb9230001,0xe4ff8c00,0x0d940222,0x3f3f800f,0xee0e68ba,0x72a8a3a3}
    },{
	{0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
	{0x1b520000,0xeaca0000,0x62da0000,0x3347000f,0x046b0121,0x75806e61,0xc6c11cd4,0xb186e676,0x27840000,0xc7ab0000,0xf28e0000,0xa2cc0006,0x6ce10284,0x4439b3f3,0x09e6389e,0x7276dbcf},
	{0x27840000,0xc7ab0000,0xf28e0000,0xa2cc0006,0x6ce10284,0x4439b3f3,0x09e6389e,0x7276dbcf,0x3cd60000,0x2d610000,0x90540000,0x918b0009,0x688a03a5,0x31b9dd92,0xcf27244a,0xc3f03db9},
	{0x3cd60000,0x2d610000,0x90540000,0x918b0009,0x688a03a5,0x31b9dd92,0xcf27244a,0xc3f03db9,0x1b520000,0xeaca0000,0x62da0000,0x3347000f,0x046b0121,0x75806e61,0xc6c11cd4,0xb186e676},
	{0x4f620000,0xdbad0000,0x25240000,0x676d0017,0x86d701d0,0xcf0fd425,0xc584b9e1,0xf17ccc62,0x060e0000,0x83170000,0xc2830000,0x3c9f0005,0xc9fa0119,0x88601ec2,0x12287f35,0x64a4749c},
	{0x54300000,0x31670000,0x47fe0000,0x542a0018,0x82bc00f1,0xba8fba44,0x0345a535,0x40fa2a14,0x218a0000,0x44bc0000,0x300d0000,0x9e530003,0xa51b039d,0xcc59ad31,0x1bce47ab,0x16d2af53},
	{0x68e60000,0x1c060000,0xd7aa0000,0xc5a10011,0xea360354,0x8b3667d6,0xcc62817f,0x830a17ad,0x3ad80000,0xae760000,0x52d70000,0xad14000c,0xa17002bc,0xb9d9c350,0xdd0f5b7f,0xa7544925},
	{0x73b40000,0xf6cc0000,0xb5700000,0xf6e6001e,0xee5d0275,0xfeb609b7,0x0aa39dab,0x328cf1db,0x1d5c0000,0x69dd0000,0xa0590000,0x0fd8000a,0xcd910038,0xfde070a3,0xd4e963e1,0xd52292ea},
	{0x060e0000,0x83170000,0xc2830000,0x3c9f0005,0xc9fa0119,0x88601ec2,0x12287f35,0x64a4749c,0x496c0000,0x58ba0000,0xe7a70000,0x5bf20012,0x4f2d00c9,0x476fcae7,0xd7acc6d4,0x95d8b8fe},
	{0x1d5c0000,0x69dd0000,0xa0590000,0x0fd8000a,0xcd910038,0xfde070a3,0xd4e963e1,0xd52292ea,0x6ee80000,0x9f110000,0x15290000,0xf93e0014,0x23cc024d,0x03567914,0xde4afe4a,0xe7ae6331},
	{0x218a0000,0x44bc0000,0x300d0000,0x9e530003,0xa51b039d,0xcc59ad31,0x1bce47ab,0x16d2af53,0x75ba0000,0x75db0000,0x77f30000,0xca79001b,0x27a7036c,0x76d61775,0x188be29e,0x56288547},
	{0x3ad80000,0xae760000,0x52d70000,0xad14000c,0xa17002bc,0xb9d9c350,0xdd0f5b7f,0xa7544925,0x523e0000,0xb2700000,0x857d0000,0x68b5001d,0x4b4601e8,0x32efa486,0x116dda00,0x245e5e88},
	{0x496c0000,0x58ba0000,0xe7a70000,0x5bf20012,0x4f2d00c9,0x476fcae7,0xd7acc6d4,0x95d8b8fe,0x4f620000,0xdbad0000,0x25240000,0x676d0017,0x86d701d0,0xcf0fd425,0xc584b9e1,0xf17ccc62},
	{0x523e0000,0xb2700000,0x857d0000,0x68b5001d,0x4b4601e8,0x32efa486,0x116dda00,0x245e5e88,0x68e60000,0x1c060000,0xd7aa0000,0xc5a10011,0xea360354,0x8b3667d6,0xcc62817f,0x830a17ad},
	{0x6ee80000,0x9f110000,0x15290000,0xf93e0014,0x23cc024d,0x03567914,0xde4afe4a,0xe7ae6331,0x73b40000,0xf6cc0000,0xb5700000,0xf6e6001e,0xee5d0275,0xfeb609b7,0x0aa39dab,0x328cf1db},
	{0x75ba0000,0x75db0000,0x77f30000,0xca79001b,0x27a7036c,0x76d61775,0x188be29e,0x56288547,0x54300000,0x31670000,0x47fe0000,0x542a0018,0x82bc00f1,0xba8fba44,0x0345a535,0x40fa2a14},
	{0xd7c10000,0x2b6b0000,0xadd80000,0x863c0027,0x93de033f,0x9d83e1ac,0xc3e9f183,0x70f0785a,0x451a0000,0x8a1e0000,0x85140000,0x491b0003,0x01b50220,0xf3ce3584,0x64b4625b,0x59392928},
	{0xcc930000,0xc1a10000,0xcf020000,0xb57b0028,0x97b5021e,0xe8038fcd,0x0528ed57,0xc1769e2c,0x629e0000,0x4db50000,0x779a0000,0xebd70005,0x6d5400a4,0xb7f78677,0x6d525ac5,0x2b4ff2e7},
	{0xf0450000,0xecc00000,0x5f560000,0x24f00021,0xff3f01bb,0xd9ba525f,0xca0fc91d,0x0286a395,0x79cc0000,0xa77f0000,0x15400000,0xd890000a,0x693f0185,0xc277e816,0xab934611,0x9ac91491},
	{0xeb170000,0x060a0000,0x3d8c0000,0x17b7002e,0xfb54009a,0xac3a3c3e,0x0cced5c9,0xb30045e3,0x5e480000,0x60d40000,0xe7ce0000,0x7a5c000c,0x05de0301,0x864e5be5,0xa2757e8f,0xe8bfcf5e},
	{0x98a30000,0xf0c60000,0x88fc0000,0xe1510030,0x150902ef,0x528c3589,0x066d4862,0x818cb438,0x43140000,0x09090000,0x47970000,0x75840006,0xc84f0339,0x7bae2b46,0x769c1d6e,0x3d9d5db4},
	{0x83f10000,0x1a0c0000,0xea260000,0xd216003f,0x116203ce,0x270c5be8,0xc0ac54b6,0x300a524e,0x64900000,0xcea20000,0xb5190000,0xd7480000,0xa4ae01bd,0x3f9798b5,0x7f7a25f0,0x4feb867b},
	{0xbf270000,0x376d0000,0x7a720000,0x439d0036,0x79e8006b,0x16b5867a,0x0f8b70fc,0xf3fa6ff7,0x7fc20000,0x24680000,0xd7c30000,0xe40f000f,0xa0c5009c,0x4a17f6d4,0xb9bb3924,0xfe6d600d},
	{0xa4750000,0xdda70000,0x18a80000,0x70da0039,0x7d83014a,0x6335e81b,0xc94a6c28,0x427c8981,0x58460000,0xe3c30000,0x254d0000,0x46c30009,0xcc240218,0x0e2e4527,0xb05d01ba,0x8c1bbbc2},
	{0xd1cf0000,0xa87c0000,0x6f5b0000,0xbaa30022,0x5a240226,0x15e3ff6e,0xd1c18eb6,0x14540cc6,0x0c760000,0xd2a40000,0x62b30000,0x12e90011,0x4e9802e9,0xb4a1ff63,0xb318a48f,0xcce191d6},
	{0xca9d0000,0x42b60000,0x0d810000,0x89e4002d,0x5e4f0307,0x6063910f,0x17009262,0xa5d2eab0,0x2bf20000,0x150f0000,0x903d0000,0xb0250017,0x2279006d,0xf0984c90,0xbafe9c11,0xbe974a19},
	{0xf64b0000,0x6fd70000,0x9dd50000,0x186f0024,0x36c500a2,0x51da4c9d,0xd827b628,0x6622d709,0x30a00000,0xffc50000,0xf2e70000,0x83620018,0x2612014c,0x851822f1,0x7c3f80c5,0x0f11ac6f},
	{0xed190000,0x851d0000,0xff0f0000,0x2b28002b,0x32ae0183,0x245a22fc,0x1ee6aafc,0xd7a4317f,0x17240000,0x386e0000,0x00690000,0x21ae001e,0x4af303c8,0xc1219102,0x75d9b85b,0x7d6777a0},
	{0x9ead0000,0x73d10000,0x4a7f0000,0xddce0035,0xdcf303f6,0xdaec2b4b,0x14453757,0xe528c0a4,0x0a780000,0x51b30000,0xa0300000,0x2e760014,0x876203f0,0x3cc1e1a1,0xa130dbba,0xa845e54a},
	{0x85ff0000,0x991b0000,0x28a50000,0xee89003a,0xd89802d7,0xaf6c452a,0xd2842b83,0x54ae26d2,0x2dfc0000,0x96180000,0x52be0000,0x8cba0012,0xeb830174,0x78f85252,0xa8d6e324,0xda333e85},
	{0xb9290000,0xb47a0000,0xb8f10000,0x7f020033,0xb0120172,0x9ed598b8,0x1da30fc9,0x975e1b6b,0x36ae0000,0x7cd20000,0x30640000,0xbffd001d,0xefe80055,0x0d783c33,0x6e17fff0,0x6bb5d8f3},
	{0xa27b0000,0x5eb00000,0xda2b0000,0x4c45003c,0xb4790053,0xeb55f6d9,0xdb62131d,0x26d8fd1d,0x112a0000,0xbb790000,0xc2ea0000,0x1d31001b,0x830902d1,0x49418fc0,0x67f1c76e,0x19c3033c},
	{0x451a0000,0x8a1e0000,0x85140000,0x491b0003,0x01b50220,0xf3ce3584,0x64b4625b,0x59392928,0x92db0000,0xa1750000,0x28cc0000,0xcf270024,0x926b011f,0x6e4dd428,0xa75d93d8,0x29c95172},
	{0x5e480000,0x60d40000,0xe7ce0000,0x7a5c000c,0x05de0301,0x864e5be5,0xa2757e8f,0xe8bfcf5e,0xb55f0000,0x66de0000,0xda420000,0x6deb0022,0xfe8a039b,0x2a7467db,0xaebbab46,0x5bbf8abd},
	{0x629e0000,0x4db50000,0x779a0000,0xebd70005,0x6d5400a4,0xb7f78677,0x6d525ac5,0x2b4ff2e7,0xae0d0000,0x8c140000,0xb8980000,0x5eac002d,0xfae102ba,0x5ff409ba,0x687ab792,0xea396ccb},
	{0x79cc0000,0xa77f0000,0x15400000,0xd890000a,0x693f0185,0xc277e816,0xab934611,0x9ac91491,0x89890000,0x4bbf0000,0x4a160000,0xfc60002b,0x9600003e,0x1bcdba49,0x619c8f0c,0x984fb704},
	{0x0a780000,0x51b30000,0xa0300000,0x2e760014,0x876203f0,0x3cc1e1a1,0xa130dbba,0xa845e54a,0x94d50000,0x22620000,0xea4f0000,0xf3b80021,0x5b910006,0xe62dcaea,0xb575eced,0x4d6d25ee},
	{0x112a0000,0xbb790000,0xc2ea0000,0x1d31001b,0x830902d1,0x49418fc0,0x67f1c76e,0x19c3033c,0xb3510000,0xe5c90000,0x18c10000,0x51740027,0x37700282,0xa2147919,0xbc93d473,0x3f1bfe21},
	{0x2dfc0000,0x96180000,0x52be0000,0x8cba0012,0xeb830174,0x78f85252,0xa8d6e324,0xda333e85,0xa8030000,0x0f030000,0x7a1b0000,0x62330028,0x331b03a3,0xd7941778,0x7a52c8a7,0x8e9d1857},
	{0x36ae0000,0x7cd20000,0x30640000,0xbffd001d,0xefe80055,0x0d783c33,0x6e17fff0,0x6bb5d8f3,0x8f870000,0xc8a80000,0x88950000,0xc0ff002e,0x5ffa0127,0x93ada48b,0x73b4f039,0xfcebc398},
	{0x43140000,0x09090000,0x47970000,0x75840006,0xc84f0339,0x7bae2b46,0x769c1d6e,0x3d9d5db4,0xdbb70000,0xf9cf0000,0xcf6b0000,0x94d50036,0xdd4601d6,0x29221ecf,0x70f1550c,0xbc11e98c},
	{0x58460000,0xe3c30000,0x254d0000,0x46c30009,0xcc240218,0x0e2e4527,0xb05d01ba,0x8c1bbbc2,0xfc330000,0x3e640000,0x3de50000,0x36190030,0xb1a70352,0x6d1bad3c,0x79176d92,0xce673243},
	{0x64900000,0xcea20000,0xb5190000,0xd7480000,0xa4ae01bd,0x3f9798b5,0x7f7a25f0,0x4feb867b,0xe7610000,0xd4ae0000,0x5f3f0000,0x055e003f,0xb5cc0273,0x189bc35d,0xbfd67146,0x7fe1d435},
	{0x7fc20000,0x24680000,0xd7c30000,0xe40f000f,0xa0c5009c,0x4a17f6d4,0xb9bb3924,0xfe6d600d,0xc0e50000,0x13050000,0xadb10000,0xa7920039,0xd92d00f7,0x5ca270ae,0xb63049d8,0x0d970ffa},
	{0x0c760000,0xd2a40000,0x62b30000,0x12e90011,0x4e9802e9,0xb4a1ff63,0xb318a48f,0xcce191d6,0xddb90000,0x7ad80000,0x0de80000,0xa84a0033,0x14bc00cf,0xa142000d,0x62d92a39,0xd8b59d10},
	{0x17240000,0x386e0000,0x00690000,0x21ae001e,0x4af303c8,0xc1219102,0x75d9b85b,0x7d6777a0,0xfa3d0000,0xbd730000,0xff660000,0x0a860035,0x785d024b,0xe57bb3fe,0x6b3f12a7,0xaac346df},
	{0x2bf20000,0x150f0000,0x903d0000,0xb0250017,0x2279006d,0xf0984c90,0xbafe9c11,0xbe974a19,0xe16f0000,0x57b90000,0x9dbc0000,0x39c1003a,0x7c36036a,0x90fbdd9f,0xadfe0e73,0x1b45a0a9},
	{0x30a00000,0xffc50000,0xf2e70000,0x83620018,0x2612014c,0x851822f1,0x7c3f80c5,0x0f11ac6f,0xc6eb0000,0x90120000,0x6f320000,0x9b0d003c,0x10d701ee,0xd4c26e6c,0xa41836ed,0x69337b66},
	{0x92db0000,0xa1750000,0x28cc0000,0xcf270024,0x926b011f,0x6e4dd428,0xa75d93d8,0x29c95172,0xd7c10000,0x2b6b0000,0xadd80000,0x863c0027,0x93de033f,0x9d83e1ac,0xc3e9f183,0x70f0785a},
	{0x89890000,0x4bbf0000,0x4a160000,0xfc60002b,0x9600003e,0x1bcdba49,0x619c8f0c,0x984fb704,0xf0450000,0xecc00000,0x5f560000,0x24f00021,0xff3f01bb,0xd9ba525f,0xca0fc91d,0x0286a395},
	{0xb55f0000,0x66de0000,0xda420000,0x6deb0022,0xfe8a039b,0x2a7467db,0xaebbab46,0x5bbf8abd,0xeb170000,0x060a0000,0x3d8c0000,0x17b7002e,0xfb54009a,0xac3a3c3e,0x0cced5c9,0xb30045e3},
	{0xae0d0000,0x8c140000,0xb8980000,0x5eac002d,0xfae102ba,0x5ff409ba,0x687ab792,0xea396ccb,0xcc930000,0xc1a10000,0xcf020000,0xb57b0028,0x97b5021e,0xe8038fcd,0x0528ed57,0xc1769e2c},
	{0xddb90000,0x7ad80000,0x0de80000,0xa84a0033,0x14bc00cf,0xa142000d,0x62d92a39,0xd8b59d10,0xd1cf0000,0xa87c0000,0x6f5b0000,0xbaa30022,0x5a240226,0x15e3ff6e,0xd1c18eb6,0x14540cc6},
	{0xc6eb0000,0x90120000,0x6f320000,0x9b0d003c,0x10d701ee,0xd4c26e6c,0xa41836ed,0x69337b66,0xf64b0000,0x6fd70000,0x9dd50000,0x186f0024,0x36c500a2,0x51da4c9d,0xd827b628,0x6622d709},
	{0xfa3d0000,0xbd730000,0xff660000,0x0a860035,0x785d024b,0xe57bb3fe,0x6b3f12a7,0xaac346df,0xed190000,0x851d0000,0xff0f0000,0x2b28002b,0x32ae0183,0x245a22fc,0x1ee6aafc,0xd7a4317f},
	{0xe16f0000,0x57b90000,0x9dbc0000,0x39c1003a,0x7c36036a,0x90fbdd9f,0xadfe0e73,0x1b45a0a9,0xca9d0000,0x42b60000,0x0d810000,0x89e4002d,0x5e4f0307,0x6063910f,0x17009262,0xa5d2eab0},
	{0x94d50000,0x22620000,0xea4f0000,0xf3b80021,0x5b910006,0xe62dcaea,0xb575eced,0x4d6d25ee,0x9ead0000,0x73d10000,0x4a7f0000,0xddce0035,0xdcf303f6,0xdaec2b4b,0x14453757,0xe528c0a4},
	{0x8f870000,0xc8a80000,0x88950000,0xc0ff002e,0x5ffa0127,0x93ada48b,0x73b4f039,0xfcebc398,0xb9290000,0xb47a0000,0xb8f10000,0x7f020033,0xb0120172,0x9ed598b8,0x1da30fc9,0x975e1b6b},
	{0xb3510000,0xe5c90000,0x18c10000,0x51740027,0x37700282,0xa2147919,0xbc93d473,0x3f1bfe21,0xa27b0000,0x5eb00000,0xda2b0000,0x4c45003c,0xb4790053,0xeb55f6d9,0xdb62131d,0x26d8fd1d},
	{0xa8030000,0x0f030000,0x7a1b0000,0x62330028,0x331b03a3,0xd7941778,0x7a52c8a7,0x8e9d1857,0x85ff0000,0x991b0000,0x28a50000,0xee89003a,0xd89802d7,0xaf6c452a,0xd2842b83,0x54ae26d2},
	{0xdbb70000,0xf9cf0000,0xcf6b0000,0x94d50036,0xdd4601d6,0x29221ecf,0x70f1550c,0xbc11e98c,0x98a30000,0xf0c60000,0x88fc0000,0xe1510030,0x150902ef,0x528c3589,0x066d4862,0x818cb438},
	{0xc0e50000,0x13050000,0xadb10000,0xa7920039,0xd92d00f7,0x5ca270ae,0xb63049d8,0x0d970ffa,0xbf270000,0x376d0000,0x7a720000,0x439d0036,0x79e8006b,0x16b5867a,0x0f8b70fc,0xf3fa6ff7},
	{0xfc330000,0x3e640000,0x3de50000,0x36190030,0xb1a70352,0x6d1bad3c,0x79176d92,0xce673243,0xa4750000,0xdda70000,0x18a80000,0x70da0039,0x7d83014a,0x6335e81b,0xc94a6c28,0x427c8981},
	{0xe7610000,0xd4ae0000,0x5f3f0000,0x055e003f,0xb5cc0273,0x189bc35d,0xbfd67146,0x7fe1d435,0x83f10000,0x1a0c0000,0xea260000,0xd216003f,0x116203ce,0x270c5be8,0xc0ac54b6,0x300a524e},
	{0x97600000,0x6fcf0000,0x5e270000,0x97c303c0,0x9a28030c,0x49be368a,0x869e47b5,0x76dd3fa7,0x850c0000,0x9ff90000,0xe91d0000,0x7ae70180,0x617a039e,0xa27b70b9,0x490f82ab,0xc9d1e6d2},
	{0x8c320000,0x85050000,0x3cfd0000,0xa48403cf,0x9e43022d,0x3c3e58eb,0x405f5b61,0xc75bd9d1,0xa2880000,0x58520000,0x1b930000,0xd82b0186,0x0d9b011a,0xe642c34a,0x40e9ba35,0xbba73d1d},
	{0xb0e40000,0xa8640000,0xaca90000,0x350f03c6,0xf6c90188,0x0d878579,0x8f787f2b,0x04abe468,0xb9da0000,0xb2980000,0x79490000,0xeb6c0189,0x09f0003b,0x93c2ad2b,0x8628a6e1,0x0a21db6b},
	{0xabb60000,0x42ae0000,0xce730000,0x064803c9,0xf2a200a9,0x7807eb18,0x49b963ff,0xb52d021e,0x9e5e0000,0x75330000,0x8bc70000,0x49a0018f,0x651102bf,0xd7fb1ed8,0x8fce9e7f,0x785700a4},
	{0xd8020000,0xb4620000,0x7b030000,0xf0ae03d7,0x1cff02dc,0x86b1e2af,0x431afe54,0x87a1f3c5,0x83020000,0x1cee0000,0x2b9e0000,0x46780185,0xa8800287,0x2a1b6e7b,0x5b27fd9e,0xad75924e},
	{0xc3500000,0x5ea80000,0x19d90000,0xc3e903d8,0x189403fd,0xf3318cce,0x85dbe280,0x362715b3,0xa4860000,0xdb450000,0xd9100000,0xe4b40183,0xc4610003,0x6e22dd88,0x52c1c500,0xdf034981},
	{0xff860000,0x73c90000,0x898d0000,0x526203d1,0x701e0058,0xc288515c,0x4afcc6ca,0xf5d7280a,0xbfd40000,0x318f0000,0xbbca0000,0xd7f3018c,0xc00a0122,0x1ba2b3e9,0x9400d9d4,0x6e85aff7},
	{0xe4d40000,0x99030000,0xeb570000,0x612503de,0x74750179,0xb7083f3d,0x8c3dda1e,0x4451ce7c,0x98500000,0xf6240000,0x49440000,0x753f018a,0xaceb03a6,0x5f9b001a,0x9de6e14a,0x1cf37438},
	{0x916e0000,0xecd80000,0x9ca40000,0xab5c03c5,0x53d20215,0xc1de2848,0x94b63880,0x12794b3b,0xcc600000,0xc7430000,0x0eba0000,0x21150192,0x2e570357,0xe514ba5e,0x9ea3447f,0x5c095e2c},
	{0x8a3c0000,0x06120000,0xfe7e0000,0x981b03ca,0x57b90334,0xb45e4629,0x52772454,0xa3ffad4d,0xebe40000,0x00e80000,0xfc340000,0x83d90194,0x42b601d3,0xa12d09ad,0x97457ce1,0x2e7f85e3},
	{0xb6ea0000,0x2b730000,0x6e2a0000,0x099003c3,0x3f330091,0x85e79bbb,0x9d50001e,0x600f90f4,0xf0b60000,0xea220000,0x9eee0000,0xb09e019b,0x46dd00f2,0xd4ad67cc,0x51846035,0x9ff96395},
	{0xadb80000,0xc1b90000,0x0cf00000,0x3ad703cc,0x3b5801b0,0xf067f5da,0x5b911cca,0xd1897682,0xd7320000,0x2d890000,0x6c600000,0x1252019d,0x2a3c0276,0x9094d43f,0x586258ab,0xed8fb85a},
	{0xde0c0000,0x37750000,0xb9800000,0xcc3103d2,0xd50503c5,0x0ed1fc6d,0x51328161,0xe3058759,0xca6e0000,0x44540000,0xcc390000,0x1d8a0197,0xe7ad024e,0x6d74a49c,0x8c8b3b4a,0x38ad2ab0},
	{0xc55e0000,0xddbf0000,0xdb5a0000,0xff7603dd,0xd16e02e4,0x7b51920c,0x97f39db5,0x5283612f,0xedea0000,0x83ff0000,0x3eb70000,0xbf460191,0x8b4c00ca,0x294d176f,0x856d03d4,0x4adbf17f},
	{0xf9880000,0xf0de0000,0x4b0e0000,0x6efd03d4,0xb9e40141,0x4ae84f9e,0x58d4b9ff,0x91735c96,0xf6b80000,0x69350000,0x5c6d0000,0x8c01019e,0x8f2701eb,0x5ccd790e,0x43ac1f00,0xfb5d1709},
	{0xe2da0000,0x1a140000,0x29d40000,0x5dba03db,0xbd8f0060,0x3f6821ff,0x9e15a52b,0x20f5bae0,0xd13c0000,0xae9e0000,0xaee30000,0x2ecd0198,0xe3c6036f,0x18f4cafd,0x4a4a279e,0x892bccc6},
	{0x40a10000,0x44a40000,0xf3ff0000,0x11ff03e7,0x09f60033,0xd43dd726,0x4577b636,0x062d47fd,0xc0160000,0x15e70000,0x6c090000,0x33fc0183,0x60cf01be,0x51b5453d,0x2dbbe0f0,0x90e8cffa},
	{0x5bf30000,0xae6e0000,0x91250000,0x22b803e8,0x0d9d0112,0xa1bdb947,0x83b6aae2,0xb7aba18b,0xe7920000,0xd24c0000,0x9e870000,0x91300185,0x0c2e033a,0x158cf6ce,0x245dd86e,0xe29e1435},
	{0x67250000,0x830f0000,0x01710000,0xb33303e1,0x651702b7,0x900464d5,0x4c918ea8,0x745b9c32,0xfcc00000,0x38860000,0xfc5d0000,0xa277018a,0x0845021b,0x600c98af,0xe29cc4ba,0x5318f243},
	{0x7c770000,0x69c50000,0x63ab0000,0x807403ee,0x617c0396,0xe5840ab4,0x8a50927c,0xc5dd7a44,0xdb440000,0xff2d0000,0x0ed30000,0x00bb018c,0x64a4009f,0x24352b5c,0xeb7afc24,0x216e298c},
	{0x0fc30000,0x9f090000,0xd6db0000,0x769203f0,0x8f2101e3,0x1b320303,0x80f30fd7,0xf7518b9f,0xc6180000,0x96f00000,0xae8a0000,0x0f630186,0xa93500a7,0xd9d55bff,0x3f939fc5,0xf44cbb66},
	{0x14910000,0x75c30000,0xb4010000,0x45d503ff,0x8b4a00c2,0x6eb26d62,0x46321303,0x46d76de9,0xe19c0000,0x515b0000,0x5c040000,0xadaf0180,0xc5d40223,0x9dece80c,0x3675a75b,0x863a60a9},
	{0x28470000,0x58a20000,0x24550000,0xd45e03f6,0xe3c00367,0x5f0bb0f0,0x89153749,0x85275050,0xface0000,0xbb910000,0x3ede0000,0x9ee8018f,0xc1bf0302,0xe86c866d,0xf0b4bb8f,0x37bc86df},
	{0x33150000,0xb2680000,0x468f0000,0xe71903f9,0xe7ab0246,0x2a8bde91,0x4fd42b9d,0x34a1b626,0xdd4a0000,0x7c3a0000,0xcc500000,0x3c240189,0xad5e0186,0xac55359e,0xf9528311,0x45ca5d10},
	{0x46af0000,0xc7b30000,0x317c0000,0x2d6003e2,0xc00c012a,0x5c5dc9e4,0x575fc903,0x62893361,0x897a0000,0x4d5d0000,0x8bae0000,0x680e0191,0x2fe20177,0x16da8fda,0xfa172624,0x05307704},
	{0x5dfd0000,0x2d790000,0x53a60000,0x1e2703ed,0xc467000b,0x29dda785,0x919ed5d7,0xd30fd517,0xaefe0000,0x8af60000,0x79200000,0xcac20197,0x430303f3,0x52e33c29,0xf3f11eba,0x7746accb},
	{0x612b0000,0x00180000,0xc3f20000,0x8fac03e4,0xaced03ae,0x18647a17,0x5eb9f19d,0x10ffe8ae,0xb5ac0000,0x603c0000,0x1bfa0000,0xf9850198,0x476802d2,0x27635248,0x3530026e,0xc6c04abd},
	{0x7a790000,0xead20000,0xa1280000,0xbceb03eb,0xa886028f,0x6de41476,0x9878ed49,0xa1790ed8,0x92280000,0xa7970000,0xe9740000,0x5b49019e,0x2b890056,0x635ae1bb,0x3cd63af0,0xb4b69172},
	{0x09cd0000,0x1c1e0000,0x14580000,0x4a0d03f5,0x46db00fa,0x93521dc1,0x92db70e2,0x93f5ff03,0x8f740000,0xce4a0000,0x492d0000,0x54910194,0xe618006e,0x9eba9118,0xe83f5911,0x61940398},
	{0x129f0000,0xf6d40000,0x76820000,0x794a03fa,0x42b001db,0xe6d273a0,0x541a6c36,0x22731975,0xa8f00000,0x09e10000,0xbba30000,0xf65d0192,0x8af902ea,0xda8322eb,0xe1d9618f,0x13e2d857},
	{0x2e490000,0xdbb50000,0xe6d60000,0xe8c103f3,0x2a3a027e,0xd76bae32,0x9b3d487c,0xe18324cc,0xb3a20000,0xe32b0000,0xd9790000,0xc51a019d,0x8e9203cb,0xaf034c8a,0x27187d5b,0xa2643e21},
	{0x351b0000,0x317f0000,0x840c0000,0xdb8603fc,0x2e51035f,0xa2ebc053,0x5dfc54a8,0x5005c2ba,0x94260000,0x24800000,0x2bf70000,0x67d6019b,0xe273014f,0xeb3aff79,0x2efe45c5,0xd012e5ee},
	{0xd27a0000,0xe5d10000,0xdb330000,0xded803c3,0x9b9d012c,0xba70030e,0xe22a25ee,0x2fe4168f,0x17d70000,0x3e8c0000,0xc1d10000,0xb5c001a4,0xf3110281,0xcc36a491,0xee521173,0xe018b7a0},
	{0xc9280000,0x0f1b0000,0xb9e90000,0xed9f03cc,0x9ff6000d,0xcff06d6f,0x24eb393a,0x9e62f0f9,0x30530000,0xf9270000,0x335f0000,0x170c01a2,0x9ff00005,0x880f1762,0xe7b429ed,0x926e6c6f},
	{0xf5fe0000,0x227a0000,0x29bd0000,0x7c1403c5,0xf77c03a8,0xfe49b0fd,0xebcc1d70,0x5d92cd40,0x2b010000,0x13ed0000,0x51850000,0x244b01ad,0x9b9b0124,0xfd8f7903,0x21753539,0x23e88a19},
	{0xeeac0000,0xc8b00000,0x4b670000,0x4f5303ca,0xf3170289,0x8bc9de9c,0x2d0d01a4,0xec142b36,0x0c850000,0xd4460000,0xa30b0000,0x868701ab,0xf77a03a0,0xb9b6caf0,0x28930da7,0x519e51d6},
	{0x9d180000,0x3e7c0000,0xfe170000,0xb9b503d4,0x1d4a00fc,0x757fd72b,0x27ae9c0f,0xde98daed,0x11d90000,0xbd9b0000,0x03520000,0x895f01a1,0x3aeb0398,0x4456ba53,0xfc7a6e46,0x84bcc33c},
	{0x864a0000,0xd4b60000,0x9ccd0000,0x8af203db,0x192101dd,0x00ffb94a,0xe16f80db,0x6f1e3c9b,0x365d0000,0x7a300000,0xf1dc0000,0x2b9301a7,0x560a011c,0x006f09a0,0xf59c56d8,0xf6ca18f3},
	{0xba9c0000,0xf9d70000,0x0c990000,0x1b7903d2,0x71ab0278,0x314664d8,0x2e48a491,0xacee0122,0x2d0f0000,0x90fa0000,0x93060000,0x18d401a8,0x5261003d,0x75ef67c1,0x335d4a0c,0x474cfe85},
	{0xa1ce0000,0x131d0000,0x6e430000,0x283e03dd,0x75c00359,0x44c60ab9,0xe889b845,0x1d68e754,0x0a8b0000,0x57510000,0x61880000,0xba1801ae,0x3e8002b9,0x31d6d432,0x3abb7292,0x353a254a},
	{0xd4740000,0x66c60000,0x19b00000,0xe24703c6,0x52670035,0x32101dcc,0xf0025adb,0x4b406213,0x5ebb0000,0x66360000,0x26760000,0xee3201b6,0xbc3c0248,0x8b596e76,0x39fed7a7,0x75c00f5e},
	{0xcf260000,0x8c0c0000,0x7b6a0000,0xd10003c9,0x560c0114,0x479073ad,0x36c3460f,0xfac68465,0x793f0000,0xa19d0000,0xd4f80000,0x4cfe01b0,0xd0dd00cc,0xcf60dd85,0x3018ef39,0x07b6d491},
	{0xf3f00000,0xa16d0000,0xeb3e0000,0x408b03c0,0x3e8602b1,0x7629ae3f,0xf9e46245,0x3936b9dc,0x626d0000,0x4b570000,0xb6220000,0x7fb901bf,0xd4b601ed,0xbae0b3e4,0xf6d9f3ed,0xb63032e7},
	{0xe8a20000,0x4ba70000,0x89e40000,0x73cc03cf,0x3aed0390,0x03a9c05e,0x3f257e91,0x88b05faa,0x45e90000,0x8cfc0000,0x44ac0000,0xdd7501b9,0xb8570369,0xfed90017,0xff3fcb73,0xc446e928},
	{0x9b160000,0xbd6b0000,0x3c940000,0x852a03d1,0xd4b001e5,0xfd1fc9e9,0x3586e33a,0xba3cae71,0x58b50000,0xe5210000,0xe4f50000,0xd2ad01b3,0x75c60351,0x033970b4,0x2bd6a892,0x11647bc2},
	{0x80440000,0x57a10000,0x5e4e0000,0xb66d03de,0xd0db00c4,0x889fa788,0xf347ffee,0x0bba4807,0x7f310000,0x228a0000,0x167b0000,0x706101b5,0x192701d5,0x4700c347,0x2230900c,0x6312a00d},
	{0xbc920000,0x7ac00000,0xce1a0000,0x27e603d7,0xb8510361,0xb9267a1a,0x3c60dba4,0xc84a75be,0x64630000,0xc8400000,0x74a10000,0x432601ba,0x1d4c00f4,0x3280ad26,0xe4f18cd8,0xd294467b},
	{0xa7c00000,0x900a0000,0xacc00000,0x14a103d8,0xbc3a0240,0xcca6147b,0xfaa1c770,0x79cc93c8,0x43e70000,0x0feb0000,0x862f0000,0xe1ea01bc,0x71ad0270,0x76b91ed5,0xed17b446,0xa0e29db4},
	{0x05bb0000,0xceba0000,0x76eb0000,0x58e403e4,0x08430213,0x27f3e2a2,0x21c3d46d,0x5f146ed5,0x52cd0000,0xb4920000,0x44c50000,0xfcdb01a7,0xf2a400a1,0x3ff89115,0x8ae67328,0xb9219e88},
	{0x1ee90000,0x24700000,0x14310000,0x6ba303eb,0x0c280332,0x52738cc3,0xe702c8b9,0xee9288a3,0x75490000,0x73390000,0xb64b0000,0x5e1701a1,0x9e450225,0x7bc122e6,0x83004bb6,0xcb574547},
	{0x223f0000,0x09110000,0x84650000,0xfa2803e2,0x64a20097,0x63ca5151,0x2825ecf3,0x2d62b51a,0x6e1b0000,0x99f30000,0xd4910000,0x6d5001ae,0x9a2e0304,0x0e414c87,0x45c15762,0x7ad1a331},
	{0x396d0000,0xe3db0000,0xe6bf0000,0xc96f03ed,0x60c901b6,0x164a3f30,0xeee4f027,0x9ce4536c,0x499f0000,0x5e580000,0x261f0000,0xcf9c01a8,0xf6cf0180,0x4a78ff74,0x4c276ffc,0x08a778fe},
	{0x4ad90000,0x15170000,0x53cf0000,0x3f8903f3,0x8e9403c3,0xe8fc3687,0xe4476d8c,0xae68a2b7,0x54c30000,0x37850000,0x86460000,0xc04401a2,0x3b5e01b8,0xb7988fd7,0x98ce0c1d,0xdd85ea14},
	{0x518b0000,0xffdd0000,0x31150000,0x0cce03fc,0x8aff02e2,0x9d7c58e6,0x22867158,0x1fee44c1,0x73470000,0xf02e0000,0x74c80000,0x628801a4,0x57bf033c,0xf3a13c24,0x91283483,0xaff331db},
	{0x6d5d0000,0xd2bc0000,0xa1410000,0x9d4503f5,0xe2750147,0xacc58574,0xeda15512,0xdc1e7978,0x68150000,0x1ae40000,0x16120000,0x51cf01ab,0x53d4021d,0x86215245,0x57e92857,0x1e75d7ad},
	{0x760f0000,0x38760000,0xc39b0000,0xae0203fa,0xe61e0066,0xd945eb15,0x2b6049c6,0x6d989f0e,0x4f910000,0xdd4f0000,0xe49c0000,0xf30301ad,0x3f350099,0xc218e1b6,0x5e0f10c9,0x6c030c62},
	{0x03b50000,0x4dad0000,0xb4680000,0x647b03e1,0xc1b9030a,0xaf93fc60,0x33ebab58,0x3bb01a49,0x1ba10000,0xec280000,0xa3620000,0xa72901b5,0xbd890068,0x78975bf2,0x5d4ab5fc,0x2cf92676},
	{0x18e70000,0xa7670000,0xd6b20000,0x573c03ee,0xc5d2022b,0xda139201,0xf52ab78c,0x8a36fc3f,0x3c250000,0x2b830000,0x51ec0000,0x05e501b3,0xd16802ec,0x3caee801,0x54ac8d62,0x5e8ffdb9},
	{0x24310000,0x8a060000,0x46e60000,0xc6b703e7,0xad58018e,0xebaa4f93,0x3a0d93c6,0x49c6c186,0x27770000,0xc1490000,0x33360000,0x36a201bc,0xd50303cd,0x492e8660,0x926d91b6,0xef091bcf},
	{0x3f630000,0x60cc0000,0x243c0000,0xf5f003e8,0xa93300af,0x9e2a21f2,0xfccc8f12,0xf84027f0,0x00f30000,0x06e20000,0xc1b80000,0x946e01ba,0xb9e20149,0x0d173593,0x9b8ba928,0x9d7fc000},
	{0x4cd70000,0x96000000,0x914c0000,0x031603f6,0x476e02da,0x609c2845,0xf66f12b9,0xcaccd62b,0x1daf0000,0x6f3f0000,0x61e10000,0x9bb601b0,0x74730171,0xf0f74530,0x4f62cac9,0x485d52ea},
	{0x57850000,0x7cca0000,0xf3960000,0x305103f9,0x430503fb,0x151c4624,0x30ae0e6d,0x7b4a305d,0x3a2b0000,0xa8940000,0x936f0000,0x397a01b6,0x189203f5,0xb4cef6c3,0x4684f257,0x3a2b8925},
	{0x6b530000,0x51ab0000,0x63c20000,0xa1da03f0,0x2b8f005e,0x24a59bb6,0xff892a27,0xb8ba0de4,0x21790000,0x425e0000,0xf1b50000,0x0a3d01b9,0x1cf902d4,0xc14e98a2,0x8045ee83,0x8bad6f53},
	{0x70010000,0xbb610000,0x01180000,0x929d03ff,0x2fe4017f,0x5125f5d7,0x394836f3,0x093ceb92,0x06fd0000,0x85f50000,0x033b0000,0xa8f101bf,0x70180050,0x85772b51,0x89a3d61d,0xf9dbb49c},
	{0x850c0000,0x9ff90000,0xe91d0000,0x7ae70180,0x617a039e,0xa27b70b9,0x490f82ab,0xc9d1e6d2,0x126c0000,0xf0360000,0xb73a0000,0xed240240,0xfb520092,0xebc54633,0xcf91c51e,0xbf0cd975},
	{0x9e5e0000,0x75330000,0x8bc70000,0x49a0018f,0x651102bf,0xd7fb1ed8,0x8fce9e7f,0x785700a4,0x35e80000,0x379d0000,0x45b40000,0x4fe80246,0x97b30216,0xaffcf5c0,0xc677fd80,0xcd7a02ba},
	{0xa2880000,0x58520000,0x1b930000,0xd82b0186,0x0d9b011a,0xe642c34a,0x40e9ba35,0xbba73d1d,0x2eba0000,0xdd570000,0x276e0000,0x7caf0249,0x93d80337,0xda7c9ba1,0x00b6e154,0x7cfce4cc},
	{0xb9da0000,0xb2980000,0x79490000,0xeb6c0189,0x09f0003b,0x93c2ad2b,0x8628a6e1,0x0a21db6b,0x093e0000,0x1afc0000,0xd5e00000,0xde63024f,0xff3901b3,0x9e452852,0x0950d9ca,0x0e8a3f03},
	{0xca6e0000,0x44540000,0xcc390000,0x1d8a0197,0xe7ad024e,0x6d74a49c,0x8c8b3b4a,0x38ad2ab0,0x14620000,0x73210000,0x75b90000,0xd1bb0245,0x32a8018b,0x63a558f1,0xddb9ba2b,0xdba8ade9},
	{0xd13c0000,0xae9e0000,0xaee30000,0x2ecd0198,0xe3c6036f,0x18f4cafd,0x4a4a279e,0x892bccc6,0x33e60000,0xb48a0000,0x87370000,0x73770243,0x5e49030f,0x279ceb02,0xd45f82b5,0xa9de7626},
	{0xedea0000,0x83ff0000,0x3eb70000,0xbf460191,0x8b4c00ca,0x294d176f,0x856d03d4,0x4adbf17f,0x28b40000,0x5e400000,0xe5ed0000,0x4030024c,0x5a22022e,0x521c8563,0x129e9e61,0x18589050},
	{0xf6b80000,0x69350000,0x5c6d0000,0x8c01019e,0x8f2701eb,0x5ccd790e,0x43ac1f00,0xfb5d1709,0x0f300000,0x99eb0000,0x17630000,0xe2fc024a,0x36c300aa,0x16253690,0x1b78a6ff,0x6a2e4b9f},
	{0x83020000,0x1cee0000,0x2b9e0000,0x46780185,0xa8800287,0x2a1b6e7b,0x5b27fd9e,0xad75924e,0x5b000000,0xa88c0000,0x509d0000,0xb6d60252,0xb47f005b,0xacaa8cd4,0x183d03ca,0x2ad4618b},
	{0x98500000,0xf6240000,0x49440000,0x753f018a,0xaceb03a6,0x5f9b001a,0x9de6e14a,0x1cf37438,0x7c840000,0x6f270000,0xa2130000,0x141a0254,0xd89e02df,0xe8933f27,0x11db3b54,0x58a2ba44},
	{0xa4860000,0xdb450000,0xd9100000,0xe4b40183,0xc4610003,0x6e22dd88,0x52c1c500,0xdf034981,0x67d60000,0x85ed0000,0xc0c90000,0x275d025b,0xdcf503fe,0x9d135146,0xd71a2780,0xe9245c32},
	{0xbfd40000,0x318f0000,0xbbca0000,0xd7f3018c,0xc00a0122,0x1ba2b3e9,0x9400d9d4,0x6e85aff7,0x40520000,0x42460000,0x32470000,0x8591025d,0xb014017a,0xd92ae2b5,0xdefc1f1e,0x9b5287fd},
	{0xcc600000,0xc7430000,0x0eba0000,0x21150192,0x2e570357,0xe514ba5e,0x9ea3447f,0x5c095e2c,0x5d0e0000,0x2b9b0000,0x921e0000,0x8a490257,0x7d850142,0x24ca9216,0x0a157cff,0x4e701517},
	{0xd7320000,0x2d890000,0x6c600000,0x1252019d,0x2a3c0276,0x9094d43f,0x586258ab,0xed8fb85a,0x7a8a0000,0xec300000,0x60900000,0x28850251,0x116403c6,0x60f321e5,0x03f34461,0x3c06ced8},
	{0xebe40000,0x00e80000,0xfc340000,0x83d90194,0x42b601d3,0xa12d09ad,0x97457ce1,0x2e7f85e3,0x61d80000,0x06fa0000,0x024a0000,0x1bc2025e,0x150f02e7,0x15734f84,0xc53258b5,0x8d8028ae},
	{0xf0b60000,0xea220000,0x9eee0000,0xb09e019b,0x46dd00f2,0xd4ad67cc,0x51846035,0x9ff96395,0x465c0000,0xc1510000,0xf0c40000,0xb90e0258,0x79ee0063,0x514afc77,0xccd4602b,0xfff6f361},
	{0x52cd0000,0xb4920000,0x44c50000,0xfcdb01a7,0xf2a400a1,0x3ff89115,0x8ae67328,0xb9219e88,0x57760000,0x7a280000,0x322e0000,0xa43f0243,0xfae702b2,0x180b73b7,0xab25a745,0xe635f05d},
	{0x499f0000,0x5e580000,0x261f0000,0xcf9c01a8,0xf6cf0180,0x4a78ff74,0x4c276ffc,0x08a778fe,0x70f20000,0xbd830000,0xc0a00000,0x06f30245,0x96060036,0x5c32c044,0xa2c39fdb,0x94432b92},
	{0x75490000,0x73390000,0xb64b0000,0x5e1701a1,0x9e450225,0x7bc122e6,0x83004bb6,0xcb574547,0x6ba00000,0x57490000,0xa27a0000,0x35b4024a,0x926d0117,0x29b2ae25,0x6402830f,0x25c5cde4},
	{0x6e1b0000,0x99f30000,0xd4910000,0x6d5001ae,0x9a2e0304,0x0e414c87,0x45c15762,0x7ad1a331,0x4c240000,0x90e20000,0x50f40000,0x9778024c,0xfe8c0393,0x6d8b1dd6,0x6de4bb91,0x57b3162b},
	{0x1daf0000,0x6f3f0000,0x61e10000,0x9bb601b0,0x74730171,0xf0f74530,0x4f62cac9,0x485d52ea,0x51780000,0xf93f0000,0xf0ad0000,0x98a00246,0x331d03ab,0x906b6d75,0xb90dd870,0x829184c1},
	{0x06fd0000,0x85f50000,0x033b0000,0xa8f101bf,0x70180050,0x85772b51,0x89a3d61d,0xf9dbb49c,0x76fc0000,0x3e940000,0x02230000,0x3a6c0240,0x5ffc012f,0xd452de86,0xb0ebe0ee,0xf0e75f0e},
	{0x3a2b0000,0xa8940000,0x936f0000,0x397a01b6,0x189203f5,0xb4cef6c3,0x4684f257,0x3a2b8925,0x6dae0000,0xd45e0000,0x60f90000,0x092b024f,0x5b97000e,0xa1d2b0e7,0x762afc3a,0x4161b978},
	{0x21790000,0x425e0000,0xf1b50000,0x0a3d01b9,0x1cf902d4,0xc14e98a2,0x8045ee83,0x8bad6f53,0x4a2a0000,0x13f50000,0x92770000,0xabe70249,0x3776028a,0xe5eb0314,0x7fccc4a4,0x331762b7},
	{0x54c30000,0x37850000,0x86460000,0xc04401a2,0x3b5e01b8,0xb7988fd7,0x98ce0c1d,0xdd85ea14,0x1e1a0000,0x22920000,0xd5890000,0xffcd0251,0xb5ca027b,0x5f64b950,0x7c896191,0x73ed48a3},
	{0x4f910000,0xdd4f0000,0xe49c0000,0xf30301ad,0x3f350099,0xc218e1b6,0x5e0f10c9,0x6c030c62,0x399e0000,0xe5390000,0x27070000,0x5d010257,0xd92b00ff,0x1b5d0aa3,0x756f590f,0x019b936c},
	{0x73470000,0xf02e0000,0x74c80000,0x628801a4,0x57bf033c,0xf3a13c24,0x91283483,0xaff331db,0x22cc0000,0x0ff30000,0x45dd0000,0x6e460258,0xdd4001de,0x6edd64c2,0xb3ae45db,0xb01d751a},
	{0x68150000,0x1ae40000,0x16120000,0x51cf01ab,0x53d4021d,0x86215245,0x57e92857,0x1e75d7ad,0x05480000,0xc8580000,0xb7530000,0xcc8a025e,0xb1a1035a,0x2ae4d731,0xba487d45,0xc26baed5},
	{0x1ba10000,0xec280000,0xa3620000,0xa72901b5,0xbd890068,0x78975bf2,0x5d4ab5fc,0x2cf92676,0x18140000,0xa1850000,0x170a0000,0xc3520254,0x7c300362,0xd704a792,0x6ea11ea4,0x17493c3f},
	{0x00f30000,0x06e20000,0xc1b80000,0x946e01ba,0xb9e20149,0x0d173593,0x9b8ba928,0x9d7fc000,0x3f900000,0x662e0000,0xe5840000,0x619e0252,0x10d101e6,0x933d1461,0x6747263a,0x653fe7f0},
	{0x3c250000,0x2b830000,0x51ec0000,0x05e501b3,0xd16802ec,0x3caee801,0x54ac8d62,0x5e8ffdb9,0x24c20000,0x8ce40000,0x875e0000,0x52d9025d,0x14ba00c7,0xe6bd7a00,0xa1863aee,0xd4b90186},
	{0x27770000,0xc1490000,0x33360000,0x36a201bc,0xd50303cd,0x492e8660,0x926d91b6,0xef091bcf,0x03460000,0x4b4f0000,0x75d00000,0xf015025b,0x785b0243,0xa284c9f3,0xa8600270,0xa6cfda49},
	{0xc0160000,0x15e70000,0x6c090000,0x33fc0183,0x60cf01be,0x51b5453d,0x2dbbe0f0,0x90e8cffa,0x80b70000,0x51430000,0x9ff60000,0x22030264,0x6939018d,0x8588921b,0x68cc56c6,0x96c58807},
	{0xdb440000,0xff2d0000,0x0ed30000,0x00bb018c,0x64a4009f,0x24352b5c,0xeb7afc24,0x216e298c,0xa7330000,0x96e80000,0x6d780000,0x80cf0262,0x05d80309,0xc1b121e8,0x612a6e58,0xe4b353c8},
	{0xe7920000,0xd24c0000,0x9e870000,0x91300185,0x0c2e033a,0x158cf6ce,0x245dd86e,0xe29e1435,0xbc610000,0x7c220000,0x0fa20000,0xb388026d,0x01b30228,0xb4314f89,0xa7eb728c,0x5535b5be},
	{0xfcc00000,0x38860000,0xfc5d0000,0xa277018a,0x0845021b,0x600c98af,0xe29cc4ba,0x5318f243,0x9be50000,0xbb890000,0xfd2c0000,0x1144026b,0x6d5200ac,0xf008fc7a,0xae0d4a12,0x27436e71},
	{0x8f740000,0xce4a0000,0x492d0000,0x54910194,0xe618006e,0x9eba9118,0xe83f5911,0x61940398,0x86b90000,0xd2540000,0x5d750000,0x1e9c0261,0xa0c30094,0x0de88cd9,0x7ae429f3,0xf261fc9b},
	{0x94260000,0x24800000,0x2bf70000,0x67d6019b,0xe273014f,0xeb3aff79,0x2efe45c5,0xd012e5ee,0xa13d0000,0x15ff0000,0xaffb0000,0xbc500267,0xcc220210,0x49d13f2a,0x7302116d,0x80172754},
	{0xa8f00000,0x09e10000,0xbba30000,0xf65d0192,0x8af902ea,0xda8322eb,0xe1d9618f,0x13e2d857,0xba6f0000,0xff350000,0xcd210000,0x8f170268,0xc8490331,0x3c51514b,0xb5c30db9,0x3191c122},
	{0xb3a20000,0xe32b0000,0xd9790000,0xc51a019d,0x8e9203cb,0xaf034c8a,0x27187d5b,0xa2643e21,0x9deb0000,0x389e0000,0x3faf0000,0x2ddb026e,0xa4a801b5,0x7868e2b8,0xbc253527,0x43e71aed},
	{0xc6180000,0x96f00000,0xae8a0000,0x0f630186,0xa93500a7,0xd9d55bff,0x3f939fc5,0xf44cbb66,0xc9db0000,0x09f90000,0x78510000,0x79f10276,0x26140144,0xc2e758fc,0xbf609012,0x031d30f9},
	{0xdd4a0000,0x7c3a0000,0xcc500000,0x3c240189,0xad5e0186,0xac55359e,0xf9528311,0x45ca5d10,0xee5f0000,0xce520000,0x8adf0000,0xdb3d0270,0x4af503c0,0x86deeb0f,0xb686a88c,0x716beb36},
	{0xe19c0000,0x515b0000,0x5c040000,0xadaf0180,0xc5d40223,0x9dece80c,0x3675a75b,0x863a60a9,0xf50d0000,0x24980000,0xe8050000,0xe87a027f,0x4e9e02e1,0xf35e856e,0x7047b458,0xc0ed0d40},
	{0xface0000,0xbb910000,0x3ede0000,0x9ee8018f,0xc1bf0302,0xe86c866d,0xf0b4bb8f,0x37bc86df,0xd2890000,0xe3330000,0x1a8b0000,0x4ab60279,0x227f0065,0xb767369d,0x79a18cc6,0xb29bd68f},
	{0x897a0000,0x4d5d0000,0x8bae0000,0x680e0191,0x2fe20177,0x16da8fda,0xfa172624,0x05307704,0xcfd50000,0x8aee0000,0xbad20000,0x456e0273,0xefee005d,0x4a87463e,0xad48ef27,0x67b94465},
	{0x92280000,0xa7970000,0xe9740000,0x5b49019e,0x2b890056,0x635ae1bb,0x3cd63af0,0xb4b69172,0xe8510000,0x4d450000,0x485c0000,0xe7a20275,0x830f02d9,0x0ebef5cd,0xa4aed7b9,0x15cf9faa},
	{0xaefe0000,0x8af60000,0x79200000,0xcac20197,0x430303f3,0x52e33c29,0xf3f11eba,0x7746accb,0xf3030000,0xa78f0000,0x2a860000,0xd4e5027a,0x876403f8,0x7b3e9bac,0x626fcb6d,0xa44979dc},
	{0xb5ac0000,0x603c0000,0x1bfa0000,0xf9850198,0x476802d2,0x27635248,0x3530026e,0xc6c04abd,0xd4870000,0x60240000,0xd8080000,0x7629027c,0xeb85017c,0x3f07285f,0x6b89f3f3,0xd63fa213},
	{0x17d70000,0x3e8c0000,0xc1d10000,0xb5c001a4,0xf3110281,0xcc36a491,0xee521173,0xe018b7a0,0xc5ad0000,0xdb5d0000,0x1ae20000,0x6b180267,0x688c03ad,0x7646a79f,0x0c78349d,0xcffca12f},
	{0x0c850000,0xd4460000,0xa30b0000,0x868701ab,0xf77a03a0,0xb9b6caf0,0x28930da7,0x519e51d6,0xe2290000,0x1cf60000,0xe86c0000,0xc9d40261,0x046d0129,0x327f146c,0x059e0c03,0xbd8a7ae0},
	{0x30530000,0xf9270000,0x335f0000,0x170c01a2,0x9ff00005,0x880f1762,0xe7b429ed,0x926e6c6f,0xf97b0000,0xf63c0000,0x8ab60000,0xfa93026e,0x00060008,0x47ff7a0d,0xc35f10d7,0x0c0c9c96},
	{0x2b010000,0x13ed0000,0x51850000,0x244b01ad,0x9b9b0124,0xfd8f7903,0x21753539,0x23e88a19,0xdeff0000,0x31970000,0x78380000,0x585f0268,0x6ce7028c,0x03c6c9fe,0xcab92849,0x7e7a4759},
	{0x58b50000,0xe5210000,0xe4f50000,0xd2ad01b3,0x75c60351,0x033970b4,0x2bd6a892,0x11647bc2,0xc3a30000,0x584a0000,0xd8610000,0x57870262,0xa17602b4,0xfe26b95d,0x1e504ba8,0xab58d5b3},
	{0x43e70000,0x0feb0000,0x862f0000,0xe1ea01bc,0x71ad0270,0x76b91ed5,0xed17b446,0xa0e29db4,0xe4270000,0x9fe10000,0x2aef0000,0xf54b0264,0xcd970030,0xba1f0aae,0x17b67336,0xd92e0e7c},
	{0x7f310000,0x228a0000,0x167b0000,0x706101b5,0x192701d5,0x4700c347,0x2230900c,0x6312a00d,0xff750000,0x752b0000,0x48350000,0xc60c026b,0xc9fc0111,0xcf9f64cf,0xd1776fe2,0x68a8e80a},
	{0x64630000,0xc8400000,0x74a10000,0x432601ba,0x1d4c00f4,0x3280ad26,0xe4f18cd8,0xd294467b,0xd8f10000,0xb2800000,0xbabb0000,0x64c0026d,0xa51d0395,0x8ba6d73c,0xd891577c,0x1ade33c5},
	{0x11d90000,0xbd9b0000,0x03520000,0x895f01a1,0x3aeb0398,0x4456ba53,0xfc7a6e46,0x84bcc33c,0x8cc10000,0x83e70000,0xfd450000,0x30ea0275,0x27a10364,0x31296d78,0xdbd4f249,0x5a2419d1},
	{0x0a8b0000,0x57510000,0x61880000,0xba1801ae,0x3e8002b9,0x31d6d432,0x3abb7292,0x353a254a,0xab450000,0x444c0000,0x0fcb0000,0x92260273,0x4b4001e0,0x7510de8b,0xd232cad7,0x2852c21e},
	{0x365d0000,0x7a300000,0xf1dc0000,0x2b9301a7,0x560a011c,0x006f09a0,0xf59c56d8,0xf6ca18f3,0xb0170000,0xae860000,0x6d110000,0xa161027c,0x4f2b00c1,0x0090b0ea,0x14f3d603,0x99d42468},
	{0x2d0f0000,0x90fa0000,0x93060000,0x18d401a8,0x5261003d,0x75ef67c1,0x335d4a0c,0x474cfe85,0x97930000,0x692d0000,0x9f9f0000,0x03ad027a,0x23ca0245,0x44a90319,0x1d15ee9d,0xeba2ffa7},
	{0x5ebb0000,0x66360000,0x26760000,0xee3201b6,0xbc3c0248,0x8b596e76,0x39fed7a7,0x75c00f5e,0x8acf0000,0x00f00000,0x3fc60000,0x0c750270,0xee5b027d,0xb94973ba,0xc9fc8d7c,0x3e806d4d},
	{0x45e90000,0x8cfc0000,0x44ac0000,0xdd7501b9,0xb8570369,0xfed90017,0xff3fcb73,0xc446e928,0xad4b0000,0xc75b0000,0xcd480000,0xaeb90276,0x82ba00f9,0xfd70c049,0xc01ab5e2,0x4cf6b682},
	{0x793f0000,0xa19d0000,0xd4f80000,0x4cfe01b0,0xd0dd00cc,0xcf60dd85,0x3018ef39,0x07b6d491,0xb6190000,0x2d910000,0xaf920000,0x9dfe0279,0x86d101d8,0x88f0ae28,0x06dba936,0xfd7050f4},
	{0x626d0000,0x4b570000,0xb6220000,0x7fb901bf,0xd4b601ed,0xbae0b3e4,0xf6d9f3ed,0xb63032e7,0x919d0000,0xea3a0000,0x5d1c0000,0x3f32027f,0xea30035c,0xccc91ddb,0x0f3d91a8,0x8f068b3b},
	{0x126c0000,0xf0360000,0xb73a0000,0xed240240,0xfb520092,0xebc54633,0xcf91c51e,0xbf0cd975,0x97600000,0x6fcf0000,0x5e270000,0x97c303c0,0x9a28030c,0x49be368a,0x869e47b5,0x76dd3fa7},
	{0x093e0000,0x1afc0000,0xd5e00000,0xde63024f,0xff3901b3,0x9e452852,0x0950d9ca,0x0e8a3f03,0xb0e40000,0xa8640000,0xaca90000,0x350f03c6,0xf6c90188,0x0d878579,0x8f787f2b,0x04abe468},
	{0x35e80000,0x379d0000,0x45b40000,0x4fe80246,0x97b30216,0xaffcf5c0,0xc677fd80,0xcd7a02ba,0xabb60000,0x42ae0000,0xce730000,0x064803c9,0xf2a200a9,0x7807eb18,0x49b963ff,0xb52d021e},
	{0x2eba0000,0xdd570000,0x276e0000,0x7caf0249,0x93d80337,0xda7c9ba1,0x00b6e154,0x7cfce4cc,0x8c320000,0x85050000,0x3cfd0000,0xa48403cf,0x9e43022d,0x3c3e58eb,0x405f5b61,0xc75bd9d1},
	{0x5d0e0000,0x2b9b0000,0x921e0000,0x8a490257,0x7d850142,0x24ca9216,0x0a157cff,0x4e701517,0x916e0000,0xecd80000,0x9ca40000,0xab5c03c5,0x53d20215,0xc1de2848,0x94b63880,0x12794b3b},
	{0x465c0000,0xc1510000,0xf0c40000,0xb90e0258,0x79ee0063,0x514afc77,0xccd4602b,0xfff6f361,0xb6ea0000,0x2b730000,0x6e2a0000,0x099003c3,0x3f330091,0x85e79bbb,0x9d50001e,0x600f90f4},
	{0x7a8a0000,0xec300000,0x60900000,0x28850251,0x116403c6,0x60f321e5,0x03f34461,0x3c06ced8,0xadb80000,0xc1b90000,0x0cf00000,0x3ad703cc,0x3b5801b0,0xf067f5da,0x5b911cca,0xd1897682},
	{0x61d80000,0x06fa0000,0x024a0000,0x1bc2025e,0x150f02e7,0x15734f84,0xc53258b5,0x8d8028ae,0x8a3c0000,0x06120000,0xfe7e0000,0x981b03ca,0x57b90334,0xb45e4629,0x52772454,0xa3ffad4d},
	{0x14620000,0x73210000,0x75b90000,0xd1bb0245,0x32a8018b,0x63a558f1,0xddb9ba2b,0xdba8ade9,0xde0c0000,0x37750000,0xb9800000,0xcc3103d2,0xd50503c5,0x0ed1fc6d,0x51328161,0xe3058759},
	{0x0f300000,0x99eb0000,0x17630000,0xe2fc024a,0x36c300aa,0x16253690,0x1b78a6ff,0x6a2e4b9f,0xf9880000,0xf0de0000,0x4b0e0000,0x6efd03d4,0xb9e40141,0x4ae84f9e,0x58d4b9ff,0x91735c96},
	{0x33e60000,0xb48a0000,0x87370000,0x73770243,0x5e49030f,0x279ceb02,0xd45f82b5,0xa9de7626,0xe2da0000,0x1a140000,0x29d40000,0x5dba03db,0xbd8f0060,0x3f6821ff,0x9e15a52b,0x20f5bae0},
	{0x28b40000,0x5e400000,0xe5ed0000,0x4030024c,0x5a22022e,0x521c8563,0x129e9e61,0x18589050,0xc55e0000,0xddbf0000,0xdb5a0000,0xff7603dd,0xd16e02e4,0x7b51920c,0x97f39db5,0x5283612f},
	{0x5b000000,0xa88c0000,0x509d0000,0xb6d60252,0xb47f005b,0xacaa8cd4,0x183d03ca,0x2ad4618b,0xd8020000,0xb4620000,0x7b030000,0xf0ae03d7,0x1cff02dc,0x86b1e2af,0x431afe54,0x87a1f3c5},
	{0x40520000,0x42460000,0x32470000,0x8591025d,0xb014017a,0xd92ae2b5,0xdefc1f1e,0x9b5287fd,0xff860000,0x73c90000,0x898d0000,0x526203d1,0x701e0058,0xc288515c,0x4afcc6ca,0xf5d7280a},
	{0x7c840000,0x6f270000,0xa2130000,0x141a0254,0xd89e02df,0xe8933f27,0x11db3b54,0x58a2ba44,0xe4d40000,0x99030000,0xeb570000,0x612503de,0x74750179,0xb7083f3d,0x8c3dda1e,0x4451ce7c},
	{0x67d60000,0x85ed0000,0xc0c90000,0x275d025b,0xdcf503fe,0x9d135146,0xd71a2780,0xe9245c32,0xc3500000,0x5ea80000,0x19d90000,0xc3e903d8,0x189403fd,0xf3318cce,0x85dbe280,0x362715b3},
	{0xc5ad0000,0xdb5d0000,0x1ae20000,0x6b180267,0x688c03ad,0x7646a79f,0x0c78349d,0xcffca12f,0xd27a0000,0xe5d10000,0xdb330000,0xded803c3,0x9b9d012c,0xba70030e,0xe22a25ee,0x2fe4168f},
	{0xdeff0000,0x31970000,0x78380000,0x585f0268,0x6ce7028c,0x03c6c9fe,0xcab92849,0x7e7a4759,0xf5fe0000,0x227a0000,0x29bd0000,0x7c1403c5,0xf77c03a8,0xfe49b0fd,0xebcc1d70,0x5d92cd40},
	{0xe2290000,0x1cf60000,0xe86c0000,0xc9d40261,0x046d0129,0x327f146c,0x059e0c03,0xbd8a7ae0,0xeeac0000,0xc8b00000,0x4b670000,0x4f5303ca,0xf3170289,0x8bc9de9c,0x2d0d01a4,0xec142b36},
	{0xf97b0000,0xf63c0000,0x8ab60000,0xfa93026e,0x00060008,0x47ff7a0d,0xc35f10d7,0x0c0c9c96,0xc9280000,0x0f1b0000,0xb9e90000,0xed9f03cc,0x9ff6000d,0xcff06d6f,0x24eb393a,0x9e62f0f9},
	{0x8acf0000,0x00f00000,0x3fc60000,0x0c750270,0xee5b027d,0xb94973ba,0xc9fc8d7c,0x3e806d4d,0xd4740000,0x66c60000,0x19b00000,0xe24703c6,0x52670035,0x32101dcc,0xf0025adb,0x4b406213},
	{0x919d0000,0xea3a0000,0x5d1c0000,0x3f32027f,0xea30035c,0xccc91ddb,0x0f3d91a8,0x8f068b3b,0xf3f00000,0xa16d0000,0xeb3e0000,0x408b03c0,0x3e8602b1,0x7629ae3f,0xf9e46245,0x3936b9dc},
	{0xad4b0000,0xc75b0000,0xcd480000,0xaeb90276,0x82ba00f9,0xfd70c049,0xc01ab5e2,0x4cf6b682,0xe8a20000,0x4ba70000,0x89e40000,0x73cc03cf,0x3aed0390,0x03a9c05e,0x3f257e91,0x88b05faa},
	{0xb6190000,0x2d910000,0xaf920000,0x9dfe0279,0x86d101d8,0x88f0ae28,0x06dba936,0xfd7050f4,0xcf260000,0x8c0c0000,0x7b6a0000,0xd10003c9,0x560c0114,0x479073ad,0x36c3460f,0xfac68465},
	{0xc3a30000,0x584a0000,0xd8610000,0x57870262,0xa17602b4,0xfe26b95d,0x1e504ba8,0xab58d5b3,0x9b160000,0xbd6b0000,0x3c940000,0x852a03d1,0xd4b001e5,0xfd1fc9e9,0x3586e33a,0xba3cae71},
	{0xd8f10000,0xb2800000,0xbabb0000,0x64c0026d,0xa51d0395,0x8ba6d73c,0xd891577c,0x1ade33c5,0xbc920000,0x7ac00000,0xce1a0000,0x27e603d7,0xb8510361,0xb9267a1a,0x3c60dba4,0xc84a75be},
	{0xe4270000,0x9fe10000,0x2aef0000,0xf54b0264,0xcd970030,0xba1f0aae,0x17b67336,0xd92e0e7c,0xa7c00000,0x900a0000,0xacc00000,0x14a103d8,0xbc3a0240,0xcca6147b,0xfaa1c770,0x79cc93c8},
	{0xff750000,0x752b0000,0x48350000,0xc60c026b,0xc9fc0111,0xcf9f64cf,0xd1776fe2,0x68a8e80a,0x80440000,0x57a10000,0x5e4e0000,0xb66d03de,0xd0db00c4,0x889fa788,0xf347ffee,0x0bba4807},
	{0x8cc10000,0x83e70000,0xfd450000,0x30ea0275,0x27a10364,0x31296d78,0xdbd4f249,0x5a2419d1,0x9d180000,0x3e7c0000,0xfe170000,0xb9b503d4,0x1d4a00fc,0x757fd72b,0x27ae9c0f,0xde98daed},
	{0x97930000,0x692d0000,0x9f9f0000,0x03ad027a,0x23ca0245,0x44a90319,0x1d15ee9d,0xeba2ffa7,0xba9c0000,0xf9d70000,0x0c990000,0x1b7903d2,0x71ab0278,0x314664d8,0x2e48a491,0xacee0122},
	{0xab450000,0x444c0000,0x0fcb0000,0x92260273,0x4b4001e0,0x7510de8b,0xd232cad7,0x2852c21e,0xa1ce0000,0x131d0000,0x6e430000,0x283e03dd,0x75c00359,0x44c60ab9,0xe889b845,0x1d68e754},
	{0xb0170000,0xae860000,0x6d110000,0xa161027c,0x4f2b00c1,0x0090b0ea,0x14f3d603,0x99d42468,0x864a0000,0xd4b60000,0x9ccd0000,0x8af203db,0x192101dd,0x00ffb94a,0xe16f80db,0x6f1e3c9b},
	{0x57760000,0x7a280000,0x322e0000,0xa43f0243,0xfae702b2,0x180b73b7,0xab25a745,0xe635f05d,0x05bb0000,0xceba0000,0x76eb0000,0x58e403e4,0x08430213,0x27f3e2a2,0x21c3d46d,0x5f146ed5},
	{0x4c240000,0x90e20000,0x50f40000,0x9778024c,0xfe8c0393,0x6d8b1dd6,0x6de4bb91,0x57b3162b,0x223f0000,0x09110000,0x84650000,0xfa2803e2,0x64a20097,0x63ca5151,0x2825ecf3,0x2d62b51a},
	{0x70f20000,0xbd830000,0xc0a00000,0x06f30245,0x96060036,0x5c32c044,0xa2c39fdb,0x94432b92,0x396d0000,0xe3db0000,0xe6bf0000,0xc96f03ed,0x60c901b6,0x164a3f30,0xeee4f027,0x9ce4536c},
	{0x6ba00000,0x57490000,0xa27a0000,0x35b4024a,0x926d0117,0x29b2ae25,0x6402830f,0x25c5cde4,0x1ee90000,0x24700000,0x14310000,0x6ba303eb,0x0c280332,0x52738cc3,0xe702c8b9,0xee9288a3},
	{0x18140000,0xa1850000,0x170a0000,0xc3520254,0x7c300362,0xd704a792,0x6ea11ea4,0x17493c3f,0x03b50000,0x4dad0000,0xb4680000,0x647b03e1,0xc1b9030a,0xaf93fc60,0x33ebab58,0x3bb01a49},
	{0x03460000,0x4b4f0000,0x75d00000,0xf015025b,0x785b0243,0xa284c9f3,0xa8600270,0xa6cfda49,0x24310000,0x8a060000,0x46e60000,0xc6b703e7,0xad58018e,0xebaa4f93,0x3a0d93c6,0x49c6c186},
	{0x3f900000,0x662e0000,0xe5840000,0x619e0252,0x10d101e6,0x933d1461,0x6747263a,0x653fe7f0,0x3f630000,0x60cc0000,0x243c0000,0xf5f003e8,0xa93300af,0x9e2a21f2,0xfccc8f12,0xf84027f0},
	{0x24c20000,0x8ce40000,0x875e0000,0x52d9025d,0x14ba00c7,0xe6bd7a00,0xa1863aee,0xd4b90186,0x18e70000,0xa7670000,0xd6b20000,0x573c03ee,0xc5d2022b,0xda139201,0xf52ab78c,0x8a36fc3f},
	{0x51780000,0xf93f0000,0xf0ad0000,0x98a00246,0x331d03ab,0x906b6d75,0xb90dd870,0x829184c1,0x4cd70000,0x96000000,0x914c0000,0x031603f6,0x476e02da,0x609c2845,0xf66f12b9,0xcaccd62b},
	{0x4a2a0000,0x13f50000,0x92770000,0xabe70249,0x3776028a,0xe5eb0314,0x7fccc4a4,0x331762b7,0x6b530000,0x51ab0000,0x63c20000,0xa1da03f0,0x2b8f005e,0x24a59bb6,0xff892a27,0xb8ba0de4},
	{0x76fc0000,0x3e940000,0x02230000,0x3a6c0240,0x5ffc012f,0xd452de86,0xb0ebe0ee,0xf0e75f0e,0x70010000,0xbb610000,0x01180000,0x929d03ff,0x2fe4017f,0x5125f5d7,0x394836f3,0x093ceb92},
	{0x6dae0000,0xd45e0000,0x60f90000,0x092b024f,0x5b97000e,0xa1d2b0e7,0x762afc3a,0x4161b978,0x57850000,0x7cca0000,0xf3960000,0x305103f9,0x430503fb,0x151c4624,0x30ae0e6d,0x7b4a305d},
	{0x1e1a0000,0x22920000,0xd5890000,0xffcd0251,0xb5ca027b,0x5f64b950,0x7c896191,0x73ed48a3,0x4ad90000,0x15170000,0x53cf0000,0x3f8903f3,0x8e9403c3,0xe8fc3687,0xe4476d8c,0xae68a2b7},
	{0x05480000,0xc8580000,0xb7530000,0xcc8a025e,0xb1a1035a,0x2ae4d731,0xba487d45,0xc26baed5,0x6d5d0000,0xd2bc0000,0xa1410000,0x9d4503f5,0xe2750147,0xacc58574,0xeda15512,0xdc1e7978},
	{0x399e0000,0xe5390000,0x27070000,0x5d010257,0xd92b00ff,0x1b5d0aa3,0x756f590f,0x019b936c,0x760f0000,0x38760000,0xc39b0000,0xae0203fa,0xe61e0066,0xd945eb15,0x2b6049c6,0x6d989f0e},
	{0x22cc0000,0x0ff30000,0x45dd0000,0x6e460258,0xdd4001de,0x6edd64c2,0xb3ae45db,0xb01d751a,0x518b0000,0xffdd0000,0x31150000,0x0cce03fc,0x8aff02e2,0x9d7c58e6,0x22867158,0x1fee44c1},
	{0x80b70000,0x51430000,0x9ff60000,0x22030264,0x6939018d,0x8588921b,0x68cc56c6,0x96c58807,0x40a10000,0x44a40000,0xf3ff0000,0x11ff03e7,0x09f60033,0xd43dd726,0x4577b636,0x062d47fd},
	{0x9be50000,0xbb890000,0xfd2c0000,0x1144026b,0x6d5200ac,0xf008fc7a,0xae0d4a12,0x27436e71,0x67250000,0x830f0000,0x01710000,0xb33303e1,0x651702b7,0x900464d5,0x4c918ea8,0x745b9c32},
	{0xa7330000,0x96e80000,0x6d780000,0x80cf0262,0x05d80309,0xc1b121e8,0x612a6e58,0xe4b353c8,0x7c770000,0x69c50000,0x63ab0000,0x807403ee,0x617c0396,0xe5840ab4,0x8a50927c,0xc5dd7a44},
	{0xbc610000,0x7c220000,0x0fa20000,0xb388026d,0x01b30228,0xb4314f89,0xa7eb728c,0x5535b5be,0x5bf30000,0xae6e0000,0x91250000,0x22b803e8,0x0d9d0112,0xa1bdb947,0x83b6aae2,0xb7aba18b},
	{0xcfd50000,0x8aee0000,0xbad20000,0x456e0273,0xefee005d,0x4a87463e,0xad48ef27,0x67b94465,0x46af0000,0xc7b30000,0x317c0000,0x2d6003e2,0xc00c012a,0x5c5dc9e4,0x575fc903,0x62893361},
	{0xd4870000,0x60240000,0xd8080000,0x7629027c,0xeb85017c,0x3f07285f,0x6b89f3f3,0xd63fa213,0x612b0000,0x00180000,0xc3f20000,0x8fac03e4,0xaced03ae,0x18647a17,0x5eb9f19d,0x10ffe8ae},
	{0xe8510000,0x4d450000,0x485c0000,0xe7a20275,0x830f02d9,0x0ebef5cd,0xa4aed7b9,0x15cf9faa,0x7a790000,0xead20000,0xa1280000,0xbceb03eb,0xa886028f,0x6de41476,0x9878ed49,0xa1790ed8},
	{0xf3030000,0xa78f0000,0x2a860000,0xd4e5027a,0x876403f8,0x7b3e9bac,0x626fcb6d,0xa44979dc,0x5dfd0000,0x2d790000,0x53a60000,0x1e2703ed,0xc467000b,0x29dda785,0x919ed5d7,0xd30fd517},
	{0x86b90000,0xd2540000,0x5d750000,0x1e9c0261,0xa0c30094,0x0de88cd9,0x7ae429f3,0xf261fc9b,0x09cd0000,0x1c1e0000,0x14580000,0x4a0d03f5,0x46db00fa,0x93521dc1,0x92db70e2,0x93f5ff03},
	{0x9deb0000,0x389e0000,0x3faf0000,0x2ddb026e,0xa4a801b5,0x7868e2b8,0xbc253527,0x43e71aed,0x2e490000,0xdbb50000,0xe6d60000,0xe8c103f3,0x2a3a027e,0xd76bae32,0x9b3d487c,0xe18324cc},
	{0xa13d0000,0x15ff0000,0xaffb0000,0xbc500267,0xcc220210,0x49d13f2a,0x7302116d,0x80172754,0x351b0000,0x317f0000,0x840c0000,0xdb8603fc,0x2e51035f,0xa2ebc053,0x5dfc54a8,0x5005c2ba},
	{0xba6f0000,0xff350000,0xcd210000,0x8f170268,0xc8490331,0x3c51514b,0xb5c30db9,0x3191c122,0x129f0000,0xf6d40000,0x76820000,0x794a03fa,0x42b001db,0xe6d273a0,0x541a6c36,0x22731975},
	{0xc9db0000,0x09f90000,0x78510000,0x79f10276,0x26140144,0xc2e758fc,0xbf609012,0x031d30f9,0x0fc30000,0x9f090000,0xd6db0000,0x769203f0,0x8f2101e3,0x1b320303,0x80f30fd7,0xf7518b9f},
	{0xd2890000,0xe3330000,0x1a8b0000,0x4ab60279,0x227f0065,0xb767369d,0x79a18cc6,0xb29bd68f,0x28470000,0x58a20000,0x24550000,0xd45e03f6,0xe3c00367,0x5f0bb0f0,0x89153749,0x85275050},
	{0xee5f0000,0xce520000,0x8adf0000,0xdb3d0270,0x4af503c0,0x86deeb0f,0xb686a88c,0x716beb36,0x33150000,0xb2680000,0x468f0000,0xe71903f9,0xe7ab0246,0x2a8bde91,0x4fd42b9d,0x34a1b626},
	{0xf50d0000,0x24980000,0xe8050000,0xe87a027f,0x4e9e02e1,0xf35e856e,0x7047b458,0xc0ed0d40,0x14910000,0x75c30000,0xb4010000,0x45d503ff,0x8b4a00c2,0x6eb26d62,0x46321303,0x46d76de9}
    }
};
/* ===== */

/* ===== "hamsi.h" */
#define MOV(r,y) for (i = 0; i < arrlen; ++i) s[r][i] =  s[y][i];
#define XOR(r,y) for (i = 0; i < arrlen; ++i) s[r][i] ^= s[y][i];
#define  OR(r,y) for (i = 0; i < arrlen; ++i) s[r][i] |= s[y][i];
#define AND(r,y) for (i = 0; i < arrlen; ++i) s[r][i] &= s[y][i];
#define MOT(r,y) for (i = 0; i < arrlen; ++i) s[r][i] = ~s[y][i];
#define NOT(r)   for (i = 0; i < arrlen; ++i) s[r][i] = ~s[r][i];

// From "Speeding up Serpent", by Dag Arne Osvik, University of Bergen
#define SUBST(size,s)                   \
    do {                                \
        int i;                          \
        const int arrlen=(size/64);     \
        MOV(4,0);     AND(0,2);         \
        XOR(0,3);     XOR(2,1);         \
        XOR(2,0);      OR(3,4);         \
        XOR(3,1);     XOR(4,2);         \
\
        MOV(1,3);      OR(3,4);         \
        XOR(3,0);     AND(0,1);         \
        XOR(4,0);     XOR(1,3);         \
        XOR(1,4);     MOT(4,4);         \
\
        MOV(0,2);                       \
        MOV(2,1);                       \
        MOV(1,3);                       \
        MOV(3,4);                       \
    } while (0)

#define INLINE

static INLINE
void subst256(uint32_t s[5][4])
{
    SUBST(256,s);
}

static INLINE
void subst512(uint32_t s[5][8])
{
    SUBST(512,s);
}

static INLINE
void Mix(uint32_t * a, uint32_t * b, uint32_t * c, uint32_t * d)
{
    *a = ROTL32(*a,13);
    *c = ROTL32(*c,3);
    *b ^= *a ^ *c;
    *d ^= *c ^ (*a<<3);

    *b = ROTL32(*b,1);
    *d = ROTL32(*d,7);
    *a ^= *b ^ *d;
    *c ^= *d ^ (*b<<7);

    *a = ROTL32(*a,5);
    *c = ROTL32(*c,22);
}

#define L Mix
#define S(r,c) &s[r][c]
static INLINE
void diffuse256(uint32_t s[4][4])
{
    // const int line=4;
    L(S(0,0),S(1,1),S(2,2),S(3,3));
    L(S(0,1),S(1,2),S(2,3),S(3,0));
    L(S(0,2),S(1,3),S(2,0),S(3,1));
    L(S(0,3),S(1,0),S(2,1),S(3,2));
}

static INLINE void diffuse512(uint32_t s[4][8])
{
    // const int line=8;
    L(S(0,0),S(1,1),S(2,2),S(3,3));
    L(S(0,1),S(1,2),S(2,3),S(3,4));
    L(S(0,2),S(1,3),S(2,4),S(3,5));
    L(S(0,3),S(1,4),S(2,5),S(3,6));
    L(S(0,4),S(1,5),S(2,6),S(3,7));
    L(S(0,5),S(1,6),S(2,7),S(3,0));
    L(S(0,6),S(1,7),S(2,0),S(3,1));
    L(S(0,7),S(1,0),S(2,1),S(3,2));

    L(S(0,0),S(0,2),S(0,5),S(0,7));
    L(S(1,1),S(1,3),S(1,4),S(1,6));
    L(S(2,0),S(2,3),S(2,5),S(2,6));
    L(S(3,1),S(3,2),S(3,4),S(3,7));
}

// #define T1(j)       T256[4096*j+8*d[j]+i]
// #define T5(j)       T512[16384*j+16*d[j]+i]
#define T1(j)       T256[j][d[j]][i]
#define T5(j)       T512[j][d[j]][i]
#define Exp256(i) (T1(0)^T1(1)^T1(2)^T1(3))
#define Exp512(i) (T5(0)^T5(1)^T5(2)^T5(3))

static
int hash256(const int ROUNDS, uint32_t * cv, const uint8_t * d, int lastiter)
{
    const int arrlen = 4;
    uint32_t s[5][4];
    int i;

    // Concatenation
    for (i=0; i<8; ++i) {
        s[i/2][i%4] = Exp256(i);    // from message expansion
        s[i/2][(i+2)%4] = cv[i];    // from chain value
    }

    for (i = 0; i < ROUNDS; ++i) {
        int r,c;
        // Add Constants
        for (r = 0; r < 4; ++r)
	    for (c = 0; c < arrlen; ++c)
		s[r][c] ^= alpha[lastiter][r][c];
        s[0][1] ^= i;
        subst256(s);
        diffuse256(s);
    }

    // truncation
    for (i = 0; i < arrlen; ++i) {
	cv[i] ^= s[0][i];
	cv[i+arrlen] ^= s[2][i];
    }

    return 0;
}

static
int hash512(const int ROUNDS, uint32_t * cv, const uint8_t * d, int lastiter)
{
    const int arrlen=8;
    uint32_t s[5][8];
    int i;

    // Concatenation
    for (i=0; i<16; ++i) {
        s[i/4][(i%4)+2*((i/2)%2)+2*((i/4)%2)] = Exp512(i);    // from message expansion
        s[i/4][(i%4)+2*((i/2)%2)+2*(((i/4)+1)%2)] = cv[i];    // from chain value
    }

    for (i=0; i<ROUNDS; ++i) {
        int r,c;
        // Add Constants
        for (r=0; r<4; ++r) for (c=0; c<arrlen; ++c) s[r][c] ^= alpha[lastiter][r][c];
        s[0][1] ^= i;
        subst512(s);
        diffuse512(s);
    }

    // truncation
    for (i=0; i<arrlen; ++i) { cv[i] ^= s[0][i]; cv[i+arrlen] ^= s[2][i]; }

    return 0;
}
/* ===== */

int hamsiInit(hamsiParam *sp, int hashbitlen)
{
    int size = (hashbitlen <= 256) ? 1 : 2;

    sp->leftbits    = 0;
    sp->counter     = 0;
    sp->hashbitlen  = hashbitlen;
    sp->ROUNDS      = 3 * size;
    sp->PFROUNDS    = 6 * size;
    sp->cvsize      = 256 * size;

    switch (hashbitlen) {
    case 224:	memcpy(sp->state, iv224, 32);	break;
    case 256:	memcpy(sp->state, iv256, 32);	break;
    case 384:	memcpy(sp->state, iv384, 64);	break;
    case 512:	memcpy(sp->state, iv512, 64);	break;
    default:	return BAD_HASHBITLEN;	break;
    }

    memset(sp->leftdata, 0, 8);

    return SUCCESS;
}

int
hamsiReset(hamsiParam *sp)
{
    return hamsiInit(sp, sp->hashbitlen);
}

int hamsiUpdate(hamsiParam *sp, const byte *data, size_t size)
{
    uint64_t databitlen = 8 * size;
    int ret = SUCCESS;
    int bits2hash = databitlen;
    int i;
    const byte * block = data;
    const int s_blocksize = sp->cvsize/8;

    // Do first incomplete block
    if (sp->leftbits) {
        if ((sp->leftbits + bits2hash) < s_blocksize) {
            // just copy, update leftbits
            for (i = 0; i < (bits2hash+7)/8; ++i)
		sp->leftdata[(sp->leftbits/8)+i] = block[i];
            if (bits2hash % 8)
		sp->leftdata[(sp->leftbits+bits2hash)/8] &= (0xff << (8 - (bits2hash%8)));
            sp->leftbits += bits2hash;
        } else {
            // copy and do first block from leftdata
            block += (s_blocksize - sp->leftbits)/8;
            bits2hash -= (s_blocksize - sp->leftbits);
            if (sp->cvsize == 256)
                hash256(sp->ROUNDS, sp->state, sp->leftdata, 0);
            else if (sp->cvsize == 512)
                hash512(sp->ROUNDS, sp->state, sp->leftdata, 0);
            sp->leftbits = 0;
        }
    }

    // do all complete blocks
    for (; bits2hash >= s_blocksize; bits2hash -= s_blocksize) {
        if (sp->cvsize == 256)
            hash256(sp->ROUNDS, sp->state, block, 0);
        else if (sp->cvsize == 512)
            hash512(sp->ROUNDS, sp->state, block, 0);
        block += (s_blocksize/8);
        ++(sp->counter);
    }

    // copy leftover data, update leftbits
    sp->leftbits = bits2hash;
    for (i = 0; i < (bits2hash+7)/8; ++i)
	sp->leftdata[i]=block[i];

    return ret;
}
 
static inline
void HV(byte *h, int i, uint32_t w)
{
    h[4*i]   = (w >> 24) & 0xff;
    h[4*i+1] = (w >> 16) & 0xff;
 
    h[4*i+2] = (w >>  8) & 0xff;
    h[4*i+3] = (w      ) & 0xff;
}

int hamsiDigest(hamsiParam *sp, byte *digest)
{
    const int block_bytes = (sp->cvsize/8)/8;
    int i;
    uint64_t length = ((uint64_t)(sp->cvsize)*sp->counter) + sp->leftbits;
    byte lenbytes[8];
    int ret = SUCCESS;

    // Padding
    sp->leftdata[sp->leftbits/8] &= (0xff<<(8-(sp->leftbits%8)));
    sp->leftdata[sp->leftbits/8] |= (1<<(7-(sp->leftbits%8)));
    for (i = (sp->leftbits/8)+1; i < block_bytes; ++i)
	sp->leftdata[i] = 0;

    // position data length in lenbytes, BIG endian
    for (i = 0; i < 8; ++i)
	lenbytes[i] = (length>>(8*(7-i)))&0xff;

    // Processing padding and length
    if (sp->cvsize == 256) {
	hash256(sp->ROUNDS, sp->state, sp->leftdata, 0);
	hash256(sp->ROUNDS, sp->state, lenbytes, 0);
	hash256(sp->PFROUNDS, sp->state, lenbytes+4, 1);
    } else if (sp->cvsize == 512) {
	hash512(sp->ROUNDS, sp->state, sp->leftdata, 0);
	hash512(sp->PFROUNDS, sp->state, lenbytes, 1);
    }

    // Truncation
    if (sp->hashbitlen == 384) {
	int T_384[12] = { 0, 1, 3, 4, 5, 6, 8, 9, 10, 12, 13, 15 };
	for (i = 0; i < 12; ++i)
	    HV(digest, i, sp->state[T_384[i]]);
	    // digest[i] = sp->state[T_384[i]];
    } else {
	//memcpy(digest, sp->state, sp->hashbitlen/8);
	for (i = 0; i < (sp->hashbitlen/32); ++i)
	    HV(digest, i, sp->state[i]);
	    // digest[i] = sp->state[i];
    }

    return ret;
}
