#include <map>
#include <iostream>

#include "globals.hh"
#include "shared.hh"
#include "eval.hh"
#include "parser.hh"
#include "get-drvs.hh"
#include "attr-path.hh"
#include "expr-to-xml.hh"
#include "util.hh"
#include "store-api.hh"
#include "common-opts.hh"

/* #include "help.text.hh" */
static unsigned char helpText[] = {0x55, 0x73, 0x61, 0x67, 0x65, 0x3a, 0x20, 0x6e, 0x69, 0x78, 0x2d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x74, 0x65, 0x20, 0x5b, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x2e, 0x2e, 0x2e, 0x5d, 0x20, 0x5b, 0x46, 0x49, 0x4c, 0x45, 0x53, 0x2e, 0x2e, 0x2e, 0x5d, 0x0a, 0x0a, 0x60, 0x6e, 0x69, 0x78, 0x2d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x74, 0x65, 0x27, 0x20, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x20, 0x4e, 0x69, 0x78, 0x20, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x20, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x20, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x20, 0x0a, 0x0a, 0x54, 0x68, 0x65, 0x20, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x60, 0x2d, 0x27, 0x20, 0x6d, 0x61, 0x79, 0x20, 0x62, 0x65, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x61, 0x64, 0x20, 0x61, 0x20, 0x4e, 0x69, 0x78, 0x20, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x0a, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x20, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x2e, 0x0a, 0x0a, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x0a, 0x0a, 0x20, 0x20, 0x2d, 0x2d, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3a, 0x20, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x20, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x0a, 0x20, 0x20, 0x2d, 0x2d, 0x68, 0x65, 0x6c, 0x70, 0x3a, 0x20, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x20, 0x68, 0x65, 0x6c, 0x70, 0x0a, 0x0a, 0x20, 0x20, 0x2d, 0x2d, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x20, 0x2f, 0x20, 0x2d, 0x76, 0x3a, 0x20, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x65, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x28, 0x6d, 0x61, 0x79, 0x20, 0x62, 0x65, 0x20, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x29, 0x0a, 0x0a, 0x20, 0x20, 0x2d, 0x2d, 0x65, 0x76, 0x61, 0x6c, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x3a, 0x20, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x20, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x65, 0x72, 0x6d, 0x3b, 0x20, 0x64, 0x6f, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x74, 0x65, 0x0a, 0x20, 0x20, 0x2d, 0x2d, 0x70, 0x61, 0x72, 0x73, 0x65, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x3a, 0x20, 0x70, 0x61, 0x72, 0x73, 0x65, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x20, 0x61, 0x62, 0x73, 0x74, 0x72, 0x61, 0x63, 0x74, 0x20, 0x73, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x20, 0x74, 0x72, 0x65, 0x65, 0x0a, 0x0a, 0x20, 0x20, 0x2d, 0x2d, 0x61, 0x74, 0x74, 0x72, 0x20, 0x2f, 0x20, 0x2d, 0x41, 0x20, 0x50, 0x41, 0x54, 0x48, 0x3a, 0x20, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x20, 0x61, 0x6e, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x6f, 0x70, 0x2d, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x20, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x0a, 0x0a, 0x20, 0x20, 0x2d, 0x2d, 0x61, 0x64, 0x64, 0x2d, 0x72, 0x6f, 0x6f, 0x74, 0x3a, 0x20, 0x61, 0x64, 0x64, 0x20, 0x67, 0x61, 0x72, 0x62, 0x61, 0x67, 0x65, 0x20, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x20, 0x72, 0x6f, 0x6f, 0x74, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x0a, 0x0a, 0x46, 0x6f, 0x72, 0x20, 0x2d, 0x2d, 0x65, 0x76, 0x61, 0x6c, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x2f, 0x20, 0x2d, 0x2d, 0x70, 0x61, 0x72, 0x73, 0x65, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x3a, 0x0a, 0x0a, 0x20, 0x20, 0x2d, 0x2d, 0x78, 0x6d, 0x6c, 0x3a, 0x20, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x20, 0x61, 0x6e, 0x20, 0x58, 0x4d, 0x4c, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x62, 0x73, 0x74, 0x72, 0x61, 0x63, 0x74, 0x20, 0x73, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x20, 0x74, 0x72, 0x65, 0x65, 0x0a, 0x0a, 0x46, 0x6f, 0x72, 0x20, 0x2d, 0x2d, 0x65, 0x76, 0x61, 0x6c, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x3a, 0x0a, 0x0a, 0x20, 0x20, 0x2d, 0x2d, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x3a, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x20, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2c, 0x20, 0x72, 0x61, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x69, 0x6e, 0x67, 0x0a, 0x20, 0x20, 0x20, 0x20, 0x6c, 0x61, 0x7a, 0x79, 0x0a, };


using namespace nix;


void printHelp()
{
    std::cout << string((char *) helpText, sizeof helpText);
}


static Expr parseStdin(EvalState & state)
{
    startNest(nest, lvlTalkative, format("parsing standard input"));
    string s, s2;
    while (getline(std::cin, s2)) s += s2 + "\n";
    return parseExprFromString(state, s, absPath("."));
}


static Path gcRoot;
static int rootNr = 0;
static bool indirectRoot = false;


static void printResult(EvalState & state, Expr e,
    bool evalOnly, bool xmlOutput, const ATermMap & autoArgs)
{
    PathSet context;
    
    if (evalOnly)
        if (xmlOutput)
            printTermAsXML(e, std::cout, context);
        else
            std::cout << format("%1%\n") % canonicaliseExpr(e);
    
    else {
        DrvInfos drvs;
        getDerivations(state, e, "", autoArgs, drvs);
        for (DrvInfos::iterator i = drvs.begin(); i != drvs.end(); ++i) {
            Path drvPath = i->queryDrvPath(state);
            if (gcRoot == "")
                printGCWarning();
            else
                drvPath = addPermRoot(drvPath,
                    makeRootName(gcRoot, rootNr),
                    indirectRoot);
            std::cout << format("%1%\n") % drvPath;
        }
    }
}


void processExpr(EvalState & state, const Strings & attrPaths,
    bool parseOnly, bool strict, const ATermMap & autoArgs,
    bool evalOnly, bool xmlOutput, Expr e)
{
    for (Strings::const_iterator i = attrPaths.begin(); i != attrPaths.end(); ++i) {
        Expr e2 = findAlongAttrPath(state, *i, autoArgs, e);
        if (!parseOnly)
            if (strict)
                e2 = strictEvalExpr(state, e2);
            else
                e2 = evalExpr(state, e2);
        printResult(state, e2, evalOnly, xmlOutput, autoArgs);
    }
}


void run(Strings args)
{
    EvalState state;
    Strings files;
    bool readStdin = false;
    bool evalOnly = false;
    bool parseOnly = false;
    bool xmlOutput = false;
    bool strict = false;
    Strings attrPaths;
    ATermMap autoArgs(128);

    for (Strings::iterator i = args.begin();
         i != args.end(); )
    {
        string arg = *i++;

        if (arg == "-")
            readStdin = true;
        else if (arg == "--eval-only") {
            readOnlyMode = true;
            evalOnly = true;
        }
        else if (arg == "--parse-only") {
            readOnlyMode = true;
            parseOnly = evalOnly = true;
        }
        else if (arg == "--attr" || arg == "-A") {
            if (i == args.end())
                throw UsageError("`--attr' requires an argument");
            attrPaths.push_back(*i++);
        }
        else if (parseOptionArg(arg, i, args.end(), state, autoArgs))
            ;
        else if (arg == "--add-root") {
            if (i == args.end())
                throw UsageError("`--add-root' requires an argument");
            gcRoot = absPath(*i++);
        }
        else if (arg == "--indirect")
            indirectRoot = true;
        else if (arg == "--xml")
            xmlOutput = true;
        else if (arg == "--strict")
            strict = true;
        else if (arg[0] == '-')
            throw UsageError(format("unknown flag `%1%'") % arg);
        else
            files.push_back(arg);
    }

    if (attrPaths.empty()) attrPaths.push_back("");

    store = openStore();

    if (readStdin) {
        Expr e = parseStdin(state);
        processExpr(state, attrPaths, parseOnly, strict, autoArgs,
            evalOnly, xmlOutput, e);
    }

    for (Strings::iterator i = files.begin();
         i != files.end(); i++)
    {
        Path path = absPath(*i);
        Expr e = parseExprFromFile(state, path);
        processExpr(state, attrPaths, parseOnly, strict, autoArgs,
            evalOnly, xmlOutput, e);
    }

    printEvalStats(state);
}


string programId = "nix-instantiate";
