/****************************************************************************
**
** Copyright (C) 2013 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the QtLocation module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QPLACEREVIEW_H
#define QPLACEREVIEW_H

#include <QtLocation/QPlaceContent>

QT_BEGIN_NAMESPACE

class QDateTime;
class QPlaceReviewPrivate;

class Q_LOCATION_EXPORT QPlaceReview : public QPlaceContent
{
public:
    QPlaceReview();
#ifdef Q_QDOC
    QPlaceReview(const QPlaceContent &other);
#else
    Q_DECLARE_CONTENT_COPY_CTOR(QPlaceReview)
#endif
    virtual ~QPlaceReview();

    QDateTime dateTime() const;
    void setDateTime(const QDateTime &dt);
    QString text() const;
    void setText(const QString &text);
    QString language() const;
    void setLanguage(const QString &data);

    qreal rating() const;
    void setRating(qreal data);
    QString reviewId() const;
    void setReviewId(const QString &identifier);
    QString title() const;
    void setTitle(const QString &data);

private:
    Q_DECLARE_CONTENT_D_FUNC(QPlaceReview)
};

QT_END_NAMESPACE

#endif // QPLACEREVIEW_H
