
/* autogenerated from video-orc.orc */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <glib.h>

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#define ORC_UINT64_C(x) UINT64_C(x)
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#define ORC_UINT64_C(x) (x##Ui64)
#define inline __inline
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#define ORC_UINT64_C(x) (x##ULL)
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#define ORC_UINT64_C(x) (x##UL)
#endif
#endif
typedef union { orc_int16 i; orc_int8 x2[2]; } orc_union16;
typedef union { orc_int32 i; float f; orc_int16 x2[2]; orc_int8 x4[4]; } orc_union32;
typedef union { orc_int64 i; double f; orc_int32 x2[2]; float x2f[2]; orc_int16 x4[4]; } orc_union64;
#endif
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif

#ifndef ORC_INTERNAL
#if defined(__SUNPRO_C) && (__SUNPRO_C >= 0x590)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#elif defined(__SUNPRO_C) && (__SUNPRO_C >= 0x550)
#define ORC_INTERNAL __hidden
#elif defined (__GNUC__)
#define ORC_INTERNAL __attribute__((visibility("hidden")))
#else
#define ORC_INTERNAL
#endif
#endif


#ifndef DISABLE_ORC
#include <orc/orc.h>
#endif
void video_orc_blend_little (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_blend_big (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_I420 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n);
void video_orc_pack_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_Y (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_YUY2 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_YUY2 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_UYVY (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_UYVY (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_YVYU (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_YVYU (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_YUV9 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n);
void video_orc_unpack_Y42B (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n);
void video_orc_pack_Y42B (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_Y444 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n);
void video_orc_pack_Y444 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_GRAY8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_GRAY8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_RGBA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_RGBA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_ABGR (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_ABGR (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_NV12 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n);
void video_orc_pack_NV12 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_NV21 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n);
void video_orc_pack_NV21 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_NV24 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n);
void video_orc_pack_NV24 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_A420 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n);
void video_orc_pack_A420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_pack_AY (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_unpack_RGB15_le (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n);
void video_orc_unpack_RGB15_be (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n);
void video_orc_unpack_RGB15_le_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n);
void video_orc_unpack_RGB15_be_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n);
void video_orc_pack_RGB15_le (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n);
void video_orc_pack_RGB15_be (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n);
void video_orc_unpack_BGR15_le (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n);
void video_orc_unpack_BGR15_be (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n);
void video_orc_unpack_BGR15_le_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n);
void video_orc_unpack_BGR15_be_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n);
void video_orc_pack_BGR15_le (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n);
void video_orc_pack_BGR15_be (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n);
void video_orc_unpack_RGB16 (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n);
void video_orc_unpack_RGB16_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n);
void video_orc_pack_RGB16_le (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n);
void video_orc_pack_RGB16_be (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n);
void video_orc_unpack_BGR16 (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n);
void video_orc_unpack_BGR16_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n);
void video_orc_pack_BGR16_le (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n);
void video_orc_pack_BGR16_be (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n);
void video_orc_resample_bilinear_u32 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int p2, int n);
void video_orc_merge_linear_u8 (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int p1, int n);
void video_orc_memset_2d (guint8 * ORC_RESTRICT d1, int d1_stride, int p1, int n, int m);
void video_orc_memcpy_2d (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_orc_convert_u16_to_u8 (guint8 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n);
void video_orc_convert_u8_to_u16 (guint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_splat_u16 (guint8 * ORC_RESTRICT d1, int p1, int n);
void video_orc_splat_u32 (guint8 * ORC_RESTRICT d1, int p1, int n);
void video_orc_splat_u64 (guint8 * ORC_RESTRICT d1, orc_int64 p1, int n);
void video_orc_splat2_u64 (guint8 * ORC_RESTRICT d1, int p1, int n);
void video_orc_convert_I420_UYVY (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n);
void video_orc_convert_I420_YUY2 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n);
void video_orc_convert_I420_AYUV (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int n);
void video_orc_convert_YUY2_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n);
void video_orc_convert_UYVY_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_orc_planar_chroma_420_422 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_orc_planar_chroma_420_444 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_orc_planar_chroma_422_444 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_orc_planar_chroma_444_422 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_orc_planar_chroma_444_420 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void video_orc_planar_chroma_422_420 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void video_orc_convert_YUY2_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int n, int m);
void video_orc_convert_UYVY_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int n, int m);
void video_orc_convert_YUY2_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_orc_convert_UYVY_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_orc_convert_YUY2_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_orc_convert_UYVY_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_orc_convert_UYVY_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n);
void video_orc_convert_AYUV_I420 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, guint8 * ORC_RESTRICT d4, int d4_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void video_orc_convert_AYUV_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_orc_convert_AYUV_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_orc_convert_AYUV_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_orc_convert_AYUV_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m);
void video_orc_convert_Y42B_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void video_orc_convert_Y42B_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void video_orc_convert_Y42B_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int p1, int n, int m);
void video_orc_convert_Y444_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void video_orc_convert_Y444_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m);
void video_orc_convert_Y444_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int p1, int n, int m);
void video_orc_convert_AYUV_ARGB (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3, int p4, int p5, int n, int m);
void video_orc_convert_AYUV_BGRA (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3, int p4, int p5, int n, int m);
void video_orc_convert_AYUV_ABGR (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3, int p4, int p5, int n, int m);
void video_orc_convert_AYUV_RGBA (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3, int p4, int p5, int n, int m);
void video_orc_convert_I420_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int p1, int p2, int p3, int p4, int p5, int n);
void video_orc_convert_I420_ARGB (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int p1, int p2, int p3, int p4, int p5, int n);
void video_orc_matrix8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, orc_int64 p1, orc_int64 p2, orc_int64 p3, orc_int64 p4, int n);
void _custom_video_orc_matrix8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, orc_int64 p1, orc_int64 p2, orc_int64 p3, orc_int64 p4, int n);
void video_orc_resample_h_near_u32_lq (guint32 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int p1, int p2, int n);
void video_orc_resample_h_2tap_1u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int p2, int n);
void video_orc_resample_h_2tap_4u8_lq (guint32 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int p1, int p2, int n);
void video_orc_resample_h_2tap_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const gint16 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, int n);
void video_orc_resample_h_2tap_u16 (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, const gint16 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, int n);
void video_orc_resample_v_2tap_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int p1, int n);
void video_orc_resample_v_2tap_u16 (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, int p1, int n);
void video_orc_resample_v_2tap_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int p1, int n);
void video_orc_resample_v_4tap_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int p2, int p3, int p4, int n);
void video_orc_resample_v_4tap_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int p2, int p3, int p4, int n);
void video_orc_resample_h_multaps_u8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const gint16 * ORC_RESTRICT s2, int n);
void video_orc_resample_h_muladdtaps_u8 (gint32 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const gint16 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void video_orc_resample_scaletaps_u8 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void video_orc_resample_h_multaps_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const gint16 * ORC_RESTRICT s2, int n);
void video_orc_resample_h_muladdtaps_u8_lq (gint16 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const gint16 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void video_orc_resample_h_multaps3_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, const gint16 * ORC_RESTRICT s5, const gint16 * ORC_RESTRICT s6, int n);
void video_orc_resample_h_muladdtaps3_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, const gint16 * ORC_RESTRICT s5, const gint16 * ORC_RESTRICT s6, int n);
void video_orc_resample_h_muladdscaletaps3_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, const gint16 * ORC_RESTRICT s5, const gint16 * ORC_RESTRICT s6, const gint16 * ORC_RESTRICT s7, int n);
void video_orc_resample_scaletaps_u8_lq (guint8 * ORC_RESTRICT d1, const gint16 * ORC_RESTRICT s1, int n);
void video_orc_resample_h_multaps_u16 (gint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const gint16 * ORC_RESTRICT s2, int n);
void video_orc_resample_h_muladdtaps_u16 (gint32 * ORC_RESTRICT d1, int d1_stride, const guint16 * ORC_RESTRICT s1, int s1_stride, const gint16 * ORC_RESTRICT s2, int s2_stride, int n, int m);
void video_orc_resample_scaletaps_u16 (guint16 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n);
void video_orc_resample_v_multaps_u8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int n);
void video_orc_resample_v_muladdtaps_u8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int n);
void video_orc_resample_v_multaps_u16 (gint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int p1, int n);
void video_orc_resample_v_muladdtaps_u16 (gint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int p1, int n);
void video_orc_resample_v_multaps_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int n);
void video_orc_resample_v_multaps4_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int p2, int p3, int p4, int n);
void video_orc_resample_v_muladdtaps_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int n);
void video_orc_resample_v_muladdtaps4_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int p2, int p3, int p4, int n);
void video_orc_resample_v_muladdscaletaps4_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, const gint16 * ORC_RESTRICT s5, int p1, int p2, int p3, int p4, int n);
void video_orc_chroma_down_h2_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_chroma_down_v2_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n);
void video_orc_chroma_up_v2_u8 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n);
void video_orc_chroma_up_v2_u16 (guint16 * ORC_RESTRICT d1, guint16 * ORC_RESTRICT d2, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, int n);
void video_orc_chroma_down_v2_u16 (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, int n);
void video_orc_chroma_down_v4_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n);
void video_orc_chroma_down_v4_u16 (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, const guint16 * ORC_RESTRICT s3, const guint16 * ORC_RESTRICT s4, int n);
void video_orc_dither_none_4u8_mask (guint8 * ORC_RESTRICT d1, int p1, int n);
void video_orc_dither_none_4u16_mask (guint16 * ORC_RESTRICT d1, orc_int64 p1, int n);
void video_orc_dither_verterr_4u8_mask (guint8 * ORC_RESTRICT d1, guint16 * ORC_RESTRICT d2, orc_int64 p1, int n);
void video_orc_dither_fs_muladd_u8 (guint16 * ORC_RESTRICT d1, int n);
void video_orc_dither_ordered_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n);
void video_orc_dither_ordered_4u8_mask (guint8 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, orc_int64 p1, int n);
void video_orc_dither_ordered_4u16_mask (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, orc_int64 p1, int n);
void video_orc_convert_UYVY_GRAY8 (guint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint16 * ORC_RESTRICT s1, int s1_stride, int n, int m);


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xffU)<<8) | (((x)&0xff00U)>>8))
#define ORC_SWAP_L(x) ((((x)&0xffU)<<24) | (((x)&0xff00U)<<8) | (((x)&0xff0000U)>>8) | (((x)&0xff000000U)>>24))
#define ORC_SWAP_Q(x) ((((x)&ORC_UINT64_C(0xff))<<56) | (((x)&ORC_UINT64_C(0xff00))<<40) | (((x)&ORC_UINT64_C(0xff0000))<<24) | (((x)&ORC_UINT64_C(0xff000000))<<8) | (((x)&ORC_UINT64_C(0xff00000000))>>8) | (((x)&ORC_UINT64_C(0xff0000000000))>>24) | (((x)&ORC_UINT64_C(0xff000000000000))>>40) | (((x)&ORC_UINT64_C(0xff00000000000000))>>56))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_DENORMAL(x) ((x) & ((((x)&0x7f800000) == 0) ? 0xff800000 : 0xffffffff))
#define ORC_ISNAN(x) ((((x)&0x7f800000) == 0x7f800000) && (((x)&0x007fffff) != 0))
#define ORC_DENORMAL_DOUBLE(x) ((x) & ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == 0) ? ORC_UINT64_C(0xfff0000000000000) : ORC_UINT64_C(0xffffffffffffffff)))
#define ORC_ISNAN_DOUBLE(x) ((((x)&ORC_UINT64_C(0x7ff0000000000000)) == ORC_UINT64_C(0x7ff0000000000000)) && (((x)&ORC_UINT64_C(0x000fffffffffffff)) != 0))
#ifndef ORC_RESTRICT
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#define ORC_RESTRICT restrict
#elif defined(__GNUC__) && __GNUC__ >= 4
#define ORC_RESTRICT __restrict__
#else
#define ORC_RESTRICT
#endif
#endif
/* end Orc C target preamble */



/* video_orc_blend_little */
#ifdef DISABLE_ORC
void
video_orc_blend_little (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union32 var40;
  orc_union16 var41;
  orc_int8 var42;
  orc_union32 var43;
  orc_union64 var44;
  orc_union64 var45;
  orc_union64 var46;
  orc_union32 var47;
  orc_union64 var48;
  orc_union64 var49;
  orc_union64 var50;
  orc_union64 var51;
  orc_union64 var52;
  orc_union32 var53;
  orc_union32 var54;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 14: loadpl */
    var39.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: convlw */
    var41.i = var40.i;
    /* 2: convwb */
    var42 = var41.i;
    /* 3: splatbl */
    var43.i = ((((orc_uint32)var42)&0xff) << 24) | ((((orc_uint32)var42)&0xff)<<16) | ((((orc_uint32)var42)&0xff) << 8) | (((orc_uint32)var42)&0xff);
    /* 4: convubw */
    var44.x4[0] = (orc_uint8)var43.x4[0];
    var44.x4[1] = (orc_uint8)var43.x4[1];
    var44.x4[2] = (orc_uint8)var43.x4[2];
    var44.x4[3] = (orc_uint8)var43.x4[3];
    /* 5: shruw */
    var45.x4[0] = ((orc_uint16)var44.x4[0]) >> 8;
    var45.x4[1] = ((orc_uint16)var44.x4[1]) >> 8;
    var45.x4[2] = ((orc_uint16)var44.x4[2]) >> 8;
    var45.x4[3] = ((orc_uint16)var44.x4[3]) >> 8;
    /* 6: convubw */
    var46.x4[0] = (orc_uint8)var40.x4[0];
    var46.x4[1] = (orc_uint8)var40.x4[1];
    var46.x4[2] = (orc_uint8)var40.x4[2];
    var46.x4[3] = (orc_uint8)var40.x4[3];
    /* 7: loadl */
    var47 = ptr0[i];
    /* 8: convubw */
    var48.x4[0] = (orc_uint8)var47.x4[0];
    var48.x4[1] = (orc_uint8)var47.x4[1];
    var48.x4[2] = (orc_uint8)var47.x4[2];
    var48.x4[3] = (orc_uint8)var47.x4[3];
    /* 9: subw */
    var49.x4[0] = var46.x4[0] - var48.x4[0];
    var49.x4[1] = var46.x4[1] - var48.x4[1];
    var49.x4[2] = var46.x4[2] - var48.x4[2];
    var49.x4[3] = var46.x4[3] - var48.x4[3];
    /* 10: mullw */
    var50.x4[0] = (var49.x4[0] * var45.x4[0]) & 0xffff;
    var50.x4[1] = (var49.x4[1] * var45.x4[1]) & 0xffff;
    var50.x4[2] = (var49.x4[2] * var45.x4[2]) & 0xffff;
    var50.x4[3] = (var49.x4[3] * var45.x4[3]) & 0xffff;
    /* 11: div255w */
    var51.x4[0] = ((orc_uint16)(((orc_uint16)(var50.x4[0]+128)) + (((orc_uint16)(var50.x4[0]+128))>>8)))>>8;
    var51.x4[1] = ((orc_uint16)(((orc_uint16)(var50.x4[1]+128)) + (((orc_uint16)(var50.x4[1]+128))>>8)))>>8;
    var51.x4[2] = ((orc_uint16)(((orc_uint16)(var50.x4[2]+128)) + (((orc_uint16)(var50.x4[2]+128))>>8)))>>8;
    var51.x4[3] = ((orc_uint16)(((orc_uint16)(var50.x4[3]+128)) + (((orc_uint16)(var50.x4[3]+128))>>8)))>>8;
    /* 12: addw */
    var52.x4[0] = var48.x4[0] + var51.x4[0];
    var52.x4[1] = var48.x4[1] + var51.x4[1];
    var52.x4[2] = var48.x4[2] + var51.x4[2];
    var52.x4[3] = var48.x4[3] + var51.x4[3];
    /* 13: convwb */
    var53.x4[0] = var52.x4[0];
    var53.x4[1] = var52.x4[1];
    var53.x4[2] = var52.x4[2];
    var53.x4[3] = var52.x4[3];
    /* 15: orl */
    var54.i = var53.i | var39.i;
    /* 16: storel */
    ptr0[i] = var54;
  }

}

#else
static void
_backup_video_orc_blend_little (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union32 var40;
  orc_union16 var41;
  orc_int8 var42;
  orc_union32 var43;
  orc_union64 var44;
  orc_union64 var45;
  orc_union64 var46;
  orc_union32 var47;
  orc_union64 var48;
  orc_union64 var49;
  orc_union64 var50;
  orc_union64 var51;
  orc_union64 var52;
  orc_union32 var53;
  orc_union32 var54;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 14: loadpl */
    var39.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var40 = ptr4[i];
    /* 1: convlw */
    var41.i = var40.i;
    /* 2: convwb */
    var42 = var41.i;
    /* 3: splatbl */
    var43.i = ((((orc_uint32)var42)&0xff) << 24) | ((((orc_uint32)var42)&0xff)<<16) | ((((orc_uint32)var42)&0xff) << 8) | (((orc_uint32)var42)&0xff);
    /* 4: convubw */
    var44.x4[0] = (orc_uint8)var43.x4[0];
    var44.x4[1] = (orc_uint8)var43.x4[1];
    var44.x4[2] = (orc_uint8)var43.x4[2];
    var44.x4[3] = (orc_uint8)var43.x4[3];
    /* 5: shruw */
    var45.x4[0] = ((orc_uint16)var44.x4[0]) >> 8;
    var45.x4[1] = ((orc_uint16)var44.x4[1]) >> 8;
    var45.x4[2] = ((orc_uint16)var44.x4[2]) >> 8;
    var45.x4[3] = ((orc_uint16)var44.x4[3]) >> 8;
    /* 6: convubw */
    var46.x4[0] = (orc_uint8)var40.x4[0];
    var46.x4[1] = (orc_uint8)var40.x4[1];
    var46.x4[2] = (orc_uint8)var40.x4[2];
    var46.x4[3] = (orc_uint8)var40.x4[3];
    /* 7: loadl */
    var47 = ptr0[i];
    /* 8: convubw */
    var48.x4[0] = (orc_uint8)var47.x4[0];
    var48.x4[1] = (orc_uint8)var47.x4[1];
    var48.x4[2] = (orc_uint8)var47.x4[2];
    var48.x4[3] = (orc_uint8)var47.x4[3];
    /* 9: subw */
    var49.x4[0] = var46.x4[0] - var48.x4[0];
    var49.x4[1] = var46.x4[1] - var48.x4[1];
    var49.x4[2] = var46.x4[2] - var48.x4[2];
    var49.x4[3] = var46.x4[3] - var48.x4[3];
    /* 10: mullw */
    var50.x4[0] = (var49.x4[0] * var45.x4[0]) & 0xffff;
    var50.x4[1] = (var49.x4[1] * var45.x4[1]) & 0xffff;
    var50.x4[2] = (var49.x4[2] * var45.x4[2]) & 0xffff;
    var50.x4[3] = (var49.x4[3] * var45.x4[3]) & 0xffff;
    /* 11: div255w */
    var51.x4[0] = ((orc_uint16)(((orc_uint16)(var50.x4[0]+128)) + (((orc_uint16)(var50.x4[0]+128))>>8)))>>8;
    var51.x4[1] = ((orc_uint16)(((orc_uint16)(var50.x4[1]+128)) + (((orc_uint16)(var50.x4[1]+128))>>8)))>>8;
    var51.x4[2] = ((orc_uint16)(((orc_uint16)(var50.x4[2]+128)) + (((orc_uint16)(var50.x4[2]+128))>>8)))>>8;
    var51.x4[3] = ((orc_uint16)(((orc_uint16)(var50.x4[3]+128)) + (((orc_uint16)(var50.x4[3]+128))>>8)))>>8;
    /* 12: addw */
    var52.x4[0] = var48.x4[0] + var51.x4[0];
    var52.x4[1] = var48.x4[1] + var51.x4[1];
    var52.x4[2] = var48.x4[2] + var51.x4[2];
    var52.x4[3] = var48.x4[3] + var51.x4[3];
    /* 13: convwb */
    var53.x4[0] = var52.x4[0];
    var53.x4[1] = var52.x4[1];
    var53.x4[2] = var52.x4[2];
    var53.x4[3] = var52.x4[3];
    /* 15: orl */
    var54.i = var53.i | var39.i;
    /* 16: storel */
    ptr0[i] = var54;
  }

}

void
video_orc_blend_little (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 22, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 98, 108, 101, 
        110, 100, 95, 108, 105, 116, 116, 108, 101, 11, 4, 4, 12, 4, 4, 14, 
        4, 255, 0, 0, 0, 14, 2, 8, 0, 0, 0, 20, 4, 20, 2, 20, 
        1, 20, 4, 20, 8, 20, 8, 20, 8, 113, 32, 4, 163, 33, 32, 157, 
        34, 33, 152, 35, 34, 21, 2, 150, 38, 35, 21, 2, 95, 38, 38, 17, 
        21, 2, 150, 37, 32, 113, 32, 0, 21, 2, 150, 36, 32, 21, 2, 98, 
        37, 37, 36, 21, 2, 89, 37, 37, 38, 21, 2, 80, 37, 37, 21, 2, 
        70, 36, 36, 37, 21, 2, 157, 32, 36, 123, 32, 32, 16, 128, 0, 32, 
        2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_blend_little);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_blend_little");
      orc_program_set_backup_function (p, _backup_video_orc_blend_little);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x000000ff, "c1");
      orc_program_add_constant (p, 2, 0x00000008, "c2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 8, "t5");
      orc_program_add_temporary (p, 8, "t6");
      orc_program_add_temporary (p, 8, "t7");

      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convwb", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbl", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 2, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 2, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 2, ORC_VAR_T6, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 2, ORC_VAR_T5, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 2, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 2, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_T7, ORC_VAR_D1);
      orc_program_append_2 (p, "div255w", 2, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 2, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_D1);
      orc_program_append_2 (p, "convwb", 2, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "storel", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_blend_big */
#ifdef DISABLE_ORC
void
video_orc_blend_big (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var40;
#else
  orc_union32 var40;
#endif
  orc_union32 var41;
  orc_union32 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_union32 var45;
  orc_union64 var46;
  orc_union64 var47;
  orc_union64 var48;
  orc_union32 var49;
  orc_union64 var50;
  orc_union64 var51;
  orc_union64 var52;
  orc_union64 var53;
  orc_union64 var54;
  orc_union32 var55;
  orc_union32 var56;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 15: loadpl */
    var40.i = (int)0xff000000; /* -16777216 or 2.11371e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 1: shrul */
    var42.i = ((orc_uint32)var41.i) >> 24;
    /* 2: convlw */
    var43.i = var42.i;
    /* 3: convwb */
    var44 = var43.i;
    /* 4: splatbl */
    var45.i = ((((orc_uint32)var44)&0xff) << 24) | ((((orc_uint32)var44)&0xff)<<16) | ((((orc_uint32)var44)&0xff) << 8) | (((orc_uint32)var44)&0xff);
    /* 5: convubw */
    var46.x4[0] = (orc_uint8)var45.x4[0];
    var46.x4[1] = (orc_uint8)var45.x4[1];
    var46.x4[2] = (orc_uint8)var45.x4[2];
    var46.x4[3] = (orc_uint8)var45.x4[3];
    /* 6: shruw */
    var47.x4[0] = ((orc_uint16)var46.x4[0]) >> 8;
    var47.x4[1] = ((orc_uint16)var46.x4[1]) >> 8;
    var47.x4[2] = ((orc_uint16)var46.x4[2]) >> 8;
    var47.x4[3] = ((orc_uint16)var46.x4[3]) >> 8;
    /* 7: convubw */
    var48.x4[0] = (orc_uint8)var41.x4[0];
    var48.x4[1] = (orc_uint8)var41.x4[1];
    var48.x4[2] = (orc_uint8)var41.x4[2];
    var48.x4[3] = (orc_uint8)var41.x4[3];
    /* 8: loadl */
    var49 = ptr0[i];
    /* 9: convubw */
    var50.x4[0] = (orc_uint8)var49.x4[0];
    var50.x4[1] = (orc_uint8)var49.x4[1];
    var50.x4[2] = (orc_uint8)var49.x4[2];
    var50.x4[3] = (orc_uint8)var49.x4[3];
    /* 10: subw */
    var51.x4[0] = var48.x4[0] - var50.x4[0];
    var51.x4[1] = var48.x4[1] - var50.x4[1];
    var51.x4[2] = var48.x4[2] - var50.x4[2];
    var51.x4[3] = var48.x4[3] - var50.x4[3];
    /* 11: mullw */
    var52.x4[0] = (var51.x4[0] * var47.x4[0]) & 0xffff;
    var52.x4[1] = (var51.x4[1] * var47.x4[1]) & 0xffff;
    var52.x4[2] = (var51.x4[2] * var47.x4[2]) & 0xffff;
    var52.x4[3] = (var51.x4[3] * var47.x4[3]) & 0xffff;
    /* 12: div255w */
    var53.x4[0] = ((orc_uint16)(((orc_uint16)(var52.x4[0]+128)) + (((orc_uint16)(var52.x4[0]+128))>>8)))>>8;
    var53.x4[1] = ((orc_uint16)(((orc_uint16)(var52.x4[1]+128)) + (((orc_uint16)(var52.x4[1]+128))>>8)))>>8;
    var53.x4[2] = ((orc_uint16)(((orc_uint16)(var52.x4[2]+128)) + (((orc_uint16)(var52.x4[2]+128))>>8)))>>8;
    var53.x4[3] = ((orc_uint16)(((orc_uint16)(var52.x4[3]+128)) + (((orc_uint16)(var52.x4[3]+128))>>8)))>>8;
    /* 13: addw */
    var54.x4[0] = var50.x4[0] + var53.x4[0];
    var54.x4[1] = var50.x4[1] + var53.x4[1];
    var54.x4[2] = var50.x4[2] + var53.x4[2];
    var54.x4[3] = var50.x4[3] + var53.x4[3];
    /* 14: convwb */
    var55.x4[0] = var54.x4[0];
    var55.x4[1] = var54.x4[1];
    var55.x4[2] = var54.x4[2];
    var55.x4[3] = var54.x4[3];
    /* 16: orl */
    var56.i = var55.i | var40.i;
    /* 17: storel */
    ptr0[i] = var56;
  }

}

#else
static void
_backup_video_orc_blend_big (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var40;
#else
  orc_union32 var40;
#endif
  orc_union32 var41;
  orc_union32 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_union32 var45;
  orc_union64 var46;
  orc_union64 var47;
  orc_union64 var48;
  orc_union32 var49;
  orc_union64 var50;
  orc_union64 var51;
  orc_union64 var52;
  orc_union64 var53;
  orc_union64 var54;
  orc_union32 var55;
  orc_union32 var56;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 15: loadpl */
    var40.i = (int)0xff000000; /* -16777216 or 2.11371e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 1: shrul */
    var42.i = ((orc_uint32)var41.i) >> 24;
    /* 2: convlw */
    var43.i = var42.i;
    /* 3: convwb */
    var44 = var43.i;
    /* 4: splatbl */
    var45.i = ((((orc_uint32)var44)&0xff) << 24) | ((((orc_uint32)var44)&0xff)<<16) | ((((orc_uint32)var44)&0xff) << 8) | (((orc_uint32)var44)&0xff);
    /* 5: convubw */
    var46.x4[0] = (orc_uint8)var45.x4[0];
    var46.x4[1] = (orc_uint8)var45.x4[1];
    var46.x4[2] = (orc_uint8)var45.x4[2];
    var46.x4[3] = (orc_uint8)var45.x4[3];
    /* 6: shruw */
    var47.x4[0] = ((orc_uint16)var46.x4[0]) >> 8;
    var47.x4[1] = ((orc_uint16)var46.x4[1]) >> 8;
    var47.x4[2] = ((orc_uint16)var46.x4[2]) >> 8;
    var47.x4[3] = ((orc_uint16)var46.x4[3]) >> 8;
    /* 7: convubw */
    var48.x4[0] = (orc_uint8)var41.x4[0];
    var48.x4[1] = (orc_uint8)var41.x4[1];
    var48.x4[2] = (orc_uint8)var41.x4[2];
    var48.x4[3] = (orc_uint8)var41.x4[3];
    /* 8: loadl */
    var49 = ptr0[i];
    /* 9: convubw */
    var50.x4[0] = (orc_uint8)var49.x4[0];
    var50.x4[1] = (orc_uint8)var49.x4[1];
    var50.x4[2] = (orc_uint8)var49.x4[2];
    var50.x4[3] = (orc_uint8)var49.x4[3];
    /* 10: subw */
    var51.x4[0] = var48.x4[0] - var50.x4[0];
    var51.x4[1] = var48.x4[1] - var50.x4[1];
    var51.x4[2] = var48.x4[2] - var50.x4[2];
    var51.x4[3] = var48.x4[3] - var50.x4[3];
    /* 11: mullw */
    var52.x4[0] = (var51.x4[0] * var47.x4[0]) & 0xffff;
    var52.x4[1] = (var51.x4[1] * var47.x4[1]) & 0xffff;
    var52.x4[2] = (var51.x4[2] * var47.x4[2]) & 0xffff;
    var52.x4[3] = (var51.x4[3] * var47.x4[3]) & 0xffff;
    /* 12: div255w */
    var53.x4[0] = ((orc_uint16)(((orc_uint16)(var52.x4[0]+128)) + (((orc_uint16)(var52.x4[0]+128))>>8)))>>8;
    var53.x4[1] = ((orc_uint16)(((orc_uint16)(var52.x4[1]+128)) + (((orc_uint16)(var52.x4[1]+128))>>8)))>>8;
    var53.x4[2] = ((orc_uint16)(((orc_uint16)(var52.x4[2]+128)) + (((orc_uint16)(var52.x4[2]+128))>>8)))>>8;
    var53.x4[3] = ((orc_uint16)(((orc_uint16)(var52.x4[3]+128)) + (((orc_uint16)(var52.x4[3]+128))>>8)))>>8;
    /* 13: addw */
    var54.x4[0] = var50.x4[0] + var53.x4[0];
    var54.x4[1] = var50.x4[1] + var53.x4[1];
    var54.x4[2] = var50.x4[2] + var53.x4[2];
    var54.x4[3] = var50.x4[3] + var53.x4[3];
    /* 14: convwb */
    var55.x4[0] = var54.x4[0];
    var55.x4[1] = var54.x4[1];
    var55.x4[2] = var54.x4[2];
    var55.x4[3] = var54.x4[3];
    /* 16: orl */
    var56.i = var55.i | var40.i;
    /* 17: storel */
    ptr0[i] = var56;
  }

}

void
video_orc_blend_big (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 98, 108, 101, 
        110, 100, 95, 98, 105, 103, 11, 4, 4, 12, 4, 4, 14, 4, 0, 0, 
        0, 255, 14, 4, 24, 0, 0, 0, 14, 2, 8, 0, 0, 0, 20, 4, 
        20, 4, 20, 2, 20, 1, 20, 4, 20, 8, 20, 8, 20, 8, 113, 32, 
        4, 126, 33, 32, 17, 163, 34, 33, 157, 35, 34, 152, 36, 35, 21, 2, 
        150, 39, 36, 21, 2, 95, 39, 39, 18, 21, 2, 150, 38, 32, 113, 32, 
        0, 21, 2, 150, 37, 32, 21, 2, 98, 38, 38, 37, 21, 2, 89, 38, 
        38, 39, 21, 2, 80, 38, 38, 21, 2, 70, 37, 37, 38, 21, 2, 157, 
        32, 37, 123, 32, 32, 16, 128, 0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_blend_big);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_blend_big");
      orc_program_set_backup_function (p, _backup_video_orc_blend_big);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0xff000000, "c1");
      orc_program_add_constant (p, 4, 0x00000018, "c2");
      orc_program_add_constant (p, 2, 0x00000008, "c3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 8, "t6");
      orc_program_add_temporary (p, 8, "t7");
      orc_program_add_temporary (p, 8, "t8");

      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbl", 0, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 2, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 2, ORC_VAR_T8, ORC_VAR_T8, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 2, ORC_VAR_T7, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 2, ORC_VAR_T6, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 2, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T6, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 2, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "div255w", 2, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 2, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_T7, ORC_VAR_D1);
      orc_program_append_2 (p, "convwb", 2, ORC_VAR_T1, ORC_VAR_T6, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "storel", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_I420 */
#ifdef DISABLE_ORC
void
video_orc_unpack_I420 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var36;
#else
  orc_int8 var36;
#endif
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;

    /* 3: loadpb */
    var36 = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var39 = ptr5[i>>1];
    /* 1: loadupdb */
    var40 = ptr6[i>>1];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var39;
       _dest.x2[1] = var40;
       var41.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var37;
       var42.i = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.i;
       _dest.x2[1] = var41.i;
       var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var36;
#else
  orc_int8 var36;
#endif
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

    /* 3: loadpb */
    var36 = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var39 = ptr5[i>>1];
    /* 1: loadupdb */
    var40 = ptr6[i>>1];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var39;
       _dest.x2[1] = var40;
       var41.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var37;
       var42.i = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.i;
       _dest.x2[1] = var41.i;
       var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_I420 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 73, 52, 50, 48, 11, 4, 4, 12, 1, 1, 12, 1, 
        1, 12, 1, 1, 14, 1, 255, 0, 0, 0, 20, 2, 20, 2, 20, 1, 
        20, 1, 45, 34, 5, 45, 35, 6, 196, 32, 34, 35, 196, 33, 16, 4, 
        195, 0, 33, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_I420);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_I420");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_I420);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");

      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T3, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T4, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_I420 */
#ifdef DISABLE_ORC
void
video_orc_pack_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;
  orc_union16 var45;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_int8 *)d2;
  ptr2 = (orc_int8 *)d3;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var38 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var38.x2[0];
       var42.x2[0] = _src.x2[1];
       var43.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var38.x2[1];
       var42.x2[1] = _src.x2[1];
       var43.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var43.x2[0];
       var39.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var43.x2[1];
       var39.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var39;
    /* 4: splitwb */
    {
       orc_union16 _src;
       _src.i = var42.x2[0];
       var44.x2[0] = _src.x2[1];
       var45.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var42.x2[1];
       var44.x2[1] = _src.x2[1];
       var45.x2[1] = _src.x2[0];
    }
    /* 5: select0wb */
    {
       orc_union16 _src;
       _src.i = var45.i;
       var40 = _src.x2[0];
    }
    /* 6: storeb */
    ptr1[i] = var40;
    /* 7: select0wb */
    {
       orc_union16 _src;
       _src.i = var44.i;
       var41 = _src.x2[0];
    }
    /* 8: storeb */
    ptr2[i] = var41;
  }

}

#else
static void
_backup_video_orc_pack_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union16 var44;
  orc_union16 var45;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_int8 *)ex->arrays[1];
  ptr2 = (orc_int8 *)ex->arrays[2];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var38 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var38.x2[0];
       var42.x2[0] = _src.x2[1];
       var43.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var38.x2[1];
       var42.x2[1] = _src.x2[1];
       var43.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var43.x2[0];
       var39.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var43.x2[1];
       var39.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var39;
    /* 4: splitwb */
    {
       orc_union16 _src;
       _src.i = var42.x2[0];
       var44.x2[0] = _src.x2[1];
       var45.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var42.x2[1];
       var44.x2[1] = _src.x2[1];
       var45.x2[1] = _src.x2[0];
    }
    /* 5: select0wb */
    {
       orc_union16 _src;
       _src.i = var45.i;
       var40 = _src.x2[0];
    }
    /* 6: storeb */
    ptr1[i] = var40;
    /* 7: select0wb */
    {
       orc_union16 _src;
       _src.i = var44.i;
       var41 = _src.x2[0];
    }
    /* 8: storeb */
    ptr2[i] = var41;
  }

}

void
video_orc_pack_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 73, 52, 50, 48, 11, 2, 2, 11, 1, 1, 11, 1, 1, 12, 
        8, 8, 20, 4, 20, 4, 20, 2, 20, 2, 20, 1, 20, 1, 21, 1, 
        198, 33, 32, 4, 21, 1, 189, 0, 32, 21, 1, 199, 35, 34, 33, 188, 
        1, 34, 188, 2, 35, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_I420);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_I420");
      orc_program_set_backup_function (p, _backup_video_orc_pack_I420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 1, "t5");
      orc_program_add_temporary (p, 1, "t6");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_D3, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_Y */
#ifdef DISABLE_ORC
void
video_orc_pack_Y (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select0lw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var35.i = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var35.i;
       var34 = _src.x2[1];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_video_orc_pack_Y (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select0lw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var35.i = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var35.i;
       var34 = _src.x2[1];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
video_orc_pack_Y (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 16, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 89, 11, 1, 1, 12, 4, 4, 20, 2, 190, 32, 4, 189, 0, 
        32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_Y);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_Y");
      orc_program_set_backup_function (p, _backup_video_orc_pack_Y);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_YUY2 */
#ifdef DISABLE_ORC
void
video_orc_unpack_YUY2 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 2: loadpb */
    var37.x2[0] = (int)0x000000ff; /* 255 or 1.25987e-321f */
    var37.x2[1] = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
       orc_union16 _src;
       _src.i = var36.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var36.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
    /* 3: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var40.x2[0];
       var41.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var40.x2[1];
       var41.x2[1] = _dest.i;
    }
    /* 4: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var39.i;
       _dest.x2[1] = var39.i;
       var42.i = _dest.i;
    }
    /* 5: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[0];
       _dest.x2[1] = var42.x2[0];
       var38.x2[0] = _dest.i;
    }
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[1];
       _dest.x2[1] = var42.x2[1];
       var38.x2[1] = _dest.i;
    }
    /* 6: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 2: loadpb */
    var37.x2[0] = (int)0x000000ff; /* 255 or 1.25987e-321f */
    var37.x2[1] = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
       orc_union16 _src;
       _src.i = var36.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var36.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
    /* 3: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var40.x2[0];
       var41.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var40.x2[1];
       var41.x2[1] = _dest.i;
    }
    /* 4: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var39.i;
       _dest.x2[1] = var39.i;
       var42.i = _dest.i;
    }
    /* 5: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[0];
       _dest.x2[1] = var42.x2[0];
       var38.x2[0] = _dest.i;
    }
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[1];
       _dest.x2[1] = var42.x2[1];
       var38.x2[1] = _dest.i;
    }
    /* 6: storeq */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_YUY2 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 89, 85, 89, 50, 11, 8, 8, 12, 4, 4, 14, 2, 
        255, 0, 0, 0, 20, 2, 20, 2, 20, 4, 20, 4, 21, 1, 199, 33, 
        32, 4, 21, 1, 196, 34, 16, 32, 195, 35, 33, 33, 21, 1, 195, 0, 
        34, 35, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_YUY2);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_YUY2");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_YUY2);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_YUY2 */
#ifdef DISABLE_ORC
void
video_orc_pack_YUY2 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var36.x2[0];
       var38.x2[0] = _src.x2[1];
       var39.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var36.x2[1];
       var38.x2[1] = _src.x2[1];
       var39.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
       orc_union32 _src;
       _src.i = var38.i;
       var40.i = _src.x2[0];
    }
    /* 3: select1wb */
    {
       orc_union16 _src;
       _src.i = var39.x2[0];
       var41.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var39.x2[1];
       var41.x2[1] = _src.x2[1];
    }
    /* 4: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var41.x2[0];
       _dest.x2[1] = var40.x2[0];
       var37.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var41.x2[1];
       _dest.x2[1] = var40.x2[1];
       var37.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_video_orc_pack_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var36.x2[0];
       var38.x2[0] = _src.x2[1];
       var39.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var36.x2[1];
       var38.x2[1] = _src.x2[1];
       var39.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
       orc_union32 _src;
       _src.i = var38.i;
       var40.i = _src.x2[0];
    }
    /* 3: select1wb */
    {
       orc_union16 _src;
       _src.i = var39.x2[0];
       var41.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var39.x2[1];
       var41.x2[1] = _src.x2[1];
    }
    /* 4: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var41.x2[0];
       _dest.x2[1] = var40.x2[0];
       var37.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var41.x2[1];
       _dest.x2[1] = var40.x2[1];
       var37.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var37;
  }

}

void
video_orc_pack_YUY2 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 89, 85, 89, 50, 11, 4, 4, 12, 8, 8, 20, 2, 20, 2, 
        20, 4, 20, 4, 21, 1, 198, 35, 34, 4, 190, 33, 35, 21, 1, 189, 
        32, 34, 21, 1, 196, 0, 32, 33, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_YUY2);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_YUY2");
      orc_program_set_backup_function (p, _backup_video_orc_pack_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_UYVY */
#ifdef DISABLE_ORC
void
video_orc_pack_UYVY (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var36.x2[0];
       var38.x2[0] = _src.x2[1];
       var39.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var36.x2[1];
       var38.x2[1] = _src.x2[1];
       var39.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
       orc_union32 _src;
       _src.i = var38.i;
       var40.i = _src.x2[0];
    }
    /* 3: select1wb */
    {
       orc_union16 _src;
       _src.i = var39.x2[0];
       var41.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var39.x2[1];
       var41.x2[1] = _src.x2[1];
    }
    /* 4: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var40.x2[0];
       _dest.x2[1] = var41.x2[0];
       var37.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var40.x2[1];
       _dest.x2[1] = var41.x2[1];
       var37.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_video_orc_pack_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var36.x2[0];
       var38.x2[0] = _src.x2[1];
       var39.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var36.x2[1];
       var38.x2[1] = _src.x2[1];
       var39.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
       orc_union32 _src;
       _src.i = var38.i;
       var40.i = _src.x2[0];
    }
    /* 3: select1wb */
    {
       orc_union16 _src;
       _src.i = var39.x2[0];
       var41.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var39.x2[1];
       var41.x2[1] = _src.x2[1];
    }
    /* 4: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var40.x2[0];
       _dest.x2[1] = var41.x2[0];
       var37.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var40.x2[1];
       _dest.x2[1] = var41.x2[1];
       var37.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var37;
  }

}

void
video_orc_pack_UYVY (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 85, 89, 86, 89, 11, 4, 4, 12, 8, 8, 20, 2, 20, 2, 
        20, 4, 20, 4, 21, 1, 198, 35, 34, 4, 190, 33, 35, 21, 1, 189, 
        32, 34, 21, 1, 196, 0, 33, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_UYVY);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_UYVY");
      orc_program_set_backup_function (p, _backup_video_orc_pack_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_UYVY */
#ifdef DISABLE_ORC
void
video_orc_unpack_UYVY (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 2: loadpb */
    var37.x2[0] = (int)0x000000ff; /* 255 or 1.25987e-321f */
    var37.x2[1] = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
       orc_union16 _src;
       _src.i = var36.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var36.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
    /* 3: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var39.x2[0];
       var41.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var39.x2[1];
       var41.x2[1] = _dest.i;
    }
    /* 4: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var40.i;
       var42.i = _dest.i;
    }
    /* 5: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[0];
       _dest.x2[1] = var42.x2[0];
       var38.x2[0] = _dest.i;
    }
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[1];
       _dest.x2[1] = var42.x2[1];
       var38.x2[1] = _dest.i;
    }
    /* 6: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 2: loadpb */
    var37.x2[0] = (int)0x000000ff; /* 255 or 1.25987e-321f */
    var37.x2[1] = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
       orc_union16 _src;
       _src.i = var36.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var36.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
    /* 3: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var39.x2[0];
       var41.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var39.x2[1];
       var41.x2[1] = _dest.i;
    }
    /* 4: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var40.i;
       var42.i = _dest.i;
    }
    /* 5: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[0];
       _dest.x2[1] = var42.x2[0];
       var38.x2[0] = _dest.i;
    }
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[1];
       _dest.x2[1] = var42.x2[1];
       var38.x2[1] = _dest.i;
    }
    /* 6: storeq */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_UYVY (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 85, 89, 86, 89, 11, 8, 8, 12, 4, 4, 14, 2, 
        255, 0, 0, 0, 20, 2, 20, 2, 20, 4, 20, 4, 21, 1, 199, 32, 
        33, 4, 21, 1, 196, 34, 16, 32, 195, 35, 33, 33, 21, 1, 195, 0, 
        34, 35, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_UYVY);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_UYVY");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_UYVY);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_YVYU */
#ifdef DISABLE_ORC
void
video_orc_unpack_YVYU (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 3: loadpb */
    var37.x2[0] = (int)0x000000ff; /* 255 or 1.25987e-321f */
    var37.x2[1] = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
       orc_union16 _src;
       _src.i = var36.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var36.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
    /* 2: swapw */
    var41.i = ORC_SWAP_W(var39.i);
    /* 4: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var40.x2[0];
       var42.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var40.x2[1];
       var42.x2[1] = _dest.i;
    }
    /* 5: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.i;
       _dest.x2[1] = var41.i;
       var43.i = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.x2[0];
       _dest.x2[1] = var43.x2[0];
       var38.x2[0] = _dest.i;
    }
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.x2[1];
       _dest.x2[1] = var43.x2[1];
       var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_YVYU (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var36;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 3: loadpb */
    var37.x2[0] = (int)0x000000ff; /* 255 or 1.25987e-321f */
    var37.x2[1] = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var36 = ptr4[i];
    /* 1: splitwb */
    {
       orc_union16 _src;
       _src.i = var36.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var36.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
    /* 2: swapw */
    var41.i = ORC_SWAP_W(var39.i);
    /* 4: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var40.x2[0];
       var42.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var40.x2[1];
       var42.x2[1] = _dest.i;
    }
    /* 5: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.i;
       _dest.x2[1] = var41.i;
       var43.i = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.x2[0];
       _dest.x2[1] = var43.x2[0];
       var38.x2[0] = _dest.i;
    }
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.x2[1];
       _dest.x2[1] = var43.x2[1];
       var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_YVYU (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 89, 86, 89, 85, 11, 8, 8, 12, 4, 4, 14, 2, 
        255, 0, 0, 0, 20, 2, 20, 2, 20, 4, 20, 4, 21, 1, 199, 33, 
        32, 4, 183, 33, 33, 21, 1, 196, 34, 16, 32, 195, 35, 33, 33, 21, 
        1, 195, 0, 34, 35, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_YVYU);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_YVYU");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_YVYU);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "swapw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_YVYU */
#ifdef DISABLE_ORC
void
video_orc_pack_YVYU (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var36.x2[0];
       var38.x2[0] = _src.x2[1];
       var39.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var36.x2[1];
       var38.x2[1] = _src.x2[1];
       var39.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
       orc_union32 _src;
       _src.i = var38.i;
       var40.i = _src.x2[0];
    }
    /* 3: select1wb */
    {
       orc_union16 _src;
       _src.i = var39.x2[0];
       var41.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var39.x2[1];
       var41.x2[1] = _src.x2[1];
    }
    /* 4: swapw */
    var42.i = ORC_SWAP_W(var40.i);
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var41.x2[0];
       _dest.x2[1] = var42.x2[0];
       var37.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var41.x2[1];
       _dest.x2[1] = var42.x2[1];
       var37.x2[1] = _dest.i;
    }
    /* 6: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_video_orc_pack_YVYU (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var36.x2[0];
       var38.x2[0] = _src.x2[1];
       var39.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var36.x2[1];
       var38.x2[1] = _src.x2[1];
       var39.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
       orc_union32 _src;
       _src.i = var38.i;
       var40.i = _src.x2[0];
    }
    /* 3: select1wb */
    {
       orc_union16 _src;
       _src.i = var39.x2[0];
       var41.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var39.x2[1];
       var41.x2[1] = _src.x2[1];
    }
    /* 4: swapw */
    var42.i = ORC_SWAP_W(var40.i);
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var41.x2[0];
       _dest.x2[1] = var42.x2[0];
       var37.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var41.x2[1];
       _dest.x2[1] = var42.x2[1];
       var37.x2[1] = _dest.i;
    }
    /* 6: storel */
    ptr0[i] = var37;
  }

}

void
video_orc_pack_YVYU (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 89, 86, 89, 85, 11, 4, 4, 12, 8, 8, 20, 2, 20, 2, 
        20, 4, 20, 4, 21, 1, 198, 35, 34, 4, 190, 33, 35, 21, 1, 189, 
        32, 34, 183, 33, 33, 21, 1, 196, 0, 32, 33, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_YVYU);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_YVYU");
      orc_program_set_backup_function (p, _backup_video_orc_pack_YVYU);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "swapw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_YUV9 */
#ifdef DISABLE_ORC
void
video_orc_unpack_YUV9 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union64 var39;
  orc_int8 var40;
  orc_int8 var41;
  orc_union16 var42;
  orc_union32 var43;
  orc_union32 var44;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;

    /* 4: loadpb */
    var37.x2[0] = (int)0x000000ff; /* 255 or 1.25987e-321f */
    var37.x2[1] = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var40 = ptr5[i>>1];
    /* 1: loadupdb */
    var41 = ptr6[i>>1];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var40;
       _dest.x2[1] = var41;
       var42.i = _dest.i;
    }
    /* 3: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.i;
       _dest.x2[1] = var42.i;
       var43.i = _dest.i;
    }
    /* 5: loadw */
    var38 = ptr4[i];
    /* 6: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var38.x2[0];
       var44.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var38.x2[1];
       var44.x2[1] = _dest.i;
    }
    /* 7: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.x2[0];
       _dest.x2[1] = var43.x2[0];
       var39.x2[0] = _dest.i;
    }
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.x2[1];
       _dest.x2[1] = var43.x2[1];
       var39.x2[1] = _dest.i;
    }
    /* 8: storeq */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_video_orc_unpack_YUV9 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var37;
#else
  orc_union16 var37;
#endif
  orc_union16 var38;
  orc_union64 var39;
  orc_int8 var40;
  orc_int8 var41;
  orc_union16 var42;
  orc_union32 var43;
  orc_union32 var44;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

    /* 4: loadpb */
    var37.x2[0] = (int)0x000000ff; /* 255 or 1.25987e-321f */
    var37.x2[1] = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var40 = ptr5[i>>1];
    /* 1: loadupdb */
    var41 = ptr6[i>>1];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var40;
       _dest.x2[1] = var41;
       var42.i = _dest.i;
    }
    /* 3: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.i;
       _dest.x2[1] = var42.i;
       var43.i = _dest.i;
    }
    /* 5: loadw */
    var38 = ptr4[i];
    /* 6: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var38.x2[0];
       var44.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var38.x2[1];
       var44.x2[1] = _dest.i;
    }
    /* 7: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.x2[0];
       _dest.x2[1] = var43.x2[0];
       var39.x2[0] = _dest.i;
    }
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.x2[1];
       _dest.x2[1] = var43.x2[1];
       var39.x2[1] = _dest.i;
    }
    /* 8: storeq */
    ptr0[i] = var39;
  }

}

void
video_orc_unpack_YUV9 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 89, 85, 86, 57, 11, 8, 8, 12, 2, 2, 12, 1, 
        1, 12, 1, 1, 14, 1, 255, 0, 0, 0, 20, 2, 20, 4, 20, 4, 
        20, 1, 20, 1, 45, 35, 5, 45, 36, 6, 196, 32, 35, 36, 195, 34, 
        32, 32, 21, 1, 196, 33, 16, 4, 21, 1, 195, 0, 33, 34, 2, 0, 

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_YUV9);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_YUV9");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_YUV9);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 1, "t5");

      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T4, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T5, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T4, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_Y42B */
#ifdef DISABLE_ORC
void
video_orc_unpack_Y42B (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var36;
  orc_int8 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_union16 var39;
  orc_union64 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;

    /* 3: loadpb */
    var38.x2[0] = (int)0x000000ff; /* 255 or 1.25987e-321f */
    var38.x2[1] = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var36 = ptr5[i];
    /* 1: loadb */
    var37 = ptr6[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var37;
       var41.i = _dest.i;
    }
    /* 4: loadw */
    var39 = ptr4[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var38.x2[0];
       _dest.x2[1] = var39.x2[0];
       var42.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var38.x2[1];
       _dest.x2[1] = var39.x2[1];
       var42.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.i;
       _dest.x2[1] = var41.i;
       var43.i = _dest.i;
    }
    /* 7: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.x2[0];
       _dest.x2[1] = var43.x2[0];
       var40.x2[0] = _dest.i;
    }
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.x2[1];
       _dest.x2[1] = var43.x2[1];
       var40.x2[1] = _dest.i;
    }
    /* 8: storeq */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_video_orc_unpack_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var36;
  orc_int8 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_union16 var39;
  orc_union64 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

    /* 3: loadpb */
    var38.x2[0] = (int)0x000000ff; /* 255 or 1.25987e-321f */
    var38.x2[1] = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var36 = ptr5[i];
    /* 1: loadb */
    var37 = ptr6[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var37;
       var41.i = _dest.i;
    }
    /* 4: loadw */
    var39 = ptr4[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var38.x2[0];
       _dest.x2[1] = var39.x2[0];
       var42.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var38.x2[1];
       _dest.x2[1] = var39.x2[1];
       var42.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.i;
       _dest.x2[1] = var41.i;
       var43.i = _dest.i;
    }
    /* 7: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.x2[0];
       _dest.x2[1] = var43.x2[0];
       var40.x2[0] = _dest.i;
    }
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.x2[1];
       _dest.x2[1] = var43.x2[1];
       var40.x2[1] = _dest.i;
    }
    /* 8: storeq */
    ptr0[i] = var40;
  }

}

void
video_orc_unpack_Y42B (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 89, 52, 50, 66, 11, 8, 8, 12, 2, 2, 12, 1, 
        1, 12, 1, 1, 14, 1, 255, 0, 0, 0, 20, 2, 20, 2, 20, 4, 
        20, 4, 196, 32, 5, 6, 21, 1, 196, 35, 16, 4, 195, 34, 32, 32, 
        21, 1, 195, 0, 35, 34, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_Y42B);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_Y42B");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_Y42B);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T4, ORC_VAR_C1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_Y42B */
#ifdef DISABLE_ORC
void
video_orc_pack_Y42B (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_int8 *)d2;
  ptr2 = (orc_int8 *)d3;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var35 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var35.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var35.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
       orc_union32 _src;
       _src.i = var39.i;
       var41.i = _src.x2[0];
    }
    /* 3: splitwb */
    {
       orc_union16 _src;
       _src.i = var41.i;
       var36 = _src.x2[1];
       var37 = _src.x2[0];
    }
    /* 4: storeb */
    ptr2[i] = var36;
    /* 5: storeb */
    ptr1[i] = var37;
    /* 6: select1wb */
    {
       orc_union16 _src;
       _src.i = var40.x2[0];
       var38.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var40.x2[1];
       var38.x2[1] = _src.x2[1];
    }
    /* 7: storew */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_pack_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_int8 *)ex->arrays[1];
  ptr2 = (orc_int8 *)ex->arrays[2];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var35 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var35.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var35.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
    /* 2: select0lw */
    {
       orc_union32 _src;
       _src.i = var39.i;
       var41.i = _src.x2[0];
    }
    /* 3: splitwb */
    {
       orc_union16 _src;
       _src.i = var41.i;
       var36 = _src.x2[1];
       var37 = _src.x2[0];
    }
    /* 4: storeb */
    ptr2[i] = var36;
    /* 5: storeb */
    ptr1[i] = var37;
    /* 6: select1wb */
    {
       orc_union16 _src;
       _src.i = var40.x2[0];
       var38.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var40.x2[1];
       var38.x2[1] = _src.x2[1];
    }
    /* 7: storew */
    ptr0[i] = var38;
  }

}

void
video_orc_pack_Y42B (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 89, 52, 50, 66, 11, 2, 2, 11, 1, 1, 11, 1, 1, 12, 
        8, 8, 20, 4, 20, 4, 20, 2, 21, 1, 198, 33, 32, 4, 190, 34, 
        33, 199, 2, 1, 34, 21, 1, 189, 0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_Y42B);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_Y42B");
      orc_program_set_backup_function (p, _backup_video_orc_pack_Y42B);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_Y444 */
#ifdef DISABLE_ORC
void
video_orc_unpack_Y444 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var34;
  orc_int8 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var36;
#else
  orc_int8 var36;
#endif
  orc_int8 var37;
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;

    /* 3: loadpb */
    var36 = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr5[i];
    /* 1: loadb */
    var35 = ptr6[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var34;
       _dest.x2[1] = var35;
       var39.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var37;
       var40.i = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var39.i;
       var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var34;
  orc_int8 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var36;
#else
  orc_int8 var36;
#endif
  orc_int8 var37;
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

    /* 3: loadpb */
    var36 = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr5[i];
    /* 1: loadb */
    var35 = ptr6[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var34;
       _dest.x2[1] = var35;
       var39.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var37;
       var40.i = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var39.i;
       var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_Y444 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 89, 52, 52, 52, 11, 4, 4, 12, 1, 1, 12, 1, 
        1, 12, 1, 1, 14, 1, 255, 0, 0, 0, 20, 2, 20, 2, 196, 32, 
        5, 6, 196, 33, 16, 4, 195, 0, 33, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_Y444);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_Y444");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_Y444);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_Y444 */
#ifdef DISABLE_ORC
void
video_orc_pack_Y444 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;

  ptr0 = (orc_int8 *)d1;
  ptr1 = (orc_int8 *)d2;
  ptr2 = (orc_int8 *)d3;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var34.i;
       var38.i = _src.x2[1];
       var39.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
       orc_union16 _src;
       _src.i = var38.i;
       var35 = _src.x2[1];
       var36 = _src.x2[0];
    }
    /* 3: storeb */
    ptr2[i] = var35;
    /* 4: storeb */
    ptr1[i] = var36;
    /* 5: select1wb */
    {
       orc_union16 _src;
       _src.i = var39.i;
       var37 = _src.x2[1];
    }
    /* 6: storeb */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_video_orc_pack_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr1 = (orc_int8 *)ex->arrays[1];
  ptr2 = (orc_int8 *)ex->arrays[2];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var34.i;
       var38.i = _src.x2[1];
       var39.i = _src.x2[0];
    }
    /* 2: splitwb */
    {
       orc_union16 _src;
       _src.i = var38.i;
       var35 = _src.x2[1];
       var36 = _src.x2[0];
    }
    /* 3: storeb */
    ptr2[i] = var35;
    /* 4: storeb */
    ptr1[i] = var36;
    /* 5: select1wb */
    {
       orc_union16 _src;
       _src.i = var39.i;
       var37 = _src.x2[1];
    }
    /* 6: storeb */
    ptr0[i] = var37;
  }

}

void
video_orc_pack_Y444 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 89, 52, 52, 52, 11, 1, 1, 11, 1, 1, 11, 1, 1, 12, 
        4, 4, 20, 2, 20, 2, 198, 33, 32, 4, 199, 2, 1, 33, 189, 0, 
        32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_Y444);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_Y444");
      orc_program_set_backup_function (p, _backup_video_orc_pack_Y444);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_GRAY8 */
#ifdef DISABLE_ORC
void
video_orc_unpack_GRAY8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var33;
#else
  orc_int8 var33;
#endif
  orc_int8 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union32 var36;
  orc_union16 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;

    /* 0: loadpb */
    var33 = (int)0x000000ff; /* 255 or 1.25987e-321f */
    /* 3: loadpw */
    var35.i = (int)0x00008080; /* 32896 or 1.62528e-319f */

  for (i = 0; i < n; i++) {
    /* 1: loadb */
    var34 = ptr4[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var33;
       _dest.x2[1] = var34;
       var37.i = _dest.i;
    }
    /* 4: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var37.i;
       _dest.x2[1] = var35.i;
       var36.i = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_video_orc_unpack_GRAY8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var33;
#else
  orc_int8 var33;
#endif
  orc_int8 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var35;
#else
  orc_union16 var35;
#endif
  orc_union32 var36;
  orc_union16 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];

    /* 0: loadpb */
    var33 = (int)0x000000ff; /* 255 or 1.25987e-321f */
    /* 3: loadpw */
    var35.i = (int)0x00008080; /* 32896 or 1.62528e-319f */

  for (i = 0; i < n; i++) {
    /* 1: loadb */
    var34 = ptr4[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var33;
       _dest.x2[1] = var34;
       var37.i = _dest.i;
    }
    /* 4: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var37.i;
       _dest.x2[1] = var35.i;
       var36.i = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
  }

}

void
video_orc_unpack_GRAY8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 22, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 71, 82, 65, 89, 56, 11, 4, 4, 12, 1, 1, 14, 
        1, 255, 0, 0, 0, 14, 2, 128, 128, 0, 0, 20, 2, 196, 32, 16, 
        4, 195, 0, 32, 17, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_GRAY8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_GRAY8");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_GRAY8);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_constant (p, 2, 0x00008080, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_GRAY8 */
#ifdef DISABLE_ORC
void
video_orc_pack_GRAY8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select0lw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var35.i = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var35.i;
       var34 = _src.x2[1];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_video_orc_pack_GRAY8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_union16 var35;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select0lw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var35.i = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var35.i;
       var34 = _src.x2[1];
    }
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
video_orc_pack_GRAY8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 20, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 71, 82, 65, 89, 56, 11, 1, 1, 12, 4, 4, 20, 2, 190, 
        32, 4, 189, 0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_GRAY8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_GRAY8");
      orc_program_set_backup_function (p, _backup_video_orc_pack_GRAY8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_BGRA */
#ifdef DISABLE_ORC
void
video_orc_unpack_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L(var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_video_orc_unpack_BGRA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L(var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
video_orc_unpack_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 66, 71, 82, 65, 11, 4, 4, 12, 4, 4, 184, 0, 
        4, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGRA);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_BGRA");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGRA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_BGRA */
#ifdef DISABLE_ORC
void
video_orc_pack_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L(var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_video_orc_pack_BGRA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var32 = ptr4[i];
    /* 1: swapl */
    var33.i = ORC_SWAP_L(var32.i);
    /* 2: storel */
    ptr0[i] = var33;
  }

}

void
video_orc_pack_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 66, 71, 82, 65, 11, 4, 4, 12, 4, 4, 184, 0, 4, 2, 
        0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_BGRA);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_BGRA");
      orc_program_set_backup_function (p, _backup_video_orc_pack_BGRA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "swapl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_RGBA */
#ifdef DISABLE_ORC
void
video_orc_pack_RGBA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: shrul */
    var36.i = ((orc_uint32)var35.i) >> 8;
    /* 2: shll */
    var37.i = ((orc_uint32)var35.i) << 24;
    /* 3: orl */
    var34.i = var37.i | var36.i;
    /* 4: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_video_orc_pack_RGBA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: shrul */
    var36.i = ((orc_uint32)var35.i) >> 8;
    /* 2: shll */
    var37.i = ((orc_uint32)var35.i) << 24;
    /* 3: orl */
    var34.i = var37.i | var36.i;
    /* 4: storel */
    ptr0[i] = var34;
  }

}

void
video_orc_pack_RGBA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 82, 71, 66, 65, 11, 4, 4, 12, 4, 4, 14, 4, 8, 0, 
        0, 0, 14, 4, 24, 0, 0, 0, 20, 4, 20, 4, 113, 33, 4, 126, 
        32, 33, 16, 124, 33, 33, 17, 123, 0, 33, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_RGBA);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_RGBA");
      orc_program_set_backup_function (p, _backup_video_orc_pack_RGBA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_constant (p, 4, 0x00000018, "c2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_RGBA */
#ifdef DISABLE_ORC
void
video_orc_unpack_RGBA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: shll */
    var36.i = ((orc_uint32)var35.i) << 8;
    /* 2: shrul */
    var37.i = ((orc_uint32)var35.i) >> 24;
    /* 3: orl */
    var34.i = var37.i | var36.i;
    /* 4: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_video_orc_unpack_RGBA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: shll */
    var36.i = ((orc_uint32)var35.i) << 8;
    /* 2: shrul */
    var37.i = ((orc_uint32)var35.i) >> 24;
    /* 3: orl */
    var34.i = var37.i | var36.i;
    /* 4: storel */
    ptr0[i] = var34;
  }

}

void
video_orc_unpack_RGBA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 82, 71, 66, 65, 11, 4, 4, 12, 4, 4, 14, 4, 
        8, 0, 0, 0, 14, 4, 24, 0, 0, 0, 20, 4, 20, 4, 113, 33, 
        4, 124, 32, 33, 16, 126, 33, 33, 17, 123, 0, 33, 32, 2, 0,       };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGBA);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_RGBA");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGBA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_constant (p, 4, 0x00000018, "c2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_ABGR */
#ifdef DISABLE_ORC
void
video_orc_unpack_ABGR (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: swapl */
    var36.i = ORC_SWAP_L(var34.i);
    /* 2: shll */
    var37.i = ((orc_uint32)var36.i) << 8;
    /* 3: shrul */
    var38.i = ((orc_uint32)var36.i) >> 24;
    /* 4: orl */
    var35.i = var38.i | var37.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_video_orc_unpack_ABGR (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: swapl */
    var36.i = ORC_SWAP_L(var34.i);
    /* 2: shll */
    var37.i = ((orc_uint32)var36.i) << 8;
    /* 3: shrul */
    var38.i = ((orc_uint32)var36.i) >> 24;
    /* 4: orl */
    var35.i = var38.i | var37.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

void
video_orc_unpack_ABGR (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 65, 66, 71, 82, 11, 4, 4, 12, 4, 4, 14, 4, 
        8, 0, 0, 0, 14, 4, 24, 0, 0, 0, 20, 4, 20, 4, 184, 33, 
        4, 124, 32, 33, 16, 126, 33, 33, 17, 123, 0, 33, 32, 2, 0,       };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_ABGR);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_ABGR");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_ABGR);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_constant (p, 4, 0x00000018, "c2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "swapl", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_ABGR */
#ifdef DISABLE_ORC
void
video_orc_pack_ABGR (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: swapl */
    var36.i = ORC_SWAP_L(var34.i);
    /* 2: shll */
    var37.i = ((orc_uint32)var36.i) << 8;
    /* 3: shrul */
    var38.i = ((orc_uint32)var36.i) >> 24;
    /* 4: orl */
    var35.i = var38.i | var37.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_video_orc_pack_ABGR (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 1: swapl */
    var36.i = ORC_SWAP_L(var34.i);
    /* 2: shll */
    var37.i = ((orc_uint32)var36.i) << 8;
    /* 3: shrul */
    var38.i = ((orc_uint32)var36.i) >> 24;
    /* 4: orl */
    var35.i = var38.i | var37.i;
    /* 5: storel */
    ptr0[i] = var35;
  }

}

void
video_orc_pack_ABGR (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 65, 66, 71, 82, 11, 4, 4, 12, 4, 4, 14, 4, 8, 0, 
        0, 0, 14, 4, 24, 0, 0, 0, 20, 4, 20, 4, 184, 33, 4, 124, 
        32, 33, 16, 126, 33, 33, 17, 123, 0, 33, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_ABGR);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_ABGR");
      orc_program_set_backup_function (p, _backup_video_orc_pack_ABGR);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000008, "c1");
      orc_program_add_constant (p, 4, 0x00000018, "c2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "swapl", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_NV12 */
#ifdef DISABLE_ORC
void
video_orc_unpack_NV12 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union64 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;

    /* 3: loadpb */
    var36.x2[0] = (int)0x000000ff; /* 255 or 1.25987e-321f */
    var36.x2[1] = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr5[i];
    /* 1: loadw */
    var35 = ptr5[i];
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var34.i;
       _dest.x2[1] = var35.i;
       var39.i = _dest.i;
    }
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[0];
       _dest.x2[1] = var37.x2[0];
       var40.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[1];
       _dest.x2[1] = var37.x2[1];
       var40.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var40.x2[0];
       _dest.x2[1] = var39.x2[0];
       var38.x2[0] = _dest.i;
    }
    {
       orc_union32 _dest;
       _dest.x2[0] = var40.x2[1];
       _dest.x2[1] = var39.x2[1];
       var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_NV12 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union64 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];

    /* 3: loadpb */
    var36.x2[0] = (int)0x000000ff; /* 255 or 1.25987e-321f */
    var36.x2[1] = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr5[i];
    /* 1: loadw */
    var35 = ptr5[i];
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var34.i;
       _dest.x2[1] = var35.i;
       var39.i = _dest.i;
    }
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[0];
       _dest.x2[1] = var37.x2[0];
       var40.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[1];
       _dest.x2[1] = var37.x2[1];
       var40.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var40.x2[0];
       _dest.x2[1] = var39.x2[0];
       var38.x2[0] = _dest.i;
    }
    {
       orc_union32 _dest;
       _dest.x2[0] = var40.x2[1];
       _dest.x2[1] = var39.x2[1];
       var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_NV12 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 78, 86, 49, 50, 11, 8, 8, 12, 2, 2, 12, 2, 
        2, 14, 1, 255, 0, 0, 0, 20, 4, 20, 4, 195, 33, 5, 5, 21, 
        1, 196, 32, 16, 4, 21, 1, 195, 0, 32, 33, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_NV12);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_NV12");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_NV12);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_NV12 */
#ifdef DISABLE_ORC
void
video_orc_pack_NV12 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union32 var37;
  orc_union32 var38;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var34 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var34.x2[0];
       var37.x2[0] = _src.x2[1];
       var38.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var34.x2[1];
       var37.x2[1] = _src.x2[1];
       var38.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var38.x2[0];
       var35.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var38.x2[1];
       var35.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var35;
    /* 4: select0lw */
    {
       orc_union32 _src;
       _src.i = var37.i;
       var36.i = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var36;
  }

}

#else
static void
_backup_video_orc_pack_NV12 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union32 var37;
  orc_union32 var38;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var34 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var34.x2[0];
       var37.x2[0] = _src.x2[1];
       var38.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var34.x2[1];
       var37.x2[1] = _src.x2[1];
       var38.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var38.x2[0];
       var35.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var38.x2[1];
       var35.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var35;
    /* 4: select0lw */
    {
       orc_union32 _src;
       _src.i = var37.i;
       var36.i = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var36;
  }

}

void
video_orc_pack_NV12 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 78, 86, 49, 50, 11, 2, 2, 11, 2, 2, 12, 8, 8, 20, 
        4, 20, 4, 21, 1, 198, 33, 32, 4, 21, 1, 189, 0, 32, 190, 1, 
        33, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_NV12);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_NV12");
      orc_program_set_backup_function (p, _backup_video_orc_pack_NV12);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_NV21 */
#ifdef DISABLE_ORC
void
video_orc_unpack_NV21 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;

    /* 3: loadpb */
    var36.x2[0] = (int)0x000000ff; /* 255 or 1.25987e-321f */
    var36.x2[1] = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr5[i];
    /* 1: swapw */
    var39.i = ORC_SWAP_W(var35.i);
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var39.i;
       _dest.x2[1] = var39.i;
       var40.i = _dest.i;
    }
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[0];
       _dest.x2[1] = var37.x2[0];
       var41.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[1];
       _dest.x2[1] = var37.x2[1];
       var41.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[0];
       _dest.x2[1] = var40.x2[0];
       var38.x2[0] = _dest.i;
    }
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[1];
       _dest.x2[1] = var40.x2[1];
       var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_NV21 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];

    /* 3: loadpb */
    var36.x2[0] = (int)0x000000ff; /* 255 or 1.25987e-321f */
    var36.x2[1] = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr5[i];
    /* 1: swapw */
    var39.i = ORC_SWAP_W(var35.i);
    /* 2: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var39.i;
       _dest.x2[1] = var39.i;
       var40.i = _dest.i;
    }
    /* 4: loadw */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[0];
       _dest.x2[1] = var37.x2[0];
       var41.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[1];
       _dest.x2[1] = var37.x2[1];
       var41.x2[1] = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[0];
       _dest.x2[1] = var40.x2[0];
       var38.x2[0] = _dest.i;
    }
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[1];
       _dest.x2[1] = var40.x2[1];
       var38.x2[1] = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_NV21 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 78, 86, 50, 49, 11, 8, 8, 12, 2, 2, 12, 2, 
        2, 14, 1, 255, 0, 0, 0, 20, 2, 20, 4, 20, 4, 183, 32, 5, 
        195, 34, 32, 32, 21, 1, 196, 33, 16, 4, 21, 1, 195, 0, 33, 34, 
        2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_NV21);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_NV21");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_NV21);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append_2 (p, "swapw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_NV21 */
#ifdef DISABLE_ORC
void
video_orc_pack_NV21 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var35 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var35.x2[0];
       var38.x2[0] = _src.x2[1];
       var39.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var35.x2[1];
       var38.x2[1] = _src.x2[1];
       var39.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var39.x2[0];
       var36.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var39.x2[1];
       var36.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var36;
    /* 4: select0lw */
    {
       orc_union32 _src;
       _src.i = var38.i;
       var40.i = _src.x2[0];
    }
    /* 5: swapw */
    var37.i = ORC_SWAP_W(var40.i);
    /* 6: storew */
    ptr1[i] = var37;
  }

}

#else
static void
_backup_video_orc_pack_NV21 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union16 var40;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var35 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var35.x2[0];
       var38.x2[0] = _src.x2[1];
       var39.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var35.x2[1];
       var38.x2[1] = _src.x2[1];
       var39.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var39.x2[0];
       var36.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var39.x2[1];
       var36.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var36;
    /* 4: select0lw */
    {
       orc_union32 _src;
       _src.i = var38.i;
       var40.i = _src.x2[0];
    }
    /* 5: swapw */
    var37.i = ORC_SWAP_W(var40.i);
    /* 6: storew */
    ptr1[i] = var37;
  }

}

void
video_orc_pack_NV21 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 78, 86, 50, 49, 11, 2, 2, 11, 2, 2, 12, 8, 8, 20, 
        4, 20, 4, 20, 2, 21, 1, 198, 33, 32, 4, 21, 1, 189, 0, 32, 
        190, 34, 33, 183, 1, 34, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_NV21);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_NV21");
      orc_program_set_backup_function (p, _backup_video_orc_pack_NV21);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "swapw", 0, ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_NV24 */
#ifdef DISABLE_ORC
void
video_orc_unpack_NV24 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var33;
#else
  orc_int8 var33;
#endif
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_union16 *)s2;

    /* 0: loadpb */
    var33 = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 1: loadb */
    var34 = ptr4[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var33;
       _dest.x2[1] = var34;
       var37.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr5[i];
    /* 4: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var37.i;
       _dest.x2[1] = var35.i;
       var36.i = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_video_orc_unpack_NV24 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var33;
#else
  orc_int8 var33;
#endif
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];

    /* 0: loadpb */
    var33 = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 1: loadb */
    var34 = ptr4[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var33;
       _dest.x2[1] = var34;
       var37.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr5[i];
    /* 4: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var37.i;
       _dest.x2[1] = var35.i;
       var36.i = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
  }

}

void
video_orc_unpack_NV24 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 78, 86, 50, 52, 11, 4, 4, 12, 1, 1, 12, 2, 
        2, 14, 1, 255, 0, 0, 0, 20, 2, 196, 32, 16, 4, 195, 0, 32, 
        5, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_NV24);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_NV24");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_NV24);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 1, 0x000000ff, "c1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_NV24 */
#ifdef DISABLE_ORC
void
video_orc_pack_NV24 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_union16 var36;

  ptr0 = (orc_int8 *)d1;
  ptr1 = (orc_union16 *)d2;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var34.i = _src.x2[1];
       var36.i = _src.x2[0];
    }
    /* 2: storew */
    ptr1[i] = var34;
    /* 3: select1wb */
    {
       orc_union16 _src;
       _src.i = var36.i;
       var35 = _src.x2[1];
    }
    /* 4: storeb */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_video_orc_pack_NV24 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_union16 var36;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var34.i = _src.x2[1];
       var36.i = _src.x2[0];
    }
    /* 2: storew */
    ptr1[i] = var34;
    /* 3: select1wb */
    {
       orc_union16 _src;
       _src.i = var36.i;
       var35 = _src.x2[1];
    }
    /* 4: storeb */
    ptr0[i] = var35;
  }

}

void
video_orc_pack_NV24 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 78, 86, 50, 52, 11, 1, 1, 11, 2, 2, 12, 4, 4, 20, 
        2, 198, 1, 32, 4, 189, 0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_NV24);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_NV24");
      orc_program_set_backup_function (p, _backup_video_orc_pack_NV24);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_A420 */
#ifdef DISABLE_ORC
void
video_orc_unpack_A420 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_int8 *)s4;


  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var39 = ptr5[i>>1];
    /* 1: loadupdb */
    var40 = ptr6[i>>1];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var39;
       _dest.x2[1] = var40;
       var41.i = _dest.i;
    }
    /* 3: loadb */
    var36 = ptr7[i];
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var37;
       var42.i = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.i;
       _dest.x2[1] = var41.i;
       var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_unpack_A420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];


  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var39 = ptr5[i>>1];
    /* 1: loadupdb */
    var40 = ptr6[i>>1];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var39;
       _dest.x2[1] = var40;
       var41.i = _dest.i;
    }
    /* 3: loadb */
    var36 = ptr7[i];
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var37;
       var42.i = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.i;
       _dest.x2[1] = var41.i;
       var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
  }

}

void
video_orc_unpack_A420 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 21, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 65, 52, 50, 48, 11, 4, 4, 12, 1, 1, 12, 1, 
        1, 12, 1, 1, 12, 1, 1, 20, 2, 20, 2, 20, 1, 20, 1, 45, 
        34, 5, 45, 35, 6, 196, 32, 34, 35, 196, 33, 7, 4, 195, 0, 33, 
        32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_A420);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_A420");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_A420);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");

      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T3, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T4, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_A420 */
#ifdef DISABLE_ORC
void
video_orc_pack_A420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  orc_union16 * ORC_RESTRICT ptr3;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_int8 *)d2;
  ptr2 = (orc_int8 *)d3;
  ptr3 = (orc_union16 *)d4;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var36.x2[0];
       var41.x2[0] = _src.x2[1];
       var42.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var36.x2[1];
       var41.x2[1] = _src.x2[1];
       var42.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var42.x2[0];
       var37.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var42.x2[1];
       var37.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var37;
    /* 4: select0wb */
    {
       orc_union16 _src;
       _src.i = var42.x2[0];
       var38.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var42.x2[1];
       var38.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr3[i] = var38;
    /* 6: splitwb */
    {
       orc_union16 _src;
       _src.i = var41.x2[0];
       var43.x2[0] = _src.x2[1];
       var44.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var41.x2[1];
       var43.x2[1] = _src.x2[1];
       var44.x2[1] = _src.x2[0];
    }
    /* 7: select0wb */
    {
       orc_union16 _src;
       _src.i = var44.i;
       var39 = _src.x2[0];
    }
    /* 8: storeb */
    ptr1[i] = var39;
    /* 9: select0wb */
    {
       orc_union16 _src;
       _src.i = var43.i;
       var40 = _src.x2[0];
    }
    /* 10: storeb */
    ptr2[i] = var40;
  }

}

#else
static void
_backup_video_orc_pack_A420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  orc_union16 * ORC_RESTRICT ptr3;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_int8 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_int8 *)ex->arrays[1];
  ptr2 = (orc_int8 *)ex->arrays[2];
  ptr3 = (orc_union16 *)ex->arrays[3];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var36 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var36.x2[0];
       var41.x2[0] = _src.x2[1];
       var42.x2[0] = _src.x2[0];
    }
    {
       orc_union32 _src;
       _src.i = var36.x2[1];
       var41.x2[1] = _src.x2[1];
       var42.x2[1] = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var42.x2[0];
       var37.x2[0] = _src.x2[1];
    }
    {
       orc_union16 _src;
       _src.i = var42.x2[1];
       var37.x2[1] = _src.x2[1];
    }
    /* 3: storew */
    ptr0[i] = var37;
    /* 4: select0wb */
    {
       orc_union16 _src;
       _src.i = var42.x2[0];
       var38.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var42.x2[1];
       var38.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr3[i] = var38;
    /* 6: splitwb */
    {
       orc_union16 _src;
       _src.i = var41.x2[0];
       var43.x2[0] = _src.x2[1];
       var44.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var41.x2[1];
       var43.x2[1] = _src.x2[1];
       var44.x2[1] = _src.x2[0];
    }
    /* 7: select0wb */
    {
       orc_union16 _src;
       _src.i = var44.i;
       var39 = _src.x2[0];
    }
    /* 8: storeb */
    ptr1[i] = var39;
    /* 9: select0wb */
    {
       orc_union16 _src;
       _src.i = var43.i;
       var40 = _src.x2[0];
    }
    /* 10: storeb */
    ptr2[i] = var40;
  }

}

void
video_orc_pack_A420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 65, 52, 50, 48, 11, 2, 2, 11, 1, 1, 11, 1, 1, 11, 
        2, 2, 12, 8, 8, 20, 4, 20, 4, 20, 2, 20, 2, 21, 1, 198, 
        33, 32, 4, 21, 1, 189, 0, 32, 21, 1, 188, 3, 32, 21, 1, 199, 
        35, 34, 33, 188, 1, 34, 188, 2, 35, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_A420);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_A420");
      orc_program_set_backup_function (p, _backup_video_orc_pack_A420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_destination (p, 2, "d4");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 1, ORC_VAR_D4, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_D3, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_D4] = d4;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_AY */
#ifdef DISABLE_ORC
void
video_orc_pack_AY (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;

  ptr0 = (orc_int8 *)d1;
  ptr1 = (orc_int8 *)d2;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select0lw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var36.i = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var36.i;
       var34 = _src.x2[1];
    }
    /* 3: storeb */
    ptr0[i] = var34;
    /* 4: select0wb */
    {
       orc_union16 _src;
       _src.i = var36.i;
       var35 = _src.x2[0];
    }
    /* 5: storeb */
    ptr1[i] = var35;
  }

}

#else
static void
_backup_video_orc_pack_AY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_int8 var34;
  orc_int8 var35;
  orc_union16 var36;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr1 = (orc_int8 *)ex->arrays[1];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 1: select0lw */
    {
       orc_union32 _src;
       _src.i = var33.i;
       var36.i = _src.x2[0];
    }
    /* 2: select1wb */
    {
       orc_union16 _src;
       _src.i = var36.i;
       var34 = _src.x2[1];
    }
    /* 3: storeb */
    ptr0[i] = var34;
    /* 4: select0wb */
    {
       orc_union16 _src;
       _src.i = var36.i;
       var35 = _src.x2[0];
    }
    /* 5: storeb */
    ptr1[i] = var35;
  }

}

void
video_orc_pack_AY (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 17, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 65, 89, 11, 1, 1, 11, 1, 1, 12, 4, 4, 20, 2, 190, 
        32, 4, 189, 0, 32, 188, 1, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_AY);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_AY");
      orc_program_set_backup_function (p, _backup_video_orc_pack_AY);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_RGB15_le */
#ifdef DISABLE_ORC
void
video_orc_unpack_RGB15_le (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union32 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 8: loadpw */
    var41.i = (int)0x00000210; /* 528 or 2.60867e-321f */
    /* 10: loadpw */
    var42.i = (int)0x00004200; /* 16896 or 8.34773e-320f */
    /* 13: loadpw */
    var43.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var45 = ptr4[i];
    /* 2: andw */
    var46.i = var45.i & var38.i;
    /* 4: andw */
    var47.i = var45.i & var39.i;
    /* 6: andw */
    var48.i = var45.i & var40.i;
    /* 7: shlw */
    var49.i = ((orc_uint16)var48.i) << 5;
    /* 9: mulhsw */
    var50.i = (var46.i * var41.i) >> 16;
    /* 11: mulhsw */
    var51.i = (var47.i * var42.i) >> 16;
    /* 12: mulhsw */
    var52.i = (var49.i * var42.i) >> 16;
    /* 14: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var43.i;
       _dest.x2[1] = var51.i;
       var53.i = _dest.i;
    }
    /* 15: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var50.i;
       _dest.x2[1] = var52.i;
       var54.i = _dest.i;
    }
    /* 16: shll */
    var55.i = ((orc_uint32)var54.i) << 8;
    /* 17: orl */
    var44.i = var53.i | var55.i;
    /* 18: storel */
    ptr0[i] = var44;
  }

}

#else
static void
_backup_video_orc_unpack_RGB15_le (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union32 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 8: loadpw */
    var41.i = (int)0x00000210; /* 528 or 2.60867e-321f */
    /* 10: loadpw */
    var42.i = (int)0x00004200; /* 16896 or 8.34773e-320f */
    /* 13: loadpw */
    var43.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var45 = ptr4[i];
    /* 2: andw */
    var46.i = var45.i & var38.i;
    /* 4: andw */
    var47.i = var45.i & var39.i;
    /* 6: andw */
    var48.i = var45.i & var40.i;
    /* 7: shlw */
    var49.i = ((orc_uint16)var48.i) << 5;
    /* 9: mulhsw */
    var50.i = (var46.i * var41.i) >> 16;
    /* 11: mulhsw */
    var51.i = (var47.i * var42.i) >> 16;
    /* 12: mulhsw */
    var52.i = (var49.i * var42.i) >> 16;
    /* 14: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var43.i;
       _dest.x2[1] = var51.i;
       var53.i = _dest.i;
    }
    /* 15: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var50.i;
       _dest.x2[1] = var52.i;
       var54.i = _dest.i;
    }
    /* 16: shll */
    var55.i = ((orc_uint32)var54.i) << 8;
    /* 17: orl */
    var44.i = var53.i | var55.i;
    /* 18: storel */
    ptr0[i] = var44;
  }

}

void
video_orc_unpack_RGB15_le (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 25, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 82, 71, 66, 49, 53, 95, 108, 101, 11, 4, 4, 12, 
        2, 2, 14, 2, 0, 124, 0, 0, 14, 2, 224, 3, 0, 0, 14, 2, 
        31, 0, 0, 0, 14, 2, 5, 0, 0, 0, 14, 2, 16, 2, 0, 0, 
        14, 2, 0, 66, 0, 0, 14, 2, 255, 0, 0, 0, 14, 4, 8, 0, 
        0, 0, 20, 2, 20, 2, 20, 2, 20, 2, 20, 4, 20, 4, 82, 32, 
        4, 73, 33, 32, 16, 73, 34, 32, 17, 73, 35, 32, 18, 93, 35, 35, 
        19, 90, 33, 33, 20, 90, 34, 34, 21, 90, 35, 35, 21, 195, 36, 22, 
        34, 195, 37, 33, 35, 124, 37, 37, 23, 123, 0, 36, 37, 2, 0,       };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGB15_le);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_RGB15_le");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGB15_le);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0x00007c00, "c1");
      orc_program_add_constant (p, 2, 0x000003e0, "c2");
      orc_program_add_constant (p, 2, 0x0000001f, "c3");
      orc_program_add_constant (p, 2, 0x00000005, "c4");
      orc_program_add_constant (p, 2, 0x00000210, "c5");
      orc_program_add_constant (p, 2, 0x00004200, "c6");
      orc_program_add_constant (p, 2, 0x000000ff, "c7");
      orc_program_add_constant (p, 4, 0x00000008, "c8");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 4, "t6");

      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T5, ORC_VAR_C7, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T6, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_C8, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_RGB15_be */
#ifdef DISABLE_ORC
void
video_orc_unpack_RGB15_be (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union32 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 8: loadpw */
    var41.i = (int)0x00000210; /* 528 or 2.60867e-321f */
    /* 10: loadpw */
    var42.i = (int)0x00004200; /* 16896 or 8.34773e-320f */
    /* 13: loadpw */
    var43.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var45 = ptr4[i];
    /* 2: andw */
    var46.i = var45.i & var38.i;
    /* 4: andw */
    var47.i = var45.i & var39.i;
    /* 6: andw */
    var48.i = var45.i & var40.i;
    /* 7: shlw */
    var49.i = ((orc_uint16)var48.i) << 5;
    /* 9: mulhsw */
    var50.i = (var46.i * var41.i) >> 16;
    /* 11: mulhsw */
    var51.i = (var47.i * var42.i) >> 16;
    /* 12: mulhsw */
    var52.i = (var49.i * var42.i) >> 16;
    /* 14: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var43.i;
       _dest.x2[1] = var51.i;
       var53.i = _dest.i;
    }
    /* 15: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var50.i;
       _dest.x2[1] = var52.i;
       var54.i = _dest.i;
    }
    /* 16: shll */
    var55.i = ((orc_uint32)var53.i) << 8;
    /* 17: orl */
    var44.i = var55.i | var54.i;
    /* 18: storel */
    ptr0[i] = var44;
  }

}

#else
static void
_backup_video_orc_unpack_RGB15_be (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union32 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 8: loadpw */
    var41.i = (int)0x00000210; /* 528 or 2.60867e-321f */
    /* 10: loadpw */
    var42.i = (int)0x00004200; /* 16896 or 8.34773e-320f */
    /* 13: loadpw */
    var43.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var45 = ptr4[i];
    /* 2: andw */
    var46.i = var45.i & var38.i;
    /* 4: andw */
    var47.i = var45.i & var39.i;
    /* 6: andw */
    var48.i = var45.i & var40.i;
    /* 7: shlw */
    var49.i = ((orc_uint16)var48.i) << 5;
    /* 9: mulhsw */
    var50.i = (var46.i * var41.i) >> 16;
    /* 11: mulhsw */
    var51.i = (var47.i * var42.i) >> 16;
    /* 12: mulhsw */
    var52.i = (var49.i * var42.i) >> 16;
    /* 14: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var43.i;
       _dest.x2[1] = var51.i;
       var53.i = _dest.i;
    }
    /* 15: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var50.i;
       _dest.x2[1] = var52.i;
       var54.i = _dest.i;
    }
    /* 16: shll */
    var55.i = ((orc_uint32)var53.i) << 8;
    /* 17: orl */
    var44.i = var55.i | var54.i;
    /* 18: storel */
    ptr0[i] = var44;
  }

}

void
video_orc_unpack_RGB15_be (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 25, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 82, 71, 66, 49, 53, 95, 98, 101, 11, 4, 4, 12, 
        2, 2, 14, 2, 0, 124, 0, 0, 14, 2, 224, 3, 0, 0, 14, 2, 
        31, 0, 0, 0, 14, 2, 5, 0, 0, 0, 14, 2, 16, 2, 0, 0, 
        14, 2, 0, 66, 0, 0, 14, 2, 255, 0, 0, 0, 14, 4, 8, 0, 
        0, 0, 20, 2, 20, 2, 20, 2, 20, 2, 20, 4, 20, 4, 82, 32, 
        4, 73, 33, 32, 16, 73, 34, 32, 17, 73, 35, 32, 18, 93, 35, 35, 
        19, 90, 33, 33, 20, 90, 34, 34, 21, 90, 35, 35, 21, 195, 36, 22, 
        34, 195, 37, 33, 35, 124, 36, 36, 23, 123, 0, 36, 37, 2, 0,       };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGB15_be);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_RGB15_be");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGB15_be);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0x00007c00, "c1");
      orc_program_add_constant (p, 2, 0x000003e0, "c2");
      orc_program_add_constant (p, 2, 0x0000001f, "c3");
      orc_program_add_constant (p, 2, 0x00000005, "c4");
      orc_program_add_constant (p, 2, 0x00000210, "c5");
      orc_program_add_constant (p, 2, 0x00004200, "c6");
      orc_program_add_constant (p, 2, 0x000000ff, "c7");
      orc_program_add_constant (p, 4, 0x00000008, "c8");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 4, "t6");

      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T5, ORC_VAR_C7, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T6, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C8, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_RGB15_le_trunc */
#ifdef DISABLE_ORC
void
video_orc_unpack_RGB15_le_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union32 var50;
  orc_union32 var51;
  orc_union32 var52;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 10: loadpw */
    var41.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var43 = ptr4[i];
    /* 2: andw */
    var44.i = var43.i & var38.i;
    /* 4: andw */
    var45.i = var43.i & var39.i;
    /* 6: andw */
    var46.i = var43.i & var40.i;
    /* 7: shruw */
    var47.i = ((orc_uint16)var44.i) >> 7;
    /* 8: shruw */
    var48.i = ((orc_uint16)var45.i) >> 2;
    /* 9: shlw */
    var49.i = ((orc_uint16)var46.i) << 3;
    /* 11: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.i;
       _dest.x2[1] = var48.i;
       var50.i = _dest.i;
    }
    /* 12: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var47.i;
       _dest.x2[1] = var49.i;
       var51.i = _dest.i;
    }
    /* 13: shll */
    var52.i = ((orc_uint32)var51.i) << 8;
    /* 14: orl */
    var42.i = var50.i | var52.i;
    /* 15: storel */
    ptr0[i] = var42;
  }

}

#else
static void
_backup_video_orc_unpack_RGB15_le_trunc (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union32 var50;
  orc_union32 var51;
  orc_union32 var52;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 10: loadpw */
    var41.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var43 = ptr4[i];
    /* 2: andw */
    var44.i = var43.i & var38.i;
    /* 4: andw */
    var45.i = var43.i & var39.i;
    /* 6: andw */
    var46.i = var43.i & var40.i;
    /* 7: shruw */
    var47.i = ((orc_uint16)var44.i) >> 7;
    /* 8: shruw */
    var48.i = ((orc_uint16)var45.i) >> 2;
    /* 9: shlw */
    var49.i = ((orc_uint16)var46.i) << 3;
    /* 11: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.i;
       _dest.x2[1] = var48.i;
       var50.i = _dest.i;
    }
    /* 12: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var47.i;
       _dest.x2[1] = var49.i;
       var51.i = _dest.i;
    }
    /* 13: shll */
    var52.i = ((orc_uint32)var51.i) << 8;
    /* 14: orl */
    var42.i = var50.i | var52.i;
    /* 15: storel */
    ptr0[i] = var42;
  }

}

void
video_orc_unpack_RGB15_le_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 82, 71, 66, 49, 53, 95, 108, 101, 95, 116, 114, 117, 
        110, 99, 11, 4, 4, 12, 2, 2, 14, 2, 0, 124, 0, 0, 14, 2, 
        224, 3, 0, 0, 14, 2, 31, 0, 0, 0, 14, 2, 7, 0, 0, 0, 
        14, 2, 2, 0, 0, 0, 14, 2, 3, 0, 0, 0, 14, 2, 255, 0, 
        0, 0, 14, 4, 8, 0, 0, 0, 20, 2, 20, 2, 20, 2, 20, 2, 
        20, 4, 20, 4, 82, 32, 4, 73, 33, 32, 16, 73, 34, 32, 17, 73, 
        35, 32, 18, 95, 33, 33, 19, 95, 34, 34, 20, 93, 35, 35, 21, 195, 
        36, 22, 34, 195, 37, 33, 35, 124, 37, 37, 23, 123, 0, 36, 37, 2, 
        0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGB15_le_trunc);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_RGB15_le_trunc");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGB15_le_trunc);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0x00007c00, "c1");
      orc_program_add_constant (p, 2, 0x000003e0, "c2");
      orc_program_add_constant (p, 2, 0x0000001f, "c3");
      orc_program_add_constant (p, 2, 0x00000007, "c4");
      orc_program_add_constant (p, 2, 0x00000002, "c5");
      orc_program_add_constant (p, 2, 0x00000003, "c6");
      orc_program_add_constant (p, 2, 0x000000ff, "c7");
      orc_program_add_constant (p, 4, 0x00000008, "c8");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 4, "t6");

      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T5, ORC_VAR_C7, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T6, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_C8, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_RGB15_be_trunc */
#ifdef DISABLE_ORC
void
video_orc_unpack_RGB15_be_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union32 var50;
  orc_union32 var51;
  orc_union32 var52;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 10: loadpw */
    var41.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var43 = ptr4[i];
    /* 2: andw */
    var44.i = var43.i & var38.i;
    /* 4: andw */
    var45.i = var43.i & var39.i;
    /* 6: andw */
    var46.i = var43.i & var40.i;
    /* 7: shruw */
    var47.i = ((orc_uint16)var44.i) >> 7;
    /* 8: shruw */
    var48.i = ((orc_uint16)var45.i) >> 2;
    /* 9: shlw */
    var49.i = ((orc_uint16)var46.i) << 3;
    /* 11: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.i;
       _dest.x2[1] = var48.i;
       var50.i = _dest.i;
    }
    /* 12: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var47.i;
       _dest.x2[1] = var49.i;
       var51.i = _dest.i;
    }
    /* 13: shll */
    var52.i = ((orc_uint32)var50.i) << 8;
    /* 14: orl */
    var42.i = var52.i | var51.i;
    /* 15: storel */
    ptr0[i] = var42;
  }

}

#else
static void
_backup_video_orc_unpack_RGB15_be_trunc (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union32 var50;
  orc_union32 var51;
  orc_union32 var52;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 10: loadpw */
    var41.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var43 = ptr4[i];
    /* 2: andw */
    var44.i = var43.i & var38.i;
    /* 4: andw */
    var45.i = var43.i & var39.i;
    /* 6: andw */
    var46.i = var43.i & var40.i;
    /* 7: shruw */
    var47.i = ((orc_uint16)var44.i) >> 7;
    /* 8: shruw */
    var48.i = ((orc_uint16)var45.i) >> 2;
    /* 9: shlw */
    var49.i = ((orc_uint16)var46.i) << 3;
    /* 11: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.i;
       _dest.x2[1] = var48.i;
       var50.i = _dest.i;
    }
    /* 12: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var47.i;
       _dest.x2[1] = var49.i;
       var51.i = _dest.i;
    }
    /* 13: shll */
    var52.i = ((orc_uint32)var50.i) << 8;
    /* 14: orl */
    var42.i = var52.i | var51.i;
    /* 15: storel */
    ptr0[i] = var42;
  }

}

void
video_orc_unpack_RGB15_be_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 82, 71, 66, 49, 53, 95, 98, 101, 95, 116, 114, 117, 
        110, 99, 11, 4, 4, 12, 2, 2, 14, 2, 0, 124, 0, 0, 14, 2, 
        224, 3, 0, 0, 14, 2, 31, 0, 0, 0, 14, 2, 7, 0, 0, 0, 
        14, 2, 2, 0, 0, 0, 14, 2, 3, 0, 0, 0, 14, 2, 255, 0, 
        0, 0, 14, 4, 8, 0, 0, 0, 20, 2, 20, 2, 20, 2, 20, 2, 
        20, 4, 20, 4, 82, 32, 4, 73, 33, 32, 16, 73, 34, 32, 17, 73, 
        35, 32, 18, 95, 33, 33, 19, 95, 34, 34, 20, 93, 35, 35, 21, 195, 
        36, 22, 34, 195, 37, 33, 35, 124, 36, 36, 23, 123, 0, 36, 37, 2, 
        0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGB15_be_trunc);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_RGB15_be_trunc");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGB15_be_trunc);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0x00007c00, "c1");
      orc_program_add_constant (p, 2, 0x000003e0, "c2");
      orc_program_add_constant (p, 2, 0x0000001f, "c3");
      orc_program_add_constant (p, 2, 0x00000007, "c4");
      orc_program_add_constant (p, 2, 0x00000002, "c5");
      orc_program_add_constant (p, 2, 0x00000003, "c6");
      orc_program_add_constant (p, 2, 0x000000ff, "c7");
      orc_program_add_constant (p, 4, 0x00000008, "c8");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 4, "t6");

      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T5, ORC_VAR_C7, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T6, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C8, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_RGB15_le */
#ifdef DISABLE_ORC
void
video_orc_pack_RGB15_le (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var37.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpl */
    var38.i = (int)0x00f80000; /* 16252928 or 8.03001e-317f */
    /* 5: loadpl */
    var39.i = (int)0xf8000000; /* -134217728 or 2.05568e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shrul */
    var45.i = ((orc_uint32)var42.i) >> 1;
    /* 8: shrul */
    var46.i = ((orc_uint32)var43.i) >> 14;
    /* 9: shrul */
    var47.i = ((orc_uint32)var44.i) >> 27;
    /* 10: orl */
    var48.i = var45.i | var46.i;
    /* 11: orl */
    var49.i = var48.i | var47.i;
    /* 12: select0lw */
    {
       orc_union32 _src;
       _src.i = var49.i;
       var40.i = _src.x2[0];
    }
    /* 13: storew */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_video_orc_pack_RGB15_le (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var37.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpl */
    var38.i = (int)0x00f80000; /* 16252928 or 8.03001e-317f */
    /* 5: loadpl */
    var39.i = (int)0xf8000000; /* -134217728 or 2.05568e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shrul */
    var45.i = ((orc_uint32)var42.i) >> 1;
    /* 8: shrul */
    var46.i = ((orc_uint32)var43.i) >> 14;
    /* 9: shrul */
    var47.i = ((orc_uint32)var44.i) >> 27;
    /* 10: orl */
    var48.i = var45.i | var46.i;
    /* 11: orl */
    var49.i = var48.i | var47.i;
    /* 12: select0lw */
    {
       orc_union32 _src;
       _src.i = var49.i;
       var40.i = _src.x2[0];
    }
    /* 13: storew */
    ptr0[i] = var40;
  }

}

void
video_orc_pack_RGB15_le (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 82, 71, 66, 49, 53, 95, 108, 101, 11, 2, 2, 12, 4, 4, 
        14, 4, 0, 248, 0, 0, 14, 4, 0, 0, 248, 0, 14, 4, 0, 0, 
        0, 248, 14, 4, 1, 0, 0, 0, 14, 4, 14, 0, 0, 0, 14, 4, 
        27, 0, 0, 0, 20, 4, 20, 4, 20, 4, 20, 4, 20, 4, 113, 32, 
        4, 106, 33, 32, 16, 106, 34, 32, 17, 106, 35, 32, 18, 126, 33, 33, 
        19, 126, 34, 34, 20, 126, 35, 35, 21, 123, 36, 33, 34, 123, 36, 36, 
        35, 190, 0, 36, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_RGB15_le);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_RGB15_le");
      orc_program_set_backup_function (p, _backup_video_orc_pack_RGB15_le);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x0000f800, "c1");
      orc_program_add_constant (p, 4, 0x00f80000, "c2");
      orc_program_add_constant (p, 4, 0xf8000000, "c3");
      orc_program_add_constant (p, 4, 0x00000001, "c4");
      orc_program_add_constant (p, 4, 0x0000000e, "c5");
      orc_program_add_constant (p, 4, 0x0000001b, "c6");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_RGB15_be */
#ifdef DISABLE_ORC
void
video_orc_pack_RGB15_be (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var37.i = (int)0x00f80000; /* 16252928 or 8.03001e-317f */
    /* 3: loadpl */
    var38.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 5: loadpl */
    var39.i = (int)0x000000f8; /* 248 or 1.22528e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shrul */
    var45.i = ((orc_uint32)var42.i) >> 9;
    /* 8: shrul */
    var46.i = ((orc_uint32)var43.i) >> 6;
    /* 9: shrul */
    var47.i = ((orc_uint32)var44.i) >> 3;
    /* 10: orl */
    var48.i = var45.i | var46.i;
    /* 11: orl */
    var49.i = var48.i | var47.i;
    /* 12: select1lw */
    {
       orc_union32 _src;
       _src.i = var49.i;
       var40.i = _src.x2[1];
    }
    /* 13: storew */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_video_orc_pack_RGB15_be (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var37.i = (int)0x00f80000; /* 16252928 or 8.03001e-317f */
    /* 3: loadpl */
    var38.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 5: loadpl */
    var39.i = (int)0x000000f8; /* 248 or 1.22528e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shrul */
    var45.i = ((orc_uint32)var42.i) >> 9;
    /* 8: shrul */
    var46.i = ((orc_uint32)var43.i) >> 6;
    /* 9: shrul */
    var47.i = ((orc_uint32)var44.i) >> 3;
    /* 10: orl */
    var48.i = var45.i | var46.i;
    /* 11: orl */
    var49.i = var48.i | var47.i;
    /* 12: select1lw */
    {
       orc_union32 _src;
       _src.i = var49.i;
       var40.i = _src.x2[1];
    }
    /* 13: storew */
    ptr0[i] = var40;
  }

}

void
video_orc_pack_RGB15_be (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 82, 71, 66, 49, 53, 95, 98, 101, 11, 2, 2, 12, 4, 4, 
        14, 4, 0, 0, 248, 0, 14, 4, 0, 248, 0, 0, 14, 4, 248, 0, 
        0, 0, 14, 4, 9, 0, 0, 0, 14, 4, 6, 0, 0, 0, 14, 4, 
        3, 0, 0, 0, 20, 4, 20, 4, 20, 4, 20, 4, 20, 4, 113, 32, 
        4, 106, 33, 32, 16, 106, 34, 32, 17, 106, 35, 32, 18, 126, 33, 33, 
        19, 126, 34, 34, 20, 126, 35, 35, 21, 123, 36, 33, 34, 123, 36, 36, 
        35, 191, 0, 36, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_RGB15_be);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_RGB15_be");
      orc_program_set_backup_function (p, _backup_video_orc_pack_RGB15_be);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00f80000, "c1");
      orc_program_add_constant (p, 4, 0x0000f800, "c2");
      orc_program_add_constant (p, 4, 0x000000f8, "c3");
      orc_program_add_constant (p, 4, 0x00000009, "c4");
      orc_program_add_constant (p, 4, 0x00000006, "c5");
      orc_program_add_constant (p, 4, 0x00000003, "c6");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "select1lw", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_BGR15_le */
#ifdef DISABLE_ORC
void
video_orc_unpack_BGR15_le (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union32 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 8: loadpw */
    var41.i = (int)0x00000210; /* 528 or 2.60867e-321f */
    /* 10: loadpw */
    var42.i = (int)0x00004200; /* 16896 or 8.34773e-320f */
    /* 13: loadpw */
    var43.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var45 = ptr4[i];
    /* 2: andw */
    var46.i = var45.i & var38.i;
    /* 4: andw */
    var47.i = var45.i & var39.i;
    /* 6: andw */
    var48.i = var45.i & var40.i;
    /* 7: shlw */
    var49.i = ((orc_uint16)var48.i) << 5;
    /* 9: mulhsw */
    var50.i = (var46.i * var41.i) >> 16;
    /* 11: mulhsw */
    var51.i = (var47.i * var42.i) >> 16;
    /* 12: mulhsw */
    var52.i = (var49.i * var42.i) >> 16;
    /* 14: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var43.i;
       _dest.x2[1] = var51.i;
       var53.i = _dest.i;
    }
    /* 15: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var52.i;
       _dest.x2[1] = var50.i;
       var54.i = _dest.i;
    }
    /* 16: shll */
    var55.i = ((orc_uint32)var54.i) << 8;
    /* 17: orl */
    var44.i = var53.i | var55.i;
    /* 18: storel */
    ptr0[i] = var44;
  }

}

#else
static void
_backup_video_orc_unpack_BGR15_le (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union32 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 8: loadpw */
    var41.i = (int)0x00000210; /* 528 or 2.60867e-321f */
    /* 10: loadpw */
    var42.i = (int)0x00004200; /* 16896 or 8.34773e-320f */
    /* 13: loadpw */
    var43.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var45 = ptr4[i];
    /* 2: andw */
    var46.i = var45.i & var38.i;
    /* 4: andw */
    var47.i = var45.i & var39.i;
    /* 6: andw */
    var48.i = var45.i & var40.i;
    /* 7: shlw */
    var49.i = ((orc_uint16)var48.i) << 5;
    /* 9: mulhsw */
    var50.i = (var46.i * var41.i) >> 16;
    /* 11: mulhsw */
    var51.i = (var47.i * var42.i) >> 16;
    /* 12: mulhsw */
    var52.i = (var49.i * var42.i) >> 16;
    /* 14: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var43.i;
       _dest.x2[1] = var51.i;
       var53.i = _dest.i;
    }
    /* 15: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var52.i;
       _dest.x2[1] = var50.i;
       var54.i = _dest.i;
    }
    /* 16: shll */
    var55.i = ((orc_uint32)var54.i) << 8;
    /* 17: orl */
    var44.i = var53.i | var55.i;
    /* 18: storel */
    ptr0[i] = var44;
  }

}

void
video_orc_unpack_BGR15_le (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 25, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 66, 71, 82, 49, 53, 95, 108, 101, 11, 4, 4, 12, 
        2, 2, 14, 2, 0, 124, 0, 0, 14, 2, 224, 3, 0, 0, 14, 2, 
        31, 0, 0, 0, 14, 2, 5, 0, 0, 0, 14, 2, 16, 2, 0, 0, 
        14, 2, 0, 66, 0, 0, 14, 2, 255, 0, 0, 0, 14, 4, 8, 0, 
        0, 0, 20, 2, 20, 2, 20, 2, 20, 2, 20, 4, 20, 4, 82, 32, 
        4, 73, 35, 32, 16, 73, 34, 32, 17, 73, 33, 32, 18, 93, 33, 33, 
        19, 90, 35, 35, 20, 90, 34, 34, 21, 90, 33, 33, 21, 195, 36, 22, 
        34, 195, 37, 33, 35, 124, 37, 37, 23, 123, 0, 36, 37, 2, 0,       };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGR15_le);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_BGR15_le");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGR15_le);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0x00007c00, "c1");
      orc_program_add_constant (p, 2, 0x000003e0, "c2");
      orc_program_add_constant (p, 2, 0x0000001f, "c3");
      orc_program_add_constant (p, 2, 0x00000005, "c4");
      orc_program_add_constant (p, 2, 0x00000210, "c5");
      orc_program_add_constant (p, 2, 0x00004200, "c6");
      orc_program_add_constant (p, 2, 0x000000ff, "c7");
      orc_program_add_constant (p, 4, 0x00000008, "c8");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 4, "t6");

      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T5, ORC_VAR_C7, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T6, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_C8, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_BGR15_be */
#ifdef DISABLE_ORC
void
video_orc_unpack_BGR15_be (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union32 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 8: loadpw */
    var41.i = (int)0x00000210; /* 528 or 2.60867e-321f */
    /* 10: loadpw */
    var42.i = (int)0x00004200; /* 16896 or 8.34773e-320f */
    /* 13: loadpw */
    var43.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var45 = ptr4[i];
    /* 2: andw */
    var46.i = var45.i & var38.i;
    /* 4: andw */
    var47.i = var45.i & var39.i;
    /* 6: andw */
    var48.i = var45.i & var40.i;
    /* 7: shlw */
    var49.i = ((orc_uint16)var48.i) << 5;
    /* 9: mulhsw */
    var50.i = (var46.i * var41.i) >> 16;
    /* 11: mulhsw */
    var51.i = (var47.i * var42.i) >> 16;
    /* 12: mulhsw */
    var52.i = (var49.i * var42.i) >> 16;
    /* 14: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var43.i;
       _dest.x2[1] = var51.i;
       var53.i = _dest.i;
    }
    /* 15: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var52.i;
       _dest.x2[1] = var50.i;
       var54.i = _dest.i;
    }
    /* 16: shll */
    var55.i = ((orc_uint32)var53.i) << 8;
    /* 17: orl */
    var44.i = var55.i | var54.i;
    /* 18: storel */
    ptr0[i] = var44;
  }

}

#else
static void
_backup_video_orc_unpack_BGR15_be (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_union32 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union32 var55;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 8: loadpw */
    var41.i = (int)0x00000210; /* 528 or 2.60867e-321f */
    /* 10: loadpw */
    var42.i = (int)0x00004200; /* 16896 or 8.34773e-320f */
    /* 13: loadpw */
    var43.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var45 = ptr4[i];
    /* 2: andw */
    var46.i = var45.i & var38.i;
    /* 4: andw */
    var47.i = var45.i & var39.i;
    /* 6: andw */
    var48.i = var45.i & var40.i;
    /* 7: shlw */
    var49.i = ((orc_uint16)var48.i) << 5;
    /* 9: mulhsw */
    var50.i = (var46.i * var41.i) >> 16;
    /* 11: mulhsw */
    var51.i = (var47.i * var42.i) >> 16;
    /* 12: mulhsw */
    var52.i = (var49.i * var42.i) >> 16;
    /* 14: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var43.i;
       _dest.x2[1] = var51.i;
       var53.i = _dest.i;
    }
    /* 15: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var52.i;
       _dest.x2[1] = var50.i;
       var54.i = _dest.i;
    }
    /* 16: shll */
    var55.i = ((orc_uint32)var53.i) << 8;
    /* 17: orl */
    var44.i = var55.i | var54.i;
    /* 18: storel */
    ptr0[i] = var44;
  }

}

void
video_orc_unpack_BGR15_be (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 25, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 66, 71, 82, 49, 53, 95, 98, 101, 11, 4, 4, 12, 
        2, 2, 14, 2, 0, 124, 0, 0, 14, 2, 224, 3, 0, 0, 14, 2, 
        31, 0, 0, 0, 14, 2, 5, 0, 0, 0, 14, 2, 16, 2, 0, 0, 
        14, 2, 0, 66, 0, 0, 14, 2, 255, 0, 0, 0, 14, 4, 8, 0, 
        0, 0, 20, 2, 20, 2, 20, 2, 20, 2, 20, 4, 20, 4, 82, 32, 
        4, 73, 35, 32, 16, 73, 34, 32, 17, 73, 33, 32, 18, 93, 33, 33, 
        19, 90, 35, 35, 20, 90, 34, 34, 21, 90, 33, 33, 21, 195, 36, 22, 
        34, 195, 37, 33, 35, 124, 36, 36, 23, 123, 0, 36, 37, 2, 0,       };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGR15_be);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_BGR15_be");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGR15_be);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0x00007c00, "c1");
      orc_program_add_constant (p, 2, 0x000003e0, "c2");
      orc_program_add_constant (p, 2, 0x0000001f, "c3");
      orc_program_add_constant (p, 2, 0x00000005, "c4");
      orc_program_add_constant (p, 2, 0x00000210, "c5");
      orc_program_add_constant (p, 2, 0x00004200, "c6");
      orc_program_add_constant (p, 2, 0x000000ff, "c7");
      orc_program_add_constant (p, 4, 0x00000008, "c8");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 4, "t6");

      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T5, ORC_VAR_C7, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T6, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C8, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_BGR15_le_trunc */
#ifdef DISABLE_ORC
void
video_orc_unpack_BGR15_le_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union32 var50;
  orc_union32 var51;
  orc_union32 var52;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 10: loadpw */
    var41.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var43 = ptr4[i];
    /* 2: andw */
    var44.i = var43.i & var38.i;
    /* 4: andw */
    var45.i = var43.i & var39.i;
    /* 6: andw */
    var46.i = var43.i & var40.i;
    /* 7: shruw */
    var47.i = ((orc_uint16)var44.i) >> 7;
    /* 8: shruw */
    var48.i = ((orc_uint16)var45.i) >> 2;
    /* 9: shlw */
    var49.i = ((orc_uint16)var46.i) << 3;
    /* 11: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.i;
       _dest.x2[1] = var48.i;
       var50.i = _dest.i;
    }
    /* 12: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var49.i;
       _dest.x2[1] = var47.i;
       var51.i = _dest.i;
    }
    /* 13: shll */
    var52.i = ((orc_uint32)var51.i) << 8;
    /* 14: orl */
    var42.i = var50.i | var52.i;
    /* 15: storel */
    ptr0[i] = var42;
  }

}

#else
static void
_backup_video_orc_unpack_BGR15_le_trunc (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union32 var50;
  orc_union32 var51;
  orc_union32 var52;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 10: loadpw */
    var41.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var43 = ptr4[i];
    /* 2: andw */
    var44.i = var43.i & var38.i;
    /* 4: andw */
    var45.i = var43.i & var39.i;
    /* 6: andw */
    var46.i = var43.i & var40.i;
    /* 7: shruw */
    var47.i = ((orc_uint16)var44.i) >> 7;
    /* 8: shruw */
    var48.i = ((orc_uint16)var45.i) >> 2;
    /* 9: shlw */
    var49.i = ((orc_uint16)var46.i) << 3;
    /* 11: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.i;
       _dest.x2[1] = var48.i;
       var50.i = _dest.i;
    }
    /* 12: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var49.i;
       _dest.x2[1] = var47.i;
       var51.i = _dest.i;
    }
    /* 13: shll */
    var52.i = ((orc_uint32)var51.i) << 8;
    /* 14: orl */
    var42.i = var50.i | var52.i;
    /* 15: storel */
    ptr0[i] = var42;
  }

}

void
video_orc_unpack_BGR15_le_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 66, 71, 82, 49, 53, 95, 108, 101, 95, 116, 114, 117, 
        110, 99, 11, 4, 4, 12, 2, 2, 14, 2, 0, 124, 0, 0, 14, 2, 
        224, 3, 0, 0, 14, 2, 31, 0, 0, 0, 14, 2, 7, 0, 0, 0, 
        14, 2, 2, 0, 0, 0, 14, 2, 3, 0, 0, 0, 14, 2, 255, 0, 
        0, 0, 14, 4, 8, 0, 0, 0, 20, 2, 20, 2, 20, 2, 20, 2, 
        20, 4, 20, 4, 82, 32, 4, 73, 35, 32, 16, 73, 34, 32, 17, 73, 
        33, 32, 18, 95, 35, 35, 19, 95, 34, 34, 20, 93, 33, 33, 21, 195, 
        36, 22, 34, 195, 37, 33, 35, 124, 37, 37, 23, 123, 0, 36, 37, 2, 
        0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGR15_le_trunc);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_BGR15_le_trunc");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGR15_le_trunc);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0x00007c00, "c1");
      orc_program_add_constant (p, 2, 0x000003e0, "c2");
      orc_program_add_constant (p, 2, 0x0000001f, "c3");
      orc_program_add_constant (p, 2, 0x00000007, "c4");
      orc_program_add_constant (p, 2, 0x00000002, "c5");
      orc_program_add_constant (p, 2, 0x00000003, "c6");
      orc_program_add_constant (p, 2, 0x000000ff, "c7");
      orc_program_add_constant (p, 4, 0x00000008, "c8");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 4, "t6");

      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T5, ORC_VAR_C7, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T6, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T6, ORC_VAR_T6, ORC_VAR_C8, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_BGR15_be_trunc */
#ifdef DISABLE_ORC
void
video_orc_unpack_BGR15_be_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union32 var50;
  orc_union32 var51;
  orc_union32 var52;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 10: loadpw */
    var41.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var43 = ptr4[i];
    /* 2: andw */
    var44.i = var43.i & var38.i;
    /* 4: andw */
    var45.i = var43.i & var39.i;
    /* 6: andw */
    var46.i = var43.i & var40.i;
    /* 7: shruw */
    var47.i = ((orc_uint16)var44.i) >> 7;
    /* 8: shruw */
    var48.i = ((orc_uint16)var45.i) >> 2;
    /* 9: shlw */
    var49.i = ((orc_uint16)var46.i) << 3;
    /* 11: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.i;
       _dest.x2[1] = var48.i;
       var50.i = _dest.i;
    }
    /* 12: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var49.i;
       _dest.x2[1] = var47.i;
       var51.i = _dest.i;
    }
    /* 13: shll */
    var52.i = ((orc_uint32)var50.i) << 8;
    /* 14: orl */
    var42.i = var52.i | var51.i;
    /* 15: storel */
    ptr0[i] = var42;
  }

}

#else
static void
_backup_video_orc_unpack_BGR15_be_trunc (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union32 var50;
  orc_union32 var51;
  orc_union32 var52;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var38.i = (int)0x00007c00; /* 31744 or 1.56836e-319f */
    /* 3: loadpw */
    var39.i = (int)0x000003e0; /* 992 or 4.90113e-321f */
    /* 5: loadpw */
    var40.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 10: loadpw */
    var41.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var43 = ptr4[i];
    /* 2: andw */
    var44.i = var43.i & var38.i;
    /* 4: andw */
    var45.i = var43.i & var39.i;
    /* 6: andw */
    var46.i = var43.i & var40.i;
    /* 7: shruw */
    var47.i = ((orc_uint16)var44.i) >> 7;
    /* 8: shruw */
    var48.i = ((orc_uint16)var45.i) >> 2;
    /* 9: shlw */
    var49.i = ((orc_uint16)var46.i) << 3;
    /* 11: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var41.i;
       _dest.x2[1] = var48.i;
       var50.i = _dest.i;
    }
    /* 12: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var49.i;
       _dest.x2[1] = var47.i;
       var51.i = _dest.i;
    }
    /* 13: shll */
    var52.i = ((orc_uint32)var50.i) << 8;
    /* 14: orl */
    var42.i = var52.i | var51.i;
    /* 15: storel */
    ptr0[i] = var42;
  }

}

void
video_orc_unpack_BGR15_be_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 66, 71, 82, 49, 53, 95, 98, 101, 95, 116, 114, 117, 
        110, 99, 11, 4, 4, 12, 2, 2, 14, 2, 0, 124, 0, 0, 14, 2, 
        224, 3, 0, 0, 14, 2, 31, 0, 0, 0, 14, 2, 7, 0, 0, 0, 
        14, 2, 2, 0, 0, 0, 14, 2, 3, 0, 0, 0, 14, 2, 255, 0, 
        0, 0, 14, 4, 8, 0, 0, 0, 20, 2, 20, 2, 20, 2, 20, 2, 
        20, 4, 20, 4, 82, 32, 4, 73, 35, 32, 16, 73, 34, 32, 17, 73, 
        33, 32, 18, 95, 35, 35, 19, 95, 34, 34, 20, 93, 33, 33, 21, 195, 
        36, 22, 34, 195, 37, 33, 35, 124, 36, 36, 23, 123, 0, 36, 37, 2, 
        0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGR15_be_trunc);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_BGR15_be_trunc");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGR15_be_trunc);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0x00007c00, "c1");
      orc_program_add_constant (p, 2, 0x000003e0, "c2");
      orc_program_add_constant (p, 2, 0x0000001f, "c3");
      orc_program_add_constant (p, 2, 0x00000007, "c4");
      orc_program_add_constant (p, 2, 0x00000002, "c5");
      orc_program_add_constant (p, 2, 0x00000003, "c6");
      orc_program_add_constant (p, 2, 0x000000ff, "c7");
      orc_program_add_constant (p, 4, 0x00000008, "c8");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 4, "t6");

      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T5, ORC_VAR_C7, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T6, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C8, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_BGR15_le */
#ifdef DISABLE_ORC
void
video_orc_pack_BGR15_le (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var37.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpl */
    var38.i = (int)0x00f80000; /* 16252928 or 8.03001e-317f */
    /* 5: loadpl */
    var39.i = (int)0xf8000000; /* -134217728 or 2.05568e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shrul */
    var45.i = ((orc_uint32)var44.i) >> 17;
    /* 8: shrul */
    var46.i = ((orc_uint32)var43.i) >> 14;
    /* 9: shrul */
    var47.i = ((orc_uint32)var42.i) >> 11;
    /* 10: orl */
    var48.i = var47.i | var46.i;
    /* 11: orl */
    var49.i = var48.i | var45.i;
    /* 12: select0lw */
    {
       orc_union32 _src;
       _src.i = var49.i;
       var40.i = _src.x2[0];
    }
    /* 13: storew */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_video_orc_pack_BGR15_le (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var37.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpl */
    var38.i = (int)0x00f80000; /* 16252928 or 8.03001e-317f */
    /* 5: loadpl */
    var39.i = (int)0xf8000000; /* -134217728 or 2.05568e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shrul */
    var45.i = ((orc_uint32)var44.i) >> 17;
    /* 8: shrul */
    var46.i = ((orc_uint32)var43.i) >> 14;
    /* 9: shrul */
    var47.i = ((orc_uint32)var42.i) >> 11;
    /* 10: orl */
    var48.i = var47.i | var46.i;
    /* 11: orl */
    var49.i = var48.i | var45.i;
    /* 12: select0lw */
    {
       orc_union32 _src;
       _src.i = var49.i;
       var40.i = _src.x2[0];
    }
    /* 13: storew */
    ptr0[i] = var40;
  }

}

void
video_orc_pack_BGR15_le (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 66, 71, 82, 49, 53, 95, 108, 101, 11, 2, 2, 12, 4, 4, 
        14, 4, 0, 248, 0, 0, 14, 4, 0, 0, 248, 0, 14, 4, 0, 0, 
        0, 248, 14, 4, 17, 0, 0, 0, 14, 4, 14, 0, 0, 0, 14, 4, 
        11, 0, 0, 0, 20, 4, 20, 4, 20, 4, 20, 4, 20, 4, 113, 32, 
        4, 106, 33, 32, 16, 106, 34, 32, 17, 106, 35, 32, 18, 126, 35, 35, 
        19, 126, 34, 34, 20, 126, 33, 33, 21, 123, 36, 33, 34, 123, 36, 36, 
        35, 190, 0, 36, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_BGR15_le);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_BGR15_le");
      orc_program_set_backup_function (p, _backup_video_orc_pack_BGR15_le);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x0000f800, "c1");
      orc_program_add_constant (p, 4, 0x00f80000, "c2");
      orc_program_add_constant (p, 4, 0xf8000000, "c3");
      orc_program_add_constant (p, 4, 0x00000011, "c4");
      orc_program_add_constant (p, 4, 0x0000000e, "c5");
      orc_program_add_constant (p, 4, 0x0000000b, "c6");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_BGR15_be */
#ifdef DISABLE_ORC
void
video_orc_pack_BGR15_be (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var37.i = (int)0x00f80000; /* 16252928 or 8.03001e-317f */
    /* 3: loadpl */
    var38.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 5: loadpl */
    var39.i = (int)0x000000f8; /* 248 or 1.22528e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shll */
    var45.i = ((orc_uint32)var44.i) << 7;
    /* 8: shrul */
    var46.i = ((orc_uint32)var43.i) >> 6;
    /* 9: shrul */
    var47.i = ((orc_uint32)var42.i) >> 19;
    /* 10: orl */
    var48.i = var47.i | var46.i;
    /* 11: orl */
    var49.i = var48.i | var45.i;
    /* 12: select1lw */
    {
       orc_union32 _src;
       _src.i = var49.i;
       var40.i = _src.x2[1];
    }
    /* 13: storew */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_video_orc_pack_BGR15_be (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var37.i = (int)0x00f80000; /* 16252928 or 8.03001e-317f */
    /* 3: loadpl */
    var38.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 5: loadpl */
    var39.i = (int)0x000000f8; /* 248 or 1.22528e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shll */
    var45.i = ((orc_uint32)var44.i) << 7;
    /* 8: shrul */
    var46.i = ((orc_uint32)var43.i) >> 6;
    /* 9: shrul */
    var47.i = ((orc_uint32)var42.i) >> 19;
    /* 10: orl */
    var48.i = var47.i | var46.i;
    /* 11: orl */
    var49.i = var48.i | var45.i;
    /* 12: select1lw */
    {
       orc_union32 _src;
       _src.i = var49.i;
       var40.i = _src.x2[1];
    }
    /* 13: storew */
    ptr0[i] = var40;
  }

}

void
video_orc_pack_BGR15_be (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 66, 71, 82, 49, 53, 95, 98, 101, 11, 2, 2, 12, 4, 4, 
        14, 4, 0, 0, 248, 0, 14, 4, 0, 248, 0, 0, 14, 4, 248, 0, 
        0, 0, 14, 4, 7, 0, 0, 0, 14, 4, 6, 0, 0, 0, 14, 4, 
        19, 0, 0, 0, 20, 4, 20, 4, 20, 4, 20, 4, 20, 4, 113, 32, 
        4, 106, 33, 32, 16, 106, 34, 32, 17, 106, 35, 32, 18, 124, 35, 35, 
        19, 126, 34, 34, 20, 126, 33, 33, 21, 123, 36, 33, 34, 123, 36, 36, 
        35, 191, 0, 36, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_BGR15_be);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_BGR15_be");
      orc_program_set_backup_function (p, _backup_video_orc_pack_BGR15_be);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00f80000, "c1");
      orc_program_add_constant (p, 4, 0x0000f800, "c2");
      orc_program_add_constant (p, 4, 0x000000f8, "c3");
      orc_program_add_constant (p, 4, 0x00000007, "c4");
      orc_program_add_constant (p, 4, 0x00000006, "c5");
      orc_program_add_constant (p, 4, 0x00000013, "c6");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "select1lw", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_RGB16 */
#ifdef DISABLE_ORC
void
video_orc_unpack_RGB16 (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var44;
#else
  orc_union16 var44;
#endif
  orc_union32 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union64 var57;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var39.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpw */
    var40.i = (int)0x000007e0; /* 2016 or 9.96036e-321f */
    /* 5: loadpw */
    var41.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 9: loadpw */
    var42.i = (int)0x00004200; /* 16896 or 8.34773e-320f */
    /* 11: loadpw */
    var43.i = (int)0x00002080; /* 8320 or 4.11063e-320f */
    /* 14: loadpw */
    var44.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var46 = ptr4[i];
    /* 2: andw */
    var47.i = var46.i & var39.i;
    /* 4: andw */
    var48.i = var46.i & var40.i;
    /* 6: andw */
    var49.i = var46.i & var41.i;
    /* 7: shruw */
    var50.i = ((orc_uint16)var47.i) >> 6;
    /* 8: shlw */
    var51.i = ((orc_uint16)var49.i) << 5;
    /* 10: mulhsw */
    var52.i = (var50.i * var42.i) >> 16;
    /* 12: mulhsw */
    var53.i = (var48.i * var43.i) >> 16;
    /* 13: mulhsw */
    var54.i = (var51.i * var42.i) >> 16;
    /* 15: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var52.i;
       var55.i = _dest.i;
    }
    /* 16: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var53.i;
       _dest.x2[1] = var54.i;
       var56.i = _dest.i;
    }
    /* 17: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var55.i;
       _dest.x2[1] = var56.i;
       var57.i = _dest.i;
    }
    /* 18: convsuswb */
    var45.x4[0] = ORC_CLAMP_UB(var57.x4[0]);
    var45.x4[1] = ORC_CLAMP_UB(var57.x4[1]);
    var45.x4[2] = ORC_CLAMP_UB(var57.x4[2]);
    var45.x4[3] = ORC_CLAMP_UB(var57.x4[3]);
    /* 19: storel */
    ptr0[i] = var45;
  }

}

#else
static void
_backup_video_orc_unpack_RGB16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var44;
#else
  orc_union16 var44;
#endif
  orc_union32 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union64 var57;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var39.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpw */
    var40.i = (int)0x000007e0; /* 2016 or 9.96036e-321f */
    /* 5: loadpw */
    var41.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 9: loadpw */
    var42.i = (int)0x00004200; /* 16896 or 8.34773e-320f */
    /* 11: loadpw */
    var43.i = (int)0x00002080; /* 8320 or 4.11063e-320f */
    /* 14: loadpw */
    var44.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var46 = ptr4[i];
    /* 2: andw */
    var47.i = var46.i & var39.i;
    /* 4: andw */
    var48.i = var46.i & var40.i;
    /* 6: andw */
    var49.i = var46.i & var41.i;
    /* 7: shruw */
    var50.i = ((orc_uint16)var47.i) >> 6;
    /* 8: shlw */
    var51.i = ((orc_uint16)var49.i) << 5;
    /* 10: mulhsw */
    var52.i = (var50.i * var42.i) >> 16;
    /* 12: mulhsw */
    var53.i = (var48.i * var43.i) >> 16;
    /* 13: mulhsw */
    var54.i = (var51.i * var42.i) >> 16;
    /* 15: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var52.i;
       var55.i = _dest.i;
    }
    /* 16: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var53.i;
       _dest.x2[1] = var54.i;
       var56.i = _dest.i;
    }
    /* 17: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var55.i;
       _dest.x2[1] = var56.i;
       var57.i = _dest.i;
    }
    /* 18: convsuswb */
    var45.x4[0] = ORC_CLAMP_UB(var57.x4[0]);
    var45.x4[1] = ORC_CLAMP_UB(var57.x4[1]);
    var45.x4[2] = ORC_CLAMP_UB(var57.x4[2]);
    var45.x4[3] = ORC_CLAMP_UB(var57.x4[3]);
    /* 19: storel */
    ptr0[i] = var45;
  }

}

void
video_orc_unpack_RGB16 (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 22, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 82, 71, 66, 49, 54, 11, 4, 4, 12, 2, 2, 14, 
        2, 0, 248, 0, 0, 14, 2, 224, 7, 0, 0, 14, 2, 31, 0, 0, 
        0, 14, 2, 6, 0, 0, 0, 14, 2, 5, 0, 0, 0, 14, 2, 0, 
        66, 0, 0, 14, 2, 128, 32, 0, 0, 14, 2, 255, 0, 0, 0, 20, 
        2, 20, 2, 20, 2, 20, 2, 20, 4, 20, 4, 20, 8, 82, 32, 4, 
        73, 33, 32, 16, 73, 34, 32, 17, 73, 35, 32, 18, 95, 33, 33, 19, 
        93, 35, 35, 20, 90, 33, 33, 21, 90, 34, 34, 22, 90, 35, 35, 21, 
        195, 36, 23, 33, 195, 37, 34, 35, 194, 38, 36, 37, 21, 2, 160, 0, 
        38, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGB16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_RGB16");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGB16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0x0000f800, "c1");
      orc_program_add_constant (p, 2, 0x000007e0, "c2");
      orc_program_add_constant (p, 2, 0x0000001f, "c3");
      orc_program_add_constant (p, 2, 0x00000006, "c4");
      orc_program_add_constant (p, 2, 0x00000005, "c5");
      orc_program_add_constant (p, 2, 0x00004200, "c6");
      orc_program_add_constant (p, 2, 0x00002080, "c7");
      orc_program_add_constant (p, 2, 0x000000ff, "c8");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 4, "t6");
      orc_program_add_temporary (p, 8, "t7");

      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C7, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T5, ORC_VAR_C8, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_T7, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 2, ORC_VAR_D1, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_RGB16_trunc */
#ifdef DISABLE_ORC
void
video_orc_unpack_RGB16_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_union32 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union32 var51;
  orc_union32 var52;
  orc_union64 var53;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var39.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpw */
    var40.i = (int)0x000007e0; /* 2016 or 9.96036e-321f */
    /* 5: loadpw */
    var41.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 10: loadpw */
    var42.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var44 = ptr4[i];
    /* 2: andw */
    var45.i = var44.i & var39.i;
    /* 4: andw */
    var46.i = var44.i & var40.i;
    /* 6: andw */
    var47.i = var44.i & var41.i;
    /* 7: shruw */
    var48.i = ((orc_uint16)var45.i) >> 8;
    /* 8: shruw */
    var49.i = ((orc_uint16)var46.i) >> 3;
    /* 9: shlw */
    var50.i = ((orc_uint16)var47.i) << 3;
    /* 11: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.i;
       _dest.x2[1] = var48.i;
       var51.i = _dest.i;
    }
    /* 12: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var49.i;
       _dest.x2[1] = var50.i;
       var52.i = _dest.i;
    }
    /* 13: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var51.i;
       _dest.x2[1] = var52.i;
       var53.i = _dest.i;
    }
    /* 14: convsuswb */
    var43.x4[0] = ORC_CLAMP_UB(var53.x4[0]);
    var43.x4[1] = ORC_CLAMP_UB(var53.x4[1]);
    var43.x4[2] = ORC_CLAMP_UB(var53.x4[2]);
    var43.x4[3] = ORC_CLAMP_UB(var53.x4[3]);
    /* 15: storel */
    ptr0[i] = var43;
  }

}

#else
static void
_backup_video_orc_unpack_RGB16_trunc (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_union32 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union32 var51;
  orc_union32 var52;
  orc_union64 var53;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var39.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpw */
    var40.i = (int)0x000007e0; /* 2016 or 9.96036e-321f */
    /* 5: loadpw */
    var41.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 10: loadpw */
    var42.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var44 = ptr4[i];
    /* 2: andw */
    var45.i = var44.i & var39.i;
    /* 4: andw */
    var46.i = var44.i & var40.i;
    /* 6: andw */
    var47.i = var44.i & var41.i;
    /* 7: shruw */
    var48.i = ((orc_uint16)var45.i) >> 8;
    /* 8: shruw */
    var49.i = ((orc_uint16)var46.i) >> 3;
    /* 9: shlw */
    var50.i = ((orc_uint16)var47.i) << 3;
    /* 11: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.i;
       _dest.x2[1] = var48.i;
       var51.i = _dest.i;
    }
    /* 12: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var49.i;
       _dest.x2[1] = var50.i;
       var52.i = _dest.i;
    }
    /* 13: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var51.i;
       _dest.x2[1] = var52.i;
       var53.i = _dest.i;
    }
    /* 14: convsuswb */
    var43.x4[0] = ORC_CLAMP_UB(var53.x4[0]);
    var43.x4[1] = ORC_CLAMP_UB(var53.x4[1]);
    var43.x4[2] = ORC_CLAMP_UB(var53.x4[2]);
    var43.x4[3] = ORC_CLAMP_UB(var53.x4[3]);
    /* 15: storel */
    ptr0[i] = var43;
  }

}

void
video_orc_unpack_RGB16_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 28, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 82, 71, 66, 49, 54, 95, 116, 114, 117, 110, 99, 11, 
        4, 4, 12, 2, 2, 14, 2, 0, 248, 0, 0, 14, 2, 224, 7, 0, 
        0, 14, 2, 31, 0, 0, 0, 14, 2, 8, 0, 0, 0, 14, 2, 3, 
        0, 0, 0, 14, 2, 255, 0, 0, 0, 20, 2, 20, 2, 20, 2, 20, 
        2, 20, 4, 20, 4, 20, 8, 82, 32, 4, 73, 33, 32, 16, 73, 34, 
        32, 17, 73, 35, 32, 18, 95, 33, 33, 19, 95, 34, 34, 20, 93, 35, 
        35, 20, 195, 36, 21, 33, 195, 37, 34, 35, 194, 38, 36, 37, 21, 2, 
        160, 0, 38, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGB16_trunc);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_RGB16_trunc");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_RGB16_trunc);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0x0000f800, "c1");
      orc_program_add_constant (p, 2, 0x000007e0, "c2");
      orc_program_add_constant (p, 2, 0x0000001f, "c3");
      orc_program_add_constant (p, 2, 0x00000008, "c4");
      orc_program_add_constant (p, 2, 0x00000003, "c5");
      orc_program_add_constant (p, 2, 0x000000ff, "c6");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 4, "t6");
      orc_program_add_temporary (p, 8, "t7");

      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T5, ORC_VAR_C6, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_T7, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 2, ORC_VAR_D1, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_RGB16_le */
#ifdef DISABLE_ORC
void
video_orc_pack_RGB16_le (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var37.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpl */
    var38.i = (int)0x00fc0000; /* 16515072 or 8.15953e-317f */
    /* 5: loadpl */
    var39.i = (int)0xf8000000; /* -134217728 or 2.05568e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shrul */
    var45.i = ((orc_uint32)var43.i) >> 13;
    /* 8: shrul */
    var46.i = ((orc_uint32)var44.i) >> 27;
    /* 9: orl */
    var47.i = var42.i | var45.i;
    /* 10: orl */
    var48.i = var47.i | var46.i;
    /* 11: select0lw */
    {
       orc_union32 _src;
       _src.i = var48.i;
       var40.i = _src.x2[0];
    }
    /* 12: storew */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_video_orc_pack_RGB16_le (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var37.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpl */
    var38.i = (int)0x00fc0000; /* 16515072 or 8.15953e-317f */
    /* 5: loadpl */
    var39.i = (int)0xf8000000; /* -134217728 or 2.05568e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shrul */
    var45.i = ((orc_uint32)var43.i) >> 13;
    /* 8: shrul */
    var46.i = ((orc_uint32)var44.i) >> 27;
    /* 9: orl */
    var47.i = var42.i | var45.i;
    /* 10: orl */
    var48.i = var47.i | var46.i;
    /* 11: select0lw */
    {
       orc_union32 _src;
       _src.i = var48.i;
       var40.i = _src.x2[0];
    }
    /* 12: storew */
    ptr0[i] = var40;
  }

}

void
video_orc_pack_RGB16_le (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 82, 71, 66, 49, 54, 95, 108, 101, 11, 2, 2, 12, 4, 4, 
        14, 4, 0, 248, 0, 0, 14, 4, 0, 0, 252, 0, 14, 4, 0, 0, 
        0, 248, 14, 4, 13, 0, 0, 0, 14, 4, 27, 0, 0, 0, 20, 4, 
        20, 4, 20, 4, 20, 4, 20, 4, 113, 32, 4, 106, 33, 32, 16, 106, 
        34, 32, 17, 106, 35, 32, 18, 126, 34, 34, 19, 126, 35, 35, 20, 123, 
        36, 33, 34, 123, 36, 36, 35, 190, 0, 36, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_RGB16_le);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_RGB16_le");
      orc_program_set_backup_function (p, _backup_video_orc_pack_RGB16_le);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x0000f800, "c1");
      orc_program_add_constant (p, 4, 0x00fc0000, "c2");
      orc_program_add_constant (p, 4, 0xf8000000, "c3");
      orc_program_add_constant (p, 4, 0x0000000d, "c4");
      orc_program_add_constant (p, 4, 0x0000001b, "c5");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_RGB16_be */
#ifdef DISABLE_ORC
void
video_orc_pack_RGB16_be (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var37.i = (int)0x00f80000; /* 16252928 or 8.03001e-317f */
    /* 3: loadpl */
    var38.i = (int)0x0000fc00; /* 64512 or 3.18732e-319f */
    /* 5: loadpl */
    var39.i = (int)0x000000f8; /* 248 or 1.22528e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shrul */
    var45.i = ((orc_uint32)var42.i) >> 8;
    /* 8: shrul */
    var46.i = ((orc_uint32)var43.i) >> 5;
    /* 9: shrul */
    var47.i = ((orc_uint32)var44.i) >> 3;
    /* 10: orl */
    var48.i = var45.i | var46.i;
    /* 11: orl */
    var49.i = var48.i | var47.i;
    /* 12: select1lw */
    {
       orc_union32 _src;
       _src.i = var49.i;
       var40.i = _src.x2[1];
    }
    /* 13: storew */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_video_orc_pack_RGB16_be (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var37.i = (int)0x00f80000; /* 16252928 or 8.03001e-317f */
    /* 3: loadpl */
    var38.i = (int)0x0000fc00; /* 64512 or 3.18732e-319f */
    /* 5: loadpl */
    var39.i = (int)0x000000f8; /* 248 or 1.22528e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shrul */
    var45.i = ((orc_uint32)var42.i) >> 8;
    /* 8: shrul */
    var46.i = ((orc_uint32)var43.i) >> 5;
    /* 9: shrul */
    var47.i = ((orc_uint32)var44.i) >> 3;
    /* 10: orl */
    var48.i = var45.i | var46.i;
    /* 11: orl */
    var49.i = var48.i | var47.i;
    /* 12: select1lw */
    {
       orc_union32 _src;
       _src.i = var49.i;
       var40.i = _src.x2[1];
    }
    /* 13: storew */
    ptr0[i] = var40;
  }

}

void
video_orc_pack_RGB16_be (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 82, 71, 66, 49, 54, 95, 98, 101, 11, 2, 2, 12, 4, 4, 
        14, 4, 0, 0, 248, 0, 14, 4, 0, 252, 0, 0, 14, 4, 248, 0, 
        0, 0, 14, 4, 8, 0, 0, 0, 14, 4, 5, 0, 0, 0, 14, 4, 
        3, 0, 0, 0, 20, 4, 20, 4, 20, 4, 20, 4, 20, 4, 113, 32, 
        4, 106, 33, 32, 16, 106, 34, 32, 17, 106, 35, 32, 18, 126, 33, 33, 
        19, 126, 34, 34, 20, 126, 35, 35, 21, 123, 36, 33, 34, 123, 36, 36, 
        35, 191, 0, 36, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_RGB16_be);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_RGB16_be");
      orc_program_set_backup_function (p, _backup_video_orc_pack_RGB16_be);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00f80000, "c1");
      orc_program_add_constant (p, 4, 0x0000fc00, "c2");
      orc_program_add_constant (p, 4, 0x000000f8, "c3");
      orc_program_add_constant (p, 4, 0x00000008, "c4");
      orc_program_add_constant (p, 4, 0x00000005, "c5");
      orc_program_add_constant (p, 4, 0x00000003, "c6");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "select1lw", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_BGR16 */
#ifdef DISABLE_ORC
void
video_orc_unpack_BGR16 (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var44;
#else
  orc_union16 var44;
#endif
  orc_union32 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union64 var57;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var39.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpw */
    var40.i = (int)0x000007e0; /* 2016 or 9.96036e-321f */
    /* 5: loadpw */
    var41.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 9: loadpw */
    var42.i = (int)0x00004200; /* 16896 or 8.34773e-320f */
    /* 11: loadpw */
    var43.i = (int)0x00002080; /* 8320 or 4.11063e-320f */
    /* 14: loadpw */
    var44.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var46 = ptr4[i];
    /* 2: andw */
    var47.i = var46.i & var39.i;
    /* 4: andw */
    var48.i = var46.i & var40.i;
    /* 6: andw */
    var49.i = var46.i & var41.i;
    /* 7: shruw */
    var50.i = ((orc_uint16)var47.i) >> 6;
    /* 8: shlw */
    var51.i = ((orc_uint16)var49.i) << 5;
    /* 10: mulhsw */
    var52.i = (var50.i * var42.i) >> 16;
    /* 12: mulhsw */
    var53.i = (var48.i * var43.i) >> 16;
    /* 13: mulhsw */
    var54.i = (var51.i * var42.i) >> 16;
    /* 15: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var54.i;
       var55.i = _dest.i;
    }
    /* 16: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var53.i;
       _dest.x2[1] = var52.i;
       var56.i = _dest.i;
    }
    /* 17: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var55.i;
       _dest.x2[1] = var56.i;
       var57.i = _dest.i;
    }
    /* 18: convsuswb */
    var45.x4[0] = ORC_CLAMP_UB(var57.x4[0]);
    var45.x4[1] = ORC_CLAMP_UB(var57.x4[1]);
    var45.x4[2] = ORC_CLAMP_UB(var57.x4[2]);
    var45.x4[3] = ORC_CLAMP_UB(var57.x4[3]);
    /* 19: storel */
    ptr0[i] = var45;
  }

}

#else
static void
_backup_video_orc_unpack_BGR16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var44;
#else
  orc_union16 var44;
#endif
  orc_union32 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union64 var57;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var39.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpw */
    var40.i = (int)0x000007e0; /* 2016 or 9.96036e-321f */
    /* 5: loadpw */
    var41.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 9: loadpw */
    var42.i = (int)0x00004200; /* 16896 or 8.34773e-320f */
    /* 11: loadpw */
    var43.i = (int)0x00002080; /* 8320 or 4.11063e-320f */
    /* 14: loadpw */
    var44.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var46 = ptr4[i];
    /* 2: andw */
    var47.i = var46.i & var39.i;
    /* 4: andw */
    var48.i = var46.i & var40.i;
    /* 6: andw */
    var49.i = var46.i & var41.i;
    /* 7: shruw */
    var50.i = ((orc_uint16)var47.i) >> 6;
    /* 8: shlw */
    var51.i = ((orc_uint16)var49.i) << 5;
    /* 10: mulhsw */
    var52.i = (var50.i * var42.i) >> 16;
    /* 12: mulhsw */
    var53.i = (var48.i * var43.i) >> 16;
    /* 13: mulhsw */
    var54.i = (var51.i * var42.i) >> 16;
    /* 15: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var54.i;
       var55.i = _dest.i;
    }
    /* 16: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var53.i;
       _dest.x2[1] = var52.i;
       var56.i = _dest.i;
    }
    /* 17: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var55.i;
       _dest.x2[1] = var56.i;
       var57.i = _dest.i;
    }
    /* 18: convsuswb */
    var45.x4[0] = ORC_CLAMP_UB(var57.x4[0]);
    var45.x4[1] = ORC_CLAMP_UB(var57.x4[1]);
    var45.x4[2] = ORC_CLAMP_UB(var57.x4[2]);
    var45.x4[3] = ORC_CLAMP_UB(var57.x4[3]);
    /* 19: storel */
    ptr0[i] = var45;
  }

}

void
video_orc_unpack_BGR16 (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 22, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 66, 71, 82, 49, 54, 11, 4, 4, 12, 2, 2, 14, 
        2, 0, 248, 0, 0, 14, 2, 224, 7, 0, 0, 14, 2, 31, 0, 0, 
        0, 14, 2, 6, 0, 0, 0, 14, 2, 5, 0, 0, 0, 14, 2, 0, 
        66, 0, 0, 14, 2, 128, 32, 0, 0, 14, 2, 255, 0, 0, 0, 20, 
        2, 20, 2, 20, 2, 20, 2, 20, 4, 20, 4, 20, 8, 82, 32, 4, 
        73, 35, 32, 16, 73, 34, 32, 17, 73, 33, 32, 18, 95, 35, 35, 19, 
        93, 33, 33, 20, 90, 35, 35, 21, 90, 34, 34, 22, 90, 33, 33, 21, 
        195, 36, 23, 33, 195, 37, 34, 35, 194, 38, 36, 37, 21, 2, 160, 0, 
        38, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGR16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_BGR16");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGR16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0x0000f800, "c1");
      orc_program_add_constant (p, 2, 0x000007e0, "c2");
      orc_program_add_constant (p, 2, 0x0000001f, "c3");
      orc_program_add_constant (p, 2, 0x00000006, "c4");
      orc_program_add_constant (p, 2, 0x00000005, "c5");
      orc_program_add_constant (p, 2, 0x00004200, "c6");
      orc_program_add_constant (p, 2, 0x00002080, "c7");
      orc_program_add_constant (p, 2, 0x000000ff, "c8");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 4, "t6");
      orc_program_add_temporary (p, 8, "t7");

      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C7, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T5, ORC_VAR_C8, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_T7, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 2, ORC_VAR_D1, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_unpack_BGR16_trunc */
#ifdef DISABLE_ORC
void
video_orc_unpack_BGR16_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_union32 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union32 var51;
  orc_union32 var52;
  orc_union64 var53;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var39.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpw */
    var40.i = (int)0x000007e0; /* 2016 or 9.96036e-321f */
    /* 5: loadpw */
    var41.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 10: loadpw */
    var42.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var44 = ptr4[i];
    /* 2: andw */
    var45.i = var44.i & var39.i;
    /* 4: andw */
    var46.i = var44.i & var40.i;
    /* 6: andw */
    var47.i = var44.i & var41.i;
    /* 7: shruw */
    var48.i = ((orc_uint16)var45.i) >> 8;
    /* 8: shruw */
    var49.i = ((orc_uint16)var46.i) >> 3;
    /* 9: shlw */
    var50.i = ((orc_uint16)var47.i) << 3;
    /* 11: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.i;
       _dest.x2[1] = var50.i;
       var51.i = _dest.i;
    }
    /* 12: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var49.i;
       _dest.x2[1] = var48.i;
       var52.i = _dest.i;
    }
    /* 13: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var51.i;
       _dest.x2[1] = var52.i;
       var53.i = _dest.i;
    }
    /* 14: convsuswb */
    var43.x4[0] = ORC_CLAMP_UB(var53.x4[0]);
    var43.x4[1] = ORC_CLAMP_UB(var53.x4[1]);
    var43.x4[2] = ORC_CLAMP_UB(var53.x4[2]);
    var43.x4[3] = ORC_CLAMP_UB(var53.x4[3]);
    /* 15: storel */
    ptr0[i] = var43;
  }

}

#else
static void
_backup_video_orc_unpack_BGR16_trunc (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var40;
#else
  orc_union16 var40;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_union32 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union32 var51;
  orc_union32 var52;
  orc_union64 var53;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var39.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpw */
    var40.i = (int)0x000007e0; /* 2016 or 9.96036e-321f */
    /* 5: loadpw */
    var41.i = (int)0x0000001f; /* 31 or 1.5316e-322f */
    /* 10: loadpw */
    var42.i = (int)0x000000ff; /* 255 or 1.25987e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var44 = ptr4[i];
    /* 2: andw */
    var45.i = var44.i & var39.i;
    /* 4: andw */
    var46.i = var44.i & var40.i;
    /* 6: andw */
    var47.i = var44.i & var41.i;
    /* 7: shruw */
    var48.i = ((orc_uint16)var45.i) >> 8;
    /* 8: shruw */
    var49.i = ((orc_uint16)var46.i) >> 3;
    /* 9: shlw */
    var50.i = ((orc_uint16)var47.i) << 3;
    /* 11: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.i;
       _dest.x2[1] = var50.i;
       var51.i = _dest.i;
    }
    /* 12: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var49.i;
       _dest.x2[1] = var48.i;
       var52.i = _dest.i;
    }
    /* 13: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var51.i;
       _dest.x2[1] = var52.i;
       var53.i = _dest.i;
    }
    /* 14: convsuswb */
    var43.x4[0] = ORC_CLAMP_UB(var53.x4[0]);
    var43.x4[1] = ORC_CLAMP_UB(var53.x4[1]);
    var43.x4[2] = ORC_CLAMP_UB(var53.x4[2]);
    var43.x4[3] = ORC_CLAMP_UB(var53.x4[3]);
    /* 15: storel */
    ptr0[i] = var43;
  }

}

void
video_orc_unpack_BGR16_trunc (guint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 28, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 117, 110, 112, 
        97, 99, 107, 95, 66, 71, 82, 49, 54, 95, 116, 114, 117, 110, 99, 11, 
        4, 4, 12, 2, 2, 14, 2, 0, 248, 0, 0, 14, 2, 224, 7, 0, 
        0, 14, 2, 31, 0, 0, 0, 14, 2, 8, 0, 0, 0, 14, 2, 3, 
        0, 0, 0, 14, 2, 255, 0, 0, 0, 20, 2, 20, 2, 20, 2, 20, 
        2, 20, 4, 20, 4, 20, 8, 82, 32, 4, 73, 35, 32, 16, 73, 34, 
        32, 17, 73, 33, 32, 18, 95, 35, 35, 19, 95, 34, 34, 20, 93, 33, 
        33, 20, 195, 36, 21, 33, 195, 37, 34, 35, 194, 38, 36, 37, 21, 2, 
        160, 0, 38, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGR16_trunc);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_unpack_BGR16_trunc");
      orc_program_set_backup_function (p, _backup_video_orc_unpack_BGR16_trunc);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0x0000f800, "c1");
      orc_program_add_constant (p, 2, 0x000007e0, "c2");
      orc_program_add_constant (p, 2, 0x0000001f, "c3");
      orc_program_add_constant (p, 2, 0x00000008, "c4");
      orc_program_add_constant (p, 2, 0x00000003, "c5");
      orc_program_add_constant (p, 2, 0x000000ff, "c6");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 4, "t6");
      orc_program_add_temporary (p, 8, "t7");

      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T5, ORC_VAR_C6, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_T7, ORC_VAR_T5, ORC_VAR_T6, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 2, ORC_VAR_D1, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_BGR16_le */
#ifdef DISABLE_ORC
void
video_orc_pack_BGR16_le (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var37.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpl */
    var38.i = (int)0x00fc0000; /* 16515072 or 8.15953e-317f */
    /* 5: loadpl */
    var39.i = (int)0xf8000000; /* -134217728 or 2.05568e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shrul */
    var45.i = ((orc_uint32)var42.i) >> 11;
    /* 8: shrul */
    var46.i = ((orc_uint32)var43.i) >> 13;
    /* 9: shrul */
    var47.i = ((orc_uint32)var44.i) >> 16;
    /* 10: orl */
    var48.i = var45.i | var46.i;
    /* 11: orl */
    var49.i = var48.i | var47.i;
    /* 12: select0lw */
    {
       orc_union32 _src;
       _src.i = var49.i;
       var40.i = _src.x2[0];
    }
    /* 13: storew */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_video_orc_pack_BGR16_le (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var37.i = (int)0x0000f800; /* 63488 or 3.13672e-319f */
    /* 3: loadpl */
    var38.i = (int)0x00fc0000; /* 16515072 or 8.15953e-317f */
    /* 5: loadpl */
    var39.i = (int)0xf8000000; /* -134217728 or 2.05568e-314f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shrul */
    var45.i = ((orc_uint32)var42.i) >> 11;
    /* 8: shrul */
    var46.i = ((orc_uint32)var43.i) >> 13;
    /* 9: shrul */
    var47.i = ((orc_uint32)var44.i) >> 16;
    /* 10: orl */
    var48.i = var45.i | var46.i;
    /* 11: orl */
    var49.i = var48.i | var47.i;
    /* 12: select0lw */
    {
       orc_union32 _src;
       _src.i = var49.i;
       var40.i = _src.x2[0];
    }
    /* 13: storew */
    ptr0[i] = var40;
  }

}

void
video_orc_pack_BGR16_le (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 66, 71, 82, 49, 54, 95, 108, 101, 11, 2, 2, 12, 4, 4, 
        14, 4, 0, 248, 0, 0, 14, 4, 0, 0, 252, 0, 14, 4, 0, 0, 
        0, 248, 14, 4, 11, 0, 0, 0, 14, 4, 13, 0, 0, 0, 14, 4, 
        16, 0, 0, 0, 20, 4, 20, 4, 20, 4, 20, 4, 20, 4, 113, 32, 
        4, 106, 33, 32, 16, 106, 34, 32, 17, 106, 35, 32, 18, 126, 33, 33, 
        19, 126, 34, 34, 20, 126, 35, 35, 21, 123, 36, 33, 34, 123, 36, 36, 
        35, 190, 0, 36, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_BGR16_le);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_BGR16_le");
      orc_program_set_backup_function (p, _backup_video_orc_pack_BGR16_le);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x0000f800, "c1");
      orc_program_add_constant (p, 4, 0x00fc0000, "c2");
      orc_program_add_constant (p, 4, 0xf8000000, "c3");
      orc_program_add_constant (p, 4, 0x0000000b, "c4");
      orc_program_add_constant (p, 4, 0x0000000d, "c5");
      orc_program_add_constant (p, 4, 0x00000010, "c6");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_pack_BGR16_be */
#ifdef DISABLE_ORC
void
video_orc_pack_BGR16_be (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var37.i = (int)0x00f80000; /* 16252928 or 8.03001e-317f */
    /* 3: loadpl */
    var38.i = (int)0x0000fc00; /* 64512 or 3.18732e-319f */
    /* 5: loadpl */
    var39.i = (int)0x000000f8; /* 248 or 1.22528e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shll */
    var45.i = ((orc_uint32)var44.i) << 8;
    /* 8: shrul */
    var46.i = ((orc_uint32)var43.i) >> 5;
    /* 9: shrul */
    var47.i = ((orc_uint32)var42.i) >> 19;
    /* 10: orl */
    var48.i = var47.i | var46.i;
    /* 11: orl */
    var49.i = var48.i | var45.i;
    /* 12: select1lw */
    {
       orc_union32 _src;
       _src.i = var49.i;
       var40.i = _src.x2[1];
    }
    /* 13: storew */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_video_orc_pack_BGR16_be (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var37;
#else
  orc_union32 var37;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var39;
#else
  orc_union32 var39;
#endif
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var37.i = (int)0x00f80000; /* 16252928 or 8.03001e-317f */
    /* 3: loadpl */
    var38.i = (int)0x0000fc00; /* 64512 or 3.18732e-319f */
    /* 5: loadpl */
    var39.i = (int)0x000000f8; /* 248 or 1.22528e-321f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var41 = ptr4[i];
    /* 2: andl */
    var42.i = var41.i & var37.i;
    /* 4: andl */
    var43.i = var41.i & var38.i;
    /* 6: andl */
    var44.i = var41.i & var39.i;
    /* 7: shll */
    var45.i = ((orc_uint32)var44.i) << 8;
    /* 8: shrul */
    var46.i = ((orc_uint32)var43.i) >> 5;
    /* 9: shrul */
    var47.i = ((orc_uint32)var42.i) >> 19;
    /* 10: orl */
    var48.i = var47.i | var46.i;
    /* 11: orl */
    var49.i = var48.i | var45.i;
    /* 12: select1lw */
    {
       orc_union32 _src;
       _src.i = var49.i;
       var40.i = _src.x2[1];
    }
    /* 13: storew */
    ptr0[i] = var40;
  }

}

void
video_orc_pack_BGR16_be (guint16 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 23, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 97, 99, 
        107, 95, 66, 71, 82, 49, 54, 95, 98, 101, 11, 2, 2, 12, 4, 4, 
        14, 4, 0, 0, 248, 0, 14, 4, 0, 252, 0, 0, 14, 4, 248, 0, 
        0, 0, 14, 4, 8, 0, 0, 0, 14, 4, 5, 0, 0, 0, 14, 4, 
        19, 0, 0, 0, 20, 4, 20, 4, 20, 4, 20, 4, 20, 4, 113, 32, 
        4, 106, 33, 32, 16, 106, 34, 32, 17, 106, 35, 32, 18, 124, 35, 35, 
        19, 126, 34, 34, 20, 126, 33, 33, 21, 123, 36, 33, 34, 123, 36, 36, 
        35, 191, 0, 36, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_pack_BGR16_be);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_pack_BGR16_be");
      orc_program_set_backup_function (p, _backup_video_orc_pack_BGR16_be);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00f80000, "c1");
      orc_program_add_constant (p, 4, 0x0000fc00, "c2");
      orc_program_add_constant (p, 4, 0x000000f8, "c3");
      orc_program_add_constant (p, 4, 0x00000008, "c4");
      orc_program_add_constant (p, 4, 0x00000005, "c5");
      orc_program_add_constant (p, 4, 0x00000013, "c6");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "loadl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "andl", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 0, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C5, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C6, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "orl", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "select1lw", 0, ORC_VAR_D1, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_bilinear_u32 */
#ifdef DISABLE_ORC
void
video_orc_resample_bilinear_u32 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int p2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: ldreslinl */
    {
    int tmp = p1 + i * p2;
    orc_union32 a = ptr4[tmp>>16];
    orc_union32 b = ptr4[(tmp>>16)+1];
    var32.x4[0] = ((orc_uint8)a.x4[0] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[0] * ((tmp>>8)&0xff))>>8;
    var32.x4[1] = ((orc_uint8)a.x4[1] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[1] * ((tmp>>8)&0xff))>>8;
    var32.x4[2] = ((orc_uint8)a.x4[2] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[2] * ((tmp>>8)&0xff))>>8;
    var32.x4[3] = ((orc_uint8)a.x4[3] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[3] * ((tmp>>8)&0xff))>>8;
    }
    /* 1: storel */
    ptr0[i] = var32;
  }

}

#else
static void
_backup_video_orc_resample_bilinear_u32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: ldreslinl */
    {
    int tmp = ex->params[24] + i * ex->params[25];
    orc_union32 a = ptr4[tmp>>16];
    orc_union32 b = ptr4[(tmp>>16)+1];
    var32.x4[0] = ((orc_uint8)a.x4[0] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[0] * ((tmp>>8)&0xff))>>8;
    var32.x4[1] = ((orc_uint8)a.x4[1] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[1] * ((tmp>>8)&0xff))>>8;
    var32.x4[2] = ((orc_uint8)a.x4[2] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[2] * ((tmp>>8)&0xff))>>8;
    var32.x4[3] = ((orc_uint8)a.x4[3] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[3] * ((tmp>>8)&0xff))>>8;
    }
    /* 1: storel */
    ptr0[i] = var32;
  }

}

void
video_orc_resample_bilinear_u32 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 98, 105, 108, 105, 110, 101, 97, 114, 95, 117, 
        51, 50, 11, 4, 4, 12, 4, 4, 16, 4, 16, 4, 51, 0, 4, 24, 
        25, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_bilinear_u32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_bilinear_u32");
      orc_program_set_backup_function (p, _backup_video_orc_resample_bilinear_u32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");

      orc_program_append_2 (p, "ldreslinl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_P1, ORC_VAR_P2);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_merge_linear_u8 */
#ifdef DISABLE_ORC
void
video_orc_merge_linear_u8 (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int p1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
  orc_int8 var40;
  orc_int8 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_int8 var47;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;

    /* 6: loadpw */
    var38.i = p1;
    /* 8: loadpw */
    var39.i = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var41 = ptr4[i];
    /* 1: loadb */
    var36 = ptr4[i];
    /* 2: convubw */
    var42.i = (orc_uint8)var36;
    /* 3: loadb */
    var37 = ptr5[i];
    /* 4: convubw */
    var43.i = (orc_uint8)var37;
    /* 5: subw */
    var44.i = var43.i - var42.i;
    /* 7: mullw */
    var45.i = (var44.i * var38.i) & 0xffff;
    /* 9: addw */
    var46.i = var45.i + var39.i;
    /* 10: convhwb */
    var47 = ((orc_uint16)var46.i)>>8;
    /* 11: addb */
    var40 = var47 + var41;
    /* 12: storeb */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_video_orc_merge_linear_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var39;
#else
  orc_union16 var39;
#endif
  orc_int8 var40;
  orc_int8 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_int8 var47;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];

    /* 6: loadpw */
    var38.i = ex->params[24];
    /* 8: loadpw */
    var39.i = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var41 = ptr4[i];
    /* 1: loadb */
    var36 = ptr4[i];
    /* 2: convubw */
    var42.i = (orc_uint8)var36;
    /* 3: loadb */
    var37 = ptr5[i];
    /* 4: convubw */
    var43.i = (orc_uint8)var37;
    /* 5: subw */
    var44.i = var43.i - var42.i;
    /* 7: mullw */
    var45.i = (var44.i * var38.i) & 0xffff;
    /* 9: addw */
    var46.i = var45.i + var39.i;
    /* 10: convhwb */
    var47 = ((orc_uint16)var46.i)>>8;
    /* 11: addb */
    var40 = var47 + var41;
    /* 12: storeb */
    ptr0[i] = var40;
  }

}

void
video_orc_merge_linear_u8 (orc_uint8 * ORC_RESTRICT d1, const orc_uint8 * ORC_RESTRICT s1, const orc_uint8 * ORC_RESTRICT s2, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 25, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 109, 101, 114, 
        103, 101, 95, 108, 105, 110, 101, 97, 114, 95, 117, 56, 11, 1, 1, 12, 
        1, 1, 12, 1, 1, 14, 2, 128, 0, 0, 0, 16, 1, 20, 2, 20, 
        2, 20, 1, 20, 1, 43, 34, 4, 150, 32, 4, 150, 33, 5, 98, 33, 
        33, 32, 89, 33, 33, 24, 70, 33, 33, 16, 158, 35, 33, 33, 0, 35, 
        34, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_merge_linear_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_merge_linear_u8");
      orc_program_set_backup_function (p, _backup_video_orc_merge_linear_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_constant (p, 2, 0x00000080, "c1");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");

      orc_program_append_2 (p, "loadb", 0, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convhwb", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 0, ORC_VAR_D1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_memset_2d */
#ifdef DISABLE_ORC
void
video_orc_memset_2d (guint8 * ORC_RESTRICT d1, int d1_stride, int p1, int n, int m){
  int i;
  int j;
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 var32;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);

      /* 0: loadpb */
        var32 = p1;

    for (i = 0; i < n; i++) {
      /* 1: storeb */
      ptr0[i] = var32;
    }
  }

}

#else
static void
_backup_video_orc_memset_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 var32;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

      /* 0: loadpb */
        var32 = ex->params[24];

    for (i = 0; i < n; i++) {
      /* 1: storeb */
      ptr0[i] = var32;
    }
  }

}

void
video_orc_memset_2d (guint8 * ORC_RESTRICT d1, int d1_stride, int p1, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 109, 101, 
        109, 115, 101, 116, 95, 50, 100, 11, 1, 1, 16, 1, 64, 0, 24, 2, 
        0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_memset_2d);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_memset_2d");
      orc_program_set_backup_function (p, _backup_video_orc_memset_2d);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_parameter (p, 1, "p1");

      orc_program_append_2 (p, "storeb", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_memcpy_2d */
#ifdef DISABLE_ORC
void
video_orc_memcpy_2d (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: copyb */
      var33 = var32;
      /* 2: storeb */
      ptr0[i] = var33;
    }
  }

}

#else
static void
_backup_video_orc_memcpy_2d (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: copyb */
      var33 = var32;
      /* 2: storeb */
      ptr0[i] = var33;
    }
  }

}

void
video_orc_memcpy_2d (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 109, 101, 
        109, 99, 112, 121, 95, 50, 100, 11, 1, 1, 12, 1, 1, 42, 0, 4, 
        2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_memcpy_2d);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_memcpy_2d");
      orc_program_set_backup_function (p, _backup_video_orc_memcpy_2d);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");

      orc_program_append_2 (p, "copyb", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_u16_to_u8 */
#ifdef DISABLE_ORC
void
video_orc_convert_u16_to_u8 (guint8 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union16 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: convhwb */
    var33 = ((orc_uint16)var32.i)>>8;
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_video_orc_convert_u16_to_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var32;
  orc_int8 var33;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var32 = ptr4[i];
    /* 1: convhwb */
    var33 = ((orc_uint16)var32.i)>>8;
    /* 2: storeb */
    ptr0[i] = var33;
  }

}

void
video_orc_convert_u16_to_u8 (guint8 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 110, 
        118, 101, 114, 116, 95, 117, 49, 54, 95, 116, 111, 95, 117, 56, 11, 1, 
        1, 12, 2, 2, 158, 0, 4, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_u16_to_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_convert_u16_to_u8");
      orc_program_set_backup_function (p, _backup_video_orc_convert_u16_to_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");

      orc_program_append_2 (p, "convhwb", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_u8_to_u16 */
#ifdef DISABLE_ORC
void
video_orc_convert_u8_to_u16 (guint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_int8 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr4[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var32;
       _dest.x2[1] = var33;
       var34.i = _dest.i;
    }
    /* 3: storew */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_video_orc_convert_u8_to_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;
  orc_union16 var34;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr4[i];
    /* 1: loadb */
    var33 = ptr4[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var32;
       _dest.x2[1] = var33;
       var34.i = _dest.i;
    }
    /* 3: storew */
    ptr0[i] = var34;
  }

}

void
video_orc_convert_u8_to_u16 (guint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 110, 
        118, 101, 114, 116, 95, 117, 56, 95, 116, 111, 95, 117, 49, 54, 11, 2, 
        2, 12, 1, 1, 196, 0, 4, 4, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_u8_to_u16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_convert_u8_to_u16");
      orc_program_set_backup_function (p, _backup_video_orc_convert_u8_to_u16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_splat_u16 */
#ifdef DISABLE_ORC
void
video_orc_splat_u16 (guint8 * ORC_RESTRICT d1, int p1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;

  ptr0 = (orc_union16 *)d1;

    /* 0: loadpw */
    var32.i = p1;

  for (i = 0; i < n; i++) {
    /* 1: storew */
    ptr0[i] = var32;
  }

}

#else
static void
_backup_video_orc_splat_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 var32;

  ptr0 = (orc_union16 *)ex->arrays[0];

    /* 0: loadpw */
    var32.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 1: storew */
    ptr0[i] = var32;
  }

}

void
video_orc_splat_u16 (guint8 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 115, 112, 108, 
        97, 116, 95, 117, 49, 54, 11, 2, 2, 16, 2, 97, 0, 24, 2, 0, 

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_splat_u16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_splat_u16");
      orc_program_set_backup_function (p, _backup_video_orc_splat_u16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_parameter (p, 2, "p1");

      orc_program_append_2 (p, "storew", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_splat_u32 */
#ifdef DISABLE_ORC
void
video_orc_splat_u32 (guint8 * ORC_RESTRICT d1, int p1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var32;

  ptr0 = (orc_union32 *)d1;

    /* 0: loadpl */
    var32.i = p1;

  for (i = 0; i < n; i++) {
    /* 1: storel */
    ptr0[i] = var32;
  }

}

#else
static void
_backup_video_orc_splat_u32 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var32;

  ptr0 = (orc_union32 *)ex->arrays[0];

    /* 0: loadpl */
    var32.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 1: storel */
    ptr0[i] = var32;
  }

}

void
video_orc_splat_u32 (guint8 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 115, 112, 108, 
        97, 116, 95, 117, 51, 50, 11, 4, 4, 16, 4, 128, 0, 24, 2, 0, 

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_splat_u32);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_splat_u32");
      orc_program_set_backup_function (p, _backup_video_orc_splat_u32);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_parameter (p, 4, "p1");

      orc_program_append_2 (p, "storel", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_splat_u64 */
#ifdef DISABLE_ORC
void
video_orc_splat_u64 (guint8 * ORC_RESTRICT d1, orc_int64 p1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  orc_union64 var32;

  ptr0 = (orc_union64 *)d1;

    /* 0: loadpq */
    var32.i = p1;

  for (i = 0; i < n; i++) {
    /* 1: storeq */
    ptr0[i] = var32;
  }

}

#else
static void
_backup_video_orc_splat_u64 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  orc_union64 var32;

  ptr0 = (orc_union64 *)ex->arrays[0];

    /* 0: loadpq */
    var32.i = (ex->params[24] & 0xffffffff) | ((orc_uint64)(ex->params[24 + (ORC_VAR_T1 - ORC_VAR_P1)]) << 32);

  for (i = 0; i < n; i++) {
    /* 1: storeq */
    ptr0[i] = var32;
  }

}

void
video_orc_splat_u64 (guint8 * ORC_RESTRICT d1, orc_int64 p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 19, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 115, 112, 108, 
        97, 116, 95, 117, 54, 52, 11, 8, 8, 18, 8, 135, 0, 24, 2, 0, 

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_splat_u64);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_splat_u64");
      orc_program_set_backup_function (p, _backup_video_orc_splat_u64);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_parameter_int64 (p, 8, "p1");

      orc_program_append_2 (p, "storeq", 0, ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  {
    orc_union64 tmp;
    tmp.i = p1;
    ex->params[ORC_VAR_P1] = ((orc_uint64) tmp.i) & 0xffffffff;
    ex->params[ORC_VAR_T1] = ((orc_uint64) tmp.i) >> 32;
  }

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_splat2_u64 */
#ifdef DISABLE_ORC
void
video_orc_splat2_u64 (guint8 * ORC_RESTRICT d1, int p1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  orc_union64 var33;
  orc_union32 var34;

  ptr0 = (orc_union64 *)d1;

    /* 0: loadpl */
    var34.i = p1;

  for (i = 0; i < n; i++) {
    /* 1: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var34.x4[0];
       _dest.x2[1] = var34.x4[0];
       var33.x4[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var34.x4[1];
       _dest.x2[1] = var34.x4[1];
       var33.x4[1] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var34.x4[2];
       _dest.x2[1] = var34.x4[2];
       var33.x4[2] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var34.x4[3];
       _dest.x2[1] = var34.x4[3];
       var33.x4[3] = _dest.i;
    }
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

#else
static void
_backup_video_orc_splat2_u64 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  orc_union64 var33;
  orc_union32 var34;

  ptr0 = (orc_union64 *)ex->arrays[0];

    /* 0: loadpl */
    var34.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 1: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var34.x4[0];
       _dest.x2[1] = var34.x4[0];
       var33.x4[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var34.x4[1];
       _dest.x2[1] = var34.x4[1];
       var33.x4[1] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var34.x4[2];
       _dest.x2[1] = var34.x4[2];
       var33.x4[2] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var34.x4[3];
       _dest.x2[1] = var34.x4[3];
       var33.x4[3] = _dest.i;
    }
    /* 2: storeq */
    ptr0[i] = var33;
  }

}

void
video_orc_splat2_u64 (guint8 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 20, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 115, 112, 108, 
        97, 116, 50, 95, 117, 54, 52, 11, 8, 8, 16, 4, 20, 4, 115, 32, 
        24, 21, 2, 196, 0, 32, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_splat2_u64);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_splat2_u64");
      orc_program_set_backup_function (p, _backup_video_orc_splat2_u64);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "loadpl", 0, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 2, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_I420_UYVY */
#ifdef DISABLE_ORC
void
video_orc_convert_I420_UYVY (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_union32 *)d1;
  ptr1 = (orc_union32 *)d2;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_int8 *)s4;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr6[i];
    /* 1: loadb */
    var34 = ptr7[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var33;
       _dest.x2[1] = var34;
       var39.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var39.x2[0];
       _dest.x2[1] = var35.x2[0];
       var36.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var39.x2[1];
       _dest.x2[1] = var35.x2[1];
       var36.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
    /* 6: loadw */
    var37 = ptr5[i];
    /* 7: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var39.x2[0];
       _dest.x2[1] = var37.x2[0];
       var38.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var39.x2[1];
       _dest.x2[1] = var37.x2[1];
       var38.x2[1] = _dest.i;
    }
    /* 8: storel */
    ptr1[i] = var38;
  }

}

#else
static void
_backup_video_orc_convert_I420_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr1 = (orc_union32 *)ex->arrays[1];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr6[i];
    /* 1: loadb */
    var34 = ptr7[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var33;
       _dest.x2[1] = var34;
       var39.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var39.x2[0];
       _dest.x2[1] = var35.x2[0];
       var36.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var39.x2[1];
       _dest.x2[1] = var35.x2[1];
       var36.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
    /* 6: loadw */
    var37 = ptr5[i];
    /* 7: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var39.x2[0];
       _dest.x2[1] = var37.x2[0];
       var38.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var39.x2[1];
       _dest.x2[1] = var37.x2[1];
       var38.x2[1] = _dest.i;
    }
    /* 8: storel */
    ptr1[i] = var38;
  }

}

void
video_orc_convert_I420_UYVY (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 110, 
        118, 101, 114, 116, 95, 73, 52, 50, 48, 95, 85, 89, 86, 89, 11, 4, 
        4, 11, 4, 4, 12, 2, 2, 12, 2, 2, 12, 1, 1, 12, 1, 1, 
        20, 2, 196, 32, 6, 7, 21, 1, 196, 0, 32, 4, 21, 1, 196, 1, 
        32, 5, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_I420_UYVY);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_convert_I420_UYVY");
      orc_program_set_backup_function (p, _backup_video_orc_convert_I420_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_I420_YUY2 */
#ifdef DISABLE_ORC
void
video_orc_convert_I420_YUY2 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_union32 *)d1;
  ptr1 = (orc_union32 *)d2;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_int8 *)s4;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr6[i];
    /* 1: loadb */
    var34 = ptr7[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var33;
       _dest.x2[1] = var34;
       var39.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var35.x2[0];
       _dest.x2[1] = var39.x2[0];
       var36.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var35.x2[1];
       _dest.x2[1] = var39.x2[1];
       var36.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
    /* 6: loadw */
    var37 = ptr5[i];
    /* 7: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var39.x2[0];
       var38.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var39.x2[1];
       var38.x2[1] = _dest.i;
    }
    /* 8: storel */
    ptr1[i] = var38;
  }

}

#else
static void
_backup_video_orc_convert_I420_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr1 = (orc_union32 *)ex->arrays[1];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr6[i];
    /* 1: loadb */
    var34 = ptr7[i];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var33;
       _dest.x2[1] = var34;
       var39.i = _dest.i;
    }
    /* 3: loadw */
    var35 = ptr4[i];
    /* 4: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var35.x2[0];
       _dest.x2[1] = var39.x2[0];
       var36.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var35.x2[1];
       _dest.x2[1] = var39.x2[1];
       var36.x2[1] = _dest.i;
    }
    /* 5: storel */
    ptr0[i] = var36;
    /* 6: loadw */
    var37 = ptr5[i];
    /* 7: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var39.x2[0];
       var38.x2[0] = _dest.i;
    }
    {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var39.x2[1];
       var38.x2[1] = _dest.i;
    }
    /* 8: storel */
    ptr1[i] = var38;
  }

}

void
video_orc_convert_I420_YUY2 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 110, 
        118, 101, 114, 116, 95, 73, 52, 50, 48, 95, 89, 85, 89, 50, 11, 4, 
        4, 11, 4, 4, 12, 2, 2, 12, 2, 2, 12, 1, 1, 12, 1, 1, 
        20, 2, 196, 32, 6, 7, 21, 1, 196, 0, 4, 32, 21, 1, 196, 1, 
        5, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_I420_YUY2);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_convert_I420_YUY2");
      orc_program_set_backup_function (p, _backup_video_orc_convert_I420_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D2, ORC_VAR_S2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_I420_AYUV */
#ifdef DISABLE_ORC
void
video_orc_convert_I420_AYUV (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_union32 var40;
  orc_int8 var41;
  orc_int8 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;

  ptr0 = (orc_union32 *)d1;
  ptr1 = (orc_union32 *)d2;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_int8 *)s4;

    /* 3: loadpb */
    var36 = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var41 = ptr6[i>>1];
    /* 1: loadupdb */
    var42 = ptr7[i>>1];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var41;
       _dest.x2[1] = var42;
       var43.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var37;
       var44.i = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var43.i;
       var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
    /* 8: loadb */
    var39 = ptr5[i];
    /* 9: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var39;
       var45.i = _dest.i;
    }
    /* 10: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var45.i;
       _dest.x2[1] = var43.i;
       var40.i = _dest.i;
    }
    /* 11: storel */
    ptr1[i] = var40;
  }

}

#else
static void
_backup_video_orc_convert_I420_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_int8 var39;
  orc_union32 var40;
  orc_int8 var41;
  orc_int8 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr1 = (orc_union32 *)ex->arrays[1];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];

    /* 3: loadpb */
    var36 = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadupdb */
    var41 = ptr6[i>>1];
    /* 1: loadupdb */
    var42 = ptr7[i>>1];
    /* 2: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var41;
       _dest.x2[1] = var42;
       var43.i = _dest.i;
    }
    /* 4: loadb */
    var37 = ptr4[i];
    /* 5: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var37;
       var44.i = _dest.i;
    }
    /* 6: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var43.i;
       var38.i = _dest.i;
    }
    /* 7: storel */
    ptr0[i] = var38;
    /* 8: loadb */
    var39 = ptr5[i];
    /* 9: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var39;
       var45.i = _dest.i;
    }
    /* 10: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var45.i;
       _dest.x2[1] = var43.i;
       var40.i = _dest.i;
    }
    /* 11: storel */
    ptr1[i] = var40;
  }

}

void
video_orc_convert_I420_AYUV (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 110, 
        118, 101, 114, 116, 95, 73, 52, 50, 48, 95, 65, 89, 85, 86, 11, 4, 
        4, 11, 4, 4, 12, 1, 1, 12, 1, 1, 12, 1, 1, 12, 1, 1, 
        16, 1, 20, 2, 20, 2, 20, 1, 20, 1, 45, 34, 6, 45, 35, 7, 
        196, 32, 34, 35, 196, 33, 24, 4, 195, 0, 33, 32, 196, 33, 24, 5, 
        195, 1, 33, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_I420_AYUV);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_convert_I420_AYUV");
      orc_program_set_backup_function (p, _backup_video_orc_convert_I420_AYUV);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");

      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T4, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_P1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_P1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_YUY2_I420 */
#ifdef DISABLE_ORC
void
video_orc_convert_YUY2_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  orc_int8 * ORC_RESTRICT ptr3;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var35;
  orc_union32 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;
  ptr2 = (orc_int8 *)d3;
  ptr3 = (orc_int8 *)d4;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: splitwb */
    {
       orc_union16 _src;
       _src.i = var35.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var35.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
    /* 2: storew */
    ptr0[i] = var40;
    /* 3: loadl */
    var36 = ptr5[i];
    /* 4: splitwb */
    {
       orc_union16 _src;
       _src.i = var36.x2[0];
       var41.x2[0] = _src.x2[1];
       var42.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var36.x2[1];
       var41.x2[1] = _src.x2[1];
       var42.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var42;
    /* 6: avgub */
    var43.x2[0] = ((orc_uint8)var39.x2[0] + (orc_uint8)var41.x2[0] + 1)>>1;
    var43.x2[1] = ((orc_uint8)var39.x2[1] + (orc_uint8)var41.x2[1] + 1)>>1;
    /* 7: splitwb */
    {
       orc_union16 _src;
       _src.i = var43.i;
       var37 = _src.x2[1];
       var38 = _src.x2[0];
    }
    /* 8: storeb */
    ptr3[i] = var37;
    /* 9: storeb */
    ptr2[i] = var38;
  }

}

#else
static void
_backup_video_orc_convert_YUY2_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  orc_int8 * ORC_RESTRICT ptr3;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var35;
  orc_union32 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];
  ptr2 = (orc_int8 *)ex->arrays[2];
  ptr3 = (orc_int8 *)ex->arrays[3];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: splitwb */
    {
       orc_union16 _src;
       _src.i = var35.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var35.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
    /* 2: storew */
    ptr0[i] = var40;
    /* 3: loadl */
    var36 = ptr5[i];
    /* 4: splitwb */
    {
       orc_union16 _src;
       _src.i = var36.x2[0];
       var41.x2[0] = _src.x2[1];
       var42.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var36.x2[1];
       var41.x2[1] = _src.x2[1];
       var42.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var42;
    /* 6: avgub */
    var43.x2[0] = ((orc_uint8)var39.x2[0] + (orc_uint8)var41.x2[0] + 1)>>1;
    var43.x2[1] = ((orc_uint8)var39.x2[1] + (orc_uint8)var41.x2[1] + 1)>>1;
    /* 7: splitwb */
    {
       orc_union16 _src;
       _src.i = var43.i;
       var37 = _src.x2[1];
       var38 = _src.x2[0];
    }
    /* 8: storeb */
    ptr3[i] = var37;
    /* 9: storeb */
    ptr2[i] = var38;
  }

}

void
video_orc_convert_YUY2_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 110, 
        118, 101, 114, 116, 95, 89, 85, 89, 50, 95, 73, 52, 50, 48, 11, 2, 
        2, 11, 2, 2, 11, 1, 1, 11, 1, 1, 12, 4, 4, 12, 4, 4, 
        20, 2, 20, 2, 20, 2, 21, 1, 199, 32, 34, 4, 97, 0, 34, 21, 
        1, 199, 33, 34, 5, 97, 1, 34, 21, 1, 39, 32, 32, 33, 199, 3, 
        2, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_YUY2_I420);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_convert_YUY2_I420");
      orc_program_set_backup_function (p, _backup_video_orc_convert_YUY2_I420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_destination (p, 1, "d4");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D4, ORC_VAR_D3, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_D4] = d4;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_UYVY_YUY2 */
#ifdef DISABLE_ORC
void
video_orc_convert_UYVY_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var32 = ptr4[i];
      /* 1: swapw */
      var33.x2[0] = ORC_SWAP_W(var32.x2[0]);
      var33.x2[1] = ORC_SWAP_W(var32.x2[1]);
      /* 2: storel */
      ptr0[i] = var33;
    }
  }

}

#else
static void
_backup_video_orc_convert_UYVY_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;
  orc_union32 var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var32 = ptr4[i];
      /* 1: swapw */
      var33.x2[0] = ORC_SWAP_W(var32.x2[0]);
      var33.x2[1] = ORC_SWAP_W(var32.x2[1]);
      /* 2: storel */
      ptr0[i] = var33;
    }
  }

}

void
video_orc_convert_UYVY_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 85, 89, 86, 89, 95, 89, 85, 89, 50, 11, 
        4, 4, 12, 4, 4, 21, 1, 183, 0, 4, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_UYVY_YUY2);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_UYVY_YUY2");
      orc_program_set_backup_function (p, _backup_video_orc_convert_UYVY_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");

      orc_program_append_2 (p, "swapw", 1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_planar_chroma_420_422 */
#ifdef DISABLE_ORC
void
video_orc_planar_chroma_420_422 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;
  orc_int8 var35;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET(d2, d2_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: copyb */
      var33 = var32;
      /* 2: storeb */
      ptr0[i] = var33;
      /* 3: loadb */
      var34 = ptr4[i];
      /* 4: copyb */
      var35 = var34;
      /* 5: storeb */
      ptr1[i] = var35;
    }
  }

}

#else
static void
_backup_video_orc_planar_chroma_420_422 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;
  orc_int8 var35;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET(ex->arrays[1], ex->params[1] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: copyb */
      var33 = var32;
      /* 2: storeb */
      ptr0[i] = var33;
      /* 3: loadb */
      var34 = ptr4[i];
      /* 4: copyb */
      var35 = var34;
      /* 5: storeb */
      ptr1[i] = var35;
    }
  }

}

void
video_orc_planar_chroma_420_422 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 108, 
        97, 110, 97, 114, 95, 99, 104, 114, 111, 109, 97, 95, 52, 50, 48, 95, 
        52, 50, 50, 11, 1, 1, 11, 1, 1, 12, 1, 1, 42, 0, 4, 42, 
        1, 4, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_planar_chroma_420_422);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_planar_chroma_420_422");
      orc_program_set_backup_function (p, _backup_video_orc_planar_chroma_420_422);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_source (p, 1, "s1");

      orc_program_append_2 (p, "copyb", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "copyb", 0, ORC_VAR_D2, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_planar_chroma_420_444 */
#ifdef DISABLE_ORC
void
video_orc_planar_chroma_420_444 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET(d2, d2_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: splatbw */
      var34.i = ((var33&0xff) << 8) | (var33&0xff);
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: storew */
      ptr1[i] = var34;
    }
  }

}

#else
static void
_backup_video_orc_planar_chroma_420_444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET(ex->arrays[1], ex->params[1] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: splatbw */
      var34.i = ((var33&0xff) << 8) | (var33&0xff);
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: storew */
      ptr1[i] = var34;
    }
  }

}

void
video_orc_planar_chroma_420_444 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 108, 
        97, 110, 97, 114, 95, 99, 104, 114, 111, 109, 97, 95, 52, 50, 48, 95, 
        52, 52, 52, 11, 2, 2, 11, 2, 2, 12, 1, 1, 20, 2, 151, 32, 
        4, 97, 0, 32, 97, 1, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_planar_chroma_420_444);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_planar_chroma_420_444");
      orc_program_set_backup_function (p, _backup_video_orc_planar_chroma_420_444);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_planar_chroma_422_444 */
#ifdef DISABLE_ORC
void
video_orc_planar_chroma_422_444 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: splatbw */
      var34.i = ((var33&0xff) << 8) | (var33&0xff);
      /* 2: storew */
      ptr0[i] = var34;
    }
  }

}

#else
static void
_backup_video_orc_planar_chroma_422_444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: splatbw */
      var34.i = ((var33&0xff) << 8) | (var33&0xff);
      /* 2: storew */
      ptr0[i] = var34;
    }
  }

}

void
video_orc_planar_chroma_422_444 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 108, 
        97, 110, 97, 114, 95, 99, 104, 114, 111, 109, 97, 95, 52, 50, 50, 95, 
        52, 52, 52, 11, 2, 2, 12, 1, 1, 20, 2, 151, 32, 4, 97, 0, 
        32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_planar_chroma_422_444);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_planar_chroma_422_444");
      orc_program_set_backup_function (p, _backup_video_orc_planar_chroma_422_444);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_planar_chroma_444_422 */
#ifdef DISABLE_ORC
void
video_orc_planar_chroma_444_422 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr4[i];
      /* 1: splitwb */
      {
       orc_union16 _src;
       _src.i = var34.i;
       var36 = _src.x2[1];
       var37 = _src.x2[0];
    }
      /* 2: avgub */
      var35 = ((orc_uint8)var36 + (orc_uint8)var37 + 1)>>1;
      /* 3: storeb */
      ptr0[i] = var35;
    }
  }

}

#else
static void
_backup_video_orc_planar_chroma_444_422 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr4[i];
      /* 1: splitwb */
      {
       orc_union16 _src;
       _src.i = var34.i;
       var36 = _src.x2[1];
       var37 = _src.x2[0];
    }
      /* 2: avgub */
      var35 = ((orc_uint8)var36 + (orc_uint8)var37 + 1)>>1;
      /* 3: storeb */
      ptr0[i] = var35;
    }
  }

}

void
video_orc_planar_chroma_444_422 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 108, 
        97, 110, 97, 114, 95, 99, 104, 114, 111, 109, 97, 95, 52, 52, 52, 95, 
        52, 50, 50, 11, 1, 1, 12, 2, 2, 20, 1, 20, 1, 199, 32, 33, 
        4, 39, 0, 32, 33, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_planar_chroma_444_422);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_planar_chroma_444_422");
      orc_program_set_backup_function (p, _backup_video_orc_planar_chroma_444_422);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");

      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_planar_chroma_444_420 */
#ifdef DISABLE_ORC
void
video_orc_planar_chroma_444_420 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m){
  int i;
  int j;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var35;
  orc_union16 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_int8 var40;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var35 = ptr4[i];
      /* 1: loadw */
      var36 = ptr5[i];
      /* 2: avgub */
      var38.x2[0] = ((orc_uint8)var35.x2[0] + (orc_uint8)var36.x2[0] + 1)>>1;
      var38.x2[1] = ((orc_uint8)var35.x2[1] + (orc_uint8)var36.x2[1] + 1)>>1;
      /* 3: splitwb */
      {
       orc_union16 _src;
       _src.i = var38.i;
       var39 = _src.x2[1];
       var40 = _src.x2[0];
    }
      /* 4: avgub */
      var37 = ((orc_uint8)var39 + (orc_uint8)var40 + 1)>>1;
      /* 5: storeb */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_video_orc_planar_chroma_444_420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var35;
  orc_union16 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_int8 var39;
  orc_int8 var40;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var35 = ptr4[i];
      /* 1: loadw */
      var36 = ptr5[i];
      /* 2: avgub */
      var38.x2[0] = ((orc_uint8)var35.x2[0] + (orc_uint8)var36.x2[0] + 1)>>1;
      var38.x2[1] = ((orc_uint8)var35.x2[1] + (orc_uint8)var36.x2[1] + 1)>>1;
      /* 3: splitwb */
      {
       orc_union16 _src;
       _src.i = var38.i;
       var39 = _src.x2[1];
       var40 = _src.x2[0];
    }
      /* 4: avgub */
      var37 = ((orc_uint8)var39 + (orc_uint8)var40 + 1)>>1;
      /* 5: storeb */
      ptr0[i] = var37;
    }
  }

}

void
video_orc_planar_chroma_444_420 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 108, 
        97, 110, 97, 114, 95, 99, 104, 114, 111, 109, 97, 95, 52, 52, 52, 95, 
        52, 50, 48, 11, 1, 1, 12, 2, 2, 12, 2, 2, 20, 2, 20, 1, 
        20, 1, 21, 1, 39, 32, 4, 5, 199, 33, 34, 32, 39, 0, 33, 34, 
        2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_planar_chroma_444_420);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_planar_chroma_444_420");
      orc_program_set_backup_function (p, _backup_video_orc_planar_chroma_444_420);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");

      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_planar_chroma_422_420 */
#ifdef DISABLE_ORC
void
video_orc_planar_chroma_422_420 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m){
  int i;
  int j;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

#else
static void
_backup_video_orc_planar_chroma_422_420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var32 = ptr4[i];
      /* 1: loadb */
      var33 = ptr5[i];
      /* 2: avgub */
      var34 = ((orc_uint8)var32 + (orc_uint8)var33 + 1)>>1;
      /* 3: storeb */
      ptr0[i] = var34;
    }
  }

}

void
video_orc_planar_chroma_422_420 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 112, 108, 
        97, 110, 97, 114, 95, 99, 104, 114, 111, 109, 97, 95, 52, 50, 50, 95, 
        52, 50, 48, 11, 1, 1, 12, 1, 1, 12, 1, 1, 39, 0, 4, 5, 
        2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_planar_chroma_422_420);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_planar_chroma_422_420");
      orc_program_set_backup_function (p, _backup_video_orc_planar_chroma_422_420);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");

      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_YUY2_AYUV */
#ifdef DISABLE_ORC
void
video_orc_convert_YUY2_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int n, int m){
  int i;
  int j;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);

      /* 2: loadpb */
        var37.x2[0] = p1;
      var37.x2[1] = p1;

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var36 = ptr4[i];
      /* 1: splitwb */
      {
       orc_union16 _src;
       _src.i = var36.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
      {
       orc_union16 _src;
       _src.i = var36.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
      /* 3: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var40.x2[0];
       var41.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var40.x2[1];
       var41.x2[1] = _dest.i;
    }
      /* 4: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var39.i;
       _dest.x2[1] = var39.i;
       var42.i = _dest.i;
    }
      /* 5: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[0];
       _dest.x2[1] = var42.x2[0];
       var38.x2[0] = _dest.i;
    }
      {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[1];
       _dest.x2[1] = var42.x2[1];
       var38.x2[1] = _dest.i;
    }
      /* 6: storeq */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_video_orc_convert_YUY2_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

      /* 2: loadpb */
        var37.x2[0] = ex->params[24];
      var37.x2[1] = ex->params[24];

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var36 = ptr4[i];
      /* 1: splitwb */
      {
       orc_union16 _src;
       _src.i = var36.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
      {
       orc_union16 _src;
       _src.i = var36.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
      /* 3: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var40.x2[0];
       var41.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var40.x2[1];
       var41.x2[1] = _dest.i;
    }
      /* 4: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var39.i;
       _dest.x2[1] = var39.i;
       var42.i = _dest.i;
    }
      /* 5: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[0];
       _dest.x2[1] = var42.x2[0];
       var38.x2[0] = _dest.i;
    }
      {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[1];
       _dest.x2[1] = var42.x2[1];
       var38.x2[1] = _dest.i;
    }
      /* 6: storeq */
      ptr0[i] = var38;
    }
  }

}

void
video_orc_convert_YUY2_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 89, 85, 89, 50, 95, 65, 89, 85, 86, 11, 
        8, 8, 12, 4, 4, 16, 1, 20, 2, 20, 2, 20, 4, 20, 4, 21, 
        1, 199, 33, 32, 4, 21, 1, 196, 34, 24, 32, 195, 35, 33, 33, 21, 
        1, 195, 0, 34, 35, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_YUY2_AYUV);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_YUY2_AYUV");
      orc_program_set_backup_function (p, _backup_video_orc_convert_YUY2_AYUV);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_UYVY_AYUV */
#ifdef DISABLE_ORC
void
video_orc_convert_UYVY_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int n, int m){
  int i;
  int j;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);

      /* 2: loadpb */
        var37.x2[0] = p1;
      var37.x2[1] = p1;

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var36 = ptr4[i];
      /* 1: splitwb */
      {
       orc_union16 _src;
       _src.i = var36.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
      {
       orc_union16 _src;
       _src.i = var36.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
      /* 3: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var39.x2[0];
       var41.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var39.x2[1];
       var41.x2[1] = _dest.i;
    }
      /* 4: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var40.i;
       var42.i = _dest.i;
    }
      /* 5: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[0];
       _dest.x2[1] = var42.x2[0];
       var38.x2[0] = _dest.i;
    }
      {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[1];
       _dest.x2[1] = var42.x2[1];
       var38.x2[1] = _dest.i;
    }
      /* 6: storeq */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_video_orc_convert_UYVY_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var36;
  orc_union16 var37;
  orc_union64 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union32 var41;
  orc_union32 var42;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

      /* 2: loadpb */
        var37.x2[0] = ex->params[24];
      var37.x2[1] = ex->params[24];

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var36 = ptr4[i];
      /* 1: splitwb */
      {
       orc_union16 _src;
       _src.i = var36.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
      {
       orc_union16 _src;
       _src.i = var36.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
      /* 3: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var39.x2[0];
       var41.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var39.x2[1];
       var41.x2[1] = _dest.i;
    }
      /* 4: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var40.i;
       var42.i = _dest.i;
    }
      /* 5: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[0];
       _dest.x2[1] = var42.x2[0];
       var38.x2[0] = _dest.i;
    }
      {
       orc_union32 _dest;
       _dest.x2[0] = var41.x2[1];
       _dest.x2[1] = var42.x2[1];
       var38.x2[1] = _dest.i;
    }
      /* 6: storeq */
      ptr0[i] = var38;
    }
  }

}

void
video_orc_convert_UYVY_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 85, 89, 86, 89, 95, 65, 89, 85, 86, 11, 
        8, 8, 12, 4, 4, 16, 1, 20, 2, 20, 2, 20, 4, 20, 4, 21, 
        1, 199, 32, 33, 4, 21, 1, 196, 34, 24, 32, 195, 35, 33, 33, 21, 
        1, 195, 0, 34, 35, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_UYVY_AYUV);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_UYVY_AYUV");
      orc_program_set_backup_function (p, _backup_video_orc_convert_UYVY_AYUV);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_YUY2_Y42B */
#ifdef DISABLE_ORC
void
video_orc_convert_YUY2_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET(d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET(d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var33 = ptr4[i];
      /* 1: splitwb */
      {
       orc_union16 _src;
       _src.i = var33.x2[0];
       var37.x2[0] = _src.x2[1];
       var34.x2[0] = _src.x2[0];
    }
      {
       orc_union16 _src;
       _src.i = var33.x2[1];
       var37.x2[1] = _src.x2[1];
       var34.x2[1] = _src.x2[0];
    }
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: splitwb */
      {
       orc_union16 _src;
       _src.i = var37.i;
       var35 = _src.x2[1];
       var36 = _src.x2[0];
    }
      /* 4: storeb */
      ptr2[i] = var35;
      /* 5: storeb */
      ptr1[i] = var36;
    }
  }

}

#else
static void
_backup_video_orc_convert_YUY2_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET(ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET(ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var33 = ptr4[i];
      /* 1: splitwb */
      {
       orc_union16 _src;
       _src.i = var33.x2[0];
       var37.x2[0] = _src.x2[1];
       var34.x2[0] = _src.x2[0];
    }
      {
       orc_union16 _src;
       _src.i = var33.x2[1];
       var37.x2[1] = _src.x2[1];
       var34.x2[1] = _src.x2[0];
    }
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: splitwb */
      {
       orc_union16 _src;
       _src.i = var37.i;
       var35 = _src.x2[1];
       var36 = _src.x2[0];
    }
      /* 4: storeb */
      ptr2[i] = var35;
      /* 5: storeb */
      ptr1[i] = var36;
    }
  }

}

void
video_orc_convert_YUY2_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 89, 85, 89, 50, 95, 89, 52, 50, 66, 11, 
        2, 2, 11, 1, 1, 11, 1, 1, 12, 4, 4, 20, 2, 21, 1, 199, 
        32, 0, 4, 199, 2, 1, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_YUY2_Y42B);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_YUY2_Y42B");
      orc_program_set_backup_function (p, _backup_video_orc_convert_YUY2_Y42B);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_UYVY_Y42B */
#ifdef DISABLE_ORC
void
video_orc_convert_UYVY_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET(d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET(d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var33 = ptr4[i];
      /* 1: splitwb */
      {
       orc_union16 _src;
       _src.i = var33.x2[0];
       var34.x2[0] = _src.x2[1];
       var37.x2[0] = _src.x2[0];
    }
      {
       orc_union16 _src;
       _src.i = var33.x2[1];
       var34.x2[1] = _src.x2[1];
       var37.x2[1] = _src.x2[0];
    }
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: splitwb */
      {
       orc_union16 _src;
       _src.i = var37.i;
       var35 = _src.x2[1];
       var36 = _src.x2[0];
    }
      /* 4: storeb */
      ptr2[i] = var35;
      /* 5: storeb */
      ptr1[i] = var36;
    }
  }

}

#else
static void
_backup_video_orc_convert_UYVY_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
  orc_union16 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET(ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET(ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var33 = ptr4[i];
      /* 1: splitwb */
      {
       orc_union16 _src;
       _src.i = var33.x2[0];
       var34.x2[0] = _src.x2[1];
       var37.x2[0] = _src.x2[0];
    }
      {
       orc_union16 _src;
       _src.i = var33.x2[1];
       var34.x2[1] = _src.x2[1];
       var37.x2[1] = _src.x2[0];
    }
      /* 2: storew */
      ptr0[i] = var34;
      /* 3: splitwb */
      {
       orc_union16 _src;
       _src.i = var37.i;
       var35 = _src.x2[1];
       var36 = _src.x2[0];
    }
      /* 4: storeb */
      ptr2[i] = var35;
      /* 5: storeb */
      ptr1[i] = var36;
    }
  }

}

void
video_orc_convert_UYVY_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 85, 89, 86, 89, 95, 89, 52, 50, 66, 11, 
        2, 2, 11, 1, 1, 11, 1, 1, 12, 4, 4, 20, 2, 21, 1, 199, 
        0, 32, 4, 199, 2, 1, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_UYVY_Y42B);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_UYVY_Y42B");
      orc_program_set_backup_function (p, _backup_video_orc_convert_UYVY_Y42B);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_YUY2_Y444 */
#ifdef DISABLE_ORC
void
video_orc_convert_YUY2_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 * ORC_RESTRICT ptr2;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET(d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET(d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var35 = ptr4[i];
      /* 1: splitwb */
      {
       orc_union16 _src;
       _src.i = var35.x2[0];
       var39.x2[0] = _src.x2[1];
       var36.x2[0] = _src.x2[0];
    }
      {
       orc_union16 _src;
       _src.i = var35.x2[1];
       var39.x2[1] = _src.x2[1];
       var36.x2[1] = _src.x2[0];
    }
      /* 2: storew */
      ptr0[i] = var36;
      /* 3: splitwb */
      {
       orc_union16 _src;
       _src.i = var39.i;
       var40 = _src.x2[1];
       var41 = _src.x2[0];
    }
      /* 4: splatbw */
      var37.i = ((var41&0xff) << 8) | (var41&0xff);
      /* 5: storew */
      ptr1[i] = var37;
      /* 6: splatbw */
      var38.i = ((var40&0xff) << 8) | (var40&0xff);
      /* 7: storew */
      ptr2[i] = var38;
    }
  }

}

#else
static void
_backup_video_orc_convert_YUY2_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 * ORC_RESTRICT ptr2;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET(ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET(ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var35 = ptr4[i];
      /* 1: splitwb */
      {
       orc_union16 _src;
       _src.i = var35.x2[0];
       var39.x2[0] = _src.x2[1];
       var36.x2[0] = _src.x2[0];
    }
      {
       orc_union16 _src;
       _src.i = var35.x2[1];
       var39.x2[1] = _src.x2[1];
       var36.x2[1] = _src.x2[0];
    }
      /* 2: storew */
      ptr0[i] = var36;
      /* 3: splitwb */
      {
       orc_union16 _src;
       _src.i = var39.i;
       var40 = _src.x2[1];
       var41 = _src.x2[0];
    }
      /* 4: splatbw */
      var37.i = ((var41&0xff) << 8) | (var41&0xff);
      /* 5: storew */
      ptr1[i] = var37;
      /* 6: splatbw */
      var38.i = ((var40&0xff) << 8) | (var40&0xff);
      /* 7: storew */
      ptr2[i] = var38;
    }
  }

}

void
video_orc_convert_YUY2_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 89, 85, 89, 50, 95, 89, 52, 52, 52, 11, 
        2, 2, 11, 2, 2, 11, 2, 2, 12, 4, 4, 20, 2, 20, 1, 20, 
        1, 21, 1, 199, 32, 0, 4, 199, 34, 33, 32, 151, 1, 33, 151, 2, 
        34, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_YUY2_Y444);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_YUY2_Y444");
      orc_program_set_backup_function (p, _backup_video_orc_convert_YUY2_Y444);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 2, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_D3, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_UYVY_Y444 */
#ifdef DISABLE_ORC
void
video_orc_convert_UYVY_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 * ORC_RESTRICT ptr2;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET(d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET(d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var35 = ptr4[i];
      /* 1: splitwb */
      {
       orc_union16 _src;
       _src.i = var35.x2[0];
       var36.x2[0] = _src.x2[1];
       var39.x2[0] = _src.x2[0];
    }
      {
       orc_union16 _src;
       _src.i = var35.x2[1];
       var36.x2[1] = _src.x2[1];
       var39.x2[1] = _src.x2[0];
    }
      /* 2: storew */
      ptr0[i] = var36;
      /* 3: splitwb */
      {
       orc_union16 _src;
       _src.i = var39.i;
       var40 = _src.x2[1];
       var41 = _src.x2[0];
    }
      /* 4: splatbw */
      var37.i = ((var41&0xff) << 8) | (var41&0xff);
      /* 5: storew */
      ptr1[i] = var37;
      /* 6: splatbw */
      var38.i = ((var40&0xff) << 8) | (var40&0xff);
      /* 7: storew */
      ptr2[i] = var38;
    }
  }

}

#else
static void
_backup_video_orc_convert_UYVY_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_union16 * ORC_RESTRICT ptr2;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_int8 var41;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET(ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET(ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var35 = ptr4[i];
      /* 1: splitwb */
      {
       orc_union16 _src;
       _src.i = var35.x2[0];
       var36.x2[0] = _src.x2[1];
       var39.x2[0] = _src.x2[0];
    }
      {
       orc_union16 _src;
       _src.i = var35.x2[1];
       var36.x2[1] = _src.x2[1];
       var39.x2[1] = _src.x2[0];
    }
      /* 2: storew */
      ptr0[i] = var36;
      /* 3: splitwb */
      {
       orc_union16 _src;
       _src.i = var39.i;
       var40 = _src.x2[1];
       var41 = _src.x2[0];
    }
      /* 4: splatbw */
      var37.i = ((var41&0xff) << 8) | (var41&0xff);
      /* 5: storew */
      ptr1[i] = var37;
      /* 6: splatbw */
      var38.i = ((var40&0xff) << 8) | (var40&0xff);
      /* 7: storew */
      ptr2[i] = var38;
    }
  }

}

void
video_orc_convert_UYVY_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 85, 89, 86, 89, 95, 89, 52, 52, 52, 11, 
        2, 2, 11, 2, 2, 11, 2, 2, 12, 4, 4, 20, 2, 20, 1, 20, 
        1, 21, 1, 199, 0, 32, 4, 199, 34, 33, 32, 151, 1, 33, 151, 2, 
        34, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_UYVY_Y444);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_UYVY_Y444");
      orc_program_set_backup_function (p, _backup_video_orc_convert_UYVY_Y444);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 2, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_D3, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_UYVY_I420 */
#ifdef DISABLE_ORC
void
video_orc_convert_UYVY_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  orc_int8 * ORC_RESTRICT ptr3;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var35;
  orc_union32 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *)d1;
  ptr1 = (orc_union16 *)d2;
  ptr2 = (orc_int8 *)d3;
  ptr3 = (orc_int8 *)d4;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: splitwb */
    {
       orc_union16 _src;
       _src.i = var35.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var35.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
    /* 2: storew */
    ptr0[i] = var39;
    /* 3: loadl */
    var36 = ptr5[i];
    /* 4: splitwb */
    {
       orc_union16 _src;
       _src.i = var36.x2[0];
       var41.x2[0] = _src.x2[1];
       var42.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var36.x2[1];
       var41.x2[1] = _src.x2[1];
       var42.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var41;
    /* 6: avgub */
    var43.x2[0] = ((orc_uint8)var40.x2[0] + (orc_uint8)var42.x2[0] + 1)>>1;
    var43.x2[1] = ((orc_uint8)var40.x2[1] + (orc_uint8)var42.x2[1] + 1)>>1;
    /* 7: splitwb */
    {
       orc_union16 _src;
       _src.i = var43.i;
       var37 = _src.x2[1];
       var38 = _src.x2[0];
    }
    /* 8: storeb */
    ptr3[i] = var37;
    /* 9: storeb */
    ptr2[i] = var38;
  }

}

#else
static void
_backup_video_orc_convert_UYVY_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  orc_int8 * ORC_RESTRICT ptr3;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var35;
  orc_union32 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr1 = (orc_union16 *)ex->arrays[1];
  ptr2 = (orc_int8 *)ex->arrays[2];
  ptr3 = (orc_int8 *)ex->arrays[3];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: splitwb */
    {
       orc_union16 _src;
       _src.i = var35.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var35.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
    /* 2: storew */
    ptr0[i] = var39;
    /* 3: loadl */
    var36 = ptr5[i];
    /* 4: splitwb */
    {
       orc_union16 _src;
       _src.i = var36.x2[0];
       var41.x2[0] = _src.x2[1];
       var42.x2[0] = _src.x2[0];
    }
    {
       orc_union16 _src;
       _src.i = var36.x2[1];
       var41.x2[1] = _src.x2[1];
       var42.x2[1] = _src.x2[0];
    }
    /* 5: storew */
    ptr1[i] = var41;
    /* 6: avgub */
    var43.x2[0] = ((orc_uint8)var40.x2[0] + (orc_uint8)var42.x2[0] + 1)>>1;
    var43.x2[1] = ((orc_uint8)var40.x2[1] + (orc_uint8)var42.x2[1] + 1)>>1;
    /* 7: splitwb */
    {
       orc_union16 _src;
       _src.i = var43.i;
       var37 = _src.x2[1];
       var38 = _src.x2[0];
    }
    /* 8: storeb */
    ptr3[i] = var37;
    /* 9: storeb */
    ptr2[i] = var38;
  }

}

void
video_orc_convert_UYVY_I420 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, guint8 * ORC_RESTRICT d3, guint8 * ORC_RESTRICT d4, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 110, 
        118, 101, 114, 116, 95, 85, 89, 86, 89, 95, 73, 52, 50, 48, 11, 2, 
        2, 11, 2, 2, 11, 1, 1, 11, 1, 1, 12, 4, 4, 12, 4, 4, 
        20, 2, 20, 2, 20, 2, 21, 1, 199, 34, 32, 4, 97, 0, 34, 21, 
        1, 199, 34, 33, 5, 97, 1, 34, 21, 1, 39, 32, 32, 33, 199, 3, 
        2, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_UYVY_I420);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_convert_UYVY_I420");
      orc_program_set_backup_function (p, _backup_video_orc_convert_UYVY_I420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_destination (p, 1, "d4");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "storew", 0, ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D4, ORC_VAR_D3, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->arrays[ORC_VAR_D4] = d4;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_AYUV_I420 */
#ifdef DISABLE_ORC
void
video_orc_convert_AYUV_I420 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, guint8 * ORC_RESTRICT d4, int d4_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  orc_int8 * ORC_RESTRICT ptr3;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var40;
  orc_union16 var41;
  orc_union64 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_int8 var53;
  orc_int8 var54;
  orc_int8 var55;
  orc_int8 var56;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET(d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET(d3, d3_stride * j);
    ptr3 = ORC_PTR_OFFSET(d4, d4_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var40 = ptr4[i];
      /* 1: splitlw */
      {
       orc_union32 _src;
       _src.i = var40.x2[0];
       var46.x2[0] = _src.x2[1];
       var47.x2[0] = _src.x2[0];
    }
      {
       orc_union32 _src;
       _src.i = var40.x2[1];
       var46.x2[1] = _src.x2[1];
       var47.x2[1] = _src.x2[0];
    }
      /* 2: select1wb */
      {
       orc_union16 _src;
       _src.i = var47.x2[0];
       var41.x2[0] = _src.x2[1];
    }
      {
       orc_union16 _src;
       _src.i = var47.x2[1];
       var41.x2[1] = _src.x2[1];
    }
      /* 3: storew */
      ptr0[i] = var41;
      /* 4: loadq */
      var42 = ptr5[i];
      /* 5: splitlw */
      {
       orc_union32 _src;
       _src.i = var42.x2[0];
       var48.x2[0] = _src.x2[1];
       var49.x2[0] = _src.x2[0];
    }
      {
       orc_union32 _src;
       _src.i = var42.x2[1];
       var48.x2[1] = _src.x2[1];
       var49.x2[1] = _src.x2[0];
    }
      /* 6: select1wb */
      {
       orc_union16 _src;
       _src.i = var49.x2[0];
       var43.x2[0] = _src.x2[1];
    }
      {
       orc_union16 _src;
       _src.i = var49.x2[1];
       var43.x2[1] = _src.x2[1];
    }
      /* 7: storew */
      ptr1[i] = var43;
      /* 8: avgub */
      var50.x4[0] = ((orc_uint8)var46.x4[0] + (orc_uint8)var48.x4[0] + 1)>>1;
      var50.x4[1] = ((orc_uint8)var46.x4[1] + (orc_uint8)var48.x4[1] + 1)>>1;
      var50.x4[2] = ((orc_uint8)var46.x4[2] + (orc_uint8)var48.x4[2] + 1)>>1;
      var50.x4[3] = ((orc_uint8)var46.x4[3] + (orc_uint8)var48.x4[3] + 1)>>1;
      /* 9: splitwb */
      {
       orc_union16 _src;
       _src.i = var50.x2[0];
       var51.x2[0] = _src.x2[1];
       var52.x2[0] = _src.x2[0];
    }
      {
       orc_union16 _src;
       _src.i = var50.x2[1];
       var51.x2[1] = _src.x2[1];
       var52.x2[1] = _src.x2[0];
    }
      /* 10: splitwb */
      {
       orc_union16 _src;
       _src.i = var52.i;
       var53 = _src.x2[1];
       var54 = _src.x2[0];
    }
      /* 11: avgub */
      var44 = ((orc_uint8)var53 + (orc_uint8)var54 + 1)>>1;
      /* 12: storeb */
      ptr2[i] = var44;
      /* 13: splitwb */
      {
       orc_union16 _src;
       _src.i = var51.i;
       var55 = _src.x2[1];
       var56 = _src.x2[0];
    }
      /* 14: avgub */
      var45 = ((orc_uint8)var55 + (orc_uint8)var56 + 1)>>1;
      /* 15: storeb */
      ptr3[i] = var45;
    }
  }

}

#else
static void
_backup_video_orc_convert_AYUV_I420 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  orc_union16 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  orc_int8 * ORC_RESTRICT ptr3;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var40;
  orc_union16 var41;
  orc_union64 var42;
  orc_union16 var43;
  orc_int8 var44;
  orc_int8 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_int8 var53;
  orc_int8 var54;
  orc_int8 var55;
  orc_int8 var56;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET(ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET(ex->arrays[2], ex->params[2] * j);
    ptr3 = ORC_PTR_OFFSET(ex->arrays[3], ex->params[3] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var40 = ptr4[i];
      /* 1: splitlw */
      {
       orc_union32 _src;
       _src.i = var40.x2[0];
       var46.x2[0] = _src.x2[1];
       var47.x2[0] = _src.x2[0];
    }
      {
       orc_union32 _src;
       _src.i = var40.x2[1];
       var46.x2[1] = _src.x2[1];
       var47.x2[1] = _src.x2[0];
    }
      /* 2: select1wb */
      {
       orc_union16 _src;
       _src.i = var47.x2[0];
       var41.x2[0] = _src.x2[1];
    }
      {
       orc_union16 _src;
       _src.i = var47.x2[1];
       var41.x2[1] = _src.x2[1];
    }
      /* 3: storew */
      ptr0[i] = var41;
      /* 4: loadq */
      var42 = ptr5[i];
      /* 5: splitlw */
      {
       orc_union32 _src;
       _src.i = var42.x2[0];
       var48.x2[0] = _src.x2[1];
       var49.x2[0] = _src.x2[0];
    }
      {
       orc_union32 _src;
       _src.i = var42.x2[1];
       var48.x2[1] = _src.x2[1];
       var49.x2[1] = _src.x2[0];
    }
      /* 6: select1wb */
      {
       orc_union16 _src;
       _src.i = var49.x2[0];
       var43.x2[0] = _src.x2[1];
    }
      {
       orc_union16 _src;
       _src.i = var49.x2[1];
       var43.x2[1] = _src.x2[1];
    }
      /* 7: storew */
      ptr1[i] = var43;
      /* 8: avgub */
      var50.x4[0] = ((orc_uint8)var46.x4[0] + (orc_uint8)var48.x4[0] + 1)>>1;
      var50.x4[1] = ((orc_uint8)var46.x4[1] + (orc_uint8)var48.x4[1] + 1)>>1;
      var50.x4[2] = ((orc_uint8)var46.x4[2] + (orc_uint8)var48.x4[2] + 1)>>1;
      var50.x4[3] = ((orc_uint8)var46.x4[3] + (orc_uint8)var48.x4[3] + 1)>>1;
      /* 9: splitwb */
      {
       orc_union16 _src;
       _src.i = var50.x2[0];
       var51.x2[0] = _src.x2[1];
       var52.x2[0] = _src.x2[0];
    }
      {
       orc_union16 _src;
       _src.i = var50.x2[1];
       var51.x2[1] = _src.x2[1];
       var52.x2[1] = _src.x2[0];
    }
      /* 10: splitwb */
      {
       orc_union16 _src;
       _src.i = var52.i;
       var53 = _src.x2[1];
       var54 = _src.x2[0];
    }
      /* 11: avgub */
      var44 = ((orc_uint8)var53 + (orc_uint8)var54 + 1)>>1;
      /* 12: storeb */
      ptr2[i] = var44;
      /* 13: splitwb */
      {
       orc_union16 _src;
       _src.i = var51.i;
       var55 = _src.x2[1];
       var56 = _src.x2[0];
    }
      /* 14: avgub */
      var45 = ((orc_uint8)var55 + (orc_uint8)var56 + 1)>>1;
      /* 15: storeb */
      ptr3[i] = var45;
    }
  }

}

void
video_orc_convert_AYUV_I420 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, guint8 * ORC_RESTRICT d4, int d4_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 65, 89, 85, 86, 95, 73, 52, 50, 48, 11, 
        2, 2, 11, 2, 2, 11, 1, 1, 11, 1, 1, 12, 8, 8, 12, 8, 
        8, 20, 4, 20, 4, 20, 4, 20, 4, 20, 2, 20, 2, 20, 1, 20, 
        1, 21, 1, 198, 33, 32, 4, 21, 1, 189, 0, 32, 21, 1, 198, 34, 
        32, 5, 21, 1, 189, 1, 32, 21, 2, 39, 35, 33, 34, 21, 1, 199, 
        37, 36, 35, 199, 38, 39, 36, 39, 2, 38, 39, 199, 38, 39, 37, 39, 
        3, 38, 39, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_I420);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_AYUV_I420");
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_I420);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 2, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_destination (p, 1, "d4");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_source (p, 8, "s2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 1, "t7");
      orc_program_add_temporary (p, 1, "t8");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 2, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 1, ORC_VAR_T6, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T7, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D3, ORC_VAR_T7, ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T7, ORC_VAR_T8, ORC_VAR_T6, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 0, ORC_VAR_D4, ORC_VAR_T7, ORC_VAR_T8, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_D4] = d4;
  ex->params[ORC_VAR_D4] = d4_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_AYUV_YUY2 */
#ifdef DISABLE_ORC
void
video_orc_convert_AYUV_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var37 = ptr4[i];
      /* 1: splitlw */
      {
       orc_union32 _src;
       _src.i = var37.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
      {
       orc_union32 _src;
       _src.i = var37.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
      /* 2: splitlw */
      {
       orc_union32 _src;
       _src.i = var39.i;
       var41.i = _src.x2[1];
       var42.i = _src.x2[0];
    }
      /* 3: avgub */
      var43.x2[0] = ((orc_uint8)var41.x2[0] + (orc_uint8)var42.x2[0] + 1)>>1;
      var43.x2[1] = ((orc_uint8)var41.x2[1] + (orc_uint8)var42.x2[1] + 1)>>1;
      /* 4: select1wb */
      {
       orc_union16 _src;
       _src.i = var40.x2[0];
       var44.x2[0] = _src.x2[1];
    }
      {
       orc_union16 _src;
       _src.i = var40.x2[1];
       var44.x2[1] = _src.x2[1];
    }
      /* 5: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var44.x2[0];
       _dest.x2[1] = var43.x2[0];
       var38.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var44.x2[1];
       _dest.x2[1] = var43.x2[1];
       var38.x2[1] = _dest.i;
    }
      /* 6: storel */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_video_orc_convert_AYUV_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var37 = ptr4[i];
      /* 1: splitlw */
      {
       orc_union32 _src;
       _src.i = var37.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
      {
       orc_union32 _src;
       _src.i = var37.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
      /* 2: splitlw */
      {
       orc_union32 _src;
       _src.i = var39.i;
       var41.i = _src.x2[1];
       var42.i = _src.x2[0];
    }
      /* 3: avgub */
      var43.x2[0] = ((orc_uint8)var41.x2[0] + (orc_uint8)var42.x2[0] + 1)>>1;
      var43.x2[1] = ((orc_uint8)var41.x2[1] + (orc_uint8)var42.x2[1] + 1)>>1;
      /* 4: select1wb */
      {
       orc_union16 _src;
       _src.i = var40.x2[0];
       var44.x2[0] = _src.x2[1];
    }
      {
       orc_union16 _src;
       _src.i = var40.x2[1];
       var44.x2[1] = _src.x2[1];
    }
      /* 5: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var44.x2[0];
       _dest.x2[1] = var43.x2[0];
       var38.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var44.x2[1];
       _dest.x2[1] = var43.x2[1];
       var38.x2[1] = _dest.i;
    }
      /* 6: storel */
      ptr0[i] = var38;
    }
  }

}

void
video_orc_convert_AYUV_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 65, 89, 85, 86, 95, 89, 85, 89, 50, 11, 
        4, 4, 12, 8, 8, 20, 2, 20, 2, 20, 2, 20, 4, 20, 4, 21, 
        1, 198, 36, 35, 4, 198, 33, 34, 36, 21, 1, 39, 33, 33, 34, 21, 
        1, 189, 32, 35, 21, 1, 196, 0, 32, 33, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_YUY2);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_AYUV_YUY2");
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_AYUV_UYVY */
#ifdef DISABLE_ORC
void
video_orc_convert_AYUV_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var37 = ptr4[i];
      /* 1: splitlw */
      {
       orc_union32 _src;
       _src.i = var37.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
      {
       orc_union32 _src;
       _src.i = var37.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
      /* 2: splitlw */
      {
       orc_union32 _src;
       _src.i = var39.i;
       var41.i = _src.x2[1];
       var42.i = _src.x2[0];
    }
      /* 3: avgub */
      var43.x2[0] = ((orc_uint8)var41.x2[0] + (orc_uint8)var42.x2[0] + 1)>>1;
      var43.x2[1] = ((orc_uint8)var41.x2[1] + (orc_uint8)var42.x2[1] + 1)>>1;
      /* 4: select1wb */
      {
       orc_union16 _src;
       _src.i = var40.x2[0];
       var44.x2[0] = _src.x2[1];
    }
      {
       orc_union16 _src;
       _src.i = var40.x2[1];
       var44.x2[1] = _src.x2[1];
    }
      /* 5: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var43.x2[0];
       _dest.x2[1] = var44.x2[0];
       var38.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var43.x2[1];
       _dest.x2[1] = var44.x2[1];
       var38.x2[1] = _dest.i;
    }
      /* 6: storel */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_video_orc_convert_AYUV_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var37 = ptr4[i];
      /* 1: splitlw */
      {
       orc_union32 _src;
       _src.i = var37.x2[0];
       var39.x2[0] = _src.x2[1];
       var40.x2[0] = _src.x2[0];
    }
      {
       orc_union32 _src;
       _src.i = var37.x2[1];
       var39.x2[1] = _src.x2[1];
       var40.x2[1] = _src.x2[0];
    }
      /* 2: splitlw */
      {
       orc_union32 _src;
       _src.i = var39.i;
       var41.i = _src.x2[1];
       var42.i = _src.x2[0];
    }
      /* 3: avgub */
      var43.x2[0] = ((orc_uint8)var41.x2[0] + (orc_uint8)var42.x2[0] + 1)>>1;
      var43.x2[1] = ((orc_uint8)var41.x2[1] + (orc_uint8)var42.x2[1] + 1)>>1;
      /* 4: select1wb */
      {
       orc_union16 _src;
       _src.i = var40.x2[0];
       var44.x2[0] = _src.x2[1];
    }
      {
       orc_union16 _src;
       _src.i = var40.x2[1];
       var44.x2[1] = _src.x2[1];
    }
      /* 5: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var43.x2[0];
       _dest.x2[1] = var44.x2[0];
       var38.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var43.x2[1];
       _dest.x2[1] = var44.x2[1];
       var38.x2[1] = _dest.i;
    }
      /* 6: storel */
      ptr0[i] = var38;
    }
  }

}

void
video_orc_convert_AYUV_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 65, 89, 85, 86, 95, 85, 89, 86, 89, 11, 
        4, 4, 12, 8, 8, 20, 2, 20, 2, 20, 2, 20, 4, 20, 4, 21, 
        1, 198, 36, 35, 4, 198, 33, 34, 36, 21, 1, 39, 33, 33, 34, 21, 
        1, 189, 32, 35, 21, 1, 196, 0, 33, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_UYVY);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_AYUV_UYVY");
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_T1, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_AYUV_Y42B */
#ifdef DISABLE_ORC
void
video_orc_convert_AYUV_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET(d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET(d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var36 = ptr4[i];
      /* 1: splitlw */
      {
       orc_union32 _src;
       _src.i = var36.x2[0];
       var40.x2[0] = _src.x2[1];
       var41.x2[0] = _src.x2[0];
    }
      {
       orc_union32 _src;
       _src.i = var36.x2[1];
       var40.x2[1] = _src.x2[1];
       var41.x2[1] = _src.x2[0];
    }
      /* 2: splitlw */
      {
       orc_union32 _src;
       _src.i = var40.i;
       var42.i = _src.x2[1];
       var43.i = _src.x2[0];
    }
      /* 3: avgub */
      var44.x2[0] = ((orc_uint8)var42.x2[0] + (orc_uint8)var43.x2[0] + 1)>>1;
      var44.x2[1] = ((orc_uint8)var42.x2[1] + (orc_uint8)var43.x2[1] + 1)>>1;
      /* 4: splitwb */
      {
       orc_union16 _src;
       _src.i = var44.i;
       var37 = _src.x2[1];
       var38 = _src.x2[0];
    }
      /* 5: storeb */
      ptr2[i] = var37;
      /* 6: storeb */
      ptr1[i] = var38;
      /* 7: select1wb */
      {
       orc_union16 _src;
       _src.i = var41.x2[0];
       var39.x2[0] = _src.x2[1];
    }
      {
       orc_union16 _src;
       _src.i = var41.x2[1];
       var39.x2[1] = _src.x2[1];
    }
      /* 8: storew */
      ptr0[i] = var39;
    }
  }

}

#else
static void
_backup_video_orc_convert_AYUV_Y42B (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var36;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET(ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET(ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadq */
      var36 = ptr4[i];
      /* 1: splitlw */
      {
       orc_union32 _src;
       _src.i = var36.x2[0];
       var40.x2[0] = _src.x2[1];
       var41.x2[0] = _src.x2[0];
    }
      {
       orc_union32 _src;
       _src.i = var36.x2[1];
       var40.x2[1] = _src.x2[1];
       var41.x2[1] = _src.x2[0];
    }
      /* 2: splitlw */
      {
       orc_union32 _src;
       _src.i = var40.i;
       var42.i = _src.x2[1];
       var43.i = _src.x2[0];
    }
      /* 3: avgub */
      var44.x2[0] = ((orc_uint8)var42.x2[0] + (orc_uint8)var43.x2[0] + 1)>>1;
      var44.x2[1] = ((orc_uint8)var42.x2[1] + (orc_uint8)var43.x2[1] + 1)>>1;
      /* 4: splitwb */
      {
       orc_union16 _src;
       _src.i = var44.i;
       var37 = _src.x2[1];
       var38 = _src.x2[0];
    }
      /* 5: storeb */
      ptr2[i] = var37;
      /* 6: storeb */
      ptr1[i] = var38;
      /* 7: select1wb */
      {
       orc_union16 _src;
       _src.i = var41.x2[0];
       var39.x2[0] = _src.x2[1];
    }
      {
       orc_union16 _src;
       _src.i = var41.x2[1];
       var39.x2[1] = _src.x2[1];
    }
      /* 8: storew */
      ptr0[i] = var39;
    }
  }

}

void
video_orc_convert_AYUV_Y42B (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 65, 89, 85, 86, 95, 89, 52, 50, 66, 11, 
        2, 2, 11, 1, 1, 11, 1, 1, 12, 8, 8, 20, 4, 20, 4, 20, 
        2, 20, 2, 21, 1, 198, 33, 32, 4, 198, 34, 35, 33, 21, 1, 39, 
        34, 34, 35, 199, 2, 1, 34, 21, 1, 189, 0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_Y42B);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_AYUV_Y42B");
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_Y42B);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");

      orc_program_append_2 (p, "splitlw", 1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_AYUV_Y444 */
#ifdef DISABLE_ORC
void
video_orc_convert_AYUV_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr1 = ORC_PTR_OFFSET(d2, d2_stride * j);
    ptr2 = ORC_PTR_OFFSET(d3, d3_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var34 = ptr4[i];
      /* 1: splitlw */
      {
       orc_union32 _src;
       _src.i = var34.i;
       var38.i = _src.x2[1];
       var39.i = _src.x2[0];
    }
      /* 2: splitwb */
      {
       orc_union16 _src;
       _src.i = var38.i;
       var35 = _src.x2[1];
       var36 = _src.x2[0];
    }
      /* 3: storeb */
      ptr2[i] = var35;
      /* 4: storeb */
      ptr1[i] = var36;
      /* 5: select1wb */
      {
       orc_union16 _src;
       _src.i = var39.i;
       var37 = _src.x2[1];
    }
      /* 6: storeb */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_video_orc_convert_AYUV_Y444 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  orc_int8 * ORC_RESTRICT ptr1;
  orc_int8 * ORC_RESTRICT ptr2;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET(ex->arrays[1], ex->params[1] * j);
    ptr2 = ORC_PTR_OFFSET(ex->arrays[2], ex->params[2] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var34 = ptr4[i];
      /* 1: splitlw */
      {
       orc_union32 _src;
       _src.i = var34.i;
       var38.i = _src.x2[1];
       var39.i = _src.x2[0];
    }
      /* 2: splitwb */
      {
       orc_union16 _src;
       _src.i = var38.i;
       var35 = _src.x2[1];
       var36 = _src.x2[0];
    }
      /* 3: storeb */
      ptr2[i] = var35;
      /* 4: storeb */
      ptr1[i] = var36;
      /* 5: select1wb */
      {
       orc_union16 _src;
       _src.i = var39.i;
       var37 = _src.x2[1];
    }
      /* 6: storeb */
      ptr0[i] = var37;
    }
  }

}

void
video_orc_convert_AYUV_Y444 (guint8 * ORC_RESTRICT d1, int d1_stride, guint8 * ORC_RESTRICT d2, int d2_stride, guint8 * ORC_RESTRICT d3, int d3_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 65, 89, 85, 86, 95, 89, 52, 52, 52, 11, 
        1, 1, 11, 1, 1, 11, 1, 1, 12, 4, 4, 20, 2, 20, 2, 198, 
        33, 32, 4, 199, 2, 1, 33, 189, 0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_Y444);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_AYUV_Y444");
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_Y444);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_destination (p, 1, "d2");
      orc_program_add_destination (p, 1, "d3");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_D3, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->params[ORC_VAR_D2] = d2_stride;
  ex->arrays[ORC_VAR_D3] = d3;
  ex->params[ORC_VAR_D3] = d3_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_Y42B_YUY2 */
#ifdef DISABLE_ORC
void
video_orc_convert_Y42B_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr5[i];
      /* 1: loadb */
      var34 = ptr6[i];
      /* 2: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var33;
       _dest.x2[1] = var34;
       var37.i = _dest.i;
    }
      /* 3: loadw */
      var35 = ptr4[i];
      /* 4: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var35.x2[0];
       _dest.x2[1] = var37.x2[0];
       var36.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var35.x2[1];
       _dest.x2[1] = var37.x2[1];
       var36.x2[1] = _dest.i;
    }
      /* 5: storel */
      ptr0[i] = var36;
    }
  }

}

#else
static void
_backup_video_orc_convert_Y42B_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr5[i];
      /* 1: loadb */
      var34 = ptr6[i];
      /* 2: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var33;
       _dest.x2[1] = var34;
       var37.i = _dest.i;
    }
      /* 3: loadw */
      var35 = ptr4[i];
      /* 4: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var35.x2[0];
       _dest.x2[1] = var37.x2[0];
       var36.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var35.x2[1];
       _dest.x2[1] = var37.x2[1];
       var36.x2[1] = _dest.i;
    }
      /* 5: storel */
      ptr0[i] = var36;
    }
  }

}

void
video_orc_convert_Y42B_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 89, 52, 50, 66, 95, 89, 85, 89, 50, 11, 
        4, 4, 12, 2, 2, 12, 1, 1, 12, 1, 1, 20, 2, 196, 32, 5, 
        6, 21, 1, 196, 0, 4, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_Y42B_YUY2);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_Y42B_YUY2");
      orc_program_set_backup_function (p, _backup_video_orc_convert_Y42B_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_Y42B_UYVY */
#ifdef DISABLE_ORC
void
video_orc_convert_Y42B_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr5[i];
      /* 1: loadb */
      var34 = ptr6[i];
      /* 2: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var33;
       _dest.x2[1] = var34;
       var37.i = _dest.i;
    }
      /* 3: loadw */
      var35 = ptr4[i];
      /* 4: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var35.x2[0];
       var36.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var35.x2[1];
       var36.x2[1] = _dest.i;
    }
      /* 5: storel */
      ptr0[i] = var36;
    }
  }

}

#else
static void
_backup_video_orc_convert_Y42B_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var33;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union16 var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr5[i];
      /* 1: loadb */
      var34 = ptr6[i];
      /* 2: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var33;
       _dest.x2[1] = var34;
       var37.i = _dest.i;
    }
      /* 3: loadw */
      var35 = ptr4[i];
      /* 4: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[0];
       _dest.x2[1] = var35.x2[0];
       var36.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var37.x2[1];
       _dest.x2[1] = var35.x2[1];
       var36.x2[1] = _dest.i;
    }
      /* 5: storel */
      ptr0[i] = var36;
    }
  }

}

void
video_orc_convert_Y42B_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 89, 52, 50, 66, 95, 85, 89, 86, 89, 11, 
        4, 4, 12, 2, 2, 12, 1, 1, 12, 1, 1, 20, 2, 196, 32, 5, 
        6, 21, 1, 196, 0, 32, 4, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_Y42B_UYVY);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_Y42B_UYVY");
      orc_program_set_backup_function (p, _backup_video_orc_convert_Y42B_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_Y42B_AYUV */
#ifdef DISABLE_ORC
void
video_orc_convert_Y42B_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int p1, int n, int m){
  int i;
  int j;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union64 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);

      /* 3: loadpb */
        var38.x2[0] = p1;
      var38.x2[1] = p1;

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var36 = ptr5[i];
      /* 1: loadb */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var37;
       var41.i = _dest.i;
    }
      /* 4: loadw */
      var39 = ptr4[i];
      /* 5: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var38.x2[0];
       _dest.x2[1] = var39.x2[0];
       var42.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var38.x2[1];
       _dest.x2[1] = var39.x2[1];
       var42.x2[1] = _dest.i;
    }
      /* 6: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var41.i;
       _dest.x2[1] = var41.i;
       var43.i = _dest.i;
    }
      /* 7: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var42.x2[0];
       _dest.x2[1] = var43.x2[0];
       var40.x2[0] = _dest.i;
    }
      {
       orc_union32 _dest;
       _dest.x2[0] = var42.x2[1];
       _dest.x2[1] = var43.x2[1];
       var40.x2[1] = _dest.i;
    }
      /* 8: storeq */
      ptr0[i] = var40;
    }
  }

}

#else
static void
_backup_video_orc_convert_Y42B_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var36;
  orc_int8 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union64 var40;
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);

      /* 3: loadpb */
        var38.x2[0] = ex->params[24];
      var38.x2[1] = ex->params[24];

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var36 = ptr5[i];
      /* 1: loadb */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var37;
       var41.i = _dest.i;
    }
      /* 4: loadw */
      var39 = ptr4[i];
      /* 5: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var38.x2[0];
       _dest.x2[1] = var39.x2[0];
       var42.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var38.x2[1];
       _dest.x2[1] = var39.x2[1];
       var42.x2[1] = _dest.i;
    }
      /* 6: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var41.i;
       _dest.x2[1] = var41.i;
       var43.i = _dest.i;
    }
      /* 7: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var42.x2[0];
       _dest.x2[1] = var43.x2[0];
       var40.x2[0] = _dest.i;
    }
      {
       orc_union32 _dest;
       _dest.x2[0] = var42.x2[1];
       _dest.x2[1] = var43.x2[1];
       var40.x2[1] = _dest.i;
    }
      /* 8: storeq */
      ptr0[i] = var40;
    }
  }

}

void
video_orc_convert_Y42B_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int p1, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 89, 52, 50, 66, 95, 65, 89, 85, 86, 11, 
        8, 8, 12, 2, 2, 12, 1, 1, 12, 1, 1, 16, 1, 20, 2, 20, 
        2, 20, 4, 20, 4, 196, 32, 5, 6, 21, 1, 196, 35, 24, 4, 195, 
        34, 32, 32, 21, 1, 195, 0, 35, 34, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_Y42B_AYUV);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_Y42B_AYUV");
      orc_program_set_backup_function (p, _backup_video_orc_convert_Y42B_AYUV);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T4, ORC_VAR_P1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 1, ORC_VAR_D1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_Y444_YUY2 */
#ifdef DISABLE_ORC
void
video_orc_convert_Y444_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var36 = ptr5[i];
      /* 1: loadw */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[0];
       _dest.x2[1] = var37.x2[0];
       var40.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[1];
       _dest.x2[1] = var37.x2[1];
       var40.x2[1] = _dest.i;
    }
      /* 3: splitlw */
      {
       orc_union32 _src;
       _src.i = var40.i;
       var41.i = _src.x2[1];
       var42.i = _src.x2[0];
    }
      /* 4: avgub */
      var43.x2[0] = ((orc_uint8)var41.x2[0] + (orc_uint8)var42.x2[0] + 1)>>1;
      var43.x2[1] = ((orc_uint8)var41.x2[1] + (orc_uint8)var42.x2[1] + 1)>>1;
      /* 5: loadw */
      var38 = ptr4[i];
      /* 6: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var38.x2[0];
       _dest.x2[1] = var43.x2[0];
       var39.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var38.x2[1];
       _dest.x2[1] = var43.x2[1];
       var39.x2[1] = _dest.i;
    }
      /* 7: storel */
      ptr0[i] = var39;
    }
  }

}

#else
static void
_backup_video_orc_convert_Y444_YUY2 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var36 = ptr5[i];
      /* 1: loadw */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[0];
       _dest.x2[1] = var37.x2[0];
       var40.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[1];
       _dest.x2[1] = var37.x2[1];
       var40.x2[1] = _dest.i;
    }
      /* 3: splitlw */
      {
       orc_union32 _src;
       _src.i = var40.i;
       var41.i = _src.x2[1];
       var42.i = _src.x2[0];
    }
      /* 4: avgub */
      var43.x2[0] = ((orc_uint8)var41.x2[0] + (orc_uint8)var42.x2[0] + 1)>>1;
      var43.x2[1] = ((orc_uint8)var41.x2[1] + (orc_uint8)var42.x2[1] + 1)>>1;
      /* 5: loadw */
      var38 = ptr4[i];
      /* 6: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var38.x2[0];
       _dest.x2[1] = var43.x2[0];
       var39.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var38.x2[1];
       _dest.x2[1] = var43.x2[1];
       var39.x2[1] = _dest.i;
    }
      /* 7: storel */
      ptr0[i] = var39;
    }
  }

}

void
video_orc_convert_Y444_YUY2 (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 89, 52, 52, 52, 95, 89, 85, 89, 50, 11, 
        4, 4, 12, 2, 2, 12, 2, 2, 12, 2, 2, 20, 2, 20, 4, 20, 
        2, 20, 2, 21, 1, 196, 33, 5, 6, 198, 34, 35, 33, 21, 1, 39, 
        32, 34, 35, 21, 1, 196, 0, 4, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_Y444_YUY2);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_Y444_YUY2");
      orc_program_set_backup_function (p, _backup_video_orc_convert_Y444_YUY2);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");

      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_Y444_UYVY */
#ifdef DISABLE_ORC
void
video_orc_convert_Y444_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var36 = ptr5[i];
      /* 1: loadw */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[0];
       _dest.x2[1] = var37.x2[0];
       var40.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[1];
       _dest.x2[1] = var37.x2[1];
       var40.x2[1] = _dest.i;
    }
      /* 3: splitlw */
      {
       orc_union32 _src;
       _src.i = var40.i;
       var41.i = _src.x2[1];
       var42.i = _src.x2[0];
    }
      /* 4: avgub */
      var43.x2[0] = ((orc_uint8)var41.x2[0] + (orc_uint8)var42.x2[0] + 1)>>1;
      var43.x2[1] = ((orc_uint8)var41.x2[1] + (orc_uint8)var42.x2[1] + 1)>>1;
      /* 5: loadw */
      var38 = ptr4[i];
      /* 6: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var43.x2[0];
       _dest.x2[1] = var38.x2[0];
       var39.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var43.x2[1];
       _dest.x2[1] = var38.x2[1];
       var39.x2[1] = _dest.i;
    }
      /* 7: storel */
      ptr0[i] = var39;
    }
  }

}

#else
static void
_backup_video_orc_convert_Y444_UYVY (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var36 = ptr5[i];
      /* 1: loadw */
      var37 = ptr6[i];
      /* 2: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[0];
       _dest.x2[1] = var37.x2[0];
       var40.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var36.x2[1];
       _dest.x2[1] = var37.x2[1];
       var40.x2[1] = _dest.i;
    }
      /* 3: splitlw */
      {
       orc_union32 _src;
       _src.i = var40.i;
       var41.i = _src.x2[1];
       var42.i = _src.x2[0];
    }
      /* 4: avgub */
      var43.x2[0] = ((orc_uint8)var41.x2[0] + (orc_uint8)var42.x2[0] + 1)>>1;
      var43.x2[1] = ((orc_uint8)var41.x2[1] + (orc_uint8)var42.x2[1] + 1)>>1;
      /* 5: loadw */
      var38 = ptr4[i];
      /* 6: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var43.x2[0];
       _dest.x2[1] = var38.x2[0];
       var39.x2[0] = _dest.i;
    }
      {
       orc_union16 _dest;
       _dest.x2[0] = var43.x2[1];
       _dest.x2[1] = var38.x2[1];
       var39.x2[1] = _dest.i;
    }
      /* 7: storel */
      ptr0[i] = var39;
    }
  }

}

void
video_orc_convert_Y444_UYVY (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 89, 52, 52, 52, 95, 85, 89, 86, 89, 11, 
        4, 4, 12, 2, 2, 12, 2, 2, 12, 2, 2, 20, 2, 20, 4, 20, 
        2, 20, 2, 21, 1, 196, 33, 5, 6, 198, 34, 35, 33, 21, 1, 39, 
        32, 34, 35, 21, 1, 196, 0, 32, 4, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_Y444_UYVY);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_Y444_UYVY");
      orc_program_set_backup_function (p, _backup_video_orc_convert_Y444_UYVY);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");

      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_Y444_AYUV */
#ifdef DISABLE_ORC
void
video_orc_convert_Y444_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int p1, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);
    ptr6 = ORC_PTR_OFFSET(s3, s3_stride * j);

      /* 3: loadpb */
        var36 = p1;

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr5[i];
      /* 1: loadb */
      var35 = ptr6[i];
      /* 2: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var34;
       _dest.x2[1] = var35;
       var39.i = _dest.i;
    }
      /* 4: loadb */
      var37 = ptr4[i];
      /* 5: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var37;
       var40.i = _dest.i;
    }
      /* 6: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var39.i;
       var38.i = _dest.i;
    }
      /* 7: storel */
      ptr0[i] = var38;
    }
  }

}

#else
static void
_backup_video_orc_convert_Y444_AYUV (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_union32 var38;
  orc_union16 var39;
  orc_union16 var40;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);

      /* 3: loadpb */
        var36 = ex->params[24];

    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr5[i];
      /* 1: loadb */
      var35 = ptr6[i];
      /* 2: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var34;
       _dest.x2[1] = var35;
       var39.i = _dest.i;
    }
      /* 4: loadb */
      var37 = ptr4[i];
      /* 5: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var36;
       _dest.x2[1] = var37;
       var40.i = _dest.i;
    }
      /* 6: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var40.i;
       _dest.x2[1] = var39.i;
       var38.i = _dest.i;
    }
      /* 7: storel */
      ptr0[i] = var38;
    }
  }

}

void
video_orc_convert_Y444_AYUV (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const guint8 * ORC_RESTRICT s2, int s2_stride, const guint8 * ORC_RESTRICT s3, int s3_stride, int p1, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 89, 52, 52, 52, 95, 65, 89, 85, 86, 11, 
        4, 4, 12, 1, 1, 12, 1, 1, 12, 1, 1, 16, 1, 20, 2, 20, 
        2, 196, 32, 5, 6, 196, 33, 24, 4, 195, 0, 33, 32, 2, 0,       };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_Y444_AYUV);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_Y444_AYUV");
      orc_program_set_backup_function (p, _backup_video_orc_convert_Y444_AYUV);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_parameter (p, 1, "p1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T2, ORC_VAR_P1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_S3] = s3_stride;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_AYUV_ARGB */
#ifdef DISABLE_ORC
void
video_orc_convert_AYUV_ARGB (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3, int p4, int p5, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union16 var55;
  orc_union16 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_union16 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_int8 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_int8 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union32 var78;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);

      /* 1: loadpb */
        var47.x4[0] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[1] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[2] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[3] = (int)0x00000080; /* 128 or 6.32404e-322f */
      /* 9: loadpw */
        var48.i = p1;
      /* 11: loadpw */
        var49.i = p2;
      /* 16: loadpw */
        var50.i = p3;
      /* 20: loadpw */
        var51.i = p4;
      /* 23: loadpw */
        var52.i = p5;

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var54.x4[0] = var46.x4[0] - var47.x4[0];
      var54.x4[1] = var46.x4[1] - var47.x4[1];
      var54.x4[2] = var46.x4[2] - var47.x4[2];
      var54.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
       orc_union32 _src;
       _src.i = var54.i;
       var55.i = _src.x2[1];
       var56.i = _src.x2[0];
    }
      /* 4: splitwb */
      {
       orc_union16 _src;
       _src.i = var56.i;
       var57 = _src.x2[1];
       var58 = _src.x2[0];
    }
      /* 5: splitwb */
      {
       orc_union16 _src;
       _src.i = var55.i;
       var59 = _src.x2[1];
       var60 = _src.x2[0];
    }
      /* 6: splatbw */
      var61.i = ((var57&0xff) << 8) | (var57&0xff);
      /* 7: splatbw */
      var62.i = ((var60&0xff) << 8) | (var60&0xff);
      /* 8: splatbw */
      var63.i = ((var59&0xff) << 8) | (var59&0xff);
      /* 10: mulhsw */
      var64.i = (var61.i * var48.i) >> 16;
      /* 12: mulhsw */
      var65.i = (var63.i * var49.i) >> 16;
      /* 13: addw */
      var66.i = var64.i + var65.i;
      /* 14: convssswb */
      var67 = ORC_CLAMP_SB(var66.i);
      /* 15: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var58;
       _dest.x2[1] = var67;
       var68.i = _dest.i;
    }
      /* 17: mulhsw */
      var69.i = (var62.i * var50.i) >> 16;
      /* 18: addw */
      var70.i = var64.i + var69.i;
      /* 19: convssswb */
      var71 = ORC_CLAMP_SB(var70.i);
      /* 21: mulhsw */
      var72.i = (var62.i * var51.i) >> 16;
      /* 22: addw */
      var73.i = var64.i + var72.i;
      /* 24: mulhsw */
      var74.i = (var63.i * var52.i) >> 16;
      /* 25: addw */
      var75.i = var73.i + var74.i;
      /* 26: convssswb */
      var76 = ORC_CLAMP_SB(var75.i);
      /* 27: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var76;
       _dest.x2[1] = var71;
       var77.i = _dest.i;
    }
      /* 28: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var68.i;
       _dest.x2[1] = var77.i;
       var78.i = _dest.i;
    }
      /* 29: addb */
      var53.x4[0] = var78.x4[0] + var47.x4[0];
      var53.x4[1] = var78.x4[1] + var47.x4[1];
      var53.x4[2] = var78.x4[2] + var47.x4[2];
      var53.x4[3] = var78.x4[3] + var47.x4[3];
      /* 30: storel */
      ptr0[i] = var53;
    }
  }

}

#else
static void
_backup_video_orc_convert_AYUV_ARGB (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union16 var55;
  orc_union16 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_union16 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_int8 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_int8 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union32 var78;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

      /* 1: loadpb */
        var47.x4[0] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[1] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[2] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[3] = (int)0x00000080; /* 128 or 6.32404e-322f */
      /* 9: loadpw */
        var48.i = ex->params[24];
      /* 11: loadpw */
        var49.i = ex->params[25];
      /* 16: loadpw */
        var50.i = ex->params[26];
      /* 20: loadpw */
        var51.i = ex->params[27];
      /* 23: loadpw */
        var52.i = ex->params[28];

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var54.x4[0] = var46.x4[0] - var47.x4[0];
      var54.x4[1] = var46.x4[1] - var47.x4[1];
      var54.x4[2] = var46.x4[2] - var47.x4[2];
      var54.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
       orc_union32 _src;
       _src.i = var54.i;
       var55.i = _src.x2[1];
       var56.i = _src.x2[0];
    }
      /* 4: splitwb */
      {
       orc_union16 _src;
       _src.i = var56.i;
       var57 = _src.x2[1];
       var58 = _src.x2[0];
    }
      /* 5: splitwb */
      {
       orc_union16 _src;
       _src.i = var55.i;
       var59 = _src.x2[1];
       var60 = _src.x2[0];
    }
      /* 6: splatbw */
      var61.i = ((var57&0xff) << 8) | (var57&0xff);
      /* 7: splatbw */
      var62.i = ((var60&0xff) << 8) | (var60&0xff);
      /* 8: splatbw */
      var63.i = ((var59&0xff) << 8) | (var59&0xff);
      /* 10: mulhsw */
      var64.i = (var61.i * var48.i) >> 16;
      /* 12: mulhsw */
      var65.i = (var63.i * var49.i) >> 16;
      /* 13: addw */
      var66.i = var64.i + var65.i;
      /* 14: convssswb */
      var67 = ORC_CLAMP_SB(var66.i);
      /* 15: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var58;
       _dest.x2[1] = var67;
       var68.i = _dest.i;
    }
      /* 17: mulhsw */
      var69.i = (var62.i * var50.i) >> 16;
      /* 18: addw */
      var70.i = var64.i + var69.i;
      /* 19: convssswb */
      var71 = ORC_CLAMP_SB(var70.i);
      /* 21: mulhsw */
      var72.i = (var62.i * var51.i) >> 16;
      /* 22: addw */
      var73.i = var64.i + var72.i;
      /* 24: mulhsw */
      var74.i = (var63.i * var52.i) >> 16;
      /* 25: addw */
      var75.i = var73.i + var74.i;
      /* 26: convssswb */
      var76 = ORC_CLAMP_SB(var75.i);
      /* 27: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var76;
       _dest.x2[1] = var71;
       var77.i = _dest.i;
    }
      /* 28: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var68.i;
       _dest.x2[1] = var77.i;
       var78.i = _dest.i;
    }
      /* 29: addb */
      var53.x4[0] = var78.x4[0] + var47.x4[0];
      var53.x4[1] = var78.x4[1] + var47.x4[1];
      var53.x4[2] = var78.x4[2] + var47.x4[2];
      var53.x4[3] = var78.x4[3] + var47.x4[3];
      /* 30: storel */
      ptr0[i] = var53;
    }
  }

}

void
video_orc_convert_AYUV_ARGB (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3, int p4, int p5, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 65, 89, 85, 86, 95, 65, 82, 71, 66, 11, 
        4, 4, 12, 4, 4, 14, 1, 128, 0, 0, 0, 16, 2, 16, 2, 16, 
        2, 16, 2, 16, 2, 20, 1, 20, 1, 20, 1, 20, 1, 20, 2, 20, 
        2, 20, 2, 20, 2, 20, 2, 20, 2, 20, 1, 20, 1, 20, 1, 20, 
        4, 21, 2, 65, 45, 4, 16, 198, 38, 36, 45, 199, 33, 32, 36, 199, 
        35, 34, 38, 151, 36, 33, 151, 37, 34, 151, 38, 35, 90, 36, 36, 24, 
        90, 39, 38, 25, 70, 39, 36, 39, 159, 42, 39, 196, 39, 32, 42, 90, 
        41, 37, 26, 70, 41, 36, 41, 159, 44, 41, 90, 40, 37, 27, 70, 40, 
        36, 40, 90, 36, 38, 28, 70, 40, 40, 36, 159, 43, 40, 196, 41, 43, 
        44, 195, 45, 39, 41, 21, 2, 33, 0, 45, 16, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_ARGB);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_AYUV_ARGB");
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_ARGB);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");
      orc_program_add_temporary (p, 2, "t9");
      orc_program_add_temporary (p, 2, "t10");
      orc_program_add_temporary (p, 1, "t11");
      orc_program_add_temporary (p, 1, "t12");
      orc_program_add_temporary (p, 1, "t13");
      orc_program_add_temporary (p, 4, "t14");

      orc_program_append_2 (p, "subb", 2, ORC_VAR_T14, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T7, ORC_VAR_T5, ORC_VAR_T14, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T7, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T8, ORC_VAR_T7, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T11, ORC_VAR_T8, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T8, ORC_VAR_T1, ORC_VAR_T11, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T10, ORC_VAR_T6, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T10, ORC_VAR_T5, ORC_VAR_T10, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T13, ORC_VAR_T10, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T9, ORC_VAR_T5, ORC_VAR_T9, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T7, ORC_VAR_P5, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T9, ORC_VAR_T9, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T12, ORC_VAR_T9, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T10, ORC_VAR_T12, ORC_VAR_T13, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T14, ORC_VAR_T8, ORC_VAR_T10, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, ORC_VAR_T14, ORC_VAR_C1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_AYUV_BGRA */
#ifdef DISABLE_ORC
void
video_orc_convert_AYUV_BGRA (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3, int p4, int p5, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union16 var55;
  orc_union16 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_union16 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_int8 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_int8 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union32 var78;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);

      /* 1: loadpb */
        var47.x4[0] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[1] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[2] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[3] = (int)0x00000080; /* 128 or 6.32404e-322f */
      /* 9: loadpw */
        var48.i = p1;
      /* 11: loadpw */
        var49.i = p2;
      /* 16: loadpw */
        var50.i = p3;
      /* 20: loadpw */
        var51.i = p4;
      /* 23: loadpw */
        var52.i = p5;

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var54.x4[0] = var46.x4[0] - var47.x4[0];
      var54.x4[1] = var46.x4[1] - var47.x4[1];
      var54.x4[2] = var46.x4[2] - var47.x4[2];
      var54.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
       orc_union32 _src;
       _src.i = var54.i;
       var55.i = _src.x2[1];
       var56.i = _src.x2[0];
    }
      /* 4: splitwb */
      {
       orc_union16 _src;
       _src.i = var56.i;
       var57 = _src.x2[1];
       var58 = _src.x2[0];
    }
      /* 5: splitwb */
      {
       orc_union16 _src;
       _src.i = var55.i;
       var59 = _src.x2[1];
       var60 = _src.x2[0];
    }
      /* 6: splatbw */
      var61.i = ((var57&0xff) << 8) | (var57&0xff);
      /* 7: splatbw */
      var62.i = ((var60&0xff) << 8) | (var60&0xff);
      /* 8: splatbw */
      var63.i = ((var59&0xff) << 8) | (var59&0xff);
      /* 10: mulhsw */
      var64.i = (var61.i * var48.i) >> 16;
      /* 12: mulhsw */
      var65.i = (var63.i * var49.i) >> 16;
      /* 13: addw */
      var66.i = var64.i + var65.i;
      /* 14: convssswb */
      var67 = ORC_CLAMP_SB(var66.i);
      /* 15: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var67;
       _dest.x2[1] = var58;
       var68.i = _dest.i;
    }
      /* 17: mulhsw */
      var69.i = (var62.i * var50.i) >> 16;
      /* 18: addw */
      var70.i = var64.i + var69.i;
      /* 19: convssswb */
      var71 = ORC_CLAMP_SB(var70.i);
      /* 21: mulhsw */
      var72.i = (var62.i * var51.i) >> 16;
      /* 22: addw */
      var73.i = var64.i + var72.i;
      /* 24: mulhsw */
      var74.i = (var63.i * var52.i) >> 16;
      /* 25: addw */
      var75.i = var73.i + var74.i;
      /* 26: convssswb */
      var76 = ORC_CLAMP_SB(var75.i);
      /* 27: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var71;
       _dest.x2[1] = var76;
       var77.i = _dest.i;
    }
      /* 28: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var77.i;
       _dest.x2[1] = var68.i;
       var78.i = _dest.i;
    }
      /* 29: addb */
      var53.x4[0] = var78.x4[0] + var47.x4[0];
      var53.x4[1] = var78.x4[1] + var47.x4[1];
      var53.x4[2] = var78.x4[2] + var47.x4[2];
      var53.x4[3] = var78.x4[3] + var47.x4[3];
      /* 30: storel */
      ptr0[i] = var53;
    }
  }

}

#else
static void
_backup_video_orc_convert_AYUV_BGRA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union16 var55;
  orc_union16 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_union16 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_int8 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_int8 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union32 var78;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

      /* 1: loadpb */
        var47.x4[0] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[1] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[2] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[3] = (int)0x00000080; /* 128 or 6.32404e-322f */
      /* 9: loadpw */
        var48.i = ex->params[24];
      /* 11: loadpw */
        var49.i = ex->params[25];
      /* 16: loadpw */
        var50.i = ex->params[26];
      /* 20: loadpw */
        var51.i = ex->params[27];
      /* 23: loadpw */
        var52.i = ex->params[28];

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var54.x4[0] = var46.x4[0] - var47.x4[0];
      var54.x4[1] = var46.x4[1] - var47.x4[1];
      var54.x4[2] = var46.x4[2] - var47.x4[2];
      var54.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
       orc_union32 _src;
       _src.i = var54.i;
       var55.i = _src.x2[1];
       var56.i = _src.x2[0];
    }
      /* 4: splitwb */
      {
       orc_union16 _src;
       _src.i = var56.i;
       var57 = _src.x2[1];
       var58 = _src.x2[0];
    }
      /* 5: splitwb */
      {
       orc_union16 _src;
       _src.i = var55.i;
       var59 = _src.x2[1];
       var60 = _src.x2[0];
    }
      /* 6: splatbw */
      var61.i = ((var57&0xff) << 8) | (var57&0xff);
      /* 7: splatbw */
      var62.i = ((var60&0xff) << 8) | (var60&0xff);
      /* 8: splatbw */
      var63.i = ((var59&0xff) << 8) | (var59&0xff);
      /* 10: mulhsw */
      var64.i = (var61.i * var48.i) >> 16;
      /* 12: mulhsw */
      var65.i = (var63.i * var49.i) >> 16;
      /* 13: addw */
      var66.i = var64.i + var65.i;
      /* 14: convssswb */
      var67 = ORC_CLAMP_SB(var66.i);
      /* 15: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var67;
       _dest.x2[1] = var58;
       var68.i = _dest.i;
    }
      /* 17: mulhsw */
      var69.i = (var62.i * var50.i) >> 16;
      /* 18: addw */
      var70.i = var64.i + var69.i;
      /* 19: convssswb */
      var71 = ORC_CLAMP_SB(var70.i);
      /* 21: mulhsw */
      var72.i = (var62.i * var51.i) >> 16;
      /* 22: addw */
      var73.i = var64.i + var72.i;
      /* 24: mulhsw */
      var74.i = (var63.i * var52.i) >> 16;
      /* 25: addw */
      var75.i = var73.i + var74.i;
      /* 26: convssswb */
      var76 = ORC_CLAMP_SB(var75.i);
      /* 27: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var71;
       _dest.x2[1] = var76;
       var77.i = _dest.i;
    }
      /* 28: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var77.i;
       _dest.x2[1] = var68.i;
       var78.i = _dest.i;
    }
      /* 29: addb */
      var53.x4[0] = var78.x4[0] + var47.x4[0];
      var53.x4[1] = var78.x4[1] + var47.x4[1];
      var53.x4[2] = var78.x4[2] + var47.x4[2];
      var53.x4[3] = var78.x4[3] + var47.x4[3];
      /* 30: storel */
      ptr0[i] = var53;
    }
  }

}

void
video_orc_convert_AYUV_BGRA (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3, int p4, int p5, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 65, 89, 85, 86, 95, 66, 71, 82, 65, 11, 
        4, 4, 12, 4, 4, 14, 1, 128, 0, 0, 0, 16, 2, 16, 2, 16, 
        2, 16, 2, 16, 2, 20, 1, 20, 1, 20, 1, 20, 1, 20, 2, 20, 
        2, 20, 2, 20, 2, 20, 2, 20, 2, 20, 1, 20, 1, 20, 1, 20, 
        4, 21, 2, 65, 45, 4, 16, 198, 38, 36, 45, 199, 33, 32, 36, 199, 
        35, 34, 38, 151, 36, 33, 151, 37, 34, 151, 38, 35, 90, 36, 36, 24, 
        90, 39, 38, 25, 70, 39, 36, 39, 159, 42, 39, 196, 39, 42, 32, 90, 
        41, 37, 26, 70, 41, 36, 41, 159, 44, 41, 90, 40, 37, 27, 70, 40, 
        36, 40, 90, 36, 38, 28, 70, 40, 40, 36, 159, 43, 40, 196, 41, 44, 
        43, 195, 45, 41, 39, 21, 2, 33, 0, 45, 16, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_BGRA);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_AYUV_BGRA");
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_BGRA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");
      orc_program_add_temporary (p, 2, "t9");
      orc_program_add_temporary (p, 2, "t10");
      orc_program_add_temporary (p, 1, "t11");
      orc_program_add_temporary (p, 1, "t12");
      orc_program_add_temporary (p, 1, "t13");
      orc_program_add_temporary (p, 4, "t14");

      orc_program_append_2 (p, "subb", 2, ORC_VAR_T14, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T7, ORC_VAR_T5, ORC_VAR_T14, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T7, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T8, ORC_VAR_T7, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T11, ORC_VAR_T8, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T8, ORC_VAR_T11, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T10, ORC_VAR_T6, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T10, ORC_VAR_T5, ORC_VAR_T10, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T13, ORC_VAR_T10, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T9, ORC_VAR_T5, ORC_VAR_T9, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T7, ORC_VAR_P5, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T9, ORC_VAR_T9, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T12, ORC_VAR_T9, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T10, ORC_VAR_T13, ORC_VAR_T12, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T14, ORC_VAR_T10, ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, ORC_VAR_T14, ORC_VAR_C1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_AYUV_ABGR */
#ifdef DISABLE_ORC
void
video_orc_convert_AYUV_ABGR (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3, int p4, int p5, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union16 var55;
  orc_union16 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_union16 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_int8 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_int8 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union32 var78;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);

      /* 1: loadpb */
        var47.x4[0] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[1] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[2] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[3] = (int)0x00000080; /* 128 or 6.32404e-322f */
      /* 9: loadpw */
        var48.i = p1;
      /* 11: loadpw */
        var49.i = p2;
      /* 15: loadpw */
        var50.i = p3;
      /* 20: loadpw */
        var51.i = p4;
      /* 23: loadpw */
        var52.i = p5;

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var54.x4[0] = var46.x4[0] - var47.x4[0];
      var54.x4[1] = var46.x4[1] - var47.x4[1];
      var54.x4[2] = var46.x4[2] - var47.x4[2];
      var54.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
       orc_union32 _src;
       _src.i = var54.i;
       var55.i = _src.x2[1];
       var56.i = _src.x2[0];
    }
      /* 4: splitwb */
      {
       orc_union16 _src;
       _src.i = var56.i;
       var57 = _src.x2[1];
       var58 = _src.x2[0];
    }
      /* 5: splitwb */
      {
       orc_union16 _src;
       _src.i = var55.i;
       var59 = _src.x2[1];
       var60 = _src.x2[0];
    }
      /* 6: splatbw */
      var61.i = ((var57&0xff) << 8) | (var57&0xff);
      /* 7: splatbw */
      var62.i = ((var60&0xff) << 8) | (var60&0xff);
      /* 8: splatbw */
      var63.i = ((var59&0xff) << 8) | (var59&0xff);
      /* 10: mulhsw */
      var64.i = (var61.i * var48.i) >> 16;
      /* 12: mulhsw */
      var65.i = (var63.i * var49.i) >> 16;
      /* 13: addw */
      var66.i = var64.i + var65.i;
      /* 14: convssswb */
      var67 = ORC_CLAMP_SB(var66.i);
      /* 16: mulhsw */
      var68.i = (var62.i * var50.i) >> 16;
      /* 17: addw */
      var69.i = var64.i + var68.i;
      /* 18: convssswb */
      var70 = ORC_CLAMP_SB(var69.i);
      /* 19: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var58;
       _dest.x2[1] = var70;
       var71.i = _dest.i;
    }
      /* 21: mulhsw */
      var72.i = (var62.i * var51.i) >> 16;
      /* 22: addw */
      var73.i = var64.i + var72.i;
      /* 24: mulhsw */
      var74.i = (var63.i * var52.i) >> 16;
      /* 25: addw */
      var75.i = var73.i + var74.i;
      /* 26: convssswb */
      var76 = ORC_CLAMP_SB(var75.i);
      /* 27: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var76;
       _dest.x2[1] = var67;
       var77.i = _dest.i;
    }
      /* 28: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var71.i;
       _dest.x2[1] = var77.i;
       var78.i = _dest.i;
    }
      /* 29: addb */
      var53.x4[0] = var78.x4[0] + var47.x4[0];
      var53.x4[1] = var78.x4[1] + var47.x4[1];
      var53.x4[2] = var78.x4[2] + var47.x4[2];
      var53.x4[3] = var78.x4[3] + var47.x4[3];
      /* 30: storel */
      ptr0[i] = var53;
    }
  }

}

#else
static void
_backup_video_orc_convert_AYUV_ABGR (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union16 var55;
  orc_union16 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_union16 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_int8 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_int8 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union32 var78;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

      /* 1: loadpb */
        var47.x4[0] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[1] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[2] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[3] = (int)0x00000080; /* 128 or 6.32404e-322f */
      /* 9: loadpw */
        var48.i = ex->params[24];
      /* 11: loadpw */
        var49.i = ex->params[25];
      /* 15: loadpw */
        var50.i = ex->params[26];
      /* 20: loadpw */
        var51.i = ex->params[27];
      /* 23: loadpw */
        var52.i = ex->params[28];

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var54.x4[0] = var46.x4[0] - var47.x4[0];
      var54.x4[1] = var46.x4[1] - var47.x4[1];
      var54.x4[2] = var46.x4[2] - var47.x4[2];
      var54.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
       orc_union32 _src;
       _src.i = var54.i;
       var55.i = _src.x2[1];
       var56.i = _src.x2[0];
    }
      /* 4: splitwb */
      {
       orc_union16 _src;
       _src.i = var56.i;
       var57 = _src.x2[1];
       var58 = _src.x2[0];
    }
      /* 5: splitwb */
      {
       orc_union16 _src;
       _src.i = var55.i;
       var59 = _src.x2[1];
       var60 = _src.x2[0];
    }
      /* 6: splatbw */
      var61.i = ((var57&0xff) << 8) | (var57&0xff);
      /* 7: splatbw */
      var62.i = ((var60&0xff) << 8) | (var60&0xff);
      /* 8: splatbw */
      var63.i = ((var59&0xff) << 8) | (var59&0xff);
      /* 10: mulhsw */
      var64.i = (var61.i * var48.i) >> 16;
      /* 12: mulhsw */
      var65.i = (var63.i * var49.i) >> 16;
      /* 13: addw */
      var66.i = var64.i + var65.i;
      /* 14: convssswb */
      var67 = ORC_CLAMP_SB(var66.i);
      /* 16: mulhsw */
      var68.i = (var62.i * var50.i) >> 16;
      /* 17: addw */
      var69.i = var64.i + var68.i;
      /* 18: convssswb */
      var70 = ORC_CLAMP_SB(var69.i);
      /* 19: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var58;
       _dest.x2[1] = var70;
       var71.i = _dest.i;
    }
      /* 21: mulhsw */
      var72.i = (var62.i * var51.i) >> 16;
      /* 22: addw */
      var73.i = var64.i + var72.i;
      /* 24: mulhsw */
      var74.i = (var63.i * var52.i) >> 16;
      /* 25: addw */
      var75.i = var73.i + var74.i;
      /* 26: convssswb */
      var76 = ORC_CLAMP_SB(var75.i);
      /* 27: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var76;
       _dest.x2[1] = var67;
       var77.i = _dest.i;
    }
      /* 28: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var71.i;
       _dest.x2[1] = var77.i;
       var78.i = _dest.i;
    }
      /* 29: addb */
      var53.x4[0] = var78.x4[0] + var47.x4[0];
      var53.x4[1] = var78.x4[1] + var47.x4[1];
      var53.x4[2] = var78.x4[2] + var47.x4[2];
      var53.x4[3] = var78.x4[3] + var47.x4[3];
      /* 30: storel */
      ptr0[i] = var53;
    }
  }

}

void
video_orc_convert_AYUV_ABGR (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3, int p4, int p5, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 65, 89, 85, 86, 95, 65, 66, 71, 82, 11, 
        4, 4, 12, 4, 4, 14, 1, 128, 0, 0, 0, 16, 2, 16, 2, 16, 
        2, 16, 2, 16, 2, 20, 1, 20, 1, 20, 1, 20, 1, 20, 2, 20, 
        2, 20, 2, 20, 2, 20, 2, 20, 2, 20, 1, 20, 1, 20, 1, 20, 
        4, 21, 2, 65, 45, 4, 16, 198, 38, 36, 45, 199, 33, 32, 36, 199, 
        35, 34, 38, 151, 36, 33, 151, 37, 34, 151, 38, 35, 90, 36, 36, 24, 
        90, 39, 38, 25, 70, 39, 36, 39, 159, 42, 39, 90, 41, 37, 26, 70, 
        41, 36, 41, 159, 44, 41, 196, 41, 32, 44, 90, 40, 37, 27, 70, 40, 
        36, 40, 90, 36, 38, 28, 70, 40, 40, 36, 159, 43, 40, 196, 39, 43, 
        42, 195, 45, 41, 39, 21, 2, 33, 0, 45, 16, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_ABGR);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_AYUV_ABGR");
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_ABGR);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");
      orc_program_add_temporary (p, 2, "t9");
      orc_program_add_temporary (p, 2, "t10");
      orc_program_add_temporary (p, 1, "t11");
      orc_program_add_temporary (p, 1, "t12");
      orc_program_add_temporary (p, 1, "t13");
      orc_program_add_temporary (p, 4, "t14");

      orc_program_append_2 (p, "subb", 2, ORC_VAR_T14, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T7, ORC_VAR_T5, ORC_VAR_T14, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T7, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T8, ORC_VAR_T7, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T11, ORC_VAR_T8, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T10, ORC_VAR_T6, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T10, ORC_VAR_T5, ORC_VAR_T10, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T13, ORC_VAR_T10, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T10, ORC_VAR_T1, ORC_VAR_T13, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T9, ORC_VAR_T5, ORC_VAR_T9, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T7, ORC_VAR_P5, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T9, ORC_VAR_T9, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T12, ORC_VAR_T9, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T8, ORC_VAR_T12, ORC_VAR_T11, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T14, ORC_VAR_T10, ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, ORC_VAR_T14, ORC_VAR_C1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_AYUV_RGBA */
#ifdef DISABLE_ORC
void
video_orc_convert_AYUV_RGBA (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3, int p4, int p5, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union16 var55;
  orc_union16 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_union16 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_int8 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_int8 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union32 var78;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);

      /* 1: loadpb */
        var47.x4[0] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[1] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[2] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[3] = (int)0x00000080; /* 128 or 6.32404e-322f */
      /* 9: loadpw */
        var48.i = p1;
      /* 11: loadpw */
        var49.i = p2;
      /* 15: loadpw */
        var50.i = p3;
      /* 20: loadpw */
        var51.i = p4;
      /* 23: loadpw */
        var52.i = p5;

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var54.x4[0] = var46.x4[0] - var47.x4[0];
      var54.x4[1] = var46.x4[1] - var47.x4[1];
      var54.x4[2] = var46.x4[2] - var47.x4[2];
      var54.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
       orc_union32 _src;
       _src.i = var54.i;
       var55.i = _src.x2[1];
       var56.i = _src.x2[0];
    }
      /* 4: splitwb */
      {
       orc_union16 _src;
       _src.i = var56.i;
       var57 = _src.x2[1];
       var58 = _src.x2[0];
    }
      /* 5: splitwb */
      {
       orc_union16 _src;
       _src.i = var55.i;
       var59 = _src.x2[1];
       var60 = _src.x2[0];
    }
      /* 6: splatbw */
      var61.i = ((var57&0xff) << 8) | (var57&0xff);
      /* 7: splatbw */
      var62.i = ((var60&0xff) << 8) | (var60&0xff);
      /* 8: splatbw */
      var63.i = ((var59&0xff) << 8) | (var59&0xff);
      /* 10: mulhsw */
      var64.i = (var61.i * var48.i) >> 16;
      /* 12: mulhsw */
      var65.i = (var63.i * var49.i) >> 16;
      /* 13: addw */
      var66.i = var64.i + var65.i;
      /* 14: convssswb */
      var67 = ORC_CLAMP_SB(var66.i);
      /* 16: mulhsw */
      var68.i = (var62.i * var50.i) >> 16;
      /* 17: addw */
      var69.i = var64.i + var68.i;
      /* 18: convssswb */
      var70 = ORC_CLAMP_SB(var69.i);
      /* 19: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var70;
       _dest.x2[1] = var58;
       var71.i = _dest.i;
    }
      /* 21: mulhsw */
      var72.i = (var62.i * var51.i) >> 16;
      /* 22: addw */
      var73.i = var64.i + var72.i;
      /* 24: mulhsw */
      var74.i = (var63.i * var52.i) >> 16;
      /* 25: addw */
      var75.i = var73.i + var74.i;
      /* 26: convssswb */
      var76 = ORC_CLAMP_SB(var75.i);
      /* 27: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var67;
       _dest.x2[1] = var76;
       var77.i = _dest.i;
    }
      /* 28: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var77.i;
       _dest.x2[1] = var71.i;
       var78.i = _dest.i;
    }
      /* 29: addb */
      var53.x4[0] = var78.x4[0] + var47.x4[0];
      var53.x4[1] = var78.x4[1] + var47.x4[1];
      var53.x4[2] = var78.x4[2] + var47.x4[2];
      var53.x4[3] = var78.x4[3] + var47.x4[3];
      /* 30: storel */
      ptr0[i] = var53;
    }
  }

}

#else
static void
_backup_video_orc_convert_AYUV_RGBA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var46;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var47;
#else
  orc_union32 var47;
#endif
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union16 var55;
  orc_union16 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_int8 var59;
  orc_int8 var60;
  orc_union16 var61;
  orc_union16 var62;
  orc_union16 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_int8 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_int8 var70;
  orc_union16 var71;
  orc_union16 var72;
  orc_union16 var73;
  orc_union16 var74;
  orc_union16 var75;
  orc_int8 var76;
  orc_union16 var77;
  orc_union32 var78;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

      /* 1: loadpb */
        var47.x4[0] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[1] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[2] = (int)0x00000080; /* 128 or 6.32404e-322f */
      var47.x4[3] = (int)0x00000080; /* 128 or 6.32404e-322f */
      /* 9: loadpw */
        var48.i = ex->params[24];
      /* 11: loadpw */
        var49.i = ex->params[25];
      /* 15: loadpw */
        var50.i = ex->params[26];
      /* 20: loadpw */
        var51.i = ex->params[27];
      /* 23: loadpw */
        var52.i = ex->params[28];

    for (i = 0; i < n; i++) {
      /* 0: loadl */
      var46 = ptr4[i];
      /* 2: subb */
      var54.x4[0] = var46.x4[0] - var47.x4[0];
      var54.x4[1] = var46.x4[1] - var47.x4[1];
      var54.x4[2] = var46.x4[2] - var47.x4[2];
      var54.x4[3] = var46.x4[3] - var47.x4[3];
      /* 3: splitlw */
      {
       orc_union32 _src;
       _src.i = var54.i;
       var55.i = _src.x2[1];
       var56.i = _src.x2[0];
    }
      /* 4: splitwb */
      {
       orc_union16 _src;
       _src.i = var56.i;
       var57 = _src.x2[1];
       var58 = _src.x2[0];
    }
      /* 5: splitwb */
      {
       orc_union16 _src;
       _src.i = var55.i;
       var59 = _src.x2[1];
       var60 = _src.x2[0];
    }
      /* 6: splatbw */
      var61.i = ((var57&0xff) << 8) | (var57&0xff);
      /* 7: splatbw */
      var62.i = ((var60&0xff) << 8) | (var60&0xff);
      /* 8: splatbw */
      var63.i = ((var59&0xff) << 8) | (var59&0xff);
      /* 10: mulhsw */
      var64.i = (var61.i * var48.i) >> 16;
      /* 12: mulhsw */
      var65.i = (var63.i * var49.i) >> 16;
      /* 13: addw */
      var66.i = var64.i + var65.i;
      /* 14: convssswb */
      var67 = ORC_CLAMP_SB(var66.i);
      /* 16: mulhsw */
      var68.i = (var62.i * var50.i) >> 16;
      /* 17: addw */
      var69.i = var64.i + var68.i;
      /* 18: convssswb */
      var70 = ORC_CLAMP_SB(var69.i);
      /* 19: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var70;
       _dest.x2[1] = var58;
       var71.i = _dest.i;
    }
      /* 21: mulhsw */
      var72.i = (var62.i * var51.i) >> 16;
      /* 22: addw */
      var73.i = var64.i + var72.i;
      /* 24: mulhsw */
      var74.i = (var63.i * var52.i) >> 16;
      /* 25: addw */
      var75.i = var73.i + var74.i;
      /* 26: convssswb */
      var76 = ORC_CLAMP_SB(var75.i);
      /* 27: mergebw */
      {
       orc_union16 _dest;
       _dest.x2[0] = var67;
       _dest.x2[1] = var76;
       var77.i = _dest.i;
    }
      /* 28: mergewl */
      {
       orc_union32 _dest;
       _dest.x2[0] = var77.i;
       _dest.x2[1] = var71.i;
       var78.i = _dest.i;
    }
      /* 29: addb */
      var53.x4[0] = var78.x4[0] + var47.x4[0];
      var53.x4[1] = var78.x4[1] + var47.x4[1];
      var53.x4[2] = var78.x4[2] + var47.x4[2];
      var53.x4[3] = var78.x4[3] + var47.x4[3];
      /* 30: storel */
      ptr0[i] = var53;
    }
  }

}

void
video_orc_convert_AYUV_RGBA (guint8 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, int p1, int p2, int p3, int p4, int p5, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 65, 89, 85, 86, 95, 82, 71, 66, 65, 11, 
        4, 4, 12, 4, 4, 14, 1, 128, 0, 0, 0, 16, 2, 16, 2, 16, 
        2, 16, 2, 16, 2, 20, 1, 20, 1, 20, 1, 20, 1, 20, 2, 20, 
        2, 20, 2, 20, 2, 20, 2, 20, 2, 20, 1, 20, 1, 20, 1, 20, 
        4, 21, 2, 65, 45, 4, 16, 198, 38, 36, 45, 199, 33, 32, 36, 199, 
        35, 34, 38, 151, 36, 33, 151, 37, 34, 151, 38, 35, 90, 36, 36, 24, 
        90, 39, 38, 25, 70, 39, 36, 39, 159, 42, 39, 90, 41, 37, 26, 70, 
        41, 36, 41, 159, 44, 41, 196, 41, 44, 32, 90, 40, 37, 27, 70, 40, 
        36, 40, 90, 36, 38, 28, 70, 40, 40, 36, 159, 43, 40, 196, 39, 42, 
        43, 195, 45, 39, 41, 21, 2, 33, 0, 45, 16, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_RGBA);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_AYUV_RGBA");
      orc_program_set_backup_function (p, _backup_video_orc_convert_AYUV_RGBA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 1, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 2, "t7");
      orc_program_add_temporary (p, 2, "t8");
      orc_program_add_temporary (p, 2, "t9");
      orc_program_add_temporary (p, 2, "t10");
      orc_program_add_temporary (p, 1, "t11");
      orc_program_add_temporary (p, 1, "t12");
      orc_program_add_temporary (p, 1, "t13");
      orc_program_add_temporary (p, 4, "t14");

      orc_program_append_2 (p, "subb", 2, ORC_VAR_T14, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T7, ORC_VAR_T5, ORC_VAR_T14, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "splitwb", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T7, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T8, ORC_VAR_T7, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T11, ORC_VAR_T8, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T10, ORC_VAR_T6, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T10, ORC_VAR_T5, ORC_VAR_T10, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T13, ORC_VAR_T10, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T10, ORC_VAR_T13, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T9, ORC_VAR_T5, ORC_VAR_T9, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T7, ORC_VAR_P5, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T9, ORC_VAR_T9, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T12, ORC_VAR_T9, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T8, ORC_VAR_T11, ORC_VAR_T12, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T14, ORC_VAR_T8, ORC_VAR_T10, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, ORC_VAR_T14, ORC_VAR_C1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_I420_BGRA */
#ifdef DISABLE_ORC
void
video_orc_convert_I420_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int p1, int p2, int p3, int p4, int p5, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var42;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var43;
#else
  orc_int8 var43;
#endif
  orc_union16 var44;
  orc_union16 var45;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var46;
#else
  orc_int8 var46;
#endif
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var50;
#else
  orc_union32 var50;
#endif
  orc_union32 var51;
  orc_int8 var52;
  orc_union16 var53;
  orc_int8 var54;
  orc_int8 var55;
  orc_union16 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_union16 var59;
  orc_union16 var60;
  orc_union16 var61;
  orc_union16 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_int8 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_int8 var72;
  orc_union16 var73;
  orc_union32 var74;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;

    /* 1: loadpb */
    var43 = (int)0x00000080; /* 128 or 6.32404e-322f */
    /* 10: loadpw */
    var44.i = p1;
    /* 12: loadpw */
    var45.i = p2;
    /* 16: loadpb */
    var46 = (int)0x0000007f; /* 127 or 6.27463e-322f */
    /* 18: loadpw */
    var47.i = p3;
    /* 22: loadpw */
    var48.i = p4;
    /* 25: loadpw */
    var49.i = p5;
    /* 31: loadpb */
    var50.x4[0] = (int)0x00000080; /* 128 or 6.32404e-322f */
    var50.x4[1] = (int)0x00000080; /* 128 or 6.32404e-322f */
    var50.x4[2] = (int)0x00000080; /* 128 or 6.32404e-322f */
    var50.x4[3] = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var42 = ptr4[i];
    /* 2: subb */
    var52 = var42 - var43;
    /* 3: splatbw */
    var53.i = ((var52&0xff) << 8) | (var52&0xff);
    /* 4: loadupdb */
    var54 = ptr5[i>>1];
    /* 5: subb */
    var55 = var54 - var43;
    /* 6: splatbw */
    var56.i = ((var55&0xff) << 8) | (var55&0xff);
    /* 7: loadupdb */
    var57 = ptr6[i>>1];
    /* 8: subb */
    var58 = var57 - var43;
    /* 9: splatbw */
    var59.i = ((var58&0xff) << 8) | (var58&0xff);
    /* 11: mulhsw */
    var60.i = (var53.i * var44.i) >> 16;
    /* 13: mulhsw */
    var61.i = (var59.i * var45.i) >> 16;
    /* 14: addw */
    var62.i = var60.i + var61.i;
    /* 15: convssswb */
    var63 = ORC_CLAMP_SB(var62.i);
    /* 17: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var63;
       _dest.x2[1] = var46;
       var64.i = _dest.i;
    }
    /* 19: mulhsw */
    var65.i = (var56.i * var47.i) >> 16;
    /* 20: addw */
    var66.i = var60.i + var65.i;
    /* 21: convssswb */
    var67 = ORC_CLAMP_SB(var66.i);
    /* 23: mulhsw */
    var68.i = (var56.i * var48.i) >> 16;
    /* 24: addw */
    var69.i = var60.i + var68.i;
    /* 26: mulhsw */
    var70.i = (var59.i * var49.i) >> 16;
    /* 27: addw */
    var71.i = var69.i + var70.i;
    /* 28: convssswb */
    var72 = ORC_CLAMP_SB(var71.i);
    /* 29: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var67;
       _dest.x2[1] = var72;
       var73.i = _dest.i;
    }
    /* 30: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var73.i;
       _dest.x2[1] = var64.i;
       var74.i = _dest.i;
    }
    /* 32: addb */
    var51.x4[0] = var74.x4[0] + var50.x4[0];
    var51.x4[1] = var74.x4[1] + var50.x4[1];
    var51.x4[2] = var74.x4[2] + var50.x4[2];
    var51.x4[3] = var74.x4[3] + var50.x4[3];
    /* 33: storel */
    ptr0[i] = var51;
  }

}

#else
static void
_backup_video_orc_convert_I420_BGRA (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var42;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var43;
#else
  orc_int8 var43;
#endif
  orc_union16 var44;
  orc_union16 var45;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var46;
#else
  orc_int8 var46;
#endif
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var50;
#else
  orc_union32 var50;
#endif
  orc_union32 var51;
  orc_int8 var52;
  orc_union16 var53;
  orc_int8 var54;
  orc_int8 var55;
  orc_union16 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_union16 var59;
  orc_union16 var60;
  orc_union16 var61;
  orc_union16 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_int8 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_int8 var72;
  orc_union16 var73;
  orc_union32 var74;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

    /* 1: loadpb */
    var43 = (int)0x00000080; /* 128 or 6.32404e-322f */
    /* 10: loadpw */
    var44.i = ex->params[24];
    /* 12: loadpw */
    var45.i = ex->params[25];
    /* 16: loadpb */
    var46 = (int)0x0000007f; /* 127 or 6.27463e-322f */
    /* 18: loadpw */
    var47.i = ex->params[26];
    /* 22: loadpw */
    var48.i = ex->params[27];
    /* 25: loadpw */
    var49.i = ex->params[28];
    /* 31: loadpb */
    var50.x4[0] = (int)0x00000080; /* 128 or 6.32404e-322f */
    var50.x4[1] = (int)0x00000080; /* 128 or 6.32404e-322f */
    var50.x4[2] = (int)0x00000080; /* 128 or 6.32404e-322f */
    var50.x4[3] = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var42 = ptr4[i];
    /* 2: subb */
    var52 = var42 - var43;
    /* 3: splatbw */
    var53.i = ((var52&0xff) << 8) | (var52&0xff);
    /* 4: loadupdb */
    var54 = ptr5[i>>1];
    /* 5: subb */
    var55 = var54 - var43;
    /* 6: splatbw */
    var56.i = ((var55&0xff) << 8) | (var55&0xff);
    /* 7: loadupdb */
    var57 = ptr6[i>>1];
    /* 8: subb */
    var58 = var57 - var43;
    /* 9: splatbw */
    var59.i = ((var58&0xff) << 8) | (var58&0xff);
    /* 11: mulhsw */
    var60.i = (var53.i * var44.i) >> 16;
    /* 13: mulhsw */
    var61.i = (var59.i * var45.i) >> 16;
    /* 14: addw */
    var62.i = var60.i + var61.i;
    /* 15: convssswb */
    var63 = ORC_CLAMP_SB(var62.i);
    /* 17: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var63;
       _dest.x2[1] = var46;
       var64.i = _dest.i;
    }
    /* 19: mulhsw */
    var65.i = (var56.i * var47.i) >> 16;
    /* 20: addw */
    var66.i = var60.i + var65.i;
    /* 21: convssswb */
    var67 = ORC_CLAMP_SB(var66.i);
    /* 23: mulhsw */
    var68.i = (var56.i * var48.i) >> 16;
    /* 24: addw */
    var69.i = var60.i + var68.i;
    /* 26: mulhsw */
    var70.i = (var59.i * var49.i) >> 16;
    /* 27: addw */
    var71.i = var69.i + var70.i;
    /* 28: convssswb */
    var72 = ORC_CLAMP_SB(var71.i);
    /* 29: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var67;
       _dest.x2[1] = var72;
       var73.i = _dest.i;
    }
    /* 30: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var73.i;
       _dest.x2[1] = var64.i;
       var74.i = _dest.i;
    }
    /* 32: addb */
    var51.x4[0] = var74.x4[0] + var50.x4[0];
    var51.x4[1] = var74.x4[1] + var50.x4[1];
    var51.x4[2] = var74.x4[2] + var50.x4[2];
    var51.x4[3] = var74.x4[3] + var50.x4[3];
    /* 33: storel */
    ptr0[i] = var51;
  }

}

void
video_orc_convert_I420_BGRA (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int p1, int p2, int p3, int p4, int p5, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 110, 
        118, 101, 114, 116, 95, 73, 52, 50, 48, 95, 66, 71, 82, 65, 11, 4, 
        4, 12, 1, 1, 12, 1, 1, 12, 1, 1, 14, 1, 128, 0, 0, 0, 
        14, 4, 128, 0, 0, 0, 14, 1, 127, 0, 0, 0, 16, 2, 16, 2, 
        16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 20, 2, 20, 2, 20, 2, 
        20, 2, 20, 1, 20, 1, 20, 1, 20, 4, 65, 38, 4, 16, 151, 32, 
        38, 45, 38, 5, 65, 38, 38, 16, 151, 33, 38, 45, 38, 6, 65, 38, 
        38, 16, 151, 34, 38, 90, 32, 32, 24, 90, 35, 34, 25, 70, 35, 32, 
        35, 159, 38, 35, 196, 35, 38, 18, 90, 37, 33, 26, 70, 37, 32, 37, 
        159, 40, 37, 90, 36, 33, 27, 70, 36, 32, 36, 90, 32, 34, 28, 70, 
        36, 36, 32, 159, 39, 36, 196, 37, 40, 39, 195, 41, 37, 35, 21, 2, 
        33, 0, 41, 17, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_I420_BGRA);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_convert_I420_BGRA");
      orc_program_set_backup_function (p, _backup_video_orc_convert_I420_BGRA);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_constant (p, 4, 0x00000080, "c2");
      orc_program_add_constant (p, 1, 0x0000007f, "c3");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 1, "t7");
      orc_program_add_temporary (p, 1, "t8");
      orc_program_add_temporary (p, 1, "t9");
      orc_program_add_temporary (p, 4, "t10");

      orc_program_append_2 (p, "subb", 0, ORC_VAR_T7, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T1, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T7, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 0, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T2, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T7, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 0, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T3, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T4, ORC_VAR_T7, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T6, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T6, ORC_VAR_T1, ORC_VAR_T6, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T5, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_P5, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T6, ORC_VAR_T9, ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T10, ORC_VAR_T6, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, ORC_VAR_T10, ORC_VAR_C2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_I420_ARGB */
#ifdef DISABLE_ORC
void
video_orc_convert_I420_ARGB (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int p1, int p2, int p3, int p4, int p5, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var42;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var43;
#else
  orc_int8 var43;
#endif
  orc_union16 var44;
  orc_union16 var45;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var46;
#else
  orc_int8 var46;
#endif
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var50;
#else
  orc_union32 var50;
#endif
  orc_union32 var51;
  orc_int8 var52;
  orc_union16 var53;
  orc_int8 var54;
  orc_int8 var55;
  orc_union16 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_union16 var59;
  orc_union16 var60;
  orc_union16 var61;
  orc_union16 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_int8 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_int8 var72;
  orc_union16 var73;
  orc_union32 var74;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;

    /* 1: loadpb */
    var43 = (int)0x00000080; /* 128 or 6.32404e-322f */
    /* 10: loadpw */
    var44.i = p1;
    /* 12: loadpw */
    var45.i = p2;
    /* 16: loadpb */
    var46 = (int)0x0000007f; /* 127 or 6.27463e-322f */
    /* 18: loadpw */
    var47.i = p3;
    /* 22: loadpw */
    var48.i = p4;
    /* 25: loadpw */
    var49.i = p5;
    /* 31: loadpb */
    var50.x4[0] = (int)0x00000080; /* 128 or 6.32404e-322f */
    var50.x4[1] = (int)0x00000080; /* 128 or 6.32404e-322f */
    var50.x4[2] = (int)0x00000080; /* 128 or 6.32404e-322f */
    var50.x4[3] = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var42 = ptr4[i];
    /* 2: subb */
    var52 = var42 - var43;
    /* 3: splatbw */
    var53.i = ((var52&0xff) << 8) | (var52&0xff);
    /* 4: loadupdb */
    var54 = ptr5[i>>1];
    /* 5: subb */
    var55 = var54 - var43;
    /* 6: splatbw */
    var56.i = ((var55&0xff) << 8) | (var55&0xff);
    /* 7: loadupdb */
    var57 = ptr6[i>>1];
    /* 8: subb */
    var58 = var57 - var43;
    /* 9: splatbw */
    var59.i = ((var58&0xff) << 8) | (var58&0xff);
    /* 11: mulhsw */
    var60.i = (var53.i * var44.i) >> 16;
    /* 13: mulhsw */
    var61.i = (var59.i * var45.i) >> 16;
    /* 14: addw */
    var62.i = var60.i + var61.i;
    /* 15: convssswb */
    var63 = ORC_CLAMP_SB(var62.i);
    /* 17: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var46;
       _dest.x2[1] = var63;
       var64.i = _dest.i;
    }
    /* 19: mulhsw */
    var65.i = (var56.i * var47.i) >> 16;
    /* 20: addw */
    var66.i = var60.i + var65.i;
    /* 21: convssswb */
    var67 = ORC_CLAMP_SB(var66.i);
    /* 23: mulhsw */
    var68.i = (var56.i * var48.i) >> 16;
    /* 24: addw */
    var69.i = var60.i + var68.i;
    /* 26: mulhsw */
    var70.i = (var59.i * var49.i) >> 16;
    /* 27: addw */
    var71.i = var69.i + var70.i;
    /* 28: convssswb */
    var72 = ORC_CLAMP_SB(var71.i);
    /* 29: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var72;
       _dest.x2[1] = var67;
       var73.i = _dest.i;
    }
    /* 30: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var64.i;
       _dest.x2[1] = var73.i;
       var74.i = _dest.i;
    }
    /* 32: addb */
    var51.x4[0] = var74.x4[0] + var50.x4[0];
    var51.x4[1] = var74.x4[1] + var50.x4[1];
    var51.x4[2] = var74.x4[2] + var50.x4[2];
    var51.x4[3] = var74.x4[3] + var50.x4[3];
    /* 33: storel */
    ptr0[i] = var51;
  }

}

#else
static void
_backup_video_orc_convert_I420_ARGB (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  orc_int8 var42;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var43;
#else
  orc_int8 var43;
#endif
  orc_union16 var44;
  orc_union16 var45;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_int8 var46;
#else
  orc_int8 var46;
#endif
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var50;
#else
  orc_union32 var50;
#endif
  orc_union32 var51;
  orc_int8 var52;
  orc_union16 var53;
  orc_int8 var54;
  orc_int8 var55;
  orc_union16 var56;
  orc_int8 var57;
  orc_int8 var58;
  orc_union16 var59;
  orc_union16 var60;
  orc_union16 var61;
  orc_union16 var62;
  orc_int8 var63;
  orc_union16 var64;
  orc_union16 var65;
  orc_union16 var66;
  orc_int8 var67;
  orc_union16 var68;
  orc_union16 var69;
  orc_union16 var70;
  orc_union16 var71;
  orc_int8 var72;
  orc_union16 var73;
  orc_union32 var74;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

    /* 1: loadpb */
    var43 = (int)0x00000080; /* 128 or 6.32404e-322f */
    /* 10: loadpw */
    var44.i = ex->params[24];
    /* 12: loadpw */
    var45.i = ex->params[25];
    /* 16: loadpb */
    var46 = (int)0x0000007f; /* 127 or 6.27463e-322f */
    /* 18: loadpw */
    var47.i = ex->params[26];
    /* 22: loadpw */
    var48.i = ex->params[27];
    /* 25: loadpw */
    var49.i = ex->params[28];
    /* 31: loadpb */
    var50.x4[0] = (int)0x00000080; /* 128 or 6.32404e-322f */
    var50.x4[1] = (int)0x00000080; /* 128 or 6.32404e-322f */
    var50.x4[2] = (int)0x00000080; /* 128 or 6.32404e-322f */
    var50.x4[3] = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var42 = ptr4[i];
    /* 2: subb */
    var52 = var42 - var43;
    /* 3: splatbw */
    var53.i = ((var52&0xff) << 8) | (var52&0xff);
    /* 4: loadupdb */
    var54 = ptr5[i>>1];
    /* 5: subb */
    var55 = var54 - var43;
    /* 6: splatbw */
    var56.i = ((var55&0xff) << 8) | (var55&0xff);
    /* 7: loadupdb */
    var57 = ptr6[i>>1];
    /* 8: subb */
    var58 = var57 - var43;
    /* 9: splatbw */
    var59.i = ((var58&0xff) << 8) | (var58&0xff);
    /* 11: mulhsw */
    var60.i = (var53.i * var44.i) >> 16;
    /* 13: mulhsw */
    var61.i = (var59.i * var45.i) >> 16;
    /* 14: addw */
    var62.i = var60.i + var61.i;
    /* 15: convssswb */
    var63 = ORC_CLAMP_SB(var62.i);
    /* 17: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var46;
       _dest.x2[1] = var63;
       var64.i = _dest.i;
    }
    /* 19: mulhsw */
    var65.i = (var56.i * var47.i) >> 16;
    /* 20: addw */
    var66.i = var60.i + var65.i;
    /* 21: convssswb */
    var67 = ORC_CLAMP_SB(var66.i);
    /* 23: mulhsw */
    var68.i = (var56.i * var48.i) >> 16;
    /* 24: addw */
    var69.i = var60.i + var68.i;
    /* 26: mulhsw */
    var70.i = (var59.i * var49.i) >> 16;
    /* 27: addw */
    var71.i = var69.i + var70.i;
    /* 28: convssswb */
    var72 = ORC_CLAMP_SB(var71.i);
    /* 29: mergebw */
    {
       orc_union16 _dest;
       _dest.x2[0] = var72;
       _dest.x2[1] = var67;
       var73.i = _dest.i;
    }
    /* 30: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var64.i;
       _dest.x2[1] = var73.i;
       var74.i = _dest.i;
    }
    /* 32: addb */
    var51.x4[0] = var74.x4[0] + var50.x4[0];
    var51.x4[1] = var74.x4[1] + var50.x4[1];
    var51.x4[2] = var74.x4[2] + var50.x4[2];
    var51.x4[3] = var74.x4[3] + var50.x4[3];
    /* 33: storel */
    ptr0[i] = var51;
  }

}

void
video_orc_convert_I420_ARGB (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, int p1, int p2, int p3, int p4, int p5, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 110, 
        118, 101, 114, 116, 95, 73, 52, 50, 48, 95, 65, 82, 71, 66, 11, 4, 
        4, 12, 1, 1, 12, 1, 1, 12, 1, 1, 14, 1, 128, 0, 0, 0, 
        14, 4, 128, 0, 0, 0, 14, 1, 127, 0, 0, 0, 16, 2, 16, 2, 
        16, 2, 16, 2, 16, 2, 20, 2, 20, 2, 20, 2, 20, 2, 20, 2, 
        20, 2, 20, 1, 20, 1, 20, 1, 20, 4, 65, 38, 4, 16, 151, 32, 
        38, 45, 38, 5, 65, 38, 38, 16, 151, 33, 38, 45, 38, 6, 65, 38, 
        38, 16, 151, 34, 38, 90, 32, 32, 24, 90, 35, 34, 25, 70, 35, 32, 
        35, 159, 38, 35, 196, 35, 18, 38, 90, 37, 33, 26, 70, 37, 32, 37, 
        159, 40, 37, 90, 36, 33, 27, 70, 36, 32, 36, 90, 32, 34, 28, 70, 
        36, 36, 32, 159, 39, 36, 196, 37, 39, 40, 195, 41, 35, 37, 21, 2, 
        33, 0, 41, 17, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_I420_ARGB);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_convert_I420_ARGB");
      orc_program_set_backup_function (p, _backup_video_orc_convert_I420_ARGB);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_constant (p, 4, 0x00000080, "c2");
      orc_program_add_constant (p, 1, 0x0000007f, "c3");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_parameter (p, 2, "p5");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");
      orc_program_add_temporary (p, 2, "t6");
      orc_program_add_temporary (p, 1, "t7");
      orc_program_add_temporary (p, 1, "t8");
      orc_program_add_temporary (p, 1, "t9");
      orc_program_add_temporary (p, 4, "t10");

      orc_program_append_2 (p, "subb", 0, ORC_VAR_T7, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T1, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T7, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 0, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T2, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadupdb", 0, ORC_VAR_T7, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 0, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbw", 0, ORC_VAR_T3, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T7, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T4, ORC_VAR_C3, ORC_VAR_T7, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T6, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T6, ORC_VAR_T1, ORC_VAR_T6, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T9, ORC_VAR_T6, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T5, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_P5, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 0, ORC_VAR_T6, ORC_VAR_T8, ORC_VAR_T9, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T10, ORC_VAR_T4, ORC_VAR_T6, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, ORC_VAR_T10, ORC_VAR_C2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;
  ex->params[ORC_VAR_P5] = p5;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_matrix8 */
#ifdef DISABLE_ORC
void
video_orc_matrix8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, orc_int64 p1, orc_int64 p2, orc_int64 p3, orc_int64 p4, int n){
  _custom_video_orc_matrix8 (d1, s1, p1, p2, p3, p4, n);
}

#else
static void
_backup_video_orc_matrix8 (OrcExecutor * ORC_RESTRICT ex)
{
  _custom_video_orc_matrix8 (ex->arrays[ORC_VAR_D1], ex->arrays[ORC_VAR_S1], (ex->params[ORC_VAR_P1] & 0xffffffff) | ((orc_uint64)(ex->params[ORC_VAR_T1]) << 32), (ex->params[ORC_VAR_P2] & 0xffffffff) | ((orc_uint64)(ex->params[ORC_VAR_T2]) << 32), (ex->params[ORC_VAR_P3] & 0xffffffff) | ((orc_uint64)(ex->params[ORC_VAR_T3]) << 32), (ex->params[ORC_VAR_P4] & 0xffffffff) | ((orc_uint64)(ex->params[ORC_VAR_T4]) << 32), ex->n);
}

void
video_orc_matrix8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, orc_int64 p1, orc_int64 p2, orc_int64 p3, orc_int64 p4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 17, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 109, 97, 116, 
        114, 105, 120, 56, 11, 4, 4, 12, 4, 4, 14, 1, 128, 0, 0, 0, 
        18, 8, 18, 8, 18, 8, 18, 8, 20, 2, 20, 2, 20, 1, 20, 1, 
        20, 4, 20, 4, 20, 8, 20, 8, 20, 8, 20, 8, 20, 8, 134, 40, 
        24, 134, 41, 25, 134, 42, 26, 21, 2, 65, 36, 4, 16, 190, 32, 36, 
        191, 33, 36, 188, 34, 32, 189, 35, 32, 150, 32, 34, 154, 36, 32, 21, 
        2, 196, 38, 36, 36, 152, 36, 35, 194, 39, 36, 36, 21, 2, 90, 39, 
        39, 40, 21, 2, 70, 38, 38, 39, 188, 34, 33, 152, 36, 34, 194, 39, 
        36, 36, 21, 2, 90, 39, 39, 41, 21, 2, 70, 38, 38, 39, 189, 35, 
        33, 152, 36, 35, 194, 39, 36, 36, 21, 2, 90, 39, 39, 42, 21, 2, 
        70, 38, 38, 39, 21, 2, 159, 37, 38, 21, 2, 33, 0, 37, 16, 2, 
        0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_matrix8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_matrix8");
      orc_program_set_backup_function (p, _backup_video_orc_matrix8);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 1, 0x00000080, "c1");
      orc_program_add_parameter_int64 (p, 8, "p1");
      orc_program_add_parameter_int64 (p, 8, "p2");
      orc_program_add_parameter_int64 (p, 8, "p3");
      orc_program_add_parameter_int64 (p, 8, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 1, "t3");
      orc_program_add_temporary (p, 1, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 4, "t6");
      orc_program_add_temporary (p, 8, "t7");
      orc_program_add_temporary (p, 8, "t8");
      orc_program_add_temporary (p, 8, "t9");
      orc_program_add_temporary (p, 8, "t10");
      orc_program_add_temporary (p, 8, "t11");

      orc_program_append_2 (p, "loadpq", 0, ORC_VAR_T9, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadpq", 0, ORC_VAR_T10, ORC_VAR_P2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadpq", 0, ORC_VAR_T11, ORC_VAR_P3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subb", 2, ORC_VAR_T5, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0lw", 0, ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1lw", 0, ORC_VAR_T2, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T5, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergebw", 2, ORC_VAR_T7, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbl", 0, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 2, ORC_VAR_T8, ORC_VAR_T8, ORC_VAR_T9, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 2, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "select0wb", 0, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbl", 0, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 2, ORC_VAR_T8, ORC_VAR_T8, ORC_VAR_T10, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 2, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "select1wb", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "splatbl", 0, ORC_VAR_T5, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_T8, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "mulhsw", 2, ORC_VAR_T8, ORC_VAR_T8, ORC_VAR_T11, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 2, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T8, ORC_VAR_D1);
      orc_program_append_2 (p, "convssswb", 2, ORC_VAR_T6, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 2, ORC_VAR_D1, ORC_VAR_T6, ORC_VAR_C1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  {
    orc_union64 tmp;
    tmp.i = p1;
    ex->params[ORC_VAR_P1] = ((orc_uint64) tmp.i) & 0xffffffff;
    ex->params[ORC_VAR_T1] = ((orc_uint64) tmp.i) >> 32;
  }
  {
    orc_union64 tmp;
    tmp.i = p2;
    ex->params[ORC_VAR_P2] = ((orc_uint64) tmp.i) & 0xffffffff;
    ex->params[ORC_VAR_T2] = ((orc_uint64) tmp.i) >> 32;
  }
  {
    orc_union64 tmp;
    tmp.i = p3;
    ex->params[ORC_VAR_P3] = ((orc_uint64) tmp.i) & 0xffffffff;
    ex->params[ORC_VAR_T3] = ((orc_uint64) tmp.i) >> 32;
  }
  {
    orc_union64 tmp;
    tmp.i = p4;
    ex->params[ORC_VAR_P4] = ((orc_uint64) tmp.i) & 0xffffffff;
    ex->params[ORC_VAR_T4] = ((orc_uint64) tmp.i) >> 32;
  }

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_h_near_u32_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_h_near_u32_lq (guint32 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int p1, int p2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: ldresnearl */
    var32 = ptr4[(p1 + i*p2)>>16];
    /* 1: storel */
    ptr0[i] = var32;
  }

}

#else
static void
_backup_video_orc_resample_h_near_u32_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: ldresnearl */
    var32 = ptr4[(ex->params[24] + i*ex->params[25])>>16];
    /* 1: storel */
    ptr0[i] = var32;
  }

}

void
video_orc_resample_h_near_u32_lq (guint32 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 32, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 104, 95, 110, 101, 97, 114, 95, 117, 51, 50, 
        95, 108, 113, 11, 4, 4, 12, 4, 4, 16, 4, 16, 4, 49, 0, 4, 
        24, 25, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_near_u32_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_h_near_u32_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_near_u32_lq);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");

      orc_program_append_2 (p, "ldresnearl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_P1, ORC_VAR_P2);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_h_2tap_1u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_h_2tap_1u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int p2, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: ldreslinb */
    {
    int tmp = p1 + i * p2;
    var32 = ((orc_uint8)ptr4[tmp>>16] * (256-((tmp>>8)&0xff)) + (orc_uint8)ptr4[(tmp>>16)+1] * ((tmp>>8)&0xff))>>8;
    }
    /* 1: storeb */
    ptr0[i] = var32;
  }

}

#else
static void
_backup_video_orc_resample_h_2tap_1u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: ldreslinb */
    {
    int tmp = ex->params[24] + i * ex->params[25];
    var32 = ((orc_uint8)ptr4[tmp>>16] * (256-((tmp>>8)&0xff)) + (orc_uint8)ptr4[(tmp>>16)+1] * ((tmp>>8)&0xff))>>8;
    }
    /* 1: storeb */
    ptr0[i] = var32;
  }

}

void
video_orc_resample_h_2tap_1u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 32, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 104, 95, 50, 116, 97, 112, 95, 49, 117, 56, 
        95, 108, 113, 11, 1, 1, 12, 1, 1, 16, 4, 16, 4, 50, 0, 4, 
        24, 25, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_2tap_1u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_h_2tap_1u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_2tap_1u8_lq);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");

      orc_program_append_2 (p, "ldreslinb", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_P1, ORC_VAR_P2);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_h_2tap_4u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_h_2tap_4u8_lq (guint32 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int p1, int p2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: ldreslinl */
    {
    int tmp = p1 + i * p2;
    orc_union32 a = ptr4[tmp>>16];
    orc_union32 b = ptr4[(tmp>>16)+1];
    var32.x4[0] = ((orc_uint8)a.x4[0] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[0] * ((tmp>>8)&0xff))>>8;
    var32.x4[1] = ((orc_uint8)a.x4[1] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[1] * ((tmp>>8)&0xff))>>8;
    var32.x4[2] = ((orc_uint8)a.x4[2] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[2] * ((tmp>>8)&0xff))>>8;
    var32.x4[3] = ((orc_uint8)a.x4[3] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[3] * ((tmp>>8)&0xff))>>8;
    }
    /* 1: storel */
    ptr0[i] = var32;
  }

}

#else
static void
_backup_video_orc_resample_h_2tap_4u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var32;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: ldreslinl */
    {
    int tmp = ex->params[24] + i * ex->params[25];
    orc_union32 a = ptr4[tmp>>16];
    orc_union32 b = ptr4[(tmp>>16)+1];
    var32.x4[0] = ((orc_uint8)a.x4[0] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[0] * ((tmp>>8)&0xff))>>8;
    var32.x4[1] = ((orc_uint8)a.x4[1] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[1] * ((tmp>>8)&0xff))>>8;
    var32.x4[2] = ((orc_uint8)a.x4[2] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[2] * ((tmp>>8)&0xff))>>8;
    var32.x4[3] = ((orc_uint8)a.x4[3] * (256-((tmp>>8)&0xff)) + (orc_uint8)b.x4[3] * ((tmp>>8)&0xff))>>8;
    }
    /* 1: storel */
    ptr0[i] = var32;
  }

}

void
video_orc_resample_h_2tap_4u8_lq (guint32 * ORC_RESTRICT d1, const guint32 * ORC_RESTRICT s1, int p1, int p2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 32, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 104, 95, 50, 116, 97, 112, 95, 52, 117, 56, 
        95, 108, 113, 11, 4, 4, 12, 4, 4, 16, 4, 16, 4, 51, 0, 4, 
        24, 25, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_2tap_4u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_h_2tap_4u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_2tap_4u8_lq);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_parameter (p, 4, "p2");

      orc_program_append_2 (p, "ldreslinl", 0, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_P1, ORC_VAR_P2);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_h_2tap_u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_h_2tap_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const gint16 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  const orc_union16 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_union16 *)s3;
  ptr7 = (orc_union16 *)s4;

    /* 9: loadpw */
    var38.i = (int)0x00000020; /* 32 or 1.58101e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var40.i = (orc_uint8)var34;
    /* 2: loadw */
    var35 = ptr6[i];
    /* 3: mullw */
    var41.i = (var40.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var42.i = (orc_uint8)var36;
    /* 6: loadw */
    var37 = ptr7[i];
    /* 7: mullw */
    var43.i = (var42.i * var37.i) & 0xffff;
    /* 8: addw */
    var44.i = var41.i + var43.i;
    /* 10: addw */
    var45.i = var44.i + var38.i;
    /* 11: shrsw */
    var46.i = var45.i >> 6;
    /* 12: convsuswb */
    var39 = ORC_CLAMP_UB(var46.i);
    /* 13: storeb */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_video_orc_resample_h_2tap_u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  const orc_union16 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_int8 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_union16 *)ex->arrays[6];
  ptr7 = (orc_union16 *)ex->arrays[7];

    /* 9: loadpw */
    var38.i = (int)0x00000020; /* 32 or 1.58101e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var40.i = (orc_uint8)var34;
    /* 2: loadw */
    var35 = ptr6[i];
    /* 3: mullw */
    var41.i = (var40.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var42.i = (orc_uint8)var36;
    /* 6: loadw */
    var37 = ptr7[i];
    /* 7: mullw */
    var43.i = (var42.i * var37.i) & 0xffff;
    /* 8: addw */
    var44.i = var41.i + var43.i;
    /* 10: addw */
    var45.i = var44.i + var38.i;
    /* 11: shrsw */
    var46.i = var45.i >> 6;
    /* 12: convsuswb */
    var39 = ORC_CLAMP_UB(var46.i);
    /* 13: storeb */
    ptr0[i] = var39;
  }

}

void
video_orc_resample_h_2tap_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const gint16 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 104, 95, 50, 116, 97, 112, 95, 117, 56, 95, 
        108, 113, 11, 1, 1, 12, 1, 1, 12, 1, 1, 12, 2, 2, 12, 2, 
        2, 14, 2, 32, 0, 0, 0, 14, 2, 6, 0, 0, 0, 20, 2, 20, 
        2, 150, 32, 4, 89, 32, 32, 6, 150, 33, 5, 89, 33, 33, 7, 70, 
        32, 32, 33, 70, 32, 32, 16, 94, 32, 32, 17, 160, 0, 32, 2, 0, 

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_2tap_u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_h_2tap_u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_2tap_u8_lq);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_constant (p, 2, 0x00000020, "c1");
      orc_program_add_constant (p, 2, 0x00000006, "c2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_h_2tap_u16 */
#ifdef DISABLE_ORC
void
video_orc_resample_h_2tap_u16 (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, const gint16 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  const orc_union16 * ORC_RESTRICT ptr7;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var40;
#else
  orc_union32 var40;
#endif
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;
  ptr6 = (orc_union16 *)s3;
  ptr7 = (orc_union16 *)s4;

    /* 11: loadpl */
    var40.i = (int)0x00001000; /* 4096 or 2.02369e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var36 = ptr4[i];
    /* 1: convuwl */
    var42.i = (orc_uint16)var36.i;
    /* 2: loadw */
    var37 = ptr6[i];
    /* 3: convswl */
    var43.i = var37.i;
    /* 4: mulll */
    var44.i = (((orc_uint32)var42.i) * ((orc_uint32)var43.i)) & 0xffffffff;
    /* 5: loadw */
    var38 = ptr5[i];
    /* 6: convuwl */
    var45.i = (orc_uint16)var38.i;
    /* 7: loadw */
    var39 = ptr7[i];
    /* 8: convswl */
    var46.i = var39.i;
    /* 9: mulll */
    var47.i = (((orc_uint32)var45.i) * ((orc_uint32)var46.i)) & 0xffffffff;
    /* 10: addl */
    var48.i = ((orc_uint32)var44.i) + ((orc_uint32)var47.i);
    /* 12: addl */
    var49.i = ((orc_uint32)var48.i) + ((orc_uint32)var40.i);
    /* 13: shrsl */
    var50.i = var49.i >> 12;
    /* 14: convsuslw */
    var41.i = ORC_CLAMP_UW(var50.i);
    /* 15: storew */
    ptr0[i] = var41;
  }

}

#else
static void
_backup_video_orc_resample_h_2tap_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  const orc_union16 * ORC_RESTRICT ptr6;
  const orc_union16 * ORC_RESTRICT ptr7;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var40;
#else
  orc_union32 var40;
#endif
  orc_union16 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union32 var49;
  orc_union32 var50;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];
  ptr6 = (orc_union16 *)ex->arrays[6];
  ptr7 = (orc_union16 *)ex->arrays[7];

    /* 11: loadpl */
    var40.i = (int)0x00001000; /* 4096 or 2.02369e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var36 = ptr4[i];
    /* 1: convuwl */
    var42.i = (orc_uint16)var36.i;
    /* 2: loadw */
    var37 = ptr6[i];
    /* 3: convswl */
    var43.i = var37.i;
    /* 4: mulll */
    var44.i = (((orc_uint32)var42.i) * ((orc_uint32)var43.i)) & 0xffffffff;
    /* 5: loadw */
    var38 = ptr5[i];
    /* 6: convuwl */
    var45.i = (orc_uint16)var38.i;
    /* 7: loadw */
    var39 = ptr7[i];
    /* 8: convswl */
    var46.i = var39.i;
    /* 9: mulll */
    var47.i = (((orc_uint32)var45.i) * ((orc_uint32)var46.i)) & 0xffffffff;
    /* 10: addl */
    var48.i = ((orc_uint32)var44.i) + ((orc_uint32)var47.i);
    /* 12: addl */
    var49.i = ((orc_uint32)var48.i) + ((orc_uint32)var40.i);
    /* 13: shrsl */
    var50.i = var49.i >> 12;
    /* 14: convsuslw */
    var41.i = ORC_CLAMP_UW(var50.i);
    /* 15: storew */
    ptr0[i] = var41;
  }

}

void
video_orc_resample_h_2tap_u16 (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, const gint16 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 29, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 104, 95, 50, 116, 97, 112, 95, 117, 49, 54, 
        11, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 12, 2, 2, 14, 
        4, 0, 16, 0, 0, 14, 4, 12, 0, 0, 0, 20, 4, 20, 4, 20, 
        4, 20, 4, 154, 32, 4, 153, 34, 6, 120, 32, 32, 34, 154, 33, 5, 
        153, 35, 7, 120, 33, 33, 35, 103, 32, 32, 33, 103, 32, 32, 16, 125, 
        32, 32, 17, 166, 0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_2tap_u16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_h_2tap_u16");
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_2tap_u16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_source (p, 2, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_constant (p, 4, 0x00001000, "c1");
      orc_program_add_constant (p, 4, 0x0000000c, "c2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convswl", 0, ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convswl", 0, ORC_VAR_T4, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuslw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_v_2tap_u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_v_2tap_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int p1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_int8 var46;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;

    /* 5: loadpw */
    var37.i = p1;
    /* 7: loadpw */
    var38.i = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr4[i];
    /* 1: convubw */
    var41.i = (orc_uint8)var35;
    /* 2: loadb */
    var36 = ptr5[i];
    /* 3: convubw */
    var42.i = (orc_uint8)var36;
    /* 4: subw */
    var43.i = var42.i - var41.i;
    /* 6: mullw */
    var44.i = (var43.i * var37.i) & 0xffff;
    /* 8: addw */
    var45.i = var44.i + var38.i;
    /* 9: convhwb */
    var46 = ((orc_uint16)var45.i)>>8;
    /* 10: loadb */
    var39 = ptr4[i];
    /* 11: addb */
    var40 = var46 + var39;
    /* 12: storeb */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_video_orc_resample_v_2tap_u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var35;
  orc_int8 var36;
  orc_union16 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var38;
#else
  orc_union16 var38;
#endif
  orc_int8 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_int8 var46;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];

    /* 5: loadpw */
    var37.i = ex->params[24];
    /* 7: loadpw */
    var38.i = (int)0x00000080; /* 128 or 6.32404e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var35 = ptr4[i];
    /* 1: convubw */
    var41.i = (orc_uint8)var35;
    /* 2: loadb */
    var36 = ptr5[i];
    /* 3: convubw */
    var42.i = (orc_uint8)var36;
    /* 4: subw */
    var43.i = var42.i - var41.i;
    /* 6: mullw */
    var44.i = (var43.i * var37.i) & 0xffff;
    /* 8: addw */
    var45.i = var44.i + var38.i;
    /* 9: convhwb */
    var46 = ((orc_uint16)var45.i)>>8;
    /* 10: loadb */
    var39 = ptr4[i];
    /* 11: addb */
    var40 = var46 + var39;
    /* 12: storeb */
    ptr0[i] = var40;
  }

}

void
video_orc_resample_v_2tap_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 118, 95, 50, 116, 97, 112, 95, 117, 56, 95, 
        108, 113, 11, 1, 1, 12, 1, 1, 12, 1, 1, 14, 2, 128, 0, 0, 
        0, 16, 2, 20, 1, 20, 2, 20, 2, 150, 33, 4, 150, 34, 5, 98, 
        34, 34, 33, 89, 34, 34, 24, 70, 34, 34, 16, 158, 32, 34, 33, 0, 
        32, 4, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_2tap_u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_v_2tap_u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_2tap_u8_lq);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_constant (p, 2, 0x00000080, "c1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T3, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "convhwb", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_v_2tap_u16 */
#ifdef DISABLE_ORC
void
video_orc_resample_v_2tap_u16 (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, int p1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;

    /* 5: loadpw */
    var37.i = p1;
    /* 8: loadpl */
    var38.i = (int)0x00001000; /* 4096 or 2.02369e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr4[i];
    /* 1: convuwl */
    var40.i = (orc_uint16)var35.i;
    /* 2: loadw */
    var36 = ptr5[i];
    /* 3: convuwl */
    var41.i = (orc_uint16)var36.i;
    /* 4: subl */
    var42.i = ((orc_uint32)var41.i) - ((orc_uint32)var40.i);
    /* 6: convuwl */
    var43.i = (orc_uint16)var37.i;
    /* 7: mulll */
    var44.i = (((orc_uint32)var42.i) * ((orc_uint32)var43.i)) & 0xffffffff;
    /* 9: addl */
    var45.i = ((orc_uint32)var44.i) + ((orc_uint32)var38.i);
    /* 10: shrsl */
    var46.i = var45.i >> 12;
    /* 11: addl */
    var47.i = ((orc_uint32)var40.i) + ((orc_uint32)var46.i);
    /* 12: convsuslw */
    var39.i = ORC_CLAMP_UW(var47.i);
    /* 13: storew */
    ptr0[i] = var39;
  }

}

#else
static void
_backup_video_orc_resample_v_2tap_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var38;
#else
  orc_union32 var38;
#endif
  orc_union16 var39;
  orc_union32 var40;
  orc_union32 var41;
  orc_union32 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];

    /* 5: loadpw */
    var37.i = ex->params[24];
    /* 8: loadpl */
    var38.i = (int)0x00001000; /* 4096 or 2.02369e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var35 = ptr4[i];
    /* 1: convuwl */
    var40.i = (orc_uint16)var35.i;
    /* 2: loadw */
    var36 = ptr5[i];
    /* 3: convuwl */
    var41.i = (orc_uint16)var36.i;
    /* 4: subl */
    var42.i = ((orc_uint32)var41.i) - ((orc_uint32)var40.i);
    /* 6: convuwl */
    var43.i = (orc_uint16)var37.i;
    /* 7: mulll */
    var44.i = (((orc_uint32)var42.i) * ((orc_uint32)var43.i)) & 0xffffffff;
    /* 9: addl */
    var45.i = ((orc_uint32)var44.i) + ((orc_uint32)var38.i);
    /* 10: shrsl */
    var46.i = var45.i >> 12;
    /* 11: addl */
    var47.i = ((orc_uint32)var40.i) + ((orc_uint32)var46.i);
    /* 12: convsuslw */
    var39.i = ORC_CLAMP_UW(var47.i);
    /* 13: storew */
    ptr0[i] = var39;
  }

}

void
video_orc_resample_v_2tap_u16 (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 29, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 118, 95, 50, 116, 97, 112, 95, 117, 49, 54, 
        11, 2, 2, 12, 2, 2, 12, 2, 2, 14, 4, 0, 16, 0, 0, 14, 
        4, 12, 0, 0, 0, 16, 2, 20, 4, 20, 4, 20, 4, 154, 32, 4, 
        154, 33, 5, 129, 33, 33, 32, 154, 34, 24, 120, 33, 33, 34, 103, 33, 
        33, 16, 125, 33, 33, 17, 103, 32, 32, 33, 166, 0, 32, 2, 0,       };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_2tap_u16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_v_2tap_u16");
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_2tap_u16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 4, 0x00001000, "c1");
      orc_program_add_constant (p, 4, 0x0000000c, "c2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuslw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_v_2tap_u8 */
#ifdef DISABLE_ORC
void
video_orc_resample_v_2tap_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int p1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var40;
#else
  orc_union32 var40;
#endif
  orc_int8 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;

    /* 5: loadpw */
    var39.i = p1;
    /* 7: loadpl */
    var40.i = (int)0x00000fff; /* 4095 or 2.0232e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var37 = ptr4[i];
    /* 1: convubw */
    var42.i = (orc_uint8)var37;
    /* 2: loadb */
    var38 = ptr5[i];
    /* 3: convubw */
    var43.i = (orc_uint8)var38;
    /* 4: subw */
    var44.i = var43.i - var42.i;
    /* 6: mulswl */
    var45.i = var44.i * var39.i;
    /* 8: addl */
    var46.i = ((orc_uint32)var45.i) + ((orc_uint32)var40.i);
    /* 9: shrsl */
    var47.i = var46.i >> 12;
    /* 10: convlw */
    var48.i = var47.i;
    /* 11: addw */
    var49.i = var48.i + var42.i;
    /* 12: convsuswb */
    var41 = ORC_CLAMP_UB(var49.i);
    /* 13: storeb */
    ptr0[i] = var41;
  }

}

#else
static void
_backup_video_orc_resample_v_2tap_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  orc_int8 var37;
  orc_int8 var38;
  orc_union16 var39;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var40;
#else
  orc_union32 var40;
#endif
  orc_int8 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];

    /* 5: loadpw */
    var39.i = ex->params[24];
    /* 7: loadpl */
    var40.i = (int)0x00000fff; /* 4095 or 2.0232e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var37 = ptr4[i];
    /* 1: convubw */
    var42.i = (orc_uint8)var37;
    /* 2: loadb */
    var38 = ptr5[i];
    /* 3: convubw */
    var43.i = (orc_uint8)var38;
    /* 4: subw */
    var44.i = var43.i - var42.i;
    /* 6: mulswl */
    var45.i = var44.i * var39.i;
    /* 8: addl */
    var46.i = ((orc_uint32)var45.i) + ((orc_uint32)var40.i);
    /* 9: shrsl */
    var47.i = var46.i >> 12;
    /* 10: convlw */
    var48.i = var47.i;
    /* 11: addw */
    var49.i = var48.i + var42.i;
    /* 12: convsuswb */
    var41 = ORC_CLAMP_UB(var49.i);
    /* 13: storeb */
    ptr0[i] = var41;
  }

}

void
video_orc_resample_v_2tap_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 28, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 118, 95, 50, 116, 97, 112, 95, 117, 56, 11, 
        1, 1, 12, 1, 1, 12, 1, 1, 14, 4, 255, 15, 0, 0, 14, 4, 
        12, 0, 0, 0, 16, 2, 20, 1, 20, 2, 20, 2, 20, 4, 20, 4, 
        150, 33, 4, 150, 34, 5, 98, 34, 34, 33, 176, 36, 34, 24, 103, 36, 
        36, 16, 125, 36, 36, 17, 163, 34, 36, 70, 34, 34, 33, 160, 0, 34, 
        2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_2tap_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_v_2tap_u8");
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_2tap_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_constant (p, 4, 0x00000fff, "c1");
      orc_program_add_constant (p, 4, 0x0000000c, "c2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T3, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "subw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convlw", 0, ORC_VAR_T3, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_v_4tap_u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_v_4tap_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int p2, int p3, int p4, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;
  orc_union16 var56;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_int8 *)s4;

    /* 2: loadpw */
    var35.i = p1;
    /* 6: loadpw */
    var37.i = p2;
    /* 11: loadpw */
    var39.i = p3;
    /* 16: loadpw */
    var41.i = p4;
    /* 19: loadpw */
    var42.i = (int)0x00000020; /* 32 or 1.58101e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var44.i = (orc_uint8)var34;
    /* 3: mullw */
    var45.i = (var44.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var46.i = (orc_uint8)var36;
    /* 7: mullw */
    var47.i = (var46.i * var37.i) & 0xffff;
    /* 8: addw */
    var48.i = var45.i + var47.i;
    /* 9: loadb */
    var38 = ptr6[i];
    /* 10: convubw */
    var49.i = (orc_uint8)var38;
    /* 12: mullw */
    var50.i = (var49.i * var39.i) & 0xffff;
    /* 13: addw */
    var51.i = var48.i + var50.i;
    /* 14: loadb */
    var40 = ptr7[i];
    /* 15: convubw */
    var52.i = (orc_uint8)var40;
    /* 17: mullw */
    var53.i = (var52.i * var41.i) & 0xffff;
    /* 18: addw */
    var54.i = var51.i + var53.i;
    /* 20: addw */
    var55.i = var54.i + var42.i;
    /* 21: shrsw */
    var56.i = var55.i >> 6;
    /* 22: convsuswb */
    var43 = ORC_CLAMP_UB(var56.i);
    /* 23: storeb */
    ptr0[i] = var43;
  }

}

#else
static void
_backup_video_orc_resample_v_4tap_u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var42;
#else
  orc_union16 var42;
#endif
  orc_int8 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;
  orc_union16 var56;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];

    /* 2: loadpw */
    var35.i = ex->params[24];
    /* 6: loadpw */
    var37.i = ex->params[25];
    /* 11: loadpw */
    var39.i = ex->params[26];
    /* 16: loadpw */
    var41.i = ex->params[27];
    /* 19: loadpw */
    var42.i = (int)0x00000020; /* 32 or 1.58101e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var44.i = (orc_uint8)var34;
    /* 3: mullw */
    var45.i = (var44.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var46.i = (orc_uint8)var36;
    /* 7: mullw */
    var47.i = (var46.i * var37.i) & 0xffff;
    /* 8: addw */
    var48.i = var45.i + var47.i;
    /* 9: loadb */
    var38 = ptr6[i];
    /* 10: convubw */
    var49.i = (orc_uint8)var38;
    /* 12: mullw */
    var50.i = (var49.i * var39.i) & 0xffff;
    /* 13: addw */
    var51.i = var48.i + var50.i;
    /* 14: loadb */
    var40 = ptr7[i];
    /* 15: convubw */
    var52.i = (orc_uint8)var40;
    /* 17: mullw */
    var53.i = (var52.i * var41.i) & 0xffff;
    /* 18: addw */
    var54.i = var51.i + var53.i;
    /* 20: addw */
    var55.i = var54.i + var42.i;
    /* 21: shrsw */
    var56.i = var55.i >> 6;
    /* 22: convsuswb */
    var43 = ORC_CLAMP_UB(var56.i);
    /* 23: storeb */
    ptr0[i] = var43;
  }

}

void
video_orc_resample_v_4tap_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int p2, int p3, int p4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 118, 95, 52, 116, 97, 112, 95, 117, 56, 95, 
        108, 113, 11, 1, 1, 12, 1, 1, 12, 1, 1, 12, 1, 1, 12, 1, 
        1, 14, 2, 32, 0, 0, 0, 14, 2, 6, 0, 0, 0, 16, 2, 16, 
        2, 16, 2, 16, 2, 20, 2, 20, 2, 150, 32, 4, 89, 32, 32, 24, 
        150, 33, 5, 89, 33, 33, 25, 70, 32, 32, 33, 150, 33, 6, 89, 33, 
        33, 26, 70, 32, 32, 33, 150, 33, 7, 89, 33, 33, 27, 70, 32, 32, 
        33, 70, 32, 32, 16, 94, 32, 32, 17, 160, 0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_4tap_u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_v_4tap_u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_4tap_u8_lq);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 0x00000020, "c1");
      orc_program_add_constant (p, 2, 0x00000006, "c2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_v_4tap_u8 */
#ifdef DISABLE_ORC
void
video_orc_resample_v_4tap_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int p2, int p3, int p4, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_int8 var42;
  orc_union16 var43;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var44;
#else
  orc_union32 var44;
#endif
  orc_int8 var45;
  orc_union16 var46;
  orc_union32 var47;
  orc_union16 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;
  orc_union32 var52;
  orc_union32 var53;
  orc_union16 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_union32 var58;
  orc_union16 var59;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_int8 *)s4;

    /* 2: loadpw */
    var37.i = p1;
    /* 6: loadpw */
    var39.i = p2;
    /* 11: loadpw */
    var41.i = p3;
    /* 16: loadpw */
    var43.i = p4;
    /* 19: loadpl */
    var44.i = (int)0x00000fff; /* 4095 or 2.0232e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var36 = ptr4[i];
    /* 1: convubw */
    var46.i = (orc_uint8)var36;
    /* 3: mulswl */
    var47.i = var46.i * var37.i;
    /* 4: loadb */
    var38 = ptr5[i];
    /* 5: convubw */
    var48.i = (orc_uint8)var38;
    /* 7: mulswl */
    var49.i = var48.i * var39.i;
    /* 8: addl */
    var50.i = ((orc_uint32)var47.i) + ((orc_uint32)var49.i);
    /* 9: loadb */
    var40 = ptr6[i];
    /* 10: convubw */
    var51.i = (orc_uint8)var40;
    /* 12: mulswl */
    var52.i = var51.i * var41.i;
    /* 13: addl */
    var53.i = ((orc_uint32)var50.i) + ((orc_uint32)var52.i);
    /* 14: loadb */
    var42 = ptr7[i];
    /* 15: convubw */
    var54.i = (orc_uint8)var42;
    /* 17: mulswl */
    var55.i = var54.i * var43.i;
    /* 18: addl */
    var56.i = ((orc_uint32)var53.i) + ((orc_uint32)var55.i);
    /* 20: addl */
    var57.i = ((orc_uint32)var56.i) + ((orc_uint32)var44.i);
    /* 21: shrsl */
    var58.i = var57.i >> 12;
    /* 22: convsuslw */
    var59.i = ORC_CLAMP_UW(var58.i);
    /* 23: convsuswb */
    var45 = ORC_CLAMP_UB(var59.i);
    /* 24: storeb */
    ptr0[i] = var45;
  }

}

#else
static void
_backup_video_orc_resample_v_4tap_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_int8 var42;
  orc_union16 var43;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var44;
#else
  orc_union32 var44;
#endif
  orc_int8 var45;
  orc_union16 var46;
  orc_union32 var47;
  orc_union16 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union16 var51;
  orc_union32 var52;
  orc_union32 var53;
  orc_union16 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_union32 var58;
  orc_union16 var59;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];

    /* 2: loadpw */
    var37.i = ex->params[24];
    /* 6: loadpw */
    var39.i = ex->params[25];
    /* 11: loadpw */
    var41.i = ex->params[26];
    /* 16: loadpw */
    var43.i = ex->params[27];
    /* 19: loadpl */
    var44.i = (int)0x00000fff; /* 4095 or 2.0232e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var36 = ptr4[i];
    /* 1: convubw */
    var46.i = (orc_uint8)var36;
    /* 3: mulswl */
    var47.i = var46.i * var37.i;
    /* 4: loadb */
    var38 = ptr5[i];
    /* 5: convubw */
    var48.i = (orc_uint8)var38;
    /* 7: mulswl */
    var49.i = var48.i * var39.i;
    /* 8: addl */
    var50.i = ((orc_uint32)var47.i) + ((orc_uint32)var49.i);
    /* 9: loadb */
    var40 = ptr6[i];
    /* 10: convubw */
    var51.i = (orc_uint8)var40;
    /* 12: mulswl */
    var52.i = var51.i * var41.i;
    /* 13: addl */
    var53.i = ((orc_uint32)var50.i) + ((orc_uint32)var52.i);
    /* 14: loadb */
    var42 = ptr7[i];
    /* 15: convubw */
    var54.i = (orc_uint8)var42;
    /* 17: mulswl */
    var55.i = var54.i * var43.i;
    /* 18: addl */
    var56.i = ((orc_uint32)var53.i) + ((orc_uint32)var55.i);
    /* 20: addl */
    var57.i = ((orc_uint32)var56.i) + ((orc_uint32)var44.i);
    /* 21: shrsl */
    var58.i = var57.i >> 12;
    /* 22: convsuslw */
    var59.i = ORC_CLAMP_UW(var58.i);
    /* 23: convsuswb */
    var45 = ORC_CLAMP_UB(var59.i);
    /* 24: storeb */
    ptr0[i] = var45;
  }

}

void
video_orc_resample_v_4tap_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int p2, int p3, int p4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 28, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 118, 95, 52, 116, 97, 112, 95, 117, 56, 11, 
        1, 1, 12, 1, 1, 12, 1, 1, 12, 1, 1, 12, 1, 1, 14, 4, 
        255, 15, 0, 0, 14, 4, 12, 0, 0, 0, 16, 2, 16, 2, 16, 2, 
        16, 2, 20, 2, 20, 2, 20, 4, 20, 4, 150, 32, 4, 176, 34, 32, 
        24, 150, 33, 5, 176, 35, 33, 25, 103, 34, 34, 35, 150, 33, 6, 176, 
        35, 33, 26, 103, 34, 34, 35, 150, 33, 7, 176, 35, 33, 27, 103, 34, 
        34, 35, 103, 34, 34, 16, 125, 34, 34, 17, 166, 32, 34, 160, 0, 32, 
        2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_4tap_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_v_4tap_u8");
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_4tap_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 4, 0x00000fff, "c1");
      orc_program_add_constant (p, 4, 0x0000000c, "c2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuslw", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_h_multaps_u8 */
#ifdef DISABLE_ORC
void
video_orc_resample_h_multaps_u8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const gint16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_int8 var33;
  orc_union16 var34;
  orc_union32 var35;
  orc_union16 var36;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_union16 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 2: loadw */
    var34 = ptr5[i];
    /* 3: mulswl */
    var35.i = var36.i * var34.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_video_orc_resample_h_multaps_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_int8 var33;
  orc_union16 var34;
  orc_union32 var35;
  orc_union16 var36;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 2: loadw */
    var34 = ptr5[i];
    /* 3: mulswl */
    var35.i = var36.i * var34.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
video_orc_resample_h_multaps_u8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const gint16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 104, 95, 109, 117, 108, 116, 97, 112, 115, 95, 
        117, 56, 11, 4, 4, 12, 1, 1, 12, 2, 2, 20, 2, 150, 32, 4, 
        176, 0, 32, 5, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_multaps_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_h_multaps_u8");
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_multaps_u8);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_h_muladdtaps_u8 */
#ifdef DISABLE_ORC
void
video_orc_resample_h_muladdtaps_u8 (gint32 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const gint16 * ORC_RESTRICT s2, int s2_stride, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union16 var38;
  orc_union32 var39;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var38.i = (orc_uint8)var34;
      /* 2: loadw */
      var35 = ptr5[i];
      /* 3: mulswl */
      var39.i = var38.i * var35.i;
      /* 4: loadl */
      var36 = ptr0[i];
      /* 5: addl */
      var37.i = ((orc_uint32)var36.i) + ((orc_uint32)var39.i);
      /* 6: storel */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_video_orc_resample_h_muladdtaps_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union16 var38;
  orc_union32 var39;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var34 = ptr4[i];
      /* 1: convubw */
      var38.i = (orc_uint8)var34;
      /* 2: loadw */
      var35 = ptr5[i];
      /* 3: mulswl */
      var39.i = var38.i * var35.i;
      /* 4: loadl */
      var36 = ptr0[i];
      /* 5: addl */
      var37.i = ((orc_uint32)var36.i) + ((orc_uint32)var39.i);
      /* 6: storel */
      ptr0[i] = var37;
    }
  }

}

void
video_orc_resample_h_muladdtaps_u8 (gint32 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const gint16 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 34, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 
        115, 97, 109, 112, 108, 101, 95, 104, 95, 109, 117, 108, 97, 100, 100, 116, 
        97, 112, 115, 95, 117, 56, 11, 4, 4, 12, 1, 1, 12, 2, 2, 20, 
        2, 20, 4, 150, 32, 4, 176, 33, 32, 5, 103, 0, 0, 33, 2, 0, 

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_muladdtaps_u8);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_resample_h_muladdtaps_u8");
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_muladdtaps_u8);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_scaletaps_u8 */
#ifdef DISABLE_ORC
void
video_orc_resample_scaletaps_u8 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_int8 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var35.i = (int)0x00000fff; /* 4095 or 2.0232e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: addl */
    var37.i = ((orc_uint32)var34.i) + ((orc_uint32)var35.i);
    /* 3: shrsl */
    var38.i = var37.i >> 12;
    /* 4: convsuslw */
    var39.i = ORC_CLAMP_UW(var38.i);
    /* 5: convsuswb */
    var36 = ORC_CLAMP_UB(var39.i);
    /* 6: storeb */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_video_orc_resample_scaletaps_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var34;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var35;
#else
  orc_union32 var35;
#endif
  orc_int8 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union16 var39;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var35.i = (int)0x00000fff; /* 4095 or 2.0232e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var34 = ptr4[i];
    /* 2: addl */
    var37.i = ((orc_uint32)var34.i) + ((orc_uint32)var35.i);
    /* 3: shrsl */
    var38.i = var37.i >> 12;
    /* 4: convsuslw */
    var39.i = ORC_CLAMP_UW(var38.i);
    /* 5: convsuswb */
    var36 = ORC_CLAMP_UB(var39.i);
    /* 6: storeb */
    ptr0[i] = var36;
  }

}

void
video_orc_resample_scaletaps_u8 (guint8 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 115, 99, 97, 108, 101, 116, 97, 112, 115, 95, 
        117, 56, 11, 1, 1, 12, 4, 4, 14, 4, 255, 15, 0, 0, 14, 4, 
        12, 0, 0, 0, 20, 2, 20, 4, 103, 33, 4, 16, 125, 33, 33, 17, 
        166, 32, 33, 160, 0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_scaletaps_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_scaletaps_u8");
      orc_program_set_backup_function (p, _backup_video_orc_resample_scaletaps_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000fff, "c1");
      orc_program_add_constant (p, 4, 0x0000000c, "c2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "addl", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuslw", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_h_multaps_u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_h_multaps_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const gint16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_union16 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 2: loadw */
    var34 = ptr5[i];
    /* 3: mullw */
    var35.i = (var36.i * var34.i) & 0xffff;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_video_orc_resample_h_multaps_u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 2: loadw */
    var34 = ptr5[i];
    /* 3: mullw */
    var35.i = (var36.i * var34.i) & 0xffff;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

void
video_orc_resample_h_multaps_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const gint16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 34, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 104, 95, 109, 117, 108, 116, 97, 112, 115, 95, 
        117, 56, 95, 108, 113, 11, 2, 2, 12, 1, 1, 12, 2, 2, 20, 2, 
        150, 32, 4, 89, 0, 32, 5, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_multaps_u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_h_multaps_u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_multaps_u8_lq);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_h_muladdtaps_u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_h_muladdtaps_u8_lq (gint16 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const gint16 * ORC_RESTRICT s2, int s2_stride, int n, int m){
  int i;
  int j;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: convubw */
      var37.i = (orc_uint8)var33;
      /* 2: loadw */
      var34 = ptr5[i];
      /* 3: mullw */
      var38.i = (var37.i * var34.i) & 0xffff;
      /* 4: loadw */
      var35 = ptr0[i];
      /* 5: addw */
      var36.i = var35.i + var38.i;
      /* 6: storew */
      ptr0[i] = var36;
    }
  }

}

#else
static void
_backup_video_orc_resample_h_muladdtaps_u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadb */
      var33 = ptr4[i];
      /* 1: convubw */
      var37.i = (orc_uint8)var33;
      /* 2: loadw */
      var34 = ptr5[i];
      /* 3: mullw */
      var38.i = (var37.i * var34.i) & 0xffff;
      /* 4: loadw */
      var35 = ptr0[i];
      /* 5: addw */
      var36.i = var35.i + var38.i;
      /* 6: storew */
      ptr0[i] = var36;
    }
  }

}

void
video_orc_resample_h_muladdtaps_u8_lq (gint16 * ORC_RESTRICT d1, int d1_stride, const guint8 * ORC_RESTRICT s1, int s1_stride, const gint16 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 37, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 
        115, 97, 109, 112, 108, 101, 95, 104, 95, 109, 117, 108, 97, 100, 100, 116, 
        97, 112, 115, 95, 117, 56, 95, 108, 113, 11, 2, 2, 12, 1, 1, 12, 
        2, 2, 20, 2, 150, 32, 4, 89, 32, 32, 5, 70, 0, 0, 32, 2, 
        0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_muladdtaps_u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_resample_h_muladdtaps_u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_muladdtaps_u8_lq);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_h_multaps3_u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_h_multaps3_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, const gint16 * ORC_RESTRICT s5, const gint16 * ORC_RESTRICT s6, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_union16 * ORC_RESTRICT ptr7;
  const orc_union16 * ORC_RESTRICT ptr8;
  const orc_union16 * ORC_RESTRICT ptr9;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_union16 *)s4;
  ptr8 = (orc_union16 *)s5;
  ptr9 = (orc_union16 *)s6;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var41.i = (orc_uint8)var34;
    /* 2: loadw */
    var35 = ptr7[i];
    /* 3: mullw */
    var42.i = (var41.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var43.i = (orc_uint8)var36;
    /* 6: loadw */
    var37 = ptr8[i];
    /* 7: mullw */
    var44.i = (var43.i * var37.i) & 0xffff;
    /* 8: addw */
    var45.i = var42.i + var44.i;
    /* 9: loadb */
    var38 = ptr6[i];
    /* 10: convubw */
    var46.i = (orc_uint8)var38;
    /* 11: loadw */
    var39 = ptr9[i];
    /* 12: mullw */
    var47.i = (var46.i * var39.i) & 0xffff;
    /* 13: addw */
    var40.i = var45.i + var47.i;
    /* 14: storew */
    ptr0[i] = var40;
  }

}

#else
static void
_backup_video_orc_resample_h_multaps3_u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_union16 * ORC_RESTRICT ptr7;
  const orc_union16 * ORC_RESTRICT ptr8;
  const orc_union16 * ORC_RESTRICT ptr9;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_union16 *)ex->arrays[7];
  ptr8 = (orc_union16 *)ex->arrays[8];
  ptr9 = (orc_union16 *)ex->arrays[9];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var41.i = (orc_uint8)var34;
    /* 2: loadw */
    var35 = ptr7[i];
    /* 3: mullw */
    var42.i = (var41.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var43.i = (orc_uint8)var36;
    /* 6: loadw */
    var37 = ptr8[i];
    /* 7: mullw */
    var44.i = (var43.i * var37.i) & 0xffff;
    /* 8: addw */
    var45.i = var42.i + var44.i;
    /* 9: loadb */
    var38 = ptr6[i];
    /* 10: convubw */
    var46.i = (orc_uint8)var38;
    /* 11: loadw */
    var39 = ptr9[i];
    /* 12: mullw */
    var47.i = (var46.i * var39.i) & 0xffff;
    /* 13: addw */
    var40.i = var45.i + var47.i;
    /* 14: storew */
    ptr0[i] = var40;
  }

}

void
video_orc_resample_h_multaps3_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, const gint16 * ORC_RESTRICT s5, const gint16 * ORC_RESTRICT s6, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 35, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 104, 95, 109, 117, 108, 116, 97, 112, 115, 51, 
        95, 117, 56, 95, 108, 113, 11, 2, 2, 12, 1, 1, 12, 1, 1, 12, 
        1, 1, 12, 2, 2, 12, 2, 2, 12, 2, 2, 20, 2, 20, 2, 150, 
        32, 4, 89, 32, 32, 7, 150, 33, 5, 89, 33, 33, 8, 70, 32, 32, 
        33, 150, 33, 6, 89, 33, 33, 9, 70, 0, 32, 33, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_multaps3_u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_h_multaps3_u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_multaps3_u8_lq);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_source (p, 2, "s5");
      orc_program_add_source (p, 2, "s6");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_S5, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_S6, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->arrays[ORC_VAR_S5] = (void *)s5;
  ex->arrays[ORC_VAR_S6] = (void *)s6;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_h_muladdtaps3_u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_h_muladdtaps3_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, const gint16 * ORC_RESTRICT s5, const gint16 * ORC_RESTRICT s6, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_union16 * ORC_RESTRICT ptr7;
  const orc_union16 * ORC_RESTRICT ptr8;
  const orc_union16 * ORC_RESTRICT ptr9;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_union16 *)s4;
  ptr8 = (orc_union16 *)s5;
  ptr9 = (orc_union16 *)s6;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var42.i = (orc_uint8)var34;
    /* 2: loadw */
    var35 = ptr7[i];
    /* 3: mullw */
    var43.i = (var42.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var44.i = (orc_uint8)var36;
    /* 6: loadw */
    var37 = ptr8[i];
    /* 7: mullw */
    var45.i = (var44.i * var37.i) & 0xffff;
    /* 8: addw */
    var46.i = var43.i + var45.i;
    /* 9: loadb */
    var38 = ptr6[i];
    /* 10: convubw */
    var47.i = (orc_uint8)var38;
    /* 11: loadw */
    var39 = ptr9[i];
    /* 12: mullw */
    var48.i = (var47.i * var39.i) & 0xffff;
    /* 13: addw */
    var49.i = var46.i + var48.i;
    /* 14: loadw */
    var40 = ptr0[i];
    /* 15: addw */
    var41.i = var40.i + var49.i;
    /* 16: storew */
    ptr0[i] = var41;
  }

}

#else
static void
_backup_video_orc_resample_h_muladdtaps3_u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_union16 * ORC_RESTRICT ptr7;
  const orc_union16 * ORC_RESTRICT ptr8;
  const orc_union16 * ORC_RESTRICT ptr9;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_union16 *)ex->arrays[7];
  ptr8 = (orc_union16 *)ex->arrays[8];
  ptr9 = (orc_union16 *)ex->arrays[9];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var42.i = (orc_uint8)var34;
    /* 2: loadw */
    var35 = ptr7[i];
    /* 3: mullw */
    var43.i = (var42.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var44.i = (orc_uint8)var36;
    /* 6: loadw */
    var37 = ptr8[i];
    /* 7: mullw */
    var45.i = (var44.i * var37.i) & 0xffff;
    /* 8: addw */
    var46.i = var43.i + var45.i;
    /* 9: loadb */
    var38 = ptr6[i];
    /* 10: convubw */
    var47.i = (orc_uint8)var38;
    /* 11: loadw */
    var39 = ptr9[i];
    /* 12: mullw */
    var48.i = (var47.i * var39.i) & 0xffff;
    /* 13: addw */
    var49.i = var46.i + var48.i;
    /* 14: loadw */
    var40 = ptr0[i];
    /* 15: addw */
    var41.i = var40.i + var49.i;
    /* 16: storew */
    ptr0[i] = var41;
  }

}

void
video_orc_resample_h_muladdtaps3_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, const gint16 * ORC_RESTRICT s5, const gint16 * ORC_RESTRICT s6, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 38, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 104, 95, 109, 117, 108, 97, 100, 100, 116, 97, 
        112, 115, 51, 95, 117, 56, 95, 108, 113, 11, 2, 2, 12, 1, 1, 12, 
        1, 1, 12, 1, 1, 12, 2, 2, 12, 2, 2, 12, 2, 2, 20, 2, 
        20, 2, 150, 32, 4, 89, 32, 32, 7, 150, 33, 5, 89, 33, 33, 8, 
        70, 32, 32, 33, 150, 33, 6, 89, 33, 33, 9, 70, 32, 32, 33, 70, 
        0, 0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_muladdtaps3_u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_h_muladdtaps3_u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_muladdtaps3_u8_lq);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_source (p, 2, "s5");
      orc_program_add_source (p, 2, "s6");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_S5, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_S6, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->arrays[ORC_VAR_S5] = (void *)s5;
  ex->arrays[ORC_VAR_S6] = (void *)s6;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_h_muladdscaletaps3_u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_h_muladdscaletaps3_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, const gint16 * ORC_RESTRICT s5, const gint16 * ORC_RESTRICT s6, const gint16 * ORC_RESTRICT s7, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_union16 * ORC_RESTRICT ptr7;
  const orc_union16 * ORC_RESTRICT ptr8;
  const orc_union16 * ORC_RESTRICT ptr9;
  const orc_union16 * ORC_RESTRICT ptr10;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
  orc_int8 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_union16 *)s4;
  ptr8 = (orc_union16 *)s5;
  ptr9 = (orc_union16 *)s6;
  ptr10 = (orc_union16 *)s7;

    /* 16: loadpw */
    var41.i = (int)0x00000020; /* 32 or 1.58101e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var43.i = (orc_uint8)var34;
    /* 2: loadw */
    var35 = ptr7[i];
    /* 3: mullw */
    var44.i = (var43.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var45.i = (orc_uint8)var36;
    /* 6: loadw */
    var37 = ptr8[i];
    /* 7: mullw */
    var46.i = (var45.i * var37.i) & 0xffff;
    /* 8: addw */
    var47.i = var44.i + var46.i;
    /* 9: loadb */
    var38 = ptr6[i];
    /* 10: convubw */
    var48.i = (orc_uint8)var38;
    /* 11: loadw */
    var39 = ptr9[i];
    /* 12: mullw */
    var49.i = (var48.i * var39.i) & 0xffff;
    /* 13: addw */
    var50.i = var47.i + var49.i;
    /* 14: loadw */
    var40 = ptr10[i];
    /* 15: addw */
    var51.i = var50.i + var40.i;
    /* 17: addw */
    var52.i = var51.i + var41.i;
    /* 18: shrsw */
    var53.i = var52.i >> 6;
    /* 19: convsuswb */
    var42 = ORC_CLAMP_UB(var53.i);
    /* 20: storeb */
    ptr0[i] = var42;
  }

}

#else
static void
_backup_video_orc_resample_h_muladdscaletaps3_u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_union16 * ORC_RESTRICT ptr7;
  const orc_union16 * ORC_RESTRICT ptr8;
  const orc_union16 * ORC_RESTRICT ptr9;
  const orc_union16 * ORC_RESTRICT ptr10;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_union16 var40;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var41;
#else
  orc_union16 var41;
#endif
  orc_int8 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_union16 *)ex->arrays[7];
  ptr8 = (orc_union16 *)ex->arrays[8];
  ptr9 = (orc_union16 *)ex->arrays[9];
  ptr10 = (orc_union16 *)ex->arrays[10];

    /* 16: loadpw */
    var41.i = (int)0x00000020; /* 32 or 1.58101e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var43.i = (orc_uint8)var34;
    /* 2: loadw */
    var35 = ptr7[i];
    /* 3: mullw */
    var44.i = (var43.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var45.i = (orc_uint8)var36;
    /* 6: loadw */
    var37 = ptr8[i];
    /* 7: mullw */
    var46.i = (var45.i * var37.i) & 0xffff;
    /* 8: addw */
    var47.i = var44.i + var46.i;
    /* 9: loadb */
    var38 = ptr6[i];
    /* 10: convubw */
    var48.i = (orc_uint8)var38;
    /* 11: loadw */
    var39 = ptr9[i];
    /* 12: mullw */
    var49.i = (var48.i * var39.i) & 0xffff;
    /* 13: addw */
    var50.i = var47.i + var49.i;
    /* 14: loadw */
    var40 = ptr10[i];
    /* 15: addw */
    var51.i = var50.i + var40.i;
    /* 17: addw */
    var52.i = var51.i + var41.i;
    /* 18: shrsw */
    var53.i = var52.i >> 6;
    /* 19: convsuswb */
    var42 = ORC_CLAMP_UB(var53.i);
    /* 20: storeb */
    ptr0[i] = var42;
  }

}

void
video_orc_resample_h_muladdscaletaps3_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const gint16 * ORC_RESTRICT s4, const gint16 * ORC_RESTRICT s5, const gint16 * ORC_RESTRICT s6, const gint16 * ORC_RESTRICT s7, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 43, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 104, 95, 109, 117, 108, 97, 100, 100, 115, 99, 
        97, 108, 101, 116, 97, 112, 115, 51, 95, 117, 56, 95, 108, 113, 11, 1, 
        1, 12, 1, 1, 12, 1, 1, 12, 1, 1, 12, 2, 2, 12, 2, 2, 
        12, 2, 2, 12, 2, 2, 14, 2, 32, 0, 0, 0, 14, 2, 6, 0, 
        0, 0, 20, 2, 20, 2, 150, 32, 4, 89, 32, 32, 7, 150, 33, 5, 
        89, 33, 33, 8, 70, 32, 32, 33, 150, 33, 6, 89, 33, 33, 9, 70, 
        32, 32, 33, 70, 32, 32, 10, 70, 32, 32, 16, 94, 32, 32, 17, 160, 
        0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_muladdscaletaps3_u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_h_muladdscaletaps3_u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_muladdscaletaps3_u8_lq);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 2, "s4");
      orc_program_add_source (p, 2, "s5");
      orc_program_add_source (p, 2, "s6");
      orc_program_add_source (p, 2, "s7");
      orc_program_add_constant (p, 2, 0x00000020, "c1");
      orc_program_add_constant (p, 2, 0x00000006, "c2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_S5, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_S6, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_S7, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->arrays[ORC_VAR_S5] = (void *)s5;
  ex->arrays[ORC_VAR_S6] = (void *)s6;
  ex->arrays[ORC_VAR_S7] = (void *)s7;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_scaletaps_u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_scaletaps_u8_lq (guint8 * ORC_RESTRICT d1, const gint16 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 1: loadpw */
    var34.i = (int)0x00000020; /* 32 or 1.58101e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 2: addw */
    var36.i = var33.i + var34.i;
    /* 3: shrsw */
    var37.i = var36.i >> 6;
    /* 4: convsuswb */
    var35 = ORC_CLAMP_UB(var37.i);
    /* 5: storeb */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_video_orc_resample_scaletaps_u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_int8 var35;
  orc_union16 var36;
  orc_union16 var37;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 1: loadpw */
    var34.i = (int)0x00000020; /* 32 or 1.58101e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 2: addw */
    var36.i = var33.i + var34.i;
    /* 3: shrsw */
    var37.i = var36.i >> 6;
    /* 4: convsuswb */
    var35 = ORC_CLAMP_UB(var37.i);
    /* 5: storeb */
    ptr0[i] = var35;
  }

}

void
video_orc_resample_scaletaps_u8_lq (guint8 * ORC_RESTRICT d1, const gint16 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 34, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 115, 99, 97, 108, 101, 116, 97, 112, 115, 95, 
        117, 56, 95, 108, 113, 11, 1, 1, 12, 2, 2, 14, 2, 32, 0, 0, 
        0, 14, 2, 6, 0, 0, 0, 20, 2, 70, 32, 4, 16, 94, 32, 32, 
        17, 160, 0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_scaletaps_u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_scaletaps_u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_scaletaps_u8_lq);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0x00000020, "c1");
      orc_program_add_constant (p, 2, 0x00000006, "c2");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_h_multaps_u16 */
#ifdef DISABLE_ORC
void
video_orc_resample_h_multaps_u16 (gint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const gint16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;
  ptr5 = (orc_union16 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: convuwl */
    var37.i = (orc_uint16)var34.i;
    /* 2: loadw */
    var35 = ptr5[i];
    /* 3: convswl */
    var38.i = var35.i;
    /* 4: mulll */
    var36.i = (((orc_uint32)var37.i) * ((orc_uint32)var38.i)) & 0xffffffff;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_video_orc_resample_h_multaps_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];
  ptr5 = (orc_union16 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: convuwl */
    var37.i = (orc_uint16)var34.i;
    /* 2: loadw */
    var35 = ptr5[i];
    /* 3: convswl */
    var38.i = var35.i;
    /* 4: mulll */
    var36.i = (((orc_uint32)var37.i) * ((orc_uint32)var38.i)) & 0xffffffff;
    /* 5: storel */
    ptr0[i] = var36;
  }

}

void
video_orc_resample_h_multaps_u16 (gint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const gint16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 32, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 104, 95, 109, 117, 108, 116, 97, 112, 115, 95, 
        117, 49, 54, 11, 4, 4, 12, 2, 2, 12, 2, 2, 20, 4, 20, 4, 
        154, 32, 4, 153, 33, 5, 120, 0, 32, 33, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_multaps_u16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_h_multaps_u16");
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_multaps_u16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convswl", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_h_muladdtaps_u16 */
#ifdef DISABLE_ORC
void
video_orc_resample_h_muladdtaps_u16 (gint32 * ORC_RESTRICT d1, int d1_stride, const guint16 * ORC_RESTRICT s1, int s1_stride, const gint16 * ORC_RESTRICT s2, int s2_stride, int n, int m){
  int i;
  int j;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);
    ptr5 = ORC_PTR_OFFSET(s2, s2_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr4[i];
      /* 1: convuwl */
      var38.i = (orc_uint16)var34.i;
      /* 2: loadw */
      var35 = ptr5[i];
      /* 3: convswl */
      var39.i = var35.i;
      /* 4: mulll */
      var40.i = (((orc_uint32)var38.i) * ((orc_uint32)var39.i)) & 0xffffffff;
      /* 5: loadl */
      var36 = ptr0[i];
      /* 6: addl */
      var37.i = ((orc_uint32)var36.i) + ((orc_uint32)var40.i);
      /* 7: storel */
      ptr0[i] = var37;
    }
  }

}

#else
static void
_backup_video_orc_resample_h_muladdtaps_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  const orc_union16 * ORC_RESTRICT ptr5;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr4[i];
      /* 1: convuwl */
      var38.i = (orc_uint16)var34.i;
      /* 2: loadw */
      var35 = ptr5[i];
      /* 3: convswl */
      var39.i = var35.i;
      /* 4: mulll */
      var40.i = (((orc_uint32)var38.i) * ((orc_uint32)var39.i)) & 0xffffffff;
      /* 5: loadl */
      var36 = ptr0[i];
      /* 6: addl */
      var37.i = ((orc_uint32)var36.i) + ((orc_uint32)var40.i);
      /* 7: storel */
      ptr0[i] = var37;
    }
  }

}

void
video_orc_resample_h_muladdtaps_u16 (gint32 * ORC_RESTRICT d1, int d1_stride, const guint16 * ORC_RESTRICT s1, int s1_stride, const gint16 * ORC_RESTRICT s2, int s2_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 35, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 
        115, 97, 109, 112, 108, 101, 95, 104, 95, 109, 117, 108, 97, 100, 100, 116, 
        97, 112, 115, 95, 117, 49, 54, 11, 4, 4, 12, 2, 2, 12, 2, 2, 
        20, 4, 20, 4, 154, 32, 4, 153, 33, 5, 120, 32, 32, 33, 103, 0, 
        0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_muladdtaps_u16);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_resample_h_muladdtaps_u16");
      orc_program_set_backup_function (p, _backup_video_orc_resample_h_muladdtaps_u16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_source (p, 2, "s2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convswl", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->params[ORC_VAR_S2] = s2_stride;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_scaletaps_u16 */
#ifdef DISABLE_ORC
void
video_orc_resample_scaletaps_u16 (guint16 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_union32 *)s1;

    /* 1: loadpl */
    var34.i = (int)0x00000fff; /* 4095 or 2.0232e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: addl */
    var36.i = ((orc_uint32)var33.i) + ((orc_uint32)var34.i);
    /* 3: shrsl */
    var37.i = var36.i >> 12;
    /* 4: convsuslw */
    var35.i = ORC_CLAMP_UW(var37.i);
    /* 5: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_video_orc_resample_scaletaps_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  orc_union32 var33;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var34;
#else
  orc_union32 var34;
#endif
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

    /* 1: loadpl */
    var34.i = (int)0x00000fff; /* 4095 or 2.0232e-320f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var33 = ptr4[i];
    /* 2: addl */
    var36.i = ((orc_uint32)var33.i) + ((orc_uint32)var34.i);
    /* 3: shrsl */
    var37.i = var36.i >> 12;
    /* 4: convsuslw */
    var35.i = ORC_CLAMP_UW(var37.i);
    /* 5: storew */
    ptr0[i] = var35;
  }

}

void
video_orc_resample_scaletaps_u16 (guint16 * ORC_RESTRICT d1, const gint32 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 32, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 115, 99, 97, 108, 101, 116, 97, 112, 115, 95, 
        117, 49, 54, 11, 2, 2, 12, 4, 4, 14, 4, 255, 15, 0, 0, 14, 
        4, 12, 0, 0, 0, 20, 4, 103, 32, 4, 16, 125, 32, 32, 17, 166, 
        0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_scaletaps_u16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_scaletaps_u16");
      orc_program_set_backup_function (p, _backup_video_orc_resample_scaletaps_u16);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 4, 0x00000fff, "c1");
      orc_program_add_constant (p, 4, 0x0000000c, "c2");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "addl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsl", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuslw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_v_multaps_u8 */
#ifdef DISABLE_ORC
void
video_orc_resample_v_multaps_u8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;
  orc_union32 var35;
  orc_union16 var36;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;

    /* 2: loadpw */
    var34.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 3: mulswl */
    var35.i = var36.i * var34.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_video_orc_resample_v_multaps_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;
  orc_union32 var35;
  orc_union16 var36;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];

    /* 2: loadpw */
    var34.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 3: mulswl */
    var35.i = var36.i * var34.i;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
video_orc_resample_v_multaps_u8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 118, 95, 109, 117, 108, 116, 97, 112, 115, 95, 
        117, 56, 11, 4, 4, 12, 1, 1, 16, 2, 20, 2, 150, 32, 4, 176, 
        0, 32, 24, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_multaps_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_v_multaps_u8");
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_multaps_u8);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_v_muladdtaps_u8 */
#ifdef DISABLE_ORC
void
video_orc_resample_v_muladdtaps_u8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union16 var38;
  orc_union32 var39;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_int8 *)s1;

    /* 2: loadpw */
    var35.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var38.i = (orc_uint8)var34;
    /* 3: mulswl */
    var39.i = var38.i * var35.i;
    /* 4: loadl */
    var36 = ptr0[i];
    /* 5: addl */
    var37.i = ((orc_uint32)var36.i) + ((orc_uint32)var39.i);
    /* 6: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_video_orc_resample_v_muladdtaps_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union16 var38;
  orc_union32 var39;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];

    /* 2: loadpw */
    var35.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var38.i = (orc_uint8)var34;
    /* 3: mulswl */
    var39.i = var38.i * var35.i;
    /* 4: loadl */
    var36 = ptr0[i];
    /* 5: addl */
    var37.i = ((orc_uint32)var36.i) + ((orc_uint32)var39.i);
    /* 6: storel */
    ptr0[i] = var37;
  }

}

void
video_orc_resample_v_muladdtaps_u8 (gint32 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 34, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 118, 95, 109, 117, 108, 97, 100, 100, 116, 97, 
        112, 115, 95, 117, 56, 11, 4, 4, 12, 1, 1, 16, 2, 20, 2, 20, 
        4, 150, 32, 4, 176, 33, 32, 24, 103, 0, 0, 33, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_muladdtaps_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_v_muladdtaps_u8");
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_muladdtaps_u8);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulswl", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_v_multaps_u16 */
#ifdef DISABLE_ORC
void
video_orc_resample_v_multaps_u16 (gint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int p1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 2: loadpl */
    var34.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: convuwl */
    var36.i = (orc_uint16)var33.i;
    /* 3: mulll */
    var35.i = (((orc_uint32)var36.i) * ((orc_uint32)var34.i)) & 0xffffffff;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_video_orc_resample_v_multaps_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var33;
  orc_union32 var34;
  orc_union32 var35;
  orc_union32 var36;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 2: loadpl */
    var34.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var33 = ptr4[i];
    /* 1: convuwl */
    var36.i = (orc_uint16)var33.i;
    /* 3: mulll */
    var35.i = (((orc_uint32)var36.i) * ((orc_uint32)var34.i)) & 0xffffffff;
    /* 4: storel */
    ptr0[i] = var35;
  }

}

void
video_orc_resample_v_multaps_u16 (gint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 32, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 118, 95, 109, 117, 108, 116, 97, 112, 115, 95, 
        117, 49, 54, 11, 4, 4, 12, 2, 2, 16, 2, 20, 4, 154, 32, 4, 
        120, 0, 32, 24, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_multaps_u16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_v_multaps_u16");
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_multaps_u16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_v_muladdtaps_u16 */
#ifdef DISABLE_ORC
void
video_orc_resample_v_muladdtaps_u16 (gint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int p1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union16 *)s1;

    /* 2: loadpw */
    var35.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: convuwl */
    var38.i = (orc_uint16)var34.i;
    /* 3: convswl */
    var39.i = var35.i;
    /* 4: mulll */
    var40.i = (((orc_uint32)var38.i) * ((orc_uint32)var39.i)) & 0xffffffff;
    /* 5: loadl */
    var36 = ptr0[i];
    /* 6: addl */
    var37.i = ((orc_uint32)var36.i) + ((orc_uint32)var40.i);
    /* 7: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_video_orc_resample_v_muladdtaps_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_union16 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union16 *)ex->arrays[4];

    /* 2: loadpw */
    var35.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadw */
    var34 = ptr4[i];
    /* 1: convuwl */
    var38.i = (orc_uint16)var34.i;
    /* 3: convswl */
    var39.i = var35.i;
    /* 4: mulll */
    var40.i = (((orc_uint32)var38.i) * ((orc_uint32)var39.i)) & 0xffffffff;
    /* 5: loadl */
    var36 = ptr0[i];
    /* 6: addl */
    var37.i = ((orc_uint32)var36.i) + ((orc_uint32)var40.i);
    /* 7: storel */
    ptr0[i] = var37;
  }

}

void
video_orc_resample_v_muladdtaps_u16 (gint32 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 35, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 118, 95, 109, 117, 108, 97, 100, 100, 116, 97, 
        112, 115, 95, 117, 49, 54, 11, 4, 4, 12, 2, 2, 16, 2, 20, 4, 
        20, 4, 154, 32, 4, 153, 33, 24, 120, 32, 32, 33, 103, 0, 0, 32, 
        2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_muladdtaps_u16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_v_muladdtaps_u16");
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_muladdtaps_u16);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");

      orc_program_append_2 (p, "convuwl", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convswl", 0, ORC_VAR_T2, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_v_multaps_u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_v_multaps_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_int8 *)s1;

    /* 2: loadpw */
    var34.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 3: mullw */
    var35.i = (var36.i * var34.i) & 0xffff;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

#else
static void
_backup_video_orc_resample_v_multaps_u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];

    /* 2: loadpw */
    var34.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: convubw */
    var36.i = (orc_uint8)var33;
    /* 3: mullw */
    var35.i = (var36.i * var34.i) & 0xffff;
    /* 4: storew */
    ptr0[i] = var35;
  }

}

void
video_orc_resample_v_multaps_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 34, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 118, 95, 109, 117, 108, 116, 97, 112, 115, 95, 
        117, 56, 95, 108, 113, 11, 2, 2, 12, 1, 1, 16, 2, 20, 2, 150, 
        32, 4, 89, 0, 32, 24, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_multaps_u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_v_multaps_u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_multaps_u8_lq);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_v_multaps4_u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_v_multaps4_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int p2, int p3, int p4, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_int8 *)s4;

    /* 2: loadpw */
    var35.i = p1;
    /* 6: loadpw */
    var37.i = p2;
    /* 11: loadpw */
    var39.i = p3;
    /* 16: loadpw */
    var41.i = p4;

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var43.i = (orc_uint8)var34;
    /* 3: mullw */
    var44.i = (var43.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var45.i = (orc_uint8)var36;
    /* 7: mullw */
    var46.i = (var45.i * var37.i) & 0xffff;
    /* 8: addw */
    var47.i = var44.i + var46.i;
    /* 9: loadb */
    var38 = ptr6[i];
    /* 10: convubw */
    var48.i = (orc_uint8)var38;
    /* 12: mullw */
    var49.i = (var48.i * var39.i) & 0xffff;
    /* 13: addw */
    var50.i = var47.i + var49.i;
    /* 14: loadb */
    var40 = ptr7[i];
    /* 15: convubw */
    var51.i = (orc_uint8)var40;
    /* 17: mullw */
    var52.i = (var51.i * var41.i) & 0xffff;
    /* 18: addw */
    var42.i = var50.i + var52.i;
    /* 19: storew */
    ptr0[i] = var42;
  }

}

#else
static void
_backup_video_orc_resample_v_multaps4_u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];

    /* 2: loadpw */
    var35.i = ex->params[24];
    /* 6: loadpw */
    var37.i = ex->params[25];
    /* 11: loadpw */
    var39.i = ex->params[26];
    /* 16: loadpw */
    var41.i = ex->params[27];

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var43.i = (orc_uint8)var34;
    /* 3: mullw */
    var44.i = (var43.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var45.i = (orc_uint8)var36;
    /* 7: mullw */
    var46.i = (var45.i * var37.i) & 0xffff;
    /* 8: addw */
    var47.i = var44.i + var46.i;
    /* 9: loadb */
    var38 = ptr6[i];
    /* 10: convubw */
    var48.i = (orc_uint8)var38;
    /* 12: mullw */
    var49.i = (var48.i * var39.i) & 0xffff;
    /* 13: addw */
    var50.i = var47.i + var49.i;
    /* 14: loadb */
    var40 = ptr7[i];
    /* 15: convubw */
    var51.i = (orc_uint8)var40;
    /* 17: mullw */
    var52.i = (var51.i * var41.i) & 0xffff;
    /* 18: addw */
    var42.i = var50.i + var52.i;
    /* 19: storew */
    ptr0[i] = var42;
  }

}

void
video_orc_resample_v_multaps4_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int p2, int p3, int p4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 35, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 118, 95, 109, 117, 108, 116, 97, 112, 115, 52, 
        95, 117, 56, 95, 108, 113, 11, 2, 2, 12, 1, 1, 12, 1, 1, 12, 
        1, 1, 12, 1, 1, 16, 2, 16, 2, 16, 2, 16, 2, 20, 2, 20, 
        2, 150, 32, 4, 89, 32, 32, 24, 150, 33, 5, 89, 33, 33, 25, 70, 
        32, 32, 33, 150, 33, 6, 89, 33, 33, 26, 70, 32, 32, 33, 150, 33, 
        7, 89, 33, 33, 27, 70, 0, 32, 33, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_multaps4_u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_v_multaps4_u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_multaps4_u8_lq);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_v_muladdtaps_u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_v_muladdtaps_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_int8 *)s1;

    /* 2: loadpw */
    var34.i = p1;

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: convubw */
    var37.i = (orc_uint8)var33;
    /* 3: mullw */
    var38.i = (var37.i * var34.i) & 0xffff;
    /* 4: loadw */
    var35 = ptr0[i];
    /* 5: addw */
    var36.i = var35.i + var38.i;
    /* 6: storew */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_video_orc_resample_v_muladdtaps_u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var33;
  orc_union16 var34;
  orc_union16 var35;
  orc_union16 var36;
  orc_union16 var37;
  orc_union16 var38;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];

    /* 2: loadpw */
    var34.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var33 = ptr4[i];
    /* 1: convubw */
    var37.i = (orc_uint8)var33;
    /* 3: mullw */
    var38.i = (var37.i * var34.i) & 0xffff;
    /* 4: loadw */
    var35 = ptr0[i];
    /* 5: addw */
    var36.i = var35.i + var38.i;
    /* 6: storew */
    ptr0[i] = var36;
  }

}

void
video_orc_resample_v_muladdtaps_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 37, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 118, 95, 109, 117, 108, 97, 100, 100, 116, 97, 
        112, 115, 95, 117, 56, 95, 108, 113, 11, 2, 2, 12, 1, 1, 16, 2, 
        20, 2, 150, 32, 4, 89, 32, 32, 24, 70, 0, 0, 32, 2, 0,       };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_muladdtaps_u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_v_muladdtaps_u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_muladdtaps_u8_lq);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_temporary (p, 2, "t1");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_v_muladdtaps4_u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_v_muladdtaps4_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int p2, int p3, int p4, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;

  ptr0 = (orc_union16 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_int8 *)s4;

    /* 2: loadpw */
    var35.i = p1;
    /* 6: loadpw */
    var37.i = p2;
    /* 11: loadpw */
    var39.i = p3;
    /* 16: loadpw */
    var41.i = p4;

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var44.i = (orc_uint8)var34;
    /* 3: mullw */
    var45.i = (var44.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var46.i = (orc_uint8)var36;
    /* 7: mullw */
    var47.i = (var46.i * var37.i) & 0xffff;
    /* 8: addw */
    var48.i = var45.i + var47.i;
    /* 9: loadb */
    var38 = ptr6[i];
    /* 10: convubw */
    var49.i = (orc_uint8)var38;
    /* 12: mullw */
    var50.i = (var49.i * var39.i) & 0xffff;
    /* 13: addw */
    var51.i = var48.i + var50.i;
    /* 14: loadb */
    var40 = ptr7[i];
    /* 15: convubw */
    var52.i = (orc_uint8)var40;
    /* 17: mullw */
    var53.i = (var52.i * var41.i) & 0xffff;
    /* 18: addw */
    var54.i = var51.i + var53.i;
    /* 19: loadw */
    var42 = ptr0[i];
    /* 20: addw */
    var43.i = var42.i + var54.i;
    /* 21: storew */
    ptr0[i] = var43;
  }

}

#else
static void
_backup_video_orc_resample_v_muladdtaps4_u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;

  ptr0 = (orc_union16 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];

    /* 2: loadpw */
    var35.i = ex->params[24];
    /* 6: loadpw */
    var37.i = ex->params[25];
    /* 11: loadpw */
    var39.i = ex->params[26];
    /* 16: loadpw */
    var41.i = ex->params[27];

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var44.i = (orc_uint8)var34;
    /* 3: mullw */
    var45.i = (var44.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var46.i = (orc_uint8)var36;
    /* 7: mullw */
    var47.i = (var46.i * var37.i) & 0xffff;
    /* 8: addw */
    var48.i = var45.i + var47.i;
    /* 9: loadb */
    var38 = ptr6[i];
    /* 10: convubw */
    var49.i = (orc_uint8)var38;
    /* 12: mullw */
    var50.i = (var49.i * var39.i) & 0xffff;
    /* 13: addw */
    var51.i = var48.i + var50.i;
    /* 14: loadb */
    var40 = ptr7[i];
    /* 15: convubw */
    var52.i = (orc_uint8)var40;
    /* 17: mullw */
    var53.i = (var52.i * var41.i) & 0xffff;
    /* 18: addw */
    var54.i = var51.i + var53.i;
    /* 19: loadw */
    var42 = ptr0[i];
    /* 20: addw */
    var43.i = var42.i + var54.i;
    /* 21: storew */
    ptr0[i] = var43;
  }

}

void
video_orc_resample_v_muladdtaps4_u8_lq (gint16 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int p1, int p2, int p3, int p4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 38, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 118, 95, 109, 117, 108, 97, 100, 100, 116, 97, 
        112, 115, 52, 95, 117, 56, 95, 108, 113, 11, 2, 2, 12, 1, 1, 12, 
        1, 1, 12, 1, 1, 12, 1, 1, 16, 2, 16, 2, 16, 2, 16, 2, 
        20, 2, 20, 2, 150, 32, 4, 89, 32, 32, 24, 150, 33, 5, 89, 33, 
        33, 25, 70, 32, 32, 33, 150, 33, 6, 89, 33, 33, 26, 70, 32, 32, 
        33, 150, 33, 7, 89, 33, 33, 27, 70, 32, 32, 33, 70, 0, 0, 32, 
        2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_muladdtaps4_u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_v_muladdtaps4_u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_muladdtaps4_u8_lq);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_resample_v_muladdscaletaps4_u8_lq */
#ifdef DISABLE_ORC
void
video_orc_resample_v_muladdscaletaps4_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, const gint16 * ORC_RESTRICT s5, int p1, int p2, int p3, int p4, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  const orc_union16 * ORC_RESTRICT ptr8;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_int8 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;
  orc_union16 var56;
  orc_union16 var57;
  orc_union16 var58;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;
  ptr5 = (orc_int8 *)s2;
  ptr6 = (orc_int8 *)s3;
  ptr7 = (orc_int8 *)s4;
  ptr8 = (orc_union16 *)s5;

    /* 2: loadpw */
    var35.i = p1;
    /* 6: loadpw */
    var37.i = p2;
    /* 11: loadpw */
    var39.i = p3;
    /* 16: loadpw */
    var41.i = p4;
    /* 21: loadpw */
    var43.i = (int)0x00000020; /* 32 or 1.58101e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var45.i = (orc_uint8)var34;
    /* 3: mullw */
    var46.i = (var45.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var47.i = (orc_uint8)var36;
    /* 7: mullw */
    var48.i = (var47.i * var37.i) & 0xffff;
    /* 8: addw */
    var49.i = var46.i + var48.i;
    /* 9: loadb */
    var38 = ptr6[i];
    /* 10: convubw */
    var50.i = (orc_uint8)var38;
    /* 12: mullw */
    var51.i = (var50.i * var39.i) & 0xffff;
    /* 13: addw */
    var52.i = var49.i + var51.i;
    /* 14: loadb */
    var40 = ptr7[i];
    /* 15: convubw */
    var53.i = (orc_uint8)var40;
    /* 17: mullw */
    var54.i = (var53.i * var41.i) & 0xffff;
    /* 18: addw */
    var55.i = var52.i + var54.i;
    /* 19: loadw */
    var42 = ptr8[i];
    /* 20: addw */
    var56.i = var55.i + var42.i;
    /* 22: addw */
    var57.i = var56.i + var43.i;
    /* 23: shrsw */
    var58.i = var57.i >> 6;
    /* 24: convsuswb */
    var44 = ORC_CLAMP_UB(var58.i);
    /* 25: storeb */
    ptr0[i] = var44;
  }

}

#else
static void
_backup_video_orc_resample_v_muladdscaletaps4_u8_lq (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  const orc_int8 * ORC_RESTRICT ptr5;
  const orc_int8 * ORC_RESTRICT ptr6;
  const orc_int8 * ORC_RESTRICT ptr7;
  const orc_union16 * ORC_RESTRICT ptr8;
  orc_int8 var34;
  orc_union16 var35;
  orc_int8 var36;
  orc_union16 var37;
  orc_int8 var38;
  orc_union16 var39;
  orc_int8 var40;
  orc_union16 var41;
  orc_union16 var42;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var43;
#else
  orc_union16 var43;
#endif
  orc_int8 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union16 var49;
  orc_union16 var50;
  orc_union16 var51;
  orc_union16 var52;
  orc_union16 var53;
  orc_union16 var54;
  orc_union16 var55;
  orc_union16 var56;
  orc_union16 var57;
  orc_union16 var58;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];
  ptr8 = (orc_union16 *)ex->arrays[8];

    /* 2: loadpw */
    var35.i = ex->params[24];
    /* 6: loadpw */
    var37.i = ex->params[25];
    /* 11: loadpw */
    var39.i = ex->params[26];
    /* 16: loadpw */
    var41.i = ex->params[27];
    /* 21: loadpw */
    var43.i = (int)0x00000020; /* 32 or 1.58101e-322f */

  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var34 = ptr4[i];
    /* 1: convubw */
    var45.i = (orc_uint8)var34;
    /* 3: mullw */
    var46.i = (var45.i * var35.i) & 0xffff;
    /* 4: loadb */
    var36 = ptr5[i];
    /* 5: convubw */
    var47.i = (orc_uint8)var36;
    /* 7: mullw */
    var48.i = (var47.i * var37.i) & 0xffff;
    /* 8: addw */
    var49.i = var46.i + var48.i;
    /* 9: loadb */
    var38 = ptr6[i];
    /* 10: convubw */
    var50.i = (orc_uint8)var38;
    /* 12: mullw */
    var51.i = (var50.i * var39.i) & 0xffff;
    /* 13: addw */
    var52.i = var49.i + var51.i;
    /* 14: loadb */
    var40 = ptr7[i];
    /* 15: convubw */
    var53.i = (orc_uint8)var40;
    /* 17: mullw */
    var54.i = (var53.i * var41.i) & 0xffff;
    /* 18: addw */
    var55.i = var52.i + var54.i;
    /* 19: loadw */
    var42 = ptr8[i];
    /* 20: addw */
    var56.i = var55.i + var42.i;
    /* 22: addw */
    var57.i = var56.i + var43.i;
    /* 23: shrsw */
    var58.i = var57.i >> 6;
    /* 24: convsuswb */
    var44 = ORC_CLAMP_UB(var58.i);
    /* 25: storeb */
    ptr0[i] = var44;
  }

}

void
video_orc_resample_v_muladdscaletaps4_u8_lq (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, const gint16 * ORC_RESTRICT s5, int p1, int p2, int p3, int p4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 43, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 114, 101, 115, 
        97, 109, 112, 108, 101, 95, 118, 95, 109, 117, 108, 97, 100, 100, 115, 99, 
        97, 108, 101, 116, 97, 112, 115, 52, 95, 117, 56, 95, 108, 113, 11, 1, 
        1, 12, 1, 1, 12, 1, 1, 12, 1, 1, 12, 1, 1, 12, 2, 2, 
        14, 2, 32, 0, 0, 0, 14, 2, 6, 0, 0, 0, 16, 2, 16, 2, 
        16, 2, 16, 2, 20, 2, 20, 2, 150, 32, 4, 89, 32, 32, 24, 150, 
        33, 5, 89, 33, 33, 25, 70, 32, 32, 33, 150, 33, 6, 89, 33, 33, 
        26, 70, 32, 32, 33, 150, 33, 7, 89, 33, 33, 27, 70, 32, 32, 33, 
        70, 32, 32, 8, 70, 32, 32, 16, 94, 32, 32, 17, 160, 0, 32, 2, 
        0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_muladdscaletaps4_u8_lq);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_resample_v_muladdscaletaps4_u8_lq");
      orc_program_set_backup_function (p, _backup_video_orc_resample_v_muladdscaletaps4_u8_lq);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");
      orc_program_add_source (p, 1, "s2");
      orc_program_add_source (p, 1, "s3");
      orc_program_add_source (p, 1, "s4");
      orc_program_add_source (p, 2, "s5");
      orc_program_add_constant (p, 2, 0x00000020, "c1");
      orc_program_add_constant (p, 2, 0x00000006, "c2");
      orc_program_add_parameter (p, 2, "p1");
      orc_program_add_parameter (p, 2, "p2");
      orc_program_add_parameter (p, 2, "p3");
      orc_program_add_parameter (p, 2, "p4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 0, ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_S5, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "shrsw", 0, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;
  ex->arrays[ORC_VAR_S5] = (void *)s5;
  ex->params[ORC_VAR_P1] = p1;
  ex->params[ORC_VAR_P2] = p2;
  ex->params[ORC_VAR_P3] = p3;
  ex->params[ORC_VAR_P4] = p4;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_chroma_down_h2_u8 */
#ifdef DISABLE_ORC
void
video_orc_chroma_down_h2_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union64 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union32 var45;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union64 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var37 = ptr4[i];
    /* 1: splitql */
    {
       orc_union64 _src;
       _src.i = var37.i;
       var39.i = _src.x2[1];
       var40.i = _src.x2[0];
    }
    /* 2: splitlw */
    {
       orc_union32 _src;
       _src.i = var40.i;
       var41.i = _src.x2[1];
       var42.i = _src.x2[0];
    }
    /* 3: select1lw */
    {
       orc_union32 _src;
       _src.i = var39.i;
       var43.i = _src.x2[1];
    }
    /* 4: avgub */
    var44.x2[0] = ((orc_uint8)var41.x2[0] + (orc_uint8)var43.x2[0] + 1)>>1;
    var44.x2[1] = ((orc_uint8)var41.x2[1] + (orc_uint8)var43.x2[1] + 1)>>1;
    /* 5: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.i;
       _dest.x2[1] = var44.i;
       var45.i = _dest.i;
    }
    /* 6: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var45.i;
       _dest.x2[1] = var39.i;
       var38.i = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

#else
static void
_backup_video_orc_chroma_down_h2_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var37;
  orc_union64 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union16 var41;
  orc_union16 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union32 var45;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var37 = ptr4[i];
    /* 1: splitql */
    {
       orc_union64 _src;
       _src.i = var37.i;
       var39.i = _src.x2[1];
       var40.i = _src.x2[0];
    }
    /* 2: splitlw */
    {
       orc_union32 _src;
       _src.i = var40.i;
       var41.i = _src.x2[1];
       var42.i = _src.x2[0];
    }
    /* 3: select1lw */
    {
       orc_union32 _src;
       _src.i = var39.i;
       var43.i = _src.x2[1];
    }
    /* 4: avgub */
    var44.x2[0] = ((orc_uint8)var41.x2[0] + (orc_uint8)var43.x2[0] + 1)>>1;
    var44.x2[1] = ((orc_uint8)var41.x2[1] + (orc_uint8)var43.x2[1] + 1)>>1;
    /* 5: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var42.i;
       _dest.x2[1] = var44.i;
       var45.i = _dest.i;
    }
    /* 6: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var45.i;
       _dest.x2[1] = var39.i;
       var38.i = _dest.i;
    }
    /* 7: storeq */
    ptr0[i] = var38;
  }

}

void
video_orc_chroma_down_h2_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 104, 114, 
        111, 109, 97, 95, 100, 111, 119, 110, 95, 104, 50, 95, 117, 56, 11, 8, 
        8, 12, 8, 8, 20, 4, 20, 4, 20, 2, 20, 2, 20, 2, 197, 33, 
        32, 4, 198, 35, 34, 32, 191, 36, 33, 21, 1, 39, 35, 35, 36, 195, 
        32, 34, 35, 194, 0, 32, 33, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_chroma_down_h2_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_chroma_down_h2_u8");
      orc_program_set_backup_function (p, _backup_video_orc_chroma_down_h2_u8);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 2, "t5");

      orc_program_append_2 (p, "splitql", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1lw", 0, ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_chroma_down_v2_u8 */
#ifdef DISABLE_ORC
void
video_orc_chroma_down_v2_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var35.i;
       var38.i = _src.x2[1];
       var39.i = _src.x2[0];
    }
    /* 2: loadl */
    var36 = ptr5[i];
    /* 3: select1lw */
    {
       orc_union32 _src;
       _src.i = var36.i;
       var40.i = _src.x2[1];
    }
    /* 4: avgub */
    var41.x2[0] = ((orc_uint8)var38.x2[0] + (orc_uint8)var40.x2[0] + 1)>>1;
    var41.x2[1] = ((orc_uint8)var38.x2[1] + (orc_uint8)var40.x2[1] + 1)>>1;
    /* 5: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var39.i;
       _dest.x2[1] = var41.i;
       var37.i = _dest.i;
    }
    /* 6: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_video_orc_chroma_down_v2_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var35;
  orc_union32 var36;
  orc_union32 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var35 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var35.i;
       var38.i = _src.x2[1];
       var39.i = _src.x2[0];
    }
    /* 2: loadl */
    var36 = ptr5[i];
    /* 3: select1lw */
    {
       orc_union32 _src;
       _src.i = var36.i;
       var40.i = _src.x2[1];
    }
    /* 4: avgub */
    var41.x2[0] = ((orc_uint8)var38.x2[0] + (orc_uint8)var40.x2[0] + 1)>>1;
    var41.x2[1] = ((orc_uint8)var38.x2[1] + (orc_uint8)var40.x2[1] + 1)>>1;
    /* 5: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var39.i;
       _dest.x2[1] = var41.i;
       var37.i = _dest.i;
    }
    /* 6: storel */
    ptr0[i] = var37;
  }

}

void
video_orc_chroma_down_v2_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 104, 114, 
        111, 109, 97, 95, 100, 111, 119, 110, 95, 118, 50, 95, 117, 56, 11, 4, 
        4, 12, 4, 4, 12, 4, 4, 20, 2, 20, 2, 20, 2, 198, 33, 32, 
        4, 191, 34, 5, 21, 1, 39, 33, 33, 34, 195, 0, 32, 33, 2, 0, 

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_chroma_down_v2_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_chroma_down_v2_u8");
      orc_program_set_backup_function (p, _backup_video_orc_chroma_down_v2_u8);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1lw", 0, ORC_VAR_T3, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avgub", 1, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_chroma_up_v2_u8 */
#ifdef DISABLE_ORC
void
video_orc_chroma_up_v2_u8 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var39;
  orc_union32 var40;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var41;
#else
  orc_union32 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var42;
#else
  orc_union32 var42;
#endif
  orc_union32 var43;
  orc_union32 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union32 var51;
  orc_union32 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union16 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_union32 var58;
  orc_union32 var59;
  orc_union16 var60;

  ptr0 = (orc_union32 *)d1;
  ptr1 = (orc_union32 *)d2;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;

    /* 6: loadpw */
    var41.x2[0] = (int)0x00000003; /* 3 or 1.4822e-323f */
    var41.x2[1] = (int)0x00000003; /* 3 or 1.4822e-323f */
    /* 9: loadpw */
    var42.x2[0] = (int)0x00000002; /* 2 or 9.88131e-324f */
    var42.x2[1] = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var39 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var39.i;
       var45.i = _src.x2[1];
       var46.i = _src.x2[0];
    }
    /* 2: loadl */
    var40 = ptr5[i];
    /* 3: splitlw */
    {
       orc_union32 _src;
       _src.i = var40.i;
       var47.i = _src.x2[1];
       var48.i = _src.x2[0];
    }
    /* 4: convubw */
    var49.x2[0] = (orc_uint8)var45.x2[0];
    var49.x2[1] = (orc_uint8)var45.x2[1];
    /* 5: convubw */
    var50.x2[0] = (orc_uint8)var47.x2[0];
    var50.x2[1] = (orc_uint8)var47.x2[1];
    /* 7: mullw */
    var51.x2[0] = (var49.x2[0] * var41.x2[0]) & 0xffff;
    var51.x2[1] = (var49.x2[1] * var41.x2[1]) & 0xffff;
    /* 8: addw */
    var52.x2[0] = var51.x2[0] + var50.x2[0];
    var52.x2[1] = var51.x2[1] + var50.x2[1];
    /* 10: addw */
    var53.x2[0] = var52.x2[0] + var42.x2[0];
    var53.x2[1] = var52.x2[1] + var42.x2[1];
    /* 11: shruw */
    var54.x2[0] = ((orc_uint16)var53.x2[0]) >> 2;
    var54.x2[1] = ((orc_uint16)var53.x2[1]) >> 2;
    /* 12: convsuswb */
    var55.x2[0] = ORC_CLAMP_UB(var54.x2[0]);
    var55.x2[1] = ORC_CLAMP_UB(var54.x2[1]);
    /* 13: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var46.i;
       _dest.x2[1] = var55.i;
       var43.i = _dest.i;
    }
    /* 14: storel */
    ptr0[i] = var43;
    /* 15: mullw */
    var56.x2[0] = (var50.x2[0] * var41.x2[0]) & 0xffff;
    var56.x2[1] = (var50.x2[1] * var41.x2[1]) & 0xffff;
    /* 16: addw */
    var57.x2[0] = var56.x2[0] + var49.x2[0];
    var57.x2[1] = var56.x2[1] + var49.x2[1];
    /* 17: addw */
    var58.x2[0] = var57.x2[0] + var42.x2[0];
    var58.x2[1] = var57.x2[1] + var42.x2[1];
    /* 18: shruw */
    var59.x2[0] = ((orc_uint16)var58.x2[0]) >> 2;
    var59.x2[1] = ((orc_uint16)var58.x2[1]) >> 2;
    /* 19: convsuswb */
    var60.x2[0] = ORC_CLAMP_UB(var59.x2[0]);
    var60.x2[1] = ORC_CLAMP_UB(var59.x2[1]);
    /* 20: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var48.i;
       _dest.x2[1] = var60.i;
       var44.i = _dest.i;
    }
    /* 21: storel */
    ptr1[i] = var44;
  }

}

#else
static void
_backup_video_orc_chroma_up_v2_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 * ORC_RESTRICT ptr1;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  orc_union32 var39;
  orc_union32 var40;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var41;
#else
  orc_union32 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var42;
#else
  orc_union32 var42;
#endif
  orc_union32 var43;
  orc_union32 var44;
  orc_union16 var45;
  orc_union16 var46;
  orc_union16 var47;
  orc_union16 var48;
  orc_union32 var49;
  orc_union32 var50;
  orc_union32 var51;
  orc_union32 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union16 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_union32 var58;
  orc_union32 var59;
  orc_union16 var60;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr1 = (orc_union32 *)ex->arrays[1];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];

    /* 6: loadpw */
    var41.x2[0] = (int)0x00000003; /* 3 or 1.4822e-323f */
    var41.x2[1] = (int)0x00000003; /* 3 or 1.4822e-323f */
    /* 9: loadpw */
    var42.x2[0] = (int)0x00000002; /* 2 or 9.88131e-324f */
    var42.x2[1] = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var39 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var39.i;
       var45.i = _src.x2[1];
       var46.i = _src.x2[0];
    }
    /* 2: loadl */
    var40 = ptr5[i];
    /* 3: splitlw */
    {
       orc_union32 _src;
       _src.i = var40.i;
       var47.i = _src.x2[1];
       var48.i = _src.x2[0];
    }
    /* 4: convubw */
    var49.x2[0] = (orc_uint8)var45.x2[0];
    var49.x2[1] = (orc_uint8)var45.x2[1];
    /* 5: convubw */
    var50.x2[0] = (orc_uint8)var47.x2[0];
    var50.x2[1] = (orc_uint8)var47.x2[1];
    /* 7: mullw */
    var51.x2[0] = (var49.x2[0] * var41.x2[0]) & 0xffff;
    var51.x2[1] = (var49.x2[1] * var41.x2[1]) & 0xffff;
    /* 8: addw */
    var52.x2[0] = var51.x2[0] + var50.x2[0];
    var52.x2[1] = var51.x2[1] + var50.x2[1];
    /* 10: addw */
    var53.x2[0] = var52.x2[0] + var42.x2[0];
    var53.x2[1] = var52.x2[1] + var42.x2[1];
    /* 11: shruw */
    var54.x2[0] = ((orc_uint16)var53.x2[0]) >> 2;
    var54.x2[1] = ((orc_uint16)var53.x2[1]) >> 2;
    /* 12: convsuswb */
    var55.x2[0] = ORC_CLAMP_UB(var54.x2[0]);
    var55.x2[1] = ORC_CLAMP_UB(var54.x2[1]);
    /* 13: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var46.i;
       _dest.x2[1] = var55.i;
       var43.i = _dest.i;
    }
    /* 14: storel */
    ptr0[i] = var43;
    /* 15: mullw */
    var56.x2[0] = (var50.x2[0] * var41.x2[0]) & 0xffff;
    var56.x2[1] = (var50.x2[1] * var41.x2[1]) & 0xffff;
    /* 16: addw */
    var57.x2[0] = var56.x2[0] + var49.x2[0];
    var57.x2[1] = var56.x2[1] + var49.x2[1];
    /* 17: addw */
    var58.x2[0] = var57.x2[0] + var42.x2[0];
    var58.x2[1] = var57.x2[1] + var42.x2[1];
    /* 18: shruw */
    var59.x2[0] = ((orc_uint16)var58.x2[0]) >> 2;
    var59.x2[1] = ((orc_uint16)var58.x2[1]) >> 2;
    /* 19: convsuswb */
    var60.x2[0] = ORC_CLAMP_UB(var59.x2[0]);
    var60.x2[1] = ORC_CLAMP_UB(var59.x2[1]);
    /* 20: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var48.i;
       _dest.x2[1] = var60.i;
       var44.i = _dest.i;
    }
    /* 21: storel */
    ptr1[i] = var44;
  }

}

void
video_orc_chroma_up_v2_u8 (guint8 * ORC_RESTRICT d1, guint8 * ORC_RESTRICT d2, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 25, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 104, 114, 
        111, 109, 97, 95, 117, 112, 95, 118, 50, 95, 117, 56, 11, 4, 4, 11, 
        4, 4, 12, 4, 4, 12, 4, 4, 14, 2, 3, 0, 0, 0, 14, 2, 
        2, 0, 0, 0, 20, 2, 20, 2, 20, 2, 20, 2, 20, 4, 20, 4, 
        20, 4, 198, 34, 32, 4, 198, 35, 33, 5, 21, 1, 150, 36, 34, 21, 
        1, 150, 37, 35, 21, 1, 89, 38, 36, 16, 21, 1, 70, 38, 38, 37, 
        21, 1, 70, 38, 38, 17, 21, 1, 95, 38, 38, 17, 21, 1, 160, 34, 
        38, 195, 0, 32, 34, 21, 1, 89, 38, 37, 16, 21, 1, 70, 38, 38, 
        36, 21, 1, 70, 38, 38, 17, 21, 1, 95, 38, 38, 17, 21, 1, 160, 
        35, 38, 195, 1, 33, 35, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_chroma_up_v2_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_chroma_up_v2_u8");
      orc_program_set_backup_function (p, _backup_video_orc_chroma_up_v2_u8);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 4, "d2");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_constant (p, 2, 0x00000003, "c1");
      orc_program_add_constant (p, 2, 0x00000002, "c2");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 2, "t3");
      orc_program_add_temporary (p, 2, "t4");
      orc_program_add_temporary (p, 4, "t5");
      orc_program_add_temporary (p, 4, "t6");
      orc_program_add_temporary (p, 4, "t7");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 1, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 1, ORC_VAR_T6, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 1, ORC_VAR_T7, ORC_VAR_T5, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 1, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T6, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 1, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 1, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 1, ORC_VAR_T3, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 1, ORC_VAR_T7, ORC_VAR_T6, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 1, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 1, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 1, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 1, ORC_VAR_T4, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_chroma_up_v2_u16 */
#ifdef DISABLE_ORC
void
video_orc_chroma_up_v2_u16 (guint16 * ORC_RESTRICT d1, guint16 * ORC_RESTRICT d2, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  orc_union64 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var39;
  orc_union64 var40;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union64 var41;
#else
  orc_union64 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union64 var42;
#else
  orc_union64 var42;
#endif
  orc_union64 var43;
  orc_union64 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union64 var49;
  orc_union64 var50;
  orc_union64 var51;
  orc_union64 var52;
  orc_union64 var53;
  orc_union64 var54;
  orc_union32 var55;
  orc_union64 var56;
  orc_union64 var57;
  orc_union64 var58;
  orc_union64 var59;
  orc_union32 var60;

  ptr0 = (orc_union64 *)d1;
  ptr1 = (orc_union64 *)d2;
  ptr4 = (orc_union64 *)s1;
  ptr5 = (orc_union64 *)s2;

    /* 6: loadpl */
    var41.x2[0] = (int)0x00000003; /* 3 or 1.4822e-323f */
    var41.x2[1] = (int)0x00000003; /* 3 or 1.4822e-323f */
    /* 9: loadpl */
    var42.x2[0] = (int)0x00000002; /* 2 or 9.88131e-324f */
    var42.x2[1] = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var39 = ptr4[i];
    /* 1: splitql */
    {
       orc_union64 _src;
       _src.i = var39.i;
       var45.i = _src.x2[1];
       var46.i = _src.x2[0];
    }
    /* 2: loadq */
    var40 = ptr5[i];
    /* 3: splitql */
    {
       orc_union64 _src;
       _src.i = var40.i;
       var47.i = _src.x2[1];
       var48.i = _src.x2[0];
    }
    /* 4: convuwl */
    var49.x2[0] = (orc_uint16)var45.x2[0];
    var49.x2[1] = (orc_uint16)var45.x2[1];
    /* 5: convuwl */
    var50.x2[0] = (orc_uint16)var47.x2[0];
    var50.x2[1] = (orc_uint16)var47.x2[1];
    /* 7: mulll */
    var51.x2[0] = (((orc_uint32)var49.x2[0]) * ((orc_uint32)var41.x2[0])) & 0xffffffff;
    var51.x2[1] = (((orc_uint32)var49.x2[1]) * ((orc_uint32)var41.x2[1])) & 0xffffffff;
    /* 8: addl */
    var52.x2[0] = ((orc_uint32)var51.x2[0]) + ((orc_uint32)var50.x2[0]);
    var52.x2[1] = ((orc_uint32)var51.x2[1]) + ((orc_uint32)var50.x2[1]);
    /* 10: addl */
    var53.x2[0] = ((orc_uint32)var52.x2[0]) + ((orc_uint32)var42.x2[0]);
    var53.x2[1] = ((orc_uint32)var52.x2[1]) + ((orc_uint32)var42.x2[1]);
    /* 11: shrul */
    var54.x2[0] = ((orc_uint32)var53.x2[0]) >> 2;
    var54.x2[1] = ((orc_uint32)var53.x2[1]) >> 2;
    /* 12: convsuslw */
    var55.x2[0] = ORC_CLAMP_UW(var54.x2[0]);
    var55.x2[1] = ORC_CLAMP_UW(var54.x2[1]);
    /* 13: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var46.i;
       _dest.x2[1] = var55.i;
       var43.i = _dest.i;
    }
    /* 14: storeq */
    ptr0[i] = var43;
    /* 15: mulll */
    var56.x2[0] = (((orc_uint32)var50.x2[0]) * ((orc_uint32)var41.x2[0])) & 0xffffffff;
    var56.x2[1] = (((orc_uint32)var50.x2[1]) * ((orc_uint32)var41.x2[1])) & 0xffffffff;
    /* 16: addl */
    var57.x2[0] = ((orc_uint32)var56.x2[0]) + ((orc_uint32)var49.x2[0]);
    var57.x2[1] = ((orc_uint32)var56.x2[1]) + ((orc_uint32)var49.x2[1]);
    /* 17: addl */
    var58.x2[0] = ((orc_uint32)var57.x2[0]) + ((orc_uint32)var42.x2[0]);
    var58.x2[1] = ((orc_uint32)var57.x2[1]) + ((orc_uint32)var42.x2[1]);
    /* 18: shrul */
    var59.x2[0] = ((orc_uint32)var58.x2[0]) >> 2;
    var59.x2[1] = ((orc_uint32)var58.x2[1]) >> 2;
    /* 19: convsuslw */
    var60.x2[0] = ORC_CLAMP_UW(var59.x2[0]);
    var60.x2[1] = ORC_CLAMP_UW(var59.x2[1]);
    /* 20: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var48.i;
       _dest.x2[1] = var60.i;
       var44.i = _dest.i;
    }
    /* 21: storeq */
    ptr1[i] = var44;
  }

}

#else
static void
_backup_video_orc_chroma_up_v2_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  orc_union64 * ORC_RESTRICT ptr1;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var39;
  orc_union64 var40;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union64 var41;
#else
  orc_union64 var41;
#endif
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union64 var42;
#else
  orc_union64 var42;
#endif
  orc_union64 var43;
  orc_union64 var44;
  orc_union32 var45;
  orc_union32 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union64 var49;
  orc_union64 var50;
  orc_union64 var51;
  orc_union64 var52;
  orc_union64 var53;
  orc_union64 var54;
  orc_union32 var55;
  orc_union64 var56;
  orc_union64 var57;
  orc_union64 var58;
  orc_union64 var59;
  orc_union32 var60;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr1 = (orc_union64 *)ex->arrays[1];
  ptr4 = (orc_union64 *)ex->arrays[4];
  ptr5 = (orc_union64 *)ex->arrays[5];

    /* 6: loadpl */
    var41.x2[0] = (int)0x00000003; /* 3 or 1.4822e-323f */
    var41.x2[1] = (int)0x00000003; /* 3 or 1.4822e-323f */
    /* 9: loadpl */
    var42.x2[0] = (int)0x00000002; /* 2 or 9.88131e-324f */
    var42.x2[1] = (int)0x00000002; /* 2 or 9.88131e-324f */

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var39 = ptr4[i];
    /* 1: splitql */
    {
       orc_union64 _src;
       _src.i = var39.i;
       var45.i = _src.x2[1];
       var46.i = _src.x2[0];
    }
    /* 2: loadq */
    var40 = ptr5[i];
    /* 3: splitql */
    {
       orc_union64 _src;
       _src.i = var40.i;
       var47.i = _src.x2[1];
       var48.i = _src.x2[0];
    }
    /* 4: convuwl */
    var49.x2[0] = (orc_uint16)var45.x2[0];
    var49.x2[1] = (orc_uint16)var45.x2[1];
    /* 5: convuwl */
    var50.x2[0] = (orc_uint16)var47.x2[0];
    var50.x2[1] = (orc_uint16)var47.x2[1];
    /* 7: mulll */
    var51.x2[0] = (((orc_uint32)var49.x2[0]) * ((orc_uint32)var41.x2[0])) & 0xffffffff;
    var51.x2[1] = (((orc_uint32)var49.x2[1]) * ((orc_uint32)var41.x2[1])) & 0xffffffff;
    /* 8: addl */
    var52.x2[0] = ((orc_uint32)var51.x2[0]) + ((orc_uint32)var50.x2[0]);
    var52.x2[1] = ((orc_uint32)var51.x2[1]) + ((orc_uint32)var50.x2[1]);
    /* 10: addl */
    var53.x2[0] = ((orc_uint32)var52.x2[0]) + ((orc_uint32)var42.x2[0]);
    var53.x2[1] = ((orc_uint32)var52.x2[1]) + ((orc_uint32)var42.x2[1]);
    /* 11: shrul */
    var54.x2[0] = ((orc_uint32)var53.x2[0]) >> 2;
    var54.x2[1] = ((orc_uint32)var53.x2[1]) >> 2;
    /* 12: convsuslw */
    var55.x2[0] = ORC_CLAMP_UW(var54.x2[0]);
    var55.x2[1] = ORC_CLAMP_UW(var54.x2[1]);
    /* 13: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var46.i;
       _dest.x2[1] = var55.i;
       var43.i = _dest.i;
    }
    /* 14: storeq */
    ptr0[i] = var43;
    /* 15: mulll */
    var56.x2[0] = (((orc_uint32)var50.x2[0]) * ((orc_uint32)var41.x2[0])) & 0xffffffff;
    var56.x2[1] = (((orc_uint32)var50.x2[1]) * ((orc_uint32)var41.x2[1])) & 0xffffffff;
    /* 16: addl */
    var57.x2[0] = ((orc_uint32)var56.x2[0]) + ((orc_uint32)var49.x2[0]);
    var57.x2[1] = ((orc_uint32)var56.x2[1]) + ((orc_uint32)var49.x2[1]);
    /* 17: addl */
    var58.x2[0] = ((orc_uint32)var57.x2[0]) + ((orc_uint32)var42.x2[0]);
    var58.x2[1] = ((orc_uint32)var57.x2[1]) + ((orc_uint32)var42.x2[1]);
    /* 18: shrul */
    var59.x2[0] = ((orc_uint32)var58.x2[0]) >> 2;
    var59.x2[1] = ((orc_uint32)var58.x2[1]) >> 2;
    /* 19: convsuslw */
    var60.x2[0] = ORC_CLAMP_UW(var59.x2[0]);
    var60.x2[1] = ORC_CLAMP_UW(var59.x2[1]);
    /* 20: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var48.i;
       _dest.x2[1] = var60.i;
       var44.i = _dest.i;
    }
    /* 21: storeq */
    ptr1[i] = var44;
  }

}

void
video_orc_chroma_up_v2_u16 (guint16 * ORC_RESTRICT d1, guint16 * ORC_RESTRICT d2, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 26, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 104, 114, 
        111, 109, 97, 95, 117, 112, 95, 118, 50, 95, 117, 49, 54, 11, 8, 8, 
        11, 8, 8, 12, 8, 8, 12, 8, 8, 14, 4, 3, 0, 0, 0, 14, 
        4, 2, 0, 0, 0, 20, 4, 20, 4, 20, 4, 20, 4, 20, 8, 20, 
        8, 20, 8, 197, 34, 32, 4, 197, 35, 33, 5, 21, 1, 154, 36, 34, 
        21, 1, 154, 37, 35, 21, 1, 120, 38, 36, 16, 21, 1, 103, 38, 38, 
        37, 21, 1, 103, 38, 38, 17, 21, 1, 126, 38, 38, 17, 21, 1, 166, 
        34, 38, 194, 0, 32, 34, 21, 1, 120, 38, 37, 16, 21, 1, 103, 38, 
        38, 36, 21, 1, 103, 38, 38, 17, 21, 1, 126, 38, 38, 17, 21, 1, 
        166, 35, 38, 194, 1, 33, 35, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_chroma_up_v2_u16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_chroma_up_v2_u16");
      orc_program_set_backup_function (p, _backup_video_orc_chroma_up_v2_u16);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_destination (p, 8, "d2");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_source (p, 8, "s2");
      orc_program_add_constant (p, 4, 0x00000003, "c1");
      orc_program_add_constant (p, 4, 0x00000002, "c2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 8, "t5");
      orc_program_add_temporary (p, 8, "t6");
      orc_program_add_temporary (p, 8, "t7");

      orc_program_append_2 (p, "splitql", 0, ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "splitql", 0, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 1, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 1, ORC_VAR_T6, ORC_VAR_T4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 1, ORC_VAR_T7, ORC_VAR_T5, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 1, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T6, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 1, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 1, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuslw", 1, ORC_VAR_T3, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mulll", 1, ORC_VAR_T7, ORC_VAR_T6, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 1, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_T5, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 1, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 1, ORC_VAR_T7, ORC_VAR_T7, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuslw", 1, ORC_VAR_T4, ORC_VAR_T7, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_chroma_down_v2_u16 */
#ifdef DISABLE_ORC
void
video_orc_chroma_down_v2_u16 (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var35;
  orc_union64 var36;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union64 *)s1;
  ptr5 = (orc_union64 *)s2;


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var35 = ptr4[i];
    /* 1: splitql */
    {
       orc_union64 _src;
       _src.i = var35.i;
       var38.i = _src.x2[1];
       var39.i = _src.x2[0];
    }
    /* 2: loadq */
    var36 = ptr5[i];
    /* 3: select1ql */
    {
       orc_union64 _src;
       _src.i = var36.i;
       var40.i = _src.x2[1];
    }
    /* 4: avguw */
    var41.x2[0] = ((orc_uint16)var38.x2[0] + (orc_uint16)var40.x2[0] + 1)>>1;
    var41.x2[1] = ((orc_uint16)var38.x2[1] + (orc_uint16)var40.x2[1] + 1)>>1;
    /* 5: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var39.i;
       _dest.x2[1] = var41.i;
       var37.i = _dest.i;
    }
    /* 6: storeq */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_video_orc_chroma_down_v2_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  orc_union64 var35;
  orc_union64 var36;
  orc_union64 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
  orc_union32 var41;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];
  ptr5 = (orc_union64 *)ex->arrays[5];


  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var35 = ptr4[i];
    /* 1: splitql */
    {
       orc_union64 _src;
       _src.i = var35.i;
       var38.i = _src.x2[1];
       var39.i = _src.x2[0];
    }
    /* 2: loadq */
    var36 = ptr5[i];
    /* 3: select1ql */
    {
       orc_union64 _src;
       _src.i = var36.i;
       var40.i = _src.x2[1];
    }
    /* 4: avguw */
    var41.x2[0] = ((orc_uint16)var38.x2[0] + (orc_uint16)var40.x2[0] + 1)>>1;
    var41.x2[1] = ((orc_uint16)var38.x2[1] + (orc_uint16)var40.x2[1] + 1)>>1;
    /* 5: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var39.i;
       _dest.x2[1] = var41.i;
       var37.i = _dest.i;
    }
    /* 6: storeq */
    ptr0[i] = var37;
  }

}

void
video_orc_chroma_down_v2_u16 (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 28, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 104, 114, 
        111, 109, 97, 95, 100, 111, 119, 110, 95, 118, 50, 95, 117, 49, 54, 11, 
        8, 8, 12, 8, 8, 12, 8, 8, 20, 4, 20, 4, 20, 4, 197, 33, 
        32, 4, 193, 34, 5, 21, 1, 76, 33, 33, 34, 194, 0, 32, 33, 2, 
        0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_chroma_down_v2_u16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_chroma_down_v2_u16");
      orc_program_set_backup_function (p, _backup_video_orc_chroma_down_v2_u16);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_source (p, 8, "s2");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 4, "t3");

      orc_program_append_2 (p, "splitql", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1ql", 0, ORC_VAR_T3, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "avguw", 1, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_chroma_down_v4_u8 */
#ifdef DISABLE_ORC
void
video_orc_chroma_down_v4_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  const orc_union32 * ORC_RESTRICT ptr7;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var41;
#else
  orc_union32 var41;
#endif
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union32 var45;
  orc_union16 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union16 var49;
  orc_union32 var50;
  orc_union16 var51;
  orc_union32 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_union32 var58;
  orc_union16 var59;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union32 *)s1;
  ptr5 = (orc_union32 *)s2;
  ptr6 = (orc_union32 *)s3;
  ptr7 = (orc_union32 *)s4;

    /* 17: loadpw */
    var41.x2[0] = (int)0x00000004; /* 4 or 1.97626e-323f */
    var41.x2[1] = (int)0x00000004; /* 4 or 1.97626e-323f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var37 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var37.i;
       var43.i = _src.x2[1];
       var44.i = _src.x2[0];
    }
    /* 2: convubw */
    var45.x2[0] = (orc_uint8)var43.x2[0];
    var45.x2[1] = (orc_uint8)var43.x2[1];
    /* 3: loadl */
    var38 = ptr7[i];
    /* 4: select1lw */
    {
       orc_union32 _src;
       _src.i = var38.i;
       var46.i = _src.x2[1];
    }
    /* 5: convubw */
    var47.x2[0] = (orc_uint8)var46.x2[0];
    var47.x2[1] = (orc_uint8)var46.x2[1];
    /* 6: addw */
    var48.x2[0] = var45.x2[0] + var47.x2[0];
    var48.x2[1] = var45.x2[1] + var47.x2[1];
    /* 7: loadl */
    var39 = ptr5[i];
    /* 8: select1lw */
    {
       orc_union32 _src;
       _src.i = var39.i;
       var49.i = _src.x2[1];
    }
    /* 9: convubw */
    var50.x2[0] = (orc_uint8)var49.x2[0];
    var50.x2[1] = (orc_uint8)var49.x2[1];
    /* 10: loadl */
    var40 = ptr6[i];
    /* 11: select1lw */
    {
       orc_union32 _src;
       _src.i = var40.i;
       var51.i = _src.x2[1];
    }
    /* 12: convubw */
    var52.x2[0] = (orc_uint8)var51.x2[0];
    var52.x2[1] = (orc_uint8)var51.x2[1];
    /* 13: addw */
    var53.x2[0] = var50.x2[0] + var52.x2[0];
    var53.x2[1] = var50.x2[1] + var52.x2[1];
    /* 14: shlw */
    var54.x2[0] = ((orc_uint16)var53.x2[0]) << 1;
    var54.x2[1] = ((orc_uint16)var53.x2[1]) << 1;
    /* 15: addw */
    var55.x2[0] = var53.x2[0] + var54.x2[0];
    var55.x2[1] = var53.x2[1] + var54.x2[1];
    /* 16: addw */
    var56.x2[0] = var48.x2[0] + var55.x2[0];
    var56.x2[1] = var48.x2[1] + var55.x2[1];
    /* 18: addw */
    var57.x2[0] = var56.x2[0] + var41.x2[0];
    var57.x2[1] = var56.x2[1] + var41.x2[1];
    /* 19: shruw */
    var58.x2[0] = ((orc_uint16)var57.x2[0]) >> 3;
    var58.x2[1] = ((orc_uint16)var57.x2[1]) >> 3;
    /* 20: convsuswb */
    var59.x2[0] = ORC_CLAMP_UB(var58.x2[0]);
    var59.x2[1] = ORC_CLAMP_UB(var58.x2[1]);
    /* 21: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var59.i;
       var42.i = _dest.i;
    }
    /* 22: storel */
    ptr0[i] = var42;
  }

}

#else
static void
_backup_video_orc_chroma_down_v4_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union32 * ORC_RESTRICT ptr4;
  const orc_union32 * ORC_RESTRICT ptr5;
  const orc_union32 * ORC_RESTRICT ptr6;
  const orc_union32 * ORC_RESTRICT ptr7;
  orc_union32 var37;
  orc_union32 var38;
  orc_union32 var39;
  orc_union32 var40;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union32 var41;
#else
  orc_union32 var41;
#endif
  orc_union32 var42;
  orc_union16 var43;
  orc_union16 var44;
  orc_union32 var45;
  orc_union16 var46;
  orc_union32 var47;
  orc_union32 var48;
  orc_union16 var49;
  orc_union32 var50;
  orc_union16 var51;
  orc_union32 var52;
  orc_union32 var53;
  orc_union32 var54;
  orc_union32 var55;
  orc_union32 var56;
  orc_union32 var57;
  orc_union32 var58;
  orc_union16 var59;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];
  ptr5 = (orc_union32 *)ex->arrays[5];
  ptr6 = (orc_union32 *)ex->arrays[6];
  ptr7 = (orc_union32 *)ex->arrays[7];

    /* 17: loadpw */
    var41.x2[0] = (int)0x00000004; /* 4 or 1.97626e-323f */
    var41.x2[1] = (int)0x00000004; /* 4 or 1.97626e-323f */

  for (i = 0; i < n; i++) {
    /* 0: loadl */
    var37 = ptr4[i];
    /* 1: splitlw */
    {
       orc_union32 _src;
       _src.i = var37.i;
       var43.i = _src.x2[1];
       var44.i = _src.x2[0];
    }
    /* 2: convubw */
    var45.x2[0] = (orc_uint8)var43.x2[0];
    var45.x2[1] = (orc_uint8)var43.x2[1];
    /* 3: loadl */
    var38 = ptr7[i];
    /* 4: select1lw */
    {
       orc_union32 _src;
       _src.i = var38.i;
       var46.i = _src.x2[1];
    }
    /* 5: convubw */
    var47.x2[0] = (orc_uint8)var46.x2[0];
    var47.x2[1] = (orc_uint8)var46.x2[1];
    /* 6: addw */
    var48.x2[0] = var45.x2[0] + var47.x2[0];
    var48.x2[1] = var45.x2[1] + var47.x2[1];
    /* 7: loadl */
    var39 = ptr5[i];
    /* 8: select1lw */
    {
       orc_union32 _src;
       _src.i = var39.i;
       var49.i = _src.x2[1];
    }
    /* 9: convubw */
    var50.x2[0] = (orc_uint8)var49.x2[0];
    var50.x2[1] = (orc_uint8)var49.x2[1];
    /* 10: loadl */
    var40 = ptr6[i];
    /* 11: select1lw */
    {
       orc_union32 _src;
       _src.i = var40.i;
       var51.i = _src.x2[1];
    }
    /* 12: convubw */
    var52.x2[0] = (orc_uint8)var51.x2[0];
    var52.x2[1] = (orc_uint8)var51.x2[1];
    /* 13: addw */
    var53.x2[0] = var50.x2[0] + var52.x2[0];
    var53.x2[1] = var50.x2[1] + var52.x2[1];
    /* 14: shlw */
    var54.x2[0] = ((orc_uint16)var53.x2[0]) << 1;
    var54.x2[1] = ((orc_uint16)var53.x2[1]) << 1;
    /* 15: addw */
    var55.x2[0] = var53.x2[0] + var54.x2[0];
    var55.x2[1] = var53.x2[1] + var54.x2[1];
    /* 16: addw */
    var56.x2[0] = var48.x2[0] + var55.x2[0];
    var56.x2[1] = var48.x2[1] + var55.x2[1];
    /* 18: addw */
    var57.x2[0] = var56.x2[0] + var41.x2[0];
    var57.x2[1] = var56.x2[1] + var41.x2[1];
    /* 19: shruw */
    var58.x2[0] = ((orc_uint16)var57.x2[0]) >> 3;
    var58.x2[1] = ((orc_uint16)var57.x2[1]) >> 3;
    /* 20: convsuswb */
    var59.x2[0] = ORC_CLAMP_UB(var58.x2[0]);
    var59.x2[1] = ORC_CLAMP_UB(var58.x2[1]);
    /* 21: mergewl */
    {
       orc_union32 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var59.i;
       var42.i = _dest.i;
    }
    /* 22: storel */
    ptr0[i] = var42;
  }

}

void
video_orc_chroma_down_v4_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, const guint8 * ORC_RESTRICT s2, const guint8 * ORC_RESTRICT s3, const guint8 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 104, 114, 
        111, 109, 97, 95, 100, 111, 119, 110, 95, 118, 52, 95, 117, 56, 11, 4, 
        4, 12, 4, 4, 12, 4, 4, 12, 4, 4, 12, 4, 4, 14, 2, 1, 
        0, 0, 0, 14, 2, 4, 0, 0, 0, 14, 2, 3, 0, 0, 0, 20, 
        2, 20, 2, 20, 4, 20, 4, 20, 4, 198, 33, 32, 4, 21, 1, 150, 
        34, 33, 191, 33, 7, 21, 1, 150, 35, 33, 21, 1, 70, 36, 34, 35, 
        191, 33, 5, 21, 1, 150, 34, 33, 191, 33, 6, 21, 1, 150, 35, 33, 
        21, 1, 70, 34, 34, 35, 21, 1, 93, 35, 34, 16, 21, 1, 70, 34, 
        34, 35, 21, 1, 70, 36, 36, 34, 21, 1, 70, 36, 36, 17, 21, 1, 
        95, 36, 36, 18, 21, 1, 160, 33, 36, 195, 0, 32, 33, 2, 0,       };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_chroma_down_v4_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_chroma_down_v4_u8");
      orc_program_set_backup_function (p, _backup_video_orc_chroma_down_v4_u8);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 4, "s1");
      orc_program_add_source (p, 4, "s2");
      orc_program_add_source (p, 4, "s3");
      orc_program_add_source (p, 4, "s4");
      orc_program_add_constant (p, 2, 0x00000001, "c1");
      orc_program_add_constant (p, 2, 0x00000004, "c2");
      orc_program_add_constant (p, 2, 0x00000003, "c3");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");
      orc_program_add_temporary (p, 4, "t3");
      orc_program_add_temporary (p, 4, "t4");
      orc_program_add_temporary (p, 4, "t5");

      orc_program_append_2 (p, "splitlw", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 1, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1lw", 0, ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 1, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 1, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "select1lw", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 1, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1lw", 0, ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 1, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 1, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "shlw", 1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 1, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 1, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 1, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "shruw", 1, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 1, ORC_VAR_T2, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergewl", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_chroma_down_v4_u16 */
#ifdef DISABLE_ORC
void
video_orc_chroma_down_v4_u16 (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, const guint16 * ORC_RESTRICT s3, const guint16 * ORC_RESTRICT s4, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  const orc_union64 * ORC_RESTRICT ptr6;
  const orc_union64 * ORC_RESTRICT ptr7;
  orc_union64 var37;
  orc_union64 var38;
  orc_union64 var39;
  orc_union64 var40;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union64 var41;
#else
  orc_union64 var41;
#endif
  orc_union64 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union64 var45;
  orc_union32 var46;
  orc_union64 var47;
  orc_union64 var48;
  orc_union32 var49;
  orc_union64 var50;
  orc_union32 var51;
  orc_union64 var52;
  orc_union64 var53;
  orc_union64 var54;
  orc_union64 var55;
  orc_union64 var56;
  orc_union64 var57;
  orc_union64 var58;
  orc_union32 var59;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union64 *)s1;
  ptr5 = (orc_union64 *)s2;
  ptr6 = (orc_union64 *)s3;
  ptr7 = (orc_union64 *)s4;

    /* 17: loadpl */
    var41.x2[0] = (int)0x00000004; /* 4 or 1.97626e-323f */
    var41.x2[1] = (int)0x00000004; /* 4 or 1.97626e-323f */

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var37 = ptr4[i];
    /* 1: splitql */
    {
       orc_union64 _src;
       _src.i = var37.i;
       var43.i = _src.x2[1];
       var44.i = _src.x2[0];
    }
    /* 2: convuwl */
    var45.x2[0] = (orc_uint16)var43.x2[0];
    var45.x2[1] = (orc_uint16)var43.x2[1];
    /* 3: loadq */
    var38 = ptr7[i];
    /* 4: select1ql */
    {
       orc_union64 _src;
       _src.i = var38.i;
       var46.i = _src.x2[1];
    }
    /* 5: convuwl */
    var47.x2[0] = (orc_uint16)var46.x2[0];
    var47.x2[1] = (orc_uint16)var46.x2[1];
    /* 6: addl */
    var48.x2[0] = ((orc_uint32)var45.x2[0]) + ((orc_uint32)var47.x2[0]);
    var48.x2[1] = ((orc_uint32)var45.x2[1]) + ((orc_uint32)var47.x2[1]);
    /* 7: loadq */
    var39 = ptr5[i];
    /* 8: select1ql */
    {
       orc_union64 _src;
       _src.i = var39.i;
       var49.i = _src.x2[1];
    }
    /* 9: convuwl */
    var50.x2[0] = (orc_uint16)var49.x2[0];
    var50.x2[1] = (orc_uint16)var49.x2[1];
    /* 10: loadq */
    var40 = ptr6[i];
    /* 11: select1ql */
    {
       orc_union64 _src;
       _src.i = var40.i;
       var51.i = _src.x2[1];
    }
    /* 12: convuwl */
    var52.x2[0] = (orc_uint16)var51.x2[0];
    var52.x2[1] = (orc_uint16)var51.x2[1];
    /* 13: addl */
    var53.x2[0] = ((orc_uint32)var50.x2[0]) + ((orc_uint32)var52.x2[0]);
    var53.x2[1] = ((orc_uint32)var50.x2[1]) + ((orc_uint32)var52.x2[1]);
    /* 14: shll */
    var54.x2[0] = ((orc_uint32)var53.x2[0]) << 1;
    var54.x2[1] = ((orc_uint32)var53.x2[1]) << 1;
    /* 15: addl */
    var55.x2[0] = ((orc_uint32)var53.x2[0]) + ((orc_uint32)var54.x2[0]);
    var55.x2[1] = ((orc_uint32)var53.x2[1]) + ((orc_uint32)var54.x2[1]);
    /* 16: addl */
    var56.x2[0] = ((orc_uint32)var48.x2[0]) + ((orc_uint32)var55.x2[0]);
    var56.x2[1] = ((orc_uint32)var48.x2[1]) + ((orc_uint32)var55.x2[1]);
    /* 18: addl */
    var57.x2[0] = ((orc_uint32)var56.x2[0]) + ((orc_uint32)var41.x2[0]);
    var57.x2[1] = ((orc_uint32)var56.x2[1]) + ((orc_uint32)var41.x2[1]);
    /* 19: shrul */
    var58.x2[0] = ((orc_uint32)var57.x2[0]) >> 3;
    var58.x2[1] = ((orc_uint32)var57.x2[1]) >> 3;
    /* 20: convsuslw */
    var59.x2[0] = ORC_CLAMP_UW(var58.x2[0]);
    var59.x2[1] = ORC_CLAMP_UW(var58.x2[1]);
    /* 21: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var59.i;
       var42.i = _dest.i;
    }
    /* 22: storeq */
    ptr0[i] = var42;
  }

}

#else
static void
_backup_video_orc_chroma_down_v4_u16 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  const orc_union64 * ORC_RESTRICT ptr5;
  const orc_union64 * ORC_RESTRICT ptr6;
  const orc_union64 * ORC_RESTRICT ptr7;
  orc_union64 var37;
  orc_union64 var38;
  orc_union64 var39;
  orc_union64 var40;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union64 var41;
#else
  orc_union64 var41;
#endif
  orc_union64 var42;
  orc_union32 var43;
  orc_union32 var44;
  orc_union64 var45;
  orc_union32 var46;
  orc_union64 var47;
  orc_union64 var48;
  orc_union32 var49;
  orc_union64 var50;
  orc_union32 var51;
  orc_union64 var52;
  orc_union64 var53;
  orc_union64 var54;
  orc_union64 var55;
  orc_union64 var56;
  orc_union64 var57;
  orc_union64 var58;
  orc_union32 var59;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];
  ptr5 = (orc_union64 *)ex->arrays[5];
  ptr6 = (orc_union64 *)ex->arrays[6];
  ptr7 = (orc_union64 *)ex->arrays[7];

    /* 17: loadpl */
    var41.x2[0] = (int)0x00000004; /* 4 or 1.97626e-323f */
    var41.x2[1] = (int)0x00000004; /* 4 or 1.97626e-323f */

  for (i = 0; i < n; i++) {
    /* 0: loadq */
    var37 = ptr4[i];
    /* 1: splitql */
    {
       orc_union64 _src;
       _src.i = var37.i;
       var43.i = _src.x2[1];
       var44.i = _src.x2[0];
    }
    /* 2: convuwl */
    var45.x2[0] = (orc_uint16)var43.x2[0];
    var45.x2[1] = (orc_uint16)var43.x2[1];
    /* 3: loadq */
    var38 = ptr7[i];
    /* 4: select1ql */
    {
       orc_union64 _src;
       _src.i = var38.i;
       var46.i = _src.x2[1];
    }
    /* 5: convuwl */
    var47.x2[0] = (orc_uint16)var46.x2[0];
    var47.x2[1] = (orc_uint16)var46.x2[1];
    /* 6: addl */
    var48.x2[0] = ((orc_uint32)var45.x2[0]) + ((orc_uint32)var47.x2[0]);
    var48.x2[1] = ((orc_uint32)var45.x2[1]) + ((orc_uint32)var47.x2[1]);
    /* 7: loadq */
    var39 = ptr5[i];
    /* 8: select1ql */
    {
       orc_union64 _src;
       _src.i = var39.i;
       var49.i = _src.x2[1];
    }
    /* 9: convuwl */
    var50.x2[0] = (orc_uint16)var49.x2[0];
    var50.x2[1] = (orc_uint16)var49.x2[1];
    /* 10: loadq */
    var40 = ptr6[i];
    /* 11: select1ql */
    {
       orc_union64 _src;
       _src.i = var40.i;
       var51.i = _src.x2[1];
    }
    /* 12: convuwl */
    var52.x2[0] = (orc_uint16)var51.x2[0];
    var52.x2[1] = (orc_uint16)var51.x2[1];
    /* 13: addl */
    var53.x2[0] = ((orc_uint32)var50.x2[0]) + ((orc_uint32)var52.x2[0]);
    var53.x2[1] = ((orc_uint32)var50.x2[1]) + ((orc_uint32)var52.x2[1]);
    /* 14: shll */
    var54.x2[0] = ((orc_uint32)var53.x2[0]) << 1;
    var54.x2[1] = ((orc_uint32)var53.x2[1]) << 1;
    /* 15: addl */
    var55.x2[0] = ((orc_uint32)var53.x2[0]) + ((orc_uint32)var54.x2[0]);
    var55.x2[1] = ((orc_uint32)var53.x2[1]) + ((orc_uint32)var54.x2[1]);
    /* 16: addl */
    var56.x2[0] = ((orc_uint32)var48.x2[0]) + ((orc_uint32)var55.x2[0]);
    var56.x2[1] = ((orc_uint32)var48.x2[1]) + ((orc_uint32)var55.x2[1]);
    /* 18: addl */
    var57.x2[0] = ((orc_uint32)var56.x2[0]) + ((orc_uint32)var41.x2[0]);
    var57.x2[1] = ((orc_uint32)var56.x2[1]) + ((orc_uint32)var41.x2[1]);
    /* 19: shrul */
    var58.x2[0] = ((orc_uint32)var57.x2[0]) >> 3;
    var58.x2[1] = ((orc_uint32)var57.x2[1]) >> 3;
    /* 20: convsuslw */
    var59.x2[0] = ORC_CLAMP_UW(var58.x2[0]);
    var59.x2[1] = ORC_CLAMP_UW(var58.x2[1]);
    /* 21: mergelq */
    {
       orc_union64 _dest;
       _dest.x2[0] = var44.i;
       _dest.x2[1] = var59.i;
       var42.i = _dest.i;
    }
    /* 22: storeq */
    ptr0[i] = var42;
  }

}

void
video_orc_chroma_down_v4_u16 (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, const guint16 * ORC_RESTRICT s2, const guint16 * ORC_RESTRICT s3, const guint16 * ORC_RESTRICT s4, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 28, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 104, 114, 
        111, 109, 97, 95, 100, 111, 119, 110, 95, 118, 52, 95, 117, 49, 54, 11, 
        8, 8, 12, 8, 8, 12, 8, 8, 12, 8, 8, 12, 8, 8, 14, 4, 
        1, 0, 0, 0, 14, 4, 4, 0, 0, 0, 14, 4, 3, 0, 0, 0, 
        20, 4, 20, 4, 20, 8, 20, 8, 20, 8, 197, 33, 32, 4, 21, 1, 
        154, 34, 33, 193, 33, 7, 21, 1, 154, 35, 33, 21, 1, 103, 36, 34, 
        35, 193, 33, 5, 21, 1, 154, 34, 33, 193, 33, 6, 21, 1, 154, 35, 
        33, 21, 1, 103, 34, 34, 35, 21, 1, 124, 35, 34, 16, 21, 1, 103, 
        34, 34, 35, 21, 1, 103, 36, 36, 34, 21, 1, 103, 36, 36, 17, 21, 
        1, 126, 36, 36, 18, 21, 1, 166, 33, 36, 194, 0, 32, 33, 2, 0, 

      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_chroma_down_v4_u16);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_chroma_down_v4_u16");
      orc_program_set_backup_function (p, _backup_video_orc_chroma_down_v4_u16);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_source (p, 8, "s2");
      orc_program_add_source (p, 8, "s3");
      orc_program_add_source (p, 8, "s4");
      orc_program_add_constant (p, 4, 0x00000001, "c1");
      orc_program_add_constant (p, 4, 0x00000004, "c2");
      orc_program_add_constant (p, 4, 0x00000003, "c3");
      orc_program_add_temporary (p, 4, "t1");
      orc_program_add_temporary (p, 4, "t2");
      orc_program_add_temporary (p, 8, "t3");
      orc_program_add_temporary (p, 8, "t4");
      orc_program_add_temporary (p, 8, "t5");

      orc_program_append_2 (p, "splitql", 0, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 1, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1ql", 0, ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 1, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 1, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "select1ql", 0, ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 1, ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "select1ql", 0, ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convuwl", 1, ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 1, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "shll", 1, ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 1, ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 1, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_D1);
      orc_program_append_2 (p, "addl", 1, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "shrul", 1, ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuslw", 1, ORC_VAR_T2, ORC_VAR_T5, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "mergelq", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->arrays[ORC_VAR_S2] = (void *)s2;
  ex->arrays[ORC_VAR_S3] = (void *)s3;
  ex->arrays[ORC_VAR_S4] = (void *)s4;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_dither_none_4u8_mask */
#ifdef DISABLE_ORC
void
video_orc_dither_none_4u8_mask (guint8 * ORC_RESTRICT d1, int p1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *)d1;

    /* 0: loadpl */
    var35.i = p1;

  for (i = 0; i < n; i++) {
    /* 1: loadl */
    var33 = ptr0[i];
    /* 2: andnb */
    var34.x4[0] = (~var35.x4[0]) & var33.x4[0];
    var34.x4[1] = (~var35.x4[1]) & var33.x4[1];
    var34.x4[2] = (~var35.x4[2]) & var33.x4[2];
    var34.x4[3] = (~var35.x4[3]) & var33.x4[3];
    /* 3: storel */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_video_orc_dither_none_4u8_mask (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union32 var33;
  orc_union32 var34;
  orc_union32 var35;

  ptr0 = (orc_union32 *)ex->arrays[0];

    /* 0: loadpl */
    var35.i = ex->params[24];

  for (i = 0; i < n; i++) {
    /* 1: loadl */
    var33 = ptr0[i];
    /* 2: andnb */
    var34.x4[0] = (~var35.x4[0]) & var33.x4[0];
    var34.x4[1] = (~var35.x4[1]) & var33.x4[1];
    var34.x4[2] = (~var35.x4[2]) & var33.x4[2];
    var34.x4[3] = (~var35.x4[3]) & var33.x4[3];
    /* 3: storel */
    ptr0[i] = var34;
  }

}

void
video_orc_dither_none_4u8_mask (guint8 * ORC_RESTRICT d1, int p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 30, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 100, 105, 116, 
        104, 101, 114, 95, 110, 111, 110, 101, 95, 52, 117, 56, 95, 109, 97, 115, 
        107, 11, 4, 4, 16, 4, 20, 4, 115, 32, 24, 21, 2, 37, 0, 32, 
        0, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_dither_none_4u8_mask);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_dither_none_4u8_mask");
      orc_program_set_backup_function (p, _backup_video_orc_dither_none_4u8_mask);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_parameter (p, 4, "p1");
      orc_program_add_temporary (p, 4, "t1");

      orc_program_append_2 (p, "loadpl", 0, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andnb", 2, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_P1] = p1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_dither_none_4u16_mask */
#ifdef DISABLE_ORC
void
video_orc_dither_none_4u16_mask (guint16 * ORC_RESTRICT d1, orc_int64 p1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  orc_union64 var33;
  orc_union64 var34;
  orc_union64 var35;

  ptr0 = (orc_union64 *)d1;

    /* 0: loadpq */
    var35.i = p1;

  for (i = 0; i < n; i++) {
    /* 1: loadq */
    var33 = ptr0[i];
    /* 2: andnw */
    var34.x4[0] = (~var35.x4[0]) & var33.x4[0];
    var34.x4[1] = (~var35.x4[1]) & var33.x4[1];
    var34.x4[2] = (~var35.x4[2]) & var33.x4[2];
    var34.x4[3] = (~var35.x4[3]) & var33.x4[3];
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_video_orc_dither_none_4u16_mask (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  orc_union64 var33;
  orc_union64 var34;
  orc_union64 var35;

  ptr0 = (orc_union64 *)ex->arrays[0];

    /* 0: loadpq */
    var35.i = (ex->params[24] & 0xffffffff) | ((orc_uint64)(ex->params[24 + (ORC_VAR_T1 - ORC_VAR_P1)]) << 32);

  for (i = 0; i < n; i++) {
    /* 1: loadq */
    var33 = ptr0[i];
    /* 2: andnw */
    var34.x4[0] = (~var35.x4[0]) & var33.x4[0];
    var34.x4[1] = (~var35.x4[1]) & var33.x4[1];
    var34.x4[2] = (~var35.x4[2]) & var33.x4[2];
    var34.x4[3] = (~var35.x4[3]) & var33.x4[3];
    /* 3: storeq */
    ptr0[i] = var34;
  }

}

void
video_orc_dither_none_4u16_mask (guint16 * ORC_RESTRICT d1, orc_int64 p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 31, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 100, 105, 116, 
        104, 101, 114, 95, 110, 111, 110, 101, 95, 52, 117, 49, 54, 95, 109, 97, 
        115, 107, 11, 8, 8, 18, 8, 20, 8, 134, 32, 24, 21, 2, 74, 0, 
        32, 0, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_dither_none_4u16_mask);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_dither_none_4u16_mask");
      orc_program_set_backup_function (p, _backup_video_orc_dither_none_4u16_mask);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_parameter_int64 (p, 8, "p1");
      orc_program_add_temporary (p, 8, "t1");

      orc_program_append_2 (p, "loadpq", 0, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "andnw", 2, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  {
    orc_union64 tmp;
    tmp.i = p1;
    ex->params[ORC_VAR_P1] = ((orc_uint64) tmp.i) & 0xffffffff;
    ex->params[ORC_VAR_T1] = ((orc_uint64) tmp.i) >> 32;
  }

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_dither_verterr_4u8_mask */
#ifdef DISABLE_ORC
void
video_orc_dither_verterr_4u8_mask (guint8 * ORC_RESTRICT d1, guint16 * ORC_RESTRICT d2, orc_int64 p1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union64 * ORC_RESTRICT ptr1;
  orc_union32 var34;
  orc_union64 var35;
  orc_union64 var36;
  orc_union32 var37;
  orc_union64 var38;
  orc_union64 var39;
  orc_union64 var40;
  orc_union64 var41;

  ptr0 = (orc_union32 *)d1;
  ptr1 = (orc_union64 *)d2;

    /* 0: loadpq */
    var38.i = p1;

  for (i = 0; i < n; i++) {
    /* 1: loadl */
    var34 = ptr0[i];
    /* 2: convubw */
    var39.x4[0] = (orc_uint8)var34.x4[0];
    var39.x4[1] = (orc_uint8)var34.x4[1];
    var39.x4[2] = (orc_uint8)var34.x4[2];
    var39.x4[3] = (orc_uint8)var34.x4[3];
    /* 3: loadq */
    var35 = ptr1[i];
    /* 4: addw */
    var40.x4[0] = var35.x4[0] + var39.x4[0];
    var40.x4[1] = var35.x4[1] + var39.x4[1];
    var40.x4[2] = var35.x4[2] + var39.x4[2];
    var40.x4[3] = var35.x4[3] + var39.x4[3];
    /* 5: andw */
    var36.x4[0] = var38.x4[0] & var40.x4[0];
    var36.x4[1] = var38.x4[1] & var40.x4[1];
    var36.x4[2] = var38.x4[2] & var40.x4[2];
    var36.x4[3] = var38.x4[3] & var40.x4[3];
    /* 6: storeq */
    ptr1[i] = var36;
    /* 7: andnw */
    var41.x4[0] = (~var38.x4[0]) & var40.x4[0];
    var41.x4[1] = (~var38.x4[1]) & var40.x4[1];
    var41.x4[2] = (~var38.x4[2]) & var40.x4[2];
    var41.x4[3] = (~var38.x4[3]) & var40.x4[3];
    /* 8: convsuswb */
    var37.x4[0] = ORC_CLAMP_UB(var41.x4[0]);
    var37.x4[1] = ORC_CLAMP_UB(var41.x4[1]);
    var37.x4[2] = ORC_CLAMP_UB(var41.x4[2]);
    var37.x4[3] = ORC_CLAMP_UB(var41.x4[3]);
    /* 9: storel */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_video_orc_dither_verterr_4u8_mask (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  orc_union64 * ORC_RESTRICT ptr1;
  orc_union32 var34;
  orc_union64 var35;
  orc_union64 var36;
  orc_union32 var37;
  orc_union64 var38;
  orc_union64 var39;
  orc_union64 var40;
  orc_union64 var41;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr1 = (orc_union64 *)ex->arrays[1];

    /* 0: loadpq */
    var38.i = (ex->params[24] & 0xffffffff) | ((orc_uint64)(ex->params[24 + (ORC_VAR_T1 - ORC_VAR_P1)]) << 32);

  for (i = 0; i < n; i++) {
    /* 1: loadl */
    var34 = ptr0[i];
    /* 2: convubw */
    var39.x4[0] = (orc_uint8)var34.x4[0];
    var39.x4[1] = (orc_uint8)var34.x4[1];
    var39.x4[2] = (orc_uint8)var34.x4[2];
    var39.x4[3] = (orc_uint8)var34.x4[3];
    /* 3: loadq */
    var35 = ptr1[i];
    /* 4: addw */
    var40.x4[0] = var35.x4[0] + var39.x4[0];
    var40.x4[1] = var35.x4[1] + var39.x4[1];
    var40.x4[2] = var35.x4[2] + var39.x4[2];
    var40.x4[3] = var35.x4[3] + var39.x4[3];
    /* 5: andw */
    var36.x4[0] = var38.x4[0] & var40.x4[0];
    var36.x4[1] = var38.x4[1] & var40.x4[1];
    var36.x4[2] = var38.x4[2] & var40.x4[2];
    var36.x4[3] = var38.x4[3] & var40.x4[3];
    /* 6: storeq */
    ptr1[i] = var36;
    /* 7: andnw */
    var41.x4[0] = (~var38.x4[0]) & var40.x4[0];
    var41.x4[1] = (~var38.x4[1]) & var40.x4[1];
    var41.x4[2] = (~var38.x4[2]) & var40.x4[2];
    var41.x4[3] = (~var38.x4[3]) & var40.x4[3];
    /* 8: convsuswb */
    var37.x4[0] = ORC_CLAMP_UB(var41.x4[0]);
    var37.x4[1] = ORC_CLAMP_UB(var41.x4[1]);
    var37.x4[2] = ORC_CLAMP_UB(var41.x4[2]);
    var37.x4[3] = ORC_CLAMP_UB(var41.x4[3]);
    /* 9: storel */
    ptr0[i] = var37;
  }

}

void
video_orc_dither_verterr_4u8_mask (guint8 * ORC_RESTRICT d1, guint16 * ORC_RESTRICT d2, orc_int64 p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 33, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 100, 105, 116, 
        104, 101, 114, 95, 118, 101, 114, 116, 101, 114, 114, 95, 52, 117, 56, 95, 
        109, 97, 115, 107, 11, 4, 4, 11, 8, 8, 18, 8, 20, 8, 20, 8, 
        134, 32, 24, 21, 2, 150, 33, 0, 21, 2, 70, 33, 1, 33, 21, 2, 
        73, 1, 32, 33, 21, 2, 74, 33, 32, 33, 21, 2, 160, 0, 33, 2, 
        0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_dither_verterr_4u8_mask);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_dither_verterr_4u8_mask");
      orc_program_set_backup_function (p, _backup_video_orc_dither_verterr_4u8_mask);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_destination (p, 8, "d2");
      orc_program_add_parameter_int64 (p, 8, "p1");
      orc_program_add_temporary (p, 8, "t1");
      orc_program_add_temporary (p, 8, "t2");

      orc_program_append_2 (p, "loadpq", 0, ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 2, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 2, ORC_VAR_T2, ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "andw", 2, ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "andnw", 2, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 2, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_D2] = d2;
  {
    orc_union64 tmp;
    tmp.i = p1;
    ex->params[ORC_VAR_P1] = ((orc_uint64) tmp.i) & 0xffffffff;
    ex->params[ORC_VAR_T1] = ((orc_uint64) tmp.i) >> 32;
  }

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_dither_fs_muladd_u8 */
#ifdef DISABLE_ORC
void
video_orc_dither_fs_muladd_u8 (guint16 * ORC_RESTRICT d1, int n){
  int i;
  orc_union16 * ORC_RESTRICT ptr0;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union16 *)d1;

    /* 1: loadpw */
    var34.i = (int)0x00000005; /* 5 or 2.47033e-323f */
    /* 6: loadpw */
    var36.i = (int)0x00000003; /* 3 or 1.4822e-323f */

  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var38 = ptr0[i + 4];
    /* 2: mullw */
    var39.i = (var38.i * var34.i) & 0xffff;
    /* 3: loadw */
    var35 = ptr0[i];
    /* 4: addw */
    var40.i = var39.i + var35.i;
    /* 5: loadoffw */
    var41 = ptr0[i + 8];
    /* 7: mullw */
    var42.i = (var41.i * var36.i) & 0xffff;
    /* 8: addw */
    var37.i = var40.i + var42.i;
    /* 9: storew */
    ptr0[i] = var37;
  }

}

#else
static void
_backup_video_orc_dither_fs_muladd_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union16 * ORC_RESTRICT ptr0;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var34;
#else
  orc_union16 var34;
#endif
  orc_union16 var35;
#if defined(__APPLE__) && __GNUC__ == 4 && __GNUC_MINOR__ == 2 && defined (__i386__) 
  volatile orc_union16 var36;
#else
  orc_union16 var36;
#endif
  orc_union16 var37;
  orc_union16 var38;
  orc_union16 var39;
  orc_union16 var40;
  orc_union16 var41;
  orc_union16 var42;

  ptr0 = (orc_union16 *)ex->arrays[0];

    /* 1: loadpw */
    var34.i = (int)0x00000005; /* 5 or 2.47033e-323f */
    /* 6: loadpw */
    var36.i = (int)0x00000003; /* 3 or 1.4822e-323f */

  for (i = 0; i < n; i++) {
    /* 0: loadoffw */
    var38 = ptr0[i + 4];
    /* 2: mullw */
    var39.i = (var38.i * var34.i) & 0xffff;
    /* 3: loadw */
    var35 = ptr0[i];
    /* 4: addw */
    var40.i = var39.i + var35.i;
    /* 5: loadoffw */
    var41 = ptr0[i + 8];
    /* 7: mullw */
    var42.i = (var41.i * var36.i) & 0xffff;
    /* 8: addw */
    var37.i = var40.i + var42.i;
    /* 9: storew */
    ptr0[i] = var37;
  }

}

void
video_orc_dither_fs_muladd_u8 (guint16 * ORC_RESTRICT d1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 29, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 100, 105, 116, 
        104, 101, 114, 95, 102, 115, 95, 109, 117, 108, 97, 100, 100, 95, 117, 56, 
        11, 2, 2, 14, 4, 4, 0, 0, 0, 14, 2, 5, 0, 0, 0, 14, 
        4, 8, 0, 0, 0, 14, 2, 3, 0, 0, 0, 20, 2, 20, 2, 83, 
        33, 0, 16, 89, 33, 33, 17, 70, 32, 33, 0, 83, 33, 0, 18, 89, 
        33, 33, 19, 70, 0, 32, 33, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_dither_fs_muladd_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_dither_fs_muladd_u8");
      orc_program_set_backup_function (p, _backup_video_orc_dither_fs_muladd_u8);
      orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 4, 0x00000004, "c1");
      orc_program_add_constant (p, 2, 0x00000005, "c2");
      orc_program_add_constant (p, 4, 0x00000008, "c3");
      orc_program_add_constant (p, 2, 0x00000003, "c4");
      orc_program_add_temporary (p, 2, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_C1, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "loadoffw", 0, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_C3, ORC_VAR_D1);
      orc_program_append_2 (p, "mullw", 0, ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_dither_ordered_u8 */
#ifdef DISABLE_ORC
void
video_orc_dither_ordered_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n){
  int i;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)d1;
  ptr4 = (orc_int8 *)s1;


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr0[i];
    /* 1: loadb */
    var33 = ptr4[i];
    /* 2: addusb */
    var34 = ORC_CLAMP_UB((orc_uint8)var32 + (orc_uint8)var33);
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

#else
static void
_backup_video_orc_dither_ordered_u8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_int8 * ORC_RESTRICT ptr4;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];


  for (i = 0; i < n; i++) {
    /* 0: loadb */
    var32 = ptr0[i];
    /* 1: loadb */
    var33 = ptr4[i];
    /* 2: addusb */
    var34 = ORC_CLAMP_UB((orc_uint8)var32 + (orc_uint8)var33);
    /* 3: storeb */
    ptr0[i] = var34;
  }

}

void
video_orc_dither_ordered_u8 (guint8 * ORC_RESTRICT d1, const guint8 * ORC_RESTRICT s1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 27, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 100, 105, 116, 
        104, 101, 114, 95, 111, 114, 100, 101, 114, 101, 100, 95, 117, 56, 11, 1, 
        1, 12, 1, 1, 35, 0, 0, 4, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_dither_ordered_u8);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_dither_ordered_u8");
      orc_program_set_backup_function (p, _backup_video_orc_dither_ordered_u8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 1, "s1");

      orc_program_append_2 (p, "addusb", 0, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_dither_ordered_4u8_mask */
#ifdef DISABLE_ORC
void
video_orc_dither_ordered_4u8_mask (guint8 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, orc_int64 p1, int n){
  int i;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union64 var35;
  orc_union32 var36;
  orc_union64 var37;
  orc_union64 var38;
  orc_union64 var39;
  orc_union64 var40;

  ptr0 = (orc_union32 *)d1;
  ptr4 = (orc_union64 *)s1;

    /* 0: loadpq */
    var37.i = p1;

  for (i = 0; i < n; i++) {
    /* 1: loadl */
    var34 = ptr0[i];
    /* 2: convubw */
    var38.x4[0] = (orc_uint8)var34.x4[0];
    var38.x4[1] = (orc_uint8)var34.x4[1];
    var38.x4[2] = (orc_uint8)var34.x4[2];
    var38.x4[3] = (orc_uint8)var34.x4[3];
    /* 3: loadq */
    var35 = ptr4[i];
    /* 4: addw */
    var39.x4[0] = var38.x4[0] + var35.x4[0];
    var39.x4[1] = var38.x4[1] + var35.x4[1];
    var39.x4[2] = var38.x4[2] + var35.x4[2];
    var39.x4[3] = var38.x4[3] + var35.x4[3];
    /* 5: andnw */
    var40.x4[0] = (~var37.x4[0]) & var39.x4[0];
    var40.x4[1] = (~var37.x4[1]) & var39.x4[1];
    var40.x4[2] = (~var37.x4[2]) & var39.x4[2];
    var40.x4[3] = (~var37.x4[3]) & var39.x4[3];
    /* 6: convsuswb */
    var36.x4[0] = ORC_CLAMP_UB(var40.x4[0]);
    var36.x4[1] = ORC_CLAMP_UB(var40.x4[1]);
    var36.x4[2] = ORC_CLAMP_UB(var40.x4[2]);
    var36.x4[3] = ORC_CLAMP_UB(var40.x4[3]);
    /* 7: storel */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_video_orc_dither_ordered_4u8_mask (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union32 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union32 var34;
  orc_union64 var35;
  orc_union32 var36;
  orc_union64 var37;
  orc_union64 var38;
  orc_union64 var39;
  orc_union64 var40;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];

    /* 0: loadpq */
    var37.i = (ex->params[24] & 0xffffffff) | ((orc_uint64)(ex->params[24 + (ORC_VAR_T1 - ORC_VAR_P1)]) << 32);

  for (i = 0; i < n; i++) {
    /* 1: loadl */
    var34 = ptr0[i];
    /* 2: convubw */
    var38.x4[0] = (orc_uint8)var34.x4[0];
    var38.x4[1] = (orc_uint8)var34.x4[1];
    var38.x4[2] = (orc_uint8)var34.x4[2];
    var38.x4[3] = (orc_uint8)var34.x4[3];
    /* 3: loadq */
    var35 = ptr4[i];
    /* 4: addw */
    var39.x4[0] = var38.x4[0] + var35.x4[0];
    var39.x4[1] = var38.x4[1] + var35.x4[1];
    var39.x4[2] = var38.x4[2] + var35.x4[2];
    var39.x4[3] = var38.x4[3] + var35.x4[3];
    /* 5: andnw */
    var40.x4[0] = (~var37.x4[0]) & var39.x4[0];
    var40.x4[1] = (~var37.x4[1]) & var39.x4[1];
    var40.x4[2] = (~var37.x4[2]) & var39.x4[2];
    var40.x4[3] = (~var37.x4[3]) & var39.x4[3];
    /* 6: convsuswb */
    var36.x4[0] = ORC_CLAMP_UB(var40.x4[0]);
    var36.x4[1] = ORC_CLAMP_UB(var40.x4[1]);
    var36.x4[2] = ORC_CLAMP_UB(var40.x4[2]);
    var36.x4[3] = ORC_CLAMP_UB(var40.x4[3]);
    /* 7: storel */
    ptr0[i] = var36;
  }

}

void
video_orc_dither_ordered_4u8_mask (guint8 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, orc_int64 p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 33, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 100, 105, 116, 
        104, 101, 114, 95, 111, 114, 100, 101, 114, 101, 100, 95, 52, 117, 56, 95, 
        109, 97, 115, 107, 11, 4, 4, 12, 8, 8, 18, 8, 20, 8, 20, 8, 
        134, 33, 24, 21, 2, 150, 32, 0, 21, 2, 70, 32, 32, 4, 21, 2, 
        74, 32, 33, 32, 21, 2, 160, 0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_dither_ordered_4u8_mask);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_dither_ordered_4u8_mask");
      orc_program_set_backup_function (p, _backup_video_orc_dither_ordered_4u8_mask);
      orc_program_add_destination (p, 4, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_parameter_int64 (p, 8, "p1");
      orc_program_add_temporary (p, 8, "t1");
      orc_program_add_temporary (p, 8, "t2");

      orc_program_append_2 (p, "loadpq", 0, ORC_VAR_T2, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convubw", 2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addw", 2, ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "andnw", 2, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
      orc_program_append_2 (p, "convsuswb", 2, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  {
    orc_union64 tmp;
    tmp.i = p1;
    ex->params[ORC_VAR_P1] = ((orc_uint64) tmp.i) & 0xffffffff;
    ex->params[ORC_VAR_T1] = ((orc_uint64) tmp.i) >> 32;
  }

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_dither_ordered_4u16_mask */
#ifdef DISABLE_ORC
void
video_orc_dither_ordered_4u16_mask (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, orc_int64 p1, int n){
  int i;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var34;
  orc_union64 var35;
  orc_union64 var36;
  orc_union64 var37;
  orc_union64 var38;

  ptr0 = (orc_union64 *)d1;
  ptr4 = (orc_union64 *)s1;

    /* 0: loadpq */
    var37.i = p1;

  for (i = 0; i < n; i++) {
    /* 1: loadq */
    var34 = ptr0[i];
    /* 2: loadq */
    var35 = ptr4[i];
    /* 3: addusw */
    var38.x4[0] = ORC_CLAMP_UW((orc_uint16)var34.x4[0] + (orc_uint16)var35.x4[0]);
    var38.x4[1] = ORC_CLAMP_UW((orc_uint16)var34.x4[1] + (orc_uint16)var35.x4[1]);
    var38.x4[2] = ORC_CLAMP_UW((orc_uint16)var34.x4[2] + (orc_uint16)var35.x4[2]);
    var38.x4[3] = ORC_CLAMP_UW((orc_uint16)var34.x4[3] + (orc_uint16)var35.x4[3]);
    /* 4: andnw */
    var36.x4[0] = (~var37.x4[0]) & var38.x4[0];
    var36.x4[1] = (~var37.x4[1]) & var38.x4[1];
    var36.x4[2] = (~var37.x4[2]) & var38.x4[2];
    var36.x4[3] = (~var37.x4[3]) & var38.x4[3];
    /* 5: storeq */
    ptr0[i] = var36;
  }

}

#else
static void
_backup_video_orc_dither_ordered_4u16_mask (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int n = ex->n;
  orc_union64 * ORC_RESTRICT ptr0;
  const orc_union64 * ORC_RESTRICT ptr4;
  orc_union64 var34;
  orc_union64 var35;
  orc_union64 var36;
  orc_union64 var37;
  orc_union64 var38;

  ptr0 = (orc_union64 *)ex->arrays[0];
  ptr4 = (orc_union64 *)ex->arrays[4];

    /* 0: loadpq */
    var37.i = (ex->params[24] & 0xffffffff) | ((orc_uint64)(ex->params[24 + (ORC_VAR_T1 - ORC_VAR_P1)]) << 32);

  for (i = 0; i < n; i++) {
    /* 1: loadq */
    var34 = ptr0[i];
    /* 2: loadq */
    var35 = ptr4[i];
    /* 3: addusw */
    var38.x4[0] = ORC_CLAMP_UW((orc_uint16)var34.x4[0] + (orc_uint16)var35.x4[0]);
    var38.x4[1] = ORC_CLAMP_UW((orc_uint16)var34.x4[1] + (orc_uint16)var35.x4[1]);
    var38.x4[2] = ORC_CLAMP_UW((orc_uint16)var34.x4[2] + (orc_uint16)var35.x4[2]);
    var38.x4[3] = ORC_CLAMP_UW((orc_uint16)var34.x4[3] + (orc_uint16)var35.x4[3]);
    /* 4: andnw */
    var36.x4[0] = (~var37.x4[0]) & var38.x4[0];
    var36.x4[1] = (~var37.x4[1]) & var38.x4[1];
    var36.x4[2] = (~var37.x4[2]) & var38.x4[2];
    var36.x4[3] = (~var37.x4[3]) & var38.x4[3];
    /* 5: storeq */
    ptr0[i] = var36;
  }

}

void
video_orc_dither_ordered_4u16_mask (guint16 * ORC_RESTRICT d1, const guint16 * ORC_RESTRICT s1, orc_int64 p1, int n)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 9, 34, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 100, 105, 116, 
        104, 101, 114, 95, 111, 114, 100, 101, 114, 101, 100, 95, 52, 117, 49, 54, 
        95, 109, 97, 115, 107, 11, 8, 8, 12, 8, 8, 18, 8, 20, 8, 20, 
        8, 134, 33, 24, 21, 2, 72, 32, 0, 4, 21, 2, 74, 0, 33, 32, 
        2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_dither_ordered_4u16_mask);
#else
      p = orc_program_new ();
      orc_program_set_name (p, "video_orc_dither_ordered_4u16_mask");
      orc_program_set_backup_function (p, _backup_video_orc_dither_ordered_4u16_mask);
      orc_program_add_destination (p, 8, "d1");
      orc_program_add_source (p, 8, "s1");
      orc_program_add_parameter_int64 (p, 8, "p1");
      orc_program_add_temporary (p, 8, "t1");
      orc_program_add_temporary (p, 8, "t2");

      orc_program_append_2 (p, "loadpq", 0, ORC_VAR_T2, ORC_VAR_P1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "addusw", 2, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);
      orc_program_append_2 (p, "andnw", 2, ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  {
    orc_union64 tmp;
    tmp.i = p1;
    ex->params[ORC_VAR_P1] = ((orc_uint64) tmp.i) & 0xffffffff;
    ex->params[ORC_VAR_T1] = ((orc_uint64) tmp.i) >> 32;
  }

  func = c->exec;
  func (ex);
}
#endif


/* video_orc_convert_UYVY_GRAY8 */
#ifdef DISABLE_ORC
void
video_orc_convert_UYVY_GRAY8 (guint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint16 * ORC_RESTRICT s1, int s1_stride, int n, int m){
  int i;
  int j;
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_int8 var35;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(d1, d1_stride * j);
    ptr4 = ORC_PTR_OFFSET(s1, s1_stride * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr4[i];
      /* 1: convhwb */
      var35 = ((orc_uint16)var34.i)>>8;
      /* 2: storeb */
      ptr0[i] = var35;
    }
  }

}

#else
static void
_backup_video_orc_convert_UYVY_GRAY8 (OrcExecutor * ORC_RESTRICT ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  orc_int8 * ORC_RESTRICT ptr0;
  const orc_union16 * ORC_RESTRICT ptr4;
  orc_union16 var34;
  orc_int8 var35;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);


    for (i = 0; i < n; i++) {
      /* 0: loadw */
      var34 = ptr4[i];
      /* 1: convhwb */
      var35 = ((orc_uint16)var34.i)>>8;
      /* 2: storeb */
      ptr0[i] = var35;
    }
  }

}

void
video_orc_convert_UYVY_GRAY8 (guint8 * ORC_RESTRICT d1, int d1_stride, const orc_uint16 * ORC_RESTRICT s1, int s1_stride, int n, int m)
{
  OrcExecutor _ex, *ex = &_ex;
  static volatile int p_inited = 0;
  static OrcCode *c = 0;
  void (*func) (OrcExecutor *);

  if (!p_inited) {
    orc_once_mutex_lock ();
    if (!p_inited) {
      OrcProgram *p;

#if 1
      static const orc_uint8 bc[] = {
        1, 7, 9, 28, 118, 105, 100, 101, 111, 95, 111, 114, 99, 95, 99, 111, 
        110, 118, 101, 114, 116, 95, 85, 89, 86, 89, 95, 71, 82, 65, 89, 56, 
        11, 1, 1, 12, 2, 2, 20, 1, 20, 2, 82, 33, 4, 158, 32, 33, 
        64, 0, 32, 2, 0, 
      };
      p = orc_program_new_from_static_bytecode (bc);
      orc_program_set_backup_function (p, _backup_video_orc_convert_UYVY_GRAY8);
#else
      p = orc_program_new ();
      orc_program_set_2d (p);
      orc_program_set_name (p, "video_orc_convert_UYVY_GRAY8");
      orc_program_set_backup_function (p, _backup_video_orc_convert_UYVY_GRAY8);
      orc_program_add_destination (p, 1, "d1");
      orc_program_add_source (p, 2, "s1");
      orc_program_add_temporary (p, 1, "t1");
      orc_program_add_temporary (p, 2, "t2");

      orc_program_append_2 (p, "loadw", 0, ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "convhwb", 0, ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1, ORC_VAR_D1);
      orc_program_append_2 (p, "storeb", 0, ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
#endif

      orc_program_compile (p);
      c = orc_program_take_code (p);
      orc_program_free (p);
    }
    p_inited = TRUE;
    orc_once_mutex_unlock ();
  }
  ex->arrays[ORC_VAR_A2] = c;
  ex->program = 0;

  ex->n = n;
  ORC_EXECUTOR_M(ex) = m;
  ex->arrays[ORC_VAR_D1] = d1;
  ex->params[ORC_VAR_D1] = d1_stride;
  ex->arrays[ORC_VAR_S1] = (void *)s1;
  ex->params[ORC_VAR_S1] = s1_stride;

  func = c->exec;
  func (ex);
}
#endif


