/*
 * Copyright (C) 2004, 2005, 2007, 2009, 2011, 2012  Internet Systems Consortium, Inc. ("ISC")
 * Copyright (C) 2000, 2001  Internet Software Consortium.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/* $Id$ */

#ifndef ISC_TASK_P_H
#define ISC_TASK_P_H

/*! \file */

#if defined(BIND9) && defined(ISC_PLATFORM_USETHREADS)
void
isc__taskmgr_pause(isc_taskmgr_t *taskmgr);

void
isc__taskmgr_resume(isc_taskmgr_t *taskmgr);
#else
isc_boolean_t
isc__taskmgr_ready(isc_taskmgr_t *taskmgr);

isc_result_t
isc__taskmgr_dispatch(isc_taskmgr_t *taskmgr);
#endif /* !BIND9 || !ISC_PLATFORM_USETHREADS */

#endif /* ISC_TASK_P_H */

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/tags/7.0.0/GA/lib/io-pkt/dist/ntp/lib/isc/task_p.h $ $Rev: 777476 $")
#endif
