#include "config.h"

#include "ntp_stdlib.h"

#include "unity.h"

void test_NonLeapYearFebruary(void);
void test_NonLeapYearJune(void);
void test_LeapYearFebruary(void);
void test_LeapYearDecember(void);


void
test_NonLeapYearFebruary(void) {
	TEST_ASSERT_EQUAL(31 + 20, ymd2yd(2010, 2, 20)); //2010-02-20
}


void
test_NonLeapYearJune(void) {
	int expected = 31+28+31+30+31+18; // 18 June non-leap year
	TEST_ASSERT_EQUAL(expected, ymd2yd(2011, 6, 18));
}


void
test_LeapYearFebruary(void) {
	TEST_ASSERT_EQUAL(31 + 20, ymd2yd(2012, 2, 20)); //2012-02-20 (leap year)
}


void
test_LeapYearDecember(void) {
	// 2012-12-31
	int expected = 31+29+31+30+31+30+31+31+30+31+30+31;
	TEST_ASSERT_EQUAL(expected, ymd2yd(2012, 12, 31));
}

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/tags/7.0.0/GA/lib/io-pkt/dist/ntp/tests/libntp/ymd2yd.c $ $Rev: 799952 $")
#endif
