/* The following source file contains modifications to the
 * original elvis source.
 *
 * 2009-04-29 Removed trailing ; character from __SRCVERSION macro for ansi C compliance
 * 2009-04-08 - Added __SRCVERSION macro.
 *
 * Please report issue directly to QNX. */

/* config.h */

/* Originally, this file was automatically generated by the "configure"
 * shell script.
 *
 * This file contains C macro definitions which indicate which features
 * are to be supported, and which library functions are to be emulated.
 * In general, #define enables the feature or emulating function, and
 * #undef disables the feature or causes the library function to be used.
 */


/* The following determine which user interfaces are to be supported */
#undef	GUI_GNOME	/* Pretty GNOME user interface */
#undef	GUI_X11		/* simple X-windows interface */
#undef	GUI_CURSES	/* curses interface */
#define	GUI_TERMCAP	/* termcap interface */
#define	GUI_OPEN	/* open-mode only, does nothing fancy */


/* These allow you to selectively disable the display modes, network protocols,
 * and other optional features.  If you disable the markup display modes then
 * the :help command is disabled because it depends on the "html" markup display
 * mode.  #define to enable the mode, #undef to exclude it.
 */
#define	DISPLAY_HEX	/* hex		interactive hex dump */
#define	DISPLAY_HTML	/* html		formatted text */
#define	DISPLAY_MAN	/* man		formatted text */
#define	DISPLAY_TEX	/* tex		formatted text */
#define	DISPLAY_SYNTAX	/* syntax	generic syntax coloring */
#define	PROTOCOL_HTTP	/* define to enable HTTP; undef to disable */
#define	PROTOCOL_FTP	/* define to enable FTP; undef to disable */
#define	FEATURE_ALIAS	/* the :alias command */
#define	FEATURE_ARRAY	/* arrays in :calc expressions */
#define	FEATURE_AUTOCMD	/* the :autocmd command */
#define	FEATURE_BACKTICK /* the `program` notation in file names */
#define	FEATURE_BROWSE	/* the :browse and :sbrowse commands */
#define	FEATURE_CACHEDESC /* store syntax/markup descriptions in RAM */
#define	FEATURE_CALC	/* built-in calculator -- see command below */
#define	FEATURE_COMPLETE /* filename completion */
#define	FEATURE_EQUALTILDE /* :let option =~ excmdline */
#define	FEATURE_FOLD	/* the :fold and :unfold commands */
#define	FEATURE_G	/* most of the visual 'g' commands */
#define	FEATURE_HLOBJECT /* the hlobject and hllayers options */
#define	FEATURE_HLSEARCH  /* the hlsearch option */
#undef	FEATURE_IMAGE	/* background images in x11 */
#define	FEATURE_INCSEARCH /* the incsearch option */
#define	FEATURE_LISTCHARS /* the "listchars" option */
#define	FEATURE_LITRE	/* accelerate searches for literal strings */
#define	FEATURE_LPR	/* the :lpr command */
#define	FEATURE_MAKE	/* the :make and :cc commands */
#define	FEATURE_MAPDB	/* the map debugger */
#define	FEATURE_MISC	/* lots of little things -- see comment below */
#define	FEATURE_MKEXRC	/* the :mkexrc command */
#define	FEATURE_NORMAL	/* vim-style :normal command */
#define	FEATURE_PROTO	/* using aliases to add new protocols */
#undef	FEATURE_RAM	/* store edit buffer in RAM if "-f ram" */
#define	FEATURE_RCSID	/* include RCS Id strings for all source files */
#define FEATURE_REGION	/* the :region and :unregion commands */
#define	FEATURE_SHOWTAG	/* the showtag option */
#define	FEATURE_SMARTARGS /* the smartargs option */
#define	FEATURE_SPELL	/* spell-checker */
#define	FEATURE_SPLIT	/* :split and friends */
#define	FEATURE_STDIN	/* ability to read from stdin for "-" filename */
#define	FEATURE_TAGS	/* :tag command -- undef'ing will break ref & ctags */
#define	FEATURE_TEXTOBJ	/* text objects */
#define	FEATURE_V	/* the v/V/^V marking commands */
#undef	FEATURE_XFT	/* support antialiased fonts in "x11" */

/* The FEATURE_CALC option, above, controls whether the calculator and all of
 * the features that depend on it should be included in elvis.  You almost
 * certainly want to leave it defined, except on a tiny "rescue" system,
 * since undef'ing it will disable the following features:
 *  o The :calc, :case, :default, :do, :eval, :for, :if, :let, :switch, and
 *    :while commands.  (But :then and :else are still supported for :try)
 *  o The elvis.ini, elvis.brf, elvis.arf, elvis.bwf, elvis.awf initialization
 *    scripts (though ~/.exrc will still be sourced, and elvis will use some
 *    hardcoded rules to guess an appropriate bufdisplay setting.)
 *  o The ability to compute buffer names via :(=expression)
 *  o Expansion of environment variables in file names.
 *  o Some parts of messages and browser headers.
 *  o Ability to use $1 and $2 in keywordprg, makeprg, and ccprg options.
 */

/* The FEATURE_MISC option, above, controls a large number of features which
 * are handy in normal daily use, but might not be needed on a tiny "rescue"
 * system.  Undef'ing FEATURE misc will disable the following features:
 *  o The :@, :all, :bb, :bu, :help, :local, :stack, :window, and :z commands
 *  o Session recovery after elvis crashes (the -r command line flag)
 *  o In "termcap" gui: Graphic chars, Shift & Alt F-key labels, xterm retitling
 *  o Screen update optimization
 *  o Support for mouse clicks and scrollbars
 *  o Expansion of "~user" in a filename.  (plain old "~" still works though)
 */

/* The following provide custom implementations of some common functions which
 * are either missing or poorly implemented on some systems.
 */
#undef	NEED_ABORT	/* replaces abort() with a simpler macro */
#undef	NEED_ASSERT	/* defines a custom assert() macro */
#undef	NEED_TGETENT	/* causes tinytcap.c to be used instead of library */
#undef	NEED_WINSIZE	/* includes <ptem.h> -- required by SCO */
#define	NEED_SPEED_T	/* includes <termcap.h> -- common on POSIX systems */
#undef	NEED_STRDUP	/* uses a custom version of strdup() */
#undef	NEED_MEMMOVE	/* uses a custom version of memmove() */
#undef	NEED_OSPEED	/* causes guitcap.c to supply an ospeed variable */
#define	NEED_BC		/* causes guitcap.c to supply a BC variable */
#define	NEED_SETPGID	/* use setpgrp() instead of setpgid() */
#undef	NEED_FREOPEN	/* use close()/dup()instead of freopen() */
#define	NEED_CTYPE	/* uses a custom <ctype.h>, driven by :digraph */
#define	NEED_WAIT_H	/* must include <sys/wait.h> */
#define	NEED_SELECT_H	/* must include <sys/select.h> */
#define	NEED_IOCTL_H	/* must include <sys/ioctl.h> */
#undef	NEED_XOS_H	/* must include <X11/Xos.h> */
#define	NEED_IN_H	/* must include <netinet/in.h> */
#define	NEED_SOCKET_H	/* must include <sys/socket.h> */
#undef	NEED_XRMCOMBINEFILEDATABASE	/* X11R4 needs this */
#undef	NEED_INET_ATON	/* SunOS, Solaris, and Cygwin need this */

/* The following control debugging features.  NDEBUG slows elvis down a lot,
 * and the others tend to make it output some confusing messages, so these
 * are all disabled by default.  (Note that NDEBUG is #define'd to disable it)
 */
#ifndef __QNXNTO__
#define	NDEBUG		/* undef to enable assert() calls */
#endif
#undef	DEBUG_ALLOC	/* define to debug memory allocations */
#undef	DEBUG_SCAN	/* define to debug character scans */
#undef	DEBUG_SESSION	/* define to debug the block cache */
#undef	DEBUG_EVENT	/* define to trace events */
#undef	DEBUG_MARKUP	/* define to debug markup display modes */
#undef	DEBUG_REGEXP	/* define to debug regular expressions */
#undef	DEBUG_MARK	/* define to debug marksetbuffer() usage */
#undef	DEBUG_REGION	/* define to debug regions */



/* The following macros, and their values, are mostly used to determine the
 * default values of some options.
 */
#define	OSLPOUT	"!lpr"	/* default value of lpout option */
#define OSLIBPATH "~/.elvis:/etc/elvis:/usr/share/elvis/:/usr/share/elvis/doc/"	/* default elvispath */

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn/product/branches/7.0.0/trunk/utils/e/elvis/common/config.h $ $Rev: 680331 $")
#endif
