/* This file is is generated by a shell script.  DO NOT EDIT! */

/* 32 bit ELF emulation code for elf_i386
   Copyright 1991, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001,
   2002, 2003, 2004, 2005, 2006 Free Software Foundation, Inc.
   Written by Steve Chamberlain <sac@cygnus.com>
   ELF support by Ian Lance Taylor <ian@cygnus.com>

This file is part of GLD, the Gnu Linker.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA 02110-1301, USA.  */

#define TARGET_IS_elf_i386

#include "config.h"
#include "bfd.h"
#include "sysdep.h"
#include "libiberty.h"
#include "safe-ctype.h"
#include "getopt.h"

#include "bfdlink.h"

#include "ld.h"
#include "ldmain.h"
#include "ldmisc.h"
#include "ldexp.h"
#include "ldlang.h"
#include "ldfile.h"
#include "ldemul.h"
#include <ldgram.h>
#include "elf/common.h"
#include "elf-bfd.h"

/* Declare functions used by various EXTRA_EM_FILEs.  */
static void gldelf_i386_before_parse (void);
static void gldelf_i386_after_open (void);
static void gldelf_i386_before_allocation (void);
static bfd_boolean gldelf_i386_place_orphan (asection *s);
static void gldelf_i386_finish (void);

#ifdef HAVE_GLOB
#include <glob.h>
#endif

static void
gldelf_i386_map_segments (bfd_boolean need_layout)
{
  int tries = 10;

  do
    {
      if (need_layout)
	{
	  lang_reset_memory_regions ();

	  /* Resize the sections.  */
	  lang_size_sections (NULL, TRUE);

	  /* Redo special stuff.  */
	  ldemul_after_allocation ();

	  /* Do the assignments again.  */
	  lang_do_assignments ();

	  need_layout = FALSE;
	}

      if (output_bfd->xvec->flavour == bfd_target_elf_flavour
	  && !link_info.relocatable)
	{
	  bfd_size_type phdr_size;

	  phdr_size = elf_tdata (output_bfd)->program_header_size;
	  /* If we don't have user supplied phdrs, throw away any
	     previous linker generated program headers.  */
	  if (lang_phdr_list == NULL)
	    elf_tdata (output_bfd)->segment_map = NULL;
	  if (!_bfd_elf_map_sections_to_segments (output_bfd, &link_info))
	    einfo ("%F%P: map sections to segments failed: %E\n");

	  if (phdr_size != elf_tdata (output_bfd)->program_header_size)
	    {
	      if (tries > 6)
		/* The first few times we allow any change to
		   phdr_size .  */
		need_layout = TRUE;
	      else if (phdr_size < elf_tdata (output_bfd)->program_header_size)
		/* After that we only allow the size to grow.  */
		need_layout = TRUE;
	      else
		elf_tdata (output_bfd)->program_header_size = phdr_size;
	    }
	}
    }
  while (need_layout && --tries);

  if (tries == 0)
    einfo (_("%P%F: looping in map_segments"));
}

static void
gldelf_i386_before_parse (void)
{
  ldfile_set_output_arch ("i386", bfd_arch_i386);
  config.dynamic_link = TRUE;
  config.has_shared = TRUE;
  link_info.sharable_sections = TRUE;
}

/* Handle as_needed DT_NEEDED.  */

static bfd_boolean
gldelf_i386_load_symbols (lang_input_statement_type *entry)
{
  int class = 0;

  /* Tell the ELF linker that we don't want the output file to have a
     DT_NEEDED entry for this file, unless it is used to resolve
     references in a regular object.  */
  if (entry->as_needed)
    class = DYN_AS_NEEDED;

  /* Tell the ELF linker that we don't want the output file to have a
     DT_NEEDED entry for any dynamic library in DT_NEEDED tags from
     this file at all.  */
  if (!entry->add_needed)
    class |= DYN_NO_ADD_NEEDED;

  if (entry->just_syms_flag
      && (bfd_get_file_flags (entry->the_bfd) & DYNAMIC) != 0)
    einfo (_("%P%F: --just-symbols may not be used on DSO: %B\n"),
	   entry->the_bfd);

  if (!class
      || (bfd_get_file_flags (entry->the_bfd) & DYNAMIC) == 0)
    return FALSE;

  bfd_elf_set_dyn_lib_class (entry->the_bfd, class);

  /* Continue on with normal load_symbols processing.  */
  return FALSE;
}

/* These variables are required to pass information back and forth
   between after_open and check_needed and stat_needed and vercheck.  */

static struct bfd_link_needed_list *global_needed;
static struct stat global_stat;
static lang_input_statement_type *global_found;
static struct bfd_link_needed_list *global_vercheck_needed;
static bfd_boolean global_vercheck_failed;


/* On Linux, it's possible to have different versions of the same
   shared library linked against different versions of libc.  The
   dynamic linker somehow tags which libc version to use in
   /etc/ld.so.cache, and, based on the libc that it sees in the
   executable, chooses which version of the shared library to use.

   We try to do a similar check here by checking whether this shared
   library needs any other shared libraries which may conflict with
   libraries we have already included in the link.  If it does, we
   skip it, and try to find another shared library farther on down the
   link path.

   This is called via lang_for_each_input_file.
   GLOBAL_VERCHECK_NEEDED is the list of objects needed by the object
   which we are checking.  This sets GLOBAL_VERCHECK_FAILED if we find
   a conflicting version.  */

static void
gldelf_i386_vercheck (lang_input_statement_type *s)
{
  const char *soname;
  struct bfd_link_needed_list *l;

  if (global_vercheck_failed)
    return;
  if (s->the_bfd == NULL
      || (bfd_get_file_flags (s->the_bfd) & DYNAMIC) == 0)
    return;

  soname = bfd_elf_get_dt_soname (s->the_bfd);
  if (soname == NULL)
    soname = lbasename (bfd_get_filename (s->the_bfd));

  for (l = global_vercheck_needed; l != NULL; l = l->next)
    {
      const char *suffix;

      if (strcmp (soname, l->name) == 0)
	{
	  /* Probably can't happen, but it's an easy check.  */
	  continue;
	}

      if (strchr (l->name, '/') != NULL)
	continue;

      suffix = strstr (l->name, ".so.");
      if (suffix == NULL)
	continue;

      suffix += sizeof ".so." - 1;

      if (strncmp (soname, l->name, suffix - l->name) == 0)
	{
	  /* Here we know that S is a dynamic object FOO.SO.VER1, and
	     the object we are considering needs a dynamic object
	     FOO.SO.VER2, and VER1 and VER2 are different.  This
	     appears to be a version mismatch, so we tell the caller
	     to try a different version of this library.  */
	  global_vercheck_failed = TRUE;
	  return;
	}
    }
}


/* See if an input file matches a DT_NEEDED entry by running stat on
   the file.  */

static void
gldelf_i386_stat_needed (lang_input_statement_type *s)
{
  struct stat st;
  const char *suffix;
  const char *soname;

  if (global_found != NULL)
    return;
  if (s->the_bfd == NULL)
    return;

  /* If this input file was an as-needed entry, and wasn't found to be
     needed at the stage it was linked, then don't say we have loaded it.  */
  if ((bfd_elf_get_dyn_lib_class (s->the_bfd) & DYN_AS_NEEDED) != 0)
    return;

  if (bfd_stat (s->the_bfd, &st) != 0)
    {
      einfo ("%P:%B: bfd_stat failed: %E\n", s->the_bfd);
      return;
    }

  /* Some operating systems, e.g. Windows, do not provide a meaningful
     st_ino; they always set it to zero.  (Windows does provide a
     meaningful st_dev.)  Do not indicate a duplicate library in that
     case.  While there is no guarantee that a system that provides
     meaningful inode numbers will never set st_ino to zero, this is
     merely an optimization, so we do not need to worry about false
     negatives.  */
  if (st.st_dev == global_stat.st_dev
      && st.st_ino == global_stat.st_ino
      && st.st_ino != 0)
    {
      global_found = s;
      return;
    }

  /* We issue a warning if it looks like we are including two
     different versions of the same shared library.  For example,
     there may be a problem if -lc picks up libc.so.6 but some other
     shared library has a DT_NEEDED entry of libc.so.5.  This is a
     heuristic test, and it will only work if the name looks like
     NAME.so.VERSION.  FIXME: Depending on file names is error-prone.
     If we really want to issue warnings about mixing version numbers
     of shared libraries, we need to find a better way.  */

  if (strchr (global_needed->name, '/') != NULL)
    return;
  suffix = strstr (global_needed->name, ".so.");
  if (suffix == NULL)
    return;
  suffix += sizeof ".so." - 1;

  soname = bfd_elf_get_dt_soname (s->the_bfd);
  if (soname == NULL)
    soname = lbasename (s->filename);

  if (strncmp (soname, global_needed->name, suffix - global_needed->name) == 0)
    einfo ("%P: warning: %s, needed by %B, may conflict with %s\n",
	   global_needed->name, global_needed->by, soname);
}

struct dt_needed
{
  bfd *by;
  const char *name;
};

/* This function is called for each possible name for a dynamic object
   named by a DT_NEEDED entry.  The FORCE parameter indicates whether
   to skip the check for a conflicting version.  */

static bfd_boolean
gldelf_i386_try_needed (struct dt_needed *needed,
				 int force)
{
  bfd *abfd;
  const char *name = needed->name;
  const char *soname;
  int class;

  abfd = bfd_openr (name, bfd_get_target (output_bfd));
  if (abfd == NULL)
    return FALSE;
  if (! bfd_check_format (abfd, bfd_object))
    {
      bfd_close (abfd);
      return FALSE;
    }
  if ((bfd_get_file_flags (abfd) & DYNAMIC) == 0)
    {
      bfd_close (abfd);
      return FALSE;
    }

  /* For DT_NEEDED, they have to match.  */
  if (abfd->xvec != output_bfd->xvec)
    {
      bfd_close (abfd);
      return FALSE;
    }

  /* Check whether this object would include any conflicting library
     versions.  If FORCE is set, then we skip this check; we use this
     the second time around, if we couldn't find any compatible
     instance of the shared library.  */

  if (! force)
    {
      struct bfd_link_needed_list *needed;

      if (! bfd_elf_get_bfd_needed_list (abfd, &needed))
	einfo ("%F%P:%B: bfd_elf_get_bfd_needed_list failed: %E\n", abfd);

      if (needed != NULL)
	{
	  global_vercheck_needed = needed;
	  global_vercheck_failed = FALSE;
	  lang_for_each_input_file (gldelf_i386_vercheck);
	  if (global_vercheck_failed)
	    {
	      bfd_close (abfd);
	      /* Return FALSE to force the caller to move on to try
		 another file on the search path.  */
	      return FALSE;
	    }

	  /* But wait!  It gets much worse.  On Linux, if a shared
	     library does not use libc at all, we are supposed to skip
	     it the first time around in case we encounter a shared
	     library later on with the same name which does use the
	     version of libc that we want.  This is much too horrible
	     to use on any system other than Linux.  */

	  {
	    struct bfd_link_needed_list *l;

	    for (l = needed; l != NULL; l = l->next)
	      if (CONST_STRNEQ (l->name, "libc.so"))
		break;
	    if (l == NULL)
	      {
		bfd_close (abfd);
		return FALSE;
	      }
	  }

	}
    }

  /* We've found a dynamic object matching the DT_NEEDED entry.  */

  /* We have already checked that there is no other input file of the
     same name.  We must now check again that we are not including the
     same file twice.  We need to do this because on many systems
     libc.so is a symlink to, e.g., libc.so.1.  The SONAME entry will
     reference libc.so.1.  If we have already included libc.so, we
     don't want to include libc.so.1 if they are the same file, and we
     can only check that using stat.  */

  if (bfd_stat (abfd, &global_stat) != 0)
    einfo ("%F%P:%B: bfd_stat failed: %E\n", abfd);

  /* First strip off everything before the last '/'.  */
  soname = lbasename (abfd->filename);

  if (trace_file_tries)
    info_msg (_("found %s at %s\n"), soname, name);

  global_found = NULL;
  lang_for_each_input_file (gldelf_i386_stat_needed);
  if (global_found != NULL)
    {
      /* Return TRUE to indicate that we found the file, even though
	 we aren't going to do anything with it.  */
      return TRUE;
    }

  /* Specify the soname to use.  */
  bfd_elf_set_dt_needed_name (abfd, soname);

  /* Tell the ELF linker that we don't want the output file to have a
     DT_NEEDED entry for this file, unless it is used to resolve
     references in a regular object.  */
  class = DYN_DT_NEEDED;

  /* Tell the ELF linker that we don't want the output file to have a
     DT_NEEDED entry for this file at all if the entry is from a file
     with DYN_NO_ADD_NEEDED.  */
  if (needed->by != NULL
      && (bfd_elf_get_dyn_lib_class (needed->by) & DYN_NO_ADD_NEEDED) != 0)
    class |= DYN_NO_NEEDED | DYN_NO_ADD_NEEDED;

  bfd_elf_set_dyn_lib_class (abfd, class);

  /* Add this file into the symbol table.  */
  if (! bfd_link_add_symbols (abfd, &link_info))
    einfo ("%F%B: could not read symbols: %E\n", abfd);

  return TRUE;
}


/* Search for a needed file in a path.  */

static bfd_boolean
gldelf_i386_search_needed (const char *path,
				    struct dt_needed *n, int force)
{
  const char *s;
  const char *name = n->name;
  size_t len;
  struct dt_needed needed;

  if (name[0] == '/')
    return gldelf_i386_try_needed (n, force);

  if (path == NULL || *path == '\0')
    return FALSE;

  needed.by = n->by;
  needed.name = n->name;

  len = strlen (name);
  while (1)
    {
      char *filename, *sset;

      s = strchr (path, ':');
      if (s == NULL)
	s = path + strlen (path);

      filename = (char *) xmalloc (s - path + len + 2);
      if (s == path)
	sset = filename;
      else
	{
	  memcpy (filename, path, s - path);
	  filename[s - path] = '/';
	  sset = filename + (s - path) + 1;
	}
      strcpy (sset, name);

      needed.name = filename;
      if (gldelf_i386_try_needed (&needed, force))
	return TRUE;

      free (filename);

      if (*s == '\0')
	break;
      path = s + 1;
    }

  return FALSE;
}


/* Add the sysroot to every entry in a colon-separated path.  */

static char *
gldelf_i386_add_sysroot (const char *path)
{
  int len, colons, i;
  char *ret, *p;

  len = strlen (path);
  colons = 0;
  i = 0;
  while (path[i])
    if (path[i++] == ':')
      colons++;

  if (path[i])
    colons++;

  len = len + (colons + 1) * strlen (ld_sysroot);
  ret = xmalloc (len + 1);
  strcpy (ret, ld_sysroot);
  p = ret + strlen (ret);
  i = 0;
  while (path[i])
    if (path[i] == ':')
      {
	*p++ = path[i++];
	strcpy (p, ld_sysroot);
	p = p + strlen (p);
      }
    else
      *p++ = path[i++];

  *p = 0;
  return ret;
}

/* For a native linker, check the file /etc/ld.so.conf for directories
   in which we may find shared libraries.  /etc/ld.so.conf is really
   only meaningful on Linux.  */

struct gldelf_i386_ld_so_conf
{
  char *path;
  size_t len, alloc;
};

static bfd_boolean
gldelf_i386_parse_ld_so_conf
     (struct gldelf_i386_ld_so_conf *info, const char *filename);

static void
gldelf_i386_parse_ld_so_conf_include
     (struct gldelf_i386_ld_so_conf *info, const char *filename,
      const char *pattern)
{
  char *newp = NULL;
#ifdef HAVE_GLOB
  glob_t gl;
#endif

  if (pattern[0] != '/')
    {
      char *p = strrchr (filename, '/');
      size_t patlen = strlen (pattern) + 1;

      newp = xmalloc (p - filename + 1 + patlen);
      memcpy (newp, filename, p - filename + 1);
      memcpy (newp + (p - filename + 1), pattern, patlen);
      pattern = newp;
    }

#ifdef HAVE_GLOB
  if (glob (pattern, 0, NULL, &gl) == 0)
    {
      size_t i;

      for (i = 0; i < gl.gl_pathc; ++i)
	gldelf_i386_parse_ld_so_conf (info, gl.gl_pathv[i]);
      globfree (&gl);
    }
#else
  /* If we do not have glob, treat the pattern as a literal filename.  */
  gldelf_i386_parse_ld_so_conf (info, pattern);
#endif

  if (newp)
    free (newp);
}

static bfd_boolean
gldelf_i386_parse_ld_so_conf
     (struct gldelf_i386_ld_so_conf *info, const char *filename)
{
  FILE *f = fopen (filename, FOPEN_RT);
  char *line;
  size_t linelen;

  if (f == NULL)
    return FALSE;

  linelen = 256;
  line = xmalloc (linelen);
  do
    {
      char *p = line, *q;

      /* Normally this would use getline(3), but we need to be portable.  */
      while ((q = fgets (p, linelen - (p - line), f)) != NULL
	     && strlen (q) == linelen - (p - line) - 1
	     && line[linelen - 2] != '\n')
	{
	  line = xrealloc (line, 2 * linelen);
	  p = line + linelen - 1;
	  linelen += linelen;
	}

      if (q == NULL && p == line)
	break;

      p = strchr (line, '\n');
      if (p)
	*p = '\0';

      /* Because the file format does not know any form of quoting we
	 can search forward for the next '#' character and if found
	 make it terminating the line.  */
      p = strchr (line, '#');
      if (p)
	*p = '\0';

      /* Remove leading whitespace.  NUL is no whitespace character.  */
      p = line;
      while (*p == ' ' || *p == '\f' || *p == '\r' || *p == '\t' || *p == '\v')
	++p;

      /* If the line is blank it is ignored.  */
      if (p[0] == '\0')
	continue;

      if (CONST_STRNEQ (p, "include") && (p[7] == ' ' || p[7] == '\t'))
	{
	  char *dir, c;
	  p += 8;
	  do
	    {
	      while (*p == ' ' || *p == '\t')
		++p;

	      if (*p == '\0')
		break;

	      dir = p;

	      while (*p != ' ' && *p != '\t' && *p)
		++p;

	      c = *p;
	      *p++ = '\0';
	      if (dir[0] != '\0')
		gldelf_i386_parse_ld_so_conf_include (info, filename,
							       dir);
	    }
	  while (c != '\0');
	}
      else
	{
	  char *dir = p;
	  while (*p && *p != '=' && *p != ' ' && *p != '\t' && *p != '\f'
		 && *p != '\r' && *p != '\v')
	    ++p;

	  while (p != dir && p[-1] == '/')
	    --p;
	  if (info->path == NULL)
	    {
	      info->alloc = p - dir + 1 + 256;
	      info->path = xmalloc (info->alloc);
	      info->len = 0;
	    }
	  else
	    {
	      if (info->len + 1 + (p - dir) >= info->alloc)
		{
		  info->alloc += p - dir + 256;
		  info->path = xrealloc (info->path, info->alloc);
		}
	      info->path[info->len++] = ':';
	    }
	  memcpy (info->path + info->len, dir, p - dir);
	  info->len += p - dir;
	  info->path[info->len] = '\0';
	}
    }
  while (! feof (f));
  free (line);
  fclose (f);
  return TRUE;
}

static bfd_boolean
gldelf_i386_check_ld_so_conf (const char *name, int force)
{
  static bfd_boolean initialized;
  static char *ld_so_conf;
  struct dt_needed needed;

  if (! initialized)
    {
      char *tmppath;
      struct gldelf_i386_ld_so_conf info;

      info.path = NULL;
      info.len = info.alloc = 0;
      tmppath = concat (ld_sysroot, "/usr/etc/ld.so.conf", NULL);
      if (!gldelf_i386_parse_ld_so_conf (&info, tmppath))
	{
	  free (tmppath);
	  tmppath = concat (ld_sysroot, "/etc/ld.so.conf", NULL);
	  gldelf_i386_parse_ld_so_conf (&info, tmppath);
	}
      free (tmppath);

      if (info.path)
	{
	  char *d = gldelf_i386_add_sysroot (info.path);
	  free (info.path);
	  ld_so_conf = d;
	}
      initialized = TRUE;
    }

  if (ld_so_conf == NULL)
    return FALSE;


  needed.by = NULL;
  needed.name = name;
  return gldelf_i386_search_needed (ld_so_conf, &needed, force);
}


/* See if an input file matches a DT_NEEDED entry by name.  */

static void
gldelf_i386_check_needed (lang_input_statement_type *s)
{
  const char *soname;

  /* Stop looking if we've found a loaded lib.  */
  if (global_found != NULL
      && (bfd_elf_get_dyn_lib_class (global_found->the_bfd)
	  & DYN_AS_NEEDED) == 0)
    return;

  if (s->filename == NULL || s->the_bfd == NULL)
    return;

  /* Don't look for a second non-loaded as-needed lib.  */
  if (global_found != NULL
      && (bfd_elf_get_dyn_lib_class (s->the_bfd) & DYN_AS_NEEDED) != 0)
    return;

  if (strcmp (s->filename, global_needed->name) == 0)
    {
      global_found = s;
      return;
    }

  if (s->search_dirs_flag)
    {
      const char *f = strrchr (s->filename, '/');
      if (f != NULL
	  && strcmp (f + 1, global_needed->name) == 0)
	{
	  global_found = s;
	  return;
	}
    }

  soname = bfd_elf_get_dt_soname (s->the_bfd);
  if (soname != NULL
      && strcmp (soname, global_needed->name) == 0)
    {
      global_found = s;
      return;
    }
}


/* This is called after all the input files have been opened.  */

static void
gldelf_i386_after_open (void)
{
  struct bfd_link_needed_list *needed, *l;

  if (link_info.eh_frame_hdr
      && ! link_info.traditional_format
      && ! link_info.relocatable)
    {
      struct elf_link_hash_table *htab;

      htab = elf_hash_table (&link_info);
      if (is_elf_hash_table (htab))
	{
	  bfd *abfd;
	  asection *s;

	  for (abfd = link_info.input_bfds; abfd; abfd = abfd->link_next)
	    {
	      s = bfd_get_section_by_name (abfd, ".eh_frame");
	      if (s && s->size > 8 && !bfd_is_abs_section (s->output_section))
		 break;
	    }
	  if (abfd)
	    {
	      const struct elf_backend_data *bed;

	      bed = get_elf_backend_data (abfd);
	      s = bfd_make_section_with_flags (abfd, ".eh_frame_hdr",
					       bed->dynamic_sec_flags
					       | SEC_READONLY);
	      if (s != NULL
		 && bfd_set_section_alignment (abfd, s, 2))
		htab->eh_info.hdr_sec = s;
	      else
		einfo ("%P: warning: Cannot create .eh_frame_hdr section,"
		       " --eh-frame-hdr ignored.\n");
	    }
	}
    }

  /* We only need to worry about this when doing a final link.  */
  if (link_info.relocatable || !link_info.executable)
    return;

  /* Get the list of files which appear in DT_NEEDED entries in
     dynamic objects included in the link (often there will be none).
     For each such file, we want to track down the corresponding
     library, and include the symbol table in the link.  This is what
     the runtime dynamic linker will do.  Tracking the files down here
     permits one dynamic object to include another without requiring
     special action by the person doing the link.  Note that the
     needed list can actually grow while we are stepping through this
     loop.  */
  needed = bfd_elf_get_needed_list (output_bfd, &link_info);
  for (l = needed; l != NULL; l = l->next)
    {
      struct bfd_link_needed_list *ll;
      struct dt_needed n, nn;
      int force;

      /* If the lib that needs this one was --as-needed and wasn't
	 found to be needed, then this lib isn't needed either.  */
      if (l->by != NULL
	  && (bfd_elf_get_dyn_lib_class (l->by) & DYN_AS_NEEDED) != 0)
	continue;

      /* If we've already seen this file, skip it.  */
      for (ll = needed; ll != l; ll = ll->next)
	if ((ll->by == NULL
	     || (bfd_elf_get_dyn_lib_class (ll->by) & DYN_AS_NEEDED) == 0)
	    && strcmp (ll->name, l->name) == 0)
	  break;
      if (ll != l)
	continue;

      /* See if this file was included in the link explicitly.  */
      global_needed = l;
      global_found = NULL;
      lang_for_each_input_file (gldelf_i386_check_needed);
      if (global_found != NULL
	  && (bfd_elf_get_dyn_lib_class (global_found->the_bfd)
	      & DYN_AS_NEEDED) == 0)
	continue;

      n.by = l->by;
      n.name = l->name;
      nn.by = l->by;
      if (trace_file_tries)
	info_msg (_("%s needed by %B\n"), l->name, l->by);

      /* As-needed libs specified on the command line (or linker script)
	 take priority over libs found in search dirs.  */
      if (global_found != NULL)
	{
	  nn.name = global_found->filename;
	  if (gldelf_i386_try_needed (&nn, TRUE))
	    continue;
	}

      /* We need to find this file and include the symbol table.  We
	 want to search for the file in the same way that the dynamic
	 linker will search.  That means that we want to use
	 rpath_link, rpath, then the environment variable
	 LD_LIBRARY_PATH (native only), then the DT_RPATH/DT_RUNPATH
	 entries (native only), then the linker script LIB_SEARCH_DIRS.
	 We do not search using the -L arguments.

	 We search twice.  The first time, we skip objects which may
	 introduce version mismatches.  The second time, we force
	 their use.  See gldelf_i386_vercheck comment.  */
      for (force = 0; force < 2; force++)
	{
	  size_t len;
	  search_dirs_type *search;
	  const char *lib_path;
	  struct bfd_link_needed_list *rp;
	  int found;

	  if (gldelf_i386_search_needed (command_line.rpath_link,
						  &n, force))
	    break;
	  if (gldelf_i386_search_needed (command_line.rpath,
						  &n, force))
	    break;
	  if (command_line.rpath_link == NULL
	      && command_line.rpath == NULL)
	    {
	      lib_path = (const char *) getenv ("LD_RUN_PATH");
	      if (gldelf_i386_search_needed (lib_path, &n,
						      force))
		break;
	    }
	  lib_path = (const char *) getenv ("LD_LIBRARY_PATH");
	  if (gldelf_i386_search_needed (lib_path, &n, force))
	    break;
	  found = 0;
	  rp = bfd_elf_get_runpath_list (output_bfd, &link_info);
	  for (; !found && rp != NULL; rp = rp->next)
	    {
	      char *tmpname = gldelf_i386_add_sysroot (rp->name);
	      found = (rp->by == l->by
		       && gldelf_i386_search_needed (tmpname,
							      &n,
							      force));
	      free (tmpname);
	    }
	  if (found)
	    break;

	  if (gldelf_i386_check_ld_so_conf (l->name, force))
	    break;

	  len = strlen (l->name);
	  for (search = search_head; search != NULL; search = search->next)
	    {
	      char *filename;

	      if (search->cmdline)
		continue;
	      filename = (char *) xmalloc (strlen (search->name) + len + 2);
	      sprintf (filename, "%s/%s", search->name, l->name);
	      nn.name = filename;
	      if (gldelf_i386_try_needed (&nn, force))
		break;
	      free (filename);
	    }
	  if (search != NULL)
	    break;
	}

      if (force < 2)
	continue;

      einfo ("%P: warning: %s, needed by %B, not found (try using -rpath or -rpath-link)\n",
	     l->name, l->by);
    }
}


/* Look through an expression for an assignment statement.  */

static void
gldelf_i386_find_exp_assignment (etree_type *exp)
{
  bfd_boolean provide = FALSE;

  switch (exp->type.node_class)
    {
    case etree_provide:
      provide = TRUE;
      /* Fall thru */
    case etree_assign:
      /* We call record_link_assignment even if the symbol is defined.
	 This is because if it is defined by a dynamic object, we
	 actually want to use the value defined by the linker script,
	 not the value from the dynamic object (because we are setting
	 symbols like etext).  If the symbol is defined by a regular
	 object, then, as it happens, calling record_link_assignment
	 will do no harm.  */
      if (strcmp (exp->assign.dst, ".") != 0)
	{
	  if (!bfd_elf_record_link_assignment (output_bfd, &link_info,
					       exp->assign.dst, provide,
					       exp->assign.hidden))
	    einfo ("%P%F: failed to record assignment to %s: %E\n",
		   exp->assign.dst);
	}
      gldelf_i386_find_exp_assignment (exp->assign.src);
      break;

    case etree_binary:
      gldelf_i386_find_exp_assignment (exp->binary.lhs);
      gldelf_i386_find_exp_assignment (exp->binary.rhs);
      break;

    case etree_trinary:
      gldelf_i386_find_exp_assignment (exp->trinary.cond);
      gldelf_i386_find_exp_assignment (exp->trinary.lhs);
      gldelf_i386_find_exp_assignment (exp->trinary.rhs);
      break;

    case etree_unary:
      gldelf_i386_find_exp_assignment (exp->unary.child);
      break;

    default:
      break;
    }
}


/* This is called by the before_allocation routine via
   lang_for_each_statement.  It locates any assignment statements, and
   tells the ELF backend about them, in case they are assignments to
   symbols which are referred to by dynamic objects.  */

static void
gldelf_i386_find_statement_assignment (lang_statement_union_type *s)
{
  if (s->header.type == lang_assignment_statement_enum)
    gldelf_i386_find_exp_assignment (s->assignment_statement.exp);
}


/* This is called after the sections have been attached to output
   sections, but before any sizes or addresses have been set.  */

static void
gldelf_i386_before_allocation (void)
{
  const char *rpath;
  asection *sinterp;

  if (link_info.hash->type == bfd_link_elf_hash_table)
    _bfd_elf_tls_setup (output_bfd, &link_info);

  /* If we are going to make any variable assignments, we need to let
     the ELF backend know about them in case the variables are
     referred to by dynamic objects.  */
  lang_for_each_statement (gldelf_i386_find_statement_assignment);

  /* Let the ELF backend work out the sizes of any sections required
     by dynamic linking.  */
  rpath = command_line.rpath;
  if (rpath == NULL)
    rpath = (const char *) getenv ("LD_RUN_PATH");
  if (! (bfd_elf_size_dynamic_sections
	 (output_bfd, command_line.soname, rpath,
	  command_line.filter_shlib,
	  (const char * const *) command_line.auxiliary_filters,
	  &link_info, &sinterp, lang_elf_version_info)))
    einfo ("%P%F: failed to set dynamic section sizes: %E\n");


  /* Let the user override the dynamic linker we are using.  */
  if (command_line.interpreter != NULL
      && sinterp != NULL)
    {
      sinterp->contents = (bfd_byte *) command_line.interpreter;
      sinterp->size = strlen (command_line.interpreter) + 1;
    }

  /* Look for any sections named .gnu.warning.  As a GNU extensions,
     we treat such sections as containing warning messages.  We print
     out the warning message, and then zero out the section size so
     that it does not get copied into the output file.  */

  {
    LANG_FOR_EACH_INPUT_STATEMENT (is)
      {
	asection *s;
	bfd_size_type sz;
	char *msg;
	bfd_boolean ret;

	if (is->just_syms_flag)
	  continue;

	s = bfd_get_section_by_name (is->the_bfd, ".gnu.warning");
	if (s == NULL)
	  continue;

	sz = s->size;
	msg = xmalloc ((size_t) (sz + 1));
	if (! bfd_get_section_contents (is->the_bfd, s,	msg,
					(file_ptr) 0, sz))
	  einfo ("%F%B: Can't read contents of section .gnu.warning: %E\n",
		 is->the_bfd);
	msg[sz] = '\0';
	ret = link_info.callbacks->warning (&link_info, msg,
					    (const char *) NULL,
					    is->the_bfd, (asection *) NULL,
					    (bfd_vma) 0);
	ASSERT (ret);
	free (msg);

	/* Clobber the section size, so that we don't waste space
	   copying the warning into the output file.  If we've already
	   sized the output section, adjust its size.  The adjustment
	   is on rawsize because targets that size sections early will
	   have called lang_reset_memory_regions after sizing.  */
	if (s->output_section != NULL
	    && s->output_section->rawsize >= s->size)
	  s->output_section->rawsize -= s->size;

	s->size = 0;

	/* Also set SEC_EXCLUDE, so that local symbols defined in the
	   warning section don't get copied to the output.  */
	s->flags |= SEC_EXCLUDE | SEC_KEEP;
      }
  }

  before_allocation_default ();

  if (!bfd_elf_size_dynsym_hash_dynstr (output_bfd, &link_info))
    einfo ("%P%F: failed to set dynamic section sizes: %E\n");
}


/* Try to open a dynamic archive.  This is where we know that ELF
   dynamic libraries have an extension of .so (or .sl on oddball systems
   like hpux).  */

static bfd_boolean
gldelf_i386_open_dynamic_archive
  (const char *arch, search_dirs_type *search, lang_input_statement_type *entry)
{
  const char *filename;
  char *string;

  if (! entry->is_archive)
    return FALSE;

  filename = entry->filename;

  /* This allocates a few bytes too many when EXTRA_SHLIB_EXTENSION
     is defined, but it does not seem worth the headache to optimize
     away those two bytes of space.  */
  string = (char *) xmalloc (strlen (search->name)
			     + strlen (filename)
			     + strlen (arch)
#ifdef EXTRA_SHLIB_EXTENSION
			     + strlen (EXTRA_SHLIB_EXTENSION)
#endif
			     + sizeof "/lib.so");

  sprintf (string, "%s/lib%s%s.so", search->name, filename, arch);

#ifdef EXTRA_SHLIB_EXTENSION
  /* Try the .so extension first.  If that fails build a new filename
     using EXTRA_SHLIB_EXTENSION.  */
  if (! ldfile_try_open_bfd (string, entry))
    sprintf (string, "%s/lib%s%s%s", search->name,
	     filename, arch, EXTRA_SHLIB_EXTENSION);
#endif

  if (! ldfile_try_open_bfd (string, entry))
    {
      free (string);
      return FALSE;
    }

  entry->filename = string;

  /* We have found a dynamic object to include in the link.  The ELF
     backend linker will create a DT_NEEDED entry in the .dynamic
     section naming this file.  If this file includes a DT_SONAME
     entry, it will be used.  Otherwise, the ELF linker will just use
     the name of the file.  For an archive found by searching, like
     this one, the DT_NEEDED entry should consist of just the name of
     the file, without the path information used to find it.  Note
     that we only need to do this if we have a dynamic object; an
     archive will never be referenced by a DT_NEEDED entry.

     FIXME: This approach--using bfd_elf_set_dt_needed_name--is not
     very pretty.  I haven't been able to think of anything that is
     pretty, though.  */
  if (bfd_check_format (entry->the_bfd, bfd_object)
      && (entry->the_bfd->flags & DYNAMIC) != 0)
    {
      ASSERT (entry->is_archive && entry->search_dirs_flag);

      /* Rather than duplicating the logic above.  Just use the
	 filename we recorded earlier.  */

      filename = lbasename (entry->filename);
      bfd_elf_set_dt_needed_name (entry->the_bfd, filename);
    }

  return TRUE;
}


/* A variant of lang_output_section_find used by place_orphan.  */

static lang_output_section_statement_type *
output_rel_find (asection *sec, int isdyn)
{
  lang_output_section_statement_type *lookup;
  lang_output_section_statement_type *last = NULL;
  lang_output_section_statement_type *last_alloc = NULL;
  lang_output_section_statement_type *last_rel = NULL;
  lang_output_section_statement_type *last_rel_alloc = NULL;
  int rela = sec->name[4] == 'a';

  for (lookup = &lang_output_section_statement.head->output_section_statement;
       lookup != NULL;
       lookup = lookup->next)
    {
      if (lookup->constraint != -1
	  && CONST_STRNEQ (lookup->name, ".rel"))
	{
	  int lookrela = lookup->name[4] == 'a';

	  /* .rel.dyn must come before all other reloc sections, to suit
	     GNU ld.so.  */
	  if (isdyn)
	    break;

	  /* Don't place after .rel.plt as doing so results in wrong
	     dynamic tags.  */
	  if (strcmp (".plt", lookup->name + 4 + lookrela) == 0)
	    break;

	  if (rela == lookrela || last_rel == NULL)
	    last_rel = lookup;
	  if ((rela == lookrela || last_rel_alloc == NULL)
	      && lookup->bfd_section != NULL
	      && (lookup->bfd_section->flags & SEC_ALLOC) != 0)
	    last_rel_alloc = lookup;
	}

      last = lookup;
      if (lookup->bfd_section != NULL
	  && (lookup->bfd_section->flags & SEC_ALLOC) != 0)
	last_alloc = lookup;
    }

  if (last_rel_alloc)
    return last_rel_alloc;

  if (last_rel)
    return last_rel;

  if (last_alloc)
    return last_alloc;

  return last;
}

/* Place an orphan section.  We use this to put random SHF_ALLOC
   sections in the right segment.  */

static bfd_boolean
gldelf_i386_place_orphan (asection *s)
{
  static struct orphan_save hold[] =
    {
      { ".text",
	SEC_HAS_CONTENTS | SEC_ALLOC | SEC_LOAD | SEC_READONLY | SEC_CODE,
	0, 0, 0, 0 },
      { ".rodata",
	SEC_HAS_CONTENTS | SEC_ALLOC | SEC_LOAD | SEC_READONLY | SEC_DATA,
	0, 0, 0, 0 },
      { ".data",
	SEC_HAS_CONTENTS | SEC_ALLOC | SEC_LOAD | SEC_DATA,
	0, 0, 0, 0 },
      { ".bss",
	SEC_ALLOC,
	0, 0, 0, 0 },
      { 0,
	SEC_HAS_CONTENTS | SEC_ALLOC | SEC_LOAD | SEC_READONLY | SEC_DATA,
	0, 0, 0, 0 },
      { ".interp",
	SEC_HAS_CONTENTS | SEC_ALLOC | SEC_LOAD | SEC_READONLY | SEC_DATA,
	0, 0, 0, 0 },
      { ".sdata",
	SEC_HAS_CONTENTS | SEC_ALLOC | SEC_LOAD | SEC_DATA | SEC_SMALL_DATA,
	0, 0, 0, 0 }
    };
  enum orphan_save_index
    {
      orphan_text = 0,
      orphan_rodata,
      orphan_data,
      orphan_bss,
      orphan_rel,
      orphan_interp,
      orphan_sdata
    };
  static int orphan_init_done = 0;
  struct orphan_save *place;
  const char *secname;
  lang_output_section_statement_type *after;
  lang_output_section_statement_type *os;
  int isdyn = 0;
  int iself = s->owner->xvec->flavour == bfd_target_elf_flavour;
  unsigned int sh_type = iself ? elf_section_type (s) : SHT_NULL;

  secname = bfd_get_section_name (s->owner, s);

  /* Orphaned sharable sections won't have correct page
     requirements.  */
  if (elf_section_flags (s) & SHF_GNU_SHARABLE)
    einfo ("%F%P: unable to place orphaned sharable section %A (%B)\n",
	   s, s->owner);

  if (! link_info.relocatable
      && link_info.combreloc
      && (s->flags & SEC_ALLOC))
    {
      if (iself)
	switch (sh_type)
	  {
	  case SHT_RELA:
	    secname = ".rela.dyn";
	    isdyn = 1;
	    break;
	  case SHT_REL:
	    secname = ".rel.dyn";
	    isdyn = 1;
	    break;
	  default:
	    break;
	  }
      else if (CONST_STRNEQ (secname, ".rel"))
	{
	  secname = secname[4] == 'a' ? ".rela.dyn" : ".rel.dyn";
	  isdyn = 1;
	}
    }

  if (isdyn || (!config.unique_orphan_sections && !unique_section_p (s)))
    {
      /* Look through the script to see where to place this section.  */
      os = lang_output_section_find (secname);

      if (os != NULL
	  && (os->bfd_section == NULL
	      || os->bfd_section->flags == 0
	      || (_bfd_elf_match_sections_by_type (output_bfd,
						   os->bfd_section,
						   s->owner, s)
		  && ((s->flags ^ os->bfd_section->flags)
		      & (SEC_LOAD | SEC_ALLOC)) == 0)))
	{
	  /* We already have an output section statement with this
	     name, and its bfd section, if any, has compatible flags.
	     If the section already exists but does not have any flags
	     set, then it has been created by the linker, probably as a
	     result of a --section-start command line switch.  */
	  lang_add_section (&os->children, s, os);
	  return TRUE;
	}
    }

  if (!orphan_init_done)
    {
      struct orphan_save *ho;
      for (ho = hold; ho < hold + sizeof (hold) / sizeof (hold[0]); ++ho)
	if (ho->name != NULL)
	  {
	    ho->os = lang_output_section_find (ho->name);
	    if (ho->os != NULL && ho->os->flags == 0)
	      ho->os->flags = ho->flags;
	  }
      orphan_init_done = 1;
    }

  /* If this is a final link, then always put .gnu.warning.SYMBOL
     sections into the .text section to get them out of the way.  */
  if (link_info.executable
      && ! link_info.relocatable
      && CONST_STRNEQ (secname, ".gnu.warning.")
      && hold[orphan_text].os != NULL)
    {
      lang_add_section (&hold[orphan_text].os->children, s,
			hold[orphan_text].os);
      return TRUE;
    }

  /* Decide which segment the section should go in based on the
     section name and section flags.  We put loadable .note sections
     right after the .interp section, so that the PT_NOTE segment is
     stored right after the program headers where the OS can read it
     in the first page.  */

  place = NULL;
  if ((s->flags & SEC_ALLOC) == 0)
    ;
  else if ((s->flags & SEC_LOAD) != 0
	   && ((iself && sh_type == SHT_NOTE)
	       || (!iself && CONST_STRNEQ (secname, ".note"))))
    place = &hold[orphan_interp];
  else if ((s->flags & (SEC_LOAD | SEC_HAS_CONTENTS)) == 0)
    place = &hold[orphan_bss];
  else if ((s->flags & SEC_SMALL_DATA) != 0)
    place = &hold[orphan_sdata];
  else if ((s->flags & SEC_READONLY) == 0)
    place = &hold[orphan_data];
  else if (((iself && (sh_type == SHT_RELA || sh_type == SHT_REL))
	    || (!iself && CONST_STRNEQ (secname, ".rel")))
	   && (s->flags & SEC_LOAD) != 0)
    place = &hold[orphan_rel];
  else if ((s->flags & SEC_CODE) == 0)
    place = &hold[orphan_rodata];
  else
    place = &hold[orphan_text];

  after = NULL;
  if (place != NULL)
    {
      if (place->os == NULL)
	{
	  if (place->name != NULL)
	    place->os = lang_output_section_find (place->name);
	  else
	    place->os = output_rel_find (s, isdyn);
	}
      after = place->os;
      if (after == NULL)
	after = lang_output_section_find_by_flags
	  (s, &place->os, _bfd_elf_match_sections_by_type);
      if (after == NULL)
	/* *ABS* is always the first output section statement.  */
	after = &lang_output_section_statement.head->output_section_statement;
    }

  /* Choose a unique name for the section.  This will be needed if the
     same section name appears in the input file with different
     loadable or allocatable characteristics.  */
  if (bfd_get_section_by_name (output_bfd, secname) != NULL)
    {
      static int count = 1;
      secname = bfd_get_unique_section_name (output_bfd, secname, &count);
      if (secname == NULL)
	einfo ("%F%P: place_orphan failed: %E\n");
    }

  lang_insert_orphan (s, secname, after, place, NULL, NULL);

  return TRUE;
}

static void
gldelf_i386_finish (void)
{
  bfd_boolean need_layout = bfd_elf_discard_info (output_bfd, &link_info);

  gldelf_i386_map_segments (need_layout);
  finish_default ();
}

static char *
gldelf_i386_get_script (int *isfile)
{
  *isfile = 0;

  if (link_info.relocatable && config.build_constructors)
    return
"/* Script for ld -Ur: link w/out relocation, do create constructors */\n\
OUTPUT_FORMAT(\"elf32-i386\", \"elf32-i386\",\n\
	      \"elf32-i386\")\n\
OUTPUT_ARCH(i386)\n\
ENTRY(_start)\n\
 /* For some reason, the Solaris linker makes bad executables\n\
  if gld -r is used and the intermediate file has sections starting\n\
  at non-zero addresses.  Could be a Solaris ld bug, could be a GNU ld\n\
  bug.  But for now assigning the zero vmas works.  */\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  .interp       0 : { *(.interp) }\n\
  .hash         0 : { *(.hash) }\n\
  .gnu.hash     0 : { *(.gnu.hash) }\n\
  .dynsym       0 : { *(.dynsym) }\n\
  .dynstr       0 : { *(.dynstr) }\n\
  .gnu.version  0 : { *(.gnu.version) }\n\
  .gnu.version_d 0: { *(.gnu.version_d) }\n\
  .gnu.version_r 0: { *(.gnu.version_r) }\n\
  .rel.init     0 : { *(.rel.init) }\n\
  .rela.init    0 : { *(.rela.init) }\n\
  .rel.text     0 : { *(.rel.text) }\n\
  .rela.text    0 : { *(.rela.text) }\n\
  .rel.fini     0 : { *(.rel.fini) }\n"
"  .rela.fini    0 : { *(.rela.fini) }\n\
  .rel.rodata   0 : { *(.rel.rodata) }\n\
  .rela.rodata  0 : { *(.rela.rodata) }\n\
  .rel.data.rel.ro 0 : { *(.rel.data.rel.ro) }\n\
  .rela.data.rel.ro 0 : { *(.rela.data.rel.ro) }\n\
  .rel.data     0 : { *(.rel.data) }\n\
  .rela.data    0 : { *(.rela.data) }\n\
  .rel.tdata	0 : { *(.rel.tdata) }\n\
  .rela.tdata	0 : { *(.rela.tdata) }\n\
  .rel.tbss	0 : { *(.rel.tbss) }\n\
  .rela.tbss	0 : { *(.rela.tbss) }\n\
  .rel.ctors    0 : { *(.rel.ctors) }\n\
  .rela.ctors   0 : { *(.rela.ctors) }\n\
  .rel.dtors    0 : { *(.rel.dtors) }\n\
  .rela.dtors   0 : { *(.rela.dtors) }\n\
  .rel.got      0 : { *(.rel.got) }\n\
  .rela.got     0 : { *(.rela.got) }\n\
  .rel.sharable_data	0 : { *(.rel.sharable_data) }\n\
  .rela.sharable_data	0 : { *(.rela.sharable_data) }\n\
  .rel.sharable_bss	0 : { *(.rel.sharable_bss) }\n\
  .rela.sharable_bss	0 : { *(.rela.sharable_bss) }\n\
  .rel.bss      0 : { *(.rel.bss) }\n\
  .rela.bss     0 : { *(.rela.bss) }\n\
  .rel.plt      0 : { *(.rel.plt) }\n\
  .rela.plt     0 : { *(.rela.plt) }\n"
"  .init         0 :\n\
  {\n\
    KEEP (*(.init))\n\
  } =0x90909090\n\
  .plt          0 : { *(.plt) }\n\
  .text         0 :\n\
  {\n\
    *(.text .stub)\n\
    KEEP (*(.text.*personality*))\n\
    /* .gnu.warning sections are handled specially by elf32.em.  */\n\
    *(.gnu.warning)\n\
  } =0x90909090\n\
  .fini         0 :\n\
  {\n\
    KEEP (*(.fini))\n\
  } =0x90909090\n\
  .rodata       0 : { *(.rodata) }\n\
  .rodata1      0 : { *(.rodata1) }\n\
  .eh_frame_hdr : { *(.eh_frame_hdr) }\n\
  .eh_frame     0 : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table 0 : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  /* Exception handling  */\n\
  .eh_frame     0 : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n"
"  .gcc_except_table 0 : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	0 : { *(.tdata) }\n\
  .tbss		0 : { *(.tbss) }\n\
  .preinit_array   0 :\n\
  {\n\
    KEEP (*(.preinit_array))\n\
  }\n\
  .init_array   0 :\n\
  {\n\
     KEEP (*(SORT(.init_array.*)))\n\
     KEEP (*(.init_array))\n\
  }\n\
  .fini_array   0 :\n\
  {\n\
    KEEP (*(.fini_array))\n\
    KEEP (*(SORT(.fini_array.*)))\n\
  }\n\
  .jcr          0 : { KEEP (*(.jcr)) }\n\
  .dynamic      0 : { *(.dynamic) }\n\
  .got          0 : { *(.got) }\n\
  .got.plt      0 : { *(.got.plt) }\n\
  .data         0 :\n\
  {\n\
    *(.data)\n"
"    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1        0 : { *(.data1) }\n\
  /* Sharable data sections.  */\n\
  .sharable_data 0 :\n\
  {\n\
    *(.sharable_data)\n\
    /* Align here to ensure that the sharable data section ends at the\n\
       page boundary.  */\n\
  }\n\
  .bss          0 :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we don't\n\
      pad the .data section.  */\n\
  }\n\
  /* Sharable bss sections  */\n\
  .sharable_bss 0 :\n\
  {\n\
    *(.dynsharablebss)\n\
    *(.sharable_bss)\n\
    *(SHARABLE_COMMON)\n\
    /* Align here to ensure that the sharable bss section ends at the\n\
       page boundary.  */\n\
  }\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment       0 : { *(.comment) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
}\n\n"
  ; else if (link_info.relocatable) return
"/* Script for ld -r: link without relocation */\n\
OUTPUT_FORMAT(\"elf32-i386\", \"elf32-i386\",\n\
	      \"elf32-i386\")\n\
OUTPUT_ARCH(i386)\n\
ENTRY(_start)\n\
 /* For some reason, the Solaris linker makes bad executables\n\
  if gld -r is used and the intermediate file has sections starting\n\
  at non-zero addresses.  Could be a Solaris ld bug, could be a GNU ld\n\
  bug.  But for now assigning the zero vmas works.  */\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  .interp       0 : { *(.interp) }\n\
  .hash         0 : { *(.hash) }\n\
  .gnu.hash     0 : { *(.gnu.hash) }\n\
  .dynsym       0 : { *(.dynsym) }\n\
  .dynstr       0 : { *(.dynstr) }\n\
  .gnu.version  0 : { *(.gnu.version) }\n\
  .gnu.version_d 0: { *(.gnu.version_d) }\n\
  .gnu.version_r 0: { *(.gnu.version_r) }\n\
  .rel.init     0 : { *(.rel.init) }\n\
  .rela.init    0 : { *(.rela.init) }\n\
  .rel.text     0 : { *(.rel.text) }\n\
  .rela.text    0 : { *(.rela.text) }\n\
  .rel.fini     0 : { *(.rel.fini) }\n"
"  .rela.fini    0 : { *(.rela.fini) }\n\
  .rel.rodata   0 : { *(.rel.rodata) }\n\
  .rela.rodata  0 : { *(.rela.rodata) }\n\
  .rel.data.rel.ro 0 : { *(.rel.data.rel.ro) }\n\
  .rela.data.rel.ro 0 : { *(.rela.data.rel.ro) }\n\
  .rel.data     0 : { *(.rel.data) }\n\
  .rela.data    0 : { *(.rela.data) }\n\
  .rel.tdata	0 : { *(.rel.tdata) }\n\
  .rela.tdata	0 : { *(.rela.tdata) }\n\
  .rel.tbss	0 : { *(.rel.tbss) }\n\
  .rela.tbss	0 : { *(.rela.tbss) }\n\
  .rel.ctors    0 : { *(.rel.ctors) }\n\
  .rela.ctors   0 : { *(.rela.ctors) }\n\
  .rel.dtors    0 : { *(.rel.dtors) }\n\
  .rela.dtors   0 : { *(.rela.dtors) }\n\
  .rel.got      0 : { *(.rel.got) }\n\
  .rela.got     0 : { *(.rela.got) }\n\
  .rel.sharable_data	0 : { *(.rel.sharable_data) }\n\
  .rela.sharable_data	0 : { *(.rela.sharable_data) }\n\
  .rel.sharable_bss	0 : { *(.rel.sharable_bss) }\n\
  .rela.sharable_bss	0 : { *(.rela.sharable_bss) }\n\
  .rel.bss      0 : { *(.rel.bss) }\n\
  .rela.bss     0 : { *(.rela.bss) }\n\
  .rel.plt      0 : { *(.rel.plt) }\n\
  .rela.plt     0 : { *(.rela.plt) }\n"
"  .init         0 :\n\
  {\n\
    KEEP (*(.init))\n\
  } =0x90909090\n\
  .plt          0 : { *(.plt) }\n\
  .text         0 :\n\
  {\n\
    *(.text .stub)\n\
    KEEP (*(.text.*personality*))\n\
    /* .gnu.warning sections are handled specially by elf32.em.  */\n\
    *(.gnu.warning)\n\
  } =0x90909090\n\
  .fini         0 :\n\
  {\n\
    KEEP (*(.fini))\n\
  } =0x90909090\n\
  .rodata       0 : { *(.rodata) }\n\
  .rodata1      0 : { *(.rodata1) }\n\
  .eh_frame_hdr : { *(.eh_frame_hdr) }\n\
  .eh_frame     0 : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table 0 : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  /* Exception handling  */\n\
  .eh_frame     0 : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n"
"  .gcc_except_table 0 : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	0 : { *(.tdata) }\n\
  .tbss		0 : { *(.tbss) }\n\
  .preinit_array   0 :\n\
  {\n\
    KEEP (*(.preinit_array))\n\
  }\n\
  .init_array   0 :\n\
  {\n\
     KEEP (*(SORT(.init_array.*)))\n\
     KEEP (*(.init_array))\n\
  }\n\
  .fini_array   0 :\n\
  {\n\
    KEEP (*(.fini_array))\n\
    KEEP (*(SORT(.fini_array.*)))\n\
  }\n\
  .jcr          0 : { KEEP (*(.jcr)) }\n\
  .dynamic      0 : { *(.dynamic) }\n\
  .got          0 : { *(.got) }\n\
  .got.plt      0 : { *(.got.plt) }\n\
  .data         0 :\n\
  {\n\
    *(.data)\n"
"  }\n\
  .data1        0 : { *(.data1) }\n\
  /* Sharable data sections.  */\n\
  .sharable_data 0 :\n\
  {\n\
    *(.sharable_data)\n\
    /* Align here to ensure that the sharable data section ends at the\n\
       page boundary.  */\n\
  }\n\
  .bss          0 :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we don't\n\
      pad the .data section.  */\n\
  }\n\
  /* Sharable bss sections  */\n\
  .sharable_bss 0 :\n\
  {\n\
    *(.dynsharablebss)\n\
    *(.sharable_bss)\n\
    *(SHARABLE_COMMON)\n\
    /* Align here to ensure that the sharable bss section ends at the\n\
       page boundary.  */\n\
  }\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment       0 : { *(.comment) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
}\n\n"
  ; else if (!config.text_read_only) return
"/* Script for -N: mix text and data on same page; don't align data */\n\
OUTPUT_FORMAT(\"elf32-i386\", \"elf32-i386\",\n\
	      \"elf32-i386\")\n\
OUTPUT_ARCH(i386)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  PROVIDE (__executable_start = 0x08048000); . = 0x08048000 + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rel.init       : { *(.rel.init) }\n\
  .rela.init      : { *(.rela.init) }\n\
  .rel.text       : { *(.rel.text .rel.text.* .rel.gnu.linkonce.t.*) }\n\
  .rela.text      : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*) }\n\
  .rel.fini       : { *(.rel.fini) }\n\
  .rela.fini      : { *(.rela.fini) }\n\
  .rel.rodata     : { *(.rel.rodata .rel.rodata.* .rel.gnu.linkonce.r.*) }\n"
"  .rela.rodata    : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) }\n\
  .rel.data.rel.ro   : { *(.rel.data.rel.ro* .rel.gnu.linkonce.d.rel.ro.*) }\n\
  .rela.data.rel.ro   : { *(.rela.data.rel.ro* .rela.gnu.linkonce.d.rel.ro.*) }\n\
  .rel.data       : { *(.rel.data .rel.data.* .rel.gnu.linkonce.d.*) }\n\
  .rela.data      : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) }\n\
  .rel.tdata	  : { *(.rel.tdata .rel.tdata.* .rel.gnu.linkonce.td.*) }\n\
  .rela.tdata	  : { *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*) }\n\
  .rel.tbss	  : { *(.rel.tbss .rel.tbss.* .rel.gnu.linkonce.tb.*) }\n\
  .rela.tbss	  : { *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*) }\n\
  .rel.ctors      : { *(.rel.ctors) }\n\
  .rela.ctors     : { *(.rela.ctors) }\n\
  .rel.dtors      : { *(.rel.dtors) }\n\
  .rela.dtors     : { *(.rela.dtors) }\n\
  .rel.got        : { *(.rel.got) }\n\
  .rela.got       : { *(.rela.got) }\n\
  .rel.sharable_data	  : { *(.rel.sharable_data .rel.sharable_data.* .rel.gnu.linkonce.shrd.*) }\n\
  .rela.sharable_data	  : { *(.rela.sharable_data .rela.sharable_data.* .rela.gnu.linkonce.shrd.*) }\n\
  .rel.sharable_bss	  : { *(.rel.sharable_bss .rel.sharable_bss.* .rel.gnu.linkonce.shrb.*) }\n\
  .rela.sharable_bss	  : { *(.rela.sharable_bss .rela.sharable_bss.* .rela.gnu.linkonce.shrb.*) }\n\
  .rel.bss        : { *(.rel.bss .rel.bss.* .rel.gnu.linkonce.b.*) }\n\
  .rela.bss       : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*) }\n\
  .rel.plt        : { *(.rel.plt) }\n\
  .rela.plt       : { *(.rela.plt) }\n\
  .init           :\n\
  {\n"
"    KEEP (*(.init))\n\
  } =0x90909090\n\
  .plt            : { *(.plt) }\n\
  .text           :\n\
  {\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    KEEP (*(.text.*personality*))\n\
    /* .gnu.warning sections are handled specially by elf32.em.  */\n\
    *(.gnu.warning)\n\
  } =0x90909090\n\
  .fini           :\n\
  {\n\
    KEEP (*(.fini))\n\
  } =0x90909090\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr : { *(.eh_frame_hdr) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = .;\n"
"  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  : { *(.tdata .tdata.* .gnu.linkonce.td.*) }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array     :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array     :\n\
  {\n\
     PROVIDE_HIDDEN (__init_array_start = .);\n\
     KEEP (*(SORT(.init_array.*)))\n\
     KEEP (*(.init_array))\n\
     PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array     :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(.fini_array))\n\
    KEEP (*(SORT(.fini_array.*)))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n"
"  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .got            : { *(.got) }\n\
  .got.plt        : { *(.got.plt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    KEEP (*(.gnu.linkonce.d.*personality*))\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  /* Sharable data sections.  */\n\
  .sharable_data   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_data_start = .);\n\
    *(.sharable_data .sharable_data.* .gnu.linkonce.shrd.*)\n\
    /* Align here to ensure that the sharable data section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_data_end = .);\n\
  }\n\
  _edata = .; PROVIDE (edata = .);\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we don't\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 32 / 8 : 1);\n\
  }\n\
  /* Sharable bss sections  */\n\
  .sharable_bss   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_bss_start = .);\n\
    *(.dynsharablebss)\n\
    *(.sharable_bss .sharable_bss.* .gnu.linkonce.shrb.*)\n\
    *(SHARABLE_COMMON)\n\
    /* Align here to ensure that the sharable bss section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_bss_end = .);\n\
  }\n\
  . = ALIGN(32 / 8);\n\
  . = ALIGN(32 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment       0 : { *(.comment) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /DISCARD/ : { *(.note.GNU-stack) }\n\
}\n\n"
  ; else if (!config.magic_demand_paged) return
"/* Script for -n: mix text and data on same page */\n\
OUTPUT_FORMAT(\"elf32-i386\", \"elf32-i386\",\n\
	      \"elf32-i386\")\n\
OUTPUT_ARCH(i386)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  PROVIDE (__executable_start = 0x08048000); . = 0x08048000 + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rel.init       : { *(.rel.init) }\n\
  .rela.init      : { *(.rela.init) }\n\
  .rel.text       : { *(.rel.text .rel.text.* .rel.gnu.linkonce.t.*) }\n\
  .rela.text      : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*) }\n\
  .rel.fini       : { *(.rel.fini) }\n\
  .rela.fini      : { *(.rela.fini) }\n\
  .rel.rodata     : { *(.rel.rodata .rel.rodata.* .rel.gnu.linkonce.r.*) }\n"
"  .rela.rodata    : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) }\n\
  .rel.data.rel.ro   : { *(.rel.data.rel.ro* .rel.gnu.linkonce.d.rel.ro.*) }\n\
  .rela.data.rel.ro   : { *(.rela.data.rel.ro* .rela.gnu.linkonce.d.rel.ro.*) }\n\
  .rel.data       : { *(.rel.data .rel.data.* .rel.gnu.linkonce.d.*) }\n\
  .rela.data      : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) }\n\
  .rel.tdata	  : { *(.rel.tdata .rel.tdata.* .rel.gnu.linkonce.td.*) }\n\
  .rela.tdata	  : { *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*) }\n\
  .rel.tbss	  : { *(.rel.tbss .rel.tbss.* .rel.gnu.linkonce.tb.*) }\n\
  .rela.tbss	  : { *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*) }\n\
  .rel.ctors      : { *(.rel.ctors) }\n\
  .rela.ctors     : { *(.rela.ctors) }\n\
  .rel.dtors      : { *(.rel.dtors) }\n\
  .rela.dtors     : { *(.rela.dtors) }\n\
  .rel.got        : { *(.rel.got) }\n\
  .rela.got       : { *(.rela.got) }\n\
  .rel.sharable_data	  : { *(.rel.sharable_data .rel.sharable_data.* .rel.gnu.linkonce.shrd.*) }\n\
  .rela.sharable_data	  : { *(.rela.sharable_data .rela.sharable_data.* .rela.gnu.linkonce.shrd.*) }\n\
  .rel.sharable_bss	  : { *(.rel.sharable_bss .rel.sharable_bss.* .rel.gnu.linkonce.shrb.*) }\n\
  .rela.sharable_bss	  : { *(.rela.sharable_bss .rela.sharable_bss.* .rela.gnu.linkonce.shrb.*) }\n\
  .rel.bss        : { *(.rel.bss .rel.bss.* .rel.gnu.linkonce.b.*) }\n\
  .rela.bss       : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*) }\n\
  .rel.plt        : { *(.rel.plt) }\n\
  .rela.plt       : { *(.rela.plt) }\n\
  .init           :\n\
  {\n"
"    KEEP (*(.init))\n\
  } =0x90909090\n\
  .plt            : { *(.plt) }\n\
  .text           :\n\
  {\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    KEEP (*(.text.*personality*))\n\
    /* .gnu.warning sections are handled specially by elf32.em.  */\n\
    *(.gnu.warning)\n\
  } =0x90909090\n\
  .fini           :\n\
  {\n\
    KEEP (*(.fini))\n\
  } =0x90909090\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr : { *(.eh_frame_hdr) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = ALIGN (CONSTANT (MAXPAGESIZE)) - ((CONSTANT (MAXPAGESIZE) - .) & (CONSTANT (MAXPAGESIZE) - 1)); . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n"
"  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  : { *(.tdata .tdata.* .gnu.linkonce.td.*) }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array     :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array     :\n\
  {\n\
     PROVIDE_HIDDEN (__init_array_start = .);\n\
     KEEP (*(SORT(.init_array.*)))\n\
     KEEP (*(.init_array))\n\
     PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array     :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(.fini_array))\n\
    KEEP (*(SORT(.fini_array.*)))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n"
"  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .got            : { *(.got) }\n\
  . = DATA_SEGMENT_RELRO_END (12, .);\n\
  .got.plt        : { *(.got.plt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    KEEP (*(.gnu.linkonce.d.*personality*))\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  /* Sharable data sections.  */\n\
  .sharable_data   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_data_start = .);\n\
    *(.sharable_data .sharable_data.* .gnu.linkonce.shrd.*)\n\
    /* Align here to ensure that the sharable data section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_data_end = .);\n\
  }\n\
  _edata = .; PROVIDE (edata = .);\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we don't\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 32 / 8 : 1);\n\
  }\n\
  /* Sharable bss sections  */\n\
  .sharable_bss   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_bss_start = .);\n\
    *(.dynsharablebss)\n\
    *(.sharable_bss .sharable_bss.* .gnu.linkonce.shrb.*)\n\
    *(SHARABLE_COMMON)\n\
    /* Align here to ensure that the sharable bss section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_bss_end = .);\n\
  }\n\
  . = ALIGN(32 / 8);\n\
  . = ALIGN(32 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment       0 : { *(.comment) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /DISCARD/ : { *(.note.GNU-stack) }\n\
}\n\n"
  ; else if (link_info.pie && link_info.combreloc
             && link_info.relro
             && (link_info.flags & DT_BIND_NOW)) return
"/* Script for -pie -z combreloc -z now -z relro: position independent executable, combine & sort relocs */\n\
OUTPUT_FORMAT(\"elf32-i386\", \"elf32-i386\",\n\
	      \"elf32-i386\")\n\
OUTPUT_ARCH(i386)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  . = 0 + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rel.dyn        :\n\
    {\n\
      *(.rel.init)\n\
      *(.rel.text .rel.text.* .rel.gnu.linkonce.t.*)\n\
      *(.rel.fini)\n\
      *(.rel.rodata .rel.rodata.* .rel.gnu.linkonce.r.*)\n\
      *(.rel.data.rel.ro* .rel.gnu.linkonce.d.rel.ro.*)\n"
"      *(.rel.data .rel.data.* .rel.gnu.linkonce.d.*)\n\
      *(.rel.tdata .rel.tdata.* .rel.gnu.linkonce.td.*)\n\
      *(.rel.tbss .rel.tbss.* .rel.gnu.linkonce.tb.*)\n\
      *(.rel.ctors)\n\
      *(.rel.dtors)\n\
      *(.rel.got)\n\
      *(.rel.sharable_data .rel.sharable_data.* .rel.gnu.linkonce.shrd.*)\n\
      *(.rel.sharable_bss .rel.sharable_bss.* .rel.gnu.linkonce.shrb.*)\n\
      *(.rel.bss .rel.bss.* .rel.gnu.linkonce.b.*)\n\
    }\n\
  .rela.dyn       :\n\
    {\n\
      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.sharable_data .rela.sharable_data.* .rela.gnu.linkonce.shrd.*)\n\
      *(.rela.sharable_bss .rela.sharable_bss.* .rela.gnu.linkonce.shrb.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n"
"    }\n\
  .rel.plt        : { *(.rel.plt) }\n\
  .rela.plt       : { *(.rela.plt) }\n\
  .init           :\n\
  {\n\
    KEEP (*(.init))\n\
  } =0x90909090\n\
  .plt            : { *(.plt) }\n\
  .text           :\n\
  {\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    KEEP (*(.text.*personality*))\n\
    /* .gnu.warning sections are handled specially by elf32.em.  */\n\
    *(.gnu.warning)\n\
  } =0x90909090\n\
  .fini           :\n\
  {\n\
    KEEP (*(.fini))\n\
  } =0x90909090\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr : { *(.eh_frame_hdr) }\n"
"  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = ALIGN (CONSTANT (MAXPAGESIZE)) - ((CONSTANT (MAXPAGESIZE) - .) & (CONSTANT (MAXPAGESIZE) - 1)); . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  : { *(.tdata .tdata.* .gnu.linkonce.td.*) }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array     :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array     :\n\
  {\n\
     PROVIDE_HIDDEN (__init_array_start = .);\n\
     KEEP (*(SORT(.init_array.*)))\n\
     KEEP (*(.init_array))\n\
     PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array     :\n"
"  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(.fini_array))\n\
    KEEP (*(SORT(.fini_array.*)))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .got            : { *(.got.plt) *(.got) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    KEEP (*(.gnu.linkonce.d.*personality*))\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  /* Sharable data sections.  */\n\
  .sharable_data   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_data_start = .);\n\
    *(.sharable_data .sharable_data.* .gnu.linkonce.shrd.*)\n\
    /* Align here to ensure that the sharable data section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_data_end = .);\n\
  }\n\
  _edata = .; PROVIDE (edata = .);\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we don't\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 32 / 8 : 1);\n\
  }\n\
  /* Sharable bss sections  */\n\
  .sharable_bss   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_bss_start = .);\n\
    *(.dynsharablebss)\n\
    *(.sharable_bss .sharable_bss.* .gnu.linkonce.shrb.*)\n\
    *(SHARABLE_COMMON)\n\
    /* Align here to ensure that the sharable bss section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_bss_end = .);\n\
  }\n\
  . = ALIGN(32 / 8);\n\
  . = ALIGN(32 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment       0 : { *(.comment) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /DISCARD/ : { *(.note.GNU-stack) }\n\
}\n\n"
  ; else if (link_info.pie && link_info.combreloc) return
"/* Script for -pie -z combreloc: position independent executable, combine & sort relocs */\n\
OUTPUT_FORMAT(\"elf32-i386\", \"elf32-i386\",\n\
	      \"elf32-i386\")\n\
OUTPUT_ARCH(i386)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  . = 0 + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rel.dyn        :\n\
    {\n\
      *(.rel.init)\n\
      *(.rel.text .rel.text.* .rel.gnu.linkonce.t.*)\n\
      *(.rel.fini)\n\
      *(.rel.rodata .rel.rodata.* .rel.gnu.linkonce.r.*)\n\
      *(.rel.data.rel.ro* .rel.gnu.linkonce.d.rel.ro.*)\n"
"      *(.rel.data .rel.data.* .rel.gnu.linkonce.d.*)\n\
      *(.rel.tdata .rel.tdata.* .rel.gnu.linkonce.td.*)\n\
      *(.rel.tbss .rel.tbss.* .rel.gnu.linkonce.tb.*)\n\
      *(.rel.ctors)\n\
      *(.rel.dtors)\n\
      *(.rel.got)\n\
      *(.rel.sharable_data .rel.sharable_data.* .rel.gnu.linkonce.shrd.*)\n\
      *(.rel.sharable_bss .rel.sharable_bss.* .rel.gnu.linkonce.shrb.*)\n\
      *(.rel.bss .rel.bss.* .rel.gnu.linkonce.b.*)\n\
    }\n\
  .rela.dyn       :\n\
    {\n\
      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.sharable_data .rela.sharable_data.* .rela.gnu.linkonce.shrd.*)\n\
      *(.rela.sharable_bss .rela.sharable_bss.* .rela.gnu.linkonce.shrb.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n"
"    }\n\
  .rel.plt        : { *(.rel.plt) }\n\
  .rela.plt       : { *(.rela.plt) }\n\
  .init           :\n\
  {\n\
    KEEP (*(.init))\n\
  } =0x90909090\n\
  .plt            : { *(.plt) }\n\
  .text           :\n\
  {\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    KEEP (*(.text.*personality*))\n\
    /* .gnu.warning sections are handled specially by elf32.em.  */\n\
    *(.gnu.warning)\n\
  } =0x90909090\n\
  .fini           :\n\
  {\n\
    KEEP (*(.fini))\n\
  } =0x90909090\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr : { *(.eh_frame_hdr) }\n"
"  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = ALIGN (CONSTANT (MAXPAGESIZE)) - ((CONSTANT (MAXPAGESIZE) - .) & (CONSTANT (MAXPAGESIZE) - 1)); . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  : { *(.tdata .tdata.* .gnu.linkonce.td.*) }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array     :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array     :\n\
  {\n\
     PROVIDE_HIDDEN (__init_array_start = .);\n\
     KEEP (*(SORT(.init_array.*)))\n\
     KEEP (*(.init_array))\n\
     PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array     :\n"
"  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(.fini_array))\n\
    KEEP (*(SORT(.fini_array.*)))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .got            : { *(.got) }\n\
  . = DATA_SEGMENT_RELRO_END (12, .);\n\
  .got.plt        : { *(.got.plt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    KEEP (*(.gnu.linkonce.d.*personality*))\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  /* Sharable data sections.  */\n\
  .sharable_data   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_data_start = .);\n\
    *(.sharable_data .sharable_data.* .gnu.linkonce.shrd.*)\n\
    /* Align here to ensure that the sharable data section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_data_end = .);\n\
  }\n\
  _edata = .; PROVIDE (edata = .);\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we don't\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 32 / 8 : 1);\n\
  }\n\
  /* Sharable bss sections  */\n\
  .sharable_bss   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_bss_start = .);\n\
    *(.dynsharablebss)\n\
    *(.sharable_bss .sharable_bss.* .gnu.linkonce.shrb.*)\n\
    *(SHARABLE_COMMON)\n\
    /* Align here to ensure that the sharable bss section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_bss_end = .);\n\
  }\n\
  . = ALIGN(32 / 8);\n\
  . = ALIGN(32 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment       0 : { *(.comment) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /DISCARD/ : { *(.note.GNU-stack) }\n\
}\n\n"
  ; else if (link_info.pie) return
"/* Script for ld -pie: link position independent executable */\n\
OUTPUT_FORMAT(\"elf32-i386\", \"elf32-i386\",\n\
	      \"elf32-i386\")\n\
OUTPUT_ARCH(i386)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  . = 0 + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rel.init       : { *(.rel.init) }\n\
  .rela.init      : { *(.rela.init) }\n\
  .rel.text       : { *(.rel.text .rel.text.* .rel.gnu.linkonce.t.*) }\n\
  .rela.text      : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*) }\n\
  .rel.fini       : { *(.rel.fini) }\n\
  .rela.fini      : { *(.rela.fini) }\n\
  .rel.rodata     : { *(.rel.rodata .rel.rodata.* .rel.gnu.linkonce.r.*) }\n"
"  .rela.rodata    : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) }\n\
  .rel.data.rel.ro   : { *(.rel.data.rel.ro* .rel.gnu.linkonce.d.rel.ro.*) }\n\
  .rela.data.rel.ro   : { *(.rela.data.rel.ro* .rela.gnu.linkonce.d.rel.ro.*) }\n\
  .rel.data       : { *(.rel.data .rel.data.* .rel.gnu.linkonce.d.*) }\n\
  .rela.data      : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) }\n\
  .rel.tdata	  : { *(.rel.tdata .rel.tdata.* .rel.gnu.linkonce.td.*) }\n\
  .rela.tdata	  : { *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*) }\n\
  .rel.tbss	  : { *(.rel.tbss .rel.tbss.* .rel.gnu.linkonce.tb.*) }\n\
  .rela.tbss	  : { *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*) }\n\
  .rel.ctors      : { *(.rel.ctors) }\n\
  .rela.ctors     : { *(.rela.ctors) }\n\
  .rel.dtors      : { *(.rel.dtors) }\n\
  .rela.dtors     : { *(.rela.dtors) }\n\
  .rel.got        : { *(.rel.got) }\n\
  .rela.got       : { *(.rela.got) }\n\
  .rel.sharable_data	  : { *(.rel.sharable_data .rel.sharable_data.* .rel.gnu.linkonce.shrd.*) }\n\
  .rela.sharable_data	  : { *(.rela.sharable_data .rela.sharable_data.* .rela.gnu.linkonce.shrd.*) }\n\
  .rel.sharable_bss	  : { *(.rel.sharable_bss .rel.sharable_bss.* .rel.gnu.linkonce.shrb.*) }\n\
  .rela.sharable_bss	  : { *(.rela.sharable_bss .rela.sharable_bss.* .rela.gnu.linkonce.shrb.*) }\n\
  .rel.bss        : { *(.rel.bss .rel.bss.* .rel.gnu.linkonce.b.*) }\n\
  .rela.bss       : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*) }\n\
  .rel.plt        : { *(.rel.plt) }\n\
  .rela.plt       : { *(.rela.plt) }\n\
  .init           :\n\
  {\n"
"    KEEP (*(.init))\n\
  } =0x90909090\n\
  .plt            : { *(.plt) }\n\
  .text           :\n\
  {\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    KEEP (*(.text.*personality*))\n\
    /* .gnu.warning sections are handled specially by elf32.em.  */\n\
    *(.gnu.warning)\n\
  } =0x90909090\n\
  .fini           :\n\
  {\n\
    KEEP (*(.fini))\n\
  } =0x90909090\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr : { *(.eh_frame_hdr) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = ALIGN (CONSTANT (MAXPAGESIZE)) - ((CONSTANT (MAXPAGESIZE) - .) & (CONSTANT (MAXPAGESIZE) - 1)); . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n"
"  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  : { *(.tdata .tdata.* .gnu.linkonce.td.*) }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array     :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array     :\n\
  {\n\
     PROVIDE_HIDDEN (__init_array_start = .);\n\
     KEEP (*(SORT(.init_array.*)))\n\
     KEEP (*(.init_array))\n\
     PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array     :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(.fini_array))\n\
    KEEP (*(SORT(.fini_array.*)))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n"
"  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .got            : { *(.got) }\n\
  . = DATA_SEGMENT_RELRO_END (12, .);\n\
  .got.plt        : { *(.got.plt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    KEEP (*(.gnu.linkonce.d.*personality*))\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  /* Sharable data sections.  */\n\
  .sharable_data   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_data_start = .);\n\
    *(.sharable_data .sharable_data.* .gnu.linkonce.shrd.*)\n\
    /* Align here to ensure that the sharable data section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_data_end = .);\n\
  }\n\
  _edata = .; PROVIDE (edata = .);\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we don't\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 32 / 8 : 1);\n\
  }\n\
  /* Sharable bss sections  */\n\
  .sharable_bss   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_bss_start = .);\n\
    *(.dynsharablebss)\n\
    *(.sharable_bss .sharable_bss.* .gnu.linkonce.shrb.*)\n\
    *(SHARABLE_COMMON)\n\
    /* Align here to ensure that the sharable bss section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_bss_end = .);\n\
  }\n\
  . = ALIGN(32 / 8);\n\
  . = ALIGN(32 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment       0 : { *(.comment) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /DISCARD/ : { *(.note.GNU-stack) }\n\
}\n\n"
  ; else if (link_info.shared && link_info.combreloc
             && link_info.relro
             && (link_info.flags & DT_BIND_NOW)) return
"/* Script for --shared -z combreloc -z now -z relro: shared library, combine & sort relocs */\n\
OUTPUT_FORMAT(\"elf32-i386\", \"elf32-i386\",\n\
	      \"elf32-i386\")\n\
OUTPUT_ARCH(i386)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  . = 0 + SIZEOF_HEADERS;\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rel.dyn        :\n\
    {\n\
      *(.rel.init)\n\
      *(.rel.text .rel.text.* .rel.gnu.linkonce.t.*)\n\
      *(.rel.fini)\n\
      *(.rel.rodata .rel.rodata.* .rel.gnu.linkonce.r.*)\n\
      *(.rel.data.rel.ro* .rel.gnu.linkonce.d.rel.ro.*)\n\
      *(.rel.data .rel.data.* .rel.gnu.linkonce.d.*)\n"
"      *(.rel.tdata .rel.tdata.* .rel.gnu.linkonce.td.*)\n\
      *(.rel.tbss .rel.tbss.* .rel.gnu.linkonce.tb.*)\n\
      *(.rel.ctors)\n\
      *(.rel.dtors)\n\
      *(.rel.got)\n\
      *(.rel.sharable_data .rel.sharable_data.* .rel.gnu.linkonce.shrd.*)\n\
      *(.rel.sharable_bss .rel.sharable_bss.* .rel.gnu.linkonce.shrb.*)\n\
      *(.rel.bss .rel.bss.* .rel.gnu.linkonce.b.*)\n\
    }\n\
  .rela.dyn       :\n\
    {\n\
      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.sharable_data .rela.sharable_data.* .rela.gnu.linkonce.shrd.*)\n\
      *(.rela.sharable_bss .rela.sharable_bss.* .rela.gnu.linkonce.shrb.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n\
    }\n"
"  .rel.plt        : { *(.rel.plt) }\n\
  .rela.plt       : { *(.rela.plt) }\n\
  .init           :\n\
  {\n\
    KEEP (*(.init))\n\
  } =0x90909090\n\
  .plt            : { *(.plt) }\n\
  .text           :\n\
  {\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    KEEP (*(.text.*personality*))\n\
    /* .gnu.warning sections are handled specially by elf32.em.  */\n\
    *(.gnu.warning)\n\
  } =0x90909090\n\
  .fini           :\n\
  {\n\
    KEEP (*(.fini))\n\
  } =0x90909090\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr : { *(.eh_frame_hdr) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n"
"  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = ALIGN (CONSTANT (MAXPAGESIZE)) - ((CONSTANT (MAXPAGESIZE) - .) & (CONSTANT (MAXPAGESIZE) - 1)); . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  : { *(.tdata .tdata.* .gnu.linkonce.td.*) }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array     :\n\
  {\n\
    KEEP (*(.preinit_array))\n\
  }\n\
  .init_array     :\n\
  {\n\
     KEEP (*(SORT(.init_array.*)))\n\
     KEEP (*(.init_array))\n\
  }\n\
  .fini_array     :\n\
  {\n\
    KEEP (*(.fini_array))\n\
    KEEP (*(SORT(.fini_array.*)))\n\
  }\n\
  .ctors          :\n"
"  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .got            : { *(.got.plt) *(.got) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    KEEP (*(.gnu.linkonce.d.*personality*))\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  /* Sharable data sections.  */\n\
  .sharable_data   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_data_start = .);\n\
    *(.sharable_data .sharable_data.* .gnu.linkonce.shrd.*)\n\
    /* Align here to ensure that the sharable data section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_data_end = .);\n\
  }\n\
  _edata = .; PROVIDE (edata = .);\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we don't\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 32 / 8 : 1);\n\
  }\n\
  /* Sharable bss sections  */\n\
  .sharable_bss   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_bss_start = .);\n\
    *(.dynsharablebss)\n\
    *(.sharable_bss .sharable_bss.* .gnu.linkonce.shrb.*)\n\
    *(SHARABLE_COMMON)\n\
    /* Align here to ensure that the sharable bss section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_bss_end = .);\n\
  }\n\
  . = ALIGN(32 / 8);\n\
  . = ALIGN(32 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment       0 : { *(.comment) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /DISCARD/ : { *(.note.GNU-stack) }\n\
}\n\n"
  ; else if (link_info.shared && link_info.combreloc) return
"/* Script for --shared -z combreloc: shared library, combine & sort relocs */\n\
OUTPUT_FORMAT(\"elf32-i386\", \"elf32-i386\",\n\
	      \"elf32-i386\")\n\
OUTPUT_ARCH(i386)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  . = 0 + SIZEOF_HEADERS;\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rel.dyn        :\n\
    {\n\
      *(.rel.init)\n\
      *(.rel.text .rel.text.* .rel.gnu.linkonce.t.*)\n\
      *(.rel.fini)\n\
      *(.rel.rodata .rel.rodata.* .rel.gnu.linkonce.r.*)\n\
      *(.rel.data.rel.ro* .rel.gnu.linkonce.d.rel.ro.*)\n\
      *(.rel.data .rel.data.* .rel.gnu.linkonce.d.*)\n"
"      *(.rel.tdata .rel.tdata.* .rel.gnu.linkonce.td.*)\n\
      *(.rel.tbss .rel.tbss.* .rel.gnu.linkonce.tb.*)\n\
      *(.rel.ctors)\n\
      *(.rel.dtors)\n\
      *(.rel.got)\n\
      *(.rel.sharable_data .rel.sharable_data.* .rel.gnu.linkonce.shrd.*)\n\
      *(.rel.sharable_bss .rel.sharable_bss.* .rel.gnu.linkonce.shrb.*)\n\
      *(.rel.bss .rel.bss.* .rel.gnu.linkonce.b.*)\n\
    }\n\
  .rela.dyn       :\n\
    {\n\
      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.sharable_data .rela.sharable_data.* .rela.gnu.linkonce.shrd.*)\n\
      *(.rela.sharable_bss .rela.sharable_bss.* .rela.gnu.linkonce.shrb.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n\
    }\n"
"  .rel.plt        : { *(.rel.plt) }\n\
  .rela.plt       : { *(.rela.plt) }\n\
  .init           :\n\
  {\n\
    KEEP (*(.init))\n\
  } =0x90909090\n\
  .plt            : { *(.plt) }\n\
  .text           :\n\
  {\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    KEEP (*(.text.*personality*))\n\
    /* .gnu.warning sections are handled specially by elf32.em.  */\n\
    *(.gnu.warning)\n\
  } =0x90909090\n\
  .fini           :\n\
  {\n\
    KEEP (*(.fini))\n\
  } =0x90909090\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr : { *(.eh_frame_hdr) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n"
"  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = ALIGN (CONSTANT (MAXPAGESIZE)) - ((CONSTANT (MAXPAGESIZE) - .) & (CONSTANT (MAXPAGESIZE) - 1)); . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  : { *(.tdata .tdata.* .gnu.linkonce.td.*) }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array     :\n\
  {\n\
    KEEP (*(.preinit_array))\n\
  }\n\
  .init_array     :\n\
  {\n\
     KEEP (*(SORT(.init_array.*)))\n\
     KEEP (*(.init_array))\n\
  }\n\
  .fini_array     :\n\
  {\n\
    KEEP (*(.fini_array))\n\
    KEEP (*(SORT(.fini_array.*)))\n\
  }\n\
  .ctors          :\n"
"  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .got            : { *(.got) }\n\
  . = DATA_SEGMENT_RELRO_END (12, .);\n\
  .got.plt        : { *(.got.plt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    KEEP (*(.gnu.linkonce.d.*personality*))\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  /* Sharable data sections.  */\n\
  .sharable_data   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_data_start = .);\n\
    *(.sharable_data .sharable_data.* .gnu.linkonce.shrd.*)\n\
    /* Align here to ensure that the sharable data section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_data_end = .);\n\
  }\n\
  _edata = .; PROVIDE (edata = .);\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we don't\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 32 / 8 : 1);\n\
  }\n\
  /* Sharable bss sections  */\n\
  .sharable_bss   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_bss_start = .);\n\
    *(.dynsharablebss)\n\
    *(.sharable_bss .sharable_bss.* .gnu.linkonce.shrb.*)\n\
    *(SHARABLE_COMMON)\n\
    /* Align here to ensure that the sharable bss section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_bss_end = .);\n\
  }\n\
  . = ALIGN(32 / 8);\n\
  . = ALIGN(32 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment       0 : { *(.comment) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /DISCARD/ : { *(.note.GNU-stack) }\n\
}\n\n"
  ; else if (link_info.shared) return
"/* Script for ld --shared: link shared library */\n\
OUTPUT_FORMAT(\"elf32-i386\", \"elf32-i386\",\n\
	      \"elf32-i386\")\n\
OUTPUT_ARCH(i386)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  . = 0 + SIZEOF_HEADERS;\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rel.init       : { *(.rel.init) }\n\
  .rela.init      : { *(.rela.init) }\n\
  .rel.text       : { *(.rel.text .rel.text.* .rel.gnu.linkonce.t.*) }\n\
  .rela.text      : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*) }\n\
  .rel.fini       : { *(.rel.fini) }\n\
  .rela.fini      : { *(.rela.fini) }\n\
  .rel.rodata     : { *(.rel.rodata .rel.rodata.* .rel.gnu.linkonce.r.*) }\n\
  .rela.rodata    : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) }\n"
"  .rel.data.rel.ro   : { *(.rel.data.rel.ro* .rel.gnu.linkonce.d.rel.ro.*) }\n\
  .rela.data.rel.ro   : { *(.rela.data.rel.ro* .rela.gnu.linkonce.d.rel.ro.*) }\n\
  .rel.data       : { *(.rel.data .rel.data.* .rel.gnu.linkonce.d.*) }\n\
  .rela.data      : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) }\n\
  .rel.tdata	  : { *(.rel.tdata .rel.tdata.* .rel.gnu.linkonce.td.*) }\n\
  .rela.tdata	  : { *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*) }\n\
  .rel.tbss	  : { *(.rel.tbss .rel.tbss.* .rel.gnu.linkonce.tb.*) }\n\
  .rela.tbss	  : { *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*) }\n\
  .rel.ctors      : { *(.rel.ctors) }\n\
  .rela.ctors     : { *(.rela.ctors) }\n\
  .rel.dtors      : { *(.rel.dtors) }\n\
  .rela.dtors     : { *(.rela.dtors) }\n\
  .rel.got        : { *(.rel.got) }\n\
  .rela.got       : { *(.rela.got) }\n\
  .rel.sharable_data	  : { *(.rel.sharable_data .rel.sharable_data.* .rel.gnu.linkonce.shrd.*) }\n\
  .rela.sharable_data	  : { *(.rela.sharable_data .rela.sharable_data.* .rela.gnu.linkonce.shrd.*) }\n\
  .rel.sharable_bss	  : { *(.rel.sharable_bss .rel.sharable_bss.* .rel.gnu.linkonce.shrb.*) }\n\
  .rela.sharable_bss	  : { *(.rela.sharable_bss .rela.sharable_bss.* .rela.gnu.linkonce.shrb.*) }\n\
  .rel.bss        : { *(.rel.bss .rel.bss.* .rel.gnu.linkonce.b.*) }\n\
  .rela.bss       : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*) }\n\
  .rel.plt        : { *(.rel.plt) }\n\
  .rela.plt       : { *(.rela.plt) }\n\
  .init           :\n\
  {\n\
    KEEP (*(.init))\n"
"  } =0x90909090\n\
  .plt            : { *(.plt) }\n\
  .text           :\n\
  {\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    KEEP (*(.text.*personality*))\n\
    /* .gnu.warning sections are handled specially by elf32.em.  */\n\
    *(.gnu.warning)\n\
  } =0x90909090\n\
  .fini           :\n\
  {\n\
    KEEP (*(.fini))\n\
  } =0x90909090\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr : { *(.eh_frame_hdr) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = ALIGN (CONSTANT (MAXPAGESIZE)) - ((CONSTANT (MAXPAGESIZE) - .) & (CONSTANT (MAXPAGESIZE) - 1)); . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n"
"  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  : { *(.tdata .tdata.* .gnu.linkonce.td.*) }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array     :\n\
  {\n\
    KEEP (*(.preinit_array))\n\
  }\n\
  .init_array     :\n\
  {\n\
     KEEP (*(SORT(.init_array.*)))\n\
     KEEP (*(.init_array))\n\
  }\n\
  .fini_array     :\n\
  {\n\
    KEEP (*(.fini_array))\n\
    KEEP (*(SORT(.fini_array.*)))\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n"
"       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .got            : { *(.got) }\n\
  . = DATA_SEGMENT_RELRO_END (12, .);\n\
  .got.plt        : { *(.got.plt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    KEEP (*(.gnu.linkonce.d.*personality*))\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  /* Sharable data sections.  */\n\
  .sharable_data   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_data_start = .);\n\
    *(.sharable_data .sharable_data.* .gnu.linkonce.shrd.*)\n\
    /* Align here to ensure that the sharable data section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_data_end = .);\n\
  }\n\
  _edata = .; PROVIDE (edata = .);\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we don't\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 32 / 8 : 1);\n\
  }\n\
  /* Sharable bss sections  */\n\
  .sharable_bss   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_bss_start = .);\n\
    *(.dynsharablebss)\n\
    *(.sharable_bss .sharable_bss.* .gnu.linkonce.shrb.*)\n\
    *(SHARABLE_COMMON)\n\
    /* Align here to ensure that the sharable bss section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_bss_end = .);\n\
  }\n\
  . = ALIGN(32 / 8);\n\
  . = ALIGN(32 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment       0 : { *(.comment) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /DISCARD/ : { *(.note.GNU-stack) }\n\
}\n\n"
  ; else if (link_info.combreloc && link_info.relro
             && (link_info.flags & DT_BIND_NOW)) return
"/* Script for -z combreloc -z now -z relro: combine and sort reloc sections */\n\
OUTPUT_FORMAT(\"elf32-i386\", \"elf32-i386\",\n\
	      \"elf32-i386\")\n\
OUTPUT_ARCH(i386)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  PROVIDE (__executable_start = 0x08048000); . = 0x08048000 + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rel.dyn        :\n\
    {\n\
      *(.rel.init)\n\
      *(.rel.text .rel.text.* .rel.gnu.linkonce.t.*)\n\
      *(.rel.fini)\n\
      *(.rel.rodata .rel.rodata.* .rel.gnu.linkonce.r.*)\n\
      *(.rel.data.rel.ro* .rel.gnu.linkonce.d.rel.ro.*)\n"
"      *(.rel.data .rel.data.* .rel.gnu.linkonce.d.*)\n\
      *(.rel.tdata .rel.tdata.* .rel.gnu.linkonce.td.*)\n\
      *(.rel.tbss .rel.tbss.* .rel.gnu.linkonce.tb.*)\n\
      *(.rel.ctors)\n\
      *(.rel.dtors)\n\
      *(.rel.got)\n\
      *(.rel.sharable_data .rel.sharable_data.* .rel.gnu.linkonce.shrd.*)\n\
      *(.rel.sharable_bss .rel.sharable_bss.* .rel.gnu.linkonce.shrb.*)\n\
      *(.rel.bss .rel.bss.* .rel.gnu.linkonce.b.*)\n\
    }\n\
  .rela.dyn       :\n\
    {\n\
      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.sharable_data .rela.sharable_data.* .rela.gnu.linkonce.shrd.*)\n\
      *(.rela.sharable_bss .rela.sharable_bss.* .rela.gnu.linkonce.shrb.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n"
"    }\n\
  .rel.plt        : { *(.rel.plt) }\n\
  .rela.plt       : { *(.rela.plt) }\n\
  .init           :\n\
  {\n\
    KEEP (*(.init))\n\
  } =0x90909090\n\
  .plt            : { *(.plt) }\n\
  .text           :\n\
  {\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    KEEP (*(.text.*personality*))\n\
    /* .gnu.warning sections are handled specially by elf32.em.  */\n\
    *(.gnu.warning)\n\
  } =0x90909090\n\
  .fini           :\n\
  {\n\
    KEEP (*(.fini))\n\
  } =0x90909090\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr : { *(.eh_frame_hdr) }\n"
"  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = ALIGN (CONSTANT (MAXPAGESIZE)) - ((CONSTANT (MAXPAGESIZE) - .) & (CONSTANT (MAXPAGESIZE) - 1)); . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  : { *(.tdata .tdata.* .gnu.linkonce.td.*) }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array     :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array     :\n\
  {\n\
     PROVIDE_HIDDEN (__init_array_start = .);\n\
     KEEP (*(SORT(.init_array.*)))\n\
     KEEP (*(.init_array))\n\
     PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array     :\n"
"  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(.fini_array))\n\
    KEEP (*(SORT(.fini_array.*)))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .got            : { *(.got.plt) *(.got) }\n\
  . = DATA_SEGMENT_RELRO_END (0, .);\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    KEEP (*(.gnu.linkonce.d.*personality*))\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  /* Sharable data sections.  */\n\
  .sharable_data   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_data_start = .);\n\
    *(.sharable_data .sharable_data.* .gnu.linkonce.shrd.*)\n\
    /* Align here to ensure that the sharable data section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_data_end = .);\n\
  }\n\
  _edata = .; PROVIDE (edata = .);\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we don't\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 32 / 8 : 1);\n\
  }\n\
  /* Sharable bss sections  */\n\
  .sharable_bss   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_bss_start = .);\n\
    *(.dynsharablebss)\n\
    *(.sharable_bss .sharable_bss.* .gnu.linkonce.shrb.*)\n\
    *(SHARABLE_COMMON)\n\
    /* Align here to ensure that the sharable bss section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_bss_end = .);\n\
  }\n\
  . = ALIGN(32 / 8);\n\
  . = ALIGN(32 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment       0 : { *(.comment) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /DISCARD/ : { *(.note.GNU-stack) }\n\
}\n\n"
  ; else if (link_info.combreloc) return
"/* Script for -z combreloc: combine and sort reloc sections */\n\
OUTPUT_FORMAT(\"elf32-i386\", \"elf32-i386\",\n\
	      \"elf32-i386\")\n\
OUTPUT_ARCH(i386)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  PROVIDE (__executable_start = 0x08048000); . = 0x08048000 + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rel.dyn        :\n\
    {\n\
      *(.rel.init)\n\
      *(.rel.text .rel.text.* .rel.gnu.linkonce.t.*)\n\
      *(.rel.fini)\n\
      *(.rel.rodata .rel.rodata.* .rel.gnu.linkonce.r.*)\n\
      *(.rel.data.rel.ro* .rel.gnu.linkonce.d.rel.ro.*)\n"
"      *(.rel.data .rel.data.* .rel.gnu.linkonce.d.*)\n\
      *(.rel.tdata .rel.tdata.* .rel.gnu.linkonce.td.*)\n\
      *(.rel.tbss .rel.tbss.* .rel.gnu.linkonce.tb.*)\n\
      *(.rel.ctors)\n\
      *(.rel.dtors)\n\
      *(.rel.got)\n\
      *(.rel.sharable_data .rel.sharable_data.* .rel.gnu.linkonce.shrd.*)\n\
      *(.rel.sharable_bss .rel.sharable_bss.* .rel.gnu.linkonce.shrb.*)\n\
      *(.rel.bss .rel.bss.* .rel.gnu.linkonce.b.*)\n\
    }\n\
  .rela.dyn       :\n\
    {\n\
      *(.rela.init)\n\
      *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*)\n\
      *(.rela.fini)\n\
      *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*)\n\
      *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*)\n\
      *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*)\n\
      *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*)\n\
      *(.rela.ctors)\n\
      *(.rela.dtors)\n\
      *(.rela.got)\n\
      *(.rela.sharable_data .rela.sharable_data.* .rela.gnu.linkonce.shrd.*)\n\
      *(.rela.sharable_bss .rela.sharable_bss.* .rela.gnu.linkonce.shrb.*)\n\
      *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*)\n"
"    }\n\
  .rel.plt        : { *(.rel.plt) }\n\
  .rela.plt       : { *(.rela.plt) }\n\
  .init           :\n\
  {\n\
    KEEP (*(.init))\n\
  } =0x90909090\n\
  .plt            : { *(.plt) }\n\
  .text           :\n\
  {\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    KEEP (*(.text.*personality*))\n\
    /* .gnu.warning sections are handled specially by elf32.em.  */\n\
    *(.gnu.warning)\n\
  } =0x90909090\n\
  .fini           :\n\
  {\n\
    KEEP (*(.fini))\n\
  } =0x90909090\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr : { *(.eh_frame_hdr) }\n"
"  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = ALIGN (CONSTANT (MAXPAGESIZE)) - ((CONSTANT (MAXPAGESIZE) - .) & (CONSTANT (MAXPAGESIZE) - 1)); . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n\
  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  : { *(.tdata .tdata.* .gnu.linkonce.td.*) }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array     :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array     :\n\
  {\n\
     PROVIDE_HIDDEN (__init_array_start = .);\n\
     KEEP (*(SORT(.init_array.*)))\n\
     KEEP (*(.init_array))\n\
     PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array     :\n"
"  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(.fini_array))\n\
    KEEP (*(SORT(.fini_array.*)))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n\
  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .got            : { *(.got) }\n\
  . = DATA_SEGMENT_RELRO_END (12, .);\n\
  .got.plt        : { *(.got.plt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    KEEP (*(.gnu.linkonce.d.*personality*))\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  /* Sharable data sections.  */\n\
  .sharable_data   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_data_start = .);\n\
    *(.sharable_data .sharable_data.* .gnu.linkonce.shrd.*)\n\
    /* Align here to ensure that the sharable data section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_data_end = .);\n\
  }\n\
  _edata = .; PROVIDE (edata = .);\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we don't\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 32 / 8 : 1);\n\
  }\n\
  /* Sharable bss sections  */\n\
  .sharable_bss   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_bss_start = .);\n\
    *(.dynsharablebss)\n\
    *(.sharable_bss .sharable_bss.* .gnu.linkonce.shrb.*)\n\
    *(SHARABLE_COMMON)\n\
    /* Align here to ensure that the sharable bss section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_bss_end = .);\n\
  }\n\
  . = ALIGN(32 / 8);\n\
  . = ALIGN(32 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment       0 : { *(.comment) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /DISCARD/ : { *(.note.GNU-stack) }\n\
}\n\n"
  ; else return
"/* Default linker script, for normal executables */\n\
OUTPUT_FORMAT(\"elf32-i386\", \"elf32-i386\",\n\
	      \"elf32-i386\")\n\
OUTPUT_ARCH(i386)\n\
ENTRY(_start)\n\
SEARCH_DIR(\"=/usr/local/lib\"); SEARCH_DIR(\"=/lib\"); SEARCH_DIR(\"=/usr/lib\");\n\
SECTIONS\n\
{\n\
  /* Read-only sections, merged into text segment: */\n\
  PROVIDE (__executable_start = 0x08048000); . = 0x08048000 + SIZEOF_HEADERS;\n\
  .interp         : { *(.interp) }\n\
  .hash           : { *(.hash) }\n\
  .gnu.hash       : { *(.gnu.hash) }\n\
  .dynsym         : { *(.dynsym) }\n\
  .dynstr         : { *(.dynstr) }\n\
  .gnu.version    : { *(.gnu.version) }\n\
  .gnu.version_d  : { *(.gnu.version_d) }\n\
  .gnu.version_r  : { *(.gnu.version_r) }\n\
  .rel.init       : { *(.rel.init) }\n\
  .rela.init      : { *(.rela.init) }\n\
  .rel.text       : { *(.rel.text .rel.text.* .rel.gnu.linkonce.t.*) }\n\
  .rela.text      : { *(.rela.text .rela.text.* .rela.gnu.linkonce.t.*) }\n\
  .rel.fini       : { *(.rel.fini) }\n\
  .rela.fini      : { *(.rela.fini) }\n\
  .rel.rodata     : { *(.rel.rodata .rel.rodata.* .rel.gnu.linkonce.r.*) }\n"
"  .rela.rodata    : { *(.rela.rodata .rela.rodata.* .rela.gnu.linkonce.r.*) }\n\
  .rel.data.rel.ro   : { *(.rel.data.rel.ro* .rel.gnu.linkonce.d.rel.ro.*) }\n\
  .rela.data.rel.ro   : { *(.rela.data.rel.ro* .rela.gnu.linkonce.d.rel.ro.*) }\n\
  .rel.data       : { *(.rel.data .rel.data.* .rel.gnu.linkonce.d.*) }\n\
  .rela.data      : { *(.rela.data .rela.data.* .rela.gnu.linkonce.d.*) }\n\
  .rel.tdata	  : { *(.rel.tdata .rel.tdata.* .rel.gnu.linkonce.td.*) }\n\
  .rela.tdata	  : { *(.rela.tdata .rela.tdata.* .rela.gnu.linkonce.td.*) }\n\
  .rel.tbss	  : { *(.rel.tbss .rel.tbss.* .rel.gnu.linkonce.tb.*) }\n\
  .rela.tbss	  : { *(.rela.tbss .rela.tbss.* .rela.gnu.linkonce.tb.*) }\n\
  .rel.ctors      : { *(.rel.ctors) }\n\
  .rela.ctors     : { *(.rela.ctors) }\n\
  .rel.dtors      : { *(.rel.dtors) }\n\
  .rela.dtors     : { *(.rela.dtors) }\n\
  .rel.got        : { *(.rel.got) }\n\
  .rela.got       : { *(.rela.got) }\n\
  .rel.sharable_data	  : { *(.rel.sharable_data .rel.sharable_data.* .rel.gnu.linkonce.shrd.*) }\n\
  .rela.sharable_data	  : { *(.rela.sharable_data .rela.sharable_data.* .rela.gnu.linkonce.shrd.*) }\n\
  .rel.sharable_bss	  : { *(.rel.sharable_bss .rel.sharable_bss.* .rel.gnu.linkonce.shrb.*) }\n\
  .rela.sharable_bss	  : { *(.rela.sharable_bss .rela.sharable_bss.* .rela.gnu.linkonce.shrb.*) }\n\
  .rel.bss        : { *(.rel.bss .rel.bss.* .rel.gnu.linkonce.b.*) }\n\
  .rela.bss       : { *(.rela.bss .rela.bss.* .rela.gnu.linkonce.b.*) }\n\
  .rel.plt        : { *(.rel.plt) }\n\
  .rela.plt       : { *(.rela.plt) }\n\
  .init           :\n\
  {\n"
"    KEEP (*(.init))\n\
  } =0x90909090\n\
  .plt            : { *(.plt) }\n\
  .text           :\n\
  {\n\
    *(.text .stub .text.* .gnu.linkonce.t.*)\n\
    KEEP (*(.text.*personality*))\n\
    /* .gnu.warning sections are handled specially by elf32.em.  */\n\
    *(.gnu.warning)\n\
  } =0x90909090\n\
  .fini           :\n\
  {\n\
    KEEP (*(.fini))\n\
  } =0x90909090\n\
  PROVIDE (__etext = .);\n\
  PROVIDE (_etext = .);\n\
  PROVIDE (etext = .);\n\
  .rodata         : { *(.rodata .rodata.* .gnu.linkonce.r.*) }\n\
  .rodata1        : { *(.rodata1) }\n\
  .eh_frame_hdr : { *(.eh_frame_hdr) }\n\
  .eh_frame       : ONLY_IF_RO { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RO { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Adjust the address for the data segment.  We want to adjust up to\n\
     the same address within the page on the next page up.  */\n\
  . = ALIGN (CONSTANT (MAXPAGESIZE)) - ((CONSTANT (MAXPAGESIZE) - .) & (CONSTANT (MAXPAGESIZE) - 1)); . = DATA_SEGMENT_ALIGN (CONSTANT (MAXPAGESIZE), CONSTANT (COMMONPAGESIZE));\n"
"  /* Exception handling  */\n\
  .eh_frame       : ONLY_IF_RW { KEEP (*(.eh_frame)) }\n\
  .gcc_except_table   : ONLY_IF_RW { *(.gcc_except_table .gcc_except_table.*) }\n\
  /* Thread Local Storage sections  */\n\
  .tdata	  : { *(.tdata .tdata.* .gnu.linkonce.td.*) }\n\
  .tbss		  : { *(.tbss .tbss.* .gnu.linkonce.tb.*) *(.tcommon) }\n\
  .preinit_array     :\n\
  {\n\
    PROVIDE_HIDDEN (__preinit_array_start = .);\n\
    KEEP (*(.preinit_array))\n\
    PROVIDE_HIDDEN (__preinit_array_end = .);\n\
  }\n\
  .init_array     :\n\
  {\n\
     PROVIDE_HIDDEN (__init_array_start = .);\n\
     KEEP (*(SORT(.init_array.*)))\n\
     KEEP (*(.init_array))\n\
     PROVIDE_HIDDEN (__init_array_end = .);\n\
  }\n\
  .fini_array     :\n\
  {\n\
    PROVIDE_HIDDEN (__fini_array_start = .);\n\
    KEEP (*(.fini_array))\n\
    KEEP (*(SORT(.fini_array.*)))\n\
    PROVIDE_HIDDEN (__fini_array_end = .);\n"
"  }\n\
  .ctors          :\n\
  {\n\
    /* gcc uses crtbegin.o to find the start of\n\
       the constructors, so we make sure it is\n\
       first.  Because this is a wildcard, it\n\
       doesn't matter if the user does not\n\
       actually link against crtbegin.o; the\n\
       linker won't look for a file to match a\n\
       wildcard.  The wildcard also means that it\n\
       doesn't matter which directory crtbegin.o\n\
       is in.  */\n\
    KEEP (*crtbegin.o(.ctors))\n\
    KEEP (*crtbegin?.o(.ctors))\n\
    /* We don't want to include the .ctor section from\n\
       the crtend.o file until after the sorted ctors.\n\
       The .ctor section from the crtend file contains the\n\
       end of ctors marker and it must be last */\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .ctors))\n\
    KEEP (*(SORT(.ctors.*)))\n\
    KEEP (*(.ctors))\n\
  }\n\
  .dtors          :\n\
  {\n\
    KEEP (*crtbegin.o(.dtors))\n\
    KEEP (*crtbegin?.o(.dtors))\n\
    KEEP (*(EXCLUDE_FILE (*crtend.o *crtend?.o ) .dtors))\n\
    KEEP (*(SORT(.dtors.*)))\n\
    KEEP (*(.dtors))\n\
  }\n\
  .jcr            : { KEEP (*(.jcr)) }\n\
  .data.rel.ro : { *(.data.rel.ro.local* .gnu.linkonce.d.rel.ro.local.*) *(.data.rel.ro* .gnu.linkonce.d.rel.ro.*) }\n\
  .dynamic        : { *(.dynamic) }\n\
  .got            : { *(.got) }\n\
  . = DATA_SEGMENT_RELRO_END (12, .);\n\
  .got.plt        : { *(.got.plt) }\n\
  .data           :\n\
  {\n\
    *(.data .data.* .gnu.linkonce.d.*)\n\
    KEEP (*(.gnu.linkonce.d.*personality*))\n\
    SORT(CONSTRUCTORS)\n\
  }\n\
  .data1          : { *(.data1) }\n\
  /* Sharable data sections.  */\n\
  .sharable_data   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_data_start = .);\n\
    *(.sharable_data .sharable_data.* .gnu.linkonce.shrd.*)\n\
    /* Align here to ensure that the sharable data section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_data_end = .);\n\
  }\n\
  _edata = .; PROVIDE (edata = .);\n\
  __bss_start = .;\n\
  .bss            :\n\
  {\n\
   *(.dynbss)\n\
   *(.bss .bss.* .gnu.linkonce.b.*)\n\
   *(COMMON)\n\
   /* Align here to ensure that the .bss section occupies space up to\n\
      _end.  Align after .bss to ensure correct alignment even if the\n\
      .bss section disappears because there are no input sections.\n\
      FIXME: Why do we need it? When there is no .bss section, we don't\n\
      pad the .data section.  */\n\
   . = ALIGN(. != 0 ? 32 / 8 : 1);\n\
  }\n\
  /* Sharable bss sections  */\n\
  .sharable_bss   : ALIGN(CONSTANT (MAXPAGESIZE))\n\
  {\n\
    PROVIDE_HIDDEN (__sharable_bss_start = .);\n\
    *(.dynsharablebss)\n\
    *(.sharable_bss .sharable_bss.* .gnu.linkonce.shrb.*)\n\
    *(SHARABLE_COMMON)\n\
    /* Align here to ensure that the sharable bss section ends at the\n\
       page boundary.  */\n\
    . = ALIGN(. != 0 ? CONSTANT (MAXPAGESIZE) : 1);\n\
    PROVIDE_HIDDEN (__sharable_bss_end = .);\n\
  }\n\
  . = ALIGN(32 / 8);\n\
  . = ALIGN(32 / 8);\n\
  _end = .; PROVIDE (end = .);\n\
  . = DATA_SEGMENT_END (.);\n\
  /* Stabs debugging sections.  */\n\
  .stab          0 : { *(.stab) }\n\
  .stabstr       0 : { *(.stabstr) }\n\
  .stab.excl     0 : { *(.stab.excl) }\n\
  .stab.exclstr  0 : { *(.stab.exclstr) }\n\
  .stab.index    0 : { *(.stab.index) }\n\
  .stab.indexstr 0 : { *(.stab.indexstr) }\n\
  .comment       0 : { *(.comment) }\n\
  /* DWARF debug sections.\n\
     Symbols in the DWARF debugging sections are relative to the beginning\n\
     of the section so we begin them at 0.  */\n\
  /* DWARF 1 */\n\
  .debug          0 : { *(.debug) }\n\
  .line           0 : { *(.line) }\n\
  /* GNU DWARF 1 extensions */\n\
  .debug_srcinfo  0 : { *(.debug_srcinfo) }\n\
  .debug_sfnames  0 : { *(.debug_sfnames) }\n\
  /* DWARF 1.1 and DWARF 2 */\n\
  .debug_aranges  0 : { *(.debug_aranges) }\n\
  .debug_pubnames 0 : { *(.debug_pubnames) }\n\
  /* DWARF 2 */\n\
  .debug_info     0 : { *(.debug_info .gnu.linkonce.wi.*) }\n\
  .debug_abbrev   0 : { *(.debug_abbrev) }\n\
  .debug_line     0 : { *(.debug_line) }\n\
  .debug_frame    0 : { *(.debug_frame) }\n\
  .debug_str      0 : { *(.debug_str) }\n\
  .debug_loc      0 : { *(.debug_loc) }\n\
  .debug_macinfo  0 : { *(.debug_macinfo) }\n\
  /* SGI/MIPS DWARF 2 extensions */\n\
  .debug_weaknames 0 : { *(.debug_weaknames) }\n\
  .debug_funcnames 0 : { *(.debug_funcnames) }\n\
  .debug_typenames 0 : { *(.debug_typenames) }\n\
  .debug_varnames  0 : { *(.debug_varnames) }\n\
  /DISCARD/ : { *(.note.GNU-stack) }\n\
}\n\n"
; }

#define OPTION_DISABLE_NEW_DTAGS	(400)
#define OPTION_ENABLE_NEW_DTAGS		(OPTION_DISABLE_NEW_DTAGS + 1)
#define OPTION_GROUP			(OPTION_ENABLE_NEW_DTAGS + 1)
#define OPTION_EH_FRAME_HDR		(OPTION_GROUP + 1)
#define OPTION_EXCLUDE_LIBS		(OPTION_EH_FRAME_HDR + 1)
#define OPTION_HASH_STYLE		(OPTION_EXCLUDE_LIBS + 1)

static void
gldelf_i386_add_options
  (int ns, char **shortopts, int nl, struct option **longopts,
   int nrl ATTRIBUTE_UNUSED, struct option **really_longopts ATTRIBUTE_UNUSED)
{
  static const char xtra_short[] = "z:";
  static const struct option xtra_long[] = {
    {"disable-new-dtags", no_argument, NULL, OPTION_DISABLE_NEW_DTAGS},
    {"enable-new-dtags", no_argument, NULL, OPTION_ENABLE_NEW_DTAGS},
    {"eh-frame-hdr", no_argument, NULL, OPTION_EH_FRAME_HDR},
    {"exclude-libs", required_argument, NULL, OPTION_EXCLUDE_LIBS},
    {"hash-style", required_argument, NULL, OPTION_HASH_STYLE},
    {"Bgroup", no_argument, NULL, OPTION_GROUP},
    {NULL, no_argument, NULL, 0}
  };

  *shortopts = (char *) xrealloc (*shortopts, ns + sizeof (xtra_short));
  memcpy (*shortopts + ns, &xtra_short, sizeof (xtra_short));
  *longopts = (struct option *)
    xrealloc (*longopts, nl * sizeof (struct option) + sizeof (xtra_long));
  memcpy (*longopts + nl, &xtra_long, sizeof (xtra_long));
}

static bfd_boolean
gldelf_i386_handle_option (int optc)
{
  switch (optc)
    {
    default:
      return FALSE;

    case OPTION_DISABLE_NEW_DTAGS:
      link_info.new_dtags = FALSE;
      break;

    case OPTION_ENABLE_NEW_DTAGS:
      link_info.new_dtags = TRUE;
      break;

    case OPTION_EH_FRAME_HDR:
      link_info.eh_frame_hdr = TRUE;
      break;

    case OPTION_GROUP:
      link_info.flags_1 |= (bfd_vma) DF_1_GROUP;
      /* Groups must be self-contained.  */
      link_info.unresolved_syms_in_objects = RM_GENERATE_ERROR;
      link_info.unresolved_syms_in_shared_libs = RM_GENERATE_ERROR;
      break;

    case OPTION_EXCLUDE_LIBS:
      add_excluded_libs (optarg);
      break;

    case OPTION_HASH_STYLE:
      link_info.emit_hash = FALSE;
      link_info.emit_gnu_hash = FALSE;
      if (strcmp (optarg, "sysv") == 0)
	link_info.emit_hash = TRUE;
      else if (strcmp (optarg, "gnu") == 0)
	link_info.emit_gnu_hash = TRUE;
      else if (strcmp (optarg, "both") == 0)
	{
	  link_info.emit_hash = TRUE;
	  link_info.emit_gnu_hash = TRUE;
	}
      else
	einfo (_("%P%F: invalid hash style `%s'\n"), optarg);
      break;

    case 'z':
      if (strcmp (optarg, "initfirst") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_INITFIRST;
      else if (strcmp (optarg, "interpose") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_INTERPOSE;
      else if (strcmp (optarg, "loadfltr") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_LOADFLTR;
      else if (strcmp (optarg, "nodefaultlib") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODEFLIB;
      else if (strcmp (optarg, "nodelete") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODELETE;
      else if (strcmp (optarg, "nodlopen") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NOOPEN;
      else if (strcmp (optarg, "nodump") == 0)
	link_info.flags_1 |= (bfd_vma) DF_1_NODUMP;
      else if (strcmp (optarg, "now") == 0)
	{
	  link_info.flags |= (bfd_vma) DF_BIND_NOW;
	  link_info.flags_1 |= (bfd_vma) DF_1_NOW;
	}
      else if (strcmp (optarg, "lazy") == 0)
	{
	  link_info.flags &= ~(bfd_vma) DF_BIND_NOW;
	  link_info.flags_1 &= ~(bfd_vma) DF_1_NOW;
	}
      else if (strcmp (optarg, "origin") == 0)
	{
	  link_info.flags |= (bfd_vma) DF_ORIGIN;
	  link_info.flags_1 |= (bfd_vma) DF_1_ORIGIN;
	}
      else if (strcmp (optarg, "defs") == 0)
	link_info.unresolved_syms_in_objects = RM_GENERATE_ERROR;
      else if (strcmp (optarg, "muldefs") == 0)
	link_info.allow_multiple_definition = TRUE;
      else if (strcmp (optarg, "combreloc") == 0)
	link_info.combreloc = TRUE;
      else if (strcmp (optarg, "nocombreloc") == 0)
	link_info.combreloc = FALSE;
      else if (strcmp (optarg, "nocopyreloc") == 0)
	link_info.nocopyreloc = TRUE;
      else if (strcmp (optarg, "execstack") == 0)
	{
	  link_info.execstack = TRUE;
	  link_info.noexecstack = FALSE;
	}
      else if (strcmp (optarg, "noexecstack") == 0)
	{
	  link_info.noexecstack = TRUE;
	  link_info.execstack = FALSE;
	}
      else if (strcmp (optarg, "relro") == 0)
	link_info.relro = TRUE;
      else if (strcmp (optarg, "norelro") == 0)
	link_info.relro = FALSE;
      else if (CONST_STRNEQ (optarg, "max-page-size="))
	{
	  char *end;

	  config.maxpagesize = strtoul (optarg + 14, &end, 0);
	  if (*end || (config.maxpagesize & (config.maxpagesize - 1)) != 0)
	    einfo (_("%P%F: invalid maxium page size `%s'\n"),
		   optarg + 14);
	  ASSERT (default_target != NULL);
	  bfd_emul_set_maxpagesize (default_target, config.maxpagesize);
	}
      else if (CONST_STRNEQ (optarg, "common-page-size="))
	{
	  char *end;
	  config.commonpagesize = strtoul (optarg + 17, &end, 0);
	  if (*end
	      || (config.commonpagesize & (config.commonpagesize - 1)) != 0)
	    einfo (_("%P%F: invalid common page size `%s'\n"),
		   optarg + 17);
	  ASSERT (default_target != NULL);
	  bfd_emul_set_commonpagesize (default_target,
				       config.commonpagesize);
	}
      /* What about the other Solaris -z options? FIXME.  */
      break;
    }

  return TRUE;
}


static void
gldelf_i386_list_options (FILE * file)
{
  fprintf (file, _("  -Bgroup\t\tSelects group name lookup rules for DSO\n"));
  fprintf (file, _("  --disable-new-dtags\tDisable new dynamic tags\n"));
  fprintf (file, _("  --enable-new-dtags\tEnable new dynamic tags\n"));
  fprintf (file, _("  --eh-frame-hdr\tCreate .eh_frame_hdr section\n"));
  fprintf (file, _("  --hash-style=STYLE\tSet hash style to sysv, gnu or both\n"));
  fprintf (file, _("  -z combreloc\t\tMerge dynamic relocs into one section and sort\n"));
  fprintf (file, _("  -z defs\t\tReport unresolved symbols in object files.\n"));
  fprintf (file, _("  -z execstack\t\tMark executable as requiring executable stack\n"));
  fprintf (file, _("  -z initfirst\t\tMark DSO to be initialized first at runtime\n"));
  fprintf (file, _("  -z interpose\t\tMark object to interpose all DSOs but executable\n"));
  fprintf (file, _("  -z lazy\t\tMark object lazy runtime binding (default)\n"));
  fprintf (file, _("  -z loadfltr\t\tMark object requiring immediate process\n"));
  fprintf (file, _("  -z muldefs\t\tAllow multiple definitions\n"));
  fprintf (file, _("  -z nocombreloc\tDon't merge dynamic relocs into one section\n"));
  fprintf (file, _("  -z nocopyreloc\tDon't create copy relocs\n"));
  fprintf (file, _("  -z nodefaultlib\tMark object not to use default search paths\n"));
  fprintf (file, _("  -z nodelete\t\tMark DSO non-deletable at runtime\n"));
  fprintf (file, _("  -z nodlopen\t\tMark DSO not available to dlopen\n"));
  fprintf (file, _("  -z nodump\t\tMark DSO not available to dldump\n"));
  fprintf (file, _("  -z noexecstack\tMark executable as not requiring executable stack\n"));
  fprintf (file, _("  -z norelro\t\tDon't create RELRO program header\n"));
  fprintf (file, _("  -z now\t\tMark object non-lazy runtime binding\n"));
  fprintf (file, _("  -z origin\t\tMark object requiring immediate $ORIGIN processing\n\t\t\t  at runtime\n"));
  fprintf (file, _("  -z relro\t\tCreate RELRO program header\n"));
  fprintf (file, _("  -z max-page-size=SIZE\tSet maximum page size to SIZE\n"));
  fprintf (file, _("  -z common-page-size=SIZE\n\t\t\tSet common page size to SIZE\n"));
  fprintf (file, _("  -z KEYWORD\t\tIgnored for Solaris compatibility\n"));
}

struct ld_emulation_xfer_struct ld_elf_i386_emulation =
{
  gldelf_i386_before_parse,
  syslib_default,
  hll_default,
  after_parse_default,
  gldelf_i386_after_open,
  after_allocation_default,
  set_output_arch_default,
  ldemul_default_target,
  gldelf_i386_before_allocation,
  gldelf_i386_get_script,
  "elf_i386",
  "elf32-i386",
  gldelf_i386_finish,
  NULL,
  gldelf_i386_open_dynamic_archive,
  gldelf_i386_place_orphan,
  NULL,
  NULL,
  gldelf_i386_add_options,
  gldelf_i386_handle_option,
  NULL,
  gldelf_i386_list_options,
  gldelf_i386_load_symbols,
  NULL,
  NULL
};
