/*
 *    DVB USB Linux driver for TS2USB Bridge device
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __USB2TS_USB_H__
#define __USB2TS_USB_H__

#include <linux/usb2ts_usb.h>
#include "dvb_usb.h"
#include "dvb_dummy_fe.h"

#define USB2TS_USB_TIMEOUT 1000

struct usb2ts_err_statistics {
	atomic_long_t num_total_ts_pkts_received;
	atomic_long_t num_total_ts_pkt_lost;
	atomic_long_t num_sync_counter_err;
	atomic_long_t num_fifo_overflow;
	atomic_long_t num_parity_err;
	atomic_long_t num_very_first_ts_pkt;
	atomic_long_t num_received_iso_pkt;
	atomic_long_t val_counter_in_isopkt_last_err;
	atomic_long_t val_counter_in_driver_last_err;
	atomic_long_t num_fragmented_ts_pkt;
	unsigned short int val_counter_in_driver; /* for FPGA SYNC counter check; let the SW counter resemble the HW (16 bit) */
	unsigned short int val_counter_in_isopkt;
#ifdef SHOW_ERR_INFO_RAW
	unsigned int err_info_raw[FIRST_512_ERR_INFO];
	int index_err_info_raw;
#endif
	int init;
};

/* function pointer declaration - to be used within dvb_usb_core.c */
extern void (*ptr_usb2ts_process_isopkt_err_info)(u8*, size_t, struct dvb_usb_adapter*);
#endif
