/*
 *    DVB USB Linux driver for TS2USB Bridge device
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _UAPI_USB2TS_DVBUSB_H_
#define _UAPI_USB2TS_DVBUSB_H_
#define TS2USB_FPGA_HAS_FW_INFO_RETRIEVAL_SUPPORT
#include <linux/ioctl.h>

#define USB2TS_GET_ERR_STATISTICS_TS0		_IOR('t', 1, struct usb2ts_error_statistics *)
#define USB2TS_GET_ERR_STATISTICS_TS1		_IOR('t', 2, struct usb2ts_error_statistics *)
#define USB2TS_RESET_ERR_STATISTICS_TS0		_IOW('t', 3, void *)
#define USB2TS_RESET_ERR_STATISTICS_TS1		_IOW('t', 4, void *)
#ifdef TS2USB_FPGA_HAS_FW_INFO_RETRIEVAL_SUPPORT
#define USB2TS_GET_FPGA_RTL_FW_VER			_IOR('t', 5, __s8[45])
#endif

struct usb2ts_error_statistics {
	__u64 num_total_ts_pkts_received;		/* for appln */
	__u64 num_total_ts_pkt_lost;			/* for appln */
	__u64 num_sync_counter_err;				/* for appln */
	__u64 num_fifo_overflow;				/* for appln */
	__u64 num_parity_err;					/* for appln */
	__u64 num_very_first_ts_pkt;			/* for debug */
	__u64 val_counter_in_isopkt_last_err;	/* for debug */
	__u64 val_counter_in_driver_last_err;	/* for debug */
	__u64 num_fragmented_ts_pkt;			/* for debug */
	__u16 val_counter_in_driver;			/* for debug */
};

#endif
