/*
 * Copyright (c) 2013--2016 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 */

#ifndef __INTEL_IPU4_ISYS_FW_TABLES__
#define __INTEL_IPU4_ISYS_FW_TABLES__

#define IPU_FW_UNSUPPORTED_DATA_TYPE	(0)
static const uint32_t
extracted_bits_per_pixel_per_mipi_data_type[N_IPU_FW_ISYS_MIPI_DATA_TYPE] = {
	64, /* [0x00]	IPU_FW_ISYS_MIPI_DATA_TYPE_FRAME_START_CODE */
	64, /* [0x01]	IPU_FW_ISYS_MIPI_DATA_TYPE_FRAME_END_CODE */
	64, /* [0x02]	IPU_FW_ISYS_MIPI_DATA_TYPE_LINE_START_CODE */
	64, /* [0x03]	IPU_FW_ISYS_MIPI_DATA_TYPE_LINE_END_CODE */
	IPU_FW_UNSUPPORTED_DATA_TYPE, /* [0x04] */
	IPU_FW_UNSUPPORTED_DATA_TYPE, /* [0x05]	*/
	IPU_FW_UNSUPPORTED_DATA_TYPE, /* [0x06]	*/
	IPU_FW_UNSUPPORTED_DATA_TYPE, /* [0x07]	*/
	64, /* [0x08]	IPU_FW_ISYS_MIPI_DATA_TYPE_GENERIC_SHORT1 */
	64, /* [0x09]	IPU_FW_ISYS_MIPI_DATA_TYPE_GENERIC_SHORT2 */
	64, /* [0x0A]	IPU_FW_ISYS_MIPI_DATA_TYPE_GENERIC_SHORT3 */
	64, /* [0x0B]	IPU_FW_ISYS_MIPI_DATA_TYPE_GENERIC_SHORT4 */
	64, /* [0x0C]	IPU_FW_ISYS_MIPI_DATA_TYPE_GENERIC_SHORT5 */
	64, /* [0x0D]	IPU_FW_ISYS_MIPI_DATA_TYPE_GENERIC_SHORT6 */
	64, /* [0x0E]	IPU_FW_ISYS_MIPI_DATA_TYPE_GENERIC_SHORT7 */
	64, /* [0x0F]	IPU_FW_ISYS_MIPI_DATA_TYPE_GENERIC_SHORT8 */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x10] */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x11] */
	8, /* [0x12]	IPU_FW_ISYS_MIPI_DATA_TYPE_EMBEDDED */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x13] */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x14] */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x15] */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x16] */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x17] */
	12, /* [0x18]	IPU_FW_ISYS_MIPI_DATA_TYPE_YUV420_8 */
	15, /* [0x19]	IPU_FW_ISYS_MIPI_DATA_TYPE_YUV420_10 */
	12, /* [0x1A]	IPU_FW_ISYS_MIPI_DATA_TYPE_YUV420_8_LEGACY */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x1B] */
	12, /* [0x1C]	IPU_FW_ISYS_MIPI_DATA_TYPE_YUV420_8_SHIFT */
	15, /* [0x1D]	IPU_FW_ISYS_MIPI_DATA_TYPE_YUV420_10_SHIFT */
	16, /* [0x1E]	IPU_FW_ISYS_MIPI_DATA_TYPE_YUV422_8 */
	20, /* [0x1F]	IPU_FW_ISYS_MIPI_DATA_TYPE_YUV422_10 */
	16, /* [0x20]	IPU_FW_ISYS_MIPI_DATA_TYPE_RGB_444 */
	16, /* [0x21]	IPU_FW_ISYS_MIPI_DATA_TYPE_RGB_555 */
	16, /* [0x22]	IPU_FW_ISYS_MIPI_DATA_TYPE_RGB_565 */
	18, /* [0x23]	IPU_FW_ISYS_MIPI_DATA_TYPE_RGB_666 */
	24, /* [0x24]	IPU_FW_ISYS_MIPI_DATA_TYPE_RGB_888 */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x25] */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x26] */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x27] */
	6, /* [0x28]	IPU_FW_ISYS_MIPI_DATA_TYPE_RAW_6 */
	7, /* [0x29]	IPU_FW_ISYS_MIPI_DATA_TYPE_RAW_7 */
	8, /* [0x2A]	IPU_FW_ISYS_MIPI_DATA_TYPE_RAW_8 */
	10, /* [0x2B]	IPU_FW_ISYS_MIPI_DATA_TYPE_RAW_10 */
	12, /* [0x2C]	IPU_FW_ISYS_MIPI_DATA_TYPE_RAW_12 */
	14, /* [0x2D]	IPU_FW_ISYS_MIPI_DATA_TYPE_RAW_14 */
	16, /* [0x2E]	IPU_FW_ISYS_MIPI_DATA_TYPE_RAW_16 */
	8, /* [0x2F]	IPU_FW_ISYS_MIPI_DATA_TYPE_BINARY_8 */
	8, /* [0x30]	IPU_FW_ISYS_MIPI_DATA_TYPE_USER_DEF1 */
	8, /* [0x31]	IPU_FW_ISYS_MIPI_DATA_TYPE_USER_DEF2 */
	8, /* [0x32]	IPU_FW_ISYS_MIPI_DATA_TYPE_USER_DEF3 */
	8, /* [0x33]	IPU_FW_ISYS_MIPI_DATA_TYPE_USER_DEF4 */
	8, /* [0x34]	IPU_FW_ISYS_MIPI_DATA_TYPE_USER_DEF5 */
	8, /* [0x35]	IPU_FW_ISYS_MIPI_DATA_TYPE_USER_DEF6 */
	8, /* [0x36]	IPU_FW_ISYS_MIPI_DATA_TYPE_USER_DEF7 */
	8, /* [0x37]	IPU_FW_ISYS_MIPI_DATA_TYPE_USER_DEF8 */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x38] */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x39] */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x3A] */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x3B] */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x3C] */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x3D] */
	IPU_FW_UNSUPPORTED_DATA_TYPE,	/* [0x3E] */
	IPU_FW_UNSUPPORTED_DATA_TYPE	/* [0x3F] */
};

#endif

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/graphics/branches/denso-jp-hv-ivi/hardware/capture/intel-ipu4/driver/intel-ipu4-drv/intel-ipu4-isys-fw-tables.h $ $Rev: 836043 $")
#endif
