/*
 * Copyright (c) 2016 Intel Corporation.
 * Some modifications (__QNXNTO__) Copyright (c) 2017 QNX Software Systems.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
#ifndef INTEL_IPU4_PSYS_ABI_DEFS_H
#define INTEL_IPU4_PSYS_ABI_DEFS_H

/* ia_css_psys_device.c */
#define IA_CSS_PSYS_CMD_QUEUE_SIZE 0x20
#define IA_CSS_PSYS_EVENT_QUEUE_SIZE 0x40

/* ia_css_psys_transport.h */
#define IA_CSS_PSYS_CMD_BITS 64
#define IA_CSS_PSYS_EVENT_BITS 128

enum {
	VIED_NCI_GMEM_TYPE_ID = 0,
	VIED_NCI_DMEM_TYPE_ID,
	VIED_NCI_VMEM_TYPE_ID,
	VIED_NCI_BAMEM_TYPE_ID,
	VIED_NCI_PMEM_TYPE_ID,
	VIED_NCI_N_MEM_TYPE_ID
};

enum {
	VIED_NCI_DEV_CHN_DMA_EXT0_ID = 0,
	VIED_NCI_DEV_CHN_GDC_ID,
	VIED_NCI_DEV_CHN_DMA_EXT1_READ_ID,
	VIED_NCI_DEV_CHN_DMA_EXT1_WRITE_ID,
	VIED_NCI_DEV_CHN_DMA_INTERNAL_ID,
	VIED_NCI_DEV_CHN_DMA_IPFD_ID,
	VIED_NCI_DEV_CHN_DMA_ISA_ID,
	VIED_NCI_DEV_CHN_DMA_FW_ID,
	VIED_NCI_N_DEV_CHN_ID
};

enum {
	VIED_NCI_SP_CTRL_TYPE_ID = 0,
	VIED_NCI_SP_SERVER_TYPE_ID,
	VIED_NCI_VP_TYPE_ID,
	VIED_NCI_ACC_PSA_TYPE_ID,
	VIED_NCI_ACC_ISA_TYPE_ID,
	VIED_NCI_ACC_OSA_TYPE_ID,
	VIED_NCI_GDC_TYPE_ID,
	VIED_NCI_N_CELL_TYPE_ID
};

#ifdef __QNXNTO__
#define CONFIG_VIDEO_INTEL_IPU4 1
#endif
#if IS_ENABLED(CONFIG_VIDEO_INTEL_IPU4)


enum {
	VIED_NCI_SP0_ID = 0,
	VIED_NCI_SP1_ID,
	VIED_NCI_SP2_ID,
	VIED_NCI_VP0_ID,
	VIED_NCI_VP1_ID,
	VIED_NCI_VP2_ID,
	VIED_NCI_VP3_ID,
	VIED_NCI_ACC0_ID,
	VIED_NCI_ACC1_ID,
	VIED_NCI_ACC2_ID,
	VIED_NCI_ACC3_ID,
	VIED_NCI_ACC4_ID,
	VIED_NCI_ACC5_ID,
	VIED_NCI_ACC6_ID,
	VIED_NCI_ACC7_ID,
	VIED_NCI_GDC0_ID,
	VIED_NCI_GDC1_ID,
	VIED_NCI_N_CELL_ID
};

#define VIED_NCI_DEV_CHN_DMA_EXT0_MAX_SIZE		(30)
#define VIED_NCI_DEV_CHN_GDC_MAX_SIZE			(4)
#define VIED_NCI_DEV_CHN_DMA_EXT1_READ_MAX_SIZE		(30)
#define VIED_NCI_DEV_CHN_DMA_EXT1_WRITE_MAX_SIZE	(20)
#define VIED_NCI_DEV_CHN_DMA_INTERNAL_MAX_SIZE		(2)
#define VIED_NCI_DEV_CHN_DMA_IPFD_MAX_SIZE		(5)
#define VIED_NCI_DEV_CHN_DMA_ISA_MAX_SIZE		(2)
#define VIED_NCI_DEV_CHN_DMA_FW_MAX_SIZE		(1)

#elif IS_ENABLED(CONFIG_VIDEO_INTEL_IPU5)

enum {
	VIED_NCI_SP0_ID = 0,
	VIED_NCI_SP1_ID,
	VIED_NCI_SP2_ID,
	VIED_NCI_VP0_ID,
	VIED_NCI_ACC0_ID,
	VIED_NCI_ACC1_ID,
	VIED_NCI_ACC2_ID,
	VIED_NCI_ACC3_ID,
	VIED_NCI_ACC4_ID,
	VIED_NCI_ACC5_ID,
	VIED_NCI_ACC6_ID,
	VIED_NCI_ACC7_ID,
	VIED_NCI_ACC8_ID,
	VIED_NCI_ACC9_ID,
	VIED_NCI_ACC10_ID,
	VIED_NCI_ACC11_ID,
	VIED_NCI_GDC0_ID,
	VIED_NCI_N_CELL_ID
};

#define VIED_NCI_DEV_CHN_DMA_EXT0_MAX_SIZE		(30)
#define VIED_NCI_DEV_CHN_GDC_MAX_SIZE			(4)
#define VIED_NCI_DEV_CHN_DMA_EXT1_READ_MAX_SIZE		(30)
#define VIED_NCI_DEV_CHN_DMA_EXT1_WRITE_MAX_SIZE	(20)
#define VIED_NCI_DEV_CHN_DMA_INTERNAL_MAX_SIZE		(4)
#define VIED_NCI_DEV_CHN_DMA_IPFD_MAX_SIZE		(5)
#define VIED_NCI_DEV_CHN_DMA_ISA_MAX_SIZE		(2)
#define VIED_NCI_DEV_CHN_DMA_FW_MAX_SIZE		(1)

#endif

#define VIED_NCI_N_DATA_MEM_TYPE_ID	(VIED_NCI_N_MEM_TYPE_ID - 1)

/* ia_css_psys_transport.h */
enum {
	IA_CSS_PSYS_EVENT_TYPE_SUCCESS = 0,
	IA_CSS_PSYS_EVENT_TYPE_UNKNOWN_ERROR = 1,
	IA_CSS_PSYS_EVENT_TYPE_RET_REM_OBJ_NOT_FOUND = 2,
	IA_CSS_PSYS_EVENT_TYPE_RET_REM_OBJ_TOO_BIG = 3,
	IA_CSS_PSYS_EVENT_TYPE_RET_REM_OBJ_DDR_TRANS_ERR = 4,
	IA_CSS_PSYS_EVENT_TYPE_RET_REM_OBJ_NULL_PKG_DIR_ADDR = 5,
	IA_CSS_PSYS_EVENT_TYPE_PROC_GRP_LOAD_FRAME_ERR = 6,
	IA_CSS_PSYS_EVENT_TYPE_PROC_GRP_LOAD_FRAGMENT_ERR = 7,
	IA_CSS_PSYS_EVENT_TYPE_PROC_GRP_PROCESS_COUNT_ZERO = 8,
	IA_CSS_PSYS_EVENT_TYPE_PROC_GRP_PROCESS_INIT_ERR = 9,
	IA_CSS_PSYS_EVENT_TYPE_PROC_GRP_ABORT = 10,
	IA_CSS_PSYS_EVENT_TYPE_PROC_GRP_NULL = 11,
	IA_CSS_PSYS_EVENT_TYPE_PROC_GRP_VALIDATION_ERR = 12
};

enum {
	IA_CSS_PSYS_CMD_QUEUE_COMMAND_ID,
	IA_CSS_PSYS_CMD_QUEUE_DEVICE_ID,
	IA_CSS_N_PSYS_CMD_QUEUE_ID
};

enum {
	IA_CSS_PSYS_EVENT_QUEUE_MAIN_ID,
	IA_CSS_N_PSYS_EVENT_QUEUE_ID
};

enum {
	IA_CSS_PROCESS_GROUP_ERROR = 0,
	IA_CSS_PROCESS_GROUP_CREATED,
	IA_CSS_PROCESS_GROUP_READY,
	IA_CSS_PROCESS_GROUP_BLOCKED,
	IA_CSS_PROCESS_GROUP_STARTED,
	IA_CSS_PROCESS_GROUP_RUNNING,
	IA_CSS_PROCESS_GROUP_STALLED,
	IA_CSS_PROCESS_GROUP_STOPPED,
	IA_CSS_N_PROCESS_GROUP_STATES
};

enum {
	IA_CSS_CONNECTION_MEMORY = 0,
	IA_CSS_CONNECTION_MEMORY_STREAM,
	IA_CSS_CONNECTION_STREAM,
	IA_CSS_N_CONNECTION_TYPES
};

enum {
	IA_CSS_BUFFER_NULL = 0,
	IA_CSS_BUFFER_UNDEFINED,
	IA_CSS_BUFFER_EMPTY,
	IA_CSS_BUFFER_NONEMPTY,
	IA_CSS_BUFFER_FULL,
	IA_CSS_N_BUFFER_STATES
};

enum {
	IA_CSS_TERMINAL_TYPE_DATA_IN = 0,
	IA_CSS_TERMINAL_TYPE_DATA_OUT,
	IA_CSS_TERMINAL_TYPE_PARAM_STREAM,
	IA_CSS_TERMINAL_TYPE_PARAM_CACHED_IN,
	IA_CSS_TERMINAL_TYPE_PARAM_CACHED_OUT,
	IA_CSS_TERMINAL_TYPE_PARAM_SPATIAL_IN,
	IA_CSS_TERMINAL_TYPE_PARAM_SPATIAL_OUT,
	IA_CSS_TERMINAL_TYPE_PARAM_SLICED_IN,
	IA_CSS_TERMINAL_TYPE_PARAM_SLICED_OUT,
	IA_CSS_TERMINAL_TYPE_STATE_IN,
	IA_CSS_TERMINAL_TYPE_STATE_OUT,
	IA_CSS_TERMINAL_TYPE_PROGRAM,
	IA_CSS_N_TERMINAL_TYPES
};

enum {
	IA_CSS_COL_DIMENSION = 0,
	IA_CSS_ROW_DIMENSION = 1,
	IA_CSS_N_DATA_DIMENSION = 2
};

enum {
	IA_CSS_PROCESS_GROUP_CMD_NOP = 0,
	IA_CSS_PROCESS_GROUP_CMD_SUBMIT,
	IA_CSS_PROCESS_GROUP_CMD_ATTACH,
	IA_CSS_PROCESS_GROUP_CMD_DETACH,
	IA_CSS_PROCESS_GROUP_CMD_START,
	IA_CSS_PROCESS_GROUP_CMD_DISOWN,
	IA_CSS_PROCESS_GROUP_CMD_RUN,
	IA_CSS_PROCESS_GROUP_CMD_STOP,
	IA_CSS_PROCESS_GROUP_CMD_SUSPEND,
	IA_CSS_PROCESS_GROUP_CMD_RESUME,
	IA_CSS_PROCESS_GROUP_CMD_ABORT,
	IA_CSS_PROCESS_GROUP_CMD_RESET,
	IA_CSS_N_PROCESS_GROUP_CMDS
};

#endif /* INTEL_IPU4_PSYS_ABI_DEFS_H */

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/graphics/branches/denso-jp-hv-ivi/hardware/capture/intel-ipu4/driver/intel-ipu4-drv/intel-ipu4-psys-abi-defs.h $ $Rev: 836043 $")
#endif
